/*********************************************************************
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ===================================================================
 * Revision History ::
 * YYYY.MM.DD   Change ID       Developer
 *              Description
 * -------------------------------------------------------------------
 * 2002.04.25                   Vlad Skarzhevskyy
 *              Initial implementation.
 *
 * ===================================================================
 *
 ********************************************************************/

#include "pure-sfv.h"

static const char *GETOPT_OPTIONS =
     "tcyP"
     "s:f:dD:E:I:qv"
#ifndef __unix
     "W"
#endif
     "wRp:N:M"
     "l:ixXuU:"
     "GgBbMm"
     "#Hh?";

void usage(char *argv0)
{
    printf(
"pure-sfv v%s   http://pure-sfv.sourceforge.net\n"
"Usage: %s [mode] [options] [-s sfv-filename] [-f filename(s)] \n", PURE_SFV_VERSION, argv0);

    printf(
"    Mode             Meaning\n"
"    ---------        -------\n"
"    -t               Test SFV file(s), DEFAULT\n"
"    -c               Create SFV file\n"
"    -y               Count files\n"
/* "    -P               Run as uploadscript for Pure-FTPd (test mode)\n" */
"    Options          Meaning\n"
"    ---------        -------\n"
"    -s sfv-filename  .sfv file to verify or create\n"
"    -f filename      File to verify or add to sfv (*m)\n"
"    -d               Change to sfv or file location directory for processing\n"
"    -D path          Change to directory for processing\n"
"    -I mask          Include files, Wildcard allowed (*m)\n"
"    -E mask          Exclude files, Wildcard allowed (*m) order important\n"
"    -q               Quiet, only prints error messages\n"
"    -v               Verbose, by default this option is on\n"
#ifndef __unix
"    -W               For windows users, pause before exit\n"
#endif
"Create mode specific options\n"
/*"    -r               Recurse subdirectories and add file\n" */
"    -w               Off Win-SFV emulation to create SFV\n"
"    -R               Recurse all dirs from curent and create SFV if one dos not exists\n"
"                     if -s is not specified sfv file name would be based on dir name\n"
"    -RR              Previous, but create SFV even when one exists\n"
"    -p   percent     Create PAR files for each SFV, Where recovery ratio in %%\n"
"    -N   char        Placeholder for auto created name, Deafilt 'X'\n"
"Test mode specific options\n"
"    -R               Recurse all dirs from curent and test SFV if exists\n"
"    -l type          List files, type: i g b m\n"
"    -i               Ignore case on filenames\n"
"    -x               Ignore Directory names in SFV file\n"
"    -X               Ignore SFV file if no files from it found\n"
/*
"    -u               Do not tests alredy tested file, update tested files database,\n"
"                     only test if file has been changed\n"
"    -U db_filename   Enable -u and specify tested files database,\n"
"                     Defaults to sfv-filename_pure-sfv.tmp\n"
*/
/*
"Pure-FTPd support options\n"
"    Flag Files to create, %%S %%F %%D %%B %%M would be replaced\n"
"    -G flag_file     If all tested are OK.\n"
"    -g flag_file     For each tested OK files.\n"
"    -B flag_file     If some files are bad.\n"
"    -g flag_file     For each bad file.\n"
"    -M flag_file     If some files are missing.\n"
"    -m flag_file     For each missing file.\n"
"          Example: pure-sfv -m %%F_is_missing -G %%S_ALL_FILES_OK.txt -M _list_of_missing_files.txt\n"
"\n" */
"(*m) this options could be included multiple times\n"
);


}

void more_help(char *argv0)
{
}

pure_sfv_params*  g_prams;

int main(int argc, char *argv[])
{
    int              opt, i;
    char*            c;
     char            ext[MAX_FILE_EXTENSION + 1];
    pure_sfv_params  params;
    g_prams = &params;

    /* return par_main(argc, argv); */

    initParams(&params);

    while ((opt = getopt(argc, argv, GETOPT_OPTIONS)) !=  EOF)
    {
        DBUG_PRINT("getopt_opt", ("%c", opt));
        if (optarg != NULL) {
            DBUG_PRINT("getopt_optarg", ("%s", optarg));
        }
        switch(opt)
        {
            case 't': if (params.mode == MODE_DEFAULT) {
                          params.mode = MODE_TEST;
                      } else if (params.mode == MODE_CREATE) {
                          params.mode = MODE_TEST_CREATE;
                      } else {
                          fprintf(stderr, "Option %c overwite previous mode command...\n", opt);
                          exit(1);
                      }
                      break;
            case 'c': if (params.mode == MODE_DEFAULT) {
                          params.mode = MODE_CREATE;
                      } else if (params.mode == MODE_TEST) {
                          params.mode = MODE_TEST_CREATE;
                      } else {
                          fprintf(stderr, "Option %c overwite previous mode command...\n", opt);
                          exit(1);
                      }
                      break;
            case 'y': if (params.mode == MODE_DEFAULT) {
                          params.mode = MODE_COUNT;
                      } else {
                          fprintf(stderr, "Option %c overwite previous mode command...\n", opt);
                          exit(1);
                      }
                      break;
            case 'P': if (params.mode == MODE_DEFAULT) {
                          params.mode = MODE_FTPD;
                      } else {
                          fprintf(stderr, "Option %c overwite previous mode command...\n", opt);
                          exit(1);
                      }
                      break;
            case 'p': params.par_recovery_ratio = atoi(optarg);
                      params.par_create = 1;
                      break;
            case 'M': params.create_m3u = 1;
                      break;
            case 's': ifNeedDirectory(&params, optarg);
                      c = stripExtraPath(&params, optarg);
                      if (!hasWildcard(c)) {
                          add_string_array(&params.sfv_files, c, PARAM_NAME);
                      } else {
                          add_string_array(&params.sfv_files, c, PARAM_MASK_INCLUDE);
                      }
                      break;
            case 'f': ifNeedDirectory(&params, optarg);
                      c = stripExtraPath(&params, optarg);
                      if (!hasWildcard(c)) {
                          add_string_array(&params.files, c, PARAM_NAME);
                      } else {
                          add_string_array(&params.files, c, PARAM_MASK_INCLUDE);
                      }
                      break;
            case 'd': params.cd_sfv_file_location = 1;
                      break;
            case 'D': strncpy(params.sfv_dir, optarg, MAX_STRING_LEN);
                      break;
            case 'I': add_string_array(&params.files, optarg, PARAM_MASK_INCLUDE);
                      break;
            case 'E': add_string_array(&params.files, optarg, PARAM_MASK_EXCLUDE);
                      break;
            case 'N': params.name_place_holder = optarg[0];
                      break;
            case 'l': params.list_files = optarg[0];
                      params.quiet = 1;
                      break;
            case 'q': params.quiet = 1;
                      break;
            case 'v': params.quiet = 0;
                      break;
#ifndef __unix
            case 'W': params.windows_pause = 1;
                      break;
#endif
            case 'r': params.create_recurse_subdirectories = 1;
                      break;
            case 'w': params.win_sfv = 0;
                      break;
            case 'R': if (params.recurse_subdirectories) {
                          params.force_create =1;
                      }
                      params.recurse_subdirectories = 1;
                      break;
            case 'i': params.ignore_case = 1;
                      break;
            case 'x': params.ignore_dir_name = 1;
                      break;
            case 'X': params.ignore_nofiles_sfv = 1;
                      break;
            case '#': _debug_on_ = 1;
                      break;
            case '?':
            case 'h':
                      usage(argv[0]);
                      exit(1);
            case 'H':
                      more_help(argv[0]);
                      exit(1);
            case '\0':
                      fprintf(stderr, "Bad Option given ...\n");
                      exit(1);
            default:
                      fprintf(stderr, "Option %c not implemented ...\n", opt);
                      exit(1);
        }
    }
    if (optind < argc)
    {
        /* fprintf(stderr, "Error: This option(s) ["); */
        for (i = optind; i < argc; i++) {
            /* fprintf(stderr, "%s ", argv[i]); */
            ifNeedDirectory(&params, argv[i]);
            getFileExtension(argv[i], ext);
            if ( (params.sfv_files.names_cnt == 0) && (isSfvFile(ext)) ) {
                 c = stripExtraPath(&params, argv[i]);
                 if (!hasWildcard(c)) {
                      add_string_array(&params.sfv_files, c, PARAM_NAME);
                 } else {
                      add_string_array(&params.sfv_files, c, PARAM_MASK_INCLUDE);
                 }
            } else {
                 c = stripExtraPath(&params, argv[i]);
                 if (!hasWildcard(c)) {
                      add_string_array(&params.files, c, PARAM_NAME);
                 } else {
                          add_string_array(&params.files, c, PARAM_MASK_INCLUDE);
                 }
            }
        }

        /*fprintf(stderr, "] has not been parsed properly!\n");
        exit(1); */
    }
    return sfvProcess(&params);
}

/* EOF */

