// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateApiKey = "CreateApiKey"

// CreateApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApiKey for more information on using the CreateApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApiKeyRequest method.
//    req, resp := client.CreateApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateApiKeyRequest(input *CreateApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opCreateApiKey,
		HTTPMethod: "POST",
		HTTPPath:   "/apikeys",
	}

	if input == nil {
		input = &CreateApiKeyInput{}
	}

	output = &ApiKey{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApiKey API operation for Amazon API Gateway.
//
// Create an ApiKey resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-api-key.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateApiKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateApiKey(input *CreateApiKeyInput) (*ApiKey, error) {
	req, out := c.CreateApiKeyRequest(input)
	return out, req.Send()
}

// CreateApiKeyWithContext is the same as CreateApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateApiKeyWithContext(ctx aws.Context, input *CreateApiKeyInput, opts ...request.Option) (*ApiKey, error) {
	req, out := c.CreateApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAuthorizer = "CreateAuthorizer"

// CreateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the CreateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAuthorizer for more information on using the CreateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAuthorizerRequest method.
//    req, resp := client.CreateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateAuthorizerRequest(input *CreateAuthorizerInput) (req *request.Request, output *Authorizer) {
	op := &request.Operation{
		Name:       opCreateAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/authorizers",
	}

	if input == nil {
		input = &CreateAuthorizerInput{}
	}

	output = &Authorizer{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAuthorizer API operation for Amazon API Gateway.
//
// Adds a new Authorizer resource to an existing RestApi resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/create-authorizer.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateAuthorizer(input *CreateAuthorizerInput) (*Authorizer, error) {
	req, out := c.CreateAuthorizerRequest(input)
	return out, req.Send()
}

// CreateAuthorizerWithContext is the same as CreateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateAuthorizerWithContext(ctx aws.Context, input *CreateAuthorizerInput, opts ...request.Option) (*Authorizer, error) {
	req, out := c.CreateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBasePathMapping = "CreateBasePathMapping"

// CreateBasePathMappingRequest generates a "aws/request.Request" representing the
// client's request for the CreateBasePathMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBasePathMapping for more information on using the CreateBasePathMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBasePathMappingRequest method.
//    req, resp := client.CreateBasePathMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateBasePathMappingRequest(input *CreateBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opCreateBasePathMapping,
		HTTPMethod: "POST",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings",
	}

	if input == nil {
		input = &CreateBasePathMappingInput{}
	}

	output = &BasePathMapping{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBasePathMapping API operation for Amazon API Gateway.
//
// Creates a new BasePathMapping resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateBasePathMapping for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateBasePathMapping(input *CreateBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.CreateBasePathMappingRequest(input)
	return out, req.Send()
}

// CreateBasePathMappingWithContext is the same as CreateBasePathMapping with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBasePathMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateBasePathMappingWithContext(ctx aws.Context, input *CreateBasePathMappingInput, opts ...request.Option) (*BasePathMapping, error) {
	req, out := c.CreateBasePathMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDeployment = "CreateDeployment"

// CreateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the CreateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDeployment for more information on using the CreateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDeploymentRequest method.
//    req, resp := client.CreateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateDeploymentRequest(input *CreateDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opCreateDeployment,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/deployments",
	}

	if input == nil {
		input = &CreateDeploymentInput{}
	}

	output = &Deployment{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDeployment API operation for Amazon API Gateway.
//
// Creates a Deployment resource, which makes a specified RestApi callable over
// the internet.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * ServiceUnavailableException
//   The requested service is not available. For details see the accompanying
//   error message. Retry after the specified time period.
//
func (c *APIGateway) CreateDeployment(input *CreateDeploymentInput) (*Deployment, error) {
	req, out := c.CreateDeploymentRequest(input)
	return out, req.Send()
}

// CreateDeploymentWithContext is the same as CreateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateDeploymentWithContext(ctx aws.Context, input *CreateDeploymentInput, opts ...request.Option) (*Deployment, error) {
	req, out := c.CreateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocumentationPart = "CreateDocumentationPart"

// CreateDocumentationPartRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocumentationPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocumentationPart for more information on using the CreateDocumentationPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDocumentationPartRequest method.
//    req, resp := client.CreateDocumentationPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateDocumentationPartRequest(input *CreateDocumentationPartInput) (req *request.Request, output *DocumentationPart) {
	op := &request.Operation{
		Name:       opCreateDocumentationPart,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts",
	}

	if input == nil {
		input = &CreateDocumentationPartInput{}
	}

	output = &DocumentationPart{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocumentationPart API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateDocumentationPart for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateDocumentationPart(input *CreateDocumentationPartInput) (*DocumentationPart, error) {
	req, out := c.CreateDocumentationPartRequest(input)
	return out, req.Send()
}

// CreateDocumentationPartWithContext is the same as CreateDocumentationPart with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocumentationPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateDocumentationPartWithContext(ctx aws.Context, input *CreateDocumentationPartInput, opts ...request.Option) (*DocumentationPart, error) {
	req, out := c.CreateDocumentationPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDocumentationVersion = "CreateDocumentationVersion"

// CreateDocumentationVersionRequest generates a "aws/request.Request" representing the
// client's request for the CreateDocumentationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDocumentationVersion for more information on using the CreateDocumentationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDocumentationVersionRequest method.
//    req, resp := client.CreateDocumentationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateDocumentationVersionRequest(input *CreateDocumentationVersionInput) (req *request.Request, output *DocumentationVersion) {
	op := &request.Operation{
		Name:       opCreateDocumentationVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions",
	}

	if input == nil {
		input = &CreateDocumentationVersionInput{}
	}

	output = &DocumentationVersion{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDocumentationVersion API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateDocumentationVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateDocumentationVersion(input *CreateDocumentationVersionInput) (*DocumentationVersion, error) {
	req, out := c.CreateDocumentationVersionRequest(input)
	return out, req.Send()
}

// CreateDocumentationVersionWithContext is the same as CreateDocumentationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDocumentationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateDocumentationVersionWithContext(ctx aws.Context, input *CreateDocumentationVersionInput, opts ...request.Option) (*DocumentationVersion, error) {
	req, out := c.CreateDocumentationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateDomainName = "CreateDomainName"

// CreateDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the CreateDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDomainName for more information on using the CreateDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDomainNameRequest method.
//    req, resp := client.CreateDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateDomainNameRequest(input *CreateDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opCreateDomainName,
		HTTPMethod: "POST",
		HTTPPath:   "/domainnames",
	}

	if input == nil {
		input = &CreateDomainNameInput{}
	}

	output = &DomainName{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDomainName API operation for Amazon API Gateway.
//
// Creates a new domain name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateDomainName for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateDomainName(input *CreateDomainNameInput) (*DomainName, error) {
	req, out := c.CreateDomainNameRequest(input)
	return out, req.Send()
}

// CreateDomainNameWithContext is the same as CreateDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateDomainNameWithContext(ctx aws.Context, input *CreateDomainNameInput, opts ...request.Option) (*DomainName, error) {
	req, out := c.CreateDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateModel = "CreateModel"

// CreateModelRequest generates a "aws/request.Request" representing the
// client's request for the CreateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateModel for more information on using the CreateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateModelRequest method.
//    req, resp := client.CreateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateModelRequest(input *CreateModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opCreateModel,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/models",
	}

	if input == nil {
		input = &CreateModelInput{}
	}

	output = &Model{}
	req = c.newRequest(op, input, output)
	return
}

// CreateModel API operation for Amazon API Gateway.
//
// Adds a new Model resource to an existing RestApi resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateModel(input *CreateModelInput) (*Model, error) {
	req, out := c.CreateModelRequest(input)
	return out, req.Send()
}

// CreateModelWithContext is the same as CreateModel with the addition of
// the ability to pass a context and additional request options.
//
// See CreateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateModelWithContext(ctx aws.Context, input *CreateModelInput, opts ...request.Option) (*Model, error) {
	req, out := c.CreateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRequestValidator = "CreateRequestValidator"

// CreateRequestValidatorRequest generates a "aws/request.Request" representing the
// client's request for the CreateRequestValidator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRequestValidator for more information on using the CreateRequestValidator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRequestValidatorRequest method.
//    req, resp := client.CreateRequestValidatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateRequestValidatorRequest(input *CreateRequestValidatorInput) (req *request.Request, output *UpdateRequestValidatorOutput) {
	op := &request.Operation{
		Name:       opCreateRequestValidator,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators",
	}

	if input == nil {
		input = &CreateRequestValidatorInput{}
	}

	output = &UpdateRequestValidatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRequestValidator API operation for Amazon API Gateway.
//
// Creates a ReqeustValidator of a given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateRequestValidator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateRequestValidator(input *CreateRequestValidatorInput) (*UpdateRequestValidatorOutput, error) {
	req, out := c.CreateRequestValidatorRequest(input)
	return out, req.Send()
}

// CreateRequestValidatorWithContext is the same as CreateRequestValidator with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRequestValidator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateRequestValidatorWithContext(ctx aws.Context, input *CreateRequestValidatorInput, opts ...request.Option) (*UpdateRequestValidatorOutput, error) {
	req, out := c.CreateRequestValidatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResource = "CreateResource"

// CreateResourceRequest generates a "aws/request.Request" representing the
// client's request for the CreateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateResource for more information on using the CreateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateResourceRequest method.
//    req, resp := client.CreateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateResourceRequest(input *CreateResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opCreateResource,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/resources/{parent_id}",
	}

	if input == nil {
		input = &CreateResourceInput{}
	}

	output = &Resource{}
	req = c.newRequest(op, input, output)
	return
}

// CreateResource API operation for Amazon API Gateway.
//
// Creates a Resource resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateResource for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateResource(input *CreateResourceInput) (*Resource, error) {
	req, out := c.CreateResourceRequest(input)
	return out, req.Send()
}

// CreateResourceWithContext is the same as CreateResource with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateResourceWithContext(ctx aws.Context, input *CreateResourceInput, opts ...request.Option) (*Resource, error) {
	req, out := c.CreateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRestApi = "CreateRestApi"

// CreateRestApiRequest generates a "aws/request.Request" representing the
// client's request for the CreateRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRestApi for more information on using the CreateRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRestApiRequest method.
//    req, resp := client.CreateRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateRestApiRequest(input *CreateRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opCreateRestApi,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis",
	}

	if input == nil {
		input = &CreateRestApiInput{}
	}

	output = &RestApi{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRestApi API operation for Amazon API Gateway.
//
// Creates a new RestApi resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateRestApi(input *CreateRestApiInput) (*RestApi, error) {
	req, out := c.CreateRestApiRequest(input)
	return out, req.Send()
}

// CreateRestApiWithContext is the same as CreateRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateRestApiWithContext(ctx aws.Context, input *CreateRestApiInput, opts ...request.Option) (*RestApi, error) {
	req, out := c.CreateRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateStage = "CreateStage"

// CreateStageRequest generates a "aws/request.Request" representing the
// client's request for the CreateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateStage for more information on using the CreateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateStageRequest method.
//    req, resp := client.CreateStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateStageRequest(input *CreateStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opCreateStage,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/stages",
	}

	if input == nil {
		input = &CreateStageInput{}
	}

	output = &Stage{}
	req = c.newRequest(op, input, output)
	return
}

// CreateStage API operation for Amazon API Gateway.
//
// Creates a new Stage resource that references a pre-existing Deployment for
// the API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateStage for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateStage(input *CreateStageInput) (*Stage, error) {
	req, out := c.CreateStageRequest(input)
	return out, req.Send()
}

// CreateStageWithContext is the same as CreateStage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateStageWithContext(ctx aws.Context, input *CreateStageInput, opts ...request.Option) (*Stage, error) {
	req, out := c.CreateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUsagePlan = "CreateUsagePlan"

// CreateUsagePlanRequest generates a "aws/request.Request" representing the
// client's request for the CreateUsagePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUsagePlan for more information on using the CreateUsagePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUsagePlanRequest method.
//    req, resp := client.CreateUsagePlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateUsagePlanRequest(input *CreateUsagePlanInput) (req *request.Request, output *UsagePlan) {
	op := &request.Operation{
		Name:       opCreateUsagePlan,
		HTTPMethod: "POST",
		HTTPPath:   "/usageplans",
	}

	if input == nil {
		input = &CreateUsagePlanInput{}
	}

	output = &UsagePlan{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUsagePlan API operation for Amazon API Gateway.
//
// Creates a usage plan with the throttle and quota limits, as well as the associated
// API stages, specified in the payload.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateUsagePlan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateUsagePlan(input *CreateUsagePlanInput) (*UsagePlan, error) {
	req, out := c.CreateUsagePlanRequest(input)
	return out, req.Send()
}

// CreateUsagePlanWithContext is the same as CreateUsagePlan with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsagePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateUsagePlanWithContext(ctx aws.Context, input *CreateUsagePlanInput, opts ...request.Option) (*UsagePlan, error) {
	req, out := c.CreateUsagePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUsagePlanKey = "CreateUsagePlanKey"

// CreateUsagePlanKeyRequest generates a "aws/request.Request" representing the
// client's request for the CreateUsagePlanKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUsagePlanKey for more information on using the CreateUsagePlanKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUsagePlanKeyRequest method.
//    req, resp := client.CreateUsagePlanKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateUsagePlanKeyRequest(input *CreateUsagePlanKeyInput) (req *request.Request, output *UsagePlanKey) {
	op := &request.Operation{
		Name:       opCreateUsagePlanKey,
		HTTPMethod: "POST",
		HTTPPath:   "/usageplans/{usageplanId}/keys",
	}

	if input == nil {
		input = &CreateUsagePlanKeyInput{}
	}

	output = &UsagePlanKey{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUsagePlanKey API operation for Amazon API Gateway.
//
// Creates a usage plan key for adding an existing API key to a usage plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateUsagePlanKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateUsagePlanKey(input *CreateUsagePlanKeyInput) (*UsagePlanKey, error) {
	req, out := c.CreateUsagePlanKeyRequest(input)
	return out, req.Send()
}

// CreateUsagePlanKeyWithContext is the same as CreateUsagePlanKey with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsagePlanKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateUsagePlanKeyWithContext(ctx aws.Context, input *CreateUsagePlanKeyInput, opts ...request.Option) (*UsagePlanKey, error) {
	req, out := c.CreateUsagePlanKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVpcLink = "CreateVpcLink"

// CreateVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the CreateVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVpcLink for more information on using the CreateVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateVpcLinkRequest method.
//    req, resp := client.CreateVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) CreateVpcLinkRequest(input *CreateVpcLinkInput) (req *request.Request, output *UpdateVpcLinkOutput) {
	op := &request.Operation{
		Name:       opCreateVpcLink,
		HTTPMethod: "POST",
		HTTPPath:   "/vpclinks",
	}

	if input == nil {
		input = &CreateVpcLinkInput{}
	}

	output = &UpdateVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVpcLink API operation for Amazon API Gateway.
//
// Creates a VPC link, under the caller's account in a selected region, in an
// asynchronous operation that typically takes 2-4 minutes to complete and become
// operational. The caller must have permissions to create and update VPC Endpoint
// services.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation CreateVpcLink for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) CreateVpcLink(input *CreateVpcLinkInput) (*UpdateVpcLinkOutput, error) {
	req, out := c.CreateVpcLinkRequest(input)
	return out, req.Send()
}

// CreateVpcLinkWithContext is the same as CreateVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) CreateVpcLinkWithContext(ctx aws.Context, input *CreateVpcLinkInput, opts ...request.Option) (*UpdateVpcLinkOutput, error) {
	req, out := c.CreateVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApiKey = "DeleteApiKey"

// DeleteApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApiKey for more information on using the DeleteApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApiKeyRequest method.
//    req, resp := client.DeleteApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteApiKeyRequest(input *DeleteApiKeyInput) (req *request.Request, output *DeleteApiKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteApiKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &DeleteApiKeyInput{}
	}

	output = &DeleteApiKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteApiKey API operation for Amazon API Gateway.
//
// Deletes the ApiKey resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteApiKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteApiKey(input *DeleteApiKeyInput) (*DeleteApiKeyOutput, error) {
	req, out := c.DeleteApiKeyRequest(input)
	return out, req.Send()
}

// DeleteApiKeyWithContext is the same as DeleteApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteApiKeyWithContext(ctx aws.Context, input *DeleteApiKeyInput, opts ...request.Option) (*DeleteApiKeyOutput, error) {
	req, out := c.DeleteApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAuthorizer = "DeleteAuthorizer"

// DeleteAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAuthorizer for more information on using the DeleteAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAuthorizerRequest method.
//    req, resp := client.DeleteAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteAuthorizerRequest(input *DeleteAuthorizerInput) (req *request.Request, output *DeleteAuthorizerOutput) {
	op := &request.Operation{
		Name:       opDeleteAuthorizer,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/authorizers/{authorizer_id}",
	}

	if input == nil {
		input = &DeleteAuthorizerInput{}
	}

	output = &DeleteAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteAuthorizer API operation for Amazon API Gateway.
//
// Deletes an existing Authorizer resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/delete-authorizer.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteAuthorizer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteAuthorizer(input *DeleteAuthorizerInput) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	return out, req.Send()
}

// DeleteAuthorizerWithContext is the same as DeleteAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteAuthorizerWithContext(ctx aws.Context, input *DeleteAuthorizerInput, opts ...request.Option) (*DeleteAuthorizerOutput, error) {
	req, out := c.DeleteAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBasePathMapping = "DeleteBasePathMapping"

// DeleteBasePathMappingRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBasePathMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBasePathMapping for more information on using the DeleteBasePathMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBasePathMappingRequest method.
//    req, resp := client.DeleteBasePathMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteBasePathMappingRequest(input *DeleteBasePathMappingInput) (req *request.Request, output *DeleteBasePathMappingOutput) {
	op := &request.Operation{
		Name:       opDeleteBasePathMapping,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &DeleteBasePathMappingInput{}
	}

	output = &DeleteBasePathMappingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBasePathMapping API operation for Amazon API Gateway.
//
// Deletes the BasePathMapping resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteBasePathMapping for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteBasePathMapping(input *DeleteBasePathMappingInput) (*DeleteBasePathMappingOutput, error) {
	req, out := c.DeleteBasePathMappingRequest(input)
	return out, req.Send()
}

// DeleteBasePathMappingWithContext is the same as DeleteBasePathMapping with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBasePathMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteBasePathMappingWithContext(ctx aws.Context, input *DeleteBasePathMappingInput, opts ...request.Option) (*DeleteBasePathMappingOutput, error) {
	req, out := c.DeleteBasePathMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteClientCertificate = "DeleteClientCertificate"

// DeleteClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteClientCertificate for more information on using the DeleteClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteClientCertificateRequest method.
//    req, resp := client.DeleteClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteClientCertificateRequest(input *DeleteClientCertificateInput) (req *request.Request, output *DeleteClientCertificateOutput) {
	op := &request.Operation{
		Name:       opDeleteClientCertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &DeleteClientCertificateInput{}
	}

	output = &DeleteClientCertificateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteClientCertificate API operation for Amazon API Gateway.
//
// Deletes the ClientCertificate resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteClientCertificate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteClientCertificate(input *DeleteClientCertificateInput) (*DeleteClientCertificateOutput, error) {
	req, out := c.DeleteClientCertificateRequest(input)
	return out, req.Send()
}

// DeleteClientCertificateWithContext is the same as DeleteClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteClientCertificateWithContext(ctx aws.Context, input *DeleteClientCertificateInput, opts ...request.Option) (*DeleteClientCertificateOutput, error) {
	req, out := c.DeleteClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDeployment = "DeleteDeployment"

// DeleteDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDeployment for more information on using the DeleteDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDeploymentRequest method.
//    req, resp := client.DeleteDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteDeploymentRequest(input *DeleteDeploymentInput) (req *request.Request, output *DeleteDeploymentOutput) {
	op := &request.Operation{
		Name:       opDeleteDeployment,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &DeleteDeploymentInput{}
	}

	output = &DeleteDeploymentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDeployment API operation for Amazon API Gateway.
//
// Deletes a Deployment resource. Deleting a deployment will only succeed if
// there are no Stage resources associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteDeployment(input *DeleteDeploymentInput) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	return out, req.Send()
}

// DeleteDeploymentWithContext is the same as DeleteDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteDeploymentWithContext(ctx aws.Context, input *DeleteDeploymentInput, opts ...request.Option) (*DeleteDeploymentOutput, error) {
	req, out := c.DeleteDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocumentationPart = "DeleteDocumentationPart"

// DeleteDocumentationPartRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocumentationPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocumentationPart for more information on using the DeleteDocumentationPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDocumentationPartRequest method.
//    req, resp := client.DeleteDocumentationPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteDocumentationPartRequest(input *DeleteDocumentationPartInput) (req *request.Request, output *DeleteDocumentationPartOutput) {
	op := &request.Operation{
		Name:       opDeleteDocumentationPart,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts/{part_id}",
	}

	if input == nil {
		input = &DeleteDocumentationPartInput{}
	}

	output = &DeleteDocumentationPartOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocumentationPart API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteDocumentationPart for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteDocumentationPart(input *DeleteDocumentationPartInput) (*DeleteDocumentationPartOutput, error) {
	req, out := c.DeleteDocumentationPartRequest(input)
	return out, req.Send()
}

// DeleteDocumentationPartWithContext is the same as DeleteDocumentationPart with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocumentationPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteDocumentationPartWithContext(ctx aws.Context, input *DeleteDocumentationPartInput, opts ...request.Option) (*DeleteDocumentationPartOutput, error) {
	req, out := c.DeleteDocumentationPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDocumentationVersion = "DeleteDocumentationVersion"

// DeleteDocumentationVersionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDocumentationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDocumentationVersion for more information on using the DeleteDocumentationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDocumentationVersionRequest method.
//    req, resp := client.DeleteDocumentationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteDocumentationVersionRequest(input *DeleteDocumentationVersionInput) (req *request.Request, output *DeleteDocumentationVersionOutput) {
	op := &request.Operation{
		Name:       opDeleteDocumentationVersion,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions/{doc_version}",
	}

	if input == nil {
		input = &DeleteDocumentationVersionInput{}
	}

	output = &DeleteDocumentationVersionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDocumentationVersion API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteDocumentationVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteDocumentationVersion(input *DeleteDocumentationVersionInput) (*DeleteDocumentationVersionOutput, error) {
	req, out := c.DeleteDocumentationVersionRequest(input)
	return out, req.Send()
}

// DeleteDocumentationVersionWithContext is the same as DeleteDocumentationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDocumentationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteDocumentationVersionWithContext(ctx aws.Context, input *DeleteDocumentationVersionInput, opts ...request.Option) (*DeleteDocumentationVersionOutput, error) {
	req, out := c.DeleteDocumentationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDomainName = "DeleteDomainName"

// DeleteDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDomainName for more information on using the DeleteDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDomainNameRequest method.
//    req, resp := client.DeleteDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteDomainNameRequest(input *DeleteDomainNameInput) (req *request.Request, output *DeleteDomainNameOutput) {
	op := &request.Operation{
		Name:       opDeleteDomainName,
		HTTPMethod: "DELETE",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &DeleteDomainNameInput{}
	}

	output = &DeleteDomainNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDomainName API operation for Amazon API Gateway.
//
// Deletes the DomainName resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteDomainName for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteDomainName(input *DeleteDomainNameInput) (*DeleteDomainNameOutput, error) {
	req, out := c.DeleteDomainNameRequest(input)
	return out, req.Send()
}

// DeleteDomainNameWithContext is the same as DeleteDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteDomainNameWithContext(ctx aws.Context, input *DeleteDomainNameInput, opts ...request.Option) (*DeleteDomainNameOutput, error) {
	req, out := c.DeleteDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGatewayResponse = "DeleteGatewayResponse"

// DeleteGatewayResponseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGatewayResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGatewayResponse for more information on using the DeleteGatewayResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGatewayResponseRequest method.
//    req, resp := client.DeleteGatewayResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteGatewayResponseRequest(input *DeleteGatewayResponseInput) (req *request.Request, output *DeleteGatewayResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteGatewayResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses/{response_type}",
	}

	if input == nil {
		input = &DeleteGatewayResponseInput{}
	}

	output = &DeleteGatewayResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteGatewayResponse API operation for Amazon API Gateway.
//
// Clears any customization of a GatewayResponse of a specified response type
// on the given RestApi and resets it with the default settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteGatewayResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteGatewayResponse(input *DeleteGatewayResponseInput) (*DeleteGatewayResponseOutput, error) {
	req, out := c.DeleteGatewayResponseRequest(input)
	return out, req.Send()
}

// DeleteGatewayResponseWithContext is the same as DeleteGatewayResponse with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGatewayResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteGatewayResponseWithContext(ctx aws.Context, input *DeleteGatewayResponseInput, opts ...request.Option) (*DeleteGatewayResponseOutput, error) {
	req, out := c.DeleteGatewayResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegration = "DeleteIntegration"

// DeleteIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegration for more information on using the DeleteIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntegrationRequest method.
//    req, resp := client.DeleteIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteIntegrationRequest(input *DeleteIntegrationInput) (req *request.Request, output *DeleteIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &DeleteIntegrationInput{}
	}

	output = &DeleteIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntegration API operation for Amazon API Gateway.
//
// Represents a delete integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteIntegration(input *DeleteIntegrationInput) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	return out, req.Send()
}

// DeleteIntegrationWithContext is the same as DeleteIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteIntegrationWithContext(ctx aws.Context, input *DeleteIntegrationInput, opts ...request.Option) (*DeleteIntegrationOutput, error) {
	req, out := c.DeleteIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegrationResponse = "DeleteIntegrationResponse"

// DeleteIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegrationResponse for more information on using the DeleteIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIntegrationResponseRequest method.
//    req, resp := client.DeleteIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteIntegrationResponseRequest(input *DeleteIntegrationResponseInput) (req *request.Request, output *DeleteIntegrationResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegrationResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &DeleteIntegrationResponseInput{}
	}

	output = &DeleteIntegrationResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntegrationResponse API operation for Amazon API Gateway.
//
// Represents a delete integration response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteIntegrationResponse(input *DeleteIntegrationResponseInput) (*DeleteIntegrationResponseOutput, error) {
	req, out := c.DeleteIntegrationResponseRequest(input)
	return out, req.Send()
}

// DeleteIntegrationResponseWithContext is the same as DeleteIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteIntegrationResponseWithContext(ctx aws.Context, input *DeleteIntegrationResponseInput, opts ...request.Option) (*DeleteIntegrationResponseOutput, error) {
	req, out := c.DeleteIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMethod = "DeleteMethod"

// DeleteMethodRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMethod for more information on using the DeleteMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMethodRequest method.
//    req, resp := client.DeleteMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteMethodRequest(input *DeleteMethodInput) (req *request.Request, output *DeleteMethodOutput) {
	op := &request.Operation{
		Name:       opDeleteMethod,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &DeleteMethodInput{}
	}

	output = &DeleteMethodOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMethod API operation for Amazon API Gateway.
//
// Deletes an existing Method resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteMethod for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
func (c *APIGateway) DeleteMethod(input *DeleteMethodInput) (*DeleteMethodOutput, error) {
	req, out := c.DeleteMethodRequest(input)
	return out, req.Send()
}

// DeleteMethodWithContext is the same as DeleteMethod with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteMethodWithContext(ctx aws.Context, input *DeleteMethodInput, opts ...request.Option) (*DeleteMethodOutput, error) {
	req, out := c.DeleteMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteMethodResponse = "DeleteMethodResponse"

// DeleteMethodResponseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteMethodResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteMethodResponse for more information on using the DeleteMethodResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteMethodResponseRequest method.
//    req, resp := client.DeleteMethodResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteMethodResponseRequest(input *DeleteMethodResponseInput) (req *request.Request, output *DeleteMethodResponseOutput) {
	op := &request.Operation{
		Name:       opDeleteMethodResponse,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &DeleteMethodResponseInput{}
	}

	output = &DeleteMethodResponseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteMethodResponse API operation for Amazon API Gateway.
//
// Deletes an existing MethodResponse resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteMethodResponse for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
func (c *APIGateway) DeleteMethodResponse(input *DeleteMethodResponseInput) (*DeleteMethodResponseOutput, error) {
	req, out := c.DeleteMethodResponseRequest(input)
	return out, req.Send()
}

// DeleteMethodResponseWithContext is the same as DeleteMethodResponse with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteMethodResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteMethodResponseWithContext(ctx aws.Context, input *DeleteMethodResponseInput, opts ...request.Option) (*DeleteMethodResponseOutput, error) {
	req, out := c.DeleteMethodResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteModel = "DeleteModel"

// DeleteModelRequest generates a "aws/request.Request" representing the
// client's request for the DeleteModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteModel for more information on using the DeleteModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteModelRequest method.
//    req, resp := client.DeleteModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteModelRequest(input *DeleteModelInput) (req *request.Request, output *DeleteModelOutput) {
	op := &request.Operation{
		Name:       opDeleteModel,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &DeleteModelInput{}
	}

	output = &DeleteModelOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteModel API operation for Amazon API Gateway.
//
// Deletes a model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteModel(input *DeleteModelInput) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	return out, req.Send()
}

// DeleteModelWithContext is the same as DeleteModel with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteModelWithContext(ctx aws.Context, input *DeleteModelInput, opts ...request.Option) (*DeleteModelOutput, error) {
	req, out := c.DeleteModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRequestValidator = "DeleteRequestValidator"

// DeleteRequestValidatorRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRequestValidator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRequestValidator for more information on using the DeleteRequestValidator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRequestValidatorRequest method.
//    req, resp := client.DeleteRequestValidatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteRequestValidatorRequest(input *DeleteRequestValidatorInput) (req *request.Request, output *DeleteRequestValidatorOutput) {
	op := &request.Operation{
		Name:       opDeleteRequestValidator,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
	}

	if input == nil {
		input = &DeleteRequestValidatorInput{}
	}

	output = &DeleteRequestValidatorOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRequestValidator API operation for Amazon API Gateway.
//
// Deletes a RequestValidator of a given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteRequestValidator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteRequestValidator(input *DeleteRequestValidatorInput) (*DeleteRequestValidatorOutput, error) {
	req, out := c.DeleteRequestValidatorRequest(input)
	return out, req.Send()
}

// DeleteRequestValidatorWithContext is the same as DeleteRequestValidator with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRequestValidator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteRequestValidatorWithContext(ctx aws.Context, input *DeleteRequestValidatorInput, opts ...request.Option) (*DeleteRequestValidatorOutput, error) {
	req, out := c.DeleteRequestValidatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResource = "DeleteResource"

// DeleteResourceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResource for more information on using the DeleteResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteResourceRequest method.
//    req, resp := client.DeleteResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteResourceRequest(input *DeleteResourceInput) (req *request.Request, output *DeleteResourceOutput) {
	op := &request.Operation{
		Name:       opDeleteResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &DeleteResourceInput{}
	}

	output = &DeleteResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResource API operation for Amazon API Gateway.
//
// Deletes a Resource resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteResource for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteResource(input *DeleteResourceInput) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	return out, req.Send()
}

// DeleteResourceWithContext is the same as DeleteResource with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteResourceWithContext(ctx aws.Context, input *DeleteResourceInput, opts ...request.Option) (*DeleteResourceOutput, error) {
	req, out := c.DeleteResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRestApi = "DeleteRestApi"

// DeleteRestApiRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRestApi for more information on using the DeleteRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRestApiRequest method.
//    req, resp := client.DeleteRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteRestApiRequest(input *DeleteRestApiInput) (req *request.Request, output *DeleteRestApiOutput) {
	op := &request.Operation{
		Name:       opDeleteRestApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &DeleteRestApiInput{}
	}

	output = &DeleteRestApiOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRestApi API operation for Amazon API Gateway.
//
// Deletes the specified API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteRestApi(input *DeleteRestApiInput) (*DeleteRestApiOutput, error) {
	req, out := c.DeleteRestApiRequest(input)
	return out, req.Send()
}

// DeleteRestApiWithContext is the same as DeleteRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteRestApiWithContext(ctx aws.Context, input *DeleteRestApiInput, opts ...request.Option) (*DeleteRestApiOutput, error) {
	req, out := c.DeleteRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteStage = "DeleteStage"

// DeleteStageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteStage for more information on using the DeleteStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteStageRequest method.
//    req, resp := client.DeleteStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteStageRequest(input *DeleteStageInput) (req *request.Request, output *DeleteStageOutput) {
	op := &request.Operation{
		Name:       opDeleteStage,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &DeleteStageInput{}
	}

	output = &DeleteStageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteStage API operation for Amazon API Gateway.
//
// Deletes a Stage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteStage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteStage(input *DeleteStageInput) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	return out, req.Send()
}

// DeleteStageWithContext is the same as DeleteStage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteStageWithContext(ctx aws.Context, input *DeleteStageInput, opts ...request.Option) (*DeleteStageOutput, error) {
	req, out := c.DeleteStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUsagePlan = "DeleteUsagePlan"

// DeleteUsagePlanRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUsagePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUsagePlan for more information on using the DeleteUsagePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUsagePlanRequest method.
//    req, resp := client.DeleteUsagePlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteUsagePlanRequest(input *DeleteUsagePlanInput) (req *request.Request, output *DeleteUsagePlanOutput) {
	op := &request.Operation{
		Name:       opDeleteUsagePlan,
		HTTPMethod: "DELETE",
		HTTPPath:   "/usageplans/{usageplanId}",
	}

	if input == nil {
		input = &DeleteUsagePlanInput{}
	}

	output = &DeleteUsagePlanOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUsagePlan API operation for Amazon API Gateway.
//
// Deletes a usage plan of a given plan Id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteUsagePlan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteUsagePlan(input *DeleteUsagePlanInput) (*DeleteUsagePlanOutput, error) {
	req, out := c.DeleteUsagePlanRequest(input)
	return out, req.Send()
}

// DeleteUsagePlanWithContext is the same as DeleteUsagePlan with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUsagePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteUsagePlanWithContext(ctx aws.Context, input *DeleteUsagePlanInput, opts ...request.Option) (*DeleteUsagePlanOutput, error) {
	req, out := c.DeleteUsagePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUsagePlanKey = "DeleteUsagePlanKey"

// DeleteUsagePlanKeyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUsagePlanKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUsagePlanKey for more information on using the DeleteUsagePlanKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteUsagePlanKeyRequest method.
//    req, resp := client.DeleteUsagePlanKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteUsagePlanKeyRequest(input *DeleteUsagePlanKeyInput) (req *request.Request, output *DeleteUsagePlanKeyOutput) {
	op := &request.Operation{
		Name:       opDeleteUsagePlanKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/usageplans/{usageplanId}/keys/{keyId}",
	}

	if input == nil {
		input = &DeleteUsagePlanKeyInput{}
	}

	output = &DeleteUsagePlanKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUsagePlanKey API operation for Amazon API Gateway.
//
// Deletes a usage plan key and remove the underlying API key from the associated
// usage plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteUsagePlanKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteUsagePlanKey(input *DeleteUsagePlanKeyInput) (*DeleteUsagePlanKeyOutput, error) {
	req, out := c.DeleteUsagePlanKeyRequest(input)
	return out, req.Send()
}

// DeleteUsagePlanKeyWithContext is the same as DeleteUsagePlanKey with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUsagePlanKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteUsagePlanKeyWithContext(ctx aws.Context, input *DeleteUsagePlanKeyInput, opts ...request.Option) (*DeleteUsagePlanKeyOutput, error) {
	req, out := c.DeleteUsagePlanKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVpcLink = "DeleteVpcLink"

// DeleteVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVpcLink for more information on using the DeleteVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteVpcLinkRequest method.
//    req, resp := client.DeleteVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) DeleteVpcLinkRequest(input *DeleteVpcLinkInput) (req *request.Request, output *DeleteVpcLinkOutput) {
	op := &request.Operation{
		Name:       opDeleteVpcLink,
		HTTPMethod: "DELETE",
		HTTPPath:   "/vpclinks/{vpclink_id}",
	}

	if input == nil {
		input = &DeleteVpcLinkInput{}
	}

	output = &DeleteVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteVpcLink API operation for Amazon API Gateway.
//
// Deletes an existing VpcLink of a specified identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation DeleteVpcLink for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) DeleteVpcLink(input *DeleteVpcLinkInput) (*DeleteVpcLinkOutput, error) {
	req, out := c.DeleteVpcLinkRequest(input)
	return out, req.Send()
}

// DeleteVpcLinkWithContext is the same as DeleteVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) DeleteVpcLinkWithContext(ctx aws.Context, input *DeleteVpcLinkInput, opts ...request.Option) (*DeleteVpcLinkOutput, error) {
	req, out := c.DeleteVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFlushStageAuthorizersCache = "FlushStageAuthorizersCache"

// FlushStageAuthorizersCacheRequest generates a "aws/request.Request" representing the
// client's request for the FlushStageAuthorizersCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FlushStageAuthorizersCache for more information on using the FlushStageAuthorizersCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FlushStageAuthorizersCacheRequest method.
//    req, resp := client.FlushStageAuthorizersCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) FlushStageAuthorizersCacheRequest(input *FlushStageAuthorizersCacheInput) (req *request.Request, output *FlushStageAuthorizersCacheOutput) {
	op := &request.Operation{
		Name:       opFlushStageAuthorizersCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/cache/authorizers",
	}

	if input == nil {
		input = &FlushStageAuthorizersCacheInput{}
	}

	output = &FlushStageAuthorizersCacheOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// FlushStageAuthorizersCache API operation for Amazon API Gateway.
//
// Flushes all authorizer cache entries on a stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation FlushStageAuthorizersCache for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) FlushStageAuthorizersCache(input *FlushStageAuthorizersCacheInput) (*FlushStageAuthorizersCacheOutput, error) {
	req, out := c.FlushStageAuthorizersCacheRequest(input)
	return out, req.Send()
}

// FlushStageAuthorizersCacheWithContext is the same as FlushStageAuthorizersCache with the addition of
// the ability to pass a context and additional request options.
//
// See FlushStageAuthorizersCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) FlushStageAuthorizersCacheWithContext(ctx aws.Context, input *FlushStageAuthorizersCacheInput, opts ...request.Option) (*FlushStageAuthorizersCacheOutput, error) {
	req, out := c.FlushStageAuthorizersCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opFlushStageCache = "FlushStageCache"

// FlushStageCacheRequest generates a "aws/request.Request" representing the
// client's request for the FlushStageCache operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See FlushStageCache for more information on using the FlushStageCache
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the FlushStageCacheRequest method.
//    req, resp := client.FlushStageCacheRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) FlushStageCacheRequest(input *FlushStageCacheInput) (req *request.Request, output *FlushStageCacheOutput) {
	op := &request.Operation{
		Name:       opFlushStageCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/cache/data",
	}

	if input == nil {
		input = &FlushStageCacheInput{}
	}

	output = &FlushStageCacheOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// FlushStageCache API operation for Amazon API Gateway.
//
// Flushes a stage's cache.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation FlushStageCache for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) FlushStageCache(input *FlushStageCacheInput) (*FlushStageCacheOutput, error) {
	req, out := c.FlushStageCacheRequest(input)
	return out, req.Send()
}

// FlushStageCacheWithContext is the same as FlushStageCache with the addition of
// the ability to pass a context and additional request options.
//
// See FlushStageCache for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) FlushStageCacheWithContext(ctx aws.Context, input *FlushStageCacheInput, opts ...request.Option) (*FlushStageCacheOutput, error) {
	req, out := c.FlushStageCacheRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGenerateClientCertificate = "GenerateClientCertificate"

// GenerateClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GenerateClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GenerateClientCertificate for more information on using the GenerateClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GenerateClientCertificateRequest method.
//    req, resp := client.GenerateClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GenerateClientCertificateRequest(input *GenerateClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opGenerateClientCertificate,
		HTTPMethod: "POST",
		HTTPPath:   "/clientcertificates",
	}

	if input == nil {
		input = &GenerateClientCertificateInput{}
	}

	output = &ClientCertificate{}
	req = c.newRequest(op, input, output)
	return
}

// GenerateClientCertificate API operation for Amazon API Gateway.
//
// Generates a ClientCertificate resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GenerateClientCertificate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GenerateClientCertificate(input *GenerateClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.GenerateClientCertificateRequest(input)
	return out, req.Send()
}

// GenerateClientCertificateWithContext is the same as GenerateClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GenerateClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GenerateClientCertificateWithContext(ctx aws.Context, input *GenerateClientCertificateInput, opts ...request.Option) (*ClientCertificate, error) {
	req, out := c.GenerateClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAccount = "GetAccount"

// GetAccountRequest generates a "aws/request.Request" representing the
// client's request for the GetAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAccount for more information on using the GetAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAccountRequest method.
//    req, resp := client.GetAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetAccountRequest(input *GetAccountInput) (req *request.Request, output *Account) {
	op := &request.Operation{
		Name:       opGetAccount,
		HTTPMethod: "GET",
		HTTPPath:   "/account",
	}

	if input == nil {
		input = &GetAccountInput{}
	}

	output = &Account{}
	req = c.newRequest(op, input, output)
	return
}

// GetAccount API operation for Amazon API Gateway.
//
// Gets information about the current Account resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetAccount(input *GetAccountInput) (*Account, error) {
	req, out := c.GetAccountRequest(input)
	return out, req.Send()
}

// GetAccountWithContext is the same as GetAccount with the addition of
// the ability to pass a context and additional request options.
//
// See GetAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetAccountWithContext(ctx aws.Context, input *GetAccountInput, opts ...request.Option) (*Account, error) {
	req, out := c.GetAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApiKey = "GetApiKey"

// GetApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApiKey for more information on using the GetApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApiKeyRequest method.
//    req, resp := client.GetApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetApiKeyRequest(input *GetApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opGetApiKey,
		HTTPMethod: "GET",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &GetApiKeyInput{}
	}

	output = &ApiKey{}
	req = c.newRequest(op, input, output)
	return
}

// GetApiKey API operation for Amazon API Gateway.
//
// Gets information about the current ApiKey resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetApiKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetApiKey(input *GetApiKeyInput) (*ApiKey, error) {
	req, out := c.GetApiKeyRequest(input)
	return out, req.Send()
}

// GetApiKeyWithContext is the same as GetApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetApiKeyWithContext(ctx aws.Context, input *GetApiKeyInput, opts ...request.Option) (*ApiKey, error) {
	req, out := c.GetApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApiKeys = "GetApiKeys"

// GetApiKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetApiKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApiKeys for more information on using the GetApiKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApiKeysRequest method.
//    req, resp := client.GetApiKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetApiKeysRequest(input *GetApiKeysInput) (req *request.Request, output *GetApiKeysOutput) {
	op := &request.Operation{
		Name:       opGetApiKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/apikeys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetApiKeysInput{}
	}

	output = &GetApiKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApiKeys API operation for Amazon API Gateway.
//
// Gets information about the current ApiKeys resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetApiKeys for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetApiKeys(input *GetApiKeysInput) (*GetApiKeysOutput, error) {
	req, out := c.GetApiKeysRequest(input)
	return out, req.Send()
}

// GetApiKeysWithContext is the same as GetApiKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetApiKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetApiKeysWithContext(ctx aws.Context, input *GetApiKeysInput, opts ...request.Option) (*GetApiKeysOutput, error) {
	req, out := c.GetApiKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetApiKeysPages iterates over the pages of a GetApiKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetApiKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetApiKeys operation.
//    pageNum := 0
//    err := client.GetApiKeysPages(params,
//        func(page *apigateway.GetApiKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetApiKeysPages(input *GetApiKeysInput, fn func(*GetApiKeysOutput, bool) bool) error {
	return c.GetApiKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetApiKeysPagesWithContext same as GetApiKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetApiKeysPagesWithContext(ctx aws.Context, input *GetApiKeysInput, fn func(*GetApiKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetApiKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetApiKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetApiKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetAuthorizer = "GetAuthorizer"

// GetAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizer for more information on using the GetAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAuthorizerRequest method.
//    req, resp := client.GetAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetAuthorizerRequest(input *GetAuthorizerInput) (req *request.Request, output *Authorizer) {
	op := &request.Operation{
		Name:       opGetAuthorizer,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/authorizers/{authorizer_id}",
	}

	if input == nil {
		input = &GetAuthorizerInput{}
	}

	output = &Authorizer{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizer API operation for Amazon API Gateway.
//
// Describe an existing Authorizer resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizer.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetAuthorizer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetAuthorizer(input *GetAuthorizerInput) (*Authorizer, error) {
	req, out := c.GetAuthorizerRequest(input)
	return out, req.Send()
}

// GetAuthorizerWithContext is the same as GetAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetAuthorizerWithContext(ctx aws.Context, input *GetAuthorizerInput, opts ...request.Option) (*Authorizer, error) {
	req, out := c.GetAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAuthorizers = "GetAuthorizers"

// GetAuthorizersRequest generates a "aws/request.Request" representing the
// client's request for the GetAuthorizers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAuthorizers for more information on using the GetAuthorizers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAuthorizersRequest method.
//    req, resp := client.GetAuthorizersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetAuthorizersRequest(input *GetAuthorizersInput) (req *request.Request, output *GetAuthorizersOutput) {
	op := &request.Operation{
		Name:       opGetAuthorizers,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/authorizers",
	}

	if input == nil {
		input = &GetAuthorizersInput{}
	}

	output = &GetAuthorizersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAuthorizers API operation for Amazon API Gateway.
//
// Describe an existing Authorizers resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-authorizers.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetAuthorizers for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetAuthorizers(input *GetAuthorizersInput) (*GetAuthorizersOutput, error) {
	req, out := c.GetAuthorizersRequest(input)
	return out, req.Send()
}

// GetAuthorizersWithContext is the same as GetAuthorizers with the addition of
// the ability to pass a context and additional request options.
//
// See GetAuthorizers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetAuthorizersWithContext(ctx aws.Context, input *GetAuthorizersInput, opts ...request.Option) (*GetAuthorizersOutput, error) {
	req, out := c.GetAuthorizersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBasePathMapping = "GetBasePathMapping"

// GetBasePathMappingRequest generates a "aws/request.Request" representing the
// client's request for the GetBasePathMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBasePathMapping for more information on using the GetBasePathMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBasePathMappingRequest method.
//    req, resp := client.GetBasePathMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetBasePathMappingRequest(input *GetBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opGetBasePathMapping,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &GetBasePathMappingInput{}
	}

	output = &BasePathMapping{}
	req = c.newRequest(op, input, output)
	return
}

// GetBasePathMapping API operation for Amazon API Gateway.
//
// Describe a BasePathMapping resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetBasePathMapping for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetBasePathMapping(input *GetBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.GetBasePathMappingRequest(input)
	return out, req.Send()
}

// GetBasePathMappingWithContext is the same as GetBasePathMapping with the addition of
// the ability to pass a context and additional request options.
//
// See GetBasePathMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetBasePathMappingWithContext(ctx aws.Context, input *GetBasePathMappingInput, opts ...request.Option) (*BasePathMapping, error) {
	req, out := c.GetBasePathMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetBasePathMappings = "GetBasePathMappings"

// GetBasePathMappingsRequest generates a "aws/request.Request" representing the
// client's request for the GetBasePathMappings operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetBasePathMappings for more information on using the GetBasePathMappings
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetBasePathMappingsRequest method.
//    req, resp := client.GetBasePathMappingsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetBasePathMappingsRequest(input *GetBasePathMappingsInput) (req *request.Request, output *GetBasePathMappingsOutput) {
	op := &request.Operation{
		Name:       opGetBasePathMappings,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetBasePathMappingsInput{}
	}

	output = &GetBasePathMappingsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetBasePathMappings API operation for Amazon API Gateway.
//
// Represents a collection of BasePathMapping resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetBasePathMappings for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetBasePathMappings(input *GetBasePathMappingsInput) (*GetBasePathMappingsOutput, error) {
	req, out := c.GetBasePathMappingsRequest(input)
	return out, req.Send()
}

// GetBasePathMappingsWithContext is the same as GetBasePathMappings with the addition of
// the ability to pass a context and additional request options.
//
// See GetBasePathMappings for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetBasePathMappingsWithContext(ctx aws.Context, input *GetBasePathMappingsInput, opts ...request.Option) (*GetBasePathMappingsOutput, error) {
	req, out := c.GetBasePathMappingsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetBasePathMappingsPages iterates over the pages of a GetBasePathMappings operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetBasePathMappings method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetBasePathMappings operation.
//    pageNum := 0
//    err := client.GetBasePathMappingsPages(params,
//        func(page *apigateway.GetBasePathMappingsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetBasePathMappingsPages(input *GetBasePathMappingsInput, fn func(*GetBasePathMappingsOutput, bool) bool) error {
	return c.GetBasePathMappingsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetBasePathMappingsPagesWithContext same as GetBasePathMappingsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetBasePathMappingsPagesWithContext(ctx aws.Context, input *GetBasePathMappingsInput, fn func(*GetBasePathMappingsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetBasePathMappingsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetBasePathMappingsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetBasePathMappingsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetClientCertificate = "GetClientCertificate"

// GetClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the GetClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClientCertificate for more information on using the GetClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClientCertificateRequest method.
//    req, resp := client.GetClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetClientCertificateRequest(input *GetClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opGetClientCertificate,
		HTTPMethod: "GET",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &GetClientCertificateInput{}
	}

	output = &ClientCertificate{}
	req = c.newRequest(op, input, output)
	return
}

// GetClientCertificate API operation for Amazon API Gateway.
//
// Gets information about the current ClientCertificate resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetClientCertificate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetClientCertificate(input *GetClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.GetClientCertificateRequest(input)
	return out, req.Send()
}

// GetClientCertificateWithContext is the same as GetClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See GetClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetClientCertificateWithContext(ctx aws.Context, input *GetClientCertificateInput, opts ...request.Option) (*ClientCertificate, error) {
	req, out := c.GetClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetClientCertificates = "GetClientCertificates"

// GetClientCertificatesRequest generates a "aws/request.Request" representing the
// client's request for the GetClientCertificates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetClientCertificates for more information on using the GetClientCertificates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetClientCertificatesRequest method.
//    req, resp := client.GetClientCertificatesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetClientCertificatesRequest(input *GetClientCertificatesInput) (req *request.Request, output *GetClientCertificatesOutput) {
	op := &request.Operation{
		Name:       opGetClientCertificates,
		HTTPMethod: "GET",
		HTTPPath:   "/clientcertificates",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetClientCertificatesInput{}
	}

	output = &GetClientCertificatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetClientCertificates API operation for Amazon API Gateway.
//
// Gets a collection of ClientCertificate resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetClientCertificates for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetClientCertificates(input *GetClientCertificatesInput) (*GetClientCertificatesOutput, error) {
	req, out := c.GetClientCertificatesRequest(input)
	return out, req.Send()
}

// GetClientCertificatesWithContext is the same as GetClientCertificates with the addition of
// the ability to pass a context and additional request options.
//
// See GetClientCertificates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetClientCertificatesWithContext(ctx aws.Context, input *GetClientCertificatesInput, opts ...request.Option) (*GetClientCertificatesOutput, error) {
	req, out := c.GetClientCertificatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetClientCertificatesPages iterates over the pages of a GetClientCertificates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetClientCertificates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetClientCertificates operation.
//    pageNum := 0
//    err := client.GetClientCertificatesPages(params,
//        func(page *apigateway.GetClientCertificatesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetClientCertificatesPages(input *GetClientCertificatesInput, fn func(*GetClientCertificatesOutput, bool) bool) error {
	return c.GetClientCertificatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetClientCertificatesPagesWithContext same as GetClientCertificatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetClientCertificatesPagesWithContext(ctx aws.Context, input *GetClientCertificatesInput, fn func(*GetClientCertificatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetClientCertificatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetClientCertificatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetClientCertificatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDeployment = "GetDeployment"

// GetDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployment for more information on using the GetDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentRequest method.
//    req, resp := client.GetDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDeploymentRequest(input *GetDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opGetDeployment,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &GetDeploymentInput{}
	}

	output = &Deployment{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployment API operation for Amazon API Gateway.
//
// Gets information about a Deployment resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * ServiceUnavailableException
//   The requested service is not available. For details see the accompanying
//   error message. Retry after the specified time period.
//
func (c *APIGateway) GetDeployment(input *GetDeploymentInput) (*Deployment, error) {
	req, out := c.GetDeploymentRequest(input)
	return out, req.Send()
}

// GetDeploymentWithContext is the same as GetDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDeploymentWithContext(ctx aws.Context, input *GetDeploymentInput, opts ...request.Option) (*Deployment, error) {
	req, out := c.GetDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDeployments = "GetDeployments"

// GetDeploymentsRequest generates a "aws/request.Request" representing the
// client's request for the GetDeployments operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDeployments for more information on using the GetDeployments
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDeploymentsRequest method.
//    req, resp := client.GetDeploymentsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDeploymentsRequest(input *GetDeploymentsInput) (req *request.Request, output *GetDeploymentsOutput) {
	op := &request.Operation{
		Name:       opGetDeployments,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/deployments",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDeploymentsInput{}
	}

	output = &GetDeploymentsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDeployments API operation for Amazon API Gateway.
//
// Gets information about a Deployments collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDeployments for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * ServiceUnavailableException
//   The requested service is not available. For details see the accompanying
//   error message. Retry after the specified time period.
//
func (c *APIGateway) GetDeployments(input *GetDeploymentsInput) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	return out, req.Send()
}

// GetDeploymentsWithContext is the same as GetDeployments with the addition of
// the ability to pass a context and additional request options.
//
// See GetDeployments for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDeploymentsWithContext(ctx aws.Context, input *GetDeploymentsInput, opts ...request.Option) (*GetDeploymentsOutput, error) {
	req, out := c.GetDeploymentsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDeploymentsPages iterates over the pages of a GetDeployments operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDeployments method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDeployments operation.
//    pageNum := 0
//    err := client.GetDeploymentsPages(params,
//        func(page *apigateway.GetDeploymentsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetDeploymentsPages(input *GetDeploymentsInput, fn func(*GetDeploymentsOutput, bool) bool) error {
	return c.GetDeploymentsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDeploymentsPagesWithContext same as GetDeploymentsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDeploymentsPagesWithContext(ctx aws.Context, input *GetDeploymentsInput, fn func(*GetDeploymentsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDeploymentsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDeploymentsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDeploymentsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetDocumentationPart = "GetDocumentationPart"

// GetDocumentationPartRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentationPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentationPart for more information on using the GetDocumentationPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentationPartRequest method.
//    req, resp := client.GetDocumentationPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDocumentationPartRequest(input *GetDocumentationPartInput) (req *request.Request, output *DocumentationPart) {
	op := &request.Operation{
		Name:       opGetDocumentationPart,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts/{part_id}",
	}

	if input == nil {
		input = &GetDocumentationPartInput{}
	}

	output = &DocumentationPart{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentationPart API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDocumentationPart for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDocumentationPart(input *GetDocumentationPartInput) (*DocumentationPart, error) {
	req, out := c.GetDocumentationPartRequest(input)
	return out, req.Send()
}

// GetDocumentationPartWithContext is the same as GetDocumentationPart with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentationPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDocumentationPartWithContext(ctx aws.Context, input *GetDocumentationPartInput, opts ...request.Option) (*DocumentationPart, error) {
	req, out := c.GetDocumentationPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentationParts = "GetDocumentationParts"

// GetDocumentationPartsRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentationParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentationParts for more information on using the GetDocumentationParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentationPartsRequest method.
//    req, resp := client.GetDocumentationPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDocumentationPartsRequest(input *GetDocumentationPartsInput) (req *request.Request, output *GetDocumentationPartsOutput) {
	op := &request.Operation{
		Name:       opGetDocumentationParts,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts",
	}

	if input == nil {
		input = &GetDocumentationPartsInput{}
	}

	output = &GetDocumentationPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentationParts API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDocumentationParts for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDocumentationParts(input *GetDocumentationPartsInput) (*GetDocumentationPartsOutput, error) {
	req, out := c.GetDocumentationPartsRequest(input)
	return out, req.Send()
}

// GetDocumentationPartsWithContext is the same as GetDocumentationParts with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentationParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDocumentationPartsWithContext(ctx aws.Context, input *GetDocumentationPartsInput, opts ...request.Option) (*GetDocumentationPartsOutput, error) {
	req, out := c.GetDocumentationPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentationVersion = "GetDocumentationVersion"

// GetDocumentationVersionRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentationVersion for more information on using the GetDocumentationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentationVersionRequest method.
//    req, resp := client.GetDocumentationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDocumentationVersionRequest(input *GetDocumentationVersionInput) (req *request.Request, output *DocumentationVersion) {
	op := &request.Operation{
		Name:       opGetDocumentationVersion,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions/{doc_version}",
	}

	if input == nil {
		input = &GetDocumentationVersionInput{}
	}

	output = &DocumentationVersion{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentationVersion API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDocumentationVersion for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDocumentationVersion(input *GetDocumentationVersionInput) (*DocumentationVersion, error) {
	req, out := c.GetDocumentationVersionRequest(input)
	return out, req.Send()
}

// GetDocumentationVersionWithContext is the same as GetDocumentationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDocumentationVersionWithContext(ctx aws.Context, input *GetDocumentationVersionInput, opts ...request.Option) (*DocumentationVersion, error) {
	req, out := c.GetDocumentationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentationVersions = "GetDocumentationVersions"

// GetDocumentationVersionsRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentationVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentationVersions for more information on using the GetDocumentationVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentationVersionsRequest method.
//    req, resp := client.GetDocumentationVersionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDocumentationVersionsRequest(input *GetDocumentationVersionsInput) (req *request.Request, output *GetDocumentationVersionsOutput) {
	op := &request.Operation{
		Name:       opGetDocumentationVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions",
	}

	if input == nil {
		input = &GetDocumentationVersionsInput{}
	}

	output = &GetDocumentationVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentationVersions API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDocumentationVersions for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDocumentationVersions(input *GetDocumentationVersionsInput) (*GetDocumentationVersionsOutput, error) {
	req, out := c.GetDocumentationVersionsRequest(input)
	return out, req.Send()
}

// GetDocumentationVersionsWithContext is the same as GetDocumentationVersions with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentationVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDocumentationVersionsWithContext(ctx aws.Context, input *GetDocumentationVersionsInput, opts ...request.Option) (*GetDocumentationVersionsOutput, error) {
	req, out := c.GetDocumentationVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainName = "GetDomainName"

// GetDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainName for more information on using the GetDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainNameRequest method.
//    req, resp := client.GetDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDomainNameRequest(input *GetDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opGetDomainName,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &GetDomainNameInput{}
	}

	output = &DomainName{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainName API operation for Amazon API Gateway.
//
// Represents a domain name that is contained in a simpler, more intuitive URL
// that can be called.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDomainName for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDomainName(input *GetDomainNameInput) (*DomainName, error) {
	req, out := c.GetDomainNameRequest(input)
	return out, req.Send()
}

// GetDomainNameWithContext is the same as GetDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDomainNameWithContext(ctx aws.Context, input *GetDomainNameInput, opts ...request.Option) (*DomainName, error) {
	req, out := c.GetDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDomainNames = "GetDomainNames"

// GetDomainNamesRequest generates a "aws/request.Request" representing the
// client's request for the GetDomainNames operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDomainNames for more information on using the GetDomainNames
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDomainNamesRequest method.
//    req, resp := client.GetDomainNamesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetDomainNamesRequest(input *GetDomainNamesInput) (req *request.Request, output *GetDomainNamesOutput) {
	op := &request.Operation{
		Name:       opGetDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDomainNamesInput{}
	}

	output = &GetDomainNamesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDomainNames API operation for Amazon API Gateway.
//
// Represents a collection of DomainName resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetDomainNames for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetDomainNames(input *GetDomainNamesInput) (*GetDomainNamesOutput, error) {
	req, out := c.GetDomainNamesRequest(input)
	return out, req.Send()
}

// GetDomainNamesWithContext is the same as GetDomainNames with the addition of
// the ability to pass a context and additional request options.
//
// See GetDomainNames for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDomainNamesWithContext(ctx aws.Context, input *GetDomainNamesInput, opts ...request.Option) (*GetDomainNamesOutput, error) {
	req, out := c.GetDomainNamesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetDomainNamesPages iterates over the pages of a GetDomainNames operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetDomainNames method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetDomainNames operation.
//    pageNum := 0
//    err := client.GetDomainNamesPages(params,
//        func(page *apigateway.GetDomainNamesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetDomainNamesPages(input *GetDomainNamesInput, fn func(*GetDomainNamesOutput, bool) bool) error {
	return c.GetDomainNamesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetDomainNamesPagesWithContext same as GetDomainNamesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetDomainNamesPagesWithContext(ctx aws.Context, input *GetDomainNamesInput, fn func(*GetDomainNamesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetDomainNamesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetDomainNamesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetDomainNamesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetExport = "GetExport"

// GetExportRequest generates a "aws/request.Request" representing the
// client's request for the GetExport operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExport for more information on using the GetExport
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetExportRequest method.
//    req, resp := client.GetExportRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetExportRequest(input *GetExportInput) (req *request.Request, output *GetExportOutput) {
	op := &request.Operation{
		Name:       opGetExport,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/exports/{export_type}",
	}

	if input == nil {
		input = &GetExportInput{}
	}

	output = &GetExportOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExport API operation for Amazon API Gateway.
//
// Exports a deployed version of a RestApi in a specified format.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetExport for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetExport(input *GetExportInput) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	return out, req.Send()
}

// GetExportWithContext is the same as GetExport with the addition of
// the ability to pass a context and additional request options.
//
// See GetExport for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetExportWithContext(ctx aws.Context, input *GetExportInput, opts ...request.Option) (*GetExportOutput, error) {
	req, out := c.GetExportRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGatewayResponse = "GetGatewayResponse"

// GetGatewayResponseRequest generates a "aws/request.Request" representing the
// client's request for the GetGatewayResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGatewayResponse for more information on using the GetGatewayResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGatewayResponseRequest method.
//    req, resp := client.GetGatewayResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetGatewayResponseRequest(input *GetGatewayResponseInput) (req *request.Request, output *UpdateGatewayResponseOutput) {
	op := &request.Operation{
		Name:       opGetGatewayResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses/{response_type}",
	}

	if input == nil {
		input = &GetGatewayResponseInput{}
	}

	output = &UpdateGatewayResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGatewayResponse API operation for Amazon API Gateway.
//
// Gets a GatewayResponse of a specified response type on the given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetGatewayResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetGatewayResponse(input *GetGatewayResponseInput) (*UpdateGatewayResponseOutput, error) {
	req, out := c.GetGatewayResponseRequest(input)
	return out, req.Send()
}

// GetGatewayResponseWithContext is the same as GetGatewayResponse with the addition of
// the ability to pass a context and additional request options.
//
// See GetGatewayResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetGatewayResponseWithContext(ctx aws.Context, input *GetGatewayResponseInput, opts ...request.Option) (*UpdateGatewayResponseOutput, error) {
	req, out := c.GetGatewayResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGatewayResponses = "GetGatewayResponses"

// GetGatewayResponsesRequest generates a "aws/request.Request" representing the
// client's request for the GetGatewayResponses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGatewayResponses for more information on using the GetGatewayResponses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGatewayResponsesRequest method.
//    req, resp := client.GetGatewayResponsesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetGatewayResponsesRequest(input *GetGatewayResponsesInput) (req *request.Request, output *GetGatewayResponsesOutput) {
	op := &request.Operation{
		Name:       opGetGatewayResponses,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses",
	}

	if input == nil {
		input = &GetGatewayResponsesInput{}
	}

	output = &GetGatewayResponsesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGatewayResponses API operation for Amazon API Gateway.
//
// Gets the GatewayResponses collection on the given RestApi. If an API developer
// has not added any definitions for gateway responses, the result will be the
// API Gateway-generated default GatewayResponses collection for the supported
// response types.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetGatewayResponses for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetGatewayResponses(input *GetGatewayResponsesInput) (*GetGatewayResponsesOutput, error) {
	req, out := c.GetGatewayResponsesRequest(input)
	return out, req.Send()
}

// GetGatewayResponsesWithContext is the same as GetGatewayResponses with the addition of
// the ability to pass a context and additional request options.
//
// See GetGatewayResponses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetGatewayResponsesWithContext(ctx aws.Context, input *GetGatewayResponsesInput, opts ...request.Option) (*GetGatewayResponsesOutput, error) {
	req, out := c.GetGatewayResponsesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegration = "GetIntegration"

// GetIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegration for more information on using the GetIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationRequest method.
//    req, resp := client.GetIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetIntegrationRequest(input *GetIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opGetIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &GetIntegrationInput{}
	}

	output = &Integration{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegration API operation for Amazon API Gateway.
//
// Get the integration settings.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetIntegration(input *GetIntegrationInput) (*Integration, error) {
	req, out := c.GetIntegrationRequest(input)
	return out, req.Send()
}

// GetIntegrationWithContext is the same as GetIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetIntegrationWithContext(ctx aws.Context, input *GetIntegrationInput, opts ...request.Option) (*Integration, error) {
	req, out := c.GetIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIntegrationResponse = "GetIntegrationResponse"

// GetIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the GetIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIntegrationResponse for more information on using the GetIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIntegrationResponseRequest method.
//    req, resp := client.GetIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetIntegrationResponseRequest(input *GetIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opGetIntegrationResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &GetIntegrationResponseInput{}
	}

	output = &IntegrationResponse{}
	req = c.newRequest(op, input, output)
	return
}

// GetIntegrationResponse API operation for Amazon API Gateway.
//
// Represents a get integration response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetIntegrationResponse(input *GetIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.GetIntegrationResponseRequest(input)
	return out, req.Send()
}

// GetIntegrationResponseWithContext is the same as GetIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See GetIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetIntegrationResponseWithContext(ctx aws.Context, input *GetIntegrationResponseInput, opts ...request.Option) (*IntegrationResponse, error) {
	req, out := c.GetIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMethod = "GetMethod"

// GetMethodRequest generates a "aws/request.Request" representing the
// client's request for the GetMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMethod for more information on using the GetMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMethodRequest method.
//    req, resp := client.GetMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetMethodRequest(input *GetMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opGetMethod,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &GetMethodInput{}
	}

	output = &Method{}
	req = c.newRequest(op, input, output)
	return
}

// GetMethod API operation for Amazon API Gateway.
//
// Describe an existing Method resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetMethod for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetMethod(input *GetMethodInput) (*Method, error) {
	req, out := c.GetMethodRequest(input)
	return out, req.Send()
}

// GetMethodWithContext is the same as GetMethod with the addition of
// the ability to pass a context and additional request options.
//
// See GetMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetMethodWithContext(ctx aws.Context, input *GetMethodInput, opts ...request.Option) (*Method, error) {
	req, out := c.GetMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMethodResponse = "GetMethodResponse"

// GetMethodResponseRequest generates a "aws/request.Request" representing the
// client's request for the GetMethodResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMethodResponse for more information on using the GetMethodResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetMethodResponseRequest method.
//    req, resp := client.GetMethodResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetMethodResponseRequest(input *GetMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opGetMethodResponse,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &GetMethodResponseInput{}
	}

	output = &MethodResponse{}
	req = c.newRequest(op, input, output)
	return
}

// GetMethodResponse API operation for Amazon API Gateway.
//
// Describes a MethodResponse resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetMethodResponse for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetMethodResponse(input *GetMethodResponseInput) (*MethodResponse, error) {
	req, out := c.GetMethodResponseRequest(input)
	return out, req.Send()
}

// GetMethodResponseWithContext is the same as GetMethodResponse with the addition of
// the ability to pass a context and additional request options.
//
// See GetMethodResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetMethodResponseWithContext(ctx aws.Context, input *GetMethodResponseInput, opts ...request.Option) (*MethodResponse, error) {
	req, out := c.GetMethodResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModel = "GetModel"

// GetModelRequest generates a "aws/request.Request" representing the
// client's request for the GetModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModel for more information on using the GetModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelRequest method.
//    req, resp := client.GetModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetModelRequest(input *GetModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opGetModel,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &GetModelInput{}
	}

	output = &Model{}
	req = c.newRequest(op, input, output)
	return
}

// GetModel API operation for Amazon API Gateway.
//
// Describes an existing model defined for a RestApi resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetModel(input *GetModelInput) (*Model, error) {
	req, out := c.GetModelRequest(input)
	return out, req.Send()
}

// GetModelWithContext is the same as GetModel with the addition of
// the ability to pass a context and additional request options.
//
// See GetModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetModelWithContext(ctx aws.Context, input *GetModelInput, opts ...request.Option) (*Model, error) {
	req, out := c.GetModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModelTemplate = "GetModelTemplate"

// GetModelTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetModelTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModelTemplate for more information on using the GetModelTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelTemplateRequest method.
//    req, resp := client.GetModelTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetModelTemplateRequest(input *GetModelTemplateInput) (req *request.Request, output *GetModelTemplateOutput) {
	op := &request.Operation{
		Name:       opGetModelTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}/default_template",
	}

	if input == nil {
		input = &GetModelTemplateInput{}
	}

	output = &GetModelTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModelTemplate API operation for Amazon API Gateway.
//
// Generates a sample mapping template that can be used to transform a payload
// into the structure of a model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetModelTemplate for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetModelTemplate(input *GetModelTemplateInput) (*GetModelTemplateOutput, error) {
	req, out := c.GetModelTemplateRequest(input)
	return out, req.Send()
}

// GetModelTemplateWithContext is the same as GetModelTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetModelTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetModelTemplateWithContext(ctx aws.Context, input *GetModelTemplateInput, opts ...request.Option) (*GetModelTemplateOutput, error) {
	req, out := c.GetModelTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetModels = "GetModels"

// GetModelsRequest generates a "aws/request.Request" representing the
// client's request for the GetModels operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetModels for more information on using the GetModels
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetModelsRequest method.
//    req, resp := client.GetModelsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetModelsRequest(input *GetModelsInput) (req *request.Request, output *GetModelsOutput) {
	op := &request.Operation{
		Name:       opGetModels,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/models",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetModelsInput{}
	}

	output = &GetModelsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetModels API operation for Amazon API Gateway.
//
// Describes existing Models defined for a RestApi resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetModels for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetModels(input *GetModelsInput) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	return out, req.Send()
}

// GetModelsWithContext is the same as GetModels with the addition of
// the ability to pass a context and additional request options.
//
// See GetModels for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetModelsWithContext(ctx aws.Context, input *GetModelsInput, opts ...request.Option) (*GetModelsOutput, error) {
	req, out := c.GetModelsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetModelsPages iterates over the pages of a GetModels operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetModels method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetModels operation.
//    pageNum := 0
//    err := client.GetModelsPages(params,
//        func(page *apigateway.GetModelsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetModelsPages(input *GetModelsInput, fn func(*GetModelsOutput, bool) bool) error {
	return c.GetModelsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetModelsPagesWithContext same as GetModelsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetModelsPagesWithContext(ctx aws.Context, input *GetModelsInput, fn func(*GetModelsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetModelsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetModelsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetModelsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetRequestValidator = "GetRequestValidator"

// GetRequestValidatorRequest generates a "aws/request.Request" representing the
// client's request for the GetRequestValidator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRequestValidator for more information on using the GetRequestValidator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRequestValidatorRequest method.
//    req, resp := client.GetRequestValidatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetRequestValidatorRequest(input *GetRequestValidatorInput) (req *request.Request, output *UpdateRequestValidatorOutput) {
	op := &request.Operation{
		Name:       opGetRequestValidator,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
	}

	if input == nil {
		input = &GetRequestValidatorInput{}
	}

	output = &UpdateRequestValidatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRequestValidator API operation for Amazon API Gateway.
//
// Gets a RequestValidator of a given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetRequestValidator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetRequestValidator(input *GetRequestValidatorInput) (*UpdateRequestValidatorOutput, error) {
	req, out := c.GetRequestValidatorRequest(input)
	return out, req.Send()
}

// GetRequestValidatorWithContext is the same as GetRequestValidator with the addition of
// the ability to pass a context and additional request options.
//
// See GetRequestValidator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetRequestValidatorWithContext(ctx aws.Context, input *GetRequestValidatorInput, opts ...request.Option) (*UpdateRequestValidatorOutput, error) {
	req, out := c.GetRequestValidatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRequestValidators = "GetRequestValidators"

// GetRequestValidatorsRequest generates a "aws/request.Request" representing the
// client's request for the GetRequestValidators operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRequestValidators for more information on using the GetRequestValidators
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRequestValidatorsRequest method.
//    req, resp := client.GetRequestValidatorsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetRequestValidatorsRequest(input *GetRequestValidatorsInput) (req *request.Request, output *GetRequestValidatorsOutput) {
	op := &request.Operation{
		Name:       opGetRequestValidators,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators",
	}

	if input == nil {
		input = &GetRequestValidatorsInput{}
	}

	output = &GetRequestValidatorsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRequestValidators API operation for Amazon API Gateway.
//
// Gets the RequestValidators collection of a given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetRequestValidators for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetRequestValidators(input *GetRequestValidatorsInput) (*GetRequestValidatorsOutput, error) {
	req, out := c.GetRequestValidatorsRequest(input)
	return out, req.Send()
}

// GetRequestValidatorsWithContext is the same as GetRequestValidators with the addition of
// the ability to pass a context and additional request options.
//
// See GetRequestValidators for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetRequestValidatorsWithContext(ctx aws.Context, input *GetRequestValidatorsInput, opts ...request.Option) (*GetRequestValidatorsOutput, error) {
	req, out := c.GetRequestValidatorsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResource = "GetResource"

// GetResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResource for more information on using the GetResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourceRequest method.
//    req, resp := client.GetResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetResourceRequest(input *GetResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opGetResource,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &GetResourceInput{}
	}

	output = &Resource{}
	req = c.newRequest(op, input, output)
	return
}

// GetResource API operation for Amazon API Gateway.
//
// Lists information about a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetResource for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetResource(input *GetResourceInput) (*Resource, error) {
	req, out := c.GetResourceRequest(input)
	return out, req.Send()
}

// GetResourceWithContext is the same as GetResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetResourceWithContext(ctx aws.Context, input *GetResourceInput, opts ...request.Option) (*Resource, error) {
	req, out := c.GetResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResources = "GetResources"

// GetResourcesRequest generates a "aws/request.Request" representing the
// client's request for the GetResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResources for more information on using the GetResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetResourcesRequest method.
//    req, resp := client.GetResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetResourcesRequest(input *GetResourcesInput) (req *request.Request, output *GetResourcesOutput) {
	op := &request.Operation{
		Name:       opGetResources,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetResourcesInput{}
	}

	output = &GetResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResources API operation for Amazon API Gateway.
//
// Lists information about a collection of Resource resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetResources for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetResources(input *GetResourcesInput) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	return out, req.Send()
}

// GetResourcesWithContext is the same as GetResources with the addition of
// the ability to pass a context and additional request options.
//
// See GetResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetResourcesWithContext(ctx aws.Context, input *GetResourcesInput, opts ...request.Option) (*GetResourcesOutput, error) {
	req, out := c.GetResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetResourcesPages iterates over the pages of a GetResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetResources operation.
//    pageNum := 0
//    err := client.GetResourcesPages(params,
//        func(page *apigateway.GetResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetResourcesPages(input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool) error {
	return c.GetResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetResourcesPagesWithContext same as GetResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetResourcesPagesWithContext(ctx aws.Context, input *GetResourcesInput, fn func(*GetResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetRestApi = "GetRestApi"

// GetRestApiRequest generates a "aws/request.Request" representing the
// client's request for the GetRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestApi for more information on using the GetRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRestApiRequest method.
//    req, resp := client.GetRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetRestApiRequest(input *GetRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opGetRestApi,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &GetRestApiInput{}
	}

	output = &RestApi{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestApi API operation for Amazon API Gateway.
//
// Lists the RestApi resource in the collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetRestApi(input *GetRestApiInput) (*RestApi, error) {
	req, out := c.GetRestApiRequest(input)
	return out, req.Send()
}

// GetRestApiWithContext is the same as GetRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetRestApiWithContext(ctx aws.Context, input *GetRestApiInput, opts ...request.Option) (*RestApi, error) {
	req, out := c.GetRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRestApis = "GetRestApis"

// GetRestApisRequest generates a "aws/request.Request" representing the
// client's request for the GetRestApis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRestApis for more information on using the GetRestApis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRestApisRequest method.
//    req, resp := client.GetRestApisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetRestApisRequest(input *GetRestApisInput) (req *request.Request, output *GetRestApisOutput) {
	op := &request.Operation{
		Name:       opGetRestApis,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetRestApisInput{}
	}

	output = &GetRestApisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRestApis API operation for Amazon API Gateway.
//
// Lists the RestApis resources for your collection.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetRestApis for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetRestApis(input *GetRestApisInput) (*GetRestApisOutput, error) {
	req, out := c.GetRestApisRequest(input)
	return out, req.Send()
}

// GetRestApisWithContext is the same as GetRestApis with the addition of
// the ability to pass a context and additional request options.
//
// See GetRestApis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetRestApisWithContext(ctx aws.Context, input *GetRestApisInput, opts ...request.Option) (*GetRestApisOutput, error) {
	req, out := c.GetRestApisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetRestApisPages iterates over the pages of a GetRestApis operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetRestApis method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetRestApis operation.
//    pageNum := 0
//    err := client.GetRestApisPages(params,
//        func(page *apigateway.GetRestApisOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetRestApisPages(input *GetRestApisInput, fn func(*GetRestApisOutput, bool) bool) error {
	return c.GetRestApisPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetRestApisPagesWithContext same as GetRestApisPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetRestApisPagesWithContext(ctx aws.Context, input *GetRestApisInput, fn func(*GetRestApisOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetRestApisInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetRestApisRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetRestApisOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetSdk = "GetSdk"

// GetSdkRequest generates a "aws/request.Request" representing the
// client's request for the GetSdk operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSdk for more information on using the GetSdk
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSdkRequest method.
//    req, resp := client.GetSdkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetSdkRequest(input *GetSdkInput) (req *request.Request, output *GetSdkOutput) {
	op := &request.Operation{
		Name:       opGetSdk,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/sdks/{sdk_type}",
	}

	if input == nil {
		input = &GetSdkInput{}
	}

	output = &GetSdkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSdk API operation for Amazon API Gateway.
//
// Generates a client SDK for a RestApi and Stage.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetSdk for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetSdk(input *GetSdkInput) (*GetSdkOutput, error) {
	req, out := c.GetSdkRequest(input)
	return out, req.Send()
}

// GetSdkWithContext is the same as GetSdk with the addition of
// the ability to pass a context and additional request options.
//
// See GetSdk for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetSdkWithContext(ctx aws.Context, input *GetSdkInput, opts ...request.Option) (*GetSdkOutput, error) {
	req, out := c.GetSdkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSdkType = "GetSdkType"

// GetSdkTypeRequest generates a "aws/request.Request" representing the
// client's request for the GetSdkType operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSdkType for more information on using the GetSdkType
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSdkTypeRequest method.
//    req, resp := client.GetSdkTypeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetSdkTypeRequest(input *GetSdkTypeInput) (req *request.Request, output *SdkType) {
	op := &request.Operation{
		Name:       opGetSdkType,
		HTTPMethod: "GET",
		HTTPPath:   "/sdktypes/{sdktype_id}",
	}

	if input == nil {
		input = &GetSdkTypeInput{}
	}

	output = &SdkType{}
	req = c.newRequest(op, input, output)
	return
}

// GetSdkType API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetSdkType for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetSdkType(input *GetSdkTypeInput) (*SdkType, error) {
	req, out := c.GetSdkTypeRequest(input)
	return out, req.Send()
}

// GetSdkTypeWithContext is the same as GetSdkType with the addition of
// the ability to pass a context and additional request options.
//
// See GetSdkType for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetSdkTypeWithContext(ctx aws.Context, input *GetSdkTypeInput, opts ...request.Option) (*SdkType, error) {
	req, out := c.GetSdkTypeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSdkTypes = "GetSdkTypes"

// GetSdkTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetSdkTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSdkTypes for more information on using the GetSdkTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSdkTypesRequest method.
//    req, resp := client.GetSdkTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetSdkTypesRequest(input *GetSdkTypesInput) (req *request.Request, output *GetSdkTypesOutput) {
	op := &request.Operation{
		Name:       opGetSdkTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/sdktypes",
	}

	if input == nil {
		input = &GetSdkTypesInput{}
	}

	output = &GetSdkTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSdkTypes API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetSdkTypes for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetSdkTypes(input *GetSdkTypesInput) (*GetSdkTypesOutput, error) {
	req, out := c.GetSdkTypesRequest(input)
	return out, req.Send()
}

// GetSdkTypesWithContext is the same as GetSdkTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetSdkTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetSdkTypesWithContext(ctx aws.Context, input *GetSdkTypesInput, opts ...request.Option) (*GetSdkTypesOutput, error) {
	req, out := c.GetSdkTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStage = "GetStage"

// GetStageRequest generates a "aws/request.Request" representing the
// client's request for the GetStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStage for more information on using the GetStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStageRequest method.
//    req, resp := client.GetStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetStageRequest(input *GetStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opGetStage,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &GetStageInput{}
	}

	output = &Stage{}
	req = c.newRequest(op, input, output)
	return
}

// GetStage API operation for Amazon API Gateway.
//
// Gets information about a Stage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetStage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetStage(input *GetStageInput) (*Stage, error) {
	req, out := c.GetStageRequest(input)
	return out, req.Send()
}

// GetStageWithContext is the same as GetStage with the addition of
// the ability to pass a context and additional request options.
//
// See GetStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetStageWithContext(ctx aws.Context, input *GetStageInput, opts ...request.Option) (*Stage, error) {
	req, out := c.GetStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetStages = "GetStages"

// GetStagesRequest generates a "aws/request.Request" representing the
// client's request for the GetStages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetStages for more information on using the GetStages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetStagesRequest method.
//    req, resp := client.GetStagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetStagesRequest(input *GetStagesInput) (req *request.Request, output *GetStagesOutput) {
	op := &request.Operation{
		Name:       opGetStages,
		HTTPMethod: "GET",
		HTTPPath:   "/restapis/{restapi_id}/stages",
	}

	if input == nil {
		input = &GetStagesInput{}
	}

	output = &GetStagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetStages API operation for Amazon API Gateway.
//
// Gets information about one or more Stage resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetStages for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetStages(input *GetStagesInput) (*GetStagesOutput, error) {
	req, out := c.GetStagesRequest(input)
	return out, req.Send()
}

// GetStagesWithContext is the same as GetStages with the addition of
// the ability to pass a context and additional request options.
//
// See GetStages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetStagesWithContext(ctx aws.Context, input *GetStagesInput, opts ...request.Option) (*GetStagesOutput, error) {
	req, out := c.GetStagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTags = "GetTags"

// GetTagsRequest generates a "aws/request.Request" representing the
// client's request for the GetTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTags for more information on using the GetTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetTagsRequest method.
//    req, resp := client.GetTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetTagsRequest(input *GetTagsInput) (req *request.Request, output *GetTagsOutput) {
	op := &request.Operation{
		Name:       opGetTags,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resource_arn}",
	}

	if input == nil {
		input = &GetTagsInput{}
	}

	output = &GetTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTags API operation for Amazon API Gateway.
//
// Gets the Tags collection for a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetTags for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetTags(input *GetTagsInput) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	return out, req.Send()
}

// GetTagsWithContext is the same as GetTags with the addition of
// the ability to pass a context and additional request options.
//
// See GetTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetTagsWithContext(ctx aws.Context, input *GetTagsInput, opts ...request.Option) (*GetTagsOutput, error) {
	req, out := c.GetTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsage = "GetUsage"

// GetUsageRequest generates a "aws/request.Request" representing the
// client's request for the GetUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsage for more information on using the GetUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsageRequest method.
//    req, resp := client.GetUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetUsageRequest(input *GetUsageInput) (req *request.Request, output *Usage) {
	op := &request.Operation{
		Name:       opGetUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans/{usageplanId}/usage",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsageInput{}
	}

	output = &Usage{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsage API operation for Amazon API Gateway.
//
// Gets the usage data of a usage plan in a specified time interval.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetUsage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetUsage(input *GetUsageInput) (*Usage, error) {
	req, out := c.GetUsageRequest(input)
	return out, req.Send()
}

// GetUsageWithContext is the same as GetUsage with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsageWithContext(ctx aws.Context, input *GetUsageInput, opts ...request.Option) (*Usage, error) {
	req, out := c.GetUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUsagePages iterates over the pages of a GetUsage operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUsage method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUsage operation.
//    pageNum := 0
//    err := client.GetUsagePages(params,
//        func(page *apigateway.Usage, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetUsagePages(input *GetUsageInput, fn func(*Usage, bool) bool) error {
	return c.GetUsagePagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUsagePagesWithContext same as GetUsagePages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePagesWithContext(ctx aws.Context, input *GetUsageInput, fn func(*Usage, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUsageInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUsageRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*Usage), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUsagePlan = "GetUsagePlan"

// GetUsagePlanRequest generates a "aws/request.Request" representing the
// client's request for the GetUsagePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsagePlan for more information on using the GetUsagePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsagePlanRequest method.
//    req, resp := client.GetUsagePlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetUsagePlanRequest(input *GetUsagePlanInput) (req *request.Request, output *UsagePlan) {
	op := &request.Operation{
		Name:       opGetUsagePlan,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans/{usageplanId}",
	}

	if input == nil {
		input = &GetUsagePlanInput{}
	}

	output = &UsagePlan{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsagePlan API operation for Amazon API Gateway.
//
// Gets a usage plan of a given plan identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetUsagePlan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetUsagePlan(input *GetUsagePlanInput) (*UsagePlan, error) {
	req, out := c.GetUsagePlanRequest(input)
	return out, req.Send()
}

// GetUsagePlanWithContext is the same as GetUsagePlan with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsagePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlanWithContext(ctx aws.Context, input *GetUsagePlanInput, opts ...request.Option) (*UsagePlan, error) {
	req, out := c.GetUsagePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsagePlanKey = "GetUsagePlanKey"

// GetUsagePlanKeyRequest generates a "aws/request.Request" representing the
// client's request for the GetUsagePlanKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsagePlanKey for more information on using the GetUsagePlanKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsagePlanKeyRequest method.
//    req, resp := client.GetUsagePlanKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetUsagePlanKeyRequest(input *GetUsagePlanKeyInput) (req *request.Request, output *UsagePlanKey) {
	op := &request.Operation{
		Name:       opGetUsagePlanKey,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans/{usageplanId}/keys/{keyId}",
	}

	if input == nil {
		input = &GetUsagePlanKeyInput{}
	}

	output = &UsagePlanKey{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsagePlanKey API operation for Amazon API Gateway.
//
// Gets a usage plan key of a given key identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetUsagePlanKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetUsagePlanKey(input *GetUsagePlanKeyInput) (*UsagePlanKey, error) {
	req, out := c.GetUsagePlanKeyRequest(input)
	return out, req.Send()
}

// GetUsagePlanKeyWithContext is the same as GetUsagePlanKey with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsagePlanKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlanKeyWithContext(ctx aws.Context, input *GetUsagePlanKeyInput, opts ...request.Option) (*UsagePlanKey, error) {
	req, out := c.GetUsagePlanKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsagePlanKeys = "GetUsagePlanKeys"

// GetUsagePlanKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetUsagePlanKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsagePlanKeys for more information on using the GetUsagePlanKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsagePlanKeysRequest method.
//    req, resp := client.GetUsagePlanKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetUsagePlanKeysRequest(input *GetUsagePlanKeysInput) (req *request.Request, output *GetUsagePlanKeysOutput) {
	op := &request.Operation{
		Name:       opGetUsagePlanKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans/{usageplanId}/keys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsagePlanKeysInput{}
	}

	output = &GetUsagePlanKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsagePlanKeys API operation for Amazon API Gateway.
//
// Gets all the usage plan keys representing the API keys added to a specified
// usage plan.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetUsagePlanKeys for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetUsagePlanKeys(input *GetUsagePlanKeysInput) (*GetUsagePlanKeysOutput, error) {
	req, out := c.GetUsagePlanKeysRequest(input)
	return out, req.Send()
}

// GetUsagePlanKeysWithContext is the same as GetUsagePlanKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsagePlanKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlanKeysWithContext(ctx aws.Context, input *GetUsagePlanKeysInput, opts ...request.Option) (*GetUsagePlanKeysOutput, error) {
	req, out := c.GetUsagePlanKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUsagePlanKeysPages iterates over the pages of a GetUsagePlanKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUsagePlanKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUsagePlanKeys operation.
//    pageNum := 0
//    err := client.GetUsagePlanKeysPages(params,
//        func(page *apigateway.GetUsagePlanKeysOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetUsagePlanKeysPages(input *GetUsagePlanKeysInput, fn func(*GetUsagePlanKeysOutput, bool) bool) error {
	return c.GetUsagePlanKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUsagePlanKeysPagesWithContext same as GetUsagePlanKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlanKeysPagesWithContext(ctx aws.Context, input *GetUsagePlanKeysInput, fn func(*GetUsagePlanKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUsagePlanKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUsagePlanKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUsagePlanKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetUsagePlans = "GetUsagePlans"

// GetUsagePlansRequest generates a "aws/request.Request" representing the
// client's request for the GetUsagePlans operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsagePlans for more information on using the GetUsagePlans
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetUsagePlansRequest method.
//    req, resp := client.GetUsagePlansRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetUsagePlansRequest(input *GetUsagePlansInput) (req *request.Request, output *GetUsagePlansOutput) {
	op := &request.Operation{
		Name:       opGetUsagePlans,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsagePlansInput{}
	}

	output = &GetUsagePlansOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsagePlans API operation for Amazon API Gateway.
//
// Gets all the usage plans of the caller's account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetUsagePlans for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetUsagePlans(input *GetUsagePlansInput) (*GetUsagePlansOutput, error) {
	req, out := c.GetUsagePlansRequest(input)
	return out, req.Send()
}

// GetUsagePlansWithContext is the same as GetUsagePlans with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsagePlans for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlansWithContext(ctx aws.Context, input *GetUsagePlansInput, opts ...request.Option) (*GetUsagePlansOutput, error) {
	req, out := c.GetUsagePlansRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetUsagePlansPages iterates over the pages of a GetUsagePlans operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetUsagePlans method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetUsagePlans operation.
//    pageNum := 0
//    err := client.GetUsagePlansPages(params,
//        func(page *apigateway.GetUsagePlansOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetUsagePlansPages(input *GetUsagePlansInput, fn func(*GetUsagePlansOutput, bool) bool) error {
	return c.GetUsagePlansPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetUsagePlansPagesWithContext same as GetUsagePlansPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetUsagePlansPagesWithContext(ctx aws.Context, input *GetUsagePlansInput, fn func(*GetUsagePlansOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetUsagePlansInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetUsagePlansRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetUsagePlansOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetVpcLink = "GetVpcLink"

// GetVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the GetVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVpcLink for more information on using the GetVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVpcLinkRequest method.
//    req, resp := client.GetVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetVpcLinkRequest(input *GetVpcLinkInput) (req *request.Request, output *UpdateVpcLinkOutput) {
	op := &request.Operation{
		Name:       opGetVpcLink,
		HTTPMethod: "GET",
		HTTPPath:   "/vpclinks/{vpclink_id}",
	}

	if input == nil {
		input = &GetVpcLinkInput{}
	}

	output = &UpdateVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVpcLink API operation for Amazon API Gateway.
//
// Gets a specified VPC link under the caller's account in a region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetVpcLink for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetVpcLink(input *GetVpcLinkInput) (*UpdateVpcLinkOutput, error) {
	req, out := c.GetVpcLinkRequest(input)
	return out, req.Send()
}

// GetVpcLinkWithContext is the same as GetVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See GetVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetVpcLinkWithContext(ctx aws.Context, input *GetVpcLinkInput, opts ...request.Option) (*UpdateVpcLinkOutput, error) {
	req, out := c.GetVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetVpcLinks = "GetVpcLinks"

// GetVpcLinksRequest generates a "aws/request.Request" representing the
// client's request for the GetVpcLinks operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetVpcLinks for more information on using the GetVpcLinks
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetVpcLinksRequest method.
//    req, resp := client.GetVpcLinksRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) GetVpcLinksRequest(input *GetVpcLinksInput) (req *request.Request, output *GetVpcLinksOutput) {
	op := &request.Operation{
		Name:       opGetVpcLinks,
		HTTPMethod: "GET",
		HTTPPath:   "/vpclinks",
		Paginator: &request.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetVpcLinksInput{}
	}

	output = &GetVpcLinksOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetVpcLinks API operation for Amazon API Gateway.
//
// Gets the VpcLinks collection under the caller's account in a selected region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation GetVpcLinks for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) GetVpcLinks(input *GetVpcLinksInput) (*GetVpcLinksOutput, error) {
	req, out := c.GetVpcLinksRequest(input)
	return out, req.Send()
}

// GetVpcLinksWithContext is the same as GetVpcLinks with the addition of
// the ability to pass a context and additional request options.
//
// See GetVpcLinks for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetVpcLinksWithContext(ctx aws.Context, input *GetVpcLinksInput, opts ...request.Option) (*GetVpcLinksOutput, error) {
	req, out := c.GetVpcLinksRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetVpcLinksPages iterates over the pages of a GetVpcLinks operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetVpcLinks method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a GetVpcLinks operation.
//    pageNum := 0
//    err := client.GetVpcLinksPages(params,
//        func(page *apigateway.GetVpcLinksOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *APIGateway) GetVpcLinksPages(input *GetVpcLinksInput, fn func(*GetVpcLinksOutput, bool) bool) error {
	return c.GetVpcLinksPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetVpcLinksPagesWithContext same as GetVpcLinksPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) GetVpcLinksPagesWithContext(ctx aws.Context, input *GetVpcLinksInput, fn func(*GetVpcLinksOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetVpcLinksInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetVpcLinksRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetVpcLinksOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opImportApiKeys = "ImportApiKeys"

// ImportApiKeysRequest generates a "aws/request.Request" representing the
// client's request for the ImportApiKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportApiKeys for more information on using the ImportApiKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportApiKeysRequest method.
//    req, resp := client.ImportApiKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) ImportApiKeysRequest(input *ImportApiKeysInput) (req *request.Request, output *ImportApiKeysOutput) {
	op := &request.Operation{
		Name:       opImportApiKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/apikeys?mode=import",
	}

	if input == nil {
		input = &ImportApiKeysInput{}
	}

	output = &ImportApiKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportApiKeys API operation for Amazon API Gateway.
//
// Import API keys from an external source, such as a CSV-formatted file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation ImportApiKeys for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) ImportApiKeys(input *ImportApiKeysInput) (*ImportApiKeysOutput, error) {
	req, out := c.ImportApiKeysRequest(input)
	return out, req.Send()
}

// ImportApiKeysWithContext is the same as ImportApiKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ImportApiKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) ImportApiKeysWithContext(ctx aws.Context, input *ImportApiKeysInput, opts ...request.Option) (*ImportApiKeysOutput, error) {
	req, out := c.ImportApiKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportDocumentationParts = "ImportDocumentationParts"

// ImportDocumentationPartsRequest generates a "aws/request.Request" representing the
// client's request for the ImportDocumentationParts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportDocumentationParts for more information on using the ImportDocumentationParts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportDocumentationPartsRequest method.
//    req, resp := client.ImportDocumentationPartsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) ImportDocumentationPartsRequest(input *ImportDocumentationPartsInput) (req *request.Request, output *ImportDocumentationPartsOutput) {
	op := &request.Operation{
		Name:       opImportDocumentationParts,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts",
	}

	if input == nil {
		input = &ImportDocumentationPartsInput{}
	}

	output = &ImportDocumentationPartsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportDocumentationParts API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation ImportDocumentationParts for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) ImportDocumentationParts(input *ImportDocumentationPartsInput) (*ImportDocumentationPartsOutput, error) {
	req, out := c.ImportDocumentationPartsRequest(input)
	return out, req.Send()
}

// ImportDocumentationPartsWithContext is the same as ImportDocumentationParts with the addition of
// the ability to pass a context and additional request options.
//
// See ImportDocumentationParts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) ImportDocumentationPartsWithContext(ctx aws.Context, input *ImportDocumentationPartsInput, opts ...request.Option) (*ImportDocumentationPartsOutput, error) {
	req, out := c.ImportDocumentationPartsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportRestApi = "ImportRestApi"

// ImportRestApiRequest generates a "aws/request.Request" representing the
// client's request for the ImportRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportRestApi for more information on using the ImportRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportRestApiRequest method.
//    req, resp := client.ImportRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) ImportRestApiRequest(input *ImportRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opImportRestApi,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis?mode=import",
	}

	if input == nil {
		input = &ImportRestApiInput{}
	}

	output = &RestApi{}
	req = c.newRequest(op, input, output)
	return
}

// ImportRestApi API operation for Amazon API Gateway.
//
// A feature of the API Gateway control service for creating a new API from
// an external API definition file.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation ImportRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) ImportRestApi(input *ImportRestApiInput) (*RestApi, error) {
	req, out := c.ImportRestApiRequest(input)
	return out, req.Send()
}

// ImportRestApiWithContext is the same as ImportRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See ImportRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) ImportRestApiWithContext(ctx aws.Context, input *ImportRestApiInput, opts ...request.Option) (*RestApi, error) {
	req, out := c.ImportRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutGatewayResponse = "PutGatewayResponse"

// PutGatewayResponseRequest generates a "aws/request.Request" representing the
// client's request for the PutGatewayResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutGatewayResponse for more information on using the PutGatewayResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutGatewayResponseRequest method.
//    req, resp := client.PutGatewayResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutGatewayResponseRequest(input *PutGatewayResponseInput) (req *request.Request, output *UpdateGatewayResponseOutput) {
	op := &request.Operation{
		Name:       opPutGatewayResponse,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses/{response_type}",
	}

	if input == nil {
		input = &PutGatewayResponseInput{}
	}

	output = &UpdateGatewayResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutGatewayResponse API operation for Amazon API Gateway.
//
// Creates a customization of a GatewayResponse of a specified response type
// and status code on the given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutGatewayResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutGatewayResponse(input *PutGatewayResponseInput) (*UpdateGatewayResponseOutput, error) {
	req, out := c.PutGatewayResponseRequest(input)
	return out, req.Send()
}

// PutGatewayResponseWithContext is the same as PutGatewayResponse with the addition of
// the ability to pass a context and additional request options.
//
// See PutGatewayResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutGatewayResponseWithContext(ctx aws.Context, input *PutGatewayResponseInput, opts ...request.Option) (*UpdateGatewayResponseOutput, error) {
	req, out := c.PutGatewayResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIntegration = "PutIntegration"

// PutIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the PutIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIntegration for more information on using the PutIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutIntegrationRequest method.
//    req, resp := client.PutIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutIntegrationRequest(input *PutIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opPutIntegration,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &PutIntegrationInput{}
	}

	output = &Integration{}
	req = c.newRequest(op, input, output)
	return
}

// PutIntegration API operation for Amazon API Gateway.
//
// Sets up a method's integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutIntegration(input *PutIntegrationInput) (*Integration, error) {
	req, out := c.PutIntegrationRequest(input)
	return out, req.Send()
}

// PutIntegrationWithContext is the same as PutIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See PutIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutIntegrationWithContext(ctx aws.Context, input *PutIntegrationInput, opts ...request.Option) (*Integration, error) {
	req, out := c.PutIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutIntegrationResponse = "PutIntegrationResponse"

// PutIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the PutIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutIntegrationResponse for more information on using the PutIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutIntegrationResponseRequest method.
//    req, resp := client.PutIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutIntegrationResponseRequest(input *PutIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opPutIntegrationResponse,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &PutIntegrationResponseInput{}
	}

	output = &IntegrationResponse{}
	req = c.newRequest(op, input, output)
	return
}

// PutIntegrationResponse API operation for Amazon API Gateway.
//
// Represents a put integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutIntegrationResponse(input *PutIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.PutIntegrationResponseRequest(input)
	return out, req.Send()
}

// PutIntegrationResponseWithContext is the same as PutIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See PutIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutIntegrationResponseWithContext(ctx aws.Context, input *PutIntegrationResponseInput, opts ...request.Option) (*IntegrationResponse, error) {
	req, out := c.PutIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMethod = "PutMethod"

// PutMethodRequest generates a "aws/request.Request" representing the
// client's request for the PutMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMethod for more information on using the PutMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMethodRequest method.
//    req, resp := client.PutMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutMethodRequest(input *PutMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opPutMethod,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &PutMethodInput{}
	}

	output = &Method{}
	req = c.newRequest(op, input, output)
	return
}

// PutMethod API operation for Amazon API Gateway.
//
// Add a method to an existing Resource resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutMethod for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutMethod(input *PutMethodInput) (*Method, error) {
	req, out := c.PutMethodRequest(input)
	return out, req.Send()
}

// PutMethodWithContext is the same as PutMethod with the addition of
// the ability to pass a context and additional request options.
//
// See PutMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutMethodWithContext(ctx aws.Context, input *PutMethodInput, opts ...request.Option) (*Method, error) {
	req, out := c.PutMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutMethodResponse = "PutMethodResponse"

// PutMethodResponseRequest generates a "aws/request.Request" representing the
// client's request for the PutMethodResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutMethodResponse for more information on using the PutMethodResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutMethodResponseRequest method.
//    req, resp := client.PutMethodResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutMethodResponseRequest(input *PutMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opPutMethodResponse,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &PutMethodResponseInput{}
	}

	output = &MethodResponse{}
	req = c.newRequest(op, input, output)
	return
}

// PutMethodResponse API operation for Amazon API Gateway.
//
// Adds a MethodResponse to an existing Method resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutMethodResponse for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutMethodResponse(input *PutMethodResponseInput) (*MethodResponse, error) {
	req, out := c.PutMethodResponseRequest(input)
	return out, req.Send()
}

// PutMethodResponseWithContext is the same as PutMethodResponse with the addition of
// the ability to pass a context and additional request options.
//
// See PutMethodResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutMethodResponseWithContext(ctx aws.Context, input *PutMethodResponseInput, opts ...request.Option) (*MethodResponse, error) {
	req, out := c.PutMethodResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutRestApi = "PutRestApi"

// PutRestApiRequest generates a "aws/request.Request" representing the
// client's request for the PutRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutRestApi for more information on using the PutRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutRestApiRequest method.
//    req, resp := client.PutRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) PutRestApiRequest(input *PutRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opPutRestApi,
		HTTPMethod: "PUT",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &PutRestApiInput{}
	}

	output = &RestApi{}
	req = c.newRequest(op, input, output)
	return
}

// PutRestApi API operation for Amazon API Gateway.
//
// A feature of the API Gateway control service for updating an existing API
// with an input of external API definitions. The update can take the form of
// merging the supplied definition into the existing API or overwriting the
// existing API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation PutRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) PutRestApi(input *PutRestApiInput) (*RestApi, error) {
	req, out := c.PutRestApiRequest(input)
	return out, req.Send()
}

// PutRestApiWithContext is the same as PutRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See PutRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) PutRestApiWithContext(ctx aws.Context, input *PutRestApiInput, opts ...request.Option) (*RestApi, error) {
	req, out := c.PutRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/tags/{resource_arn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon API Gateway.
//
// Adds or updates a tag on a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestInvokeAuthorizer = "TestInvokeAuthorizer"

// TestInvokeAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the TestInvokeAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestInvokeAuthorizer for more information on using the TestInvokeAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestInvokeAuthorizerRequest method.
//    req, resp := client.TestInvokeAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) TestInvokeAuthorizerRequest(input *TestInvokeAuthorizerInput) (req *request.Request, output *TestInvokeAuthorizerOutput) {
	op := &request.Operation{
		Name:       opTestInvokeAuthorizer,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/authorizers/{authorizer_id}",
	}

	if input == nil {
		input = &TestInvokeAuthorizerInput{}
	}

	output = &TestInvokeAuthorizerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestInvokeAuthorizer API operation for Amazon API Gateway.
//
// Simulate the execution of an Authorizer in your RestApi with headers, parameters,
// and an incoming request body.
//
// Use Lambda Function as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html)
// Use Cognito User Pool as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation TestInvokeAuthorizer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) TestInvokeAuthorizer(input *TestInvokeAuthorizerInput) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	return out, req.Send()
}

// TestInvokeAuthorizerWithContext is the same as TestInvokeAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See TestInvokeAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) TestInvokeAuthorizerWithContext(ctx aws.Context, input *TestInvokeAuthorizerInput, opts ...request.Option) (*TestInvokeAuthorizerOutput, error) {
	req, out := c.TestInvokeAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTestInvokeMethod = "TestInvokeMethod"

// TestInvokeMethodRequest generates a "aws/request.Request" representing the
// client's request for the TestInvokeMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TestInvokeMethod for more information on using the TestInvokeMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TestInvokeMethodRequest method.
//    req, resp := client.TestInvokeMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) TestInvokeMethodRequest(input *TestInvokeMethodInput) (req *request.Request, output *TestInvokeMethodOutput) {
	op := &request.Operation{
		Name:       opTestInvokeMethod,
		HTTPMethod: "POST",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &TestInvokeMethodInput{}
	}

	output = &TestInvokeMethodOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TestInvokeMethod API operation for Amazon API Gateway.
//
// Simulate the execution of a Method in your RestApi with headers, parameters,
// and an incoming request body.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation TestInvokeMethod for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) TestInvokeMethod(input *TestInvokeMethodInput) (*TestInvokeMethodOutput, error) {
	req, out := c.TestInvokeMethodRequest(input)
	return out, req.Send()
}

// TestInvokeMethodWithContext is the same as TestInvokeMethod with the addition of
// the ability to pass a context and additional request options.
//
// See TestInvokeMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) TestInvokeMethodWithContext(ctx aws.Context, input *TestInvokeMethodInput, opts ...request.Option) (*TestInvokeMethodOutput, error) {
	req, out := c.TestInvokeMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resource_arn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon API Gateway.
//
// Removes a tag from a given resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAccount = "UpdateAccount"

// UpdateAccountRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAccount for more information on using the UpdateAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAccountRequest method.
//    req, resp := client.UpdateAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateAccountRequest(input *UpdateAccountInput) (req *request.Request, output *Account) {
	op := &request.Operation{
		Name:       opUpdateAccount,
		HTTPMethod: "PATCH",
		HTTPPath:   "/account",
	}

	if input == nil {
		input = &UpdateAccountInput{}
	}

	output = &Account{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAccount API operation for Amazon API Gateway.
//
// Changes information about the current Account resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateAccount for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateAccount(input *UpdateAccountInput) (*Account, error) {
	req, out := c.UpdateAccountRequest(input)
	return out, req.Send()
}

// UpdateAccountWithContext is the same as UpdateAccount with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateAccountWithContext(ctx aws.Context, input *UpdateAccountInput, opts ...request.Option) (*Account, error) {
	req, out := c.UpdateAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApiKey = "UpdateApiKey"

// UpdateApiKeyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApiKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApiKey for more information on using the UpdateApiKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApiKeyRequest method.
//    req, resp := client.UpdateApiKeyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateApiKeyRequest(input *UpdateApiKeyInput) (req *request.Request, output *ApiKey) {
	op := &request.Operation{
		Name:       opUpdateApiKey,
		HTTPMethod: "PATCH",
		HTTPPath:   "/apikeys/{api_Key}",
	}

	if input == nil {
		input = &UpdateApiKeyInput{}
	}

	output = &ApiKey{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApiKey API operation for Amazon API Gateway.
//
// Changes information about an ApiKey resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateApiKey for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateApiKey(input *UpdateApiKeyInput) (*ApiKey, error) {
	req, out := c.UpdateApiKeyRequest(input)
	return out, req.Send()
}

// UpdateApiKeyWithContext is the same as UpdateApiKey with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApiKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateApiKeyWithContext(ctx aws.Context, input *UpdateApiKeyInput, opts ...request.Option) (*ApiKey, error) {
	req, out := c.UpdateApiKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAuthorizer = "UpdateAuthorizer"

// UpdateAuthorizerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAuthorizer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAuthorizer for more information on using the UpdateAuthorizer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAuthorizerRequest method.
//    req, resp := client.UpdateAuthorizerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateAuthorizerRequest(input *UpdateAuthorizerInput) (req *request.Request, output *Authorizer) {
	op := &request.Operation{
		Name:       opUpdateAuthorizer,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/authorizers/{authorizer_id}",
	}

	if input == nil {
		input = &UpdateAuthorizerInput{}
	}

	output = &Authorizer{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAuthorizer API operation for Amazon API Gateway.
//
// Updates an existing Authorizer resource.
//
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/update-authorizer.html)
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateAuthorizer for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateAuthorizer(input *UpdateAuthorizerInput) (*Authorizer, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	return out, req.Send()
}

// UpdateAuthorizerWithContext is the same as UpdateAuthorizer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAuthorizer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateAuthorizerWithContext(ctx aws.Context, input *UpdateAuthorizerInput, opts ...request.Option) (*Authorizer, error) {
	req, out := c.UpdateAuthorizerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateBasePathMapping = "UpdateBasePathMapping"

// UpdateBasePathMappingRequest generates a "aws/request.Request" representing the
// client's request for the UpdateBasePathMapping operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateBasePathMapping for more information on using the UpdateBasePathMapping
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateBasePathMappingRequest method.
//    req, resp := client.UpdateBasePathMappingRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateBasePathMappingRequest(input *UpdateBasePathMappingInput) (req *request.Request, output *BasePathMapping) {
	op := &request.Operation{
		Name:       opUpdateBasePathMapping,
		HTTPMethod: "PATCH",
		HTTPPath:   "/domainnames/{domain_name}/basepathmappings/{base_path}",
	}

	if input == nil {
		input = &UpdateBasePathMappingInput{}
	}

	output = &BasePathMapping{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateBasePathMapping API operation for Amazon API Gateway.
//
// Changes information about the BasePathMapping resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateBasePathMapping for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateBasePathMapping(input *UpdateBasePathMappingInput) (*BasePathMapping, error) {
	req, out := c.UpdateBasePathMappingRequest(input)
	return out, req.Send()
}

// UpdateBasePathMappingWithContext is the same as UpdateBasePathMapping with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateBasePathMapping for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateBasePathMappingWithContext(ctx aws.Context, input *UpdateBasePathMappingInput, opts ...request.Option) (*BasePathMapping, error) {
	req, out := c.UpdateBasePathMappingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateClientCertificate = "UpdateClientCertificate"

// UpdateClientCertificateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateClientCertificate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateClientCertificate for more information on using the UpdateClientCertificate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateClientCertificateRequest method.
//    req, resp := client.UpdateClientCertificateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateClientCertificateRequest(input *UpdateClientCertificateInput) (req *request.Request, output *ClientCertificate) {
	op := &request.Operation{
		Name:       opUpdateClientCertificate,
		HTTPMethod: "PATCH",
		HTTPPath:   "/clientcertificates/{clientcertificate_id}",
	}

	if input == nil {
		input = &UpdateClientCertificateInput{}
	}

	output = &ClientCertificate{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateClientCertificate API operation for Amazon API Gateway.
//
// Changes information about an ClientCertificate resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateClientCertificate for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateClientCertificate(input *UpdateClientCertificateInput) (*ClientCertificate, error) {
	req, out := c.UpdateClientCertificateRequest(input)
	return out, req.Send()
}

// UpdateClientCertificateWithContext is the same as UpdateClientCertificate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateClientCertificate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateClientCertificateWithContext(ctx aws.Context, input *UpdateClientCertificateInput, opts ...request.Option) (*ClientCertificate, error) {
	req, out := c.UpdateClientCertificateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDeployment = "UpdateDeployment"

// UpdateDeploymentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDeployment operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDeployment for more information on using the UpdateDeployment
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDeploymentRequest method.
//    req, resp := client.UpdateDeploymentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateDeploymentRequest(input *UpdateDeploymentInput) (req *request.Request, output *Deployment) {
	op := &request.Operation{
		Name:       opUpdateDeployment,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/deployments/{deployment_id}",
	}

	if input == nil {
		input = &UpdateDeploymentInput{}
	}

	output = &Deployment{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDeployment API operation for Amazon API Gateway.
//
// Changes information about a Deployment resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateDeployment for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
//   * ServiceUnavailableException
//   The requested service is not available. For details see the accompanying
//   error message. Retry after the specified time period.
//
func (c *APIGateway) UpdateDeployment(input *UpdateDeploymentInput) (*Deployment, error) {
	req, out := c.UpdateDeploymentRequest(input)
	return out, req.Send()
}

// UpdateDeploymentWithContext is the same as UpdateDeployment with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDeployment for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateDeploymentWithContext(ctx aws.Context, input *UpdateDeploymentInput, opts ...request.Option) (*Deployment, error) {
	req, out := c.UpdateDeploymentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentationPart = "UpdateDocumentationPart"

// UpdateDocumentationPartRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentationPart operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentationPart for more information on using the UpdateDocumentationPart
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentationPartRequest method.
//    req, resp := client.UpdateDocumentationPartRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateDocumentationPartRequest(input *UpdateDocumentationPartInput) (req *request.Request, output *DocumentationPart) {
	op := &request.Operation{
		Name:       opUpdateDocumentationPart,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/documentation/parts/{part_id}",
	}

	if input == nil {
		input = &UpdateDocumentationPartInput{}
	}

	output = &DocumentationPart{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocumentationPart API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateDocumentationPart for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateDocumentationPart(input *UpdateDocumentationPartInput) (*DocumentationPart, error) {
	req, out := c.UpdateDocumentationPartRequest(input)
	return out, req.Send()
}

// UpdateDocumentationPartWithContext is the same as UpdateDocumentationPart with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentationPart for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateDocumentationPartWithContext(ctx aws.Context, input *UpdateDocumentationPartInput, opts ...request.Option) (*DocumentationPart, error) {
	req, out := c.UpdateDocumentationPartRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDocumentationVersion = "UpdateDocumentationVersion"

// UpdateDocumentationVersionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDocumentationVersion operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDocumentationVersion for more information on using the UpdateDocumentationVersion
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDocumentationVersionRequest method.
//    req, resp := client.UpdateDocumentationVersionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateDocumentationVersionRequest(input *UpdateDocumentationVersionInput) (req *request.Request, output *DocumentationVersion) {
	op := &request.Operation{
		Name:       opUpdateDocumentationVersion,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/documentation/versions/{doc_version}",
	}

	if input == nil {
		input = &UpdateDocumentationVersionInput{}
	}

	output = &DocumentationVersion{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDocumentationVersion API operation for Amazon API Gateway.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateDocumentationVersion for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateDocumentationVersion(input *UpdateDocumentationVersionInput) (*DocumentationVersion, error) {
	req, out := c.UpdateDocumentationVersionRequest(input)
	return out, req.Send()
}

// UpdateDocumentationVersionWithContext is the same as UpdateDocumentationVersion with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDocumentationVersion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateDocumentationVersionWithContext(ctx aws.Context, input *UpdateDocumentationVersionInput, opts ...request.Option) (*DocumentationVersion, error) {
	req, out := c.UpdateDocumentationVersionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDomainName = "UpdateDomainName"

// UpdateDomainNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDomainName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDomainName for more information on using the UpdateDomainName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDomainNameRequest method.
//    req, resp := client.UpdateDomainNameRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateDomainNameRequest(input *UpdateDomainNameInput) (req *request.Request, output *DomainName) {
	op := &request.Operation{
		Name:       opUpdateDomainName,
		HTTPMethod: "PATCH",
		HTTPPath:   "/domainnames/{domain_name}",
	}

	if input == nil {
		input = &UpdateDomainNameInput{}
	}

	output = &DomainName{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateDomainName API operation for Amazon API Gateway.
//
// Changes information about the DomainName resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateDomainName for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateDomainName(input *UpdateDomainNameInput) (*DomainName, error) {
	req, out := c.UpdateDomainNameRequest(input)
	return out, req.Send()
}

// UpdateDomainNameWithContext is the same as UpdateDomainName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDomainName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateDomainNameWithContext(ctx aws.Context, input *UpdateDomainNameInput, opts ...request.Option) (*DomainName, error) {
	req, out := c.UpdateDomainNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGatewayResponse = "UpdateGatewayResponse"

// UpdateGatewayResponseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGatewayResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGatewayResponse for more information on using the UpdateGatewayResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGatewayResponseRequest method.
//    req, resp := client.UpdateGatewayResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateGatewayResponseRequest(input *UpdateGatewayResponseInput) (req *request.Request, output *UpdateGatewayResponseOutput) {
	op := &request.Operation{
		Name:       opUpdateGatewayResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/gatewayresponses/{response_type}",
	}

	if input == nil {
		input = &UpdateGatewayResponseInput{}
	}

	output = &UpdateGatewayResponseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGatewayResponse API operation for Amazon API Gateway.
//
// Updates a GatewayResponse of a specified response type on the given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateGatewayResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateGatewayResponse(input *UpdateGatewayResponseInput) (*UpdateGatewayResponseOutput, error) {
	req, out := c.UpdateGatewayResponseRequest(input)
	return out, req.Send()
}

// UpdateGatewayResponseWithContext is the same as UpdateGatewayResponse with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGatewayResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateGatewayResponseWithContext(ctx aws.Context, input *UpdateGatewayResponseInput, opts ...request.Option) (*UpdateGatewayResponseOutput, error) {
	req, out := c.UpdateGatewayResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntegration = "UpdateIntegration"

// UpdateIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntegration for more information on using the UpdateIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIntegrationRequest method.
//    req, resp := client.UpdateIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateIntegrationRequest(input *UpdateIntegrationInput) (req *request.Request, output *Integration) {
	op := &request.Operation{
		Name:       opUpdateIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration",
	}

	if input == nil {
		input = &UpdateIntegrationInput{}
	}

	output = &Integration{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntegration API operation for Amazon API Gateway.
//
// Represents an update integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateIntegration for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateIntegration(input *UpdateIntegrationInput) (*Integration, error) {
	req, out := c.UpdateIntegrationRequest(input)
	return out, req.Send()
}

// UpdateIntegrationWithContext is the same as UpdateIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateIntegrationWithContext(ctx aws.Context, input *UpdateIntegrationInput, opts ...request.Option) (*Integration, error) {
	req, out := c.UpdateIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIntegrationResponse = "UpdateIntegrationResponse"

// UpdateIntegrationResponseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIntegrationResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIntegrationResponse for more information on using the UpdateIntegrationResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIntegrationResponseRequest method.
//    req, resp := client.UpdateIntegrationResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateIntegrationResponseRequest(input *UpdateIntegrationResponseInput) (req *request.Request, output *IntegrationResponse) {
	op := &request.Operation{
		Name:       opUpdateIntegrationResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}",
	}

	if input == nil {
		input = &UpdateIntegrationResponseInput{}
	}

	output = &IntegrationResponse{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIntegrationResponse API operation for Amazon API Gateway.
//
// Represents an update integration response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateIntegrationResponse for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateIntegrationResponse(input *UpdateIntegrationResponseInput) (*IntegrationResponse, error) {
	req, out := c.UpdateIntegrationResponseRequest(input)
	return out, req.Send()
}

// UpdateIntegrationResponseWithContext is the same as UpdateIntegrationResponse with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIntegrationResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateIntegrationResponseWithContext(ctx aws.Context, input *UpdateIntegrationResponseInput, opts ...request.Option) (*IntegrationResponse, error) {
	req, out := c.UpdateIntegrationResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMethod = "UpdateMethod"

// UpdateMethodRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMethod operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMethod for more information on using the UpdateMethod
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMethodRequest method.
//    req, resp := client.UpdateMethodRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateMethodRequest(input *UpdateMethodInput) (req *request.Request, output *Method) {
	op := &request.Operation{
		Name:       opUpdateMethod,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}",
	}

	if input == nil {
		input = &UpdateMethodInput{}
	}

	output = &Method{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMethod API operation for Amazon API Gateway.
//
// Updates an existing Method resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateMethod for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateMethod(input *UpdateMethodInput) (*Method, error) {
	req, out := c.UpdateMethodRequest(input)
	return out, req.Send()
}

// UpdateMethodWithContext is the same as UpdateMethod with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMethod for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateMethodWithContext(ctx aws.Context, input *UpdateMethodInput, opts ...request.Option) (*Method, error) {
	req, out := c.UpdateMethodRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateMethodResponse = "UpdateMethodResponse"

// UpdateMethodResponseRequest generates a "aws/request.Request" representing the
// client's request for the UpdateMethodResponse operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateMethodResponse for more information on using the UpdateMethodResponse
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateMethodResponseRequest method.
//    req, resp := client.UpdateMethodResponseRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateMethodResponseRequest(input *UpdateMethodResponseInput) (req *request.Request, output *MethodResponse) {
	op := &request.Operation{
		Name:       opUpdateMethodResponse,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}",
	}

	if input == nil {
		input = &UpdateMethodResponseInput{}
	}

	output = &MethodResponse{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateMethodResponse API operation for Amazon API Gateway.
//
// Updates an existing MethodResponse resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateMethodResponse for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateMethodResponse(input *UpdateMethodResponseInput) (*MethodResponse, error) {
	req, out := c.UpdateMethodResponseRequest(input)
	return out, req.Send()
}

// UpdateMethodResponseWithContext is the same as UpdateMethodResponse with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateMethodResponse for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateMethodResponseWithContext(ctx aws.Context, input *UpdateMethodResponseInput, opts ...request.Option) (*MethodResponse, error) {
	req, out := c.UpdateMethodResponseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateModel = "UpdateModel"

// UpdateModelRequest generates a "aws/request.Request" representing the
// client's request for the UpdateModel operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateModel for more information on using the UpdateModel
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateModelRequest method.
//    req, resp := client.UpdateModelRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateModelRequest(input *UpdateModelInput) (req *request.Request, output *Model) {
	op := &request.Operation{
		Name:       opUpdateModel,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/models/{model_name}",
	}

	if input == nil {
		input = &UpdateModelInput{}
	}

	output = &Model{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateModel API operation for Amazon API Gateway.
//
// Changes information about a model.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateModel for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateModel(input *UpdateModelInput) (*Model, error) {
	req, out := c.UpdateModelRequest(input)
	return out, req.Send()
}

// UpdateModelWithContext is the same as UpdateModel with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateModel for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateModelWithContext(ctx aws.Context, input *UpdateModelInput, opts ...request.Option) (*Model, error) {
	req, out := c.UpdateModelRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRequestValidator = "UpdateRequestValidator"

// UpdateRequestValidatorRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRequestValidator operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRequestValidator for more information on using the UpdateRequestValidator
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRequestValidatorRequest method.
//    req, resp := client.UpdateRequestValidatorRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateRequestValidatorRequest(input *UpdateRequestValidatorInput) (req *request.Request, output *UpdateRequestValidatorOutput) {
	op := &request.Operation{
		Name:       opUpdateRequestValidator,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/requestvalidators/{requestvalidator_id}",
	}

	if input == nil {
		input = &UpdateRequestValidatorInput{}
	}

	output = &UpdateRequestValidatorOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRequestValidator API operation for Amazon API Gateway.
//
// Updates a RequestValidator of a given RestApi.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateRequestValidator for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateRequestValidator(input *UpdateRequestValidatorInput) (*UpdateRequestValidatorOutput, error) {
	req, out := c.UpdateRequestValidatorRequest(input)
	return out, req.Send()
}

// UpdateRequestValidatorWithContext is the same as UpdateRequestValidator with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRequestValidator for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateRequestValidatorWithContext(ctx aws.Context, input *UpdateRequestValidatorInput, opts ...request.Option) (*UpdateRequestValidatorOutput, error) {
	req, out := c.UpdateRequestValidatorRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResource = "UpdateResource"

// UpdateResourceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateResource for more information on using the UpdateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateResourceRequest method.
//    req, resp := client.UpdateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateResourceRequest(input *UpdateResourceInput) (req *request.Request, output *Resource) {
	op := &request.Operation{
		Name:       opUpdateResource,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/resources/{resource_id}",
	}

	if input == nil {
		input = &UpdateResourceInput{}
	}

	output = &Resource{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateResource API operation for Amazon API Gateway.
//
// Changes information about a Resource resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateResource for usage and error information.
//
// Returned Error Types:
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateResource(input *UpdateResourceInput) (*Resource, error) {
	req, out := c.UpdateResourceRequest(input)
	return out, req.Send()
}

// UpdateResourceWithContext is the same as UpdateResource with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateResourceWithContext(ctx aws.Context, input *UpdateResourceInput, opts ...request.Option) (*Resource, error) {
	req, out := c.UpdateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRestApi = "UpdateRestApi"

// UpdateRestApiRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRestApi operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRestApi for more information on using the UpdateRestApi
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRestApiRequest method.
//    req, resp := client.UpdateRestApiRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateRestApiRequest(input *UpdateRestApiInput) (req *request.Request, output *RestApi) {
	op := &request.Operation{
		Name:       opUpdateRestApi,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}",
	}

	if input == nil {
		input = &UpdateRestApiInput{}
	}

	output = &RestApi{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRestApi API operation for Amazon API Gateway.
//
// Changes information about the specified API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateRestApi for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateRestApi(input *UpdateRestApiInput) (*RestApi, error) {
	req, out := c.UpdateRestApiRequest(input)
	return out, req.Send()
}

// UpdateRestApiWithContext is the same as UpdateRestApi with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRestApi for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateRestApiWithContext(ctx aws.Context, input *UpdateRestApiInput, opts ...request.Option) (*RestApi, error) {
	req, out := c.UpdateRestApiRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateStage = "UpdateStage"

// UpdateStageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateStage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateStage for more information on using the UpdateStage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateStageRequest method.
//    req, resp := client.UpdateStageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateStageRequest(input *UpdateStageInput) (req *request.Request, output *Stage) {
	op := &request.Operation{
		Name:       opUpdateStage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}",
	}

	if input == nil {
		input = &UpdateStageInput{}
	}

	output = &Stage{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateStage API operation for Amazon API Gateway.
//
// Changes information about a Stage resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateStage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateStage(input *UpdateStageInput) (*Stage, error) {
	req, out := c.UpdateStageRequest(input)
	return out, req.Send()
}

// UpdateStageWithContext is the same as UpdateStage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateStage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateStageWithContext(ctx aws.Context, input *UpdateStageInput, opts ...request.Option) (*Stage, error) {
	req, out := c.UpdateStageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUsage = "UpdateUsage"

// UpdateUsageRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUsage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUsage for more information on using the UpdateUsage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUsageRequest method.
//    req, resp := client.UpdateUsageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateUsageRequest(input *UpdateUsageInput) (req *request.Request, output *Usage) {
	op := &request.Operation{
		Name:       opUpdateUsage,
		HTTPMethod: "PATCH",
		HTTPPath:   "/usageplans/{usageplanId}/keys/{keyId}/usage",
	}

	if input == nil {
		input = &UpdateUsageInput{}
	}

	output = &Usage{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUsage API operation for Amazon API Gateway.
//
// Grants a temporary extension to the remaining quota of a usage plan associated
// with a specified API key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateUsage for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateUsage(input *UpdateUsageInput) (*Usage, error) {
	req, out := c.UpdateUsageRequest(input)
	return out, req.Send()
}

// UpdateUsageWithContext is the same as UpdateUsage with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUsage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateUsageWithContext(ctx aws.Context, input *UpdateUsageInput, opts ...request.Option) (*Usage, error) {
	req, out := c.UpdateUsageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUsagePlan = "UpdateUsagePlan"

// UpdateUsagePlanRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUsagePlan operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUsagePlan for more information on using the UpdateUsagePlan
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateUsagePlanRequest method.
//    req, resp := client.UpdateUsagePlanRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateUsagePlanRequest(input *UpdateUsagePlanInput) (req *request.Request, output *UsagePlan) {
	op := &request.Operation{
		Name:       opUpdateUsagePlan,
		HTTPMethod: "PATCH",
		HTTPPath:   "/usageplans/{usageplanId}",
	}

	if input == nil {
		input = &UpdateUsagePlanInput{}
	}

	output = &UsagePlan{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUsagePlan API operation for Amazon API Gateway.
//
// Updates a usage plan of a given plan Id.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateUsagePlan for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateUsagePlan(input *UpdateUsagePlanInput) (*UsagePlan, error) {
	req, out := c.UpdateUsagePlanRequest(input)
	return out, req.Send()
}

// UpdateUsagePlanWithContext is the same as UpdateUsagePlan with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUsagePlan for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateUsagePlanWithContext(ctx aws.Context, input *UpdateUsagePlanInput, opts ...request.Option) (*UsagePlan, error) {
	req, out := c.UpdateUsagePlanRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateVpcLink = "UpdateVpcLink"

// UpdateVpcLinkRequest generates a "aws/request.Request" representing the
// client's request for the UpdateVpcLink operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateVpcLink for more information on using the UpdateVpcLink
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateVpcLinkRequest method.
//    req, resp := client.UpdateVpcLinkRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *APIGateway) UpdateVpcLinkRequest(input *UpdateVpcLinkInput) (req *request.Request, output *UpdateVpcLinkOutput) {
	op := &request.Operation{
		Name:       opUpdateVpcLink,
		HTTPMethod: "PATCH",
		HTTPPath:   "/vpclinks/{vpclink_id}",
	}

	if input == nil {
		input = &UpdateVpcLinkInput{}
	}

	output = &UpdateVpcLinkOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateVpcLink API operation for Amazon API Gateway.
//
// Updates an existing VpcLink of a specified identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon API Gateway's
// API operation UpdateVpcLink for usage and error information.
//
// Returned Error Types:
//   * BadRequestException
//   The submitted request is not valid, for example, the input is incomplete
//   or incorrect. See the accompanying error message for details.
//
//   * ConflictException
//   The request configuration has conflicts. For details, see the accompanying
//   error message.
//
//   * LimitExceededException
//   The request exceeded the rate limit. Retry after the specified time period.
//
//   * NotFoundException
//   The requested resource is not found. Make sure that the request URI is correct.
//
//   * UnauthorizedException
//   The request is denied because the caller has insufficient permissions.
//
//   * TooManyRequestsException
//   The request has reached its throttling limit. Retry after the specified time
//   period.
//
func (c *APIGateway) UpdateVpcLink(input *UpdateVpcLinkInput) (*UpdateVpcLinkOutput, error) {
	req, out := c.UpdateVpcLinkRequest(input)
	return out, req.Send()
}

// UpdateVpcLinkWithContext is the same as UpdateVpcLink with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateVpcLink for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *APIGateway) UpdateVpcLinkWithContext(ctx aws.Context, input *UpdateVpcLinkInput, opts ...request.Option) (*UpdateVpcLinkOutput, error) {
	req, out := c.UpdateVpcLinkRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Access log settings, including the access log format and access log destination
// ARN.
type AccessLogSettings struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the CloudWatch Logs log group or Kinesis
	// Data Firehose delivery stream to receive access logs. If you specify a Kinesis
	// Data Firehose delivery stream, the stream name must begin with amazon-apigateway-.
	DestinationArn *string `locationName:"destinationArn" type:"string"`

	// A single line format of the access logs of data, as specified by selected
	// $context variables (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference).
	// The format must include at least $context.requestId.
	Format *string `locationName:"format" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLogSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessLogSettings) GoString() string {
	return s.String()
}

// SetDestinationArn sets the DestinationArn field's value.
func (s *AccessLogSettings) SetDestinationArn(v string) *AccessLogSettings {
	s.DestinationArn = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *AccessLogSettings) SetFormat(v string) *AccessLogSettings {
	s.Format = &v
	return s
}

// Represents an AWS account that is associated with API Gateway.
//
// To view the account info, call GET on this resource.
//
// Error Codes
//
// The following exception may be thrown when the request fails.
//
//    * UnauthorizedException
//
//    * NotFoundException
//
//    * TooManyRequestsException
//
// For detailed error code information, including the corresponding HTTP Status
// Codes, see API Gateway Error Codes (https://docs.aws.amazon.com/apigateway/api-reference/handling-errors/#api-error-codes)
//
// Example: Get the information about an account.
//
// Request
//  GET /account HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
//  X-Amz-Date: 20160531T184618Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
// Response
//
// The successful response returns a 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/account-apigateway-{rel}.html",
//  "name": "account", "templated": true }, "self": { "href": "/account" },
//  "account:update": { "href": "/account" } }, "cloudwatchRoleArn": "arn:aws:iam::123456789012:role/apigAwsProxyRole",
//  "throttleSettings": { "rateLimit": 500, "burstLimit": 1000 } }
// In addition to making the REST API call directly, you can use the AWS CLI
// and an AWS SDK to access this resource.
//
// API Gateway Limits (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-limits.html)
// Developer Guide (https://docs.aws.amazon.com/apigateway/latest/developerguide/welcome.html),
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-account.html)
type Account struct {
	_ struct{} `type:"structure"`

	// The version of the API keys used for the account.
	ApiKeyVersion *string `locationName:"apiKeyVersion" type:"string"`

	// The ARN of an Amazon CloudWatch role for the current Account.
	CloudwatchRoleArn *string `locationName:"cloudwatchRoleArn" type:"string"`

	// A list of features supported for the account. When usage plans are enabled,
	// the features list will include an entry of "UsagePlans".
	Features []*string `locationName:"features" type:"list"`

	// Specifies the API request limits configured for the current Account.
	ThrottleSettings *ThrottleSettings `locationName:"throttleSettings" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Account) GoString() string {
	return s.String()
}

// SetApiKeyVersion sets the ApiKeyVersion field's value.
func (s *Account) SetApiKeyVersion(v string) *Account {
	s.ApiKeyVersion = &v
	return s
}

// SetCloudwatchRoleArn sets the CloudwatchRoleArn field's value.
func (s *Account) SetCloudwatchRoleArn(v string) *Account {
	s.CloudwatchRoleArn = &v
	return s
}

// SetFeatures sets the Features field's value.
func (s *Account) SetFeatures(v []*string) *Account {
	s.Features = v
	return s
}

// SetThrottleSettings sets the ThrottleSettings field's value.
func (s *Account) SetThrottleSettings(v *ThrottleSettings) *Account {
	s.ThrottleSettings = v
	return s
}

// A resource that can be distributed to callers for executing Method resources
// that require an API key. API keys can be mapped to any Stage on any RestApi,
// which indicates that the callers with the API key can make requests to that
// stage.
//
// Use API Keys (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html)
type ApiKey struct {
	_ struct{} `type:"structure"`

	// The timestamp when the API Key was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// An AWS Marketplace customer identifier , when integrating with the AWS SaaS
	// Marketplace.
	CustomerId *string `locationName:"customerId" type:"string"`

	// The description of the API Key.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the API Key can be used by callers.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The identifier of the API Key.
	Id *string `locationName:"id" type:"string"`

	// The timestamp when the API Key was last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// The name of the API Key.
	Name *string `locationName:"name" type:"string"`

	// A list of Stage resources that are associated with the ApiKey resource.
	StageKeys []*string `locationName:"stageKeys" type:"list"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The value of the API Key.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiKey) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ApiKey) SetCreatedDate(v time.Time) *ApiKey {
	s.CreatedDate = &v
	return s
}

// SetCustomerId sets the CustomerId field's value.
func (s *ApiKey) SetCustomerId(v string) *ApiKey {
	s.CustomerId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApiKey) SetDescription(v string) *ApiKey {
	s.Description = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *ApiKey) SetEnabled(v bool) *ApiKey {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApiKey) SetId(v string) *ApiKey {
	s.Id = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *ApiKey) SetLastUpdatedDate(v time.Time) *ApiKey {
	s.LastUpdatedDate = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApiKey) SetName(v string) *ApiKey {
	s.Name = &v
	return s
}

// SetStageKeys sets the StageKeys field's value.
func (s *ApiKey) SetStageKeys(v []*string) *ApiKey {
	s.StageKeys = v
	return s
}

// SetTags sets the Tags field's value.
func (s *ApiKey) SetTags(v map[string]*string) *ApiKey {
	s.Tags = v
	return s
}

// SetValue sets the Value field's value.
func (s *ApiKey) SetValue(v string) *ApiKey {
	s.Value = &v
	return s
}

// API stage name of the associated API stage in a usage plan.
type ApiStage struct {
	_ struct{} `type:"structure"`

	// API Id of the associated API stage in a usage plan.
	ApiId *string `locationName:"apiId" type:"string"`

	// API stage name of the associated API stage in a usage plan.
	Stage *string `locationName:"stage" type:"string"`

	// Map containing method level throttling information for API stage in a usage
	// plan.
	Throttle map[string]*ThrottleSettings `locationName:"throttle" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiStage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApiStage) GoString() string {
	return s.String()
}

// SetApiId sets the ApiId field's value.
func (s *ApiStage) SetApiId(v string) *ApiStage {
	s.ApiId = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *ApiStage) SetStage(v string) *ApiStage {
	s.Stage = &v
	return s
}

// SetThrottle sets the Throttle field's value.
func (s *ApiStage) SetThrottle(v map[string]*ThrottleSettings) *ApiStage {
	s.Throttle = v
	return s
}

// Represents an authorization layer for methods. If enabled on a method, API
// Gateway will activate the authorizer when a client calls the method.
//
// Use Lambda Function as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html)
// Use Cognito User Pool as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html)
type Authorizer struct {
	_ struct{} `type:"structure"`

	// Optional customer-defined field, used in OpenAPI imports and exports without
	// functional impact.
	AuthType *string `locationName:"authType" type:"string"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null.
	AuthorizerCredentials *string `locationName:"authorizerCredentials" type:"string"`

	// The TTL in seconds of cached authorizer results. If it equals 0, authorization
	// caching is disabled. If it is greater than 0, API Gateway will cache authorizer
	// responses. If this field is not set, the default value is 300. The maximum
	// value is 3600, or 1 hour.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or
	// REQUEST authorizers, this must be a well-formed Lambda function URI, for
	// example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form arn:aws:apigateway:{region}:lambda:path/{service_api},
	// where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identifier for the authorizer resource.
	Id *string `locationName:"id" type:"string"`

	// The identity source for which authorization is requested.
	//    * For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies
	//    the request header mapping expression for the custom header holding the
	//    authorization token submitted by the client. For example, if the token
	//    header name is Auth, the header mapping expression is method.request.header.Auth.
	//
	//    * For the REQUEST authorizer, this is required when authorization caching
	//    is enabled. The value is a comma-separated string of one or more mapping
	//    expressions of the specified request parameters. For example, if an Auth
	//    header, a Name query string parameter are defined as identity sources,
	//    this value is method.request.header.Auth, method.request.querystring.Name.
	//    These parameters will be used to derive the authorization caching key
	//    and to perform runtime validation of the REQUEST authorizer by verifying
	//    all of the identity-related request parameters are present, not null and
	//    non-empty. Only when this is true does the authorizer invoke the authorizer
	//    Lambda function, otherwise, it returns a 401 Unauthorized response without
	//    calling the Lambda function. The valid value is a string of comma-separated
	//    mapping expressions of the specified request parameters. When the authorization
	//    caching is not enabled, this property is optional.
	IdentitySource *string `locationName:"identitySource" type:"string"`

	// A validation expression for the incoming identity token. For TOKEN authorizers,
	// this value is a regular expression. For COGNITO_USER_POOLS authorizers, API
	// Gateway will match the aud field of the incoming token from the client against
	// the specified regular expression. It will invoke the authorizer's Lambda
	// function when there is a match. Otherwise, it will return a 401 Unauthorized
	// response without calling the Lambda function. The validation expression does
	// not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// [Required] The name of the authorizer.
	Name *string `locationName:"name" type:"string"`

	// A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer.
	// Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}.
	// For a TOKEN or REQUEST authorizer, this is not defined.
	ProviderARNs []*string `locationName:"providerARNs" type:"list"`

	// The authorizer type. Valid values are TOKEN for a Lambda function using a
	// single authorization token submitted in a custom header, REQUEST for a Lambda
	// function using incoming request parameters, and COGNITO_USER_POOLS for using
	// an Amazon Cognito user pool.
	Type *string `locationName:"type" type:"string" enum:"AuthorizerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authorizer) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Authorizer) GoString() string {
	return s.String()
}

// SetAuthType sets the AuthType field's value.
func (s *Authorizer) SetAuthType(v string) *Authorizer {
	s.AuthType = &v
	return s
}

// SetAuthorizerCredentials sets the AuthorizerCredentials field's value.
func (s *Authorizer) SetAuthorizerCredentials(v string) *Authorizer {
	s.AuthorizerCredentials = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *Authorizer) SetAuthorizerResultTtlInSeconds(v int64) *Authorizer {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *Authorizer) SetAuthorizerUri(v string) *Authorizer {
	s.AuthorizerUri = &v
	return s
}

// SetId sets the Id field's value.
func (s *Authorizer) SetId(v string) *Authorizer {
	s.Id = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *Authorizer) SetIdentitySource(v string) *Authorizer {
	s.IdentitySource = &v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *Authorizer) SetIdentityValidationExpression(v string) *Authorizer {
	s.IdentityValidationExpression = &v
	return s
}

// SetName sets the Name field's value.
func (s *Authorizer) SetName(v string) *Authorizer {
	s.Name = &v
	return s
}

// SetProviderARNs sets the ProviderARNs field's value.
func (s *Authorizer) SetProviderARNs(v []*string) *Authorizer {
	s.ProviderARNs = v
	return s
}

// SetType sets the Type field's value.
func (s *Authorizer) SetType(v string) *Authorizer {
	s.Type = &v
	return s
}

// The submitted request is not valid, for example, the input is incomplete
// or incorrect. See the accompanying error message for details.
type BadRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadRequestException) Code() string {
	return "BadRequestException"
}

// Message returns the exception's message.
func (s *BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadRequestException) OrigErr() error {
	return nil
}

func (s *BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the base path that callers of the API must provide as part of
// the URL after the domain name.
//
// A custom domain name plus a BasePathMapping specification identifies a deployed
// RestApi in a given stage of the owner Account.
//
// Use Custom Domain Names (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type BasePathMapping struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// The string identifier of the associated RestApi.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The name of the associated stage.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasePathMapping) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BasePathMapping) GoString() string {
	return s.String()
}

// SetBasePath sets the BasePath field's value.
func (s *BasePathMapping) SetBasePath(v string) *BasePathMapping {
	s.BasePath = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *BasePathMapping) SetRestApiId(v string) *BasePathMapping {
	s.RestApiId = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *BasePathMapping) SetStage(v string) *BasePathMapping {
	s.Stage = &v
	return s
}

// Configuration settings of a canary deployment.
type CanarySettings struct {
	_ struct{} `type:"structure"`

	// The ID of the canary deployment.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The percent (0-100) of traffic diverted to a canary deployment.
	PercentTraffic *float64 `locationName:"percentTraffic" type:"double"`

	// Stage variables overridden for a canary release deployment, including new
	// stage variables introduced in the canary. These stage variables are represented
	// as a string-to-string map between stage variable names and their values.
	StageVariableOverrides map[string]*string `locationName:"stageVariableOverrides" type:"map"`

	// A Boolean flag to indicate whether the canary deployment uses the stage cache
	// or not.
	UseStageCache *bool `locationName:"useStageCache" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanarySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CanarySettings) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CanarySettings) SetDeploymentId(v string) *CanarySettings {
	s.DeploymentId = &v
	return s
}

// SetPercentTraffic sets the PercentTraffic field's value.
func (s *CanarySettings) SetPercentTraffic(v float64) *CanarySettings {
	s.PercentTraffic = &v
	return s
}

// SetStageVariableOverrides sets the StageVariableOverrides field's value.
func (s *CanarySettings) SetStageVariableOverrides(v map[string]*string) *CanarySettings {
	s.StageVariableOverrides = v
	return s
}

// SetUseStageCache sets the UseStageCache field's value.
func (s *CanarySettings) SetUseStageCache(v bool) *CanarySettings {
	s.UseStageCache = &v
	return s
}

// Represents a client certificate used to configure client-side SSL authentication
// while sending requests to the integration endpoint.
//
// Client certificates are used to authenticate an API by the backend server.
// To authenticate an API client (or user), use IAM roles and policies, a custom
// Authorizer or an Amazon Cognito user pool.
//
// Use Client-Side Certificate (https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html)
type ClientCertificate struct {
	_ struct{} `type:"structure"`

	// The identifier of the client certificate.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the client certificate was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description of the client certificate.
	Description *string `locationName:"description" type:"string"`

	// The timestamp when the client certificate will expire.
	ExpirationDate *time.Time `locationName:"expirationDate" type:"timestamp"`

	// The PEM-encoded public key of the client certificate, which can be used to
	// configure certificate authentication in the integration endpoint .
	PemEncodedCertificate *string `locationName:"pemEncodedCertificate" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientCertificate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientCertificate) GoString() string {
	return s.String()
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *ClientCertificate) SetClientCertificateId(v string) *ClientCertificate {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *ClientCertificate) SetCreatedDate(v time.Time) *ClientCertificate {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ClientCertificate) SetDescription(v string) *ClientCertificate {
	s.Description = &v
	return s
}

// SetExpirationDate sets the ExpirationDate field's value.
func (s *ClientCertificate) SetExpirationDate(v time.Time) *ClientCertificate {
	s.ExpirationDate = &v
	return s
}

// SetPemEncodedCertificate sets the PemEncodedCertificate field's value.
func (s *ClientCertificate) SetPemEncodedCertificate(v string) *ClientCertificate {
	s.PemEncodedCertificate = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClientCertificate) SetTags(v map[string]*string) *ClientCertificate {
	s.Tags = v
	return s
}

// The request configuration has conflicts. For details, see the accompanying
// error message.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request to create an ApiKey resource.
type CreateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// An AWS Marketplace customer identifier , when integrating with the AWS SaaS
	// Marketplace.
	CustomerId *string `locationName:"customerId" type:"string"`

	// The description of the ApiKey.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether the ApiKey can be used by callers.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// Specifies whether (true) or not (false) the key identifier is distinct from
	// the created API key value. This parameter is deprecated and should not be
	// used.
	GenerateDistinctId *bool `locationName:"generateDistinctId" type:"boolean"`

	// The name of the ApiKey.
	Name *string `locationName:"name" type:"string"`

	// DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key.
	StageKeys []*StageKey `locationName:"stageKeys" type:"list"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Specifies a value of the API key.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApiKeyInput) GoString() string {
	return s.String()
}

// SetCustomerId sets the CustomerId field's value.
func (s *CreateApiKeyInput) SetCustomerId(v string) *CreateApiKeyInput {
	s.CustomerId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApiKeyInput) SetDescription(v string) *CreateApiKeyInput {
	s.Description = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *CreateApiKeyInput) SetEnabled(v bool) *CreateApiKeyInput {
	s.Enabled = &v
	return s
}

// SetGenerateDistinctId sets the GenerateDistinctId field's value.
func (s *CreateApiKeyInput) SetGenerateDistinctId(v bool) *CreateApiKeyInput {
	s.GenerateDistinctId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApiKeyInput) SetName(v string) *CreateApiKeyInput {
	s.Name = &v
	return s
}

// SetStageKeys sets the StageKeys field's value.
func (s *CreateApiKeyInput) SetStageKeys(v []*StageKey) *CreateApiKeyInput {
	s.StageKeys = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApiKeyInput) SetTags(v map[string]*string) *CreateApiKeyInput {
	s.Tags = v
	return s
}

// SetValue sets the Value field's value.
func (s *CreateApiKeyInput) SetValue(v string) *CreateApiKeyInput {
	s.Value = &v
	return s
}

// Request to add a new Authorizer to an existing RestApi resource.
type CreateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// Optional customer-defined field, used in OpenAPI imports and exports without
	// functional impact.
	AuthType *string `locationName:"authType" type:"string"`

	// Specifies the required credentials as an IAM role for API Gateway to invoke
	// the authorizer. To specify an IAM role for API Gateway to assume, use the
	// role's Amazon Resource Name (ARN). To use resource-based permissions on the
	// Lambda function, specify null.
	AuthorizerCredentials *string `locationName:"authorizerCredentials" type:"string"`

	// The TTL in seconds of cached authorizer results. If it equals 0, authorization
	// caching is disabled. If it is greater than 0, API Gateway will cache authorizer
	// responses. If this field is not set, the default value is 300. The maximum
	// value is 3600, or 1 hour.
	AuthorizerResultTtlInSeconds *int64 `locationName:"authorizerResultTtlInSeconds" type:"integer"`

	// Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or
	// REQUEST authorizers, this must be a well-formed Lambda function URI, for
	// example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations.
	// In general, the URI has this form arn:aws:apigateway:{region}:lambda:path/{service_api},
	// where {region} is the same as the region hosting the Lambda function, path
	// indicates that the remaining substring in the URI should be treated as the
	// path to the resource, including the initial /. For Lambda functions, this
	// is usually of the form /2015-03-31/functions/[FunctionARN]/invocations.
	AuthorizerUri *string `locationName:"authorizerUri" type:"string"`

	// The identity source for which authorization is requested.
	//    * For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies
	//    the request header mapping expression for the custom header holding the
	//    authorization token submitted by the client. For example, if the token
	//    header name is Auth, the header mapping expression is method.request.header.Auth.
	//
	//    * For the REQUEST authorizer, this is required when authorization caching
	//    is enabled. The value is a comma-separated string of one or more mapping
	//    expressions of the specified request parameters. For example, if an Auth
	//    header, a Name query string parameter are defined as identity sources,
	//    this value is method.request.header.Auth, method.request.querystring.Name.
	//    These parameters will be used to derive the authorization caching key
	//    and to perform runtime validation of the REQUEST authorizer by verifying
	//    all of the identity-related request parameters are present, not null and
	//    non-empty. Only when this is true does the authorizer invoke the authorizer
	//    Lambda function, otherwise, it returns a 401 Unauthorized response without
	//    calling the Lambda function. The valid value is a string of comma-separated
	//    mapping expressions of the specified request parameters. When the authorization
	//    caching is not enabled, this property is optional.
	IdentitySource *string `locationName:"identitySource" type:"string"`

	// A validation expression for the incoming identity token. For TOKEN authorizers,
	// this value is a regular expression. For COGNITO_USER_POOLS authorizers, API
	// Gateway will match the aud field of the incoming token from the client against
	// the specified regular expression. It will invoke the authorizer's Lambda
	// function when there is a match. Otherwise, it will return a 401 Unauthorized
	// response without calling the Lambda function. The validation expression does
	// not apply to the REQUEST authorizer.
	IdentityValidationExpression *string `locationName:"identityValidationExpression" type:"string"`

	// [Required] The name of the authorizer.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer.
	// Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}.
	// For a TOKEN or REQUEST authorizer, this is not defined.
	ProviderARNs []*string `locationName:"providerARNs" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The authorizer type. Valid values are TOKEN for a Lambda function
	// using a single authorization token submitted in a custom header, REQUEST
	// for a Lambda function using incoming request parameters, and COGNITO_USER_POOLS
	// for using an Amazon Cognito user pool.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"AuthorizerType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAuthorizerInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthType sets the AuthType field's value.
func (s *CreateAuthorizerInput) SetAuthType(v string) *CreateAuthorizerInput {
	s.AuthType = &v
	return s
}

// SetAuthorizerCredentials sets the AuthorizerCredentials field's value.
func (s *CreateAuthorizerInput) SetAuthorizerCredentials(v string) *CreateAuthorizerInput {
	s.AuthorizerCredentials = &v
	return s
}

// SetAuthorizerResultTtlInSeconds sets the AuthorizerResultTtlInSeconds field's value.
func (s *CreateAuthorizerInput) SetAuthorizerResultTtlInSeconds(v int64) *CreateAuthorizerInput {
	s.AuthorizerResultTtlInSeconds = &v
	return s
}

// SetAuthorizerUri sets the AuthorizerUri field's value.
func (s *CreateAuthorizerInput) SetAuthorizerUri(v string) *CreateAuthorizerInput {
	s.AuthorizerUri = &v
	return s
}

// SetIdentitySource sets the IdentitySource field's value.
func (s *CreateAuthorizerInput) SetIdentitySource(v string) *CreateAuthorizerInput {
	s.IdentitySource = &v
	return s
}

// SetIdentityValidationExpression sets the IdentityValidationExpression field's value.
func (s *CreateAuthorizerInput) SetIdentityValidationExpression(v string) *CreateAuthorizerInput {
	s.IdentityValidationExpression = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAuthorizerInput) SetName(v string) *CreateAuthorizerInput {
	s.Name = &v
	return s
}

// SetProviderARNs sets the ProviderARNs field's value.
func (s *CreateAuthorizerInput) SetProviderARNs(v []*string) *CreateAuthorizerInput {
	s.ProviderARNs = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateAuthorizerInput) SetRestApiId(v string) *CreateAuthorizerInput {
	s.RestApiId = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateAuthorizerInput) SetType(v string) *CreateAuthorizerInput {
	s.Type = &v
	return s
}

// Requests API Gateway to create a new BasePathMapping resource.
type CreateBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// The base path name that callers of the API must provide as part of the URL
	// after the domain name. This value must be unique for all of the mappings
	// across a single API. Specify '(none)' if you do not want callers to specify
	// a base path name after the domain name.
	BasePath *string `locationName:"basePath" type:"string"`

	// [Required] The domain name of the BasePathMapping resource to create.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `locationName:"restApiId" type:"string" required:"true"`

	// The name of the API's stage that you want to use for this mapping. Specify
	// '(none)' if you want callers to explicitly specify the stage name after any
	// base path name.
	Stage *string `locationName:"stage" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateBasePathMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBasePathMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBasePathMappingInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePath sets the BasePath field's value.
func (s *CreateBasePathMappingInput) SetBasePath(v string) *CreateBasePathMappingInput {
	s.BasePath = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateBasePathMappingInput) SetDomainName(v string) *CreateBasePathMappingInput {
	s.DomainName = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateBasePathMappingInput) SetRestApiId(v string) *CreateBasePathMappingInput {
	s.RestApiId = &v
	return s
}

// SetStage sets the Stage field's value.
func (s *CreateBasePathMappingInput) SetStage(v string) *CreateBasePathMappingInput {
	s.Stage = &v
	return s
}

// Requests API Gateway to create a Deployment resource.
type CreateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// Enables a cache cluster for the Stage resource specified in the input.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// Specifies the cache cluster size for the Stage resource specified in the
	// input, if a cache cluster is enabled.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The input configuration for the canary deployment when the deployment is
	// a canary release deployment.
	CanarySettings *DeploymentCanarySettings `locationName:"canarySettings" type:"structure"`

	// The description for the Deployment resource to create.
	Description *string `locationName:"description" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The description of the Stage resource for the Deployment resource to create.
	StageDescription *string `locationName:"stageDescription" type:"string"`

	// The name of the Stage resource for the Deployment resource to create.
	StageName *string `locationName:"stageName" type:"string"`

	// Specifies whether active tracing with X-ray is enabled for the Stage.
	TracingEnabled *bool `locationName:"tracingEnabled" type:"boolean"`

	// A map that defines the stage variables for the Stage resource that is associated
	// with the new deployment. Variable names can have alphanumeric and underscore
	// characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+.
	Variables map[string]*string `locationName:"variables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDeploymentInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *CreateDeploymentInput) SetCacheClusterEnabled(v bool) *CreateDeploymentInput {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *CreateDeploymentInput) SetCacheClusterSize(v string) *CreateDeploymentInput {
	s.CacheClusterSize = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *CreateDeploymentInput) SetCanarySettings(v *DeploymentCanarySettings) *CreateDeploymentInput {
	s.CanarySettings = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDeploymentInput) SetDescription(v string) *CreateDeploymentInput {
	s.Description = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateDeploymentInput) SetRestApiId(v string) *CreateDeploymentInput {
	s.RestApiId = &v
	return s
}

// SetStageDescription sets the StageDescription field's value.
func (s *CreateDeploymentInput) SetStageDescription(v string) *CreateDeploymentInput {
	s.StageDescription = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateDeploymentInput) SetStageName(v string) *CreateDeploymentInput {
	s.StageName = &v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *CreateDeploymentInput) SetTracingEnabled(v bool) *CreateDeploymentInput {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *CreateDeploymentInput) SetVariables(v map[string]*string) *CreateDeploymentInput {
	s.Variables = v
	return s
}

// Creates a new documentation part of a given API.
type CreateDocumentationPartInput struct {
	_ struct{} `type:"structure"`

	// [Required] The location of the targeted API entity of the to-be-created documentation
	// part.
	//
	// Location is a required field
	Location *DocumentationPartLocation `locationName:"location" type:"structure" required:"true"`

	// [Required] The new documentation content map of the targeted API entity.
	// Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value
	// pairs can be exported and, hence, published.
	//
	// Properties is a required field
	Properties *string `locationName:"properties" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentationPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentationPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentationPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentationPartInput"}
	if s.Location == nil {
		invalidParams.Add(request.NewErrParamRequired("Location"))
	}
	if s.Properties == nil {
		invalidParams.Add(request.NewErrParamRequired("Properties"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.Location != nil {
		if err := s.Location.Validate(); err != nil {
			invalidParams.AddNested("Location", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLocation sets the Location field's value.
func (s *CreateDocumentationPartInput) SetLocation(v *DocumentationPartLocation) *CreateDocumentationPartInput {
	s.Location = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *CreateDocumentationPartInput) SetProperties(v string) *CreateDocumentationPartInput {
	s.Properties = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateDocumentationPartInput) SetRestApiId(v string) *CreateDocumentationPartInput {
	s.RestApiId = &v
	return s
}

// Creates a new documentation version of a given API.
type CreateDocumentationVersionInput struct {
	_ struct{} `type:"structure"`

	// A description about the new documentation snapshot.
	Description *string `locationName:"description" type:"string"`

	// [Required] The version identifier of the new snapshot.
	//
	// DocumentationVersion is a required field
	DocumentationVersion *string `locationName:"documentationVersion" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The stage name to be associated with the new documentation snapshot.
	StageName *string `locationName:"stageName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDocumentationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDocumentationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDocumentationVersionInput"}
	if s.DocumentationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationVersion"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateDocumentationVersionInput) SetDescription(v string) *CreateDocumentationVersionInput {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *CreateDocumentationVersionInput) SetDocumentationVersion(v string) *CreateDocumentationVersionInput {
	s.DocumentationVersion = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateDocumentationVersionInput) SetRestApiId(v string) *CreateDocumentationVersionInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateDocumentationVersionInput) SetStageName(v string) *CreateDocumentationVersionInput {
	s.StageName = &v
	return s
}

// A request to create a new domain name.
type CreateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// The reference to an AWS-managed certificate that will be used by edge-optimized
	// endpoint for this domain name. AWS Certificate Manager is the only supported
	// source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// [Deprecated] The body of the server certificate that will be used by edge-optimized
	// endpoint for this domain name provided by your certificate authority.
	CertificateBody *string `locationName:"certificateBody" type:"string"`

	// [Deprecated] The intermediate certificates and optionally the root certificate,
	// one after the other without any blank lines, used by an edge-optimized endpoint
	// for this domain name. If you include the root certificate, your certificate
	// chain must start with intermediate certificates and end with the root certificate.
	// Use the intermediate certificates that were provided by your certificate
	// authority. Do not include any intermediaries that are not in the chain of
	// trust path.
	CertificateChain *string `locationName:"certificateChain" type:"string"`

	// The user-friendly name of the certificate that will be used by edge-optimized
	// endpoint for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// [Deprecated] Your edge-optimized endpoint's domain name certificate's private
	// key.
	CertificatePrivateKey *string `locationName:"certificatePrivateKey" type:"string"`

	// [Required] The name of the DomainName resource.
	//
	// DomainName is a required field
	DomainName *string `locationName:"domainName" type:"string" required:"true"`

	// The endpoint configuration of this DomainName showing the endpoint types
	// of the domain name.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// If specified, API Gateway performs two-way authentication between the client
	// and the server. Clients must present a trusted certificate to access your
	// custom domain name.
	MutualTlsAuthentication *MutualTlsAuthenticationInput `locationName:"mutualTlsAuthentication" type:"structure"`

	// The ARN of the public certificate issued by ACM to validate ownership of
	// your custom domain. Only required when configuring mutual TLS and using an
	// ACM imported or private CA certificate ARN as the regionalCertificateArn.
	OwnershipVerificationCertificateArn *string `locationName:"ownershipVerificationCertificateArn" type:"string"`

	// The reference to an AWS-managed certificate that will be used by regional
	// endpoint for this domain name. AWS Certificate Manager is the only supported
	// source.
	RegionalCertificateArn *string `locationName:"regionalCertificateArn" type:"string"`

	// The user-friendly name of the certificate that will be used by regional endpoint
	// for this domain name.
	RegionalCertificateName *string `locationName:"regionalCertificateName" type:"string"`

	// The Transport Layer Security (TLS) version + cipher suite for this DomainName.
	// The valid values are TLS_1_0 and TLS_1_2.
	SecurityPolicy *string `locationName:"securityPolicy" type:"string" enum:"SecurityPolicy"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *CreateDomainNameInput) SetCertificateArn(v string) *CreateDomainNameInput {
	s.CertificateArn = &v
	return s
}

// SetCertificateBody sets the CertificateBody field's value.
func (s *CreateDomainNameInput) SetCertificateBody(v string) *CreateDomainNameInput {
	s.CertificateBody = &v
	return s
}

// SetCertificateChain sets the CertificateChain field's value.
func (s *CreateDomainNameInput) SetCertificateChain(v string) *CreateDomainNameInput {
	s.CertificateChain = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *CreateDomainNameInput) SetCertificateName(v string) *CreateDomainNameInput {
	s.CertificateName = &v
	return s
}

// SetCertificatePrivateKey sets the CertificatePrivateKey field's value.
func (s *CreateDomainNameInput) SetCertificatePrivateKey(v string) *CreateDomainNameInput {
	s.CertificatePrivateKey = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *CreateDomainNameInput) SetDomainName(v string) *CreateDomainNameInput {
	s.DomainName = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *CreateDomainNameInput) SetEndpointConfiguration(v *EndpointConfiguration) *CreateDomainNameInput {
	s.EndpointConfiguration = v
	return s
}

// SetMutualTlsAuthentication sets the MutualTlsAuthentication field's value.
func (s *CreateDomainNameInput) SetMutualTlsAuthentication(v *MutualTlsAuthenticationInput) *CreateDomainNameInput {
	s.MutualTlsAuthentication = v
	return s
}

// SetOwnershipVerificationCertificateArn sets the OwnershipVerificationCertificateArn field's value.
func (s *CreateDomainNameInput) SetOwnershipVerificationCertificateArn(v string) *CreateDomainNameInput {
	s.OwnershipVerificationCertificateArn = &v
	return s
}

// SetRegionalCertificateArn sets the RegionalCertificateArn field's value.
func (s *CreateDomainNameInput) SetRegionalCertificateArn(v string) *CreateDomainNameInput {
	s.RegionalCertificateArn = &v
	return s
}

// SetRegionalCertificateName sets the RegionalCertificateName field's value.
func (s *CreateDomainNameInput) SetRegionalCertificateName(v string) *CreateDomainNameInput {
	s.RegionalCertificateName = &v
	return s
}

// SetSecurityPolicy sets the SecurityPolicy field's value.
func (s *CreateDomainNameInput) SetSecurityPolicy(v string) *CreateDomainNameInput {
	s.SecurityPolicy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDomainNameInput) SetTags(v map[string]*string) *CreateDomainNameInput {
	s.Tags = v
	return s
}

// Request to add a new Model to an existing RestApi resource.
type CreateModelInput struct {
	_ struct{} `type:"structure"`

	// [Required] The content-type for the model.
	//
	// ContentType is a required field
	ContentType *string `locationName:"contentType" type:"string" required:"true"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// [Required] The name of the model. Must be alphanumeric.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// [Required] The RestApi identifier under which the Model will be created.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 (https://tools.ietf.org/html/draft-zyp-json-schema-04) model.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateModelInput"}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentType sets the ContentType field's value.
func (s *CreateModelInput) SetContentType(v string) *CreateModelInput {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateModelInput) SetDescription(v string) *CreateModelInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateModelInput) SetName(v string) *CreateModelInput {
	s.Name = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateModelInput) SetRestApiId(v string) *CreateModelInput {
	s.RestApiId = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *CreateModelInput) SetSchema(v string) *CreateModelInput {
	s.Schema = &v
	return s
}

// Creates a RequestValidator of a given RestApi.
type CreateRequestValidatorInput struct {
	_ struct{} `type:"structure"`

	// The name of the to-be-created RequestValidator.
	Name *string `locationName:"name" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// A Boolean flag to indicate whether to validate request body according to
	// the configured model schema for the method (true) or not (false).
	ValidateRequestBody *bool `locationName:"validateRequestBody" type:"boolean"`

	// A Boolean flag to indicate whether to validate request parameters, true,
	// or not false.
	ValidateRequestParameters *bool `locationName:"validateRequestParameters" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRequestValidatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRequestValidatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRequestValidatorInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateRequestValidatorInput) SetName(v string) *CreateRequestValidatorInput {
	s.Name = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateRequestValidatorInput) SetRestApiId(v string) *CreateRequestValidatorInput {
	s.RestApiId = &v
	return s
}

// SetValidateRequestBody sets the ValidateRequestBody field's value.
func (s *CreateRequestValidatorInput) SetValidateRequestBody(v bool) *CreateRequestValidatorInput {
	s.ValidateRequestBody = &v
	return s
}

// SetValidateRequestParameters sets the ValidateRequestParameters field's value.
func (s *CreateRequestValidatorInput) SetValidateRequestParameters(v bool) *CreateRequestValidatorInput {
	s.ValidateRequestParameters = &v
	return s
}

// Requests API Gateway to create a Resource resource.
type CreateResourceInput struct {
	_ struct{} `type:"structure"`

	// [Required] The parent resource's identifier.
	//
	// ParentId is a required field
	ParentId *string `location:"uri" locationName:"parent_id" type:"string" required:"true"`

	// The last path segment for this resource.
	//
	// PathPart is a required field
	PathPart *string `locationName:"pathPart" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceInput"}
	if s.ParentId == nil {
		invalidParams.Add(request.NewErrParamRequired("ParentId"))
	}
	if s.ParentId != nil && len(*s.ParentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParentId", 1))
	}
	if s.PathPart == nil {
		invalidParams.Add(request.NewErrParamRequired("PathPart"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParentId sets the ParentId field's value.
func (s *CreateResourceInput) SetParentId(v string) *CreateResourceInput {
	s.ParentId = &v
	return s
}

// SetPathPart sets the PathPart field's value.
func (s *CreateResourceInput) SetPathPart(v string) *CreateResourceInput {
	s.PathPart = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateResourceInput) SetRestApiId(v string) *CreateResourceInput {
	s.RestApiId = &v
	return s
}

// The POST Request to add a new RestApi resource to your collection.
type CreateRestApiInput struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	// Valid values are:
	//    * HEADER to read the API key from the X-API-Key header of a request.
	//
	//    * AUTHORIZER to read the API key from the UsageIdentifierKey from a custom
	//    authorizer.
	ApiKeySource *string `locationName:"apiKeySource" type:"string" enum:"ApiKeySourceType"`

	// The list of binary media types supported by the RestApi. By default, the
	// RestApi supports only UTF-8-encoded text payloads.
	BinaryMediaTypes []*string `locationName:"binaryMediaTypes" type:"list"`

	// The ID of the RestApi that you want to clone from.
	CloneFrom *string `locationName:"cloneFrom" type:"string"`

	// The description of the RestApi.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether clients can invoke your API by using the default execute-api
	// endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
	// endpoint. To require that clients use a custom domain name to invoke your
	// API, disable the default endpoint.
	DisableExecuteApiEndpoint *bool `locationName:"disableExecuteApiEndpoint" type:"boolean"`

	// The endpoint configuration of this RestApi showing the endpoint types of
	// the API.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// A nullable integer that is used to enable compression (with non-negative
	// between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with
	// a null value) on an API. When compression is enabled, compression or decompression
	// is not applied on the payload if the payload size is smaller than this value.
	// Setting it to zero allows compression for any payload size.
	MinimumCompressionSize *int64 `locationName:"minimumCompressionSize" type:"integer"`

	// [Required] The name of the RestApi.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// A stringified JSON policy document that applies to this RestApi regardless
	// of the caller and Method configuration.
	Policy *string `locationName:"policy" type:"string"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRestApiInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeySource sets the ApiKeySource field's value.
func (s *CreateRestApiInput) SetApiKeySource(v string) *CreateRestApiInput {
	s.ApiKeySource = &v
	return s
}

// SetBinaryMediaTypes sets the BinaryMediaTypes field's value.
func (s *CreateRestApiInput) SetBinaryMediaTypes(v []*string) *CreateRestApiInput {
	s.BinaryMediaTypes = v
	return s
}

// SetCloneFrom sets the CloneFrom field's value.
func (s *CreateRestApiInput) SetCloneFrom(v string) *CreateRestApiInput {
	s.CloneFrom = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRestApiInput) SetDescription(v string) *CreateRestApiInput {
	s.Description = &v
	return s
}

// SetDisableExecuteApiEndpoint sets the DisableExecuteApiEndpoint field's value.
func (s *CreateRestApiInput) SetDisableExecuteApiEndpoint(v bool) *CreateRestApiInput {
	s.DisableExecuteApiEndpoint = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *CreateRestApiInput) SetEndpointConfiguration(v *EndpointConfiguration) *CreateRestApiInput {
	s.EndpointConfiguration = v
	return s
}

// SetMinimumCompressionSize sets the MinimumCompressionSize field's value.
func (s *CreateRestApiInput) SetMinimumCompressionSize(v int64) *CreateRestApiInput {
	s.MinimumCompressionSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRestApiInput) SetName(v string) *CreateRestApiInput {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CreateRestApiInput) SetPolicy(v string) *CreateRestApiInput {
	s.Policy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRestApiInput) SetTags(v map[string]*string) *CreateRestApiInput {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *CreateRestApiInput) SetVersion(v string) *CreateRestApiInput {
	s.Version = &v
	return s
}

// Requests API Gateway to create a Stage resource.
type CreateStageInput struct {
	_ struct{} `type:"structure"`

	// Whether cache clustering is enabled for the stage.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// The stage's cache cluster size.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The canary deployment settings of this stage.
	CanarySettings *CanarySettings `locationName:"canarySettings" type:"structure"`

	// [Required] The identifier of the Deployment resource for the Stage resource.
	//
	// DeploymentId is a required field
	DeploymentId *string `locationName:"deploymentId" type:"string" required:"true"`

	// The description of the Stage resource.
	Description *string `locationName:"description" type:"string"`

	// The version of the associated API documentation.
	DocumentationVersion *string `locationName:"documentationVersion" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name for the Stage resource. Stage names can only contain
	// alphanumeric characters, hyphens, and underscores. Maximum length is 128
	// characters.
	//
	// StageName is a required field
	StageName *string `locationName:"stageName" type:"string" required:"true"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Specifies whether active tracing with X-ray is enabled for the Stage.
	TracingEnabled *bool `locationName:"tracingEnabled" type:"boolean"`

	// A map that defines the stage variables for the new Stage resource. Variable
	// names can have alphanumeric and underscore characters, and the values must
	// match [A-Za-z0-9-._~:/?#&=,]+.
	Variables map[string]*string `locationName:"variables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateStageInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *CreateStageInput) SetCacheClusterEnabled(v bool) *CreateStageInput {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *CreateStageInput) SetCacheClusterSize(v string) *CreateStageInput {
	s.CacheClusterSize = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *CreateStageInput) SetCanarySettings(v *CanarySettings) *CreateStageInput {
	s.CanarySettings = v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *CreateStageInput) SetDeploymentId(v string) *CreateStageInput {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateStageInput) SetDescription(v string) *CreateStageInput {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *CreateStageInput) SetDocumentationVersion(v string) *CreateStageInput {
	s.DocumentationVersion = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *CreateStageInput) SetRestApiId(v string) *CreateStageInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *CreateStageInput) SetStageName(v string) *CreateStageInput {
	s.StageName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateStageInput) SetTags(v map[string]*string) *CreateStageInput {
	s.Tags = v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *CreateStageInput) SetTracingEnabled(v bool) *CreateStageInput {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *CreateStageInput) SetVariables(v map[string]*string) *CreateStageInput {
	s.Variables = v
	return s
}

// The POST request to create a usage plan with the name, description, throttle
// limits and quota limits, as well as the associated API stages, specified
// in the payload.
type CreateUsagePlanInput struct {
	_ struct{} `type:"structure"`

	// The associated API stages of the usage plan.
	ApiStages []*ApiStage `locationName:"apiStages" type:"list"`

	// The description of the usage plan.
	Description *string `locationName:"description" type:"string"`

	// [Required] The name of the usage plan.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The quota of the usage plan.
	Quota *QuotaSettings `locationName:"quota" type:"structure"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The throttling limits of the usage plan.
	Throttle *ThrottleSettings `locationName:"throttle" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsagePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsagePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsagePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUsagePlanInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiStages sets the ApiStages field's value.
func (s *CreateUsagePlanInput) SetApiStages(v []*ApiStage) *CreateUsagePlanInput {
	s.ApiStages = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateUsagePlanInput) SetDescription(v string) *CreateUsagePlanInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUsagePlanInput) SetName(v string) *CreateUsagePlanInput {
	s.Name = &v
	return s
}

// SetQuota sets the Quota field's value.
func (s *CreateUsagePlanInput) SetQuota(v *QuotaSettings) *CreateUsagePlanInput {
	s.Quota = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUsagePlanInput) SetTags(v map[string]*string) *CreateUsagePlanInput {
	s.Tags = v
	return s
}

// SetThrottle sets the Throttle field's value.
func (s *CreateUsagePlanInput) SetThrottle(v *ThrottleSettings) *CreateUsagePlanInput {
	s.Throttle = v
	return s
}

// The POST request to create a usage plan key for adding an existing API key
// to a usage plan.
type CreateUsagePlanKeyInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of a UsagePlanKey resource for a plan customer.
	//
	// KeyId is a required field
	KeyId *string `locationName:"keyId" type:"string" required:"true"`

	// [Required] The type of a UsagePlanKey resource for a plan customer.
	//
	// KeyType is a required field
	KeyType *string `locationName:"keyType" type:"string" required:"true"`

	// [Required] The Id of the UsagePlan resource representing the usage plan containing
	// the to-be-created UsagePlanKey resource representing a plan customer.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsagePlanKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsagePlanKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsagePlanKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUsagePlanKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyType == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyType"))
	}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *CreateUsagePlanKeyInput) SetKeyId(v string) *CreateUsagePlanKeyInput {
	s.KeyId = &v
	return s
}

// SetKeyType sets the KeyType field's value.
func (s *CreateUsagePlanKeyInput) SetKeyType(v string) *CreateUsagePlanKeyInput {
	s.KeyType = &v
	return s
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *CreateUsagePlanKeyInput) SetUsagePlanId(v string) *CreateUsagePlanKeyInput {
	s.UsagePlanId = &v
	return s
}

// Creates a VPC link, under the caller's account in a selected region, in an
// asynchronous operation that typically takes 2-4 minutes to complete and become
// operational. The caller must have permissions to create and update VPC Endpoint
// services.
type CreateVpcLinkInput struct {
	_ struct{} `type:"structure"`

	// The description of the VPC link.
	Description *string `locationName:"description" type:"string"`

	// [Required] The name used to label and identify the VPC link.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// [Required] The ARN of the network load balancer of the VPC targeted by the
	// VPC link. The network load balancer must be owned by the same AWS account
	// of the API owner.
	//
	// TargetArns is a required field
	TargetArns []*string `locationName:"targetArns" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVpcLinkInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.TargetArns == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArns"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateVpcLinkInput) SetDescription(v string) *CreateVpcLinkInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateVpcLinkInput) SetName(v string) *CreateVpcLinkInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVpcLinkInput) SetTags(v map[string]*string) *CreateVpcLinkInput {
	s.Tags = v
	return s
}

// SetTargetArns sets the TargetArns field's value.
func (s *CreateVpcLinkInput) SetTargetArns(v []*string) *CreateVpcLinkInput {
	s.TargetArns = v
	return s
}

// A request to delete the ApiKey resource.
type DeleteApiKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the ApiKey resource to be deleted.
	//
	// ApiKey is a required field
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApiKeyInput"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.ApiKey != nil && len(*s.ApiKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *DeleteApiKeyInput) SetApiKey(v string) *DeleteApiKeyInput {
	s.ApiKey = &v
	return s
}

type DeleteApiKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApiKeyOutput) GoString() string {
	return s.String()
}

// Request to delete an existing Authorizer resource.
type DeleteAuthorizerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the Authorizer resource.
	//
	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizer_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAuthorizerInput"}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *DeleteAuthorizerInput) SetAuthorizerId(v string) *DeleteAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteAuthorizerInput) SetRestApiId(v string) *DeleteAuthorizerInput {
	s.RestApiId = &v
	return s
}

type DeleteAuthorizerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAuthorizerOutput) GoString() string {
	return s.String()
}

// A request to delete the BasePathMapping resource.
type DeleteBasePathMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The base path name of the BasePathMapping resource to delete.
	//
	// To specify an empty base path, set this parameter to '(none)'.
	//
	// BasePath is a required field
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// [Required] The domain name of the BasePathMapping resource to delete.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBasePathMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBasePathMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBasePathMappingInput"}
	if s.BasePath == nil {
		invalidParams.Add(request.NewErrParamRequired("BasePath"))
	}
	if s.BasePath != nil && len(*s.BasePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePath", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePath sets the BasePath field's value.
func (s *DeleteBasePathMappingInput) SetBasePath(v string) *DeleteBasePathMappingInput {
	s.BasePath = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteBasePathMappingInput) SetDomainName(v string) *DeleteBasePathMappingInput {
	s.DomainName = &v
	return s
}

type DeleteBasePathMappingOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBasePathMappingOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteBasePathMappingOutput) GoString() string {
	return s.String()
}

// A request to delete the ClientCertificate resource.
type DeleteClientCertificateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the ClientCertificate resource to be deleted.
	//
	// ClientCertificateId is a required field
	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteClientCertificateInput"}
	if s.ClientCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientCertificateId"))
	}
	if s.ClientCertificateId != nil && len(*s.ClientCertificateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCertificateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *DeleteClientCertificateInput) SetClientCertificateId(v string) *DeleteClientCertificateInput {
	s.ClientCertificateId = &v
	return s
}

type DeleteClientCertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientCertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteClientCertificateOutput) GoString() string {
	return s.String()
}

// Requests API Gateway to delete a Deployment resource.
type DeleteDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the Deployment resource to delete.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *DeleteDeploymentInput) SetDeploymentId(v string) *DeleteDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteDeploymentInput) SetRestApiId(v string) *DeleteDeploymentInput {
	s.RestApiId = &v
	return s
}

type DeleteDeploymentOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDeploymentOutput) GoString() string {
	return s.String()
}

// Deletes an existing documentation part of an API.
type DeleteDocumentationPartInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the to-be-deleted documentation part.
	//
	// DocumentationPartId is a required field
	DocumentationPartId *string `location:"uri" locationName:"part_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentationPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentationPartInput"}
	if s.DocumentationPartId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationPartId"))
	}
	if s.DocumentationPartId != nil && len(*s.DocumentationPartId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationPartId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationPartId sets the DocumentationPartId field's value.
func (s *DeleteDocumentationPartInput) SetDocumentationPartId(v string) *DeleteDocumentationPartInput {
	s.DocumentationPartId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteDocumentationPartInput) SetRestApiId(v string) *DeleteDocumentationPartInput {
	s.RestApiId = &v
	return s
}

type DeleteDocumentationPartOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationPartOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationPartOutput) GoString() string {
	return s.String()
}

// Deletes an existing documentation version of an API.
type DeleteDocumentationVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The version identifier of a to-be-deleted documentation snapshot.
	//
	// DocumentationVersion is a required field
	DocumentationVersion *string `location:"uri" locationName:"doc_version" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDocumentationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDocumentationVersionInput"}
	if s.DocumentationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationVersion"))
	}
	if s.DocumentationVersion != nil && len(*s.DocumentationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationVersion", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *DeleteDocumentationVersionInput) SetDocumentationVersion(v string) *DeleteDocumentationVersionInput {
	s.DocumentationVersion = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteDocumentationVersionInput) SetRestApiId(v string) *DeleteDocumentationVersionInput {
	s.RestApiId = &v
	return s
}

type DeleteDocumentationVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationVersionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDocumentationVersionOutput) GoString() string {
	return s.String()
}

// A request to delete the DomainName resource.
type DeleteDomainNameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The name of the DomainName resource to be deleted.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *DeleteDomainNameInput) SetDomainName(v string) *DeleteDomainNameInput {
	s.DomainName = &v
	return s
}

type DeleteDomainNameOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainNameOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDomainNameOutput) GoString() string {
	return s.String()
}

// Clears any customization of a GatewayResponse of a specified response type
// on the given RestApi and resets it with the default settings.
type DeleteGatewayResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required]
	// The response type of the associated GatewayResponse.
	//
	// ResponseType is a required field
	ResponseType *string `location:"uri" locationName:"response_type" type:"string" required:"true" enum:"GatewayResponseType"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGatewayResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGatewayResponseInput"}
	if s.ResponseType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseType"))
	}
	if s.ResponseType != nil && len(*s.ResponseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseType", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResponseType sets the ResponseType field's value.
func (s *DeleteGatewayResponseInput) SetResponseType(v string) *DeleteGatewayResponseInput {
	s.ResponseType = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteGatewayResponseInput) SetRestApiId(v string) *DeleteGatewayResponseInput {
	s.RestApiId = &v
	return s
}

type DeleteGatewayResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteGatewayResponseOutput) GoString() string {
	return s.String()
}

// Represents a delete integration request.
type DeleteIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] Specifies a delete integration request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a delete integration request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *DeleteIntegrationInput) SetHttpMethod(v string) *DeleteIntegrationInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteIntegrationInput) SetResourceId(v string) *DeleteIntegrationInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteIntegrationInput) SetRestApiId(v string) *DeleteIntegrationInput {
	s.RestApiId = &v
	return s
}

type DeleteIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationOutput) GoString() string {
	return s.String()
}

// Represents a delete integration response request.
type DeleteIntegrationResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] Specifies a delete integration response request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a delete integration response request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] Specifies a delete integration response request's status code.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIntegrationResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *DeleteIntegrationResponseInput) SetHttpMethod(v string) *DeleteIntegrationResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteIntegrationResponseInput) SetResourceId(v string) *DeleteIntegrationResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteIntegrationResponseInput) SetRestApiId(v string) *DeleteIntegrationResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *DeleteIntegrationResponseInput) SetStatusCode(v string) *DeleteIntegrationResponseInput {
	s.StatusCode = &v
	return s
}

type DeleteIntegrationResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIntegrationResponseOutput) GoString() string {
	return s.String()
}

// Request to delete an existing Method resource.
type DeleteMethodInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] The Resource identifier for the Method resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMethodInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *DeleteMethodInput) SetHttpMethod(v string) *DeleteMethodInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteMethodInput) SetResourceId(v string) *DeleteMethodInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteMethodInput) SetRestApiId(v string) *DeleteMethodInput {
	s.RestApiId = &v
	return s
}

type DeleteMethodOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodOutput) GoString() string {
	return s.String()
}

// A request to delete an existing MethodResponse resource.
type DeleteMethodResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] The Resource identifier for the MethodResponse resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The status code identifier for the MethodResponse resource.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteMethodResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteMethodResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *DeleteMethodResponseInput) SetHttpMethod(v string) *DeleteMethodResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteMethodResponseInput) SetResourceId(v string) *DeleteMethodResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteMethodResponseInput) SetRestApiId(v string) *DeleteMethodResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *DeleteMethodResponseInput) SetStatusCode(v string) *DeleteMethodResponseInput {
	s.StatusCode = &v
	return s
}

type DeleteMethodResponseOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteMethodResponseOutput) GoString() string {
	return s.String()
}

// Request to delete an existing model in an existing RestApi resource.
type DeleteModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The name of the model to delete.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *DeleteModelInput) SetModelName(v string) *DeleteModelInput {
	s.ModelName = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteModelInput) SetRestApiId(v string) *DeleteModelInput {
	s.RestApiId = &v
	return s
}

type DeleteModelOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteModelOutput) GoString() string {
	return s.String()
}

// Deletes a specified RequestValidator of a given RestApi.
type DeleteRequestValidatorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the RequestValidator to be deleted.
	//
	// RequestValidatorId is a required field
	RequestValidatorId *string `location:"uri" locationName:"requestvalidator_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRequestValidatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRequestValidatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRequestValidatorInput"}
	if s.RequestValidatorId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestValidatorId"))
	}
	if s.RequestValidatorId != nil && len(*s.RequestValidatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestValidatorId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestValidatorId sets the RequestValidatorId field's value.
func (s *DeleteRequestValidatorInput) SetRequestValidatorId(v string) *DeleteRequestValidatorInput {
	s.RequestValidatorId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteRequestValidatorInput) SetRestApiId(v string) *DeleteRequestValidatorInput {
	s.RestApiId = &v
	return s
}

type DeleteRequestValidatorOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRequestValidatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRequestValidatorOutput) GoString() string {
	return s.String()
}

// Request to delete a Resource.
type DeleteResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the Resource resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteResourceInput) SetResourceId(v string) *DeleteResourceInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteResourceInput) SetRestApiId(v string) *DeleteResourceInput {
	s.RestApiId = &v
	return s
}

type DeleteResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourceOutput) GoString() string {
	return s.String()
}

// Request to delete the specified API from your collection.
type DeleteRestApiInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRestApiInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteRestApiInput) SetRestApiId(v string) *DeleteRestApiInput {
	s.RestApiId = &v
	return s
}

type DeleteRestApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestApiOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteRestApiOutput) GoString() string {
	return s.String()
}

// Requests API Gateway to delete a Stage resource.
type DeleteStageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the Stage resource to delete.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteStageInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *DeleteStageInput) SetRestApiId(v string) *DeleteStageInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *DeleteStageInput) SetStageName(v string) *DeleteStageInput {
	s.StageName = &v
	return s
}

type DeleteStageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteStageOutput) GoString() string {
	return s.String()
}

// The DELETE request to delete a usage plan of a given plan Id.
type DeleteUsagePlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The Id of the to-be-deleted usage plan.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUsagePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUsagePlanInput"}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *DeleteUsagePlanInput) SetUsagePlanId(v string) *DeleteUsagePlanInput {
	s.UsagePlanId = &v
	return s
}

// The DELETE request to delete a usage plan key and remove the underlying API
// key from the associated usage plan.
type DeleteUsagePlanKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The Id of the UsagePlanKey resource to be deleted.
	//
	// KeyId is a required field
	KeyId *string `location:"uri" locationName:"keyId" type:"string" required:"true"`

	// [Required] The Id of the UsagePlan resource representing the usage plan containing
	// the to-be-deleted UsagePlanKey resource representing a plan customer.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUsagePlanKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUsagePlanKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *DeleteUsagePlanKeyInput) SetKeyId(v string) *DeleteUsagePlanKeyInput {
	s.KeyId = &v
	return s
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *DeleteUsagePlanKeyInput) SetUsagePlanId(v string) *DeleteUsagePlanKeyInput {
	s.UsagePlanId = &v
	return s
}

type DeleteUsagePlanKeyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanKeyOutput) GoString() string {
	return s.String()
}

type DeleteUsagePlanOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsagePlanOutput) GoString() string {
	return s.String()
}

// Deletes an existing VpcLink of a specified identifier.
type DeleteVpcLinkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the VpcLink. It is used in an Integration to
	// reference this VpcLink.
	//
	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpclink_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteVpcLinkInput"}
	if s.VpcLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcLinkId"))
	}
	if s.VpcLinkId != nil && len(*s.VpcLinkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcLinkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *DeleteVpcLinkInput) SetVpcLinkId(v string) *DeleteVpcLinkInput {
	s.VpcLinkId = &v
	return s
}

type DeleteVpcLinkOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcLinkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteVpcLinkOutput) GoString() string {
	return s.String()
}

// An immutable representation of a RestApi resource that can be called by users
// using Stages. A deployment must be associated with a Stage for it to be callable
// over the Internet.
//
// To create a deployment, call POST on the Deployments resource of a RestApi.
// To view, update, or delete a deployment, call GET, PATCH, or DELETE on the
// specified deployment resource (/restapis/{restapi_id}/deployments/{deployment_id}).
//
// RestApi, Deployments, Stage, AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html),
// AWS SDKs (https://aws.amazon.com/tools/)
type Deployment struct {
	_ struct{} `type:"structure"`

	// A summary of the RestApi at the date and time that the deployment resource
	// was created.
	ApiSummary map[string]map[string]*MethodSnapshot `locationName:"apiSummary" type:"map"`

	// The date and time that the deployment resource was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description for the deployment resource.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the deployment resource.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Deployment) GoString() string {
	return s.String()
}

// SetApiSummary sets the ApiSummary field's value.
func (s *Deployment) SetApiSummary(v map[string]map[string]*MethodSnapshot) *Deployment {
	s.ApiSummary = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Deployment) SetCreatedDate(v time.Time) *Deployment {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Deployment) SetDescription(v string) *Deployment {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Deployment) SetId(v string) *Deployment {
	s.Id = &v
	return s
}

// The input configuration for a canary deployment.
type DeploymentCanarySettings struct {
	_ struct{} `type:"structure"`

	// The percentage (0.0-100.0) of traffic routed to the canary deployment.
	PercentTraffic *float64 `locationName:"percentTraffic" type:"double"`

	// A stage variable overrides used for the canary release deployment. They can
	// override existing stage variables or add new stage variables for the canary
	// release deployment. These stage variables are represented as a string-to-string
	// map between stage variable names and their values.
	StageVariableOverrides map[string]*string `locationName:"stageVariableOverrides" type:"map"`

	// A Boolean flag to indicate whether the canary release deployment uses the
	// stage cache or not.
	UseStageCache *bool `locationName:"useStageCache" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentCanarySettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeploymentCanarySettings) GoString() string {
	return s.String()
}

// SetPercentTraffic sets the PercentTraffic field's value.
func (s *DeploymentCanarySettings) SetPercentTraffic(v float64) *DeploymentCanarySettings {
	s.PercentTraffic = &v
	return s
}

// SetStageVariableOverrides sets the StageVariableOverrides field's value.
func (s *DeploymentCanarySettings) SetStageVariableOverrides(v map[string]*string) *DeploymentCanarySettings {
	s.StageVariableOverrides = v
	return s
}

// SetUseStageCache sets the UseStageCache field's value.
func (s *DeploymentCanarySettings) SetUseStageCache(v bool) *DeploymentCanarySettings {
	s.UseStageCache = &v
	return s
}

// A documentation part for a targeted API entity.
//
// A documentation part consists of a content map (properties) and a target
// (location). The target specifies an API entity to which the documentation
// content applies. The supported API entity types are API, AUTHORIZER, MODEL,
// RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY,
// RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. Valid location fields depend
// on the API entity type. All valid fields are not required.
//
// The content map is a JSON string of API-specific key-value pairs. Although
// an API can use any shape for the content map, only the OpenAPI-compliant
// documentation fields will be injected into the associated API entity definition
// in the exported OpenAPI definition file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationParts
type DocumentationPart struct {
	_ struct{} `type:"structure"`

	// The DocumentationPart identifier, generated by API Gateway when the DocumentationPart
	// is created.
	Id *string `locationName:"id" type:"string"`

	// The location of the API entity to which the documentation applies. Valid
	// fields depend on the targeted API entity type. All the valid location fields
	// are not required. If not explicitly specified, a valid location field is
	// treated as a wildcard and associated documentation content may be inherited
	// by matching entities, unless overridden.
	Location *DocumentationPartLocation `locationName:"location" type:"structure"`

	// A content map of API-specific key-value pairs describing the targeted API
	// entity. The map must be encoded as a JSON string, e.g., "{ \"description\":
	// \"The API does ...\" }". Only OpenAPI-compliant documentation-related fields
	// from the properties map are exported and, hence, published as part of the
	// API entity definitions, while the original documentation parts are exported
	// in a OpenAPI extension of x-amazon-apigateway-documentation.
	Properties *string `locationName:"properties" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationPart) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationPart) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *DocumentationPart) SetId(v string) *DocumentationPart {
	s.Id = &v
	return s
}

// SetLocation sets the Location field's value.
func (s *DocumentationPart) SetLocation(v *DocumentationPartLocation) *DocumentationPart {
	s.Location = v
	return s
}

// SetProperties sets the Properties field's value.
func (s *DocumentationPart) SetProperties(v string) *DocumentationPart {
	s.Properties = &v
	return s
}

// Specifies the target API entity to which the documentation applies.
type DocumentationPartLocation struct {
	_ struct{} `type:"structure"`

	// The HTTP verb of a method. It is a valid field for the API entity types of
	// METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY, RESPONSE,
	// RESPONSE_HEADER, and RESPONSE_BODY. The default value is * for any method.
	// When an applicable child entity inherits the content of an entity of the
	// same type with more general specifications of the other location attributes,
	// the child entity's method attribute must match that of the parent entity
	// exactly.
	Method *string `locationName:"method" type:"string"`

	// The name of the targeted API entity. It is a valid and required field for
	// the API entity types of AUTHORIZER, MODEL, PATH_PARAMETER, QUERY_PARAMETER,
	// REQUEST_HEADER, REQUEST_BODY and RESPONSE_HEADER. It is an invalid field
	// for any other entity type.
	Name *string `locationName:"name" type:"string"`

	// The URL path of the target. It is a valid field for the API entity types
	// of RESOURCE, METHOD, PATH_PARAMETER, QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY,
	// RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. The default value is / for
	// the root resource. When an applicable child entity inherits the content of
	// another entity of the same type with more general specifications of the other
	// location attributes, the child entity's path attribute must match that of
	// the parent entity as a prefix.
	Path *string `locationName:"path" type:"string"`

	// The HTTP status code of a response. It is a valid field for the API entity
	// types of RESPONSE, RESPONSE_HEADER, and RESPONSE_BODY. The default value
	// is * for any status code. When an applicable child entity inherits the content
	// of an entity of the same type with more general specifications of the other
	// location attributes, the child entity's statusCode attribute must match that
	// of the parent entity exactly.
	StatusCode *string `locationName:"statusCode" type:"string"`

	// [Required] The type of API entity to which the documentation content applies.
	// Valid values are API, AUTHORIZER, MODEL, RESOURCE, METHOD, PATH_PARAMETER,
	// QUERY_PARAMETER, REQUEST_HEADER, REQUEST_BODY, RESPONSE, RESPONSE_HEADER,
	// and RESPONSE_BODY. Content inheritance does not apply to any entity of the
	// API, AUTHORIZER, METHOD, MODEL, REQUEST_BODY, or RESOURCE type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"DocumentationPartType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationPartLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationPartLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentationPartLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentationPartLocation"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMethod sets the Method field's value.
func (s *DocumentationPartLocation) SetMethod(v string) *DocumentationPartLocation {
	s.Method = &v
	return s
}

// SetName sets the Name field's value.
func (s *DocumentationPartLocation) SetName(v string) *DocumentationPartLocation {
	s.Name = &v
	return s
}

// SetPath sets the Path field's value.
func (s *DocumentationPartLocation) SetPath(v string) *DocumentationPartLocation {
	s.Path = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *DocumentationPartLocation) SetStatusCode(v string) *DocumentationPartLocation {
	s.StatusCode = &v
	return s
}

// SetType sets the Type field's value.
func (s *DocumentationPartLocation) SetType(v string) *DocumentationPartLocation {
	s.Type = &v
	return s
}

// A snapshot of the documentation of an API.
//
// Publishing API documentation involves creating a documentation version associated
// with an API stage and exporting the versioned documentation to an external
// (e.g., OpenAPI) file.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart, DocumentationVersions
type DocumentationVersion struct {
	_ struct{} `type:"structure"`

	// The date when the API documentation snapshot is created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The description of the API documentation snapshot.
	Description *string `locationName:"description" type:"string"`

	// The version identifier of the API documentation snapshot.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationVersion) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentationVersion) GoString() string {
	return s.String()
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *DocumentationVersion) SetCreatedDate(v time.Time) *DocumentationVersion {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DocumentationVersion) SetDescription(v string) *DocumentationVersion {
	s.Description = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *DocumentationVersion) SetVersion(v string) *DocumentationVersion {
	s.Version = &v
	return s
}

// Represents a custom domain name as a user-friendly host name of an API (RestApi).
//
// When you deploy an API, API Gateway creates a default host name for the API.
// This default API host name is of the {restapi-id}.execute-api.{region}.amazonaws.com
// format. With the default host name, you can access the API's root resource
// with the URL of https://{restapi-id}.execute-api.{region}.amazonaws.com/{stage}/.
// When you set up a custom domain name of apis.example.com for this API, you
// can then access the same resource using the URL of the https://apis.examples.com/myApi,
// where myApi is the base path mapping (BasePathMapping) of your API under
// the custom domain name.
//
// Set a Custom Host Name for an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type DomainName struct {
	_ struct{} `type:"structure"`

	// The reference to an AWS-managed certificate that will be used by edge-optimized
	// endpoint for this domain name. AWS Certificate Manager is the only supported
	// source.
	CertificateArn *string `locationName:"certificateArn" type:"string"`

	// The name of the certificate that will be used by edge-optimized endpoint
	// for this domain name.
	CertificateName *string `locationName:"certificateName" type:"string"`

	// The timestamp when the certificate that was used by edge-optimized endpoint
	// for this domain name was uploaded.
	CertificateUploadDate *time.Time `locationName:"certificateUploadDate" type:"timestamp"`

	// The domain name of the Amazon CloudFront distribution associated with this
	// custom domain name for an edge-optimized endpoint. You set up this association
	// when adding a DNS record pointing the custom domain name to this distribution
	// name. For more information about CloudFront distributions, see the Amazon
	// CloudFront documentation (https://aws.amazon.com/documentation/cloudfront/).
	DistributionDomainName *string `locationName:"distributionDomainName" type:"string"`

	// The region-agnostic Amazon Route 53 Hosted Zone ID of the edge-optimized
	// endpoint. The valid value is Z2FDTNDATAQYW2 for all the regions. For more
	// information, see Set up a Regional Custom Domain Name (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html)
	// and AWS Regions and Endpoints for API Gateway (https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region).
	DistributionHostedZoneId *string `locationName:"distributionHostedZoneId" type:"string"`

	// The custom domain name as an API host name, for example, my-api.example.com.
	DomainName *string `locationName:"domainName" type:"string"`

	// The status of the DomainName migration. The valid values are AVAILABLE, UPDATING,
	// PENDING_CERTIFICATE_REIMPORT, and PENDING_OWNERSHIP_VERIFICATION. If the
	// status is UPDATING, the domain cannot be modified further until the existing
	// operation is complete. If it is AVAILABLE, the domain can be updated.
	DomainNameStatus *string `locationName:"domainNameStatus" type:"string" enum:"DomainNameStatus"`

	// An optional text message containing detailed information about status of
	// the DomainName migration.
	DomainNameStatusMessage *string `locationName:"domainNameStatusMessage" type:"string"`

	// The endpoint configuration of this DomainName showing the endpoint types
	// of the domain name.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// The mutual TLS authentication configuration for a custom domain name. If
	// specified, API Gateway performs two-way authentication between the client
	// and the server. Clients must present a trusted certificate to access your
	// API.
	MutualTlsAuthentication *MutualTlsAuthentication `locationName:"mutualTlsAuthentication" type:"structure"`

	// The ARN of the public certificate issued by ACM to validate ownership of
	// your custom domain. Only required when configuring mutual TLS and using an
	// ACM imported or private CA certificate ARN as the regionalCertificateArn.
	OwnershipVerificationCertificateArn *string `locationName:"ownershipVerificationCertificateArn" type:"string"`

	// The reference to an AWS-managed certificate that will be used for validating
	// the regional domain name. AWS Certificate Manager is the only supported source.
	RegionalCertificateArn *string `locationName:"regionalCertificateArn" type:"string"`

	// The name of the certificate that will be used for validating the regional
	// domain name.
	RegionalCertificateName *string `locationName:"regionalCertificateName" type:"string"`

	// The domain name associated with the regional endpoint for this custom domain
	// name. You set up this association by adding a DNS record that points the
	// custom domain name to this regional domain name. The regional domain name
	// is returned by API Gateway when you create a regional endpoint.
	RegionalDomainName *string `locationName:"regionalDomainName" type:"string"`

	// The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
	// For more information, see Set up a Regional Custom Domain Name (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-regional-api-custom-domain-create.html)
	// and AWS Regions and Endpoints for API Gateway (https://docs.aws.amazon.com/general/latest/gr/rande.html#apigateway_region).
	RegionalHostedZoneId *string `locationName:"regionalHostedZoneId" type:"string"`

	// The Transport Layer Security (TLS) version + cipher suite for this DomainName.
	// The valid values are TLS_1_0 and TLS_1_2.
	SecurityPolicy *string `locationName:"securityPolicy" type:"string" enum:"SecurityPolicy"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainName) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DomainName) GoString() string {
	return s.String()
}

// SetCertificateArn sets the CertificateArn field's value.
func (s *DomainName) SetCertificateArn(v string) *DomainName {
	s.CertificateArn = &v
	return s
}

// SetCertificateName sets the CertificateName field's value.
func (s *DomainName) SetCertificateName(v string) *DomainName {
	s.CertificateName = &v
	return s
}

// SetCertificateUploadDate sets the CertificateUploadDate field's value.
func (s *DomainName) SetCertificateUploadDate(v time.Time) *DomainName {
	s.CertificateUploadDate = &v
	return s
}

// SetDistributionDomainName sets the DistributionDomainName field's value.
func (s *DomainName) SetDistributionDomainName(v string) *DomainName {
	s.DistributionDomainName = &v
	return s
}

// SetDistributionHostedZoneId sets the DistributionHostedZoneId field's value.
func (s *DomainName) SetDistributionHostedZoneId(v string) *DomainName {
	s.DistributionHostedZoneId = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *DomainName) SetDomainName(v string) *DomainName {
	s.DomainName = &v
	return s
}

// SetDomainNameStatus sets the DomainNameStatus field's value.
func (s *DomainName) SetDomainNameStatus(v string) *DomainName {
	s.DomainNameStatus = &v
	return s
}

// SetDomainNameStatusMessage sets the DomainNameStatusMessage field's value.
func (s *DomainName) SetDomainNameStatusMessage(v string) *DomainName {
	s.DomainNameStatusMessage = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *DomainName) SetEndpointConfiguration(v *EndpointConfiguration) *DomainName {
	s.EndpointConfiguration = v
	return s
}

// SetMutualTlsAuthentication sets the MutualTlsAuthentication field's value.
func (s *DomainName) SetMutualTlsAuthentication(v *MutualTlsAuthentication) *DomainName {
	s.MutualTlsAuthentication = v
	return s
}

// SetOwnershipVerificationCertificateArn sets the OwnershipVerificationCertificateArn field's value.
func (s *DomainName) SetOwnershipVerificationCertificateArn(v string) *DomainName {
	s.OwnershipVerificationCertificateArn = &v
	return s
}

// SetRegionalCertificateArn sets the RegionalCertificateArn field's value.
func (s *DomainName) SetRegionalCertificateArn(v string) *DomainName {
	s.RegionalCertificateArn = &v
	return s
}

// SetRegionalCertificateName sets the RegionalCertificateName field's value.
func (s *DomainName) SetRegionalCertificateName(v string) *DomainName {
	s.RegionalCertificateName = &v
	return s
}

// SetRegionalDomainName sets the RegionalDomainName field's value.
func (s *DomainName) SetRegionalDomainName(v string) *DomainName {
	s.RegionalDomainName = &v
	return s
}

// SetRegionalHostedZoneId sets the RegionalHostedZoneId field's value.
func (s *DomainName) SetRegionalHostedZoneId(v string) *DomainName {
	s.RegionalHostedZoneId = &v
	return s
}

// SetSecurityPolicy sets the SecurityPolicy field's value.
func (s *DomainName) SetSecurityPolicy(v string) *DomainName {
	s.SecurityPolicy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DomainName) SetTags(v map[string]*string) *DomainName {
	s.Tags = v
	return s
}

// The endpoint configuration to indicate the types of endpoints an API (RestApi)
// or its custom domain name (DomainName) has.
type EndpointConfiguration struct {
	_ struct{} `type:"structure"`

	// A list of endpoint types of an API (RestApi) or its custom domain name (DomainName).
	// For an edge-optimized API and its custom domain name, the endpoint type is
	// "EDGE". For a regional API and its custom domain name, the endpoint type
	// is REGIONAL. For a private API, the endpoint type is PRIVATE.
	Types []*string `locationName:"types" type:"list"`

	// A list of VpcEndpointIds of an API (RestApi) against which to create Route53
	// ALIASes. It is only supported for PRIVATE endpoint type.
	VpcEndpointIds []*string `locationName:"vpcEndpointIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointConfiguration) GoString() string {
	return s.String()
}

// SetTypes sets the Types field's value.
func (s *EndpointConfiguration) SetTypes(v []*string) *EndpointConfiguration {
	s.Types = v
	return s
}

// SetVpcEndpointIds sets the VpcEndpointIds field's value.
func (s *EndpointConfiguration) SetVpcEndpointIds(v []*string) *EndpointConfiguration {
	s.VpcEndpointIds = v
	return s
}

// Request to flush authorizer cache entries on a specified stage.
type FlushStageAuthorizersCacheInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The name of the stage to flush.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageAuthorizersCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageAuthorizersCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlushStageAuthorizersCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlushStageAuthorizersCacheInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *FlushStageAuthorizersCacheInput) SetRestApiId(v string) *FlushStageAuthorizersCacheInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *FlushStageAuthorizersCacheInput) SetStageName(v string) *FlushStageAuthorizersCacheInput {
	s.StageName = &v
	return s
}

type FlushStageAuthorizersCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageAuthorizersCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageAuthorizersCacheOutput) GoString() string {
	return s.String()
}

// Requests API Gateway to flush a stage's cache.
type FlushStageCacheInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the stage to flush its cache.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageCacheInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageCacheInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlushStageCacheInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FlushStageCacheInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *FlushStageCacheInput) SetRestApiId(v string) *FlushStageCacheInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *FlushStageCacheInput) SetStageName(v string) *FlushStageCacheInput {
	s.StageName = &v
	return s
}

type FlushStageCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FlushStageCacheOutput) GoString() string {
	return s.String()
}

// A request to generate a ClientCertificate resource.
type GenerateClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// The description of the ClientCertificate.
	Description *string `locationName:"description" type:"string"`

	// The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GenerateClientCertificateInput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GenerateClientCertificateInput) SetDescription(v string) *GenerateClientCertificateInput {
	s.Description = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GenerateClientCertificateInput) SetTags(v map[string]*string) *GenerateClientCertificateInput {
	s.Tags = v
	return s
}

// Requests API Gateway to get information about the current Account resource.
type GetAccountInput struct {
	_ struct{} `type:"structure" nopayload:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAccountInput) GoString() string {
	return s.String()
}

// A request to get information about the current ApiKey resource.
type GetApiKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the ApiKey resource.
	//
	// ApiKey is a required field
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`

	// A boolean flag to specify whether (true) or not (false) the result contains
	// the key value.
	IncludeValue *bool `location:"querystring" locationName:"includeValue" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApiKeyInput"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.ApiKey != nil && len(*s.ApiKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *GetApiKeyInput) SetApiKey(v string) *GetApiKeyInput {
	s.ApiKey = &v
	return s
}

// SetIncludeValue sets the IncludeValue field's value.
func (s *GetApiKeyInput) SetIncludeValue(v bool) *GetApiKeyInput {
	s.IncludeValue = &v
	return s
}

// A request to get information about the current ApiKeys resource.
type GetApiKeysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of a customer in AWS Marketplace or an external system, such
	// as a developer portal.
	CustomerId *string `location:"querystring" locationName:"customerId" type:"string"`

	// A boolean flag to specify whether (true) or not (false) the result contains
	// key values.
	IncludeValues *bool `location:"querystring" locationName:"includeValues" type:"boolean"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The name of queried API keys.
	NameQuery *string `location:"querystring" locationName:"name" type:"string"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeysInput) GoString() string {
	return s.String()
}

// SetCustomerId sets the CustomerId field's value.
func (s *GetApiKeysInput) SetCustomerId(v string) *GetApiKeysInput {
	s.CustomerId = &v
	return s
}

// SetIncludeValues sets the IncludeValues field's value.
func (s *GetApiKeysInput) SetIncludeValues(v bool) *GetApiKeysInput {
	s.IncludeValues = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetApiKeysInput) SetLimit(v int64) *GetApiKeysInput {
	s.Limit = &v
	return s
}

// SetNameQuery sets the NameQuery field's value.
func (s *GetApiKeysInput) SetNameQuery(v string) *GetApiKeysInput {
	s.NameQuery = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetApiKeysInput) SetPosition(v string) *GetApiKeysInput {
	s.Position = &v
	return s
}

// Represents a collection of API keys as represented by an ApiKeys resource.
//
// Use API Keys (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-api-keys.html)
type GetApiKeysOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*ApiKey `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`

	// A list of warning messages logged during the import of API keys when the
	// failOnWarnings option is set to true.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApiKeysOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetApiKeysOutput) SetItems(v []*ApiKey) *GetApiKeysOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetApiKeysOutput) SetPosition(v string) *GetApiKeysOutput {
	s.Position = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetApiKeysOutput) SetWarnings(v []*string) *GetApiKeysOutput {
	s.Warnings = v
	return s
}

// Request to describe an existing Authorizer resource.
type GetAuthorizerInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the Authorizer resource.
	//
	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizer_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizerInput"}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *GetAuthorizerInput) SetAuthorizerId(v string) *GetAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetAuthorizerInput) SetRestApiId(v string) *GetAuthorizerInput {
	s.RestApiId = &v
	return s
}

// Request to describe an existing Authorizers resource.
type GetAuthorizersInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAuthorizersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAuthorizersInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetAuthorizersInput) SetLimit(v int64) *GetAuthorizersInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetAuthorizersInput) SetPosition(v string) *GetAuthorizersInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetAuthorizersInput) SetRestApiId(v string) *GetAuthorizersInput {
	s.RestApiId = &v
	return s
}

// Represents a collection of Authorizer resources.
//
// Use Lambda Function as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html)
// Use Cognito User Pool as Authorizer (https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html)
type GetAuthorizersOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*Authorizer `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAuthorizersOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetAuthorizersOutput) SetItems(v []*Authorizer) *GetAuthorizersOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetAuthorizersOutput) SetPosition(v string) *GetAuthorizersOutput {
	s.Position = &v
	return s
}

// Request to describe a BasePathMapping resource.
type GetBasePathMappingInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The base path name that callers of the API must provide as part
	// of the URL after the domain name. This value must be unique for all of the
	// mappings across a single API. Specify '(none)' if you do not want callers
	// to specify any base path name after the domain name.
	//
	// BasePath is a required field
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// [Required] The domain name of the BasePathMapping resource to be described.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBasePathMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBasePathMappingInput"}
	if s.BasePath == nil {
		invalidParams.Add(request.NewErrParamRequired("BasePath"))
	}
	if s.BasePath != nil && len(*s.BasePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePath", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePath sets the BasePath field's value.
func (s *GetBasePathMappingInput) SetBasePath(v string) *GetBasePathMappingInput {
	s.BasePath = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *GetBasePathMappingInput) SetDomainName(v string) *GetBasePathMappingInput {
	s.DomainName = &v
	return s
}

// A request to get information about a collection of BasePathMapping resources.
type GetBasePathMappingsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The domain name of a BasePathMapping resource.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetBasePathMappingsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetBasePathMappingsInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetBasePathMappingsInput) SetDomainName(v string) *GetBasePathMappingsInput {
	s.DomainName = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetBasePathMappingsInput) SetLimit(v int64) *GetBasePathMappingsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetBasePathMappingsInput) SetPosition(v string) *GetBasePathMappingsInput {
	s.Position = &v
	return s
}

// Represents a collection of BasePathMapping resources.
//
// Use Custom Domain Names (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type GetBasePathMappingsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*BasePathMapping `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetBasePathMappingsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetBasePathMappingsOutput) SetItems(v []*BasePathMapping) *GetBasePathMappingsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetBasePathMappingsOutput) SetPosition(v string) *GetBasePathMappingsOutput {
	s.Position = &v
	return s
}

// A request to get information about the current ClientCertificate resource.
type GetClientCertificateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the ClientCertificate resource to be described.
	//
	// ClientCertificateId is a required field
	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetClientCertificateInput"}
	if s.ClientCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientCertificateId"))
	}
	if s.ClientCertificateId != nil && len(*s.ClientCertificateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCertificateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *GetClientCertificateInput) SetClientCertificateId(v string) *GetClientCertificateInput {
	s.ClientCertificateId = &v
	return s
}

// A request to get information about a collection of ClientCertificate resources.
type GetClientCertificatesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificatesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificatesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetClientCertificatesInput) SetLimit(v int64) *GetClientCertificatesInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetClientCertificatesInput) SetPosition(v string) *GetClientCertificatesInput {
	s.Position = &v
	return s
}

// Represents a collection of ClientCertificate resources.
//
// Use Client-Side Certificate (https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-client-side-ssl-authentication.html)
type GetClientCertificatesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*ClientCertificate `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificatesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetClientCertificatesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetClientCertificatesOutput) SetItems(v []*ClientCertificate) *GetClientCertificatesOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetClientCertificatesOutput) SetPosition(v string) *GetClientCertificatesOutput {
	s.Position = &v
	return s
}

// Requests API Gateway to get information about a Deployment resource.
type GetDeploymentInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the Deployment resource to get information about.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// A query parameter to retrieve the specified embedded resources of the returned
	// Deployment resource in the response. In a REST API call, this embed parameter
	// value is a list of comma-separated strings, as in GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=var1,var2.
	// The SDK and other platform-dependent libraries might use a different format
	// for the list. Currently, this request supports only retrieval of the embedded
	// API summary this way. Hence, the parameter value must be a single-valued
	// list containing only the "apisummary" string. For example, GET /restapis/{restapi_id}/deployments/{deployment_id}?embed=apisummary.
	Embed []*string `location:"querystring" locationName:"embed" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetDeploymentInput) SetDeploymentId(v string) *GetDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetEmbed sets the Embed field's value.
func (s *GetDeploymentInput) SetEmbed(v []*string) *GetDeploymentInput {
	s.Embed = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDeploymentInput) SetRestApiId(v string) *GetDeploymentInput {
	s.RestApiId = &v
	return s
}

// Requests API Gateway to get information about a Deployments collection.
type GetDeploymentsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDeploymentsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDeploymentsInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetDeploymentsInput) SetLimit(v int64) *GetDeploymentsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDeploymentsInput) SetPosition(v string) *GetDeploymentsInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDeploymentsInput) SetRestApiId(v string) *GetDeploymentsInput {
	s.RestApiId = &v
	return s
}

// Represents a collection resource that contains zero or more references to
// your existing deployments, and links that guide you on how to interact with
// your collection. The collection offers a paginated view of the contained
// deployments.
//
// To create a new deployment of a RestApi, make a POST request against this
// resource. To view, update, or delete an existing deployment, make a GET,
// PATCH, or DELETE request, respectively, on a specified Deployment resource.
//
// Deploying an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html),
// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-deployment.html),
// AWS SDKs (https://aws.amazon.com/tools/)
type GetDeploymentsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*Deployment `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDeploymentsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDeploymentsOutput) SetItems(v []*Deployment) *GetDeploymentsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDeploymentsOutput) SetPosition(v string) *GetDeploymentsOutput {
	s.Position = &v
	return s
}

// Gets a specified documentation part of a given API.
type GetDocumentationPartInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// DocumentationPartId is a required field
	DocumentationPartId *string `location:"uri" locationName:"part_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentationPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentationPartInput"}
	if s.DocumentationPartId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationPartId"))
	}
	if s.DocumentationPartId != nil && len(*s.DocumentationPartId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationPartId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationPartId sets the DocumentationPartId field's value.
func (s *GetDocumentationPartInput) SetDocumentationPartId(v string) *GetDocumentationPartInput {
	s.DocumentationPartId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDocumentationPartInput) SetRestApiId(v string) *GetDocumentationPartInput {
	s.RestApiId = &v
	return s
}

// Gets the documentation parts of an API. The result may be filtered by the
// type, name, or path of API entities (targets).
type GetDocumentationPartsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The status of the API documentation parts to retrieve. Valid values are DOCUMENTED
	// for retrieving DocumentationPart resources with content and UNDOCUMENTED
	// for DocumentationPart resources without content.
	LocationStatus *string `location:"querystring" locationName:"locationStatus" type:"string" enum:"LocationStatusType"`

	// The name of API entities of the to-be-retrieved documentation parts.
	NameQuery *string `location:"querystring" locationName:"name" type:"string"`

	// The path of API entities of the to-be-retrieved documentation parts.
	Path *string `location:"querystring" locationName:"path" type:"string"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The type of API entities of the to-be-retrieved documentation parts.
	Type *string `location:"querystring" locationName:"type" type:"string" enum:"DocumentationPartType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentationPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentationPartsInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetDocumentationPartsInput) SetLimit(v int64) *GetDocumentationPartsInput {
	s.Limit = &v
	return s
}

// SetLocationStatus sets the LocationStatus field's value.
func (s *GetDocumentationPartsInput) SetLocationStatus(v string) *GetDocumentationPartsInput {
	s.LocationStatus = &v
	return s
}

// SetNameQuery sets the NameQuery field's value.
func (s *GetDocumentationPartsInput) SetNameQuery(v string) *GetDocumentationPartsInput {
	s.NameQuery = &v
	return s
}

// SetPath sets the Path field's value.
func (s *GetDocumentationPartsInput) SetPath(v string) *GetDocumentationPartsInput {
	s.Path = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDocumentationPartsInput) SetPosition(v string) *GetDocumentationPartsInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDocumentationPartsInput) SetRestApiId(v string) *GetDocumentationPartsInput {
	s.RestApiId = &v
	return s
}

// SetType sets the Type field's value.
func (s *GetDocumentationPartsInput) SetType(v string) *GetDocumentationPartsInput {
	s.Type = &v
	return s
}

// The collection of documentation parts of an API.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart
type GetDocumentationPartsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*DocumentationPart `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationPartsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDocumentationPartsOutput) SetItems(v []*DocumentationPart) *GetDocumentationPartsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDocumentationPartsOutput) SetPosition(v string) *GetDocumentationPartsOutput {
	s.Position = &v
	return s
}

// Gets a documentation snapshot of an API.
type GetDocumentationVersionInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The version identifier of the to-be-retrieved documentation snapshot.
	//
	// DocumentationVersion is a required field
	DocumentationVersion *string `location:"uri" locationName:"doc_version" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentationVersionInput"}
	if s.DocumentationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationVersion"))
	}
	if s.DocumentationVersion != nil && len(*s.DocumentationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationVersion", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *GetDocumentationVersionInput) SetDocumentationVersion(v string) *GetDocumentationVersionInput {
	s.DocumentationVersion = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDocumentationVersionInput) SetRestApiId(v string) *GetDocumentationVersionInput {
	s.RestApiId = &v
	return s
}

// Gets the documentation versions of an API.
type GetDocumentationVersionsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentationVersionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentationVersionsInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetDocumentationVersionsInput) SetLimit(v int64) *GetDocumentationVersionsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDocumentationVersionsInput) SetPosition(v string) *GetDocumentationVersionsInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetDocumentationVersionsInput) SetRestApiId(v string) *GetDocumentationVersionsInput {
	s.RestApiId = &v
	return s
}

// The collection of documentation snapshots of an API.
//
// Use the DocumentationVersions to manage documentation snapshots associated
// with various API stages.
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// DocumentationPart, DocumentationVersion
type GetDocumentationVersionsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*DocumentationVersion `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentationVersionsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDocumentationVersionsOutput) SetItems(v []*DocumentationVersion) *GetDocumentationVersionsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDocumentationVersionsOutput) SetPosition(v string) *GetDocumentationVersionsOutput {
	s.Position = &v
	return s
}

// Request to get the name of a DomainName resource.
type GetDomainNameInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The name of the DomainName resource.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *GetDomainNameInput) SetDomainName(v string) *GetDomainNameInput {
	s.DomainName = &v
	return s
}

// Request to describe a collection of DomainName resources.
type GetDomainNamesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNamesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetDomainNamesInput) SetLimit(v int64) *GetDomainNamesInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDomainNamesInput) SetPosition(v string) *GetDomainNamesInput {
	s.Position = &v
	return s
}

// Represents a collection of DomainName resources.
//
// Use Client-Side Certificate (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type GetDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*DomainName `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDomainNamesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetDomainNamesOutput) SetItems(v []*DomainName) *GetDomainNamesOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetDomainNamesOutput) SetPosition(v string) *GetDomainNamesOutput {
	s.Position = &v
	return s
}

// Request a new export of a RestApi for a particular Stage.
type GetExportInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The content-type of the export, for example application/json. Currently application/json
	// and application/yaml are supported for exportType ofoas30 and swagger. This
	// should be specified in the Accept header for direct API requests.
	Accepts *string `location:"header" locationName:"Accept" type:"string"`

	// [Required] The type of export. Acceptable values are 'oas30' for OpenAPI
	// 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
	//
	// ExportType is a required field
	ExportType *string `location:"uri" locationName:"export_type" type:"string" required:"true"`

	// A key-value map of query string parameters that specify properties of the
	// export, depending on the requested exportType. For exportType oas30 and swagger,
	// any combination of the following parameters are supported: extensions='integrations'
	// or extensions='apigateway' will export the API with x-amazon-apigateway-integration
	// extensions. extensions='authorizers' will export the API with x-amazon-apigateway-authorizer
	// extensions. postman will export the API with Postman extensions, allowing
	// for import to the Postman tool
	Parameters map[string]*string `location:"querystring" locationName:"parameters" type:"map"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the Stage that will be exported.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExportInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExportInput"}
	if s.ExportType == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportType"))
	}
	if s.ExportType != nil && len(*s.ExportType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ExportType", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAccepts sets the Accepts field's value.
func (s *GetExportInput) SetAccepts(v string) *GetExportInput {
	s.Accepts = &v
	return s
}

// SetExportType sets the ExportType field's value.
func (s *GetExportInput) SetExportType(v string) *GetExportInput {
	s.ExportType = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *GetExportInput) SetParameters(v map[string]*string) *GetExportInput {
	s.Parameters = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetExportInput) SetRestApiId(v string) *GetExportInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetExportInput) SetStageName(v string) *GetExportInput {
	s.StageName = &v
	return s
}

// The binary blob response to GetExport, which contains the generated SDK.
type GetExportOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The binary blob response to GetExport, which contains the export.
	Body []byte `locationName:"body" type:"blob"`

	// The content-disposition header value in the HTTP response.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// The content-type header value in the HTTP response. This will correspond
	// to a valid 'accept' type in the request.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExportOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetExportOutput) SetBody(v []byte) *GetExportOutput {
	s.Body = v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetExportOutput) SetContentDisposition(v string) *GetExportOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetExportOutput) SetContentType(v string) *GetExportOutput {
	s.ContentType = &v
	return s
}

// Gets a GatewayResponse of a specified response type on the given RestApi.
type GetGatewayResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required]
	// The response type of the associated GatewayResponse.
	//
	// ResponseType is a required field
	ResponseType *string `location:"uri" locationName:"response_type" type:"string" required:"true" enum:"GatewayResponseType"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGatewayResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGatewayResponseInput"}
	if s.ResponseType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseType"))
	}
	if s.ResponseType != nil && len(*s.ResponseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseType", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResponseType sets the ResponseType field's value.
func (s *GetGatewayResponseInput) SetResponseType(v string) *GetGatewayResponseInput {
	s.ResponseType = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetGatewayResponseInput) SetRestApiId(v string) *GetGatewayResponseInput {
	s.RestApiId = &v
	return s
}

// Gets the GatewayResponses collection on the given RestApi. If an API developer
// has not added any definitions for gateway responses, the result will be the
// API Gateway-generated default GatewayResponses collection for the supported
// response types.
type GetGatewayResponsesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500. The GatewayResponses collection does not support
	// pagination and the limit does not apply here.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set. The GatewayResponse
	// collection does not support pagination and the position does not apply here.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponsesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponsesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGatewayResponsesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGatewayResponsesInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetGatewayResponsesInput) SetLimit(v int64) *GetGatewayResponsesInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetGatewayResponsesInput) SetPosition(v string) *GetGatewayResponsesInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetGatewayResponsesInput) SetRestApiId(v string) *GetGatewayResponsesInput {
	s.RestApiId = &v
	return s
}

// The collection of the GatewayResponse instances of a RestApi as a responseType-to-GatewayResponse
// object map of key-value pairs. As such, pagination is not supported for querying
// this collection.
//
// For more information about valid gateway response types, see Gateway Response
// Types Supported by API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html)
//
// Example: Get the collection of gateway responses of an API
//
// Request
//
// This example request shows how to retrieve the GatewayResponses collection
// from an API.
//  GET /restapis/o81lxisefl/gatewayresponses HTTP/1.1 Host: beta-apigateway.us-east-1.amazonaws.com
//  Content-Type: application/json X-Amz-Date: 20170503T220604Z Authorization:
//  AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature=59b42fe54a76a5de8adf2c67baa6d39206f8e9ad49a1d77ccc6a5da3103a398a
//  Cache-Control: no-cache Postman-Token: 5637af27-dc29-fc5c-9dfe-0645d52cb515
// Response
//
// The successful operation returns the 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": { "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
//  "name": "gatewayresponse", "templated": true }, "self": { "href": "/restapis/o81lxisefl/gatewayresponses"
//  }, "first": { "href": "/restapis/o81lxisefl/gatewayresponses" }, "gatewayresponse:by-type":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "item": [ { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE" },
//  { "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR" },
//  { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX" }, { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY" },
//  { "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR" }, { "href":
//  "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED" }, { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  }, { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE" },
//  { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE" } ]
//  }, "_embedded": { "item": [ { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_FAILURE"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "INTEGRATION_FAILURE", "statusCode": "504" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/RESOURCE_NOT_FOUND"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "RESOURCE_NOT_FOUND", "statusCode": "404" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/REQUEST_TOO_LARGE"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "REQUEST_TOO_LARGE", "statusCode": "413" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/THROTTLED" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/THROTTLED"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "THROTTLED", "statusCode": "429" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/UNSUPPORTED_MEDIA_TYPE"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "UNSUPPORTED_MEDIA_TYPE", "statusCode": "415" }, { "_links": { "self": {
//  "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_CONFIGURATION_ERROR"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "AUTHORIZER_CONFIGURATION_ERROR", "statusCode": "500" }, { "_links": { "self":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_5XX"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "DEFAULT_5XX" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/DEFAULT_4XX"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "DEFAULT_4XX" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_PARAMETERS"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "BAD_REQUEST_PARAMETERS", "statusCode": "400" }, { "_links": { "self": {
//  "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/BAD_REQUEST_BODY"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "BAD_REQUEST_BODY", "statusCode": "400" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/EXPIRED_TOKEN"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "EXPIRED_TOKEN", "statusCode": "403" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/ACCESS_DENIED"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "ACCESS_DENIED", "statusCode": "403" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_API_KEY"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "INVALID_API_KEY", "statusCode": "403" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/UNAUTHORIZED"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "UNAUTHORIZED", "statusCode": "401" }, { "_links": { "self": { "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/API_CONFIGURATION_ERROR"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "API_CONFIGURATION_ERROR", "statusCode": "500" }, { "_links": { "self":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/QUOTA_EXCEEDED"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "QUOTA_EXCEEDED", "statusCode": "429" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INTEGRATION_TIMEOUT"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "INTEGRATION_TIMEOUT", "statusCode": "504" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN" },
//  "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "MISSING_AUTHENTICATION_TOKEN", "statusCode": "403" }, { "_links": { "self":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/INVALID_SIGNATURE"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "INVALID_SIGNATURE", "statusCode": "403" }, { "_links": { "self": { "href":
//  "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE" }, "gatewayresponse:put":
//  { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}", "templated":
//  true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/AUTHORIZER_FAILURE"
//  } }, "defaultResponse": true, "responseParameters": {}, "responseTemplates":
//  { "application/json": "{\"message\":$context.error.messageString}" }, "responseType":
//  "AUTHORIZER_FAILURE", "statusCode": "500" } ] } }
//
// Customize Gateway Responses (https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html)
type GetGatewayResponsesOutput struct {
	_ struct{} `type:"structure"`

	// Returns the entire collection, because of no pagination support.
	Items []*UpdateGatewayResponseOutput `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponsesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetGatewayResponsesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetGatewayResponsesOutput) SetItems(v []*UpdateGatewayResponseOutput) *GetGatewayResponsesOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetGatewayResponsesOutput) SetPosition(v string) *GetGatewayResponsesOutput {
	s.Position = &v
	return s
}

// Represents a request to get the integration configuration.
type GetIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] Specifies a get integration request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a get integration request's resource identifier
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *GetIntegrationInput) SetHttpMethod(v string) *GetIntegrationInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetIntegrationInput) SetResourceId(v string) *GetIntegrationInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetIntegrationInput) SetRestApiId(v string) *GetIntegrationInput {
	s.RestApiId = &v
	return s
}

// Represents a get integration response request.
type GetIntegrationResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] Specifies a get integration response request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a get integration response request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] Specifies a get integration response request's status code.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIntegrationResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *GetIntegrationResponseInput) SetHttpMethod(v string) *GetIntegrationResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetIntegrationResponseInput) SetResourceId(v string) *GetIntegrationResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetIntegrationResponseInput) SetRestApiId(v string) *GetIntegrationResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *GetIntegrationResponseInput) SetStatusCode(v string) *GetIntegrationResponseInput {
	s.StatusCode = &v
	return s
}

// Request to describe an existing Method resource.
type GetMethodInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] Specifies the method request's HTTP method type.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] The Resource identifier for the Method resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMethodInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *GetMethodInput) SetHttpMethod(v string) *GetMethodInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetMethodInput) SetResourceId(v string) *GetMethodInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetMethodInput) SetRestApiId(v string) *GetMethodInput {
	s.RestApiId = &v
	return s
}

// Request to describe a MethodResponse resource.
type GetMethodResponseInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] The Resource identifier for the MethodResponse resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The status code for the MethodResponse resource.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetMethodResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetMethodResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetMethodResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *GetMethodResponseInput) SetHttpMethod(v string) *GetMethodResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetMethodResponseInput) SetResourceId(v string) *GetMethodResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetMethodResponseInput) SetRestApiId(v string) *GetMethodResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *GetMethodResponseInput) SetStatusCode(v string) *GetMethodResponseInput {
	s.StatusCode = &v
	return s
}

// Request to list information about a model in an existing RestApi resource.
type GetModelInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A query parameter of a Boolean value to resolve (true) all external model
	// references and returns a flattened model schema or not (false) The default
	// is false.
	Flatten *bool `location:"querystring" locationName:"flatten" type:"boolean"`

	// [Required] The name of the model as an identifier.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// [Required] The RestApi identifier under which the Model exists.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFlatten sets the Flatten field's value.
func (s *GetModelInput) SetFlatten(v bool) *GetModelInput {
	s.Flatten = &v
	return s
}

// SetModelName sets the ModelName field's value.
func (s *GetModelInput) SetModelName(v string) *GetModelInput {
	s.ModelName = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetModelInput) SetRestApiId(v string) *GetModelInput {
	s.RestApiId = &v
	return s
}

// Request to generate a sample mapping template used to transform the payload.
type GetModelTemplateInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The name of the model for which to generate a template.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelTemplateInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *GetModelTemplateInput) SetModelName(v string) *GetModelTemplateInput {
	s.ModelName = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetModelTemplateInput) SetRestApiId(v string) *GetModelTemplateInput {
	s.RestApiId = &v
	return s
}

// Represents a mapping template used to transform a payload.
//
// Mapping Templates (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html#models-mappings-mappings)
type GetModelTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Apache Velocity Template Language (VTL) (https://velocity.apache.org/engine/devel/vtl-reference.html)
	// template content used for the template resource.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelTemplateOutput) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *GetModelTemplateOutput) SetValue(v string) *GetModelTemplateOutput {
	s.Value = &v
	return s
}

// Request to list existing Models defined for a RestApi resource.
type GetModelsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetModelsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetModelsInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetModelsInput) SetLimit(v int64) *GetModelsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetModelsInput) SetPosition(v string) *GetModelsInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetModelsInput) SetRestApiId(v string) *GetModelsInput {
	s.RestApiId = &v
	return s
}

// Represents a collection of Model resources.
//
// Method, MethodResponse, Models and Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html)
type GetModelsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*Model `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetModelsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetModelsOutput) SetItems(v []*Model) *GetModelsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetModelsOutput) SetPosition(v string) *GetModelsOutput {
	s.Position = &v
	return s
}

// Gets a RequestValidator of a given RestApi.
type GetRequestValidatorInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the RequestValidator to be retrieved.
	//
	// RequestValidatorId is a required field
	RequestValidatorId *string `location:"uri" locationName:"requestvalidator_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRequestValidatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRequestValidatorInput"}
	if s.RequestValidatorId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestValidatorId"))
	}
	if s.RequestValidatorId != nil && len(*s.RequestValidatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestValidatorId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRequestValidatorId sets the RequestValidatorId field's value.
func (s *GetRequestValidatorInput) SetRequestValidatorId(v string) *GetRequestValidatorInput {
	s.RequestValidatorId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetRequestValidatorInput) SetRestApiId(v string) *GetRequestValidatorInput {
	s.RestApiId = &v
	return s
}

// Gets the RequestValidators collection of a given RestApi.
type GetRequestValidatorsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRequestValidatorsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRequestValidatorsInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetRequestValidatorsInput) SetLimit(v int64) *GetRequestValidatorsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetRequestValidatorsInput) SetPosition(v string) *GetRequestValidatorsInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetRequestValidatorsInput) SetRestApiId(v string) *GetRequestValidatorsInput {
	s.RestApiId = &v
	return s
}

// A collection of RequestValidator resources of a given RestApi.
//
// In OpenAPI, the RequestValidators of an API is defined by the x-amazon-apigateway-request-validators
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.html)
// extension.
//
// Enable Basic Request Validation in API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html)
type GetRequestValidatorsOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*UpdateRequestValidatorOutput `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRequestValidatorsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetRequestValidatorsOutput) SetItems(v []*UpdateRequestValidatorOutput) *GetRequestValidatorsOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetRequestValidatorsOutput) SetPosition(v string) *GetRequestValidatorsOutput {
	s.Position = &v
	return s
}

// Request to list information about a resource.
type GetResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A query parameter to retrieve the specified resources embedded in the returned
	// Resource representation in the response. This embed parameter value is a
	// list of comma-separated strings. Currently, the request supports only retrieval
	// of the embedded Method resources this way. The query parameter value must
	// be a single-valued list and contain the "methods" string. For example, GET
	// /restapis/{restapi_id}/resources/{resource_id}?embed=methods.
	Embed []*string `location:"querystring" locationName:"embed" type:"list"`

	// [Required] The identifier for the Resource resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmbed sets the Embed field's value.
func (s *GetResourceInput) SetEmbed(v []*string) *GetResourceInput {
	s.Embed = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *GetResourceInput) SetResourceId(v string) *GetResourceInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetResourceInput) SetRestApiId(v string) *GetResourceInput {
	s.RestApiId = &v
	return s
}

// Request to list information about a collection of resources.
type GetResourcesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A query parameter used to retrieve the specified resources embedded in the
	// returned Resources resource in the response. This embed parameter value is
	// a list of comma-separated strings. Currently, the request supports only retrieval
	// of the embedded Method resources this way. The query parameter value must
	// be a single-valued list and contain the "methods" string. For example, GET
	// /restapis/{restapi_id}/resources?embed=methods.
	Embed []*string `location:"querystring" locationName:"embed" type:"list"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcesInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEmbed sets the Embed field's value.
func (s *GetResourcesInput) SetEmbed(v []*string) *GetResourcesInput {
	s.Embed = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetResourcesInput) SetLimit(v int64) *GetResourcesInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetResourcesInput) SetPosition(v string) *GetResourcesInput {
	s.Position = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetResourcesInput) SetRestApiId(v string) *GetResourcesInput {
	s.RestApiId = &v
	return s
}

// Represents a collection of Resource resources.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type GetResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*Resource `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetResourcesOutput) SetItems(v []*Resource) *GetResourcesOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetResourcesOutput) SetPosition(v string) *GetResourcesOutput {
	s.Position = &v
	return s
}

// The GET request to list an existing RestApi defined for your collection.
type GetRestApiInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRestApiInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetRestApiInput) SetRestApiId(v string) *GetRestApiInput {
	s.RestApiId = &v
	return s
}

// The GET request to list existing RestApis defined for your collection.
type GetRestApisInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApisInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetRestApisInput) SetLimit(v int64) *GetRestApisInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetRestApisInput) SetPosition(v string) *GetRestApisInput {
	s.Position = &v
	return s
}

// Contains references to your APIs and links that guide you in how to interact
// with your collection. A collection offers a paginated view of your APIs.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type GetRestApisOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*RestApi `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRestApisOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetRestApisOutput) SetItems(v []*RestApi) *GetRestApisOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetRestApisOutput) SetPosition(v string) *GetRestApisOutput {
	s.Position = &v
	return s
}

// Request a new generated client SDK for a RestApi and Stage.
type GetSdkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A string-to-string key-value map of query parameters sdkType-dependent properties
	// of the SDK. For sdkType of objectivec or swift, a parameter named classPrefix
	// is required. For sdkType of android, parameters named groupId, artifactId,
	// artifactVersion, and invokerPackage are required. For sdkType of java, parameters
	// named serviceName and javaPackageName are required.
	Parameters map[string]*string `location:"querystring" locationName:"parameters" type:"map"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The language for the generated SDK. Currently java, javascript,
	// android, objectivec (for iOS), swift (for iOS), and ruby are supported.
	//
	// SdkType is a required field
	SdkType *string `location:"uri" locationName:"sdk_type" type:"string" required:"true"`

	// [Required] The name of the Stage that the SDK will use.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSdkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSdkInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.SdkType == nil {
		invalidParams.Add(request.NewErrParamRequired("SdkType"))
	}
	if s.SdkType != nil && len(*s.SdkType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SdkType", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParameters sets the Parameters field's value.
func (s *GetSdkInput) SetParameters(v map[string]*string) *GetSdkInput {
	s.Parameters = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetSdkInput) SetRestApiId(v string) *GetSdkInput {
	s.RestApiId = &v
	return s
}

// SetSdkType sets the SdkType field's value.
func (s *GetSdkInput) SetSdkType(v string) *GetSdkInput {
	s.SdkType = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetSdkInput) SetStageName(v string) *GetSdkInput {
	s.StageName = &v
	return s
}

// The binary blob response to GetSdk, which contains the generated SDK.
type GetSdkOutput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The binary blob response to GetSdk, which contains the generated SDK.
	Body []byte `locationName:"body" type:"blob"`

	// The content-disposition header value in the HTTP response.
	ContentDisposition *string `location:"header" locationName:"Content-Disposition" type:"string"`

	// The content-type header value in the HTTP response.
	ContentType *string `location:"header" locationName:"Content-Type" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *GetSdkOutput) SetBody(v []byte) *GetSdkOutput {
	s.Body = v
	return s
}

// SetContentDisposition sets the ContentDisposition field's value.
func (s *GetSdkOutput) SetContentDisposition(v string) *GetSdkOutput {
	s.ContentDisposition = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *GetSdkOutput) SetContentType(v string) *GetSdkOutput {
	s.ContentType = &v
	return s
}

// Get an SdkType instance.
type GetSdkTypeInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the queried SdkType instance.
	//
	// Id is a required field
	Id *string `location:"uri" locationName:"sdktype_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSdkTypeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSdkTypeInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetSdkTypeInput) SetId(v string) *GetSdkTypeInput {
	s.Id = &v
	return s
}

// Get the SdkTypes collection.
type GetSdkTypesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypesInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetSdkTypesInput) SetLimit(v int64) *GetSdkTypesInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetSdkTypesInput) SetPosition(v string) *GetSdkTypesInput {
	s.Position = &v
	return s
}

// The collection of SdkType instances.
type GetSdkTypesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*SdkType `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSdkTypesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetSdkTypesOutput) SetItems(v []*SdkType) *GetSdkTypesOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetSdkTypesOutput) SetPosition(v string) *GetSdkTypesOutput {
	s.Position = &v
	return s
}

// Requests API Gateway to get information about a Stage resource.
type GetStageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the Stage resource to get information about.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStageInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetStageInput) SetRestApiId(v string) *GetStageInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *GetStageInput) SetStageName(v string) *GetStageInput {
	s.StageName = &v
	return s
}

// Requests API Gateway to get information about one or more Stage resources.
type GetStagesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The stages' deployment identifiers.
	DeploymentId *string `location:"querystring" locationName:"deploymentId" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetStagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetStagesInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *GetStagesInput) SetDeploymentId(v string) *GetStagesInput {
	s.DeploymentId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *GetStagesInput) SetRestApiId(v string) *GetStagesInput {
	s.RestApiId = &v
	return s
}

// A list of Stage resources that are associated with the ApiKey resource.
//
// Deploying API in Stages (https://docs.aws.amazon.com/apigateway/latest/developerguide/stages.html)
type GetStagesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Item []*Stage `locationName:"item" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetStagesOutput) GoString() string {
	return s.String()
}

// SetItem sets the Item field's value.
func (s *GetStagesOutput) SetItem(v []*Stage) *GetStagesOutput {
	s.Item = v
	return s
}

// Gets the Tags collection for a given resource.
type GetTagsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// (Not currently supported) The maximum number of returned results per page.
	// The default value is 25 and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// (Not currently supported) The current pagination position in the paged result
	// set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The ARN of a resource that can be tagged.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource_arn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTagsInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetTagsInput) SetLimit(v int64) *GetTagsInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetTagsInput) SetPosition(v string) *GetTagsInput {
	s.Position = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetTagsInput) SetResourceArn(v string) *GetTagsInput {
	s.ResourceArn = &v
	return s
}

// The collection of tags. Each tag element is associated with a given resource.
type GetTagsOutput struct {
	_ struct{} `type:"structure"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTagsOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *GetTagsOutput) SetTags(v map[string]*string) *GetTagsOutput {
	s.Tags = v
	return s
}

// The GET request to get the usage data of a usage plan in a specified time
// interval.
type GetUsageInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The ending date (e.g., 2016-12-31) of the usage data.
	//
	// EndDate is a required field
	EndDate *string `location:"querystring" locationName:"endDate" type:"string" required:"true"`

	// The Id of the API key associated with the resultant usage data.
	KeyId *string `location:"querystring" locationName:"keyId" type:"string"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The starting date (e.g., 2016-01-01) of the usage data.
	//
	// StartDate is a required field
	StartDate *string `location:"querystring" locationName:"startDate" type:"string" required:"true"`

	// [Required] The Id of the usage plan associated with the usage data.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsageInput"}
	if s.EndDate == nil {
		invalidParams.Add(request.NewErrParamRequired("EndDate"))
	}
	if s.StartDate == nil {
		invalidParams.Add(request.NewErrParamRequired("StartDate"))
	}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndDate sets the EndDate field's value.
func (s *GetUsageInput) SetEndDate(v string) *GetUsageInput {
	s.EndDate = &v
	return s
}

// SetKeyId sets the KeyId field's value.
func (s *GetUsageInput) SetKeyId(v string) *GetUsageInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetUsageInput) SetLimit(v int64) *GetUsageInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetUsageInput) SetPosition(v string) *GetUsageInput {
	s.Position = &v
	return s
}

// SetStartDate sets the StartDate field's value.
func (s *GetUsageInput) SetStartDate(v string) *GetUsageInput {
	s.StartDate = &v
	return s
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *GetUsageInput) SetUsagePlanId(v string) *GetUsageInput {
	s.UsagePlanId = &v
	return s
}

// The GET request to get a usage plan of a given plan identifier.
type GetUsagePlanInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the UsagePlan resource to be retrieved.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsagePlanInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsagePlanInput"}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *GetUsagePlanInput) SetUsagePlanId(v string) *GetUsagePlanInput {
	s.UsagePlanId = &v
	return s
}

// The GET request to get a usage plan key of a given key identifier.
type GetUsagePlanKeyInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The key Id of the to-be-retrieved UsagePlanKey resource representing
	// a plan customer.
	//
	// KeyId is a required field
	KeyId *string `location:"uri" locationName:"keyId" type:"string" required:"true"`

	// [Required] The Id of the UsagePlan resource representing the usage plan containing
	// the to-be-retrieved UsagePlanKey resource representing a plan customer.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsagePlanKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsagePlanKeyInput"}
	if s.KeyId == nil {
		invalidParams.Add(request.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KeyId", 1))
	}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyId sets the KeyId field's value.
func (s *GetUsagePlanKeyInput) SetKeyId(v string) *GetUsagePlanKeyInput {
	s.KeyId = &v
	return s
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *GetUsagePlanKeyInput) SetUsagePlanId(v string) *GetUsagePlanKeyInput {
	s.UsagePlanId = &v
	return s
}

// The GET request to get all the usage plan keys representing the API keys
// added to a specified usage plan.
type GetUsagePlanKeysInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// A query parameter specifying the name of the to-be-returned usage plan keys.
	NameQuery *string `location:"querystring" locationName:"name" type:"string"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`

	// [Required] The Id of the UsagePlan resource representing the usage plan containing
	// the to-be-retrieved UsagePlanKey resource representing a plan customer.
	//
	// UsagePlanId is a required field
	UsagePlanId *string `location:"uri" locationName:"usageplanId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsagePlanKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsagePlanKeysInput"}
	if s.UsagePlanId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsagePlanId"))
	}
	if s.UsagePlanId != nil && len(*s.UsagePlanId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UsagePlanId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *GetUsagePlanKeysInput) SetLimit(v int64) *GetUsagePlanKeysInput {
	s.Limit = &v
	return s
}

// SetNameQuery sets the NameQuery field's value.
func (s *GetUsagePlanKeysInput) SetNameQuery(v string) *GetUsagePlanKeysInput {
	s.NameQuery = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetUsagePlanKeysInput) SetPosition(v string) *GetUsagePlanKeysInput {
	s.Position = &v
	return s
}

// SetUsagePlanId sets the UsagePlanId field's value.
func (s *GetUsagePlanKeysInput) SetUsagePlanId(v string) *GetUsagePlanKeysInput {
	s.UsagePlanId = &v
	return s
}

// Represents the collection of usage plan keys added to usage plans for the
// associated API keys and, possibly, other types of keys.
//
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type GetUsagePlanKeysOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*UsagePlanKey `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlanKeysOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetUsagePlanKeysOutput) SetItems(v []*UsagePlanKey) *GetUsagePlanKeysOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetUsagePlanKeysOutput) SetPosition(v string) *GetUsagePlanKeysOutput {
	s.Position = &v
	return s
}

// The GET request to get all the usage plans of the caller's account.
type GetUsagePlansInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the API key associated with the usage plans.
	KeyId *string `location:"querystring" locationName:"keyId" type:"string"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlansInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlansInput) GoString() string {
	return s.String()
}

// SetKeyId sets the KeyId field's value.
func (s *GetUsagePlansInput) SetKeyId(v string) *GetUsagePlansInput {
	s.KeyId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *GetUsagePlansInput) SetLimit(v int64) *GetUsagePlansInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetUsagePlansInput) SetPosition(v string) *GetUsagePlansInput {
	s.Position = &v
	return s
}

// Represents a collection of usage plans for an AWS account.
//
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type GetUsagePlansOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*UsagePlan `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlansOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsagePlansOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetUsagePlansOutput) SetItems(v []*UsagePlan) *GetUsagePlansOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetUsagePlansOutput) SetPosition(v string) *GetUsagePlansOutput {
	s.Position = &v
	return s
}

// Gets a specified VPC link under the caller's account in a region.
type GetVpcLinkInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The identifier of the VpcLink. It is used in an Integration to
	// reference this VpcLink.
	//
	// VpcLinkId is a required field
	VpcLinkId *string `location:"uri" locationName:"vpclink_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinkInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinkInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetVpcLinkInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetVpcLinkInput"}
	if s.VpcLinkId == nil {
		invalidParams.Add(request.NewErrParamRequired("VpcLinkId"))
	}
	if s.VpcLinkId != nil && len(*s.VpcLinkId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VpcLinkId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetVpcLinkId sets the VpcLinkId field's value.
func (s *GetVpcLinkInput) SetVpcLinkId(v string) *GetVpcLinkInput {
	s.VpcLinkId = &v
	return s
}

// Gets the VpcLinks collection under the caller's account in a selected region.
type GetVpcLinksInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinksInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinksInput) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *GetVpcLinksInput) SetLimit(v int64) *GetVpcLinksInput {
	s.Limit = &v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetVpcLinksInput) SetPosition(v string) *GetVpcLinksInput {
	s.Position = &v
	return s
}

// The collection of VPC links under the caller's account in a region.
//
// Getting Started with Private Integrations (https://docs.aws.amazon.com/apigateway/latest/developerguide/getting-started-with-private-integration.html),
// Set up Private Integrations (https://docs.aws.amazon.com/apigateway/latest/developerguide/set-up-private-integration.html)
type GetVpcLinksOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []*UpdateVpcLinkOutput `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinksOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetVpcLinksOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *GetVpcLinksOutput) SetItems(v []*UpdateVpcLinkOutput) *GetVpcLinksOutput {
	s.Items = v
	return s
}

// SetPosition sets the Position field's value.
func (s *GetVpcLinksOutput) SetPosition(v string) *GetVpcLinksOutput {
	s.Position = &v
	return s
}

// The POST request to import API keys from an external source, such as a CSV-formatted
// file.
type ImportApiKeysInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// The payload of the POST request to import API keys. For the payload format,
	// see API Key File Format (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-key-file-format.html).
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true"`

	// A query parameter to indicate whether to rollback ApiKey importation (true)
	// or not (false) when error is encountered.
	FailOnWarnings *bool `location:"querystring" locationName:"failonwarnings" type:"boolean"`

	// A query parameter to specify the input format to imported API keys. Currently,
	// only the csv format is supported.
	//
	// Format is a required field
	Format *string `location:"querystring" locationName:"format" type:"string" required:"true" enum:"ApiKeysFormat"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportApiKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportApiKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportApiKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportApiKeysInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.Format == nil {
		invalidParams.Add(request.NewErrParamRequired("Format"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *ImportApiKeysInput) SetBody(v []byte) *ImportApiKeysInput {
	s.Body = v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *ImportApiKeysInput) SetFailOnWarnings(v bool) *ImportApiKeysInput {
	s.FailOnWarnings = &v
	return s
}

// SetFormat sets the Format field's value.
func (s *ImportApiKeysInput) SetFormat(v string) *ImportApiKeysInput {
	s.Format = &v
	return s
}

// The identifier of an ApiKey used in a UsagePlan.
type ImportApiKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of all the ApiKey identifiers.
	Ids []*string `locationName:"ids" type:"list"`

	// A list of warning messages.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportApiKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportApiKeysOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ImportApiKeysOutput) SetIds(v []*string) *ImportApiKeysOutput {
	s.Ids = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ImportApiKeysOutput) SetWarnings(v []*string) *ImportApiKeysOutput {
	s.Warnings = v
	return s
}

// Import documentation parts from an external (e.g., OpenAPI) definition file.
type ImportDocumentationPartsInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// [Required] Raw byte array representing the to-be-imported documentation parts.
	// To import from an OpenAPI file, this is a JSON object.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true"`

	// A query parameter to specify whether to rollback the documentation importation
	// (true) or not (false) when a warning is encountered. The default value is
	// false.
	FailOnWarnings *bool `location:"querystring" locationName:"failonwarnings" type:"boolean"`

	// A query parameter to indicate whether to overwrite (OVERWRITE) any existing
	// DocumentationParts definition or to merge (MERGE) the new definition into
	// the existing one. The default value is MERGE.
	Mode *string `location:"querystring" locationName:"mode" type:"string" enum:"PutMode"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentationPartsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentationPartsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportDocumentationPartsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportDocumentationPartsInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *ImportDocumentationPartsInput) SetBody(v []byte) *ImportDocumentationPartsInput {
	s.Body = v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *ImportDocumentationPartsInput) SetFailOnWarnings(v bool) *ImportDocumentationPartsInput {
	s.FailOnWarnings = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *ImportDocumentationPartsInput) SetMode(v string) *ImportDocumentationPartsInput {
	s.Mode = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *ImportDocumentationPartsInput) SetRestApiId(v string) *ImportDocumentationPartsInput {
	s.RestApiId = &v
	return s
}

// A collection of the imported DocumentationPart identifiers.
//
// This is used to return the result when documentation parts in an external
// (e.g., OpenAPI) file are imported into API Gateway
//
// Documenting an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-documenting-api.html),
// documentationpart:import (https://docs.aws.amazon.com/apigateway/api-reference/link-relation/documentationpart-import/),
// DocumentationPart
type ImportDocumentationPartsOutput struct {
	_ struct{} `type:"structure"`

	// A list of the returned documentation part identifiers.
	Ids []*string `locationName:"ids" type:"list"`

	// A list of warning messages reported during import of documentation parts.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentationPartsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportDocumentationPartsOutput) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *ImportDocumentationPartsOutput) SetIds(v []*string) *ImportDocumentationPartsOutput {
	s.Ids = v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *ImportDocumentationPartsOutput) SetWarnings(v []*string) *ImportDocumentationPartsOutput {
	s.Warnings = v
	return s
}

// A POST request to import an API to API Gateway using an input of an API definition
// file.
type ImportRestApiInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// [Required] The POST request body containing external API definitions. Currently,
	// only OpenAPI definition JSON/YAML files are supported. The maximum size of
	// the API definition file is 6MB.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true"`

	// A query parameter to indicate whether to rollback the API creation (true)
	// or not (false) when a warning is encountered. The default value is false.
	FailOnWarnings *bool `location:"querystring" locationName:"failonwarnings" type:"boolean"`

	// A key-value map of context-specific query string parameters specifying the
	// behavior of different API importing operations. The following shows operation-specific
	// parameters and their supported values.
	//
	// To exclude DocumentationParts from the import, set parameters as ignore=documentation.
	//
	// To configure the endpoint type, set parameters as endpointConfigurationTypes=EDGE,
	// endpointConfigurationTypes=REGIONAL, or endpointConfigurationTypes=PRIVATE.
	// The default endpoint type is EDGE.
	//
	// To handle imported basepath, set parameters as basepath=ignore, basepath=prepend
	// or basepath=split.
	//
	// For example, the AWS CLI command to exclude documentation from the imported
	// API is:
	//
	//    aws apigateway import-rest-api --parameters ignore=documentation --body
	//    'file:///path/to/imported-api-body.json'
	//
	// The AWS CLI command to set the regional endpoint on the imported API is:
	//
	//    aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL
	//    --body 'file:///path/to/imported-api-body.json'
	Parameters map[string]*string `location:"querystring" locationName:"parameters" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportRestApiInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *ImportRestApiInput) SetBody(v []byte) *ImportRestApiInput {
	s.Body = v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *ImportRestApiInput) SetFailOnWarnings(v bool) *ImportRestApiInput {
	s.FailOnWarnings = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *ImportRestApiInput) SetParameters(v map[string]*string) *ImportRestApiInput {
	s.Parameters = v
	return s
}

// Represents an HTTP, HTTP_PROXY, AWS, AWS_PROXY, or Mock integration.
//
// In the API Gateway console, the built-in Lambda integration is an AWS integration.
//
// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type Integration struct {
	_ struct{} `type:"structure"`

	// A list of request parameters whose values API Gateway caches. To be valid
	// values for cacheKeyParameters, these parameters must also be specified for
	// Method requestParameters.
	CacheKeyParameters []*string `locationName:"cacheKeyParameters" type:"list"`

	// Specifies a group of related cached parameters. By default, API Gateway uses
	// the resource ID as the cacheNamespace. You can specify the same cacheNamespace
	// across resources to return the same cached data for requests to different
	// resources.
	CacheNamespace *string `locationName:"cacheNamespace" type:"string"`

	// The (id (https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id))
	// of the VpcLink used for the integration when connectionType=VPC_LINK and
	// undefined, otherwise.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. The valid
	// value is INTERNET for connections through the public routable internet or
	// VPC_LINK for private connections between API Gateway and a network load balancer
	// in a VPC. The default value is INTERNET.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle request payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the request payload will be passed through
	// from the method request to integration request without modification, provided
	// that the passthroughBehavior is configured to support payload pass-through.
	ContentHandling *string `locationName:"contentHandling" type:"string" enum:"ContentHandlingStrategy"`

	// Specifies the credentials required for the integration, if any. For AWS integrations,
	// three options are available. To specify an IAM Role for API Gateway to assume,
	// use the role's Amazon Resource Name (ARN). To require that the caller's identity
	// be passed through from the request, specify the string arn:aws:iam::\*:user/\*.
	// To use resource-based permissions on supported AWS services, specify null.
	Credentials *string `locationName:"credentials" type:"string"`

	// Specifies the integration's HTTP method type.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// Specifies the integration's responses.
	//
	// Example: Get integration responses of a method
	//
	// Request
	//   GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200
	//   HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   X-Amz-Date: 20160607T191449Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160607/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns 200 OK status and a payload as follows:
	//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "title": "200" }, "integrationresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
	//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream
	//  in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
	//  }, "statusCode": "200" }
	//
	// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
	IntegrationResponses map[string]*IntegrationResponse `locationName:"integrationResponses" type:"map"`

	// Specifies how the method request body of an unmapped content type will be
	// passed through the integration request to the back end without transformation.
	// A content type is unmapped if no mapping template is defined in the integration
	// or the content type does not match any of the mapped content types, as specified
	// in requestTemplates. The valid value is one of the following:
	//
	//    * WHEN_NO_MATCH: passes the method request body through the integration
	//    request to the back end without transformation when the method request
	//    content type does not match any content type associated with the mapping
	//    templates defined in the integration request.
	//
	//    * WHEN_NO_TEMPLATES: passes the method request body through the integration
	//    request to the back end without transformation when no mapping template
	//    is defined in the integration request. If a template is defined when this
	//    option is selected, the method request of an unmapped content-type will
	//    be rejected with an HTTP 415 Unsupported Media Type response.
	//
	//    * NEVER: rejects the method request with an HTTP 415 Unsupported Media
	//    Type response when either the method request content type does not match
	//    any content type associated with the mapping templates defined in the
	//    integration request or no mapping template is defined in the integration
	//    request.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the back end. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the back end. The method request parameter value must match the pattern of
	// method.request.{location}.{name}, where location is querystring, path, or
	// header and name must be a valid and unique method request parameter name.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000
	// milliseconds or 29 seconds.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" type:"integer"`

	// Specifies the TLS configuration for an integration.
	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`

	// Specifies an API method integration type. The valid value is one of the following:
	//
	//    * AWS: for integrating the API method request with an AWS service action,
	//    including the Lambda function-invoking action. With the Lambda function-invoking
	//    action, this is referred to as the Lambda custom integration. With any
	//    other AWS service action, this is known as AWS integration.
	//
	//    * AWS_PROXY: for integrating the API method request with the Lambda function-invoking
	//    action with the client request passed through as-is. This integration
	//    is also referred to as the Lambda proxy integration.
	//
	//    * HTTP: for integrating the API method request with an HTTP endpoint,
	//    including a private HTTP endpoint within a VPC. This integration is also
	//    referred to as the HTTP custom integration.
	//
	//    * HTTP_PROXY: for integrating the API method request with an HTTP endpoint,
	//    including a private HTTP endpoint within a VPC, with the client request
	//    passed through as-is. This is also referred to as the HTTP proxy integration.
	//
	//    * MOCK: for integrating the API method request with API Gateway as a "loop-back"
	//    endpoint without invoking any backend.
	//
	// For the HTTP and HTTP proxy integrations, each integration can specify a
	// protocol (http/https), port and path. Standard 80 and 443 ports are supported
	// as well as custom ports above 1024. An HTTP or HTTP proxy integration with
	// a connectionType of VPC_LINK is referred to as a private integration and
	// uses a VpcLink to connect API Gateway to a network load balancer of a VPC.
	Type *string `locationName:"type" type:"string" enum:"IntegrationType"`

	// Specifies Uniform Resource Identifier (URI) of the integration endpoint.
	//
	//    * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed,
	//    encoded HTTP(S) URL according to the RFC-3986 specification (https://en.wikipedia.org/wiki/Uniform_Resource_Identifier),
	//    for either standard integration, where connectionType is not VPC_LINK,
	//    or private integration, where connectionType is VPC_LINK. For a private
	//    HTTP integration, the URI is not used for routing.
	//
	//    * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}.
	//    Here, {Region} is the API Gateway region (e.g., us-east-1); {service}
	//    is the name of the integrated AWS service (e.g., s3); and {subdomain}
	//    is a designated subdomain supported by certain AWS service for fast host-name
	//    lookup. action can be used for an AWS service action-based API, using
	//    an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api}
	//    refers to a supported action {name} plus any required input parameters.
	//    Alternatively, path can be used for an AWS service path-based API. The
	//    ensuing service_api refers to the path to an AWS service resource, including
	//    the region of the integrated AWS service, if applicable. For example,
	//    for integration with the S3 API of GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html),
	//    the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}
	//    or arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integration) GoString() string {
	return s.String()
}

// SetCacheKeyParameters sets the CacheKeyParameters field's value.
func (s *Integration) SetCacheKeyParameters(v []*string) *Integration {
	s.CacheKeyParameters = v
	return s
}

// SetCacheNamespace sets the CacheNamespace field's value.
func (s *Integration) SetCacheNamespace(v string) *Integration {
	s.CacheNamespace = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *Integration) SetConnectionId(v string) *Integration {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *Integration) SetConnectionType(v string) *Integration {
	s.ConnectionType = &v
	return s
}

// SetContentHandling sets the ContentHandling field's value.
func (s *Integration) SetContentHandling(v string) *Integration {
	s.ContentHandling = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *Integration) SetCredentials(v string) *Integration {
	s.Credentials = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *Integration) SetHttpMethod(v string) *Integration {
	s.HttpMethod = &v
	return s
}

// SetIntegrationResponses sets the IntegrationResponses field's value.
func (s *Integration) SetIntegrationResponses(v map[string]*IntegrationResponse) *Integration {
	s.IntegrationResponses = v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *Integration) SetPassthroughBehavior(v string) *Integration {
	s.PassthroughBehavior = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *Integration) SetRequestParameters(v map[string]*string) *Integration {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *Integration) SetRequestTemplates(v map[string]*string) *Integration {
	s.RequestTemplates = v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *Integration) SetTimeoutInMillis(v int64) *Integration {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *Integration) SetTlsConfig(v *TlsConfig) *Integration {
	s.TlsConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *Integration) SetType(v string) *Integration {
	s.Type = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *Integration) SetUri(v string) *Integration {
	s.Uri = &v
	return s
}

// Represents an integration response. The status code must map to an existing
// MethodResponse, and parameters and templates can be used to transform the
// back-end response.
//
// Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type IntegrationResponse struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the method response without modification.
	ContentHandling *string `locationName:"contentHandling" type:"string" enum:"ContentHandlingStrategy"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the back end. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name is a valid and
	// unique response header name and JSON-expression is a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Specifies the templates used to transform the integration response body.
	// Response templates are represented as a key/value map, with a content-type
	// as the key and a template as the value.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// Specifies the regular expression (regex) pattern used to choose an integration
	// response based on the response from the back end. For example, if the success
	// response returns nothing and the error response returns some string, you
	// could use the .+ regex to match error response. However, make sure that the
	// error response does not contain any newline (\n) character in such cases.
	// If the back end is an AWS Lambda function, the AWS Lambda function error
	// header is matched. For all other HTTP and AWS back ends, the HTTP status
	// code is matched.
	SelectionPattern *string `locationName:"selectionPattern" type:"string"`

	// Specifies the status code that is used to map the integration response to
	// an existing MethodResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegrationResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IntegrationResponse) GoString() string {
	return s.String()
}

// SetContentHandling sets the ContentHandling field's value.
func (s *IntegrationResponse) SetContentHandling(v string) *IntegrationResponse {
	s.ContentHandling = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *IntegrationResponse) SetResponseParameters(v map[string]*string) *IntegrationResponse {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *IntegrationResponse) SetResponseTemplates(v map[string]*string) *IntegrationResponse {
	s.ResponseTemplates = v
	return s
}

// SetSelectionPattern sets the SelectionPattern field's value.
func (s *IntegrationResponse) SetSelectionPattern(v string) *IntegrationResponse {
	s.SelectionPattern = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *IntegrationResponse) SetStatusCode(v string) *IntegrationResponse {
	s.StatusCode = &v
	return s
}

// The request exceeded the rate limit. Retry after the specified time period.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a client-facing interface by which the client calls the API to
// access back-end resources. A Method resource is integrated with an Integration
// resource. Both consist of a request and one or more responses. The method
// request takes the client input that is passed to the back end through the
// integration request. A method response returns the output from the back end
// to the client through an integration response. A method request is embodied
// in a Method resource, whereas an integration request is embodied in an Integration
// resource. On the other hand, a method response is represented by a MethodResponse
// resource, whereas an integration response is represented by an IntegrationResponse
// resource.
//
// Example: Retrive the GET method on a specified resource
//
// Request
//
// The following example request retrieves the information about the GET method
// on an API resource (3kzxbg5sa2) of an API (fugvjdxtri).
//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type:
//  application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20160603T210259Z
//  Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
// Response
//
// The successful response returns a 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
//  "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
//  "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
//  "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
//  "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
//  }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
//  }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
//  "templated": true } }, "apiKeyRequired": true, "authorizationType": "NONE",
//  "httpMethod": "GET", "_embedded": { "method:integration": { "_links": {
//  "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
//  }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2",
//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type":
//  "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json":
//  "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E\")"
//  }, "statusCode": "200" } } }, "method:responses": { "_links": { "self":
//  { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
//  } }
// In the example above, the response template for the 200 OK response maps
// the JSON output from the ListStreams action in the back end to an XML output.
// The mapping template is URL-encoded as %3CkinesisStreams%3E%23foreach(%24stream%20in%20%24input.path(%27%24.StreamNames%27))%3Cstream%3E%3Cname%3E%24stream%3C%2Fname%3E%3C%2Fstream%3E%23end%3C%2FkinesisStreams%3E
// and the output is decoded using the $util.urlDecode() (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#util-templat-reference)
// helper function.
//
// MethodResponse, Integration, IntegrationResponse, Resource, Set up an API's
// method (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-method-settings.html)
type Method struct {
	_ struct{} `type:"structure"`

	// A boolean flag specifying whether a valid ApiKey is required to invoke this
	// method.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on the method. The scopes are used
	// with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
	// The authorization works by matching the method scopes against the scopes
	// parsed from the access token in the incoming request. The method invocation
	// is authorized if any method scopes matches a claimed scope in the access
	// token. Otherwise, the invocation is not authorized. When the method scope
	// is configured, the client must provide an access token instead of an identity
	// token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS
	// for using a Cognito user pool.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`

	// The identifier of an Authorizer to use on this method. The authorizationType
	// must be CUSTOM.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// The method's HTTP verb.
	HttpMethod *string `locationName:"httpMethod" type:"string"`

	// Gets the method's integration responsible for passing the client-submitted
	// request to the back end and performing necessary transformations to make
	// the request compliant with the back end.
	//
	// Example:
	//
	// Request
	//   GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration HTTP/1.1
	//   Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   Content-Length: 117 X-Amz-Date: 20160613T213210Z Authorization: AWS4-HMAC-SHA256
	//   Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns a 200 OK status code and a payload similar
	// to the following:
	//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
	//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true } ], "self": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration" }, "integration:delete":
	//  { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
	//  }, "integration:responses": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration"
	//  }, "integrationresponse:put": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/{status_code}",
	//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "0cjtch",
	//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
	//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestTemplates": { "application/json":
	//  "{\n \"a\": \"$input.params('operand1')\",\n \"b\": \"$input.params('operand2')\",
	//  \n \"op\": \"$input.params('operator')\" \n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-west-2:lambda:path//2015-03-31/functions/arn:aws:lambda:us-west-2:123456789012:function:Calc/invocations",
	//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
	//  "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.operator": "integration.response.body.op",
	//  "method.response.header.operand_2": "integration.response.body.b", "method.response.header.operand_1":
	//  "integration.response.body.a" }, "responseTemplates": { "application/json":
	//  "#set($res = $input.path('$'))\n{\n \"result\": \"$res.a, $res.b, $res.op
	//  => $res.c\",\n \"a\" : \"$res.a\",\n \"b\" : \"$res.b\",\n \"op\" : \"$res.op\",\n
	//  \"c\" : \"$res.c\"\n}" }, "selectionPattern": "", "statusCode": "200" }
	//  } }
	//
	// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-integration.html)
	MethodIntegration *Integration `locationName:"methodIntegration" type:"structure"`

	// Gets a method response associated with a given HTTP status code.
	//
	// The collection of method responses are encapsulated in a key-value map, where
	// the key is a response's HTTP status code and the value is a MethodResponse
	// resource that specifies the response returned to the caller from the back
	// end through the integration response.
	//
	// Example: Get a 200 OK response of a GET method
	//
	// Request
	//   GET /restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200 HTTP/1.1
	//   Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
	//   Content-Length: 117 X-Amz-Date: 20160613T215008Z Authorization: AWS4-HMAC-SHA256
	//   Credential={access_key_ID}/20160613/us-east-1/apigateway/aws4_request,
	//   SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//
	// The successful response returns a 200 OK status code and a payload similar
	// to the following:
	//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
	//  "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200",
	//  "title": "200" }, "methodresponse:delete": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
	//  }, "methodresponse:update": { "href": "/restapis/uojnr9hd57/resources/0cjtch/methods/GET/responses/200"
	//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
	//  { "method.response.header.operator": false, "method.response.header.operand_2":
	//  false, "method.response.header.operand_1": false }, "statusCode": "200"
	//  }
	//
	// AWS CLI (https://docs.aws.amazon.com/cli/latest/reference/apigateway/get-method-response.html)
	MethodResponses map[string]*MethodResponse `locationName:"methodResponses" type:"map"`

	// A human-friendly operation identifier for the method. For example, you can
	// assign the operationName of ListPets for the GET /pets method in the PetStore
	// example.
	OperationName *string `locationName:"operationName" type:"string"`

	// A key-value map specifying data schemas, represented by Model resources,
	// (as the mapped value) of the request payloads of given content types (as
	// the mapping key).
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// A key-value map defining required or optional method request parameters that
	// can be accepted by API Gateway. A key is a method request parameter name
	// matching the pattern of method.request.{location}.{name}, where location
	// is querystring, path, or header and name is a valid and unique parameter
	// name. The value associated with the key is a Boolean flag indicating whether
	// the parameter is required (true) or optional (false). The method request
	// parameter names defined here are available in Integration to be mapped to
	// integration request parameters or templates.
	RequestParameters map[string]*bool `locationName:"requestParameters" type:"map"`

	// The identifier of a RequestValidator for request validation.
	RequestValidatorId *string `locationName:"requestValidatorId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Method) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Method) GoString() string {
	return s.String()
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *Method) SetApiKeyRequired(v bool) *Method {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *Method) SetAuthorizationScopes(v []*string) *Method {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *Method) SetAuthorizationType(v string) *Method {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *Method) SetAuthorizerId(v string) *Method {
	s.AuthorizerId = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *Method) SetHttpMethod(v string) *Method {
	s.HttpMethod = &v
	return s
}

// SetMethodIntegration sets the MethodIntegration field's value.
func (s *Method) SetMethodIntegration(v *Integration) *Method {
	s.MethodIntegration = v
	return s
}

// SetMethodResponses sets the MethodResponses field's value.
func (s *Method) SetMethodResponses(v map[string]*MethodResponse) *Method {
	s.MethodResponses = v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *Method) SetOperationName(v string) *Method {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *Method) SetRequestModels(v map[string]*string) *Method {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *Method) SetRequestParameters(v map[string]*bool) *Method {
	s.RequestParameters = v
	return s
}

// SetRequestValidatorId sets the RequestValidatorId field's value.
func (s *Method) SetRequestValidatorId(v string) *Method {
	s.RequestValidatorId = &v
	return s
}

// Represents a method response of a given HTTP status code returned to the
// client. The method response is passed from the back end through the associated
// integration response that can be transformed using a mapping template.
//
// Example: A MethodResponse instance of an API
//
// Request
//
// The example request retrieves a MethodResponse of the 200 status code.
//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200
//  HTTP/1.1 Content-Type: application/json Host: apigateway.us-east-1.amazonaws.com
//  X-Amz-Date: 20160603T222952Z Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20160603/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
// Response
//
// The successful response returns 200 OK status and a payload as follows:
//  { "_links": { "curies": { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
//  "name": "methodresponse", "templated": true }, "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
//  "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
//
// Method, IntegrationResponse, Integration Creating an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type MethodResponse struct {
	_ struct{} `type:"structure"`

	// Specifies the Model resources used for the response's content-type. Response
	// models are represented as a key/value map, with a content-type as the key
	// and a Model name as the value.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// A key-value map specifying required or optional response parameters that
	// API Gateway can send back to the caller. A key defines a method response
	// header and the value specifies whether the associated method response header
	// is required or not. The expression of the key must match the pattern method.response.header.{name},
	// where name is a valid and unique header name. API Gateway passes certain
	// integration response data to the method response headers specified here according
	// to the mapping you prescribe in the API's IntegrationResponse. The integration
	// response data that can be mapped include an integration response header expressed
	// in integration.response.header.{name}, a static value enclosed within a pair
	// of single quotes (e.g., 'application/json'), or a JSON expression from the
	// back-end response payload in the form of integration.response.body.{JSON-expression},
	// where JSON-expression is a valid JSON expression without the $ prefix.)
	ResponseParameters map[string]*bool `locationName:"responseParameters" type:"map"`

	// The method response's status code.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodResponse) GoString() string {
	return s.String()
}

// SetResponseModels sets the ResponseModels field's value.
func (s *MethodResponse) SetResponseModels(v map[string]*string) *MethodResponse {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *MethodResponse) SetResponseParameters(v map[string]*bool) *MethodResponse {
	s.ResponseParameters = v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *MethodResponse) SetStatusCode(v string) *MethodResponse {
	s.StatusCode = &v
	return s
}

// Specifies the method setting properties.
type MethodSetting struct {
	_ struct{} `type:"structure"`

	// Specifies whether the cached responses are encrypted. The PATCH path for
	// this setting is /{method_setting_key}/caching/dataEncrypted, and the value
	// is a Boolean.
	CacheDataEncrypted *bool `locationName:"cacheDataEncrypted" type:"boolean"`

	// Specifies the time to live (TTL), in seconds, for cached responses. The higher
	// the TTL, the longer the response will be cached. The PATCH path for this
	// setting is /{method_setting_key}/caching/ttlInSeconds, and the value is an
	// integer.
	CacheTtlInSeconds *int64 `locationName:"cacheTtlInSeconds" type:"integer"`

	// Specifies whether responses should be cached and returned for requests. A
	// cache cluster must be enabled on the stage for responses to be cached. The
	// PATCH path for this setting is /{method_setting_key}/caching/enabled, and
	// the value is a Boolean.
	CachingEnabled *bool `locationName:"cachingEnabled" type:"boolean"`

	// Specifies whether full requests and responses are logged for this method,
	// which affects the log entries pushed to Amazon CloudWatch Logs. This can
	// be useful to troubleshoot APIs, but can result in logging sensitive data.
	// We recommend that you don't enable this option for production APIs. The PATCH
	// path for this setting is /{method_setting_key}/logging/dataTrace, and the
	// value is a Boolean.
	DataTraceEnabled *bool `locationName:"dataTraceEnabled" type:"boolean"`

	// Specifies the logging level for this method, which affects the log entries
	// pushed to Amazon CloudWatch Logs. The PATCH path for this setting is /{method_setting_key}/logging/loglevel,
	// and the available levels are OFF, ERROR, and INFO. Choose ERROR to write
	// only error-level entries to CloudWatch Logs, or choose INFO to include all
	// ERROR events as well as extra informational events.
	LoggingLevel *string `locationName:"loggingLevel" type:"string"`

	// Specifies whether Amazon CloudWatch metrics are enabled for this method.
	// The PATCH path for this setting is /{method_setting_key}/metrics/enabled,
	// and the value is a Boolean.
	MetricsEnabled *bool `locationName:"metricsEnabled" type:"boolean"`

	// Specifies whether authorization is required for a cache invalidation request.
	// The PATCH path for this setting is /{method_setting_key}/caching/requireAuthorizationForCacheControl,
	// and the value is a Boolean.
	RequireAuthorizationForCacheControl *bool `locationName:"requireAuthorizationForCacheControl" type:"boolean"`

	// Specifies the throttling burst limit. The PATCH path for this setting is
	// /{method_setting_key}/throttling/burstLimit, and the value is an integer.
	ThrottlingBurstLimit *int64 `locationName:"throttlingBurstLimit" type:"integer"`

	// Specifies the throttling rate limit. The PATCH path for this setting is /{method_setting_key}/throttling/rateLimit,
	// and the value is a double.
	ThrottlingRateLimit *float64 `locationName:"throttlingRateLimit" type:"double"`

	// Specifies how to handle unauthorized requests for cache invalidation. The
	// PATCH path for this setting is /{method_setting_key}/caching/unauthorizedCacheControlHeaderStrategy,
	// and the available values are FAIL_WITH_403, SUCCEED_WITH_RESPONSE_HEADER,
	// SUCCEED_WITHOUT_RESPONSE_HEADER.
	UnauthorizedCacheControlHeaderStrategy *string `locationName:"unauthorizedCacheControlHeaderStrategy" type:"string" enum:"UnauthorizedCacheControlHeaderStrategy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodSetting) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodSetting) GoString() string {
	return s.String()
}

// SetCacheDataEncrypted sets the CacheDataEncrypted field's value.
func (s *MethodSetting) SetCacheDataEncrypted(v bool) *MethodSetting {
	s.CacheDataEncrypted = &v
	return s
}

// SetCacheTtlInSeconds sets the CacheTtlInSeconds field's value.
func (s *MethodSetting) SetCacheTtlInSeconds(v int64) *MethodSetting {
	s.CacheTtlInSeconds = &v
	return s
}

// SetCachingEnabled sets the CachingEnabled field's value.
func (s *MethodSetting) SetCachingEnabled(v bool) *MethodSetting {
	s.CachingEnabled = &v
	return s
}

// SetDataTraceEnabled sets the DataTraceEnabled field's value.
func (s *MethodSetting) SetDataTraceEnabled(v bool) *MethodSetting {
	s.DataTraceEnabled = &v
	return s
}

// SetLoggingLevel sets the LoggingLevel field's value.
func (s *MethodSetting) SetLoggingLevel(v string) *MethodSetting {
	s.LoggingLevel = &v
	return s
}

// SetMetricsEnabled sets the MetricsEnabled field's value.
func (s *MethodSetting) SetMetricsEnabled(v bool) *MethodSetting {
	s.MetricsEnabled = &v
	return s
}

// SetRequireAuthorizationForCacheControl sets the RequireAuthorizationForCacheControl field's value.
func (s *MethodSetting) SetRequireAuthorizationForCacheControl(v bool) *MethodSetting {
	s.RequireAuthorizationForCacheControl = &v
	return s
}

// SetThrottlingBurstLimit sets the ThrottlingBurstLimit field's value.
func (s *MethodSetting) SetThrottlingBurstLimit(v int64) *MethodSetting {
	s.ThrottlingBurstLimit = &v
	return s
}

// SetThrottlingRateLimit sets the ThrottlingRateLimit field's value.
func (s *MethodSetting) SetThrottlingRateLimit(v float64) *MethodSetting {
	s.ThrottlingRateLimit = &v
	return s
}

// SetUnauthorizedCacheControlHeaderStrategy sets the UnauthorizedCacheControlHeaderStrategy field's value.
func (s *MethodSetting) SetUnauthorizedCacheControlHeaderStrategy(v string) *MethodSetting {
	s.UnauthorizedCacheControlHeaderStrategy = &v
	return s
}

// Represents a summary of a Method resource, given a particular date and time.
type MethodSnapshot struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method requires a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// The method's authorization type. Valid values are NONE for open access, AWS_IAM
	// for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS
	// for using a Cognito user pool.
	AuthorizationType *string `locationName:"authorizationType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodSnapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MethodSnapshot) GoString() string {
	return s.String()
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *MethodSnapshot) SetApiKeyRequired(v bool) *MethodSnapshot {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *MethodSnapshot) SetAuthorizationType(v string) *MethodSnapshot {
	s.AuthorizationType = &v
	return s
}

// Represents the data structure of a method's request or response payload.
//
// A request model defines the data structure of the client-supplied request
// payload. A response model defines the data structure of the response payload
// returned by the back end. Although not required, models are useful for mapping
// payloads between the front end and back end.
//
// A model is used for generating an API's SDK, validating the input request
// body, and creating a skeletal mapping template.
//
// Method, MethodResponse, Models and Mappings (https://docs.aws.amazon.com/apigateway/latest/developerguide/models-mappings.html)
type Model struct {
	_ struct{} `type:"structure"`

	// The content-type for the model.
	ContentType *string `locationName:"contentType" type:"string"`

	// The description of the model.
	Description *string `locationName:"description" type:"string"`

	// The identifier for the model resource.
	Id *string `locationName:"id" type:"string"`

	// The name of the model. Must be an alphanumeric string.
	Name *string `locationName:"name" type:"string"`

	// The schema for the model. For application/json models, this should be JSON
	// schema draft 4 (https://tools.ietf.org/html/draft-zyp-json-schema-04) model.
	// Do not include "\*/" characters in the description of any properties because
	// such "\*/" characters may be interpreted as the closing marker for comments
	// in some languages, such as Java or JavaScript, causing the installation of
	// your API's SDK generated by API Gateway to fail.
	Schema *string `locationName:"schema" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Model) GoString() string {
	return s.String()
}

// SetContentType sets the ContentType field's value.
func (s *Model) SetContentType(v string) *Model {
	s.ContentType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Model) SetDescription(v string) *Model {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Model) SetId(v string) *Model {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *Model) SetName(v string) *Model {
	s.Name = &v
	return s
}

// SetSchema sets the Schema field's value.
func (s *Model) SetSchema(v string) *Model {
	s.Schema = &v
	return s
}

// If specified, API Gateway performs two-way authentication between the client
// and the server. Clients must present a trusted certificate to access your
// custom domain name.
type MutualTlsAuthentication struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 URL that specifies the truststore for mutual TLS authentication,
	// for example s3://bucket-name/key-name. The truststore can contain certificates
	// from public or private certificate authorities. To update the truststore,
	// upload a new version to S3, and then update your custom domain name to use
	// the new version. To update the truststore, you must have permissions to access
	// the S3 object.
	TruststoreUri *string `locationName:"truststoreUri" type:"string"`

	// The version of the S3 object that contains your truststore. To specify a
	// version, you must have versioning enabled for the S3 bucket.
	TruststoreVersion *string `locationName:"truststoreVersion" type:"string"`

	// A list of warnings that API Gateway returns while processing your truststore.
	// Invalid certificates produce warnings. Mutual TLS is still enabled, but some
	// clients might not be able to access your API. To resolve warnings, upload
	// a new truststore to S3, and then update you domain name to use the new version.
	TruststoreWarnings []*string `locationName:"truststoreWarnings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutualTlsAuthentication) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutualTlsAuthentication) GoString() string {
	return s.String()
}

// SetTruststoreUri sets the TruststoreUri field's value.
func (s *MutualTlsAuthentication) SetTruststoreUri(v string) *MutualTlsAuthentication {
	s.TruststoreUri = &v
	return s
}

// SetTruststoreVersion sets the TruststoreVersion field's value.
func (s *MutualTlsAuthentication) SetTruststoreVersion(v string) *MutualTlsAuthentication {
	s.TruststoreVersion = &v
	return s
}

// SetTruststoreWarnings sets the TruststoreWarnings field's value.
func (s *MutualTlsAuthentication) SetTruststoreWarnings(v []*string) *MutualTlsAuthentication {
	s.TruststoreWarnings = v
	return s
}

// If specified, API Gateway performs two-way authentication between the client
// and the server. Clients must present a trusted certificate to access your
// custom domain name.
type MutualTlsAuthenticationInput struct {
	_ struct{} `type:"structure"`

	// An Amazon S3 resource ARN that specifies the truststore for mutual TLS authentication,
	// for example, s3://bucket-name/key-name. The truststore can contain certificates
	// from public or private certificate authorities. To update the truststore,
	// upload a new version to S3, and then update your custom domain name to use
	// the new version. To update the truststore, you must have permissions to access
	// the S3 object.
	TruststoreUri *string `locationName:"truststoreUri" type:"string"`

	// The version of the S3 object that contains your truststore. To specify a
	// version, you must have versioning enabled for the S3 bucket.
	TruststoreVersion *string `locationName:"truststoreVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutualTlsAuthenticationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MutualTlsAuthenticationInput) GoString() string {
	return s.String()
}

// SetTruststoreUri sets the TruststoreUri field's value.
func (s *MutualTlsAuthenticationInput) SetTruststoreUri(v string) *MutualTlsAuthenticationInput {
	s.TruststoreUri = &v
	return s
}

// SetTruststoreVersion sets the TruststoreVersion field's value.
func (s *MutualTlsAuthenticationInput) SetTruststoreVersion(v string) *MutualTlsAuthenticationInput {
	s.TruststoreVersion = &v
	return s
}

// The requested resource is not found. Make sure that the request URI is correct.
type NotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s *NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *NotFoundException) OrigErr() error {
	return nil
}

func (s *NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *NotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *NotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A single patch operation to apply to the specified resource. Please refer
// to http://tools.ietf.org/html/rfc6902#section-4 for an explanation of how
// each operation is used.
type PatchOperation struct {
	_ struct{} `type:"structure"`

	// The copy update operation's source as identified by a JSON-Pointer value
	// referencing the location within the targeted resource to copy the value from.
	// For example, to promote a canary deployment, you copy the canary deployment
	// ID to the affiliated deployment ID by calling a PATCH request on a Stage
	// resource with "op":"copy", "from":"/canarySettings/deploymentId" and "path":"/deploymentId".
	From *string `locationName:"from" type:"string"`

	// An update operation to be performed with this PATCH request. The valid value
	// can be add, remove, replace or copy. Not all valid operations are supported
	// for a given resource. Support of the operations depends on specific operational
	// contexts. Attempts to apply an unsupported operation on a resource will return
	// an error message.
	Op *string `locationName:"op" type:"string" enum:"Op"`

	// The op operation's target, as identified by a JSON Pointer (https://tools.ietf.org/html/draft-ietf-appsawg-json-pointer-08)
	// value that references a location within the targeted resource. For example,
	// if the target resource has an updateable property of {"name":"value"}, the
	// path for this property is /name. If the name property value is a JSON object
	// (e.g., {"name": {"child/name": "child-value"}}), the path for the child/name
	// property will be /name/child~1name. Any slash ("/") character appearing in
	// path names must be escaped with "~1", as shown in the example above. Each
	// op operation can have only one path associated with it.
	Path *string `locationName:"path" type:"string"`

	// The new target value of the update operation. It is applicable for the add
	// or replace operation. When using AWS CLI to update a property of a JSON value,
	// enclose the JSON object with a pair of single quotes in a Linux shell, e.g.,
	// '{"a": ...}'. In a Windows shell, see Using JSON for Parameters (https://docs.aws.amazon.com/cli/latest/userguide/cli-using-param.html#cli-using-param-json).
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatchOperation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PatchOperation) GoString() string {
	return s.String()
}

// SetFrom sets the From field's value.
func (s *PatchOperation) SetFrom(v string) *PatchOperation {
	s.From = &v
	return s
}

// SetOp sets the Op field's value.
func (s *PatchOperation) SetOp(v string) *PatchOperation {
	s.Op = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PatchOperation) SetPath(v string) *PatchOperation {
	s.Path = &v
	return s
}

// SetValue sets the Value field's value.
func (s *PatchOperation) SetValue(v string) *PatchOperation {
	s.Value = &v
	return s
}

// Creates a customization of a GatewayResponse of a specified response type
// and status code on the given RestApi.
type PutGatewayResponseInput struct {
	_ struct{} `type:"structure"`

	// Response parameters (paths, query strings and headers) of the GatewayResponse
	// as a string-to-string map of key-value pairs.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Response templates of the GatewayResponse as a string-to-string map of key-value
	// pairs.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// [Required]
	// The response type of the associated GatewayResponse.
	//
	// ResponseType is a required field
	ResponseType *string `location:"uri" locationName:"response_type" type:"string" required:"true" enum:"GatewayResponseType"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// The HTTP status code of the GatewayResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGatewayResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutGatewayResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutGatewayResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutGatewayResponseInput"}
	if s.ResponseType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseType"))
	}
	if s.ResponseType != nil && len(*s.ResponseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseType", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *PutGatewayResponseInput) SetResponseParameters(v map[string]*string) *PutGatewayResponseInput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *PutGatewayResponseInput) SetResponseTemplates(v map[string]*string) *PutGatewayResponseInput {
	s.ResponseTemplates = v
	return s
}

// SetResponseType sets the ResponseType field's value.
func (s *PutGatewayResponseInput) SetResponseType(v string) *PutGatewayResponseInput {
	s.ResponseType = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutGatewayResponseInput) SetRestApiId(v string) *PutGatewayResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *PutGatewayResponseInput) SetStatusCode(v string) *PutGatewayResponseInput {
	s.StatusCode = &v
	return s
}

// Sets up a method's integration.
type PutIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A list of request parameters whose values API Gateway caches. To be valid
	// values for cacheKeyParameters, these parameters must also be specified for
	// Method requestParameters.
	CacheKeyParameters []*string `locationName:"cacheKeyParameters" type:"list"`

	// Specifies a group of related cached parameters. By default, API Gateway uses
	// the resource ID as the cacheNamespace. You can specify the same cacheNamespace
	// across resources to return the same cached data for requests to different
	// resources.
	CacheNamespace *string `locationName:"cacheNamespace" type:"string"`

	// The (id (https://docs.aws.amazon.com/apigateway/api-reference/resource/vpc-link/#id))
	// of the VpcLink used for the integration when connectionType=VPC_LINK and
	// undefined, otherwise.
	ConnectionId *string `locationName:"connectionId" type:"string"`

	// The type of the network connection to the integration endpoint. The valid
	// value is INTERNET for connections through the public routable internet or
	// VPC_LINK for private connections between API Gateway and a network load balancer
	// in a VPC. The default value is INTERNET.
	ConnectionType *string `locationName:"connectionType" type:"string" enum:"ConnectionType"`

	// Specifies how to handle request payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a request payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the request payload will be passed through
	// from the method request to integration request without modification, provided
	// that the passthroughBehavior is configured to support payload pass-through.
	ContentHandling *string `locationName:"contentHandling" type:"string" enum:"ContentHandlingStrategy"`

	// Specifies whether credentials are required for a put integration.
	Credentials *string `locationName:"credentials" type:"string"`

	// [Required] Specifies a put integration request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// Specifies a put integration HTTP method. When the integration type is HTTP
	// or AWS, this field is required.
	IntegrationHttpMethod *string `locationName:"httpMethod" type:"string"`

	// Specifies the pass-through behavior for incoming requests based on the Content-Type
	// header in the request, and the available mapping templates specified as the
	// requestTemplates property on the Integration resource. There are three valid
	// values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.
	//
	//    * WHEN_NO_MATCH passes the request body for unmapped content types through
	//    to the integration back end without transformation.
	//
	//    * NEVER rejects unmapped content types with an HTTP 415 'Unsupported Media
	//    Type' response.
	//
	//    * WHEN_NO_TEMPLATES allows pass-through when the integration has NO content
	//    types mapped to templates. However if there is at least one content type
	//    defined, unmapped content types will be rejected with the same 415 response.
	PassthroughBehavior *string `locationName:"passthroughBehavior" type:"string"`

	// A key-value map specifying request parameters that are passed from the method
	// request to the back end. The key is an integration request parameter name
	// and the associated value is a method request parameter value or static value
	// that must be enclosed within single quotes and pre-encoded as required by
	// the back end. The method request parameter value must match the pattern of
	// method.request.{location}.{name}, where location is querystring, path, or
	// header and name must be a valid and unique method request parameter name.
	RequestParameters map[string]*string `locationName:"requestParameters" type:"map"`

	// Represents a map of Velocity templates that are applied on the request payload
	// based on the value of the Content-Type header sent by the client. The content
	// type value is the key in this map, and the template (as a String) is the
	// value.
	RequestTemplates map[string]*string `locationName:"requestTemplates" type:"map"`

	// [Required] Specifies a put integration request's resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000
	// milliseconds or 29 seconds.
	TimeoutInMillis *int64 `locationName:"timeoutInMillis" type:"integer"`

	TlsConfig *TlsConfig `locationName:"tlsConfig" type:"structure"`

	// [Required] Specifies a put integration input's type.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true" enum:"IntegrationType"`

	// Specifies Uniform Resource Identifier (URI) of the integration endpoint.
	//
	//    * For HTTP or HTTP_PROXY integrations, the URI must be a fully formed,
	//    encoded HTTP(S) URL according to the RFC-3986 specification (https://en.wikipedia.org/wiki/Uniform_Resource_Identifier),
	//    for either standard integration, where connectionType is not VPC_LINK,
	//    or private integration, where connectionType is VPC_LINK. For a private
	//    HTTP integration, the URI is not used for routing.
	//
	//    * For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}.
	//    Here, {Region} is the API Gateway region (e.g., us-east-1); {service}
	//    is the name of the integrated AWS service (e.g., s3); and {subdomain}
	//    is a designated subdomain supported by certain AWS service for fast host-name
	//    lookup. action can be used for an AWS service action-based API, using
	//    an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api}
	//    refers to a supported action {name} plus any required input parameters.
	//    Alternatively, path can be used for an AWS service path-based API. The
	//    ensuing service_api refers to the path to an AWS service resource, including
	//    the region of the integrated AWS service, if applicable. For example,
	//    for integration with the S3 API of GetObject (https://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectGET.html),
	//    the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key}
	//    or arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key}
	Uri *string `locationName:"uri" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIntegrationInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCacheKeyParameters sets the CacheKeyParameters field's value.
func (s *PutIntegrationInput) SetCacheKeyParameters(v []*string) *PutIntegrationInput {
	s.CacheKeyParameters = v
	return s
}

// SetCacheNamespace sets the CacheNamespace field's value.
func (s *PutIntegrationInput) SetCacheNamespace(v string) *PutIntegrationInput {
	s.CacheNamespace = &v
	return s
}

// SetConnectionId sets the ConnectionId field's value.
func (s *PutIntegrationInput) SetConnectionId(v string) *PutIntegrationInput {
	s.ConnectionId = &v
	return s
}

// SetConnectionType sets the ConnectionType field's value.
func (s *PutIntegrationInput) SetConnectionType(v string) *PutIntegrationInput {
	s.ConnectionType = &v
	return s
}

// SetContentHandling sets the ContentHandling field's value.
func (s *PutIntegrationInput) SetContentHandling(v string) *PutIntegrationInput {
	s.ContentHandling = &v
	return s
}

// SetCredentials sets the Credentials field's value.
func (s *PutIntegrationInput) SetCredentials(v string) *PutIntegrationInput {
	s.Credentials = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *PutIntegrationInput) SetHttpMethod(v string) *PutIntegrationInput {
	s.HttpMethod = &v
	return s
}

// SetIntegrationHttpMethod sets the IntegrationHttpMethod field's value.
func (s *PutIntegrationInput) SetIntegrationHttpMethod(v string) *PutIntegrationInput {
	s.IntegrationHttpMethod = &v
	return s
}

// SetPassthroughBehavior sets the PassthroughBehavior field's value.
func (s *PutIntegrationInput) SetPassthroughBehavior(v string) *PutIntegrationInput {
	s.PassthroughBehavior = &v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *PutIntegrationInput) SetRequestParameters(v map[string]*string) *PutIntegrationInput {
	s.RequestParameters = v
	return s
}

// SetRequestTemplates sets the RequestTemplates field's value.
func (s *PutIntegrationInput) SetRequestTemplates(v map[string]*string) *PutIntegrationInput {
	s.RequestTemplates = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutIntegrationInput) SetResourceId(v string) *PutIntegrationInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutIntegrationInput) SetRestApiId(v string) *PutIntegrationInput {
	s.RestApiId = &v
	return s
}

// SetTimeoutInMillis sets the TimeoutInMillis field's value.
func (s *PutIntegrationInput) SetTimeoutInMillis(v int64) *PutIntegrationInput {
	s.TimeoutInMillis = &v
	return s
}

// SetTlsConfig sets the TlsConfig field's value.
func (s *PutIntegrationInput) SetTlsConfig(v *TlsConfig) *PutIntegrationInput {
	s.TlsConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *PutIntegrationInput) SetType(v string) *PutIntegrationInput {
	s.Type = &v
	return s
}

// SetUri sets the Uri field's value.
func (s *PutIntegrationInput) SetUri(v string) *PutIntegrationInput {
	s.Uri = &v
	return s
}

// Represents a put integration response request.
type PutIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// Specifies how to handle response payload content type conversions. Supported
	// values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:
	//
	//    * CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded
	//    string to the corresponding binary blob.
	//
	//    * CONVERT_TO_TEXT: Converts a response payload from a binary blob to a
	//    Base64-encoded string.
	//
	// If this property is not defined, the response payload will be passed through
	// from the integration response to the method response without modification.
	ContentHandling *string `locationName:"contentHandling" type:"string" enum:"ContentHandlingStrategy"`

	// [Required] Specifies a put integration response request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] Specifies a put integration response request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// A key-value map specifying response parameters that are passed to the method
	// response from the back end. The key is a method response header parameter
	// name and the mapped value is an integration response header value, a static
	// value enclosed within a pair of single quotes, or a JSON expression from
	// the integration response body. The mapping key must match the pattern of
	// method.response.header.{name}, where name is a valid and unique header name.
	// The mapped non-static value must match the pattern of integration.response.header.{name}
	// or integration.response.body.{JSON-expression}, where name must be a valid
	// and unique response header name and JSON-expression a valid JSON expression
	// without the $ prefix.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Specifies a put integration response's templates.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// Specifies the selection pattern of a put integration response.
	SelectionPattern *string `locationName:"selectionPattern" type:"string"`

	// [Required] Specifies the status code that is used to map the integration
	// response to an existing MethodResponse.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutIntegrationResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContentHandling sets the ContentHandling field's value.
func (s *PutIntegrationResponseInput) SetContentHandling(v string) *PutIntegrationResponseInput {
	s.ContentHandling = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *PutIntegrationResponseInput) SetHttpMethod(v string) *PutIntegrationResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutIntegrationResponseInput) SetResourceId(v string) *PutIntegrationResponseInput {
	s.ResourceId = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *PutIntegrationResponseInput) SetResponseParameters(v map[string]*string) *PutIntegrationResponseInput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *PutIntegrationResponseInput) SetResponseTemplates(v map[string]*string) *PutIntegrationResponseInput {
	s.ResponseTemplates = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutIntegrationResponseInput) SetRestApiId(v string) *PutIntegrationResponseInput {
	s.RestApiId = &v
	return s
}

// SetSelectionPattern sets the SelectionPattern field's value.
func (s *PutIntegrationResponseInput) SetSelectionPattern(v string) *PutIntegrationResponseInput {
	s.SelectionPattern = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *PutIntegrationResponseInput) SetStatusCode(v string) *PutIntegrationResponseInput {
	s.StatusCode = &v
	return s
}

// Request to add a method to an existing Resource resource.
type PutMethodInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether the method required a valid ApiKey.
	ApiKeyRequired *bool `locationName:"apiKeyRequired" type:"boolean"`

	// A list of authorization scopes configured on the method. The scopes are used
	// with a COGNITO_USER_POOLS authorizer to authorize the method invocation.
	// The authorization works by matching the method scopes against the scopes
	// parsed from the access token in the incoming request. The method invocation
	// is authorized if any method scopes matches a claimed scope in the access
	// token. Otherwise, the invocation is not authorized. When the method scope
	// is configured, the client must provide an access token instead of an identity
	// token for authorization purposes.
	AuthorizationScopes []*string `locationName:"authorizationScopes" type:"list"`

	// [Required] The method's authorization type. Valid values are NONE for open
	// access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom
	// authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
	//
	// AuthorizationType is a required field
	AuthorizationType *string `locationName:"authorizationType" type:"string" required:"true"`

	// Specifies the identifier of an Authorizer to use on this Method, if the type
	// is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by
	// API Gateway when you created the authorizer.
	AuthorizerId *string `locationName:"authorizerId" type:"string"`

	// [Required] Specifies the method request's HTTP method type.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A human-friendly operation identifier for the method. For example, you can
	// assign the operationName of ListPets for the GET /pets method in the PetStore
	// example.
	OperationName *string `locationName:"operationName" type:"string"`

	// Specifies the Model resources used for the request's content type. Request
	// models are represented as a key/value map, with a content type as the key
	// and a Model name as the value.
	RequestModels map[string]*string `locationName:"requestModels" type:"map"`

	// A key-value map defining required or optional method request parameters that
	// can be accepted by API Gateway. A key defines a method request parameter
	// name matching the pattern of method.request.{location}.{name}, where location
	// is querystring, path, or header and name is a valid and unique parameter
	// name. The value associated with the key is a Boolean flag indicating whether
	// the parameter is required (true) or optional (false). The method request
	// parameter names defined here are available in Integration to be mapped to
	// integration request parameters or body-mapping templates.
	RequestParameters map[string]*bool `locationName:"requestParameters" type:"map"`

	// The identifier of a RequestValidator for validating the method request.
	RequestValidatorId *string `locationName:"requestValidatorId" type:"string"`

	// [Required] The Resource identifier for the new Method resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMethodInput"}
	if s.AuthorizationType == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizationType"))
	}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKeyRequired sets the ApiKeyRequired field's value.
func (s *PutMethodInput) SetApiKeyRequired(v bool) *PutMethodInput {
	s.ApiKeyRequired = &v
	return s
}

// SetAuthorizationScopes sets the AuthorizationScopes field's value.
func (s *PutMethodInput) SetAuthorizationScopes(v []*string) *PutMethodInput {
	s.AuthorizationScopes = v
	return s
}

// SetAuthorizationType sets the AuthorizationType field's value.
func (s *PutMethodInput) SetAuthorizationType(v string) *PutMethodInput {
	s.AuthorizationType = &v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *PutMethodInput) SetAuthorizerId(v string) *PutMethodInput {
	s.AuthorizerId = &v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *PutMethodInput) SetHttpMethod(v string) *PutMethodInput {
	s.HttpMethod = &v
	return s
}

// SetOperationName sets the OperationName field's value.
func (s *PutMethodInput) SetOperationName(v string) *PutMethodInput {
	s.OperationName = &v
	return s
}

// SetRequestModels sets the RequestModels field's value.
func (s *PutMethodInput) SetRequestModels(v map[string]*string) *PutMethodInput {
	s.RequestModels = v
	return s
}

// SetRequestParameters sets the RequestParameters field's value.
func (s *PutMethodInput) SetRequestParameters(v map[string]*bool) *PutMethodInput {
	s.RequestParameters = v
	return s
}

// SetRequestValidatorId sets the RequestValidatorId field's value.
func (s *PutMethodInput) SetRequestValidatorId(v string) *PutMethodInput {
	s.RequestValidatorId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutMethodInput) SetResourceId(v string) *PutMethodInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutMethodInput) SetRestApiId(v string) *PutMethodInput {
	s.RestApiId = &v
	return s
}

// Request to add a MethodResponse to an existing Method resource.
type PutMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// [Required] The Resource identifier for the Method resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// Specifies the Model resources used for the response's content type. Response
	// models are represented as a key/value map, with a content type as the key
	// and a Model name as the value.
	ResponseModels map[string]*string `locationName:"responseModels" type:"map"`

	// A key-value map specifying required or optional response parameters that
	// API Gateway can send back to the caller. A key defines a method response
	// header name and the associated value is a Boolean flag indicating whether
	// the method response parameter is required or not. The method response header
	// names must match the pattern of method.response.header.{name}, where name
	// is a valid and unique header name. The response parameter names defined here
	// are available in the integration response to be mapped from an integration
	// response header expressed in integration.response.header.{name}, a static
	// value enclosed within a pair of single quotes (e.g., 'application/json'),
	// or a JSON expression from the back-end response payload in the form of integration.response.body.{JSON-expression},
	// where JSON-expression is a valid JSON expression without the $ prefix.)
	ResponseParameters map[string]*bool `locationName:"responseParameters" type:"map"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The method response's status code.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutMethodResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutMethodResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutMethodResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *PutMethodResponseInput) SetHttpMethod(v string) *PutMethodResponseInput {
	s.HttpMethod = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *PutMethodResponseInput) SetResourceId(v string) *PutMethodResponseInput {
	s.ResourceId = &v
	return s
}

// SetResponseModels sets the ResponseModels field's value.
func (s *PutMethodResponseInput) SetResponseModels(v map[string]*string) *PutMethodResponseInput {
	s.ResponseModels = v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *PutMethodResponseInput) SetResponseParameters(v map[string]*bool) *PutMethodResponseInput {
	s.ResponseParameters = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutMethodResponseInput) SetRestApiId(v string) *PutMethodResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *PutMethodResponseInput) SetStatusCode(v string) *PutMethodResponseInput {
	s.StatusCode = &v
	return s
}

// A PUT request to update an existing API, with external API definitions specified
// as the request body.
type PutRestApiInput struct {
	_ struct{} `type:"structure" payload:"Body"`

	// [Required] The PUT request body containing external API definitions. Currently,
	// only OpenAPI definition JSON/YAML files are supported. The maximum size of
	// the API definition file is 6MB.
	//
	// Body is a required field
	Body []byte `locationName:"body" type:"blob" required:"true"`

	// A query parameter to indicate whether to rollback the API update (true) or
	// not (false) when a warning is encountered. The default value is false.
	FailOnWarnings *bool `location:"querystring" locationName:"failonwarnings" type:"boolean"`

	// The mode query parameter to specify the update mode. Valid values are "merge"
	// and "overwrite". By default, the update mode is "merge".
	Mode *string `location:"querystring" locationName:"mode" type:"string" enum:"PutMode"`

	// Custom header parameters as part of the request. For example, to exclude
	// DocumentationParts from an imported API, set ignore=documentation as a parameters
	// value, as in the AWS CLI command of aws apigateway import-rest-api --parameters
	// ignore=documentation --body 'file:///path/to/imported-api-body.json'.
	Parameters map[string]*string `location:"querystring" locationName:"parameters" type:"map"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutRestApiInput"}
	if s.Body == nil {
		invalidParams.Add(request.NewErrParamRequired("Body"))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *PutRestApiInput) SetBody(v []byte) *PutRestApiInput {
	s.Body = v
	return s
}

// SetFailOnWarnings sets the FailOnWarnings field's value.
func (s *PutRestApiInput) SetFailOnWarnings(v bool) *PutRestApiInput {
	s.FailOnWarnings = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *PutRestApiInput) SetMode(v string) *PutRestApiInput {
	s.Mode = &v
	return s
}

// SetParameters sets the Parameters field's value.
func (s *PutRestApiInput) SetParameters(v map[string]*string) *PutRestApiInput {
	s.Parameters = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *PutRestApiInput) SetRestApiId(v string) *PutRestApiInput {
	s.RestApiId = &v
	return s
}

// Quotas configured for a usage plan.
type QuotaSettings struct {
	_ struct{} `type:"structure"`

	// The target maximum number of requests that can be made in a given time period.
	Limit *int64 `locationName:"limit" type:"integer"`

	// The day that a time period starts. For example, with a time period of WEEK,
	// an offset of 0 starts on Sunday, and an offset of 1 starts on Monday.
	Offset *int64 `locationName:"offset" type:"integer"`

	// The time period in which the limit applies. Valid values are "DAY", "WEEK"
	// or "MONTH".
	Period *string `locationName:"period" type:"string" enum:"QuotaPeriodType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuotaSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QuotaSettings) GoString() string {
	return s.String()
}

// SetLimit sets the Limit field's value.
func (s *QuotaSettings) SetLimit(v int64) *QuotaSettings {
	s.Limit = &v
	return s
}

// SetOffset sets the Offset field's value.
func (s *QuotaSettings) SetOffset(v int64) *QuotaSettings {
	s.Offset = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *QuotaSettings) SetPeriod(v string) *QuotaSettings {
	s.Period = &v
	return s
}

// Represents an API resource.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type Resource struct {
	_ struct{} `type:"structure"`

	// The resource's identifier.
	Id *string `locationName:"id" type:"string"`

	// The parent resource's identifier.
	ParentId *string `locationName:"parentId" type:"string"`

	// The full path for this resource.
	Path *string `locationName:"path" type:"string"`

	// The last path segment for this resource.
	PathPart *string `locationName:"pathPart" type:"string"`

	// Gets an API resource's method of a given HTTP verb.
	//
	// The resource methods are a map of methods indexed by methods' HTTP verbs
	// enabled on the resource. This method map is included in the 200 OK response
	// of the GET /restapis/{restapi_id}/resources/{resource_id} or GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods
	// request.
	//
	// Example: Get the GET method of an API resource
	//
	// Request
	//  GET /restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET HTTP/1.1 Content-Type:
	//  application/json Host: apigateway.us-east-1.amazonaws.com X-Amz-Date: 20170223T031827Z
	//  Authorization: AWS4-HMAC-SHA256 Credential={access_key_ID}/20170223/us-east-1/apigateway/aws4_request,
	//  SignedHeaders=content-type;host;x-amz-date, Signature={sig4_hash}
	// Response
	//  { "_links": { "curies": [ { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-{rel}.html",
	//  "name": "integration", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-integration-response-{rel}.html",
	//  "name": "integrationresponse", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-{rel}.html",
	//  "name": "method", "templated": true }, { "href": "https://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-method-response-{rel}.html",
	//  "name": "methodresponse", "templated": true } ], "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET",
	//  "name": "GET", "title": "GET" }, "integration:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "method:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
	//  }, "method:integration": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "method:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
	//  "name": "200", "title": "200" }, "method:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET"
	//  }, "methodresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/{status_code}",
	//  "templated": true } }, "apiKeyRequired": false, "authorizationType": "NONE",
	//  "httpMethod": "GET", "_embedded": { "method:integration": { "_links": {
	//  "self": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integration:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integration:responses": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integration:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration"
	//  }, "integrationresponse:put": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/{status_code}",
	//  "templated": true } }, "cacheKeyParameters": [], "cacheNamespace": "3kzxbg5sa2",
	//  "credentials": "arn:aws:iam::123456789012:role/apigAwsProxyRole", "httpMethod":
	//  "POST", "passthroughBehavior": "WHEN_NO_MATCH", "requestParameters": { "integration.request.header.Content-Type":
	//  "'application/x-amz-json-1.1'" }, "requestTemplates": { "application/json":
	//  "{\n}" }, "type": "AWS", "uri": "arn:aws:apigateway:us-east-1:kinesis:action/ListStreams",
	//  "_embedded": { "integration:responses": { "_links": { "self": { "href":
	//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200",
	//  "name": "200", "title": "200" }, "integrationresponse:delete": { "href":
	//  "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  }, "integrationresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/integration/responses/200"
	//  } }, "responseParameters": { "method.response.header.Content-Type": "'application/xml'"
	//  }, "responseTemplates": { "application/json": "$util.urlDecode(\"%3CkinesisStreams%3E#foreach($stream
	//  in $input.path('$.StreamNames'))%3Cstream%3E%3Cname%3E$stream%3C/name%3E%3C/stream%3E#end%3C/kinesisStreams%3E\")\n"
	//  }, "statusCode": "200" } } }, "method:responses": { "_links": { "self":
	//  { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200",
	//  "name": "200", "title": "200" }, "methodresponse:delete": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
	//  }, "methodresponse:update": { "href": "/restapis/fugvjdxtri/resources/3kzxbg5sa2/methods/GET/responses/200"
	//  } }, "responseModels": { "application/json": "Empty" }, "responseParameters":
	//  { "method.response.header.Content-Type": false }, "statusCode": "200" }
	//  } }
	// If the OPTIONS is enabled on the resource, you can follow the example here
	// to get that method. Just replace the GET of the last path segment in the
	// request URL with OPTIONS.
	ResourceMethods map[string]*Method `locationName:"resourceMethods" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *Resource) SetId(v string) *Resource {
	s.Id = &v
	return s
}

// SetParentId sets the ParentId field's value.
func (s *Resource) SetParentId(v string) *Resource {
	s.ParentId = &v
	return s
}

// SetPath sets the Path field's value.
func (s *Resource) SetPath(v string) *Resource {
	s.Path = &v
	return s
}

// SetPathPart sets the PathPart field's value.
func (s *Resource) SetPathPart(v string) *Resource {
	s.PathPart = &v
	return s
}

// SetResourceMethods sets the ResourceMethods field's value.
func (s *Resource) SetResourceMethods(v map[string]*Method) *Resource {
	s.ResourceMethods = v
	return s
}

// Represents a REST API.
//
// Create an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-create-api.html)
type RestApi struct {
	_ struct{} `type:"structure"`

	// The source of the API key for metering requests according to a usage plan.
	// Valid values are:
	//    * HEADER to read the API key from the X-API-Key header of a request.
	//
	//    * AUTHORIZER to read the API key from the UsageIdentifierKey from a custom
	//    authorizer.
	ApiKeySource *string `locationName:"apiKeySource" type:"string" enum:"ApiKeySourceType"`

	// The list of binary media types supported by the RestApi. By default, the
	// RestApi supports only UTF-8-encoded text payloads.
	BinaryMediaTypes []*string `locationName:"binaryMediaTypes" type:"list"`

	// The timestamp when the API was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The API's description.
	Description *string `locationName:"description" type:"string"`

	// Specifies whether clients can invoke your API by using the default execute-api
	// endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com
	// endpoint. To require that clients use a custom domain name to invoke your
	// API, disable the default endpoint.
	DisableExecuteApiEndpoint *bool `locationName:"disableExecuteApiEndpoint" type:"boolean"`

	// The endpoint configuration of this RestApi showing the endpoint types of
	// the API.
	EndpointConfiguration *EndpointConfiguration `locationName:"endpointConfiguration" type:"structure"`

	// The API's identifier. This identifier is unique across all of your APIs in
	// API Gateway.
	Id *string `locationName:"id" type:"string"`

	// A nullable integer that is used to enable compression (with non-negative
	// between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with
	// a null value) on an API. When compression is enabled, compression or decompression
	// is not applied on the payload if the payload size is smaller than this value.
	// Setting it to zero allows compression for any payload size.
	MinimumCompressionSize *int64 `locationName:"minimumCompressionSize" type:"integer"`

	// The API's name.
	Name *string `locationName:"name" type:"string"`

	// A stringified JSON policy document that applies to this RestApi regardless
	// of the caller and Method configuration.
	Policy *string `locationName:"policy" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// A version identifier for the API.
	Version *string `locationName:"version" type:"string"`

	// The warning messages reported when failonwarnings is turned on during API
	// import.
	Warnings []*string `locationName:"warnings" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestApi) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestApi) GoString() string {
	return s.String()
}

// SetApiKeySource sets the ApiKeySource field's value.
func (s *RestApi) SetApiKeySource(v string) *RestApi {
	s.ApiKeySource = &v
	return s
}

// SetBinaryMediaTypes sets the BinaryMediaTypes field's value.
func (s *RestApi) SetBinaryMediaTypes(v []*string) *RestApi {
	s.BinaryMediaTypes = v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *RestApi) SetCreatedDate(v time.Time) *RestApi {
	s.CreatedDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *RestApi) SetDescription(v string) *RestApi {
	s.Description = &v
	return s
}

// SetDisableExecuteApiEndpoint sets the DisableExecuteApiEndpoint field's value.
func (s *RestApi) SetDisableExecuteApiEndpoint(v bool) *RestApi {
	s.DisableExecuteApiEndpoint = &v
	return s
}

// SetEndpointConfiguration sets the EndpointConfiguration field's value.
func (s *RestApi) SetEndpointConfiguration(v *EndpointConfiguration) *RestApi {
	s.EndpointConfiguration = v
	return s
}

// SetId sets the Id field's value.
func (s *RestApi) SetId(v string) *RestApi {
	s.Id = &v
	return s
}

// SetMinimumCompressionSize sets the MinimumCompressionSize field's value.
func (s *RestApi) SetMinimumCompressionSize(v int64) *RestApi {
	s.MinimumCompressionSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *RestApi) SetName(v string) *RestApi {
	s.Name = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *RestApi) SetPolicy(v string) *RestApi {
	s.Policy = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *RestApi) SetTags(v map[string]*string) *RestApi {
	s.Tags = v
	return s
}

// SetVersion sets the Version field's value.
func (s *RestApi) SetVersion(v string) *RestApi {
	s.Version = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *RestApi) SetWarnings(v []*string) *RestApi {
	s.Warnings = v
	return s
}

// A configuration property of an SDK type.
type SdkConfigurationProperty struct {
	_ struct{} `type:"structure"`

	// The default value of an SdkType configuration property.
	DefaultValue *string `locationName:"defaultValue" type:"string"`

	// The description of an SdkType configuration property.
	Description *string `locationName:"description" type:"string"`

	// The user-friendly name of an SdkType configuration property.
	FriendlyName *string `locationName:"friendlyName" type:"string"`

	// The name of a an SdkType configuration property.
	Name *string `locationName:"name" type:"string"`

	// A boolean flag of an SdkType configuration property to indicate if the associated
	// SDK configuration property is required (true) or not (false).
	Required *bool `locationName:"required" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SdkConfigurationProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SdkConfigurationProperty) GoString() string {
	return s.String()
}

// SetDefaultValue sets the DefaultValue field's value.
func (s *SdkConfigurationProperty) SetDefaultValue(v string) *SdkConfigurationProperty {
	s.DefaultValue = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SdkConfigurationProperty) SetDescription(v string) *SdkConfigurationProperty {
	s.Description = &v
	return s
}

// SetFriendlyName sets the FriendlyName field's value.
func (s *SdkConfigurationProperty) SetFriendlyName(v string) *SdkConfigurationProperty {
	s.FriendlyName = &v
	return s
}

// SetName sets the Name field's value.
func (s *SdkConfigurationProperty) SetName(v string) *SdkConfigurationProperty {
	s.Name = &v
	return s
}

// SetRequired sets the Required field's value.
func (s *SdkConfigurationProperty) SetRequired(v bool) *SdkConfigurationProperty {
	s.Required = &v
	return s
}

// A type of SDK that API Gateway can generate.
type SdkType struct {
	_ struct{} `type:"structure"`

	// A list of configuration properties of an SdkType.
	ConfigurationProperties []*SdkConfigurationProperty `locationName:"configurationProperties" type:"list"`

	// The description of an SdkType.
	Description *string `locationName:"description" type:"string"`

	// The user-friendly name of an SdkType instance.
	FriendlyName *string `locationName:"friendlyName" type:"string"`

	// The identifier of an SdkType instance.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SdkType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SdkType) GoString() string {
	return s.String()
}

// SetConfigurationProperties sets the ConfigurationProperties field's value.
func (s *SdkType) SetConfigurationProperties(v []*SdkConfigurationProperty) *SdkType {
	s.ConfigurationProperties = v
	return s
}

// SetDescription sets the Description field's value.
func (s *SdkType) SetDescription(v string) *SdkType {
	s.Description = &v
	return s
}

// SetFriendlyName sets the FriendlyName field's value.
func (s *SdkType) SetFriendlyName(v string) *SdkType {
	s.FriendlyName = &v
	return s
}

// SetId sets the Id field's value.
func (s *SdkType) SetId(v string) *SdkType {
	s.Id = &v
	return s
}

// The requested service is not available. For details see the accompanying
// error message. Retry after the specified time period.
type ServiceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceUnavailableException) GoString() string {
	return s.String()
}

func newErrorServiceUnavailableException(v protocol.ResponseMetadata) error {
	return &ServiceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceUnavailableException) Code() string {
	return "ServiceUnavailableException"
}

// Message returns the exception's message.
func (s *ServiceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceUnavailableException) OrigErr() error {
	return nil
}

func (s *ServiceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents a unique identifier for a version of a deployed RestApi that is
// callable by users.
//
// Deploy an API (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-deploy-api.html)
type Stage struct {
	_ struct{} `type:"structure"`

	// Settings for logging access in this stage.
	AccessLogSettings *AccessLogSettings `locationName:"accessLogSettings" type:"structure"`

	// Specifies whether a cache cluster is enabled for the stage.
	CacheClusterEnabled *bool `locationName:"cacheClusterEnabled" type:"boolean"`

	// The size of the cache cluster for the stage, if enabled.
	CacheClusterSize *string `locationName:"cacheClusterSize" type:"string" enum:"CacheClusterSize"`

	// The status of the cache cluster for the stage, if enabled.
	CacheClusterStatus *string `locationName:"cacheClusterStatus" type:"string" enum:"CacheClusterStatus"`

	// Settings for the canary deployment in this stage.
	CanarySettings *CanarySettings `locationName:"canarySettings" type:"structure"`

	// The identifier of a client certificate for an API stage.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// The timestamp when the stage was created.
	CreatedDate *time.Time `locationName:"createdDate" type:"timestamp"`

	// The identifier of the Deployment that the stage points to.
	DeploymentId *string `locationName:"deploymentId" type:"string"`

	// The stage's description.
	Description *string `locationName:"description" type:"string"`

	// The version of the associated API documentation.
	DocumentationVersion *string `locationName:"documentationVersion" type:"string"`

	// The timestamp when the stage last updated.
	LastUpdatedDate *time.Time `locationName:"lastUpdatedDate" type:"timestamp"`

	// A map that defines the method settings for a Stage resource. Keys (designated
	// as /{method_setting_key below) are method paths defined as {resource_path}/{http_method}
	// for an individual method override, or /\*/\* for overriding all methods in
	// the stage.
	MethodSettings map[string]*MethodSetting `locationName:"methodSettings" type:"map"`

	// The name of the stage is the first path segment in the Uniform Resource Identifier
	// (URI) of a call to API Gateway. Stage names can only contain alphanumeric
	// characters, hyphens, and underscores. Maximum length is 128 characters.
	StageName *string `locationName:"stageName" type:"string"`

	// The collection of tags. Each tag element is associated with a given resource.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Specifies whether active tracing with X-ray is enabled for the Stage.
	TracingEnabled *bool `locationName:"tracingEnabled" type:"boolean"`

	// A map that defines the stage variables for a Stage resource. Variable names
	// can have alphanumeric and underscore characters, and the values must match
	// [A-Za-z0-9-._~:/?#&=,]+.
	Variables map[string]*string `locationName:"variables" type:"map"`

	// The ARN of the WebAcl associated with the Stage.
	WebAclArn *string `locationName:"webAclArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Stage) GoString() string {
	return s.String()
}

// SetAccessLogSettings sets the AccessLogSettings field's value.
func (s *Stage) SetAccessLogSettings(v *AccessLogSettings) *Stage {
	s.AccessLogSettings = v
	return s
}

// SetCacheClusterEnabled sets the CacheClusterEnabled field's value.
func (s *Stage) SetCacheClusterEnabled(v bool) *Stage {
	s.CacheClusterEnabled = &v
	return s
}

// SetCacheClusterSize sets the CacheClusterSize field's value.
func (s *Stage) SetCacheClusterSize(v string) *Stage {
	s.CacheClusterSize = &v
	return s
}

// SetCacheClusterStatus sets the CacheClusterStatus field's value.
func (s *Stage) SetCacheClusterStatus(v string) *Stage {
	s.CacheClusterStatus = &v
	return s
}

// SetCanarySettings sets the CanarySettings field's value.
func (s *Stage) SetCanarySettings(v *CanarySettings) *Stage {
	s.CanarySettings = v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *Stage) SetClientCertificateId(v string) *Stage {
	s.ClientCertificateId = &v
	return s
}

// SetCreatedDate sets the CreatedDate field's value.
func (s *Stage) SetCreatedDate(v time.Time) *Stage {
	s.CreatedDate = &v
	return s
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *Stage) SetDeploymentId(v string) *Stage {
	s.DeploymentId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Stage) SetDescription(v string) *Stage {
	s.Description = &v
	return s
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *Stage) SetDocumentationVersion(v string) *Stage {
	s.DocumentationVersion = &v
	return s
}

// SetLastUpdatedDate sets the LastUpdatedDate field's value.
func (s *Stage) SetLastUpdatedDate(v time.Time) *Stage {
	s.LastUpdatedDate = &v
	return s
}

// SetMethodSettings sets the MethodSettings field's value.
func (s *Stage) SetMethodSettings(v map[string]*MethodSetting) *Stage {
	s.MethodSettings = v
	return s
}

// SetStageName sets the StageName field's value.
func (s *Stage) SetStageName(v string) *Stage {
	s.StageName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Stage) SetTags(v map[string]*string) *Stage {
	s.Tags = v
	return s
}

// SetTracingEnabled sets the TracingEnabled field's value.
func (s *Stage) SetTracingEnabled(v bool) *Stage {
	s.TracingEnabled = &v
	return s
}

// SetVariables sets the Variables field's value.
func (s *Stage) SetVariables(v map[string]*string) *Stage {
	s.Variables = v
	return s
}

// SetWebAclArn sets the WebAclArn field's value.
func (s *Stage) SetWebAclArn(v string) *Stage {
	s.WebAclArn = &v
	return s
}

// A reference to a unique stage identified in the format {restApiId}/{stage}.
type StageKey struct {
	_ struct{} `type:"structure"`

	// The string identifier of the associated RestApi.
	RestApiId *string `locationName:"restApiId" type:"string"`

	// The stage name associated with the stage key.
	StageName *string `locationName:"stageName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageKey) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StageKey) GoString() string {
	return s.String()
}

// SetRestApiId sets the RestApiId field's value.
func (s *StageKey) SetRestApiId(v string) *StageKey {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *StageKey) SetStageName(v string) *StageKey {
	s.StageName = &v
	return s
}

// Adds or updates a tag on a given resource.
type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// [Required] The ARN of a resource that can be tagged.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource_arn" type:"string" required:"true"`

	// [Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/].
	// The tag key can be up to 128 characters and must not start with aws:. The
	// tag value can be up to 256 characters.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Make a request to simulate the execution of an Authorizer.
type TestInvokeAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// [Optional] A key-value map of additional context variables.
	AdditionalContext map[string]*string `locationName:"additionalContext" type:"map"`

	// [Required] Specifies a test invoke authorizer request's Authorizer ID.
	//
	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizer_id" type:"string" required:"true"`

	// [Optional] The simulated request body of an incoming invocation request.
	Body *string `locationName:"body" type:"string"`

	// [Required] A key-value map of headers to simulate an incoming invocation
	// request. This is where the incoming authorization token, or identity source,
	// should be specified.
	Headers map[string]*string `locationName:"headers" type:"map"`

	// [Optional] The headers as a map from string to list of values to simulate
	// an incoming invocation request. This is where the incoming authorization
	// token, or identity source, may be specified.
	MultiValueHeaders map[string][]*string `locationName:"multiValueHeaders" type:"map"`

	// [Optional] The URI path, including query string, of the simulated invocation
	// request. Use this to specify path parameters and query string parameters.
	PathWithQueryString *string `locationName:"pathWithQueryString" type:"string"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// A key-value map of stage variables to simulate an invocation on a deployed
	// Stage.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestInvokeAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestInvokeAuthorizerInput"}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdditionalContext sets the AdditionalContext field's value.
func (s *TestInvokeAuthorizerInput) SetAdditionalContext(v map[string]*string) *TestInvokeAuthorizerInput {
	s.AdditionalContext = v
	return s
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *TestInvokeAuthorizerInput) SetAuthorizerId(v string) *TestInvokeAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

// SetBody sets the Body field's value.
func (s *TestInvokeAuthorizerInput) SetBody(v string) *TestInvokeAuthorizerInput {
	s.Body = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *TestInvokeAuthorizerInput) SetHeaders(v map[string]*string) *TestInvokeAuthorizerInput {
	s.Headers = v
	return s
}

// SetMultiValueHeaders sets the MultiValueHeaders field's value.
func (s *TestInvokeAuthorizerInput) SetMultiValueHeaders(v map[string][]*string) *TestInvokeAuthorizerInput {
	s.MultiValueHeaders = v
	return s
}

// SetPathWithQueryString sets the PathWithQueryString field's value.
func (s *TestInvokeAuthorizerInput) SetPathWithQueryString(v string) *TestInvokeAuthorizerInput {
	s.PathWithQueryString = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *TestInvokeAuthorizerInput) SetRestApiId(v string) *TestInvokeAuthorizerInput {
	s.RestApiId = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *TestInvokeAuthorizerInput) SetStageVariables(v map[string]*string) *TestInvokeAuthorizerInput {
	s.StageVariables = v
	return s
}

// Represents the response of the test invoke request for a custom Authorizer
type TestInvokeAuthorizerOutput struct {
	_ struct{} `type:"structure"`

	Authorization map[string][]*string `locationName:"authorization" type:"map"`

	// The open identity claims (https://openid.net/specs/openid-connect-core-1_0.html#StandardClaims),
	// with any supported custom attributes, returned from the Cognito Your User
	// Pool configured for the API.
	Claims map[string]*string `locationName:"claims" type:"map"`

	// The HTTP status code that the client would have received. Value is 0 if the
	// authorizer succeeded.
	ClientStatus *int64 `locationName:"clientStatus" type:"integer"`

	// The execution latency of the test authorizer request.
	Latency *int64 `locationName:"latency" type:"long"`

	// The API Gateway execution log for the test authorizer request.
	Log *string `locationName:"log" type:"string"`

	// The JSON policy document returned by the Authorizer
	Policy *string `locationName:"policy" type:"string"`

	// The principal identity returned by the Authorizer
	PrincipalId *string `locationName:"principalId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeAuthorizerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeAuthorizerOutput) GoString() string {
	return s.String()
}

// SetAuthorization sets the Authorization field's value.
func (s *TestInvokeAuthorizerOutput) SetAuthorization(v map[string][]*string) *TestInvokeAuthorizerOutput {
	s.Authorization = v
	return s
}

// SetClaims sets the Claims field's value.
func (s *TestInvokeAuthorizerOutput) SetClaims(v map[string]*string) *TestInvokeAuthorizerOutput {
	s.Claims = v
	return s
}

// SetClientStatus sets the ClientStatus field's value.
func (s *TestInvokeAuthorizerOutput) SetClientStatus(v int64) *TestInvokeAuthorizerOutput {
	s.ClientStatus = &v
	return s
}

// SetLatency sets the Latency field's value.
func (s *TestInvokeAuthorizerOutput) SetLatency(v int64) *TestInvokeAuthorizerOutput {
	s.Latency = &v
	return s
}

// SetLog sets the Log field's value.
func (s *TestInvokeAuthorizerOutput) SetLog(v string) *TestInvokeAuthorizerOutput {
	s.Log = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *TestInvokeAuthorizerOutput) SetPolicy(v string) *TestInvokeAuthorizerOutput {
	s.Policy = &v
	return s
}

// SetPrincipalId sets the PrincipalId field's value.
func (s *TestInvokeAuthorizerOutput) SetPrincipalId(v string) *TestInvokeAuthorizerOutput {
	s.PrincipalId = &v
	return s
}

// Make a request to simulate the execution of a Method.
type TestInvokeMethodInput struct {
	_ struct{} `type:"structure"`

	// The simulated request body of an incoming invocation request.
	Body *string `locationName:"body" type:"string"`

	// A ClientCertificate identifier to use in the test invocation. API Gateway
	// will use the certificate when making the HTTPS request to the defined back-end
	// endpoint.
	ClientCertificateId *string `locationName:"clientCertificateId" type:"string"`

	// A key-value map of headers to simulate an incoming invocation request.
	Headers map[string]*string `locationName:"headers" type:"map"`

	// [Required] Specifies a test invoke method request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// The headers as a map from string to list of values to simulate an incoming
	// invocation request.
	MultiValueHeaders map[string][]*string `locationName:"multiValueHeaders" type:"map"`

	// The URI path, including query string, of the simulated invocation request.
	// Use this to specify path parameters and query string parameters.
	PathWithQueryString *string `locationName:"pathWithQueryString" type:"string"`

	// [Required] Specifies a test invoke method request's resource ID.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// A key-value map of stage variables to simulate an invocation on a deployed
	// Stage.
	StageVariables map[string]*string `locationName:"stageVariables" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TestInvokeMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TestInvokeMethodInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBody sets the Body field's value.
func (s *TestInvokeMethodInput) SetBody(v string) *TestInvokeMethodInput {
	s.Body = &v
	return s
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *TestInvokeMethodInput) SetClientCertificateId(v string) *TestInvokeMethodInput {
	s.ClientCertificateId = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *TestInvokeMethodInput) SetHeaders(v map[string]*string) *TestInvokeMethodInput {
	s.Headers = v
	return s
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *TestInvokeMethodInput) SetHttpMethod(v string) *TestInvokeMethodInput {
	s.HttpMethod = &v
	return s
}

// SetMultiValueHeaders sets the MultiValueHeaders field's value.
func (s *TestInvokeMethodInput) SetMultiValueHeaders(v map[string][]*string) *TestInvokeMethodInput {
	s.MultiValueHeaders = v
	return s
}

// SetPathWithQueryString sets the PathWithQueryString field's value.
func (s *TestInvokeMethodInput) SetPathWithQueryString(v string) *TestInvokeMethodInput {
	s.PathWithQueryString = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *TestInvokeMethodInput) SetResourceId(v string) *TestInvokeMethodInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *TestInvokeMethodInput) SetRestApiId(v string) *TestInvokeMethodInput {
	s.RestApiId = &v
	return s
}

// SetStageVariables sets the StageVariables field's value.
func (s *TestInvokeMethodInput) SetStageVariables(v map[string]*string) *TestInvokeMethodInput {
	s.StageVariables = v
	return s
}

// Represents the response of the test invoke request in the HTTP method.
//
// Test API using the API Gateway console (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-test-method.html#how-to-test-method-console)
type TestInvokeMethodOutput struct {
	_ struct{} `type:"structure"`

	// The body of the HTTP response.
	Body *string `locationName:"body" type:"string"`

	// The headers of the HTTP response.
	Headers map[string]*string `locationName:"headers" type:"map"`

	// The execution latency of the test invoke request.
	Latency *int64 `locationName:"latency" type:"long"`

	// The API Gateway execution log for the test invoke request.
	Log *string `locationName:"log" type:"string"`

	// The headers of the HTTP response as a map from string to list of values.
	MultiValueHeaders map[string][]*string `locationName:"multiValueHeaders" type:"map"`

	// The HTTP status code.
	Status *int64 `locationName:"status" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeMethodOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TestInvokeMethodOutput) GoString() string {
	return s.String()
}

// SetBody sets the Body field's value.
func (s *TestInvokeMethodOutput) SetBody(v string) *TestInvokeMethodOutput {
	s.Body = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *TestInvokeMethodOutput) SetHeaders(v map[string]*string) *TestInvokeMethodOutput {
	s.Headers = v
	return s
}

// SetLatency sets the Latency field's value.
func (s *TestInvokeMethodOutput) SetLatency(v int64) *TestInvokeMethodOutput {
	s.Latency = &v
	return s
}

// SetLog sets the Log field's value.
func (s *TestInvokeMethodOutput) SetLog(v string) *TestInvokeMethodOutput {
	s.Log = &v
	return s
}

// SetMultiValueHeaders sets the MultiValueHeaders field's value.
func (s *TestInvokeMethodOutput) SetMultiValueHeaders(v map[string][]*string) *TestInvokeMethodOutput {
	s.MultiValueHeaders = v
	return s
}

// SetStatus sets the Status field's value.
func (s *TestInvokeMethodOutput) SetStatus(v int64) *TestInvokeMethodOutput {
	s.Status = &v
	return s
}

// The API request rate limits.
type ThrottleSettings struct {
	_ struct{} `type:"structure"`

	// The API target request burst rate limit. This allows more requests through
	// for a period of time than the target rate limit.
	BurstLimit *int64 `locationName:"burstLimit" type:"integer"`

	// The API target request rate limit.
	RateLimit *float64 `locationName:"rateLimit" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottleSettings) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottleSettings) GoString() string {
	return s.String()
}

// SetBurstLimit sets the BurstLimit field's value.
func (s *ThrottleSettings) SetBurstLimit(v int64) *ThrottleSettings {
	s.BurstLimit = &v
	return s
}

// SetRateLimit sets the RateLimit field's value.
func (s *ThrottleSettings) SetRateLimit(v float64) *ThrottleSettings {
	s.RateLimit = &v
	return s
}

type TlsConfig struct {
	_ struct{} `type:"structure"`

	// Specifies whether or not API Gateway skips verification that the certificate
	// for an integration endpoint is issued by a supported certificate authority
	// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-supported-certificate-authorities-for-http-endpoints.html).
	// This isn’t recommended, but it enables you to use certificates that are
	// signed by private certificate authorities, or certificates that are self-signed.
	// If enabled, API Gateway still performs basic certificate validation, which
	// includes checking the certificate's expiration date, hostname, and presence
	// of a root certificate authority. Supported only for HTTP and HTTP_PROXY integrations.
	InsecureSkipVerification *bool `locationName:"insecureSkipVerification" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TlsConfig) GoString() string {
	return s.String()
}

// SetInsecureSkipVerification sets the InsecureSkipVerification field's value.
func (s *TlsConfig) SetInsecureSkipVerification(v bool) *TlsConfig {
	s.InsecureSkipVerification = &v
	return s
}

// The request has reached its throttling limit. Retry after the specified time
// period.
type TooManyRequestsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	RetryAfterSeconds *string `location:"header" locationName:"Retry-After" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyRequestsException) GoString() string {
	return s.String()
}

func newErrorTooManyRequestsException(v protocol.ResponseMetadata) error {
	return &TooManyRequestsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyRequestsException) Code() string {
	return "TooManyRequestsException"
}

// Message returns the exception's message.
func (s *TooManyRequestsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyRequestsException) OrigErr() error {
	return nil
}

func (s *TooManyRequestsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyRequestsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyRequestsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is denied because the caller has insufficient permissions.
type UnauthorizedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnauthorizedException) GoString() string {
	return s.String()
}

func newErrorUnauthorizedException(v protocol.ResponseMetadata) error {
	return &UnauthorizedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnauthorizedException) Code() string {
	return "UnauthorizedException"
}

// Message returns the exception's message.
func (s *UnauthorizedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnauthorizedException) OrigErr() error {
	return nil
}

func (s *UnauthorizedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnauthorizedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnauthorizedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Removes a tag from a given resource.
type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// [Required] The ARN of a resource that can be tagged.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resource_arn" type:"string" required:"true"`

	// [Required] The Tag keys to delete.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Requests API Gateway to change information about the current Account resource.
type UpdateAccountInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAccountInput) GoString() string {
	return s.String()
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateAccountInput) SetPatchOperations(v []*PatchOperation) *UpdateAccountInput {
	s.PatchOperations = v
	return s
}

// A request to change information about an ApiKey resource.
type UpdateApiKeyInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the ApiKey resource to be updated.
	//
	// ApiKey is a required field
	ApiKey *string `location:"uri" locationName:"api_Key" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApiKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApiKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApiKeyInput"}
	if s.ApiKey == nil {
		invalidParams.Add(request.NewErrParamRequired("ApiKey"))
	}
	if s.ApiKey != nil && len(*s.ApiKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ApiKey", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApiKey sets the ApiKey field's value.
func (s *UpdateApiKeyInput) SetApiKey(v string) *UpdateApiKeyInput {
	s.ApiKey = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateApiKeyInput) SetPatchOperations(v []*PatchOperation) *UpdateApiKeyInput {
	s.PatchOperations = v
	return s
}

// Request to update an existing Authorizer resource.
type UpdateAuthorizerInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the Authorizer resource.
	//
	// AuthorizerId is a required field
	AuthorizerId *string `location:"uri" locationName:"authorizer_id" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAuthorizerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAuthorizerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAuthorizerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAuthorizerInput"}
	if s.AuthorizerId == nil {
		invalidParams.Add(request.NewErrParamRequired("AuthorizerId"))
	}
	if s.AuthorizerId != nil && len(*s.AuthorizerId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AuthorizerId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthorizerId sets the AuthorizerId field's value.
func (s *UpdateAuthorizerInput) SetAuthorizerId(v string) *UpdateAuthorizerInput {
	s.AuthorizerId = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateAuthorizerInput) SetPatchOperations(v []*PatchOperation) *UpdateAuthorizerInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateAuthorizerInput) SetRestApiId(v string) *UpdateAuthorizerInput {
	s.RestApiId = &v
	return s
}

// A request to change information about the BasePathMapping resource.
type UpdateBasePathMappingInput struct {
	_ struct{} `type:"structure"`

	// [Required] The base path of the BasePathMapping resource to change.
	//
	// To specify an empty base path, set this parameter to '(none)'.
	//
	// BasePath is a required field
	BasePath *string `location:"uri" locationName:"base_path" type:"string" required:"true"`

	// [Required] The domain name of the BasePathMapping resource to change.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBasePathMappingInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateBasePathMappingInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateBasePathMappingInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateBasePathMappingInput"}
	if s.BasePath == nil {
		invalidParams.Add(request.NewErrParamRequired("BasePath"))
	}
	if s.BasePath != nil && len(*s.BasePath) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BasePath", 1))
	}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBasePath sets the BasePath field's value.
func (s *UpdateBasePathMappingInput) SetBasePath(v string) *UpdateBasePathMappingInput {
	s.BasePath = &v
	return s
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateBasePathMappingInput) SetDomainName(v string) *UpdateBasePathMappingInput {
	s.DomainName = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateBasePathMappingInput) SetPatchOperations(v []*PatchOperation) *UpdateBasePathMappingInput {
	s.PatchOperations = v
	return s
}

// A request to change information about an ClientCertificate resource.
type UpdateClientCertificateInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the ClientCertificate resource to be updated.
	//
	// ClientCertificateId is a required field
	ClientCertificateId *string `location:"uri" locationName:"clientcertificate_id" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClientCertificateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateClientCertificateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateClientCertificateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateClientCertificateInput"}
	if s.ClientCertificateId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientCertificateId"))
	}
	if s.ClientCertificateId != nil && len(*s.ClientCertificateId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientCertificateId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientCertificateId sets the ClientCertificateId field's value.
func (s *UpdateClientCertificateInput) SetClientCertificateId(v string) *UpdateClientCertificateInput {
	s.ClientCertificateId = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateClientCertificateInput) SetPatchOperations(v []*PatchOperation) *UpdateClientCertificateInput {
	s.PatchOperations = v
	return s
}

// Requests API Gateway to change information about a Deployment resource.
type UpdateDeploymentInput struct {
	_ struct{} `type:"structure"`

	// The replacement identifier for the Deployment resource to change information
	// about.
	//
	// DeploymentId is a required field
	DeploymentId *string `location:"uri" locationName:"deployment_id" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDeploymentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDeploymentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDeploymentInput"}
	if s.DeploymentId == nil {
		invalidParams.Add(request.NewErrParamRequired("DeploymentId"))
	}
	if s.DeploymentId != nil && len(*s.DeploymentId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DeploymentId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *UpdateDeploymentInput) SetDeploymentId(v string) *UpdateDeploymentInput {
	s.DeploymentId = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateDeploymentInput) SetPatchOperations(v []*PatchOperation) *UpdateDeploymentInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateDeploymentInput) SetRestApiId(v string) *UpdateDeploymentInput {
	s.RestApiId = &v
	return s
}

// Updates an existing documentation part of a given API.
type UpdateDocumentationPartInput struct {
	_ struct{} `type:"structure"`

	// [Required] The identifier of the to-be-updated documentation part.
	//
	// DocumentationPartId is a required field
	DocumentationPartId *string `location:"uri" locationName:"part_id" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDocumentationPartInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDocumentationPartInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentationPartInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDocumentationPartInput"}
	if s.DocumentationPartId == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationPartId"))
	}
	if s.DocumentationPartId != nil && len(*s.DocumentationPartId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationPartId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationPartId sets the DocumentationPartId field's value.
func (s *UpdateDocumentationPartInput) SetDocumentationPartId(v string) *UpdateDocumentationPartInput {
	s.DocumentationPartId = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateDocumentationPartInput) SetPatchOperations(v []*PatchOperation) *UpdateDocumentationPartInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateDocumentationPartInput) SetRestApiId(v string) *UpdateDocumentationPartInput {
	s.RestApiId = &v
	return s
}

// Updates an existing documentation version of an API.
type UpdateDocumentationVersionInput struct {
	_ struct{} `type:"structure"`

	// [Required] The version identifier of the to-be-updated documentation version.
	//
	// DocumentationVersion is a required field
	DocumentationVersion *string `location:"uri" locationName:"doc_version" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi..
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDocumentationVersionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDocumentationVersionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDocumentationVersionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDocumentationVersionInput"}
	if s.DocumentationVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentationVersion"))
	}
	if s.DocumentationVersion != nil && len(*s.DocumentationVersion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentationVersion", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentationVersion sets the DocumentationVersion field's value.
func (s *UpdateDocumentationVersionInput) SetDocumentationVersion(v string) *UpdateDocumentationVersionInput {
	s.DocumentationVersion = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateDocumentationVersionInput) SetPatchOperations(v []*PatchOperation) *UpdateDocumentationVersionInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateDocumentationVersionInput) SetRestApiId(v string) *UpdateDocumentationVersionInput {
	s.RestApiId = &v
	return s
}

// A request to change information about the DomainName resource.
type UpdateDomainNameInput struct {
	_ struct{} `type:"structure"`

	// [Required] The name of the DomainName resource to be changed.
	//
	// DomainName is a required field
	DomainName *string `location:"uri" locationName:"domain_name" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainNameInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDomainNameInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainNameInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDomainNameInput"}
	if s.DomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("DomainName"))
	}
	if s.DomainName != nil && len(*s.DomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DomainName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDomainName sets the DomainName field's value.
func (s *UpdateDomainNameInput) SetDomainName(v string) *UpdateDomainNameInput {
	s.DomainName = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateDomainNameInput) SetPatchOperations(v []*PatchOperation) *UpdateDomainNameInput {
	s.PatchOperations = v
	return s
}

// Updates a GatewayResponse of a specified response type on the given RestApi.
type UpdateGatewayResponseInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required]
	// The response type of the associated GatewayResponse.
	//
	// ResponseType is a required field
	ResponseType *string `location:"uri" locationName:"response_type" type:"string" required:"true" enum:"GatewayResponseType"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGatewayResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGatewayResponseInput"}
	if s.ResponseType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResponseType"))
	}
	if s.ResponseType != nil && len(*s.ResponseType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResponseType", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateGatewayResponseInput) SetPatchOperations(v []*PatchOperation) *UpdateGatewayResponseInput {
	s.PatchOperations = v
	return s
}

// SetResponseType sets the ResponseType field's value.
func (s *UpdateGatewayResponseInput) SetResponseType(v string) *UpdateGatewayResponseInput {
	s.ResponseType = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateGatewayResponseInput) SetRestApiId(v string) *UpdateGatewayResponseInput {
	s.RestApiId = &v
	return s
}

// A gateway response of a given response type and status code, with optional
// response parameters and mapping templates.
//
// For more information about valid gateway response types, see Gateway Response
// Types Supported by API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html)
//
// Example: Get a Gateway Response of a given response type
//
// Request
//
// This example shows how to get a gateway response of the MISSING_AUTHENTICATION_TOKEN
// type.
//  GET /restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN HTTP/1.1
//  Host: beta-apigateway.us-east-1.amazonaws.com Content-Type: application/json
//  X-Amz-Date: 20170503T202516Z Authorization: AWS4-HMAC-SHA256 Credential={access-key-id}/20170503/us-east-1/apigateway/aws4_request,
//  SignedHeaders=content-type;host;x-amz-date, Signature=1b52460e3159c1a26cff29093855d50ea141c1c5b937528fecaf60f51129697a
//  Cache-Control: no-cache Postman-Token: 3b2a1ce9-c848-2e26-2e2f-9c2caefbed45
// The response type is specified as a URL path.
//
// Response
//
// The successful operation returns the 200 OK status code and a payload similar
// to the following:
//  { "_links": { "curies": { "href": "http://docs.aws.amazon.com/apigateway/latest/developerguide/restapi-gatewayresponse-{rel}.html",
//  "name": "gatewayresponse", "templated": true }, "self": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  }, "gatewayresponse:delete": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  }, "gatewayresponse:put": { "href": "/restapis/o81lxisefl/gatewayresponses/{response_type}",
//  "templated": true }, "gatewayresponse:update": { "href": "/restapis/o81lxisefl/gatewayresponses/MISSING_AUTHENTICATION_TOKEN"
//  } }, "defaultResponse": false, "responseParameters": { "gatewayresponse.header.x-request-path":
//  "method.request.path.petId", "gatewayresponse.header.Access-Control-Allow-Origin":
//  "'a.b.c'", "gatewayresponse.header.x-request-query": "method.request.querystring.q",
//  "gatewayresponse.header.x-request-header": "method.request.header.Accept"
//  }, "responseTemplates": { "application/json": "{\n \"message\": $context.error.messageString,\n
//  \"type\": \"$context.error.responseType\",\n \"stage\": \"$context.stage\",\n
//  \"resourcePath\": \"$context.resourcePath\",\n \"stageVariables.a\": \"$stageVariables.a\",\n
//  \"statusCode\": \"'404'\"\n}" }, "responseType": "MISSING_AUTHENTICATION_TOKEN",
//  "statusCode": "404" }
//
// Customize Gateway Responses (https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html)
type UpdateGatewayResponseOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean flag to indicate whether this GatewayResponse is the default gateway
	// response (true) or not (false). A default gateway response is one generated
	// by API Gateway without any customization by an API developer.
	DefaultResponse *bool `locationName:"defaultResponse" type:"boolean"`

	// Response parameters (paths, query strings and headers) of the GatewayResponse
	// as a string-to-string map of key-value pairs.
	ResponseParameters map[string]*string `locationName:"responseParameters" type:"map"`

	// Response templates of the GatewayResponse as a string-to-string map of key-value
	// pairs.
	ResponseTemplates map[string]*string `locationName:"responseTemplates" type:"map"`

	// The response type of the associated GatewayResponse.
	ResponseType *string `locationName:"responseType" type:"string" enum:"GatewayResponseType"`

	// The HTTP status code for this GatewayResponse.
	StatusCode *string `locationName:"statusCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayResponseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateGatewayResponseOutput) GoString() string {
	return s.String()
}

// SetDefaultResponse sets the DefaultResponse field's value.
func (s *UpdateGatewayResponseOutput) SetDefaultResponse(v bool) *UpdateGatewayResponseOutput {
	s.DefaultResponse = &v
	return s
}

// SetResponseParameters sets the ResponseParameters field's value.
func (s *UpdateGatewayResponseOutput) SetResponseParameters(v map[string]*string) *UpdateGatewayResponseOutput {
	s.ResponseParameters = v
	return s
}

// SetResponseTemplates sets the ResponseTemplates field's value.
func (s *UpdateGatewayResponseOutput) SetResponseTemplates(v map[string]*string) *UpdateGatewayResponseOutput {
	s.ResponseTemplates = v
	return s
}

// SetResponseType sets the ResponseType field's value.
func (s *UpdateGatewayResponseOutput) SetResponseType(v string) *UpdateGatewayResponseOutput {
	s.ResponseType = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *UpdateGatewayResponseOutput) SetStatusCode(v string) *UpdateGatewayResponseOutput {
	s.StatusCode = &v
	return s
}

// Represents an update integration request.
type UpdateIntegrationInput struct {
	_ struct{} `type:"structure"`

	// [Required] Represents an update integration request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] Represents an update integration request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIntegrationInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateIntegrationInput) SetHttpMethod(v string) *UpdateIntegrationInput {
	s.HttpMethod = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateIntegrationInput) SetPatchOperations(v []*PatchOperation) *UpdateIntegrationInput {
	s.PatchOperations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateIntegrationInput) SetResourceId(v string) *UpdateIntegrationInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateIntegrationInput) SetRestApiId(v string) *UpdateIntegrationInput {
	s.RestApiId = &v
	return s
}

// Represents an update integration response request.
type UpdateIntegrationResponseInput struct {
	_ struct{} `type:"structure"`

	// [Required] Specifies an update integration response request's HTTP method.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] Specifies an update integration response request's resource identifier.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] Specifies an update integration response request's status code.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateIntegrationResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIntegrationResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIntegrationResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateIntegrationResponseInput) SetHttpMethod(v string) *UpdateIntegrationResponseInput {
	s.HttpMethod = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateIntegrationResponseInput) SetPatchOperations(v []*PatchOperation) *UpdateIntegrationResponseInput {
	s.PatchOperations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateIntegrationResponseInput) SetResourceId(v string) *UpdateIntegrationResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateIntegrationResponseInput) SetRestApiId(v string) *UpdateIntegrationResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *UpdateIntegrationResponseInput) SetStatusCode(v string) *UpdateIntegrationResponseInput {
	s.StatusCode = &v
	return s
}

// Request to update an existing Method resource.
type UpdateMethodInput struct {
	_ struct{} `type:"structure"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The Resource identifier for the Method resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMethodInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMethodInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMethodInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMethodInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateMethodInput) SetHttpMethod(v string) *UpdateMethodInput {
	s.HttpMethod = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateMethodInput) SetPatchOperations(v []*PatchOperation) *UpdateMethodInput {
	s.PatchOperations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateMethodInput) SetResourceId(v string) *UpdateMethodInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateMethodInput) SetRestApiId(v string) *UpdateMethodInput {
	s.RestApiId = &v
	return s
}

// A request to update an existing MethodResponse resource.
type UpdateMethodResponseInput struct {
	_ struct{} `type:"structure"`

	// [Required] The HTTP verb of the Method resource.
	//
	// HttpMethod is a required field
	HttpMethod *string `location:"uri" locationName:"http_method" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The Resource identifier for the MethodResponse resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The status code for the MethodResponse resource.
	//
	// StatusCode is a required field
	StatusCode *string `location:"uri" locationName:"status_code" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMethodResponseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateMethodResponseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateMethodResponseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateMethodResponseInput"}
	if s.HttpMethod == nil {
		invalidParams.Add(request.NewErrParamRequired("HttpMethod"))
	}
	if s.HttpMethod != nil && len(*s.HttpMethod) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HttpMethod", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StatusCode == nil {
		invalidParams.Add(request.NewErrParamRequired("StatusCode"))
	}
	if s.StatusCode != nil && len(*s.StatusCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StatusCode", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHttpMethod sets the HttpMethod field's value.
func (s *UpdateMethodResponseInput) SetHttpMethod(v string) *UpdateMethodResponseInput {
	s.HttpMethod = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateMethodResponseInput) SetPatchOperations(v []*PatchOperation) *UpdateMethodResponseInput {
	s.PatchOperations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateMethodResponseInput) SetResourceId(v string) *UpdateMethodResponseInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateMethodResponseInput) SetRestApiId(v string) *UpdateMethodResponseInput {
	s.RestApiId = &v
	return s
}

// SetStatusCode sets the StatusCode field's value.
func (s *UpdateMethodResponseInput) SetStatusCode(v string) *UpdateMethodResponseInput {
	s.StatusCode = &v
	return s
}

// Request to update an existing model in an existing RestApi resource.
type UpdateModelInput struct {
	_ struct{} `type:"structure"`

	// [Required] The name of the model to update.
	//
	// ModelName is a required field
	ModelName *string `location:"uri" locationName:"model_name" type:"string" required:"true"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateModelInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateModelInput"}
	if s.ModelName == nil {
		invalidParams.Add(request.NewErrParamRequired("ModelName"))
	}
	if s.ModelName != nil && len(*s.ModelName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ModelName", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetModelName sets the ModelName field's value.
func (s *UpdateModelInput) SetModelName(v string) *UpdateModelInput {
	s.ModelName = &v
	return s
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateModelInput) SetPatchOperations(v []*PatchOperation) *UpdateModelInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateModelInput) SetRestApiId(v string) *UpdateModelInput {
	s.RestApiId = &v
	return s
}

// Updates a RequestValidator of a given RestApi.
type UpdateRequestValidatorInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The identifier of RequestValidator to be updated.
	//
	// RequestValidatorId is a required field
	RequestValidatorId *string `location:"uri" locationName:"requestvalidator_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequestValidatorInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequestValidatorInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRequestValidatorInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRequestValidatorInput"}
	if s.RequestValidatorId == nil {
		invalidParams.Add(request.NewErrParamRequired("RequestValidatorId"))
	}
	if s.RequestValidatorId != nil && len(*s.RequestValidatorId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RequestValidatorId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateRequestValidatorInput) SetPatchOperations(v []*PatchOperation) *UpdateRequestValidatorInput {
	s.PatchOperations = v
	return s
}

// SetRequestValidatorId sets the RequestValidatorId field's value.
func (s *UpdateRequestValidatorInput) SetRequestValidatorId(v string) *UpdateRequestValidatorInput {
	s.RequestValidatorId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateRequestValidatorInput) SetRestApiId(v string) *UpdateRequestValidatorInput {
	s.RestApiId = &v
	return s
}

// A set of validation rules for incoming Method requests.
//
// In OpenAPI, a RequestValidator of an API is defined by the x-amazon-apigateway-request-validators.requestValidator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validators.requestValidator.html)
// object. It the referenced using the x-amazon-apigateway-request-validator
// (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-swagger-extensions.html#api-gateway-swagger-extensions-request-validator)
// property.
//
// Enable Basic Request Validation in API Gateway (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-method-request-validation.html)
type UpdateRequestValidatorOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of this RequestValidator.
	Id *string `locationName:"id" type:"string"`

	// The name of this RequestValidator
	Name *string `locationName:"name" type:"string"`

	// A Boolean flag to indicate whether to validate a request body according to
	// the configured Model schema.
	ValidateRequestBody *bool `locationName:"validateRequestBody" type:"boolean"`

	// A Boolean flag to indicate whether to validate request parameters (true)
	// or not (false).
	ValidateRequestParameters *bool `locationName:"validateRequestParameters" type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequestValidatorOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRequestValidatorOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateRequestValidatorOutput) SetId(v string) *UpdateRequestValidatorOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateRequestValidatorOutput) SetName(v string) *UpdateRequestValidatorOutput {
	s.Name = &v
	return s
}

// SetValidateRequestBody sets the ValidateRequestBody field's value.
func (s *UpdateRequestValidatorOutput) SetValidateRequestBody(v bool) *UpdateRequestValidatorOutput {
	s.ValidateRequestBody = &v
	return s
}

// SetValidateRequestParameters sets the ValidateRequestParameters field's value.
func (s *UpdateRequestValidatorOutput) SetValidateRequestParameters(v bool) *UpdateRequestValidatorOutput {
	s.ValidateRequestParameters = &v
	return s
}

// Request to change information about a Resource resource.
type UpdateResourceInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The identifier of the Resource resource.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"resource_id" type:"string" required:"true"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateResourceInput) SetPatchOperations(v []*PatchOperation) *UpdateResourceInput {
	s.PatchOperations = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateResourceInput) SetResourceId(v string) *UpdateResourceInput {
	s.ResourceId = &v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateResourceInput) SetRestApiId(v string) *UpdateResourceInput {
	s.RestApiId = &v
	return s
}

// Request to update an existing RestApi resource in your collection.
type UpdateRestApiInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRestApiInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRestApiInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRestApiInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRestApiInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateRestApiInput) SetPatchOperations(v []*PatchOperation) *UpdateRestApiInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateRestApiInput) SetRestApiId(v string) *UpdateRestApiInput {
	s.RestApiId = &v
	return s
}

// Requests API Gateway to change information about a Stage resource.
type UpdateStageInput struct {
	_ struct{} `type:"structure"`

	// A list of update operations to be applied to the specified resource and in
	// the order specified in this list.
	PatchOperations []*PatchOperation `locationName:"patchOperations" type:"list"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the Stage resource to change information about.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateStageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateStageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateStageInput"}
	if s.RestApiId == nil {
		invalidParams.Add(request.NewErrParamRequired("RestApiId"))
	}
	if s.RestApiId != nil && len(*s.RestApiId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RestApiId", 1))
	}
	if s.StageName == nil {
		invalidParams.Add(request.NewErrParamRequired("StageName"))
	}
	if s.StageName != nil && len(*s.StageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StageName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPatchOperations sets the PatchOperations field's value.
func (s *UpdateStageInput) SetPatchOperations(v []*PatchOperation) *UpdateStageInput {
	s.PatchOperations = v
	return s
}

// SetRestApiId sets the RestApiId field's value.
func (s *UpdateStageInput) SetRestApiId(v string) *UpdateStageInput {
	s.RestApiId = &v
	return s
}

// SetStageName sets the StageName field's value.
func (s *UpdateStageInput) SetStageName(v string) *UpdateStageInput {
	s.StageName = &v
	return s
}

// The PATCH request to grant a temporary extension to the remaining quota of
// a usage plan associated with a specified API key.
type UpdateUsageInput struct {
	_