/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.analysis.Conservation;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.GraphLine;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AppletFormatAdapter;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueProperties;
import jalview.schemes.UserColourScheme;
import jalview.util.Comparison;
import jalview.util.Format;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class AnnotationFile {
    StringBuffer text = new StringBuffer("JALVIEW_ANNOTATION\n# Created: " + new Date() + "\n\n");
    SequenceI refSeq = null;
    String refSeqId = null;

    public String printAnnotations(AlignmentAnnotation[] annotations, Vector groups, Hashtable properties) {
        return this.printAnnotations(annotations, groups, properties, null);
    }

    public String printAnnotations(AlignmentAnnotation[] annotations, Vector groups, Hashtable properties, ViewDef[] views) {
        if (annotations != null) {
            boolean oneColour = true;
            SequenceI refSeq = null;
            StringBuffer colours = new StringBuffer();
            StringBuffer graphLine = new StringBuffer();
            Hashtable<String, String> graphGroup = new Hashtable<String, String>();
            for (int i = 0; i < annotations.length; ++i) {
                AlignmentAnnotation row = annotations[i];
                if (!row.visible && !row.hasScore()) continue;
                Color color = null;
                oneColour = true;
                if (row.sequenceRef == null) {
                    if (refSeq != null) {
                        this.text.append("\nSEQUENCE_REF\tALIGNMENT\n");
                    }
                    refSeq = null;
                } else if (refSeq == null || refSeq != row.sequenceRef) {
                    refSeq = row.sequenceRef;
                    this.text.append("\nSEQUENCE_REF\t" + refSeq.getName() + "\n");
                }
                if (row.graph == 0) {
                    this.text.append("NO_GRAPH\t");
                } else {
                    if (row.graph == 1) {
                        this.text.append("BAR_GRAPH\t");
                    } else if (row.graph == 2) {
                        this.text.append("LINE_GRAPH\t");
                    }
                    if (row.getThreshold() != null) {
                        graphLine.append("GRAPHLINE\t" + row.label + "\t" + row.getThreshold().value + "\t" + row.getThreshold().label + "\t" + Format.getHexString(row.getThreshold().colour) + "\n");
                    }
                    if (row.graphGroup > -1) {
                        String key = String.valueOf(row.graphGroup);
                        if (graphGroup.containsKey(key)) {
                            graphGroup.put(key, graphGroup.get(key) + "\t" + row.label);
                        } else {
                            graphGroup.put(key, row.label);
                        }
                    }
                }
                this.text.append(row.label + "\t");
                if (row.description != null) {
                    this.text.append(row.description + "\t");
                }
                for (int j = 0; row.annotations != null && j < row.annotations.length; ++j) {
                    if (refSeq != null && Comparison.isGap(refSeq.getCharAt(j))) continue;
                    if (row.annotations[j] != null) {
                        String comma = "";
                        if (row.annotations[j].secondaryStructure != ' ') {
                            this.text.append(comma + row.annotations[j].secondaryStructure);
                            comma = ",";
                        }
                        if (row.annotations[j].displayCharacter != null && row.annotations[j].displayCharacter.length() > 0 && !row.annotations[j].displayCharacter.equals(" ")) {
                            this.text.append(comma + row.annotations[j].displayCharacter);
                            comma = ",";
                        }
                        if (row.annotations[j] != null) {
                            if (color != null && !color.equals(row.annotations[j].colour)) {
                                oneColour = false;
                            }
                            color = row.annotations[j].colour;
                            if (row.annotations[j].value != 0.0f && row.annotations[j].value != Float.NaN) {
                                this.text.append(comma + row.annotations[j].value);
                            }
                        }
                        if (row.annotations[j].colour != null && row.annotations[j].colour != Color.black) {
                            this.text.append(comma + "[" + Format.getHexString(row.annotations[j].colour) + "]");
                        }
                    }
                    this.text.append("|");
                }
                if (row.hasScore()) {
                    this.text.append("\t" + row.score);
                }
                this.text.append("\n");
                if (color == null || color == Color.black || !oneColour) continue;
                colours.append("COLOUR\t" + row.label + "\t" + Format.getHexString(color) + "\n");
            }
            this.text.append("\n");
            this.text.append(colours.toString());
            this.text.append(graphLine.toString());
            if (graphGroup.size() > 0) {
                this.text.append("COMBINE\t");
                Enumeration en = graphGroup.elements();
                while (en.hasMoreElements()) {
                    this.text.append(en.nextElement() + "\n");
                }
            }
        }
        if (groups != null) {
            this.printGroups(groups);
        }
        if (properties != null) {
            this.text.append("\n\nALIGNMENT");
            Enumeration en = properties.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement().toString();
                this.text.append("\t" + key + "=" + properties.get(key));
            }
        }
        return this.text.toString();
    }

    public void printGroups(Vector sequenceGroups) {
        for (int i = 0; i < sequenceGroups.size(); ++i) {
            SequenceGroup sg = (SequenceGroup)sequenceGroups.elementAt(i);
            this.text.append("SEQUENCE_GROUP\t" + sg.getName() + "\t" + (sg.getStartRes() + 1) + "\t" + (sg.getEndRes() + 1) + "\t" + "-1\t");
            for (int s = 0; s < sg.getSize(); ++s) {
                this.text.append(sg.getSequenceAt(s).getName() + "\t");
            }
            this.text.append("\nPROPERTIES\t" + sg.getName() + "\t");
            if (sg.getDescription() != null) {
                this.text.append("description=" + sg.getDescription() + "\t");
            }
            if (sg.cs != null) {
                this.text.append("colour=" + ColourSchemeProperty.getColourName(sg.cs) + "\t");
                if (sg.cs.getThreshold() != 0) {
                    this.text.append("pidThreshold=" + sg.cs.getThreshold());
                }
                if (sg.cs.conservationApplied()) {
                    this.text.append("consThreshold=" + sg.cs.getConservationInc() + "\t");
                }
            }
            this.text.append("outlineColour=" + Format.getHexString(sg.getOutlineColour()) + "\t");
            this.text.append("displayBoxes=" + sg.getDisplayBoxes() + "\t");
            this.text.append("displayText=" + sg.getDisplayText() + "\t");
            this.text.append("colourText=" + sg.getColourText() + "\t");
            if (sg.textColour != Color.black) {
                this.text.append("textCol1=" + Format.getHexString(sg.textColour) + "\t");
            }
            if (sg.textColour2 != Color.white) {
                this.text.append("textCol2=" + Format.getHexString(sg.textColour2) + "\t");
            }
            if (sg.thresholdTextColour != 0) {
                this.text.append("textColThreshold=" + sg.thresholdTextColour);
            }
            if (sg.idColour != null) {
                this.text.append("idColour=" + Format.getHexString(sg.idColour) + "\t");
            }
            this.text.append("\n\n");
        }
    }

    public boolean readAnnotationFile(AlignmentI al, String file, String protocol) {
        try {
            String line;
            InputStream is;
            BufferedReader in = null;
            if (protocol.equals(AppletFormatAdapter.FILE)) {
                in = new BufferedReader(new FileReader(file));
            } else if (protocol.equals(AppletFormatAdapter.URL)) {
                URL url = new URL(file);
                in = new BufferedReader(new InputStreamReader(url.openStream()));
            } else if (protocol.equals(AppletFormatAdapter.PASTE)) {
                in = new BufferedReader(new StringReader(file));
            } else if (protocol.equals(AppletFormatAdapter.CLASSLOADER) && (is = this.getClass().getResourceAsStream("/" + file)) != null) {
                in = new BufferedReader(new InputStreamReader(is));
            }
            int refSeqIndex = 1;
            int existingAnnotations = 0;
            if (al.getAlignmentAnnotation() != null) {
                existingAnnotations = al.getAlignmentAnnotation().length;
            }
            int alWidth = al.getWidth();
            AlignmentAnnotation annotation = null;
            boolean jvAnnotationFile = false;
            while ((line = in.readLine()) != null) {
                if (line.indexOf("#") == 0 || line.indexOf("JALVIEW_ANNOTATION") <= -1) continue;
                jvAnnotationFile = true;
                break;
            }
            if (!jvAnnotationFile) {
                in.close();
                return false;
            }
            while ((line = in.readLine()) != null) {
                if (line.indexOf("#") == 0 || line.indexOf("JALVIEW_ANNOTATION") > -1 || line.length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, "\t");
                String token = st.nextToken();
                if (token.equalsIgnoreCase("COLOUR")) {
                    this.colourAnnotations(al, st.nextToken(), st.nextToken());
                    continue;
                }
                if (token.equalsIgnoreCase("COMBINE")) {
                    this.combineAnnotations(al, st);
                    continue;
                }
                if (token.equalsIgnoreCase("GRAPHLINE")) {
                    this.addLine(al, st);
                    continue;
                }
                if (token.equalsIgnoreCase("SEQUENCE_REF")) {
                    if (st.hasMoreTokens()) {
                        this.refSeqId = st.nextToken();
                        this.refSeq = al.findName(this.refSeqId);
                        if (this.refSeq == null) {
                            this.refSeqId = null;
                        }
                        try {
                            refSeqIndex = Integer.parseInt(st.nextToken());
                            if (refSeqIndex >= 1) continue;
                            refSeqIndex = 1;
                            System.out.println("WARNING: SEQUENCE_REF index must be > 0 in AnnotationFile");
                        }
                        catch (Exception ex) {
                            refSeqIndex = 1;
                        }
                        continue;
                    }
                    this.refSeq = null;
                    this.refSeqId = null;
                    continue;
                }
                if (token.equalsIgnoreCase("SEQUENCE_GROUP")) {
                    this.addGroup(al, st);
                    continue;
                }
                if (token.equalsIgnoreCase("PROPERTIES")) {
                    this.addProperties(al, st);
                    continue;
                }
                if (token.equalsIgnoreCase("BELOW_ALIGNMENT")) {
                    this.setBelowAlignment(al, st);
                    continue;
                }
                if (token.equalsIgnoreCase("ALIGNMENT")) {
                    this.addAlignmentDetails(al, st);
                    continue;
                }
                int graphStyle = AlignmentAnnotation.getGraphValueFromString(token);
                String label = st.nextToken();
                int index = 0;
                Annotation[] annotations = new Annotation[alWidth];
                String description = null;
                float score = Float.NaN;
                if (st.hasMoreTokens()) {
                    boolean onlyOneElement;
                    line = st.nextToken();
                    if (line.indexOf("|") == -1) {
                        description = line;
                        if (st.hasMoreTokens()) {
                            line = st.nextToken();
                        }
                    }
                    if (st.hasMoreTokens()) {
                        score = Float.valueOf(st.nextToken()).floatValue();
                    }
                    st = new StringTokenizer(line, "|", true);
                    boolean emptyColumn = true;
                    boolean bl = onlyOneElement = st.countTokens() == 1;
                    while (st.hasMoreElements() && index < alWidth) {
                        token = st.nextToken().trim();
                        if (onlyOneElement) {
                            try {
                                score = Float.valueOf(token).floatValue();
                                break;
                            }
                            catch (NumberFormatException ex) {
                                // empty catch block
                            }
                        }
                        if (token.equals("|")) {
                            if (emptyColumn) {
                                ++index;
                            }
                            emptyColumn = true;
                            continue;
                        }
                        annotations[index++] = this.parseAnnotation(token);
                        emptyColumn = false;
                    }
                }
                annotation = new AlignmentAnnotation(label, description, index == 0 ? null : annotations, 0.0f, 0.0f, graphStyle);
                annotation.score = score;
                if (this.refSeq != null) {
                    annotation.belowAlignment = false;
                    SequenceI referedSeq = this.refSeq;
                    do {
                        AlignmentAnnotation ann = new AlignmentAnnotation(annotation);
                        annotation.createSequenceMapping(referedSeq, refSeqIndex, false);
                        annotation.adjustForAlignment();
                        referedSeq.addAlignmentAnnotation(annotation);
                        al.addAnnotation(annotation);
                        al.setAnnotationIndex(annotation, al.getAlignmentAnnotation().length - existingAnnotations - 1);
                        annotation = ann;
                    } while (this.refSeqId != null && (referedSeq = al.findName(referedSeq, this.refSeqId, true)) != null);
                    continue;
                }
                al.addAnnotation(annotation);
                al.setAnnotationIndex(annotation, al.getAlignmentAnnotation().length - existingAnnotations - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("Problem reading annotation file: " + ex);
            return false;
        }
        return true;
    }

    Annotation parseAnnotation(String string) {
        String desc = null;
        String displayChar = null;
        char ss = ' ';
        float value = 0.0f;
        boolean parsedValue = false;
        Color colour = null;
        int i = string.indexOf("[");
        int j = string.indexOf("]");
        if (i > -1 && j > -1) {
            UserColourScheme ucs = new UserColourScheme();
            colour = ucs.getColourFromString(string.substring(i + 1, j));
            string = string.substring(0, i) + string.substring(j + 1);
        }
        StringTokenizer st = new StringTokenizer(string, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (token.length() == 0) continue;
            if (!parsedValue) {
                try {
                    displayChar = token;
                    value = new Float(token).floatValue();
                    parsedValue = true;
                    continue;
                }
                catch (NumberFormatException ex) {
                    // empty catch block
                }
            }
            if (token.equals("H") || token.equals("E")) {
                ss = token.charAt(0);
                if (!displayChar.equals(token.substring(0, 1))) continue;
                displayChar = "";
                continue;
            }
            if (desc != null) continue;
            desc = token;
        }
        if (displayChar != null && displayChar.length() > 1 && desc != null && desc.length() == 1) {
            String tmp = displayChar;
            displayChar = desc;
            desc = tmp;
        }
        Annotation anot = new Annotation(displayChar, desc, ss, value);
        anot.colour = colour;
        return anot;
    }

    void colourAnnotations(AlignmentI al, String label, String colour) {
        UserColourScheme ucs = new UserColourScheme(colour);
        for (int i = 0; i < al.getAlignmentAnnotation().length; ++i) {
            if (!al.getAlignmentAnnotation()[i].label.equalsIgnoreCase(label)) continue;
            Annotation[] annotations = al.getAlignmentAnnotation()[i].annotations;
            for (int j = 0; j < annotations.length; ++j) {
                if (annotations[j] == null) continue;
                annotations[j].colour = ucs.findColour('A');
            }
        }
    }

    void combineAnnotations(AlignmentI al, StringTokenizer st) {
        int i;
        int graphGroup = -1;
        String group = st.nextToken();
        for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
            if (!al.getAlignmentAnnotation()[i].label.equalsIgnoreCase(group)) continue;
            al.getAlignmentAnnotation()[i].graphGroup = graphGroup = al.getAlignmentAnnotation()[i].graphGroup + 1;
            break;
        }
        block1: while (st.hasMoreTokens()) {
            group = st.nextToken();
            for (i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                if (!al.getAlignmentAnnotation()[i].label.equalsIgnoreCase(group)) continue;
                al.getAlignmentAnnotation()[i].graphGroup = graphGroup;
                continue block1;
            }
        }
    }

    void addLine(AlignmentI al, StringTokenizer st) {
        String group = st.nextToken();
        AlignmentAnnotation annotation = null;
        for (int i = 0; i < al.getAlignmentAnnotation().length; ++i) {
            if (!al.getAlignmentAnnotation()[i].label.equalsIgnoreCase(group)) continue;
            annotation = al.getAlignmentAnnotation()[i];
            break;
        }
        if (annotation == null) {
            return;
        }
        float value = new Float(st.nextToken()).floatValue();
        String label = st.hasMoreTokens() ? st.nextToken() : null;
        Color colour = null;
        if (st.hasMoreTokens()) {
            UserColourScheme ucs = new UserColourScheme(st.nextToken());
            colour = ucs.findColour('A');
        }
        annotation.setThreshold(new GraphLine(value, label, colour));
    }

    void addGroup(AlignmentI al, StringTokenizer st) {
        SequenceGroup sg = new SequenceGroup();
        sg.setName(st.nextToken());
        sg.setStartRes(Integer.parseInt(st.nextToken()) - 1);
        sg.setEndRes(Integer.parseInt(st.nextToken()) - 1);
        String index = st.nextToken();
        if (index.equals("-1")) {
            while (st.hasMoreElements()) {
                sg.addSequence(al.findName(st.nextToken()), false);
            }
        } else {
            StringTokenizer st2 = new StringTokenizer(index, ",");
            while (st2.hasMoreTokens()) {
                String tmp = st2.nextToken();
                if (tmp.equals("*")) {
                    for (int i = 0; i < al.getHeight(); ++i) {
                        sg.addSequence(al.getSequenceAt(i), false);
                    }
                    continue;
                }
                if (tmp.indexOf("-") >= 0) {
                    StringTokenizer st3 = new StringTokenizer(tmp, "-");
                    int start = Integer.parseInt(st3.nextToken());
                    int end = Integer.parseInt(st3.nextToken());
                    if (end <= start) continue;
                    for (int i = start; i <= end; ++i) {
                        sg.addSequence(al.getSequenceAt(i - 1), false);
                    }
                    continue;
                }
                sg.addSequence(al.getSequenceAt(Integer.parseInt(tmp) - 1), false);
            }
        }
        if (this.refSeq != null) {
            sg.setStartRes(this.refSeq.findIndex(sg.getStartRes() + 1) - 1);
            sg.setEndRes(this.refSeq.findIndex(sg.getEndRes() + 1) - 1);
        }
        if (sg.getSize() > 0) {
            al.addGroup(sg);
        }
    }

    void addProperties(AlignmentI al, StringTokenizer st) {
        if (al.getGroups() == null) {
            return;
        }
        SequenceGroup sg = null;
        String name = st.nextToken();
        Vector groups = al.getGroups();
        for (int i = 0; i < groups.size() && !(sg = (SequenceGroup)groups.elementAt(i)).getName().equals(name); ++i) {
            sg = null;
        }
        if (sg != null) {
            ColourSchemeI def = sg.cs;
            sg.cs = null;
            while (st.hasMoreTokens()) {
                String keyValue = st.nextToken();
                String key = keyValue.substring(0, keyValue.indexOf("="));
                String value = keyValue.substring(keyValue.indexOf("=") + 1);
                if (key.equalsIgnoreCase("description")) {
                    sg.setDescription(value);
                } else if (key.equalsIgnoreCase("colour")) {
                    sg.cs = ColourSchemeProperty.getColour(al, value);
                } else if (key.equalsIgnoreCase("pidThreshold")) {
                    sg.cs.setThreshold(Integer.parseInt(value), true);
                } else if (key.equalsIgnoreCase("consThreshold")) {
                    sg.cs.setConservationInc(Integer.parseInt(value));
                    Conservation c = new Conservation("Group", ResidueProperties.propHash, 3, sg.getSequences(null), sg.getStartRes(), sg.getEndRes() + 1);
                    c.calculate();
                    c.verdict(false, 25.0f);
                    sg.cs.setConservation(c);
                } else if (key.equalsIgnoreCase("outlineColour")) {
                    sg.setOutlineColour(new UserColourScheme(value).findColour('A'));
                } else if (key.equalsIgnoreCase("displayBoxes")) {
                    sg.setDisplayBoxes(Boolean.valueOf(value));
                } else if (key.equalsIgnoreCase("displayText")) {
                    sg.setDisplayText(Boolean.valueOf(value));
                } else if (key.equalsIgnoreCase("colourText")) {
                    sg.setColourText(Boolean.valueOf(value));
                } else if (key.equalsIgnoreCase("textCol1")) {
                    sg.textColour = new UserColourScheme(value).findColour('A');
                } else if (key.equalsIgnoreCase("textCol2")) {
                    sg.textColour2 = new UserColourScheme(value).findColour('A');
                } else if (key.equalsIgnoreCase("textColThreshold")) {
                    sg.thresholdTextColour = Integer.parseInt(value);
                } else if (key.equalsIgnoreCase("idColour")) {
                    def = new UserColourScheme(value);
                    sg.setIdColour(def.findColour('A'));
                }
                sg.recalcConservation();
            }
            if (sg.cs == null) {
                sg.cs = def;
            }
        }
    }

    void setBelowAlignment(AlignmentI al, StringTokenizer st) {
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            for (int i = 0; i < al.getAlignmentAnnotation().length; ++i) {
                AlignmentAnnotation aa = al.getAlignmentAnnotation()[i];
                if (aa.sequenceRef != this.refSeq || !aa.label.equals(token)) continue;
                aa.belowAlignment = true;
            }
        }
    }

    void addAlignmentDetails(AlignmentI al, StringTokenizer st) {
        while (st.hasMoreTokens()) {
            String keyValue = st.nextToken();
            String key = keyValue.substring(0, keyValue.indexOf("="));
            String value = keyValue.substring(keyValue.indexOf("=") + 1);
            al.setProperty(key, value);
        }
    }

    public String printCSVAnnotations(AlignmentAnnotation[] annotations) {
        StringBuffer sp = new StringBuffer();
        for (int i = 0; i < annotations.length; ++i) {
            int cp;
            String atos = annotations[i].toString();
            int p = 0;
            do {
                cp = atos.indexOf("\n", p);
                sp.append(annotations[i].label);
                sp.append(",");
                if (cp > p) {
                    sp.append(atos.substring(p, cp + 1));
                    continue;
                }
                sp.append(atos.substring(p));
                sp.append("\n");
            } while ((p = cp + 1) > 0);
        }
        return sp.toString();
    }

    public class ViewDef {
        public String viewname;
        public HiddenSequences hidseqs;
        public ColumnSelection hiddencols;
        public Vector visibleGroups;

        public ViewDef(String viewname, HiddenSequences hidseqs, ColumnSelection hiddencols) {
            this.viewname = viewname;
            this.hidseqs = hidseqs;
            this.hiddencols = hiddencols;
        }
    }
}

