
/*

    filesys.h - Header file for filesystem histogram
    Copyright (C) 2002-2004 Mario Pascucci <ilpettegolo (a) yahoo it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    or
    visit the URL http://www.fsf.org/


*/

/* prevent multiple inclusion */
#ifndef _MP_FILESYS


#ifdef __cplusplus
extern "C" {
#endif


/* define header ID */
#define _MP_FILESYS

/* for PATH_MAX */
#ifndef _LIMITS_H
  #include <limits.h>
#endif

/* header definitions starts here */

struct fsys_monitor
{
  int handler;			/* graphic area handler */
  int enable;			/* enabled flag */
  int update_dly;		/* update delay in 2/10 sec */
  char fsys1[PATH_MAX],fsys2[PATH_MAX],fsys3[PATH_MAX]; /* path to filesys */
  int fsflag1,fsflag2,fsflag3,fstotals;		/* filesys to check */
  int perc1,perc2,perc3;	/* free low limit % */
  unsigned long fstotal1,fstotal2,fstotal3;	/* size of fs */
  unsigned long fsfree1,fsfree2,fsfree3;	/* free fs */
  char used_color[30];			/* used fs color */
  char crit_color[30];			/* critical used color */
  int xf,yf,wf,hf;			/* gauge position */
  int hi,y2,y3;				/* histogram thickness and y pos */
};
  


/* reads filesys status */
void filesys_update(struct fsys_monitor *fmon);

/* set size for histogram */
int filesys_size(struct fsys_monitor *fmon);

/* set paths and percent */
int filesys_setpath(struct fsys_monitor *fmon);

/* draw histogram */
void filesys_draw(struct fsys_monitor *fmon);


#ifdef __cplusplus
}
#endif

#endif /* _MP_FILESYS */


