// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: openfga/v1/openfga.proto

package openfgav1

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on Object with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Object) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Object with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in ObjectMultiError, or nil if none found.
func (m *Object) ValidateAll() error {
	return m.validate(true)
}

func (m *Object) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_Object_Type_Pattern.MatchString(m.GetType()) {
		err := ObjectValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,254}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_Object_Id_Pattern.MatchString(m.GetId()) {
		err := ObjectValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"[^#:\\\\s]+$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ObjectMultiError(errors)
	}

	return nil
}

// ObjectMultiError is an error wrapping multiple validation errors returned by
// Object.ValidateAll() if the designated constraints aren't met.
type ObjectMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ObjectMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ObjectMultiError) AllErrors() []error { return m }

// ObjectValidationError is the validation error returned by Object.Validate if
// the designated constraints aren't met.
type ObjectValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ObjectValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ObjectValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ObjectValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ObjectValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ObjectValidationError) ErrorName() string { return "ObjectValidationError" }

// Error satisfies the builtin error interface
func (e ObjectValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sObject.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ObjectValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ObjectValidationError{}

var _Object_Type_Pattern = regexp.MustCompile("^[^:#@\\s]{1,254}$")

var _Object_Id_Pattern = regexp.MustCompile("[^#:\\s]+$")

// Validate checks the field values on RelationshipCondition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *RelationshipCondition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on RelationshipCondition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// RelationshipConditionMultiError, or nil if none found.
func (m *RelationshipCondition) ValidateAll() error {
	return m.validate(true)
}

func (m *RelationshipCondition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_RelationshipCondition_Name_Pattern.MatchString(m.GetName()) {
		err := RelationshipConditionValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, RelationshipConditionValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, RelationshipConditionValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return RelationshipConditionValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return RelationshipConditionMultiError(errors)
	}

	return nil
}

// RelationshipConditionMultiError is an error wrapping multiple validation
// errors returned by RelationshipCondition.ValidateAll() if the designated
// constraints aren't met.
type RelationshipConditionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m RelationshipConditionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m RelationshipConditionMultiError) AllErrors() []error { return m }

// RelationshipConditionValidationError is the validation error returned by
// RelationshipCondition.Validate if the designated constraints aren't met.
type RelationshipConditionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e RelationshipConditionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e RelationshipConditionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e RelationshipConditionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e RelationshipConditionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e RelationshipConditionValidationError) ErrorName() string {
	return "RelationshipConditionValidationError"
}

// Error satisfies the builtin error interface
func (e RelationshipConditionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sRelationshipCondition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = RelationshipConditionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = RelationshipConditionValidationError{}

var _RelationshipCondition_Name_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on TupleKeyWithoutCondition with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *TupleKeyWithoutCondition) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleKeyWithoutCondition with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// TupleKeyWithoutConditionMultiError, or nil if none found.
func (m *TupleKeyWithoutCondition) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleKeyWithoutCondition) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetUser()) > 512 {
		err := TupleKeyWithoutConditionValidationError{
			field:  "User",
			reason: "value length must be at most 512 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRelation() != "" {

		if !_TupleKeyWithoutCondition_Relation_Pattern.MatchString(m.GetRelation()) {
			err := TupleKeyWithoutConditionValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetObject() != "" {

		if !_TupleKeyWithoutCondition_Object_Pattern.MatchString(m.GetObject()) {
			err := TupleKeyWithoutConditionValidationError{
				field:  "Object",
				reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return TupleKeyWithoutConditionMultiError(errors)
	}

	return nil
}

// TupleKeyWithoutConditionMultiError is an error wrapping multiple validation
// errors returned by TupleKeyWithoutCondition.ValidateAll() if the designated
// constraints aren't met.
type TupleKeyWithoutConditionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleKeyWithoutConditionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleKeyWithoutConditionMultiError) AllErrors() []error { return m }

// TupleKeyWithoutConditionValidationError is the validation error returned by
// TupleKeyWithoutCondition.Validate if the designated constraints aren't met.
type TupleKeyWithoutConditionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleKeyWithoutConditionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleKeyWithoutConditionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleKeyWithoutConditionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleKeyWithoutConditionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleKeyWithoutConditionValidationError) ErrorName() string {
	return "TupleKeyWithoutConditionValidationError"
}

// Error satisfies the builtin error interface
func (e TupleKeyWithoutConditionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleKeyWithoutCondition.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleKeyWithoutConditionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleKeyWithoutConditionValidationError{}

var _TupleKeyWithoutCondition_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _TupleKeyWithoutCondition_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on TupleKey with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleKey with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleKeyMultiError, or nil
// if none found.
func (m *TupleKey) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetUser()) > 512 {
		err := TupleKeyValidationError{
			field:  "User",
			reason: "value length must be at most 512 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRelation() != "" {

		if !_TupleKey_Relation_Pattern.MatchString(m.GetRelation()) {
			err := TupleKeyValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetObject() != "" {

		if !_TupleKey_Object_Pattern.MatchString(m.GetObject()) {
			err := TupleKeyValidationError{
				field:  "Object",
				reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if all {
		switch v := interface{}(m.GetCondition()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleKeyValidationError{
					field:  "Condition",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleKeyValidationError{
					field:  "Condition",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCondition()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleKeyValidationError{
				field:  "Condition",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleKeyMultiError(errors)
	}

	return nil
}

// TupleKeyMultiError is an error wrapping multiple validation errors returned
// by TupleKey.ValidateAll() if the designated constraints aren't met.
type TupleKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleKeyMultiError) AllErrors() []error { return m }

// TupleKeyValidationError is the validation error returned by
// TupleKey.Validate if the designated constraints aren't met.
type TupleKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleKeyValidationError) ErrorName() string { return "TupleKeyValidationError" }

// Error satisfies the builtin error interface
func (e TupleKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleKeyValidationError{}

var _TupleKey_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _TupleKey_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on Tuple with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Tuple) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Tuple with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in TupleMultiError, or nil if none found.
func (m *Tuple) ValidateAll() error {
	return m.validate(true)
}

func (m *Tuple) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetKey() == nil {
		err := TupleValidationError{
			field:  "Key",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Key",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Key",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleValidationError{
				field:  "Key",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetTimestamp()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Timestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleValidationError{
					field:  "Timestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimestamp()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleValidationError{
				field:  "Timestamp",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleMultiError(errors)
	}

	return nil
}

// TupleMultiError is an error wrapping multiple validation errors returned by
// Tuple.ValidateAll() if the designated constraints aren't met.
type TupleMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleMultiError) AllErrors() []error { return m }

// TupleValidationError is the validation error returned by Tuple.Validate if
// the designated constraints aren't met.
type TupleValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleValidationError) ErrorName() string { return "TupleValidationError" }

// Error satisfies the builtin error interface
func (e TupleValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTuple.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleValidationError{}

// Validate checks the field values on TupleKeys with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleKeys) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleKeys with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleKeysMultiError, or nil
// if none found.
func (m *TupleKeys) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleKeys) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTupleKeys()) < 1 {
		err := TupleKeysValidationError{
			field:  "TupleKeys",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTupleKeys() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, TupleKeysValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, TupleKeysValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return TupleKeysValidationError{
					field:  fmt.Sprintf("TupleKeys[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return TupleKeysMultiError(errors)
	}

	return nil
}

// TupleKeysMultiError is an error wrapping multiple validation errors returned
// by TupleKeys.ValidateAll() if the designated constraints aren't met.
type TupleKeysMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleKeysMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleKeysMultiError) AllErrors() []error { return m }

// TupleKeysValidationError is the validation error returned by
// TupleKeys.Validate if the designated constraints aren't met.
type TupleKeysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleKeysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleKeysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleKeysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleKeysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleKeysValidationError) ErrorName() string { return "TupleKeysValidationError" }

// Error satisfies the builtin error interface
func (e TupleKeysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleKeys.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleKeysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleKeysValidationError{}

// Validate checks the field values on ContextualTupleKeys with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ContextualTupleKeys) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ContextualTupleKeys with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ContextualTupleKeysMultiError, or nil if none found.
func (m *ContextualTupleKeys) ValidateAll() error {
	return m.validate(true)
}

func (m *ContextualTupleKeys) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTupleKeys()) > 20 {
		err := ContextualTupleKeysValidationError{
			field:  "TupleKeys",
			reason: "value must contain no more than 20 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTupleKeys() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ContextualTupleKeysValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ContextualTupleKeysValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ContextualTupleKeysValidationError{
					field:  fmt.Sprintf("TupleKeys[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ContextualTupleKeysMultiError(errors)
	}

	return nil
}

// ContextualTupleKeysMultiError is an error wrapping multiple validation
// errors returned by ContextualTupleKeys.ValidateAll() if the designated
// constraints aren't met.
type ContextualTupleKeysMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ContextualTupleKeysMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ContextualTupleKeysMultiError) AllErrors() []error { return m }

// ContextualTupleKeysValidationError is the validation error returned by
// ContextualTupleKeys.Validate if the designated constraints aren't met.
type ContextualTupleKeysValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ContextualTupleKeysValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ContextualTupleKeysValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ContextualTupleKeysValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ContextualTupleKeysValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ContextualTupleKeysValidationError) ErrorName() string {
	return "ContextualTupleKeysValidationError"
}

// Error satisfies the builtin error interface
func (e ContextualTupleKeysValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sContextualTupleKeys.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ContextualTupleKeysValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ContextualTupleKeysValidationError{}

// Validate checks the field values on UsersetTree with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *UsersetTree) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in UsersetTreeMultiError, or
// nil if none found.
func (m *UsersetTree) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetRoot()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UsersetTreeValidationError{
					field:  "Root",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UsersetTreeValidationError{
					field:  "Root",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetRoot()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UsersetTreeValidationError{
				field:  "Root",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UsersetTreeMultiError(errors)
	}

	return nil
}

// UsersetTreeMultiError is an error wrapping multiple validation errors
// returned by UsersetTree.ValidateAll() if the designated constraints aren't met.
type UsersetTreeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTreeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTreeMultiError) AllErrors() []error { return m }

// UsersetTreeValidationError is the validation error returned by
// UsersetTree.Validate if the designated constraints aren't met.
type UsersetTreeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTreeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTreeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTreeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTreeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTreeValidationError) ErrorName() string { return "UsersetTreeValidationError" }

// Error satisfies the builtin error interface
func (e UsersetTreeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTreeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTreeValidationError{}

// Validate checks the field values on TupleChange with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *TupleChange) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on TupleChange with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in TupleChangeMultiError, or
// nil if none found.
func (m *TupleChange) ValidateAll() error {
	return m.validate(true)
}

func (m *TupleChange) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetTupleKey() == nil {
		err := TupleChangeValidationError{
			field:  "TupleKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleChangeValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleChangeValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleChangeValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := TupleOperation_name[int32(m.GetOperation())]; !ok {
		err := TupleChangeValidationError{
			field:  "Operation",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTimestamp()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, TupleChangeValidationError{
					field:  "Timestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, TupleChangeValidationError{
					field:  "Timestamp",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTimestamp()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return TupleChangeValidationError{
				field:  "Timestamp",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return TupleChangeMultiError(errors)
	}

	return nil
}

// TupleChangeMultiError is an error wrapping multiple validation errors
// returned by TupleChange.ValidateAll() if the designated constraints aren't met.
type TupleChangeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m TupleChangeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m TupleChangeMultiError) AllErrors() []error { return m }

// TupleChangeValidationError is the validation error returned by
// TupleChange.Validate if the designated constraints aren't met.
type TupleChangeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e TupleChangeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e TupleChangeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e TupleChangeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e TupleChangeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e TupleChangeValidationError) ErrorName() string { return "TupleChangeValidationError" }

// Error satisfies the builtin error interface
func (e TupleChangeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sTupleChange.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = TupleChangeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = TupleChangeValidationError{}

// Validate checks the field values on Store with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Store) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Store with the rules defined in the
// proto definition for this message. If any rules are violated, the result is
// a list of violation errors wrapped in StoreMultiError, or nil if none found.
func (m *Store) ValidateAll() error {
	return m.validate(true)
}

func (m *Store) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetCreatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCreatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StoreValidationError{
				field:  "CreatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpdatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpdatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StoreValidationError{
				field:  "UpdatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDeletedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "DeletedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, StoreValidationError{
					field:  "DeletedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDeletedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StoreValidationError{
				field:  "DeletedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return StoreMultiError(errors)
	}

	return nil
}

// StoreMultiError is an error wrapping multiple validation errors returned by
// Store.ValidateAll() if the designated constraints aren't met.
type StoreMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StoreMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StoreMultiError) AllErrors() []error { return m }

// StoreValidationError is the validation error returned by Store.Validate if
// the designated constraints aren't met.
type StoreValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StoreValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StoreValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StoreValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StoreValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StoreValidationError) ErrorName() string { return "StoreValidationError" }

// Error satisfies the builtin error interface
func (e StoreValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStore.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StoreValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StoreValidationError{}

// Validate checks the field values on UsersetTree_Leaf with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Leaf) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Leaf with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_LeafMultiError, or nil if none found.
func (m *UsersetTree_Leaf) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Leaf) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.Value.(type) {
	case *UsersetTree_Leaf_Users:
		if v == nil {
			err := UsersetTree_LeafValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUsers()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "Users",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "Users",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUsers()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_LeafValidationError{
					field:  "Users",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UsersetTree_Leaf_Computed:
		if v == nil {
			err := UsersetTree_LeafValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetComputed()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "Computed",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "Computed",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetComputed()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_LeafValidationError{
					field:  "Computed",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UsersetTree_Leaf_TupleToUserset:
		if v == nil {
			err := UsersetTree_LeafValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetTupleToUserset()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "TupleToUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_LeafValidationError{
						field:  "TupleToUserset",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetTupleToUserset()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_LeafValidationError{
					field:  "TupleToUserset",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return UsersetTree_LeafMultiError(errors)
	}

	return nil
}

// UsersetTree_LeafMultiError is an error wrapping multiple validation errors
// returned by UsersetTree_Leaf.ValidateAll() if the designated constraints
// aren't met.
type UsersetTree_LeafMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_LeafMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_LeafMultiError) AllErrors() []error { return m }

// UsersetTree_LeafValidationError is the validation error returned by
// UsersetTree_Leaf.Validate if the designated constraints aren't met.
type UsersetTree_LeafValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_LeafValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_LeafValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_LeafValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_LeafValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_LeafValidationError) ErrorName() string { return "UsersetTree_LeafValidationError" }

// Error satisfies the builtin error interface
func (e UsersetTree_LeafValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Leaf.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_LeafValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_LeafValidationError{}

// Validate checks the field values on UsersetTree_Nodes with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Nodes) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Nodes with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_NodesMultiError, or nil if none found.
func (m *UsersetTree_Nodes) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Nodes) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetNodes() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_NodesValidationError{
						field:  fmt.Sprintf("Nodes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_NodesValidationError{
						field:  fmt.Sprintf("Nodes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_NodesValidationError{
					field:  fmt.Sprintf("Nodes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return UsersetTree_NodesMultiError(errors)
	}

	return nil
}

// UsersetTree_NodesMultiError is an error wrapping multiple validation errors
// returned by UsersetTree_Nodes.ValidateAll() if the designated constraints
// aren't met.
type UsersetTree_NodesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_NodesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_NodesMultiError) AllErrors() []error { return m }

// UsersetTree_NodesValidationError is the validation error returned by
// UsersetTree_Nodes.Validate if the designated constraints aren't met.
type UsersetTree_NodesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_NodesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_NodesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_NodesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_NodesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_NodesValidationError) ErrorName() string {
	return "UsersetTree_NodesValidationError"
}

// Error satisfies the builtin error interface
func (e UsersetTree_NodesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Nodes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_NodesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_NodesValidationError{}

// Validate checks the field values on UsersetTree_Users with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Users) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Users with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_UsersMultiError, or nil if none found.
func (m *UsersetTree_Users) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Users) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return UsersetTree_UsersMultiError(errors)
	}

	return nil
}

// UsersetTree_UsersMultiError is an error wrapping multiple validation errors
// returned by UsersetTree_Users.ValidateAll() if the designated constraints
// aren't met.
type UsersetTree_UsersMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_UsersMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_UsersMultiError) AllErrors() []error { return m }

// UsersetTree_UsersValidationError is the validation error returned by
// UsersetTree_Users.Validate if the designated constraints aren't met.
type UsersetTree_UsersValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_UsersValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_UsersValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_UsersValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_UsersValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_UsersValidationError) ErrorName() string {
	return "UsersetTree_UsersValidationError"
}

// Error satisfies the builtin error interface
func (e UsersetTree_UsersValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Users.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_UsersValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_UsersValidationError{}

// Validate checks the field values on UsersetTree_Computed with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Computed) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Computed with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_ComputedMultiError, or nil if none found.
func (m *UsersetTree_Computed) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Computed) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return UsersetTree_ComputedMultiError(errors)
	}

	return nil
}

// UsersetTree_ComputedMultiError is an error wrapping multiple validation
// errors returned by UsersetTree_Computed.ValidateAll() if the designated
// constraints aren't met.
type UsersetTree_ComputedMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_ComputedMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_ComputedMultiError) AllErrors() []error { return m }

// UsersetTree_ComputedValidationError is the validation error returned by
// UsersetTree_Computed.Validate if the designated constraints aren't met.
type UsersetTree_ComputedValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_ComputedValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_ComputedValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_ComputedValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_ComputedValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_ComputedValidationError) ErrorName() string {
	return "UsersetTree_ComputedValidationError"
}

// Error satisfies the builtin error interface
func (e UsersetTree_ComputedValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Computed.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_ComputedValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_ComputedValidationError{}

// Validate checks the field values on UsersetTree_TupleToUserset with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_TupleToUserset) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_TupleToUserset with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_TupleToUsersetMultiError, or nil if none found.
func (m *UsersetTree_TupleToUserset) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_TupleToUserset) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetComputed() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_TupleToUsersetValidationError{
						field:  fmt.Sprintf("Computed[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_TupleToUsersetValidationError{
						field:  fmt.Sprintf("Computed[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_TupleToUsersetValidationError{
					field:  fmt.Sprintf("Computed[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return UsersetTree_TupleToUsersetMultiError(errors)
	}

	return nil
}

// UsersetTree_TupleToUsersetMultiError is an error wrapping multiple
// validation errors returned by UsersetTree_TupleToUserset.ValidateAll() if
// the designated constraints aren't met.
type UsersetTree_TupleToUsersetMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_TupleToUsersetMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_TupleToUsersetMultiError) AllErrors() []error { return m }

// UsersetTree_TupleToUsersetValidationError is the validation error returned
// by UsersetTree_TupleToUserset.Validate if the designated constraints aren't met.
type UsersetTree_TupleToUsersetValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_TupleToUsersetValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_TupleToUsersetValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_TupleToUsersetValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_TupleToUsersetValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_TupleToUsersetValidationError) ErrorName() string {
	return "UsersetTree_TupleToUsersetValidationError"
}

// Error satisfies the builtin error interface
func (e UsersetTree_TupleToUsersetValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_TupleToUserset.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_TupleToUsersetValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_TupleToUsersetValidationError{}

// Validate checks the field values on UsersetTree_Difference with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Difference) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Difference with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_DifferenceMultiError, or nil if none found.
func (m *UsersetTree_Difference) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Difference) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetBase() == nil {
		err := UsersetTree_DifferenceValidationError{
			field:  "Base",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetBase()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UsersetTree_DifferenceValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UsersetTree_DifferenceValidationError{
					field:  "Base",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetBase()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UsersetTree_DifferenceValidationError{
				field:  "Base",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetSubtract() == nil {
		err := UsersetTree_DifferenceValidationError{
			field:  "Subtract",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetSubtract()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UsersetTree_DifferenceValidationError{
					field:  "Subtract",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UsersetTree_DifferenceValidationError{
					field:  "Subtract",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetSubtract()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UsersetTree_DifferenceValidationError{
				field:  "Subtract",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UsersetTree_DifferenceMultiError(errors)
	}

	return nil
}

// UsersetTree_DifferenceMultiError is an error wrapping multiple validation
// errors returned by UsersetTree_Difference.ValidateAll() if the designated
// constraints aren't met.
type UsersetTree_DifferenceMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_DifferenceMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_DifferenceMultiError) AllErrors() []error { return m }

// UsersetTree_DifferenceValidationError is the validation error returned by
// UsersetTree_Difference.Validate if the designated constraints aren't met.
type UsersetTree_DifferenceValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_DifferenceValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_DifferenceValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_DifferenceValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_DifferenceValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_DifferenceValidationError) ErrorName() string {
	return "UsersetTree_DifferenceValidationError"
}

// Error satisfies the builtin error interface
func (e UsersetTree_DifferenceValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Difference.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_DifferenceValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_DifferenceValidationError{}

// Validate checks the field values on UsersetTree_Node with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *UsersetTree_Node) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UsersetTree_Node with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UsersetTree_NodeMultiError, or nil if none found.
func (m *UsersetTree_Node) ValidateAll() error {
	return m.validate(true)
}

func (m *UsersetTree_Node) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Name

	switch v := m.Value.(type) {
	case *UsersetTree_Node_Leaf:
		if v == nil {
			err := UsersetTree_NodeValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetLeaf()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Leaf",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetLeaf()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_NodeValidationError{
					field:  "Leaf",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UsersetTree_Node_Difference:
		if v == nil {
			err := UsersetTree_NodeValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetDifference()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Difference",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Difference",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetDifference()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_NodeValidationError{
					field:  "Difference",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UsersetTree_Node_Union:
		if v == nil {
			err := UsersetTree_NodeValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetUnion()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Union",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Union",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetUnion()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_NodeValidationError{
					field:  "Union",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	case *UsersetTree_Node_Intersection:
		if v == nil {
			err := UsersetTree_NodeValidationError{
				field:  "Value",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetIntersection()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Intersection",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, UsersetTree_NodeValidationError{
						field:  "Intersection",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetIntersection()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return UsersetTree_NodeValidationError{
					field:  "Intersection",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return UsersetTree_NodeMultiError(errors)
	}

	return nil
}

// UsersetTree_NodeMultiError is an error wrapping multiple validation errors
// returned by UsersetTree_Node.ValidateAll() if the designated constraints
// aren't met.
type UsersetTree_NodeMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UsersetTree_NodeMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UsersetTree_NodeMultiError) AllErrors() []error { return m }

// UsersetTree_NodeValidationError is the validation error returned by
// UsersetTree_Node.Validate if the designated constraints aren't met.
type UsersetTree_NodeValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UsersetTree_NodeValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UsersetTree_NodeValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UsersetTree_NodeValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UsersetTree_NodeValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UsersetTree_NodeValidationError) ErrorName() string { return "UsersetTree_NodeValidationError" }

// Error satisfies the builtin error interface
func (e UsersetTree_NodeValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUsersetTree_Node.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UsersetTree_NodeValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UsersetTree_NodeValidationError{}
