# -*- coding: UTF-8 -*-
#
# generated by wxGlade 1.0.4 on Sat Jul 13 15:52:43 2024
#

import wx

# begin wxGlade: dependencies
import gettext
# end wxGlade

# begin wxGlade: extracode
# ------------------------------------------------------------------------------
# Project: SiriL-ic ( SiriL Image Converter )
#
# This script structures the SiriL work folder into a subfolder, copies the
# astronomical images into the subfolders, and builds the associated SiriL script.
# It can also group scripts.
# ------------------------------------------------------------------------------
#    Author:  M27trognondepomme <pebe92 (at) gmail.com>
#
# This program is provided without any guarantee.
#
# The license is  LGPL-v3
# For details, see GNU General Public License, version 3 or later.
#                        "https://www.gnu.org/licenses/gpl.html"
# ------------------------------------------------------------------------------

def wxNewIdRef():
    return wx.Window.NewControlId()

NB_HISTO             = 5
myID_LASTPRJ         = [ wxNewIdRef(), wxNewIdRef(), wxNewIdRef(), wxNewIdRef(), wxNewIdRef()]
# end wxGlade


class CGui(wx.Frame):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CGui.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.SetTitle(_("Siril IC  ( SiriL Image Converter )"))

        # Menu Bar
        self.menubar = wx.MenuBar()
        wxglade_tmp_menu = wx.Menu()
        self.menubar.mNew = wxglade_tmp_menu.Append(wx.ID_NEW, _("New"), _("Create a new project to astronomical image preprocessing"))
        self.menubar.mLoad = wxglade_tmp_menu.Append(wx.ID_OPEN, _("Load"), _("Load a  project to astronomical image preprocessing"))
        self.menubar.mSave = wxglade_tmp_menu.Append(wx.ID_SAVE, _("Save"), _("Save the project to astronomical image preprocessing"))
        self.menubar.mSaveas = wxglade_tmp_menu.Append(wx.ID_SAVEAS, _("Save as"), _("Save as a new  project to astronomical image preprocessing"))
        self.menubar.mReverseProject = wxglade_tmp_menu.Append(wx.ID_REPLACE, _("Reverse Project"), _("Recreate a project from the directory of an existing project"))
        wxglade_tmp_menu_sub = wx.Menu()
        self.menubar.mLastProject0 = wxglade_tmp_menu_sub.Append(myID_LASTPRJ[0], _("last project 0"), _("Load a last project to astronomical image preprocessing"))
        self.menubar.mLastProject1 = wxglade_tmp_menu_sub.Append(myID_LASTPRJ[1], _("last project 1"), _("Load a last project to astronomical image preprocessing"))
        self.menubar.mLastProject2 = wxglade_tmp_menu_sub.Append(myID_LASTPRJ[2], _("last project 2"), _("Load a last project to astronomical image preprocessing"))
        self.menubar.mLastProject3 = wxglade_tmp_menu_sub.Append(myID_LASTPRJ[3], _("last project 3"), _("Load a last project to astronomical image preprocessing"))
        self.menubar.mLastProject4 = wxglade_tmp_menu_sub.Append(myID_LASTPRJ[4], _("last project 4"), _("Load a last project to astronomical image preprocessing"))
        wxglade_tmp_menu.Append(wx.ID_ANY, _("Last project"), wxglade_tmp_menu_sub, "")
        wxglade_tmp_menu.AppendSeparator()
        self.menubar.mPrefs = wxglade_tmp_menu.Append(wx.ID_PREFERENCES, _("Preferences"), _("Sirilic preferences "))
        wxglade_tmp_menu.AppendSeparator()
        self.menubar.mExit = wxglade_tmp_menu.Append(wx.ID_EXIT, _("Exit"), "")
        self.menubar.Append(wxglade_tmp_menu, _("File"))
        wxglade_tmp_menu = wx.Menu()
        self.menubar.mModifyLight = wxglade_tmp_menu.Append(wx.ID_EDIT, _("Modify light"), _("Modify a light of the project"))
        self.menubar.mAddLight = wxglade_tmp_menu.Append(wx.ID_ADD, _("Add light"), _("Add a light to the project"))
        self.menubar.mDeleteLight = wxglade_tmp_menu.Append(wx.ID_REMOVE, _("Delete light"), _("Delete a light of the project"))
        wxglade_tmp_menu.AppendSeparator()
        self.menubar.mEditProp = wxglade_tmp_menu.Append(wx.ID_PROPERTIES, _("Edit properties"), _("Edit the properties and parameters of the project"))
        self.menubar.mSetMasters = wxglade_tmp_menu.Append(wx.ID_SELECT_COLOR, _("Set biases and dark masters for all the project"), _("Set the default value of biases and dark masters"))
        self.menubar.Append(wxglade_tmp_menu, _("Project"))
        wxglade_tmp_menu = wx.Menu()
        self.menubar.mCpyFiles = wxglade_tmp_menu.Append(wx.ID_COPY, _("Step 1: Build Directories and copy/link the images"), _("Build directories and copy or link the images"))
        self.menubar.mRunAll = wxglade_tmp_menu.Append(wx.ID_EXECUTE, _("Step 2: Build and Run the Siril script"), _("Build the Siril script and launch the image preprocessing"))
        self.menubar.mDelTmpFile = wxglade_tmp_menu.Append(wx.ID_DELETE, _("Delete intermediate files"), _("Delete intermediate files from subfolders"))
        wxglade_tmp_menu.AppendSeparator()
        self.menubar.mAbortAction = wxglade_tmp_menu.Append(wx.ID_STOP, _("Abort Action"), _("Abort the current action"))
        wxglade_tmp_menu.AppendSeparator()
        self.menubar.mExpertMode = wxglade_tmp_menu.Append(wx.ID_ANY, _("EXPERT MODE"), "")
        self.menubar.mBuildScript = wxglade_tmp_menu.Append(wx.ID_INDENT, _("Build Siril script"), _("Build the Siril script of project"))
        self.menubar.mPartialScript = wxglade_tmp_menu.Append(wx.ID_INDEX, _("Build partially siril script"), _("Launch part of the processing script for fine tuning"))
        self.menubar.mEditScript = wxglade_tmp_menu.Append(wx.ID_FILE, _("Edit Siril script"), _("Edit and  modify the siril script"))
        self.menubar.mRunScript = wxglade_tmp_menu.Append(wx.ID_CONVERT, _("Run Siril script"), _("Launch the image preprocessing"))
        self.menubar.myRunSiril = wxglade_tmp_menu.Append(wx.ID_APPLY, _("Run Siril"), _("launches Siril to do the last treatments (color calibration, gradient, ...)"))
        self.menubar.Append(wxglade_tmp_menu, _("Actions"))
        wxglade_tmp_menu = wx.Menu()
        self.menubar.mAbout = wxglade_tmp_menu.Append(wx.ID_ABOUT, _("About"), "")
        self.menubar.Append(wxglade_tmp_menu, _("Help"))
        self.SetMenuBar(self.menubar)
        # Menu Bar end
        self.mLastProject=[ self.menubar.mLastProject0,
                            self.menubar.mLastProject1,
                            self.menubar.mLastProject2,
                            self.menubar.mLastProject3,
                            self.menubar.mLastProject4]

        self.statusbar = self.CreateStatusBar(1)
        self.statusbar.SetStatusWidths([-1])
        # statusbar fields
        statusbar_fields = [_("sirilic status: Ready")]
        for i in range(len(statusbar_fields)):
            self.statusbar.SetStatusText(statusbar_fields[i], i)

        sizer_1 = wx.BoxSizer(wx.HORIZONTAL)

        sizer_9 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_9, 0, wx.EXPAND, 0)

        self.listProject = wx.ListCtrl(self, wx.ID_ANY, style=wx.LC_HRULES | wx.LC_REPORT | wx.LC_SINGLE_SEL | wx.LC_SORT_ASCENDING | wx.LC_VRULES)
        self.listProject.SetMinSize((-1, 340))
        self.listProject.SetBackgroundColour(wx.Colour(255, 255, 255))
        self.listProject.AppendColumn(_("Object"), format=wx.LIST_FORMAT_LEFT, width=-1)
        self.listProject.AppendColumn(_("Layer"), format=wx.LIST_FORMAT_LEFT, width=-1)
        self.listProject.AppendColumn(_("Session"), format=wx.LIST_FORMAT_LEFT, width=-1)
        self.listProject.AppendColumn(_("Status"), format=wx.LIST_FORMAT_LEFT, width=-1)
        sizer_9.Add(self.listProject, 0, wx.ALL | wx.EXPAND, 0)

        sizer_9.Add((20, 2), 0, 0, 0)

        static_line_2 = wx.StaticLine(self, wx.ID_ANY)
        sizer_9.Add(static_line_2, 0, wx.EXPAND, 0)

        sizer_9.Add((20, 2), 0, 0, 0)

        self.treeProject = wx.TreeCtrl(self, wx.ID_ANY)
        sizer_9.Add(self.treeProject, 1, wx.EXPAND, 0)

        self.gProgress = wx.Gauge(self, wx.ID_ANY, 100, style=wx.GA_HORIZONTAL | wx.GA_SMOOTH)
        sizer_9.Add(self.gProgress, 0, wx.EXPAND, 0)

        self.lTraitement = wx.TextCtrl(self, wx.ID_ANY, _("..."), style=wx.BORDER_NONE | wx.TE_CENTRE)
        sizer_9.Add(self.lTraitement, 0, wx.ALL | wx.EXPAND, 0)

        sizer_1.Add((2, 20), 0, 0, 0)

        static_line_1 = wx.StaticLine(self, wx.ID_ANY, style=wx.LI_VERTICAL)
        sizer_1.Add(static_line_1, 0, wx.EXPAND, 0)

        sizer_1.Add((2, 20), 0, 0, 0)

        sizer_43 = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_43, 1, wx.EXPAND, 0)

        sizer_44 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_43.Add(sizer_44, 0, wx.EXPAND, 0)

        self.b_nb_process = wx.ToggleButton(self, wx.ID_ANY, _("Process"))
        sizer_44.Add(self.b_nb_process, 1, 0, 0)

        self.b_nb_files = wx.ToggleButton(self, wx.ID_ANY, _("Files"))
        sizer_44.Add(self.b_nb_files, 1, 0, 0)

        self.b_nb_properties = wx.ToggleButton(self, wx.ID_ANY, _("Properties"))
        sizer_44.Add(self.b_nb_properties, 1, 0, 0)

        self.b_nb_log = wx.ToggleButton(self, wx.ID_ANY, _("Log"))
        sizer_44.Add(self.b_nb_log, 1, 0, 0)

        self.panel_1 = wx.ScrolledWindow(self, wx.ID_ANY, style=wx.TAB_TRAVERSAL)
        self.panel_1.SetScrollRate(10, 10)
        sizer_43.Add(self.panel_1, 1, wx.EXPAND, 0)

        sizer_13 = wx.BoxSizer(wx.VERTICAL)

        self.wprocess = CFprocess(self.panel_1, wx.ID_ANY)
        self.wprocess.Hide()
        sizer_13.Add(self.wprocess, 1, wx.EXPAND, 0)

        self.wfiles = CFfiles(self.panel_1, wx.ID_ANY)
        self.wfiles.Hide()
        sizer_13.Add(self.wfiles, 1, wx.EXPAND, 0)

        self.wproperties = CFproperties(self.panel_1, wx.ID_ANY)
        sizer_13.Add(self.wproperties, 1, wx.EXPAND, 0)

        self.wlog = CFlog(self.panel_1, wx.ID_ANY)
        self.wlog.Hide()
        sizer_13.Add(self.wlog, 1, wx.EXPAND, 0)

        self.panel_1.SetSizer(sizer_13)

        self.SetSizer(sizer_1)
        sizer_1.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CGui

class CNewProject(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CNewProject.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetTitle(_("New project"))

        sizer_2 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, ""), wx.VERTICAL)

        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(sizer_3, 0, wx.EXPAND, 0)

        sizer_4 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Object name")), wx.HORIZONTAL)
        sizer_3.Add(sizer_4, 1, wx.EXPAND, 0)

        self.cbLayer={ "DSLR":None,"RGB":None,"L":None,"R":None,"G":None,"B":None,"Ha":None,"O3":None,"S2":None,"Hb":None }
        self.eObject = wx.TextCtrl(self, wx.ID_ANY, _("M1"))
        sizer_4.Add(self.eObject, 0, 0, 0)

        sizer_5 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Session basename")), wx.HORIZONTAL)
        sizer_3.Add(sizer_5, 1, wx.EXPAND, 0)

        self.eSession = wx.TextCtrl(self, wx.ID_ANY, _("S"))
        sizer_5.Add(self.eSession, 0, 0, 0)

        sizer_6 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Number of session")), wx.HORIZONTAL)
        sizer_3.Add(sizer_6, 1, wx.EXPAND, 0)

        self.eNbSession = wx.SpinCtrl(self, wx.ID_ANY, "1", min=1, max=10)
        sizer_6.Add(self.eNbSession, 0, 0, 0)

        sizer_7 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Layers")), wx.VERTICAL)
        sizer_2.Add(sizer_7, 0, wx.EXPAND, 0)

        sizer_55 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("mono")), wx.VERTICAL)
        sizer_7.Add(sizer_55, 1, wx.EXPAND, 0)

        grid_sizer_1 = wx.GridSizer(2, 4, 0, 0)
        sizer_55.Add(grid_sizer_1, 1, wx.EXPAND, 0)

        self.cbLight = wx.CheckBox(self, wx.ID_ANY, _("Light"))
        self.cbLight.SetValue(1)
        self.cbLayer["L"]=self.cbLight
        grid_sizer_1.Add(self.cbLight, 0, 0, 0)

        self.cbRed = wx.CheckBox(self, wx.ID_ANY, _("Red"))
        self.cbLayer["R"]=self.cbRed
        grid_sizer_1.Add(self.cbRed, 0, 0, 0)

        self.cbGreen = wx.CheckBox(self, wx.ID_ANY, _("Green"))
        self.cbLayer["G"]=self.cbGreen
        grid_sizer_1.Add(self.cbGreen, 0, 0, 0)

        self.cbBlue = wx.CheckBox(self, wx.ID_ANY, _("Blue"))
        self.cbLayer["B"]=self.cbBlue
        grid_sizer_1.Add(self.cbBlue, 0, 0, 0)

        self.cbHa = wx.CheckBox(self, wx.ID_ANY, _("Halpha"))
        self.cbLayer["Ha"]=self.cbHa
        grid_sizer_1.Add(self.cbHa, 0, 0, 0)

        self.cbHb = wx.CheckBox(self, wx.ID_ANY, _("Hbeta"))
        self.cbLayer["Hb"]=self.cbHb
        grid_sizer_1.Add(self.cbHb, 0, 0, 0)

        self.cbSii = wx.CheckBox(self, wx.ID_ANY, _("Sii"))
        self.cbLayer["S2"]=self.cbSii
        grid_sizer_1.Add(self.cbSii, 0, 0, 0)

        self.cbOiii = wx.CheckBox(self, wx.ID_ANY, _("Oiii"))
        self.cbLayer["O3"]=self.cbOiii
        grid_sizer_1.Add(self.cbOiii, 0, 0, 0)

        sizer_56 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("color")), wx.HORIZONTAL)
        sizer_7.Add(sizer_56, 0, wx.EXPAND, 0)

        grid_sizer_4 = wx.GridSizer(1, 6, 0, 0)
        sizer_56.Add(grid_sizer_4, 1, wx.EXPAND, 0)

        self.cbColorCcd = wx.CheckBox(self, wx.ID_ANY, _("OSC/CCD"))
        self.cbLayer["RGB"]=self.cbColorCcd
        grid_sizer_4.Add(self.cbColorCcd, 0, 0, 0)

        self.cbDSLR = wx.CheckBox(self, wx.ID_ANY, _("DSLR"))
        self.cbLayer["DSLR"]=self.cbDSLR
        grid_sizer_4.Add(self.cbDSLR, 0, 0, 0)

        self.cbCHa = wx.CheckBox(self, wx.ID_ANY, _("Halpha"))
        self.cbLayer["cHa"]=self.cbCHa
        grid_sizer_4.Add(self.cbCHa, 0, 0, 0)

        self.cbCHaOiii = wx.CheckBox(self, wx.ID_ANY, _("Duo Ha/Oiii"))
        self.cbLayer["cHaO3"]=self.cbCHaOiii
        grid_sizer_4.Add(self.cbCHaOiii, 0, 0, 0)

        self.cbCSiiOiii = wx.CheckBox(self, wx.ID_ANY, _("Duo Sii/Oiii"))
        self.cbLayer["cS2O3"]=self.cbCSiiOiii
        grid_sizer_4.Add(self.cbCSiiOiii, 0, 0, 0)

        self.cbCGreen = wx.CheckBox(self, wx.ID_ANY, _("Green"))
        self.cbLayer["cGreen"]=self.cbCGreen
        grid_sizer_4.Add(self.cbCGreen, 0, 0, 0)

        sizer_59 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("debayerised")), wx.HORIZONTAL)
        sizer_7.Add(sizer_59, 1, wx.EXPAND, 0)

        grid_sizer_6 = wx.GridSizer(2, 4, 0, 0)
        sizer_59.Add(grid_sizer_6, 1, wx.EXPAND, 0)

        self.cbDLight = wx.CheckBox(self, wx.ID_ANY, _("Light"))
        self.cbLayer["dL"]=self.cbDLight
        grid_sizer_6.Add(self.cbDLight, 0, 0, 0)

        self.cbDRed = wx.CheckBox(self, wx.ID_ANY, _("Red"))
        self.cbLayer["dR"]=self.cbDRed
        grid_sizer_6.Add(self.cbDRed, 0, 0, 0)

        self.cbDGreen = wx.CheckBox(self, wx.ID_ANY, _("Green"))
        self.cbLayer["dG"]=self.cbDGreen
        grid_sizer_6.Add(self.cbDGreen, 0, 0, 0)

        self.cbDBlue = wx.CheckBox(self, wx.ID_ANY, _("Blue"))
        self.cbLayer["dB"]=self.cbDBlue
        grid_sizer_6.Add(self.cbDBlue, 0, 0, 0)

        self.cbDHa = wx.CheckBox(self, wx.ID_ANY, _("Halpha"))
        self.cbLayer["dHa"]=self.cbDHa
        grid_sizer_6.Add(self.cbDHa, 0, 0, 0)

        self.cbDHb = wx.CheckBox(self, wx.ID_ANY, _("Hbeta"))
        self.cbLayer["dHb"]=self.cbDHb
        grid_sizer_6.Add(self.cbDHb, 0, 0, 0)

        self.cbDSii = wx.CheckBox(self, wx.ID_ANY, _("Sii"))
        self.cbLayer["dS2"]=self.cbDSii
        grid_sizer_6.Add(self.cbDSii, 0, 0, 0)

        self.cbDOiii = wx.CheckBox(self, wx.ID_ANY, _("Oiii"))
        self.cbLayer["dO3"]=self.cbDOiii
        grid_sizer_6.Add(self.cbDOiii, 0, 0, 0)

        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(sizer_8, 0, wx.EXPAND, 0)

        self.bOK = wx.Button(self, wx.ID_OK, _("OK"))
        sizer_8.Add(self.bOK, 0, 0, 0)

        sizer_8.Add((100, 25), 2, 0, 0)

        self.bCancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.bCancel.SetDefault()
        sizer_8.Add(self.bCancel, 0, 0, 0)

        self.SetSizer(sizer_2)
        sizer_2.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CNewProject

class CModifyFile(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CModifyFile.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetTitle(_("Modify the file path"))

        sizer_11 = wx.BoxSizer(wx.VERTICAL)

        self.text_file = wx.TextCtrl(self, wx.ID_ANY, "")
        self.text_file.SetMinSize((480, 23))
        sizer_11.Add(self.text_file, 0, 0, 0)

        sizer_16 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_11.Add(sizer_16, 1, wx.EXPAND, 0)

        self.bOK = wx.Button(self, wx.ID_OK, _("OK"))
        sizer_16.Add(self.bOK, 0, 0, 0)

        sizer_16.Add((20, 20), 1, 0, 0)

        self.bCancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.bCancel.SetDefault()
        sizer_16.Add(self.bCancel, 0, 0, 0)

        self.SetSizer(sizer_11)
        sizer_11.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CModifyFile

class CPrefs(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CPrefs.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetTitle(_("Preferences"))

        sizer_18 = wx.BoxSizer(wx.HORIZONTAL)

        sizer_18.Add((20, 20), 0, 0, 0)

        sizer_19 = wx.BoxSizer(wx.VERTICAL)
        sizer_18.Add(sizer_19, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        grid_sizer_3 = wx.FlexGridSizer(2, 4, 0, 0)
        sizer_19.Add(grid_sizer_3, 1, wx.EXPAND, 0)

        label_18 = wx.StaticText(self, wx.ID_ANY, _("Work directory: "))
        grid_sizer_3.Add(label_18, 0, 0, 0)

        self.textWorkDir = wx.TextCtrl(self, wx.ID_ANY, "")
        self.textWorkDir.SetMinSize((250, -1))
        self.textWorkDir.SetToolTip(_("work directory of SiriL"))
        grid_sizer_3.Add(self.textWorkDir, 1, wx.EXPAND, 0)

        self.b_workdir = wx.Button(self, wx.ID_ANY, _(" ... "))
        grid_sizer_3.Add(self.b_workdir, 0, 0, 0)

        grid_sizer_3.Add((0, 0), 0, 0, 0)

        label_19 = wx.StaticText(self, wx.ID_ANY, _("SiriL executable : "))
        grid_sizer_3.Add(label_19, 0, 0, 0)

        self.textSirilExe = wx.TextCtrl(self, wx.ID_ANY, "")
        self.textSirilExe.SetMinSize((250, -1))
        self.textSirilExe.SetToolTip(_("full name of siril exe"))
        grid_sizer_3.Add(self.textSirilExe, 1, wx.EXPAND, 0)

        self.b_sirilexe = wx.Button(self, wx.ID_ANY, _(" ... "))
        grid_sizer_3.Add(self.b_sirilexe, 0, 0, 0)

        self.bDetect = wx.Button(self, wx.ID_ANY, _("Default"))
        self.bDetect.SetToolTip(_("Set the default SiriL executable according to OS"))
        grid_sizer_3.Add(self.bDetect, 0, wx.ALL, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_cleandir = wx.CheckBox(self, wx.ID_ANY, _("Clean the object directory before to launch the script"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_cleandir, 0, 0, 0)

        self.cb_links = wx.CheckBox(self, wx.ID_ANY, _("use symbolic links ( replace the copy)"), style=wx.CHK_2STATE)
        self.cb_links.SetToolTip(_("to use symbolic link on  the windows 10 , select the developper mode"))
        sizer_19.Add(self.cb_links, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_WorkDirFinal = wx.CheckBox(self, wx.ID_ANY, _("return to the workdir at the script end"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_WorkDirFinal, 0, 0, 0)

        self.cb_RunSirilAfter = wx.CheckBox(self, wx.ID_ANY, _("After executing the script, launch Siril"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_RunSirilAfter, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_savetif = wx.CheckBox(self, wx.ID_ANY, _("Save a copy in tif format (16b, uncompressed)"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_savetif, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_set32b = wx.CheckBox(self, wx.ID_ANY, _("mode: float 32 bits"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_set32b, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_61 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("FITS compression")), wx.HORIZONTAL)
        sizer_19.Add(sizer_61, 0, wx.EXPAND, 0)

        sizer_62 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_61.Add(sizer_62, 1, wx.EXPAND, 0)

        self.cb_compress = wx.CheckBox(self, wx.ID_ANY, _("enable"), style=wx.CHK_2STATE)
        sizer_62.Add(self.cb_compress, 0, 0, 0)

        sizer_62.Add((20, 20), 0, wx.EXPAND, 0)

        self.cb_typecomp = wx.ComboBox(self, wx.ID_ANY, choices=[_("rice"), _("gzip1"), _("gzip2")], style=wx.CB_DROPDOWN | wx.CB_READONLY)
        self.cb_typecomp.SetSelection(0)
        sizer_62.Add(self.cb_typecomp, 0, 0, 0)

        sizer_62.Add((20, 20), 0, wx.EXPAND, 0)

        self.sp_quantif = wx.SpinCtrl(self, wx.ID_ANY, "16", min=0, max=256)
        self.sp_quantif.SetMinSize((110, -1))
        sizer_62.Add(self.sp_quantif, 0, 0, 0)

        label_26 = wx.StaticText(self, wx.ID_ANY, _("quantization"))
        sizer_62.Add(label_26, 0, 0, 0)

        sizer_62.Add((20, 20), 0, wx.EXPAND, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.rb_seqmode = wx.RadioBox(self, wx.ID_ANY, _("Sequence mode:"), choices=[_("Single image by FITS"), _("Multi-image by FITS"), _("SER ")], majorDimension=1, style=wx.RA_SPECIFY_ROWS)
        self.rb_seqmode.SetSelection(0)
        sizer_19.Add(self.rb_seqmode, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.l_version_dbg = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Siril = x.y.z")), wx.HORIZONTAL)
        sizer_19.Add(self.l_version_dbg, 0, wx.EXPAND, 0)

        sizer_54 = wx.BoxSizer(wx.VERTICAL)
        self.l_version_dbg.Add(sizer_54, 0, wx.EXPAND, 0)

        self.cb_siril_dev = wx.CheckBox(self, wx.ID_ANY, _("Enable Siril dev ..."), style=wx.CHK_2STATE)
        sizer_54.Add(self.cb_siril_dev, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_42 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19.Add(sizer_42, 0, wx.EXPAND, 0)

        self.spCPU = wx.SpinCtrl(self, wx.ID_ANY, "0", min=0, max=32)
        self.spCPU.SetMinSize((110, -1))
        self.spCPU.SetToolTip(_("0=default value  of SiriL else number of used cpu"))
        sizer_42.Add(self.spCPU, 0, 0, 0)

        label_22 = wx.StaticText(self, wx.ID_ANY, _("CPU"))
        sizer_42.Add(label_22, 0, 0, 0)

        sizer_42.Add((20, 20), 0, 0, 0)

        self.spMem = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.8, min=0.0, max=4.0)
        self.spMem.SetMinSize((110, -1))
        self.spMem.SetToolTip(_("0=default  of SiriL else ratio of used mem"))
        self.spMem.SetIncrement(0.1)
        self.spMem.SetDigits(2)
        sizer_42.Add(self.spMem, 0, 0, 0)

        label_23 = wx.StaticText(self, wx.ID_ANY, _("MEM"))
        sizer_42.Add(label_23, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cbDebug = wx.CheckBox(self, wx.ID_ANY, _("Debug ( save stdout/stderr in file)"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cbDebug, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_16 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19.Add(sizer_16, 0, wx.EXPAND, 0)

        self.bOK = wx.Button(self, wx.ID_OK, _("OK"))
        sizer_16.Add(self.bOK, 0, 0, 0)

        sizer_16.Add((20, 20), 1, 0, 0)

        self.bCancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.bCancel.SetDefault()
        sizer_16.Add(self.bCancel, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_18.Add((20, 20), 0, 0, 0)

        self.SetSizer(sizer_18)
        sizer_18.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CPrefs

class CModifyProject(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CModifyProject.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetTitle(_("Modify project"))

        sizer_2 = wx.BoxSizer(wx.VERTICAL)

        sizer_3 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(sizer_3, 0, wx.EXPAND, 0)

        sizer_4 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Object name")), wx.HORIZONTAL)
        sizer_3.Add(sizer_4, 1, wx.EXPAND, 0)

        self.rbLayer={ "DSLR":None,"RGB":None,"L":None,"R":None,"G":None,"B":None,"Ha":None,"O3":None,"S2":None,"Hb":None }
        self.eObject = wx.TextCtrl(self, wx.ID_ANY, _("M1"))
        sizer_4.Add(self.eObject, 0, 0, 0)

        sizer_5 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Session name")), wx.HORIZONTAL)
        sizer_3.Add(sizer_5, 1, wx.EXPAND, 0)

        self.eSession = wx.TextCtrl(self, wx.ID_ANY, _("S"))
        sizer_5.Add(self.eSession, 0, 0, 0)

        sizer_7 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Layers")), wx.VERTICAL)
        sizer_2.Add(sizer_7, 1, wx.EXPAND, 0)

        sizer_57 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("mono")), wx.HORIZONTAL)
        sizer_7.Add(sizer_57, 1, wx.EXPAND, 0)

        grid_sizer_1 = wx.GridSizer(2, 4, 0, 0)
        sizer_57.Add(grid_sizer_1, 1, wx.EXPAND, 0)

        self.rbLight = wx.RadioButton(self, wx.ID_ANY, _("Light"))
        self.rbLayer["L"]=self.rbLight
        grid_sizer_1.Add(self.rbLight, 1, wx.EXPAND, 0)

        self.rbRed = wx.RadioButton(self, wx.ID_ANY, _("Red"))
        self.rbLayer["R"]=self.rbRed
        grid_sizer_1.Add(self.rbRed, 0, 0, 0)

        self.rbGreen = wx.RadioButton(self, wx.ID_ANY, _("Green"))
        self.rbLayer["G"]=self.rbGreen
        grid_sizer_1.Add(self.rbGreen, 0, 0, 0)

        self.rbBlue = wx.RadioButton(self, wx.ID_ANY, _("Blue"))
        self.rbLayer["B"]=self.rbBlue
        grid_sizer_1.Add(self.rbBlue, 0, 0, 0)

        self.rbHa = wx.RadioButton(self, wx.ID_ANY, _("H alpha"))
        self.rbLayer["Ha"]=self.rbHa
        grid_sizer_1.Add(self.rbHa, 0, 0, 0)

        self.rbHb = wx.RadioButton(self, wx.ID_ANY, _("H beta"))
        self.rbLayer["Hb"]=self.rbHb
        grid_sizer_1.Add(self.rbHb, 0, 0, 0)

        self.rbS2 = wx.RadioButton(self, wx.ID_ANY, _("Sii"))
        self.rbLayer["S2"]=self.rbS2
        grid_sizer_1.Add(self.rbS2, 0, 0, 0)

        self.rbO3 = wx.RadioButton(self, wx.ID_ANY, _("Oiii"))
        self.rbLayer["O3"]=self.rbO3
        grid_sizer_1.Add(self.rbO3, 0, 0, 0)

        sizer_58 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("color")), wx.HORIZONTAL)
        sizer_7.Add(sizer_58, 0, wx.EXPAND, 0)

        grid_sizer_5 = wx.GridSizer(1, 6, 0, 0)
        sizer_58.Add(grid_sizer_5, 1, wx.EXPAND, 0)

        self.rbColorCCD = wx.RadioButton(self, wx.ID_ANY, _("OSC/CCD"))
        self.rbLayer["RGB"]=self.rbColorCCD
        grid_sizer_5.Add(self.rbColorCCD, 0, 0, 0)

        self.rbDSLR = wx.RadioButton(self, wx.ID_ANY, _("DSLR"))
        self.rbLayer["DSLR"]=self.rbDSLR
        grid_sizer_5.Add(self.rbDSLR, 1, 0, 0)

        self.rbCHa = wx.RadioButton(self, wx.ID_ANY, _("H alpha"))
        self.rbLayer["cHa"]=self.rbCHa
        grid_sizer_5.Add(self.rbCHa, 0, 0, 0)

        self.rbCHaO3 = wx.RadioButton(self, wx.ID_ANY, _("Duo Ha/Oiii"))
        self.rbLayer["cHaO3"]=self.rbCHaO3
        grid_sizer_5.Add(self.rbCHaO3, 0, 0, 0)

        self.rbCS2O3 = wx.RadioButton(self, wx.ID_ANY, _("Duo Sii/Oiii"))
        self.rbLayer["cS2O3"]=self.rbCS2O3
        grid_sizer_5.Add(self.rbCS2O3, 0, 0, 0)

        self.rbCGreen = wx.RadioButton(self, wx.ID_ANY, _("Green"))
        self.rbLayer["cGreen"]=self.rbCGreen
        grid_sizer_5.Add(self.rbCGreen, 0, 0, 0)

        sizer_60 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("debayerised")), wx.HORIZONTAL)
        sizer_7.Add(sizer_60, 1, wx.EXPAND, 0)

        grid_sizer_2 = wx.GridSizer(2, 4, 0, 0)
        sizer_60.Add(grid_sizer_2, 1, wx.EXPAND, 0)

        self.rbDLight = wx.RadioButton(self, wx.ID_ANY, _("Light"))
        self.rbLayer["dL"]=self.rbDLight
        grid_sizer_2.Add(self.rbDLight, 1, wx.EXPAND, 0)

        self.rbDRed = wx.RadioButton(self, wx.ID_ANY, _("Red"))
        self.rbLayer["dR"]=self.rbDRed
        grid_sizer_2.Add(self.rbDRed, 0, 0, 0)

        self.rbDGreen = wx.RadioButton(self, wx.ID_ANY, _("Green"))
        self.rbLayer["dG"]=self.rbDGreen
        grid_sizer_2.Add(self.rbDGreen, 0, 0, 0)

        self.rbDBlue = wx.RadioButton(self, wx.ID_ANY, _("Blue"))
        self.rbLayer["dB"]=self.rbDBlue
        grid_sizer_2.Add(self.rbDBlue, 0, 0, 0)

        self.rbDHa = wx.RadioButton(self, wx.ID_ANY, _("H alpha"))
        self.rbLayer["dHa"]=self.rbDHa
        grid_sizer_2.Add(self.rbDHa, 0, 0, 0)

        self.rbDHb = wx.RadioButton(self, wx.ID_ANY, _("H beta"))
        self.rbLayer["dHb"]=self.rbDHb
        grid_sizer_2.Add(self.rbDHb, 0, 0, 0)

        self.rbDS2 = wx.RadioButton(self, wx.ID_ANY, _("Sii"))
        self.rbLayer["dS2"]=self.rbDS2
        grid_sizer_2.Add(self.rbDS2, 0, 0, 0)

        self.rbDO3 = wx.RadioButton(self, wx.ID_ANY, _("Oiii"))
        self.rbLayer["dO3"]=self.rbDO3
        grid_sizer_2.Add(self.rbDO3, 0, 0, 0)

        sizer_8 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_2.Add(sizer_8, 0, wx.EXPAND, 0)

        self.bOK = wx.Button(self, wx.ID_OK, _("OK"))
        sizer_8.Add(self.bOK, 0, 0, 0)

        sizer_8.Add((100, 25), 2, 0, 0)

        self.bCancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.bCancel.SetDefault()
        sizer_8.Add(self.bCancel, 0, 0, 0)

        self.SetSizer(sizer_2)
        sizer_2.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CModifyProject

class CGlobProp(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CGlobProp.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetTitle(_("Global properties for the project"))

        sizer_18 = wx.BoxSizer(wx.HORIZONTAL)

        sizer_18.Add((20, 20), 0, 0, 0)

        sizer_19 = wx.BoxSizer(wx.VERTICAL)
        sizer_18.Add(sizer_19, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_multisession = wx.CheckBox(self, wx.ID_ANY, _("Multi-session"), style=wx.CHK_2STATE)
        self.cb_multisession.SetValue(1)
        sizer_19.Add(self.cb_multisession, 0, 0, 0)

        self.cb_stack_intermed = wx.CheckBox(self, wx.ID_ANY, _("intermediate stacking (multi-session)"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_stack_intermed, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_19.Add((0, 0), 0, 0, 0)

        self.cb_CFAequa = wx.CheckBox(self, wx.ID_ANY, _("equalize (CFA)"), style=wx.CHK_2STATE)
        self.cb_CFAequa.SetToolTip(_("option equalizes the mean intensity of RGB layers of the CFA flat master"))
        sizer_19.Add(self.cb_CFAequa, 0, 0, 0)

        self.cb_FastNorm = wx.CheckBox(self, wx.ID_ANY, _("Fast normalization"), style=wx.CHK_2STATE)
        self.cb_FastNorm.SetToolTip(_("By default, Siril uses IKSS estimators of location and scale to compute normalisation. For long sequences, computing these estimators can be quite intensive. For such cases, you can opt in for faster estimators (based on median and median absolute deviation). While less resistant to outliers in each image, they can still give a satisfactory result when compared to no normalization at all"))
        sizer_19.Add(self.cb_FastNorm, 0, 0, 0)

        sizer_19.Add((0, 0), 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_DslrDebayerised = wx.CheckBox(self, wx.ID_ANY, _("Debayerised DSLR"), style=wx.CHK_2STATE)
        self.cb_DslrDebayerised.SetToolTip(_("the CCD is a debayerised DSLR"))
        self.cb_DslrDebayerised.Hide()
        sizer_19.Add(self.cb_DslrDebayerised, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        self.cb_prop_unique = wx.CheckBox(self, wx.ID_ANY, _("identical parameters for all layers"), style=wx.CHK_2STATE)
        sizer_19.Add(self.cb_prop_unique, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_16 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19.Add(sizer_16, 0, wx.EXPAND, 0)

        self.bOK = wx.Button(self, wx.ID_OK, _("OK"))
        sizer_16.Add(self.bOK, 0, 0, 0)

        sizer_16.Add((20, 20), 1, 0, 0)

        self.bCancel = wx.Button(self, wx.ID_CANCEL, _("Cancel"))
        self.bCancel.SetDefault()
        sizer_16.Add(self.bCancel, 0, 0, 0)

        sizer_19.Add((20, 20), 0, 0, 0)

        sizer_18.Add((20, 20), 0, 0, 0)

        self.SetSizer(sizer_18)
        sizer_18.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CGlobProp

class CFprocess(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CFprocess.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_45 = wx.BoxSizer(wx.HORIZONTAL)

        self.f_draw = wx.Panel(self, wx.ID_ANY)
        self.f_draw.SetBackgroundColour(wx.Colour(192, 192, 192))
        sizer_45.Add(self.f_draw, 1, wx.ALL | wx.EXPAND, 0)

        self.SetSizer(sizer_45)
        sizer_45.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CFprocess

class CFfiles(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CFfiles.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_21 = wx.BoxSizer(wx.VERTICAL)

        self.bFastFiles = wx.Button(self, wx.ID_ANY, _("load files with pattern"))
        sizer_21.Add(self.bFastFiles, 0, wx.ALIGN_RIGHT, 0)

        label_16 = wx.StaticText(self, wx.ID_ANY, _("Drag and drop the images or use the selection button"))
        label_16.SetForegroundColour(wx.Colour(0, 127, 255))
        sizer_21.Add(label_16, 0, 0, 0)

        self.panel_images = wx.Panel(self, wx.ID_ANY)
        sizer_21.Add(self.panel_images, 1, wx.EXPAND, 0)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        self.TitreImagesFiles = wx.StaticText(self.panel_images, wx.ID_ANY, _("Image:"))
        self.TitreImagesFiles.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.TitreImagesFiles.SetForegroundColour(wx.Colour(0, 0, 0))
        self.TitreImagesFiles.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_1.Add(self.TitreImagesFiles, 0, wx.EXPAND, 0)

        self.wImageFiles = CFilesSelection(self.panel_images, wx.ID_ANY)
        sizer_1.Add(self.wImageFiles, 1, wx.EXPAND, 0)

        self.panel_offset = wx.Panel(self, wx.ID_ANY)
        sizer_21.Add(self.panel_offset, 1, wx.EXPAND, 0)

        sizer_2 = wx.BoxSizer(wx.VERTICAL)

        self.TitreOffsetFiles = wx.StaticText(self.panel_offset, wx.ID_ANY, _("Biases:"))
        self.TitreOffsetFiles.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.TitreOffsetFiles.SetForegroundColour(wx.Colour(0, 0, 0))
        self.TitreOffsetFiles.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_2.Add(self.TitreOffsetFiles, 0, wx.EXPAND, 0)

        self.wOffsetFiles = CFilesSelection(self.panel_offset, wx.ID_ANY)
        sizer_2.Add(self.wOffsetFiles, 1, wx.EXPAND, 0)

        self.panel_dark = wx.Panel(self, wx.ID_ANY)
        sizer_21.Add(self.panel_dark, 1, wx.EXPAND, 0)

        sizer_3 = wx.BoxSizer(wx.VERTICAL)

        self.TitreDarkFiles = wx.StaticText(self.panel_dark, wx.ID_ANY, _("Dark:"))
        self.TitreDarkFiles.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.TitreDarkFiles.SetForegroundColour(wx.Colour(0, 0, 0))
        self.TitreDarkFiles.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_3.Add(self.TitreDarkFiles, 0, wx.EXPAND, 0)

        self.wDarkFiles = CFilesSelection(self.panel_dark, wx.ID_ANY)
        sizer_3.Add(self.wDarkFiles, 1, wx.EXPAND, 0)

        self.panel_flat = wx.Panel(self, wx.ID_ANY)
        sizer_21.Add(self.panel_flat, 1, wx.EXPAND, 0)

        sizer_4 = wx.BoxSizer(wx.VERTICAL)

        self.TitreFlatFiles = wx.StaticText(self.panel_flat, wx.ID_ANY, _("Flat:"))
        self.TitreFlatFiles.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.TitreFlatFiles.SetForegroundColour(wx.Colour(0, 0, 0))
        self.TitreFlatFiles.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_4.Add(self.TitreFlatFiles, 0, wx.EXPAND, 0)

        self.wFlatFiles = CFilesSelection(self.panel_flat, wx.ID_ANY)
        sizer_4.Add(self.wFlatFiles, 1, wx.EXPAND, 0)

        self.panel_dflat = wx.Panel(self, wx.ID_ANY)
        sizer_21.Add(self.panel_dflat, 1, wx.EXPAND, 0)

        sizer_5 = wx.BoxSizer(wx.VERTICAL)

        self.TitreDFlatFiles = wx.StaticText(self.panel_dflat, wx.ID_ANY, _("Dark-Flat:"))
        self.TitreDFlatFiles.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.TitreDFlatFiles.SetForegroundColour(wx.Colour(0, 0, 0))
        self.TitreDFlatFiles.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_5.Add(self.TitreDFlatFiles, 0, wx.EXPAND, 0)

        self.wDFlatFiles = CFilesSelection(self.panel_dflat, wx.ID_ANY)
        sizer_5.Add(self.wDFlatFiles, 1, wx.EXPAND, 0)

        sizer_17 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_21.Add(sizer_17, 0, wx.EXPAND, 0)

        sizer_17.Add((20, 10), 1, 0, 0)

        self.bClearAllFiles = wx.Button(self, wx.ID_ANY, _("Clear all files"))
        sizer_17.Add(self.bClearAllFiles, 0, 0, 0)

        sizer_17.Add((20, 10), 1, 0, 0)

        self.panel_dflat.SetSizer(sizer_5)

        self.panel_flat.SetSizer(sizer_4)

        self.panel_dark.SetSizer(sizer_3)

        self.panel_offset.SetSizer(sizer_2)

        self.panel_images.SetSizer(sizer_1)

        self.SetSizer(sizer_21)
        sizer_21.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CFfiles

class CFproperties(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CFproperties.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_10 = wx.BoxSizer(wx.VERTICAL)

        sizer_20 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_10.Add(sizer_20, 0, wx.EXPAND | wx.TOP, 5)

        self.b_prop_image = wx.ToggleButton(self, wx.ID_ANY, _("IMAGE"))
        sizer_20.Add(self.b_prop_image, 1, 0, 0)

        self.b_prop_offset = wx.ToggleButton(self, wx.ID_ANY, _("BIASES"))
        sizer_20.Add(self.b_prop_offset, 1, 0, 0)

        self.b_prop_dark = wx.ToggleButton(self, wx.ID_ANY, _("DARK"))
        sizer_20.Add(self.b_prop_dark, 1, 0, 0)

        self.b_prop_flat = wx.ToggleButton(self, wx.ID_ANY, _("FLAT"))
        sizer_20.Add(self.b_prop_flat, 1, 0, 0)

        self.b_prop_dflat = wx.ToggleButton(self, wx.ID_ANY, _("DARK FLAT"))
        sizer_20.Add(self.b_prop_dflat, 1, 0, 0)

        self.l_mode_param = wx.StaticText(self, wx.ID_ANY, _("identical parameters for all layers"))
        self.l_mode_param.SetForegroundColour(wx.Colour(255, 0, 0))
        sizer_10.Add(self.l_mode_param, 0, 0, 0)

        static_line_8 = wx.StaticLine(self, wx.ID_ANY)
        sizer_10.Add(static_line_8, 0, wx.EXPAND, 0)

        sizer_10.Add((10, 10), 0, 0, 0)

        sizer_preproc = wx.BoxSizer(wx.VERTICAL)
        sizer_10.Add(sizer_preproc, 0, wx.ALL | wx.EXPAND, 1)

        l_Preprocessing = wx.StaticText(self, wx.ID_ANY, _("Preprocessing"))
        l_Preprocessing.SetBackgroundColour(wx.Colour(188, 183, 161))
        l_Preprocessing.SetForegroundColour(wx.Colour(0, 0, 0))
        l_Preprocessing.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_preproc.Add(l_Preprocessing, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_1 = wx.GridBagSizer(5, 5)
        sizer_preproc.Add(grid_sizer_1, 1, wx.EXPAND, 0)

        self.cb_cpylib = wx.CheckBox(self, wx.ID_ANY, _("copy the library by Siril"), style=wx.CHK_2STATE)
        grid_sizer_1.Add(self.cb_cpylib, (0, 0), (1, 1), wx.EXPAND, 0)

        self.cb_OffsetSub = wx.CheckBox(self, wx.ID_ANY, _("Biases subtract"), style=wx.CHK_2STATE)
        grid_sizer_1.Add(self.cb_OffsetSub, (0, 1), (1, 1), 0, 0)

        self.cb_fix_fujix = wx.CheckBox(self, wx.ID_ANY, _("fix Fuji X    "), style=wx.CHK_2STATE)
        grid_sizer_1.Add(self.cb_fix_fujix, (0, 2), (1, 1), 0, 0)

        sizer_10.Add((10, 10), 0, 0, 0)

        sizer_cosmetic = wx.BoxSizer(wx.VERTICAL)
        sizer_10.Add(sizer_cosmetic, 0, wx.ALL | wx.EXPAND, 1)

        self.cb_Cosmetic = wx.CheckBox(self, wx.ID_ANY, _("Cosmetic correction"), style=wx.CHK_2STATE)
        self.cb_Cosmetic.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.cb_Cosmetic.SetForegroundColour(wx.Colour(255, 255, 255))
        sizer_cosmetic.Add(self.cb_Cosmetic, 0, wx.BOTTOM | wx.EXPAND, 5)

        sizer_29 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_cosmetic.Add(sizer_29, 1, wx.EXPAND, 0)

        self.l_HotCosmetic = wx.StaticText(self, wx.ID_ANY, _("hot: "))
        sizer_29.Add(self.l_HotCosmetic, 0, wx.LEFT, 5)

        self.e_HotCosmetic = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=3.0, min=0.1, max=30.0)
        self.e_HotCosmetic.SetIncrement(0.1)
        self.e_HotCosmetic.SetDigits(1)
        sizer_29.Add(self.e_HotCosmetic, 0, 0, 0)

        self.l_ColdCosmetic = wx.StaticText(self, wx.ID_ANY, _("cold: "))
        sizer_29.Add(self.l_ColdCosmetic, 0, wx.LEFT, 5)

        self.e_ColdCosmetic = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=3.0, min=0.1, max=30.0)
        self.e_ColdCosmetic.SetIncrement(0.1)
        self.e_ColdCosmetic.SetDigits(1)
        sizer_29.Add(self.e_ColdCosmetic, 0, 0, 0)

        self.l_bpm_file = wx.StaticText(self, wx.ID_ANY, _("Bad Pixel Map: "))
        self.l_bpm_file.SetToolTip(_("Bad Pixel Map to specify which pixels must be corrected"))
        sizer_29.Add(self.l_bpm_file, 0, wx.LEFT, 5)

        self.e_bpm_file = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_LEFT | wx.TE_NO_VSCROLL)
        self.e_bpm_file.SetMinSize((300, -1))
        self.e_bpm_file.SetToolTip(_("path to your Bad Pixel Map to specify which pixels must be corrected\n*** empty = no file ****"))
        sizer_29.Add(self.e_bpm_file, 1, wx.EXPAND, 0)

        self.b_bpm_file = wx.ToggleButton(self, wx.ID_ANY, _("..."))
        self.b_bpm_file.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.b_bpm_file.SetForegroundColour(wx.Colour(0, 0, 0))
        self.b_bpm_file.SetToolTip(_("select a BPM file"))
        sizer_29.Add(self.b_bpm_file, 0, 0, 0)

        sizer_10.Add((10, 10), 0, 0, 0)

        sizer_stacking = wx.BoxSizer(wx.VERTICAL)
        sizer_10.Add(sizer_stacking, 0, wx.ALL | wx.EXPAND, 1)

        l_Stacking = wx.StaticText(self, wx.ID_ANY, _("Stacking"))
        l_Stacking.SetBackgroundColour(wx.Colour(188, 183, 161))
        l_Stacking.SetForegroundColour(wx.Colour(0, 0, 0))
        l_Stacking.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_stacking.Add(l_Stacking, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_2 = wx.GridBagSizer(5, 5)
        sizer_stacking.Add(grid_sizer_2, 0, wx.EXPAND, 0)

        self.cb_RGBequa = wx.CheckBox(self, wx.ID_ANY, _("RGB equalization"), style=wx.CHK_2STATE)
        self.cb_RGBequa.SetToolTip(_("If you check this button, the channels in the final image will be equalized (color images only)."))
        grid_sizer_2.Add(self.cb_RGBequa, (0, 0), (1, 2), 0, 0)

        self.cb_optimdark = wx.CheckBox(self, wx.ID_ANY, _("Optim.Dark"), style=wx.CHK_2STATE)
        grid_sizer_2.Add(self.cb_optimdark, (0, 2), (1, 2), 0, 0)

        l_Stack = wx.StaticText(self, wx.ID_ANY, _("Stack"))
        l_Stack.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_Stack.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_2.Add(l_Stack, (1, 0), (1, 1), wx.EXPAND, 0)

        l_rejtype = wx.StaticText(self, wx.ID_ANY, _("Rejection type"))
        l_rejtype.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_rejtype.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_2.Add(l_rejtype, (1, 1), (1, 5), wx.EXPAND, 0)

        self.l_weighing = wx.StaticText(self, wx.ID_ANY, _("Weighing: "))
        self.l_weighing.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_weighing.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_2.Add(self.l_weighing, (1, 6), (1, 1), wx.EXPAND, 0)

        l_norm = wx.StaticText(self, wx.ID_ANY, _("Normalisation"))
        l_norm.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_norm.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_2.Add(l_norm, (1, 7), (1, 1), wx.EXPAND, 0)

        self.cb_Stack = wx.ComboBox(self, wx.ID_ANY, choices=[_("sum"), _("mean"), _("median"), _("min"), _("max")], style=wx.CB_DROPDOWN)
        self.cb_Stack.SetToolTip(_("'Sum': This is the simplest method.\nPixel values are added in an image normalized to 32-bit values.\nIt increases signal/noise ratio (SNR) as square root of number of images.\n\n'Mean' with rejection: This method is used to reject deviant pixels iteratively.\nSeven methods have been implemented:\n- Percentile Clipping\n- Sigma Clipping\n- MAD Clipping\n- Median Sigma Clipping\n- Winsorized Sigma Clipping\n- Linear Fit Clipping\n- Generalized Extreme Studentized Deviate Test\nAfter pixel rejection, the mean of the stack is computed.\n\n'Median': This method was mostly used for dark/flat/offset stacking although now we recommend the use of average with rejection stacking.\nThe median value of the pixels in the stack is computed for each pixel.\nAs this method should only be used for dark/flat/offset stacking, it does not take\ninto account shifts computed during registration.\n\n'Pixel maximum': This case is mainly used to construct long exposure star-trails images.\nPixels of the image are replaced by pixels at the same coordinates if intensity is greater.\n\n'Pixel minimum': This case could be useful to select the area to be cropped after the stack operation.\nPixels of the image are replaced by pixels at the same coordinates if intensity is lower."))
        self.cb_Stack.SetSelection(2)
        grid_sizer_2.Add(self.cb_Stack, (2, 0), (1, 1), 0, 0)

        self.cb_rejtype = wx.ComboBox(self, wx.ID_ANY, choices=[_("No rejection"), _("Percentile"), _("Sigma"), _("MAD"), _("Median"), _("Winsorized"), _("Linear-Fit"), _("Generalized")], style=wx.CB_DROPDOWN)
        self.cb_rejtype.SetToolTip(_("Seven rejection algorithms are available:\n\n'Percentile Clipping' is a one-step rejection algorithm ideal for small sets of data (up to 6 images).\n\n'Sigma Clipping' is an iterative algorithm which will reject pixels whose distance from median will be farthest than two given values in sigma units.\n\n'MAD Clipping' is an iterative algorithm working as Sigma Clipping except that the estimator used is the Median Absolute Deviation (MAD). This is generally used for noisy infrared image processing.\n\n'Median Sigma Clipping' is the same algorithm except than the rejected pixels are replaced by the median value.\n\n'Winsorized Sigma Clipping' is very similar to Sigma Clipping method but it uses an algorithm based on Huber's work [1] [2].\n\n'Linear Fit Clipping' is an algorithm developed by Juan Conejero, main developer of PixInsight [2]. It fits the best straight line (y=ax+b) of the pixel stack and rejects outliers. This algorithm performs very well with large stack and images containing sky gradients with differing spatial distributions and orientations.\n\nThe 'Generalized Extreme Studentized Deviate Test' algorithm [3] is a generalization of Grubbs Test that is used to detect one or more outliers in a univariate data set that follows an approximately normal distribution. This algorithm shows excellent performances with large dataset of more 50 images.\n\n[1] Peter J. Huber and E. Ronchetti (2009), Robust Statistics, 2nd Ed., Wiley\n[2] Juan Conejero, ImageIntegration, Pixinsight Tutorial\n[3] Rosner, Bernard (May 1983), Percentage Points for a Generalized ESD Many-Outlier Procedure, Technometrics, 25(2), pp. 165-172"))
        self.cb_rejtype.SetSelection(3)
        grid_sizer_2.Add(self.cb_rejtype, (2, 1), (1, 1), wx.FIXED_MINSIZE, 0)

        sizer_9 = wx.BoxSizer(wx.HORIZONTAL)
        grid_sizer_2.Add(sizer_9, (2, 2), (1, 2), wx.EXPAND, 0)

        self.l_RejH = wx.StaticText(self, wx.ID_ANY, _("High: "))
        sizer_9.Add(self.l_RejH, 0, wx.LEFT, 5)

        self.e_RejH = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=3.0, min=0.001, max=30.0)
        self.e_RejH.SetIncrement(0.1)
        self.e_RejH.SetDigits(3)
        sizer_9.Add(self.e_RejH, 0, wx.FIXED_MINSIZE, 0)

        self.l_RejL = wx.StaticText(self, wx.ID_ANY, _("Low: "))
        sizer_9.Add(self.l_RejL, 0, wx.LEFT, 5)

        self.e_RejL = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=3.0, min=0.001, max=30.0)
        self.e_RejL.SetIncrement(0.1)
        self.e_RejL.SetDigits(3)
        sizer_9.Add(self.e_RejL, 0, 0, 0)

        self.cb_Weighing = wx.ComboBox(self, wx.ID_ANY, choices=[_("None"), _("Nb of stars"), _("WFWHM"), _("Noise"), _("Nb of images")], style=wx.CB_DROPDOWN)
        self.cb_Weighing.SetToolTip(_("Four methods of weighing are available:\n\n'Number of stars' weighs individual frames based on number of stars computed during registration step.\n\n'Weighted FWHM' weighs individual frames based on wFWHM computed during registration step.\n\n'Noise' weighs individual frames based on background noise values.\n\n'Number of images' weighs individual frames based on their integration time."))
        self.cb_Weighing.SetSelection(0)
        grid_sizer_2.Add(self.cb_Weighing, (2, 6), (1, 1), wx.FIXED_MINSIZE, 0)

        self.cb_Norm = wx.ComboBox(self, wx.ID_ANY, choices=[_("no"), _("add"), _("mul"), _("addscale"), _("mulscale")], style=wx.CB_DROPDOWN)
        self.cb_Norm.SetToolTip(_("If one of these items is selected, a normalisation process will be applied to all input\nimages before stacking.\n\n- Normalisation matches the mean background of all input images, then, the\nnormalisation is processed by multiplication or addition. Keep in mind that both\nprocesses generally lead to similar results but multiplicative normalisation is\nprefered for image which will be used for multiplication or division as flat-field.\n\n- Scale matches dispersion by weighting all input images. This tends to improve\nthe signal-to-noise ratio and therefore this is the option used by default with\nthe additive normalisation.\n\n** The offset and dark masters should not be processed with normalisation.\nHowever, multiplicative normalisation must be used with flat-field frames **"))
        self.cb_Norm.SetSelection(0)
        grid_sizer_2.Add(self.cb_Norm, (2, 7), (1, 1), wx.EXPAND, 0)

        sizer_10.Add((10, 10), 0, 0, 0)

        self.panel_RejectFilt_stack = wx.Panel(self, wx.ID_ANY)
        sizer_10.Add(self.panel_RejectFilt_stack, 0, wx.EXPAND, 0)

        sizer_2 = wx.BoxSizer(wx.VERTICAL)

        self.wRejectFilt_stack = CRejectFilter(self.panel_RejectFilt_stack, wx.ID_ANY)
        sizer_2.Add(self.wRejectFilt_stack, 1, wx.EXPAND, 0)

        sizer_10.Add((10, 10), 0, 0, 0)

        self.panel_moreprop = wx.Panel(self, wx.ID_ANY)
        sizer_10.Add(self.panel_moreprop, 1, wx.EXPAND, 0)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        self.bMoreProp = wx.ToggleButton(self.panel_moreprop, wx.ID_ANY, _("More properties"))
        self.bMoreProp.SetToolTip(_("Display more properties"))
        sizer_1.Add(self.bMoreProp, 0, wx.ALIGN_CENTER_HORIZONTAL, 0)

        self.wMoreProp = CMoreProp(self.panel_moreprop, wx.ID_ANY)
        sizer_1.Add(self.wMoreProp, 1, wx.EXPAND, 0)

        self.panel_moreprop.SetSizer(sizer_1)

        self.panel_RejectFilt_stack.SetSizer(sizer_2)

        grid_sizer_2.AddGrowableRow(0)

        self.SetSizer(sizer_10)
        sizer_10.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CFproperties

class CFlog(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CFlog.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_40 = wx.BoxSizer(wx.VERTICAL)

        self.tlog = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.HSCROLL | wx.TE_DONTWRAP | wx.TE_MULTILINE | wx.TE_READONLY | wx.TE_RICH)
        self.tlog.SetFont(wx.Font(10, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_NORMAL, 0, ""))
        self.tlog.SetFocus()
        sizer_40.Add(self.tlog, 1, wx.EXPAND, 0)

        self.lProgress = wx.TextCtrl(self, wx.ID_ANY, _("..."), style=wx.BORDER_NONE)
        sizer_40.Add(self.lProgress, 0, wx.EXPAND, 0)

        sizer_40.Add((0, 0), 0, 0, 0)

        sizer_41 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_40.Add(sizer_41, 0, wx.EXPAND, 0)

        sizer_41.Add((20, 20), 0, 0, 0)

        l_search = wx.StaticText(self, wx.ID_ANY, _("search:"))
        sizer_41.Add(l_search, 0, wx.RIGHT, 5)

        self.esearch = wx.TextCtrl(self, wx.ID_ANY, "")
        sizer_41.Add(self.esearch, 0, 0, 0)

        self.bsearchprev = wx.Button(self, wx.ID_ANY, _("previous"))
        sizer_41.Add(self.bsearchprev, 0, wx.LEFT, 5)

        self.bsearchnext = wx.Button(self, wx.ID_ANY, _("next"))
        sizer_41.Add(self.bsearchnext, 0, wx.LEFT, 5)

        sizer_41.Add((20, 20), 1, wx.EXPAND, 0)

        self.bclear = wx.Button(self, wx.ID_ANY, _("Clear"))
        sizer_41.Add(self.bclear, 0, 0, 0)

        sizer_41.Add((20, 20), 1, wx.EXPAND, 0)

        self.bSiril = wx.Button(self, wx.ID_ANY, _("Siril"))
        sizer_41.Add(self.bSiril, 0, 0, 0)

        self.SetSizer(sizer_40)
        sizer_40.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CFlog

class CDlgDefaultMaster(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CDlgDefaultMaster.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetSize((600, 180))
        self.SetTitle(_("Setting the default Bias and Dark Masters"))

        sizer_39 = wx.BoxSizer(wx.VERTICAL)

        sizer_47 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Default masters")), wx.HORIZONTAL)
        sizer_39.Add(sizer_47, 1, wx.ALL | wx.EXPAND, 3)

        grid_sizer_2 = wx.GridBagSizer(11, 3)
        sizer_47.Add(grid_sizer_2, 1, wx.EXPAND, 0)

        label_24 = wx.StaticText(self, wx.ID_ANY, _("BIASES : "))
        grid_sizer_2.Add(label_24, (0, 0), (1, 1), 0, 0)

        self.tOffsetMaster = wx.TextCtrl(self, wx.ID_ANY, "")
        self.tOffsetMaster.SetMinSize((460, -1))
        grid_sizer_2.Add(self.tOffsetMaster, (0, 1), (1, 1), wx.EXPAND, 0)

        self.bOffsetMaster = wx.Button(self, wx.ID_ANY, _("..."))
        self.bOffsetMaster.SetMinSize((50, -1))
        grid_sizer_2.Add(self.bOffsetMaster, (0, 2), (1, 1), 0, 0)

        label_25 = wx.StaticText(self, wx.ID_ANY, _("DARK : "))
        grid_sizer_2.Add(label_25, (1, 0), (1, 1), 0, 0)

        self.tDarkMaster = wx.TextCtrl(self, wx.ID_ANY, "")
        self.tDarkMaster.SetMinSize((460, 26))
        grid_sizer_2.Add(self.tDarkMaster, (1, 1), (1, 1), wx.EXPAND, 0)

        self.bDarkMaster = wx.Button(self, wx.ID_ANY, _("..."))
        self.bDarkMaster.SetMinSize((50, -1))
        grid_sizer_2.Add(self.bDarkMaster, (1, 2), (1, 1), 0, 0)

        sizer_48 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_39.Add(sizer_48, 0, wx.EXPAND, 0)

        self.bOkMaster = wx.Button(self, wx.ID_OK, "")
        sizer_48.Add(self.bOkMaster, 0, wx.EXPAND, 0)

        sizer_48.Add((20, 20), 1, wx.EXPAND, 0)

        self.bCancelMaster = wx.Button(self, wx.ID_CANCEL, "")
        sizer_48.Add(self.bCancelMaster, 0, wx.EXPAND, 0)

        self.SetSizer(sizer_39)

        self.Layout()
        # end wxGlade

# end of class CDlgDefaultMaster

class CTagProcess(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CTagProcess.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetSize((500, 300))
        self.SetTitle(_("Process list"))

        sizer_46 = wx.BoxSizer(wx.VERTICAL)

        sizer_49 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_46.Add(sizer_49, 1, wx.EXPAND, 0)

        sizer_50 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, ""), wx.HORIZONTAL)
        sizer_49.Add(sizer_50, 0, wx.EXPAND, 0)

        sizer_52 = wx.BoxSizer(wx.VERTICAL)
        sizer_50.Add(sizer_52, 1, wx.EXPAND, 0)

        self.bSelectAll = wx.Button(self, wx.ID_ANY, _("Select All"))
        sizer_52.Add(self.bSelectAll, 0, 0, 0)

        self.bUnSelectAll = wx.Button(self, wx.ID_ANY, _("Unselect All"))
        sizer_52.Add(self.bUnSelectAll, 0, 0, 0)

        sizer_51 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("Check for active processing")), wx.HORIZONTAL)
        sizer_49.Add(sizer_51, 1, wx.EXPAND, 0)

        self.cklb_tag = wx.CheckListBox(self, wx.ID_ANY, choices=[_("choice 1")], style=wx.LB_ALWAYS_SB | wx.LB_HSCROLL)
        sizer_51.Add(self.cklb_tag, 1, wx.EXPAND, 0)

        sizer_48 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_46.Add(sizer_48, 0, wx.EXPAND, 0)

        self.bOkTagProcess = wx.Button(self, wx.ID_OK, "")
        sizer_48.Add(self.bOkTagProcess, 0, wx.EXPAND, 0)

        sizer_48.Add((20, 20), 1, wx.EXPAND, 0)

        self.bCancelTagProcess = wx.Button(self, wx.ID_CANCEL, "")
        sizer_48.Add(self.bCancelTagProcess, 0, wx.EXPAND, 0)

        self.SetSizer(sizer_46)

        self.Layout()
        # end wxGlade

# end of class CTagProcess

class CRejectFilter(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CRejectFilter.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        self.l_FilterRejection = wx.StaticText(self, wx.ID_ANY, _("Rejecting Filter"))
        self.l_FilterRejection.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_FilterRejection.SetForegroundColour(wx.Colour(255, 255, 255))
        self.l_FilterRejection.SetToolTip(_("Select the set of images to be stacked:\n\n'FWHM': images with best computed FWHM (star-based registration only)\n\n'weighted FWHM': this is an improvement of a simple FWHM. It allows to exclude much more spurious images by using the number of stars detected compared to the reference image (star-based registration only)\n\n'roundness': images with best star roundness (star-based registration only)\n"))
        sizer_1.Add(self.l_FilterRejection, 0, wx.BOTTOM | wx.EXPAND, 5)

        sizer_28 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_1.Add(sizer_28, 1, wx.EXPAND, 0)

        self.l_fwhm_filter = wx.StaticText(self, wx.ID_ANY, _("FWHM: "))
        sizer_28.Add(self.l_fwhm_filter, 0, wx.LEFT, 5)

        self.e_fwhm_filter = wx.TextCtrl(self, wx.ID_ANY, _("90%"), style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_fwhm_filter.SetToolTip(_("empty = no filter\nvalue : filter  on the  fwhm value (ex: fwhm < 4.2 )\npourcentage : filter xx % on the best  fwhm (ex:  95% )"))
        sizer_28.Add(self.e_fwhm_filter, 0, 0, 0)

        self.l_wfwhm_filter = wx.StaticText(self, wx.ID_ANY, _("WFWHM: "))
        sizer_28.Add(self.l_wfwhm_filter, 0, wx.LEFT, 5)

        self.e_wfwhm_filter = wx.TextCtrl(self, wx.ID_ANY, _("90%"), style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_wfwhm_filter.SetToolTip(_("empty = no filter\nvalue : filter  on the  weighted fwhm value (ex: fwhm < 4.2 )\npourcentage : filter xx % on the best weighted fwhm (ex:  95% )"))
        sizer_28.Add(self.e_wfwhm_filter, 0, 0, 0)

        self.l_bkg_filter = wx.StaticText(self, wx.ID_ANY, _("Background:"))
        sizer_28.Add(self.l_bkg_filter, 0, wx.LEFT, 5)

        self.e_bkg_filter = wx.TextCtrl(self, wx.ID_ANY, _("90%"), style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_bkg_filter.SetToolTip(_("images with lowest background values (star-based registration only)\nempty = no filter\nvalue : filter  on the  value (ex: background < 4.2 )\npourcentage : filter xx % on the lowest background (ex:  95% )\n"))
        sizer_28.Add(self.e_bkg_filter, 0, 0, 0)

        self.l_round_filter = wx.StaticText(self, wx.ID_ANY, _("Round: "))
        sizer_28.Add(self.l_round_filter, 0, wx.LEFT, 5)

        self.e_round_filter = wx.TextCtrl(self, wx.ID_ANY, _("85%"), style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_round_filter.SetToolTip(_("empty = no filter\nvalue [0.0-1.0] : filter  on the roundness value (ex: roundness > 0.8 )\npourcentage : filter xx % on the best  roundness (ex:  95% )\n"))
        sizer_28.Add(self.e_round_filter, 0, 0, 0)

        self.l_quality_filter = wx.StaticText(self, wx.ID_ANY, _("Quality: "))
        sizer_28.Add(self.l_quality_filter, 0, wx.LEFT, 5)

        self.e_quality_filter = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_quality_filter.SetToolTip(_("empty =no filter \nvalue [0.0-1.0] : filter  on the quality value (ex: quality > 0.8 )\npourcentage : filter xx % on the best  quality (ex:  95% )\n** for the planetary only **\n"))
        sizer_28.Add(self.e_quality_filter, 0, 0, 0)

        self.l_nb_stars_filter = wx.StaticText(self, wx.ID_ANY, _("Number stars:"))
        sizer_28.Add(self.l_nb_stars_filter, 0, wx.LEFT, 5)

        self.e_nb_stars_filter = wx.TextCtrl(self, wx.ID_ANY, _("90%"), style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_nb_stars_filter.SetToolTip(_("images with best number of stars detected (star-based registration only)\nempty = no filter\nvalue : filter  on the  value (ex: number > 42 )\npourcentage : filter xx % on the best number of stars detected (ex:  95% )\n"))
        sizer_28.Add(self.e_nb_stars_filter, 0, 0, 0)

        self.SetSizer(sizer_1)
        sizer_1.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CRejectFilter

class CSubSky(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CSubSky.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        self.l_SubSky = wx.StaticText(self, wx.ID_ANY, _("SubSky"))
        self.l_SubSky.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.l_SubSky.SetForegroundColour(wx.Colour(0, 0, 0))
        self.l_SubSky.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        self.l_SubSky.SetToolTip(_("Computes a synthetic background gradient using either the polynomial function \nmodel of 'degree' degrees or the RBF model (if '-rbf' is provided instead) \nand subtracts it from the image. The number of samples per horizontal line and \nthe tolerance to exclude brighter areas can be adjusted with the optional arguments. \nTolerance is in mad units: median + tolerance * mad. \nFor RBF, the additional smoothing parameter is also available"))
        sizer_1.Add(self.l_SubSky, 0, wx.BOTTOM | wx.EXPAND, 5)

        sizer_31 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_1.Add(sizer_31, 0, wx.EXPAND, 0)

        self.cb_rbf = wx.CheckBox(self, wx.ID_ANY, _("RBF:"), style=wx.ALIGN_RIGHT)
        sizer_31.Add(self.cb_rbf, 0, 0, 0)

        self.l_Degree = wx.StaticText(self, wx.ID_ANY, _("degree:"))
        sizer_31.Add(self.l_Degree, 0, wx.LEFT, 5)

        self.spDegree = wx.SpinCtrl(self, wx.ID_ANY, "0", min=0, max=10)
        self.spDegree.SetToolTip(_("Computes the level of the local sky background thanks to a polynomial function of an order degree and subtracts it from the image"))
        sizer_31.Add(self.spDegree, 0, 0, 0)

        self.l_Samples = wx.StaticText(self, wx.ID_ANY, _("samples:"))
        sizer_31.Add(self.l_Samples, 0, wx.LEFT, 5)

        self.spSamples = wx.SpinCtrl(self, wx.ID_ANY, "20", min=0, max=100)
        self.spSamples.SetToolTip(_("number of samples per horizontal line"))
        sizer_31.Add(self.spSamples, 0, 0, 0)

        self.l_Tolerance = wx.StaticText(self, wx.ID_ANY, _("tolerance:"))
        sizer_31.Add(self.l_Tolerance, 0, wx.LEFT, 5)

        self.spTolerance = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=1.0, min=0.0, max=10.0)
        self.spTolerance.SetToolTip(_("the tolerance to exclude brighter areas can be adjusted with the optional arguments. \nTolerance is in mad units: \nmedian + tolerance * mad.\n"))
        self.spTolerance.SetDigits(2)
        sizer_31.Add(self.spTolerance, 0, 0, 0)

        self.l_Smooth = wx.StaticText(self, wx.ID_ANY, _("smoothing:"))
        self.l_Smooth.Hide()
        sizer_31.Add(self.l_Smooth, 0, wx.LEFT, 5)

        self.spSmooth = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.5, min=0.0, max=1.0)
        self.spSmooth.SetToolTip(_("For RBF, the additional smoothing parameter"))
        self.spSmooth.Hide()
        self.spSmooth.SetDigits(2)
        sizer_31.Add(self.spSmooth, 0, 0, 0)

        self.SetSizer(sizer_1)
        sizer_1.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CSubSky

class CFilesSelection(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CFilesSelection.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        grid_sizer_8 = wx.GridBagSizer(0, 0)
        sizer_1.Add(grid_sizer_8, 1, wx.EXPAND, 0)

        self.lb_file = wx.ListBox(self, wx.ID_ANY, choices=[_("choice 1")], style=wx.LB_HSCROLL | wx.LB_SINGLE | wx.LB_SORT)
        self.lb_file.SetToolTip(_("add the image files"))
        self.lb_file.SetSelection(0)
        grid_sizer_8.Add(self.lb_file, (0, 0), (5, 1), wx.EXPAND | wx.FIXED_MINSIZE, 0)

        self.bAdd_file = wx.Button(self, wx.ID_ANY, _("ADD"))
        self.bAdd_file.SetToolTip(_("Add a file in the list"))
        grid_sizer_8.Add(self.bAdd_file, (0, 1), (1, 1), wx.ALIGN_CENTER, 0)

        self.bEdit_file = wx.Button(self, wx.ID_ANY, _("EDIT"))
        self.bEdit_file.SetToolTip(_("Edit a file in the list"))
        grid_sizer_8.Add(self.bEdit_file, (1, 1), (1, 1), wx.ALIGN_CENTER, 0)

        grid_sizer_8.Add(20, 20, (2, 1), (1, 1), 0, 0)

        self.bDEL_file = wx.Button(self, wx.ID_ANY, _("DELETE"))
        self.bDEL_file.SetToolTip(_("Delete a file of the list"))
        grid_sizer_8.Add(self.bDEL_file, (3, 1), (1, 1), wx.ALIGN_CENTER, 0)

        self.bCLR_file = wx.Button(self, wx.ID_ANY, _("CLEAR"))
        self.bCLR_file.SetToolTip(_("Clear all files"))
        grid_sizer_8.Add(self.bCLR_file, (4, 1), (1, 1), wx.ALIGN_CENTER, 0)

        grid_sizer_8.AddGrowableCol(0)

        self.SetSizer(sizer_1)
        sizer_1.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CFilesSelection

class CMoreProp(wx.Panel):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CMoreProp.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_FRAME_STYLE
        wx.Panel.__init__(self, *args, **kwds)

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        sizer_findstar = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_findstar, 0, wx.ALL | wx.EXPAND, 1)

        self.cb_findstar = wx.CheckBox(self, wx.ID_ANY, _("Star finding"), style=wx.CHK_2STATE)
        self.cb_findstar.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.cb_findstar.SetForegroundColour(wx.Colour(0, 0, 0))
        self.cb_findstar.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_findstar.Add(self.cb_findstar, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_4 = wx.GridBagSizer(5, 5)
        sizer_findstar.Add(grid_sizer_4, 1, wx.EXPAND, 0)

        self.l_sigma_findstar = wx.StaticText(self, wx.ID_ANY, _("sigma"))
        self.l_sigma_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_sigma_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_sigma_findstar, (0, 0), (1, 1), wx.EXPAND, 0)

        self.l_roundness_findstar = wx.StaticText(self, wx.ID_ANY, _("roundness"))
        self.l_roundness_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_roundness_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_roundness_findstar, (0, 1), (1, 1), wx.EXPAND, 0)

        self.l_radius_findstar = wx.StaticText(self, wx.ID_ANY, _("radius"))
        self.l_radius_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_radius_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_radius_findstar, (0, 2), (1, 1), wx.EXPAND, 0)

        self.l_convergence_findstar = wx.StaticText(self, wx.ID_ANY, _("convergence"))
        self.l_convergence_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_convergence_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_convergence_findstar, (0, 3), (1, 1), wx.EXPAND, 0)

        self.l_focal_findstar = wx.StaticText(self, wx.ID_ANY, _("focal"))
        self.l_focal_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_focal_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_focal_findstar, (0, 4), (1, 1), wx.EXPAND, 0)

        self.l_pixel_findstar = wx.StaticText(self, wx.ID_ANY, _("pixel size"))
        self.l_pixel_findstar.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_pixel_findstar.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_pixel_findstar, (0, 5), (1, 1), wx.EXPAND, 0)

        self.l_amplitude_Star = wx.StaticText(self, wx.ID_ANY, _("amplitude limit of stars"))
        self.l_amplitude_Star.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_amplitude_Star.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_4.Add(self.l_amplitude_Star, (0, 8), (1, 2), wx.EXPAND, 0)

        self.e_sigma_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=1.0, min=0.05, max=30.0)
        self.e_sigma_findstar.SetToolTip(_("threshold above noise and must be greater or equal to 0.05."))
        self.e_sigma_findstar.SetIncrement(0.05)
        self.e_sigma_findstar.SetDigits(2)
        self.e_sigma_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_sigma_findstar, (1, 0), (1, 1), 0, 0)

        self.e_roundness_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.5, min=0.1, max=0.95)
        self.e_roundness_findstar.SetIncrement(0.05)
        self.e_roundness_findstar.SetDigits(2)
        self.e_roundness_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_roundness_findstar, (1, 1), (1, 1), 0, 0)

        self.e_radius_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=3.0, min=3.0, max=50.0)
        self.e_radius_findstar.SetToolTip(_(" radius  of the initial search box and must be between 3 and 50."))
        self.e_radius_findstar.SetDigits(2)
        self.e_radius_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_radius_findstar, (1, 2), (1, 1), 0, 0)

        self.e_convergence_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=1.0, min=1.0, max=3.0)
        self.e_convergence_findstar.SetToolTip(_("number of iterations performed to fit PSF and should be set between 1 and 3 (more tolerant)."))
        self.e_convergence_findstar.SetDigits(1)
        self.e_convergence_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_convergence_findstar, (1, 3), (1, 1), 0, 0)

        self.e_focal_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.0, min=0.0, max=5000.0)
        self.e_focal_findstar.SetToolTip(_("the focal length of the telescope (mm)\n0 = takes the focal length from the file"))
        self.e_focal_findstar.SetDigits(4)
        self.e_focal_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_focal_findstar, (1, 4), (1, 1), 0, 0)

        self.e_pixel_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.0, min=0.0, max=20.0)
        self.e_pixel_findstar.SetToolTip(_(u"the pixel size of the sensor. (µm)\n0 = takes the pixel size from the file"))
        self.e_pixel_findstar.SetIncrement(0.01)
        self.e_pixel_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_pixel_findstar, (1, 5), (1, 1), 0, 0)

        self.cb_relax_findstar = wx.CheckBox(self, wx.ID_ANY, _("relax"), style=wx.CHK_2STATE)
        self.cb_relax_findstar.SetToolTip(_("relaxes the checks that are done on star candidates to assess if they are stars or not, to allow objects not shaped like stars to still be  accepted (off by default)"))
        grid_sizer_4.Add(self.cb_relax_findstar, (1, 6), (1, 1), wx.ALIGN_CENTER, 0)

        self.l_minA_findstar = wx.StaticText(self, wx.ID_ANY, _("min :"))
        grid_sizer_4.Add(self.l_minA_findstar, (1, 8), (1, 1), wx.ALIGN_RIGHT, 0)

        self.e_minA_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.0, min=0.0, max=1.0)
        self.e_minA_findstar.SetToolTip(_("minimum amplitude of stars to keep, normalized between 0 and 1."))
        self.e_minA_findstar.SetIncrement(0.01)
        self.e_minA_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_minA_findstar, (1, 9), (1, 1), 0, 0)

        self.l_solver_findstar = wx.StaticText(self, wx.ID_ANY, _("solver: "))
        grid_sizer_4.Add(self.l_solver_findstar, (2, 3), (1, 1), wx.ALIGN_RIGHT, 0)

        self.cb_solver_findstar = wx.ComboBox(self, wx.ID_ANY, choices=[_("gaussian"), _("moffat")], style=wx.CB_DROPDOWN)
        self.cb_solver_findstar.SetToolTip(_("configure the solver model to be used."))
        self.cb_solver_findstar.SetSelection(0)
        grid_sizer_4.Add(self.cb_solver_findstar, (2, 4), (1, 1), wx.FIXED_MINSIZE, 0)

        self.l_minbeta_findstar = wx.StaticText(self, wx.ID_ANY, _(u"Min bêta :"))
        grid_sizer_4.Add(self.l_minbeta_findstar, (2, 5), (1, 1), wx.ALIGN_RIGHT, 0)

        self.e_minbeta_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=1.0, min=0.0, max=10.0)
        self.e_minbeta_findstar.SetToolTip(_("If Moffat is selected, 'minbeta=' defines the minimum value of beta for which  candidate stars will be accepted and must be greater or equal to 0.0 and less than 10.0"))
        self.e_minbeta_findstar.SetIncrement(0.1)
        self.e_minbeta_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_minbeta_findstar, (2, 6), (1, 1), 0, 0)

        self.l_maxA_findstar = wx.StaticText(self, wx.ID_ANY, _("max :"))
        grid_sizer_4.Add(self.l_maxA_findstar, (2, 8), (1, 1), wx.ALIGN_RIGHT, 0)

        self.e_maxA_findstar = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.0, min=0.0, max=1.0)
        self.e_maxA_findstar.SetToolTip(_("maximum amplitude of stars to keep, normalized between 0 and 1."))
        self.e_maxA_findstar.SetIncrement(0.01)
        self.e_maxA_findstar.SetDigits(1)
        grid_sizer_4.Add(self.e_maxA_findstar, (2, 9), (1, 1), 0, 0)

        sizer_1.Add((10, 10), 0, 0, 0)

        sizer_register = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_register, 0, wx.ALL | wx.EXPAND, 1)

        self.l_Registering = wx.StaticText(self, wx.ID_ANY, _("Registering"))
        self.l_Registering.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.l_Registering.SetForegroundColour(wx.Colour(0, 0, 0))
        self.l_Registering.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_register.Add(self.l_Registering, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_5 = wx.GridBagSizer(5, 5)
        sizer_register.Add(grid_sizer_5, 1, wx.EXPAND, 0)

        self.l_transf = wx.StaticText(self, wx.ID_ANY, _("Transformation"))
        self.l_transf.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_transf.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_5.Add(self.l_transf, (0, 0), (1, 1), wx.EXPAND, 0)

        self.l_PixInterpo = wx.StaticText(self, wx.ID_ANY, _("Interpolation"))
        self.l_PixInterpo.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_PixInterpo.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_5.Add(self.l_PixInterpo, (0, 1), (1, 1), wx.EXPAND, 0)

        self.l_RegLayer = wx.StaticText(self, wx.ID_ANY, _("Layer"))
        self.l_RegLayer.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_RegLayer.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_5.Add(self.l_RegLayer, (0, 2), (1, 1), wx.EXPAND, 0)

        self.cb_transf = wx.ComboBox(self, wx.ID_ANY, choices=["", _("shift"), _("similarity"), _("affine"), _("homography")], style=wx.CB_DROPDOWN)
        self.cb_transf.SetToolTip(_("The option specifies the type of transformation to compute:\no shift : a 2 degrees of freedom (dof), X and Y translation, rigid transform (can be used with -noout to not create a new sequence, and still be stacked directly)\no similarity: a 4 dof transform, X and Y translation, a scale and rotation\no affine: a 6 dof transform, X and Y translation, two scales, one shear and rotation\no homography (default): a 8 dof warping transform\n*** empty = default value of siril ***"))
        self.cb_transf.SetSelection(0)
        grid_sizer_5.Add(self.cb_transf, (1, 0), (1, 1), wx.FIXED_MINSIZE, 0)

        self.cb_PixInterpo = wx.ComboBox(self, wx.ID_ANY, choices=["", _("none"), _("nearest"), _("cubic"), _("lanczos4"), _("linear"), _("area")], style=wx.CB_DROPDOWN)
        self.cb_PixInterpo.SetToolTip(_("during image transformation, the pixel interpolation method can be specified. If none is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation. This option is unused if the output sequence is not created. \n*** empty = default value of siril ***"))
        self.cb_PixInterpo.SetSelection(0)
        grid_sizer_5.Add(self.cb_PixInterpo, (1, 1), (1, 1), wx.FIXED_MINSIZE, 0)

        self.cb_RegLayer = wx.ComboBox(self, wx.ID_ANY, choices=[_("layer 0"), _("layer 0 (R)"), _("layer 1 (G)"), _("layer 2 (B)")], style=wx.CB_DROPDOWN)
        self.cb_RegLayer.SetToolTip(_("The registration is done on the first layer for which data exists for RGB images unless specified option (0, 1 or 2 for R, G and B respectively."))
        self.cb_RegLayer.SetSelection(0)
        grid_sizer_5.Add(self.cb_RegLayer, (1, 2), (1, 1), wx.FIXED_MINSIZE, 0)

        self.cb_norot = wx.CheckBox(self, wx.ID_ANY, _("no rotate"), style=wx.CHK_2STATE)
        grid_sizer_5.Add(self.cb_norot, (1, 3), (1, 1), wx.EXPAND, 0)

        self.cb_RegDrizzle = wx.CheckBox(self, wx.ID_ANY, _("Drizzle "), style=wx.CHK_2STATE)
        self.cb_RegDrizzle.SetToolTip(_("The option activates the sub-pixel stacking by up-scaling by 2 the generated images or by setting a flag that will proceed to the up-scaling during stacking if -transf=shift -noout are passed"))
        grid_sizer_5.Add(self.cb_RegDrizzle, (1, 4), (1, 1), 0, 0)

        self.e_minpairs = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_minpairs.SetToolTip(_("empty = default value of siril\nan integer that specify the minimum number of star pairs a frame must have with the reference frame, otherwise the frame will be dropped."))
        grid_sizer_5.Add(self.e_minpairs, (1, 5), (1, 1), wx.ALIGN_RIGHT, 0)

        self.l_minpairs = wx.StaticText(self, wx.ID_ANY, _("min.  star pairs"), style=wx.ALIGN_RIGHT)
        grid_sizer_5.Add(self.l_minpairs, (1, 6), (1, 1), 0, 0)

        self.cb_2pass = wx.CheckBox(self, wx.ID_ANY, _("2 pass"), style=wx.CHK_2STATE)
        self.cb_2pass.SetToolTip(_("adds a preliminary pass to the registration, first detecting stars and choosing the best reference frame using a function based on FWHM and the number of stars, then computing the transforms of all frames relative to this new reference."))
        grid_sizer_5.Add(self.cb_2pass, (2, 0), (1, 1), wx.EXPAND, 0)

        self.cb_noout = wx.CheckBox(self, wx.ID_ANY, _("no out"), style=wx.CHK_2STATE)
        self.cb_noout.SetToolTip(_("disables saving the star lists to disk."))
        grid_sizer_5.Add(self.cb_noout, (2, 1), (1, 1), wx.EXPAND, 0)

        self.cb_noclamp = wx.CheckBox(self, wx.ID_ANY, _("no clamping"), style=wx.CHK_2STATE)
        self.cb_noclamp.SetToolTip(_("Clamping of the bicubic and lanczos4 interpolation methods is the default, \nto avoid artefacts, but can be disabled."))
        grid_sizer_5.Add(self.cb_noclamp, (2, 2), (1, 1), wx.EXPAND, 0)

        self.cb_selected = wx.CheckBox(self, wx.ID_ANY, _("selected"), style=wx.CHK_2STATE)
        self.cb_selected.SetToolTip(_("the option excludes images will not be processed"))
        grid_sizer_5.Add(self.cb_selected, (2, 3), (1, 1), wx.EXPAND, 0)

        self.cb_nostarslist = wx.CheckBox(self, wx.ID_ANY, _("no stars list"), style=wx.CHK_2STATE)
        self.cb_nostarslist.SetToolTip(_("disables saving the star lists to disk."))
        grid_sizer_5.Add(self.cb_nostarslist, (2, 4), (1, 1), wx.EXPAND, 0)

        self.e_maxstars = wx.TextCtrl(self, wx.ID_ANY, "", style=wx.TE_NO_VSCROLL | wx.TE_RIGHT)
        self.e_maxstars.SetToolTip(_("empty = default value of siril\nan integer that specify the maximum number of star to find within each frame (must be between 100 and 2000). With more stars, a more accurate registration can be computed, but will take more time to run."))
        grid_sizer_5.Add(self.e_maxstars, (2, 5), (1, 1), wx.ALIGN_RIGHT, 0)

        self.l_maxstars = wx.StaticText(self, wx.ID_ANY, _("max  stars"), style=wx.ALIGN_RIGHT)
        grid_sizer_5.Add(self.l_maxstars, (2, 6), (1, 2), 0, 0)

        sizer_1.Add((10, 10), 0, 0, 0)

        sizer_seqreg = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_seqreg, 0, wx.EXPAND, 0)

        self.cb_SeqRegistering = wx.CheckBox(self, wx.ID_ANY, _("Sequence Registering"), style=wx.CHK_2STATE)
        self.cb_SeqRegistering.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.cb_SeqRegistering.SetForegroundColour(wx.Colour(0, 0, 0))
        self.cb_SeqRegistering.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_seqreg.Add(self.cb_SeqRegistering, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_6 = wx.GridBagSizer(5, 5)
        sizer_seqreg.Add(grid_sizer_6, 1, 0, 0)

        self.l_autoframing = wx.StaticText(self, wx.ID_ANY, _("Auto framing"), style=wx.ALIGN_CENTER_HORIZONTAL)
        self.l_autoframing.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_autoframing.SetForegroundColour(wx.Colour(255, 255, 255))
        self.l_autoframing.SetToolTip(_("'max' (bounding box) adds a black border around each image as required  so that no part of the image is cropped when registered.\n\n'min' (common area) crops each image to the area it has in common with all images of the sequence.\n\n'cog' determines the best  framing position as the center of gravity (cog) of all the images."))
        grid_sizer_6.Add(self.l_autoframing, (0, 0), (1, 1), wx.EXPAND | wx.SHAPED, 0)

        self.l_SeqInterpo = wx.StaticText(self, wx.ID_ANY, _("Interpolation"), style=wx.ALIGN_CENTER_HORIZONTAL)
        self.l_SeqInterpo.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_SeqInterpo.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_6.Add(self.l_SeqInterpo, (0, 1), (1, 1), wx.EXPAND | wx.SHAPED, 0)

        self.l_SeqLayer = wx.StaticText(self, wx.ID_ANY, _("Layer"), style=wx.ALIGN_CENTER_HORIZONTAL)
        self.l_SeqLayer.SetBackgroundColour(wx.Colour(143, 143, 188))
        self.l_SeqLayer.SetForegroundColour(wx.Colour(255, 255, 255))
        grid_sizer_6.Add(self.l_SeqLayer, (0, 2), (1, 1), wx.EXPAND | wx.SHAPED, 0)

        self.cb_SeqNoclamp = wx.CheckBox(self, wx.ID_ANY, _("no clamping"), style=wx.CHK_2STATE)
        self.cb_SeqNoclamp.SetToolTip(_("Clamping of the bicubic and lanczos4 interpolation methods is the default, \nto avoid artefacts, but can be disabled."))
        grid_sizer_6.Add(self.cb_SeqNoclamp, (0, 7), (1, 1), wx.EXPAND, 0)

        self.cb_autoframing = wx.ComboBox(self, wx.ID_ANY, choices=[_("current"), _("min"), _("max"), _("cog")], style=wx.CB_DROPDOWN)
        self.cb_autoframing.SetToolTip(_("Automatic framing of the output sequence can be specified using:\n\no max: (bounding box) adds a black border around each image as  required so that no part of the image is cropped when registered.\n\no min : (common area) crops each image to the area it has in common with all images of the sequence.\n                    \no cog: determines the best framing position as the center of gravity (cog) of all the images."))
        self.cb_autoframing.SetSelection(3)
        grid_sizer_6.Add(self.cb_autoframing, (1, 0), (1, 1), wx.EXPAND, 0)

        self.cb_SeqInterpo = wx.ComboBox(self, wx.ID_ANY, choices=["", _("none"), _("nearest"), _("cubic"), _("lanczos4"), _("linear"), _("area")], style=wx.CB_DROPDOWN)
        self.cb_SeqInterpo.SetToolTip(_("during image transformation, the pixel interpolation method can be specified. If none is passed, the transformation is forced to shift and a pixel-wise shift is applied to each image without any interpolation. This option is unused if the output sequence is not created. \n*** empty = default value of siril ***"))
        self.cb_SeqInterpo.SetSelection(0)
        grid_sizer_6.Add(self.cb_SeqInterpo, (1, 1), (1, 1), wx.EXPAND, 0)

        self.cb_SeqLayer = wx.ComboBox(self, wx.ID_ANY, choices=[_("layer 0"), _("layer 0 (R)"), _("layer 1 (G)"), _("layer 2 (B)")], style=wx.CB_DROPDOWN)
        self.cb_SeqLayer.SetToolTip(_("The registration is done on the first layer for which data exists for RGB images unless specified option (0, 1 or 2 for R, G and B respectively."))
        self.cb_SeqLayer.SetSelection(0)
        grid_sizer_6.Add(self.cb_SeqLayer, (1, 2), (1, 1), wx.EXPAND, 0)

        self.cb_SeqDrizzle = wx.CheckBox(self, wx.ID_ANY, _("drizzle"), style=wx.CHK_2STATE)
        self.cb_SeqDrizzle.SetToolTip(_("activates up-scaling by 2 the images created in the transformed \nsequence."))
        grid_sizer_6.Add(self.cb_SeqDrizzle, (1, 7), (1, 1), wx.EXPAND, 0)

        sizer_seqreg.Add((10, 10), 0, 0, 0)

        self.panel_1 = wx.Panel(self, wx.ID_ANY)
        sizer_seqreg.Add(self.panel_1, 0, wx.EXPAND, 0)

        sizer_2 = wx.BoxSizer(wx.VERTICAL)

        self.wRejectFilt_seqreg = CRejectFilter(self.panel_1, wx.ID_ANY)
        sizer_2.Add(self.wRejectFilt_seqreg, 1, wx.EXPAND, 0)

        sizer_seqreg.Add((10, 10), 0, 0, 0)

        self.panel_subsky = wx.Panel(self, wx.ID_ANY)
        sizer_seqreg.Add(self.panel_subsky, 1, wx.EXPAND, 0)

        sizer_3 = wx.BoxSizer(wx.VERTICAL)

        self.wSubSky = CSubSky(self.panel_subsky, wx.ID_ANY)
        sizer_3.Add(self.wSubSky, 1, wx.EXPAND, 0)

        sizer_platesolve = wx.BoxSizer(wx.VERTICAL)
        sizer_1.Add(sizer_platesolve, 1, wx.EXPAND, 0)

        self.l_Platesolving = wx.StaticText(self, wx.ID_ANY, _("Platesolving"))
        self.l_Platesolving.SetBackgroundColour(wx.Colour(188, 183, 161))
        self.l_Platesolving.SetForegroundColour(wx.Colour(0, 0, 0))
        self.l_Platesolving.SetFont(wx.Font(12, wx.FONTFAMILY_DEFAULT, wx.FONTSTYLE_NORMAL, wx.FONTWEIGHT_BOLD, 0, ""))
        sizer_platesolve.Add(self.l_Platesolving, 0, wx.BOTTOM | wx.EXPAND, 5)

        grid_sizer_1 = wx.GridBagSizer(0, 0)
        sizer_platesolve.Add(grid_sizer_1, 1, wx.EXPAND, 0)

        self.rb_platesolve = wx.RadioBox(self, wx.ID_ANY, _("Apply platesolve"), choices=[_("Disable"), _("Final image"), _("After Registering"), _("Before Registering")], majorDimension=4, style=wx.RA_SPECIFY_COLS)
        self.rb_platesolve.SetSelection(0)
        grid_sizer_1.Add(self.rb_platesolve, (0, 0), (1, 4), 0, 0)

        self.cb_noflip = wx.CheckBox(self, wx.ID_ANY, _("no flip"))
        self.cb_noflip.SetToolTip(_("Unless -noflip is specified, if the image is detected as being upside-down, it will be flipped."))
        grid_sizer_1.Add(self.cb_noflip, (0, 5), (1, 1), wx.LEFT, 5)

        self.cb_forceplatesolve = wx.CheckBox(self, wx.ID_ANY, _("force platesolve"))
        self.cb_forceplatesolve.SetToolTip(_("If the image has already been plate solved nothing will be done, unless the -platesolve argument is passed to force a new solve."))
        grid_sizer_1.Add(self.cb_forceplatesolve, (0, 6), (1, 1), wx.LEFT, 5)

        self.cb_downscale = wx.CheckBox(self, wx.ID_ANY, _("downscale"))
        self.cb_downscale.SetToolTip(_("For faster star detection in big images, downsampling the image is possible with -downscale."))
        grid_sizer_1.Add(self.cb_downscale, (0, 7), (1, 1), wx.LEFT, 5)

        self.cb_localasnet = wx.CheckBox(self, wx.ID_ANY, _("localasnet"))
        self.cb_localasnet.SetToolTip(_("Images can be either plate solved by Siril using a star catalog and the global registration algorithm or by astrometry.net's local solve-field command (enabled with -localasnet)."))
        grid_sizer_1.Add(self.cb_localasnet, (0, 8), (1, 1), 0, 0)

        l_focal = wx.StaticText(self, wx.ID_ANY, _("focal"), style=wx.ALIGN_CENTER_HORIZONTAL)
        l_focal.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_focal.SetForegroundColour(wx.Colour(255, 255, 255))
        l_focal.SetToolTip(_("the focal length of the telescope (mm)\n0 = takes the focal length from the file"))
        grid_sizer_1.Add(l_focal, (1, 0), (1, 1), wx.EXPAND, 0)

        l_pixesize = wx.StaticText(self, wx.ID_ANY, _("pixel size"), style=wx.ALIGN_CENTER_HORIZONTAL)
        l_pixesize.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_pixesize.SetForegroundColour(wx.Colour(255, 255, 255))
        l_pixesize.SetToolTip(_(u"the pixel size of the sensor. (µm)\n0 = takes the pixel size from the file"))
        grid_sizer_1.Add(l_pixesize, (1, 1), (1, 1), wx.EXPAND, 0)

        l_coord = wx.StaticText(self, wx.ID_ANY, _("image center"), style=wx.ALIGN_CENTER_HORIZONTAL)
        l_coord.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_coord.SetForegroundColour(wx.Colour(255, 255, 255))
        l_coord.SetToolTip(_("If WCS or other image metadata is erroneous or missing, arguments must be passed: the approximate image center coordinates can be provided in decimal degrees or degree/hour minute second values (J2000 with colon separators), with right ascension and declination values separated by a comma or a space (not mandatory for astrometry.net).\ne.g. for NGC281 : 0:52:59,56:37:19"))
        grid_sizer_1.Add(l_coord, (1, 2), (1, 1), wx.EXPAND, 0)

        l_limitmag = wx.StaticText(self, wx.ID_ANY, _("limit  mag."))
        l_limitmag.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_limitmag.SetForegroundColour(wx.Colour(255, 255, 255))
        l_limitmag.SetToolTip(_("The limit magnitude of stars used for plate solving is automatically computed from the size of the field of view, but can be altered by passing a +offset or -offset value to -limitmag=, or simply an absolute positive value for the limit magnitude."))
        grid_sizer_1.Add(l_limitmag, (1, 5), (1, 1), wx.EXPAND, 0)

        l_catalog = wx.StaticText(self, wx.ID_ANY, _("catalog"))
        l_catalog.SetBackgroundColour(wx.Colour(143, 143, 188))
        l_catalog.SetForegroundColour(wx.Colour(255, 255, 255))
        l_catalog.SetToolTip(_("The choice of the star catalog is automatic if  -catalog=None option is passed\nIf the option is passed, it forces the use of the remote catalog given in argument, with possible values: tycho2, nomad, gaia, ppmxl, brightstars, apass"))
        grid_sizer_1.Add(l_catalog, (1, 6), (1, 1), wx.EXPAND, 0)

        self.sp_focal = wx.SpinCtrl(self, wx.ID_ANY, "0", min=0, max=30000)
        self.sp_focal.SetToolTip(_("focal length in  millimeter\n0 = takes the focal length from the file"))
        grid_sizer_1.Add(self.sp_focal, (2, 0), (1, 1), 0, 0)

        self.sp_pixelsize = wx.SpinCtrlDouble(self, wx.ID_ANY, initial=0.0, min=0.0, max=20.0)
        self.sp_pixelsize.SetToolTip(_(u"the pixel size of the sensor. (µm)\n0 = takes the pixel size from the file"))
        self.sp_pixelsize.SetDigits(2)
        grid_sizer_1.Add(self.sp_pixelsize, (2, 1), (1, 1), 0, 0)

        self.t_coord = wx.TextCtrl(self, wx.ID_ANY, "")
        self.t_coord.SetToolTip(_("If WCS or other image metadata is erroneous or missing, arguments must be passed: the approximate image center coordinates can be provided in decimal degrees or degree/hour minute second values (J2000 with colon separators), with right ascension and declination values separated by a comma or a space (not mandatory for astrometry.net).\ne.g. for NGC281 : 0:52:59,56:37:19"))
        grid_sizer_1.Add(self.t_coord, (2, 2), (1, 1), 0, 0)

        self.b_find = wx.Button(self, wx.ID_ANY, _("object"))
        self.b_find.SetToolTip(_("find object coordinates"))
        grid_sizer_1.Add(self.b_find, (2, 3), (1, 1), 0, 0)

        self.t_limitmag = wx.TextCtrl(self, wx.ID_ANY, "")
        self.t_limitmag.SetToolTip(_("The limit magnitude of stars used for plate solving is automatically computed from the size of the field of view, but can be altered by passing a +offset or -offset value to -limitmag=, or simply an absolute positive value for the limit magnitude."))
        grid_sizer_1.Add(self.t_limitmag, (2, 5), (1, 1), 0, 0)

        self.lb_catalog = wx.ComboBox(self, wx.ID_ANY, choices=[_("auto"), _("tycho2"), _("nomad"), _("gaia"), _("ppmxl"), _("brightstars"), _("apass")], style=wx.CB_DROPDOWN)
        self.lb_catalog.SetToolTip(_("The choice of the star catalog is automatic if  -catalog=None option is passed\nIf the option is passed, it forces the use of the remote catalog given in argument, with possible values: tycho2, nomad, gaia, ppmxl, brightstars, apass"))
        self.lb_catalog.SetSelection(0)
        grid_sizer_1.Add(self.lb_catalog, (2, 6), (1, 1), 0, 0)

        self.panel_subsky.SetSizer(sizer_3)

        self.panel_1.SetSizer(sizer_2)

        grid_sizer_6.AddGrowableRow(0)

        grid_sizer_5.AddGrowableRow(0)

        grid_sizer_4.AddGrowableRow(0)

        self.SetSizer(sizer_1)
        sizer_1.Fit(self)

        self.Layout()
        # end wxGlade

# end of class CMoreProp

class CPatternFilesDlg(wx.Dialog):
    def __init__(self, *args, **kwds):
        # begin wxGlade: CPatternFilesDlg.__init__
        kwds["style"] = kwds.get("style", 0) | wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.SetSize((300, -1))
        self.SetTitle(_("Pattern Files Brower"))

        sizer_1 = wx.BoxSizer(wx.VERTICAL)

        sizer_4 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("root directory")), wx.HORIZONTAL)
        sizer_1.Add(sizer_4, 0, wx.EXPAND, 0)

        sizer_5 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_4.Add(sizer_5, 1, wx.EXPAND, 0)

        self.eRoot = wx.TextCtrl(self, wx.ID_ANY, "")
        sizer_5.Add(self.eRoot, 1, wx.EXPAND, 0)

        self.bRoot = wx.Button(self, wx.ID_ANY, _(" ... "))
        sizer_5.Add(self.bRoot, 0, wx.FIXED_MINSIZE, 0)

        sizer_6 = wx.StaticBoxSizer(wx.StaticBox(self, wx.ID_ANY, _("pattern")), wx.HORIZONTAL)
        sizer_1.Add(sizer_6, 0, wx.EXPAND, 0)

        sizer_3 = wx.FlexGridSizer(5, 2, 0, 0)
        sizer_6.Add(sizer_3, 1, wx.EXPAND, 0)

        l_image = wx.StaticText(self, wx.ID_ANY, _("Image:"))
        sizer_3.Add(l_image, 0, 0, 0)

        self.eImage = wx.TextCtrl(self, wx.ID_ANY, _("Light/*.fits"))
        self.eImage.SetMinSize((250, -1))
        sizer_3.Add(self.eImage, 1, wx.EXPAND, 0)

        l_offset = wx.StaticText(self, wx.ID_ANY, _("Biases:"))
        sizer_3.Add(l_offset, 0, 0, 0)

        self.eOffset = wx.TextCtrl(self, wx.ID_ANY, _("Light/*.fits"))
        sizer_3.Add(self.eOffset, 1, wx.EXPAND, 0)

        l_dark = wx.StaticText(self, wx.ID_ANY, _("Dark:"))
        sizer_3.Add(l_dark, 0, 0, 0)

        self.eDark = wx.TextCtrl(self, wx.ID_ANY, _("Light/*.fits"))
        sizer_3.Add(self.eDark, 1, wx.EXPAND, 0)

        l_flat = wx.StaticText(self, wx.ID_ANY, _("Flat:"))
        sizer_3.Add(l_flat, 0, 0, 0)

        self.eFlat = wx.TextCtrl(self, wx.ID_ANY, _("Light/*.fits"))
        sizer_3.Add(self.eFlat, 1, wx.EXPAND, 0)

        l_dflat = wx.StaticText(self, wx.ID_ANY, _("Dark-Flat:"))
        sizer_3.Add(l_dflat, 0, 0, 0)

        self.eDFlat = wx.TextCtrl(self, wx.ID_ANY, _("Light/*.fits"))
        sizer_3.Add(self.eDFlat, 1, wx.EXPAND, 0)

        sizer_2 = wx.StdDialogButtonSizer()
        sizer_1.Add(sizer_2, 0, wx.ALIGN_RIGHT | wx.ALL, 4)

        self.button_OK = wx.Button(self, wx.ID_OK, "")
        self.button_OK.SetDefault()
        sizer_2.AddButton(self.button_OK)

        self.button_CANCEL = wx.Button(self, wx.ID_CANCEL, "")
        sizer_2.AddButton(self.button_CANCEL)

        sizer_2.Realize()

        self.SetSizer(sizer_1)

        self.SetAffirmativeId(self.button_OK.GetId())
        self.SetEscapeId(self.button_CANCEL.GetId())

        self.Layout()
        # end wxGlade

# end of class CPatternFilesDlg
