/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.jclasslib.structures.constants;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.gjt.jclasslib.structures.CPInfo;
import org.gjt.jclasslib.structures.InvalidByteCodeException;

public class ConstantNameAndTypeInfo
extends CPInfo {
    public static final int SIZE = 4;
    private int nameIndex;
    private int descriptorIndex;

    public byte getTag() {
        return 12;
    }

    public String getTagVerbose() {
        return "CONSTANT_NameAndType_info";
    }

    public String getVerbose() throws InvalidByteCodeException {
        return this.getName() + this.getDescriptor();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public int getDescriptorIndex() {
        return this.descriptorIndex;
    }

    public void setDescriptorIndex(int n) {
        this.descriptorIndex = n;
    }

    public String getName() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolEntryName(this.nameIndex);
    }

    public String getDescriptor() throws InvalidByteCodeException {
        return this.classFile.getConstantPoolEntryName(this.descriptorIndex);
    }

    public void read(DataInput dataInput) throws InvalidByteCodeException, IOException {
        this.nameIndex = dataInput.readUnsignedShort();
        this.descriptorIndex = dataInput.readUnsignedShort();
        if (this.debug) {
            this.debug("read ");
        }
    }

    public void write(DataOutput dataOutput) throws InvalidByteCodeException, IOException {
        dataOutput.writeByte(12);
        dataOutput.writeShort(this.nameIndex);
        dataOutput.writeShort(this.descriptorIndex);
        if (this.debug) {
            this.debug("wrote ");
        }
    }

    protected void debug(String string) {
        super.debug(string + this.getTagVerbose() + " with name_index " + this.nameIndex + " and descriptor_index " + this.descriptorIndex);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConstantNameAndTypeInfo)) {
            return false;
        }
        ConstantNameAndTypeInfo constantNameAndTypeInfo = (ConstantNameAndTypeInfo)object;
        return super.equals(object) && constantNameAndTypeInfo.nameIndex == this.nameIndex && constantNameAndTypeInfo.descriptorIndex == this.descriptorIndex;
    }

    public int hashCode() {
        return super.hashCode() ^ this.nameIndex ^ this.descriptorIndex;
    }
}

