// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by gapic-generator. DO NOT EDIT.

package phishingprotection

import (
	"context"
	"flag"
	"fmt"
	"io"
	"log"
	"net"
	"os"
	"strings"
	"testing"

	"github.com/golang/protobuf/proto"
	"github.com/golang/protobuf/ptypes"
	"google.golang.org/api/option"
	phishingprotectionpb "google.golang.org/genproto/googleapis/cloud/phishingprotection/v1beta1"

	status "google.golang.org/genproto/googleapis/rpc/status"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/grpc/metadata"

	gstatus "google.golang.org/grpc/status"
)

var _ = io.EOF
var _ = ptypes.MarshalAny
var _ status.Status

type mockPhishingProtectionServiceV1Beta1Server struct {
	// Embed for forward compatibility.
	// Tests will keep working if more methods are added
	// in the future.
	phishingprotectionpb.PhishingProtectionServiceV1Beta1Server

	reqs []proto.Message

	// If set, all calls return this error.
	err error

	// responses to return if err == nil
	resps []proto.Message
}

func (s *mockPhishingProtectionServiceV1Beta1Server) ReportPhishing(ctx context.Context, req *phishingprotectionpb.ReportPhishingRequest) (*phishingprotectionpb.ReportPhishingResponse, error) {
	md, _ := metadata.FromIncomingContext(ctx)
	if xg := md["x-goog-api-client"]; len(xg) == 0 || !strings.Contains(xg[0], "gl-go/") {
		return nil, fmt.Errorf("x-goog-api-client = %v, expected gl-go key", xg)
	}
	s.reqs = append(s.reqs, req)
	if s.err != nil {
		return nil, s.err
	}
	return s.resps[0].(*phishingprotectionpb.ReportPhishingResponse), nil
}

// clientOpt is the option tests should use to connect to the test server.
// It is initialized by TestMain.
var clientOpt option.ClientOption

var (
	mockPhishingProtectionServiceV1Beta1 mockPhishingProtectionServiceV1Beta1Server
)

func TestMain(m *testing.M) {
	flag.Parse()

	serv := grpc.NewServer()
	phishingprotectionpb.RegisterPhishingProtectionServiceV1Beta1Server(serv, &mockPhishingProtectionServiceV1Beta1)

	lis, err := net.Listen("tcp", "localhost:0")
	if err != nil {
		log.Fatal(err)
	}
	go serv.Serve(lis)

	conn, err := grpc.Dial(lis.Addr().String(), grpc.WithInsecure())
	if err != nil {
		log.Fatal(err)
	}
	clientOpt = option.WithGRPCConn(conn)

	os.Exit(m.Run())
}

func TestPhishingProtectionServiceV1Beta1ReportPhishing(t *testing.T) {
	var expectedResponse *phishingprotectionpb.ReportPhishingResponse = &phishingprotectionpb.ReportPhishingResponse{}

	mockPhishingProtectionServiceV1Beta1.err = nil
	mockPhishingProtectionServiceV1Beta1.reqs = nil

	mockPhishingProtectionServiceV1Beta1.resps = append(mockPhishingProtectionServiceV1Beta1.resps[:0], expectedResponse)

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var uri string = "uri116076"
	var request = &phishingprotectionpb.ReportPhishingRequest{
		Parent: formattedParent,
		Uri:    uri,
	}

	c, err := NewPhishingProtectionServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ReportPhishing(context.Background(), request)

	if err != nil {
		t.Fatal(err)
	}

	if want, got := request, mockPhishingProtectionServiceV1Beta1.reqs[0]; !proto.Equal(want, got) {
		t.Errorf("wrong request %q, want %q", got, want)
	}

	if want, got := expectedResponse, resp; !proto.Equal(want, got) {
		t.Errorf("wrong response %q, want %q)", got, want)
	}
}

func TestPhishingProtectionServiceV1Beta1ReportPhishingError(t *testing.T) {
	errCode := codes.PermissionDenied
	mockPhishingProtectionServiceV1Beta1.err = gstatus.Error(errCode, "test error")

	var formattedParent string = fmt.Sprintf("projects/%s", "[PROJECT]")
	var uri string = "uri116076"
	var request = &phishingprotectionpb.ReportPhishingRequest{
		Parent: formattedParent,
		Uri:    uri,
	}

	c, err := NewPhishingProtectionServiceV1Beta1Client(context.Background(), clientOpt)
	if err != nil {
		t.Fatal(err)
	}

	resp, err := c.ReportPhishing(context.Background(), request)

	if st, ok := gstatus.FromError(err); !ok {
		t.Errorf("got error %v, expected grpc error", err)
	} else if c := st.Code(); c != errCode {
		t.Errorf("got error code %q, want %q", c, errCode)
	}
	_ = resp
}
