/*
 * SPDX-License-Identifier: BSD-2-Clause
 *
 * Copyright (c) 2007-2025, Oleg Derevenetz <oleg.derevenetz@gmail.com>.
 *
 * Use of this source code is governed by the BSD 2-Clause license that can be found in the COPYING file.
 */

#ifndef CYGWIN_H
#define CYGWIN_H

#ifndef ICMP_MINLEN
#define ICMP_MINLEN 8
#endif
#ifndef ICMP_ECHO
#define ICMP_ECHO 8
#endif
#ifndef ICMP_ECHOREPLY
#define ICMP_ECHOREPLY 0
#endif

struct icmp_ra_addr
{
    u_int32_t ira_addr;
    u_int32_t ira_preference;
} __attribute__( ( packed ) );

struct icmp
{
    u_int8_t  icmp_type;  /* type of message, see below */
    u_int8_t  icmp_code;  /* type sub code */
    u_int16_t icmp_cksum; /* ones complement checksum of struct */
    union
    {
        u_char         ih_pptr;   /* ICMP_PARAMPROB */
        struct in_addr ih_gwaddr; /* gateway address */
        struct ih_idseq           /* echo datagram */
        {
            u_int16_t icd_id;
            u_int16_t icd_seq;
        } __attribute__( ( packed ) ) ih_idseq;
        u_int32_t ih_void;

        /* ICMP_UNREACH_NEEDFRAG -- Path MTU Discovery (RFC1191) */
        struct ih_pmtu
        {
            u_int16_t ipm_void;
            u_int16_t ipm_nextmtu;
        } __attribute__( ( packed ) ) ih_pmtu;

        struct ih_rtradv
        {
            u_int8_t  irt_num_addrs;
            u_int8_t  irt_wpa;
            u_int16_t irt_lifetime;
        } __attribute__( ( packed ) ) ih_rtradv;
    } __attribute__( ( packed ) ) icmp_hun;
#define icmp_pptr      icmp_hun.ih_pptr
#define icmp_gwaddr    icmp_hun.ih_gwaddr
#define icmp_id        icmp_hun.ih_idseq.icd_id
#define icmp_seq       icmp_hun.ih_idseq.icd_seq
#define icmp_void      icmp_hun.ih_void
#define icmp_pmvoid    icmp_hun.ih_pmtu.ipm_void
#define icmp_nextmtu   icmp_hun.ih_pmtu.ipm_nextmtu
#define icmp_num_addrs icmp_hun.ih_rtradv.irt_num_addrs
#define icmp_wpa       icmp_hun.ih_rtradv.irt_wpa
#define icmp_lifetime  icmp_hun.ih_rtradv.irt_lifetime
    union
    {
        struct
        {
            u_int32_t its_otime;
            u_int32_t its_rtime;
            u_int32_t its_ttime;
        } __attribute__( ( packed ) ) id_ts;
        struct
        {
            struct ip idi_ip;
            /* options and then 64 bits of data */
        } __attribute__( ( packed ) ) id_ip;
        struct icmp_ra_addr id_radv;
        u_int32_t           id_mask;
        u_int8_t            id_data[1];
    } __attribute__( ( packed ) ) icmp_dun;
#define icmp_otime icmp_dun.id_ts.its_otime
#define icmp_rtime icmp_dun.id_ts.its_rtime
#define icmp_ttime icmp_dun.id_ts.its_ttime
#define icmp_ip    icmp_dun.id_ip.idi_ip
#define icmp_radv  icmp_dun.id_radv
#define icmp_mask  icmp_dun.id_mask
#define icmp_data  icmp_dun.id_data
} __attribute__( ( packed ) );

struct icmp6_hdr
{
    u_int8_t  icmp6_type;  /* type field */
    u_int8_t  icmp6_code;  /* code field */
    u_int16_t icmp6_cksum; /* checksum field */
    union
    {
        u_int32_t icmp6_un_data32[1]; /* type-specific field */
        u_int16_t icmp6_un_data16[2]; /* type-specific field */
        u_int8_t  icmp6_un_data8[4];  /* type-specific field */
    } __attribute__( ( packed ) ) icmp6_dataun;
} __attribute__( ( packed ) );

#define icmp6_data32   icmp6_dataun.icmp6_un_data32
#define icmp6_data16   icmp6_dataun.icmp6_un_data16
#define icmp6_data8    icmp6_dataun.icmp6_un_data8
#define icmp6_pptr     icmp6_data32[0] /* parameter prob */
#define icmp6_mtu      icmp6_data32[0] /* packet too big */
#define icmp6_id       icmp6_data16[0] /* echo request/reply */
#define icmp6_seq      icmp6_data16[1] /* echo request/reply */
#define icmp6_maxdelay icmp6_data16[0] /* mcast group membership */

#define ICMP6_ECHO_REQUEST 128 /* echo service */
#define ICMP6_ECHO_REPLY   129 /* echo reply */

#endif /* CYGWIN_H */
