/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UnknownDomainObjectException;
import org.gradle.api.internal.plugins.DefaultExtensionsSchema;
import org.gradle.api.plugins.DeferredConfigurable;
import org.gradle.api.plugins.ExtensionsSchema;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.Cast;
import org.gradle.internal.MutableActionSet;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeprecationLogger;

public class ExtensionsStorage {
    private final Map<String, ExtensionHolder> extensions = new LinkedHashMap<String, ExtensionHolder>();

    public <T> void add(TypeOf<T> publicType, String name, T extension) {
        if (this.hasExtension(name)) {
            throw new IllegalArgumentException(String.format("Cannot add extension with name '%s', as there is an extension already registered with that name.", name));
        }
        this.extensions.put(name, this.wrap(name, publicType, extension));
    }

    public boolean hasExtension(String name) {
        return this.extensions.containsKey(name);
    }

    public Map<String, Object> getAsMap() {
        LinkedHashMap<String, Object> rawExtensions = new LinkedHashMap<String, Object>(this.extensions.size());
        for (Map.Entry<String, ExtensionHolder> entry : this.extensions.entrySet()) {
            rawExtensions.put(entry.getKey(), entry.getValue().get());
        }
        return rawExtensions;
    }

    public ExtensionsSchema getSchema() {
        return DefaultExtensionsSchema.create(this.extensions.values());
    }

    public <T> T configureExtension(String name, Action<? super T> action) {
        ExtensionHolder extensionHolder = (ExtensionHolder)Cast.uncheckedCast((Object)this.extensions.get(name));
        if (extensionHolder != null) {
            return extensionHolder.configure(action);
        }
        throw this.unknownExtensionException(name);
    }

    public <T> void configureExtension(TypeOf<T> type, Action<? super T> action) {
        this.getHolderByType(type).configure(action);
    }

    public <T> T getByType(TypeOf<T> type) {
        return this.getHolderByType(type).get();
    }

    public <T> T findByType(TypeOf<T> type) {
        ExtensionHolder<T> found = this.findHolderByType(type);
        return found != null ? (T)found.get() : null;
    }

    private <T> ExtensionHolder<T> getHolderByType(TypeOf<T> type) {
        ExtensionHolder<T> found = this.findHolderByType(type);
        if (found != null) {
            return found;
        }
        throw new UnknownDomainObjectException("Extension of type '" + type.getSimpleName() + "' does not exist. Currently registered extension types: " + this.registeredExtensionTypeNames());
    }

    private <T> ExtensionHolder<T> findHolderByType(TypeOf<T> type) {
        ExtensionHolder<T> firstHolderWithExactPublicType = this.firstHolderWithExactPublicType(type);
        return firstHolderWithExactPublicType != null ? firstHolderWithExactPublicType : this.firstHolderWithAssignableType(type);
    }

    @Nullable
    private <T> ExtensionHolder<T> firstHolderWithExactPublicType(TypeOf<T> type) {
        for (ExtensionHolder extensionHolder : this.extensions.values()) {
            if (!type.equals(extensionHolder.getPublicType())) continue;
            return (ExtensionHolder)Cast.uncheckedCast((Object)extensionHolder);
        }
        return null;
    }

    @Nullable
    private <T> ExtensionHolder<T> firstHolderWithAssignableType(TypeOf<T> type) {
        for (ExtensionHolder extensionHolder : this.extensions.values()) {
            if (!type.isAssignableFrom(extensionHolder.getPublicType())) continue;
            return (ExtensionHolder)Cast.uncheckedCast((Object)extensionHolder);
        }
        return null;
    }

    public Object getByName(String name) {
        Object extension = this.findByName(name);
        if (extension != null) {
            return extension;
        }
        throw this.unknownExtensionException(name);
    }

    public Object findByName(String name) {
        ExtensionHolder extensionHolder = this.extensions.get(name);
        return extensionHolder != null ? extensionHolder.get() : null;
    }

    private <T> ExtensionHolder<T> wrap(String name, TypeOf<T> publicType, T extension) {
        if (this.isDeferredConfigurable(extension)) {
            if (!extension.getClass().getName().startsWith("org.gradle.api.publish.internal.DeferredConfigurablePublishingExtension")) {
                DeprecationLogger.nagUserOfDeprecated((String)"@DeferredConfigurable");
            }
            return new DeferredConfigurableExtensionHolder<T>(name, publicType, extension);
        }
        return new ExtensionHolder(name, publicType, extension);
    }

    private List<String> registeredExtensionTypeNames() {
        ArrayList<String> types = new ArrayList<String>(this.extensions.size());
        for (ExtensionHolder holder : this.extensions.values()) {
            types.add(holder.getPublicType().getSimpleName());
        }
        return types;
    }

    private <T> boolean isDeferredConfigurable(T extension) {
        return extension.getClass().isAnnotationPresent(DeferredConfigurable.class);
    }

    private UnknownDomainObjectException unknownExtensionException(String name) {
        throw new UnknownDomainObjectException("Extension with name '" + name + "' does not exist. Currently registered extension names: " + this.extensions.keySet());
    }

    private static class DeferredConfigurableExtensionHolder<T>
    extends ExtensionHolder<T> {
        private MutableActionSet<T> actions = new MutableActionSet();
        private boolean configured;
        private Throwable configureFailure;

        DeferredConfigurableExtensionHolder(String name, TypeOf<T> publicType, T extension) {
            super(name, publicType, extension);
        }

        @Override
        public boolean isDeferredConfigurable() {
            return true;
        }

        @Override
        public T get() {
            this.configureNow();
            return (T)this.extension;
        }

        @Override
        public T configure(Action<? super T> action) {
            this.configureLater(action);
            return null;
        }

        private void configureLater(Action<? super T> action) {
            if (this.configured) {
                throw new InvalidUserDataException(String.format("Cannot configure the '%s' extension after it has been accessed.", this.getName()));
            }
            this.actions.add(action);
        }

        private void configureNow() {
            if (!this.configured) {
                this.configured = true;
                try {
                    this.actions.execute(this.extension);
                }
                catch (Throwable t) {
                    this.configureFailure = t;
                }
                this.actions = null;
            }
            if (this.configureFailure != null) {
                throw UncheckedException.throwAsUncheckedException((Throwable)this.configureFailure);
            }
        }
    }

    private static class ExtensionHolder<T>
    implements ExtensionsSchema.ExtensionSchema {
        private final String name;
        private final TypeOf<T> publicType;
        protected final T extension;

        private ExtensionHolder(String name, TypeOf<T> publicType, T extension) {
            this.name = name;
            this.publicType = publicType;
            this.extension = extension;
        }

        public String getName() {
            return this.name;
        }

        public TypeOf<T> getPublicType() {
            return this.publicType;
        }

        public boolean isDeferredConfigurable() {
            return false;
        }

        public T get() {
            return this.extension;
        }

        public T configure(Action<? super T> action) {
            action.execute(this.extension);
            return this.extension;
        }
    }
}

