/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.WellKnownFileLocations;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.initialization.RootBuildLifecycleListener;
import org.gradle.internal.file.FileMetadataSnapshot;

public class DefaultFileSystemMirror
implements FileSystemMirror,
TaskOutputChangesListener,
RootBuildLifecycleListener {
    private final Map<String, FileMetadataSnapshot> metadata = new ConcurrentHashMap<String, FileMetadataSnapshot>();
    private final Map<String, FileMetadataSnapshot> cacheMetadata = new ConcurrentHashMap<String, FileMetadataSnapshot>();
    private final Map<String, PhysicalSnapshot> files = new ConcurrentHashMap<String, PhysicalSnapshot>();
    private final Map<String, PhysicalSnapshot> cacheFiles = new ConcurrentHashMap<String, PhysicalSnapshot>();
    private final WellKnownFileLocations wellKnownFileLocations;

    public DefaultFileSystemMirror(WellKnownFileLocations wellKnownFileLocations) {
        this.wellKnownFileLocations = wellKnownFileLocations;
    }

    @Override
    @Nullable
    public PhysicalSnapshot getSnapshot(String absolutePath) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            return this.cacheFiles.get(absolutePath);
        }
        return this.files.get(absolutePath);
    }

    @Override
    public void putSnapshot(PhysicalSnapshot file) {
        if (this.wellKnownFileLocations.isImmutable(file.getAbsolutePath())) {
            this.cacheFiles.put(file.getAbsolutePath(), file);
        } else {
            this.files.put(file.getAbsolutePath(), file);
        }
    }

    @Override
    public FileMetadataSnapshot getMetadata(String absolutePath) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            return this.cacheMetadata.get(absolutePath);
        }
        return this.metadata.get(absolutePath);
    }

    @Override
    public void putMetadata(String absolutePath, FileMetadataSnapshot metadata) {
        if (this.wellKnownFileLocations.isImmutable(absolutePath)) {
            this.cacheMetadata.put(absolutePath, metadata);
        } else {
            this.metadata.put(absolutePath, metadata);
        }
    }

    @Override
    public void beforeTaskOutputChanged() {
        this.metadata.clear();
        this.files.clear();
    }

    @Override
    public void afterStart() {
    }

    @Override
    public void beforeComplete() {
        this.metadata.clear();
        this.cacheMetadata.clear();
        this.files.clear();
        this.cacheFiles.clear();
    }
}

