/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.changes;

import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.changedetection.changes.StatefulIncrementalTaskInputs;
import org.gradle.api.internal.changedetection.rules.TaskStateChange;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class ChangesOnlyIncrementalTaskInputs
extends StatefulIncrementalTaskInputs {
    private final Iterable<TaskStateChange> inputFilesState;
    private final List<InputFileDetails> removedFiles = new ArrayList<InputFileDetails>();

    public ChangesOnlyIncrementalTaskInputs(Iterable<TaskStateChange> inputFilesState) {
        this.inputFilesState = inputFilesState;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    protected void doOutOfDate(Action<? super InputFileDetails> outOfDateAction) {
        for (TaskStateChange change : this.inputFilesState) {
            InputFileDetails fileChange = (InputFileDetails)change;
            if (fileChange.isRemoved()) {
                this.removedFiles.add(fileChange);
                continue;
            }
            outOfDateAction.execute((Object)fileChange);
        }
    }

    @Override
    protected void doRemoved(Action<? super InputFileDetails> removedAction) {
        for (InputFileDetails removedFile : this.removedFiles) {
            removedAction.execute((Object)removedFile);
        }
    }
}

