/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.client;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.gradle.internal.concurrent.ManagedExecutor;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.io.LineBufferingOutputStream;
import org.gradle.internal.io.TextStream;
import org.gradle.util.DisconnectableInputStream;

public class InputForwarder
implements Stoppable {
    private final InputStream input;
    private final TextStream handler;
    private final ExecutorFactory executorFactory;
    private final int bufferSize;
    private ManagedExecutor forwardingExecuter;
    private DisconnectableInputStream disconnectableInput;
    private LineBufferingOutputStream outputBuffer;
    private final Lock lifecycleLock = new ReentrantLock();
    private boolean started;
    private boolean stopped;

    public InputForwarder(InputStream input, TextStream handler, ExecutorFactory executerFactory, int bufferSize) {
        this.input = input;
        this.handler = handler;
        this.executorFactory = executerFactory;
        this.bufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputForwarder start() {
        this.lifecycleLock.lock();
        try {
            if (this.started) {
                throw new IllegalStateException("input forwarder has already been started");
            }
            this.disconnectableInput = new DisconnectableInputStream(this.input, this.bufferSize);
            this.outputBuffer = new LineBufferingOutputStream(this.handler, this.bufferSize);
            this.forwardingExecuter = this.executorFactory.create("Forward input");
            this.forwardingExecuter.execute(new Runnable(){

                @Override
                public void run() {
                    byte[] buffer = new byte[InputForwarder.this.bufferSize];
                    IOException readFailure = null;
                    try {
                        while (true) {
                            int readCount;
                            block10: {
                                try {
                                    readCount = InputForwarder.this.disconnectableInput.read(buffer, 0, InputForwarder.this.bufferSize);
                                    if (readCount < 0) {
                                    }
                                    break block10;
                                }
                                catch (AsynchronousCloseException e) {
                                }
                                catch (IOException e) {
                                    readFailure = e;
                                }
                                break;
                            }
                            InputForwarder.this.outputBuffer.write(buffer, 0, readCount);
                        }
                        InputForwarder.this.outputBuffer.flush();
                    }
                    catch (IOException e) {
                        throw UncheckedException.throwAsUncheckedException(e);
                    }
                    finally {
                        InputForwarder.this.handler.endOfStream(readFailure);
                    }
                }
            });
            this.started = true;
        }
        finally {
            this.lifecycleLock.unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        block5: {
            this.lifecycleLock.lock();
            try {
                if (this.stopped) break block5;
                try {
                    this.disconnectableInput.close();
                }
                catch (IOException e) {
                    throw UncheckedException.throwAsUncheckedException(e);
                }
                this.forwardingExecuter.stop();
                this.stopped = true;
            }
            finally {
                this.lifecycleLock.unlock();
            }
        }
    }
}

