/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.google.common.collect.Multimap;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtConstructorDelegationCall;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtModifierListOwnerStub;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPropertyDelegate;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeList;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeAlias;
import org.jetbrains.kotlin.psi.KtTypeConstraint;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterList;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.AnnotationChecker;
import org.jetbrains.kotlin.resolve.AnnotationResolverImpl;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.BodiesResolveContext;
import org.jetbrains.kotlin.resolve.DeclarationsChecker;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.ExposedVisibilityChecker;
import org.jetbrains.kotlin.resolve.FiniteBoundRestrictionChecker;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.LateinitModifierApplicabilityChecker;
import org.jetbrains.kotlin.resolve.ModifierCheckerCore;
import org.jetbrains.kotlin.resolve.ModifiersChecker;
import org.jetbrains.kotlin.resolve.NonExpansiveInheritanceRestrictionChecker;
import org.jetbrains.kotlin.resolve.ShadowedExtensionChecker;
import org.jetbrains.kotlin.resolve.TypeAliasExpander;
import org.jetbrains.kotlin.resolve.TypeAliasExpansion;
import org.jetbrains.kotlin.resolve.TypeAliasExpansionReportStrategy;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.checkers.PlatformDiagnosticSuppressor;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.SubstitutionUtils;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u00b6\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 ~2\u00020\u0001:\u0002~\u007fBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J$\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u0002022\u0006\u0010.\u001a\u00020/H\u0002J\u0018\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u0002052\u0006\u00101\u001a\u000202H\u0002J\u001c\u00106\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\n\u0010)\u001a\u0006\u0012\u0002\b\u000309H\u0002J\u0010\u0010:\u001a\u00020\u00192\u0006\u0010;\u001a\u000205H\u0002J\u0018\u0010<\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\u0006\u0010)\u001a\u00020%H\u0002J\u0018\u0010=\u001a\u00020\u00192\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\u001c\u0010B\u001a\u00020\u00192\u0006\u00107\u001a\u0002082\n\u0010)\u001a\u0006\u0012\u0002\b\u000309H\u0002J\u0018\u0010C\u001a\u00020\u00192\u0006\u0010D\u001a\u00020E2\u0006\u0010&\u001a\u00020'H\u0002J\u0016\u0010F\u001a\u00020\u00192\u0006\u0010D\u001a\u00020E2\u0006\u0010&\u001a\u00020GJ\u0018\u0010H\u001a\u00020\u00192\u0006\u0010)\u001a\u00020I2\u0006\u0010J\u001a\u00020KH\u0002J\u0018\u0010L\u001a\u00020\u00192\u0006\u00101\u001a\u00020A2\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u0010M\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J \u0010N\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00101\u001a\u00020AH\u0002J\u0010\u0010O\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0002J\u0010\u0010P\u001a\u00020\u00192\u0006\u0010Q\u001a\u00020RH\u0002J\u0018\u0010S\u001a\u00020\u00192\u0006\u0010)\u001a\u00020T2\u0006\u00101\u001a\u000202H\u0002J \u0010U\u001a\u00020\u00192\u0006\u0010J\u001a\u00020V2\u0006\u0010)\u001a\u00020W2\u0006\u0010X\u001a\u00020YH\u0002J\u0010\u0010Z\u001a\u00020\u00192\u0006\u00101\u001a\u000202H\u0002J\u0018\u0010[\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/2\u0006\u00101\u001a\u00020AH\u0002J\u0018\u0010\\\u001a\u00020\u00192\u0006\u0010)\u001a\u00020%2\u0006\u0010J\u001a\u00020]H\u0002J\u0018\u0010^\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010_\u001a\u00020\u00192\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010`\u001a\u00020\u00192\u0006\u0010J\u001a\u00020\u001bH\u0002J\u0018\u0010a\u001a\u00020\u00192\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020eH\u0002J\u0018\u0010f\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0018\u0010g\u001a\u00020\u00192\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u0010h\u001a\u00020\u00192\u0006\u0010i\u001a\u00020YH\u0002J\u0010\u0010j\u001a\u00020\u00192\u0006\u0010i\u001a\u00020YH\u0002J\u0010\u0010k\u001a\u00020\u00192\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u0010l\u001a\u00020\u00192\u0006\u00104\u001a\u000205H\u0002J\u0018\u0010m\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010n\u001a\u00020KH\u0002J\u001e\u0010o\u001a\b\u0012\u0004\u0012\u00020V0p2\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020,H\u0002J\u0010\u0010t\u001a\u00020u2\u0006\u0010!\u001a\u00020\"H\u0002J\u000e\u0010v\u001a\u00020\u00192\u0006\u0010w\u001a\u00020xJ$\u0010y\u001a\u00020\u00192\f\u0010z\u001a\b\u0012\u0004\u0012\u00020e0{2\f\u0010|\u001a\b\u0012\u0004\u0012\u00020e0}H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u00060\u0015R\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0080\u0001"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker;", "", "descriptorResolver", "Lorg/jetbrains/kotlin/resolve/DescriptorResolver;", "modifiersChecker", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker;", "annotationChecker", "Lorg/jetbrains/kotlin/resolve/AnnotationChecker;", "identifierChecker", "Lorg/jetbrains/kotlin/resolve/IdentifierChecker;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "diagnosticSuppressor", "Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;", "(Lorg/jetbrains/kotlin/resolve/DescriptorResolver;Lorg/jetbrains/kotlin/resolve/ModifiersChecker;Lorg/jetbrains/kotlin/resolve/AnnotationChecker;Lorg/jetbrains/kotlin/resolve/IdentifierChecker;Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/resolve/checkers/PlatformDiagnosticSuppressor;)V", "exposedChecker", "Lorg/jetbrains/kotlin/resolve/ExposedVisibilityChecker;", "Lorg/jetbrains/kotlin/resolve/ModifiersChecker$ModifiersCheckingProcedure;", "shadowedExtensionChecker", "Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "checkAccessor", "", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "accessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "accessorDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkAccessors", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "checkActualFunction", "element", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkActualTypeAlias", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "checkAnnotationClassMembers", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "checkClass", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptorWithResolutionScopes;", "checkClassButNotObject", "aClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "checkConstructorDeclaration", "constructorDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassConstructorDescriptor;", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "checkConstructorInInterface", "klass", "checkConstructorVisibility", "checkEnumEntry", "enumEntry", "Lorg/jetbrains/kotlin/psi/KtEnumEntry;", "enumEntryClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "checkExpectedClassConstructor", "checkExpectedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkFunction", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "checkImplicitCallableType", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "checkLocalAnnotation", "checkLocalTypeAliasDeclaration", "checkMemberProperty", "checkMethodsOfAnyInInterface", "checkModifiersAndAnnotationsInPackageDirective", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "checkObject", "Lorg/jetbrains/kotlin/psi/KtObjectDeclaration;", "checkOnlyOneTypeParameterBound", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "owner", "Lorg/jetbrains/kotlin/psi/KtTypeParameterListOwner;", "checkOpenMembers", "checkPrimaryConstructor", "checkPrivateExpectedDeclaration", "Lorg/jetbrains/kotlin/descriptors/MemberDescriptor;", "checkProperty", "checkPropertyInitializer", "checkPropertyTypeParametersAreUsedInReceiverType", "checkSupertypesForConsistency", "classifier", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "sourceElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "checkTypeAliasDeclaration", "checkTypeAliasExpansion", "checkTypeParameterConstraints", "typeParameterListOwner", "checkTypeParameters", "checkTypesInClassHeader", "checkValOnAnnotationParameter", "checkVarargParameters", "callableDescriptor", "getUsedTypeAliasParameters", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "typeAlias", "noExplicitTypeOrGetterType", "", "process", "bodiesResolveContext", "Lorg/jetbrains/kotlin/resolve/BodiesResolveContext;", "reportVisibilityModifierDiagnostics", "tokens", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "Companion", "TypeAliasDeclarationCheckingReportStrategy", "frontend"})
public final class DeclarationsChecker {
    private final ModifiersChecker.ModifiersCheckingProcedure modifiersChecker;
    private final ExposedVisibilityChecker exposedChecker;
    private final ShadowedExtensionChecker shadowedExtensionChecker;
    private final DescriptorResolver descriptorResolver;
    private final AnnotationChecker annotationChecker;
    private final IdentifierChecker identifierChecker;
    private final BindingTrace trace;
    private final LanguageVersionSettings languageVersionSettings;
    private final PlatformDiagnosticSuppressor diagnosticSuppressor;
    private static final ImmutableSet<String> METHOD_OF_ANY_NAMES;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void process(@NotNull BodiesResolveContext bodiesResolveContext) {
        KtDeclarationStub declaration;
        Object object;
        Iterable $receiver$iv$iv;
        Object property;
        Iterator iterator2;
        Intrinsics.checkParameterIsNotNull((Object)bodiesResolveContext, (String)"bodiesResolveContext");
        Object object2 = bodiesResolveContext.getFiles().iterator();
        while (object2.hasNext()) {
            KtFile ktFile;
            KtFile ktFile2 = ktFile = object2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktFile2, (String)"file");
            this.checkModifiersAndAnnotationsInPackageDirective(ktFile2);
            this.annotationChecker.check(ktFile, this.trace, null);
        }
        for (Map.Entry entry : bodiesResolveContext.getDeclaredClasses().entrySet()) {
            ClassDescriptorWithResolutionScopes classDescriptor;
            iterator2 = entry;
            KtClassOrObject classOrObject = (KtClassOrObject)iterator2.getKey();
            iterator2 = entry;
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = classDescriptor = (ClassDescriptorWithResolutionScopes)iterator2.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptorWithResolutionScopes, (String)"classDescriptor");
            KtClassOrObject ktClassOrObject = classOrObject;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktClassOrObject, (String)"classOrObject");
            this.checkClass(classDescriptorWithResolutionScopes, ktClassOrObject);
            this.modifiersChecker.checkModifiersForDeclaration(classOrObject, classDescriptor);
            this.identifierChecker.checkDeclaration(classOrObject, this.trace);
            this.exposedChecker.checkClassHeader(classOrObject, classDescriptor);
        }
        for (Map.Entry entry : bodiesResolveContext.getFunctions().entrySet()) {
            iterator2 = entry;
            KtNamedFunction function2 = (KtNamedFunction)iterator2.getKey();
            iterator2 = entry;
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)iterator2.getValue();
            KtNamedFunction ktNamedFunction = function2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktNamedFunction, (String)"function");
            SimpleFunctionDescriptor simpleFunctionDescriptor = functionDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)simpleFunctionDescriptor, (String)"functionDescriptor");
            this.checkFunction(ktNamedFunction, simpleFunctionDescriptor);
            this.modifiersChecker.checkModifiersForDeclaration(function2, functionDescriptor);
            this.identifierChecker.checkDeclaration(function2, this.trace);
        }
        object2 = bodiesResolveContext.getProperties().entrySet().iterator();
        while (object2.hasNext()) {
            Map.Entry entry = (Map.Entry)object2.next();
            iterator2 = entry;
            property = (KtProperty)iterator2.getKey();
            iterator2 = entry;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)iterator2.getValue();
            Object object3 = property;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"property");
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)propertyDescriptor2, (String)"propertyDescriptor");
            this.checkProperty((KtProperty)object3, propertyDescriptor2);
            this.modifiersChecker.checkModifiersForDeclaration((KtDeclaration)property, propertyDescriptor);
            this.identifierChecker.checkDeclaration((KtDeclaration)property, this.trace);
        }
        Iterable $receiver$iv = bodiesResolveContext.getDestructuringDeclarationEntries().entrySet();
        property = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            KtDestructuringDeclarationEntry entry;
            void $entry_$_$;
            Map.Entry entry2 = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            void var9_16 = $entry_$_$;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry = (KtDestructuringDeclarationEntry)var9_16.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"entry");
            PsiElement psiElement = ktDestructuringDeclarationEntry.getParent();
            collection.add(psiElement);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            if (!(element$iv$iv instanceof KtDestructuringDeclaration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        for (KtDestructuringDeclaration multiDeclaration : list2) {
            this.modifiersChecker.checkModifiersForDestructuringDeclaration(multiDeclaration);
            this.identifierChecker.checkDeclaration(multiDeclaration, this.trace);
        }
        Iterator<Object> iterator3 = bodiesResolveContext.getSecondaryConstructors().entrySet().iterator();
        while (iterator3.hasNext()) {
            ClassConstructorDescriptor constructorDescriptor;
            object = object2 = (Map.Entry)iterator3.next();
            declaration = (KtSecondaryConstructor)object.getKey();
            object = object2;
            ClassConstructorDescriptor classConstructorDescriptor = constructorDescriptor = (ClassConstructorDescriptor)object.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"constructorDescriptor");
            KtDeclarationStub ktDeclarationStub = declaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationStub, (String)"declaration");
            this.checkConstructorDeclaration(classConstructorDescriptor, (KtConstructor<?>)ktDeclarationStub);
            ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, declaration, constructorDescriptor, null, 4, null);
        }
        iterator3 = bodiesResolveContext.getTypeAliases().entrySet().iterator();
        while (iterator3.hasNext()) {
            object = object2 = (Map.Entry)iterator3.next();
            declaration = (KtTypeAlias)object.getKey();
            object = object2;
            TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)object.getValue();
            KtDeclarationStub ktDeclarationStub = declaration;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDeclarationStub, (String)"declaration");
            TypeAliasDescriptor typeAliasDescriptor2 = typeAliasDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeAliasDescriptor2, (String)"typeAliasDescriptor");
            this.checkTypeAliasDeclaration((KtTypeAlias)ktDeclarationStub, typeAliasDescriptor2);
            this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
            this.exposedChecker.checkTypeAlias((KtTypeAlias)declaration, typeAliasDescriptor);
        }
    }

    public final void checkLocalTypeAliasDeclaration(@NotNull KtTypeAlias declaration, @NotNull TypeAliasDescriptor typeAliasDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        Intrinsics.checkParameterIsNotNull((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
        this.checkTypeAliasDeclaration(declaration, typeAliasDescriptor);
        this.modifiersChecker.checkModifiersForDeclaration(declaration, typeAliasDescriptor);
        this.exposedChecker.checkTypeAlias(declaration, typeAliasDescriptor);
    }

    private final void checkTypeAliasDeclaration(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        KtTypeReference ktTypeReference = declaration.getTypeReference();
        if (ktTypeReference == null) {
            return;
        }
        KtTypeReference typeReference = ktTypeReference;
        this.checkTypeAliasExpansion(declaration, typeAliasDescriptor);
        SimpleType expandedType = typeAliasDescriptor.getExpandedType();
        if (KotlinTypeKt.isError(expandedType)) {
            return;
        }
        ClassifierDescriptor expandedClassifier = expandedType.getConstructor().getDeclarationDescriptor();
        if (DynamicTypesKt.isDynamic(expandedType) || expandedClassifier instanceof TypeParameterDescriptor) {
            this.trace.report(Errors.TYPEALIAS_SHOULD_EXPAND_TO_CLASS.on((KtTypeReference)((PsiElement)typeReference), expandedType));
        }
        if (TypeUtils.contains((KotlinType)expandedType, (Function1<UnwrappedType, Boolean>)((Function1)checkTypeAliasDeclaration.1.INSTANCE))) {
            this.trace.report(Errors.TYPEALIAS_EXPANDED_TO_MALFORMED_TYPE.on((KtTypeReference)((PsiElement)typeReference), expandedType, "Array<Nothing> is illegal"));
        }
        Set<TypeParameterDescriptor> usedTypeAliasParameters = this.getUsedTypeAliasParameters(expandedType, typeAliasDescriptor);
        for (TypeParameterDescriptor typeParameter : typeAliasDescriptor.getDeclaredTypeParameters()) {
            KtTypeParameter source;
            if (usedTypeAliasParameters.contains(typeParameter)) continue;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameterDescriptor);
            if (!(psiElement instanceof KtTypeParameter)) {
                psiElement = null;
            }
            if ((KtTypeParameter)psiElement == null) {
                throw (Throwable)((Object)new AssertionError((Object)("No source element for type parameter " + typeParameter + " of " + typeAliasDescriptor)));
            }
            this.trace.report(Errors.UNUSED_TYPEALIAS_PARAMETER.on((KtTypeParameter)((PsiElement)source), typeParameter, expandedType));
        }
        if (PsiUtilsKt.hasActualModifier(declaration)) {
            this.checkActualTypeAlias(declaration, typeAliasDescriptor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkActualTypeAlias(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        void $receiver$iv$iv;
        boolean bl;
        Iterable $receiver$iv;
        SimpleType rhs;
        block13: {
            Object it;
            boolean bl2;
            block12: {
                rhs = typeAliasDescriptor.getUnderlyingType();
                ClassifierDescriptor classDescriptor = rhs.getConstructor().getDeclarationDescriptor();
                if (!(classDescriptor instanceof ClassDescriptor)) {
                    this.trace.report(Errors.ACTUAL_TYPE_ALIAS_NOT_TO_CLASS.on((KtTypeAlias)((PsiElement)declaration)));
                    return;
                }
                List<TypeParameterDescriptor> list2 = ((ClassDescriptor)classDescriptor).getDeclaredTypeParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classDescriptor.declaredTypeParameters");
                $receiver$iv = list2;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl2 = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        it = (TypeParameterDescriptor)element$iv;
                        TypeParameterDescriptor typeParameterDescriptor = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"it");
                        if (!(typeParameterDescriptor.getVariance() != Variance.INVARIANT)) continue;
                        bl2 = true;
                        break block12;
                    }
                    bl2 = false;
                }
            }
            if (bl2) {
                this.trace.report(Errors.ACTUAL_TYPE_ALIAS_TO_CLASS_WITH_DECLARATION_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
                return;
            }
            $receiver$iv = rhs.getArguments();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    it = (TypeProjection)element$iv;
                    if (!(it.getProjectionKind() != Variance.INVARIANT || it.isStarProjection())) continue;
                    bl = true;
                    break block13;
                }
                bl = false;
            }
        }
        if (bl) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_USE_SITE_VARIANCE.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
        $receiver$iv = rhs.getArguments();
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TypeProjection $i$f$any = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            ClassifierDescriptor classifierDescriptor = it.getType().getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)classifierDescriptor;
            collection.add(typeParameterDescriptor);
        }
        if (Intrinsics.areEqual((Object)((List)destination$iv$iv), typeAliasDescriptor.getDeclaredTypeParameters()) ^ true) {
            this.trace.report(Errors.ACTUAL_TYPE_ALIAS_WITH_COMPLEX_SUBSTITUTION.on((KtTypeAlias)((PsiElement)declaration)));
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<TypeParameterDescriptor> getUsedTypeAliasParameters(KotlinType type2, TypeAliasDescriptor typeAlias) {
        void $receiver$iv;
        Iterable iterable = TypeUtilsKt.constituentTypes(type2);
        Collection destination$iv = new HashSet();
        void $receiver$iv$iv = $receiver$iv;
        for (Object element$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor typeParameterDescriptor;
            TypeParameterDescriptor typeParameterDescriptor2;
            TypeParameterDescriptor it;
            TypeParameterDescriptor descriptor2;
            Object element$iv = element$iv$iv;
            KotlinType it2 = (KotlinType)element$iv;
            ClassifierDescriptor classifierDescriptor = it2.getConstructor().getDeclarationDescriptor();
            if (!(classifierDescriptor instanceof TypeParameterDescriptor)) {
                classifierDescriptor = null;
            }
            TypeParameterDescriptor typeParameterDescriptor3 = (descriptor2 = (TypeParameterDescriptor)classifierDescriptor) != null ? (Intrinsics.areEqual((Object)(it = typeParameterDescriptor2).getContainingDeclaration(), (Object)typeAlias) ? typeParameterDescriptor2 : null) : null;
            if (typeParameterDescriptor3 == null) continue;
            TypeParameterDescriptor it$iv = typeParameterDescriptor = typeParameterDescriptor3;
            destination$iv.add(it$iv);
        }
        return (Set)destination$iv;
    }

    private final void checkTypeAliasExpansion(KtTypeAlias declaration, TypeAliasDescriptor typeAliasDescriptor) {
        TypeAliasExpansion typeAliasExpansion = TypeAliasExpansion.Companion.createWithFormalArguments(typeAliasDescriptor);
        TypeAliasDeclarationCheckingReportStrategy reportStrategy = new TypeAliasDeclarationCheckingReportStrategy(this.trace, typeAliasDescriptor, declaration);
        new TypeAliasExpander(reportStrategy, true).expandWithoutAbbreviation(typeAliasExpansion, Annotations.Companion.getEMPTY());
    }

    private final void checkConstructorDeclaration(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        this.modifiersChecker.checkModifiersForDeclaration(declaration, constructorDescriptor);
        this.identifierChecker.checkDeclaration(declaration, this.trace);
        this.checkVarargParameters(this.trace, constructorDescriptor);
        this.checkConstructorVisibility(constructorDescriptor, declaration);
        this.checkExpectedClassConstructor(constructorDescriptor, declaration);
        if (constructorDescriptor.isActual()) {
            this.checkActualFunction(declaration, constructorDescriptor);
        }
    }

    private final void checkExpectedClassConstructor(ClassConstructorDescriptor constructorDescriptor, KtConstructor<?> declaration) {
        KtConstructorDelegationCall delegationCall;
        if (!constructorDescriptor.isExpect()) {
            return;
        }
        if (declaration.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)declaration)));
        }
        if (constructorDescriptor.getContainingDeclaration().getKind() == ClassKind.ENUM_CLASS) {
            this.trace.report(Errors.EXPECTED_ENUM_CONSTRUCTOR.on((KtConstructor<?>)((PsiElement)declaration)));
        }
        if (declaration instanceof KtPrimaryConstructor && !DescriptorUtils.isAnnotationClass(constructorDescriptor.getConstructedClass())) {
            ClassDescriptor classDescriptor = constructorDescriptor.getConstructedClass();
            Intrinsics.checkExpressionValueIsNotNull((Object)classDescriptor, (String)"constructorDescriptor.constructedClass");
            if (!classDescriptor.isInline()) {
                for (KtParameter parameter : ((KtPrimaryConstructor)declaration).getValueParameters()) {
                    if (!parameter.hasValOrVar()) continue;
                    this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_PROPERTY_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                }
            }
        }
        if (declaration instanceof KtSecondaryConstructor && !(delegationCall = ((KtSecondaryConstructor)declaration).getDelegationCall()).isImplicit()) {
            this.trace.report(Errors.EXPECTED_CLASS_CONSTRUCTOR_DELEGATION_CALL.on((KtConstructorDelegationCall)((PsiElement)delegationCall)));
        }
    }

    private final void checkConstructorVisibility(ClassConstructorDescriptor constructorDescriptor, KtDeclaration declaration) {
        PsiElement visibilityModifier = KtPsiUtilKt.visibilityModifier(declaration);
        if (visibilityModifier != null) {
            ASTNode aSTNode = visibilityModifier.getNode();
            if (Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)KtTokens.PRIVATE_KEYWORD) ^ true) {
                ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
                if (classDescriptor.getKind() == ClassKind.ENUM_CLASS) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_ENUM.on(visibilityModifier));
                } else if (classDescriptor.getModality() == Modality.SEALED) {
                    this.trace.report(Errors.NON_PRIVATE_CONSTRUCTOR_IN_SEALED.on(visibilityModifier));
                }
            }
        }
    }

    private final void checkModifiersAndAnnotationsInPackageDirective(KtFile file2) {
        KtModifierList modifierList;
        KtPackageDirective ktPackageDirective = file2.getPackageDirective();
        if (ktPackageDirective == null) {
            return;
        }
        KtPackageDirective packageDirective = ktPackageDirective;
        KtModifierList ktModifierList = packageDirective.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList ktModifierList2 = modifierList = ktModifierList;
        Intrinsics.checkExpressionValueIsNotNull((Object)ktModifierList2, (String)"modifierList");
        Iterator<KtAnnotationEntry> iterator2 = ktModifierList2.getAnnotationEntries().iterator();
        while (iterator2.hasNext()) {
            KtSimpleNameExpression ktSimpleNameExpression;
            KtAnnotationEntry annotationEntry;
            KtAnnotationEntry ktAnnotationEntry = annotationEntry = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktAnnotationEntry, (String)"annotationEntry");
            KtConstructorCalleeExpression calleeExpression = ktAnnotationEntry.getCalleeExpression();
            if (calleeExpression == null) continue;
            if (calleeExpression.getConstructorReferenceExpression() == null) continue;
            KtSimpleNameExpression it = ktSimpleNameExpression;
            this.trace.report(Errors.UNRESOLVED_REFERENCE.on((KtReferenceExpression)((PsiElement)it), it));
        }
        this.annotationChecker.check(packageDirective, this.trace, null);
        ModifierCheckerCore.INSTANCE.check(packageDirective, this.trace, null, this.languageVersionSettings);
    }

    private final void checkClass(ClassDescriptorWithResolutionScopes classDescriptor, KtClassOrObject classOrObject) {
        this.checkSupertypesForConsistency(classDescriptor, classOrObject);
        this.checkLocalAnnotation(classDescriptor, classOrObject);
        this.checkTypesInClassHeader(classOrObject);
        KtClassOrObject ktClassOrObject = classOrObject;
        if (ktClassOrObject instanceof KtClass) {
            this.checkClassButNotObject((KtClass)classOrObject, classDescriptor);
            this.descriptorResolver.checkNamesInConstraints(classOrObject, classDescriptor, classDescriptor.getScopeForClassHeaderResolution(), this.trace);
        } else if (ktClassOrObject instanceof KtObjectDeclaration) {
            this.checkObject((KtObjectDeclaration)classOrObject, classDescriptor);
        }
        this.checkPrimaryConstructor(classOrObject, classDescriptor);
        this.checkPrivateExpectedDeclaration(classOrObject, classDescriptor);
    }

    private final void checkLocalAnnotation(ClassDescriptor classDescriptor, KtClassOrObject classOrObject) {
        if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS && DescriptorUtils.isLocal(classDescriptor)) {
            if (this.languageVersionSettings.supportsFeature(LanguageFeature.ProhibitLocalAnnotations)) {
                this.trace.report(Errors.LOCAL_ANNOTATION_CLASS_ERROR.on((KtClassOrObject)((PsiElement)classOrObject)));
            } else {
                this.trace.report(Errors.LOCAL_ANNOTATION_CLASS.on((KtClassOrObject)((PsiElement)classOrObject)));
            }
        }
    }

    private final void checkTypesInClassHeader(KtClassOrObject classOrObject) {
        KotlinType type2;
        KtTypeReference typeReference;
        Function1<KtTypeReference, KotlinType> type$ = new Function1<KtTypeReference, KotlinType>(this){
            final /* synthetic */ DeclarationsChecker this$0;

            @Nullable
            public final KotlinType invoke(@NotNull KtTypeReference $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                return (KotlinType)DeclarationsChecker.access$getTrace$p(this.this$0).getBindingContext().get(BindingContext.TYPE, $receiver);
            }
            {
                this.this$0 = declarationsChecker;
                super(1);
            }
        };
        for (KtSuperTypeListEntry delegationSpecifier : classOrObject.getSuperTypeListEntries()) {
            KotlinType kotlinType;
            KtTypeReference typeReference2;
            if (delegationSpecifier.getTypeReference() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference2;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"typeReference");
            if (type$.invoke(ktTypeReference) == null) continue;
            KotlinType it = kotlinType;
            DescriptorResolver.checkBounds(typeReference2, it, this.trace);
        }
        if (!(classOrObject instanceof KtClass)) {
            return;
        }
        ArrayList<DescriptorResolver.UpperBoundCheckRequest> upperBoundCheckRequests = new ArrayList<DescriptorResolver.UpperBoundCheckRequest>();
        Iterator<KtElementImplStub> iterator2 = ((KtClass)classOrObject).getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            KtTypeParameter typeParameter;
            KtTypeParameter ktTypeParameter = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"typeParameter");
            if (ktTypeParameter.getExtendsBound() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"typeReference");
            if (type$.invoke(ktTypeReference) == null) {
                continue;
            }
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest(typeParameter.getNameAsName(), typeReference, type2));
        }
        iterator2 = ((KtClass)classOrObject).getTypeConstraints().iterator();
        while (iterator2.hasNext()) {
            KtTypeConstraint constraint;
            KtTypeConstraint ktTypeConstraint = constraint = (KtTypeConstraint)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeConstraint, (String)"constraint");
            if (ktTypeConstraint.getBoundTypeReference() == null) {
                continue;
            }
            KtTypeReference ktTypeReference = typeReference;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeReference, (String)"typeReference");
            if (type$.invoke(ktTypeReference) == null) {
                continue;
            }
            Object object = constraint.getSubjectTypeParameterName();
            if (object == null || (object = object.getReferencedNameAsName()) == null) {
                continue;
            }
            Object name = object;
            upperBoundCheckRequests.add(new DescriptorResolver.UpperBoundCheckRequest((Name)name, typeReference, type2));
        }
        DescriptorResolver.checkUpperBoundTypes(this.trace, (List<DescriptorResolver.UpperBoundCheckRequest>)upperBoundCheckRequests);
        for (DescriptorResolver.UpperBoundCheckRequest request : upperBoundCheckRequests) {
            DescriptorResolver.checkBounds(request.upperBound, request.upperBoundType, this.trace);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkOnlyOneTypeParameterBound(TypeParameterDescriptor descriptor2, KtTypeParameter declaration, KtTypeParameterListOwner owner) {
        void boundsWhichAreTypeParameters;
        TypeConstructor typeConstructor2;
        Collection collection;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        List<KotlinType> upperBounds;
        List<KotlinType> list2 = upperBounds = descriptor2.getUpperBounds();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"upperBounds");
        Iterable iterable = list2;
        void var9_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void receiver;
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            collection = destination$iv$iv;
            typeConstructor2 = ((KotlinType)receiver).getConstructor();
            collection.add(typeConstructor2);
        }
        $receiver$iv = (List)destination$iv$iv;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $receiver$iv) {
            TypeConstructor constructor = (TypeConstructor)element$iv;
            if (constructor.getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Iterable pair = $receiver$iv = new Pair(first$iv, second$iv);
        Object object = TuplesKt.to((Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getFirst())), (Object)CollectionsKt.toSet((Iterable)((Iterable)pair.getSecond())));
        Set set = (Set)object.component1();
        Set otherBounds = (Set)object.component2();
        if (boundsWhichAreTypeParameters.size() > 1 || boundsWhichAreTypeParameters.size() == 1 && !(object = (Collection)otherBounds).isEmpty()) {
            KtModifierListOwnerStub ktModifierListOwnerStub;
            if (boundsWhichAreTypeParameters.size() + otherBounds.size() == 2) {
                Pair problematicBound;
                Object object2;
                Object v6;
                block10: {
                    Object element$iv$iv$iv;
                    Object element$iv$iv2;
                    Iterable $receiver$iv$iv2;
                    Iterable $receiver$iv2;
                    List<KtTypeConstraint> list3 = owner.getTypeConstraints();
                    Intrinsics.checkExpressionValueIsNotNull(list3, (String)"owner.typeConstraints");
                    pair = list3;
                    void $i$a$3$let = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv2) {
                        KtTypeConstraint constraint;
                        KtTypeConstraint ktTypeConstraint = constraint = (KtTypeConstraint)element$iv$iv2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeConstraint, (String)"constraint");
                        KtSimpleNameExpression ktSimpleNameExpression = ktTypeConstraint.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getReferencedNameAsName() : null), (Object)declaration.getNameAsName())) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    $receiver$iv2 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv2;
                    destination$iv$iv2 = new ArrayList();
                    Iterable $receiver$iv$iv$iv = $receiver$iv$iv2;
                    element$iv$iv2 = $receiver$iv$iv$iv.iterator();
                    while (element$iv$iv2.hasNext()) {
                        KtTypeReference ktTypeReference;
                        KtTypeConstraint constraint;
                        Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
                        KtTypeConstraint ktTypeConstraint = constraint = (KtTypeConstraint)element$iv$iv3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeConstraint, (String)"constraint");
                        if (ktTypeConstraint.getBoundTypeReference() == null) continue;
                        KtTypeReference it$iv$iv = ktTypeReference;
                        destination$iv$iv2.add(it$iv$iv);
                    }
                    $receiver$iv2 = (List)destination$iv$iv2;
                    $receiver$iv$iv2 = $receiver$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (Object item$iv$iv : $receiver$iv$iv2) {
                        void typeReference;
                        element$iv$iv$iv = (KtTypeReference)item$iv$iv;
                        collection = destination$iv$iv2;
                        typeConstructor2 = TuplesKt.to((Object)typeReference, this.trace.getBindingContext().get(BindingContext.TYPE, typeReference));
                        collection.add(typeConstructor2);
                    }
                    List allBounds = (List)destination$iv$iv2;
                    Iterable $receiver$iv3 = allBounds;
                    for (Object element$iv : $receiver$iv3) {
                        Pair bound = (Pair)element$iv;
                        KotlinType kotlinType = (KotlinType)bound.getSecond();
                        if (!(Intrinsics.areEqual((Object)(kotlinType != null ? kotlinType.getConstructor() : null), (Object)((TypeConstructor)CollectionsKt.first((Iterable)((Iterable)boundsWhichAreTypeParameters)))) ^ true)) continue;
                        v6 = element$iv;
                        break block10;
                    }
                    v6 = null;
                }
                ktModifierListOwnerStub = (object2 = (problematicBound = (Pair)v6)) != null && (object2 = (KtTypeReference)object2.getFirst()) != null ? (KtModifierListOwnerStub)object2 : (KtModifierListOwnerStub)declaration;
            } else {
                ktModifierListOwnerStub = declaration;
            }
            KtModifierListOwnerStub reportOn = ktModifierListOwnerStub;
            this.trace.report(Errors.BOUNDS_NOT_ALLOWED_IF_BOUNDED_BY_TYPE_PARAMETER.on((KtElement)((PsiElement)reportOn)));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSupertypesForConsistency(ClassifierDescriptor classifier2, PsiElement sourceElement) {
        Object object;
        Object object2;
        Object destination$iv$iv;
        if (classifier2 instanceof TypeParameterDescriptor) {
            void $receiver$iv$iv;
            List<KotlinType> list2 = ((TypeParameterDescriptor)classifier2).getUpperBounds();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"classifier.upperBounds");
            Iterable entry = list2;
            Iterable iterable = entry;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)entry, (int)10));
            for (Map.Entry item$iv$iv : $receiver$iv$iv) {
                void it;
                KotlinType kotlinType = (KotlinType)((Object)item$iv$iv);
                object2 = destination$iv$iv;
                object = it.getConstructor();
                object2.add(object);
            }
            List immediateUpperBounds = (List)destination$iv$iv;
            if (immediateUpperBounds.size() != CollectionsKt.toSet((Iterable)immediateUpperBounds).size()) {
                return;
            }
        }
        Multimap<TypeParameterDescriptor, TypeProjection> multiMap = SubstitutionUtils.buildDeepSubstitutionMultimap(classifier2.getDefaultType());
        Map<TypeParameterDescriptor, Collection<TypeProjection>> map2 = multiMap.asMap();
        Intrinsics.checkExpressionValueIsNotNull(map2, (String)"multiMap.asMap()");
        destination$iv$iv = map2;
        for (Map.Entry entry : destination$iv$iv.entrySet()) {
            ClassDescriptor containingDeclaration;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Map.Entry item$iv$iv;
            item$iv$iv = entry;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)item$iv$iv.getKey();
            item$iv$iv = entry;
            Collection projections = (Collection)item$iv$iv.getValue();
            if (projections.size() <= 1) continue;
            Collection collection = projections;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"projections");
            Iterable $i$a$1$map = $receiver$iv = (Iterable)collection;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv2 : $receiver$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv2;
                object2 = destination$iv$iv2;
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                object = v3.getType();
                object2.add(object);
            }
            Set conflictingTypes = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv2));
            DeclarationsChecker.Companion.removeDuplicateTypes(conflictingTypes);
            if (conflictingTypes.size() <= 1) continue;
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor2, (String)"typeParameterDescriptor");
            DeclarationDescriptor declarationDescriptor = typeParameterDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                declarationDescriptor = null;
            }
            if ((ClassDescriptor)declarationDescriptor == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Not a class descriptor: " + typeParameterDescriptor.getContainingDeclaration())));
            }
            if (sourceElement instanceof KtClassOrObject) {
                KtSuperTypeList delegationSpecifierList;
                if (((KtClassOrObject)sourceElement).getSuperTypeList() == null) {
                    continue;
                }
                this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on((KtSuperTypeList)((PsiElement)delegationSpecifierList), typeParameterDescriptor, containingDeclaration, conflictingTypes));
                continue;
            }
            if (!(sourceElement instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.INCONSISTENT_TYPE_PARAMETER_BOUNDS.on((KtTypeParameter)sourceElement, typeParameterDescriptor, containingDeclaration, conflictingTypes));
        }
    }

    private final void checkObject(KtObjectDeclaration declaration, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        if (declaration.isLocal() && !declaration.isCompanion() && !declaration.isObjectLiteral()) {
            this.trace.report(Errors.LOCAL_OBJECT_NOT_ALLOWED.on((KtObjectDeclaration)((PsiElement)declaration), classDescriptor));
        }
    }

    private final void checkClassButNotObject(KtClass aClass2, ClassDescriptorWithResolutionScopes classDescriptor) {
        this.checkOpenMembers(classDescriptor);
        this.checkTypeParameters(aClass2);
        this.checkTypeParameterConstraints(aClass2);
        FiniteBoundRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        NonExpansiveInheritanceRestrictionChecker.check(aClass2, classDescriptor, this.trace);
        if (aClass2.isInterface()) {
            this.checkConstructorInInterface(aClass2);
            this.checkMethodsOfAnyInInterface(classDescriptor);
            if (aClass2.isLocal() && !(classDescriptor.getContainingDeclaration() instanceof ClassDescriptor)) {
                this.trace.report(Errors.LOCAL_INTERFACE_NOT_ALLOWED.on((KtClass)((PsiElement)aClass2), classDescriptor));
            }
        } else if (classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS) {
            this.checkAnnotationClassMembers(aClass2);
            this.checkValOnAnnotationParameter(aClass2);
        } else if (aClass2 instanceof KtEnumEntry) {
            this.checkEnumEntry((KtEnumEntry)aClass2, classDescriptor);
        }
    }

    private final void checkPrimaryConstructor(KtClassOrObject classOrObject, ClassDescriptor classDescriptor) {
        KtModifierList it;
        PsiElement psiElement;
        ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
        if (classConstructorDescriptor == null) {
            return;
        }
        ClassConstructorDescriptor primaryConstructor2 = classConstructorDescriptor;
        KtPrimaryConstructor ktPrimaryConstructor = classOrObject.getPrimaryConstructor();
        if (ktPrimaryConstructor == null) {
            return;
        }
        KtPrimaryConstructor declaration = ktPrimaryConstructor;
        for (KtParameter parameter : declaration.getValueParameters()) {
            PropertyDescriptor propertyDescriptor;
            if ((PropertyDescriptor)this.trace.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter) == null) continue;
            PropertyDescriptor it2 = propertyDescriptor;
            this.modifiersChecker.checkModifiersForDeclaration(parameter, it2);
            KtParameter ktParameter = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktParameter, (String)"parameter");
            LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, ktParameter, it2);
        }
        if (!declaration.hasConstructorKeyword()) {
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList != null) {
                it = psiElement = ktModifierList;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_KEYWORD.on((KtElement)((PsiElement)it)));
            }
        }
        if (declaration.getValueParameterList() == null) {
            PsiElement psiElement2 = declaration.getConstructorKeyword();
            if (psiElement2 != null) {
                it = psiElement = psiElement2;
                this.trace.report(Errors.MISSING_CONSTRUCTOR_BRACKETS.on(it));
            }
        }
        if (!(classOrObject instanceof KtClass)) {
            this.trace.report(Errors.CONSTRUCTOR_IN_OBJECT.on((KtDeclaration)((PsiElement)declaration)));
        }
        ClassConstructorDescriptor classConstructorDescriptor2 = primaryConstructor2;
        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor2, (String)"primaryConstructor");
        this.checkConstructorDeclaration(classConstructorDescriptor2, declaration);
    }

    private final void checkTypeParameters(KtTypeParameterListOwner typeParameterListOwner) {
        for (KtTypeParameter jetTypeParameter : typeParameterListOwner.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor;
            AnnotationResolverImpl.reportUnsupportedAnnotationForTypeParameter(jetTypeParameter, this.trace);
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, jetTypeParameter) == null) continue;
            TypeParameterDescriptor it = typeParameterDescriptor;
            DescriptorResolver.checkConflictingUpperBounds(this.trace, it, jetTypeParameter);
        }
    }

    private final void checkTypeParameterConstraints(KtTypeParameterListOwner typeParameterListOwner) {
        List<KtTypeConstraint> constraints = typeParameterListOwner.getTypeConstraints();
        if (constraints.isEmpty()) {
            return;
        }
        Iterator<KtTypeParameter> iterator2 = typeParameterListOwner.getTypeParameters().iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor;
            KtTypeParameter typeParameter;
            KtTypeParameter ktTypeParameter = typeParameter = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)ktTypeParameter, (String)"typeParameter");
            if (ktTypeParameter.getExtendsBound() != null) {
                List<KtTypeConstraint> list2 = constraints;
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"constraints");
                if (DeclarationsChecker.Companion.hasConstraints(typeParameter, list2)) {
                    this.trace.report(Errors.MISPLACED_TYPE_PARAMETER_CONSTRAINTS.on((KtTypeParameter)((PsiElement)typeParameter)));
                }
            }
            if ((TypeParameterDescriptor)this.trace.get(BindingContext.TYPE_PARAMETER, typeParameter) == null) {
                continue;
            }
            this.checkSupertypesForConsistency(typeParameterDescriptor, typeParameter);
            this.checkOnlyOneTypeParameterBound(typeParameterDescriptor, typeParameter, typeParameterListOwner);
        }
    }

    private final void checkConstructorInInterface(KtClass klass2) {
        block0: {
            KtPrimaryConstructor ktPrimaryConstructor;
            KtPrimaryConstructor ktPrimaryConstructor2 = klass2.getPrimaryConstructor();
            if (ktPrimaryConstructor2 == null) break block0;
            KtPrimaryConstructor it = ktPrimaryConstructor = ktPrimaryConstructor2;
            this.trace.report(Errors.CONSTRUCTOR_IN_INTERFACE.on((KtDeclaration)((PsiElement)it)));
        }
    }

    private final void checkMethodsOfAnyInInterface(ClassDescriptorWithResolutionScopes classDescriptor) {
        for (CallableMemberDescriptor declaredCallableMember : classDescriptor.getDeclaredCallableMembers()) {
            PsiElement declaration;
            if (!(declaredCallableMember instanceof FunctionDescriptor) || !((declaration = DescriptorToSourceUtils.descriptorToDeclaration(declaredCallableMember)) instanceof KtNamedFunction) || DeclarationsChecker.Companion.isHidingParentMemberIfPresent(declaredCallableMember) || !DeclarationsChecker.Companion.isImplementingMethodOfAny(declaredCallableMember)) continue;
            this.trace.report(Errors.METHOD_OF_ANY_IMPLEMENTED_IN_INTERFACE.on((KtDeclaration)declaration));
        }
    }

    private final void checkAnnotationClassMembers(KtClassOrObject classOrObject) {
        for (KtDeclaration declaration : classOrObject.getDeclarations()) {
            if (declaration instanceof KtClassOrObject && this.languageVersionSettings.supportsFeature(LanguageFeature.NestedClassesInAnnotations)) continue;
            this.trace.report(Errors.ANNOTATION_CLASS_MEMBER.on(declaration));
        }
    }

    private final void checkValOnAnnotationParameter(KtClass aClass2) {
        for (KtParameter parameter : aClass2.getPrimaryConstructorParameters()) {
            if (!parameter.hasValOrVar()) {
                this.trace.report(Errors.MISSING_VAL_ON_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
                continue;
            }
            if (!parameter.isMutable()) continue;
            this.trace.report(Errors.VAR_ANNOTATION_PARAMETER.on((KtParameter)((PsiElement)parameter)));
        }
    }

    private final void checkOpenMembers(ClassDescriptorWithResolutionScopes classDescriptor) {
        if (DescriptorUtils.classCanHaveOpenMembers(classDescriptor)) {
            return;
        }
        Iterator<CallableMemberDescriptor> iterator2 = classDescriptor.getDeclaredCallableMembers().iterator();
        while (iterator2.hasNext()) {
            KtNamedDeclaration member;
            CallableMemberDescriptor memberDescriptor;
            CallableMemberDescriptor callableMemberDescriptor = memberDescriptor = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"memberDescriptor");
            if (callableMemberDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) continue;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(memberDescriptor);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            if ((member = (KtNamedDeclaration)psiElement) == null || !member.hasModifier(KtTokens.OPEN_KEYWORD)) continue;
            if (classDescriptor.getKind() == ClassKind.OBJECT) {
                this.trace.report(Errors.NON_FINAL_MEMBER_IN_OBJECT.on((KtNamedDeclaration)((PsiElement)member)));
                continue;
            }
            this.trace.report(Errors.NON_FINAL_MEMBER_IN_FINAL_CLASS.on((KtNamedDeclaration)((PsiElement)member)));
        }
    }

    private final void checkProperty(KtProperty property, PropertyDescriptor propertyDescriptor) {
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        if (containingDeclaration instanceof ClassDescriptor) {
            this.checkMemberProperty(property, propertyDescriptor, (ClassDescriptor)containingDeclaration);
        }
        LateinitModifierApplicabilityChecker.INSTANCE.checkLateinitModifierApplicability(this.trace, property, propertyDescriptor);
        this.checkPropertyInitializer(property, propertyDescriptor);
        this.checkAccessors(property, propertyDescriptor);
        this.checkTypeParameterConstraints(property);
        ExposedVisibilityChecker.checkProperty$default(this.exposedChecker, property, propertyDescriptor, null, 4, null);
        this.shadowedExtensionChecker.checkDeclaration(property, propertyDescriptor);
        this.checkPropertyTypeParametersAreUsedInReceiverType(propertyDescriptor);
        this.checkImplicitCallableType(property, propertyDescriptor);
        this.checkPrivateExpectedDeclaration(property, propertyDescriptor);
    }

    private final void checkPrivateExpectedDeclaration(KtDeclaration declaration, MemberDescriptor descriptor2) {
        if (descriptor2.isExpect() && Visibilities.isPrivate(descriptor2.getVisibility())) {
            PsiElement psiElement = declaration.getModifierList();
            if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.PRIVATE_KEYWORD)) == null) {
                psiElement = declaration;
            }
            this.trace.report(Errors.EXPECTED_PRIVATE_DECLARATION.on(psiElement));
        }
    }

    private final void checkPropertyTypeParametersAreUsedInReceiverType(PropertyDescriptor descriptor2) {
        List<TypeParameterDescriptor> list2 = descriptor2.getTypeParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"descriptor.typeParameters");
        Set allTypeParameters = CollectionsKt.toSet((Iterable)list2);
        HashSet allAccessibleTypeParameters = new HashSet();
        Function1<KotlinType, Unit> addAccessibleTypeParametersFromType$ = new Function1<KotlinType, Unit>(allTypeParameters, allAccessibleTypeParameters){
            final /* synthetic */ Set $allTypeParameters;
            final /* synthetic */ HashSet $allAccessibleTypeParameters;

            public final void invoke(@Nullable KotlinType type2) {
                TypeUtils.contains(type2, (Function1<UnwrappedType, Boolean>)((Function1)new Function1<UnwrappedType, Boolean>(this){
                    final /* synthetic */ checkPropertyTypeParametersAreUsedInReceiverType.1 this$0;

                    public final Boolean invoke(UnwrappedType it) {
                        ClassifierDescriptor declarationDescriptor = it.getConstructor().getDeclarationDescriptor();
                        if (declarationDescriptor instanceof TypeParameterDescriptor && this.this$0.$allTypeParameters.contains(declarationDescriptor) && this.this$0.$allAccessibleTypeParameters.add(declarationDescriptor)) {
                            List<KotlinType> list2 = ((TypeParameterDescriptor)declarationDescriptor).getUpperBounds();
                            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"declarationDescriptor.upperBounds");
                            Iterable $receiver$iv = list2;
                            for (T element$iv : $receiver$iv) {
                                KotlinType p1 = (KotlinType)element$iv;
                                this.this$0.invoke(p1);
                            }
                        }
                        return false;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }));
            }
            {
                this.$allTypeParameters = set;
                this.$allAccessibleTypeParameters = hashSet;
                super(1);
            }
        };
        ReceiverParameterDescriptor receiverParameterDescriptor = descriptor2.getExtensionReceiverParameter();
        addAccessibleTypeParametersFromType$.invoke(receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null);
        Set typeParametersInaccessibleFromReceiver = SetsKt.minus((Set)allTypeParameters, (Iterable)allAccessibleTypeParameters);
        Iterator iterator2 = typeParametersInaccessibleFromReceiver.iterator();
        while (iterator2.hasNext()) {
            TypeParameterDescriptor typeParameter;
            TypeParameterDescriptor typeParameterDescriptor = typeParameter = (TypeParameterDescriptor)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)typeParameterDescriptor, (String)"typeParameter");
            PsiElement typeParameterPsi = DescriptorToSourceUtils.getSourceFromDescriptor(typeParameterDescriptor);
            if (!(typeParameterPsi instanceof KtTypeParameter)) continue;
            this.trace.report(Errors.TYPE_PARAMETER_OF_PROPERTY_NOT_USED_IN_RECEIVER.on((KtTypeParameter)typeParameterPsi));
        }
    }

    private final void checkMemberProperty(KtProperty property, PropertyDescriptor propertyDescriptor, ClassDescriptor classDescriptor) {
        KtModifierList modifierList = property.getModifierList();
        if (modifierList != null) {
            if (modifierList.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                if (!DescriptorUtils.classCanHaveAbstractDeclaration(classDescriptor)) {
                    PsiElement psiElement = property;
                    String string = property.getName();
                    if (string == null) {
                        string = "";
                    }
                    this.trace.report(Errors.ABSTRACT_PROPERTY_IN_NON_ABSTRACT_CLASS.on((KtModifierListOwner)psiElement, string, classDescriptor));
                    return;
                }
            } else if (classDescriptor.getKind() == ClassKind.INTERFACE && modifierList.hasModifier(KtTokens.OPEN_KEYWORD) && propertyDescriptor.getModality() == Modality.ABSTRACT) {
                this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)property)));
            }
        }
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            KtPropertyAccessor setter2;
            KtExpression it;
            KtElement ktElement;
            KtExpression ktExpression = property.getInitializer();
            if (ktExpression != null) {
                it = ktElement = ktExpression;
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_INITIALIZER.on((KtExpression)((PsiElement)it)));
            }
            KtPropertyDelegate ktPropertyDelegate = property.getDelegate();
            if (ktPropertyDelegate != null) {
                it = ktElement = ktPropertyDelegate;
                this.trace.report(Errors.ABSTRACT_DELEGATED_PROPERTY.on((KtPropertyDelegate)((Object)it)));
            }
            KtPropertyAccessor getter2 = property.getGetter();
            if (getter2 != null && getter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_GETTER.on((KtPropertyAccessor)((PsiElement)getter2)));
            }
            if ((setter2 = property.getSetter()) != null && setter2.hasBody()) {
                this.trace.report(Errors.ABSTRACT_PROPERTY_WITH_SETTER.on((KtPropertyAccessor)((PsiElement)setter2)));
            }
        }
    }

    private final void checkPropertyInitializer(KtProperty property, PropertyDescriptor propertyDescriptor) {
        boolean backingFieldRequired;
        boolean hasAccessorImplementation = Companion.hasAccessorImplementation(propertyDescriptor);
        DeclarationDescriptor containingDeclaration = propertyDescriptor.getContainingDeclaration();
        boolean inInterface = DescriptorUtils.isInterface(containingDeclaration);
        if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
            if (!property.hasDelegateExpressionOrInitializer() && property.getTypeReference() == null) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (inInterface && property.hasModifier(KtTokens.PRIVATE_KEYWORD) && !property.hasModifier(KtTokens.ABSTRACT_KEYWORD)) {
                this.trace.report(Errors.PRIVATE_PROPERTY_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
            }
            return;
        }
        Boolean bl = (Boolean)this.trace.getBindingContext().get(BindingContext.BACKING_FIELD_REQUIRED, propertyDescriptor);
        boolean bl2 = backingFieldRequired = bl != null ? bl : false;
        if (inInterface && backingFieldRequired && hasAccessorImplementation) {
            this.trace.report(Errors.BACKING_FIELD_IN_INTERFACE.on((KtProperty)((PsiElement)property)));
        }
        KtExpression initializer2 = property.getInitializer();
        KtPropertyDelegate delegate = property.getDelegate();
        boolean isExpect = propertyDescriptor.isExpect();
        if (initializer2 != null) {
            if (inInterface) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_IN_INTERFACE.on((KtExpression)((PsiElement)initializer2)));
            } else if (isExpect) {
                this.trace.report(Errors.EXPECTED_PROPERTY_INITIALIZER.on((KtExpression)((PsiElement)initializer2)));
            } else if (!backingFieldRequired) {
                this.trace.report(Errors.PROPERTY_INITIALIZER_NO_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            } else if (property.getReceiverTypeReference() != null) {
                this.trace.report(Errors.EXTENSION_PROPERTY_WITH_BACKING_FIELD.on((KtExpression)((PsiElement)initializer2)));
            }
        } else if (delegate != null) {
            if (inInterface) {
                this.trace.report(Errors.DELEGATED_PROPERTY_IN_INTERFACE.on((KtPropertyDelegate)((PsiElement)delegate)));
            } else if (isExpect) {
                this.trace.report(Errors.EXPECTED_DELEGATED_PROPERTY.on((KtPropertyDelegate)((PsiElement)delegate)));
            }
        } else {
            Boolean bl3 = (Boolean)this.trace.getBindingContext().get(BindingContext.IS_UNINITIALIZED, propertyDescriptor);
            boolean isUninitialized = bl3 != null ? bl3 : false;
            boolean isExternal = DescriptorUtilsKt.isEffectivelyExternal(propertyDescriptor);
            if (backingFieldRequired && !inInterface && !propertyDescriptor.isLateInit() && !isExpect && isUninitialized && !isExternal) {
                if (propertyDescriptor.getExtensionReceiverParameter() != null && !hasAccessorImplementation) {
                    this.trace.report(Errors.EXTENSION_PROPERTY_MUST_HAVE_ACCESSORS_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                } else if (this.diagnosticSuppressor.shouldReportNoBody(propertyDescriptor)) {
                    if (!(containingDeclaration instanceof ClassDescriptor) || hasAccessorImplementation) {
                        this.trace.report(Errors.MUST_BE_INITIALIZED.on((KtProperty)((PsiElement)property)));
                    } else {
                        this.trace.report(Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.on((KtProperty)((PsiElement)property)));
                    }
                }
            } else if (property.getTypeReference() == null && !this.languageVersionSettings.supportsFeature(LanguageFeature.ShortSyntaxForPropertyGetters)) {
                this.trace.report(Errors.UNSUPPORTED_FEATURE.on(property, (Pair<LanguageFeature, LanguageVersionSettings>)TuplesKt.to((Object)((Object)LanguageFeature.ShortSyntaxForPropertyGetters), (Object)this.languageVersionSettings)));
            } else if (this.noExplicitTypeOrGetterType(property)) {
                this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on((KtProperty)((PsiElement)property)));
            }
            if (propertyDescriptor.isLateInit()) {
                if (propertyDescriptor.isExpect()) {
                    PsiElement psiElement = property.getModifierList();
                    if (psiElement == null || (psiElement = psiElement.getModifier(KtTokens.LATEINIT_KEYWORD)) == null) {
                        psiElement = property;
                    }
                    this.trace.report(Errors.EXPECTED_LATEINIT_PROPERTY.on(psiElement));
                }
                if (backingFieldRequired && !inInterface && !isUninitialized && Intrinsics.areEqual((Object)((Boolean)this.trace.get(BindingContext.MUST_BE_LATEINIT, propertyDescriptor)), (Object)true) ^ true) {
                    this.trace.report(Errors.UNNECESSARY_LATEINIT.on((KtProperty)((PsiElement)property)));
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean noExplicitTypeOrGetterType(KtProperty property) {
        if (property.getTypeReference() != null) return false;
        if (property.getGetter() == null) return true;
        KtPropertyAccessor ktPropertyAccessor = property.getGetter();
        if (ktPropertyAccessor == null) {
            Intrinsics.throwNpe();
        }
        if (!ktPropertyAccessor.hasBlockBody()) return false;
        KtPropertyAccessor ktPropertyAccessor2 = property.getGetter();
        if (ktPropertyAccessor2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)ktPropertyAccessor2, (String)"property.getter!!");
        if (ktPropertyAccessor2.getReturnTypeReference() != null) return false;
        return true;
    }

    public final void checkFunction(@NotNull KtNamedFunction function2, @NotNull SimpleFunctionDescriptor functionDescriptor) {
        Intrinsics.checkParameterIsNotNull((Object)function2, (String)"function");
        Intrinsics.checkParameterIsNotNull((Object)functionDescriptor, (String)"functionDescriptor");
        KtTypeParameterList typeParameterList = function2.getTypeParameterList();
        PsiElement nameIdentifier = function2.getNameIdentifier();
        if (typeParameterList != null && nameIdentifier != null) {
            TextRange textRange = typeParameterList.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"typeParameterList.textRange");
            int n = textRange.getStartOffset();
            TextRange textRange2 = nameIdentifier.getTextRange();
            Intrinsics.checkExpressionValueIsNotNull((Object)textRange2, (String)"nameIdentifier.textRange");
            if (n > textRange2.getStartOffset()) {
                this.trace.report(Errors.DEPRECATED_TYPE_PARAMETER_SYNTAX.on((KtTypeParameterList)((PsiElement)typeParameterList)));
            }
        }
        this.checkTypeParameterConstraints(function2);
        this.checkImplicitCallableType(function2, functionDescriptor);
        ExposedVisibilityChecker.checkFunction$default(this.exposedChecker, function2, functionDescriptor, null, 4, null);
        this.checkVarargParameters(this.trace, functionDescriptor);
        DeclarationDescriptor containingDescriptor = functionDescriptor.getContainingDeclaration();
        boolean hasAbstractModifier = function2.hasModifier(KtTokens.ABSTRACT_KEYWORD);
        boolean hasExternalModifier = DescriptorUtilsKt.isEffectivelyExternal(functionDescriptor);
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean hasBody;
            boolean inInterface = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.INTERFACE;
            boolean isExpectClass = ((ClassDescriptor)containingDescriptor).isExpect();
            if (hasAbstractModifier && !DescriptorUtils.classCanHaveAbstractDeclaration((ClassDescriptor)containingDescriptor)) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_IN_NON_ABSTRACT_CLASS.on((KtFunction)((PsiElement)function2), functionDescriptor.getName().asString(), (ClassDescriptor)containingDescriptor));
            }
            if ((hasBody = function2.hasBody()) && hasAbstractModifier) {
                this.trace.report(Errors.ABSTRACT_FUNCTION_WITH_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
            if (!hasBody && inInterface) {
                if (function2.hasModifier(KtTokens.PRIVATE_KEYWORD)) {
                    this.trace.report(Errors.PRIVATE_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
                }
                if (!hasAbstractModifier && function2.hasModifier(KtTokens.OPEN_KEYWORD)) {
                    this.trace.report(Errors.REDUNDANT_OPEN_IN_INTERFACE.on((KtModifierListOwner)((PsiElement)function2)));
                }
            }
            if (!(hasBody || hasAbstractModifier || hasExternalModifier || inInterface || isExpectClass || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
                this.trace.report(Errors.NON_ABSTRACT_FUNCTION_WITH_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
            }
        } else if (!(function2.hasBody() || hasAbstractModifier || hasExternalModifier || functionDescriptor.isExpect() || !this.diagnosticSuppressor.shouldReportNoBody(functionDescriptor))) {
            this.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function2), functionDescriptor));
        }
        if (functionDescriptor.isExpect()) {
            this.checkExpectedFunction(function2, functionDescriptor);
        }
        if (functionDescriptor.isActual()) {
            this.checkActualFunction(function2, functionDescriptor);
        }
        this.shadowedExtensionChecker.checkDeclaration(function2, functionDescriptor);
    }

    private final void checkExpectedFunction(KtNamedFunction function2, FunctionDescriptor functionDescriptor) {
        if (function2.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)function2)));
        }
        this.checkPrivateExpectedDeclaration(function2, functionDescriptor);
    }

    private final void checkActualFunction(KtDeclaration element, FunctionDescriptor functionDescriptor) {
        if (!DescriptorUtilsKt.isAnnotationConstructor(functionDescriptor)) {
            for (ValueParameterDescriptor valueParameter : functionDescriptor.getValueParameters()) {
                if (!valueParameter.declaresDefaultValue()) continue;
                ValueParameterDescriptor valueParameterDescriptor = valueParameter;
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"valueParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
                if (psiElement == null) {
                    psiElement = element;
                }
                this.trace.report(Errors.ACTUAL_FUNCTION_WITH_DEFAULT_ARGUMENTS.on(psiElement));
            }
        }
    }

    private final void checkImplicitCallableType(KtCallableDeclaration declaration, CallableDescriptor descriptor2) {
        block2: {
            PsiElement target;
            KotlinType it;
            block3: {
                KotlinType kotlinType;
                KotlinType kotlinType2 = descriptor2.getReturnType();
                if (kotlinType2 == null || (kotlinType2 = kotlinType2.unwrap()) == null) break block2;
                it = kotlinType = kotlinType2;
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = target = (PsiElement)declaration;
                }
                if (declaration.getTypeReference() != null) break block3;
                if (TypeUtilsKt.isNothing(it) && !declaration.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                    this.trace.report((declaration instanceof KtProperty ? Errors.IMPLICIT_NOTHING_PROPERTY_TYPE : Errors.IMPLICIT_NOTHING_RETURN_TYPE).on(target));
                }
                if (!TypeUtilsKt.contains(it, (Function1<? super UnwrappedType, Boolean>)((Function1)checkImplicitCallableType.1.1.INSTANCE))) break block2;
                this.trace.report(Errors.IMPLICIT_INTERSECTION_TYPE.on(target, it));
                break block2;
            }
            if (!TypeUtilsKt.isNothing(it) || !(it instanceof AbbreviatedType)) break block2;
            this.trace.report((declaration instanceof KtProperty ? Errors.ABBREVIATED_NOTHING_PROPERTY_TYPE : Errors.ABBREVIATED_NOTHING_RETURN_TYPE).on(target));
        }
    }

    private final void checkAccessors(KtProperty property, PropertyDescriptor propertyDescriptor) {
        for (PropertyAccessorDescriptor accessorDescriptor : propertyDescriptor.getAccessors()) {
            KtPropertyAccessor accessor;
            KtPropertyAccessor ktPropertyAccessor = accessor = accessorDescriptor instanceof PropertyGetterDescriptor ? property.getGetter() : property.getSetter();
            if (accessor != null) {
                this.modifiersChecker.checkModifiersForDeclaration(accessor, accessorDescriptor);
                this.identifierChecker.checkDeclaration(accessor, this.trace);
                continue;
            }
            this.modifiersChecker.runDeclarationCheckers(property, accessorDescriptor);
        }
        this.checkAccessor(propertyDescriptor, property.getGetter(), propertyDescriptor.getGetter());
        this.checkAccessor(propertyDescriptor, property.getSetter(), propertyDescriptor.getSetter());
    }

    private final void reportVisibilityModifierDiagnostics(Collection<? extends PsiElement> tokens, DiagnosticFactory0<PsiElement> diagnostic) {
        for (PsiElement psiElement : tokens) {
            this.trace.report(diagnostic.on(psiElement));
        }
    }

    private final void checkAccessor(PropertyDescriptor propertyDescriptor, KtPropertyAccessor accessor, PropertyAccessorDescriptor accessorDescriptor) {
        if (accessor == null || accessorDescriptor == null) {
            return;
        }
        if (propertyDescriptor.isExpect() && accessor.hasBody()) {
            this.trace.report(Errors.EXPECTED_DECLARATION_WITH_BODY.on((KtDeclaration)((PsiElement)accessor)));
        }
        KtModifierList ktModifierList = accessor.getModifierList();
        if (ktModifierList == null) {
            return;
        }
        KtModifierList accessorModifierList = ktModifierList;
        Map<KtModifierKeywordToken, PsiElement> tokens = this.modifiersChecker.getTokensCorrespondingToModifiers(accessorModifierList, SetsKt.setOf((Object[])new KtModifierKeywordToken[]{KtTokens.PUBLIC_KEYWORD, KtTokens.PROTECTED_KEYWORD, KtTokens.PRIVATE_KEYWORD, KtTokens.INTERNAL_KEYWORD}));
        if (accessor.isGetter()) {
            if (Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)propertyDescriptor.getVisibility()) ^ true) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.GETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.GETTER_VISIBILITY\u2026_FROM_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.REDUNDANT_MODIFIER_IN_GETTER;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.REDUNDANT_MODIFIER_IN_GETTER");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else if (ModalityKt.isOverridable(propertyDescriptor) && Intrinsics.areEqual((Object)accessorDescriptor.getVisibility(), (Object)Visibilities.PRIVATE) && Intrinsics.areEqual((Object)propertyDescriptor.getVisibility(), (Object)Visibilities.PRIVATE) ^ true) {
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_ABSTRACT_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            } else {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.PRIVATE_SETTER_FOR_OPEN_PROPERTY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        } else {
            Integer compare = Visibilities.compare(accessorDescriptor.getVisibility(), propertyDescriptor.getVisibility());
            if (compare == null || Intrinsics.compare((int)compare, (int)0) > 0) {
                Collection<PsiElement> collection = tokens.values();
                DiagnosticFactory0<PsiElement> diagnosticFactory0 = Errors.SETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY;
                Intrinsics.checkExpressionValueIsNotNull(diagnosticFactory0, (String)"Errors.SETTER_VISIBILITY\u2026_WITH_PROPERTY_VISIBILITY");
                this.reportVisibilityModifierDiagnostics(collection, diagnosticFactory0);
            }
        }
    }

    private final void checkEnumEntry(KtEnumEntry enumEntry, ClassDescriptor enumEntryClass) {
        DeclarationDescriptor declarationDescriptor = enumEntryClass.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
        }
        ClassDescriptor enumClass2 = (ClassDescriptor)declarationDescriptor;
        if (DescriptorUtils.isEnumClass(enumClass2)) {
            if (enumClass2.isExpect() && enumEntry.getBody() != null) {
                this.trace.report(Errors.EXPECTED_ENUM_ENTRY_WITH_BODY.on((KtEnumEntry)((PsiElement)enumEntry)));
            }
        } else {
            boolean bl = DescriptorUtils.isInterface(enumClass2);
            if (_Assertions.ENABLED && !bl) {
                String string = "Enum entry should be declared in enum class: " + enumEntryClass;
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    private final void checkVarargParameters(BindingTrace trace, CallableDescriptor callableDescriptor) {
        Iterator $receiver$iv$iv;
        Iterable $receiver$iv;
        List<ValueParameterDescriptor> list2 = callableDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"callableDescriptor.valueParameters");
        Iterable iterable = $receiver$iv = (Iterable)list2;
        Collection destination$iv$iv = new ArrayList();
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv$iv = iterator2.next();
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv$iv;
            if (!(it.getVarargElementType() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List varargParameters = (List)destination$iv$iv;
        if (varargParameters.size() > 1) {
            $receiver$iv$iv = varargParameters.iterator();
            while ($receiver$iv$iv.hasNext()) {
                KtParameter parameterDeclaration;
                ValueParameterDescriptor parameter;
                ValueParameterDescriptor valueParameterDescriptor = parameter = (ValueParameterDescriptor)$receiver$iv$iv.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
                if (!(psiElement instanceof KtParameter)) {
                    psiElement = null;
                }
                if ((KtParameter)psiElement == null) {
                    continue;
                }
                trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtParameter)((PsiElement)parameterDeclaration)));
            }
        }
        SimpleType nullableNothing = DescriptorUtilsKt.getBuiltIns(callableDescriptor).getNullableNothingType();
        for (ValueParameterDescriptor parameter : varargParameters) {
            KtParameter parameterDeclaration;
            SimpleType varargElementType;
            KotlinType kotlinType = parameter.getVarargElementType();
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(varargElementType = FlexibleTypesKt.upperIfFlexible(kotlinType), nullableNothing) && !InlineClassesUtilsKt.isInlineClassType(varargElementType)) continue;
            ValueParameterDescriptor valueParameterDescriptor = parameter;
            Intrinsics.checkExpressionValueIsNotNull((Object)valueParameterDescriptor, (String)"parameter");
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(valueParameterDescriptor);
            if (!(psiElement instanceof KtParameter)) {
                psiElement = null;
            }
            if ((KtParameter)psiElement == null) {
                continue;
            }
            trace.report(Errors.FORBIDDEN_VARARG_PARAMETER_TYPE.on((KtParameter)((PsiElement)parameterDeclaration), varargElementType));
        }
    }

    public DeclarationsChecker(@NotNull DescriptorResolver descriptorResolver, @NotNull ModifiersChecker modifiersChecker, @NotNull AnnotationChecker annotationChecker, @NotNull IdentifierChecker identifierChecker, @NotNull BindingTrace trace, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull PlatformDiagnosticSuppressor diagnosticSuppressor) {
        Intrinsics.checkParameterIsNotNull((Object)descriptorResolver, (String)"descriptorResolver");
        Intrinsics.checkParameterIsNotNull((Object)modifiersChecker, (String)"modifiersChecker");
        Intrinsics.checkParameterIsNotNull((Object)annotationChecker, (String)"annotationChecker");
        Intrinsics.checkParameterIsNotNull((Object)identifierChecker, (String)"identifierChecker");
        Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
        Intrinsics.checkParameterIsNotNull((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkParameterIsNotNull((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkParameterIsNotNull((Object)diagnosticSuppressor, (String)"diagnosticSuppressor");
        this.descriptorResolver = descriptorResolver;
        this.annotationChecker = annotationChecker;
        this.identifierChecker = identifierChecker;
        this.trace = trace;
        this.languageVersionSettings = languageVersionSettings;
        this.diagnosticSuppressor = diagnosticSuppressor;
        this.modifiersChecker = modifiersChecker.withTrace(this.trace);
        this.exposedChecker = new ExposedVisibilityChecker(this.trace);
        this.shadowedExtensionChecker = new ShadowedExtensionChecker(typeSpecificityComparator, this.trace);
    }

    static {
        Companion = new Companion(null);
        METHOD_OF_ANY_NAMES = ImmutableSet.of("toString", "hashCode", "equals");
    }

    @NotNull
    public static final /* synthetic */ BindingTrace access$getTrace$p(DeclarationsChecker $this) {
        return $this.trace;
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\"\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0005H\u0016J\u0010\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$TypeAliasDeclarationCheckingReportStrategy;", "Lorg/jetbrains/kotlin/resolve/TypeAliasExpansionReportStrategy;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "typeAliasDescriptor", "Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;", "declaration", "Lorg/jetbrains/kotlin/psi/KtTypeAlias;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/descriptors/TypeAliasDescriptor;Lorg/jetbrains/kotlin/psi/KtTypeAlias;)V", "typeReference", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "boundsViolationInSubstitution", "", "bound", "Lorg/jetbrains/kotlin/types/KotlinType;", "unsubstitutedArgument", "argument", "typeParameter", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "conflictingProjection", "typeAlias", "substitutedArgument", "recursiveTypeAlias", "repeatedAnnotation", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "wrongNumberOfTypeArguments", "numberOfParameters", "", "frontend"})
    private static final class TypeAliasDeclarationCheckingReportStrategy
    implements TypeAliasExpansionReportStrategy {
        private final KtTypeReference typeReference;
        private final BindingTrace trace;

        @Override
        public void wrongNumberOfTypeArguments(@NotNull TypeAliasDescriptor typeAlias, int numberOfParameters) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
        }

        @Override
        public void conflictingProjection(@NotNull TypeAliasDescriptor typeAlias, @Nullable TypeParameterDescriptor typeParameter, @NotNull KotlinType substitutedArgument) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
            Intrinsics.checkParameterIsNotNull((Object)substitutedArgument, (String)"substitutedArgument");
            this.trace.report(Errors.CONFLICTING_PROJECTION_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), substitutedArgument));
        }

        @Override
        public void recursiveTypeAlias(@NotNull TypeAliasDescriptor typeAlias) {
            Intrinsics.checkParameterIsNotNull((Object)typeAlias, (String)"typeAlias");
            this.trace.report(Errors.RECURSIVE_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), typeAlias));
        }

        @Override
        public void boundsViolationInSubstitution(@NotNull KotlinType bound, @NotNull KotlinType unsubstitutedArgument, @NotNull KotlinType argument, @NotNull TypeParameterDescriptor typeParameter) {
            Intrinsics.checkParameterIsNotNull((Object)bound, (String)"bound");
            Intrinsics.checkParameterIsNotNull((Object)unsubstitutedArgument, (String)"unsubstitutedArgument");
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            Intrinsics.checkParameterIsNotNull((Object)typeParameter, (String)"typeParameter");
            if (!TypeUtilsKt.containsTypeAliasParameters(argument) && !TypeUtilsKt.containsTypeAliasParameters(bound)) {
                this.trace.report(Errors.UPPER_BOUND_VIOLATED_IN_TYPEALIAS_EXPANSION.on((KtElement)((PsiElement)this.typeReference), bound, argument, typeParameter));
            }
        }

        @Override
        public void repeatedAnnotation(@NotNull AnnotationDescriptor annotation2) {
            Intrinsics.checkParameterIsNotNull((Object)annotation2, (String)"annotation");
            SourceElement sourceElement = annotation2.getSource();
            if (!(sourceElement instanceof KotlinSourceElement)) {
                sourceElement = null;
            }
            KotlinSourceElement kotlinSourceElement = (KotlinSourceElement)sourceElement;
            KtElement ktElement = kotlinSourceElement != null ? kotlinSourceElement.getPsi() : null;
            if (!(ktElement instanceof KtAnnotationEntry)) {
                ktElement = null;
            }
            KtAnnotationEntry ktAnnotationEntry = (KtAnnotationEntry)ktElement;
            if (ktAnnotationEntry == null) {
                return;
            }
            KtAnnotationEntry annotationEntry = ktAnnotationEntry;
            this.trace.report(Errors.REPEATED_ANNOTATION.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
        }

        public TypeAliasDeclarationCheckingReportStrategy(@NotNull BindingTrace trace, @NotNull TypeAliasDescriptor typeAliasDescriptor, @NotNull KtTypeAlias declaration) {
            Intrinsics.checkParameterIsNotNull((Object)trace, (String)"trace");
            Intrinsics.checkParameterIsNotNull((Object)typeAliasDescriptor, (String)"typeAliasDescriptor");
            Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
            this.trace = trace;
            KtTypeReference ktTypeReference = declaration.getTypeReference();
            if (ktTypeReference == null) {
                throw (Throwable)((Object)new AssertionError((Object)("Incorrect type alias declaration for " + typeAliasDescriptor)));
            }
            this.typeReference = ktTypeReference;
        }
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0014H\u0002J\n\u0010\u001a\u001a\u00020\b*\u00020\u001bR2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/DeclarationsChecker$Companion;", "", "()V", "METHOD_OF_ANY_NAMES", "Lorg/jetbrains/kotlin/com/google/common/collect/ImmutableSet;", "", "kotlin.jvm.PlatformType", "hasConstraints", "", "typeParameter", "Lorg/jetbrains/kotlin/psi/KtTypeParameter;", "constraints", "", "Lorg/jetbrains/kotlin/psi/KtTypeConstraint;", "isHidingParentMemberIfPresent", "member", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "isImplementingMethodOfAny", "isImplementingMethodOfAnyInternal", "visitedClasses", "", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "removeDuplicateTypes", "", "conflictingTypes", "Lorg/jetbrains/kotlin/types/KotlinType;", "hasAccessorImplementation", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "frontend"})
    public static final class Companion {
        private final void removeDuplicateTypes(Set<KotlinType> conflictingTypes) {
            Iterator<KotlinType> iterator2 = conflictingTypes.iterator();
            block0: while (iterator2.hasNext()) {
                KotlinType type2 = iterator2.next();
                for (KotlinType otherType : conflictingTypes) {
                    boolean subtypeOf = KotlinTypeChecker.DEFAULT.equalTypes(type2, otherType);
                    if (type2 == otherType || !subtypeOf) continue;
                    iterator2.remove();
                    continue block0;
                }
            }
        }

        private final boolean hasConstraints(KtTypeParameter typeParameter, List<? extends KtTypeConstraint> constraints) {
            boolean bl;
            block4: {
                if (typeParameter.getName() == null) {
                    return false;
                }
                Iterable $receiver$iv = constraints;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtTypeConstraint it = (KtTypeConstraint)element$iv;
                        KtSimpleNameExpression ktSimpleNameExpression = it.getSubjectTypeParameterName();
                        if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)typeParameter.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean isImplementingMethodOfAny(CallableMemberDescriptor member) {
            if (!METHOD_OF_ANY_NAMES.contains(member.getName().asString())) {
                return false;
            }
            if (member.getModality() == Modality.ABSTRACT) {
                return false;
            }
            return this.isImplementingMethodOfAnyInternal(member, new HashSet());
        }

        private final boolean isImplementingMethodOfAnyInternal(CallableMemberDescriptor member, Set<ClassDescriptor> visitedClasses) {
            Iterator<? extends CallableMemberDescriptor> iterator2 = member.getOverriddenDescriptors().iterator();
            while (iterator2.hasNext()) {
                CallableMemberDescriptor overridden;
                CallableMemberDescriptor callableMemberDescriptor = overridden = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)callableMemberDescriptor, (String)"overridden");
                DeclarationDescriptor containingDeclaration = callableMemberDescriptor.getContainingDeclaration();
                if (!(containingDeclaration instanceof ClassDescriptor) || visitedClasses.contains(containingDeclaration)) continue;
                if (Intrinsics.areEqual((Object)DescriptorUtils.getFqName(containingDeclaration), (Object)KotlinBuiltIns.FQ_NAMES.any)) {
                    return true;
                }
                if (this.isHidingParentMemberIfPresent(overridden)) continue;
                visitedClasses.add((ClassDescriptor)containingDeclaration);
                if (!this.isImplementingMethodOfAnyInternal(overridden, visitedClasses)) continue;
                return true;
            }
            return false;
        }

        private final boolean isHidingParentMemberIfPresent(CallableMemberDescriptor member) {
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(member);
            if (!(psiElement instanceof KtNamedDeclaration)) {
                psiElement = null;
            }
            KtNamedDeclaration ktNamedDeclaration = (KtNamedDeclaration)psiElement;
            if (ktNamedDeclaration == null) {
                return false;
            }
            KtNamedDeclaration declaration = ktNamedDeclaration;
            KtModifierList ktModifierList = declaration.getModifierList();
            if (ktModifierList == null) {
                return true;
            }
            KtModifierList modifierList = ktModifierList;
            return !modifierList.hasModifier(KtTokens.OVERRIDE_KEYWORD);
        }

        public final boolean hasAccessorImplementation(@NotNull PropertyDescriptor $receiver) {
            PropertyAccessorDescriptor propertyAccessorDescriptor;
            PropertyGetterDescriptor it;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
            if (propertyGetterDescriptor != null) {
                PropertyGetterDescriptor propertyGetterDescriptor2 = it = (propertyAccessorDescriptor = propertyGetterDescriptor);
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor2, (String)"it");
                if (DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor2)) {
                    return true;
                }
            }
            PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
            if (propertySetterDescriptor != null) {
                PropertyGetterDescriptor propertyGetterDescriptor3 = it = (propertyAccessorDescriptor = propertySetterDescriptor);
                Intrinsics.checkExpressionValueIsNotNull((Object)propertyGetterDescriptor3, (String)"it");
                if (DescriptorPsiUtilsKt.hasBody(propertyGetterDescriptor3)) {
                    return true;
                }
            }
            return false;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

