;
; FXPIPE_COMMON - information related to pipes in the FXFILTER package.
;
;  POINTER     - for each LUN, the current file pointer (a long integer)
;  CACHE_UNIT  - for each pipe LUN, the LUN of the cache file.
;  CACHE_LEN   - for each cache LUN, the number of cached bytes.
;  CACHE_MAX   - for each cache LUN, the maximum size of the cache.
;  CACHE_FILE  - for each pipe LUN, the name of the cache file. (a string)
;  EOF_REACHED - for each pipe LUN, a flag indicating whether the end
;                of the pipe has been reached.
;  PROCESS_ID  - for each pipe LUN, the process ID of the pipe
;                command.
;  BYTELENS    - the length in bytes of each IDL data type.
;
; MODIFICATION HISTORY:
;   2000-09-21 Changed copyright notice
;   2007-09-01 Add CACHE_MAX in anticipation of in-memory caching
;   2012-04-17 Promote file position pointers to LONG64, CM
;
;  $Id: fxpcommn.pro,v 1.4 2012/04/17 18:31:38 cmarkwar Exp $
;
;-
; Copyright (C) 1999-2000, 2007, 2012 Craig Markwardt
; This software is provided as is without any warranty whatsoever.
; Permission to use, copy, modify, and distribute modified or
; unmodified copies is granted, provided this copyright and disclaimer
; are included unchanged.
;-
        COMMON FXPIPE_COMMON, POINTER, CACHE_UNIT, CACHE_LEN, CACHE_MAX, $
          CACHE_FILE, BYTELENS, EOF_REACHED, PROCESS_ID

        IF N_ELEMENTS(POINTER) EQ 0 THEN BEGIN
            POINTER     = LON64ARR(256)
            CACHE_UNIT  = LONARR(256)
            CACHE_LEN   = LON64ARR(256)
            CACHE_MAX   = LON64ARR(256)
            CACHE_FILE  = STRARR(256)
            EOF_REACHED = LONARR(256)
            PROCESS_ID  = LONARR(256)

            ;; This is the length in bytes of each IDL type
;                         0   1   2   3   4   5   6   7   8   9  10  11  12
            BYTELENS = [-1L,  1,  2,  4,  4,  8, 16, -1, -1, 16, $
                        -1,  -1,  2,  4,  8,  8, -1 ]
        ENDIF
