      SUBROUTINE MATI50(X,N,Y)
C
C     THIS PROGRAM COMPUTES THE INVERSE OF A SINGLE PRECISION SYMMETRIC
C     MATRIX WHOSE ORDER DOES NOT EXCEED 50
C     THE MODIFIED NO-SQUARE-ROOT CHOLESKI DECOMPOSITION IS USED
C     N IS THE ORDER OF THE SYMMETRIC MATRIX--N DOES NOT EXCEED 50
C     THE INPUT MATRIX IS THE LOWER LEFT TRIANGLE OF ARRAY X
C     OR, IF AVAILABLE, ALL OF THE ARRAY X
C     OUTPUT MATRIX--Y.
C     NOTE--THE DIMENSIONS OF X AND Y MUST BE THE SAME
C           IN THE CALLING ROUTINE AS IN THIS SUBROUTINE.
C           THEY HAVE BEEN SET HEREIN TO 50 BY 50,
C           AND HENCE THE 50 IN THE NAME OF THIS SUBROUTINE (MATI50).
C     NOTE--MATI50 IS IDENTICAL TO MATI25 AND MATINV
C           EXCEPT FOR THE DIMENSIONS.
C
C     REFERENCE--
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--THESIS
C     UPDATED         --AUGUST    1976.
C     UPDATED         --MARCH     1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
CCCCC DOUBLE PRECISION SUM
C
      DIMENSION X(50,50)
      DIMENSION Y(50,50)
C
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MATI'
      ISUBN2='50  '
C
CCCC  IF(N-1)115,106,115
      IF(N-1.NE.0)GOTO115
  106 Y(1,1)=1.0D0/X(1,1)
      GOTO111
C
C     WE KNOW THAT A = L TIMES D TIMES L TRANSPOSE     WHERE L IS A
C     LOWER TRIANGULAR MATRIX AND D IS A DIAGONAL MATRIX
C     THE DIAGONAL ELEMENTS OF L ARE ALL ONES, THEREFORE WE SAVE SPACE
C     AND OVERWRITE THIS DIAGONAL WITH THE DIAGONAL ELEMENTS OF D
C     FIND L AND D
C
  115 Y(1,1)=X(1,1)
      DO20I=2,N
      Y(I,1)=X(I,1)/X(1,1)
      DO30J=2,I
      SUM=0.
      JM1=J-1
      DO40K=1,JM1
      SUM=SUM+Y(K,K)*Y(I,K)*Y(J,K)
   40 CONTINUE
      Y(I,J)=X(I,J)-SUM
CCCCC IF(J-I)41,30,41
      IF(J-I.EQ.0)GOTO30
   41 Y(I,J)=Y(I,J)/Y(J,J)
   30 CONTINUE
   20 CONTINUE
C
C     FIND L INVERSE AND STORE IT IN THE UPPER RIGHT TRIANGLE OF L
C
      DO60I=2,N
      IM1=I-1
      DO70J=1,IM1
      JJ=I-J
      SUM=0.
      JJP1=JJ+1
      DO80K=JJP1,I
CCCCC IF(K-I)64,65,64
      IF(K-I.NE.0)GOTO64
   65 SUM=SUM+Y(K,JJ)
      GOTO80
   64 SUM=SUM+Y(K,I)*Y(K,JJ)
   80 CONTINUE
      Y(JJ,I)=-SUM
   70 CONTINUE
   60 CONTINUE
C
C     FIND A INVERSE=L INVERSE TRANSPOSE TIMES D INVERSE TIMES L INVERSE
C     STORE THIS IN THE LOWER LEFT TRIANGLE OF L
C
      DO100I=1,N
      DO110J=1,I
      SUM=0.
      DO120K=I,N
CCCCC IF(K-I)91,92,91
      IF(K-I.EQ.0)GOTO92
   91 CONTINUE
CCCCC IF(K-J)93,94,93
      IF(K-J.EQ.0)GOTO94
   93 SUM=SUM+Y(I,K)*Y(J,K)/Y(K,K)
      GOTO120
   94 SUM=SUM+Y(I,K)/Y(K,K)
      GOTO120
   92 CONTINUE
CCCCC IF(K-J)95,96,95
      IF(K-J.EQ.0)GOTO96
   95 SUM=SUM+Y(J,K)/Y(K,K)
      GOTO120
   96 SUM=SUM+1.0D0/Y(K,K)
  120 CONTINUE
      Y(I,J)=SUM
  110 CONTINUE
  100 CONTINUE
C
C     FILL IN THE UPPER RIGHT TRIANGLE OF THE INVERSE MATRIX
C     THIS IS NEEDED ONLY BECAUSE OF THE BLUE SUBROUTINE WHICH FOLLOWS
C
      NM1=N-1
      DO10I=1,NM1
      JMIN=I+1
      DO21J=JMIN,N
      Y(I,J)=Y(J,I)
   21 CONTINUE
   10 CONTINUE
  111 RETURN
      END
      SUBROUTINE MATSCA(AMAT,AMAT2,MAXROM,MAXCOM,NR1,NC1,Y1,Y2,Y3,
     1IMATSC,ICASE,IWRITE,
     1IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE SCALES A MATRIX BY
C              EITHER A SD, RANGE, MEAN, OR Z-SCORE.
C     INPUT  ARGUMENTS--AMAT   = THE SINGLE PRECISION MATRIX
C                     --MAXROM = THE INTEGER ROW DIMENSION OF AMAT
C                     --MAXCOM = THE INTEGER COUMN DIMENSION OF AMAT
C                     --NR1    = THE INTEGER NUMBER OF ROWS OF AMAT
C                     --NC1    = THE INTEGER NUMBER OF COLUMNS OF AMAT
C     OUTPUT ARGUMENTS--AMAT2    = THE SINGLE PRECISION VALUE OF THE
C                                SCALED MATRIX.
C     OUTPUT--SCALED MATRIX.
C     NOTE--THIS ROUTINE ASSUMES THE ERROR CHECKING (FOR EQUAL
C           ROWS AND COLUMNS, MATCHING DIMENSIONS FOR X AND AMAT)
C           IS DONE BT THE CALLING SUBROUTINE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98.6
C     ORIGINAL VERSION--JUNE      1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IMATSC
      CHARACTER*4 ICASE
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION Y3(*)
      DIMENSION AMAT(MAXROM,MAXCOM)
      DIMENSION AMAT2(MAXROM,MAXCOM)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MATS'
      ISUBN2='CA  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MATSCA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NR1,NC1
   53 FORMAT('NR1, NC1 = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ICASE
   54 FORMAT('ICASE = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************
C               **  SCALE THE MATRIX           *
C               ********************************
C
      IWRITE='OFF'
C
      IF(IMATSC.EQ.'NONE')THEN
        DO110J=1,NC1
          DO120I=1,NR1
            AMAT2(I,J)=AMAT(I,J)
 120      CONTINUE
 110    CONTINUE 
        GOTO9000
      ENDIF
C
      IF(IMATSC.EQ.'MEAN')THEN
        IF(ICASE.EQ.'ROW ')THEN
          DO210I=1,NR1
            DO215J=1,NC1
              Y1(J)=AMAT(I,J)
 215        CONTINUE
            CALL MEAN(Y1,NC1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(I)=ASTAT
 210      CONTINUE
          DO220I=1,NR1
            DO225J=1,NC1
              AMAT2(I,J)=AMAT(I,J)/Y2(I)
 225        CONTINUE
 220      CONTINUE
        ELSE
          DO230J=1,NC1
            DO235I=1,NR1
              Y1(I)=AMAT(I,J)
 235        CONTINUE
            CALL MEAN(Y1,NR1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(J)=ASTAT
 230      CONTINUE
          DO240J=1,NC1
            DO245I=1,NR1
              AMAT2(I,J)=AMAT(I,J)/Y2(J)
 245        CONTINUE
 240      CONTINUE
        ENDIF
      ENDIF
C
      IF(IMATSC.EQ.'RANG')THEN
        IF(ICASE.EQ.'ROW ')THEN
          DO310I=1,NR1
            DO315J=1,NC1
              Y1(J)=AMAT(I,J)
 315        CONTINUE
            CALL RANGDP(Y1,NC1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(I)=ASTAT
 310      CONTINUE
          DO320I=1,NR1
            DO325J=1,NC1
              AMAT2(I,J)=AMAT(I,J)/Y2(I)
 325        CONTINUE
 320      CONTINUE
        ELSE
          DO330J=1,NC1
            DO335I=1,NR1
              Y1(I)=AMAT(I,J)
 335        CONTINUE
            CALL RANGDP(Y1,NR1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(J)=ASTAT
 330      CONTINUE
          DO340J=1,NC1
            DO345I=1,NR1
              AMAT2(I,J)=AMAT(I,J)/Y2(J)
 345        CONTINUE
 340      CONTINUE
        ENDIF
      ENDIF
C
      IF(IMATSC.EQ.'Z-SC')THEN
        IF(ICASE.EQ.'ROW ')THEN
          DO410I=1,NR1
            DO415J=1,NC1
              Y1(J)=AMAT(I,J)
 415        CONTINUE
            CALL SD(Y1,NC1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(I)=ASTAT
            CALL MEAN(Y1,NC1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y3(I)=ASTAT
 410      CONTINUE
          DO420I=1,NR1
            DO425J=1,NC1
              AMAT2(I,J)=(AMAT(I,J)-Y3(I))/Y2(I)
 425        CONTINUE
 420      CONTINUE
        ELSE
          DO430J=1,NC1
            DO435I=1,NR1
              Y1(I)=AMAT(I,J)
 435        CONTINUE
            CALL SD(Y1,NR1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y2(J)=ASTAT
            CALL MEAN(Y1,NR1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y3(J)=ASTAT
 430      CONTINUE
          DO440J=1,NC1
            DO445I=1,NR1
              AMAT2(I,J)=(AMAT(I,J)-Y3(J))/Y2(J)
 445        CONTINUE
 440      CONTINUE
        ENDIF
      ENDIF
C
      IF(IMATSC.EQ.'SD  ')THEN
        IF(ICASE.EQ.'ROW ')THEN
          DO510I=1,NR1
            DO515J=1,NC1
              Y1(J)=AMAT(I,J)
 515        CONTINUE
            CALL SD(Y1,NC1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y3(I)=ASTAT
 510      CONTINUE
          DO520I=1,NR1
            DO525J=1,NC1
              AMAT2(I,J)=AMAT(I,J)/Y2(I)
 525        CONTINUE
 520      CONTINUE
        ELSE
          DO530J=1,NC1
            DO535I=1,NR1
              Y1(I)=AMAT(I,J)
 535        CONTINUE
            CALL SD(Y1,NR1,IWRITE,ASTAT,IBUGA3,IERROR)
            Y3(J)=ASTAT
 530      CONTINUE
          DO540J=1,NC1
            DO545I=1,NR1
              AMAT2(I,J)=AMAT(I,J)/Y2(J)
 545        CONTINUE
 540      CONTINUE
        ENDIF
      ENDIF
C
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)
  811 FORMAT('THE EUCLIDEN DISTANCE MATRIX HAS BEEN CALCULATED.')
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MATSCA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)IMATSC
 9015 FORMAT('IMATSC = ',A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MATMPI (X,WORK,S,E,V,N,M,NX,MX,K,IFLAG)
C
C-----------------------------------------------------------------------
C   MATMPI   WRITTEN BY CHARLES P. REEVE, STATISTICAL ENGINEERING
C            DIVISION, NATIONAL BUREAU OF STANDARDS, GAITHERSBURG,
C            MARYLAND  20899
C
C   FOR: COMPUTING THE MOORE-PENROSE PSEUDO-INVERSE OF AN NXM MATRIX
C        X WHERE N >= M.  THE TRANSPOSE OF THE INVERSE IS RETURNED IN 
C        THE ORIGINAL MATRIX.  A LINPACK ROUTINE IS USED TO PERFORM
C        A SINGULAR VALUE DECOMPOSITION OF X FROM WHICH THE INVERSE
C        X+ IS COMPUTED.  IF X IS OF FULL RANK THEN X+ = INV(X'X)*X'. 
C
C   NOTE: RNDERR IS A MACHINE DEPENDENT CONSTANT WHICH IS THE MACHINE 
C         ROUNDING ERROR (OR A LITTLE LARGER).  IT IS USED TO DETERMINE
C         WHEN A SINGULAR VALUE IS ZERO (IN CASES WHERE THE USER HAS
C         REQUESTED AUTOMATIC DETERMINATION OF RANK BY INPUTTING K=0).
C         SEE DISCUSSION OF THIS POINT ON PAGE 11.2 OF REFERENCE 1.
C
C   SUBPROGRAMS CALLED: SSVDC (LINPACK) 
C
C   CURRENT VERSION COMPLETED DECEMBER 14, 1989
C
C   REFERENCES: 
C
C   1) DONGARRA, J.J., MOLER, C.B., BUNCH, J.R., AND STEWART, G.W.,
C      "LINPACK USERS' GUIDE", SIAM, PHILADELPHIA, 1979, CH. 11.
C
C   2) LAWSON, CHARLES L. AND HANSON, RICHARD J., "SOLVING LEAST
C      SQUARES PROBLEMS", PRENTICE-HALL, INC., CH. 7.
C-----------------------------------------------------------------------
C   DEFINITION OF PASSED PARAMETERS: 
C
C    * X(NX,*) = MATRIX (SIZE N BY M) WHOSE PSEUDO-INVERSE IS TO BE
C                COMPUTED.  THE SECOND DIMENSION OF X, DEFINED IN THE 
C                CALLING PROGRAM, MUST BE >=M. [REAL]
C
C      WORK(*) = VECTOR (LENGTH N) USED AS WORKSPACE [REAL] 
C
C         S(*) = VECTOR (LENGTH M) OF SINGULAR VALUES IN DESCENDING
C                ORDER ON RETURN, PROVIDED INFO=0 ON RETURN [REAL]
C
C         E(*) = VECTOR (LENGTH M) OF ZEROS ON RETURN, PROVIDED INFO=0
C                ON RETURN [REAL]
C
C      V(MX,*) = MATRIX (SIZE M BY M) USED FOR INTERMEDIATE 
C                COMPUTATIONS [REAL]
C
C          * N = NUMBER OF ROWS IN MATRIX X [INTEGER]
C
C          * M = NUMBER OF COLUMNS IN MATRIX X (M<=N) [INTEGER]
C
C         * NX = LEADING DIMENSION OF MATRIX X (NX>=N) [INTEGER]
C
C         * MX = LEADING DIMENSION OF MATRIX V (MX>=M) [INTEGER]
C
C          * K = ON INPUT: K>0 INDICATES KNOWN RANK OF MATRIX X.
C                          K=0 INDICATES RANK SHOULD BE AUTOMATICALLY 
C                              DETERMINED BY PROGRAM.
C                ON OUTPUT: = UNCHANGED IF K>0 ON INPUT.
C                           = COMPUTED RANK OF X IF K=0 ON INPUT.
C
C        IFLAG = ERROR INDICATOR ON OUTPUT [INTEGER]  INTERPRETATION: 
C                1 -> N>NX OR M>MX.
C                2 -> N<M.
C                3 -> INFO<>0 RETURNED FROM SSVDC (SINGULAR VALUES WERE
C                     NOT COMPUTED CORRECTLY, THUS MOORE-PENROSE
C                     PSEUDO-INVERSE NOT COMPUTED).
C                4 -> K<0 ON INPUT.
C
C   * INDICATES PARAMETERS REQUIRING INPUT VALUES 
C-----------------------------------------------------------------------
C
      DIMENSION X(NX,*),WORK(*),S(*),E(*),V(MX,*) 
C
      DATA RNDERR / 1.0E-14 / 
C
      IFLAG = 0
      IF (N.GT.NX.OR.M.GT.MX) THEN
         IFLAG = 1
         RETURN
C
      ENDIF
      IF (N.LT.M) THEN
         IFLAG = 2
         RETURN
C
      ENDIF
      IF (K.LT.0) THEN
         IFLAG = 4
         RETURN
C
      ENDIF
      IF (K.EQ.0) THEN
C
C--- COMPUTE LARGEST ELEMENT OF X (IN ABSOLUTE VALUE)
C
         XMAX = 0.0 
         DO 20 I = 1, N
            DO 10 J = 1, M
               XMAX = AMAX1(XMAX,ABS(X(I,J)))
   10       CONTINUE
   20    CONTINUE
C
C--- COMPUTE CUTOFF POINT FOR A SINGULAR VALUE BEING ZERO
C
         CUTOFF = 10.0*RNDERR*XMAX
      ENDIF
C
C--- PERFORM SINGULAR VALUE FACTORIZATION USING LINPACK
C
      CALL SSVDC (X,NX,N,M,S,E,X,NX,V,MX,WORK,21,INFO)
C
C--- CHECK WHETHER SINGULAR VALUES HAVE BEEN COMPUTED CORRECTLY
C
      IF (INFO.NE.0) THEN
         IFLAG = 3
         RETURN
C
      ENDIF
      IF (K.EQ.0) THEN
C
C--- DETERMINE NUMBER OF NONZERO SINGULAR VALUES
C
         K = 0
         DO 30 J = 1, M
            IF (ABS(S(J)).GT.CUTOFF) THEN
               K = K+1
            ELSE
               GO TO 40
C
            ENDIF
   30    CONTINUE
      ENDIF
C
C--- COMPUTE THE MOORE-PENROSE PSEUDO-INVERSE OF X (TRANSPOSED)
C
   40 DO 60 J = 1, M
         DO 50 L = 1, K
            V(J,L) = V(J,L)/S(L)
   50    CONTINUE
   60 CONTINUE
      DO 100 I = 1, N
         DO 80 J = 1, M
            T = 0.0 
            DO 70 L = 1, K
               T = T+V(J,L)*X(I,L)
   70       CONTINUE
            E(J) = T
   80    CONTINUE
         DO 90 J = 1, M
            X(I,J) = E(J)
   90    CONTINUE
  100 CONTINUE
      RETURN
C
      END 
      SUBROUTINE MAXIM(X,N,IWRITE,XMAX,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MAXIMUM
C              OF THE DATA IN THE INPUT VECTOR X.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMAX   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MAXIMUM.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MAXIMUM.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--DAVID, ORDER STATISTICS, 1970, PAGE 7.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JUNE      1979.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --FEBRUARY  1988.  (SUPPRESS SOME DIAGNOSTIC MESSAGES)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MAXI'
      ISUBN2='M   '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MAXIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ***********************
C               **  COMPUTE MAXIMUM  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN MAXIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE MAXIMUM IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN MAXIM--',
CCCCC1'THE 2ND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XMAX=X(1)
      GOTO800
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN MAXIM--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XMAX=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               ****************************
C               **  STEP 2--              **
C               **  COMPUTE THE MAXIMUM.  **
C               ****************************
C
      XMAX=X(1)
      DO200I=2,N
      IF(X(I).GT.XMAX)XMAX=X(I)
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,XMAX
  811 FORMAT('THE MAXIMUM OF THE ',I8,' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MAXIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XMAX
 9015 FORMAT('XMAX = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MAXIND(X,N,IWRITE,PSTAMV,XIND,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE INDEX WHERE THE
C              SAMPLE MAXIMUM OF THE DATA IN THE INPUT VECTOR X
C              OCCURS.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XIND   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED INDEX OF THE SAMPLE MAXIMUM.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE INDEX OF THE MAXIMUM.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.2
C     ORIGINAL VERSION--FEBRUARY  2009.
C     UPDATED         --APRIL     2010. SKIP "MISSING VALUES"
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MINI'
      ISUBN2='ND  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'XIND')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF MAXIND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ***********************
C               **  COMPUTE MAXIMUM  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN INDEX MAXIMUM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLE MUST BE 1 OR LARGER.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,116)
  116   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.EQ.1)THEN
        XIND=1.0
        GOTO800
      ENDIF
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE INDEX OF THE MAXIMUM.  **
C               *****************************************
C
      XMAX=CPUMIN
      XIND=1
      DO200I=1,N
        IF(X(I).NE.PSTAMV .AND. X(I).GT.XMAX)THEN
          XMAX=X(I)
          XIND=REAL(I)
        ENDIF
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,XIND
  811   FORMAT('THE INDEX FOR THE MAXIMUM VALUE OF THE ',I8,
     1         ' OBSERVATIONS = ',F12.0)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'XIND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF MAXIND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N
 9013   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)XMAX,XIND
 9015   FORMAT('XMAX,XIND = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE MAXCDF(X,CDF)
CCCCC SUBROUTINE MAXCDF(X,SIGMA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MAXWELL DISTRIBUTION
C              THIS DISTRIBUTION IS DEFINED FOR NON-NEGATIVE X AND
C              HAS THE CUMULATIVE DISTRIBUTION FUNCTION
C                 F(X) = 2*IG(3/2,0.5*(1/SIGMA**2)*X**2)/SQRT(PI)
C              WITH IG DENOTING THE IMCOMPLETE GAMMA FUNCTION.
C              SIGMA IS A SCALE PARAMETER, SO WE CAN SET IT TO 1.
C     INPUT  ARGUMENTS--X     = THE SINGLE PRECISION VALUE AT
C                               WHICH THE CUMULATIVE DISTRIBUTION
C                               FUNCTION IS TO BE EVALUATED.
C                               X SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--CDF   = THE SINGLE PRECISION CUMULATIVE
C                               DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION FUNCTION
C             VALUE CDF FOR THE MAXWELL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DGAMI, DSQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994).
C                "CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, WILEY, P. 453.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --FEBRUARY  2008. TREAT MAXWELL AS A SCALE
C                                       PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DGAMI
C
      EXTERNAL DGAMI
C
      INCLUDE 'DPCOMC.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
CCCCC IF(X.LT.0.0)THEN
CCCCC   WRITE(ICOUT,8)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)X
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   CDF=0.0
CCCCC   GOTO9000
CCCCC ENDIF
CCCCC IF(SIGMA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,18)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)SIGMA
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   CDF=0.0
CCCCC   GOTO9000
CCCCC ENDIF
CCCC8 FORMAT('***** ERROR: VALUE OF THE FIRST ARGUMENT TO MAXCDF ',
CCCCC1       'IS NEGATIVE.')
   18 FORMAT('***** ERROR: VALUE OF THE SECOND ARGUMENT TO MAXCDF ',
     1       'IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(X.LE.0.0)THEN
        CDF=0.0
      ELSE
        DX=DBLE(X)
CCCCC   DS=DBLE(SIGMA)**2
        DS=1.0D0
        IF(DX.GE.DSQRT(D1MACH(2)))THEN
          CDF=1.0
          GOTO9000
        ENDIF
C
        DTERM3=2.0D0/DSQRT(DPI)
        DTERM1=1.5D0
        DTERM2=0.5D0*DX*DX/DS
        DCDF=DTERM3*DGAMI(DTERM1,DTERM2)
        CDF=REAL(DCDF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MAXCD2(DX,DCDF)
CCCCC SUBROUTINE MAXCD2(DX,DSIGMA,DCDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MAXWELL DISTRIBUTION
C              THIS DISTRIBUTION IS DEFINED FOR NON-NEGATIVE X AND
C              HAS THE CUMULATIVE DISTRIBUTION FUNCTION
C                 F(X) = 2*IG(3/2,0.5*(1/SIGMA**2)*X**2)/SQRT(PI)
C              WITH IG DENOTING THE IMCOMPLETE GAMMA FUNCTION.
C     NOTE--THIS IS A COPY OF MAXCDF USED BY MAXPPF ROUTINE
C           TO OBTAIN HIGHER ACCURACY IN NUMERICAL INVERSION
C     INPUT  ARGUMENTS--X     = THE SINGLE PRECISION VALUE AT
C                               WHICH THE CUMULATIVE DISTRIBUTION
C                               FUNCTION IS TO BE EVALUATED.
C                               X SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--CDF   = THE SINGLE PRECISION CUMULATIVE
C                               DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION FUNCTION
C             VALUE CDF FOR THE MAXWELL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DGAMI, DSQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994).
C                "CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, WILEY, P. 453.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --FEBRUARY  2008. TREAT SIGMA AS A SCALE
C                                       PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DS
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DGAMI
C
      EXTERNAL DGAMI
C
      INCLUDE 'DPCOMC.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
CCCCC IF(X.LT.0.0)THEN
CCCCC   WRITE(ICOUT,8)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)X
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   CDF=0.0
CCCCC   GOTO9000
CCCCC ENDIF
CCCCC IF(DSIGMA.LE.0.0D0)THEN
CCCCC   WRITE(ICOUT,18)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)SIGMA
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   DCDF=0.0D0
CCCCC   GOTO9000
CCCCC ENDIF
CCCC8 FORMAT('***** ERROR: VALUE OF THE FIRST ARGUMENT TO MAXCDF ',
CCCCC1       'IS NEGATIVE.')
   18 FORMAT('***** ERROR: VALUE OF THE SECOND ARGUMENT TO MAXCDF ',
     1       'IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(DX.LE.0.0D0)THEN
        DCDF=0.0D0
      ELSE
        DS=1.0D0
CCCCC   DS=DSIGMA**2
        IF(DX.GE.DSQRT(D1MACH(2)))THEN
          DCDF=1.0D0
          GOTO9000
        ENDIF
C
        DTERM3=2.0D0/DSQRT(DPI)
        DTERM1=1.5D0
        DTERM2=0.5D0*DX*DX/DS
        DCDF=DTERM3*DGAMI(DTERM1,DTERM2)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      subroutine maxofq
c
c      NOTE: This subroutine used in computing the consensus mean
c            using the Iyer and Wang generalized tolerance interval
c            approach.
c
c            Modified for Dataplot 3/2006.
c
      implicit none
c
      integer kk
      double precision aa, ybar, cc, bb(100), yy(100)
      common /cmn1/ kk
      common /cmn2/ aa, ybar, cc, bb, yy
c
      integer i
      double precision sx2, sx1, s1b
c
      sx2 = 0.0d0
      sx1 = 0.0d0
      s1b = 0.0d0
c
      do 10 i = 1, kk
         sx2 = sx2 + yy(i)**2/bb(i)
         sx1 = sx1 + yy(i)/bb(i)
         s1b = s1b + 1.0d0/bb(i)
   10 continue
c
      aa = sx2 - 2.0d0*ybar*sx1 + ybar**2 * s1b -
     1    (sx1 - ybar*s1b)**2/s1b
c
      return
      end
      SUBROUTINE MAXLI1(Y,N,ICASPL,
     1                  ALOC,SCALE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE MAXWELL DISTRIBUTION.  THIS IS FOR THE RAW DATA
C              CASE (I.E., NO GROUPING AND NO CENSORING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 10.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MAXL'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XLI1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF MAXLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XLI1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
      IF(ICASPL.EQ.'1MAX')ALOC=0.0
C
C     THE LOG-LIKELIHOOD FUNCTION IS
C
C     (-N/2)*LOG(2) -3*N*LOG(S) - N*LOGGAMMA(1.5) +
C     2*SUM[i=1][N][LOG(Y(i) - U) -
C     (1/(2*S**2)*SUM[i=1][N][Y(i) - U]
C
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DTERM1=(-DN/2.0D0)*DLOG(2.0D0) - 3.0D0*DN*DLOG(DS)
      DTERM2=1.0D0/(2.0D0*DS*DS)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO1000I=1,N
        DX=DBLE(Y(I))
        DSUM1=DSUM1 + DLOG(DX-DU)
        DSUM2=DSUM2 + (DX-DU)
 1000 CONTINUE
      DLIK=DTERM1 + 2.0D0*DSUM1 - DTERM2*DSUM2
C
      ALIK=REAL(DLIK)
      DNP=2.0D0
      IF(ICASPL.EQ.'1MAX')DNP=1.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XLI1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF MAXLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DSUM2,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DSUM2,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE MAXML1(Y,N,ICASPL,
     1                  DTEMP1,
     1                  XMEAN,XSD,XMIN,XMAX,
     1                  ALOCML,SCALML,SCALSE,
     1                  ALOCMO,SCALMO,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE MAXWELL DISTRIBUTION FOR THE RAW DATA CASE (I.E.,
C              NO CENSORING AND NO GROUPING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLMX WILL GENERATE THE OUTPUT
C              FOR THE MAXWELL MLE COMMAND).
C
C              THE CODE IS SET-UP TO HANDLE EITHER 1-PARAMETER OR
C              2-PARAMETER CASE.  CURRENTLY, THE 2-PARAMETER CASE ONLY
C              SUPPORTS MOMENT ESTIMATES.
C
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 10.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLMX),
C                                       SUPPORT 2-PARAMETER CASE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DP
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DVAR
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
C
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
      DOUBLE PRECISION DGAMMA
      EXTERNAL DGAMMA
      DOUBLE PRECISION DLNGAM
      EXTERNAL DLNGAM
C
      DOUBLE PRECISION RAYFUN
      EXTERNAL RAYFUN
C
      INTEGER IN
      DOUBLE PRECISION DXBAR
      COMMON/RAYCOM/DXBAR,IN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI/ 3.14159265358979D+00/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MAXM'
      ISUBN2='L1  '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF MAXML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,MAXNXT
   52   FORMAT('IBUGA3,ISUBRO,N,MAXNXT = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CARRY OUT CALCULATIONS                **
C               **  FOR MAXWELL MLE ESTIMATE              **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='MAXWELL'
      IFLAG=0
      IF(ICASPL.EQ.'1')IFLAG=1
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      ALOCMO=CPUMIN
      SCALMO=CPUMIN
      ALOCML=CPUMIN
      SCALML=CPUMIN
      ALOCMM=CPUMIN
      SCALMM=CPUMIN
      SCALSE=CPUMIN
      SCA2SE=CPUMIN
C
      IF(ICASPL.EQ.'1')THEN
C
C       ONE-PARAMETER MODEL
C
C       MAXIMUM LIKELIHOOD ESTIMATE OF SIGMA:
C
C       SIGMAHAT = SUM[i=1 to N][SQRT(X(i)**2/(3*N)]
C
C       FORMULA FOR STANDARD ERROR GIVEN ON PAGE 201 OF
C       COHEN AND WHITTEN.
C
        DP=3.0D0
        DN=DBLE(N)
        DSUM1=0.0D0
        DO1010I=1,N
          DX=DBLE(Y(I))
          DSUM1=DSUM1 + DX*DX/(DP*DN)
 1010   CONTINUE
        DSUM1=DSQRT(DSUM1)
        SCALML=REAL(DSUM1)
        DTERM1=DSUM1**2/(2.0D0*DN*DP)
        DTERM2=2.0D0*DN*DP
C
C       USE LOG GAMMA FUNCTION IN CASE N GETS LARGE
C
CCCCC   DTERM3=DGAMMA((DN*DP+1.0D0)/2.0D0)
CCCCC   DTERM4=DGAMMA(DN*DP/2.0D0)
        DTERM3=DLNGAM((DN*DP+1.0D0)/2.0D0)
        DTERM4=DLNGAM(DN*DP/2.0D0)
        DTERM5=2.0D0*(DLOG(2.0D0) + DTERM3 - DTERM4)
        DTERM5=DEXP(DTERM5)
C
        DVAR=DTERM1*(DTERM2 - DTERM5)
        SCALSE=REAL(DSQRT(DVAR))
C
        DTERM1=DGAMMA(DP/2.0D0)
        DTERM2=DGAMMA((DP+1.0D0)/2.0D0)
        DTERM3=DTERM1/DSQRT(2.0D0*DTERM2)
        SCALMO=XMEAN*REAL(DTERM3)
      ELSE
C
C       MOMENT ESTIMATES ARE:
C
C       SIGMAHAT = S*SQRT(PI/(3*PI-8))
C       UHAT = XBAR - 2*SIGMAHAT**2*SQRT(2/PI)
C
        DTERM1=DSQRT(DPI/(3.0D0*DPI-8.0D0))
        DTERM2=DBLE(XSD)*DTERM1
        SCALMO=REAL(DTERM2)
        DTERM2=DSQRT(2.0D0/DPI)
        ALOCMO=XMEAN - 2.0*SCALMO*REAL(DTERM2)
C
C       MAXIMUM LIKELIHOOD ESTIMATES ARE:
C
CRAYL   DXBAR=DBLE(XMEAN)
CRAYL   IN=N
CRAYL   DO2010I=1,N
CRAYL     DTEMP1(I)=DBLE(Y(I))
 2010   CONTINUE
C
CRAYL   DXSTRT=DBLE(ALOCMM)
CRAYL   DAE=2.0*0.000001D0*DXSTRT
CRAYL   DRE=DAE
CRAYL   IFLAG=0
CRAYL   IF(DXSTRT.GE.0.0D0)THEN
CRAYL     DXLOW=DXSTRT/3.0D0
CRAYL   ELSE
CRAYL     DXLOW=DXSTRT*3.0D0
CRAYL   ENDIF
CRAYL   DXUP=DBLE(XMIN)
CRAYL   ITBRAC=0
 4105   CONTINUE
CRAYL   XLOWSV=DXLOW
CRAYL   XUPSV=DXUP
CRAYL   CALL DFZER2(RAYFUN,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
C
CRAYL   IF(IFLAG.EQ.4 .AND. ITBRAC.LE.100)THEN
CRAYL     IF(DXLOW.GE.0.0D0)THEN
CRAYL       DXLOW=XLOWSV/2.0D0
CRAYL     ELSE
CRAYL       DXLOW=XLOWSV*2.0D0
CRAYL     ENDIF
CRAYL     ITBRAC=ITBRAC+1
CRAYL     GOTO4105
CRAYL   ENDIF
C
CRAYL   IF(IFLAG.EQ.2)THEN
C
C         NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC     WRITE(ICOUT,999)
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,111)
CC111     FORMAT('***** WARNING FROM MAXWELL MAXIMUM ',
CCCCC1           'LIKELIHOOD--')
CCCCC     CALL DPWRST('XXX','BUG ')
CCCCC     WRITE(ICOUT,113)
CC113     FORMAT('      ESTIMATE OF MU MAY NOT BE COMPUTED TO ',
CCCCC1           'DESIRED TOLERANCE.')
CCCCC     CALL DPWRST('XXX','BUG ')
CRAYL   ELSEIF(IFLAG.EQ.3)THEN
CRAYL     WRITE(ICOUT,999)
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,121)
  121     FORMAT('***** WARNING FROM MAXWELL MAXIMUM LIKELIHOOD--')
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,123)
  123     FORMAT('      ESTIMATE OF MU MAY BE NEAR A SINGULAR POINT.')
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL   ELSEIF(IFLAG.EQ.4)THEN
CRAYL     WRITE(ICOUT,999)
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,131)
  131     FORMAT('***** ERROR FROM MAXWELL MAXIMUM LIKELIHOOD--')
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,133)
  133     FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL   ELSEIF(IFLAG.EQ.5)THEN
CRAYL     WRITE(ICOUT,999)
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,121)
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL     WRITE(ICOUT,143)
  143     FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
CRAYL     CALL DPWRST('XXX','BUG ')
CRAYL   ENDIF
C
CRAYL   ALOCML=REAL(DXLOW)
CRAYL   DSUM1=0.0D0
CRAYL   DO2030I=1,N
CRAYL     DX=DBLE(Y(I)) - DXLOW
CRAYL     DSUM1=DSUM1 + DX**2
 2030   CONTINUE
CRAYL   SCALML=REAL(DSUM1/(2.0D0*DP))
C
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF MAXML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9055)N,XMEAN,XSD,XMIN,XMAX
 9055   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,6G15.7)
        CALL DPWRST('XXX','WRIT')
        IF(ICASPL.EQ.'1')THEN
          WRITE(ICOUT,9056)SCALMM,SCALSE
 9056     FORMAT('SCALMM,SCALSE = ',2G15.7)
          CALL DPWRST('XXX','WRIT')
        ELSE
          WRITE(ICOUT,9058)ALOCMO,SCALMO
 9058     FORMAT('ALOCML,SCALML = ',2G15.7)
          CALL DPWRST('XXX','WRIT')
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE MAXPDF(X,PDF)
CCCCC SUBROUTINE MAXPDF(X,SIGMA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MAXWELL DISTRIBUTION.
C              THIS DISTRIBUTION IS DEFINED FOR NON-NEGATIVE X AND
C              HAS THE PROBABILITY DENSITY FUNCTION
C                 F(X) = SQRT(2/PI)*(1/SIGMA**2)**(3/2)*X**2*
C                        EXP(-(X**2)/(2*SIGMA**2))
C     INPUT  ARGUMENTS--X     = THE SINGLE PRECISION VALUE AT
C                               WHICH THE PROBABILITY DENSITY
C                               FUNCTION IS TO BE EVALUATED.
C                               X SHOULD BE NON-NEGATIVE.
C                     --SIGMA = THE SINGLE PRECISION VALUE WHICH
C                               DEFINES THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PDF   = THE SINGLE PRECISION PROBABILITY
C                               DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY FUNCTION
C             VALUE PDF FOR THE MAXWELL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP, LOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994).
C                "CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, WILEY, P. 453.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --FEBRUARY  2008. TREAT SIGMA AS A SCALE
C                                       PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
C
      INCLUDE 'DPCOMC.INC'
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)X
        CALL DPWRST('XXX','WRIT')
        PDF=0.0
        GOTO9000
      ENDIF
CCCCC IF(SIGMA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,18)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)SIGMA
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   PDF=0.0
CCCCC   GOTO9000
CCCCC ENDIF
    8 FORMAT('***** ERROR: VALUE OF THE FIRST ARGUMENT TO MAXPDF ',
     1       'IS NEGATIVE.')
   18 FORMAT('***** ERROR: VALUE OF THE SECOND ARGUMENT TO MAXPDF ',
     1       'IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(X.EQ.0.0)THEN
        PDF=0.0
      ELSE
        DX=DBLE(X)
CCCCCC  DS=DBLE(SIGMA)
        DS=1.0D0
        IF(DX.GE.DSQRT(D1MACH(2)))THEN
          PDF=0.0
          GOTO9000
        ENDIF
C
        DTERM1=DLOG(DSQRT(2.0D0/DPI))
        DTERM2=1.5D0*DLOG(1.0D0/DS**2)
        DTERM3=2.0D0*DLOG(DX)
        DTERM4=-(DX*DX)/(2.0D0*DS**2)
        DPDF=DTERM1 + DTERM2 + DTERM3 + DTERM4
        DPDF=DEXP(DPDF)
        PDF=REAL(DPDF)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MAXPPF(P,PPF)
CCCCC SUBROUTINE MAXPPF(P,SIGMA,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE MAXWELL DISTRIBUTION
C              THIS DISTRIBUTION IS DEFINED FOR NON-NEGATIVE X AND
C              HAS THE CUMULATIVE DISTRIBUTION FUNCTION
C                 F(X) = 2*IG(3/2,0.5*(1/SIGMA)*X**2)/SQRT(PI)
C              WITH IG DENOTING THE IMCOMPLETE GAMMA FUNCTION.
C              DATAPLOT COMPUTES THE PERCENT POINT FUNCTION BY
C              NUMERICALLY INVERTING THE CUMULATIVE DISTRIBUTION
C              FUNCTION.
C     INPUT  ARGUMENTS--P     = THE SINGLE PRECISION VALUE AT
C                               WHICH THE PERCENT POINT
C                               FUNCTION IS TO BE EVALUATED.
C                               P SHOULD BE IN THE INTERVAL (0,1].
C     OUTPUT ARGUMENTS--PPF   = THE SINGLE PRECISION PERCENT POINT
C                               FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION
C             VALUE PPF FOR THE MAXWELL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--MAXCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994).
C                "CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, WILEY, P. 453.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --OCTOBER   2006. UPDATE TO DOUBLE PRECISION
C     UPDATED         --FEBRUARY  2008. TREAT SIGMA AS A SCALE
C                                       PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DP
      DOUBLE PRECISION EPS
      DOUBLE PRECISION SIG
      DOUBLE PRECISION ZERO
      DOUBLE PRECISION DMEAN
      DOUBLE PRECISION DSD
      DOUBLE PRECISION XL
      DOUBLE PRECISION XR
      DOUBLE PRECISION XINC
      DOUBLE PRECISION CDFL
      DOUBLE PRECISION CDFR
      DOUBLE PRECISION FXL
      DOUBLE PRECISION FXR
      DOUBLE PRECISION FCS
      DOUBLE PRECISION P1
      DOUBLE PRECISION DX
      DOUBLE PRECISION DCDF
C
      DOUBLE PRECISION DGAMMA
      EXTERNAL DGAMMA
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
      DATA EPS /0.000001D0/
      DATA SIG /1.0E-7/
      DATA ZERO /0.0D0/
      DATA MAXIT /3000/
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      IF(P.LT.0.0 .OR. P.GE.1.0)THEN
        WRITE(ICOUT,8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)P
        CALL DPWRST('XXX','WRIT')
        PPF=0.0
        GOTO9000
      ENDIF
CCCCC IF(SIGMA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,18)
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   WRITE(ICOUT,48)SIGMA
CCCCC   CALL DPWRST('XXX','WRIT')
CCCCC   PDF=0.0
CCCCC   GOTO9000
CCCCC ENDIF
    8 FORMAT('***** ERROR: VALUE OF THE FIRST ARGUMENT TO MAXPPF ',
     1       'IS OUTSIDE THE [0,1) INTERVAL.')
   18 FORMAT('***** ERROR: VALUE OF THE SECOND ARGUMENT TO MAXPDF ',
     1       'IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(P.EQ.0.0)THEN
        PPF=0.0
        GOTO9000
      ENDIF
C
C  FIND BRACKETING INTERVAL.
C
C  1) LOWER LIMIT = 0
C  2) MEAN = 2*SQRT(2*SIGMA/PI)
C     SD = SQRT(SIGMA**2*(3*PI-8)/PI)
C  3) START RIGHT LIMIT AT MEAN, INCREMENT IN UNITS OF
C     ONE STANDARD DEVIATION
C
CCCCC DSIGMA=DBLE(SIGMA)
      DSIGMA=1.0D0
      DP=DBLE(P)
      DMEAN=2.0D0*DSQRT(2.0D0*DSIGMA/DPI)
      DSD=DSIGMA**2*(3.0D0*DPI - 8.0D0)/DPI
      DSD=DSQRT(DSD)
C
      XL=0.0D0
      XR=DMEAN
      XINC=DSD
      ICOUNT=0
      MAXCNT=1000
C
   91 CONTINUE
      IF(XL.LE.0.0D0)XL=0.0D0
      IF(XR.LE.0.0D0)XR=XL+XINC
CCCCC CALL MAXCD2(XL,DSIGMA,CDFL)
CCCCC CALL MAXCD2(XR,DSIGMA,CDFR)
      CALL MAXCD2(XL,CDFL)
      CALL MAXCD2(XR,CDFR)
      IF(CDFL.LT.DP .AND. CDFR.LT.DP)THEN
        XL=XR
        XR=XL+XINC
      ELSEIF(CDFL.GT.DP .AND. CDFR.GT.DP)THEN
        XL=XL-XINC
        IF(XL.LT.0.0D0)XL=0.0D0
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
   96 FORMAT('***** ERROR--MAXPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL.')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -DP
      FXR = 1.0D0 - DP
  105 CONTINUE
      DX = (XL+XR)*0.5D0
CCCCC CALL MAXCD2(DX,DSIGMA,DCDF)
      CALL MAXCD2(DX,DCDF)
      P1=DCDF
      PPF=REAL(DX)
      FCS = P1 - DP
      IF(FCS*FXL.GT.ZERO)THEN
        XL = DX
        FXL = FCS
      ELSE
        XR = DX
        FXR = FCS
      ENDIF
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9000
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** ERROR--MAXPPF ROUTINE DID NOT CONVERGE.')
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MAXRAN(N,ISEED,X)
CCCCC SUBROUTINE MAXRAN(N,SIGMA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE MAXWELL DISTRIBUTION.
C              THIS DISTRIBUTION IS DEFINED FOR NON-NEGATIVE X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C                 F(X) = SQRT(2/PI)*(1/SIGMA)**(3/2)X**2*
C                        EXP(-X**2/(2*SIGMA))
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE MAXWELL DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, MAXPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--JOHNSON, KOTZ, AND BALAKRISHNAN (1994).
C                "CONTINUOUS UNIVARIATE DISTRIBUTIONS--VOLUME 1",
C                SECOND EDITION, WILEY, P. 453.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATION INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRMAXMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.6
C     ORIGINAL VERSION--JUNE      2004.
C     UPDATED         --FEBRUARY  2008. TREAT SIGMA AS A SCALE
C                                       PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
C
    5 FORMAT('***** ERROR--FOR THE MAXWELL DISTRIBUTION, THE')
    6 FORMAT('      REQUESTED NUMBER OF RANDOM NUMBERS WAS ',
     1      'NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,'.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
C     USE PERCENT POINT TRANSFORMATION METHOD.
C
      CALL UNIRAN(N,ISEED,X)
      DO100I=1,N
        ATEMP=X(I)
CCCCC   CALL MAXPPF(ATEMP,SIGMA,PPF)
        CALL MAXPPF(ATEMP,PPF)
        X(I)=PPF
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MCLCDF(X,ALPHA,DCDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MCLEISH
C              DISTRIBUTION WITH SHAPE PARAMETER ALPHA.
C              THE CUMULATIVE DISTRIBUTION IS COMPUTED BY
C              NUMERICALLY INTEGRATING THE PDF FUNCTION.
C     INPUT  ARGUMENTS--X       = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE CUMULATIVE DISTRIBUTION
C                                 FUNCTION IS TO BE EVALUATED.
C                     --ALPHA   = THE FIRST SHAPE PARAMETER
C     OUTPUT ARGUMENTS--CDF     = THE DOUBLE PRECISION CUMULATIVE
C                                 DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE FOR THE MCLEISH
C             DISTRIBUTION WITH SHAPE PARAMETERS ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DQAG.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                 WILEY, PP. 50-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      INTEGER LIMIT
      INTEGER LENW
      PARAMETER(LIMIT=100)
      PARAMETER(LENW=4*LIMIT)
      INTEGER INF
      INTEGER NEVAL
      INTEGER IER
      INTEGER LAST
      INTEGER IWORK(LIMIT)
      DOUBLE PRECISION ALPHA
      DOUBLE PRECISION EPSABS
      DOUBLE PRECISION EPSREL
      DOUBLE PRECISION RESULT
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION X
      DOUBLE PRECISION DX
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DM
      DOUBLE PRECISION ABSERR
      DOUBLE PRECISION WORK(LENW)
C
      DOUBLE PRECISION MCLFUN
      EXTERNAL MCLFUN
C
      DOUBLE PRECISION DALPHA
      COMMON/MCLCOM/DALPHA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(ALPHA.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)ALPHA
        CALL DPWRST('XXX','WRIT')
        CDF=0.0D0
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR: VALUE OF SHAPE PARAMETER (ALPHA)',
     1       ' IN MCLCDF ROUTINE IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      IF(X.EQ.0.0D0)THEN
        DCDF=0.5D0
        GOTO9000
      ELSEIF(X.LT.0.0D0)THEN
        ICASE=0
        DX=-X
      ELSE
        ICASE=1
        DX=X
      ENDIF
C
      INF=+1
      IKEY=3
      EPSABS=0.0D0
      EPSREL=1.0D-7
      DA=0.0D0
      IER=0
      DCDF=0.0D0
      DALPHA=ALPHA
C
      CALL DQAG(MCLFUN,DA,DX,EPSABS,EPSREL,IKEY,DCDF,ABSERR,NEVAL,
     1          IER,LIMIT,LENW,LAST,IWORK,WORK)
C
      IF(ICASE.EQ.1)THEN
        DCDF=0.5D0 + DCDF
      ELSE
        DCDF=0.50D0 - DCDF
      ENDIF
C
      IF(IER.EQ.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      MAXIMUM NUMBER OF SUBDIVISIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ROUNDOFF ERROR PREVENTS REQUESTED TOLERANCE ',
     1         'FROM BEING ACHIEVED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      BAD INTEGRAND BEHAVIOUR DETECTED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,141)
  141   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      INTEGRATION DID NOT CONVERGE.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
  151   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,153)
  153   FORMAT('      THE INTEGRATION IS PROBABLY DIVERGENT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.6)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,161)
  161   FORMAT('***** ERROR FROM MCLCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,163)
  163   FORMAT('      INVALID INPUT TO THE INTEGRATION ROUTINE.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION MCLFUN(DX)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MCLEISH
C              DISTRIBUTION WITH SHAPE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL REAL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C
C                 MCLPDF(X,ALPHA) = [1/(SQRT(PI)*GAMMA(ALPHA))]*
C                                   (ABS(X)/2)**(ALPHA-1/2)*
C                                   K(X,ALPHA-1/2)
C              WHERE
C                 K(X,N) IS THE MODIFIED BESSEL FUNCTION OF THE
C                        SECOND KIND
C                 GAMMA IS THE GAMMA FUNCTION
C
C              THE MCLPDF ROUTINE IS CALLED TO COMPUTE THE
C              PROBABILITY DENSITY.  DEFINE AS FUNCTION TO BE USED FOR
C              INTEGRATION CODE CALLED BY MCLCDF.  THIS ROUTINE USES
C              DOUBLE PRECISION ARITHMETIC.
C     INPUT  ARGUMENTS--DX      = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE PROBABILITY DENSITY
C                                 FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--MCLFUN  = THE DOUBLE PRECISION PROBABILITY
C                                 DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE MCLEISH
C             DISTRIBUTION WITH SHAPE PARAMETER ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--MCLPDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                 WILEY, PP. 50-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DTERM
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DALPHA
      COMMON/MCLCOM/DALPHA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      CALL MCLPDF(DX,DALPHA,DTERM)
      MCLFUN=DTERM
C
 9000 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION MCLFU2(DX)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MCLEISH
C              DISTRIBUTION WITH SHAPE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL REAL X
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C
C                 MCLPDF(X,ALPHA) = [1/(SQRT(PI)*GAMMA(ALPHA))]*
C                                   (ABS(X)/2)**(ALPHA-1/2)*
C                                   K(X,ALPHA-1/2)
C              WHERE
C                 K(X,N) IS THE MODIFIED BESSEL FUNCTION OF THE
C                        SECOND KIND
C                 GAMMA IS THE GAMMA FUNCTION
C
C              THE MCLCDF ROUTINE IS CALLED TO COMPUTE THE
C              CUMULATIVE DISTRIBUTION.  DEFINE AS FUNCTION TO BE USED
C              FOR INTEGRATION CODE CALLED BY MCLCDF.  THIS ROUTINE
C              USES DOUBLE PRECISION ARITHMETIC.
C     INPUT  ARGUMENTS--DX      = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE CUMULATIVE DISTRIBUTION
C                                 FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--MCLFU2  = THE DOUBLE PRECISION CUMULATIVE
C                                 DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE MCLEISH
C             DISTRIBUTION WITH SHAPE PARAMETER ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--MCLCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                 WILEY, PP. 50-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DX
C
      DOUBLE PRECISION DP
      COMMON/MC2COM/DP
C
      DOUBLE PRECISION DALPHA
      COMMON/MCLCOM/DALPHA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      CALL MCLCDF(DX,DALPHA,DCDF)
      MCLFU2=DP - DCDF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MCLPDF(X,ALPHA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MCLEISH BESSEL K-FUNCTION
C              DISTRIBUTION.  IT HAS SHAPE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS SYMMETRIC AND IS DEFINED
C              FOR ALL REAL X AND HAS THE PROBABILITY DENSITY FUNCTION
C
C                 MCLPDF(X,ALPHA) = [1/(SQRT(PI)*GAMMA(ALPHA))]*
C                                   (ABS(X)/2)**(ALPHA-1/2)*
C                                   K(X,ALPHA-1/2)
C              WHERE
C                 K(X,N) IS THE MODIFIED BESSEL FUNCTION OF THE
C                        SECOND KIND
C                 GAMMA IS THE GAMMA FUNCTION
C
C     NOTE--ARGUMENTS TO THIS ROUTINE ARE IN DOUBLE PRECISION.
C     INPUT  ARGUMENTS--X       = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE PROBABILITY DENSITY
C                                 FUNCTION IS TO BE EVALUATED.
C                                 X SHOULD BE POSITIVE
C                     --ALPHA    = THE FIRST SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PDF     = THE DOUBLE PRECISION PROBABILITY
C                                 DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY FUNCTION
C             VALUE PDF FOR THE MCLEISH DISTRIBUTION
C             WITH SHAPE PARAMETER ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DBESK.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME I", SECOND EDITION,
C                 WILEY, 1994, PP. 50-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION X
      DOUBLE PRECISION DX
      DOUBLE PRECISION ALPHA
      DOUBLE PRECISION PDF
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DORD
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DEPS
      DOUBLE PRECISION DLNGAM
      EXTERNAL DLNGAM
C
      DOUBLE PRECISION DTEMP1(1000)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA DPI / 3.14159265358979D+00/
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(ALPHA.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)ALPHA
        CALL DPWRST('XXX','WRIT')
        PDF=0.0D0
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR: VALUE OF SHAPE PARAMETER (ALPHA)',
     1       ' IN MCLPDF ROUTINE IS NON-POSITIVE.')
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE DENSITY FUNCTION.  FOR **
C               **  BETTER NUMERICAL STABILITY,        **
C               **  COMPUTE LOGARIGHMS.                **
C               *****************************************
C
C
C  COMPUTE BESSEL FUNCTION FIRST.  IF THIS IS 0, SET PDF TO
C  0 AND RETURN.
C
      DEPS=1.0D-12
      IF(ALPHA.GT.25.0)DEPS=1.0D-10
      DX=X
      DX=DABS(DX)
      IF(DX.EQ.0.0D0)DX=DEPS
      DORD=DABS(ALPHA-0.5D0)
      IARG1=1
      ISCALE=1
      CALL DBESK(DX,DORD,ISCALE,IARG1,DTEMP1,NZERO)
      DTERM3=DTEMP1(IARG1)
      IF(DTERM3.LE.0.0D0)THEN
        PDF=0.0D0
        GOTO9000
      ENDIF
      DTERM3=DLOG(DTERM3)
C
      DTERM1=0.5D0*DLOG(DPI) + DLNGAM(ALPHA)
      DTERM2=(ALPHA-0.5D0)*DLOG(DX/2.0D0)
      DTERM4 = -DTERM1+DTERM2+DTERM3
      PDF=DEXP(DTERM4)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MCLPPF(P,ALPHA,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE MCLEISH DISTRIBUTION.  IT HAS
C              SHAPE PARAMETERS ALPHA.  THIS DISTRIBUTION IS DEFINED
C              FOR ALL REAL X AND HAS THE PROBABILITY DENSITY FUNCTION
C
C                 MCLPDF(X,ALPHA) = [1/(SQRT(PI)*GAMMA(ALPHA))]*
C                                   (ABS(X)/2)**(ALPHA-1/2)*
C                                   K(X,ALPHA-1/2)
C              WHERE
C                 K(X,N) IS THE MODIFIED BESSEL FUNCTION OF THE
C                        SECOND KIND
C                 GAMMA IS THE GAMMA FUNCTION
C
C              THE PERCENT POINT FUNCTION IS COMPUTED BY NUMERICALLY
C              INVERTING THE MCLEISH CUMULATIVE
C              DISTRIBUTION FUNCTION (WHICH IN TURN IS COMPUTED BY
C              NUMERICAL INTEGRATION OF THE PROBABILITYT DENSITY.
C
C     INPUT  ARGUMENTS--P       = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE PERCENT POINT
C                                 FUNCTION IS TO BE EVALUATED.
C                                 0 < P < 1
C                     --ALPHA   = THE FIRST SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PPF     = THE SINGLE PRECISION PERCENT POINT
C                                 FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION
C             VALUE PPF FOR THE MCLEISH
C             DISTRIBUTION WITH SHAPE PARAMETER = ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DFZERO.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 1", SECOND EDITION,
C                 WILEY, PP. 50-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION P
      DOUBLE PRECISION PTEMPL
      DOUBLE PRECISION PTEMPU
      DOUBLE PRECISION ALPHA
      DOUBLE PRECISION PPF
      DOUBLE PRECISION DINC
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
C
      DOUBLE PRECISION DTEMP1(1000)
C
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XUP2
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION RE
      DOUBLE PRECISION AE
C
      DOUBLE PRECISION MCLFU2
      EXTERNAL MCLFU2
C
      DOUBLE PRECISION DP
      COMMON/MC2COM/DP
C
      DOUBLE PRECISION DALPHA
      COMMON/MCLCOM/DALPHA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C               *****************************************
C               **  STEP 1--                           **
C               **  CHECK FOR VALID PARAMETERS         **
C               *****************************************
C
      IF(P.LE.0.0D0 .OR. P.GE.1.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,14)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)P
        CALL DPWRST('XXX','WRIT')
        PPF=0.0D0
        GOTO9000
      ENDIF
    4 FORMAT('***** ERROR: VALUE OF INPUT ARGUMENT (P) IN ',
     1       'MCLPPF ROUTINE')
   14 FORMAT('      IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
      IF(ALPHA.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)ALPHA
        CALL DPWRST('XXX','WRIT')
        PPF=0.0D0
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR: VALUE OF SHAPE PARAMETER (ALPHA)',
     1       ' IN MCLPPF ROUTINE IS NON-POSITIVE.')
C
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(P.EQ.0.5D0)THEN
        PPF=0.0D0
        GOTO9000
      ENDIF
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE PERCENT POINT FUNCTION.**
C               *****************************************
C
C  STEP 1: FIND BRACKETING INTERVAL.  START WITH -10 AND +10,
C          INCREMENT BY 10.
C
      XLOW=-10.0D0
      XUP2=10.0D0
      CALL MCLCDF(XLOW,ALPHA,PTEMPL)
      CALL MCLCDF(XUP2,ALPHA,PTEMPU)
      DINC=10.0D0
C
      MAXIT=1000
      NIT=0
C
  200 CONTINUE
      IF(NIT.GT.MAXIT)THEN
        PPF=0.0D0
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      CALL MCLCDF(XLOW,ALPHA,PTEMPL)
      CALL MCLCDF(XUP2,ALPHA,PTEMPU)
      IF(PTEMPL.LE.P .AND. P.LE.PTEMPU)THEN
        XUP=XUP2
        GOTO300
      ELSEIF(P.GT.PTEMPU)THEN
        XLOW=XUP2
        XUP2=XUP2 + DINC
        NIT=NIT+1
        GOTO200
      ELSEIF(P.LT.PTEMPL)THEN
        XUP2=XLOW
        XLOW=XLOW - DINC
        NIT=NIT+1
        GOTO200
      ENDIF
C
  300 CONTINUE
      AE=1.D-7
      RE=1.D-7
      DALPHA=ALPHA
      DP=P
      CALL DFZERO(MCLFU2,XLOW,XUP,XUP,RE,AE,IFLAG)
C
      PPF=XLOW
C
      IF(IFLAG.EQ.2)THEN
C
C  NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
  999   FORMAT(1X)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM MCLPPF--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      PPF VALUE MAY NOT BE COMPUTED TO DESIRED ',
CCCCC1         'TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM MCLPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      PPF VALUE MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM MCLPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,141)
  141   FORMAT('***** WARNING FROM MCLPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MCLRAN(N,ALPHA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE MCLEISH DISTRIBUTION WITH SHAPE
C              PARAMETER = ALPHA.  THIS DISTRIBUTION IS DEFINED
C              FOR ALL X AND HAS THE PROBABILITY DENSITY FUNCTION
C
C                 MCLPDF(X,ALPHA) = [1/(SQRT(PI)*GAMMA(ALPHA))]*
C                                   (ABS(X)/2)**(ALPHA-1/2)*
C                                   K(X,ALPHA-1/2)
C              WHERE
C                 K(X,N) IS THE MODIFIED BESSEL FUNCTION OF THE
C                        SECOND KIND
C                 GAMMA IS THE GAMMA FUNCTION
C
C              TO GENERATE RANDOM NUMBERS, USE THE RELATIONSHIP
C
C                    Y = SQRT(G)*Z
C
C              WITH G DENOTING A GAMMA RANDOM VARIABLE WITH SHAPE
C              ALPHA AND SCALE PARAMETER 2 AND Z A STANDARD NORMAL
C              RANDOM VARIABLE.
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --ALPHA  = THE SHAPE PARAMETER FOR THE
C                                MCLEISH DISTRIBUTION
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N FROM THE MCLEISH DISTRIBUTION
C             WITH SHAPE PARAMETER ALPHA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, NORRAN, GAMRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME I", SECOND EDITION,
C                 WILEY, 1994, PP. 50-51.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATION INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.8
C     ORIGINAL VERSION--AUGUST    2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
C
    5 FORMAT('***** ERROR--FOR THE MCLEISH DISTRIBUTION, THE REQUESTED')
    6 FORMAT('      NUMBER OF RANDOM NUMBERS WAS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,'.')
CCC48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
C     MCLEISH IS DISTRIBUTION OF SQRT(G)*Z WHERE G IS A GAMMA
C     DISTRIBUTION WITH SHAPE PARAMETER ALPHA AND SCALE PARAMETER 2
C     T IS A STANDARD NORMAL DISTRIBUTION.
C
      CALL GAMRAN(N,ALPHA,ISEED,X)
      NTEMP=1
      DO100I=1,N
        G1=SQRT(2.0*X(I))
        CALL NORRAN(NTEMP,ISEED,Y)
        G2=Y(1)
        X(I)=G1*G2
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MEAN(X,N,IWRITE,XMEAN,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MEAN
C              OF THE DATA IN THE INPUT VECTOR X.
C              THE SAMPLE MEAN = (SUM OF THE OBSERVATIONS)/N.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMEAN  = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MEAN.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MEAN.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 2, EDITION 1, 1961, PAGE 4.
C               --MOOD AND GRABLE, INTRODUCTION TO THE THEORY
C                 OF STATISTICS, EDITION 2, 1963, PAGE 146.
C               --DIXON AND MASSEY, INTRODUCTION TO STATISTICAL
C                 ANALYSIS, EDITION 2, 1957, PAGE 14.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JUNE      1979.
C     UPDATED         --JULY      1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MEAN'
      ISUBN2='    '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF MEAN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,N
   52   FORMAT('IBUGA3,N = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************
C               **  COMPUTE MEAN  **
C               ********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN MEAN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS IN THE VARIABLE FOR')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,114)
  114   FORMAT('      WHICH THE MEAN IS TO BE COMPUTED MUST BE AT ',
     1         'LEAST 1.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.EQ.1)THEN
        XMEAN=X(1)
        GOTO800
      ENDIF
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
      XMEAN=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               *************************
C               **  STEP 2--           **
C               **  COMPUTE THE MEAN.  **
C               *************************
C
      DN=N
      DSUM=0.0D0
      DO200I=1,N
        DSUM=DSUM+DBLE(X(I))
  200 CONTINUE
      XMEAN=REAL(DSUM/DN)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,XMEAN
  811   FORMAT('THE MEAN OF THE ',I8,' OBSERVATIONS = ',E15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF MEAN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IERROR,XMEAN
 9012   FORMAT('IERROR,XMEAN = ',A4,2X,G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE MEDIAN(X,N,IWRITE,XTEMP,MAXNXT,XMED,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MEDIAN
C              OF THE DATA IN THE INPUT VECTOR X.
C              THE SAMPLE MEDIAN = THAT VALUE SUCH THAT HALF THE
C              DATA SET IS BELOW IT AND HALF ABOVE IT.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMED   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MEDIAN.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MEDIAN.
C     OTHER DATAPAC   SUBROUTINES NEEDED--SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGE 326.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 2, EDITION 1, 1961, PAGE 49.
C               --DAVID, ORDER STATISTICS, 1970, PAGE 139.
C               --SNEDECOR AND COCHRAN, STATISTICAL METHODS,
C                 EDITION 6, 1967, PAGE 123.
C               --DIXON AND MASSEY, INTRODUCTION TO STATISTICAL
C                 ANALYSIS, EDITION 2, 1957, PAGE 70.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --FEBRUARY  1976.
C     UPDATED         --JUNE      1979.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --FEBRUARY  1988.  (COMMENTED OUT INPUT ERROR MESSAGES)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MEDI'
      ISUBN2='AN  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MEDIAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               **********************
C               **  COMPUTE MEDIAN  **
C               **********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(1.LE.N.AND.N.LE.MAXNXT)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN MEDIAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE MEDIAN IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)MAXNXT
  115 FORMAT('      MUST BE BETWEEN 1 AND ',I8,' (INCLUSIVELY).')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN MEDIAN--',
CCCCC1'THE 2ND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XMED=X(1)
      GOTO800
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN MEDIAN--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XMED=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               ***************************
C               **  STEP 2--             **
C               **  COMPUTE THE MEDIAN.  **
C               ***************************
C
      CALL SORT(X,N,XTEMP)
C
      IEVODD=N-(N/2)*2
      NMID=N/2
      NMIDP1=NMID+1
      IF(IEVODD.EQ.0)XMED=(XTEMP(NMID)+XTEMP(NMIDP1))/2.0
      IF(IEVODD.EQ.1)XMED=XTEMP(NMIDP1)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,XMED
  811 FORMAT('THE MEDIAN OF THE ',I8,' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MEDIAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XMED
 9015 FORMAT('XMED = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MIDMEA(X,N,IWRITE,XTEMP,MAXNXT,XMIDM,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MIDMEAN = THE
C              SAMPLE 25% (ON EACH SIDE) TRIMMED MEAN
C              OF THE DATA IN THE INPUT VECTOR X.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMIDM  = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MIDMEAN.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MIDMEAN.
C     OTHER DATAPAC   SUBROUTINES NEEDED--SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--DAVID, ORDER STATISTICS, 1970, PAGES 129, 136.
C               --CROW AND SIDDIQUI, 'ROBUST ESTIMATION OF LOCATION',
C                 JOURNAL OF THE AMERICAN STATISTICAL ASSOCIATION,
C                 1967, PAGES 357, 387.
C               --FILLIBEN, SIMPLE AND ROBUST LINEAR ESTIMATION
C                 OF THE LOCATION PARAMETER OF A SYMMETRIC
C                 DISTRIBUTION (UNPUBLISHED PH.D. DISSERTATION,
C                 PRINCETON UNIVERSITY, 1969).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --FEBRUARY  1976.
C     UPDATED         --JUNE      1979.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     2007. FIX BUG
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DX
      DOUBLE PRECISION DSUM
C
      DIMENSION X(*)
      DIMENSION XTEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MIDM'
      ISUBN2='EA  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MIDMEA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ***********************
C               **  COMPUTE MIDMEAN  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(1.LE.N.AND.N.LE.MAXNXT)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN MIDMEA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE MIDMEAN IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)MAXNXT
  115 FORMAT('      MUST BE BETWEEN 1 AND ',I8,' (INCLUSIVELY).')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN MIDMEA--',
CCCCC1'THE 2ND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XMIDM=X(1)
      GOTO800
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN MIDMEA--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XMIDM=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               ****************************
C               **  STEP 2--              **
C               **  COMPUTE THE MIDMEAN.  **
C               ****************************
C
      CALL SORT(X,N,XTEMP)
C
      P1=0.25
      NP1=P1*AN+0.0001
      ISTART=NP1+1
C
      P2=0.25
      NP2=P2*AN+0.0001
      ISTOP=N-NP2
C
      DSUM=0.0
      K=0
      IF(ISTART.GT.ISTOP)GOTO250
      DO200I=ISTART,ISTOP
      K=K+1
CCCCC MARCH 2007.  USE SORTED VALUE
CCCCC DX=X(I)
      DX=XTEMP(I)
      DSUM=DSUM+DX
  200 CONTINUE
      DK=K
      XMIDM=DSUM/DK
      GOTO290
C
  250 CONTINUE
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,251)
  251 FORMAT('***** INTERNAL ERROR IN MIDMEA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,252)
  252 FORMAT('      START INDEX IS HIGHER THAN STOP INDEX.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,253)ISTART,ISTOP
  253 FORMAT('      ISTART,ISTOP = ',2I8)
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  290 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      PERP1=100.0*P1
      PERP2=100.0*P2
      PERP3=100.0*(1.0-P1-P2)
      WRITE(ICOUT,811)PERP1,NP1
  811 FORMAT(8X,F10.4,' PERCENT (= ',I8,' OBSERVATIONS) ',
     1'OF THE DATA WERE TRIMMED         FROM BELOW')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,812)PERP2,NP2
  812 FORMAT(8X,F10.4,' PERCENT (= ',I8,' OBSERVATIONS) ',
     1'OF THE DATA WERE TRIMMED         FROM ABOVE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,813)PERP3,K
  813 FORMAT(8X,F10.4,' PERCENT (= ',I8,' OBSERVATIONS) ',
     1'OF THE DATA REMAIN IN MIDDLE AFTER TRIMMING')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,821)N,XMIDM
  821 FORMAT('THE MIDMEAN OF THE ',I8,' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MIDMEA--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XMIDM
 9015 FORMAT('XMIDM = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MIDRAN(X,N,IWRITE,XMIDR,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MIDRANGE
C              OF THE DATA IN THE INPUT VECTOR X.
C              THE SAMPLE MIDRANGE = (SAMPLE MIN + SAMPLE MAX)/2.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMIDR  = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MIDRANGE.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MIDRANGE.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGE 338.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 2, EDITION 1, 1961, PAGE 91.
C               --DAVID, ORDER STATISTICS, 1970, PAGE 97.
C               --DIXON AND MASSEY, INTRODUCTION TO STATISTICAL
C                 ANALYSIS, EDITION 2, 1957, PAGE 71.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JUNE      1979.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MIDR'
      ISUBN2='AN  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MIDRAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ************************
C               **  COMPUTE MIDRANGE  **
C               ************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN MIDRAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE MIDRANGE IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN MIDRAN--',
CCCCC1'THE 2ND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XMIDR=X(1)
      GOTO9000
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN MIDRAN--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XMIDR=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               *****************************
C               **  STEP 2--               **
C               **  COMPUTE THE MIDRANGE.  **
C               *****************************
C
      XMIN=X(1)
      XMAX=X(1)
      DO200I=1,N
      IF(X(I).LT.XMIN)XMIN=X(I)
      IF(X(I).GT.XMAX)XMAX=X(I)
  200 CONTINUE
      XMIDR=(XMIN+XMAX)/2.0
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,XMIDR
  811 FORMAT('THE MIDRANGE OF THE ',I8,' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MIDRAN--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XMIDR
 9015 FORMAT('XMIDR = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MIECDF(DX,DK,DTHETA,DCDF)
CCCCC SUBROUTINE MIECDF(X,AK,BETA,THETA,CDF)
C
C     NOTE 05/06/2008--THE FOLLOWING 3 CHANGES WERE MADE:
C
C                      1) RENAMED FROM KAPPDF TO MIEPDF TO DISTINGUISH
C                         FROM THE KAPPA DISTRIBUTION DEFINED BY
C                         HOSKING AND WALLIS.
C
C                      2) BETA IS ACTUALLY A SCALE PARAMETER, SO WE
C                         CAN ASSUME BETA = 1 FOR STANDARD FORM OF
C                         DISTRIBUTION.
C
C                      3) MAKE THE ARGUMENTS DOUBLE PRECISION.
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DENSITY
C              FUNCTION VALUE FOR THE MIELKE'S BETA-KAPPA DISTRIBUTION
C              WITH POSITIVE SHAPE PARAMETERS K AND THETA.
C              THE CDF FOR THE DISTRIBUTION IS
C                  F(X;K,THETA) = {X**THETA/(1 + X**THETA)}**(K/THETA)  X > 0
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --DK     = A POSITIVE SHAPE PARAMETER
C                     --DTHETA = A POSITIVE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--DCDF   = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE MIELKE'S BETA-KAPPA
C             DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE POSITIVE.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2", SECOND EDITION, P. 351.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C     VERSION NUMBER--96/1
C     ORIGINAL VERSION--JANUARY   1996.
C     UPDATED         --MAY       2008. RENAME ROUTINE
C     UPDATED         --MAY       2008. TREAT BETA AS SCALE PARAMETER
C     UPDATED         --MAY       2008. ARGUMENTS DOUBLE PRECISION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DCDF
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DCDF=0.0D0
      IF(DX.LE.0.0D0)THEN
CCCCC   WRITE(ICOUT,5)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,46)DX
CCCCC   CALL DPWRST('XXX','BUG ')
        GOTO9999
CCCC5   FORMAT('***** ERROR--THE FIRST ARGUMENT TO MIECDF IS ',
CCCCC1         'NON-POSITIVE')
      ELSEIF(DK.LE.0.0D0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DK
        CALL DPWRST('XXX','BUG ')
        GOTO9999
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO MIECDF IS ',
     1         'NON-POSITIVE')
      ELSEIF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   35 FORMAT('***** ERROR--THE THIRD ARGUMENT TO MIECDF IS ',
     1       'NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      DTERM1=DTHETA*DLOG(DX) - DLOG(1.0D0+DX**DTHETA)
      DTERM2=(DK/DTHETA)*DTERM1
      DCDF=DEXP(DTERM2)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MIEPDF(DX,DK,DTHETA,DPDF)
CCCCC SUBROUTINE MIEPDF(X,AK,BETA,THETA,PDF)
C
C     NOTE 05/06/2008--THE FOLLOWING 3 CHANGES WERE MADE:
C
C                      1) RENAMED FROM KAPPDF TO MIEPDF TO DISTINGUISH
C                         FROM THE KAPPA DISTRIBUTION DEFINED BY
C                         HOSKING AND WALLIS.
C
C                      2) BETA IS ACTUALLY A SCALE PARAMETER, SO WE
C                         CAN ASSUME BETA = 1 FOR STANDARD FORM OF
C                         DISTRIBUTION.
C
C                      3) MAKE THE ARGUMENTS DOUBLE PRECISION.
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MIELKE'S BETA-KAPPA DISTRIBUTION
C              WITH POSITIVE SHAPE PARAMETERS K AND THETA.
C              THE PDF FOR THE STANDARD FORM OF THE DISTRIBUTION IS
C
C                 f(X;K,THETA) = K*X**(K-1)/[1+X**THETA]**(1+(K/THETA))
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --DK     = A POSITIVE SHAPE PARAMETER
C                     --DTHETA = A POSITIVE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--DPDF   = THE DOUBLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE MIELKE'S BETA-KAPPA
C             DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE POSITIVE.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION, P. 351.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C     VERSION NUMBER--96/1
C     ORIGINAL VERSION--JANUARY   1996.
C     UPDATED         --MAY       2008. RENAME ROUTINE
C     UPDATED         --MAY       2008. TREAT BETA AS SCALE PARAMETER
C     UPDATED         --MAY       2008. MAKE ARGUMENTS DOUBLE PRECISION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DPDF
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DPDF=0.0D0
      IF(DX.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG ')
        GOTO9999
    5   FORMAT('***** ERROR--THE FIRST ARGUMENT TO MIEPDF IS ',
     1         'NON-POSITIVE')
      ELSEIF(DK.LE.0.0D0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DK
        CALL DPWRST('XXX','BUG ')
        GOTO9999
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO MIEPDF IS ',
     1         'NON-POSITIVE')
      ELSEIF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   35 FORMAT('***** ERROR--THE THIRD ARGUMENT TO MIEPDF IS ',
     1       'NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      DTERM1=DLOG(DK) + (DK-1.0D0)*DLOG(DX)
      DTERM2=(1.0D0 + (DK/DTHETA))*DLOG(1.0D0 + DX**DTHETA)
      DTERM3=DTERM1-DTERM2
      DPDF=DEXP(DTERM3)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MIEPPF(DP,DK,DTHETA,DPPF)
CCCCC SUBROUTINE MIEPPF(P,AK,BETA,THETA,PPF)
C
C     NOTE 05/06/2008--THE FOLLOWING 2 CHANGES WERE MADE:
C
C                      1) RENAMED FROM KAPPPF TO MIEPPF TO DISTINGUISH
C                         FROM THE KAPPA DISTRIBUTION DEFINED BY
C                         HOSKING AND WALLIS.
C
C                      2) BETA IS ACTUALLY A SCALE PARAMETER, SO WE
C                         CAN ASSUME BETA = 1 FOR STANDARD FORM OF
C                         DISTRIBUTION.
C
C                      3) MAKE ARGUMENTS DOUBLE PRECISION
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE MIELKE'S BETA-KAPPA DISTRIBUTION
C              WITH POSITIVE SHAPE PARAMETERS K AND THETA.
C              THE PPF FOR THE STANDARD FORM OF THE DISTRIBUTION IS
C                  G(P;K.THETA) = [P**(THETA/K)/(1-P**(THETA/K))]**(1/THETA)
C                                 0 < P < 1
C     INPUT  ARGUMENTS--P      = THE DOUBLE PRECISION VALUE AT WHICH THE
C                                PERCENT POINT FUNCTION IS TO BE EVALUATED.
C                     --AK     = A POSITIVE SHAPE PARAMETER
C                     --THETA  = A POSITIVE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PPF    = THE DOUBLE PRECISION PERCENT POINT
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUE PPF FOR
C             THE MIELKE'S BETA-KAPPA DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--0 < P < 1, THETA, K > 0.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN (1994), "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2", SECOND EDITION, P. 351.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C     UPDATED         --MAY       2008. RENAME ROUTINE
C     UPDATED         --MAY       2008. TREAT BETA AS SCALE PARAMETER
C     UPDATED         --MAY       2008. MAKE ARGUMENTS DOUBLE PRECISION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DP
      DOUBLE PRECISION DK
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
      DOUBLE PRECISION DPPF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(DP.LE.0.0D0 .OR. DP.GE.1.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        GOTO9999
    5   FORMAT('***** ERROR--THE FIRST ARGUMENT TO MIEPPF IS ',
     1         'OUTSIDE THE (0,1) INTERVAL')
      ELSEIF(DK.LE.0.0D0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DK
        CALL DPWRST('XXX','BUG ')
        GOTO9999
   15   FORMAT('***** ERROR--THE SECOND ARGUMENT TO MIEPPF IS ',
     1         'NON-POSITIVE')
      ELSEIF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   35 FORMAT('***** ERROR--THE THIRD ARGUMENT TO MIEPPF IS ',
     1       'NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      DTERM2=(1.0D0/DTHETA)
      DTERM3=DP**(DTHETA/DK)
      DTERM4=DLOG(-DTERM3/(DTERM3-1.0D0))
      DTERM5=DTERM2*DTERM4
      DPPF=DEXP(DTERM5)
C
CCCCC DTERM1=(DTHETA/DK)*DLOG(DP) - DLOG(1.0D0 - DP**(DTHETA/DK))
CCCCC DTERM2=(DK/DTHETA)*DTERM1
CCCCC DPPF=DEXP(DTERM2)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MIERAN(N,AK,THETA,ISEED,X)
C
C     NOTE 05/06/2008--THE FOLLOWING 2 CHANGES WERE MADE:
C
C                      1) RENAMED FROM KAPRAN TO MIERAN TO DISTINGUISH
C                         FROM THE KAPPA DISTRIBUTION DEFINED BY
C                         HOSKING AND WALLIS.
C
C                      2) BETA IS ACTUALLY A SCALE PARAMETER, SO WE
C                         CAN ASSUME BETA = 1 FOR STANDARD FORM OF
C                         DISTRIBUTION.
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE MIELKE'S BETA-KAPPA DISTRIBUTION
C              WITH SHAPE PARAMETERs = K AND THETA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --K      = THE SINGLE PRECISION VALUE OF THE
C                                K SHAPE PARAMETER.
C                     --THETA  = THE SINGLE PRECISION VALUE OF THE
C                                THETA SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE MIELKE'S BETA-KAPPA DISTRIBUTION
C             WITH SHAPE PARAMETERS K AND THETA
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --ANU SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C     VERSION NUMBER--2003.7
C     ORIGINAL VERSION--JULY      2003.
C     UPDATED         --MAY       2008. RENAME ROUTINE
C     UPDATED         --MAY       2008. TREAT BETA AS SCALE PARAMETER
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
      DOUBLE PRECISION DPPF
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF MIELKE ',
     1       'BETA-KAPPA RANDOM NUMBERS IS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
      IF(AK.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AK
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   15 FORMAT('***** ERROR--THE FIRST SHAPE PARAMETER (K) FOR ',
     1'THE  MIELKE BETA-KAPPA RANDOM NUMBERS IS NON-POSITIVE')
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   35 FORMAT('***** ERROR--THE THIRD SHAPE PARAMETER (THETA) ',
     1'FOR THE  MIELKE BETA-KAPPA RANDOM NUMBERS IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N MIELKE'S BETA-KAPPA DISTRIBUTION RANDOM
C     NUMBERS USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
CCCCC   CALL KAPPPF(X(I),AK,BETA,THETA,XTEMP)
        CALL MIEPPF(DBLE(X(I)),DBLE(AK),DBLE(THETA),DPPF)
        X(I)=REAL(DPPF)
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MINDIS(AMAT,AMAT2,MAXROM,MAXCOM,NR1,NC1,P,ICASE,
     1IWRITE,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              MINKOWSKI DISTANCE OF A MATRIX.  THE FORMULA IS:
C                 Dij=SUM(ABS|(Xik - Xjk)|**P)**(1/P)
C              THE SUM IS FROM K = 1 TO P (WHERE THERE ARE P
C              COLUMNS IN THE MATRIX).  FOR EXAMPLE, D23 IS
C              THE DISTANCE BETWEEN THE SECOND AND THIRD ROWS.
C              (ALTERNATIVELY, THE DISTANCE CAN BE CALCULATED
C              ACROSS COLUMNS).
C     INPUT  ARGUMENTS--AMAT   = THE SINGLE PRECISION MATRIX
C                     --MAXROM = THE INTEGER ROW DIMENSION OF AMAT
C                     --MAXCOM = THE INTEGER COUMN DIMENSION OF AMAT
C                     --NR1    = THE INTEGER NUMBER OF ROWS OF AMAT
C                     --NC1    = THE INTEGER NUMBER OF COLUMNS OF AMAT
C     OUTPUT ARGUMENTS--AMAT2    = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MINKOWSKI DISTANCES.
C     OUTPUT--MATRIX OF MINKOWSKI DISTANCES
C     NOTE--THIS ROUTINE ASSUMES THE ERROR CHECKING (FOR EQUAL
C           ROWS AND COLUMNS, MATCHING DIMENSIONS FOR X AND AMAT)
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98.7
C     ORIGINAL VERSION--JULY      1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASE
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DYM1
      DOUBLE PRECISION DYM2
C
      DIMENSION AMAT(MAXROM,MAXCOM)
      DIMENSION AMAT2(MAXROM,MAXCOM)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='CHED'
      ISUBN2='IS  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MINDIS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)NR1,NC1
   53 FORMAT('NR1, NC1 = ',2I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ICASE
   54 FORMAT('ICASE = ',A4)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************
C               **  COMPUTE MINKOWSKI DISTANCE *
C               ********************************
C
      IF(ICASE.EQ.'ROW ')THEN
        DO5861I=1,NR1
          DO5863J=1,I
            IF(I.EQ.1)THEN
              AMAT2(I,I)=0.0
            ELSE
              DSUM=0.0D0
              DO5865K=1,NC1
                DYM1=AMAT(I,K)
                DYM2=AMAT(J,K)
                DSUM=DSUM + DABS(DYM1-DYM2)**DBLE(P)
 5865         CONTINUE
              AMAT2(I,J)=REAL(DSUM**(1.0D0/DBLE(P)))
              AMAT2(J,I)=AMAT2(I,J)
            ENDIF
 5863     CONTINUE
 5861   CONTINUE
      ELSEIF(ICASE.EQ.'COLU')THEN
        DO5961I=1,NC1
          DO5963J=1,I
            IF(I.EQ.J)THEN
              AMAT2(I,I)=0.0
            ELSE
              DSUM=0.0D0
              DO5965K=1,NR1
                DYM1=AMAT(K,I)
                DYM2=AMAT(K,J)
                DSUM=DSUM + DABS(DYM1-DYM2)**DBLE(P)
 5965         CONTINUE
              AMAT2(I,J)=REAL(DSUM**(1.0D0/DBLE(P)))
              AMAT2(J,I)=AMAT2(I,J)
            ENDIF
 5963     CONTINUE
 5961   CONTINUE
      ENDIF
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)
  811 FORMAT('THE MINKOWSKI DISTANCE MATRIX HAS BEEN CALCULATED.')
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MINDIS--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MINIM(X,N,IWRITE,XMIN,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE MINIMUM
C              OF THE DATA IN THE INPUT VECTOR X.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XMIN   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE MINIMUM.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE MINIMUM.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--DAVID, ORDER STATISTICS, 1970, PAGE 7.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JUNE      1979.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --FEBRUARY  1988. (SUPPRESS SOME DIAGNOSTIC MESSAGES)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MINI'
      ISUBN2='M   '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF MINIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ***********************
C               **  COMPUTE MINIMUM  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN MINIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE MINIMUM IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN MINIM--',
CCCCC1'THE 2ND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XMIN=X(1)
      GOTO800
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN MINIM--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XMIN=HOLD
      GOTO800
  139 CONTINUE
C
  190 CONTINUE
C
C               ****************************
C               **  STEP 2--              **
C               **  COMPUTE THE MINIMUM.  **
C               ****************************
C
      XMIN=X(1)
      DO200I=2,N
      IF(X(I).LT.XMIN)XMIN=X(I)
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,XMIN
  811 FORMAT('THE MINIMUM OF THE ',I8,' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF MINIM--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)XMIN
 9015 FORMAT('XMIN = ',E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE MININD(X,N,IWRITE,PSTAMV,XIND,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE INDEX WHERE THE
C              SAMPLE MINIMUM OF THE DATA IN THE INPUT VECTOR X
C              OCCURS.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XIND   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED INDEX OF THE SAMPLE MINIMUM.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE INDEX OF THE MINIMUM.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.2
C     ORIGINAL VERSION--FEBRUARY  2009.
C     UPDATED         --APRIL     2010. SKIP "MISSING VALUES"
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MINI'
      ISUBN2='ND  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'NIND')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF MININD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ***********************
C               **  COMPUTE MINIMUM  **
C               ***********************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN INDEX MINIMUM--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLE MUST BE 1 OR LARGER.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,116)
  116   FORMAT('      SUCH WAS NOT THE CASE HERE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1         '.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.EQ.1)THEN
        XIND=1.0
        GOTO800
      ENDIF
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE INDEX OF THE MINIMUM.  **
C               *****************************************
C
      XMIN=CPUMAX
      XIND=1.0
      DO200I=1,N
        IF(X(I).NE.PSTAMV .AND. X(I).LT.XMIN)THEN
          XMIN=X(I)
          XIND=REAL(I)
        ENDIF
  200 CONTINUE
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
  800 CONTINUE
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,XIND
  811   FORMAT('THE INDEX FOR THE MINIMUM VALUE OF THE ',I8,
     1         ' OBSERVATIONS = ',F12.0)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'NIND')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF MININD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N
 9013   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)XMIN,XIND
 9015   FORMAT('XMIN,XIND = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      subroutine mixtur(a, k, m, c, x, n, 
     +    alpha, mean, sd, tol, nobvs,
     +    newalp,newmea,newsd,dt,nt,vt,g,f,
     +    kmax,mmax,
     +    logl, icount, ifault)
c
c     Translation from Algol 60 by Alan Miller of AS 203.
c
c     ALGORITHM AS 203 APPL. STATIST. (1984) VOL.33, NO. 3
c
c     This algorithm calculates the maximum likelihood estimates of the
c     parameters of a mixture of normal or exponential or Poisson or
c     binomial distributions.   These parameters are the mixing
c     proportions, the means and (in the normal distribution case)
c     standard deviations.   It also calculates the log-likelihood
c     function and the number of iterations taken to satisfy the
c     tolerance value.
c
c     Users must provide their own routine `putout' which prints the
c     estimated parameter values after each iteration.   The form of
c     this routine is:
c        subroutine putout(k, alpha, mean, sd, logl)
c        integer k
c        real alpha(k), mean(k), sd(k), logl
c
c     Notes:
c     The original (Algol) variable names have been retained.   This
c     means that some variable names have more than 6 characters, such
c     as `counter', `newalp', etc.
c
c     NOTE: For Dataplot, variable names have been modified to be
c           six characters or less.
c
c     The authors treat the normal distribution as if it were a discrete
c     distribution.
c     In Fortran 77 it is necessary to give explicit dimensions to some
c     of the temporary arrays which are not passed as arguments.
c     Maximum values have been set for k and m (kmax and mmax) in the
c     parameter statement under `Local variables' below.
c
c     NOTE: For Dataplot, dimension in calling routine and pass
c           in to this routine.
c
      integer a, k, m, c, n(m), nobvs, icount, ifault
      real x(m), alpha(k), mean(k), sd(k), tol, logl
ccccc external putout
c
c     Local variables
c
      integer kmax, mmax, i, j
ccccc parameter (kmax = 20, mmax = 100)
      logical test
      real sumalp, part, oldlgl
      real zero, one, half
c
      real newalp(kmax)
      real newmea(kmax)
      real newsd(kmax)
      real dt(kmax)
      real nt(kmax)
      real vt(kmax)
c
      real g(mmax)
      real f(mmax, kmax)
c
      data zero /0.0/, one /1.0/, half /0.5/
c
      if (a .lt. 1 .or. a .gt. 4) then
        ifault = 1
        return
      else
        ifault = 0
      end if

      do 10 i = 1, m-1
        if (x(i) .gt. x(i+1)) then
          ifault = 5
          return
        end if
   10 continue

      if (nobvs .lt. 2 * m) then
        ifault = 6
        return
      end if

      do 20 i = 1, m
        if (n(i) .lt. 0) then
          ifault = 6
          return
        end if
        if (a .ne. 1) then
          if (x(i) .lt. zero) then
            ifault = 7
            return
          end if
        end if
   20 continue

      oldlgl = zero
      icount = 0 
c
c     Start of iterative cycle
c
   30 icount = icount + 1
      do 40 j = 1, k
        if (alpha(j) .gt. one .or. alpha(j) .lt. zero) then
          ifault = 2
          return
        end if
        if (mean(j) .ge. x(m) .or. mean(j) .le. x(1)) then
          ifault = 3
          return
        end if
        if (a .eq. 1) then
          if (sd(j) .le. zero) then
            ifault = 4
            return
          end if
        end if
   40 continue

      do 60 i = 1, k-1
        do 50 j = i+1, k
          if (mean(i) .eq. mean(j)) then
            if (a .eq. 1) then
              if (sd(i) .eq. sd(j)) then
                ifault = 9
                return
              end if
            else
              ifault = 8
              return
            end if
          end if
   50   continue
   60 continue

      logl = zero
      do 80 i = 1, m
        g(i) = zero
        do 70 j = 1, k
c
c     a = 1 denotes normal mixture
c     a = 2 denotes exponential mixture
c     a = 3 denotes Poisson mixture
c     a = 4 denotes binomial mixture
c
          if (a .eq. 1) then
            f(i,j) = exp(-half*((x(i) - mean(j))/sd(j))**2) / sd(j)
          else if (a .eq. 2) then
            f(i,j) = exp(-x(i)/mean(j)) / mean(j)
          else if (a .eq. 3) then
            if (x(i) .eq. x(1)) then
              f(i,j) = exp(-mean(j)) * mean(j)**x(i)
            else
              f(i,j) = f(i-1,j) * mean(j)
            end if
          else
            if (x(i) .eq. x(1)) then
              f(i,j) = (one - mean(j) / x(m))**x(m) * (mean(j) /
     +                  (x(m) - mean(j)))**x(i)
            else
              f(i,j) = f(i-1,j) * (mean(j) / (x(m) - mean(j)))
            end if
          end if
          g(i) = g(i) + alpha(j) * f(i,j)
   70   continue
        logl = logl + n(i) * log(g(i))
   80 continue
c
c     Calculation of the probability densities of the sub-populations
c     which form the mixture, and the log-likelihood function.
c
      test = .false.
      sumalp = zero
      do 100 j = 1, k
        nt(j) = zero
        dt(j) = zero
        vt(j) = zero
        do 90 i = 1, m
          part = f(i,j) * n(i) / g(i)
          dt(j) = dt(j) + part
          nt(j) = nt(j) + part * x(i)
          if (a .eq. 1) vt(j) = vt(j) + part * (x(i) - mean(j))**2
   90   continue
c
c     Calculation of denominators and numerators of new estimates.
c
        newmea(j) = nt(j) / dt(j)
        if (j .ne. k) then
          newalp(j) = alpha(j) * dt(j) / nobvs
          sumalp = sumalp + newalp(j)
        else
          newalp(k) = one - sumalp
        end if
        if (a .eq. 1) newsd(j) = sqrt(vt(j) / dt(j))
c
c     Convergence test.
c
        if (abs(oldlgl - logl) .gt. tol) test = .true.
        oldlgl = logl
        alpha(j) = newalp(j)
        mean(j) = newmea(j)
        if (a .eq. 1) sd(j) = newsd(j)
  100 continue
c
      if (c .gt. 0) then
        if ((icount/c)*c .eq. icount) then
ccccc     call putout(k, alpha, mean, sd, logl)
        end if
      end if

      if (test) go to 30
      return
      end
      SUBROUTINE MLEGEV(X, N, PARA, VCOV, MONIT, IFAULT)
         
C        ALGORITHM AS215   APPL. STATIST. (1985) VOL. 34, NO. 3
C        Modifications in AS R76 (1989) have been incorporated.
C
C        MAXIMUM-LIKELIHOOD ESTIMATION OF GENERALIZED EXTREME-VALUE
C        DISTRIBUTION
C
      DOUBLE PRECISION PARA(3), VCOV(6), X(N)
      DOUBLE PRECISION A, ACCA, ACCG, ACCU, AI, AIGI, AN, D, DA, DAA,
     *  DAG, DELA, DELG, DELU, DG, DGG, DU, DUA, DUG, DUU, E, F, FOLD,
     *  G, GAI, GG, GI, GIPQ, GNORM, H, HALF, HE, HH, ONE, P, PA, PQ,
     *  PQG, PU, Q, QA, QU, R, RA, RATIO, RG, RU, SE, SH, SHE, SHH,
     *  SHHE, SMALL, SRF, STEPA, STEPG, STEPU, SY, SYE, SYHE, SYYE,
     *  TEMP1, TEMP2, U, VLNEG, XMAX, XMIN, Y, YE, Z, ZERO
      CHARACTER*8 ACTI1, ACTI2, ACTI3, ACTI4, ACTI5, ACTI6, ACTI7,
     *  ACTI8, ACTI9
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA ACTI1/'  NEWTON'/, ACTI2/'  ST.ASC'/, ACTI3/'  RESETK'/,
     *  ACTI4/'  SR.INF'/, ACTI5/'  SR.LIK'/, ACTI6/'  MAX.SR'/,
     *  ACTI7/'  MAX.EV'/, ACTI8/'  MAX.IT'/, ACTI9/'  CONVGD'/
      DATA ZERO /0.0D0/, HALF /0.5D0/, ONE/1.0D0/
C
C        ADDU,ACCA,ACCG ARE ACCURACY CRITERIA FOR TESTING CONVERGENCE
C        STEPU,STEPA,STEPG ARE MAXIMUM STEPLENGTHS FOR ITERATIONS
C        ACCU,ACCA,STEPU,STEPA ARE SCALED BY CURRENT VALUE OF A WHEN
C        USED IN PROGRAM
C
CCCCC DATA ACCU, ACCA, ACCG /3 * 1.0D-5/, STEPU, STEPA, STEPG /
      DATA ACCU /0.00001D0/
      DATA ACCA /0.00001D0/
      DATA ACCG /0.00001D0/
      DATA STEPU /0.5D0/
      DATA STEPA /0.25D0/
      DATA STEPG /0.01D0/
C
C        MAXIT IS MAX. NO. OF ITERATIONS
C        MAXEV IS MAX. NO. OF EVALUATIONS OF LIKELIHOOD FUNCTION
C        SRF IS STEPLENGTH REDUCTION FACTOR
C        MAXSR IS MAX. NO. OF STEPLENGTH REDUCTIONS PERMITTED PER
C        ITERATION
C
CCCCC DATA MAXIT /30/, MAXEV /50/, SRF /0.25D0/, MAXSR /30/
      DATA MAXIT /300/, MAXEV /500/, SRF /0.25D0/, MAXSR /300/
C
C        SMALL IS A SMALL NUMBER, USED TO ADJUST THE SHAPE PARAMETER TO
C        AVOID AN EXACT ZERO VALUE OR BORDERLINE INFEASIBILITY
C        ALNEG IS A LARGE NEGATIVE NUMBER, USED TO INITIALIZE
C        LOG-LIKELIHOOD
C
      DATA SMALL /1.D-3/, VLNEG /-1.D37/
C
C        FIND MIN AND MAX DATA VALUE
C
      DO 10 I = 1, 6
  10  VCOV(I) = ZERO
      IFAULT = 1
      IF (N .LE. 2) GOTO 170
      XMIN = X(1)
      XMAX = X(1)
      DO 20 I = 2, N
        IF (X(I) .LT. XMIN) XMIN = X(I)
        IF (X(I) .GT. XMAX) XMAX = X(I)
   20 CONTINUE
C
C       INITIALIZATION
C       U IS LOCATION PARAMETER
C       A IS SCALE PARAMETER
C       G IS SHAPE PARAMETER
C
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE (ICOUT, 6000)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE (ICOUT, 6003)
        CALL DPWRST('XXX','BUG ')
      ENDIF
  999 FORMAT(1X)
 6000 FORMAT(' MAXIMUM-LIKELIHOOD ESTIMATION OF GENERALIZED EXTREME',
     *  1X, 'VALUE DISTRIBUTION')
 6003 FORMAT(' ITER EVAL', 8X, 'XI', 5X, 'ALPHA',
     *  9X, 'K  ACTION', 6X, 'LOG-L', 7X, 'GNORM')
C
      IFAULT = 0
      NITER = 0
      NEVAL =0
      FOLD = VLNEG
      U = PARA(1)
      A = PARA(2)
      G = PARA(3)
      IF (G .EQ. ZERO) G = SMALL
      IF (Z .LE. ZERO) A = ONE
      AN = DBLE(FLOAT(N))
C
C        CHECK WHETHER ALL DATA POINTS LIE WITHIN THE RANGE OF THE GEV
C        DISTRIBUTION WITH THE INITIAL PARAMETERS - IF NOT, ADJUST THE
C        SHAPE PARAMETER SO AS TO BRING ALL POINTS WITHIN RANGE
C
      IF (G .GT. ZERO) GOTO 30
      IF (XMIN .GE. U) GOTO 40
      Z = A / (XMIN - U)
      IF (MONIT .GT. 0) THEN
        WRITE (ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI3
        CALL DPWRST('XXX','BUG ')
      ENDIF
 6010 FORMAT(1X, I4, I5, 3F10.4, 1X, A, F11.3, 1PD12.2)
C
      G = Z + SMALL
      IF (G .GE. ZERO) G = HALF * Z
      GOTO 40
   30 IF (XMAX .LE. U) GOTO 40
      Z = A / (XMAX - U)
      IF (G .LT. Z) GOTO 40
      IF(MONIT .GT. 0) THEN
        WRITE (ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI3
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      G = Z - SMALL
      IF (G .LE. ZERO) G = HALF * Z
C
C        START OF MAIN LOOP
C
   40 DO 140 NITER = 1, MAXIT
C
      NSR = 0
   50 IF (NEVAL .GE. MAXEV) GOTO 150
      NEVAL = NEVAL + 1
      AI = ONE / A
      GI = ONE /G
      GAI = G * AI
      AIGI = AI * GI
      GG = ONE - G
C        
C       ACCUMULATE SUMS OF QUANTITIES OCCURRING IN LIKELIHOOD
C       DERIVATIVES
C
C       IN PRESCOTT AND WALDEN'S NOTATION:
C       Z IS 1 - K * (X(I)-U) / A
C       Y IS THE REDUCED VARIATE - (1/K) * LOG(Z)
C       E IS EXP(-Y)
C       H IS EXP(K*Y)
C
      SY = ZERO
      SE = ZERO
      SYE = ZERO
      SYYE = ZERO
      SH = ZERO
      SHE = ZERO
      SYHE = ZERO
      SHHE = ZERO
      SHH = ZERO
      DO 60 I = 1, N
        Z = ONE -GAI * (X(I) - U)
        Y = -GI * LOG(Z)
        E = EXP(-Y)
        H = ONE / Z
        YE = Y * E
        HE = H * E
        HH = H * H
        SY = SY + Y
        SY = SY + E
        SYE = SYE + YE
        SYYE = SYYE + Y * YE
        SH = SH + H
        SHE = SHE + HE
        SYHE = SYHE + Y * HE
        SHHE = SHHE + HH * E
        SHH = SHH + HH
   60 CONTINUE
C
C       F IS CURRENT VALUE OF LIKELIHOOD FUNCTIONN
C
      F = -AN * LOG(A) - GG * SY - SE
      IF (F .GT. FOLD) GOTO 90
C
C       LIKELIHOOD HAS NOT INCREASED - REDUCE STEPLENGTH AND TRY AGAIN
C
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI5, F
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF (NSR .EQ. MAXSR) GOTO 80
   70 NSR = NSR + 1
      U = U - DELU
      A = A - DELA
      G = G - DELG
      DELU = SRF * DELU
      DELA = SRF * DELA
      DELG = SRF * DELG
      U = U + DELU
      A = A + DELA
      G = G + DELG
      IF (A .GT. G * (XMIN - U) .AND. A .GT. G * (XMAX - U) .AND. G .NE.
     *  ZERO) GO TO 50
      IF (MONIT .GT. 0) THEN
        WRITE (ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI4
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF (NSR .LT. MAXSR) GOTO 70
C
C        MAX. NO. OF STEPLENGTH REDUCTIONS REACHED
C        IF CURRENT ITERATION IS NEWTON-RAPHSON, TRY STEEPEST ASCENT
C        INSTEAD.  IF CURRENT ITERATION IS STEEPEST ASCENT, GIVE UP.
C
   80 U = U - DELU
      A = A - DELA
      G = G - DELG
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI6
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      IF (ITYPE .EQ. 1) GOTO 100
      IFAULT = 4
      GOTO 160
C
C        P,Q,R, ARE AS DEFINED IN FLOOD STUDIES REPORT
C
   90 FOLD = F
      P = AN - SE
      Q = SHE - GG * SH
      R = AN - SY + SYE
      PQ = P + Q
      GIPQ = GI * PQ
C
C        FIRST DERIVATIVES OF LOG-LIKELIHOOD
C
      DU = -AI * Q
      DA = -AIGI * PQ
      DG = -GI * (R - GIPQ)
      IF (MONIT .GT. 0) GNORM = SQRT(DU * DU + DA * DA + DG * DG)
C
C        DERIVATIVES OF P,Q,R
C
      PU = -AI * SHE
      PA = GI * PU + AIGI * SE
      QU = GG * AI * (SHHE + G * SHH)
      RU = AI * (SH - SHE + SYHE)
      RA = GI * RU - AIGI * (AN - SE + SYE)
      RG = GI * (SY - SYE + SYYE - A * RA)
      QA = AI * Q + GI * (PU + QU)
      PQG = GIPQ + A * (RA - GI * (PA + QA))
C
C         MINUS SECOND DERIVATIVE OF LOG-LIKELIHOOD (HESSIAN MATRIX)
C
      DUU = AI * QU
      DUA = AIGI * (PU + QU)
      DAA = -AIGI * (AI * PQ - PA - QA)
      DUG = GI * (RU - GI * (PU + QU))
      DAG = -AIGI * (GIPQ - PQG)
      DGG = GI * (RG - GI * (PQG + R - GIPQ - GIPQ))
C
C         INVERT HESSIAN MATRIX
C
      DO 95 KK = 1, 3
        IF (DUU .LE. ZERO) GO TO 100
        D = ONE / DUU
        TEMP1 = -DUA * D
        IF (KK .GT. 2) TEMP1 = -TEMP1
        TEMP2 = -DUG * D
        IF (KK .GT. 1) TEMP2 = -TEMP2
        DUU = DAA + TEMP1 * DUA
        DUA = DAG + TEMP1 * DUG
        DAA = DGG + TEMP2 * DUG
        DUG = TEMP1
        DAG = TEMP2
        DGG = D
   95 CONTINUE
C
C        CALCULATE STEPLENGTHS
C
      ITYPE = 1
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI1, F, GNORM
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      DELU = DUU * DU + DUA * DA + DUG * DG
      DELA = DUA * DU + DAA * DA + DAG * DG
      DELG = DUG * DU + DAG * DA + DGG * DG
      RATIO = DMAX1(ABS(DELU) / (STEPU * A), ABS(DELA) / (STEPA * A),
     *  ABS(DELG) / STEPG)
      IF (RATIO .LT. ONE) GOTO 110
      RATIO = ONE / RATIO
      DELU = DELU * RATIO
      DELA = DELA * RATIO
      DELG = DELG * RATIO
      GOTO 110
C
C        HESSIAN IS NOT POSITIVE DEFINITE - MAKE A LARGE STEP IN THE
C        DIRECTION OF STEEPEST ASCENT
C
  100 ITYPE = 2
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI2, F, GNORM
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      D = ABS(VLNEG)
      TEMP1 = D
      IF (DU .NE. ZERO) TEMP1 = STEPU * A / ABS(DU)
      TEMP2 = D
      IF (DA .NE. ZERO) TEMP2 = STEPA * A / ABS(DA)
      Z = D
      IF (DG .NE. ZERO) Z = STEPG / ABS(DG)
      RATIO = MIN(TEMP1, TEMP2, Z)
      DELU = RATIO * DU
      DELA = RATIO * DA
      DELG = RATIO * DG
C
C        ADJUST PARAMETERS
C
  110 U = U + DELU
      A = A + DELA
      G = G + DELG
C
C        TEST FOR FEASIBILITY
C
      IF (A .GT. F * (XMIN - U) .AND. A .GT. G * (XMAX - U) .AND. G .NE.
     *  ZERO) GOTO 130
      DO 120 NSR = 1, MAXSR
        IF (MONIT .GT. 0) THEN
          WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI4
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
        U = U - DELU
        A = A - DELA
        G = G - DELG
        DELU = SRF * DELU
        DELA = SRF * DELA
        DELG = SRF * DELG
        U = U + DELU
        A = A + DELA
        G = G + DELG
        IF (A .GT. G * (XMIN - U) .AND. A .GT. G * (XMAX - Y) .AND. 
     *     G .NE. ZERO) GOTO 140
  120 CONTINUE
      GOTO 80
C
C        TEST FOR CONVERGENCE
C
  130 IF (ABS(DELU) .GT. ACCU * A) GOTO 140
      IF (ABS(DELA) .GT. ACCA * A) GOTO 140
      IF (ABS(DELG) .GT. ACCG) GOTO 140
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, NEVAL, U, A, G, ACTI9
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      VCOV(1) = DUU
      VCOV(2) = DUA
      VCOV(3) = DAA
      VCOV(4) = DUG
      VCOV(5) = DAG
      VCOV(6) = DGG
      GOTO 160
C
C        END OF MAIN LOOP
C
  140 CONTINUE
C
C        ITERATIONS NOT CONVERGED - SET FAULT FLAG
C
      IFAULT = 2
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) MAXIT, NEVAL, U, A, G, ACTI8
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      GOTO 160
  150 IFAULT = 3
      IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6010) NITER, MAXEV, U, A, G, ACTI7
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C
C        ITERATION FINISHED -COPY RESULTS INTO ARRAY PARA
C
  160 IF (MONIT .GT. 0) THEN
        WRITE(ICOUT, 6020)
        CALL DPWRST('XXX','BUG ')
      ENDIF
 6020 FORMAT('0')
C
      PARA(1) = U
      PARA(2) = A
      PARA(3) = G
      RETURN
C
  170 DO 180 I = 1, 3
  180 PARA(I) = ZERO
      RETURN
C
      END
      SUBROUTINE MMXCDF(X,BETA,GAMMA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MINIMAX DISTRIBUTION
C              WITH SHAPE PARAMETERS BETA AND GAMMA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C
C                 f(X;GAMMA,BETA) = BETA*GAMMA*X**(BETA-1)*
C                                   (1-X**BETA)**(GAMMA-1)
C                                   0 < X < 1; GAMMA, BETA > 0
C
C              THE CUMULATIVE DISTRIBUTION IS COMPUTED BY
C              NUMERICALLY INTEGRATING THE PDF FUNCTION.
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF THE
C                                FIRST SHAPE PARAMETER.
C                     --GAMMA  = THE DOUBLE PRECISION VALUE OF THE
C                                SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE MINIMAX DISTRIBUTION
C             WITH SHAPE PARAMETERS BETA AND GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DQAGI.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION JANUARY--2008.1
C     ORIGINAL VERSION--JANUARY   2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      INTEGER LIMIT
      INTEGER LENW
      PARAMETER(LIMIT=200)
      PARAMETER(LENW=4*LIMIT)
      INTEGER INF
      INTEGER NEVAL
      INTEGER IER
      INTEGER LAST
      INTEGER IWORK(LIMIT)
      DOUBLE PRECISION WORK(LENW)
C
      DOUBLE PRECISION MMXFUN
      EXTERNAL MMXFUN
C
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DGAMMA
      COMMON/MMXCOM/DBETA,DGAMMA
C
C---------------------------------------------------------------------
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      CDF=0.0D0
      IF(X.LE.0.0)GOTO9000
      IF(X.GE.1.0)THEN
        CDF=1.0D0
        GOTO9000
      ENDIF
C
      IF(BETA.LE.0.0D0)THEN
        WRITE(ICOUT,201)
  201   FORMAT('***** ERROR--THE SECOND ARGUMENT TO MMXCDF IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)BETA
  102   FORMAT('      THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA.LE.0.0D0)THEN
        WRITE(ICOUT,301)
  301   FORMAT('***** ERROR--THE THIRD ARGUMENT TO MMXCDF IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      INF=+1
      EPSABS=1.0D-7
      EPSREL=1.0D-7
      IER=0
      IKEY=3
      CDF=0.0D0
C
      DA=1.0D-7
      DX=DBLE(X)
      DBETA=BETA
      DGAMMA=GAMMA
C
      CALL DQAG(MMXFUN,DA,DX,EPSABS,EPSREL,IKEY,DCDF,ABSERR,NEVAL,
     1          IER,LIMIT,LENW,LAST,IWORK,WORK)
      CDF=REAL(DCDF)
C
      IF(IER.EQ.1)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      MAXIMUM NUMBER OF SUBDIVISIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ROUNDOFF ERROR PREVENTS REQUESTED TOLERANCE ',
     1         'FROM BEING ACHIEVED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      BAD INTEGRAND BEHAVIOUR DETECTED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,141)
  141   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      INTEGRATION DID NOT CONVERGE.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,151)
  151   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,153)
  153   FORMAT('      THE INTEGRATION IS PROBABLY DIVERGENT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IER.EQ.6)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,161)
  161   FORMAT('***** ERROR FROM MMXCDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,163)
  163   FORMAT('      INVALID INPUT TO THE INTEGRATION ROUTINE.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION MMXFUN(DX)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MINIMAX DISTRIBUTION
C              WITH SHAPE PARAMETERS GAMMA AND BETA.
C
C              THE MINIMAX PROBABILITY DENSITY FUNCTION IS:
C
C                  f(X;GAMMA,BETA) = BETA*GAMMA*X**(BETA-1)*
C                                    (1-X**BETA)**(GAMMA-1)
C                                    0 < X < 1; GAMMA, BETA > 0
C
C              IDENTICAL TO MMXPDF,
C              BUT DEFINE AS FUNCTION TO BE USED FOR INTEGRATION
C              CODE CALLED BY MMXCDF.
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--MMXFUN  = THE DOUBLE PRECISION PROBABILITY
C                                 DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE MINIMAX DISTRIBUTION
C             WITH SHAPE PARAMETERS GAMMA AND BETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP, LOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     VERSION NUMBER--2008/1
C     ORIGINAL VERSION--JANUARY   2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      COMMON/MMXCOM/BETA,GAMMA
C
C---------------------------------------------------------------------
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      TERM1=DLOG(GAMMA) + DLOG(BETA)
      TERM2=(BETA-1.0D0)*DLOG(X)
      TERM3=(GAMMA-1.0D0)*DLOG(1.0D0 - X**BETA)
      TERM4=TERM1+TERM2+TERM3
      PDF=DEXP(TERM4)
C
 9000 CONTINUE
      MMXFUN=PDF
C
      RETURN
      END
      SUBROUTINE MMXPDF(X,BETA,GAMMA,PDF)
C
C     NOTE--THE MINIMAX PROBABILITY DENSITY FUNCTION IS:
C
C           f(X;GAMMA,BETA) = BETA*GAMMA*X**(BETA-1)*
C                             (1-X**BETA)**(GAMMA-1)
C                             0 < X < 1; GAMMA, BETA > 0
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C     VERSION NUMBER--2008/1
C     ORIGINAL VERSION--JANUARY   2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      PDF=0.0D0
C
      IF(X.LE.0.0D0 .OR. X.GE.1.0D0)THEN
        WRITE(ICOUT,101)
  101   FORMAT('***** ERROR--THE FIRST ARGUMENT TO MMXPDF IS ',
     1         'OUTSIDE THE (0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)X
  102   FORMAT('      THE VALUE OF THE ARGUMENT IS ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(BETA.LE.0.0D0)THEN
        WRITE(ICOUT,201)
  201   FORMAT('***** ERROR--THE SECOND ARGUMENT TO MMXPDF IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)BETA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA.LE.0.0D0)THEN
        WRITE(ICOUT,301)
  301   FORMAT('***** ERROR--THE THIRD ARGUMENT TO MMXPDF IS ',
     1         'NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      TERM1=DLOG(GAMMA) + DLOG(BETA)
      TERM2=(BETA-1.0D0)*DLOG(X)
      TERM3=(GAMMA-1.0D0)*DLOG(1.0D0 - X**BETA)
      TERM4=TERM1+TERM2+TERM3
      PDF=DEXP(TERM4)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MOM(G, D, A, FAULT)
C
C        ALGORITHM AS 99.3  APPL. STATIST. (1976) VOL.25, P.180
C
C        EVALUATES FIRST SIX MOMENTS OF A JOHNSON
C        SB DISTRIBUTION, USING GOODWIN METHOD
C
      REAL A(6), B(6), C(6), G, D, ZZ, VV, RTTWO, RRTPI, W, E, R,
     $  H, T, U, Y, X, V, F, Z, S, P, Q, AA, AB, EXPA, EXPB,
     $  ZERO, QUART, HALF, P75, ONE, TWO, THREE, ZABS, ZEXP
      LOGICAL L, FAULT
C
      DATA ZZ, VV, LIMIT /1.0E-5, 1.0E-8, 500/
C
C        RTTWO IS SQRT(2.0)
C        RRTPI IS RECIPROCAL OF SQRT(PI)
C        EXPA IS A VALUE SUCH THAT EXP(EXPA) DOES NOT QUITE
C          CAUSE OVERFLOW
C        EXPB IS A VALUE SUCH THAT 1.0 + EXP(-EXPB) MAY BE
C          TAKEN TO BE 1.0
C
      DATA     RTTWO,        RRTPI, EXPA, EXPB
     $  /1.414213562, 0.5641895835, 80.0, 23.7/
      DATA ZERO, QUART, HALF,  P75, ONE, TWO, THREE
     $     /0.0,  0.25,  0.5, 0.75, 1.0, 2.0,   3.0/
C
      ZABS(X) = ABS(X)
      ZEXP(X) = EXP(X)
C
      FAULT = .FALSE.
      DO 10 I = 1, 6
   10 C(I) = ZERO
      W = G / D
C
C        TRIAL VALUE OF H
C
      IF (W .GT. EXPA) GOTO 140
      E = ZEXP(W) + ONE
      R = RTTWO / D
      H = P75
      IF (D .LT. THREE) H = QUART * D
      K = 1
      GOTO 40
C
C        START OF OUTER LOOP
C
   20 K = K + 1
      IF (K .GT. LIMIT) GOTO 140
      DO 30 I = 1, 6
   30 C(I) = A(I)
C
C        NO CONVERGENCE YET - TRY SMALLER H
C
      H = HALF * H
   40 T = W
      U = T
      Y = H * H
      X = TWO * Y
      A(1) = ONE / E
      DO 50 I = 2, 6
   50 A(I) = A(I - 1) / E
      V = Y
      F = R * H
      M = 0
C
C        START OF INNER LOOP
C        TO EVALUATE INFINITE SERIES
C
   60 M = M + 1
      IF (M .GT. LIMIT) GOTO 140
      DO 70 I = 1, 6
   70 B(I) = A(I)
      U = U - F
      Z = ONE
      IF (U .GT. -EXPB) Z = ZEXP(U) + Z
      T = T + F
      L = T .GT. EXPB
      IF (.NOT. L) S = ZEXP(T) + ONE
      P = ZEXP(-V)
      Q = P
      DO 90 I = 1, 6
      AA = A(I)
      P = P / Z
      AB = AA
      AA = AA + P
      IF (AA .EQ. AB) GOTO 100
      IF (L) GOTO 80
      Q = Q / S
      AB = AA
      AA = AA + Q
      L = AA .EQ. AB
   80 A(I) = AA
   90 CONTINUE
  100 Y = Y + X
      V = V + Y
      DO 110 I = 1, 6
      IF (A(I) .EQ. ZERO) GOTO 140
      IF (ZABS((A(I) - B(I)) / A(I)) .GT. VV) GOTO 60
  110 CONTINUE
C
C        END OF INNER LOOP
C
      V = RRTPI * H
      DO 120 I = 1, 6
  120 A(I) = V * A(I)
      DO 130 I = 1, 6
      IF (A(I) .EQ. ZERO) GOTO 140
      IF (ZABS((A(I) - C(I)) / A(I)) .GT. ZZ) GOTO 20
  130 CONTINUE
C
C        END OF OUTER LOOP
C
      RETURN
  140 FAULT =.TRUE.
      RETURN
      END
      SUBROUTINE MOMENT(X, Y, N, R, W)
C
C        ALGORITHM AS 258.3  APPL.STATIST. (1990), VOL.39, NO.3
C
C        For k=0,...,n,  computes the integral from x to
C        infinity of the quantity
C
C                 R(k+1) = ( t - y )**k z(t) dt,
C            where
C                 z(t) = 1/sqrt(2 pi) exp( -t**2 / 2 ) .
C
      INTEGER N
      DOUBLE PRECISION X, Y, R( * ), W( * )
      INTEGER I, K
      DOUBLE PRECISION ALNORM
      DOUBLE PRECISION XMY, SQR2PI, FACT(19)
      EXTERNAL ALNORM
      DATA SQR2PI / 2.506628274631000502415765D0 /
      DATA FACT / 2 * 1.D0, 2.D0, 6.D0, 24.D0, 120.D0, 720.D0, 5040.D0,
     *     40320.D0, 362880.D0, 3628800.D0, 39916800.D0, 479001600.D0,
     *     6227020800.D0, 87178291200.D0, 1307674368000.D0,
     *     20922789888000.D0, 355687428096000.D0, 6402373705728000.D0 /
C
C        Compute first term of R.
C
      W(1) = EXP(-X * X / 2.0) / SQR2PI
      W(2) = ALNORM(-X, .FALSE.)
      R(1) = W(2)
      IF (N .GT. 0) THEN
         DO 10 I = 1, N
            W(I + 2) = (W(I) - X * W(I + 1)) / I
            R(I + 1) = W(I + 2) * FACT(I + 1)
   10    CONTINUE
C
C        If X=Y, then R is already computed.
C
         IF (X .NE. Y) THEN
C
C        Compute R.
C
            DO 30 K = 0, N
               R(K + 1) = W(2) / FACT(K + 1)
               XMY = X - Y
               DO 20 I = 1, K
                  R(K + 1) = R(K + 1) * XMY + W(I + 2) / FACT(K - I + 1)
   20          CONTINUE
               R(K + 1) = R(K + 1) * FACT(K + 1)
   30       CONTINUE
         END IF
      END IF
      RETURN
      END
      SUBROUTINE MOVSTA(Y1,Y2,Y3,N,NUMV,ICASS7,MAXNXT,
     1                  ISEED,IQUAME,IQUASE,PSTAMV,
     1                  IMOVEP,IMOVDI,IFILT,
     1                  TEMP1,TEMP2,TEMP3,
     1                  ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                  DTEMP1,DTEMP2,DTEMP3,
     1                  YOUT,NOUT,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--COMPUTE A "MOVING" STATISTIC.  ALTHOUGH THIS IS TYPICALLY
C              USED FOR A LOCATION STATISTIC, IN CAN BE USED FOR ANY
C              SUPPORTED STATISTIC.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/10
C     ORIGINAL VERSION--OCTOBER     2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASCT
      CHARACTER*4 ICASC2
      CHARACTER*4 ICASS7
      CHARACTER*4 IQUAME
      CHARACTER*4 IQUASE
      CHARACTER*4 IMOVDI
      CHARACTER*4 IMOVEP
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION Y3(*)
      DIMENSION YOUT(*)
C
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      INTEGER ITEMP1(*)
      INTEGER ITEMP2(*)
      INTEGER ITEMP3(*)
      INTEGER ITEMP4(*)
      INTEGER ITEMP5(*)
      INTEGER ITEMP6(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION DTEMP2(*)
      DOUBLE PRECISION DTEMP3(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='MOVS'
      ISUBN2='TA  '
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'VSTA')THEN
        WRITE(ICOUT,70)
   70   FORMAT('AT THE BEGINNING OF MOVSTA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,71)ICASCT,ICASC2,ICASS7,IMOVDI,IMOVEP
   71   FORMAT('ICASCT,ICASC2,ICASS7,IMOVDI,IMOVEP = ',
     1         4(A4,2X),A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,72)N,IFILT
   72   FORMAT('N,IFILT = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO75I=1,N
          WRITE(ICOUT,73)I,Y1(I),Y2(I),Y3(I)
   73     FORMAT('I,Y1(I),Y2(I),Y3(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
   75   CONTINUE
      ENDIF
C
      IF(IFILT.LT.1)THEN
        IFILT=3
      ENDIF
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.IFILT)THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,31)
   31   FORMAT('***** ERROR IN MOVING <STAT> COMMAND--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,32)
   32   FORMAT('      THE NUMBER OF OBSERVATIONS IS LESS THAN THE ',
     1         'FILTER WIDTH.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,34)N
   34   FORMAT('      THE NUMBER OF OBSERVATIONS = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,36)IFILT
   36   FORMAT('      THE FILTER WIDTH           = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 1--                                        **
C               **  CASE 1: DIRECTION = CENTER                      **
C               ******************************************************
C
      NOUT=0
C
      IF(IMOVEP.EQ.'SYMM')THEN
        IF(IMOVDI.EQ.'LEFT')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,111)
  111     FORMAT('      SYMMETRIC END POINT OPTION NOT SUPPORTED ',
     1           '"LEFT" DIRECTION.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(IMOVDI.EQ.'RIGH')THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,31)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,121)
  121     FORMAT('      SYMMETRIC END POINT OPTION NOT SUPPORTED ',
     1           '"RIGHT" DIRECTION.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
      ENDIF
C
      IF(IMOVDI.EQ.'CENT')THEN
        IBELOW=IFILT/2
        IABOVE=IFILT/2
      ELSEIF(IMOVDI.EQ.'LEFT')THEN
        IBELOW=0
        IABOVE=IFILT-1
      ELSEIF(IMOVDI.EQ.'RIGH')THEN
        IBELOW=IFILT-1
        IABOVE=0
      ENDIF
C
      IF(IMOVEP.EQ.'SKIP')THEN
        DO1010I=1,N
          NSTRT=I-IBELOW
          IF(NSTRT.LT.1)GOTO1010
          NSTOP=I+IABOVE
          IF(NSTOP.GT.N)GOTO1010
          NTEMP=NSTOP-NSTRT+1
          CALL CMPSTA(Y1(NSTRT),Y2(NSTRT),Y3(NSTRT),TEMP1,TEMP2,TEMP3,
     1                MAXNXT,NTEMP,NTEMP,NTEMP,NUMV,ICASS7,
     1                ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                DTEMP1,DTEMP2,DTEMP3,
CCCCC1                IQUAME,IQUASE,PSTAMV,
     1                STAT,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          NOUT=NOUT+1
          YOUT(NOUT)=STAT
 1010   CONTINUE
      ELSEIF(IMOVEP.EQ.'SYMM')THEN
        DO1020I=1,N
          NSTRT=I-IBELOW
          IF(NSTRT.LT.1)NSTRT=1
          IBELOT=I-NSTRT
          NSTOP=I+IABOVE
          IF(NSTOP.GT.N)NSTOP=N
          IABOVT=NSTOP-I
          ITEMP=MIN(IABOVT,IBELOT)
          NSTRT=I-ITEMP
          NSTOP=I+ITEMP
          NTEMP=NSTOP-NSTRT+1
          CALL CMPSTA(Y1(NSTRT),Y2(NSTRT),Y3(NSTRT),TEMP1,TEMP2,TEMP3,
     1                MAXNXT,NTEMP,NTEMP,NTEMP,NUMV,ICASS7,
     1                ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                DTEMP1,DTEMP2,DTEMP3,
CCCCC1                IQUAME,IQUASE,PSTAMV,
     1                STAT,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          NOUT=NOUT+1
          YOUT(NOUT)=STAT
 1020   CONTINUE
      ELSEIF(IMOVEP.EQ.'PART')THEN
        DO1030I=1,N
          NSTRT=I-IBELOW
          IF(NSTRT.LT.1)NSTRT=1
          NSTOP=I+IABOVE
          IF(NSTOP.GT.N)NSTOP=N
          NTEMP=NSTOP-NSTRT+1
          CALL CMPSTA(Y1(NSTRT),Y2(NSTRT),Y3(NSTRT),TEMP1,TEMP2,TEMP3,
     1                MAXNXT,NTEMP,NTEMP,NTEMP,NUMV,ICASS7,
     1                ISEED,ITEMP1,ITEMP2,ITEMP3,ITEMP4,ITEMP5,ITEMP6,
     1                DTEMP1,DTEMP2,DTEMP3,
CCCCC1                IQUAME,IQUASE,PSTAMV,
     1                STAT,
     1                ISUBRO,IBUGA3,IERROR)
          IF(IERROR.EQ.'YES')GOTO9000
          NOUT=NOUT+1
          YOUT(NOUT)=STAT
 1030   CONTINUE
      ENDIF
C
C               ******************
C               **   STEP 90--  **
C               **   EXIT       **
C               ******************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'VSTA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF MOVSTA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)NOUT
 9013   FORMAT('NOUT = ',I8)
        CALL DPWRST('XXX','BUG ')
        IF(NOUT.GE.1)THEN
          DO9021I=1,NOUT
            WRITE(ICOUT,9023)I,YOUT(I)
 9023       FORMAT('I,YOUT(I) = ',I8,G15.7)
            CALL DPWRST('XXX','BUG ')
 9021     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      double precision function mpf(x, t, nlab, y)
      implicit double precision (a-h, o-z)
      dimension x(*), t(*)
c
c     -- Calculate the mean estimate
      wsum = 0.0d0
      xhat = 0.0d0
      do 10 i=1, nlab
         wght = 1.0d0/(t(i)+y)
         wsum = wsum +wght
         xhat = xhat +x(i)*wght
 10   continue
      xhat = xhat /wsum
c
c    -- Evaluate the function
      mpf = 0.0d0
      do 20 i=1, nlab
         mpf = mpf + 1.0d0/(t(i) +y) *(x(i) -xhat)**2
 20   continue
      return
      end
      double precision function mpfder(x, t, nlab, y, wsum)
      implicit double precision (a-h, o-z)
      dimension x(*), t(*)
c
c     -- Calculate the mean estimate
      wsum = 0.0d0
      xhat = 0.0d0
      do 10 i=1, nlab
         wght = 1.0d0/(t(i)+y)
         wsum = wsum + wght
         xhat = xhat + x(i)*wght
 10   continue
      xhat = xhat /wsum
c
c    -- Evaluate the function
      mpfder = 0.0d0
      do 20 i=1, nlab
         mpfder = mpfder + 1.0d0/(t(i) +y)**2 *(x(i) -xhat)**2
 20   continue
      return
      end
      subroutine mpinit (dat, n, ieq2, nlab, x, t)
c
c  Initialization for Mandel-Paule estimation
c
c  Routine supplied by Mark Vangel: 10/2000
c
c  2/2005: Modification by Alan Heckert.  If a lab has a single
c          observation, the within lab variance is zero and
c          code below blows up.  As an alternative, check for
c          this case and set the resulting variance to the
c          maximum variance of all the labs.
c
      implicit double precision (a-h, o-z)
      real dat
      dimension dat(*), n(*), x(*), t(*)
c
c     -- Calculate batch means and variances of these means
      ntot   = 0
      timax=0.0
      do 10 i=1, nlab
        x(i) = 0.0d0
        if (ieq2 .eq. 1) then
           ntot  = ntot +n(1)
           ni    = n(1)
           n(i)  = ni
        else
           ntot  = ntot +n(i)
           ni = n(i)
        end if
        do 20 j=ntot-ni+1, ntot
          x(i) = x(i) + dat(j)
 20     continue
        x(i)   = x(i)/dble(ni)
        t(i)   = 0.0d0
        do 30 j=ntot-ni+1, ntot
           t (i) = t(i) +(dat(j)-x(i))**2
 30     continue
        if(ni .eq. 1)then
          t(i) = -1.0
        else
          t(i) = t(i) /dble(((ni-1)*ni))
          if(t(i).gt.timax)timax=t(i)
        endif
 10   continue
c
      do 40 i=1, nlab
        if (t(i) .le. 0.0) t(i)=timax
 40   continue
c
      Return
      end
      subroutine mpintl(nlab,n,x,t,xm,s2b,w,maxit,dlik,ibuga3,ierror)
c
c  --Mandel-Paule Interlab subroutine
c  --This subroutine is driver routine for generating maximum
c  --likelihood estimates
c  --Code provided by Mark Vangel (10/2000)
c  --Adapted to Dataplot by Alan Heckert
c
      implicit double precision (a-h, o-z)
      double precision mplglk, mpwmea, mps2bf
      dimension n(*), t(*), w(*), x(*)
      character*4 ibuga3
      character*4 ierror
      dimension q(3), xl(3)
C
      common /mpcom/ t0, t1
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
      do 5 i=1,3
        q(i)=0.0d0
        xl(i)=0.0d0
  5   continue
ccccc tol    = 1.d-12
      tol    = 1.d-18
      iter   = 0
      dlik   = mplglk (nlab, n, x, t, xm, s2b, w, ibuga3)
 10   continue
c
      if(ibuga3.eq.'ON')then
         WRITE(ICOUT,999)
  999    FORMAT(1X)
         CALL DPWRST('XXX','BUG ')
         WRITE(ICOUT,1001)ITER,S2B,XM,DLIK
 1001    FORMAT('ITER,S2B,XM,DLIK=',I8,3G15.7)
         CALL DPWRST('XXX','BUG ')
      endif
c
      dlt    = 0.0d0
      iter   = iter +1
      mltwgt = 0
      do 20 i=1, nlab
        a    = s2b  /(x(i) - xm)**2
        b    = t(i) /(x(i) - xm)**2
        ss   = dble(n(i)*(n(i)-1))*t(i)
        if (a .eq. 0.0d0) then
          w(i)  = dble(n(i))/((x(i)-xm)**2 +dble(n(i)-1)*t(i))
          q(1)  = w(i)
          nwght = 1
        else
          call mpweig(a, b, dble(n(i)-1), nwght, q, ibuga3, ierror)
          if(ierror.eq.'YES')return
        end if
        if (nwght .gt. 1) mltwgt = 1
        if (nwght .eq. 1) then
          wtmp = q(1)
          jwgt = 1
        else
          do 15 j=1,3
            xl(j) = dble(n(i))*log(q(j)) -
     $      q(j)*(1.0d0/a +dble(n(i)-1)*t(i)/(1.0d0-q(j))) -
     $      dble(n(i)-1)*log(1.0d0-q(j))
 15       continue
          if (xl(2) .gt. xl(1) .and. xl(2) .gt. xl(3)) then
            wtmp = q(2)
            jwgt = 2
          else if (xl(3) .gt. xl(1) .and. xl(3) .gt. xl(2)) then
            wtmp = q(3)
            jwgt = 3
          else 
            wtmp = q(1)
            jwgt = 1
          end if
        end if
        dtmp = abs(wtmp - w(i))
        if (dtmp .gt. dlt) dlt = dtmp
        w(i) = wtmp
        if(ibuga3.eq.'ON')then
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1011)XM,S2B,I,NWGHT,JWGT
 1011     FORMAT('XM,S2B,I,NWGHT,JWGT=',2G15.7,3I8)
          CALL DPWRST('XXX','BUG ')
        endif
 20   continue
c
      dlik  = mplglk (nlab, n, x, t, xm, s2b, w, ibuga3)
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1021)iter,t0 +(t1-t0)*xm,(t1-t0)**2*s2b, dlik
 1021   FORMAT('ITER,T0+(T1-T0)*XM,(T1-T0**2*S2B,DLIK=',I8,3G16.8)
        CALL DPWRST('XXX','BUG ')
      ENDIF
      s2b   = mps2bf(x, w, xm, nlab)
      xm    = mpwmea(x, w, nlab, ibuga3)
      if (dlt .gt. tol .and. iter .lt. maxit) go to 10
      if (iter .gt. maxit) then
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1041)
 1041   FORMAT('***** ERROR FROM MPINTL:: CONVERGENCE FAILED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      return
      end
      double precision function mplglk 
     $    (nlab, n, x, t, xm, s2b, w, ibuga3)
c
c  --log-likelihood function used by CONSESUS MEANS code
c  --provided by Mark Vangel (10/2000)
c 
      implicit double precision (a-h, o-z)
      character*4 ibuga3
      dimension n(*), x(*), t(*), w(*)
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
      mplglk = 0.0d0
      if (s2b .gt. 0.0d0) then
        do 10 i=1, nlab
          prtlik = dble(n(i))*log(w(i)/s2b) - 
     $             (w(i)/s2b)*((x(i)-xm)**2 +
     $             dble(n(i)-1)*t(i)/(1.0d0-w(i))) -
     $             dble(n(i)-1)*log(1.0d0 - w(i))
          mplglk = mplglk + prtlik
          IF(IBUGA3.EQ.'ON')THEN
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,101)PRTLIK
 101   FORMAT('***** FROM MPLGLK (s2b > 0): PRTLIK = ',G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
 10     continue
      else
        do 20 i=1, nlab
          prtlik = -w(i) *((x(i)-xm)**2 + dble(n(i)-1)*t(i)) +
     $             dble(n(i))*log(w(i))
          mplglk = mplglk + prtlik
          IF(IBUGA3.EQ.'ON')THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,103)PRTLIK
 103   FORMAT('***** FROM MPLGLK (s2b <= 0): PRTLIK = ',G15.7)
          ENDIF
 20     continue
      end if
c
      return
      end
      subroutine mppoly(x, fx)
c
c --Compute cubic polynomial function for root finder in
c --Consensus Means code.
c --Code provided by Mark Vangel
c
      implicit double precision (a-h, o-z)
      double precision c(0:3)
      common /mpfnc/ c
c
      fx = c(0)+x*(c(1)+x*(c(2)+x*c(3)))
c
      return
      end
      subroutine mpprep (nlab, x, t, t0, t1)
c
c     Mark Vangel, NIST, Nov 1995
c
c     Added to Dataplot: 10/2000
c
c     Scale the sufficient statistics so that the
c     means are in [0,1].
c
      implicit double precision (a-h, o-z)
      dimension x(*), t(*)
c
      t0 = x(1)
      t1 = x(1)
      do 10 j=1, nlab
         if (x(j) .lt. t0) t0 = x(j)
         if (x(j) .gt. t1) t1 = x(j)
 10   continue
      do 20 j=1, nlab
         x(j) = (x(j)-t0)/(t1-t0)
         t(j) = t(j)/(t1-t0)**2
 20   continue
      return
      end
      double precision function mprhs (x, t, that, n, nlab)
      implicit double precision (a-h, o-z)
      dimension x(*), t(*), that(*), n(*)
      mprhs = 0.0d0
      do 10 i=1, nlab
         mprhs = mprhs + dble(n(i)-1) * (1.0d0 - t(i)/that(i)) + 1.0d0
 10   continue
      return
      end
      subroutine mproot
     $ (x, t, nlab, tol, rhs, root, maxit, niter, ier)
      implicit double precision (a-h, o-z)
      double precision mpf, mpfder
      dimension x(*), t(*)
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
c
c     -- If root is negative or nonexistent, set it to 
c        zero.
c
      y  = 0.0d0
      f0 = mpf(x, t, nlab, y)
      if (f0 .lt. rhs) then
         root = 0.0d0
         ier  = 1
         return
      end if
c
c    -- Loop until convergence
      niter = 0
 30   continue
         niter = niter +1
         fd = mpfder(x, t, nlab, y, wsum)
         ynew = y +(mpf(x, t, nlab, y)-rhs)/fd
         if (abs (ynew-y) .le. tol .and.
     $            niter   .le. maxit) then
            root = ynew
            ier  = 0
            return
         else if (niter .gt. maxit) then
            root = ynew
            WRITE(ICOUT,999)
  999       FORMAT(1X)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1001)
 1001       FORMAT('***** ERROR: FAILURE IN MPROOT: YNEW = ',G15.7)
            CALL DPWRST('XXX','BUG ')
            DO1010I=1,NLAB
            WRITE(ICOUT,1011)
 1011       FORMAT('      I,T(I) = ',I8,G15.7)
 1010       CONTINUE
            ier  = 2
            return
         else
           y = ynew
           go to 30
         end if
         return
      end
      double precision function mps2bf (x, w, xbar, nlab)
c
c  --Code for consensus mean
c  --Provided by Mark Vangel
c
      implicit double precision (a-h, o-z)
      dimension x(*), w(*)
      mps2bf = 0.0d0
      wsum   = 0.0d0
      do 10 i=1, nlab
         mps2bf = mps2bf + w(i)**2 *(x(i) -xbar)**2
         wsum   = wsum + w(i)
 10   continue
      if (wsum .ne. 0.0d0) then
         mps2bf = mps2bf /wsum
      else
         mps2bf = 0.0d0
      end if
      return
      end
      subroutine mpsub (nlab, n, x, t, xmp, s2bmp, imanpa, ibuga3)
c
c  Initialization for Mandel-Paule estimation
c
c  Routine supplied by Mark Vangel: 10/2000
c
      implicit double precision (a-h, o-z)
ccccc double precision mprhs
      double precision mpxbar
      dimension x(*), n(*), t(*)
      character*4 imanpa
      character*4 ibuga3
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
      maxit = 1000
ccccc tol   = 1.d-7
      tol   = 1.d-15
c
c    -- Initialize with Mandel-Paule
      s2b = 0.d0
CCCCC USE NLAB FOR MANDEL-PAULE, NLAB-1 FOR MODIFIED MANDEL-PAULE
      if(imanpa.eq.'MODI')then
        xrhs=dble(nlab)
      else
        xrhs=dble(nlab-1)
      endif
CCCCC xrhs = mprhs (x, t, t, n, nlab)
      call mproot
     $ (x, t, nlab, tol, xrhs, s2b, maxit, niter, ier)
      xmp  = mpxbar   (x, t, s2b, nlab)
      s2bmp  = s2b
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      IF(IBUGA3.NE.'ON')GOTO1099
      WRITE(ICOUT,1001)
 1001 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1011)
 1011 FORMAT('FROM ROUTINE MPSUB')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1021)XRHS,XMP,S2BMP
 1021 FORMAT('RHS, XMP, S2BMP = ',3G15.7)
      CALL DPWRST('XXX','BUG ')
 1099 CONTINUE
      return
      end
      double precision function mpwmea (x, w, nlab, ibuga3)
c
c --Compute a weighted mean for the consensus means code
c --provided by Mark Vangel.
c
      implicit double precision (a-h, o-z)
      dimension w(*), x(*)
      character*4 ibuga3
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
      dtemp = 0.0d0
      wsum  = 0.0d0
      do 10 i=1, nlab
         dtemp = dtemp + x(i)*w(i)
         wsum  = wsum  + w(i)
 10   continue
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        DO1010I=1,NLAB
          WRITE(ICOUT,1001)I,X(I),W(I)
 1001     FORMAT('***** MPWMEA: I,X(I),W(I)=',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 1010   CONTINUE
      ENDIF
      mpwmea = dtemp/wsum
      return
      end
      subroutine mpweig (a, b, gnu, nwght, w, ibuga3, ierror)
      implicit double precision (a-h, o-z)
c
c     Concensus Means Code
c     Mark Vangel, NIST, Oct. 1995
c
c         Find weight by solving cubic equation.
c
      character*4 ibuga3
      character*4 ierror
      real dwarf, precis
      double precision w(*)
      double precision c(0:3)
      common /mpfnc/ c
      external mppoly
C
C--------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT------------------------------------------------
C
c
      IERROR='NO'
      c(3)   = 1.0d0
      c(2)   = 1.0d0 - a
      c(1)   = gnu *(a+b)
      c(0)   = gnu *b
      precis = 1.e-14
      dwarf  = 1.e-14
      x0     = -1.0d0
      x1     =  0.0d0
      ndeg   = 11
      zero=0.0d0
c
      call mpzero(mppoly, x0, x1, ndeg, precis, dwarf, zero, ier)
      nwght  = 1
      w(1)   = zero + 1.0d0
      disc   = (1.0d0-a+zero)**2 +4.0d0*b*gnu/zero
      if (disc .gt. 0.0d0) then
            z1   = zero
            disc = sqrt(disc)
            z2   = (-(1.0d0-a+zero) +disc)/2.0d0
            z3   = (-(1.0d0-a+zero) -disc)/2.0d0
            if ((-1.0d0 .le. z2 .and. z2 .le. 0.0d0) .or.
     $         ((-1.0d0 .le. z3 .and. z3 .le. 0.0d0))) then
                nwght = 3
                w(2) = z2 +1.0d0
                w(3) = z3 +1.0d0
            end if
      end if
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1001)W(1),W(2),W(3)
 1001   FORMAT('FROM MPWEIG: W = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
      if (ier .ne. 0) then
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1011)IER
 1011   FORMAT('FROM MPWEIG: IER = ',I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1021)A,B,GNU
 1021   FORMAT('FROM MPWEIG: A,B,GNU = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1026)W(1),W(2),W(3)
 1026   FORMAT('FROM MPWEIG: W = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
      end if
      if (nwght .eq. 3) then
CCCCC   write(ICOUT,1031) W(1),W(2),W(3)
C1031   FORMAT('FROM MPWEIG (NWGHT=3): W = ',3G15.7)
CCCCC   CALL DPWRST('XXX','BUG ')
      endif
      return
      end
      double precision function mpxbar (x, t, s2b, nlab)
      implicit double precision (a-h, o-z)
      dimension x(*), t(*)
c
      mpxbar = 0.0d0
      wsum = 0.0d0
      do 10 i=1, nlab
         wi   = 1.0d0/(s2b+t(i))
         wsum = wsum + wi
         mpxbar = mpxbar + x(i)*wi
 10   continue
      mpxbar = mpxbar /wsum
c
      return
      end
      SUBROUTINE MPZERO(EVF,A,B,NDEG,PRECIS,DWARF,ZERO,IER)
C-----------------------------------------------------------------------
C
C   PURPOSE              - FIND A ZERO OF A FUNCTION WHICH CHANGES
C                            SIGN IN A GIVEN INTERVAL BY LARKIN'S
C                            METHOD OF RATIONAL INTERPOLATION.
C
C   PRECISION            - DOUBLE.
C
C   ARGUMENTS    EVF     - AN EXTERNAL SUBROUTINE EVF(X,FX) WITH
C                            DOUBLE PRECISION ARBUMENTS X,FX WHICH
C                            COMPUTES F(X) FOR ANY X IN THE INTERVAL
C                            (A,B) INCLUSIVE. (INPUT)
C                            EVF MUST APPEAR IN AN EXTERNAL STATEMENT
C                            IN THE CALLING PROGRAM.
C                A,B     - DOUBLE PRECISION BOUNDARY POINTS.
C                            (INPUT/OUTPUT)
C                          ON INPUT, F(A) AND F(B) SHOULD HAVE OPPOSITE
C                            SIGNS UNLESS ONE EQUALS 0.
C                          ON OUTPUT, BOTH A AND B ARE ALTERED BUT F(A)
C                            AND F(B) REMAIN OPPOSITELY SIGNED UNLESS
C                            ONE EQUALS 0. IF NEITHER F(A) NOR F(B)
C                            EQUALS 0, THEN
C                              ABS(A-B) .LE. 4*PRECIS*ABS(A)+2*DWARF.
C                NDEG    - MAXIMUM TOTAL DEGREE OF RATIONAL INTER-
C                            POLATION. (INPUT)
C                            IF NDEG.LT.2 THEN 2 IS USED IN PLACE OF
C                            NDEG. IF NDEG.GT.11 THEN 11 IS USED IN
C                            PLACE OF NDEG.
C                PRECIS  - REAL RELATIVE CONVERGENCE PARAMETER. (INPUT)
C                            PRECIS SHOULD BE AT LEAST MACHINE PRE-
C                            CISION, I.E. 1+PRECIS.GT.1 IN DOUBLE
C                            PRECISION ARITHMETIC.
C                DWARF   - REAL ABSOLUTE CONVERGENCE PARAMETER. (INPUT)
C                            DWARF SHOULD BE AT LEAST AS LARGE AS THE
C                            SMALLEST POSITIVE NORMALIZED REAL NUMBER
C                            REPRESENTABLE IN THE COMPUTER.
C                ZERO    - DOUBLE PRECISION APPROXIMATE ZERO OF F(X).
C                            (OUTPUT)
C                            ZERO EQUALS WHICHEVER OF OUTPUT A OR B HAS
C                            SMALLER F MAGNITUDE.
C                IER     - ERROR INDICATOR. (OUTPUT)
C                            NO ERROR: IER=0 .
C                            TERMINAL ERROR:
C                              IER=129 INDICATES THAT F HAS THE SAME
C                              SIGN ON INPUT A AND B.
C
C-----------------------------------------------------------------------
C
C                                 SPECIFICATIONS FOR ARGUMENTS.
C
      INTEGER NDEG,IER
      REAL PRECIS,DWARF
      DOUBLE PRECISION A,B,ZERO
C
C                                 SPECIFICATIONS FOR LOCAL VARIABLES.
C
      INTEGER MAXDEG,NN,N,NLAST,I,J
      REAL TOL,C,D,E,D0,D1
      DOUBLE PRECISION X(11),U(11),X0,F0,F1,F2,Z,FZ,H,HLAST,R,S,T
      DATA MAXDEG/11/
C
C     REMARK:  IN THIS SUBROUTINE THE MAXIMUM ALLOWABLE DEGREE OF
C                RATIONAL INTERPOLATION HAS BEEN ARBITRARILY SET AT 11.
C                (SEE DESCRIPTION OF NDEG.) TO INCREASE THE MAXIMUM
C                ALLOWABLE DEGREE TO M:
C                  1. DIMENSION X AND U AT M (RATHER THAN 11),
C                  2. INITIALIZE MAXDEG AT M (RATHER THAN 11),
C                IN THE ABOVE LINES OF CODE.
C
C                                 FIRST EXECUTABLE STATEMENT.
C
      X0 = A
      X(1) = B
      CALL EVF(A,F0)
      CALL EVF(B,F1)
      IF (F0.EQ.0. .OR. F1.EQ.0.) GO TO 120
      IF (F0.GT.0. .AND. F1.GT.0.) GO TO 140
      IF (F0.LT.0. .AND. F1.LT.0.) GO TO 140
      NN = NDEG
      IF (NN.LT.2) NN = 2
      IF (NN.GT.MAXDEG) NN = MAXDEG
      R = X(1) - X0
      E = 0.
      F2 = F0
C
C                                 MAIN LOOP.
C
   10 CONTINUE
      TOL = 2.*PRECIS*DABS(X0) + DWARF
      IF (DABS(R).LE.2.*TOL) GO TO 120
      U(1) = R* (F0/ (F0-F1))
      IF (E.LT.TOL .OR. DABS(F0).GE.DABS(F2)) GO TO 60
C
C                                 INTERPOLATE.
C
      H = U(1)
      HLAST = H
      NLAST = 1
      S = R
      DO 30 I = 2,N
          S = S + U(I) - U(I-1)
          T = X(I) - X0 - S
          IF (T.EQ.0.) GO TO 40
          U(I) = H* (S/T)
          H = H + U(I)
          D1 = DABS(U(I))
          IF (I.EQ.2) GO TO 20
          IF (D1.GE.D0) GO TO 40
          T = H/R
          IF (T.LE.0. .OR. T.GE.1.) GO TO 40
   20     HLAST = H
          NLAST = I
          D0 = D1
   30 CONTINUE
   40 Z = X0 + HLAST
      D0 = DABS(HLAST)
      D1 = DABS(Z-X(1))
      C = E
      E = D
      D = AMIN1(D0,D1)
      IF (D.GE..5*C) GO TO 60
      IF (D.GE.TOL) GO TO 70
      IF (D0.LT.TOL) GO TO 50
      IF (R.LT.0.) TOL = -TOL
      Z = X(1) - TOL
      GO TO 70

   50 IF (R.LT.0.) TOL = -TOL
      Z = X0 + TOL
      GO TO 70
C
C                                 END INTERPOLATE.
C
   60 CONTINUE
C
C                                 BISECT.
C
      H = .5*R
      Z = X0 + H
      NLAST = 1
      D = DABS(H)
      E = D
C
C                                 END BISECT.
C
   70 CONTINUE
C
C                                 EVALUATE AND ORGANIZE.
C
      CALL EVF(Z,FZ)
      IF (FZ.NE.0.) GO TO 80
      X0 = Z
      F0 = FZ
      GO TO 120

   80 N = MIN0(NLAST+1,NN)
      J = N + 1
      DO 90 I = 2,N
          J = J - 1
          X(J) = X(J-1)
          U(J) = U(J-1)
   90 CONTINUE
      IF (FZ.GT.0. .AND. F1.GT.0.) GO TO 100
      IF (FZ.LT.0. .AND. F1.LT.0.) GO TO 100
      X(2) = X0
      F2 = F0
      U(2) = U(2) - R
      GO TO 110

  100 X(1) = X0
      F2 = F1
      F1 = F0
  110 CONTINUE
      X0 = Z
      F0 = FZ
      R = X(1) - X0
C
C                                 END EVALUATE AND ORGANIZE.
C
      GO TO 10
C
C                                 END MAIN LOOP.
C
  120 CONTINUE
C
C                                 RETURN WITHOUT ERROR.
C
      IER = 0
      A = X0
      B = X(1)
      IF (DABS(F1).LT.DABS(F0)) GO TO 130
      ZERO = A
      RETURN

  130 ZERO = B
      RETURN

  140 CONTINUE
C
C                                 RETURN WITH ERROR.
C
      IER = 129
      RETURN
      END
        INTEGER FUNCTION MSTA1(X,MP)
C
C       ===================================================
C       Purpose: Determine the starting point for backward  
C                recurrence such that the magnitude of    
C                Jn(x) at that point is about 10^(-MP)
C       Input :  x     --- Argument of Jn(x)
C                MP    --- Value of magnitude
C       Output:  MSTA1 --- Starting point   
C       ===================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        A0=DABS(X)
        N0=INT(1.1*A0)+1
        F0=ENVJ(N0,A0)-MP
        N1=N0+5
        F1=ENVJ(N1,A0)-MP
        DO 10 IT=1,20             
           NN=N1-(N1-N0)/(1.0D0-F0/F1)                  
           F=ENVJ(NN,A0)-MP
           IF(ABS(NN-N1).LT.1) GO TO 20
           N0=N1
           F0=F1
           N1=NN
 10        F1=F
 20     MSTA1=NN
        RETURN
        END
      INTEGER FUNCTION MSTA2(X,N,MP)
C
C       ===================================================
C       Purpose: Determine the starting point for backward
C                recurrence such that all Jn(x) has MP
C                significant digits
C       Input :  x  --- Argument of Jn(x)
C                n  --- Order of Jn(x)
C                MP --- Significant digit
C       Output:  MSTA2 --- Starting point
C       ===================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        A0=DABS(X)
        HMP=0.5D0*MP
        EJN=ENVJ(N,A0)
        IF (EJN.LE.HMP) THEN
           OBJ=MP
           N0=INT(1.1*A0)
        ELSE
           OBJ=HMP+EJN
           N0=N
        ENDIF
        F0=ENVJ(N0,A0)-OBJ
        N1=N0+5
        F1=ENVJ(N1,A0)-OBJ
        DO 10 IT=1,20
           NN=N1-(N1-N0)/(1.0D0-F0/F1)
           F=ENVJ(NN,A0)-OBJ
           IF (ABS(NN-N1).LT.1) GO TO 20
           N0=N1
           F0=F1
           N1=NN
10         F1=F
20      MSTA2=NN+10
        RETURN
        END
      SUBROUTINE MULRAN(n,p,ncat,ix,iseed,ierror)
C**********************************************************************
C
C            SUBROUTINE GENMUL( N, P, NCAT, IX )
C     GENerate an observation from the MULtinomial distribution
C
C
C                              Arguments
C
C
C     N --> Number of events that will be classified into one of
C           the categories 1..NCAT
C                         INTEGER N
C
C     P --> Vector of probabilities.  P(i) is the probability that
C           an event will be classified into category i.  Thus, P(i)
C           must be [0,1]. Only the first NCAT-1 P(i) must be defined
C           since P(NCAT) is 1.0 minus the sum of the first
C           NCAT-1 P(i).
C                         REAL P(NCAT-1)
C
C     NCAT --> Number of categories.  Length of P and IX.
C                         INTEGER NCAT
C
C     IX <-- Observation from multinomial distribution.  All IX(i)
C            will be nonnegative and their sum will be N.
C                         INTEGER IX(NCAT)
C
C
C                              Method
C
C
C     Algorithm from page 559 of
C
C     Devroye, Luc
C
C     Non-Uniform Random Variate Generation.  Springer-Verlag,
C     New York, 1986.
C
C     DATAPLOT NOTE: CODE FROM RANLIB LIBRARY OF BROWN AND LAVATO.
C                    Department of Biomathematics, Box 237
C                    The University of Texas, M.D. Anderson Cancer Center
C                    1515 Holcombe Boulevard
C                    Houston, TX      77030
C
C                    FOLLOWING CHANGES:
C                    1) RENAMED FROM GENMUL TO MULRAN
C                    2) REPLACE THEIR IGBNM ROUTINE WITH DATAPLOT BINRAN
C                    3) I/O CHANGED AND ERROR FLAG ADDED.
C
C**********************************************************************
C     .. Scalar Arguments ..
      INTEGER n,ncat
C     ..
C     .. Array Arguments ..
      REAL p(*)
      INTEGER ix(*)
C     ..
C     .. Local Scalars ..
      REAL prob,ptot,sum
      INTEGER i,icat,ntot
C     ..
C     .. External Functions ..
CCCCC INTEGER ignbin
CCCCC EXTERNAL ignbin
C     ..
C     .. Intrinsic Functions ..
      INTRINSIC abs
C     ..
C     .. Executable Statements ..
C
C---------------------------------------------------------------------
C
      REAL XTEMP(1)
C
      CHARACTER*4 IERROR
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C     Check Arguments
C
      IF (n.LT.0) THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1001)N
 1001   FORMAT('***** ERROR IN MULRAN: N IS NOT POSITIVE, VALUE = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9999
      ENDIF
      IF (ncat.LE.1) THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1003)NCAT
 1003   FORMAT('***** ERROR IN MULRAN: NUMBER OF CATEGORIES IS <= 1, ',
     1         'VALUE = ',I8)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9999
      ENDIF
      ptot = 0.0
      DO 10,i = 1,ncat - 1
          IF (p(i).LT.0.0 .or. p(i).gt.1.0) THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1011)i,p(i)
 1011   FORMAT('***** ERROR IN MULRAN: FOR CATEGORY ',I8,' P(I) IS ',
     1         'NOT IN THE INTERVAL (0,1).  THE VALUE = ',G15.7)
            CALL DPWRST('XXX','BUG ')
            IERROR='YES'
            GOTO9999
          ENDIF
          ptot = ptot + p(i)
   10 CONTINUE
      IF (ptot.GT.0.999999) THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1021)
 1021   FORMAT('***** ERROR IN MULRAN: SUM OF PROBABILITIES IS ',
     1         'GREATER THAN 1.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9999
      ENDIF
C
C     Initialize variables
C
      ntot = n
      sum = 1.0
      DO 20,i = 1,ncat
          ix(i) = 0
   20 CONTINUE

C     Generate the observation
      NPAR=1
      DO 30,icat = 1,ncat - 1
          prob = p(icat)/sum
CCCCC     ix(icat) = ignbin(ntot,prob)
          CALL BINRAN(NPAR,PROB,NTOT,ISEED,XTEMP)
          IX(ICAT) = INT(XTEMP(1)+0.1)
          ntot = ntot - ix(icat)
          IF (ntot.LE.0) goto9999
          sum = sum - p(icat)
   30 CONTINUE
      ix(ncat) = ntot
C
C     Finished
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE MUTCDF(X,BETA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MUTH DISTRIBUTION
C              WITH SHAPE PARAMETER BETA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL POSITIVE X,
C              AND HAS THE CUMULATIVE DISTRIBUTION FUNCTION
C
C              F(X;BETA) = 1 - EXP[-(1/BETA)*(EXP(BETA*X) - 1) + BETA*X]
C                          0 <= BETA <= 1; X > 0
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JANUARY   2008. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      CDF=0.0D0
      IF(X.LE.0.0D0)THEN
        CDF=0.0D0
        GOTO9000
      ELSEIF(BETA.LT.0.0D0 .OR. BETA.GT.1.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTCDF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      IF(BETA.LE.0.0D0)THEN
        CDF=1.0D0 - DEXP(-X)
      ELSE
        TERM1=DEXP(BETA*X)
        TERM3=-(1.0D0/BETA)*(TERM1 - 1.0D0)
        CDF=1.0D0 - EXP(TERM3 + BETA*X)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE MUTCHA(X,BETA,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE MUTH DISTRIBUTION
C              WITH SHAPE PARAMETER BETA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL POSITIVE X,
C              AND HAS THE CUMULATIVE HAZARD FUNCTION
C
C              H(X;BETA) = (1/BETA)*(EXP(BETA*X) - 1) - BETA*X
C                          0 <= BETA <= 1; X > 0
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE HAZARD
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--HAZ    = THE DOUBLE PRECISION CUMULATIVE HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE HAZARD FUNCTION VALUE HAZ.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JANUARY   2008. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      HAZ=0.0D0
      IF(X.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ELSEIF(BETA.LT.0.0D0 .OR. BETA.GT.1.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO MUTCHAZ IS ',
     1       'NON-POSITIVE.')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTCHAZ IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      IF(BETA.LE.0.0D0)THEN
        HAZ=X
      ELSE
        HAZ=(1.0D0/BETA)*(DEXP(BETA*X) - 1.0D0) - BETA*X
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MUTHAZ(X,BETA,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE MUTH DISTRIBUTION
C              WITH SHAPE PARAMETER BETA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL POSITIVE X,
C              AND HAS THE HAZARD FUNCTION
C
C              h(X;BETA) = EXP(BETA*X) - BETA
C                          0 <= BETA <= 1; X > 0
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE HAZARD
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--HAZ    = THE DOUBLE PRECISION HAZARD
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION HAZARD FUNCTION VALUE HAZ.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JANUARY   2008. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      HAZ=0.0D0
      IF(X.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ELSEIF(BETA.LT.0.0D0 .OR. BETA.GT.1.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO MUTHAZ IS ',
     1       'NON-POSITIVE.')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTHAZ IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      IF(BETA.LE.0.0D0)THEN
        HAZ=1.0D0
      ELSE
        HAZ=DEXP(BETA*X) - BETA
      ENDIF
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE MUTPDF(X,BETA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE MUTH DISTRIBUTION
C              WITH SHAPE PARAMETER BETA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL POSITIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C
C              f(X;BETA) = (EXP(BETA*X) - BETA)*
C                          EXP[-(1/BETA)*(EXP(BETA*X) - 1) + BETA*X]
C
C                          0 <= BETA <= 1; X > 0
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PDF    = THE DOUBLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP, LOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JANUARY   2008. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PDF=0.0D0
      IF(X.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ELSEIF(BETA.LT.0.0D0 .OR. BETA.GT.1.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO MUTPDF IS ',
     1       'NON-POSITIVE.')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTPDF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      IF(BETA.LE.0.0D0)THEN
        PDF=DEXP(-X)
      ELSE
        TERM1=DEXP(BETA*X)
        TERM3=-(1.0D0/BETA)*(TERM1 - 1.0D0)
        PDF=(TERM1 - BETA)*EXP(TERM3 + BETA*X)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE MUTPPF(P,BETA,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE MUTH
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     INPUT  ARGUMENTS--P      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --BETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION PERCENT POINT
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUE PPF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--0 < P < 1
C     OTHER DATAPAC   SUBROUTINES NEEDED--MUTCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/1
C     ORIGINAL VERSION--JANUARY   2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA EPS /0.00000001D0/
      DATA SIG /1.0D-8/
      DATA ZERO /0.0D0/
      DATA MAXIT /5000/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PPF=0.0D0
      IF(P.LE.0.0D0 .OR. P.GE.1.0D0)THEN
        WRITE(ICOUT,1)
    1   FORMAT('***** ERROR--THE FIRST ARGUMENT TO MUTPPF IS OUTSIDE ',
     1         'THE ALLOWABLE (0,1) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(BETA.LT.0.0D0 .OR. BETA.GT.1.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTPPF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IF(BETA.LE.0.0D0)THEN
        PPF=-DLOG(1.0D0 - P)
        GOTO9000
      ENDIF
C
C  FIND BRACKETING INTERVAL.  THIS IS A RELATIVELY SHORT-TAILED
C  DISTRIBUTION WITH A RESTRICTED VALUE OF THE SHAPE PARAMETER.
C  SO JUST USE 10 AS THE UPPER BOUND (AND INCREMENT IN STEPS
C  OF 10).
C
      XL=0.0D0
      XR=5.0D0
      XINC=10.0D0
      ICOUNT=0
      MAXCNT=10000
C
   91 CONTINUE
      IF(XL.LE.0.0D0)THEN
        CDFL=0.0D0
      ELSE
        CALL MUTCDF(XL,BETA,CDFL)
      ENDIF
      IF(XR.LE.0.0D0)XR=XL+XINC
      CALL MUTCDF(XR,BETA,CDFR)
C
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
        XR=XL+XINC
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
        IF(XL.LT.0.0D0)XL=0.0D0
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
   96 FORMAT('***** ERROR--MUTPPF UNABLE TO FIND BRACKETING INTERVAL.')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -P
      FXR = 1.0D0 - P
  105 CONTINUE
      X = (XL+XR)*0.5D0
      CALL MUTCDF(X,BETA,DCDF)
      P1=DCDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9000
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
  130 FORMAT('***** ERROR--MUTPPF ROUTINE DID NOT CONVERGE.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MUTRAN(N,BETA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE MUTH DISTRIBUTION
C              WITH SHAPE PARAMETER VALUE = BETA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --BETA   = THE SINGLE PRECISION VALUE OF THE
C                                SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE MUTH DISTRIBUTION
C             WITH SHAPE PARAMETER VALUE = BETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --0 <= BETA <= N
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, MUTPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCE--LEEMIS AND MCQUESTION (2008), "UNIVARIATE DISTRIBUTION
C                RELATIONSHIPS", THE AMERICAN STATISTICIAN, VOL. 62,
C                NO. 1, PP. 45-53.
C              --MUTH (1977), "RELIABILITY MODELS WITH POSITIVE MEMORY
C                DERIVED FROM THE MEAN RESIDUAL LIFE FUNCTION", IN
C                "THE THEORY AND APPLICATIONS OF RELIABILITY",
C                EDS. TSOKOS AND SHIMI, NEW YORK: ACADEMIC PRESS, INC.,
C                PP. 401-435.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008.1
C     ORIGINAL VERSION--JANUARY   2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
      DOUBLE PRECISION DTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(BETA.LT.0.0 .OR. BETA.GT.1.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF MUTH RANDOM ',
     1       'NUMBERS IS NON-POSITIVE.')
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO MUTRAN IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N MUTH DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        CALL MUTPPF(DBLE(X(I)),DBLE(BETA),DTEMP)
        X(I)=REAL(DTEMP)
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE MVMLTL(NR,N,A,X,Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C COMPUTE Y=LX
C WHERE L IS A LOWER TRIANGULAR MATRIX STORED IN A
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM
C A(N,N)       --> LOWER TRIANGULAR (N*N) MATRIX
C X(N)         --> OPERAND VECTOR
C Y(N)        <--  RESULT VECTOR
C
C NOTE
C ----
C X AND Y CANNOT SHARE STORAGE
C
      DIMENSION A(NR,1),X(N),Y(N)
      DO 30 I=1,N
        SUM=0.
        DO 10 J=1,I
          SUM=SUM+A(I,J)*X(J)
   10   CONTINUE
        Y(I)=SUM
   30 CONTINUE
      RETURN
      END
      SUBROUTINE MVMLTS(NR,N,A,X,Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C COMPUTE Y=AX
C WHERE "A" IS A SYMMETRIC (N*N) MATRIX STORED IN ITS LOWER
C TRIANGULAR PART AND X,Y ARE N-VECTORS
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM
C A(N,N)       --> SYMMETRIC (N*N) MATRIX STORED IN
C                  LOWER TRIANGULAR PART AND DIAGONAL
C X(N)         --> OPERAND VECTOR
C Y(N)        <--  RESULT VECTOR
C
C NOTE
C ----
C X AND Y CANNOT SHARE STORAGE.
C
      DIMENSION A(NR,1),X(N),Y(N)
      DO 30 I=1,N
        SUM=0.
        DO 10 J=1,I
          SUM=SUM+A(I,J)*X(J)
   10   CONTINUE
        IF(I.EQ.N) GO TO 25
        IP1=I+1
        DO 20 J=IP1,N
          SUM=SUM+A(J,I)*X(J)
   20   CONTINUE
   25   Y(I)=SUM
   30 CONTINUE
      RETURN
      END
      SUBROUTINE MVMLTU(NR,N,A,X,Y)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C COMPUTE Y=(L+)X
C WHERE L IS A LOWER TRIANGULAR MATRIX STORED IN A
C (L-TRANSPOSE (L+) IS TAKEN IMPLICITLY)
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM
C A(NR,1)       --> LOWER TRIANGULAR (N*N) MATRIX
C X(N)         --> OPERAND VECTOR
C Y(N)        <--  RESULT VECTOR
C
C NOTE
C ----
C X AND Y CANNOT SHARE STORAGE
C
      DIMENSION A(NR,1),X(N),Y(N)
      DO 30 I=1,N
        SUM=0.
        DO 10 J=I,N
          SUM=SUM+A(J,I)*X(J)
   10   CONTINUE
        Y(I)=SUM
   30 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION MVNFNC(N, W)
*     
*     Integrand subroutine
*
      INTEGER N, INFIN(*), INFIS
      DOUBLE PRECISION W(*), LOWER(*), UPPER(*), CORREL(*), ONE
      INTEGER NL, IJ, I, J
      PARAMETER ( NL = 100, ONE = 1.0D0 )
      DOUBLE PRECISION COV((NL*(NL+1))/2), A(NL), B(NL), Y(NL), BVN
      INTEGER INFI(NL)
      DOUBLE PRECISION PROD, D1, E1, DI, EI, SUM, PHINV, D, E, MVNNIT
      SAVE D1, E1, A, B, INFI, COV
      DI = D1
      EI = E1
      PROD = E1 - D1
      IJ = 1
      DO 100 I = 1,N
         Y(I) = PHINV( DI + W(I)*(EI-DI) )
         SUM = 0.0D0
         DO 200 J = 1,I
            IJ = IJ + 1
            SUM = SUM + COV(IJ)*Y(J)
  200    CONTINUE
         IJ = IJ + 1
         IF ( COV(IJ) .GT. 0.0D0 ) THEN
            CALL LIMITS( A(I+1)-SUM, B(I+1)-SUM, INFI(I+1), DI, EI )
         ELSE
            DI = ( 1.0D0 + SIGN( ONE, A(I+1)-SUM ) )/2.0D0
            EI = ( 1.0D0 + SIGN( ONE, B(I+1)-SUM ) )/2.0D0
         ENDIF
         PROD = PROD*(EI-DI)
 100  CONTINUE
      MVNFNC = PROD
      RETURN
*
*     Entry point for intialization.
*
      ENTRY MVNNIT(N, CORREL, LOWER, UPPER, INFIN, INFIS, D, E)
      MVNNIT = 0
*
*     Initialization and computation of covariance Cholesky factor.
*
      CALL NCVSRT(N, LOWER,UPPER,CORREL,INFIN,Y, INFIS,A,B,INFI,COV,D,E)
      D1 = D
      E1 = E
      IF ( N - INFIS .EQ. 2 ) THEN
         D = SQRT( 1.0D0 + COV(2)**2 )
         A(2) = A(2)/D
         B(2) = B(2)/D
         E = BVN( A, B, INFI, COV(2)/D )
         D = 0.0D0
         INFIS = INFIS + 1 
      END IF
C
      RETURN
      END
      SUBROUTINE MVTLMS( NU, A, B, INFIN, LOWER, UPPER )
      DOUBLE PRECISION A, B, LOWER, UPPER, STUDNT
      INTEGER NU, INFIN
      LOWER = 0.0D0
      UPPER = 1.0D0
      IF ( INFIN .GE. 0 ) THEN
         IF ( INFIN .NE. 0 ) LOWER = STUDNT( NU, A )
         IF ( INFIN .NE. 1 ) UPPER = STUDNT( NU, B )
      ENDIF
C
      RETURN
      END
      SUBROUTINE MVTSRT( N, NU, LOWER, UPPER, CORREL, INFIN, Y, INFIS, 
     &                   A, B, INFI, COV, D, E )
*
*     Sort limits
*
      INTEGER N, NU, INFI(*), INFIN(*), INFIS
      DOUBLE PRECISION 
     &     A(*), B(*), COV(*), LOWER(*), UPPER(*), CORREL(*), Y(*), D, E
      INTEGER I, J, K, IJ, II, JMIN
      DOUBLE PRECISION SUMSQ, ZERO, TWO, PI, CVDIAG
      DOUBLE PRECISION AI, BI, SUM, YL, YU, YD
      DOUBLE PRECISION AMIN, BMIN, DMIN, EMIN, CON, CONODD, CONEVN
      PARAMETER ( ZERO = 0, TWO = 2, PI = 3.14159 26535 89793 23844 )
      IJ = 0
      II = 0
      INFIS = 0
      DO 100 I = 1, N
         INFI(I) = INFIN(I)
         IF ( INFI(I) .LT. 0 ) THEN
            INFIS = INFIS + 1
         ELSE
            A(I) = 0.0D0
            B(I) = 0.0D0
            IF ( INFI(I) .NE. 0 ) A(I) = LOWER(I)
            IF ( INFI(I) .NE. 1 ) B(I) = UPPER(I)
         ENDIF
         DO 200 J = 1,I-1
            IJ = IJ + 1
            II = II + 1
            COV(IJ) = CORREL(II)
  200    CONTINUE
         IJ = IJ + 1
         COV(IJ) = 1
  100 CONTINUE
      CONODD = 1.0D0/PI
      CONEVN = 1.0D0/TWO
      DO 300 I = 1, NU - 1
         IF ( MOD(I,2) .EQ. 0 ) THEN
            IF ( I .GT. 2 ) CONEVN = CONEVN*DBLE(I-1)/DBLE(I-2)
         ELSE
            IF ( I .GT. 2 ) CONODD = CONODD*DBLE(I-1)/DBLE(I-2)
         ENDIF
  300 CONTINUE
*
*     First move any doubly infinite limits to innermost positions
*
      IF ( INFIS .LT. N ) THEN
         DO 400 I = N, N-INFIS+1, -1
            IF ( INFI(I) .GE. 0 ) THEN
               DO 500 J = 1, I-1
                  IF ( INFI(J) .LT. 0 ) THEN
                     CALL RCSWAP( J, I, A, B, INFI, N, COV )
                     GOTO 400
                  ENDIF
  500          CONTINUE
            ENDIF
  400    CONTINUE
*
*     Sort remaining limits and determine Cholesky decomposition
*
         II = 0
         YD = 1.0D0
         DO 900 I = 1, N-INFIS
*
*     Determine the integration limits for variable with minimum
*      expected probability and interchange that variable with Ith.
*
            EMIN = 1
            DMIN = 0
            JMIN = I
            CVDIAG = 0
            IJ = II
            DO 600 J = I, N-INFIS
               SUM = 0
               SUMSQ = 0
               DO 650 K = 1, I-1
                  SUM = SUM + COV(IJ+K)*Y(K)
                  SUMSQ = SUMSQ + COV(IJ+K)**2
  650          CONTINUE
               IJ = IJ + J
               SUMSQ = SQRT( MAX( COV(IJ)-SUMSQ, ZERO ) )
               IF ( SUMSQ .GT. 0 ) THEN
                  AI = YD*( A(J) - SUM )/SUMSQ
                  BI = YD*( B(J) - SUM )/SUMSQ
                  CALL MVTLMS( NU+J-1, AI, BI, INFI(J), D, E )
                  IF ( EMIN - DMIN .GE. E - D ) THEN
                     JMIN = J
                     AMIN = AI
                     BMIN = BI
                     DMIN = D
                     EMIN = E
                     CVDIAG = SUMSQ
                  ENDIF
               ENDIF
  600       CONTINUE
            IF ( JMIN .NE. I ) CALL RCSWAP( I, JMIN, A,B, INFI, N,COV )
*
*     Compute Ith column of Cholesky factor.
*
            IJ = II + I
            COV(IJ) = CVDIAG
            DO 700 J = I+1, N-INFIS
               IF ( CVDIAG .GT. 0.0D0 ) THEN
                  SUM = COV(IJ+I)
                  DO 750 K = 1, I-1
                     SUM = SUM - COV(II+K)*COV(IJ+K)
  750             CONTINUE
                  COV(IJ+I) = SUM/CVDIAG
               ELSE
                  COV(IJ+I) = 0.0D0
               ENDIF
               IJ = IJ + J
 700        CONTINUE
*
*     Compute expected value for Ith integration variable and
*     scale Ith covariance matrix row and limits.
*
            IF ( MOD(NU+I-1,2) .EQ. 0 ) THEN
               IF ( NU+I-3 .GT. 0 ) CONEVN =
     &                              CONEVN*DBLE(NU+I-2)/DBLE(NU+I-3)
               CON = CONEVN
            ELSE
               IF ( NU+I-3 .GT. 0 ) CONODD =
     &                              CONODD*DBLE(NU+I-2)/DBLE(NU+I-3)
               CON = CONODD
            ENDIF
            IF ( CVDIAG .GT. 0.0D0 ) THEN
               YL = 0.0D0
               YU = 0.0D0
               IF ( INFI(I) .NE. 0 .AND. NU+I-2 .GT. 0 ) 
     &              YL = -CON*DBLE(NU+I-1)/DBLE(NU+I-2)
     &              /( 1.0D0 + AMIN**2/DBLE(NU+I-1) )**((NU+I-2)/TWO)
               IF ( INFI(I) .NE. 1 .AND. NU+I-2 .GT. 0 ) 
     &              YU = -CON*DBLE(NU+I-1)/DBLE(NU+I-2)
     &              /( 1.0D0 + BMIN**2/(NU+I-1) )**( (NU+I-2)/TWO )
               Y(I) = ( YU - YL )/( EMIN - DMIN )/YD
               DO 800 J = 1,I
                  II = II + 1
                  COV(II) = COV(II)/CVDIAG
  800          CONTINUE
               IF ( INFI(I) .NE. 0 ) A(I) = A(I)/CVDIAG
               IF ( INFI(I) .NE. 1 ) B(I) = B(I)/CVDIAG
            ELSE
               Y(I) = 0.0D0
               II = II + I
            ENDIF
            YD = YD/SQRT( 1 + ( Y(I)*YD + 1 )*( Y(I)*YD - 1 )/(NU+I) )
  900    CONTINUE
         CALL MVTLMS( NU, A(1), B(1), INFI(1), D, E)
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBCDF(X,P,AN,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE X FOR
C              THE NEGATIVE BINOMIAL DISTRIBUTION WITH DOUBLE
C              PRECISION 'BERNOULLI PROBABILITY' PARAMETER = P,
C              AND DOUBLE PRECISION 'NUMBER OF SUCCESSES IN
C              BERNOULLI TRIALS' PARAMETER = N.  THE NEGATIVE
C              BINOMIAL DISTRIBUTION USED HEREIN HAS MEAN = N*(1-P)/P
C              AND STANDARD DEVIATION = SQRT(N*(1-P)/(P*P))).
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE
C              INTEGER X--X = 0, 1, 2, ... .  THIS DISTRIBUTION HAS
C              THE PROBABILITY MASS FUNCTION
C
C                  p(X;P,N) = C(N+X-1,N) * P**N * (1-P)**X.
C
C              WHERE C(N+X-1,N) IS THE COMBINATORIAL FUNCTION
C              EQUALING THE NUMBER OF COMBINATIONS OF N+X-1 ITEMS
C              TAKEN N AT A TIME.  THE NEGATIVE BINOMIAL DISTRIBUTION
C              IS THE DISTRIBUTION OF THE NUMBER OF FAILURES BEFORE
C              OBTAINING N SUCCESSES IN AN INDEFINITE SEQUENCE OF
C              BERNOULLI (0,1) CTRIALS WHERE THE PROBABILITY OF
C              SUCCESS IN A SINGLE TRIAL = P.
C
C              THE NEGATIVE BINOMIAL CAN BE EXTENDED TO THE
C              CASE WHERE N IS POSITIVE REAL NUMBER (I.E., NOT
C              RESTRICTED TO AN INTEGER).  IN THAT CASE, THE
C              PROBABILITY FUNCTION IS:
C
C              F(X) = P**N * (1-P)**X * GAMMA(N+X)/(GAMMA(N)*X!)
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.  X
C                                SHOULD BE A NON-NEGATIVE INTEGER.
C                     --P      = THE DOUBLE PRECISION VALUE OF THE
C                                'BERNOULLI PROBABILITY' PARAMETER
C                                FOR THE NEGATIVE BINOMIAL
C                                DISTRIBUTION.  0 <= P < 1.
C                     --N      = THE DOUBLE PRECISION VALUE OF THE
C                                'NUMBER OF SUCCESSES IN BERNOULLI
C                                TRIALS' PARAMETER.  N > 0.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE NEGATIVE BINOMIAL
C             DISTRIBUTION WITH PARAMETERS P AND N.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE AND INTEGRAL-VALUED.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY) AND
C                   1.0 (EXCLUSIVELY).
C                 --N SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DBETAI.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DSQRT, DATAN, LNGAMM.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NATIONAL BUREAU OF STANDARDS APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 945, FORMULAE 26.5.24 AND
C                 26.5.28, AND PAGE 929.
C               --JOHNSON, KOTZ, AND KEMP, "DISCRETE UNIVARIATE
C                 DISTRIBUTIONS", SECOND EDITION, 1992.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION, 2001.
C               --FELLER, AN INTRODUCTION TO PROBABILITY
C                 THEORY AND ITS APPLICATIONS, VOLUME 1,
C                 EDITION 2, 1957, PAGES 155-157, 210.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGES 130-131.
C               --WILLIAMSON AND BRETHERTON, TABLES OF
C                 THE NEGATIVE BINOMIAL PROBABILITY
C                 DISTRIBUTION, 1963.
C               --OWEN, HANDBOOK OF STATISTICAL
C                 TABLES, 1962, PAGE 304.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     2004. EXTEND TO NON-INTEGER VALUES
C                                       FOR N
C     UPDATED         --MARCH     2009. CONVERT TO DOUBLE PRECISION
C     UPDATED         --MARCH     2009. USE DBETAI EVEN FOR INTEGER
C                                       VALUES OF N
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 ICASE
C
      DOUBLE PRECISION X
      DOUBLE PRECISION P
      DOUBLE PRECISION AN
      DOUBLE PRECISION CDF
      DOUBLE PRECISION DBETAI
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA EPS/0.0000001D0/
C
C-----START POINT-----------------------------------------------------
C
      CDF=0.0D0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0D0.OR.P.GT.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   11 FORMAT('***** ERROR--THE SECOND ARGUMENT TO NBCDF IS OUTSIDE ',
     1'THE ALLOWABLE (0,1) INTERVAL')
C
      IF(X.LT.0.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO NBCDF IS NEGATIVE.')
C
      IF(AN.LE.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AN
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE THIRD ARGUMENT TO NBCDF IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IX=INT(X+EPS)
      CDF=1.0D0 - DBETAI(DBLE(1.0-P),DBLE(IX+1),DBLE(AN))
C
 9000 CONTINUE
      RETURN
C
      END
      INTEGER FUNCTION NBPK(M,J)
CCCCC INTEGER FUNCTION NBP_K(M,J)
      IF (M.LT.J) THEN
          NBPK=0
      ELSE
          IF (J.EQ.1) NBPK=M
          IF (J.EQ.2) NBPK=(M*(M-1))/2
          IF (J.EQ.3) NBPK=(M*(M-1)*(M-2))/6
      ENDIF
      RETURN
      END
      INTEGER FUNCTION NBPNCE(M,J)
CCCCC CHANGE TO 6-CHARACTER NAME
CCCCC INTEGER FUNCTION NBP_NCEIL(M,J)
      IF (MOD(M,J).EQ.0) THEN
         NBPNCE=INT(dble(M)/J)
      ELSE
         NBPNCE=NINT(dble(M)/J+0.5)
      ENDIF
      RETURN
      END
      DOUBLE PRECISION FUNCTION NBFUN(DK,DX)
C
C     PURPOSE--DPMLNB CALLS DFZER2 TO FIND A ROOT FOR THE FOLLOWING
C              FUNCTION:
C
C                 LN(KHAT) - LN(XBAR + KHAT) - PSI(KHAT) +
C                 (1/N)*SUM[i=1 to N][PSI(X(I) + KHAT)] = 0
C
C              WITH
C
C                  KHAT     = CURRENT ESTIMATE FOR K
C                  N        = SAMPLE SIZE
C                  XBAR     = SAMPLE MEAN
C                  PSI      = PSI FUNCTION
C
C     INPUT  ARGUMENTS--DK  = THE DOUBLE PRECISION VALUE THAT
C                             SPECIFIES THE K SHAPE PARAMETER FOR
C                             THE NEGATIVE BINOMIAL DISTRIBUTION.
C     OUTPUT--THE DOUBLE PRECISION FUNCTION VALUE NBFUN.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DPSI.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KARL BURY (1999). "STATISTICAL DISTRIBUTIONS IN
C                 ENGINEERING", CAMBRIDGE UNIVERSITY PRESS, P. 91.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006.5
C     ORIGINAL VERSION--MAY       2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DX(*)
C
      DOUBLE PRECISION DXBAR
      COMMON/NBCOM/DXBAR,N
C
      EXTERNAL DPSI
      DOUBLE PRECISION DPSI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DSUM1
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DTERM1=DLOG(DK) - DLOG(DXBAR + DK) - DPSI(DK)
      DSUM1=0.0D0
      DO100I=1,N
        DTERM2=DX(I) + DK
        DSUM1=DSUM1 + DPSI(DTERM2)
  100 CONTINUE
      NBFUN=DTERM1 + DSUM1/DBLE(N)
C
 9999 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION NBFUN2(DK,DX)
C
C     PURPOSE--DPMLNB CALLS DFZER2 TO FIND A ROOT FOR THE FOLLOWING
C              FUNCTION:
C
C                 LN(KHAT) - LN(XBAR + KHAT) - PSI(KHAT) +
C                 (1/N)*SUM[i=1 to N][PSI(X(I) + KHAT)] = 0
C
C              WITH
C
C                  KHAT     = CURRENT ESTIMATE FOR K
C                  N        = SAMPLE SIZE
C                  XBAR     = SAMPLE MEAN
C                  PSI      = PSI FUNCTION
C
C               THIS VERSION IS MODIFIED FOR THE CASE WHERE THE
C               DATA IS GROUPED.
C
C     INPUT  ARGUMENTS--DK  = THE DOUBLE PRECISION VALUE THAT
C                             SPECIFIES THE K SHAPE PARAMETER FOR
C                             THE NEGATIVE BINOMIAL DISTRIBUTION.
C     OUTPUT--THE DOUBLE PRECISION FUNCTION VALUE NBFUN.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DPSI.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KARL BURY (1999). "STATISTICAL DISTRIBUTIONS IN
C                 ENGINEERING", CAMBRIDGE UNIVERSITY PRESS, P. 91.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009.3
C     ORIGINAL VERSION--MARCH     2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DK
      DOUBLE PRECISION DX(*)
C
      DOUBLE PRECISION DXBAR
      COMMON/NBCOM2/DXBAR,N,IINDX
C
      EXTERNAL DPSI
      DOUBLE PRECISION DPSI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DFREQ
      DOUBLE PRECISION DVAL
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DTERM1=DLOG(DK) - DLOG(DXBAR + DK) - DPSI(DK)
      DSUM1=0.0D0
      DO100I=1,N
        DVAL=DX(I)
        DFREQ=DX(I+IINDX)
        DTERM2=DVAL + DK
        DSUM1=DSUM1 + DFREQ*DPSI(DTERM2)
  100 CONTINUE
      NBFUN2=DTERM1 + DSUM1/DBLE(N)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NBLIK1(Y,N,P,AK,
     1ALIK,AIC,AICC,BIC,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE NEGATIVE BINOMIAL DISTRIBUTION.  THE DATA IS
C              ASSUMED TO BE IN "RAW" FORM.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.  ALSO, IT IS ASSUMED
C              THAT THE CALLING PROGRAM HAS ALREADY ROUNDED THE RESPONSE
C              TO THE NEAREST INTEGER.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DP
      DOUBLE PRECISION DK
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DLNGAM
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NBLI'
      ISUBN2='K1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NBLIK1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,P,AK
   55   FORMAT('N,P,AK = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
C     LIKELIHOOD FUNCTION IS:
C
C     SUM[i=1 to N][LOG(GAMMA(Y(i) + K)] - N*LOG(GAMMA(R)) -
C     SUM[i=1 to N][LOG(GAMMA(Y(i)+ 1)] - N*K*LOG(P) +
C     N*XBAR*LOG(1-P)
C
      CALL MEAN(Y,N,IWRITE,XMEAN,IBUGA3,IERROR)
      DXBAR=DBLE(XMEAN)
      DN=DBLE(N)
      DP=DBLE(P)
      DK=DBLE(AK)
      DTERM1=-DN*DLNGAM(DK)+DN*DK*LOG(DP)+DN*DXBAR*LOG(1.0D0-DP)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO1000I=1,N
        DX=DBLE(Y(I))
        DSUM1=DSUM1 + DLNGAM(DX+DK)
        DSUM2=DSUM2 + DLNGAM(DX+1.0D0)
 1000 CONTINUE
C
      DLIK=DSUM1 - DSUM2 + DTERM1
      ALIK=REAL(DLIK)
      DNP=2.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NBLIK1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)DSUM1,DSUM2
 9012   FORMAT('DSUM1,DSUM2 = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DTERM1,DTERM2,DTERM3
 9013   FORMAT('DTERM1,DTERM2,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBLIK2(Y,X,N,P,AK,
     1ALIK,AIC,AICC,BIC,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE NEGATIVE BINOMIAL DISTRIBUTION.  THE DATA IS
C              ASSUMED TO BE IN "BINNED" FORM.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.  ALSO, IT IS ASSUMED
C              THAT THE CALLING PROGRAM HAS ALREADY ROUNDED THE RESPONSE
C              TO THE NEAREST INTEGER.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DFREQ
      DOUBLE PRECISION DP
      DOUBLE PRECISION DK
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DLNGAM
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NBLI'
      ISUBN2='K2  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NBLIK2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,P,AK
   55   FORMAT('N,P,AK = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,X(I),Y(I)
   57     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
C     LIKELIHOOD FUNCTION IS:
C
C     SUM[i=1 to N][LOG(GAMMA(Y(i) + K)] - N*LOG(GAMMA(R)) -
C     SUM[i=1 to N][LOG(GAMMA(Y(i)+ 1)] - N*K*LOG(P) +
C     N*XBAR*LOG(1-P)
C
      CALL WEMEAN(X,Y,N,IWRITE,XMEAN,IBUGA3,IERROR)
      DXBAR=DBLE(XMEAN)
      NTOT=0
      DO1000I=1,N
        NTOT=INT(Y(I))+NTOT
 1000 CONTINUE
      DN=DBLE(NTOT)
      DP=DBLE(P)
      DK=DBLE(AK)
      DTERM1=-DN*DLNGAM(DK)+DN*DK*LOG(DP)+DN*DXBAR*LOG(1.0D0-DP)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO1010I=1,N
        DX=DBLE(X(I))
        DFREQ=DBLE(Y(I))
        DSUM1=DSUM1 + DFREQ*DLNGAM(DX+DK)
        DSUM2=DSUM2 + DFREQ*DLNGAM(DX+1.0D0)
 1010 CONTINUE
C
      DLIK=DSUM1 - DSUM2 + DTERM1
      ALIK=REAL(DLIK)
      NP=2
      DNP=DBLE(NP)
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NBLIK2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)DSUM1,DSUM2
 9012   FORMAT('DSUM1,DSUM2 = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DTERM1,DTERM2,DTERM3
 9013   FORMAT('DTERM1,DTERM2,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBML1(Y,N,XMEAN,XVAR,PSV,AKSV,
     1XTEMP,DTEMP,ITEMP,MAXNXT,
     1ALOWP1,AUPPP1,ALOWK1,AUPPK1,ALPHA,NUMALP,NUMOUT,
     1AKML,PML,PMLBC,PSE,AKSE,COVSE,IERFLG,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE NEGATIVE BINOMIAL DISTRIBUTION FOR THE CASE WHERE
C              P AND K ARE BOTH UNKNOWN.  THE DATA IS ASSUMED TO BE IN
C              "RAW" FORM.  YOU CAN OPTIONALLY SPECIFY STARTING VALUES
C              (IN PSV AND KSV).  THE MOMENT ESTIMATES WILL BE USED IF
C              STARTING VALUES ARE NOT SPECIFIED.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.  ALSO, IT IS ASSUMED
C              THAT THE CALLING PROGRAM HAS ALREADY ROUNDED THE RESPONSE
C              TO THE NEAREST INTEGER.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --JOHNSON, KEMP, AND KOTZ.  "UNIVARIATE DISCRETE
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2005, CHAPTER 5.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPNBML)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION ALOWP1(*)
      DIMENSION AUPPP1(*)
      DIMENSION ALOWK1(*)
      DIMENSION AUPPK1(*)
      DIMENSION ALPHA(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      EXTERNAL NBFUN
      DOUBLE PRECISION NBFUN
C
      DOUBLE PRECISION DXBAR
      COMMON/NBCOM/DXBAR,NSAMP
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
      DOUBLE PRECISION DINC
C
      DOUBLE PRECISION TRIGAM
C
      INTEGER IFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER ITEMP(*)
C
      REAL FISH(2,2)
      REAL COV(2,2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NBML'
      ISUBN2='1   '
C
      IERROR='NO'
C
      AKML=-99.0
      PML=-99.0
      PMLBC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NBML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,XMEAN,XVAR,AKSV,PSV
   55   FORMAT('N,XMEAN,XVAR,AKSV,PSV = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
      IF(XVAR.LE.0.0)THEN
        IERFLG=1
        GOTO9000
      ELSE
        ARATIO=XMEAN/XVAR
        AMXRAT=0.97
        IF(ARATIO.GT.AMXRAT)THEN
          IERFLG=1
          GOTO9000
        ENDIF
      ENDIF
C
C     IF STARTING VALUES DO NOT EXIST, COMPUTE METHOD OF
C     MOMENT ESTIMATORS
C
      AKMOM=XMEAN*XMEAN/(XVAR - XMEAN)
      IF(AKSV.EQ.CPUMIN)THEN
        AKSV=AKMOM
      ENDIF
      PMOM=XMEAN/XVAR
      IF(PSV.EQ.CPUMIN)THEN
        PKSV=PMOM
      ENDIF
C
C     NOW COMPUTE MAXIMUM LIKELIHOOD ESTIMATES FOR K
C     ASSUMED UNKNOWN CASE.
C
      DXBAR=DBLE(XMEAN)
      NSAMP=N
C
      DXSTRT=DBLE(AKSV)
      DINC=MAX(DXSTRT/25.0D0,1.0D0)
      DINC=2.0D0
      DAE=0.000001D0
      DRE=DAE
      IFLAG=0
      DXLOW=MAX(DXSTRT - DINC,0.00001D0)
      DXUP=DXSTRT + DINC
      ITBRAC=0
      DO3104I=1,N
        DTEMP(I)=DBLE(Y(I))
 3104 CONTINUE
C
 3105 CONTINUE
      XLOWSV=DXLOW
      XUPSV=DXUP
      CALL DFZER2(NBFUN,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
C
      IF(IFLAG.EQ.4 .AND. ITBRAC.LE.200)THEN
        DXLOW=MAX(0.00001D0,XLOWSV-DINC)
        DXUP=XUPSV+DINC
        ITBRAC=ITBRAC+1
        GOTO3105
      ENDIF
C
      IERFLG=IFLAG
C
      AKML=REAL(DXLOW)
      PML=AKML/(XMEAN + AKML)
      IF(AKML.GT.1.0)THEN
        PMLBC=(AKML-1.0)/(XMEAN + AKML - 1.0)
      ELSE
        PMLBC=0.0
      ENDIF
C
C     COMPUTE LOCAL FISHER INFORMATION MATRIX
C
      AN=REAL(N)
      FISH(1,1)=AN*AKML/(PML*PML*(1.0-PML))
      FISH(2,1)=-AN/PML
      FISH(1,2)=FISH(2,1)
      DN=DBLE(N)
      DTERM1=DN*TRIGAM(DBLE(AKML),IFAULT)
      DSUM1=0.0D0
      DO3200I=1,N
        DSUM1=DSUM1 + TRIGAM(DBLE(Y(I)+DBLE(AKML)),IFAULT)
 3200 CONTINUE
      FISH(2,2)=REAL(DTERM1 - DSUM1)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3211)
 3211   FORMAT('****** NBML1: AFTER COMPUTE FISHER INFORMATION MATRIX')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3214)DSUM1,DTERM1
 3214   FORMAT('DSUM1,DTERM1 = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3215)FISH(1,1),FISH(2,1),FISH(2,2)
 3215   FORMAT('FISH(1,1),FISH(2,1),FISH(2,2) = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      NDIM=2
      CALL SGECO(FISH,NDIM,NDIM,ITEMP,RCOND,XTEMP)
      IJOB=1
      CALL SGEDI(FISH,NDIM,NDIM,ITEMP,XTEMP,XTEMP(MAXNXT/2),IJOB)
      DO3230J=1,NDIM
        DO3240I=1,NDIM
          COV(I,J)=FISH(I,J)
 3240   CONTINUE
 3230 CONTINUE
      PSE=0.0
      IF(COV(1,1).GE.0.0)PSE=SQRT(COV(1,1))
      AKSE=0.0
      IF(COV(2,2).GE.0.0)AKSE=SQRT(COV(2,2))
      COVSE=0.0
      IF(COV(2,1).GE.0.0)COVSE=SQRT(COV(2,1))
C
      DO3260I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL NORPPF(P1,APPF1)
        CALL NORPPF(P2,APPF2)
        ALOWP1(I)=PML + APPF1*PSE
        IF(ALOWP1(I).LT.0.0)ALOWP1(I)=0.0
        AUPPP1(I)=PML + APPF2*PSE
        IF(AUPPP1(I).GE.1.0)AUPPP1(I)=1.0
        ALOWK1(I)=AKML + APPF1*AKSE
        IF(ALOWK1(I).LT.0.0)ALOWK1(I)=0.0
        AUPPK1(I)=AKML + APPF2*AKSE
C
 3260 CONTINUE
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NBML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)PML,PMLBC,AKML
 9013   FORMAT('PML,PMLBC,AKML = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBML2(N,XMEAN,XVAR,AK,
     1ALOWP1,AUPPP1,ALPHA,NUMALP,NUMOUT,
     1PML,PMLBC,PMLBCV,IERFLG,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE NEGATIVE BINOMIAL DISTRIBUTION FOR THE CASE WHERE
C              K IS ASSUMED KNOWN.  THE DATA IS ASSUMED TO BE IN
C              "RAW" FORM.  CONFIDENCE LIMITS FOR P WILL BE RETURNED IF
C              NUMALP >= 1.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.  ALSO, IT IS ASSUMED
C              THAT THE CALLING PROGRAM HAS ALREADY ROUNDED THE RESPONSE
C              TO THE NEAREST INTEGER.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --JOHNSON, KEMP, AND KOTZ.  "UNIVARIATE DISCRETE
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2005, CHAPTER 5.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPNBML)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
C---------------------------------------------------------------------
C
      DIMENSION ALOWP1(*)
      DIMENSION AUPPP1(*)
      DIMENSION ALPHA(*)
C
      DOUBLE PRECISION DTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NBML'
      ISUBN2='1   '
C
      IERROR='NO'
C
      AKML=-99.0
      PML=-99.0
      PMLBC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NBML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,XMEAN,XVAR
   55   FORMAT('N,XMEAN,XVAR = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
      PMLBC=0.0
      PMLBCV=0.0
      PML=AK/(XMEAN+AK)
C
      IF(PML.LT.0.0 .OR. PML.GT.1.0)THEN
        IERFLG=1
        GOTO9000
      ENDIF
C
      IF(AK.GE.2.0)THEN
        PMLBC=(AK-1.0)/(XMEAN+AK-1.0)
        PMLBCV=(1.0/REAL(N))*PMLBC*PMLBC*(1.0-PMLBC)/
     1         (AK-1.0-PMLBC)
      ENDIF
C
      AN=REAL(N)
      IF(AK.GE.2.0 .AND. NUMALP.GE.1)THEN
        DO2160I=1,NUMALP
C
          ALP=ALPHA(I)
          P1=ALP/2.0
          P2=1.0-(ALP/2.0)
          CALL NBPPF(DBLE(P1),DBLE(PMLBC),DBLE(AN*AK),DTEMP)
          SL=DTEMP
          CALL NBPPF(DBLE(P2),DBLE(PMLBC),DBLE(AN*AK),DTEMP)
          SU=DTEMP
          TERM1=AK - 1.0
          ALOWP1(I)=TERM1/((SU/AN)+TERM1)
          IF(ALOWP1(I).LE.0.0)ALOWP1(I)=0.0
          AUPPP1(I)=TERM1/((SL/AN)+TERM1)
          IF(AUPPP1(I).GE.1.0)AUPPP1(I)=1.0
 2160   CONTINUE
        NUMOUT=NUMALP
      ELSE
        NUMOUT=0
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NBML2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)PML,PMLBC,PMLBCV
 9013   FORMAT('PML,PMLBC,PMLBCV = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        IF(AK.GE.2.0 .AND. NUMALP.GE.1)THEN
          DO9160I=1,NUMALP
            WRITE(ICOUT,9063)I,ALPHA(I),ALOWP1(I),AUPPP1(I)
 9063       FORMAT('I,ALPHA(I),ALOWP1(I),AUPPP1(I) = ',I8,3G15.7)
            CALL DPWRST('XXX','WRIT')
 9160     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBML3(Y,X,N,XMEAN,XVAR,PSV,AKSV,
     1XTEMP,DTEMP,ITEMP,MAXNXT,
     1ALOWP1,AUPPP1,ALOWK1,AUPPK1,ALPHA,NUMALP,NUMOUT,
     1AKML,PML,PMLBC,PSE,AKSE,COVSE,IERFLG,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE NEGATIVE BINOMIAL DISTRIBUTION FOR THE CASE WHERE
C              P AND K ARE BOTH UNKNOWN.  THE DATA IS ASSUMED TO BE IN
C              "BINNED" FORM.  THE BINNING IS ASSUMED TO BE OF THE
C              TYPE X(I),F(I) WHERE X(I) IS THE DATA VALUE AND
C              F(I) IS THE FREQUENCY.
C
C              YOU CAN OPTIONALLY SPECIFY STARTING VALUES
C              (IN PSV AND KSV).  THE MOMENT ESTIMATES WILL BE USED IF
C              STARTING VALUES ARE NOT SPECIFIED.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.  SPECIFICALLY, THE SAMPLE SIZE AND THE
C              PRESENCE OF NON-NEGATIVE VALUES.  ALSO, IT IS ASSUMED
C              THAT THE CALLING PROGRAM HAS ALREADY ROUNDED THE RESPONSE
C              TO THE NEAREST INTEGER.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --JOHNSON, KEMP, AND KOTZ.  "UNIVARIATE DISCRETE
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2005, CHAPTER 5.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/3
C     ORIGINAL VERSION--MARCH     2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION ALOWP1(*)
      DIMENSION AUPPP1(*)
      DIMENSION ALOWK1(*)
      DIMENSION AUPPK1(*)
      DIMENSION ALPHA(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      EXTERNAL NBFUN2
      DOUBLE PRECISION NBFUN2
C
      DOUBLE PRECISION DXBAR
      COMMON/NBCOM2/DXBAR,NSAMP,IINDX
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DT1
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
      DOUBLE PRECISION DINC
C
      DOUBLE PRECISION TRIGAM
      DOUBLE PRECISION DVAL
      DOUBLE PRECISION DFREQ
C
      INTEGER IFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XTEMP(*)
      DOUBLE PRECISION DTEMP(*)
      INTEGER          ITEMP(*)
C
      REAL FISH(2,2)
      REAL COV(2,2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NBML'
      ISUBN2='3   '
C
      IERROR='NO'
C
      AKML=-99.0
      PML=-99.0
      PMLBC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML3')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NBML3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,XMEAN,XVAR,AKSV,PSV
   55   FORMAT('N,XMEAN,XVAR,AKSV,PSV = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,X(I),Y(I)
   57     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NEGATIVE BINOMIAL MLE ESTIMATE  **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML3')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
      IF(XVAR.LE.0.0)THEN
        IERFLG=1
        GOTO9000
      ELSE
        ARATIO=XMEAN/XVAR
        AMXRAT=0.97
        IF(ARATIO.GT.AMXRAT)THEN
          IERFLG=1
          GOTO9000
        ENDIF
      ENDIF
C
C     IF STARTING VALUES DO NOT EXIST, COMPUTE METHOD OF
C     MOMENT ESTIMATORS
C
      AKMOM=XMEAN*XMEAN/(XVAR - XMEAN)
      IF(AKSV.EQ.CPUMIN)THEN
        AKSV=AKMOM
      ENDIF
      PMOM=XMEAN/XVAR
      IF(PSV.EQ.CPUMIN)THEN
        PKSV=PMOM
      ENDIF
C
C     NOW COMPUTE MAXIMUM LIKELIHOOD ESTIMATES FOR K
C     ASSUMED UNKNOWN CASE.
C
      DXBAR=DBLE(XMEAN)
      IINDX=MAXNXT/2
      IF(N.LE.IINDX)THEN
        IWD=0
        NSAMP=0
        DO2110I=1,N
          DTEMP(I)=X(I)
          DTEMP(IINDX+I)=Y(I)
          NSAMP=NSAMP+INT(Y(I)+0.1)
 2110   CONTINUE
      ELSE
        IERFLG=99
        GOTO9000
      ENDIF
C
      DXSTRT=DBLE(AKSV)
      DINC=MAX(1.0D0,DXSTRT/25.0D0)
      DAE=0.000001D0
      DRE=DAE
      IFLAG=0
      DXLOW=MAX(DXSTRT - DINC,0.00001D0)
      DXUP=DXSTRT + DINC
      ITBRAC=0
C
 3105 CONTINUE
      XLOWSV=DXLOW
      XUPSV=DXUP
      CALL DFZER2(NBFUN2,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP)
C
      IF(IFLAG.EQ.4 .AND. ITBRAC.LE.200)THEN
        DXLOW=MAX(0.00001D0,XLOWSV-DINC)
        DXUP=XUPSV+DINC
        ITBRAC=ITBRAC+1
        GOTO3105
      ENDIF
C
      IERFLG=IFLAG
C
      AKML=REAL(DXLOW)
      PML=AKML/(XMEAN + AKML)
      IF(AKML.GT.1.0)THEN
        PMLBC=(AKML-1.0)/(XMEAN + AKML - 1.0)
      ELSE
        PMLBC=0.0
      ENDIF
C
C     COMPUTE LOCAL FISHER INFORMATION MATRIX
C
      AN=REAL(NSAMP)
      FISH(1,1)=AN*AKML/(PML*PML*(1.0-PML))
      FISH(2,1)=-AN/PML
      FISH(1,2)=FISH(2,1)
      DN=DBLE(NSAMP)
      DTERM1=DN*TRIGAM(DBLE(AKML),IFAULT)
      DSUM1=0.0D0
      DO3200I=1,N
        DVAL=DBLE(X(I))
        DFREQ=DBLE(Y(I))
        DSUM1=DSUM1 + DFREQ*TRIGAM(DVAL+DBLE(AKML),IFAULT)
 3200 CONTINUE
      FISH(2,2)=REAL(DTERM1 - DSUM1)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3211)
 3211   FORMAT('****** NBML1: AFTER COMPUTE FISHER INFORMATION MATRIX')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3214)DSUM1,DTERM1
 3214   FORMAT('DSUM1,DTERM1 = ',2G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,3215)FISH(1,1),FISH(2,1),FISH(2,2)
 3215   FORMAT('FISH(1,1),FISH(2,1),FISH(2,2) = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      NDIM=2
      CALL SGECO(FISH,NDIM,NDIM,ITEMP,RCOND,XTEMP)
      IJOB=1
      CALL SGEDI(FISH,NDIM,NDIM,ITEMP,XTEMP,XTEMP(MAXNXT/2),IJOB)
      DO3230J=1,NDIM
        DO3240I=1,NDIM
          COV(I,J)=FISH(I,J)
 3240   CONTINUE
 3230 CONTINUE
      PSE=0.0
      IF(COV(1,1).GE.0.0)PSE=SQRT(COV(1,1))
      AKSE=0.0
      IF(COV(2,2).GE.0.0)AKSE=SQRT(COV(2,2))
      COVSE=0.0
      IF(COV(2,1).GE.0.0)COVSE=SQRT(COV(2,1))
C
      DO3260I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
        CALL NORPPF(P1,APPF1)
        CALL NORPPF(P2,APPF2)
        ALOWP1(I)=PML + APPF1*PSE
        IF(ALOWP1(I).LT.0.0)ALOWP1(I)=0.0
        AUPPP1(I)=PML + APPF2*PSE
        IF(AUPPP1(I).GE.1.0)AUPPP1(I)=1.0
        ALOWK1(I)=AKML + APPF1*AKSE
        IF(ALOWK1(I).LT.0.0)ALOWK1(I)=0.0
        AUPPK1(I)=AKML + APPF2*AKSE
C
 3260 CONTINUE
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'BML3')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NBML3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)PML,PMLBC,AKML
 9013   FORMAT('PML,PMLBC,AKML = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NBPDF(X,P,AN,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY MASS
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE X FOR
C              THE NEGATIVE BINOMIAL DISTRIBUTION WITH DOUBLE
C              PRECISION 'BERNOULLI PROBABILITY' PARAMETER = P,
C              AND DOUBLE PRECISION 'NUMBER OF SUCCESSES IN
C              BERNOULLI TRIALS' PARAMETER = N.  THE NEGATIVE
C              BINOMIAL DISTRIBUTION USED HEREIN HAS MEAN = N*(1-P)/P
C              AND STANDARD DEVIATION = SQRT(N*(1-P)/(P*P))).
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE
C              INTEGER X--X = 0, 1, 2, ... .  THIS DISTRIBUTION HAS
C              THE PROBABILITY MASS FUNCTION
C
C                  p(X;P,N) = C(N+X-1,N) * P**N * (1-P)**X.
C
C              WHERE C(N+X-1,N) IS THE COMBINATORIAL FUNCTION
C              EQUALING THE NUMBER OF COMBINATIONS OF N+X-1 ITEMS
C              TAKEN N AT A TIME.  THE NEGATIVE BINOMIAL DISTRIBUTION
C              IS THE DISTRIBUTION OF THE NUMBER OF FAILURES BEFORE
C              OBTAINING N SUCCESSES IN AN INDEFINITE SEQUENCE OF
C              BERNOULLI (0,1) CTRIALS WHERE THE PROBABILITY OF
C              SUCCESS IN A SINGLE TRIAL = P.
C
C              THE NEGATIVE BINOMIAL CAN BE EXTENDED TO THE
C              CASE WHERE N IS POSITIVE REAL NUMBER (I.E., NOT
C              RESTRICTED TO AN INTEGER).  IN THAT CASE, THE
C              PROBABILITY FUNCTION IS:
C
C              F(X) = P**N * (1-P)**X * GAMMA(N+X)/(GAMMA(N)*X!)
C
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY MASS
C                                FUNCTION IS TO BE EVALUATED.  X
C                                SHOULD BE A NON-NEGATIVE INTEGER.
C                     --P      = THE DOUBLE PRECISION VALUE OF THE
C                                'BERNOULLI PROBABILITY' PARAMETER
C                                FOR THE NEGATIVE BINOMIAL
C                                DISTRIBUTION.  0 <= P < 1.
C                     --N      = THE DOUBLE PRECISION VALUE OF THE
C                                'NUMBER OF SUCCESSES IN BERNOULLI
C                                TRIALS' PARAMETER.  N > 0.
C     OUTPUT ARGUMENTS--PDF    = THE DOUBLE PRECISION PROBABILITY MASS
C                                FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY MASS FUNCTION VALUE
C             PDF FOR THE NEGATIVE BINOMIAL DISTRIBUTION WITH
C             PARAMETERS P AND N.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE AND INTEGRAL-VALUED.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY) AND
C                   1.0 (INCLUSIVELY).
C                 --N SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--BINRAW.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 945, FORMULAE 26.5.24 AND
C                 26.5.28, AND PAGE 929.
C               --JOHNSON, KOTZ, AND KEMP, "DISCRETE UNIVARIATE
C                 DISTRIBUTIONS", SECOND EDITION, 1992.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION, 2001.
C               --FELLER, AN INTRODUCTION TO PROBABILITY
C                 THEORY AND ITS APPLICATIONS, VOLUME 1,
C                 EDITION 2, 1957, PAGES 155-157, 210.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGES 130-131.
C               --WILLIAMSON AND BRETHERTON, TABLES OF
C                 THE NEGATIVE BINOMIAL PROBABILITY
C                 DISTRIBUTION, 1963.
C               --OWEN, HANDBOOK OF STATISTICAL
C                 TABLES, 1962, PAGE 304.
C               --CATHERINE LOADER (2000), "FAST AND ACCURATE COMPUTATION
C                 OF BINOMIAL PROBABILITIES", BELL LABS?
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --MARCH     2009. USE CATHERINE LOADER ALGORITHM
C                                       (THIS IS IMPLEMENTED IN THE
C                                       BINRAW ROUTINE, WHICH IS A
C                                       FORTRAN IMPLEMENTATION OF THE
C                                       ORIGINAL C CODES OF LOADER)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      CHARACTER*4 ICASE
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA EPS/0.0000001D0/
C
C-----START POINT-----------------------------------------------------
C
      PDF=0.0D0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0D0.OR.P.GT.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   11 FORMAT('***** ERROR--THE SECOND ARGUMENT TO NBPDF IS OUTSIDE ',
     1'THE ALLOWABLE (0,1) INTERVAL')
C
      IF(X.LT.0.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO NBPDF IS NEGATIVE.')
C
      IF(AN.LT.0.0D0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AN
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE THIRD ARGUMENT TO NBPDF IS NEGATIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IX=INT(X+EPS)
      Q=1.0D0 - P
      ILOG=0
C
      CALL BINRAW(AN,P,Q,DBLE(IX)+AN,ANS,ILOG)
      DP=AN/(AN+X)
      IF(ILOG.EQ.1)THEN
        PDF=LOG(DP)+ANS
      ELSE
        PDF=DP*ANS
      ENDIF
C
 9000 CONTINUE
      RETURN
C
      END
      SUBROUTINE NBPPF(P,PPAR,AN,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT FUNCTION VALUE
C              AT THE DOUBLE PRECISION VALUE P FOR THE NEGATIVE BINOMIAL
C              DISTRIBUTION WITH DOUBLE PRECISION 'BERNOULLI PROBABILITY'
C              PARAMETER = PPAR, AND DOUBLE PRECISION 'NUMBER OF
C              SUCCESSES IN BERNOULLI TRIALS' PARAMETER = N.  THE
C              NEGATIVE BINOMIAL DISTRIBUTION USED HEREIN HAS
C              MEAN = N*(1-PPAR)/PPAR AND STANDARD DEVIATION =
C              SQRT(N*(1-PPAR)/(PPAR*PPAR))).  THIS DISTRIBUTION IS DEFINED
C              FOR ALL NON-NEGATIVE INTEGER X--X = 0, 1, 2, ... .
C              THIS DISTRIBUTION HAS THE PROBABILITY MASS FUNCTION
C
C                  p(X;P,N) = C(N+X-1,N) * P**N * (1-P)**X.
C
C              WHERE C(N+X-1,N) IS THE COMBINATORIAL FUNCTION
C              EQUALING THE NUMBER OF COMBINATIONS OF N+X-1 ITEMS
C              TAKEN N AT A TIME.  THE NEGATIVE BINOMIAL DISTRIBUTION
C              IS THE DISTRIBUTION OF THE NUMBER OF FAILURES BEFORE
C              OBTAINING N SUCCESSES IN AN INDEFINITE SEQUENCE OF
C              BERNOULLI (0,1) CTRIALS WHERE THE PROBABILITY OF
C              SUCCESS IN A SINGLE TRIAL = P.
C
C              THE NEGATIVE BINOMIAL CAN BE EXTENDED TO THE
C              CASE WHERE N IS POSITIVE REAL NUMBER (I.E., NOT
C              RESTRICTED TO AN INTEGER).  IN THAT CASE, THE
C              PROBABILITY FUNCTION IS:
C
C              F(X) = P**N * (1-P)**X * GAMMA(N+X)/(GAMMA(N)*X!)
C
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE DOUBLE PRECISION VALUE (BETWEEN
C                                0.0 (INCLUSIVELY) AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT FUNCTION IS
C                                TO BE EVALUATED.
C                     --PPAR   = THE DOUBLE PRECISION VALUE OF THE
C                                'BERNOULLI PROBABILITY' PARAMETER.
C                     --AN     = THE DOUBLE PRECISION VALUE OF THE
C                                'NUMBER OF SUCCESSES IN BERNOULLI
C                                TRIALS' PARAMETER.
C     OUTPUT ARGUMENTS--PPF    = THE DOUBLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUE PPF
C             FOR THE NEGATIVE BINOMIAL DISTRIBUTION WITH PARAMETERS
C             PPAR AND AN.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--PPAR SHOULD BE BETWEEN 0.0 (EXCLUSIVELY) AND
C                   1.0 (EXCLUSIVELY).
C                 --AN SHOULD BE A POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NORPPF, NBCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT, EXP, LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION AND DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--NOTE THAT EVEN THOUGH THE OUTPUT FROM THIS DISCRETE
C              DISTRIBUTION PERCENT POINT FUNCTION SUBROUTINE MUST
C              NECESSARILY BE A DISCRETE INTEGER VALUE, THE OUTPUT
C              VARIABLE PPF IS DOUBLE PRECISION IN MODE.
C     REFERENCES--JOHNSON AND KOTZ, DISCRETE
C                 DISTRIBUTIONS, 1969, PAGES 122-142,
C                 ESPECIALLY PAGE 127, FORMULA 22.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGES 92-95.
C               --NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 929.
C               --FELLER, AN INTRODUCTION TO PROBABILITY
C                 THEORY AND ITS APPLICATIONS, VOLUME 1,
C                 EDITION 2, 1957, PAGES 155-157, 210.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGES 130-131.
C               --WILLIAMSON AND BRETHERTON, TABLES OF
C                 THE NEGATIVE BINOMIAL PROBABILITY
C                 DISTRIBUTION, 1963.
C               --OWEN, HANDBOOK OF STATISTICAL
C                 TABLES, 1962, PAGE 304.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --OCTOBER   1978.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     2004. EXTENDED TO SUPPORT
C                                       NON-INTEGER VALUES FOR N
C     UPDATED         --MARCH     2009. CONVERT TO DOUBLE PRECISION
C     UPDATED         --MARCH     2009. IMPROVED INITIAL APPROXIMATION
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PPF=0.0D0
      IF(P.LT.0.0D0.OR.P.GE.1.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(PPAR.LE.0.0D0.OR.PPAR.GT.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)PPAR
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(AN.LE.0.0D0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)AN
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9000
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO NBPPF IS OUTSIDE ',
     1       'THE ALLOWABLE (0,1) INTERVAL.')
   11 FORMAT('***** ERROR--THE SECOND ARGUMENT TO NBPPF IS OUTSIDE ',
     1       'THE ALLOWABLE (0,1) INTERVAL.')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO NBPPF IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      N=INT(AN+0.000001D0)
      DPPAR=PPAR
      PPF=0.0D0
      IX0=0
      IX1=0
      IX2=0
      P0=0.0D0
      P1=0.0D0
      P2=0.0D0
C
C     TREAT CERTAIN SPECIAL CASES IMMEDIATELY--
C     1) P = 0.0
C     2) P = 0.5 AND PPAR = 0.5
C     3) PPF = 0
C     4) PPAR = 0
C
      IF(P.EQ.0.0D0)THEN
        PPF=0.0D0
        GOTO9000
      ELSEIF(PPAR.EQ.1.0D0)THEN
        PPF=0.0D0
        GOTO9000
      ELSEIF(P.EQ.0.5D0.AND.PPAR.EQ.0.5D0)THEN
        PPF=DBLE(N-1)
        GOTO9000
      ELSE
        PF0=PPAR**AN
        IF(P.LE.PF0)THEN
          PPF=0.0D0
          GOTO9000
        ENDIF
      ENDIF
C
C     DETERMINE AN INITIAL APPROXIMATION TO THE NEGATIVE BINOMIAL
C     PERCENT POINT BY USE OF THE HYPERBOLIC ARCSIN
C     TRANSFORMATION OF THE NEGATIVE BINOMIAL
C     TO APPROXIMATE NORMALITY.
C     (SEE JOHNSON AND KOTZ, DISCRETE DISTRIBUTIONS,
C     PAGE 127, FORMULA 22).
C
      AMEAN=AN*(1.0D0-PPAR)/PPAR
      SD=SQRT(AN*(1.0D0-PPAR)/(PPAR*PPAR))
      ARG=SQRT((AMEAN+0.375D0)/(AN-0.75D0))
      ARCSH=LOG(ARG+SQRT(ARG*ARG+1.0D0))
      YMEAN=(SQRT(AN-0.5D0))*ARCSH
      YSD=0.5D0
      CALL NODPPF(P,ZPPF)
      YPPF=YMEAN+ZPPF*YSD
      ARG=YPPF/SQRT(AN-0.5D0)
      E=EXP(ARG)
      SINH=(E-1.0D0/E)/2.0D0
      X2=-0.375D0+(AN-0.75D0)*SINH*SINH
      X2=X2+0.5D0
      IX2=X2
C
C     CHECK AND MODIFY (IF NECESSARY) THIS INITIAL
C     ESTIMATE OF THE PERCENT POINT
C     TO ASSURE THAT IT BE NON-NEGATIVE.
C
      IF(IX2.LT.0)IX2=0
C
C     DETERMINE UPPER AND LOWER BOUNDS ON THE DESIRED
C     PERCENT POINT BY ITERATING OUT (BOTH BELOW AND ABOVE)
C     FROM THE ORIGINAL APPROXIMATION AT STEPS
C     OF 1 STANDARD DEVIATION.
C     THE RESULTING BOUNDS WILL BE AT MOST
C     1 STANDARD DEVIATION APART.
C
      IX0=0
      IX1=INT(10.0D0**7 + 0.01D0)
      ISD=INT(SD+1.0D0)
      X2=DBLE(IX2)
      CALL NBCDF(X2,PPAR,AN,P2)
C
      IF(P2.LT.P)GOTO210
      GOTO250
C
  210 CONTINUE
      IX0=IX2
      I=1
  215 CONTINUE
      IX2=IX0+ISD
      IF(IX2.GE.IX1)GOTO275
      X2=IX2
      CALL NBCDF(X2,PPAR,AN,P2)
      IF(P2.GE.P)GOTO230
      IX0=IX2
  220 CONTINUE
      I=I+1
      IF(I.LE.1000000)GOTO215
      WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,222)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  230 IX1=IX2
      GOTO275
C
  250 CONTINUE
      IX1=IX2
      I=1
  255 CONTINUE
      IX2=IX1-ISD
      IF(IX2.LE.IX0)GOTO275
      X2=IX2
      CALL NBCDF(X2,PPAR,AN,P2)
      IF(P2.LT.P)GOTO270
      IX1=IX2
  260 CONTINUE
      I=I+1
      IF(I.LE.1000000)GOTO255
      WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,262)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  270 IX0=IX2
C
  275 IF(IX0.EQ.IX1)GOTO280
      GOTO295
  280 IF(IX0.EQ.0)GOTO285
      IF(IX0.EQ.N)GOTO290
      WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,282)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  285 IX1=IX1+1
      GOTO295
  290 IX0=IX0-1
  295 CONTINUE
C
C     COMPUTE NEGATIVE BINOMIAL PROBABILITIES FOR THE
C     DERIVED LOWER AND UPPER BOUNDS.
C
      X0=IX0
      X1=IX1
      CALL NBCDF(X0,PPAR,AN,P0)
      CALL NBCDF(X1,PPAR,AN,P1)
C
C     CHECK THE PROBABILITIES FOR PROPER ORDERING
C
      IF(P0.LT.P.AND.P.LE.P1)GOTO490
      IF(P0.EQ.P)GOTO410
      IF(P1.EQ.P)GOTO420
      IF(P0.GT.P1)GOTO430
      IF(P0.GT.P)GOTO440
      IF(P1.LT.P)GOTO450
      WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,401)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  410 PPF=IX0
      GOTO9000
  420 PPF=IX1
      GOTO9000
  430 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,431)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  440 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,441)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  450 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,451)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  490 CONTINUE
C
C     THE STOPPING CRITERION IS THAT THE LOWER BOUND
C     AND UPPER BOUND ARE EXACTLY 1 UNIT APART.
C     CHECK TO SEE IF IX1 = IX0 + 1;
C     IF SO, THE ITERATIONS ARE COMPLETE;
C     IF NOT, THEN BISECT, COMPUTE PROBABILIIES,
C     CHECK PROBABILITIES, AND CONTINUE ITERATING
C     UNTIL IX1 = IX0 + 1.
C
  300 IX0P1=IX0+1
      IF(IX1.EQ.IX0P1)GOTO690
      IX2=(IX0+IX1)/2
      IF(IX2.EQ.IX0)GOTO610
      IF(IX2.EQ.IX1)GOTO620
      X2=IX2
      CALL NBCDF(X2,PPAR,AN,P2)
      IF(P0.LT.P2.AND.P2.LT.P1)GOTO630
      IF(P2.LE.P0)GOTO640
      IF(P2.GE.P1)GOTO650
  610 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,611)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  620 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,611)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  630 IF(P2.LE.P)GOTO635
      IX1=IX2
      P1=P2
      GOTO300
  635 IX0=IX2
      P0=P2
      GOTO300
  640 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,641)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  650 WRITE(ICOUT,249)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,651)
      CALL DPWRST('XXX','BUG ')
      GOTO950
  690 PPF=IX1
      IF(P0.EQ.P)PPF=IX0
      GOTO9000
C
  950 WRITE(ICOUT,240)IX0,P0
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,241)IX1,P1
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,242)IX2,P2
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,244)P
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,245)PPAR,N
      CALL DPWRST('XXX','BUG ')
      GOTO9000
C
  222 FORMAT('NO UPPER BOUND FOUND AFTER 10**7 ITERATIONS')
  240 FORMAT('IX0  = ',I8,10X,'P0 = ',F14.7)
  241 FORMAT('IX1  = ',I8,10X,'P1 = ',F14.7)
  242 FORMAT('IX2  = ',I8,10X,'P2 = ',F14.7)
  244 FORMAT('P    = ',F14.7)
  245 FORMAT('PPAR = ',F14.7,10X,'N  = ',I8)
  249 FORMAT('***** INTERNAL ERROR IN NBPPF  SUBROUTINE *****')
  262 FORMAT('NO LOWER BOUND FOUND AFTER 10**7 ITERATIONS')
  282 FORMAT('LOWER AND UPPER BOUND IDENTICAL')
  401 FORMAT('IMPOSSIBLE BRANCH CONDITION ENCOUNTERED')
  431 FORMAT('LOWER BOUND PROBABILITY (P0) GREATER THAN ',
     1 'UPPER BOUND PROBABILITY (P1)')
  441 FORMAT('LOWER BOUND PROBABILITY (P0) GREATER THAN ',
     1 21HINPUT PROBABILITY (P))
  451 FORMAT('UPPER BOUND PROBABILITY (P1) LESS    THAN ',
     1 'INPUT PROBABILITY (P)')
  611 FORMAT('BISECTION VALUE (X2) = LOWER BOUND (X0)')
  621 FORMAT('BISECTION VALUE (X2) = UPPER BOUND (X1)')
  641 FORMAT('BISECTION VALUE PROBABILITY (P2) ',
     1 'LESS THAN LOWER BOUND PROBABILITY (P0)')
  651 FORMAT('BISECTION VALUE PROBABILITY (P2) ',
     1 'GREATER THAN UPPER BOUND PROBABILITY (P1)')
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NBRAN(N,P,AK,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE NEGATIVE BINOMIAL DISTRIBUTION
C              WITH SINGLE PRECISION 'BERNOULLI PROBABILITY'
C              PARAMETER = P,
C              AND INTEGER 'NUMBER OF SUCCESSES IN BERNOULLI TRIALS'
C              PARAMETER = K.
C              THE NEGATIVE BINOMIAL DISTRIBUTION USED
C              HEREIN HAS MEAN = K*(1-P)/P
C              AND STANDARD DEVIATION = SQRT(K*(1-P)/(P*P))).
C              THIS DISTRIBUTION IS DEFINED FOR
C              ALL NON-NEGATIVE INTEGER X--X = 0, 1, 2, ... .
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              F(X) = C(K+X-1,K) * P**K * (1-P)**X.
C              WHERE C(K+X-1,K) IS THE COMBINATORIAL FUNCTION
C              EQUALING THE NUMBER OF COMBINATIONS OF K+X-1 ITEMS
C              TAKEN K AT A TIME.
C              THE NEGATIVE BINOMIAL DISTRIBUTION IS THE
C              DISTRIBUTION OF THE NUMBER OF FAILURES
C              BEFORE OBTAINING K SUCCESSES IN AN
C              INDEFINITE SEQUENCE OF BERNOULLI (0,1)
C              TRIALS WHERE THE PROBABILITY OF SUCCESS
C              IN A SINGLE TRIAL = P.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --P      = THE SINGLE PRECISION VALUE
C                                OF THE 'BERNOULLI PROBABILITY'
C                                PARAMETER FOR THE NEGATIVE BINOMIAL
C                                DISTRIBUTION.
C                                P SHOULD BE BETWEEN
C                                0.0 (EXCLUSIVELY) AND
C                                1.0 (EXCLUSIVELY).
C                     --K      = THE INTEGER VALUE
C                                OF THE 'NUMBER OF SUCCESSES
C                                IN BERNOULLI TRIALS' PARAMETER.
C                                K SHOULD BE A POSITIVE INTEGER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NEGATIVE BINOMIAL DISTRIBUTION
C             WITH 'BERNOULLI PROBABILITY' PARAMETER = P
C             AND 'NUMBER OF SUCCESSES IN BERNOULLI TRIALS'
C             PARAMETER = K.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C                 --K SHOULD BE A POSITIVE INTEGER.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, BINRAN, GEORAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     COMMENT--NOTE THAT EVEN THOUGH THE OUTPUT
C              FROM THIS DISCRETE RANDOM NUMBER
C              GENERATOR MUST NECESSARILY BE A
C              SEQUENCE OF ***INTEGER*** VALUES,
C              THE OUTPUT VECTOR X IS SINGLE
C              PRECISION IN MODE.
C              X HAS BEEN SPECIFIED AS SINGLE
C              PRECISION SO AS TO CONFORM WITH THE DATAPAC
C              CONVENTION THAT ALL OUTPUT VECTORS FROM ALL
C              DATAPAC SUBROUTINES ARE SINGLE PRECISION.
C              THIS CONVENTION IS BASED ON THE BELIEF THAT
C              1) A MIXTURE OF MODES (FLOATING POINT
C              VERSUS INTEGER) IS INCONSISTENT AND
C              AN UNNECESSARY COMPLICATION
C              IN A DATA ANALYSIS; AND
C              2) FLOATING POINT MACHINE ARITHMETIC
C              (AS OPPOSED TO INTEGER ARITHMETIC)
C              IS THE MORE NATURAL MODE FOR DOING
C              DATA ANALYSIS.
C     REFERENCES--HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 95.
C               --JOHNSON AND KOTZ, DISCRETE
C                 DISTRIBUTIONS, 1969, PAGES 122-142.
C               --FELLER, AN INTRODUCTION TO PROBABILITY
C                 THEORY AND ITS APPLICATIONS, VOLUME 1,
C                 EDITION 2, 1957, PAGES 155-157, 210.
C               --NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 929.
C               --KENDALL AND STUART, THE ADVANCED THEORY OF
C                 STATISTICS, VOLUME 1, EDITION 2, 1963, PAGES 130-131.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MARCH     2004. SUPPORT FOR NON-INTEGER K
C     UPDATED         --MARCH     2004. ALGORITHM FOR MODERATE TO
C                                       LARGE K APPEARS WRONG (STARTS
C                                       AT X>=K, I.E., BASED ON
C                                       ALTERNATIVE DEFINITION OF
C                                       NEGATIVE BINOMIAL.
C                                       REPLACE CURRENT ALGORITHM
C                                       WITH CODE FROM ALAN MILLER
C                                       BASED ON J. DAGPUNAR,
C                                       "PRINCIPLES OF RANDOM VARIATE
C                                       GENERATION", CLARENDON PRESS,
C                                       OXFORD, 1988.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      REAL X(*)
C
COLD  DIMENSION B(2)
COLD  DIMENSION G(2)
C
      REAL H
      REAL Q
      REAL XTEMP
      REAL ST
      REAL AK
      REAL ULN
      REAL V
      REAL R(1)
      REAL S
      REAL Y
      REAL G
      INTEGER K
      INTEGER I
      INTEGER NTEMP
      INTEGER NUNI
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(P.LE.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(AK.LE.0.0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)K
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE NUMBER OF REQUESTED NEGATIVE ',
     1'BINOMIAL RANDOM NUMBERS IS NON-POSITIVE.')
   11 FORMAT('***** ERROR--THE FIRST SHAPE PARAMETER FOR THE ',
     1'NEGATIVE BINOMIAL IS OUTSIDE THE (0,1) INTERVAL')
   25 FORMAT('***** ERROR--THE SECOND SHAPE PARAMETER FOR THE ',
     1'NEGATIVE BINOMIAL IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C
C
C     REPLACE FOLLOWING ALGORITHM WITH ONE THAT CAN ACCOMODATE
C     REAL VALUES FOR K.
C
C     CHECK ON THE MAGNITUDE OF P,
C     AND BRANCH TO THE FASTER
C     GENERATION METHOD ACCORDINGLY.
C
COLD  IF(P.LT.0.1)GOTO450
C
C     IF P IS MODERATE OR LARGE,
C     GENERATE N NEGATIVE BINOMIAL NUMBERS
C     USING THE FACT THAT THE
C     WAITING TIME FOR K SUCCESSES IN
C     BERNOULLI TRIALS HAS A
C     NEGATIVE BINOMIAL DISTRIBUTION.
C
COLD  DO100I=1,N
COLD  ISUM=0
COLD  J=1
CO150 CALL BINRAN(1,P,1,ISEED,B)
COLD  IB=B(1)+0.5
COLD  ISUM=ISUM+IB
COLD  IF(ISUM.EQ.K)GOTO250
COLD  J=J+1
COLD  GOTO150
CO250 X(I)=J
CO100 CONTINUE
COLD  RETURN
C
C     IF P IS SMALL,
C     GENERATE N NEGATIVE BINOMIAL NUMBERS
C     BY USING THE FACT THAT THE SUM
C     OF GEOMETRIC VARIATES IS A
C     NEGATIVE BINOMIAL VARIATE.
C
CO450 DO500I=1,N
COLD  ISUM=0
COLD  DO600J=1,K
COLD  CALL GEORAN(1,P,ISEED,G)
COLD  IG=G(1)+0.5
COLD  ISUM=ISUM+IG
CO600 CONTINUE
COLD  X(I)=ISUM
CO500 CONTINUE
C
C     THIS ALGORITHM REVERSES THE ROLE OF P AND Q AS
C     USED IN DATAPLOT.
C
      NUNI=1
      Q=P
      P2=1.0-Q
      H=0.7
C
      DO600I=1,N
C
        XTEMP=0.0
        ST=AK
C
        IF(P2.GT.H)THEN
          V=1.0/LOG(P2)
          K=ST + 0.0000001
          DO610ITEMP=1,K
  620       CONTINUE
            CALL UNIRAN(NUNI,ISEED,R)
            IF(R(1).LE.0.0)GOTO620
            NTEMP=V*LOG(R(1))
            XTEMP=XTEMP+NTEMP
  610     CONTINUE
          ST=ST-K
        ENDIF
C
        S=0.0
        ULN=-LOG(R1MACH(1))
        IF(ST.GT.-ULN/LOG(Q))THEN
          WRITE(ICOUT,691)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,692)P2,AK
          CALL DPWRST('XXX','BUG ')
          GOTO9000
        ENDIF
        Y=Q**ST
        G=ST
        CALL UNIRAN(NUNI,ISEED,R)
  630   CONTINUE
        IF(Y.LE.R(1))THEN
          R(1)=R(1)-Y
          S=S+1.0
          Y=Y*P2*G/S
          G=G+1.0
          GOTO630
        ENDIF
        X(I)=XTEMP+S
  600 CONTINUE
C
  691 FORMAT('***** ERROR IN NEGATIVE BINOMIAL RANDOM NUMBERS--')
  692 FORMAT('      THE VALUE OF P (',F10.5,') IS TOO LARGE FOR THE ',
     1       'VALUE OF K (',F10.5,')')
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NCBCDF(XSNGL, ASNGL, BSNGL, LAMBDS, CDF)
C
C     ALGORITHM AS226 APPL. STATIST. (1987) VOL. 36, NO. 2
C     Incorporates modification AS R84 from AS vol. 39, pp311-2, 1990
C
C     Returns the cumulative probability of X for the non-central beta
C     distribution with parameters A, B and non-centrality LAMBDA
C
C     Auxiliary routines required: DLNGAM - log-gamma function (ACM
C     291 or AS 245), and BETAIN - incomplete-beta function (AS 63)
C
      REAL  XSNGL, ASNGL, BSNGL, LAMBDS, CDF
      DOUBLE PRECISION A, AX, B, BETA, C, ERRBD, ERRMAX, GX, HALF, 
     *                 LAMBDA, ONE, Q, SUMQ, TEMP, X, XJ, ZERO
      DOUBLE PRECISION BETANC, A0, X0, UALPHA
      DOUBLE PRECISION DLNGAM
      DOUBLE PRECISION DLBETA
      DOUBLE PRECISION DBETAI
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C     Change ERRMAX and ITRMAX if desired ...
C     MAY 2004. Increase error criterion and number of iterations
C               (to get more accuracy for PDF function)
C
CCCCC DATA ERRMAX, ITRMAX /1.0D-6, 100/, UALPHA /5.0D0/
      DATA ERRMAX, ITRMAX /1.0D-8, 300/, UALPHA /5.0D0/
      DATA ZERO, HALF, ONE /0.0D0, 0.5D0, 1.0D0/
C
      A=DBLE(ASNGL)
      B=DBLE(BSNGL)
      LAMBDA=DBLE(LAMBDS)
      X=DBLE(XSNGL)
      CDF=0.0
C
      IF(A.LE.0.0 .OR. B.LE.0.0)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,103)A
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)B
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(X.LT.0.D0)THEN
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,302)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(X.GT.1.D0)THEN
        WRITE(ICOUT,401)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,402)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(LAMBDA.LT.0.D0)THEN
        WRITE(ICOUT,501)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,503)LAMBDS
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** ERROR--EITHER THE ALPHA OR BETA IS NON-POSITIVE.')
  103 FORMAT('      THE VALUE OF ALPHA IS ',E15.7)
  104 FORMAT('      THE VALUE OF BETA IS ',E15.7,'       ******')
  301 FORMAT('***** ERROR--THE INPUT ARGUMENT IS NON-POSITIVE.')
  302 FORMAT('      IT HAS THE VALUE ',G15.7)
  401 FORMAT('***** ERROR--THE INPUT ARGUMENT IS GREATER THAN 1.')
  402 FORMAT('      IT HAS THE VALUE ',G15.7)
  501 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER IS NEGATIVE.')
  503 FORMAT('      THE VALUE OF LAMBDA IS ',G15.7)
C
      BETANC = X
      CDF=REAL(BETANC)
C
      IF (X .EQ. ZERO .OR. X .EQ. ONE) GOTO9999
C
      C = LAMBDA * HALF
C
C     Initialize the series ...
C
      X0 = INT(MAX(C - UALPHA*SQRT(C), ZERO))
      A0 = A + X0
CCCCC BETA = DLNGAM(A0) + DLNGAM(B) -  DLNGAM(A0+B)
      BETA = DLBETA(A0,B)
      TEMP = DBETAI(X, A0, B)
      GX = EXP(A0 * LOG(X) + B * LOG(ONE - X) - BETA - LOG(A0))
      IF (A0 .GT. A) THEN
        Q = EXP(-C + X0*LOG(C) - DLNGAM(X0 + ONE))
      ELSE
        Q = EXP(-C)
      END IF
      XJ = ZERO
      AX = Q * TEMP
      SUMQ = ONE - Q
      BETANC = AX
C
C     Recur over subsequent terms until convergence is achieved...
C
   10 XJ = XJ + ONE
      TEMP = TEMP - GX
      GX = X * (A + B + XJ - ONE) * GX / (A + XJ)
      Q = Q * C / XJ
      SUMQ = SUMQ - Q
      AX = TEMP * Q
      BETANC = BETANC + AX
C
C     Check for convergence and act accordingly...
C
      ERRBD = (TEMP - GX) * SUMQ
      IF ((INT(XJ) .LT. ITRMAX) .AND. (ERRBD .GT. ERRMAX)) GO TO 10
      IF (ERRBD .GT. ERRMAX) THEN
        WRITE(ICOUT,701)
        CALL DPWRST('XXX','BUG ')
        CDF=REAL(BETANC)
        GOTO9999
      ELSE
        CDF=REAL(BETANC)
        GOTO9999
      ENDIF
  701 FORMAT('***** WARNING--THE BETCDF ROUTINE DID NOT CONVERGE.  ***')
C
 9999 CONTINUE
      RETURN
      END
      REAL FUNCTION NCBFU3(X)
C
C     PURPOSE--NCBPDF CALLS DIFF TO FIND A NUMERICAL DERIVATIVE
C              FOR THE NON-CENTRAL CUMULATIVE DISTRIBUTION FUNCTION.
C              NCBFU3 IS A FUNCTION THAT CALL NCBCDF.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE DERIVATIVE
C                                IS TO BE EVALUATED.
C     OUTPUT--THE SINGLE PRECISION FUNCTION VALUE NCBFU3.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NCBCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATION INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.3
C     ORIGINAL VERSION--APRIL     2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      REAL ALPHA
      REAL BETA
      REAL ALAMB
      COMMON/NCBCOM/ALPHA,BETA,ALAMB
C
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      CALL NCBCDF(X,ALPHA,BETA,ALAMB,CDF)
      NCBFU3=CDF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCBPDF(X, A, B, LAMBDA, PDF)
C
C     PURPOSE--PROBABILITY DENSITY FUNCTION FOR THE NON-CENTRAL
C              BETA DISTRIBUTION.  THE PROBABILITY DENSITY FUNCTION
C              IS COMPUTED BY COMPUTING THE NUMERICAL DERIVATIVE OF
C              THE CUMULATIVE DISTRIBUTION FUNCTION.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --ALPHA  = THE FIRST SHAPE PARAMETER
C                     --BETA   = THE SECOND SHAPE PARAMETER
C                     --LAMBDS = THE NON-CENTRALITY PARAMETER
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DIFF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--LENTH, "COMPUTING NONCENTRAL BETA PROBABILITIES",
C                 APPLIED STATISTICS, VOL. 39, NO. 2, 1987,
C                 PP. 241-244.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/4
C     ORIGINAL VERSION--APRIL     2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL  X
      REAL  A
      REAL  B
      REAL  LAMBDA
      REAL  PDF
C
      REAL NCBFU3
      EXTERNAL NCBFU3
      REAL ALPHA
      REAL BETA
      REAL ALAMB
      COMMON/NCBCOM/ALPHA,BETA,ALAMB
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      PDF=0.0
C
      IF(A.LE.0.0)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)A
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(B.LE.0.0)THEN
        WRITE(ICOUT,102)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)B
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(LAMBDA.LT.0.0)THEN
        WRITE(ICOUT,103)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)LAMBDA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(X.LT.0.0 .OR. X.GT.1.0)THEN
        WRITE(ICOUT,105)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** ERROR--THE FIRST SHAPE PARAMETER FOR THE ',
     1       'NON-CENTRAL BETA PDF IS NON-POSITIVE.')
  102 FORMAT('***** ERROR--THE SECOND SHAPE PARAMETER FOR THE ',
     1       'NON-CENTRAL BETA PDF IS NON-POSITIVE.')
  103 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER FOR THE ',
     1       'NON-CENTRAL BETA PDF IS NEGATIVE.')
  104 FORMAT('      THE VALUE OF THE PARAMETER IS ',G15.7)
  105 FORMAT('***** ERROR--THE INPUT ARGUMENT FOR THE NON-CENTRAL ',
     1       'BETA PDF IS OUTSIDE THE (0,1) INTERVAL')
C
C  USE NON-CENTRAL F PDF FUNCTION
C
C  NOTE: THIS RELATIONSHIP APPLIES TO CDF FUNCTION, NOT CLEAR
C        THAT IT APPLIES TO PDF (DO NOT GET CONSISTENT ANSWERS).
C
CCCCC DF2=2.0*B
CCCCC DF2=2.0*B
CCCCC XTEMP=X*DF2/(DF1 - X*DF1)
CCCCC CALL NCFPDF(XTEMP,DF1,DF2,ALAMB,PDF)
CCCCC GOTO9999
C
C  FIND NUMERIC DERIVATIVE OF CDF ROUTINE
C
      IFAIL=0
      IORD=1
      EPS=0.001
      ACCUR=0.0
      IFAIL=0
      X0 = X
      XMIN=0.0
      XMAX=1.0
      ALPHA=A
      BETA=B
      ALAMB=LAMBDA
C
      CALL DIFF(IORD,X0,XMIN,XMAX,NCBFU3,EPS,ACCUR,PDF,ERROR,IFAIL)
C
      IF(IFAIL.EQ.1)THEN
  999     FORMAT(1X)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,301)
  301   FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR NCBPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,303)
  303   FORMAT('      THE ESTIMATED ERROR IN THE RESULT EXCEEDS THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,305)
  305   FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE RESULT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,307)
  307   FORMAT('      POSSIBLE HAS BEEN RETURNED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFAIL.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,311)
  311   FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR NCBPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,313)
  313   FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(IFAIL.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,321)
  321   FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR NCBPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,323)
  323   FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1         ',',G15.7,')')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,325)
  325   FORMAT('      IS TOO SMALL.')
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
C
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCBPPF(P,ALPHA,BETA,LAMBDA,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE NON-CENTRAL BETA
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--82/7
C     ORIGINAL VERSION--JULY      1981.
C     UPDATED         --FEBRUARY  1982.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
CCCCC DOUBLE PRECISION DCDF
CCCCC DOUBLE PRECISION DALPHA
CCCCC DOUBLE PRECISION DBETA
CCCCC DOUBLE PRECISION DX
CCCCC DOUBLE PRECISION DBETAI
      REAL LAMBDA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA EPS /0.0001/
      DATA SIG /1.0E-5/
      DATA ZERO /0./
      DATA MAXIT /100/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GT.1.0)GOTO50
      IF(ALPHA.LE.0.0)GOTO55
      IF(BETA.LE.0.0)GOTO60
      IF(LAMBDA.LT.0.0)GOTO70
      GOTO90
   50 WRITE(ICOUT,1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   55 WRITE(ICOUT,11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)ALPHA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   60 WRITE(ICOUT,25)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)BETA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      GOTO9999
   70 WRITE(ICOUT,35)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)LAMBDA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      GOTO9999
C
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO ',
     1       'NCBPPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   11 FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1       'NCBPPF IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1       ' NCBPPF IS NON-POSITIVE')
   35 FORMAT('***** ERROR--THE FOURTH ARGUMENT TO ',
     1       'NCBPPF SUBROUTINE IS NEGATIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
   90 CONTINUE
C
      A = ALPHA
      B = BETA
C
      IERR=0
      IC = 0
      AB = A/B
      XL = 0.0
      XR = 1.0
      FXL = -P
      FXR = 1.0 - P
CCCCC INVALID P EXPLICITLY CHECKED FOR EARLIER.
      IF(FXL*FXR .GT. ZERO)GOTO50
C
C  BISECTION METHOD
C
  105 CONTINUE
      X = (XL+XR)*0.5
      CALL NCBCDF(X,ALPHA,BETA,LAMBDA,CDF)
      P1=CDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS 
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** FATAL ERROR--NCBPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCBRAN(N,ALPHA,BETA,ALAMB,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE NON-CENTRAL BETA DISTRIBUTION WITH SHAPE
C              PARAMETERS ALPHA AND BETA AND NON-CENTRALITY
C              PARAMETER LAMBDA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --ALPHA  = THE SINGLE PRECISION VALUE OF THE
C                                FIRST  SHAPE PARAMETER.
C                     --BETA   = THE SINGLE PRECISION VALUE OF THE
C                                SECOND SHAPE PARAMETER.
C                     --ALAMB  = THE SINGLE PRECISION VALUE OF THE
C                                NON-CENTRALITY PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NON-CENTRAL BETA DISTRIBUTION
C             WITH SHAPE PARAMETER VALUES = ALPHA, BETA, AND ALAMB.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --ALPHA AND BETA  SHOULD BE POSITIVE.
C                 --ALAMB  SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NCCRAN, CHSRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS VOLUME 2", SECOND EDITION,
C                 1994, PAGES 502-503.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.5
C     ORIGINAL VERSION--MAY       2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF NON-CENTRAL BETA ',
     1' RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ALPHA.LE.0.0)THEN
        WRITE(ICOUT,16)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   16 FORMAT('***** ERROR--THE SHAPE PARAMETER ALPHA FOR THE ',
     1'NON-CENTRAL BETA RANDOM NUMBERS IS NON-POSITIVE.')
      IF(BETA.LE.0.0)THEN
        WRITE(ICOUT,26)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)BETA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   26 FORMAT('***** ERROR--THE SHAPE PARAMETER BETA FOR THE ',
     1'NON-CENTRAL BETA RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ALAMB.LT.0.0)THEN
        WRITE(ICOUT,36)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALAMB
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   36 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER LAMBDA FOR ',
     1'THE NON-CENTRAL BETA RANDOM NUMBERS IS NEGATIVE.')
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C     USE THE CENTRAL AND NON-CENTRAL CHI-SQUARE RANDOM NUMBER
C     ROUTINE TO GENERATE NON-CENTRAL BETA RANDOM NUMBERS.
C
C     NCB = NCCHISQ(NU1,LAMBDA)/(NCCHISQ(NU1,LAMBDA)+CHISQUARE(NU2))
C
      ANU1=ALPHA
      ANU2=BETA
      NTEMP=1
      DO100I=1,N
        CALL NCCRAN(NTEMP,ANU1,ALAMB,ISEED,XTEMP)
        TERM1=XTEMP(1)
        CALL CHSRAN(NTEMP,ANU2,ISEED,XTEMP)
        TERM2=XTEMP(1)
        X(I)=TERM1/(TERM1+TERM2)
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NCVSRT( N, LOWER, UPPER, CORREL, INFIN, Y, INFIS, 
     &                   A, B, INFI, COV, D, E )
*
*     Subroutine to sort integration limits.
*
      INTEGER N, INFI(*), INFIN(*), INFIS
      DOUBLE PRECISION 
     &     A(*), B(*), COV(*), LOWER(*), UPPER(*), CORREL(*), Y(*), D, E
      INTEGER I, J, K, IJ, II, JMIN
      DOUBLE PRECISION SUMSQ, ZERO
      PARAMETER ( ZERO = 0 )
      DOUBLE PRECISION AJ, BJ, SUM, SQTWPI
      DOUBLE PRECISION CVDIAG, AMIN, BMIN, DMIN, EMIN, YL, YU
      PARAMETER ( SQTWPI = 2.50662 82746 31000 50240 )
      IJ = 0
      II = 0
      INFIS = 0
      DO 100 I = 1,N
         INFI(I) = INFIN(I) 
         IF ( INFI(I) .LT. 0 ) THEN
            INFIS = INFIS + 1
         ELSE 
            A(I) = 0
            B(I) = 0
            IF ( INFI(I) .NE. 0 ) A(I) = LOWER(I)
            IF ( INFI(I) .NE. 1 ) B(I) = UPPER(I)
         ENDIF
         DO 200 J = 1,I-1
            IJ = IJ + 1
            II = II + 1
            COV(IJ) = CORREL(II)
  200    CONTINUE
         IJ = IJ + 1
         COV(IJ) = 1
  100 CONTINUE
*
*     First move any doubly infinite limits to innermost positions
*
      IF ( INFIS .LT. N ) THEN
         DO 300 I = N,N-INFIS+1,-1
            IF ( INFI(I) .GE. 0 ) THEN 
               DO 400 J = 1,I-1
                  IF ( INFI(J) .LT. 0 ) THEN
                     CALL RCSWAP(J, I, A, B, INFI, N, COV)
                     GO TO 300
                  ENDIF
 400           CONTINUE
            ENDIF
 300     CONTINUE
*
*     Sort remaining limits and determine Cholesky decomposition
*
         II = 0
         DO 500 I = 1,N-INFIS
*
*     Determine the integration limits for variable with minimum
*      expected probability and interchange that variable with Ith.
*
            EMIN = 1
            DMIN = 0
            JMIN = I
            CVDIAG = 0
            IJ = II
            DO 600 J = I, N-INFIS
               SUM = 0
               SUMSQ = 0
               DO 700 K = 1, I-1
                  SUM = SUM + COV(IJ+K)*Y(K)
                  SUMSQ = SUMSQ + COV(IJ+K)**2
  700          CONTINUE
               IJ = IJ + J 
               SUMSQ = SQRT( MAX( COV(IJ)-SUMSQ, ZERO ) )
               IF ( SUMSQ .GT. 0 ) THEN
                  IF ( INFI(J) .NE. 0 ) AJ = ( A(J) - SUM )/SUMSQ
                  IF ( INFI(J) .NE. 1 ) BJ = ( B(J) - SUM )/SUMSQ
                  CALL LIMITS( AJ, BJ, INFI(J), D, E )
                  IF ( EMIN - DMIN .GE. E - D ) THEN
                     JMIN = J
                     IF ( INFI(J) .NE. 0 ) AMIN = AJ 
                     IF ( INFI(J) .NE. 1 ) BMIN = BJ
                     DMIN = D
                     EMIN = E
                     CVDIAG = SUMSQ
                  ENDIF
               ENDIF
  600       CONTINUE
            IF ( JMIN .NE. I) CALL RCSWAP(I, JMIN, A, B, INFI, N, COV)
*
*     Compute Ith column of Cholesky factor.
*
            IJ = II + I
            COV(IJ) = CVDIAG
            DO 800 J = I+1, N-INFIS               
               IF ( CVDIAG .GT. 0 ) THEN
                  SUM = COV(IJ+I)
                  DO 900 K = 1, I-1
                     SUM = SUM - COV(II+K)*COV(IJ+K)
  900             CONTINUE
                  COV(IJ+I) = SUM/CVDIAG
               ELSE
                  COV(IJ+I) = 0
               ENDIF
               IJ = IJ + J
  800       CONTINUE
*
*     Compute expected value for Ith integration variable and
*     scale Ith covariance matrix row and limits.
*
            IF ( CVDIAG .GT. 0 ) THEN
               IF ( EMIN .GT. DMIN + 1D-8 ) THEN
                  YL = 0
                  YU = 0
                  IF ( INFI(I) .NE. 0 ) YL = -EXP( -AMIN**2/2 )/SQTWPI
                  IF ( INFI(I) .NE. 1 ) YU = -EXP( -BMIN**2/2 )/SQTWPI
                  Y(I) = ( YU - YL )/( EMIN - DMIN )
               ELSE
                  IF ( INFI(I) .EQ. 0 ) Y(I) = BMIN
                  IF ( INFI(I) .EQ. 1 ) Y(I) = AMIN
                  IF ( INFI(I) .EQ. 2 ) Y(I) = ( AMIN + BMIN )/2
               END IF
               DO 910 J = 1,I
                  II = II + 1
                  COV(II) = COV(II)/CVDIAG
  910          CONTINUE
               IF ( INFI(I) .NE. 0 ) A(I) = A(I)/CVDIAG
               IF ( INFI(I) .NE. 1 ) B(I) = B(I)/CVDIAG
            ELSE
               Y(I) = 0
               II = II + I
            ENDIF
  500    CONTINUE
         CALL LIMITS( A(1), B(1), INFI(1), D, E)
      ENDIF
C
      RETURN
      END
      SUBROUTINE NCCCDF(X, DF, FL, CDF)
C UKC NETLIB DISTRIBUTION COPYRIGHT 1990 RSS
C
C
C<<<<<  Acquired in machine-readable form from 'Applied Statistics'
C<<<<<  algorithms editor, January 1983.
C
C
C        ALGORITHM AS 170  APPL. STATIST. (1981) VOL.30, NO.3
C
C        The non-central chi-squared distribution.
C
C     Auxiliary routines required: GAMMDS = AS147, ALOGAM = CACM 291.
C     See AS245 for an alternative to ALOGAM.
C
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DGAMIP
      DOUBLE PRECISION DARG1
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C        TEST FOR ADMISSIBILITY OF ARGUMENTS
C
      IF (DF.LE.0.0) THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,302)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF (FL.LT.0.0)THEN
        WRITE(ICOUT,401)
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** ERROR--THE DEGREES OF FREEDOM PARAMETER FOR NCCCDF '
     1      ,'IS NON-POSITIVE. ****')
  301 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO NCCCDF IS ')
  302 FORMAT('      NON-POSITIVE.  IT HAS THE VALUE ',E15.7)
  401 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER TO NCCCDF ',
     1       'IS NEGATIVE. ****')
C
C
      CDF = 0.0
      IF(X.EQ.0.0)GOTO9999
      DF2 = 0.5*DF
      X2 = 0.5*X
CCCCC FXP = GAMMDS(X2,DF2,IFAULT)
      DARG1=DGAMIP(DBLE(DF2),DBLE(X2))
      FXP=REAL(DARG1)
      CALL NCCCHI(X2,DF2,FL,FXP,CDF)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCCCHI(X, DF, FL, FXC, CHI)
C
C        ALGORITHM AS 170.2  APPL. STATIST. (1981) VOL.30, NO.3
C
C        (ROUTINE USED BY NCCCDF AND NCCNCP)
      PARAMETER (ACC2 = 1.0E-8)
      DOUBLE PRECISION DGAMIP
      DOUBLE PRECISION DARG1
C
      CHI = FXC
      DF1 = DF
      FL2 = 0.5*FL
      C = 1.0
      T = 0.0
    1 CONTINUE
      T = T+1.0
      C = C*FL2/T
      DF1 = DF1+1.0
CCCCC TERM = C*GAMMDS(X, DF1, IFAULT)
      DARG1=DGAMIP(DBLE(DF1),DBLE(X))
      TERM = C*REAL(DARG1)
      CHI = CHI+TERM
      IF (TERM.GE.ACC2) GO TO 1
      CHI = CHI*EXP(-FL2)
C
      RETURN
      END
      SUBROUTINE NCCPDF(X, V, FL, PDF)
C UKC NETLIB DISTRIBUTION COPYRIGHT 1990 RSS
C
C
C        The non-central chi-squared probability density function.
C        USE THE FOLLOWING FORMULA ON PAGE 436 OF 2ND ED OF
C        VOL. 2 OF JOHNSON AND KOTZ.
C        F(X)=EXP(-(L+X)/2)*(1/2)*(X/V)**((V-2)/4)*I((V-2)/2)(SQRT(L*X))
C        WHERE I IS THE MODIFIED BESSEL FUNCTION.
C
C---------------------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
C
      DOUBLE PRECISION DX, DL, DV, DPDF
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3, DTERM4, DTERM5
      DOUBLE PRECISION DLNGAM
C
      DOUBLE PRECISION DTEMP1(1)
      REAL TEMP1(1)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C        TEST FOR ADMISSIBILITY OF ARGUMENTS
C
      IF(X.LE.0.0)THEN
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF (V.LE.0.0) THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)V
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF (FL.LT.0.0)THEN
        WRITE(ICOUT,401)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)FL
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** ERROR IN NCCPDF--THE SECOND INPUT ARGUMENT ',
     1'IS NON-POSITIVE')
  301 FORMAT('***** ERROR IN NCCPDF--THE FIRST INPUT ARGUMENT ',
     1'IS NON-POSITIVE')
  401 FORMAT('***** ERROR IN NCCPDF--THE THIRD INPUT ARGUMENT ',
     1'IS NON-POSITIVE')
   46 FORMAT('      THE ARGUMENT HAS THE VALUE ',E15.6)
C
C
      PDF = 0.0
      DX=DBLE(X)
      DL=DBLE(FL)
      DV=DBLE(V)
C
      IF(FL.EQ.0.0)THEN
        DTERM1=((DV-2.0D0)/2.0D0)*DLOG(DX)
        DTERM2=-DX/2.0D0
        DTERM3=(DV/2.0D0)*DLOG(2.0D0)
        DTERM4=DLNGAM(DV/2.0D0)
        DPDF=DEXP(DTERM1+DTERM2-DTERM3-DTERM4)
        PDF=REAL(DPDF)
        GOTO9999
      ENDIF
C
      IF(DV.LT.2.0D0)GOTO1000
C
      DTERM1=DSQRT(DL*DX)
      IF(DTERM1.LE.DLOG(D1MACH(2)))THEN
        DTERM2=-(DL+DX)/2.0D0+DLOG(0.5D0)+
     1         ((DV-2.0D0)/4.0D0)*DLOG(DX/DL)
        IARG1=1
        ISCALE=1
        DTERM5=(DV-2.0D0)/2.0D0
        CALL DBESI(DTERM1,DTERM5,ISCALE,IARG1,DTEMP1,NZERO)
        DTERM3=DTEMP1(1)
        DTERM3=DLOG(DTERM3)
        DTERM4=DTERM2+DTERM3
        IF(DTERM4.LE.-80.D0)THEN
          PDF=0.0
        ELSEIF(DTERM4.GE.80.D0)THEN
          WRITE(ICOUT,601)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,47)X
          CALL DPWRST('XXX','BUG ')
          PDF=LOG(R1MACH(2))
        ELSE
          DPDF=DEXP(DTERM4)
          PDF=SNGL(DPDF)
        ENDIF
      ELSE
        WRITE(ICOUT,501)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)X
        CALL DPWRST('XXX','BUG ')
      ENDIF
      GOTO9999
  601 FORMAT('***** ERROR IN NCCPDF--OVERFLOW IN CALCULATION OF PDF' ,
     1' VALUE, PDF SET TO LOG OF LARGEST NUMBER.')
  501 FORMAT('***** ERROR IN NCCPDF--ARGUMENT TO LARGE FOR DBESI ',
     1'ROUTINE, PDF SET TO 0')
   47 FORMAT('      THE ARGUMENT HAS THE VALUE ',E15.6)
C
C  CASE FOR V < 2 REQUIRE NEGATIVE ORDER OF MODIFIED BESSEL FUNCTION.
C  USE I(-v) = I(v) + (2/PI)*SIN(V*PI)*K(v)
C
 1000 CONTINUE
      DTERM1=DSQRT(DL*DX)
      IF(DTERM1.LE.DLOG(D1MACH(2)))THEN
        DTERM2=-(DL+DX)/2.0D0+DLOG(0.5D0)+
     1         ((DV-2.0D0)/4.0D0)*DLOG(DX/DL)
        IARG1=1
        ISCALE=1
        DTERM5=(DV-2.0D0)/2.0D0
        CALL DBESI(DTERM1,DABS(DTERM5),ISCALE,IARG1,DTEMP1,NZERO)
        DTERM3=DTEMP1(1)
        CALL BESK(SNGL(DTERM1),SNGL(DABS(DTERM5)),ISCALE,IARG1,TEMP1,
     1            NZERO)
        TERM3=TEMP1(1)
        DTERM3=DTERM3+(2.0D0/DPI)*DSIN(DABS(DTERM5)*DPI)*DBLE(TERM3)
        DTERM3=DLOG(DTERM3)
        DTERM4=DTERM2+DTERM3
        IF(DTERM4.LE.-80.D0)THEN
          PDF=0.0
        ELSEIF(DTERM4.GE.80.D0)THEN
          WRITE(ICOUT,601)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,47)X
          CALL DPWRST('XXX','BUG ')
          PDF=LOG(R1MACH(2))
        ELSE
          DPDF=DEXP(DTERM4)
          PDF=SNGL(DPDF)
        ENDIF
      ELSE
        WRITE(ICOUT,501)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)X
        CALL DPWRST('XXX','BUG ')
      ENDIF
      GOTO9999
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCCNCP(X, DF, FX, FL)
C
C        ALGORITHM AS 170.1  APPL.STATIST. (1981) VOL.30, NO.3
C
C        DEFINE ACCURACY AND INITIALIZE
C
C        N SHOULD BE SPECIFIED SUCH THAT ACC IS GREATER THAN
C        OR EQUAL TO (AU-AL)/2**N
C
      PARAMETER (ACC = 1.0E-6, N = 30)
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DGAMIP
      DOUBLE PRECISION DARG1
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
      AL = 0.0
      AINC = 80.0
      AU = 80.0
C
C        TEST FOR ADMISSIBILITY OF ARGUMENTS
C
      IF (DF.LE.0.0) THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,301)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,302)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
      IF (FX.LE.0.0)THEN
        WRITE(ICOUT,401)
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** FATAL DIAGNOSTIC--THE DEGREES OF FREEDOM PARAMETER',
     1       ' IS NON-POSITIVE. ****')
  301 FORMAT('***** FATAL DIAGNOSTIC--THE FIRST INPUT ARGUMENT IS ')
  302 FORMAT('      NON-POSITIVE.  IT HAS THE VALUE ',E15.7)
  401 FORMAT('***** FATAL DIAGNOSTIC--THE CDF PARAMETER IS NEGATIVE.')
C
      DF2 = 0.5*DF
      X2 = 0.5*X
CCCCC FX1 = GAMMDS(X2,DF2,IFAULT)
      DARG1=DGAMIP(DBLE(DF2),DBLE(X2))
      FX1 = REAL(DARG1)
    1 CONTINUE
CCCC1 APROX = CHI(X2,DF2,AU,FX1)
      CALL NCCCHI (X2,DF2,AU,FX1,APROX)
      IF (FX.GT.APROX) GOTO 2
      IF (FX.LT.APROX) AL = AU
      AU = AU+AINC
      GO TO 1
C
    2 CONTINUE
      DO 3 J = 1,N
        FL = 0.5*(AL+AU)
CCCCC   APROX = CHI(X2, DF2, FL, FX1)
        CALL NCCCHI (X2,DF2,FL,FX1,APROX)
        IF (ABS(FX-APROX).LT.ACC) GO TO 9999
        IF (FX.LT.APROX) AL = FL
        IF (FX.GE.APROX) AU = FL
    3 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCCPPF(P,NU,DELTA,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE NON-CENTRAL CHI-SQUARE
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--94/9
C     ORIGINAL VERSION--SEPTEMBER 1994.
C     UPDATE          --MAY       2004. SOME UPDATES TO SPEED
C                                 CONVERGENCE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL NU
      DOUBLE PRECISION DGAMIP
      DOUBLE PRECISION DARG1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA EPS /0.0001/
CCCCC DATA SIG /1.0E-5/
      DATA ZERO /0./
      DATA MAXIT /500/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GE.1.0)GOTO50
      IF(NU.LE.0.0)GOTO55
      IF(DELTA.LT.0.0)GOTO70
      GOTO90
   50 WRITE(ICOUT,1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   55 WRITE(ICOUT,11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)NU
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   70 WRITE(ICOUT,35)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)DELTA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      GOTO9999
C
    1 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE ',
     1' NCCPPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
   11 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE ',
     1' NCCPPF SUBROUTINE IS NON-POSITIVE.')
   35 FORMAT('***** FATAL ERROR--THE THIRD INPUT ARGUMENT TO THE ',
     1' NCCPPF SUBROUTINE IS NEGATIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I15,' *****')
C
   90 CONTINUE
C
C  SPECIAL CASE.  FOR INTEGER NU AND DELTA = 0, USE CENTRAL CHI-SQUARE
C  ROUTINE.
C
      IF(DELTA.EQ.0.0)THEN
        NUINT=INT(NU+0.1)
        ANUINT=REAL(NUINT)
        IF(ABS(NU-ANUINT).LE.0.00001 .AND. NUINT.GE.1)THEN
          CALL CHSPPF(P,NUINT,PPF)
          GOTO9999
        ENDIF
      ENDIF
C
C  FIND BRACKETING INTERVAL.  USE CORRESPONDING CENTRAL CHI-SQUARE
C  AS INITIAL GUESS, INCREMENTS OF 1 STANDARD DEVIATION AROUND IT
C  (SD = SQRT(2*(NU+2*DELTA))
C  AFTER SUCCESSFULLY FIND BRACKETING INTERVAL, THEN SWITCH TO 
C  MORE EFFICIENT BISECTION METHOD.
C
C  5/2004. BETTER BRACKETING INTERVAL.  BASE ON MEAN, SD, AND VALUE OF P.
C          ALSO, FOR LOW VALUES OF NU AND MORE EXTREME VALUES OF P,
C          LOOSEN THE CONVERGENCE CRITIERION.  LEFT INVERVAL IS 0 (OR
C          0 + EPS)
C
      EPS=0.0001
      SIG=1.0E-5
CCCCC IF(NU.GE.20.0)THEN
CCCCC   EPS=0.0001
CCCCC   SIG=1.0E-5
CCCCC   IF(P.GT.0.95 .OR. P.LT.0.05)THEN
CCCCC     EPS=0.0001
CCCCC     SIG=1.0E-4
CCCCC   ENDIF
CCCCC ELSE
CCCCC   IF(P.GT.0.99 .OR. P.LT.0.01)THEN
CCCCC     EPS=0.0001
CCCCC     SIG=1.0E-5
CCCCC   ENDIF
CCCCC ENDIF
C
CCCCC NUINT=NU+0.5
CCCCC CALL CHSPPF(P,NUINT,XL)
      AMEAN=NU+DELTA
      SD=SQRT(2.0*(NU+2.0*DELTA))
      XINC=SD
C
      XL=0.0
      IF(P.LE.0.25)THEN
        XL=0.0
      ELSEIF(P.GT.0.25 .AND. P.LE.0.75)THEN
        XL=AMEAN
      ELSEIF(P.GT.0.75 .AND. P.LE.0.95)THEN
        XL=AMEAN+SD
      ELSE
        XL=AMEAN+2.0*SD
      ENDIF
C
      ICOUNT=0
      MAXCNT=100
C
   91 CONTINUE
      XR=XL+XINC
      IF(XL.LE.0.0)XL=0.0
      IF(XR.LE.0.0)XR=XL+XINC
C
      DF2 = 0.5*NU
      FL=DELTA
      IF(XL.LE.0.0000001)THEN
        CDFL=0.0
      ELSE
        X2 = 0.5*XL
        DARG1=DGAMIP(DBLE(DF2),DBLE(X2))
        FXP=REAL(DARG1)
        CALL NCCCHI(X2,DF2,FL,FXP,CDFL)
      ENDIF
      X2 = 0.5*XR
      DARG1=DGAMIP(DBLE(DF2),DBLE(X2))
      FXP=REAL(DARG1)
      CALL NCCCHI(X2,DF2,FL,FXP,CDFR)
C
CCCCC CALL NCCCDF(XL,NU,DELTA,CDFL)
CCCCC CALL NCCCDF(XR,NU,DELTA,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   96 FORMAT('***** FATAL ERROR--NCCPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL. *****')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -P
      FXR = 1.0 - P
  105 CONTINUE
      X = (XL+XR)*0.5
C
      IF(X.LE.0.0000001)THEN
        CDF=0.0
      ELSE
        X2 = 0.5*X
        DARG1=DGAMIP(DBLE(DF2),DBLE(X2))
        FXP=REAL(DARG1)
        CALL NCCCHI(X2,DF2,FL,FXP,CDF)
      ENDIF
CCCCC CALL NCCCDF(X,NU,DELTA,CDF)
      P1=CDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS 
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** ERROR--NCCPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCCRAN(N,ANU,ALAMB,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE NON-CENTRAL CHI-SQUARED DISTRIBUTION
C              WITH DEGREES OF FREEDOM PARAMETER NU AND
C              NON-CENTRALITY PARAMETER LAMBDA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --ANU    = THE DEGREES OF FREEDOM PARAMETER
C                     --ALAMB  = THE NON-CENTRALITY PARAMETER
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NON-CENTRAL CHI-SQUARED DISTRIBUTION
C             WITH SHAPE PARAMETERS NU AND LANBDA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --ANU SHOULD BE POSITIVE.
C                 --ALAMB SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NORRAN, GAMRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY. 
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/5
C     ORIGINAL VERSION--MAY       2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF NON-CENTRAL ',
     1       'CHI-SQUARE RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ANU.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,48)ANU
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   15 FORMAT('***** ERROR--THE DEGREES OF FREEDOM PARAMETER FOR ',
     1'NON-CENTRAL CHI-SQUARE RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ALAMB.LT.0.0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,48)ALAMB
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   25 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER FOR ',
     1'NON-CENTRAL CHI-SQUARE RANDOM NUMBERS IS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
   48 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IF(ALAMB.EQ.0.0)THEN
        CALL CHSRAN(N,ANU,ISEED,X)
      ELSE
        IF(ANU.LE.1.0)THEN
          CALL UNIRAN(N,ISEED,X)
          DO1367II=1,N
            ATEMP=X(II)
            CALL NCCPPF(ATEMP,ANU,ALAMB,PPF)
            X(II)=PPF
 1367     CONTINUE
        ELSE
CCCCC     NOTE: 5/2004.  USING PERCENT POINT METHOD SEEMS TO
CCCCC           GENERATE BETTER RANDOM NUMBERS THAN THE SUM OF
CCCCC           NORMALS METHOD.  IT IS SLOWER, BUT IT SEEMS TO
CCCCC           BE MORE ACCURATE.  ALSO, IT CAN HANDLE NON-INTEGER
CCCCC           VALUES OF NU.
C
          CALL UNIRAN(N,ISEED,X)
          DO1369II=1,N
            ATEMP=X(II)
            CALL NCCPPF(ATEMP,ANU,ALAMB,PPF)
            X(II)=PPF
 1369     CONTINUE
CCCCC     NUINT=INT(NU+0.5)
CCCCC     IF(NUINT.LT.1)NUINT=1
CCCCC     NTEMP=1
CCCCC     DO1365II=1,N
CCCCC       ASUM=0.0
CCCCC       DO1366J=1,NUINT
CCCCC         CALL NORRAN(NTEMP,ISEED,XTEMP)
CCCCC         ASUM=ASUM + (XTEMP(1) + (ALAMB/REAL(NUINT)))**2
C1365       CONTINUE
CCCCC       X(II)=ASUM
C1365     CONTINUE
        ENDIF
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NCFCDF(X,NU1,NU2,LAMBDA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE NON-CENTRAL F DISTRIBUTION
C              WITH INTEGER DEGREES OF FREEDOM
C              PARAMETERS = NU1 AND NU2.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X.
C              THE PROBABILITY DENSITY FUNCTION IS GIVEN
C              IN THE REFERENCES BELOW.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE NON-NEGATIVE.
C                     --NU1    = THE INTEGER DEGREES OF FREEDOM
C                                FOR THE NUMERATOR OF THE F RATIO.
C                                NU1 SHOULD BE POSITIVE.
C                     --NU2    = THE INTEGER DEGREES OF FREEDOM
C                                FOR THE DENOMINATOR OF THE F RATIO.
C                                NU2 SHOULD BE POSITIVE.
C                     --LAMBDA   NON-NEGATIVE NON-CENTRALITY PARAMETER.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE NON-CENTRAL F DISTRIBUTION
C             WITH DEGREES OF FREEDOM PARAMETERS = NU1 AND NU2.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C                 --NU1 SHOULD BE A POSITIVE INTEGER VARIABLE.
C                 --NU2 SHOULD BE A POSITIVE INTEGER VARIABLE.
C                 --LAMBDA SHOULD BE GREATER THAN OR EQUAL TO 0.
C     OTHER           SUBROUTINES NEEDED--NCBCDF,CHSCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DSQRT, DATAN.
C     LANGUAGE--ANSI FORTRAN (1977)
C     ALGORITHM --USES THE NON-CENTRAL BETA DISTRIBUTION.
C     REFERENCES--"COMPUTING NON-CENTRAL BETA PROBABILITIES"
C                 RUSSELL LENTH, ALGORITHM AS 226 FROM APPLIED
C                 STATISTICS JOURNAL.  
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--94/9
C     ORIGINAL VERSION--SEPTEMBER 1994.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL NU1
      REAL NU2
      REAL LAMBDA
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(NU1.LE.0.0)GOTO50
      IF(NU2.LE.0.0)GOTO55
      IF(X.LT.0.0)GOTO60
      IF(LAMBDA.LT.0.0)GOTO70
      GOTO90
   50 WRITE(ICOUT,15)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)NU1
      CALL DPWRST('XXX','BUG ')
      CDF=0.0
      RETURN
   55 WRITE(ICOUT,23)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)NU2
      CALL DPWRST('XXX','BUG ')
      CDF=0.0
      RETURN
   60 WRITE(ICOUT,4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)X
      CALL DPWRST('XXX','BUG ')
      CDF=0.0
      RETURN
   70 WRITE(ICOUT,24)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)LAMBDA
      CALL DPWRST('XXX','BUG ')
      CDF=0.0
      RETURN
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE 1ST INPUT ARGUMENT ',
     1'TO THE NCFCDF   SUBROUTINE IS NEGATIVE *****')
   15 FORMAT('***** FATAL ERROR--THE 2ND INPUT ARGUMENT TO THE ',
     1'NCFCDF   SUBROUTINE IS NON-POSITIVE *****')
   23 FORMAT('***** FATAL ERROR--THE 3RD INPUT ARGUMENT TO THE ',
     1'NCFCDF   SUBROUTINE IS NON-POSITIVE *****')
   24 FORMAT('***** FATAL ERROR--THE FOURTH INPUT ARGUMENT TO THE ',
     1'NCFCDF   SUBROUTINE IS NEGATIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
   90 CONTINUE
C
      TERM1=NU1*0.5
      TERM2=NU2*0.5
      TERM3=NU1*X/(NU1*X+NU2)
      CALL NCBCDF(TERM3,TERM1,TERM2,LAMBDA,CDF)
C
 9999 CONTINUE
      RETURN
      END
      REAL FUNCTION NCFFU3(X)
C
C     PURPOSE--NCFPDF CALLS DIFF TO FIND A NUMERICAL DERIVATIVE
C              FOR THE NON-CENTRAL CUMULATIVE DISTRIBUTION FUNCTION.
C              NCFFU3 IS A FUNCTION THAT CALL NCFCDF.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE DERIVATIVE
C                                IS TO BE EVALUATED.
C     OUTPUT--THE SINGLE PRECISION FUNCTION VALUE NCFFU3.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NCBCDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.5
C     ORIGINAL VERSION--MAY       2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      REAL ANU1
      REAL ANU2
      REAL ALAMB
      COMMON/NCFCOM/ANU1,ANU2,ALAMB
C
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  NOTE: NCFCDF CALLS NCBCDF.  PERFORM THE NEEDED PARAMETER TRANSLATION
C        AND CALL NCBCDF (I.E., SAVE A SUBROUTINE CALL).
C
CCCCC CALL NCFCDF(X,ANU1,ANU2,,ALAMB,CDF)
      TERM1=ANU1*0.5
      TERM2=ANU2*0.5
      TERM3=ANU1*X/(ANU1*X+ANU2)
      CALL NCBCDF(TERM3,TERM1,TERM2,ALAMB,CDF)
      NCFFU3=CDF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCFPDF(X,NU1,NU2,LAMBDA,PDF)
C
C     PURPOSE--PROBABILITY DENSITY FUNCTION FOR THE NON-CENTRAL
C              T DISTRIBUTION.  THE PROBABILITY DENSITY FUNCTION
C              IS COMPUTED BY COMPUTING THE NUMERICAL DERIVATIVE OF
C              THE CUMULATIVE DISTRIBUTION FUNCTION.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --ANU    = THE DEGREES OF FREEDOM SHAPE PARAMETER
C                     --DELTA  = THE FIRST NON-CENTRALITY SHAPE PARAMETER
C                     --LAMBDA = THE SECOND NON-CENTRALITY PARAMETER
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY FUNCTION VALUE PDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DIFF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/5
C     ORIGINAL VERSION--MAY       2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL  X
      REAL  NU1
      REAL  NU2
      REAL  LAMBDA
      REAL  PDF
C
      REAL NCFFU3
      EXTERNAL NCFFU3
      REAL ANU1
      REAL ANU2
      REAL ALAMB
      COMMON/NCFCOM/ANU1,ANU2,ALAMB
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      PDF=0.0
C
      IF(NU1.LE.0.0)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)NU1
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('**** ERROR--THE FIRST DEGREES OF FREEDOM PARAMETER')
  102 FORMAT('     FOR NCFPDF IS NON-POSITIVE.  IT HAS THE VALUE ',
     1       E15.7)
C
      IF(NU2.LE.0.0)THEN
        WRITE(ICOUT,103)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,104)NU2
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  103 FORMAT('**** ERROR--THE SECOND DEGREES OF FREEDOM PARAMETER')
  104 FORMAT('     FOR NCFPDF IS NON-POSITIVE.  IT HAS THE VALUE ',
     1       E15.7)
C
      IF(ALAMB.LT.0.0)THEN
        WRITE(ICOUT,303)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,304)ALAMB
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  303 FORMAT('**** ERROR--THE NON-CENTRALITY PARAMETER IS NEGATIVE.')
  304 FORMAT('     IT HAS THE VALUE ',E15.7)
C
C  FIND NUMERIC DERIVATIVE OF CDF ROUTINE
C
      IORD=1
      EPS=0.0001
      ACCUR=0.0
      IFAIL=0
      X0 = X
      XMIN=MAX(X0 - 50.0,0.0)
      XMAX=X0 + 50.0
      ANU1=NU1
      ANU2=NU2
      ALAMB=LAMBDA
C
      CALL DIFF(IORD,X0,XMIN,XMAX,NCFFU3,EPS,ACCUR,PDF,ERROR,IFAIL)
C
      IF(IFAIL.EQ.1)THEN
  999     FORMAT(1X)
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,401)
  401   FORMAT('***** WARNING IN NUMERICAL DERIVATIVE FOR NCFPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,403)
  403   FORMAT('      THE ESTIMATED ERROR IN THE RESULT EXCEEDS THE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,405)
  405   FORMAT('      REQUESTED ERROR, BUT THE MOST ACCURATE RESULT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,407)
  407   FORMAT('      POSSIBLE HAS BEEN RETURNED.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFAIL.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,411)
  411   FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR NCFPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,413)
  413   FORMAT('      ERROR IN THE INPUT TO THE DIFF ROUTINE.')
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(IFAIL.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,421)
  421   FORMAT('***** ERROR IN NUMERICAL DERIVATIVE FOR NCFPDF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,423)
  423   FORMAT('      THE INTERVAL FOR DIFFERENTIATION, (',G15.7,
     1         ',',G15.7,')')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,425)
  425   FORMAT('      IS TOO SMALL.')
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCFPPF(P,NU1,NU2,DELTA,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE NON-CENTRAL F
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--94/9
C     ORIGINAL VERSION--SEPTEMBER 1994.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL NU1
      REAL NU2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA EPS /0.0001/
      DATA SIG /1.0E-5/
      DATA ZERO /0./
      DATA MAXIT /500/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0.OR.P.GE.1.0)GOTO50
      IF(NU1.LT.0.0)GOTO55
      IF(NU2.LT.0.0)GOTO65
      IF(DELTA.LT.0.0)GOTO70
      GOTO90
   50 WRITE(ICOUT,1)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   55 WRITE(ICOUT,11)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)NU1
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   65 WRITE(ICOUT,12)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)NU2
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      RETURN
   70 WRITE(ICOUT,35)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)DELTA
      CALL DPWRST('XXX','BUG ')
      PPF=0.0
      GOTO9999
C
    1 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1' NCFPPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   11 FORMAT('***** FATAL ERROR--THE 2ND INPUT ARGUMENT TO THE ',
     1' NCFPPF SUBROUTINE IS NON-POSITIVE.')
   12 FORMAT('***** FATAL ERROR--THE THIRD INPUT ARGUMENT TO THE ',
     1' NCFPPF SUBROUTINE IS NON-POSITIVE.')
   35 FORMAT('***** FATAL ERROR--THE FOURTH INPUT ARGUMENT TO THE ',
     1' NCFPPF SUBROUTINE IS NEGATIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I15,' *****')
C
   90 CONTINUE
C
C  FIND BRACKETING INTERVAL.  USE CORRESPONDING CENTRAL F
C  AS INITIAL GUESS, INCREMENTS OF 100 AROUND IT.
C  AFTER SUCCESSFULLY FIND BRACKETING INTERVAL, THEN SWITCH TO 
C  MORE EFFICIENT BISECTION METHOD.
C
      XINC=50.0
      NU1INT=NU1+0.5
      NU2INT=NU2+0.5
      CALL FPPF(P,NU1INT,NU2INT,XL)
      ICOUNT=0
      MAXCNT=10000
C
   91 CONTINUE
      XR=XL+XINC
      IF(XL.LE.0.0)XL=0.0
      IF(XR.LE.0.0)XR=XL+1.0
      CALL NCFCDF(XL,NU1,NU2,DELTA,CDFL)
      CALL NCFCDF(XR,NU1,NU2,DELTA,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   96 FORMAT('***** FATAL ERROR--NCFPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL. *****')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -P
      FXR = 1.0 - P
  105 CONTINUE
      X = (XL+XR)*0.5
      CALL NCFCDF(X,NU1,NU2,DELTA,CDF)
      P1=CDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS 
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** FATAL ERROR--NCFPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCFRAN(N,ANU1,ANU2,ALAMB1,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE NON-CENTRAL F DISTRIBUTION WITH SHAPE
C              PARAMETERS ANU1 AND ANU2 AND NON-CENTRALITY
C              PARAMETER LAMBDA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --ANU1   = THE SINGLE PRECISION VALUE OF THE
C                                FIRST  SHAPE PARAMETER.
C                     --ANU2   = THE SINGLE PRECISION VALUE OF THE
C                                SECOND SHAPE PARAMETER.
C                     --ALAMB1  = THE SINGLE PRECISION VALUE OF THE
C                                NON-CENTRALITY PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NON-CENTRAL F DISTRIBUTION
C             WITH SHAPE PARAMETER VALUES = ANU1, ANU2, AND ALAMB1.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --ANU1 AND ANU2  SHOULD BE POSITIVE.
C                 --ALAMB1  SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NORRAN, CHSRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALAKRISHNAN, "CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS VOLUME 2", SECOND EDITION,
C                 1994, PAGES 502-503.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004.5
C     ORIGINAL VERSION--MAY       2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF NON-CENTRAL F ',
     1' RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ANU1.LE.0.0)THEN
        WRITE(ICOUT,16)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ANU1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   16 FORMAT('***** ERROR--THE SHAPE PARAMETER NU1 FOR THE ',
     1'NON-CENTRAL F RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ANU2.LE.0.0)THEN
        WRITE(ICOUT,26)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ANU2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   26 FORMAT('***** ERROR--THE SHAPE PARAMETER NU2 FOR THE ',
     1'NON-CENTRAL F RANDOM NUMBERS IS NON-POSITIVE.')
      IF(ALAMB1.LT.0.0)THEN
        WRITE(ICOUT,36)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALAMB1
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   36 FORMAT('***** ERROR--THE NON-CENTRALITY PARAMETER LAMBDA FOR ',
     1'THE NON-CENTRAL F RANDOM NUMBERS IS NEGATIVE.')
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C  IF DEGREES OF FREEDOM ARE LESS THAN 1, THEN USE PERCENT
C  POINT METHOD (PROBABLY NOT MOST EFFICIENT METHOD, BUT LEAVE
C  UNTIL FIND A BETTER ALGORITHM).
C 
      ALAMB2=0.0
C
      IF(ANU1.LE.1.0 .OR. ANU2.LE.1.0)THEN
        CALL UNIRAN(N,ISEED,X)
        DO1378II=1,N
          ATEMP=X(II)
          CALL NCFPPF(ATEMP,ANU1,ANU2,ALAMB1,PPF)
          X(II)=PPF
 1378   CONTINUE
      ELSE
        NTEMP=1
        DO100II=1,N
          CALL NORRAN(NTEMP,ISEED,XTEMP)
          X1=(XTEMP(1) + SQRT(ALAMB1))**2
          IF(ANU1.GT.1.0)THEN
            CALL CHSRAN(NTEMP,ANU1-1.0,ISEED,XTEMP)
            X1=X1+XTEMP(1)
          ENDIF
          CALL NORRAN(NTEMP,ISEED,XTEMP)
          X2=(XTEMP(1) + SQRT(ALAMB2))**2
          IF(ANU2.GT.1.0)THEN
            CALL CHSRAN(NTEMP,ANU2-1.0,ISEED,XTEMP)
            X2=X2+XTEMP(1)
          ENDIF
          X(II)=ANU2*X1/(ANU1*X2)
  100   CONTINUE
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NCTCDF(T2, DF2, DELTA2, CDF)
C
C     ALGORITHM AS 243  APPL. STATIST. (1989), VOL.38, NO. 1
C
C     Cumulative probability at T of the non-central t-distribution
C     with DF degrees of freedom (may be fractional) and non-centrality
C     parameter DELTA.
C
C     Note - requires the following auxiliary routines
C     ALOGAM (X)                         - ACM 291 or AS 245
C     BETAIN (X, A, B, ALBETA, IFAULT)   - AS 63 (updated in ASR 19)
C     ALNORM (X, UPPER)                  - AS 66
C
      REAL T2, DF2, DELTA2
      DOUBLE PRECISION A, DLBETA, ALNRPI, B, DEL, DELTA, DF, EN, ERRBD
      DOUBLE PRECISION ERRMAX, GEVEN, GODD, HALF, ITRMAX, LAMBDA, ONE
      DOUBLE PRECISION P, Q, R2PI, RXB, S, T, TT, TWO, X, XEVEN, XODD
      DOUBLE PRECISION ZERO, DBETAI, TNC
      LOGICAL NEGDEL
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C     Note - ITRMAX and ERRMAX may be changed to suit one's needs.
C
      DATA ITRMAX/500.1D0/, ERRMAX/1.D-06/
C
C     Constants - R2PI = 1/ {GAMMA(1.5) * SQRT(2)} = SQRT(2 / PI)
C                 ALNRPI = LN(SQRT(PI))
C
      DATA ZERO/0.D0/
      DATA HALF/0.5D0/
      DATA ONE/1.0D0/
      DATA TWO/2.0D0/
      DATA R2PI/0.79788 45608 02865 35588D0/
      DATA ALNRPI/0.57236 49429 24700 08707D0/
C
      T=DBLE(T2)
      DF=DBLE(DF2)
      DELTA=DBLE(DELTA2)
C
      IF(DF.LE.ZERO)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)DF2
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** FATAL DIAGNOSTIC--THE DEGREES OF FREEDOM PARAMETER')
  102 FORMAT('      IS NON-POSITIVE.  IT HAS THE VALUE ',E15.7)
C
      TNC = ZERO
C
      TT = T
      DEL = DELTA
      NEGDEL = .FALSE.
      IF (T .GE. ZERO) GO TO 1
      NEGDEL = .TRUE.
      TT = -TT
      DEL = -DEL
    1 CONTINUE
C
C     Initialize twin series (Guenther, J. Statist. Computn. Simuln.
C     vol.6, 199, 1978).
C
      EN = ONE
      X = T * T / (T* T + DF)
      IF (X .LE. ZERO) GO TO 20
      LAMBDA = DEL * DEL
      P = HALF * DEXP(-HALF * LAMBDA)
      Q = R2PI * P * DEL
      S = HALF - P
      A = HALF
      B = HALF * DF
      RXB = (ONE - X) ** B
CCCCC ALBETA = ALNRPI + ALOGAM(B, IFAULT) - ALOGAM(A + B, IFAULT)
CCCCC XODD = BETAIN(X, A, B, ALBETA, IFAULT)
      ALBETA=DLBETA(A,B)
      XODD = DBETAI(X,A,B)
C
      GODD = TWO * RXB * EXP(A * LOG(X) - ALBETA)
      XEVEN = ONE - RXB
      GEVEN = B * X * RXB
      TNC = P * XODD + Q * XEVEN
C
C     Repeat until convergence
C
   10 A = A + ONE
      XODD = XODD - GODD
      XEVEN = XEVEN - GEVEN
      GODD = GODD * X * (A + B - ONE) / A
      GEVEN = GEVEN * X * (A + B - HALF) / (A + HALF)
      P = P * LAMBDA / (TWO * EN)
      Q = Q * LAMBDA / (TWO * EN + ONE)
      S = S - P
      EN = EN + ONE
      TNC = TNC + P * XODD + Q * XEVEN
      ERRBD = TWO * S * (XODD - GODD)
      IF (ERRBD .GT. ERRMAX .AND. EN .LE. ITRMAX) GO TO 10
C
CCCCC APRIL 1995.  IF NO CONVERGENCE, CALL DOUBLY NON-CENTRAL T
CCCCC ROUTINE.
C
   20 CONTINUE
      IF (EN .GT. ITRMAX) THEN
CCCCC   WRITE(ICOUT,701)
CCCCC   CALL DPWRST('XXX','BUG ')
        ALAMB=0.0
        CALL DNTCDF(T2,DF2,DELTA2,ALAMB,CDF)
        RETURN
      ENDIF
  701 FORMAT('*** WARNING--THE NCTCDF ROUTINE DID NOT CONVERGE.  ***')
C
CCCCC TNC = TNC + ALNORM(DEL, .TRUE.)
      ARG1=REAL(DEL)
      CALL NORCDF(ARG1,ARG2)
      TNC = TNC + DBLE(1.0-ARG2)
      IF (NEGDEL) TNC = ONE - TNC
      GOTO9999
C
 9999 CONTINUE
      CDF=REAL(TNC)
      RETURN
      END
      SUBROUTINE NCTCD2(T2, DF2, DELTA2, CDF)
C
C     This is a copy of NCTCDF.  Distinction is that this version
C     returns a double precision result (used by the NCTPDF
C     routine) and inputs double precision arguments.
C
C     ALGORITHM AS 243  APPL. STATIST. (1989), VOL.38, NO. 1
C
C     Cumulative probability at T of the non-central t-distribution
C     with DF degrees of freedom (may be fractional) and non-centrality
C     parameter DELTA.
C
C     Note - requires the following auxiliary routines
C     ALOGAM (X)                         - ACM 291 or AS 245
C     BETAIN (X, A, B, ALBETA, IFAULT)   - AS 63 (updated in ASR 19)
C     ALNORM (X, UPPER)                  - AS 66
C
      DOUBLE PRECISION T2, DF2, DELTA2, ARG2, CDF
      DOUBLE PRECISION A, DLBETA, ALNRPI, B, DEL, DELTA, DF, EN, ERRBD
      DOUBLE PRECISION ERRMAX, GEVEN, GODD, HALF, ITRMAX, LAMBDA, ONE
      DOUBLE PRECISION P, Q, R2PI, RXB, S, T, TT, TWO, X, XEVEN, XODD
      DOUBLE PRECISION ZERO, DBETAI, TNC
      LOGICAL NEGDEL
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C     Note - ITRMAX and ERRMAX may be changed to suit one's needs.
C
      DATA ITRMAX/1000.1D0/, ERRMAX/1.D-08/
C
C     Constants - R2PI = 1/ {GAMMA(1.5) * SQRT(2)} = SQRT(2 / PI)
C                 ALNRPI = LN(SQRT(PI))
C
      DATA ZERO/0.D0/
      DATA HALF/0.5D0/
      DATA ONE/1.0D0/
      DATA TWO/2.0D0/
      DATA R2PI/0.79788 45608 02865 35588D0/
      DATA ALNRPI/0.57236 49429 24700 08707D0/
C
      T=T2
      DF=DF2
      DELTA=DELTA2
C
      IF(DF.LE.ZERO)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,102)DF2
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
  101 FORMAT('***** FATAL DIAGNOSTIC--THE DEGREES OF FREEDOM PARAMETER')
  102 FORMAT('      IS NON-POSITIVE.  IT HAS THE VALUE ',D15.7)
C
      TNC = ZERO
C
      TT = T
      DEL = DELTA
      NEGDEL = .FALSE.
      IF (T .GE. ZERO) GO TO 1
      NEGDEL = .TRUE.
      TT = -TT
      DEL = -DEL
    1 CONTINUE
C
C     Initialize twin series (Guenther, J. Statist. Computn. Simuln.
C     vol.6, 199, 1978).
C
      EN = ONE
      X = T * T / (T* T + DF)
      IF (X .LE. ZERO) GO TO 20
      LAMBDA = DEL * DEL
      P = HALF * DEXP(-HALF * LAMBDA)
      Q = R2PI * P * DEL
      S = HALF - P
      A = HALF
      B = HALF * DF
      RXB = (ONE - X) ** B
CCCCC ALBETA = ALNRPI + ALOGAM(B, IFAULT) - ALOGAM(A + B, IFAULT)
CCCCC XODD = BETAIN(X, A, B, ALBETA, IFAULT)
      ALBETA=DLBETA(A,B)
      XODD = DBETAI(X,A,B)
C
      GODD = TWO * RXB * EXP(A * LOG(X) - ALBETA)
      XEVEN = ONE - RXB
      GEVEN = B * X * RXB
      TNC = P * XODD + Q * XEVEN
C
C     Repeat until convergence
C
   10 A = A + ONE
      XODD = XODD - GODD
      XEVEN = XEVEN - GEVEN
      GODD = GODD * X * (A + B - ONE) / A
      GEVEN = GEVEN * X * (A + B - HALF) / (A + HALF)
      P = P * LAMBDA / (TWO * EN)
      Q = Q * LAMBDA / (TWO * EN + ONE)
      S = S - P
      EN = EN + ONE
      TNC = TNC + P * XODD + Q * XEVEN
      ERRBD = TWO * S * (XODD - GODD)
      IF (ERRBD .GT. ERRMAX .AND. EN .LE. ITRMAX) GO TO 10
C
CCCCC APRIL 1995.  IF NO CONVERGENCE, CALL DOUBLY NON-CENTRAL T
CCCCC ROUTINE.
C
   20 CONTINUE
      IF (EN .GT. ITRMAX) THEN
CCCCC   WRITE(ICOUT,701)
CCCCC   CALL DPWRST('XXX','BUG ')
        ALAMB=0.0
        CALL DNTCDF(REAL(T2),REAL(DF2),REAL(DELTA2),ALAMB,CDF2)
        CDF=DBLE(CDF2)
        RETURN
      ENDIF
  701 FORMAT('*** WARNING--THE NCTCD2 ROUTINE DID NOT CONVERGE.  ***')
C
CCCCC TNC = TNC + ALNORM(DEL, .TRUE.)
      ARG1=REAL(DEL)
      CALL NODCDF(DEL,ARG2)
      TNC = TNC + (1.0D0-ARG2)
      IF (NEGDEL) TNC = ONE - TNC
      GOTO9999
C
 9999 CONTINUE
      CDF=TNC
      RETURN
      END
      SUBROUTINE NCTPDF(T, DF, DELTA, PDF)
C
C     COMPUTE NON-CENTRAL PDF BASED ON NON-CENTRAL CDF.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DPDF1
      DOUBLE PRECISION DPDF2
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C     T = 0 IS A SPECIAL CASE.
C
CCCCC EPS=0.000001
      EPS=1.0E-8
      IF(ABS(T).LE.EPS)THEN
C
C  THIS ALGORITHM DOES NOT RETURN A CORRECT RESULT.  AS TEMPORARY
C  FIX, COMPUTE FOR +EPS AND -EPS, THEN AVERAGE RESULT.
C
CCCCC   TX=EPS
CCCCC   TERM1=DF/TX
CCCCC   DF2=DF+2.0
CCCCC   TX2=SQRT((DF+2.0)/DF)*TX
CCCCC   CALL NCTCDF(TX2,DF2,DELTA,TERM2)
CCCCC   CALL NCTCDF(TX,DF,DELTA,TERM3)
CCCCC   PDF=TERM1*(TERM2-TERM3)
C
        TTEMP=EPS
        DTERM1=DBLE(DF/TTEMP)
        DF2=DF+2.0
        T2=SQRT((DF+2.0)/DF)*TTEMP
        CALL NCTCD2(DBLE(T2),DBLE(DF2),DBLE(DELTA),DTERM2)
        CALL NCTCD2(DBLE(TTEMP),DBLE(DF),DBLE(DELTA),DTERM3)
        DPDF1=DTERM1*(DTERM2-DTERM3)
C
        TTEMP=-EPS
        DTERM1=DBLE(DF/TTEMP)
        DF2=DF+2.0
        T2=SQRT((DF+2.0)/DF)*TTEMP
        CALL NCTCD2(DBLE(T2),DBLE(DF2),DBLE(DELTA),DTERM2)
        CALL NCTCD2(DBLE(TTEMP),DBLE(DF),DBLE(DELTA),DTERM3)
        DPDF2=DTERM1*(DTERM2-DTERM3)
C
        DPDF=(DPDF1+DPDF2)/2.0D0
        PDF=REAL(DPDF)
      ELSE
        DTERM1=DBLE(DF/T)
        DF2=DF+2.0
        T2=SQRT((DF+2.0)/DF)*T
        CALL NCTCD2(DBLE(T2),DBLE(DF2),DBLE(DELTA),DTERM2)
        CALL NCTCD2(DBLE(T),DBLE(DF),DBLE(DELTA),DTERM3)
        DPDF=DTERM1*(DTERM2-DTERM3)
        PDF=REAL(DPDF)
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCTPPF(P,NU,DELTA,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE NON-CENTRAL T
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--94/9
C     ORIGINAL VERSION--SEPTEMBER 1994.
C     UPDATED         --OCTOBER   2006. CALL LIST TO TPPF
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL NU
      DOUBLE PRECISION DLNGAM
      DOUBLE PRECISION ANU
      DOUBLE PRECISION DSD
      DOUBLE PRECISION DDELTA
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
CCCCC DOUBLE PRECISION FCT
CCCCC DOUBLE PRECISION C0
CCCCC DOUBLE PRECISION C1
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
CCCCC DATA EPS /0.0001/
CCCCC DATA SIG /1.0E-5/
      DATA ZERO /0./
      DATA MAXIT /500/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ELSEIF(NU.LT.0.0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)NU
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ELSEIF(DELTA.LT.0.0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DELTA
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
C
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO ',
     1' NCTPPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
   11 FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1' NCTPPF IS NON-POSITIVE.')
   35 FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1' NCTPPF IS NEGATIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I18)
C
C  DELTA = 0 AND NU INTEGER, USE CENTRAL T
C
      IF(DELTA.EQ.0.0)THEN
        NUINT=INT(NU+0.1)
        ANUINT=REAL(NUINT)
        IF(ABS(NU-ANUINT).LE.0.000001)THEN
          CALL TPPF(P,REAL(NUINT),PPF)
          GOTO9999
        ENDIF
      ENDIF
C
C  FIND BRACKETING INTERVAL.
C
C  1) CORRESPONDING CENTRAL T IS A LOWER BOUND
C  2) BASE INCREMENT ON SD OF NON-CENTRAL T:
C
C         (DELTA**2 + 1)*N/(N-2) -
C          DELTA**2*N*[GAMMA(0.5*(N-1))]**2/{2*[GAMMA(0.5*N)]**2}
C
C     IF NU <= 2, THEN BASE SD ON NU = 3 AND MULTIPLY BY A
C     SCALE FACTOR (AND SET MAX ITERATIONS HIGHER).
C
C  AFTER SUCCESSFULLY FIND BRACKETING INTERVAL, THEN SWITCH TO 
C  MORE EFFICIENT BISECTION METHOD.
C
      EPS=0.0000001
      SIG=1.0E-7
CCCCC IF(NU.LT.3.0)THEN
CCCCC   IF(P.GT.0.90 .OR. P.LT.0.10)THEN
CCCCC     EPS=0.0001
CCCCC     SIG=1.0E-4
CCCCC   ENDIF
CCCCC ENDIF
CCCCC IF(ABS(DELTA).GE.10.0)THEN
CCCCC     EPS=0.0001
CCCCC     SIG=1.0E-4
CCCCC ENDIF
C
      NUINT=NU+0.5
      CALL TPPF(P,REAL(NUINT),XL)
CCCCC XINC=50.0
      ANU=DBLE(NUINT)
      IF(ANU.LE.2.5D0)ANU=3.0D0
C
      DDELTA=DBLE(DELTA)
      DTERM1=ANU*(DDELTA**2 + 1.0D0)/(ANU-2.0D0)
      DTERM2=2.0D0*DLOG(DDELTA) + DLOG(ANU) - DLOG(2.0D0)
      DTERM3=2.0D0*DLNGAM(0.5D0*(ANU-1.0D0)) - 2.0D0*DLNGAM(0.5D0*ANU)
      DTERM4=DTERM2 + DTERM3
      DTERM5=DEXP(DTERM4)
      DSD=DTERM1 - DTERM5
      IF(DSD.GE.0.0D0)THEN
        SD=REAL(DSQRT(DSD))
      ELSE
        SD=10.0
      ENDIF
      IF(NU.GE.2.5)THEN
        XINC=SD
      ELSEIF(NU.GE.1.5)THEN
        XINC=5.0*SD
      ELSE
        XINC=10.0*SD
      ENDIF
      IF(XINC.LT.1.0)XINC=1.0
C
      ICOUNT=0
      MAXCNT=200
      IF(NU.LT.3.0)MAXCNT=500
C
   91 CONTINUE
      XR=XL+XINC
      CALL NCTCDF(XL,NU,DELTA,CDFL)
      CALL NCTCDF(XR,NU,DELTA,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   96 FORMAT('***** ERROR--NCTPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL.')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      IC = 0
      FXL = -P
      FXR = 1.0 - P
  105 CONTINUE
      X = (XL+XR)*0.5
      CALL NCTCDF(X,NU,DELTA,CDF)
      P1=CDF
      PPF=X
      FCS = P1 - P
      IF(FCS*FXL.GT.ZERO)GOTO110
      XR = X
      FXR = FCS 
      GOTO115
  110 CONTINUE
      XL = X
      FXL = FCS
  115 CONTINUE
      XRML = XR - XL
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** FATAL ERROR--NCTPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NCTRAN(N,ANU,DELTA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE STUDENT'S NON-CENTRAL T DISTRIBUTION
C              WITH DEGREES OF FREEDOM PARAMETER NU AND
C              NON-CENTRALITY PARAMETER DELTA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --NU     = THE INTEGER DEGREES OF FREEDOM
C                                PARAMETER.
C                     --DELTA  = THE REAL NON-CENTRALITY PARAMETER DELTA.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE STUDENT'S NON-CENTRAL T DISTRIBUTION
C             WITH DEGREES OF FREEDOM PARAMETER = NU AND
C             NON-CENTRALITY PARAMETER DELTA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --NU SHOULD BE A POSITIVE INTEGER VARIABLE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORNCTRAN LIBRARY SUBROUTINES NEEDED--LOG, SQRT, SIN, COS.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORNCTRAN (1977)
C     REFERENCES--MOOD AND GRABLE, INTRODUCTION TO THE
C                 THEORY OF STATISTICS, 1963, PAGE 233.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, CONTINUOUS
C                 UNIVARIATE DISTRIBUTIONS--VOLUME 2, SECOND EDITION,
C                 1994, CHAPTER 31.
C               --HASTINGS, EVANS, AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION, WILEY, 2001,
C                 PP. 184-186.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-921-3651
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--2004.3
C     ORIGINAL VERSION--MARCH     2004.
C     UPDATED         --MAY       2004. SUPPORT FOR REAL VALUES OF NU
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      REAL DELTA
      REAL ANU
      DIMENSION X(*)
      DIMENSION Y(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA PI/3.14159265359/
      DATA EPS/0.00001/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
      IF(ANU.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,48)ANU
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE ',
     1'NCTRAN   SUBROUTINE IS NON-POSITIVE *****')
   15 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE ',
     1'NCTRAN   SUBROUTINE IS NON-POSITIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
   48 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C     GENERATE N STUDENT'S NON-CENTRAL T RANDOM NUMBERS
C     USING THE DEFINITION THAT A STUDENT'S NON-CENTRAL T VARIATE
C     WITH NU DEGREES OF FREEDOM AND NON-CENTRALITY PARAMETER
C     DELTA EQUALS A NORMAL VARIATE WITH LOCATION PARAMETER DELTA
C     DIVIDED BY A STANDARDIZED CHI VARIATE
C     (WHERE THE LATTER EQUALS SQRT(CHI-SQUARED/NU).
C     FIRST GENERATE A NORMAL RANDOM NUMBER WITH LOCATION PARAMETER
C     DELTA, THEN GENERATE A STANDARDIZED CHI RANDOM NUMBER,
C     THEN FORM THE RATIO OF THE FIRST DIVIDED BY
C     THE SECOND.
C
      CALL NORRAN(N,ISEED,X)
      NTEMP=1
C
      DO100I=1,N
C
        X(I)=X(I) + DELTA
        CALL CHSRAN(NTEMP,ANU,ISEED,Y)
        X(I)=X(I)/SQRT(Y(1)/ANU)
C
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NEARNE(Y1,X1,N,Y2,D2,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--COMPUTE THE NEAREST NEIGHBOR FOR THE
C              2-D CASE.  THIS USES A BRUTE FORCE ALGORITHM.
C              THE OUTPOUT VECTOR IS THE INDEX OF THE NEAREST
C              NEIGHBOR.
C
C     INPUT  ARGUMENTS--X1 (REAL)
C                     --Y1 (REAL)
C     OUTPUT ARGUMENTS--Y2 (REAL)
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2013/8
C     ORIGINAL VERSION--AUGUST     2013
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL X1(*)
      REAL Y1(*)
      REAL Y2(*)
      REAL D2(*)
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      DOUBLE PRECISION DISTM
      DOUBLE PRECISION DDIST
      DOUBLE PRECISION DX1
      DOUBLE PRECISION DX2
      DOUBLE PRECISION DY1
      DOUBLE PRECISION DY2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'ARNE')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF NEARNE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',3(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X1(I),Y1(I)
   56     FORMAT('I,X1(I),Y1(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK NUMBER OF INPUT OBSERVATIONS.   **
C               ********************************************
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1151)
 1151   FORMAT('***** ERROR IN NEAREST NEIGHBOR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1152)
 1152   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS IS LESS THAN ',
     1         'ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1154)N
 1154   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(N.EQ.1)THEN
        Y2(1)=1.0
        D2(1)=0.0
      ELSEIF(N.EQ.2)THEN
        Y2(1)=2.0
        Y2(2)=1.0
        TERM1=(X1(1) - X1(2))**2
        TERM2=(Y1(1) - Y1(2))**2
        D2(1)=SQRT(TERM1 + TERM2)
        D2(2)=D2(1)
      ENDIF
C
C               ************************************************
C               **  STEP 2--                                  **
C               **  COMPUTE THE NEAREST NEIGHBORS             **
C               ************************************************
C
      DO2000K=1,N
        DISTM=DBLE(CPUMAX)
        IINDX=-1
        DO2100L=1,N
          IF(L.EQ.K)GOTO2100
          DX1=DBLE(X1(K))
          DX2=DBLE(X1(L))
          DY1=DBLE(Y1(K))
          DY2=DBLE(Y1(L))
          DDIST=DSQRT((DX1 - DX2)**2 + (DY1 - DY2)**2)
          IF(DDIST.LT.DISTM)THEN
            IINDX=L
            DISTM=DDIST
          ENDIF
 2100   CONTINUE
        Y2(K)=REAL(IINDX)
        D2(K)=REAL(DISTM)
 2000 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'ARNE')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF NEARNE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IERROR
 9013   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','BUG ')
        DO9021I=1,N
          WRITE(ICOUT,9022)I,Y2(I),D2(I)
 9022     FORMAT('I,Y2(I),D2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 9021   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE NEARN2(X1,Y1,N1,X2,Y2,N2,ICASE,MAXOBV,
     1                  AIINDX,TEMPX,TEMPY,TEMPD,TEMPZ,
     1                  Y3,X3,D3,TAG1,TAG2,N3,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS IS A SLIGHTLY MODIFIED VERSION OF NEARNE.  THE
C              NEARNE ROUTINE TAKES A LIST OF (X,Y) COORDINATE PAIRS
C              AND FINDS THE NEAREST NEIGHBOR OF EACH POINT.  THIS
C              ROUTINE TAKES TWO LISTS OF (X,Y) COORDINATE PAIRS.
C              FOR EACH ROW OF THE FIRST LIST, THE SECOND LIST IS
C              SEARCHED TO FIND THE NEAREST NEIGHBOR.  THERE ARE
C              TWO ALTERNATIVES.  IN THE FIRST ALTERNATIVE, ONLY
C              THE SINGLE NEAREST NEIGBOR IS RETURNED.  FOR THE
C              SECOND ALTERNATIVE, WE RETURN A SORTED LIST OF
C              NEAREST NEIGBORS.  THIS CAN BE HELPFUL IF YOU NEED
C              THE "SECOND" NEAREST NEIGHBOR OR THE "THIRD" NEAREST
C              NEIGHBOR, AND SO ON.
C
C     INPUT  ARGUMENTS--X1 (REAL)
C                     --Y1 (REAL)
C     OUTPUT ARGUMENTS--Y2 (REAL)
C
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2013/9
C     ORIGINAL VERSION--SEPTEMBER  2013
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      REAL X1(*)
      REAL Y1(*)
      REAL X2(*)
      REAL Y2(*)
      REAL X3(*)
      REAL Y3(*)
      REAL D3(*)
      REAL TAG1(*)
      REAL TAG2(*)
      REAL TEMPX(*)
      REAL TEMPY(*)
      REAL TEMPD(*)
      REAL TEMPZ(*)
      REAL AIINDX(*)
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      DOUBLE PRECISION DISTM
      DOUBLE PRECISION DDIST
      DOUBLE PRECISION DX1
      DOUBLE PRECISION DX2
      DOUBLE PRECISION DY1
      DOUBLE PRECISION DY2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'ARN2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF NEARN2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N1,N2
   52   FORMAT('IBUGA3,ISUBRO,N1,N2 = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N1
          WRITE(ICOUT,56)I,X1(I),Y1(I)
   56     FORMAT('I,X1(I),Y1(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        DO65I=1,N2
          WRITE(ICOUT,66)I,X2(I),Y2(I)
   66     FORMAT('I,X2(I),Y2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   65   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK NUMBER OF INPUT OBSERVATIONS.   **
C               ********************************************
C
      IF(N1.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1151)
 1151   FORMAT('***** ERROR IN NEAREST NEIGHBOR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1152)
 1152   FORMAT('      THE NUMBER OF OBSERVATIONS FOR (X1,Y1) ',
     1         'IS LESS THAN ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1154)N1
 1154   FORMAT('      THE NUMBER OF OBSERVATIONS = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(N2.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1151)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1162)
 1162   FORMAT('      THE NUMBER OF OBSERVATIONS FOR (X2,Y2) ',
     1         'IS LESS THAN ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1154)N2
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  CASE ONE: FIND THE SINGLE NEAREST NEIGHBOR **
C               *************************************************
C
      IF(ICASE.EQ.1)THEN
        DO2010J=1,N2
          DX1=DBLE(X2(J))
          DY1=DBLE(Y2(J))
          DISTM=DBLE(CPUMAX)
          DO2020K=1,N1
            DX2=DBLE(X1(K))
            DY2=DBLE(Y1(K))
            DDIST=DSQRT((DX1 - DX2)**2 + (DY1 - DY2)**2)
            IF(DDIST.LT.DISTM)THEN
              DISTM=DDIST
              X3(J)=X1(K)
              Y3(J)=Y1(K)
              D3(J)=REAL(DDIST)
            ENDIF
 2020     CONTINUE
 2010   CONTINUE
        N3=N2
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  CASE TWO: RETURN SORTED LIST OF DISTANCES  **
C               *************************************************
C
      ELSEIF(ICASE.EQ.2)THEN
        IF(N1*N2.GT.MAXOBV)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1151)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,3052)MAXOBV
 3052     FORMAT('      THE NUMBER OF OUTPUT ROWS EXCEEDS THE ',
     1           'MAXIMUM ALLOWED (',I8,')')
          CALL DPWRST('XXX','BUG ')
          IERROR='YES'
          GOTO9000
        ENDIF
C
        ICNT=0
        DO3010J=1,N2
          DX1=DBLE(X2(J))
          DY1=DBLE(Y2(J))
C
          IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'ARN2')THEN
            WRITE(ICOUT,3011)J,DX1,DY1
 3011       FORMAT('J,DX1,DX2 = ',I8,2G15.7)
           CALL DPWRST('XXX','BUG ')
          ENDIF
C
          DO3020K=1,N1
            DX2=DBLE(X1(K))
            DY2=DBLE(Y1(K))
            DDIST=DSQRT((DX1 - DX2)**2 + (DY1 - DY2)**2)
            TEMPX(K)=X1(K)
            TEMPY(K)=Y1(K)
            TEMPD(K)=REAL(DDIST)
            AIINDX(K)=REAL(K)
 3020     CONTINUE
C
C         NOW SORT THE DATA
C
          CALL SORTI(TEMPD,N1,TEMPZ,AIINDX)
          DO3030K=1,N1
            ICNT=ICNT+1
            IINDX=INT(AIINDX(K)+0.1)
            D3(ICNT)=TEMPD(K)
            X3(ICNT)=TEMPX(IINDX)
            Y3(ICNT)=TEMPY(IINDX)
            TAG1(ICNT)=REAL(J)
            TAG2(ICNT)=REAL(K)
 3030     CONTINUE
 3010   CONTINUE
        N3=ICNT
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'ARN2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF NEARN2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IERROR,N3
 9013   FORMAT('IERROR,N3 = ',A4,2X,I8)
        CALL DPWRST('XXX','BUG ')
        DO9021I=1,N3
          WRITE(ICOUT,9022)I,X3(I),Y3(I),D3(I)
 9022     FORMAT('I,X3(I),Y3(I),D3(I) = ',I8,3G15.7)
          CALL DPWRST('XXX','BUG ')
 9021   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE NEIGH(IT,NN,XS,N,I1,I2,ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--FOR THE IT-TH HORIZONTAL ORDERED DATA POINT XS(IT),
C              DETERMINE THE INDICES I1 AND I2 WHICH DEFINE
C              THE NN NEAREST NEIGHBORS OF XS(IT).
C     NOTE--XS(IT) IS CONSIDERED A NEIGHBOR OF ITSELF.
C     REFERENCE--CHAMBERS, ET AL.  GRAPHICAL METHODS FOR DATA ANALYSIS.
C                WADSWORTH, 1983, PAGES 94-98, 121-122.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--88/2
C     ORIGINAL VERSION--FEBRUARY   1988
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION XS(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='EIGH'
      ISUBN2='H   '
C
      I1=(-999)
      I2=(-999)
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'EIGH')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF NEIGH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)ISUBRO,IBUGA3,IERROR
   52 FORMAT('ISUBRO,IBUGA3,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)IT,NN,N
   53 FORMAT('IT,NN,N = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)I1,I2
   54 FORMAT('I1,I2 = ',2I8)
      CALL DPWRST('XXX','BUG ')
   90 CONTINUE
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.GE.1)GOTO119
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN NEIGH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT FULL SAMPLE SIZE,')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      FOR WHICH LOWESS NEIGHBORHOODS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      ARE TO BE COMPUTED, MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)N
  116 FORMAT('      THE FULL SAMPLE SIZE N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  119 CONTINUE
C
      IF(IT.GE.1)GOTO129
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,121)
  121 FORMAT('***** ERROR IN NEIGH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,122)
  122 FORMAT('      THE INPUT TARGET OBSERVATION INDEX')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,123)
  123 FORMAT('      FOR WHICH A LOWESS IS TO BE CARRIED OUT')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,124)N
  124 FORMAT('      MUST BE BETWEEN 1 AND ',I8,' (INCLUSIVE).')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,125)
  125 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,126)IT
  126 FORMAT('      THE TARGET OBSERVATION INDEX IT = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  129 CONTINUE
C
      IF(NN.GE.1)GOTO139
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,131)
  131 FORMAT('***** ERROR IN NEIGH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,132)
  132 FORMAT('      THE INPUT NEIGHBORHOOD SIZE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,133)
  133 FORMAT('      FOR WHICH A LOWESS IS TO BE CARRIED OUT')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,134)N
  134 FORMAT('      MUST BE BETWEEN 1 AND ',I8,' (INCLUSIVE).')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,135)
  135 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,136)NN
  136 FORMAT('      THE NEIGHBORHOOD SIZE NN = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
  139 CONTINUE
C
C               ***********************************************
C               **  STEP 11--                                **
C               **  COMPUTE THE INDICES OF THE NEIGHBORHOOD  **
C               ***********************************************
C
      I1=IT
      I2=IT
      NNI=1
C
      IF(NN.LE.1)GOTO1190
      DO1100I=2,NN
C
      IF(I1.LE.1)GOTO1110
      IF(I2.GE.N)GOTO1120
      GOTO1130
C
 1110 CONTINUE
      I2=I2+1
      NNI=NNI+1
      GOTO1100
C
 1120 CONTINUE
      I1=I1-1
      NNI=NNI+1
      GOTO1100
C
 1130 CONTINUE
      I1M1=I1-1
      I2P1=I2+1
      DEL1=ABS(XS(IT)-XS(I1M1))
      DEL2=ABS(XS(I2P1)-XS(IT))
      IF(DEL1.LT.DEL2)I1=I1M1
      IF(DEL1.GE.DEL2)I2=I2P1
      NNI=NNI+1
      GOTO1100
C
 1100 CONTINUE
 1190 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF'.AND.ISUBRO.NE.'EIGH')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF NEIGH--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)ISUBRO,IBUGA3,IERROR
 9012 FORMAT('ISUBRO,IBUGA3,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)IT,NN,N
 9013 FORMAT('IT,NN,N = ',3I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)I1,I2
 9014 FORMAT('I1,I2 = ',2I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE NEXT (RCOMBO, R, N, INIT)
C
C        ALGORITHM AS 304.7 APPL.STATIST. (1996), VOL.45, NO.3
C
C        Accepts some R-combination of the first N integers and then
C        computes the next R-combination in the lexicographic
C        ordering of the N! / (R! * (N - R)!) such R-combinations.  
C        Returns the first R-combination if the initialization 
C        indicator is .true. and then resets the indicator.
C
C        DATAPLOT NOTE: THIS IS A UTILITY ROUTINE USED BY
C                       FISHER TWO SAMPLE RANDOMIZATION TEST
C
      INTEGER R, N, RCOMBO(R)
      LOGICAL INIT
C
      INTEGER I, J, D
C
      IF (INIT) THEN
         DO 10 I = 1, R
            RCOMBO(I) = I
   10    CONTINUE
         INIT = .FALSE.
      ELSE
         D = N - R
         J = R
C
C        The counter J is not prevented from going out of bounds
C        which will happen if there is no next R-combination
C
   20    IF (RCOMBO(J) .LT. D + J) GOTO 30
         J = J - 1
         GOTO 20
   30    RCOMBO(J) = RCOMBO(J) + 1
         DO 40 I = J + 1, R
            RCOMBO(I) = RCOMBO(I - 1) + 1
   40    CONTINUE
      END IF
C
      RETURN
      END
      SUBROUTINE NMXCDF(X,U1,SD1,U2,SD2,P,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MIXTUURE NORMAL (GAUSSIAN)
C              DISTRIBUTION.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NODCDF.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS, 2ND. ED.--1, 1994, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--98.5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DARG1
      DOUBLE PRECISION DCDF1
      DOUBLE PRECISION DCDF2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(SD1.LE.0.0)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
  101 FORMAT('*****ERROR FROM NMXCDF--FIRST SCALE PARAMETER IS ',
     1       'NOT POSITVE.')
      IF(SD2.LE.0.0)THEN
        WRITE(ICOUT,103)
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
  103 FORMAT('*****ERROR FROM NMXCDF--SECOND SCALE PARAMETER IS ',
     1       'NOT POSITIVE.')
C
      DARG1=DBLE((X-U1)/SD1)
      CALL NODCDF(DARG1,DCDF1)
      DARG1=DBLE((X-U2)/SD2)
      CALL NODCDF(DARG1,DCDF2)
C
      CDF=REAL(DBLE(P)*DCDF1 + DBLE(1.0-P)*DCDF2)
C
 9000 CONTINUE
C
      RETURN
      END
      SUBROUTINE NMDCDF(X,U1,SD1,U2,SD2,P,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE MIXTUURE NORMAL (GAUSSIAN)
C              DISTRIBUTION.  SAME AS NMXCDF EXCEPT THAT THE
C              CDF RETURNED IS DOUBLE PRECISION.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NODCDF.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS, 2ND. ED.--1, 1994, CHAPTER 12.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--98.5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DARG1
      DOUBLE PRECISION DCDF1
      DOUBLE PRECISION DCDF2
      DOUBLE PRECISION CDF
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(SD1.LE.0.0)THEN
        WRITE(ICOUT,101)
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
  101 FORMAT('*****ERROR FROM NMXCDF--FIRST SCALE PARAMETER IS ',
     1       'NOT POSITVE.')
      IF(SD2.LE.0.0)THEN
        WRITE(ICOUT,103)
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9000
      ENDIF
  103 FORMAT('*****ERROR FROM NMXCDF--SECOND SCALE PARAMETER IS ',
     1       'NOT POSITIVE.')
C
      DARG1=DBLE((X-U1)/SD1)
      CALL NODCDF(DARG1,DCDF1)
      DARG1=DBLE((X-U2)/SD2)
      CALL NODCDF(DARG1,DCDF2)
C
      CDF=DBLE(P)*DCDF1 + DBLE(1.0-P)*DCDF2
C
 9000 CONTINUE
C
      RETURN
      END
      SUBROUTINE NMXML1(Y,X,N,NVAR,Y2,X2,N2,
     1                  TEMP1,TEMP2,TEMP3,WORK,ITEMP1,MAXNXT,
     1                  CLLIMI,CLWIDT,NCOMP,IHSTCW,
     1                  ALPHA,XMEAN,XSD,KMAX,NTOT2,ALOGL,
     1                  AMEAN,ASD,AMIN,AMAX,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD
C              ESTIMATES FOR THE NORMAL MIXTURE DISTRIBUTION
C              IT USES APPLIED STATISTICS ALGORITHM 203 TO
C              PERFORM THE MAXIMUM LIKELIHOOD ESTIMATION.
C
C              THERE ARE TWO CASES:
C
C              1) ONE VARIABLE CASE: Y IS RAW DATA
C                 A) CALL DPBIN TO BIN DATA
C                 B) IF USER HAS SPECIFIED CLASS LIMITS OR WIDTH,
C                    PASS TO DPBIN.
C              2) TWO VARIABLE CASE: Y IS FREQUENCY, X IS CLASS
C                 MID-POINT.
C
C              NCOMP DEFINES NUMBER OF NORMAL DISTRIBUTIONS BEING
C              FIT.  MAXIMUM OF 20 ALLOWED.
C
C              EXTRACTED FROM DPMLNM IN ORDER TO MAKE IT EASIER TO
C              USE BY OTHER COMMANDS (E.G., GOODNESS OF FIT, BOOTSTRAP).
C     EXAMPLE--NORMAL MIXTURE MAXIMUM LIKELIHOOD Y
C            --NORMAL MIXTURE MAXIMUM LIKELIHOOD Y X
C     REFERENCE--"MAXIMUM LIKELIHOOD ESTIMATION OF MIXTURES OF
C                DISTRIBUTIONS", M. AGHA AND T. IBRAHIM,
C                APPLIED STATISTICS, 1984, VOLUME 33, NO. 3,
C                PP. 327-329.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/3
C     ORIGINAL VERSION--MARCH     2011. EXTRACTED FROM DPMLNM
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IHSTCW
      CHARACTER*4 IHSTO2
      CHARACTER*4 IRELAT
      CHARACTER*4 IRHSTG
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      PARAMETER (MMAX=200)
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION Y2(*)
      DIMENSION X2(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION TEMP3(*)
      DIMENSION CLLIMI(*)
      DIMENSION CLWIDT(*)
      INTEGER   ITEMP1(*)
C
      REAL TOL
C
      REAL ALPHA(*)
      REAL XMEAN(*)
      REAL XSD(*)
C
C     FOR STORAGE EFFICIENCY, USE SINGLE "WORK" ARRAY FOR FOLLOWING.
C     TO AVOID CONFUSION, LEAVE ALPHA, XMEAN, AND XSD AS DISTINCT
C     ARRAYS (THESE TAKE A MINIMAL AMOUNT OF STORAGE, SINCE THESE
C     REFERENCED IN THIS ROUTINE, KEEP CLARITY IN CODE)
C
      DIMENSION WORK(*)
C
CCCCC REAL NEWALP(KMAX)
CCCCC REAL NEWMEA(KMAX)
CCCCC REAL NEWSD(KMAX)
CCCCC REAL DT(KMAX)
CCCCC REAL NT(KMAX)
CCCCC REAL VT(KMAX)
CCCCC REAL G(MMAX)
CCCCC REAL F(MMAX,KMAX)
C
CCCCC EQUIVALENCE(NEWALP(1), WORK(1))
CCCCC EQUIVALENCE(NEWMEA(1), WORK(KMAX + 1))
CCCCC EQUIVALENCE(NEWSD(1),  WORK(2*KMAX + 1))
CCCCC EQUIVALENCE(DT(1),     WORK(3*KMAX + 1))
CCCCC EQUIVALENCE(NT(1),     WORK(4*KMAX + 1))
CCCCC EQUIVALENCE(VT(1),     WORK(5*KMAX + 1))
CCCCC EQUIVALENCE(G(1),      WORK(6*KMAX + 1))
CCCCC EQUIVALENCE(F(1,1),    WORK(7*KMAX + 1))
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT---------------------------------------------------
C
      ISUBN1='NMXM'
      ISUBN2='L1  '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NMXML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,IHSTCW,IHSTO2,IRELAT,IRHSTG
   52   FORMAT('IBUGA3,ISUBRO,IHSTCW,IHSTO2,IRELAT,IRHSTG = ',
     1         5(A4,2X),A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)N,NCOMP,NVAR,KMAX,MAXNXT
   53   FORMAT('N,NCOMP,NVAR,KMAX,MAXNXT = ',5I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,54)CLWIDT(1),CLLIMI(1),CLLIMI(2)
   54   FORMAT('CLWIDT(1),CLLIMI(1),CLLIMI(2) = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,N
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 11--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='11'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'XML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NCOMP.LT.2 .OR. NCOMP.GT.KMAX)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
 1111   FORMAT('***** ERROR IN NORMAL MIXTURE MAXIMUM LIKELIHOOD ',
     1         'ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1123)
 1123   FORMAT('      THE SPECIFIED NUMBER OF COMPONENT ',
     1         'DISTRIBUTIONS IS')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1125)KMAX
 1125   FORMAT('      LESS THAN 2 OR GREATER THAN ',I8,'.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1127)NCOMP
 1127   FORMAT('      NUMBER OF COMPONENTS = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      NPERC=0
      NMIN=5
      IF(NVAR.EQ.1)THEN
        CALL CKDIST(Y,N,NMIN,TEMP2,NPERC,ISUBRO,IBUGA3,IERROR)
      ELSEIF(NVAR.EQ.2)THEN
        CALL CKDIS2(Y,X,TEMP1,N,MAXNXT,NMIN,TEMP2,NPERC,NTOT2,
     1              ISUBRO,IBUGA3,IERROR)
      ENDIF
      IF(IERROR.EQ.'YES')GOTO9000
C
      IF(NVAR.EQ.1)THEN
        CALL SORT(Y,N,TEMP2)
        DO1160I=1,N
          Y(I)=TEMP2(I)
 1160   CONTINUE
      ELSEIF(NVAR.EQ.2)THEN
        CALL SORTC(X,Y,N,TEMP1,TEMP2)
        DO1210I=1,N
          X(I)=TEMP1(I)
          Y(I)=TEMP2(I)
 1210   CONTINUE
      ENDIF
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1301)N
 1301   FORMAT('AFTER SORT, N = ',I8)
        CALL DPWRST('XXX','WRIT')
        DO1310I=1,MIN(N,100)
          WRITE(ICOUT,1311)I,X(I),Y(I)
 1311     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
 1310   CONTINUE
      ENDIF
C
C               *****************************************
C               **  STEP 21--                          **
C               **  CARRY OUT CALCULATIONS             **
C               **  FOR NORMAL MIXTURE MLE ESTIMATION  **
C               *****************************************
C
 2100 CONTINUE
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'XML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERROR='NO'
      IWRITE='OFF'
      TOL=1.0E-6
      IA = 1
      K = NCOMP
      IC = 0
C
      IF(NVAR.EQ.1)THEN
        NTOT2=N
        CALL MEAN(Y,N,IWRITE,AMEAN,IBUGA3,IERROR)
        CALL SD(Y,N,IWRITE,ASD,IBUGA3,IERROR)
        AMIN=Y(1)
        AMAX=Y(N)
        IRELAT='OFF'
        IRHSTG='PERC'
        CLWID=CLWIDT(1)
        IHSTO2='ON'
        CALL DPBIN(Y,N,IRELAT,CLWID,CLLIMI(1),CLLIMI(2),IRHSTG,
     1             TEMP3,MAXNXT,IHSTCW,IHSTO2,
     1             Y2,X2,N2,IBUGA3,IERROR)
C
        M=N2
        DO2210I=1,N2
          ITEMP1(I)=INT(Y2(I)+0.5)
 2210   CONTINUE
C
      ELSE
        M=N
        DO2310I=1,M
          ITEMP1(I)=INT(Y(I)+0.5)
          X2(I)=X(I)
 2310   CONTINUE
        DELTA=X2(2) - X2(1)
        AMIN=X2(1) - (DELTA/2.0)
        AMAX=X2(M) + (DELTA/2.0)
        DSUM1=0.0D0
        NTOT=0
        DO2220I=1,M
          NTOT=NTOT + ITEMP1(I)
          DSUM1= DSUM1 + DBLE(ITEMP1(I))*DBLE(X2(I))
 2220   CONTINUE
        AMEAN=REAL(DSUM1/DBLE(NTOT2))
        DSUM1=0.0D0
        DO2230I=1,M
          TERM1=X2(I) - AMEAN
          DSUM1= DSUM1 + DBLE(ITEMP1(I))*(DBLE(TERM1)**2)
 2230   CONTINUE
        ASD=REAL(DSUM1/DBLE(NTOT2))
      ENDIF
C
      ACOMP=REAL(NCOMP)
      PTEMP=1.0/ACOMP
      DO2410I=1,NCOMP
        ALPHA(I)=PTEMP
        XSD(I)=ASD
        XMEAN(I)=AMIN + REAL(I)*PTEMP*(AMAX-AMIN)
 2410 CONTINUE
      XMEAN(NCOMP)=XMEAN(NCOMP) - 0.5*PTEMP*(AMAX-AMIN)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        DO2412I=1,N2
          WRITE(ICOUT,2411)I,X2(I),ITEMP1(I)
 2411     FORMAT('I,X2(I),ITEMP1(I) = ',I8,G15.7,I8)
          CALL DPWRST('XXX','WRIT')
 2412   CONTINUE
      ENDIF
C
      CALL MIXTUR(IA,K,M,IC,X2,ITEMP1,
     1            ALPHA,XMEAN,XSD,TOL,NTOT2,
CCCCC1            NEWALP,NEWMEA,NEWSD,DT,NT,VT,G,F,KMAX,MMAX,
     1            WORK(1),WORK(KMAX+1),WORK(2*KMAX+1),WORK(3*KMAX+1),
     1            WORK(4*KMAX+1),WORK(5*KMAX+1),WORK(6*KMAX+1),
     1            WORK(7*KMAX+1),
     1            KMAX,MMAX,
     1            ALOGL,ICOUNT,IFAULT)
C
      IF(IFAULT.EQ.1)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2013)
 2013   FORMAT('     AN INVALID  CHOICE FOR DISTRIBUTION WAS MADE.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2015)
 2015   FORMAT('     VALUE OF IA = ',I8)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2023)
 2023   FORMAT('     A MIXING PARAMETER OUTSIDE THE (0,1] ',
     1         'INTERVAL WAS SPECIFIED.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2033)
 2033   FORMAT('     MEAN IS OUTSIDE THE RANGE OF THE DATA.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2043)
 2043   FORMAT('     A NON-POSITIVE STANDARD DEVIATION WAS ',
     1         'SPECIFIED.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2053)
 2053   FORMAT('     INPUT DATA WAS NOT SORTED.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.6)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2063)
 2063   FORMAT('     A NEGATIVE FREQUENCY WAS SPECIFIED OR THE ')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2065)
 2065   FORMAT('     TOTAL FREQUENCY IS LESS THAN 2 TIMES THE ',
     1         'NUMBER OF CLASSES.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.7)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2073)
 2073   FORMAT('     NEGATIVE FREQUENCY SPECIFIED FOR NON-NORMAL ',
     1         'DISTRIBUTION.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.8)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2083)
 2083   FORMAT('     EQUAL MEANS SPECIFIED FOR NON-NORMAL ',
     1         'DISTRIBUTION.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ELSEIF(IFAULT.EQ.9)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1111)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2093)
 2093   FORMAT('     ALL MEANS AND ALL STANDARD DEVIATIONS ',
     1         'WERE SPECIFIED EQUAL.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      IF(IFAULT.GT.0)THEN
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF NMXML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9012)N,IBUGA3,IERROR
 9012   FORMAT('N,IBUGA3,IERROR = ',I8,2X,A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)N
 9015   FORMAT('N = ',I8)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NMXPPF(P,U1,SD1,U2,SD2,PMIX,PPF)
C
C     PURPOSE   --PERCENT POINT FUNCTION FOR THE NORMAL MIXTURE
C                 DISTRIBUTION.  USES A BISECTION METHOD.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION FXL
      DOUBLE PRECISION FXR
      DOUBLE PRECISION XLD
      DOUBLE PRECISION XRD
      DOUBLE PRECISION P1
      DOUBLE PRECISION X
      DOUBLE PRECISION PPFD
      DOUBLE PRECISION FCS
      DOUBLE PRECISION XRML
      DOUBLE PRECISION SIG
      DOUBLE PRECISION EPS
      DOUBLE PRECISION ZERO
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA EPS /0.00001D0/
      DATA SIG /1.0D-6/
      DATA ZERO /0.D0/
      DATA MAXIT /20000/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
    1 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1' NMXPPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
      IF(SD1.LE.0.0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SD1
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   11 FORMAT('***** FATAL ERROR--THE FIRST SCALE PARAMETER TO THE ',
     1' NMXPPF SUBROUTINE IS LESS THAN OR EQUAL TO 0.')
      IF(SD2.LE.0.0)THEN
        WRITE(ICOUT,13)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)SD2
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   13 FORMAT('***** FATAL ERROR--THE SECOND SCALE PARAMETER TO THE ',
     1' NMXPPF SUBROUTINE IS LESS THAN OR EQUAL TO 0.')
C
      IF(PMIX.LT.0.0 .OR. PMIX.GT.1.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)PMIX
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   15 FORMAT('***** FATAL ERROR--THE MIXING PARAMETER TO THE ',
     1' NMXPPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I15,' *****')
C
   90 CONTINUE
C
C  FIND BRACKETING INTERVAL.
C
      XMEAN=PMIX*U1 + (1.0-PMIX)*U2
      XVAR=PMIX*SD1*SD1 + (1.0-PMIX)*SD2*SD2 +
     1     PMIX*(1.0-PMIX)*(U1-U2)*(U1-U2)
      XSD=SQRT(XVAR)
C
      ICOUNT=0
      MAXCNT=100
C
      XL=XMEAN
      XINC=XSD
C
   91 CONTINUE
      XR=XL+XINC
      CALL NMXCDF(XL,U1,SD1,U2,SD2,PMIX,CDFL)
      CALL NMXCDF(XR,U1,SD1,U2,SD2,PMIX,CDFR)
      IF(CDFL.LT.P .AND. CDFR.LT.P)THEN
        XL=XR
      ELSEIF(CDFL.GT.P .AND. CDFR.GT.P)THEN
        XL=XL-XINC
      ELSE
        GOTO99
      ENDIF
      ICOUNT=ICOUNT+1
      IF(ICOUNT.GT.MAXCNT)THEN
        WRITE(ICOUT,96)
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
   96 FORMAT('***** FATAL ERROR--NMXPPF UNABLE TO FIND BRACKETING ',
     *       'INTERVAL. *****')
      GOTO91
C
C  BISECTION METHOD
C
   99 CONTINUE
      XLD=DBLE(XL)
      XRD=DBLE(XR)
      IC = 0
      FXL = DBLE(-P)
      FXR = DBLE(1.0 - P)
  105 CONTINUE
      X = (XLD+XRD)*0.5D0
      CALL NMDCDF(REAL(X),U1,SD1,U2,SD2,PMIX,DCDF)
      P1=DCDF
      PPFD=X
      PPF=REAL(PPFD)
      FCS = P1 - DBLE(P)
      IF(FCS*FXL.GT.ZERO)GOTO110
      XRD = X
      FXR = FCS
      GOTO115
  110 CONTINUE
      XLD = X
      FXL = FCS
  115 CONTINUE
      XRML = XRD - XLD
      IF(XRML.LE.SIG .AND. ABS(FCS).LE.EPS)GOTO9999
      IC = IC + 1
      IF(IC.LE.MAXIT)GOTO105
      WRITE(ICOUT,130)
      CALL DPWRST('XXX','BUG ')
  130 FORMAT('***** FATAL ERROR--NMXPPF ROUTINE DID NOT CONVERGE. ***')
      GOTO9999
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE NMXRAN(N,U1,SD1,U2,SD2,P,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE THE NORMAL (GAUSSIAN) MIXTURE
C              DISTRIBUTION.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NORMAL MIXTURE DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG, SQRT, SIN, COS.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     METHOD--1) CALCULATE UNIFORM RAND NUMBER.
C             2) IF LESS THAN OR EQUAL TO P, CALCULATE RAND NUMBER
C                FROM NORMAL WITH U1, SD1
C             3) IF GREATER THAN P, CALCULATE RAND NUMBER
C                FROM NORMAL WITH U2, SD2
C     REFERENCES--FOWLKES, "SOME METHODS FOR STUDYING THE MIXTURE
C                 OF TWO NORMAL (LOGNORMAL) DSITRIBUTIONS', 
C                 JOURNAL OF THE AMERICAN STATISTICAL ASSOCIATION,
C                 SEPTEMBER, 1979.  PAGES 561-575.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--98.5
C     ORIGINAL VERSION--MAY       1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(1)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO50
      GOTO90
   50 WRITE(ICOUT, 5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)N
      CALL DPWRST('XXX','BUG ')
      RETURN
   90 CONTINUE
    5 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'NMXRAN SUBROUTINE IS NON-POSITIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
      CALL UNIRAN(N,ISEED,X)
C
      NTEMP=1
      DO200I=1,N
        CALL NORRAN(NTEMP,ISEED,Y)
        IF(X(I).LE.P)THEN
          X(I)=U1 + SD1*Y(1)
        ELSE
          X(I)=U2 + SD2*Y(1)
        ENDIF
  200 CONTINUE
C
      RETURN
      END
      SUBROUTINE NORCDF(X,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 932, FORMULA 26.2.17.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --OCTOBER   1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA B1,B2,B3,B4,B5,P/.319381530,-0.356563782,1.781477937,-1.82125
     15978,1.330274429,.2316419/
C
C-----START POINT-----------------------------------------------------
C
      Z=X
      IF(X.LT.0.0)Z=-Z
      T=1.0/(1.0+P*Z)
      CDF=1.0-((0.39894228040143  )*EXP(-0.5*Z*Z))*(B1*T+B2*T**2+B3*T**3
     1+B4*T**4+B5*T**5)
      IF(X.LT.0.0)CDF=1.0-CDF
C
      RETURN
      END
      SUBROUTINE NORFUN (N, X, FVEC, IFLAG, XDATA, NOBS)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE FUNCTIONS FOR THE
C              CENSORED NORMAL MAXIMUM LIKELIHOOD EQUATIONS.
C
C                 SUM[i=1 to r][Z(I)] + SUM[j=1 to m][h(y(i)] = 0
C                 SUM[i=1 to r][Z(I)**2] + SUM[j=1 to m][y(i)*h(y(i)] - r = 0
C
C              WITH
C
C                 r = NUMBER OF FAILURE TIMES
C                 m = NUMBER OF CENSORED ITEMS
C
C                 Z(I) = (X(i) - muhat)/sigmahat
C                 Y(I) = (C(j) - muhat)/sigmahat
C
C                 h IS THE NORMAL HAZARD FUNCTION.
C
C              WITH C AND K DENOTING THE SHAPE PARAMETERS,
C              RESPECTIVELY.  THE muhat AND sigmahat PARAMETERS ARE
C              THE QUANTITIES BEING ESTIMATED.  USE THE MEAN AND
C              STANDARD DEVIATION OF THE FAILURE TIMES DATA AS
C              STARTING VALUES.
C
C              TO SIMPLIFY THE INTERFACE, SORT THE INPUT DATA
C              ARRAY, X, SO THAT THE r FAILURE TIMES COME FIRST
C              AND THEN THE M CENSOR TIMES.
C
C              CALLED BY DNSQE ROUTINE FOR SOLVING SIMULTANEOUS
C              NONLINEAR EQUATIONS.  NOTE THAT THE CALLING SEQUENCE
C              DID NOT ACCOMODATE A DATA ARRAY (AND ASSCIATED NUMBER OF
C              OBSERVATIONS), SO THESE WERE ADDED TO THE CALL LIST.
C     EXAMPLE--NORMAL MAXIMUM LIKELIHOOD Y CENSOR
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2003/11
C     ORIGINAL VERSION--NOVEMBER  2003.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION X(*)
      DOUBLE PRECISION FVEC(*)
      REAL XDATA(*)
C
      DOUBLE PRECISION MU
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION DN
      DOUBLE PRECISION DX
      DOUBLE PRECISION DR
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DCDF
C
C---------------------------------------------------------------------
C
      COMMON/NORCML/IR
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      MU=X(1)
      SIGMA=X(2)
      DN=DBLE(NOBS)
      DR=DBLE(IR)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO200I=1,IR
        DX=DBLE(XDATA(I))
        DX=(DX - MU)/SIGMA
        DSUM1=DSUM1 + DX
        DSUM2=DSUM2 + DX*DX
  200 CONTINUE
C
      DSUM3=0.0D0
      DSUM4=0.0D0
      IF(IR.LT.NOBS)THEN
        DO300I=IR+1,NOBS
          DX=DBLE(XDATA(I))
          DX=(DX - MU)/SIGMA
          CALL NODPDF(DX,DPDF)
          CALL NODCDF(DX,DCDF)
          DHAZ=DPDF/(1.0D0 - DCDF)
          DSUM3=DSUM3 + DHAZ
          DSUM4=DSUM4 + DX*DHAZ
  300   CONTINUE
      ENDIF
C
      FVEC(1)=DSUM1 + DSUM3
      FVEC(2)=DSUM2 + DSUM4 - DR
C
      RETURN
      END
      SUBROUTINE NORLI1(Y,N,ALOC,SCALE,
     1ALIK,AIC,AICC,BIC,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE NORMAL DISTRIBUTION.  THIS IS FOR THE RAW DATA
C              CASE (I.E., NO GROUPING AND NO CENSORING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORL'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RLI1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
C     LOG-LIKELIHOOD FUNCTION IS:
C
C     -(N/2)*LOG(2*PI) - N*LOG(SIGMA) -
C     0.5*SUM[i=1 to N][((X(I)-MU)/SIGMA)**2]
C
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DTERM1=-(DN/2.0D0)*DLOG(2.0D0*DPI) - DN*DLOG(DS)
      DSUM1=0.0D0
      DO1000I=1,N
        DX=DBLE(Y(I))
        DSUM1=DSUM1 + ((DX-DU)/DS)**2
 1000 CONTINUE
C
      DLIK=DTERM1 - 0.5D0*DSUM1
      ALIK=REAL(DLIK)
      DNP=2.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORLI2(Y,X,N,IR,ALOC,SCALE,
     1ALIK,AIC,AICC,BIC,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE NORMAL DISTRIBUTION.  THIS IS FOR RIGHT CENSORED
C              DATA WITH NO GROUPING.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DS
      DOUBLE PRECISION DU
      DOUBLE PRECISION DN
      DOUBLE PRECISION DPI
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORL'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORLI2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SCALE
   55   FORMAT('N,ALOC,SCALE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
C     LOG-LIKELIHOOD FUNCTION IS (WE ASSUME THE FAILURE TIMES
C     ARE IN OBSERVATIONS 1 TO R AND THE CENSORING TIMES ARE IN
C     OBSERVATIONS R+1 TO N):
C
C     -(R/2)*LOG(2*PI) - R*LOG(SIGMA) -
C     0.5*SUM[i=1 to R][((Y(I)-MU)/SIGMA)**2] +
C     SUM[i=R+1 to N][1 - NORCDF(Y(I),MU,SIGMA)]
C
      DR=DBLE(IR)
      DN=DBLE(N)
      DS=DBLE(SCALE)
      DU=DBLE(ALOC)
      DTERM1=-(DR/2.0D0)*DLOG(2.0D0*DPI) - DR*DLOG(DS)
      DSUM1=0.0D0
      DO1000I=1,IR
        DX=DBLE(Y(I))
        DSUM1=DSUM1 + ((DX-DU)/DS)**2
 1000 CONTINUE
C
      DSUM2=0.0D0
      IF(IR.LT.N)THEN
        DO2000I=IR+1,N
          DX=DBLE(Y(I))
          DX=(DX-DU)/DS
          CALL NODCDF(DX,DCDF)
          DSUM2=DSUM2 + (1.0D0 - DCDF)
 2000   CONTINUE
      ENDIF
C
      DLIK=DTERM1 - 0.5D0*DSUM1 + DSUM2
      ALIK=REAL(DLIK)
      DNP=2.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'LIK2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORLI2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DSUM2,DTERM1,DTERM3,DCDF
 9013   FORMAT('DSUM1,DSUM2,DTERM1,DTERM3,DCDF = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORML1(Y,N,ICASE,
     1ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,NUMOUT,
     1XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE NORMAL DISTRIBUTION FOR THE RAW DATA CASE
C              (I.E., NO CENSORING AND NO GROUPING).  IT WILL ALSO
C              RETURN THE CONFIDENCE INTERVALS FOR THE LOCATION
C              AND SCALE PARAMETERS.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLN1 WILL GENERATE THE OUTPUT
C              FOR THE NORMAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --JOHNSON, KEMP, AND KOTZ.  "UNIVARIATE DISCRETE
C                DISTRIBUTIONS", THIRD EDITION, WILEY, 2005, CHAPTER 5.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLNO)
C     UPDATED         --OCTOBER   2009. ADD "ICASE":
C                                       0 => POINT ESTIMATE ONLY
C                                       1 => POINT ESTIMATE PLUS
C                                            UNCERTAINTY INTERVALS
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALPHA(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      INTEGER IFLAG
      INTEGER ICASE
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORM'
      ISUBN2='L1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,ICASE
   52   FORMAT('IBUGA3,ISUBRO,ICASE = ',2(A4,2X),I5)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NORMAL MLE ESTIMATE             **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='NORMAL'
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(ICASE.EQ.0)GOTO9000
C
      AN=REAL(N)
      XSDMEA=XSD/SQRT(AN)
      XSDSD=XSD/SQRT(2.0*(AN-1.0))
C
      IDF=N-1
      ADF=REAL(IDF)
      DO1010I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
C
        CALL TPPF(P1,REAL(IDF),TLOW)
        CALL TPPF(P2,REAL(IDF),TUPP)
        ALOWLO(I)=XMEAN + TLOW*XSDMEA
        AUPPLO(I)=XMEAN + TUPP*XSDMEA
C
        CALL CHSPPF(P1,IDF,APPF1)
        CALL CHSPPF(P2,IDF,APPF2)
        ALOWSC(I)=XSD*SQRT(ADF/APPF2)
        AUPPSC(I)=XSD*SQRT(ADF/APPF1)
C
 1010 CONTINUE
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,XMEAN,XSD,XSDMEA,XSDSD
   55   FORMAT('N,XMEAN,XSD,XSDMEA,XSDSD = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORML2(Y,X,N,IR,
     1                  XTEMP,DTEMP1,ITEMP,MAXNXT,IOUNI2,
     1                  ALOWLO,AUPPLO,ALOWSC,AUPPSC,ALPHA,NUMALP,NUMOUT,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,XSDMEA,XSDSD,XCOV,COV,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE NORMAL DISTRIBUTION FOR THE UNGROUPED,
C              MULTIPLY RIGHT CENSORED DATA CASE.  IT WILL ALSO
C              RETURN THE CONFIDENCE INTERVALS FOR THE LOCATION
C              AND SCALE PARAMETERS.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLN2 WILL GENERATE THE OUTPUT
C              FOR THE NORMAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C              --CLIFFORD COHEN, "TRUNCATED AND CENSORED SAMPLES:
C                THEORY AND APPLICATIONS", DEKKER, 1991.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLNO)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION ALOWLO(*)
      DIMENSION AUPPLO(*)
      DIMENSION ALOWSC(*)
      DIMENSION AUPPSC(*)
      DIMENSION ALPHA(*)
C
      DIMENSION FISH(2,2)
      DIMENSION COV(2,2)
      DIMENSION D(2)
C
      COMMON/NORCML/IR2
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      EXTERNAL NORFUN
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DR
      DOUBLE PRECISION DX
      DOUBLE PRECISION MU
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION SIGMA
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DSUM5
      DOUBLE PRECISION DSUM6
      DOUBLE PRECISION DPPF1
      DOUBLE PRECISION DPPF2
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      INTEGER IFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION XTEMP(*)
      DIMENSION ITEMP(*)
      DOUBLE PRECISION DTEMP1(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORM'
      ISUBN2='L1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORML2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NORMAL MLE ESTIMATE             **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='NORMAL'
      CALL CKCENS(X,XTEMP,N,IDIST,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
      CALL SORTC(Y,X,N,Y,X)
      IR=0
      DO2120I=1,N
        IF(X(I).EQ.1.0)IR=IR+1
 2120 CONTINUE
C
      IFLAG=0
      CALL SUMRAW(Y,IR,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
      IR2=IR
      XPAR(1)=DBLE(XMEAN)
      XPAR(2)=DBLE(XSD)
      IOPT=2
      TOL=1.0D-6
      NVAR=2
      NPRINT=-1
      INFO=0
      LWA=MAXNXT
      CALL DNSQE(NORFUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,Y,N)
C
      XMEAN=REAL(XPAR(1))
      XSD=REAL(XPAR(2))
C
C  NOW COMPUTE THE FISHER INFORMATION MATRIX, INVERT TO GET THE
C  PARAMETER VARIANCE-COVARIANCE MATRIX.
C
      MU=DBLE(XMEAN)
      SIGMA=DBLE(XSD)
      DN=DBLE(N)
      DR=DBLE(IR)
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DO4150I=1,IR
        DX=(DBLE(Y(I)) - MU)/SIGMA
        DSUM1=DSUM1 + DX
        DSUM2=DSUM2 + DX*DX
 4150 CONTINUE
C
      DSUM3=0.0D0
      DSUM4=0.0D0
      DSUM5=0.0D0
      DSUM6=0.0D0
      IF(IR.LT.N)THEN
        DO4180I=IR+1,N
          DX=(DBLE(Y(I)) - MU)/SIGMA
          CALL NODPDF(DX,DPDF)
          CALL NODCDF(DX,DCDF)
          DHAZ=DPDF/(1.0D0 - DCDF)
          DSUM3=DSUM3 + DHAZ*(DHAZ - DX)
          DSUM4=DSUM4 + DHAZ*(1.0D0 + DX*(DHAZ - DX))
          DSUM5=DSUM5 + DX*DHAZ
          DSUM6=DSUM6 + DX*DX*DHAZ*(DHAZ - DX)
 4180   CONTINUE
      ENDIF
      XVAR=XSD*XSD
      FISH(1,1)=(1.0/XVAR)*REAL(DR + DSUM3)
      FISH(1,2)=(1.0/XVAR)*REAL(2.0D0*DSUM1 + DSUM4)
      FISH(2,1)=FISH(1,2)
      FISH(2,2)=(1.0/XVAR)*REAL(3.0D0*DSUM2+2.0D0*DSUM5+DSUM6-DR)
C
      NDIM=2
      CALL SGECO(FISH,NDIM,NDIM,ITEMP,RCOND,XTEMP)
      IJOB=1
      CALL SGEDI(FISH,NDIM,NDIM,ITEMP,XTEMP,XTEMP(MAXNXT/2),IJOB)
      DO4210J=1,NDIM
        DO4215I=1,NDIM
          COV(I,J)=FISH(I,J)
 4215   CONTINUE
 4210 CONTINUE
      DO4219I=1,NDIM
        WRITE(IOUNI2,'(2E15.7)')(COV(I,J),J=1,NDIM)
 4219 CONTINUE
C
      XSDMEA=SQRT(COV(1,1))
      XSDSD=SQRT(COV(2,2))
      XCOV=COV(1,2)
C
      IDF=N-1
      ADF=REAL(IDF)
      DO1010I=1,NUMALP
C
        ALP=ALPHA(I)
        P1=ALP/2.0
        P2=1.0-(ALP/2.0)
C
        CALL NODPPF(DBLE(P1),DPPF1)
        CALL NODPPF(DBLE(P2),DPPF2)
        ALOWLO(I)=0.0
        AUPPLO(I)=0.0
        ALOWSC(I)=0.0
        AUPPSC(I)=0.0
C
        IF(COV(1,1).GE.0.0)THEN
          ALOWLO(I)=XMEAN + REAL(DPPF1)*SQRT(COV(1,1))
          AUPPLO(I)=XMEAN + REAL(DPPF2)*SQRT(COV(1,1))
        ENDIF
        IF(COV(2,2).GE.0.0)THEN
          ALOWSC(I)=XMEAN + REAL(DPPF1)*SQRT(COV(2,2))
          AUPPSC(I)=XMEAN + REAL(DPPF2)*SQRT(COV(2,2))
        ENDIF
C
 1010 CONTINUE
      NUMOUT=NUMALP
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORML2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,XMEAN,XSD,XSDMEA,XSDSD
   55   FORMAT('N,XMEAN,XSD,XSDMEA,XSDSD = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORPDF(X,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 931, FORMULA 26.2.1.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DENSITYS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --OCTOBER   1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA PI/3.14159265/
C
C-----START POINT-----------------------------------------------------
C
      CONST=1/SQRT(2.0*PI)
      TERM=EXP(-0.5*X**2)
      PDF=CONST*TERM
C
      RETURN
      END
      SUBROUTINE NORPE1(Y,N,NPERC,XMEAN,XSD,IOUNI1,
     1QP,XQPHAT,XQPLCL,XQPUCL,
     1ALPHAP,NUMALP,
     1ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES PERCENTILES AND ASSOCIATED
C              CONIDENCE INTERVALS (BASED ON THE ML ESTIMATES) FOR
C              THE NORMAL DISTRIBUTION FOR THE RAW DATA CASE
C              (I.E., NO CENSORING AND NO GROUPING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLN1 WILL GENERATE THE OUTPUT
C              FOR THE NORMAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLNO)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      DOUBLE PRECISION DPPF
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      INTEGER IFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORP'
      ISUBN2='E1  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORPE1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)N,NPERC,NUMALP
   53   FORMAT('N,NPERC,NUMALP = ',3I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS              **
C               **  FOR NORMAL PERCENTILES              **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NPERC.GE.1)THEN
C
        AN=REAL(N)
        C1=XSD/SQRT(AN)
        ANU=REAL(N-1)
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
C
        WRITE(IOUNI1,1001)
 1001   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
        WRITE(IOUNI1,1002)
 1002   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
C
        DO1110I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL NODPPF(DBLE(QPTEMP),DPPF)
          XQPHAT(I)=XMEAN + XSD*REAL(DPPF)
          DELTA=REAL(DPPF)*SQRT(AN)
          IF(DELTA.LT.0.0)THEN
            DELTA2=-DELTA
            CALL NCTPPF(ALPHU,ANU,DELTA2,C2)
            C2=-C2
            CALL NCTPPF(ALPHL,ANU,DELTA2,C3)
            C3=-C3
          ELSE
            CALL NCTPPF(ALPHL,ANU,DELTA,C2)
            CALL NCTPPF(ALPHU,ANU,DELTA,C3)
          ENDIF
          ATEMP1=XMEAN + C1*C2
          ATEMP2=XMEAN + C1*C3
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
          WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RPE1')THEN
            WRITE(ICOUT,1113)XMEAN,XSD,ANU,ALPHAP
 1113       FORMAT('XMEAN,XSD,ANU,ALPHAP = ',4G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1115)DELTA,C1,C2,C3
 1115       FORMAT('DELTA,C1,C2,C3 = ',4G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1117)ATEMP1,ATEMP2
 1117       FORMAT('ATEMP1,ATEMP2 = ',2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
 1110   CONTINUE
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORPE1--')
        CALL DPWRST('XXX','WRIT')
        IF(NPERC.GT.1)THEN
          DO9050I=1,NPERC
            WRITE(ICOUT,9055)I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
 9055       FORMAT('I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I) = ',
     1             I8,4G15.7)
            CALL DPWRST('XXX','WRIT')
 9050     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORPE2(Y,X,N,IR,NPERC,
     1                  XMEAN,XSD,COV,IOUNI1,
     1                  QP,XQPHAT,XQPLCL,XQPUCL,
     1                  ALPHAP,NUMALP,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES PERCENTILES AND ASSOCIATED
C              CONIDENCE INTERVALS (BASED ON THE ML ESTIMATES) FOR
C              THE NORMAL DISTRIBUTION FOR THE MULTIPLY CENSORED
C              UNGROUPED DATA CASE.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLN1 WILL GENERATE THE OUTPUT
C              FOR THE NORMAL MLE COMMAND).
C
C     REFERENCE--KARL BURY, "STATISTICAL DISTRIBUTIONS IN ENGINEERING",
C                CAMBRIDGE UNIVERSITY PRESS, 1999, CHAPTER 10.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2009/9
C     ORIGINAL VERSION--SEPTEMBER 2009. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLNO)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION QP(*)
      DIMENSION XQPHAT(*)
      DIMENSION XQPLCL(*)
      DIMENSION XQPUCL(*)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
      CHARACTER*1 IBASLC
C
      INTEGER IFLAG
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION X(*)
      DIMENSION COV(2,2)
C
      DOUBLE PRECISION ZALPU
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION D(2)
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NORP'
      ISUBN2='E2  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE2')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF NORPE2--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,53)N,IR,NPERC,NUMALP,ALPHAP
   53   FORMAT('N,IR,NPERC,NUMALP,ALPHAP = ',4I8,G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,54)XMEAN,XSD,COV(1,1),COV(2,2),COV(2,1)
   54   FORMAT('XMEAN,XSD,COV(1,1),COV(2,2),COV(2,1) = ',5G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I),X(I)
   57     FORMAT('I,Y(I),X(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  CARRY OUT CALCULATIONS FOR          **
C               **  CENSORED NORMAL PERCENTILES         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE2')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NPERC.GE.1)THEN
C
        D(1)=1.0D0
        ALPHL=ALPHAP/2.0
        ALPHU=1.0 - ALPHAP/2.0
        CALL NODPPF(DBLE(ALPHU),ZALPU)
C
        WRITE(IOUNI1,1001)
 1001   FORMAT(15X,'       POINT     ','     LOWER     ',
     1         '     UPPER')
        WRITE(IOUNI1,1002)
 1002   FORMAT('    PERCENTILE ','     ESTIMATE   ',
     1         'CONFIDENCE LIMIT ','CONFIDENCE LIMIT')
C
        DO1010I=1,NPERC
          QPTEMP=QP(I)/100.0
          CALL NODPPF(DBLE(QPTEMP),D(2))
          XQPHAT(I)=XMEAN + XSD*REAL(D(2))
          DSUM1=0.0D0
          DO1020II=1,2
            DO1030JJ=1,2
              DSUM1=DSUM1 + D(II)*D(JJ)*DBLE(COV(II,JJ))
 1030       CONTINUE
 1020     CONTINUE
          XQPSE=SQRT(REAL(DSUM1))
          ATEMP1=XQPHAT(I) - REAL(ZALPU)*XQPSE
          ATEMP2=XQPHAT(I) + REAL(ZALPU)*XQPSE
          XQPLCL(I)=MIN(ATEMP1,ATEMP2)
          XQPUCL(I)=MAX(ATEMP1,ATEMP2)
          WRITE(IOUNI1,'(3E15.7,2X,E15.7)')
     1         QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
C
          IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'MLNO')THEN
            WRITE(ICOUT,1061)I,QP(I),XQPHAT(I)
 1061       FORMAT('I,QP(I),XQPHAT(I),ZALPU = ',I8,3G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1065)ZALPU,DSUM1,XQPSE
 1065       FORMAT('ZALPU,DSUM1,XQPSE = ',3G15.7)
            CALL DPWRST('XXX','BUG ')
            WRITE(ICOUT,1067)ATEMP1,ATEMP2
 1067       FORMAT('ATEMP1,ATEMP2 = ',2G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
 1010   CONTINUE
C
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RPE2')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF NORPE2--')
        CALL DPWRST('XXX','WRIT')
        IF(NPERC.GT.1)THEN
          DO9050I=1,NPERC
            WRITE(ICOUT,9055)I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I)
 9055       FORMAT('I,QP(I),XQPHAT(I),XQPLCL(I),XQPUCL(I) = ',
     1             I8,4G15.7)
            CALL DPWRST('XXX','WRIT')
 9050     CONTINUE
        ENDIF
      ENDIF
C
      RETURN
      END
      SUBROUTINE NORPPC(X,N,IDIST,ALAMB,ALAMB2,
     1                  IWRITE,Y,W,MAXNYW,
     1                  MINMAX,IGEPDF,
     1                  PPCC,SHAPE,SHAPE2,ALOC,SCALE,
     1                  IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE NORMAL
C              PROBABILITY PLOT CORRELATION COEFFICIENT.
C              THE PROTOTYPE NORMAL DISTRIBUTION USED HEREIN
C              HAS MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI)) * EXP(-X*X/2).
C              AS USED HEREIN, A PROBABILITY PLOT FOR A DISTRIBUTION
C              IS A PLOT OF THE ORDERED OBSERVATIONS VERSUS
C              THE ORDER STATISTIC MEDIANS FOR THAT DISTRIBUTION.
C              THE NORMAL PROBABILITY PLOT IS USEFUL IN
C              GRAPHICALLY TESTING THE COMPOSITE (THAT IS,
C              LOCATION AND SCALE PARAMETERS NEED NOT BE SPECIFIED)
C              HYPOTHESIS THAT THE UNDERLYING DISTRIBUTION
C              FROM WHICH THE DATA HAVE BEEN RANDOMLY DRAWN
C              IS THE NORMAL DISTRIBUTION.
C              IF THE HYPOTHESIS IS TRUE, THE PROBABILITY PLOT
C              SHOULD BE NEAR-LINEAR.
C              A MEASURE OF SUCH LINEARITY IS GIVEN BY THE
C              CALCULATED PROBABILITY PLOT CORRELATION COEFFICIENT.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--PPCC   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED NORMAL PPCC.
C     OUTPUT--NONE.
C     PRINTING--YES.
C     OTHER DATAPAC   SUBROUTINES NEEDED--SORT, UNIMED, NORPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--FILLIBEN, 'TECHNIQUES FOR TAIL LENGTH ANALYSIS',
C                 PROCEEDINGS OF THE EIGHTEENTH CONFERENCE
C                 ON THE DESIGN OF EXPERIMENTS IN ARMY RESEARCH
C                 DEVELOPMENT AND TESTING (ABERDEEN, MARYLAND,
C                 OCTOBER, 1972), PAGES 425-450.
C               --FILLIBEN, 'THE PROBABILITY PLOT CORRELATION COEFFICIENT
C                 TEST FOR NORMALITY', TECHNOMETRICS, 1975, PAGES 111-117.
C               --RYAN AND JOINER, 'NORMAL PROBABILITY PLOTS AND TESTS
C                 FOR NORMALITY'  PENNSYLVANIA
C                 STATE UNIVERSITY REPORT.
C               --HAHN AND SHAPIRO, STATISTICAL METHODS IN ENGINEERING,
C                 1967, PAGES 260-308.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION (AS A SEPARATE SUBROUTINE)--JULY      1972.
C     UPDATED         --JULY      1981.
C     UPDATED         --AUGUST    1981.
C     UPDATED         --NOVEMBER  1981.
C     UPDATED         --MAY       1982.
C     UPDATED         --MAY       2011. INCORPORATE OTHER DISTRIBUTIONS
C     UPDATED         --JANUARY   2013. FOR WEIBULL AND TUKEY-LAMBDA, OPTION
C                                       TO ESTIMATE SHAPE PARAMETER
C     UPDATED         --FEBRUARY  2013. ADD LOGNORMAL
C     UPDATED         --FEBRUARY  2013. ADD GENERALIZED PARETO
C     UPDATED         --FEBRUARY  2013. ADD G AND H
C     UPDATED         --FEBRUARY  2013. ADD WALD, INVERTED WEIBULL
C     UPDATED         --FEBRUARY  2013. ADD GAMMA, FATIGUE LIFE
C     UPDATED         --MARCH     2013. ADD SINE
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*20 IDIST
      CHARACTER*4 IWRITE
      CHARACTER*4 IGEPDF
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 IWRISV
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DPPF
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION W(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DATA PI/3.14159265359/
C
      ISUBN1='NORP'
      ISUBN2='PC  '
C
      IERROR='NO'
      IUPPER=MAXOBV
C
      SUM1=0.0
      SUM2=0.0
      SUM3=0.0
      AN=N
      PPCC=0.0
      SHAPE=ALAMB
      WBAR=CPUMIN
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RPPC')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF NORPPC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IDIST,IBUGA3,ISUBRO,N,MAXNYW
   52   FORMAT('IDIST,IBUGA3,ISUBRO,N,MAXNXT = ',A16,2X,2(A4,2X),2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ************************************************
C               **  COMPUTE NORMAL                            **
C               **  PROBABILITY PLOT CORRELATION COEFFICIENT  **
C               ************************************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
C
      IF(N.EQ.1)THEN
        GOTO9000
      ELSEIF(N.LE.2 .OR. N.GE.MAXNYW)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN NORMAL PPCC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE RESPONSE VARIABLE HAS FEWER THAN TWO')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)MAXNYW
  113   FORMAT('      OR MORE THAN ',I8,' OBSERVATIONS.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,118)N
  118   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS = ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,136)HOLD
  136 FORMAT('      THE RESPONSE VARIABLE HAS ALL ELEMENTS = ',G15.7)
      GOTO9000
  139 CONTINUE
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  COMPUTE THE NORMAL                         **
C               **  PROBABILITY PLOT CORRELATION COEFFICIENT.  **
C               *************************************************
C
      CALL SORT(X,N,Y)
      CALL UNIMED(N,W)
      IWRISV=IWRITE
      IWRITE='OFF'
      CALL MEAN(Y,N,IWRITE,YBAR,IBUGA3,IERROR)
      IWRITE=IWRISV
C
      IF(IDIST.EQ.'NORMAL')THEN
        DO200I=1,N
          CALL NORPPF(W(I),WOUT)
          W(I)=WOUT
  200   CONTINUE
        WBAR=0.0
      ELSEIF(IDIST.EQ.'CAUCHY')THEN
        DO210I=1,N
          ARG=PI*W(I)
          W(I)=-COS(ARG)/SIN(ARG)
  210   CONTINUE
      ELSEIF(IDIST.EQ.'TUKEY-LAMBDA')THEN
C
C       FOR TUKEY-LAMBDA, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=-4.0
          SHAPIN=0.05
          NLOOP=161
          PPCC=-1.0
          DO221ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            IF(-0.001.LT.SHAPST.AND.SHAPST.LT.0.001)THEN
              DO225I=1,N
                Q=W(I)
                W(I)=LOG(Q/(1.0-Q))
  225         CONTINUE
            ELSE
              DO226I=1,N
                Q=W(I)
                W(I)=(Q**SHAPST-(1.0-Q)**SHAPST)/SHAPST
  226         CONTINUE
            ENDIF
            IWRISV=IWRITE
            IWRITE='OFF'
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
            IWRITE=IWRISV
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO227I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  227       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
              PPCC=PPCCT
            ENDIF
            SHAPST=SHAPST+SHAPIN
  221     CONTINUE
          GOTO8000
C
        ELSE
          IF(-0.001.LT.ALAMB.AND.ALAMB.LT.0.001)THEN
            DO228I=1,N
              Q=W(I)
              W(I)=LOG(Q/(1.0-Q))
  228       CONTINUE
          ELSE
            DO229I=1,N
              Q=W(I)
              W(I)=(Q**ALAMB-(1.0-Q)**ALAMB)/ALAMB
  229       CONTINUE
          ENDIF
        ENDIF
      ELSEIF(IDIST.EQ.'LOGISTIC')THEN
        DO230I=1,N
          CALL LOGPPF(W(I),WOUT)
          W(I)=WOUT
  230   CONTINUE
      ELSEIF(IDIST.EQ.'DOUBLE EXPONENTIAL')THEN
        DO235I=1,N
          CALL DEXPPF(W(I),WOUT)
          W(I)=WOUT
  235   CONTINUE
      ELSEIF(IDIST.EQ.'COSINE')THEN
        DO240I=1,N
          CALL COSPPF(W(I),WOUT)
          W(I)=WOUT
  240   CONTINUE
      ELSEIF(IDIST.EQ.'SINE')THEN
        DO243I=1,N
          CALL SINPPF(W(I),WOUT)
          W(I)=WOUT
  243   CONTINUE
      ELSEIF(IDIST.EQ.'ANGLIT')THEN
        DO245I=1,N
          CALL ANGPPF(W(I),WOUT)
          W(I)=WOUT
  245   CONTINUE
      ELSEIF(IDIST.EQ.'EXPONENTIAL')THEN
        DO250I=1,N
          CALL EXPPPF(W(I),WOUT)
          W(I)=WOUT
  250   CONTINUE
      ELSEIF(IDIST.EQ.'ARCSINE')THEN
        DO255I=1,N
          CALL ARSPPF(W(I),WOUT)
          W(I)=WOUT
  255   CONTINUE
      ELSEIF(IDIST.EQ.'HYPERBOLIC SECANT')THEN
        DO260I=1,N
          CALL HSEPPF(W(I),WOUT)
          W(I)=WOUT
  260   CONTINUE
      ELSEIF(IDIST.EQ.'SLASH')THEN
        DO265I=1,N
          CALL SLAPPF(W(I),WOUT)
          W(I)=WOUT
  265   CONTINUE
      ELSEIF(IDIST.EQ.'MAXWELL')THEN
        DO270I=1,N
          CALL MAXPPF(W(I),WOUT)
          W(I)=WOUT
  270   CONTINUE
      ELSEIF(IDIST.EQ.'RAYLEIGH')THEN
        DO275I=1,N
          CALL RAYPPF(W(I),WOUT)
          W(I)=WOUT
  275   CONTINUE
      ELSEIF(IDIST.EQ.'HALF-NORMAL')THEN
        DO280I=1,N
          CALL HFNPPF(W(I),WOUT)
          W(I)=WOUT
  280   CONTINUE
      ELSEIF(IDIST.EQ.'HALF-CAUCHY')THEN
        DO285I=1,N
          CALL HFCPPF(W(I),WOUT)
          W(I)=WOUT
  285   CONTINUE
      ELSEIF(IDIST.EQ.'SEMI-CIRCULAR')THEN
        ATEMP=1.0
        DO290I=1,N
          CALL SEMPPF(W(I),ATEMP,WOUT)
          W(I)=WOUT
  290   CONTINUE
      ELSEIF(IDIST.EQ.'MINIMUM GUMBEL')THEN
        MINMXT=1
        DO295I=1,N
          CALL EV1PPF(W(I),MINMXT,WOUT)
          W(I)=WOUT
  295   CONTINUE
      ELSEIF(IDIST.EQ.'MAXIMUM GUMBEL')THEN
        MINMXT=2
        DO296I=1,N
          CALL EV1PPF(W(I),MINMXT,WOUT)
          W(I)=WOUT
  296   CONTINUE
      ELSEIF(IDIST.EQ.'WEIBULL')THEN
C
C       FOR WEIBULL, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.0
          SHAPIN=0.1
          NLOOP=500
          PPCC=-1.0
          DO305ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            SHAPST=SHAPST+SHAPIN
            DO303I=1,N
              CALL WEIPPF(W(I),SHAPST,MINMAX,WOUT)
              W(I)=WOUT
  303       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO307I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  307       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
  305     CONTINUE
          GOTO8000
C
        ELSE
          DO309I=1,N
            CALL WEIPPF(W(I),ALAMB,MINMAX,WOUT)
            W(I)=WOUT
  309     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'LOGNORMAL')THEN
C
C       FOR LOGNORMAL, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.1
          SHAPIN=0.1
          NLOOP=249
          PPCC=-1.0
          DO315ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO313I=1,N
              CALL LGNPPF(W(I),SHAPST,WOUT)
              W(I)=WOUT
  313       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO317I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  317       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  315     CONTINUE
          GOTO8000
C
        ELSE
          DO319I=1,N
            CALL LGNPPF(W(I),ALAMB,WOUT)
            W(I)=WOUT
  319     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'GPARETO')THEN
C
C       FOR GENERALIZED PARETO, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        MINMXT=1
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=-10.0
          SHAPIN=0.05
          NLOOP=400
          PPCC=-1.0
          DO325ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO323I=1,N
              CALL GEPPPF(W(I),SHAPST,MINMAX,IGEPDF,WOUT)
              W(I)=WOUT
  323       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO327I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  327       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  325     CONTINUE
          GOTO8000
C
        ELSE
          DO329I=1,N
            CALL GEPPPF(W(I),SHAPST,MINMAX,IGEPDF,WOUT)
            W(I)=WOUT
  329     CONTINUE
        ENDIF
C
      ELSEIF(IDIST.EQ.'GH')THEN
C
C       FOR GH, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN .OR. ALAMB2.EQ.CPUMIN)THEN
          SHAPS1=-1.0
          SHAPI1=0.02
          NLOOP1=100
          SHAPS2=0.0
          SHAPI2=0.02
          NLOOP2=50
          PPCC=-1.0
          AVAL1=-1.0
          DO335ILOOP1=1,NLOOP1
            DO338ILOOP2=1,NLOOP2
              CALL UNIMED(N,W)
              DO333I=1,N
                CALL GHPPF(W(I),SHAPS1,SHAPS2,PPF,DBLE(AVAL1),DPPF)
                W(I)=REAL(DPPF)
  333         CONTINUE
              CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
              DSUM1=0.0D0
              DSUM2=0.0D0
              DSUM3=0.0D0
              DO337I=1,N
                DTERM1=DBLE(Y(I) - YBAR)
                DTERM2=DBLE(W(I) - WBAR)
                DSUM1=DSUM1 + DTERM1*DTERM1
                DSUM2=DSUM2 + DTERM1*DTERM2
                DSUM3=DSUM3 + DTERM2*DTERM2
  337         CONTINUE
              PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
              IF(PPCCT.GT.PPCC)THEN
                SHAPE=SHAPS1
                SHAPE2=SHAPS2
                PPCC=PPCCT
                SUMXY=REAL(DSUM2)
                SUMXX=REAL(DSUM3)
                SCALE=0.0
                IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
                ALOC=YBAR-SCALE*WBAR
              ENDIF
              SHAPS1=SHAPS1+SHAPI1
              SHAPS2=SHAPS2+SHAPI2
  338       CONTINUE
  335     CONTINUE
          GOTO8000
C
        ELSE
          DO339I=1,N
            AVAL1=-1.0
            CALL GHPPF(W(I),ALAMB,ALAMB2,PPF,DBLE(AVAL1),DPPF)
            W(I)=REAL(DPPF)
  339     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'WALD')THEN
C
C       FOR WALD, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.1
          SHAPIN=0.1
          NLOOP=499
          PPCC=-1.0
          DO345ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO343I=1,N
              CALL WALPPF(W(I),SHAPST,WOUT)
              W(I)=WOUT
  343       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO347I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  347       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  345     CONTINUE
          GOTO8000
C
        ELSE
          DO349I=1,N
            CALL WALPPF(W(I),ALAMB,WOUT)
            W(I)=WOUT
  349     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'GAMMA')THEN
C
C       FOR GAMMA, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.1
          SHAPIN=0.1
          NLOOP=499
          PPCC=-1.0
          DO355ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO353I=1,N
              CALL GAMPPF(W(I),SHAPST,WOUT)
              W(I)=WOUT
  353       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO357I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  357       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  355     CONTINUE
          GOTO8000
C
        ELSE
          DO359I=1,N
            CALL GAMPPF(W(I),ALAMB,WOUT)
            W(I)=WOUT
  359     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'INVERTED WEIBULL')THEN
C
C       FOR INVERTED WEIBULL, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.1
          SHAPIN=0.1
          NLOOP=499
          PPCC=-1.0
          DO365ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO363I=1,N
              CALL IWEPPF(W(I),SHAPST,WOUT)
              W(I)=WOUT
  363       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO367I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  367       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  365     CONTINUE
          GOTO8000
C
        ELSE
          DO369I=1,N
            CALL IWEPPF(W(I),ALAMB,WOUT)
            W(I)=WOUT
  369     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'FATIGUE LIFE')THEN
C
C       FOR FATIGUE LIFE, EITHER USED A FIXED VALUE FOR SHAPE OR
C       USE PPCC METHOD TO ESTIMATE.
C
        IF(ALAMB.EQ.CPUMIN)THEN
          SHAPST=0.1
          SHAPIN=0.1
          NLOOP=249
          PPCC=-1.0
          DO375ILOOP=1,NLOOP
            CALL UNIMED(N,W)
            DO373I=1,N
              CALL FLPPF(W(I),SHAPST,WOUT)
              W(I)=WOUT
  373       CONTINUE
            CALL MEAN(W,N,IWRITE,WBAR,IBUGA3,IERROR)
C
            DSUM1=0.0D0
            DSUM2=0.0D0
            DSUM3=0.0D0
            DO377I=1,N
              DTERM1=DBLE(Y(I) - YBAR)
              DTERM2=DBLE(W(I) - WBAR)
              DSUM1=DSUM1 + DTERM1*DTERM1
              DSUM2=DSUM2 + DTERM1*DTERM2
              DSUM3=DSUM3 + DTERM2*DTERM2
  377       CONTINUE
            PPCCT=DSUM2/DSQRT(DSUM3*DSUM1)
            IF(PPCCT.GT.PPCC)THEN
              SHAPE=SHAPST
              PPCC=PPCCT
              SUMXY=REAL(DSUM2)
              SUMXX=REAL(DSUM3)
              SCALE=0.0
              IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
              ALOC=YBAR-SCALE*WBAR
            ENDIF
            SHAPST=SHAPST+SHAPIN
  375     CONTINUE
          GOTO8000
C
        ELSE
          DO379I=1,N
            CALL FLPPF(W(I),ALAMB,WOUT)
            W(I)=WOUT
  379     CONTINUE
        ENDIF
      ELSEIF(IDIST.EQ.'UNIFORM')THEN
        WBAR=0.5
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,399)IDIST
  399   FORMAT('      NO MATCH FOR DISTRIBUTION: ',A20)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      SUM1=0.0
      SUM2=0.0
      DO410I=1,N
        SUM1=SUM1+Y(I)
        SUM2=SUM2+W(I)
  410 CONTINUE
      YBAR=SUM1/AN
      IF(WBAR.EQ.CPUMIN)WBAR=SUM2/AN
C
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM3=0.0D0
      DO420I=1,N
        DTERM1=DBLE(Y(I) - YBAR)
        DTERM2=DBLE(W(I) - WBAR)
        DSUM1=DSUM1 + DTERM1*DTERM1
        DSUM2=DSUM2 + DTERM1*DTERM2
        DSUM3=DSUM3 + DTERM2*DTERM2
  420 CONTINUE
      PPCC=REAL(DSUM2/DSQRT(DSUM3*DSUM1))
      SUMXY=REAL(DSUM2)
      SUMXX=REAL(DSUM3)
      SCALE=0.0
      IF(SUMXX.NE.0.0)SCALE=SUMXY/SUMXX
      ALOC=YBAR-SCALE*WBAR
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
 8000 CONTINUE
C
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)
  811   FORMAT('THE NORMAL PROBABILITY PLOT CORRELATION COEFFICIENT')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,812)N,PPCC
  812   FORMAT('OF THE ',I8,' OBSERVATIONS = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RPPC')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF NORPPC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)SUM1,SUM2,SUM3,PPCC,SHAPE
 9014   FORMAT('SUM1,SUM2,SUM3,PPCC,SHAPE = ',5G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NODCDF(X,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C              THIS IS THE DOUBLE PRECISION VERSION.
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--ALNORM.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 932, FORMULA 26.2.17.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--97.8
C     ORIGINAL VERSION--AUGUST    1997.
C     UPDATED         --SEPTEMBER 2009. SWITCH FROM USING APPLIED
C                                       STATISTICS ALGORITHM ALNORM
C                                       TO ACM 715 ANORM ALGORITHM
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION X
      DOUBLE PRECISION CDF
CCCCC DOUBLE PRECISION ALNORM
      DOUBLE PRECISION ANORM
      LOGICAL UPPER
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(X.LT.0.0D0)THEN
        UPPER=.FALSE.
CCCCC   CDF=ALNORM(X,UPPER)
        CDF=ANORM(X)
      ELSEIF(X.GT.0.0D0)THEN
CCCCC   UPPER=.TRUE.
CCCCC   CDF=1.0D0 - ALNORM(X,UPPER)
        CDF=ANORM(X)
      ELSE
        CDF=0.5D0
      ENDIF
C
      RETURN
      END
      SUBROUTINE NODPDF(Z, PDF)
CCCCC SUBROUTINE NODPDF(Z, P, Q, PDF)
C
C      Normal distribution probabilities accurate to 1.e-15.
C      Z = no. of standard deviations from the mean.
C      P, Q = probabilities to the left & right of Z.   P + Q = 1.
C       PDF = the probability density.
C
C       Based upon algorithm 5666 for the error function, from:
C       Hart, J.F. et al, 'Computer Approximations', Wiley 1968
C
C       Programmer: Alan Miller
C
C      Latest revision - 30 March 1986
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      DATA P0, P1, P2, P3, P4, P5, P6/220.20 68679 12376 1D0,
     *        221.21 35961 69931 1D0, 112.07 92914 97870 9D0,
     *        33.912 86607 83830 0D0, 6.3739 62203 53165 0D0,
     *        .70038 30644 43688 1D0, .35262 49659 98910 9D-01/,
     *        Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7/440.41 37358 24752 2D0,
     *        793.82 65125 19948 4D0, 637.33 36333 78831 1D0,
     *        296.56 42487 79673 7D0, 86.780 73220 29460 8D0,
     *        16.064 17757 92069 5D0, 1.7556 67163 18264 2D0,
     *        .88388 34764 83184 4D-1/,
     *        CUTOFF/7.071D0/, ROOT2PI/2.5066 28274 63100 1D0/
C
      ZABS = ABS(Z)
C
C      |Z| > 37.
C
      IF (ZABS .GT. 37.D0) THEN
        PDF = 0.D0
        IF (Z .GT. 0.D0) THEN
          P = 1.D0
          Q = 0.D0
        ELSE
          P = 0.D0
          Q = 1.D0
        END IF
        RETURN
      END IF
C
C      |Z| <= 37.
C
      EXPNTL = EXP(-0.5D0*ZABS**2)
      PDF = EXPNTL/ROOT2PI
C
C      |Z| < CUTOFF = 10/sqrt(2).
C
      IF (ZABS .LT. CUTOFF) THEN
        P = EXPNTL*((((((P6*ZABS + P5)*ZABS + P4)*ZABS + P3)*ZABS +
     *        P2)*ZABS + P1)*ZABS + P0)/(((((((Q7*ZABS + Q6)*ZABS +
     *        Q5)*ZABS + Q4)*ZABS + Q3)*ZABS + Q2)*ZABS + Q1)*ZABS +
     *        Q0)
C
C      |Z| >= CUTOFF.
C
      ELSE
        P = PDF/(ZABS + 1.D0/(ZABS + 2.D0/(ZABS + 3.D0/(ZABS + 4.D0/
     *        (ZABS + 0.65D0)))))
      END IF
C
      IF (Z .LT. 0.D0) THEN
        Q = 1.D0 - P
      ELSE
        Q = P
        P = 1.D0 - Q
      END IF
      RETURN
      END
      SUBROUTINE NODPPF(P,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES
C              THE PERCENT POINT
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     NOTE--THIS ROUTINE IS IDENTICAL IN LOGIC TO NORPPF
C           EXCEPT NORPPF HAS INTERNAL CALUCLATIONS
C           IN SINGLE PRECISION,
C           WHILE NODPPF HAS INTERNAL CALUCLATIONS
C           IN DOUBLE PRECISION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT
C             FUNCTION VALUE PPF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 AND 1.0, EXCLUSIVELY.
C
C      ALGORITHM AS241  APPL. STATIST. (1988) VOL. 37, NO. 3
C
C      Produces the normal deviate Z corresponding to a given lower
C      tail area of P; Z is accurate to about 1 part in 10**16.
C
C      The hash sums below are the sums of the mantissas of the
C      coefficients.   They are included for use in checking
C      transcription.
C
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1966)
C     VERSION NUMBER--95.7
C     ORIGINAL VERSION--JULY      1995.
C     UPDATED         --AUGUST    1997. REPLACE CURRENT ALGORITHM WITH
C                                       AS 241 (HAS HIGHER ACCURACY)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION P
      DOUBLE PRECISION PPF
      DOUBLE PRECISION ZERO, ONE, HALF, SPLIT1, SPLIT2, CONST1,
     *        CONST2, A0, A1,  A2, A3, A4, A5, A6, A7, B1, B2, B3,
     *          B4, B5, B6, B7,
     *        C0, C1, C2, C3, C4, C5, C6, C7,  D1, D2, D3, D4, D5,
     *        D6, D7, E0, E1, E2, E3, E4, E5, E6, E7, F1, F2, F3,
     *        F4, F5, F6, F7, Q, R
      PARAMETER (ZERO = 0.D0, ONE = 1.D0, HALF = 0.5D0,
     *        SPLIT1 = 0.425D0, SPLIT2 = 5.D0,
     *        CONST1 = 0.180625D0, CONST2 = 1.6D0)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C      Coefficients for P close to 0.5
C
      PARAMETER (A0 = 3.38713 28727 96366 6080D0,
     *           A1 = 1.33141 66789 17843 7745D+2,
     *           A2 = 1.97159 09503 06551 4427D+3,
     *           A3 = 1.37316 93765 50946 1125D+4,
     *           A4 = 4.59219 53931 54987 1457D+4,
     *           A5 = 6.72657 70927 00870 0853D+4,
     *           A6 = 3.34305 75583 58812 8105D+4,
     *           A7 = 2.50908 09287 30122 6727D+3,
     *           B1 = 4.23133 30701 60091 1252D+1,
     *           B2 = 6.87187 00749 20579 0830D+2,
     *           B3 = 5.39419 60214 24751 1077D+3,
     *           B4 = 2.12137 94301 58659 5867D+4,
     *           B5 = 3.93078 95800 09271 0610D+4,
     *           B6 = 2.87290 85735 72194 2674D+4,
     *           B7 = 5.22649 52788 52854 5610D+3)
C      HASH SUM AB    55.88319 28806 14901 4439
C
C      Coefficients for P not close to 0, 0.5 or 1.
C
      PARAMETER (C0 = 1.42343 71107 49683 57734D0,
     *           C1 = 4.63033 78461 56545 29590D0,
     *           C2 = 5.76949 72214 60691 40550D0,
     *           C3 = 3.64784 83247 63204 60504D0,
     *           C4 = 1.27045 82524 52368 38258D0,
     *           C5 = 2.41780 72517 74506 11770D-1,
     *             C6 = 2.27238 44989 26918 45833D-2,
     *           C7 = 7.74545 01427 83414 07640D-4,
     *           D1 = 2.05319 16266 37758 82187D0,
     *           D2 = 1.67638 48301 83803 84940D0,
     *           D3 = 6.89767 33498 51000 04550D-1,
     *           D4 = 1.48103 97642 74800 74590D-1,
     *           D5 = 1.51986 66563 61645 71966D-2,
     *           D6 = 5.47593 80849 95344 94600D-4,
     *           D7 = 1.05075 00716 44416 84324D-9)
C      HASH SUM CD    49.33206 50330 16102 89036
C
C      Coefficients for P near 0 or 1.
C
      PARAMETER (E0 = 6.65790 46435 01103 77720D0,
     *           E1 = 5.46378 49111 64114 36990D0,
     *           E2 = 1.78482 65399 17291 33580D0,
     *           E3 = 2.96560 57182 85048 91230D-1,
     *           E4 = 2.65321 89526 57612 30930D-2,
     *           E5 = 1.24266 09473 88078 43860D-3,
     *           E6 = 2.71155 55687 43487 57815D-5,
     *           E7 = 2.01033 43992 92288 13265D-7,
     *           F1 = 5.99832 20655 58879 37690D-1,
     *           F2 = 1.36929 88092 27358 05310D-1,
     *           F3 = 1.48753 61290 85061 48525D-2,
     *           F4 = 7.86869 13114 56132 59100D-4,
     *           F5 = 1.84631 83175 10054 68180D-5,
     *           F6 = 1.42151 17583 16445 88870D-7,
     *           F7 = 2.04426 31033 89939 78564D-15)
C      HASH SUM EF    47.52583 31754 92896 71629
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      PPF=0.0D0
      IF(P.LE.0.0D0.OR.P.GE.1.0D0)GOTO50
      GOTO90
   50 WRITE(ICOUT,1)
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO NODPPF ',
     1'IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',D15.7,'*****')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
   90 CONTINUE
C
C               ************************************************
C               **  STEP 2--                                  **
C               **  COMPUTE THE PERCENT POINT FUNCTION VALUE  **
C               ************************************************
C
      IF(P.EQ.0.5D0)THEN
        PPF=0.0D0
        GOTO9000
      ENDIF
C
      Q = P - HALF
      IF (ABS(Q) .LE. SPLIT1) THEN
        R = CONST1 - Q * Q
        PPF = Q * (((((((A7 * R + A6) * R + A5) * R + A4) * R + A3)
     *          * R + A2) * R + A1) * R + A0) /
     *              (((((((B7 * R + B6) * R + B5) * R + B4) * R + B3)
     *          * R + B2) * R + B1) * R + ONE)
        RETURN
      ELSE
        IF (Q .LT. ZERO) THEN
          R = P
        ELSE
          R = ONE - P
        END IF
        IF (R .LE. ZERO) THEN
          WRITE(ICOUT,47)
          CALL DPWRST('XXX','BUG ')
          PPF = ZERO
          RETURN
        END IF
   47 FORMAT('***** INTERNAL ERROR FROM NODPPF ******')
        R = SQRT(-LOG(R))
        IF (R .LE. SPLIT2) THEN
          R = R - CONST2
          PPF = (((((((C7 * R + C6) * R + C5) * R + C4) * R + C3)
     *          * R + C2) * R + C1) * R + C0) /
     *             (((((((D7 * R + D6) * R + D5) * R + D4) * R + D3)
     *          * R + D2) * R + D1) * R + ONE)
        ELSE
          R = R - SPLIT2
          PPF = (((((((E7 * R + E6) * R + E5) * R + E4) * R + E3)
     *          * R + E2) * R + E1) * R + E0) /
     *             (((((((F7 * R + F6) * R + F5) * R + F4) * R + F3)
     *          * R + F2) * R + F1) * R + ONE)
        END IF
        IF (Q .LT. ZERO) PPF = - PPF
        RETURN
      END IF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NORPPF(P,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT
C             FUNCTION VALUE PPF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 AND 1.0, EXCLUSIVELY.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--SQRT, LOG.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--ODEH AND EVANS, THE PERCENTAGE POINTS
C                 OF THE NORMAL DISTRIBUTION, ALGORTIHM 70,
C                 APPLIED STATISTICS, 1974, PAGES 96-97.
C               --EVANS, ALGORITHMS FOR MINIMAL DEGREE
C                 POLYNOMIAL AND RATIONAL APPROXIMATION,
C                 M. SC. THESIS, 1972, UNIVERSITY
C                 OF VICTORIA, B. C., CANADA.
C               --HASTINGS, APPROXIMATIONS FOR DIGITAL
C                 COMPUTERS, 1955, PAGES 113, 191, 192.
C               --NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY APPLIED MATHEMATICS
C                 SERIES 55, 1964, PAGE 933, FORMULA 26.2.23.
C               --FILLIBEN, SIMPLE AND ROBUST LINEAR ESTIMATION
C                 OF THE LOCATION PARAMETER OF A SYMMETRIC
C                 DISTRIBUTION (UNPUBLISHED PH.D. DISSERTATION,
C                 PRINCETON UNIVERSITY), 1969, PAGES 21-44, 229-231.
C               --FILLIBEN, 'THE PERCENT POINT FUNCTION',
C                 (UNPUBLISHED MANUSCRIPT), 1970, PAGES 28-31.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C               --THE KELLEY STATISTICAL TABLES, 1948.
C               --OWEN, HANDBOOK OF STATISTICAL TABLES,
C                 1962, PAGES 3-16.
C               --PEARSON AND HARTLEY, BIOMETRIKA TABLES
C                 FOR STATISTICIANS, VOLUME 1, 1954,
C                 PAGES 104-113.
C     COMMENTS--THE CODING AS PRESENTED BELOW
C               IS ESSENTIALLY IDENTICAL TO THAT
C               PRESENTED BY ODEH AND EVANS
C               AS ALGORTIHM 70 OF APPLIED STATISTICS.
C               THE PRESENT AUTHOR HAS MODIFIED THE
C               ORIGINAL ODEH AND EVANS CODE WITH ONLY
C               MINOR STYLISTIC CHANGES.
C             --AS POINTED OUT BY ODEH AND EVANS
C               IN APPLIED STATISTICS,
C               THEIR ALGORITHM REPRESENTES A
C               SUBSTANTIAL IMPROVEMENT OVER THE
C               PREVIOUSLY EMPLOYED
C               HASTINGS APPROXIMATION FOR THE
C               NORMAL PERCENT POINT FUNCTION--
C               THE ACCURACY OF APPROXIMATION
C               BEING IMPROVED FROM 4.5*(10**-4)
C               TO 1.5*(10**-8).
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --OCTOBER   1976.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA P0,P1,P2,P3,P4
     1/-.322232431088,-1.0,
     1 -.342242088547,-.204231210245E-1,
     1 -.453642210148E-4/
      DATA Q0,Q1,Q2,Q3,Q4
     1/.993484626060E-1,.588581570495,
     1 .531103462366,.103537752850,
     1 .38560700634E-2/
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(P.LE.0.0.OR.P.GE.1.0)GOTO50
      GOTO90
   50 WRITE(ICOUT,1)
    1 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'NORPPF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,46)P
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,'*****')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
   90 CONTINUE
C
C               ************************************************
C               **  STEP 2--                                  **
C               **  COMPUTE THE PERCENT POINT FUNCTION VALUE  **
C               ************************************************
C
      IF(P.EQ.0.5)GOTO120
      GOTO129
  120 CONTINUE
      PPF=0.0
      GOTO9000
  129 CONTINUE
C
      PHOLD=P
      R=P
      IF(PHOLD.GT.0.5)R=1.0-R
      T=SQRT(-2.0*LOG(R))
      ANUM=((((T*P4+P3)*T+P2)*T+P1)*T+P0)
      ADEN=((((T*Q4+Q3)*T+Q2)*T+Q1)*T+Q0)
      PPF=T+(ANUM/ADEN)
      IF(PHOLD.LT.0.5)PPF=-PPF
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE NORRAN(N,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2).
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE NORMAL DISTRIBUTION
C             WITH MEAN = 0 AND STANDARD DEVIATION = 1.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--LOG, SQRT, SIN, COS.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     METHOD--BOX-MULLER ALGORITHM.
C     REFERENCES--BOX AND MULLER, 'A NOTE ON THE GENERATION
C                 OF RANDOM NORMAL DEVIATES', JOURNAL OF THE
C                 ASSOCIATION FOR COMPUTING MACHINERY, 1958,
C                 PAGES 610-611.
C               --TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 33-34.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 39.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--JUNE      1972.
C     UPDATED         --SEPTEMBER 1975.
C     UPDATED         --NOVEMBER  1975.
C     UPDATED         --JULY      1976.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(2)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
      DATA PI/3.14159265359/
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)GOTO50
      GOTO90
   50 WRITE(ICOUT, 5)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,47)N
      CALL DPWRST('XXX','BUG ')
      RETURN
   90 CONTINUE
    5 FORMAT('***** FATAL ERROR--THE 1ST INPUT ARGUMENT TO THE ',
     1'NORRAN SUBROUTINE IS NON-POSITIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C     THEN GENERATE 2 ADDITIONAL UNIFORM (0,1) RANDOM NUMBERS
C     (TO BE USED BELOW IN FORMING THE N-TH NORMAL
C     RANDOM NUMBER WHEN THE DESIRED SAMPLE SIZE N
C     HAPPENS TO BE ODD).
C
      CALL UNIRAN(N,ISEED,X)
      CALL UNIRAN(2,ISEED,Y)
C
C     GENERATE N NORMAL RANDOM NUMBERS
C     USING THE BOX-MULLER METHOD.
C
      DO200I=1,N,2
      IP1=I+1
      U1=X(I)
      IF(I.EQ.N)GOTO210
      U2=X(IP1)
      GOTO220
  210 U2=Y(2)
  220 ARG1=-2.0*LOG(U1)
      ARG2=2.0*PI*U2
      SQRT1=SQRT(ARG1)
      Z1=SQRT1*COS(ARG2)
      Z2=SQRT1*SIN(ARG2)
      X(I)=Z1
      IF(I.EQ.N)GOTO200
      X(IP1)=Z2
  200 CONTINUE
C
      RETURN
      END
      SUBROUTINE NORSF(P,SF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE SPARSITY
C              FUNCTION VALUE FOR THE NORMAL (GAUSSIAN)
C              DISTRIBUTION WITH MEAN = 0 AND STANDARD DEVIATION = 1. 
C              THIS DISTRIBUTION IS DEFINED FOR ALL X AND HAS
C              THE PROBABILITY DENSITY FUNCTION
C              F(X) = (1/SQRT(2*PI))*EXP(-X*X/2). 
C              NOTE THAT THE SPARSITY FUNCTION OF A DISTRIBUTION
C              IS THE DERIVATIVE OF THE PERCENT POINT FUNCTION,
C              AND ALSO IS THE RECIPROCAL OF THE PROBABILITY
C              DENSITY FUNCTION (BUT IN UNITS OF P RATHER THAN X).
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE 
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE SPARSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--SF     = THE SINGLE PRECISION
C                                SPARSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION SPARSITY
C             FUNCTION VALUE SF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 AND 1.0, EXCLUSIVELY.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NORPPF. 
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--FILLIBEN, SIMPLE AND ROBUST LINEAR ESTIMATION
C                 OF THE LOCATION PARAMETER OF A SYMMETRIC
C                 DISTRIBUTION (UNPUBLISHED PH.D. DISSERTATION,
C                 PRINCETON UNIVERSITY), 1969, PAGES 21-44, 229-231.
C               --FILLIBEN, 'THE PERCENT POINT FUNCTION',
C                 (UNPUBLISHED MANUSCRIPT), 1970, PAGES 28-31.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 40-111.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-921-2315
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION P
      DOUBLE PRECISION SF
      DOUBLE PRECISION PPF
      DOUBLE PRECISION PDF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
      DATA C/.3989422804/
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LE.0.0D0 .OR. P.GE.1.0D0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST  ARGUMENT TO NORSF IS OUTSIDE THE')
    2 FORMAT('      THE ALLOWABLE (0,1) INTERVAL *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.7,' *****')
C
C-----START POINT-----------------------------------------------------
C
      CALL NODPPF(P,PPF)
      PDF=DBLE(C)*EXP(-(PPF*PPF)/2.0D0)
      IF(PDF.NE.0.0D0)THEN
        SF=1.0D0/PDF
      ELSE
        SF=DBLE(CPUMAX)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE NPV(X,Y,N,IWRITE,XIDTEM,STAT,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE NEGATIVE PREDICTIVE VALUE
C              BETWEEN TWO VARIABLES.
C
C              THIS IS NPVICALLY FOR THE 2X2 CASE.  THAT IS,
C              EACH VARIABLE HAS TWO MUTUALLY EXCLUSIVE
C              CHOICES CODED AS 1 (FOR SUCCESS) OR 0 (FOR
C              FAILURE).
C
C              A TYPICAL EXAMPLE WOULD BE WHERE VARIABLE ONE
C              DENOTES THE GROUND TRUTH AND A VALUE OF 1
C              INDICATES "PRESENT" AND A VALUE OF 0 INDICATES
C              "NOT PRESENT".  VARIABLE TWO REPRESENTS SOME TYPE
C              OF DETECTION DEVICE WHERE A VALUE OF 1 INDICATES
C              THE DEVICE DETECTED THE NPVIED OBJECT WHILE A
C              VALUE OF 0 INDICATES THAT THE OBJECT WAS NOT
C              DETECTED.  NEGATIVE PREDICTIVE VALUE IS THEN DEFINED AS
C              (TRUE NEGATIVE)/(TRUE NEGATIVE + FALSE NEGATIVE).
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE FIRST SET
C                                OF DATA.
C                     --Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE SECOND SET
C                                OF DATA.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X, OR EQUIVALENTLY,
C                                THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C     OUTPUT ARGUMENTS--STAT   = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED NEGATIVE PREDICTIVE VALUE
C                                BETWEEN THE 2 SETS OF DATA
C                                IN THE INPUT VECTORS X AND Y.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE NEGATIVE PREDICTIVE VALUE BETWEEN THE 2 SETS
C             OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/3
C     ORIGINAL VERSION--MARCH     2007.
C     UPDATED         --AUGUST    2007. IF 2X2 CASE, CHECK IF SUM
C                                       OF ENTRIES IS <= 4.  IN THIS
C                                       CASE, ASSUME WE HAVE RAW DATA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION XIDTEM(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NPV '
      ISUBN2='    '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF NPV--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I),Y(I)
   56     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('***** ERROR IN THE NEGATIVE PREDICTIVE VALUE')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1203)
 1203   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE RESPONSE ',
     1         'VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N
 1205   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************
C               **  STEP 22--                             **
C               **  CHECK THAT THE VARIABLES HAVE AT MOST **
C               **  TWO DISTINCT VALUES (1 INDICATES A    **
C               **  SUCCESS, 0 INDICATES A FAILURE).      **
C               ********************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: CHECK FOR SPECIAL CASE N = 2.  IN THIS CASE,
C           ASSUME WE HAVE A 2X2 TABLE OF COUNTS INSTEAD
C           OF RAW DATA.
C
      IF(N.EQ.2)THEN
        N11=INT(X(1)+0.5)
        N21=INT(X(2)+0.5)
        N12=INT(Y(1)+0.5)
        N22=INT(Y(2)+0.5)
C
C       CHECK IF ALL ENTRIES 0 OR 1. IF SO, ASSUME
C       RAW DATA CASE.
C
        IF((N11.EQ.0 .OR. N11.EQ.1) .AND.
     1     (N12.EQ.0 .OR. N12.EQ.1) .AND.
     1     (N21.EQ.0 .OR. N21.EQ.1) .AND.
     1     (N22.EQ.0 .OR. N22.EQ.1)) GOTO1349
C
        IF(N11.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1311)
 1311     FORMAT('      ROW 1 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N21.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1321)
 1321     FORMAT('      ROW 2 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N12.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1331)
 1331     FORMAT('      ROW 1 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N22.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1341)
 1341     FORMAT('      ROW 2 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        AN11=REAL(N11)
        AN21=REAL(N21)
        AN12=REAL(N12)
        AN22=REAL(N22)
        STAT=AN22/(AN12+AN22)
        GOTO3000
      ENDIF
C
      CALL DISTIN(X,N,IWRITE,XIDTEM,NDIST,IBUGA3,IERROR)
      IF(NDIST.EQ.1)THEN
        AVAL=XIDTEM(1)
        IF(ABS(AVAL).LE.0.5)THEN
          AVAL=0.0
        ELSE
          AVAL=1.0
        ENDIF
        DO2202I=1,N
          X(I)=1.0
 2202   CONTINUE
      ELSEIF(NDIST.EQ.2)THEN
        IF(XIDTEM(1).EQ.1.0 .OR. XIDTEM(2).EQ.1.0)THEN
          DO2203I=1,N
            IF(X(I).NE.1.0)X(I)=0.0
 2203     CONTINUE
        ELSE
          ATEMP1=MIN(XIDTEM(1),XIDTEM(2))
          ATEMP2=MAX(XIDTEM(1),XIDTEM(2))
          DO2208I=1,N1
            IF(X(I).EQ.ATEMP1)X(I)=0.0
            IF(X(I).EQ.ATEMP2)X(I)=1.0
 2208     CONTINUE
        ENDIF
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2211)
 2211   FORMAT('      RESPONSE VARIABLE ONE SHOULD CONTAIN AT MOST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2213)
 2213   FORMAT('      TWO DISTINCT VALUES.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2215)NDIST
 2215   FORMAT('      ',I8,' DISTINCT VALUES FOUND.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
 1349 CONTINUE
C
      CALL DISTIN(Y,N,IWRITE,XIDTEM,NDIST,IBUGA3,IERROR)
      IF(NDIST.EQ.1)THEN
        AVAL=XIDTEM(1)
        IF(ABS(AVAL).LE.0.5)THEN
          AVAL=0.0
        ELSE
          AVAL=1.0
        ENDIF
        DO2302I=1,N
          Y(I)=1.0
 2302   CONTINUE
      ELSEIF(NDIST.EQ.2)THEN
        IF(XIDTEM(1).EQ.1.0 .OR. XIDTEM(2).EQ.1.0)THEN
          DO2303I=1,N
            IF(Y(I).NE.1.0)Y(I)=0.0
 2303     CONTINUE
        ELSE
          ATEMP1=MIN(XIDTEM(1),XIDTEM(2))
          ATEMP2=MAX(XIDTEM(1),XIDTEM(2))
          DO2308I=1,N
            IF(Y(I).EQ.ATEMP1)Y(I)=0.0
            IF(Y(I).EQ.ATEMP2)Y(I)=1.0
 2308     CONTINUE
        ENDIF
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2311)
 2311   FORMAT('      RESPONSE VARIABLE TWO SHOULD CONTAIN AT MOST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2313)
 2313   FORMAT('      TWO DISTINCT VALUES.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2315)NDIST
 2315   FORMAT('      ',I8,' DISTINCT VALUES FOUND.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      N11=0
      N12=0
      N21=0
      N22=0
      DO2410I=1,N
        IF(X(I).EQ.1.0 .AND. Y(I).EQ.1.0)THEN
          N11=N11+1
        ELSEIF(X(I).EQ.0.0 .AND. Y(I).EQ.0.0)THEN
          N22=N22+1
        ELSEIF(X(I).EQ.1.0 .AND. Y(I).EQ.0.0)THEN
          N12=N12+1
        ELSEIF(X(I).EQ.0.0 .AND. Y(I).EQ.1.0)THEN
          N21=N21+1
        ENDIF
 2410 CONTINUE
C
      STAT=REAL(N22)/REAL(N12+N22)
C
 3000 CONTINUE
C
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF' .OR. IWRITE.EQ.'NO')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)STAT
  811 FORMAT('THE NEGATIVE PREDICTIVE VALUE PROPORTION = ',G15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF NPV--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N,N11,N12,N21,N22
 9013   FORMAT('N,N11,N12,N21,N22 = ',5I10)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)STAT
 9015   FORMAT('STAT = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE NRMLAG(X,AN,ALN)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE NORMALIZED LAGUERRE
C              POLYNOMIAL OF ORDER N.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION INPUT ARGUMENT
C                       AN     = THE SINGLE PRECISION VALUE FOR THE
C                                ORDER OF THE FUNCTION (SHOULD BE
C                                NON-NEGATIVE ORDER)
C     OUTPUT ARGUMENTS--ALN    = THE SINGLE PRECISION VALUE OF THE
C                                NORMALIZED LAGUERRE POLYNOMIAL.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE
C     MODE OF INTERNAL OPERATIONS--SOME DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--"HANDBOOK OF MATHEMATICAL FUNCTIONS, AMS 55", 
C                 ABRAMOWITZ AND STEGUM.
C                 USE FOLLOWING RECURRENCE FORMULA:
C                    L(N+1) = (1+2*N-X)*L(N)-N**2*L(N-1)
C                 FIRST FEW TERMS ARE FROM TABLE 22.10 OF ABRAMOWITZ
C                 AND STEGUM.
C                 NORMALIZED LAGUERRE IS LAGUERRE SCALED BY N!
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JULY       1995. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 ICOUTINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,ICOUTINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN, DN2
      DOUBLE PRECISION DLN, DLN1, DLN2
C
C-----START POINT-----------------------------------------------------
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    4 FORMAT('***** NON-FATAL DIAGNOSTIC--THE 1ST INPUT ARGUMENT ',
     1'TO THE NRMLAG SUBROUTINE IS NEGATIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
      N=INT(AN+0.5)
      IF(N.LT.0)THEN
        WRITE(ICOUT,6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    6 FORMAT('***** NON-FATAL DIAGNOSTIC--THE 2ND INPUT ARGUMENT ',
     1'TO THE NRMLAGRRE SUBROUTINE IS NEGATIVE *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
      DX=DBLE(X)
      DN=DBLE(N)
C
      IF(N.LE.0)THEN
        ALN=1.0
      ELSEIF(N.EQ.1)THEN
        ALN=-X+1.0
      ELSEIF(N.EQ.2)THEN
        ALN=X**2 - 4.0*X + 2.0
      ELSEIF(N.EQ.3)THEN
        DLN=-DX**3 + 9.0D0*DX**2 -18.0D0*DX + 6.0D0
        ALN=REAL(DLN)
      ELSE
        DLN1=-DX**3 + 9.0D0*DX**2 -18.0D0*DX + 6.0D0
        DLN2=DX**2 - 4.0D0*DX + 2.0D0
        DO1000I=4,N
          DN2=DBLE(I)-1.0D0
          DLN=(1.0D0+2.0D0*DN2-DX)*DLN1 - DN2**2*DLN2
          DLN2=DLN1
          DLN1=DLN
 1000   CONTINUE
        ALN=REAL(DLN)
      ENDIF
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE OCCPDF(X,B,C,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE CLASICAL OCCUPANCY
C              DISTRIBUTION ON THE INTERVAL (0,C).
C              THIS DISTRIBUTION HAS MEAN = (C-1)**B*C**(1-B)
C              AND STANDARD DEVIATION = (C-1)*(C-2)**B*C**(1-B) +
C                                       (C-1)**B*C**(1-B) -
C                                       (C-1)**(2*B)*C**(2-2*B)
C              THIS DISTRIBUTION HAS THE PROBABILITY
C              MASS FUNCTION:
C
C                P(X;C,B) = SUM[i=0 to C-X][(-1)**i*(X+i i)*
C                           (C  X+i)*((C-X-i)/C)**B
C                         = SUM[i=X to C][(-1)**(i-X)*C!*((C-i)/C)**B/
C                           (X!*(i-X)!(C-i)!
C                         = C!*S(B,C-X)/(X!*C**B)
C                         X = 0, 1, ..., C
C               WITH S DENOTING STERLING'S NUMBER OF THE SECOND
C               KIND.
C
C               GIVEN C CELLS AND B BALLS, THERE ARE C**B WAYS THE
C               BALLS CAN BE PLACED IN THE C CELLS (ASSUMMING
C               THAT ALL PLACEMENTS ARE EQUI-PROBABLE).  THE
C               CLASSICAL OCCUPANCY DISTRIBUTION IS THE DISTRIBUTION
C               OF THE NUMBER OF EMPTY CELLS.
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                       C      = THE INTEGER VALUE THAT SPECIFIES
C                                THE FIRST SHAPE PARAMETER (THE
C                                NUMBER OF CELLS)
C                       B      = THE INTEGER VALUE THAT SPECIFIES
C                                THE SECOND SHAPE PARAMETER (THE
C                                NUMBER OF BALLS)
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE BETWEEN 0 AND C, INCLUSIVELY.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DLNGAMM.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS" SECOND EDITION,
C                 PAGES 414-416.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--JUNE      2006. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      INTEGER B
      INTEGER C
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DJ
      DOUBLE PRECISION DSIGN
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DLNGAM
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PDF=0.0
C
      IF(C.LT.1)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)C
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   12 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO ',
     1       'OCCPDF IS LESS THAN 1.')
C
      IF(B.LT.1)THEN
        WRITE(ICOUT,22)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)B
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
   22 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO ',
     1       'OCCPDF IS LESS THAN 1.')
C
      IX=INT(X+0.5)
      IF(IX.LT.0 .OR. IX.GT.C)THEN
        WRITE(ICOUT,2)C
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)IX
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    2 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO ',
     1       'OCCPDF IS OUTSIDE THE (0,',I8,') INTERVAL')
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(IX)
      DB=DBLE(B)
      DC=DBLE(C)
      DPDF=0.0D0
C
C     NOTE: JOHNSON, KOTZ, AND KEMP PROVIDE 3 DIFFERENT
C           SUMMATION FORMULAS.  THESE SEEM ACCURATE UP TO
C           ABOUT N = 50.
C
CCCCC DO100J=IX,C
CCCCC   DJ=DBLE(J)
CCCCC   DSIGN=(-1.0D0)**(DJ-DX)
CCCCC   IF(J.EQ.C)THEN
CCCCC     CONTINUE
CCCCC   ELSE
CCCCC     DTERM1=DLNGAM(DC+1.0D0) - DLNGAM(DX+1.0D0) -
CCCCC1           DLNGAM(DJ-DX+1.0D0) - DLNGAM(DC-DJ+1.0D0) +
CCCCC1           DB*DLOG((DC-DJ)/DC)
CCCCC     DTERM1=DEXP(DTERM1)
CCCCC     DPDF=DPDF + DSIGN*DTERM1
CCCCC   ENDIF
CC100 CONTINUE
CCCCC PDF=REAL(DPDF)
C
CCCCC DTERM1=DLNGAM(DC+1.0D0) - DLNGAM(DX+1.0D0) - DLNGAM(DC-DX+1.0D0)
C
CCCCC DSUM1=0.0D0
CCCCC DO200J=0,C-IX,2
CCCCC   DJ=DBLE(J)
CCCCC   DTERM2=DLNGAM(DC-DX+1.0D0) - DLNGAM(DJ+1.0D0) -
CCCCC1         DLNGAM(DC-DX-DJ+1.0D0)
CCCCC   DTERM3=DB*DLOG(1.0D0 - (DX+DJ)/DC)
CCCCC   DTERM4=DEXP(DTERM2 + DTERM3)
CCCCC   DSUM1=DSUM1 + DTERM4
CC200 CONTINUE
C
CCCCC DSUM2=0.0D0
CCCCC DO400J=1,C-IX,2
CCCCC   DJ=DBLE(J)
CCCCC   DTERM2=DLNGAM(DC-DX+1.0D0) - DLNGAM(DJ+1.0D0) -
CCCCC1         DLNGAM(DC-DX-DJ+1.0D0)
CCCCC   DTERM3=DB*DLOG(1.0D0 - (DX+DJ)/DC)
CCCCC   DTERM4=DEXP(DTERM2 + DTERM3)
CCCCC   DSUM2=DSUM2 + DTERM4
CC400 CONTINUE
C
CCCCC DSUM1=DSUM1 - DSUM2
CCCCC DPDF=DEXP(DTERM1 + DLOG(DSUM1))
CCCCC PDF=REAL(DPDF)
C
 9000 CONTINUE
      RETURN
      END 
      SUBROUTINE ODDDIS(Y,N,PSTAMV,IWRITE,XIDTEM,N11,N21,NOUT,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE IS A UITILITY ROUTINE USED BY
C              THE ODDS RATIO AND RELATED ROUTINES.  THE ODDS
C              RATIO ASSUMES THERE ARE TWO CHOICES THAT ARE
C              TYPICALLY CODED AS 1 (FOR SUCCESS) OR
C              0 (FOR FAILURE).   SINCE THE SAMPLES CAN BE
C              OF DIFFERENT SIZES, ALLOW FOR A MISSING VALUE
C              CODE (PSTAMV).
C
C              THIS ROUTINE DOES THE FOLLOWING:
C
C              1) STRIP OUT ANY MISSING VALUES.
C
C              2) DETERMINE HOW MANY DISTINCT VALUES THERE ARE
C                 IN Y.  SHOULD BE EITHER ONE OR TWO AFTER
C                 MISSING VALUES EXTRACTED.
C
C              3) COUNT UP NUMBER OF SUCCESSES (1's) AND
C                 FAILURES (0's).
C
C     INPUT  ARGUMENTS--Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --PSTAMV = THE SINGLE PRECISION MISSING VALUE
C                                CODE.
C                     --IWRITE = CHARACTER VARIABLE SPECIFYING
C                                PRINT OPTION.
C                     --XIDTEM = TEMPORARY SINGLE PRECISION VECTOR.
C     OUTPUT ARGUMENTS--N11    = THE INTEGER VALUE CONTAINING THE
C                                NUMBER OF SUCCESSES.
C                     --N21    = THE INTEGER VALUE CONTAINING THE
C                                NUMBER OF FAILURES.
C                     --NOUT   = THE INTEGER VALUE CONTAINING THE
C                                NUMBER OF OBSERVATIONS AFTER
C                                MISSING VALUES STRIPPED OUT.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE ODDS RATIO BETWEEN THE 2 SETS
C             OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DISTIN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/4
C     ORIGINAL VERSION--APRIL     2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
      DIMENSION XIDTEM(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='ODDD'
      ISUBN2='IS  '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF ODDDIS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y(I)
   56     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('***** ERROR IN THE ODDDIS ROUTINE--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1203)
 1203   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N
 1205   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************
C               **  STEP 22--                             **
C               **  STRIP OUT MISSING VALUES              **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      ICNT=0
      DO1260I=1,N
        IF(ABS(Y(I) - PSTAMV).GE.0.001)THEN
          ICNT=ICNT+1
          Y(ICNT)=Y(I)
        ENDIF
 1260 CONTINUE
      NOUT=ICNT
C
      IF(NOUT.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1281)
 1281   FORMAT('      AFTER REMOVING THE MISSING VALUES,')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1283)
 1283   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)NOUT
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************
C               **  STEP 22--                             **
C               **  CHECK THAT THE VARIABLES HAVE AT MOST **
C               **  TWO DISTINCT VALUES (1 INDICATES A    **
C               **  SUCCESS, 0 INDICATES A FAILURE).      **
C               ********************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DISTIN(Y,NOUT,IWRITE,XIDTEM,NDIST,IBUGA3,IERROR)
      IF(NDIST.EQ.1)THEN
        AVAL=XIDTEM(1)
        IF(ABS(AVAL).LE.0.5)THEN
          AVAL=0.0
        ELSE
          AVAL=1.0
        ENDIF
        DO2302I=1,NOUT
          Y(I)=1.0
 2302   CONTINUE
      ELSEIF(NDIST.EQ.2)THEN
        IF(XIDTEM(1).EQ.1.0 .OR. XIDTEM(2).EQ.1.0)THEN
          DO2303I=1,NOUT
            IF(Y(I).NE.1.0)Y(I)=0.0
 2303     CONTINUE
        ELSE
          ATEMP1=MIN(XIDTEM(1),XIDTEM(2))
          ATEMP2=MAX(XIDTEM(1),XIDTEM(2))
          DO2308I=1,N2
            IF(Y(I).EQ.ATEMP1)Y(I)=0.0
            IF(Y(I).EQ.ATEMP2)Y(I)=1.0
 2308     CONTINUE
        ENDIF
      ELSE
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2311)
 2311   FORMAT('      RESPONSE VARIABLE SHOULD CONTAIN AT MOST')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2313)
 2313   FORMAT('      TWO DISTINCT VALUES.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2315)NDIST
 2315   FORMAT('      ',I8,' DISTINCT VALUES FOUND.')
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      N11=0
      N21=0
C
      DO2410I=1,NOUT
        IF(Y(I).EQ.1.0)THEN
          N11=N11+1
        ELSE
          N21=N21+1
        ENDIF
 2410 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF ODDDIS--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N,NOUT,N11,N21
 9013   FORMAT('N,NOUT,N11,N21 = ',5I10)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE ODDRAT(X,N1,Y,N2,PSTAMV,IWRITE,XIDTEM,STAT,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE ODDS RATIO
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE FIRST SET
C                                OF DATA.
C                     --N1     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE SECOND SET
C                                OF DATA.
C                     --N2     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C                     --PSTAMV = THE MISSING VALUE CODE
C     OUTPUT ARGUMENTS--ODDRAT = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED ODDS RATIO
C                                BETWEEN THE 2 SETS OF DATA
C                                IN THE INPUT VECTORS X AND Y.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE ODDS RATIO BETWEEN THE 2 SETS
C             OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--ODDDIS.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/4
C     ORIGINAL VERSION--APRIL     2007.
C     UPDATED         --AUGUST    2007. IF 2X2 CASE, CHECK IF SUM
C                                       OF ENTRIES IS <= 4.  IN THIS
C                                       CASE, ASSUME WE HAVE RAW DATA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION XIDTEM(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='ODDR'
      ISUBN2='AT  '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF ODDRAT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N1,N2
   53   FORMAT('N1,N2 = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,MAX(N1,N2)
          WRITE(ICOUT,56)I,X(I),Y(I)
   56     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N1.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('***** ERROR IN THE BIAS CORRECTED ODDS RATIO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1203)
 1203   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE FIRST ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N1
 1205   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(N2.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1213)
 1213   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE SECOND ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N2
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ********************************************
C               **  STEP 22--                             **
C               **  CHECK THAT THE VARIABLES HAVE AT MOST **
C               **  TWO DISTINCT VALUES (1 INDICATES A    **
C               **  SUCCESS, 0 INDICATES A FAILURE).      **
C               ********************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     NOTE: CHECK FOR SPECIAL CASE N = 2.  IN THIS CASE,
C           ASSUME WE HAVE A 2X2 TABLE OF COUNTS INSTEAD
C           OF RAW DATA.
C
      IF(N1.EQ.2 .AND. N2.EQ.2)THEN
        N11=INT(X(1)+0.5)
        N21=INT(X(2)+0.5)
        N12=INT(Y(1)+0.5)
        N22=INT(Y(2)+0.5)
C
C       CHECK IF ALL ENTRIES 0 OR 1. IF SO, ASSUME
C       RAW DATA CASE.
C
        IF((N11.EQ.0 .OR. N11.EQ.1) .AND.
     1     (N12.EQ.0 .OR. N12.EQ.1) .AND.
     1     (N21.EQ.0 .OR. N21.EQ.1) .AND.
     1     (N22.EQ.0 .OR. N22.EQ.1)) GOTO1349
C
        IF(N11.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1311)
 1311     FORMAT('      ROW 1 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N21.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1321)
 1321     FORMAT('      ROW 2 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N12.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1331)
 1331     FORMAT('      ROW 1 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N22.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1341)
 1341     FORMAT('      ROW 2 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        AN11=REAL(N11)
        AN21=REAL(N21)
        AN12=REAL(N12)
        AN22=REAL(N22)
        GOTO3000
      ENDIF
C
 1349 CONTINUE
C
      CALL ODDDIS(X,N1,PSTAMV,IWRITE,XIDTEM,N11,N21,NOUT,
     1            IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. IERROR.EQ.'ON')GOTO9000
      CALL ODDDIS(Y,N2,PSTAMV,IWRITE,XIDTEM,N12,N22,NOUT,
     1            IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. IERROR.EQ.'ON')GOTO9000
      AN11=REAL(N11)
      AN21=REAL(N21)
      AN12=REAL(N12)
      AN22=REAL(N22)
      GOTO3000
C
C     COMPUTE THE BIAS CORRECTED LOG OF THE ODDS RATIO.
C
 3000 CONTINUE
      AN1=AN11+AN21
      AN2=AN12+AN22
      AN=AN1 + AN2
C
      P11=AN11/AN1
      P21=AN21/AN1
      P12=AN12/AN2
      P22=AN22/AN2
C
      STAT=(AN11+0.5)*(AN22+0.5)/((AN12+0.5)*(AN21+0.5))
C
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF' .OR. IWRITE.EQ.'NO')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)STAT
  811 FORMAT('THE BIAS CORRECTED ODDS RATIO = ',G15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF ODDRAT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N,N11,N12,N21,N22
 9013   FORMAT('N,N11,N12,N21,N22 = ',5I10)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)P11,P12,P21,P22
 9014   FORMAT('P11,P12,P21,P22 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)STAT
 9015   FORMAT('STAT = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE ODDRSE(X,N1,Y,N2,PSTAMV,IWRITE,XIDTEM,STAT,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE STANDARD ERROR OF THE
C              BIAS CORRECTED ODDS RATIO.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE FIRST SET
C                                OF DATA.
C                     --N1     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE SECOND SET
C                                OF DATA.
C                     --N2     = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C                     --PSTAMV = THE MISSING VALUE CODE
C     OUTPUT ARGUMENTS--ODDRSE = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED STANDARD ERROR OF THE
C                                ODDS RATIO (BIAS CORRECTED)
C                                BETWEEN THE 2 SETS OF DATA
C                                IN THE INPUT VECTORS X AND Y.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE STANDARD ERROR OF THE ODDS RATIO BETWEEN
C             THE 2 SETS OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--ODDDIS.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/4
C     ORIGINAL VERSION--APRIL     2007.
C     UPDATED         --AUGUST    2007. IF 2X2 CASE, CHECK IF SUM
C                                       OF ENTRIES IS <= 4.  IN THIS
C                                       CASE, ASSUME WE HAVE RAW DATA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION XIDTEM(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='ODDR'
      ISUBN2='SE  '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF ODDRSE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N1,N2
   53   FORMAT('N1,N2 = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,MAX(N1,N2)
          WRITE(ICOUT,56)I,X(I),Y(I)
   56     FORMAT('I,X(I),Y(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N1.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('***** ERROR IN THE BIAS CORRECTED ',
     1         'LOG ODDS RATIO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1203)
 1203   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE FIRST ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N1
 1205   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(N2.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1213)
 1213   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE SECOND ',
     1         'RESPONSE VARIABLES IS LESS THAN TWO')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1205)N2
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C     NOTE: CHECK FOR SPECIAL CASE N = 2.  IN THIS CASE,
C           ASSUME WE HAVE A 2X2 TABLE OF COUNTS INSTEAD
C           OF RAW DATA.
C
      IF(N1.EQ.2 .AND. N2.EQ.2)THEN
        N11=INT(X(1)+0.5)
        N21=INT(X(2)+0.5)
        N12=INT(Y(1)+0.5)
        N22=INT(Y(2)+0.5)
C
C       CHECK IF ALL ENTRIES 0 OR 1. IF SO, ASSUME
C       RAW DATA CASE.
C
        IF((N11.EQ.0 .OR. N11.EQ.1) .AND.
     1     (N12.EQ.0 .OR. N12.EQ.1) .AND.
     1     (N21.EQ.0 .OR. N21.EQ.1) .AND.
     1     (N22.EQ.0 .OR. N22.EQ.1)) GOTO1349
C
        IF(N11.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1311)
 1311     FORMAT('      ROW 1 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N21.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1321)
 1321     FORMAT('      ROW 2 COLUMN 1 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N12.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1331)
 1331     FORMAT('      ROW 1 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ELSEIF(N22.LT.0)THEN
          WRITE(ICOUT,999)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1201)
          CALL DPWRST('XXX','BUG ')
          WRITE(ICOUT,1341)
 1341     FORMAT('      ROW 2 COLUMN 2 OF THE COUNTS TABLE IS ',
     1           'NEGATIVE.')
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
        AN11=REAL(N11)
        AN21=REAL(N21)
        AN12=REAL(N12)
        AN22=REAL(N22)
        GOTO3000
      ENDIF
C
 1349 CONTINUE
C
      CALL ODDDIS(X,N1,PSTAMV,IWRITE,XIDTEM,N11,N21,NOUT,
     1            IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. IERROR.EQ.'ON')GOTO9000
      CALL ODDDIS(Y,N2,PSTAMV,IWRITE,XIDTEM,N12,N22,NOUT,
     1            IBUGA3,IERROR)
      IF(IERROR.EQ.'YES' .OR. IERROR.EQ.'ON')GOTO9000
      AN11=REAL(N11)
      AN21=REAL(N21)
      AN12=REAL(N12)
      AN22=REAL(N22)
      GOTO3000
C
C     COMPUTE THE BIAS CORRECTED LOG OF THE ODDS RATIO.
C
 3000 CONTINUE
      AN1=AN11+AN21
      AN2=AN12+AN22
      AN=AN1 + AN2
C
      P11=AN11/AN1
      P21=AN21/AN1
      P12=AN12/AN2
      P22=AN22/AN2
C
      ODDRAT=(AN11+0.5)*(AN22+0.5)/((AN12+0.5)*(AN21+0.5))
      STAT=ODDRAT*SQRT((1.0/(AN11+0.5)) + (1.0/(AN21+0.5)) +
     1         (1.0/(AN12+0.5)) + (1.0/(AN22+0.5)))
C
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF' .OR. IWRITE.EQ.'NO')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)STAT
  811 FORMAT('THE STANDARD ERROR OF THE BIAS CORRECTED ODDS ',
     1       'RATIO = ',G15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF ODDRSE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)N,N11,N12,N21,N22
 9013   FORMAT('N,N11,N12,N21,N22 = ',5I10)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)P11,P12,P21,P22
 9014   FORMAT('P11,P12,P21,P22 = ',4G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)STAT
 9015   FORMAT('STAT = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE OGICDF(DX,DN,DCDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE OGIVE DISTRIBUTION WITH SHAPE
C              PARAMETER N.  THE CUMULATIVE DISTRIBUTION FUNCTION IS:
C
C              F(X;N) = ((4*N-2)/(3*N-1))*X**N - ((N-1)/(3*N-1))*X**(2*N)
C                       0 <= X <= 1, N >= 0.5
C
C              WITH N DENOTING THE SHAPE PARAMETER.
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --DN     = THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--DCDF   = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE OGIVE
C             DISTRIBUTION WITH SHAPE PARAMETER N.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DQAGI.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KOTZ AND VAN DORP (2004), "BEYOND N: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                 SUPPORT AND APPLICATIONS", WORLD SCIENTFIC
C                 PUBLISHING COMPANY, CHAPTER 8.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007.10
C     ORIGINAL VERSION--OCTOBER   2007.
C     UPDATED         --DECEMBER  2007. UPDATE FROM USING NUMERICAL
C                                       INTEGRATION TO USING EXPLICIT
C                                       FORMULA
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
      DOUBLE PRECISION DCDF
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(DX.LE.0.0D0)THEN
        DCDF=0.0D0
        GOTO9000
      ELSEIF(DX.GE.1.0D0)THEN
        DCDF=1.0D0
        GOTO9000
      ELSEIF(DN.LT.0.5D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DN
        CALL DPWRST('XXX','BUG ')
        DCDF=0.0D0
        GOTO9000
      ENDIF
   12 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO OGICDF IS ',
     1       'LESS THAN 0.5')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE CDF     FUNCTION  **
C               ************************************
C
      DTERM1=((4.0D0*DN - 2.0D0)/(3.0D0*DN - 1.0D0))*DX**DN
      DTERM2=((DN - 1.0D0)/(3.0D0*DN - 1.0D0))*DX**(2.0D0*DN)
      DCDF=DTERM1 - DTERM2
C
 9000 CONTINUE
      RETURN
      END
      DOUBLE PRECISION FUNCTION OGIFU2(DX)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE OGIVE DISTRIBUTION WITH
C              SHAPE PARAMETERS N.
C
C              DEFINE AS FUNCTION TO BE USED FOR INTEGRATION
C              CODE CALLED BY OGIPPF.
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C     OUTPUT ARGUMENTS--OGIFU2  = THE DOUBLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE OGIVE DISTRIBUTION WITH
C             SHAPE PARAMETER N.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--OGIPDF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KOTZ AND VAN DORP (2004), "BEYOND N: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                 SUPPORT AND APPLICATIONS", WORLD SCIENTFIC
C                 PUBLISHING COMPANY, CHAPTER 8.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007.10
C     ORIGINAL VERSION--OCTOBER   2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DX
C
      DOUBLE PRECISION DP
      COMMON/OG2COM/DP
C
      DOUBLE PRECISION DN
      COMMON/OGICOM/DN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C               ************************************
C               **  STEP 1--                      **
C               **  COMPUTE THE DENSITY FUNCTION  **
C               ************************************
C
      CALL OGICDF(DX,DN,DCDF)
      OGIFU2=DP - DCDF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE OGIPDF(X,N,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE OGIVE DISTRIBUTION.
C              THE PROBABILITY DENSITY FUNCTION IS:
C
C                  f(X;N) = N*X**(N-1)*{(4*N-2)/(3*N-1) -
C                           ((2*N-2)/(3*N-1))*X**N}
C                           0 <= X <= 1, N >= 0.5
C
C              WITH N DENOTING THE SHAPE PARAMETER.
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --N      = THE SINGLE PRECISION SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE BETWEEN 0 AND 1, INCLUSIVELY.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--KOTZ AND VAN DORP (2004), "BEYOND N: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                 SUPPORT AND APPLICATIONS", WORLD SCIENTFIC
C                 PUBLISHING COMPANY, CHAPTER 8.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--SEPTEMBER   2007. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION N
      DOUBLE PRECISION X
      DOUBLE PRECISION PDF
      DOUBLE PRECISION TERM1
      DOUBLE PRECISION TERM2
      DOUBLE PRECISION TERM3
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF((N.GT.0.5D0 .AND. N.LT.1.0D0) .AND.
     1    X.LE.0.0D0)THEN
        WRITE(ICOUT,2)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        PDF=0.0D0
        GOTO9000
      ELSEIF(N.LT.0.5D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)N
        CALL DPWRST('XXX','BUG ')
        PDF=0.0D0
        GOTO9000
      ENDIF
    2 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO OGIPDF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
   12 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO OGIPDF IS ',
     1       'LESS THAN 0.5')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      IF(X.LE.0.0D0 .AND. N.EQ.0.5D0)THEN
        PDF=1.0D0
      ELSEIF(X.LE.0.0D0 .AND. N.EQ.1.0D0)THEN
        PDF=1.0D0
      ELSEIF(X.LE.0.0D0 .AND.
     1      (N.GT.0.5D0 .AND. N.LT.1.0D0))THEN
        TERM1=N
        TERM2=(4.0D0*N-2.0D0)/(3.0D0-1.0D0)
        TERM3=(2.0D0*N-2.0D0)/(3.0D0-1.0D0)
        PDF=TERM1*(TERM2-TERM3)
      ELSE
        TERM1=N*(X**(N-1.0D0))
        TERM2=(4.0D0*N-2.0D0)/(3.0D0*N-1.0D0)
        TERM3=((2.0D0*N-2.0D0)/(3.0D0*N-1.0D0))*X**N
        PDF=TERM1*(TERM2 - TERM3)
      ENDIF
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE OGIPPF(P,N,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE OGIVE DISTRIBUTION WITH
C              SHAPE PARAMETER N.  THIS DISTRIBUTION HAS
C              THE PROBABILITY DENSITY FUNCTION
C
C                  f(X;N) = N*X**(N-1)*{(4*N-2)/(3*N-1) -
C                           ((2*N-2)/(3*N-1))*X**N}
C                           0 <= X <= 1, N >= 0.5
C
C              WITH N DENOTING THE SHAPE PARAMETER.
C
C              THE PERCENT POINT FUNCTION IS COMPUTED BY NUMERICALLY
C              INVERTING THE OGIVE CUMULATIVE
C              DISTRIBUTION FUNCTION (WHICH IN TURN IS COMPUTED BY
C              NUMERICAL INTEGRATION OF THE PROBABILITYT DENSITY.
C
C     INPUT  ARGUMENTS--P       = THE DOUBLE PRECISION VALUE AT
C                                 WHICH THE PERCENT POINT
C                                 FUNCTION IS TO BE EVALUATED.
C                                 0 < P < 1
C                     --N       = THE FIRST SHAPE PARAMETER
C     OUTPUT ARGUMENTS--PPF     = THE DOUBLE PRECISION PERCENT POINT
C                                 FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION
C             VALUE PPF FOR THE OGIVE
C             DISTRIBUTION WITH SHAPE PARAMETER = N.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--NONE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DFZERO.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KOTZ AND VAN DORP (2004), "BEYOND N: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                 SUPPORT AND APPLICATIONS", WORLD SCIENTFIC
C                 PUBLISHING COMPANY, CHAPTER 8.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007.10
C     ORIGINAL VERSION--OVTOBER   2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION P
      DOUBLE PRECISION N
      DOUBLE PRECISION PPF
C
      DOUBLE PRECISION XUP
      DOUBLE PRECISION XUP2
      DOUBLE PRECISION XLOW
      DOUBLE PRECISION RE
      DOUBLE PRECISION AE
C
      DOUBLE PRECISION OGIFU2
      EXTERNAL OGIFU2
C
      DOUBLE PRECISION DP
      COMMON/OG2COM/DP
C
      DOUBLE PRECISION DN
      COMMON/OGICOM/DN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C               *****************************************
C               **  STEP 1--                           **
C               **  CHECK FOR VALID PARAMETERS         **
C               *****************************************
C
      IF(P.LT.0.0D0 .OR. P.GT.1.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,48)P
        CALL DPWRST('XXX','WRIT')
        PPF=0.0D0
        GOTO9000
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO OGIPPF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL.')
C
      IF(N.LT.0.5D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)N
        CALL DPWRST('XXX','BUG ')
        PDF=0.0D0
        GOTO9000
      ENDIF
   12 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO OGIPDF IS ',
     1       'LESS THAN 0.5')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   48 FORMAT('      VALUE OF ARGUMENT IS: ',G15.7)
C
      IF(P.EQ.0.0D0)THEN
        PPF=0.0D0
        GOTO9000
      ELSEIF(P.EQ.1.0D0)THEN
        PPF=1.0D0
        GOTO9000
      ENDIF
C
C               *****************************************
C               **  STEP 2--                           **
C               **  COMPUTE THE PERCENT POINT FUNCTION.**
C               *****************************************
C
  300 CONTINUE
      XLOW=0.0D0
      XUP=1.0D0
      XUP2=0.5D0
      AE=1.D-7
      RE=1.D-7
      DN=N
      DP=P
      CALL DFZERO(OGIFU2,XLOW,XUP,XUP2,RE,AE,IFLAG)
C
      PPF=XLOW
C
      IF(IFLAG.EQ.2)THEN
C
C  NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
  999   FORMAT(1X)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM OGIPPF--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      PPF VALUE MAY NOT BE COMPUTED TO DESIRED ',
CCCCC1         'TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM OGIPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      PPF VALUE MAY BE NEAR A SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
  131   FORMAT('***** ERROR FROM OGIPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,141)
  141   FORMAT('***** WARNING FROM OGIPPF--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE OGIRAN(N,AN,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE OGIVE DISTRIBUTION WITH
C              SHAPE PARAMETER AN.
C
C              THE PROBABILITY DENSITY FUNCTION IS:
C
C                  f(X;N) = N*X**(N-1)*{(4*N-2)/(3*N-1) -
C                           ((2*N-2)/(3*N-1))*X**N}
C                           0 <= X <= 1, N >= 0.5
C
C              WITH N DENOTING THE SHAPE PARAMETER.
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --AN     = THE SINGLE PRECISION VALUE OF THE
C                                SHAPE PARAMETER AN.
C                                AN SHOULD BE IN THE RANGE (0,1).
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE OGIVE DISTRIBUTION
C             WITH SHAPE PARAMETER AN.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, OGIPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--KOTZ AND VAN DORP (2004), "BEYOND AN: OTHER
C                 CONTINUOUS FAMILIES OF DISTRIBUTIONS WITH BOUNDED
C                 SUPPORT AND APPLICATIONS", WORLD SCIENTFIC
C                 PUBLISHING COMPANY, CHAPTER 8.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHMOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007.10
C     ORIGINAL VERSION--OCTOBER   2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DOUBLE PRECISION DTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
    5   FORMAT('***** ERROR--THE REQUESTED NUMBER OF ',
     1         'OGIVE RANDOM NUMBERS IS NON-POSITIVE')
   47   FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
      ELSEIF(AN.LT.0.5)THEN
        WRITE(ICOUT,201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,203)AN
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
  201 FORMAT('***** ERROR--THE N SHAPE PARAMETER IS ',
     1       'LESS THAN 0.5')
  203 FORMAT('      THE VALUE OF N IS ',G15.7)
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N OGIVE DISTRIBUTION RANDOM
C     NUMBERS USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO300I=1,N
        CALL OGIPPF(DBLE(X(I)),DBLE(AN),DTEMP)
        X(I)=REAL(DTEMP)
  300 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      subroutine onestp(y,n,np,ns,nt,nl,isdeg,itdeg,ildeg,nsjump,ntjump,
     &nljump,ni,userw,rw,season,trend,work)
c
c  This routine is part of the Bill Cleveland seasonal loess
c  program.
c
      integer n,ni,np,ns,nt,nsjump,ntjump,nl,nljump,isdeg,itdeg,ildeg
      real y(n),rw(n),season(n),trend(n),work(n+2*np,5)
      logical userw
      do 23089 j = 1,ni 
      do 23091 i = 1,n
      work(i,1) = y(i)-trend(i)
23091 continue
      call ss(work(1,1),n,np,ns,isdeg,nsjump,userw,rw,work(1,2),work(1,
     &3),work(1,4),work(1,5),season)
      call fts(work(1,2),n+2*np,np,work(1,3),work(1,1))
      call ess(work(1,3),n,nl,ildeg,nljump,.false.,work(1,4),work(1,1),
     &work(1,5))
      do 23093 i = 1,n
      season(i) = work(np+i,2)-work(i,1)
23093 continue
      do 23095 i = 1,n
      work(i,1) = y(i)-season(i)
23095 continue
      call ess(work(1,1),n,nt,itdeg,ntjump,userw,rw,trend,work(1,3))
23089 continue
      return
      end
      SUBROUTINE OPTCHK(N,X,TYPSIZ,SX,FSCALE,GRADTL,ITNLIM,NDIGIT,EPSM,
     +     DLT,METHOD,IEXP,IAGFLG,IAHFLG,STEPMX,MSG,IPRTMP)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C CHECK INPUT FOR REASONABLENESS
C
C PARAMETERS
C ----------
C N            --> DIMENSION OF PROBLEM
C X(N)         --> ON ENTRY, ESTIMATE TO ROOT OF FCN
C TYPSIZ(N)   <--> TYPICAL SIZE OF EACH COMPONENT OF X
C SX(N)       <--  DIAGONAL SCALING MATRIX FOR X
C FSCALE      <--> ESTIMATE OF SCALE OF OBJECTIVE FUNCTION FCN
C GRADTL       --> TOLERANCE AT WHICH GRADIENT CONSIDERED CLOSE
C                  ENOUGH TO ZERO TO TERMINATE ALGORITHM
C ITNLIM      <--> MAXIMUM NUMBER OF ALLOWABLE ITERATIONS
C NDIGIT      <--> NUMBER OF GOOD DIGITS IN OPTIMIZATION FUNCTION FCN
C EPSM         --> MACHINE EPSILON
C DLT         <--> TRUST REGION RADIUS
C METHOD      <--> ALGORITHM INDICATOR
C IEXP        <--> EXPENSE FLAG
C IAGFLG      <--> =1 IF ANALYTIC GRADIENT SUPPLIED
C IAHFLG      <--> =1 IF ANALYTIC HESSIAN SUPPLIED
C STEPMX      <--> MAXIMUM STEP SIZE
C MSG         <--> MESSAGE AND ERROR CODE
C IPR          --> DEVICE TO WHICH TO SEND OUTPUT
C
      DIMENSION X(N),TYPSIZ(N),SX(N)
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C CHECK THAT PARAMETERS ONLY TAKE ON ACCEPTABLE VALUES.
C IF NOT, SET THEM TO DEFAULT VALUES.
      IF(METHOD.LT.1 .OR. METHOD.GT.3) METHOD=1
      IF(IAGFLG.NE.1) IAGFLG=0
      IF(IAHFLG.NE.1) IAHFLG=0
      IF(IEXP.NE.0) IEXP=1
      IF(MOD(MSG/2,2).EQ.1 .AND. IAGFLG.EQ.0) GO TO 830
      IF(MOD(MSG/4,2).EQ.1 .AND. IAHFLG.EQ.0) GO TO 835
C
C CHECK DIMENSION OF PROBLEM
C
      IF(N.LE.0) GO TO 805
      IF(N.EQ.1 .AND. MOD(MSG,2).EQ.0) GO TO 810
C
C COMPUTE SCALE MATRIX
C
      DO 10 I=1,N
        IF(TYPSIZ(I).EQ.0.) TYPSIZ(I)=1.0
        IF(TYPSIZ(I).LT.0.) TYPSIZ(I)=-TYPSIZ(I)
        SX(I)=1.0/TYPSIZ(I)
   10 CONTINUE
C
C CHECK MAXIMUM STEP SIZE
C
      IF (STEPMX .GT. 0.0) GO TO 20
      STPSIZ = 0.0
      DO 15 I = 1, N
         STPSIZ = STPSIZ + X(I)*X(I)*SX(I)*SX(I)
   15 CONTINUE
      STPSIZ = SQRT(STPSIZ)
      STEPMX = MAX(1.0E3*STPSIZ, 1.0D3)
   20 CONTINUE
C CHECK FUNCTION SCALE
      IF(FSCALE.EQ.0.) FSCALE=1.0
      IF(FSCALE.LT.0.) FSCALE=-FSCALE
C
C CHECK GRADIENT TOLERANCE
      IF(GRADTL.LT.0.) GO TO 815
C
C CHECK ITERATION LIMIT
      IF(ITNLIM.LE.0) GO TO 820
C
C CHECK NUMBER OF DIGITS OF ACCURACY IN FUNCTION FCN
      IF(NDIGIT.EQ.0) GO TO 825
      IF(NDIGIT.LT.0) NDIGIT=-LOG10(EPSM)
C
C CHECK TRUST REGION RADIUS
      IF(DLT.LE.0.) DLT=-1.0
      IF (DLT .GT. STEPMX) DLT = STEPMX
      RETURN
C
C ERROR EXITS
C
  805 WRITE(ICOUT,901) N
      CALL DPWRST('XXX','BUG ')
      MSG=-1
      GO TO 895
  810 WRITE(ICOUT,902)
      CALL DPWRST('XXX','BUG ')
      MSG=-2
      GO TO 895
  815 WRITE(ICOUT,903) GRADTL
      CALL DPWRST('XXX','BUG ')
      MSG=-3
      GO TO 895
  820 WRITE(ICOUT,904) ITNLIM
      CALL DPWRST('XXX','BUG ')
      MSG=-4
      GO TO 895
  825 WRITE(ICOUT,905) NDIGIT
      CALL DPWRST('XXX','BUG ')
      MSG=-5
      GO TO 895
  830 WRITE(ICOUT,906) MSG
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,916)IAGFLG
      CALL DPWRST('XXX','BUG ')
      MSG=-6
      GO TO 895
  835 WRITE(ICOUT,907) MSG
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,917)IAHFLG
      CALL DPWRST('XXX','BUG ')
      MSG=-7
  895 RETURN
  901 FORMAT('***** FROM OPTCHK    ILLEGAL DIMENSION, N =',I5)
  902 FORMAT(
     +'***** FROM OPTCHK    +++ WARNING +++  THIS PACKAGE IS ',
     +'INEFFICIENT FOR PROBLEMS OF SIZE N=1.')
  903 FORMAT(
     +'***** FROM OPTCHK    ILLEGAL TOLERANCE.  GRADTL = ',E20.13)
  904 FORMAT(
     +'***** FROM OPTCHK    ILLEGAL ITERATION LIMIT.  ITNLIM = ',I5)
  905 FORMAT(
     +'***** FROM OPTCHK    MINIMIZATION FUNCTION HAS NO GOOD DIGITS.'
     +,'  NDIGIT = ',I5)
  906 FORMAT(
     +'***** FROM OPTCHK    USER REQUESTS THAT ANALYTIC GRADIENT BE',
     +' ACCEPTED AS PROPERLY CODED (MSG =',I5)
  916 FORMAT(
     +'                     BUT ANALYTIC GRADIENT NOT SUPPLIED',
     +'(IAGFLG = ',I5,'.')
  907 FORMAT(
     +'***** FROM OPTCHK    USER REQUESTS THAT ANALYTIC HESSIAN BE',
     +' ACCEPTED AS PROPERLY CODED (MSG =',I5)
  917 FORMAT(
     +'                     BUT ANALYTIC HESSIAN NOT SUPPLIED',
     +'(IAHFLG = ',I5,'.')
      END
      SUBROUTINE OPTDRV(NR,N,X,TYPSIZ,FSCALE,
CDPLT SUBROUTINE OPTDRV(NR,N,X,FCN,D1FCN,D2FCN,TYPSIZ,FSCALE,
CDPLT+     METHOD,IEXP,MSG,NDIGIT,ITNLIM,IAGFLG,IAHFLG,IPR,
     +     METHOD,IEXP,MSG,NDIGIT,ITNLIM,IAGFLG,IAHFLG,IPR2,
     +     DLT,GRADTL,STEPMX,STEPTL,
     +     XPLS,FPLS,GPLS,ITRMCD,
     +     A,UDIAG,G,P,SX,WRK0,WRK1,WRK2,WRK3)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C DRIVER FOR NON-LINEAR OPTIMIZATION PROBLEM
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM
C X(N)         --> ON ENTRY: ESTIMATE TO A ROOT OF FCN
C FCN          --> NAME OF SUBROUTINE TO EVALUATE OPTIMIZATION FUNCTION
C                  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C                            FCN: R(N) --> R(1)
C D1FCN        --> (OPTIONAL) NAME OF SUBROUTINE TO EVALUATE GRADIENT
C                  OF FCN.  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C D2FCN        --> (OPTIONAL) NAME OF SUBROUTINE TO EVALUATE HESSIAN OF
C                  OF FCN.  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C TYPSIZ(N)    --> TYPICAL SIZE FOR EACH COMPONENT OF X
C FSCALE       --> ESTIMATE OF SCALE OF OBJECTIVE FUNCTION
C METHOD       --> ALGORITHM TO USE TO SOLVE MINIMIZATION PROBLEM
C                    =1 LINE SEARCH
C                    =2 DOUBLE DOGLEG
C                    =3 MORE-HEBDON
C IEXP         --> =1 IF OPTIMIZATION FUNCTION FCN IS EXPENSIVE TO
C                  EVALUATE, =0 OTHERWISE.  IF SET THEN HESSIAN WILL
C                  BE EVALUATED BY SECANT UPDATE INSTEAD OF
C                  ANALYTICALLY OR BY FINITE DIFFERENCES
C MSG         <--> ON INPUT:  (.GT.0) MESSAGE TO INHIBIT CERTAIN
C                    AUTOMATIC CHECKS
C                  ON OUTPUT: (.LT.0) ERROR CODE; =0 NO ERROR
C NDIGIT       --> NUMBER OF GOOD DIGITS IN OPTIMIZATION FUNCTION FCN
C ITNLIM       --> MAXIMUM NUMBER OF ALLOWABLE ITERATIONS
C IAGFLG       --> =1 IF ANALYTIC GRADIENT SUPPLIED
C IAHFLG       --> =1 IF ANALYTIC HESSIAN SUPPLIED
C IPR          --> DEVICE TO WHICH TO SEND OUTPUT
C DLT          --> TRUST REGION RADIUS
C GRADTL       --> TOLERANCE AT WHICH GRADIENT CONSIDERED CLOSE
C                  ENOUGH TO ZERO TO TERMINATE ALGORITHM
C STEPMX       --> MAXIMUM ALLOWABLE STEP SIZE
C STEPTL       --> RELATIVE STEP SIZE AT WHICH SUCCESSIVE ITERATES
C                  CONSIDERED CLOSE ENOUGH TO TERMINATE ALGORITHM
C XPLS(N)     <--> ON EXIT:  XPLS IS LOCAL MINIMUM
C FPLS        <--> ON EXIT:  FUNCTION VALUE AT SOLUTION, XPLS
C GPLS(N)     <--> ON EXIT:  GRADIENT AT SOLUTION XPLS
C ITRMCD      <--  TERMINATION CODE
C A(N,N)       --> WORKSPACE FOR HESSIAN (OR ESTIMATE)
C                  AND ITS CHOLESKY DECOMPOSITION
C UDIAG(N)     --> WORKSPACE [FOR DIAGONAL OF HESSIAN]
C G(N)         --> WORKSPACE (FOR GRADIENT AT CURRENT ITERATE)
C P(N)         --> WORKSPACE FOR STEP
C SX(N)        --> WORKSPACE (FOR DIAGONAL SCALING MATRIX)
C WRK0(N)      --> WORKSPACE
C WRK1(N)      --> WORKSPACE
C WRK2(N)      --> WORKSPACE
C WRK3(N)      --> WORKSPACE
C
C
C INTERNAL VARIABLES
C ------------------
C ANALTL           TOLERANCE FOR COMPARISON OF ESTIMATED AND
C                  ANALYTICAL GRADIENTS AND HESSIANS
C EPSM             MACHINE EPSILON
C F                FUNCTION VALUE: FCN(X)
C ITNCNT           CURRENT ITERATION, K
C RNF              RELATIVE NOISE IN OPTIMIZATION FUNCTION FCN.
C                       NOISE=10.**(-NDIGIT)
C
      DIMENSION X(N),XPLS(N),G(N),GPLS(N),P(N)
      DIMENSION TYPSIZ(N),SX(N)
      DIMENSION A(NR,1),UDIAG(N)
      DIMENSION WRK0(N),WRK1(N),WRK2(N),WRK3(N)
      DOUBLE PRECISION FHAT(1)
      LOGICAL MXTAKE,NOUPDT
CDPLT EXTERNAL FCN,D1FCN,D2FCN
CDPLT EXTERNAL OPTFCN
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      INCLUDE 'DPCOF2.INC'
      REAL R1MACH
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C INITIALIZATION
C --------------
      DO 10 I=1,N
        P(I)=0.
   10 CONTINUE
      ITNCNT=0
      IRETCD=-1
CCCCC EPSM=D1MACH(4)
      EPSM=R1MACH(4)
      CALL OPTCHK(N,X,TYPSIZ,SX,FSCALE,GRADTL,ITNLIM,NDIGIT,EPSM,
     +     DLT,METHOD,IEXP,IAGFLG,IAHFLG,STEPMX,MSG,IPR2)
      IF(MSG.LT.0) RETURN
      RNF=MAX(10.0D0**(-NDIGIT),EPSM)
      ANALTL=MAX(1.0D-2,SQRT(RNF))
C
      IF(MOD(MSG/8,2).EQ.1) GO TO 15
      WRITE(ICOUT,901)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,900) (TYPSIZ(I),I=1,N)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,902)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,900) (SX(I),I=1,N)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,903) FSCALE
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,904) NDIGIT
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,914) IAGFLG
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,916)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,924) IAHFLG
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,926)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,934) IEXP
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,936) 
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,944) METHOD
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,946)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,954) ITNLIM
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,964) EPSM
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,905) STEPMX
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,915) STEPTL
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,925) GRADTL
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,935) DLT
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,945) RNF
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,955) ANALTL
      CALL DPWRST('XXX','BUG ')
   15 CONTINUE
C
C EVALUATE FCN(X)
C
      CALL OPTFCN(N,X,FHAT)
      F=FHAT(1)
C
C EVALUATE ANALYTIC OR FINITE DIFFERENCE GRADIENT AND CHECK ANALYTIC
C GRADIENT, IF REQUESTED.
C
      IF (IAGFLG .EQ. 1) GO TO 20
C     IF (IAGFLG .EQ. 0)
C     THEN
CCCCC   CALL FSTOFD (1, 1, N, X, OPTFCN, F, G, SX, RNF, WRK, 1)
CCCCC   CALL FSTOFD (1, 1, N, X, F, G, SX, RNF, WRK, 1)
        CALL FSTOFD (1, 1, N, X, FHAT, G, SX, RNF, WRK1, 1)
        F=FHAT(1)
        GO TO 25
C
   20 CONTINUE
CDP20 CALL D1FCN (N, X, G)
CDPLT IF (MOD(MSG/2,2) .EQ. 1) GO TO 25
C     IF (MOD(MSG/2,2).EQ.0)
C     THEN
CDPLT   CALL GRDCHK (N, X, FCN, F, G, TYPSIZ, SX, FSCALE,
CDPLT1    RNF, ANALTL, WRK1, MSG, IPR)
CDPLT   IF (MSG .LT. 0) RETURN
   25 CONTINUE
C
      CALL OPTSTP(N,X,F,G,WRK1,ITNCNT,ICSCMX,
     +            ITRMCD,GRADTL,STEPTL,SX,FSCALE,ITNLIM,IRETCD,MXTAKE,
     +            IPR,MSG)
      IF(ITRMCD.NE.0) GO TO 700
C
      IF(IEXP.NE.1) GO TO 80
C
C IF OPTIMIZATION FUNCTION EXPENSIVE TO EVALUATE (IEXP=1), THEN
C HESSIAN WILL BE OBTAINED BY SECANT UPDATES.  GET INITIAL HESSIAN.
C
      CALL HSNINT(NR,N,A,SX,METHOD)
      GO TO 90
   80 CONTINUE
C
C EVALUATE ANALYTIC OR FINITE DIFFERENCE HESSIAN AND CHECK ANALYTIC
C HESSIAN IF REQUESTED (ONLY IF USER-SUPPLIED ANALYTIC HESSIAN
C ROUTINE D2FCN FILLS ONLY LOWER TRIANGULAR PART AND DIAGONAL OF A).
C
      IF (IAHFLG .EQ. 1) GO TO 82
C     IF (IAHFLG .EQ. 0)
C     THEN
CDPLT    IF (IAGFLG .EQ. 1) CALL FSTOFD (NR, N, N, X, D1FCN, G, A, SX,
CDPLT1      RNF, WRK1, 3)
CDPLT    IF (IAGFLG .NE. 1) CALL SNDOFD (NR, N, X, OPTFCN, F, A, SX, 
         IF (IAGFLG .NE. 1) CALL SNDOFD (NR, N, X, F, A, SX, 
     1      RNF, WRK1, WRK2)
         GO TO 88
C
C     ELSE
   82    CONTINUE
CDP82    IF (MOD(MSG/4,2).EQ.0) GO TO 85
C        IF (MOD(MSG/4, 2) .EQ. 1)
C        THEN
CDPLT       CALL D2FCN (NR, N, X, A)
CDPLT       GO TO 88
C
C        ELSE
CDP85       CALL HESCHK (NR, N, X, FCN, D1FCN, D2FCN, F, G, A, TYPSIZ,
CDPLT1         SX, RNF, ANALTL, IAGFLG, UDIAG, WRK1, WRK2, MSG, IPR)
C
C           HESCHK EVALUATES D2FCN AND CHECKS IT AGAINST THE FINITE
C           DIFFERENCE HESSIAN WHICH IT CALCULATES BY CALLING FSTOFD
C           (IF IAGFLG .EQ. 1) OR SNDOFD (OTHERWISE).
C
CDPLT       IF (MSG .LT. 0) RETURN
   88 CONTINUE
C
   90 IF(MOD(MSG/8,2).EQ.0)
     +     CALL RESULT(NR,N,X,F,G,A,P,ITNCNT,1,IPR2)
C
C
C ITERATION
C ---------
  100 ITNCNT=ITNCNT+1
C
C FIND PERTURBED LOCAL MODEL HESSIAN AND ITS LL+ DECOMPOSITION
C (SKIP THIS STEP IF LINE SEARCH OR DOGSTEP TECHNIQUES BEING USED WITH
C SECANT UPDATES.  CHOLESKY DECOMPOSITION L ALREADY OBTAINED FROM
C SECFAC.)
C
      IF(IEXP.EQ.1 .AND. METHOD.NE.3) GO TO 105
  103   CALL CHLHSN(NR,N,A,EPSM,SX,UDIAG)
  105 CONTINUE
C
C SOLVE FOR NEWTON STEP:  AP=-G
C
      DO 110 I=1,N
        WRK1(I)=-G(I)
  110 CONTINUE
      CALL LLTSLV(NR,N,A,P,WRK1)
C
C DECIDE WHETHER TO ACCEPT NEWTON STEP  XPLS=X + P
C OR TO CHOOSE XPLS BY A GLOBAL STRATEGY.
C
      IF (IAGFLG .NE. 0 .OR. METHOD .EQ. 1) GO TO 111
      DLTSAV = DLT
      IF (METHOD .EQ. 2) GO TO 111
      AMUSAV = AMU
      DLPSAV = DLTP
      PHISAV = PHI
      PHPSAV = PHIP0
  111 IF(METHOD.EQ.1)
CDPLT+     CALL LNSRCH(N,X,F,G,P,XPLS,FPLS,OPTFCN,MXTAKE,IRETCD,
     +     CALL LNSRCH(N,X,F,G,P,XPLS,FPLS,MXTAKE,IRETCD,
     +     STEPMX,STEPTL,SX,IPR2)
      IF(METHOD.EQ.2)
CDPLT+     CALL DOGDRV(NR,N,X,F,G,A,P,XPLS,FPLS,OPTFCN,SX,STEPMX,
     +     CALL DOGDRV(NR,N,X,F,G,A,P,XPLS,FPLS,SX,STEPMX,
     +     STEPTL,DLT,IRETCD,MXTAKE,WRK0,WRK1,WRK2,WRK3,IPR2)
      IF(METHOD.EQ.3)
CDPLT+     CALL HOOKDR(NR,N,X,F,G,A,UDIAG,P,XPLS,FPLS,OPTFCN,SX,STEPMX,
     +     CALL HOOKDR(NR,N,X,F,G,A,UDIAG,P,XPLS,FPLS,SX,STEPMX,
     +     STEPTL,DLT,IRETCD,MXTAKE,AMU,DLTP,PHI,PHIP0,WRK0,
     +     WRK1,WRK2,EPSM,ITNCNT,IPR2)
C
C IF COULD NOT FIND SATISFACTORY STEP AND FORWARD DIFFERENCE
C GRADIENT WAS USED, RETRY USING CENTRAL DIFFERENCE GRADIENT.
C
      IF (IRETCD .NE. 1 .OR. IAGFLG .NE. 0) GO TO 112
C     IF (IRETCD .EQ. 1 .AND. IAGFLG .EQ. 0)
C     THEN
C
C        SET IAGFLG FOR CENTRAL DIFFERENCES
C
         IAGFLG = -1
         WRITE(ICOUT,906) ITNCNT
         CALL DPWRST('XXX','BUG ')
C
CDPLT    CALL FSTOCD (N, X, OPTFCN, SX, RNF, G)
         CALL FSTOCD (N, X, SX, RNF, G)
         IF (METHOD .EQ. 1) GO TO 105
         DLT = DLTSAV
         IF (METHOD .EQ. 2) GO TO 105
         AMU = AMUSAV
         DLTP = DLPSAV
         PHI = PHISAV
         PHIP0 = PHPSAV
         GO TO 103
C     ENDIF
C
C CALCULATE STEP FOR OUTPUT
C
  112 CONTINUE
      DO 114 I = 1, N
         P(I) = XPLS(I) - X(I)
  114 CONTINUE
C
C CALCULATE GRADIENT AT XPLS
C
      IF (IAGFLG .EQ. (-1)) GO TO 116
      IF (IAGFLG .EQ. 0) GO TO 118
C
C ANALYTIC GRADIENT
CDPLT CALL D1FCN (N, XPLS, GPLS)
      GO TO 120
C
C CENTRAL DIFFERENCE GRADIENT
CD116 CALL FSTOCD (N, XPLS, OPTFCN, SX, RNF, GPLS)
  116 CALL FSTOCD (N, XPLS, SX, RNF, GPLS)
      GO TO 120
C
C FORWARD DIFFERENCE GRADIENT
CD118 CALL FSTOFD (1, 1, N, XPLS, OPTFCN, FPLS, GPLS, SX, RNF, WRK, 1)
CC118 CALL FSTOFD (1, 1, N, XPLS, FPLS, GPLS, SX, RNF, WRK, 1)
  118 CALL FSTOFD (1, 1, N, XPLS, FHAT, GPLS, SX, RNF, WRK1, 1)
      FPLS=FHAT(1)
  120 CONTINUE
C
C CHECK WHETHER STOPPING CRITERIA SATISFIED
C
      CALL OPTSTP(N,XPLS,FPLS,GPLS,X,ITNCNT,ICSCMX,
     +            ITRMCD,GRADTL,STEPTL,SX,FSCALE,ITNLIM,IRETCD,MXTAKE,
     +            IPR2,MSG)
      IF(ITRMCD.NE.0) GO TO 690
C
C EVALUATE HESSIAN AT XPLS
C
      IF(IEXP.EQ.0) GO TO 130
      IF(METHOD.EQ.3)
     +     CALL SECUNF(NR,N,X,G,A,UDIAG,XPLS,GPLS,EPSM,ITNCNT,RNF,
     +     IAGFLG,NOUPDT,WRK1,WRK2,WRK3)
      IF(METHOD.NE.3)
     +     CALL SECFAC(NR,N,X,G,A,XPLS,GPLS,EPSM,ITNCNT,RNF,IAGFLG,
     +     NOUPDT,WRK0,WRK1,WRK2,WRK3)
      GO TO 150
  130 IF(IAHFLG.EQ.1) GO TO 140
CDPLT IF(IAGFLG.EQ.1)
CDPLT+     CALL FSTOFD(NR,N,N,XPLS,D1FCN,GPLS,A,SX,RNF,WRK1,3)
      IF(IAGFLG.NE.1) 
CDPLT+     CALL SNDOFD(NR,N,XPLS,OPTFCN,FPLS,A,SX,RNF,WRK1,WRK2)
     +     CALL SNDOFD(NR,N,XPLS,FPLS,A,SX,RNF,WRK1,WRK2)
      GO TO 150
  140 CONTINUE
CD140 CALL D2FCN(NR,N,XPLS,A)
  150 CONTINUE
      IF(MOD(MSG/16,2).EQ.1)
     +     CALL RESULT(NR,N,XPLS,FPLS,GPLS,A,P,ITNCNT,1,IPR2)
C
C X <-- XPLS  AND  G <-- GPLS  AND  F <-- FPLS
C
      F=FPLS
      DO 160 I=1,N
        X(I)=XPLS(I)
        G(I)=GPLS(I)
  160 CONTINUE
      GO TO 100
C
C TERMINATION
C -----------
C RESET XPLS,FPLS,GPLS,  IF PREVIOUS ITERATE SOLUTION
C
  690 IF(ITRMCD.NE.3) GO TO 710
  700 CONTINUE
      FPLS=F
      DO 705 I=1,N
        XPLS(I)=X(I)
        GPLS(I)=G(I)
  705 CONTINUE
C
C PRINT RESULTS
C
  710 CONTINUE
      IF(MOD(MSG/8,2).EQ.0)
     +     CALL RESULT(NR,N,XPLS,FPLS,GPLS,A,P,ITNCNT,0,IPR2)
      MSG=0
CDPLT
CCCCC WRITE HESSIAN TO FILE DPST2F.DAT.  BEFORE WRITING, MAKE
CCCCC UPPER DIAGONAL OF MATRIX EQUAL TO LOWER DIAGONAL.
C
      IOUNI2=IST2NU
      DO9005I=1,N
        DO9007J=1,N
          A(J,I)=A(I,J)
 9007   CONTINUE
 9005 CONTINUE
C
      IF(N.LE.10)THEN
      WRITE(IOUNI2,9011)ITNCNT
      DO9010I=1,N
        WRITE(IOUNI2,9013)(A(I,J),J=1,N)
 9010 CONTINUE
 9011 FORMAT(1X,'HESSIAN MATRIX AT ITERATION ',I5)
 9013 FORMAT(10(1X,E15.7))
      ELSE
      WRITE(IOUNI2,9011)ITNCNT
      DO9020I=1,N
        DO9025J=1,N
          WRITE(IOUNI2,9023)A(I,J)
 9025   CONTINUE
        WRITE(IOUNI2,9027)
 9020 CONTINUE
 9023 FORMAT(1X,E15.7)
 9027 FORMAT(1X)
      ENDIF
C
      RETURN
C
  900 FORMAT('***** FROM OPTDRV       ',5(E20.13,3X))
  901 FORMAT('***** FROM OPTDRV    TYPICAL X')
  902 FORMAT('***** FROM OPTDRV    DIAGONAL SCALING MATRIX FOR X')
  903 FORMAT('***** FROM OPTDRV    TYPICAL F = ',E20.13)
  904 FORMAT('***** FROM OPTDRV    NUMBER OF GOOD DIGITS IN OPTFCN = ',
     +I5)
  914 FORMAT('                     GRADIENT FLAG  = ',I5,
     +' (=1 IF ')
  916 FORMAT('                     ANALYTIC GRADIENT SUPPLIED)')
  924 FORMAT('                     HESSIAN FLAG   = ',I5,
     +' (=1 IF ')
  926 FORMAT('                     ANALYTIC HESSIAN SUPPLIED)')
  934 FORMAT('                     EXPENSE FLAG   = ',I5,' (=1 IF ',
     +'MINIMIZATION ')
  936 FORMAT('                     FUNCTION EXPENSIVE TO EVALUATE)')
  944 FORMAT('                     METHOD TO USE  = ',I5,' (=1,2,3 ',
     +'FOR LINE SEARCH,')
  946 FORMAT('                     DOUBLE DOGLEG, MORE-HEBDON ',
     +' RESPECTIVELY)')
  954 FORMAT('                     ITERATION LIMIT = ',I5)
  964 FORMAT('                     MACHINE EPSILON = ',E20.13)
  905 FORMAT('***** FROM OPTDRV    MAXIMUM STEP SIZE    = ',E20.13)
  915 FORMAT('                     STEP TOLERANCE       = ',E20.13)
  925 FORMAT('                     GRADIENT TOLERANCE   = ',E20.13)
  935 FORMAT('                     TRUST REGION RADIUS  = ',E20.13)
  945 FORMAT('                     REL NOISE IN OPTFCN  = ',E20.13)
  955 FORMAT('                     ANAL-FD TOLERANCE    = ',E20.13)
  906 FORMAT('***** FROM OPTDRV    SHIFT FROM FORWARD TO CENTRAL ',
     +'DIFFERENCES IN ITERATION ', I5)
      END
      SUBROUTINE OPTFCN(N, X, FHAT)
C
C     PURPOSE--AUXILLARY FUNCTION FOR THE UNCMIN ROUTINES.
C              IT COMPUTES THE FUNCTION BEING OPTIMIZED
C              AT THE VALUES OF THE N PARAMETERS GIVEN IN
C              X AND RETURNS THE FUNCTION VALUE IN F.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--95/2
C     ORIGINAL VERSION--FEBRUARY  1995.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION X(*)
      DOUBLE PRECISION FHAT(*)
      DOUBLE PRECISION F
C
      CHARACTER*4 MODEL
      CHARACTER*4 IPARN
      CHARACTER*4 IPARN2
      CHARACTER*4 IANGLU
      CHARACTER*4 ITYPEH
      CHARACTER*4 IW21HO
      CHARACTER*4 IW22HO
      CHARACTER*4 IVARN
      CHARACTER*4 IVARN2
      CHARACTER*4 IBUGA3
      CHARACTER*4 IBUGCO
      CHARACTER*4 IBUGEV
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      PARAMETER (IOPTCH=1000)
      PARAMETER (IOPTC2=100)
C
      DIMENSION PARAM(IOPTC2)
      DIMENSION IPARN(IOPTC2)
      DIMENSION IPARN2(IOPTC2)
      DIMENSION IVARN(IOPTC2)
      DIMENSION IVARN2(IOPTC2)
C
      DIMENSION MODEL(IOPTCH)
      DIMENSION ITYPEH(IOPTCH)
      DIMENSION IW21HO(IOPTCH)
      DIMENSION IW22HO(IOPTCH)
      DIMENSION W2HOLD(IOPTCH)
C
      DIMENSION ILOCV(IOPTC2)
CCCCC DIMENSION ILAB(IOPTC2)
C
      COMMON /OPTCMC/ IBUGA3, ITYPEH, IW21HO, IW22HO, IPARN, IPARN2, 
     &                IVARN, IVARN2, MODEL
      COMMON /OPTCMR/ PARAM, W2HOLD,
     &                NUMCHA, NUMVAR, NWHOLD, NUMDV, ILOCV
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('AT THE BEGINNING OF OPTFCN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)NUMCHA,NUMDV,NUMVAR
   53   FORMAT('NUMCHA,NUMDV,NUMVAR = ',3I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,54)(MODEL(J),J=1,MIN(NUMCHA,25))
   54   FORMAT('MODEL(I) = ',25A4)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NUMVAR
          WRITE(ICOUT,56)I,PARAM(I),IPARN(I),IPARN2(I)
   56     FORMAT('I,PARAM(I),IPARN(I),IPARN2(I) = ',I8,G15.7,A4,A4)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
        DO59I=1,NUMDV
          WRITE(ICOUT,61)I,IVARN(I),IVARN2(I)
   61     FORMAT('I, IVARN(I),IVARN2(I) = ',I8,2X,A4,A4)
          CALL DPWRST('XXX','BUG ')
   59   CONTINUE
      ENDIF
C
C               ***************************
C               **  STEP 3--             **
C               **  INITIALIZE PARAMETERS**
C               ***************************
C
      ISTEPN='3'
      IF(IBUGA3.EQ.'ON')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO9100K=1,NUMDV
        JLOC=ILOCV(K)
        PARAM(JLOC)=REAL(X(K))
 9100 CONTINUE
C
      IPASS=2
      IBUGCO=IBUGA3
      IBUGEV=IBUGA3
      FX=0.0
      CALL COMPIM(MODEL,NUMCHA,IPASS,PARAM,IPARN,IPARN2,NUMVAR,
     1            IANGLU,ITYPEH,IW21HO,IW22HO,W2HOLD,NWHOLD,FX,
     1            IBUGCO,IBUGEV,IERROR)
      F=DBLE(FX)
      FHAT(1)=F
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,9101)FX
 9101   FORMAT('FX  = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        DO9102KK=1,NUMDV
          WRITE(ICOUT,9103)KK,REAL(X(KK))
 9103     FORMAT('I,X(I) = ',I5,1X,G15.7)
          CALL DPWRST('XXX','BUG ')
 9102   CONTINUE
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT       **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END      OF OPTFCN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9021)IERROR
 9021   FORMAT('IERROR = ',A4)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE OPTIF9(NR,N,X,TYPSIZ,FSCALE,
CCCCC SUBROUTINE OPTIF9(NR,N,X,OPTFCN,D1FCN,D2FCN,TYPSIZ,FSCALE,
     +     METHOD,IEXP,MSG,NDIGIT,ITNLIM,IAGFLG,IAHFLG,IPR,
     +     DLT,GRADTL,STEPMX,STEPTL,
     +     XPLS,FPLS,GPLS,ITRMCD,A,WRK)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C PURPOSE
C -------
C PROVIDE COMPLETE INTERFACE TO MINIMIZATION PACKAGE.
C USER HAS FULL CONTROL OVER OPTIONS.
C
C PARAMETERS
C ----------
C NR           --> ROW DIMENSION OF MATRIX
C N            --> DIMENSION OF PROBLEM
C X(N)         --> ON ENTRY: ESTIMATE TO A ROOT OF FCN
C FCN          --> NAME OF SUBROUTINE TO EVALUATE OPTIMIZATION FUNCTION
C                  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C                            FCN: R(N) --> R(1)
C D1FCN        --> (OPTIONAL) NAME OF SUBROUTINE TO EVALUATE GRADIENT
C                  OF FCN.  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C D2FCN        --> (OPTIONAL) NAME OF SUBROUTINE TO EVALUATE HESSIAN OF
C                  OF FCN.  MUST BE DECLARED EXTERNAL IN CALLING ROUTINE
C TYPSIZ(N)    --> TYPICAL SIZE FOR EACH COMPONENT OF X
C FSCALE       --> ESTIMATE OF SCALE OF OBJECTIVE FUNCTION
C METHOD       --> ALGORITHM TO USE TO SOLVE MINIMIZATION PROBLEM
C                    =1 LINE SEARCH
C                    =2 DOUBLE DOGLEG
C                    =3 MORE-HEBDON
C IEXP         --> =1 IF OPTIMIZATION FUNCTION FCN IS EXPENSIVE TO
C                  EVALUATE, =0 OTHERWISE.  IF SET THEN HESSIAN WILL
C                  BE EVALUATED BY SECANT UPDATE INSTEAD OF
C                  ANALYTICALLY OR BY FINITE DIFFERENCES
C MSG         <--> ON INPUT:  (.GT.0) MESSAGE TO INHIBIT CERTAIN
C                    AUTOMATIC CHECKS
C                  ON OUTPUT: (.LT.0) ERROR CODE; =0 NO ERROR
C NDIGIT       --> NUMBER OF GOOD DIGITS IN OPTIMIZATION FUNCTION FCN
C ITNLIM       --> MAXIMUM NUMBER OF ALLOWABLE ITERATIONS
C IAGFLG       --> =1 IF ANALYTIC GRADIENT SUPPLIED
C IAHFLG       --> =1 IF ANALYTIC HESSIAN SUPPLIED
C IPR          --> DEVICE TO WHICH TO SEND OUTPUT
C DLT          --> TRUST REGION RADIUS
C GRADTL       --> TOLERANCE AT WHICH GRADIENT CONSIDERED CLOSE
C                  ENOUGH TO ZERO TO TERMINATE ALGORITHM
C STEPMX       --> MAXIMUM ALLOWABLE STEP SIZE
C STEPTL       --> RELATIVE STEP SIZE AT WHICH SUCCESSIVE ITERATES
C                  CONSIDERED CLOSE ENOUGH TO TERMINATE ALGORITHM
C XPLS(N)     <--> ON EXIT:  XPLS IS LOCAL MINIMUM
C FPLS        <--> ON EXIT:  FUNCTION VALUE AT SOLUTION, XPLS
C GPLS(N)     <--> ON EXIT:  GRADIENT AT SOLUTION XPLS
C ITRMCD      <--  TERMINATION CODE
C A(N,N)       --> WORKSPACE FOR HESSIAN (OR ESTIMATE)
C                  AND ITS CHOLESKY DECOMPOSITION
C WRK(N,8)     --> WORKSPACE
C
CCCCC MAY 1995.  DO DUMMY DECLARATIONS WITH "*".
CCCCC DIMENSION X(N),XPLS(N),GPLS(N),TYPSIZ(N)
CCCCC DIMENSION A(NR,1),WRK(NR,1)
      DIMENSION X(*),XPLS(*),GPLS(*),TYPSIZ(*)
      DIMENSION A(NR,*),WRK(NR,*)
CDPLT EXTERNAL FCN,D1FCN,D2FCN
CDPLT EXTERNAL OPTFCN
C
C EQUIVALENCE WRK(N,1) = UDIAG(N)
C             WRK(N,2) = G(N)
C             WRK(N,3) = P(N)
C             WRK(N,4) = SX(N)
C             WRK(N,5) = WRK0(N)
C             WRK(N,6) = WRK1(N)
C             WRK(N,7) = WRK2(N)
C             WRK(N,8) = WRK3(N)
C
CDPLT CALL OPTDRV(NR,N,X,FCN,D1FCN,D2FCN,TYPSIZ,FSCALE,
      CALL OPTDRV(NR,N,X,TYPSIZ,FSCALE,
     +     METHOD,IEXP,MSG,NDIGIT,ITNLIM,IAGFLG,IAHFLG,IPR,
     +     DLT,GRADTL,STEPMX,STEPTL,
     +     XPLS,FPLS,GPLS,ITRMCD,
     +     A,WRK(1,1),WRK(1,2),WRK(1,3),WRK(1,4),WRK(1,5),
     +     WRK(1,6),WRK(1,7),WRK(1,8))
      RETURN
      END
      SUBROUTINE OPTSTP(N,XPLS,FPLS,GPLS,X,ITNCNT,ICSCMX,
     +      ITRMCD,GRADTL,STEPTL,SX,FSCALE,ITNLIM,IRETCD,MXTAKE,
     +      IPRTMP,MSG)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C UNCONSTRAINED MINIMIZATION STOPPING CRITERIA
C --------------------------------------------
C FIND WHETHER THE ALGORITHM SHOULD TERMINATE, DUE TO ANY
C OF THE FOLLOWING:
C 1) PROBLEM SOLVED WITHIN USER TOLERANCE
C 2) CONVERGENCE WITHIN USER TOLERANCE
C 3) ITERATION LIMIT REACHED
C 4) DIVERGENCE OR TOO RESTRICTIVE MAXIMUM STEP (STEPMX) SUSPECTED
C
C
C PARAMETERS
C ----------
C N            --> DIMENSION OF PROBLEM
C XPLS(N)      --> NEW ITERATE X[K]
C FPLS         --> FUNCTION VALUE AT NEW ITERATE F(XPLS)
C GPLS(N)      --> GRADIENT AT NEW ITERATE, G(XPLS), OR APPROXIMATE
C X(N)         --> OLD ITERATE X[K-1]
C ITNCNT       --> CURRENT ITERATION K
C ICSCMX      <--> NUMBER CONSECUTIVE STEPS .GE. STEPMX
C                  [RETAIN VALUE BETWEEN SUCCESSIVE CALLS]
C ITRMCD      <--  TERMINATION CODE
C GRADTL       --> TOLERANCE AT WHICH RELATIVE GRADIENT CONSIDERED CLOSE
C                  ENOUGH TO ZERO TO TERMINATE ALGORITHM
C STEPTL       --> RELATIVE STEP SIZE AT WHICH SUCCESSIVE ITERATES
C                  CONSIDERED CLOSE ENOUGH TO TERMINATE ALGORITHM
C SX(N)        --> DIAGONAL SCALING MATRIX FOR X
C FSCALE       --> ESTIMATE OF SCALE OF OBJECTIVE FUNCTION
C ITNLIM       --> MAXIMUM NUMBER OF ALLOWABLE ITERATIONS
C IRETCD       --> RETURN CODE
C MXTAKE       --> BOOLEAN FLAG INDICATING STEP OF MAXIMUM LENGTH USED
C IPR          --> DEVICE TO WHICH TO SEND OUTPUT
C MSG          --> IF MSG INCLUDES A TERM 8, SUPPRESS OUTPUT
C
C
      INTEGER N,ITNCNT,ICSCMX,ITRMCD,ITNLIM
      DIMENSION SX(N)
      DIMENSION XPLS(N),GPLS(N),X(N)
      LOGICAL MXTAKE
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
      REAL CPUMIN, CPUMAX
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
      ITRMCD=0
C
C LAST GLOBAL STEP FAILED TO LOCATE A POINT LOWER THAN X
      IF(IRETCD.NE.1) GO TO 50
C     IF(IRETCD.EQ.1)
C     THEN
        JTRMCD=3
        GO TO 600
C     ENDIF
   50 CONTINUE
C
C FIND DIRECTION IN WHICH RELATIVE GRADIENT MAXIMUM.
C CHECK WHETHER WITHIN TOLERANCE
C
      D=MAX(ABS(FPLS),FSCALE)
      RGX=0.0
      DO 100 I=1,N
        RELGRD=ABS(GPLS(I))*MAX(ABS(XPLS(I)),1./SX(I))/D
        RGX=MAX(RGX,RELGRD)
  100 CONTINUE
      JTRMCD=1
      IF(RGX.LE.GRADTL) GO TO 600
C
      IF(ITNCNT.EQ.0) RETURN
C
C FIND DIRECTION IN WHICH RELATIVE STEPSIZE MAXIMUM
C CHECK WHETHER WITHIN TOLERANCE.
C
      RSX=0.0
      DO 120 I=1,N
        RELSTP=ABS(XPLS(I)-X(I))/MAX(ABS(XPLS(I)),1./SX(I))
        RSX=MAX(RSX,RELSTP)
  120 CONTINUE
      JTRMCD=2
      IF(RSX.LE.STEPTL) GO TO 600
C
C CHECK ITERATION LIMIT
C
      JTRMCD=4
      IF(ITNCNT.GE.ITNLIM) GO TO 600
C
C CHECK NUMBER OF CONSECUTIVE STEPS \ STEPMX
C
      IF(MXTAKE) GO TO 140
C     IF(.NOT.MXTAKE)
C     THEN
        ICSCMX=0
        RETURN
C     ELSE
  140   CONTINUE
        IF (MOD(MSG/8,2) .EQ. 0) WRITE(ICOUT,900)
        ICSCMX=ICSCMX+1
        IF(ICSCMX.LT.5) RETURN
        JTRMCD=5
C     ENDIF
C
C
C PRINT TERMINATION CODE
C
CCCCC DATAPLOT WILL PRINT THE ERROR MESSAGES FROM DPOPT3.
  600 ITRMCD=JTRMCD
      IF (MOD(MSG/8,2) .EQ. 0) GO TO(601,602,603,604,605), ITRMCD
      GO TO 700
  601 CONTINUE
CCCCC WRITE(ICOUT,901)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,911)
CCCCC CALL DPWRST('XXX','BUG ')
      GO TO 700
  602 CONTINUE
CCCCC WRITE(ICOUT,902)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,912)
CCCCC CALL DPWRST('XXX','BUG ')
      GO TO 700
  603 CONTINUE
CCCCC WRITE(ICOUT,903)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,913)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,923)
CCCCC CALL DPWRST('XXX','BUG ')
      GO TO 700
  604 CONTINUE
CCCCC WRITE(ICOUT,904)
CCCCC CALL DPWRST('XXX','BUG ')
      GO TO 700
  605 CONTINUE
CCCCC WRITE(ICOUT,905)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,915)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,915)
CCCCC CALL DPWRST('XXX','BUG ')
C
  700 RETURN
C
  900 FORMAT(
     +'***** FROM OPTSTP    STEP OF MAXIMUM LENGTH (STEPMX) TAKEN')
  901 FORMAT(
     +'***** FROM OPTSTP    RELATIVE GRADIENT CLOSE TO ZERO.')
  911 FORMAT(
     +'                     CURRENT ITERATE IS PROBABLY SOLUTION.')
  902 FORMAT(
     +'***** FROM OPTSTP    SUCCESSIVE ITERATES WITHIN TOLERANCE.')
  912 FORMAT(
     +'                     CURRENT ITERATE IS PROBABLY SOLUTION.')
  903 FORMAT(
     +'***** FROM OPTSTP    LAST GLOBAL STEP FAILED TO LOCATE A ',
     +'POINT LOWER THAN X.')
  913 FORMAT(
     +'                     EITHER X IS AN APPROXIMATE LOCAL MINIMUM',
     + ' OF THE FUNCTION,')
  923 FORMAT(
     +'                     THE FUNCTION IS TOO NON-LINEAR FOR THIS ',
     +'ALGORITHM OR STEPTL IS TOO LARGE.')
  904 FORMAT(
     +'***** FROM OPTSTP    ALGORITHM FAILED BECAUSE ITERATION LIMIT',
     +'  EXCEEDED.')
  905 FORMAT(
     +'***** FROM OPTSTP    MAXIMUM STEP SIZE EXCEEDED 5 CONSECUTIVE',
     +'  TIMES.')
  915 FORMAT(
     +'                     EITHER THE FUNCTION IS UNBOUNDED BELOW, ',
     +'BECOMES ASYMPTOTIC TO A FINITE VALUE FROM ABOVE IN SOME ')
  925 FORMAT(
     +'                     DIRECTION, OR STEPMX IS TOO SMALL.')
      END
      SUBROUTINE ORTHES(NM,N,LOW,IGH,A,ORT)
C***BEGIN PROLOGUE  ORTHES
C***DATE WRITTEN   760101   (YYMMDD)
C***REVISION DATE  830518   (YYMMDD)
C***CATEGORY NO.  D4C1B2
C***KEYWORDS  EIGENVALUES,EIGENVECTORS,EISPACK
C***AUTHOR  SMITH, B. T., ET AL.
C***PURPOSE  Reduces real general matrix to upper Hessenberg form
C            orthogonal similarity transformations.
C***DESCRIPTION
C
C     This subroutine is a translation of the ALGOL procedure ORTHES,
C     NUM. MATH. 12, 349-368(1968) by Martin and Wilkinson.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 339-358(1971).
C
C     Given a REAL GENERAL matrix, this subroutine
C     reduces a submatrix situated in rows and columns
C     LOW through IGH to upper Hessenberg form by
C     orthogonal similarity transformations.
C
C     On INPUT
C
C        NM must be set to the row dimension of two-dimensional
C          array parameters as declared in the calling program
C          dimension statement.
C
C        N is the order of the matrix.
C
C        LOW and IGH are integers determined by the balancing
C          subroutine  BALANC.  If  BALANC  has not been used,
C          set LOW=1, IGH=N.
C
C        A contains the input matrix.
C
C     On OUTPUT
C
C        A contains the Hessenberg matrix.  Information about
C          the orthogonal transformations used in the reduction
C          is stored in the remaining triangle under the
C          Hessenberg matrix.
C
C        ORT contains further information about the transformations.
C          only elements LOW through IGH are used.
C
C     Questions and comments should be directed to B. S. Garbow,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C     ------------------------------------------------------------------
C***REFERENCES  B. T. SMITH, J. M. BOYLE, J. J. DONGARRA, B. S. GARBOW,
C                 Y. IKEBE, V. C. KLEMA, C. B. MOLER, *MATRIX EIGEN-
C                 SYSTEM ROUTINES - EISPACK GUIDE*, SPRINGER-VERLAG,
C                 1976.
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  ORTHES
C
      INTEGER I,J,M,N,II,JJ,LA,MP,NM,IGH,KP1,LOW
      REAL A(NM,N),ORT(IGH)
      REAL F,G,H,SCALE
C
C***FIRST EXECUTABLE STATEMENT  ORTHES
      LA = IGH - 1
      KP1 = LOW + 1
      IF (LA .LT. KP1) GO TO 200
C
      DO 180 M = KP1, LA
         H = 0.0E0
         ORT(M) = 0.0E0
         SCALE = 0.0E0
C     .......... SCALE COLUMN (ALGOL TOL THEN NOT NEEDED) ..........
         DO 90 I = M, IGH
   90    SCALE = SCALE + ABS(A(I,M-1))
C
         IF (SCALE .EQ. 0.0E0) GO TO 180
         MP = M + IGH
C     .......... FOR I=IGH STEP -1 UNTIL M DO -- ..........
         DO 100 II = M, IGH
            I = MP - II
            ORT(I) = A(I,M-1) / SCALE
            H = H + ORT(I) * ORT(I)
  100    CONTINUE
C
         G = -SIGN(SQRT(H),ORT(M))
         H = H - ORT(M) * G
         ORT(M) = ORT(M) - G
C     .......... FORM (I-(U*UT)/H) * A ..........
         DO 130 J = M, N
            F = 0.0E0
C     .......... FOR I=IGH STEP -1 UNTIL M DO -- ..........
            DO 110 II = M, IGH
               I = MP - II
               F = F + ORT(I) * A(I,J)
  110       CONTINUE
C
            F = F / H
C
            DO 120 I = M, IGH
  120       A(I,J) = A(I,J) - F * ORT(I)
C
  130    CONTINUE
C     .......... FORM (I-(U*UT)/H)*A*(I-(U*UT)/H) ..........
         DO 160 I = 1, IGH
            F = 0.0E0
C     .......... FOR J=IGH STEP -1 UNTIL M DO -- ..........
            DO 140 JJ = M, IGH
               J = MP - JJ
               F = F + ORT(J) * A(I,J)
  140       CONTINUE
C
            F = F / H
C
            DO 150 J = M, IGH
  150       A(I,J) = A(I,J) - F * ORT(J)
C
  160    CONTINUE
C
         ORT(M) = SCALE * ORT(M)
         A(M,M-1) = SCALE * G
  180 CONTINUE
C
  200 RETURN
      END
      SUBROUTINE ORTRAN(NM,N,LOW,IGH,A,ORT,Z)
C***BEGIN PROLOGUE  ORTRAN
C***DATE WRITTEN   760101   (YYMMDD)
C***REVISION DATE  830518   (YYMMDD)
C***CATEGORY NO.  D4C4
C***KEYWORDS  EIGENVALUES,EIGENVECTORS,EISPACK
C***AUTHOR  SMITH, B. T., ET AL.
C***PURPOSE  Accumulates orthogonal similarity transformations in
C            reduction of real general matrix by ORTHES.
C***DESCRIPTION
C
C     This subroutine is a translation of the ALGOL procedure ORTRANS,
C     NUM. MATH. 16, 181-204(1970) by Peters and Wilkinson.
C     HANDBOOK FOR AUTO. COMP., VOL.II-LINEAR ALGEBRA, 372-395(1971).
C
C     This subroutine accumulates the orthogonal similarity
C     transformations used in the reduction of a REAL GENERAL
C     matrix to upper Hessenberg form by  ORTHES.
C
C     On INPUT
C
C        NM must be set to the row dimension of two-dimensional
C          array parameters as declared in the calling program
C          dimension statement.
C
C        N is the order of the matrix.
C
C        LOW and IGH are integers determined by the balancing
C          subroutine  BALANC.  If  BALANC  has not been used,
C          set LOW=1, IGH=N.
C
C        A contains information about the orthogonal trans-
C          formations used in the reduction by  ORTHES
C          in its strict lower triangle.
C
C        ORT contains further information about the trans-
C          formations used in the reduction by  ORTHES.
C          only elements LOW through IGH are USED.
C
C     On OUTPUT
C
C        Z contains the transformation matrix produced in the
C          reduction by  ORTHES.
C
C        ORT has been altered.
C
C     Questions and comments should be directed to B. S. Garbow,
C     APPLIED MATHEMATICS DIVISION, ARGONNE NATIONAL LABORATORY
C     ------------------------------------------------------------------
C***REFERENCES  B. T. SMITH, J. M. BOYLE, J. J. DONGARRA, B. S. GARBOW,
C                 Y. IKEBE, V. C. KLEMA, C. B. MOLER, *MATRIX EIGEN-
C                 SYSTEM ROUTINES - EISPACK GUIDE*, SPRINGER-VERLAG,
C                 1976.
C***ROUTINES CALLED  (NONE)
C***END PROLOGUE  ORTRAN
C
      INTEGER I,J,N,KL,MM,MP,NM,IGH,LOW,MP1
      REAL A(NM,IGH),ORT(IGH),Z(NM,N)
      REAL G
C
C     .......... INITIALIZE Z TO IDENTITY MATRIX ..........
C***FIRST EXECUTABLE STATEMENT  ORTRAN
      DO 80 I = 1, N
C
         DO 60 J = 1, N
   60    Z(I,J) = 0.0E0
C
         Z(I,I) = 1.0E0
   80 CONTINUE
C
      KL = IGH - LOW - 1
      IF (KL .LT. 1) GO TO 200
C     .......... FOR MP=IGH-1 STEP -1 UNTIL LOW+1 DO -- ..........
      DO 140 MM = 1, KL
         MP = IGH - MM
         IF (A(MP,MP-1) .EQ. 0.0E0) GO TO 140
         MP1 = MP + 1
C
         DO 100 I = MP1, IGH
  100    ORT(I) = A(I,MP-1)
C
         DO 130 J = MP, IGH
            G = 0.0E0
C
            DO 110 I = MP, IGH
  110       G = G + ORT(I) * Z(I,J)
C     .......... DIVISOR BELOW IS NEGATIVE OF H FORMED IN ORTHES.
C                DOUBLE DIVISION AVOIDS POSSIBLE UNDERFLOW ..........
            G = (G / ORT(MP)) / A(MP,MP-1)
C
            DO 120 I = MP, IGH
  120       Z(I,J) = Z(I,J) + G * ORT(I)
C
  130    CONTINUE
C
  140 CONTINUE
C
  200 RETURN
      END
      SUBROUTINE PAPCDF(DX,DTHETA,DP,DCDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE DX
C              FOR THE POLYA-AEPPLI DISTRIBUTION
C              WITH DOUBLE PRECISION SHAPE PARAMETERS DTHETA AND
C              DP.  THIS DISTRIBUTION IS DEFINED FOR ALL
C              NON-NEGATIVE INTEGER X >= 0.
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              p(X;THETA,P) = EXP(-THETA)*(THETA*(1-P)/P)*P**X*
C                             CHU(X+1;2,THETA*(1-P)/P)
C                           = EXP(-THETA)*P**X*
C                             SUM[J=1 to X][(X-1  J-1)*
C                             (THETA*(1-P)/P)**J/J!
C                             X = 1, 2, ....
C
C              p(0;THETA,P) = EXP(-THETA)
C
C              CHU = THE CONFLUENT HYPERGEOMETRIC FUNTION 1F1.
C
C              JOHNSON, KOTZ, AND KEMP GIVE THE FOLLOWING
C              FORMULAS FOR X = 1, ..., 4 (ALPHA=THETA*(1-P)/P):
C
C
C              p(1;THETA,P) = EXP(-THETA)*
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(3;THETA,P) = EXP(-THETA)*ALPHA*P**3*
C                             (1+ALPHA+ALPHA**2/6)
C              p(4;THETA,P) = EXP(-THETA)*ALPHA*P**4*
C                             (1+3*ALPHA/2+ALPHA**2/2+ALPHA**3/24)
C
C              FOR THE CDF, WE USE THE FOLLOWING RECURRENCE
C              RELATION (FROM JOHNSON, KOTZ AND KEMP):
C
C              p(X+1) = (THETA*(1-P)/(X+1))*SUM[J=1 TO X]
C                       [(X+1-J)*P**(X-J)*p(X)]
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE
C                                AT WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE A NON-NEGATIVE INTEGR
C                     --DTHETA = THE DOUBLE PRECISION VALUE
C                                OF THE FIRST SHAPE PARAMETER.
C                     --DP     = THE DOUBLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DPDF   = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION FUNCTION
C             VALUE DCDF FOR THE POLYA-AEPPLI DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE A NON-NEGATIVE INTEGER
C                 --0 < P < 1,  AND THETA > 0
C     OTHER DATAPAC   SUBROUTINES NEEDED--DLNGAM, DCHU.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DCDF=0.0D0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(DP.LE.0.0D0 .OR. DP.GE.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DCDF=0.0D0
        GOTO9999
      ENDIF
C
      IF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        DCDF=0.0D0
        GOTO9999
      ENDIF
      INTX=INT(DX+0.5D0)
      IF(INTX.LT.0)THEN
        DCDF=0.0D0
        GOTO9999
      ENDIF
C
   11 FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1'PAPCDF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   12 FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1'PAPCDF IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
      DQ=1.0D0 - DP
      DALPHA=DTHETA*DQ/DP
      DX=DBLE(INTX)
C
      DPDFS2=DEXP(-DTHETA)
      IF(INTX.EQ.0)THEN
        DCDF=DPDFS2
        GOTO9999
      ENDIF
      DTERM1=-DTHETA + DLOG(DALPHA) + DLOG(DP)
      DPDFS1=DEXP(DTERM1)
      IF(INTX.EQ.1)THEN
        DCDF=DPDFS1+DPDFS2
        GOTO9999
      ENDIF
      DCDF=DPDFS1+DPDFS2
C
      DO100I=2,INTX
        IF(I.EQ.2)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 2.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + DALPHA/2.0D0)
          DPDF=DEXP(DTERM1)
        ELSEIF(I.EQ.3)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 3.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + DALPHA + DALPHA**2/6.0D0)
          DPDF=DEXP(DTERM1)
        ELSEIF(I.EQ.4)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 4.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + 1.5D0*DALPHA + 0.5D0*DALPHA**2
     1           + DALPHA**3/24.0D0)
          DPDF=DEXP(DTERM1)
        ELSE
          DTERM1=(1.0D0/DBLE(I))
          DTERM2=(DTHETA*DQ + 2.0D0*DP*DBLE(I-1))*DPDFS1
          DTERM3=DP**2*DBLE(I-2)*DPDFS2
          DPDF=DTERM1*(DTERM2 - DTERM3)
        ENDIF
        DCDF=DCDF + DPDF
        DPDFS2=DPDFS1
        DPDFS1=DPDF
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PAPFUN(N,XPAR,FVEC,IFLAG,Y,K)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE FUNCTIONS FOR THE
C              POLYA-AEPPLI MAXIMUM LIKELIHOOD EQUATIONS:
C
C                  XBAR - THETAHAT/(1-PHAT) = 0
C                  XBAR - SUM[J=1 to N][fj*(J-1)*P(J-1)/(N*P(J))} = 0
C
C              WITH THETAHAT AND PHAT DENOTING THE CURRENT ESTIMATES
C              OF THE SHAPE PARAMETERS AND WHERE P(J) = THE
C              POLYA-AEPPLI PDF USING THE ESTIMATED PARAMETERS.
C
C              CALLED BY DNSQE ROUTINE FOR SOLVING SIMULTANEOUS
C              NONLINEAR EQUATIONS.  NOTE THAT THE CALLING SEQUENCE
C              DID NOT ACCOMODATE A DATA ARRAY (AND ASSCIATED NUMBER OF
C              OBSERVATIONS), SO THESE WERE ADDED TO THE CALL LIST.
C              SINCE DNSQE ONLY PASSES ONE ARRAY, WE SPLIT INTO
C              TWO PARTS: 1 - MAXNXT/2 ARE THE FREQUENCIES WHILE
C              (MAXNXT/2 + 1) - MAXNXT ARE THE CLASS VALUES (I.E.,
C              THE X).
C
C     EXAMPLE--POLYA-AEPPLI MAXIMUM LIKELIHOOD Y
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION XPAR(*)
      DOUBLE PRECISION FVEC(*)
      REAL Y(*)
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DXM1
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION DP
      DOUBLE PRECISION DPDF1
      DOUBLE PRECISION DPDF2
      DOUBLE PRECISION DNUM
      DOUBLE PRECISION DENOM
      DOUBLE PRECISION DSUM1
C
      DOUBLE PRECISION XBAR
      COMMON/PAPCOM/MAXNXT,NTOT,XBAR
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DTHETA=XPAR(1)
      DP=XPAR(2)
      DN=DBLE(NTOT)
      FVEC(1)=XBAR - DTHETA/(1.0D0 - DP)
C
      IINDX=MAXNXT/2
      DSUM1=0.0D0
C
      DO200I=1,K
C
        DX=DBLE(Y(IINDX+I))
        DFREQ=Y(I)
C
        DXM1=DX-1.0D0
        CALL PAPPDF(DXM1,DTHETA,DP,DPDF1)
        CALL PAPPDF(DX,DTHETA,DP,DPDF2)
        DNUM=DFREQ*DXM1*DPDF1
        DENOM=DN*DPDF2
C
        IF(DENOM.NE.0.0D0)THEN
          DSUM1=DSUM1 + DNUM/DENOM
        ELSE
          DSUM1=DSUM1 + DBLE(CPUMAX)
        ENDIF
C
  200 CONTINUE
C
      FVEC(2)=XBAR - DSUM1
C
      RETURN
      END
      SUBROUTINE PAPPDF(DX,DTHETA,DP,DPDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY MASS
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE DX
C              FOR THE POLYA-AEPPLI DISTRIBUTION
C              WITH DOUBLE PRECISION SHAPE PARAMETERS DTHETA AND
C              DP.  THIS DISTRIBUTION IS DEFINED FOR ALL
C              NON-NEGATIVE INTEGER X >= 0.
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              p(X;THETA,P) = EXP(-THETA)*(THETA*(1-P)/P)*P**X*
C                             CHU(X+1;2,THETA*(1-P)/P)
C                           = EXP(-THETA)*P**X*
C                             SUM[J=1 to X][(X-1  J-1)*
C                             (THETA*(1-P)/P)**J/J!
C                             X = 1, 2, ....
C
C              p(0;THETA,P) = EXP(-THETA)
C
C              CHU = THE CONFLUENT HYPERGEOMETRIC FUNTION 1F1.
C
C              JOHNSON, KOTZ, AND KEMP GIVE THE FOLLOWING
C              FORMULAS FOR X = 1, ..., 4 (ALPHA=THETA*(1-P)/P):
C
C
C              p(1;THETA,P) = EXP(-THETA)*
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(3;THETA,P) = EXP(-THETA)*ALPHA*P**3*
C                             (1+ALPHA+ALPHA**2/6)
C              p(4;THETA,P) = EXP(-THETA)*ALPHA*P**4*
C                             (1+3*ALPHA/2+ALPHA**2/2+ALPHA**3/24)
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE
C                                AT WHICH THE PROBABILITY MASS
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE A NON-NEGATIVE INTEGR
C                     --DTHETA = THE DOUBLE PRECISION VALUE
C                                OF THE FIRST SHAPE PARAMETER.
C                     --DP     = THE DOUBLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DPDF   = THE DOUBLE PRECISION PROBABILITY
C                                MASS FUNCTION VALUE
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY MASS FUNCTION VALUE
C             DPDF FOR THE POLYA-AEPPLI DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE A NON-NEGATIVE INTEGER
C                 --0 < P < 1,  AND THETA > 0
C     OTHER DATAPAC   SUBROUTINES NEEDED--DLNGAM, DCHU.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DPDF=0.0D0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(DP.LE.0.0D0 .OR. DP.GE.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DPDF=0.0D0
        GOTO9999
      ENDIF
C
      IF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        DPDF=0.0D0
        GOTO9999
      ENDIF
      INTX=INT(DX+0.5D0)
      IF(INTX.LT.0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)INTX
        CALL DPWRST('XXX','BUG ')
        DPDF=0.0D0
        GOTO9999
      ENDIF
C
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PAPPDF ',
     1'IS NEGATIVE')
   11 FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1'PAPPDF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   12 FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1'PAPPDF IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
      DQ=1.0D0 - DP
      DALPHA=DTHETA*DQ/DP
      DX=DBLE(INTX)
C
      IF(INTX.EQ.0)THEN
        DPDF=DEXP(-DTHETA)
      ELSEIF(INTX.EQ.1)THEN
        DTERM1=-DTHETA + DLOG(DALPHA) + DLOG(DP)
        DPDF=DEXP(DTERM1)
      ELSEIF(INTX.EQ.2)THEN
        DTERM1=-DTHETA + DLOG(DALPHA) + 2.0D0*DLOG(DP) +
     1          DLOG(1.0D0 + DALPHA/2.0D0)
        DPDF=DEXP(DTERM1)
      ELSEIF(INTX.EQ.3)THEN
        DTERM1=-DTHETA + DLOG(DALPHA) + 3.0D0*DLOG(DP) +
     1          DLOG(1.0D0 + DALPHA + DALPHA**2/6.0D0)
        DPDF=DEXP(DTERM1)
      ELSEIF(INTX.EQ.4)THEN
        DTERM1=-DTHETA + DLOG(DALPHA) + 4.0D0*DLOG(DP) +
     1          DLOG(1.0D0 + 1.5D0*DALPHA + 0.5D0*DALPHA**2
     1          + DALPHA**3/24.0D0)
        DPDF=DEXP(DTERM1)
      ELSE
C
C       THE CONFLUENT HYPERGEOMETRIC FORMULATION GIVEN IN
C       JOHNSON, KOTZ, AND KEMP DOES NOT SEEM TO BE
C       WORKING FOR REASONS THAT ARE NOT CLEAR TO ME.  SO FOR
C       NOW, USE THE SUMMATION FORMULA.  THIS IS LESS
C       EFFICIENT, BUT IT SEEMS TO PROVIDE ACCURATE ANSWERS.
C
CCCCC   DTWO=2.0D0
CCCCC   DTERM1=-DTHETA + DLOG(1.0D0-DP) + DLOG(DTHETA) - DLOG(DP)
CCCCC  1       + DX*DLOG(DP)
CCCCC   CALL CHM(DTWO,-DTHETA*(1.0D0-DP)/DP,1.0D0-DX,DTERM2,IERROR)
CCCCC   DTERM2=DLOG(DTERM2)
CCCCC   DPDF=DEXP(DTERM1 + DTERM2)
CCCCC   print *,'dterm1,dterm2,dpdf=',dterm1,dterm2,dpdf
C
        DTERM1=-DTHETA + DX*DLOG(DP)
        DSUM=0.0D0
        DO100J=1,INTX
          DJ=DBLE(J)
          DTERM2=DLNGAM(DX) - DLNGAM(DJ) - DLNGAM(DX-DJ+1.0D0)
          DTERM3=DJ*DLOG(DALPHA) - DLNGAM(DJ+1.0D0)
          DSUM=DSUM + DEXP(DTERM2 + DTERM3)
  100   CONTINUE
        DTERM4=DLOG(DSUM)
        DPDF=DEXP(DTERM1 + DTERM4)
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PAPPPF(DX,DTHETA,DP,DPPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE DX
C              FOR THE POLYA-AEPPLI DISTRIBUTION
C              WITH DOUBLE PRECISION SHAPE PARAMETERS DTHETA AND
C              DP.  THIS DISTRIBUTION IS DEFINED FOR 0 <= DX < 1.
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              p(X;THETA,P) = EXP(-THETA)*(THETA*(1-P)/P)*P**X*
C                             CHU(X+1;2,THETA*(1-P)/P)
C                           = EXP(-THETA)*P**X*
C                             SUM[J=1 to X][(X-1  J-1)*
C                             (THETA*(1-P)/P)**J/J!
C                             X = 1, 2, ....
C
C              p(0;THETA,P) = EXP(-THETA)
C
C              CHU = THE CONFLUENT HYPERGEOMETRIC FUNTION 1F1.
C
C              JOHNSON, KOTZ, AND KEMP GIVE THE FOLLOWING
C              FORMULAS FOR X = 1, ..., 4 (ALPHA=THETA*(1-P)/P):
C
C
C              p(1;THETA,P) = EXP(-THETA)*
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(3;THETA,P) = EXP(-THETA)*ALPHA*P**3*
C                             (1+ALPHA+ALPHA**2/6)
C              p(4;THETA,P) = EXP(-THETA)*ALPHA*P**4*
C                             (1+3*ALPHA/2+ALPHA**2/2+ALPHA**3/24)
C
C              FOR THE CDF, WE USE THE FOLLOWING RECURRENCE
C              RELATION (FROM JOHNSON, KOTZ AND KEMP):
C
C              p(X+1) = (THETA*(1-P)/(X+1))*SUM[J=1 TO X]
C                       [(X+1-J)*P**(X-J)*p(X)]
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE A NON-NEGATIVE INTEGR
C                     --DTHETA = THE DOUBLE PRECISION VALUE
C                                OF THE FIRST SHAPE PARAMETER.
C                     --DP     = THE DOUBLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DPPF   = THE DOUBLE PRECISION PERCENT POINT
C                                FUNCTION VALUE
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION
C             VALUE DPPF FOR THE POLYA-AEPPLI DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--0 <= X < P.
C                 --0 < P < 1,  AND THETA > 0
C     OTHER DATAPAC   SUBROUTINES NEEDED--DLNGAM, DCHU.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      REAL R1MACH
      INCLUDE 'DPCOMC.INC'
C
      REAL CPUMIN
      REAL CPUMAX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      DPPF=0.0D0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(DP.LE.0.0D0 .OR. DP.GE.1.0D0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
      ENDIF
C
      IF(DTHETA.LE.0.0D0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DTHETA
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
      ENDIF
C
      IF(DX.LT.0.0D0 .OR. DX.GE.1.0D0)THEN
        WRITE(ICOUT,13)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
      ENDIF
C
   11 FORMAT('***** ERROR--THE THIRD ARGUMENT TO ',
     1'PAPPPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   12 FORMAT('***** ERROR--THE SECOND ARGUMENT TO ',
     1'PAPPPF IS NON-POSITIVE')
   13 FORMAT('***** ERROR--THE FIRST ARGUMENT TO ',
     1'PAPPPF IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
      IF(DX.LE.0.0D0)THEN
        DPPF=0.0D0
        GOTO9999
      ENDIF
C
      DQ=1.0D0 - DP
      DALPHA=DTHETA*DQ/DP
      DEPS=1.0D-7
C
      DPDFS2=DEXP(-DTHETA)
      IF(DPDFS2.GE.DX-DEPS)THEN
        DPPF=0.0D0
        GOTO9999
      ENDIF
      DTERM1=-DTHETA + DLOG(DALPHA) + DLOG(DP)
      DPDFS1=DEXP(DTERM1)
      DCDF=DPDFS1+DPDFS2
      IF(DCDF.GE.DX-DEPS)THEN
        DPPF=1.0D0
        GOTO9999
      ENDIF
      I=1
C
  100 CONTINUE
C
        I=I+1
        IF(DBLE(I).GE.DBLE(I1MACH(9)))THEN
          WRITE(ICOUT,55)
   55     FORMAT('***** ERROR--THE COMPUTED PERCENT POINT VALUE ',
     1           'EXCEEDS THE LARGEST MACHINE INTEGER.')
          CALL DPWRST('XXX','BUG ')
          DPPF=0.0
          GOTO9999
        ENDIF
C
        IF(I.EQ.2)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 2.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + DALPHA/2.0D0)
          DPDF=DEXP(DTERM1)
        ELSEIF(I.EQ.3)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 3.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + DALPHA + DALPHA**2/6.0D0)
          DPDF=DEXP(DTERM1)
        ELSEIF(I.EQ.4)THEN
          DTERM1=-DTHETA + DLOG(DALPHA) + 4.0D0*DLOG(DP) +
     1           DLOG(1.0D0 + 1.5D0*DALPHA + 0.5D0*DALPHA**2
     1           + DALPHA**3/24.0D0)
          DPDF=DEXP(DTERM1)
        ELSE
          DTERM1=(1.0D0/DBLE(I))
          DTERM2=(DTHETA*DQ + 2.0D0*DP*DBLE(I-1))*DPDFS1
          DTERM3=DP**2*DBLE(I-2)*DPDFS2
          DPDF=DTERM1*(DTERM2 - DTERM3)
        ENDIF
        DCDF=DCDF + DPDF
        DPDFS2=DPDFS1
        DPDFS1=DPDF
        IF(DCDF.GE.DX-DEPS)THEN
          DPPF=DBLE(I)
          GOTO9999
        ENDIF
      GOTO100
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PAPRAN(N,THETA,P,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE POLYA-AEPPLI DISTRIBUTION
C              WITH SHAPE PARAMETERS THETA AND P.
C              THIS DISTRIBUTION IS DEFINED FOR ALL
C              NON-NEGATIVE INTEGER X >= 0.
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              p(X;THETA,P) = EXP(-THETA)*(THETA*(1-P)/P)*P**X*
C                             CHU(X+1;2,THETA*(1-P)/P)
C                           = EXP(-THETA)*P**X*
C                             SUM[J=1 to X][(X-1  J-1)*
C                             (THETA*(1-P)/P)**J/J!
C                             X = 1, 2, ....
C
C              p(0;THETA,P) = EXP(-THETA)
C
C              CHU = THE CONFLUENT HYPERGEOMETRIC FUNTION 1F1.
C
C              JOHNSON, KOTZ, AND KEMP GIVE THE FOLLOWING
C              FORMULAS FOR X = 1, ..., 4 (ALPHA=THETA*(1-P)/P):
C
C
C              p(1;THETA,P) = EXP(-THETA)*
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(2;THETA,P) = EXP(-THETA)*ALPHA*P**2*(1+ALPHA/2)
C              p(3;THETA,P) = EXP(-THETA)*ALPHA*P**3*
C                             (1+ALPHA+ALPHA**2/6)
C              p(4;THETA,P) = EXP(-THETA)*ALPHA*P**4*
C                             (1+3*ALPHA/2+ALPHA**2/2+ALPHA**3/24)
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --THETA = THE SINGLE PRECISION VALUE
C                                OF THE FIRST SHAPE PARAMETER.
C                     --P      = THE SINGLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE POLYA-AEPPLI DISTRIBUTION
C             WITH SHAPE PARAMETERS THETA AND P.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --0 < P < 1, THETA > 0
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 378-382.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/6
C     ORIGINAL VERSION--JUNE      2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-----------------
C
C-------------------------------------------------------------------
C
      REAL THETA
      REAL P
      DIMENSION X(*)
C
      DOUBLE PRECISION DTHETA
      DOUBLE PRECISION DP
      DOUBLE PRECISION DTEMP
      DOUBLE PRECISION DPPF
C
C-------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-----------------------------------------------
C
C-----START POINT---------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF ',
     1'POLYA-AEPPLI RANDOM NUMBERS IS NON-POSITIVE')
C
      IF(P.LE.0.0 .OR. P.GE.1.0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   11 FORMAT('***** ERROR--THE P SHAPE PARAMETER FOR POLYA-AEPPLI ')
   12 FORMAT('      RANDOM NUMBERS IS OUTSIDE THE ALLOWABLE (0,1) ',
     1       'INTERVAL')
C
      IF(THETA.LE.0.0)THEN
        WRITE(ICOUT,21)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,22)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   21 FORMAT('***** ERROR--THE THETA SHAPE PARAMETER FOR ',
     1       'POLYA-AEPPLI')
   22 FORMAT('      RANDOM NUMBERS IS NON-POSITIVE.')
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C 100 CONTINUE
C
      CALL UNIRAN(N,ISEED,X)
      DTHETA=DBLE(THETA)
      DP=DBLE(P)
C
      DO100I=1,N
        DTEMP=DBLE(X(I))
        CALL PAPPPF(DTEMP,DTHETA,DP,DPPF)
        X(I)=REAL(DPPF)
  100 CONTINUE
C
 9999 CONTINUE
C
      RETURN
      END
      SUBROUTINE PARALI (X1,Y1,X2,Y2,X3,Y3,
     1                   X4,Y4,
     1                   IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--GIVEN A LINE DEFINED BY THE TWO POINTS (X1,Y1) AND
C              (X2,Y2) AND THE POINT (X3,Y3), FIND THE LINE
C              PARALLEL TO THE FIRST LINE AND CONTAINING (X3,Y3).
C              THAT IS, FIND THE COORDINATES FOR A SECOND POINT
C              ON THIS PARALLEL LINE.  THIS IS BASICALLY A
C              UTILITY ROUTINE SINCE THE SECOND LINE NEEDS TO
C              CALL ROUTINES BASED ON THE LINE AS DEFINED BY
C              TWO POINTS (RATHER THAN ONE POINT AND THE SLOPE).
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012.10
C     ORIGINAL VERSION--OCTOBER   2012.
C
C-----NON-COMMON VARIABLES (GRAPHICS)-------------------------------------
C
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      REAL X1
      REAL Y1
      REAL X2
      REAL Y2
      REAL X3
      REAL Y3
      REAL X4
      REAL Y4
      REAL S
      REAL YINT
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RALI')THEN
        WRITE(ICOUT,51)
   51   FORMAT('AT THE BEGININNING OF PARALI')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)X1,Y1,X2,Y2,X3,Y3
   53   FORMAT('X1,Y1,X2,Y2,X3,Y3 = ',6G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      XADD=(X1+X2)/2.0
      IF(ABS(XADD).LT.1.0)XADD=1.0
      YADD=(Y1+Y2)/2.0
      IF(ABS(YADD).LT.1.0)YADD=1.0
C
      IF(Y1.EQ.Y2)THEN
        X4=X3+XADD
        Y4=Y3
      ELSEIF(X1.EQ.X2)THEN
        X4=X3
        Y4=Y3+YADD
      ELSE
        S=(Y2-Y1)/(X2-X1)
        YINT=Y3 - S*X3
        X4=X3+XADD
        Y4=S*X4 + YINT
      ENDIF
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'TLIN')THEN
        WRITE(ICOUT,9051)
 9051   FORMAT('AT THE END OF INTLIN')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9053)XOUT,YOUT
 9053   FORMAT('X3(I),Y3(I) = ',2G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PARCHI(IHP,IHP2,IDIST,
     1IPAR,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1ISUBN1,ISUBN2,IERROR)
C
C     PURPOSE--CHECK TO SEE IF A (INTEGER) PARAMETER IS IN 
C              A SPECIFIED RANGE.  UTILITY ROUTINE FOR
C              PROBABILITY PLOT, LAHEY COMPILER HAD TROUBLE
C              COMPILING DPPP.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/8
C     ORIGINAL VERSION--AUGUST    1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*30 IDIST
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C               ************************************
C               **  STEP 1--                      **
C               **  CHECK FOR GAMMA DISTRIBUTION  **
C               **  PARAMETER GAMMA               **
C               ************************************
C
      IHWUSE='P'
      MESSAG='YES'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      IPAR=VALUE(ILOCP)+0.5
C
      IF(LOWLTY.EQ.'>   ')THEN
        IF(IPAR.GT.ILOWLM)GOTO1590
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        IF(IPAR.GE.ILOWLM)GOTO1590
      ENDIF
      WRITE(ICOUT,999)
  999 FORMAT(' ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1511)ISUBN1,ISUBN2
 1511 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1512)IHP,IHP2
 1512 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1513)IDIST
 1513 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(LOWLTY.EQ.'>   ')THEN
        WRITE(ICOUT,1514)ILOWLM
 1514   FORMAT('      MUST BE STRICTLY LARGER THAN ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        WRITE(ICOUT,1524)ILOWLM
 1524   FORMAT('      MUST BE LARGER THAN OR EQUAL TO ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1515)
 1515 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1516)IHP,IHP2,IPAR
 1516 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',I10)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1590 CONTINUE
C
      IF(UPPLTY.EQ.'<   ')THEN
        IF(IPAR.LT.IUPPLM)GOTO1690
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        IF(IPAR.LE.IUPPLM)GOTO1690
      ENDIF
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1611)ISUBN1,ISUBN2
 1611 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1612)IHP,IHP2
 1612 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1613)IDIST
 1613 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(UPPLTY.EQ.'<   ')THEN
        WRITE(ICOUT,1614)IUPPLM
 1614   FORMAT('      MUST BE STRICTLY LESS THAN ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        WRITE(ICOUT,1624)IUPPLM
 1624   FORMAT('      MUST BE LESS THAN OR EQUAL TO',I10,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1615)
 1615 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1616)IHP,IHP2,IPAR
 1616 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',I10)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1690 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PARCHR(IHP,IHP2,IDIST,
     1APAR,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1ISUBN1,ISUBN2,IERROR)
C
C     PURPOSE--CHECK TO SEE IF A (REAL) PARAMETER IS IN 
C              A SPECIFIED RANGE.  UTILITY ROUTINE FOR
C              PROBABILITY PLOT, LAHEY COMPILER HAD TROUBLE
C              COMPILING DPPP.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--98/8
C     ORIGINAL VERSION--AUGUST    1998.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*30 IDIST
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C               ************************************
C               **  STEP 1--                      **
C               **  CHECK FOR GAMMA DISTRIBUTION  **
C               **  PARAMETER GAMMA               **
C               ************************************
C
      IHWUSE='P'
      MESSAG='YES'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
      APAR=VALUE(ILOCP)
C
      IF(LOWLTY.EQ.'>   ')THEN
        IF(APAR.GT.ALOWLM)GOTO1590
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        IF(APAR.GE.ALOWLM)GOTO1590
      ENDIF
      WRITE(ICOUT,999)
  999 FORMAT(' ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1511)ISUBN1,ISUBN2
 1511 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1512)IHP,IHP2
 1512 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1513)IDIST
 1513 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(LOWLTY.EQ.'>   ')THEN
        WRITE(ICOUT,1514)ALOWLM
 1514   FORMAT('      MUST BE STRICTLY LARGER THAN ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        WRITE(ICOUT,1524)ALOWLM
 1524   FORMAT('      MUST BE LARGER THAN OR EQUAL TO ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1515)
 1515 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1516)IHP,IHP2,APAR
 1516 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1590 CONTINUE
C
      IF(UPPLTY.EQ.'<   ')THEN
        IF(APAR.LT.AUPPLM)GOTO1690
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        IF(APAR.LE.AUPPLM)GOTO1690
      ENDIF
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1611)ISUBN1,ISUBN2
 1611 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1612)IHP,IHP2
 1612 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1613)IDIST
 1613 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(UPPLTY.EQ.'<   ')THEN
        WRITE(ICOUT,1614)AUPPLM
 1614   FORMAT('      MUST BE STRICTLY LESS THAN ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        WRITE(ICOUT,1624)AUPPLM
 1624   FORMAT('      MUST BE LESS THAN OR EQUAL TO',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1615)
 1615 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1616)IHP,IHP2,APAR
 1616 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1690 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PARCH2(IHP,IHP2,IDIST,
     1APAR,APARDF,ALOWLM,AUPPLM,LOWLTY,UPPLTY,
     1ISUBN1,ISUBN2,IERROR)
C
C     PURPOSE--CHECK TO SEE IF A (REAL) PARAMETER IS IN 
C              A SPECIFIED RANGE.  UTILITY ROUTINE FOR
C              PPCC PLOT, KOLMOGOROV-SMIRNOV PLOT.
C              THIS IS SLIGHTLY MODIFIED VERSION OF PARCHR
C              (USED BY PROB PLOT, K-S AND CHI-SQUARE GOODNESS
C              OF FIT TESTS).  DISTINCTION IS THAT PARAMETER
C              IS OPTIONAL AND A SUITABLE DEFAULT VALUE IS
C              PROVIDED.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*30 IDIST
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C               ************************************
C               **  STEP 1--                      **
C               **  CHECK FOR PARAMETER           **
C               ************************************
C
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')THEN
        APAR=APARDF
      ELSE
        APAR=VALUE(ILOCP)
      ENDIF
C
      IERROR='NO'
      IF(LOWLTY.EQ.'>   ')THEN
        IF(APAR.GT.ALOWLM)GOTO1590
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        IF(APAR.GE.ALOWLM)GOTO1590
      ENDIF
      WRITE(ICOUT,999)
  999 FORMAT(' ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1511)ISUBN1,ISUBN2
 1511 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1512)IHP,IHP2
 1512 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1513)IDIST
 1513 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(LOWLTY.EQ.'>   ')THEN
        WRITE(ICOUT,1514)ALOWLM
 1514   FORMAT('      MUST BE STRICTLY LARGER THAN ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        WRITE(ICOUT,1524)ALOWLM
 1524   FORMAT('      MUST BE LARGER THAN OR EQUAL TO ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1515)
 1515 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1516)IHP,IHP2,APAR
 1516 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1590 CONTINUE
C
      IF(UPPLTY.EQ.'<   ')THEN
        IF(APAR.LT.AUPPLM)GOTO1690
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        IF(APAR.LE.AUPPLM)GOTO1690
      ENDIF
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1611)ISUBN1,ISUBN2
 1611 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1612)IHP,IHP2
 1612 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1613)IDIST
 1613 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(UPPLTY.EQ.'<   ')THEN
        WRITE(ICOUT,1614)AUPPLM
 1614   FORMAT('      MUST BE STRICTLY LESS THAN ',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        WRITE(ICOUT,1624)AUPPLM
 1624   FORMAT('      MUST BE LESS THAN OR EQUAL TO',F10.5,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1615)
 1615 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1616)IHP,IHP2,APAR
 1616 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1690 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PARCI2(IHP,IHP2,IDIST,
     1IPAR,IPARDF,ILOWLM,IUPPLM,LOWLTY,UPPLTY,
     1ISUBN1,ISUBN2,IERROR)
C
C     PURPOSE--CHECK TO SEE IF A (INTEGER) PARAMETER IS IN 
C              A SPECIFIED RANGE.  UTILITY ROUTINE FOR
C              PPCC PLOT AND KOLMOGOROV-SMIRNOV PLOT.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2004/3
C     ORIGINAL VERSION--MARCH     2004.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      INCLUDE 'DPCOPA.INC'
      INCLUDE 'DPCOHK.INC'
C
      CHARACTER*4 IHP
      CHARACTER*4 IHP2
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 LOWLTY
      CHARACTER*4 UPPLTY
      CHARACTER*30 IDIST
      CHARACTER*4 IERROR
C
      CHARACTER*4 IHWUSE
      CHARACTER*4 MESSAG
C
C-----COMMON VARIABLES (GENERAL)--------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C
C               ************************************
C               **  STEP 1--                      **
C               **  CHECK FOR GAMMA DISTRIBUTION  **
C               **  PARAMETER GAMMA               **
C               ************************************
C
      IHWUSE='P'
      MESSAG='NO'
      CALL CHECKN(IHP,IHP2,IHWUSE,
     1IHNAME,IHNAM2,IUSE,IN,IVALUE,VALUE,NUMNAM,MAXNAM,
     1ISUBN1,ISUBN2,MESSAG,IANS,IWIDTH,ILOCP,IERROR)
      IF(IERROR.EQ.'YES')THEN
        IPAR=IPARDF
      ELSE
        IPAR=VALUE(ILOCP)+0.5
      ENDIF
      IERROR='NO'
C
      IF(LOWLTY.EQ.'>   ')THEN
        IF(IPAR.GT.ILOWLM)GOTO1590
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        IF(IPAR.GE.ILOWLM)GOTO1590
      ENDIF
      WRITE(ICOUT,999)
  999 FORMAT(' ')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1511)ISUBN1,ISUBN2
 1511 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1512)IHP,IHP2
 1512 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1513)IDIST
 1513 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(LOWLTY.EQ.'>   ')THEN
        WRITE(ICOUT,1514)ILOWLM
 1514   FORMAT('      MUST BE STRICTLY LARGER THAN ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(LOWLTY.EQ.'>=  ')THEN
        WRITE(ICOUT,1524)ILOWLM
 1524   FORMAT('      MUST BE LARGER THAN OR EQUAL TO ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1515)
 1515 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1516)IHP,IHP2,IPAR
 1516 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',I10)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1590 CONTINUE
C
      IF(UPPLTY.EQ.'<   ')THEN
        IF(IPAR.LT.IUPPLM)GOTO1690
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        IF(IPAR.LE.IUPPLM)GOTO1690
      ENDIF
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1611)ISUBN1,ISUBN2
 1611 FORMAT('***** ERROR IN ',A4,A4,'--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1612)IHP,IHP2
 1612 FORMAT('      THE SPECIFIED SHAPE PARAMETER ',A4,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1613)IDIST
 1613 FORMAT('      FOR THE ',A30,' DISTRIBUTION')
      CALL DPWRST('XXX','BUG ')
      IF(UPPLTY.EQ.'<   ')THEN
        WRITE(ICOUT,1614)IUPPLM
 1614   FORMAT('      MUST BE STRICTLY LESS THAN ',I10,';')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(UPPLTY.EQ.'<=  ')THEN
        WRITE(ICOUT,1624)IUPPLM
 1624   FORMAT('      MUST BE LESS THAN OR EQUAL TO',I10,';')
        CALL DPWRST('XXX','BUG ')
      ENDIF
      WRITE(ICOUT,1615)
 1615 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,1616)IHP,IHP2,IPAR
 1616 FORMAT('      THE SPECIFIED VALUE OF ',A4,A4,' = ',I10)
      CALL DPWRST('XXX','BUG ')
      IERROR='YES'
      GOTO9000
 1690 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PARCDF(X,GAMMA,A,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE PARETO
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA
C              AND LOCATION PARAMETER ALOC.
C              THE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO A, 
C              AND HAS THE CUMULATIVE DISTRIBUTION FUNCTION
C              F(X) = 1 - (A/X)**GAMMA
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO ALOC.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                ALOC SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN
C                   OR EQUAL TO A.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 233-249.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 102.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2899
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.A)THEN
        WRITE(ICOUT,4)A
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PARCDF IS LESS THAN ',
     1       'THE LOCATION PARAMETER ',G15.7)
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PARCDF (THE SHAPE ',
     1       'PARAMETER) IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PARCDF (THE ',
     1       'LOCATION PARAMETER) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      CDF=1.0-(A/X)**GAMMA
C
 9999 CONTINUE
      RETURN
      END 
      DOUBLE PRECISION FUNCTION PARFUN(AHAT,X)
C
C     PURPOSE--THIS ROUTINE IS USED IN FINDING THE MODIFIED
C              MAXIMUM LIKELIHOOD ESTIMATE OF THE THRESHOLD PARAMETER
C              OF THE PARETO DISTRIBUTION.  THIS FUNCTION FINDS THE ROOT
C              OF THE EQUATION:
C
C              N*(XMIN - AHAT)/XMIN -
C              (1/N)*SUM[i=1 to N][LOG(X(i)/AHAT) = 0
C
C              CALLED BY DFZER2 ROUTINE FOR FINDING THE ROOT OF A
C              FUNCTION.
C     EXAMPLE--PARETO MAXIMUM LIKELIHOOD Y
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 11.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBUG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY       2010.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION AHAT
      DOUBLE PRECISION X(*)
C
      INTEGER N 
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DXMIN
      COMMON/PARCOM/DXBAR,DXMIN,N
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
C
C-----START POINT-----------------------------------------------------
C
      DN=DBLE(N)
      DTERM1=DN*(DXMIN - AHAT)/DXMIN
      DSUM1=0.0D0
      DO100I=1,N
        DX=X(I)/AHAT
        DSUM1=DSUM1 + DLOG(DX)
  100 CONTINUE
C
      PARFUN=DTERM1 - DSUM1/DN
C
      RETURN
      END
      SUBROUTINE PARCHA(X,GAMMA,A,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE PARETO
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA
C              AND LOCATION PARAMETER = A.
C              THE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO A, 
C              AND HAS THE CUMULATIVE HAZARD FUNCTION
C              H(X) = GAMMA*LOG(X/A)
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO ALOC.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                ALOC SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION
C                                CUMULATIVE HAZARD FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN
C                   OR EQUAL TO A.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, CHAPTER 20
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 102.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      HAZ=0.0
      IF(X.LT.A)THEN
        WRITE(ICOUT,4)A
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PARCHAZ IS LESS THAN ',
     1       'THE LOCATION PARAMETER ',G15.7)
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PARCHAZ (THE SHAPE ',
     1       'PARAMETER) IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PARCHAZ (THE ',
     1       'LOCATION PARAMETER) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      HAZ=GAMMA*LOG(X/A)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PARHAZ(X,GAMMA,A,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE PARETO
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA
C              AND LOCATION PARAMETER = A.
C              THE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO A, AND HAS THE HAZARD FUNCTION
C              H(X) = GAMMA / X
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO ALOC.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                ALOC SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--HAZ    = THE SINGLE PRECISION
C                                HAZARD FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION HAZARD
C             FUNCTION VALUE PDF FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN OR EQUAL TO A.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, CHAPTER 20
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 102.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      HAZ=0.0
      IF(X.LT.A)THEN
        WRITE(ICOUT,4)A
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PARHAZ IS LESS THAN ',
     1       'THE LOCATION PARAMETER ',G15.7)
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PARHAZ (THE SHAPE ',
     1       'PARAMETER) IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PARHAZ (THE ',
     1       'LOCATION PARAMETER) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      HAZ=GAMMA/X
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PARLI1(Y,N,
     1                  THRESH,SHAPE,
     1                  ALIK,AIC,AICC,BIC,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE LIKELIHOOD FUNCTION FOR
C              THE PARETO DISTRIBUTION.  THIS IS FOR THE RAW DATA
C              CASE (I.E., NO GROUPING AND NO CENSORING).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 10.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY      2010.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DA
      DOUBLE PRECISION DN
      DOUBLE PRECISION DNP
      DOUBLE PRECISION DLIK
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM3
C
C---------------------------------------------------------------------
C
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PARL'
      ISUBN2='I1  '
C
      IERROR='NO'
C
      ALIK=-99.0
      AIC=-99.0
      AICC=-99.0
      BIC=-99.0
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RLI1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF PARLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO
   52   FORMAT('IBUGA3,ISUBRO = ',A4,2X,A4)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,55)N,ALOC,SHAPE
   55   FORMAT('N,ALOC,SHAPE = ',I8,2G15.7)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ******************************************
C               **  STEP 1--                            **
C               **  COMPUTE LIKELIHOOD FUNCTION         **
C               ******************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RLI1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IERFLG=0
      IERROR='NO'
      IWRITE='OFF'
C
C     THE LOG-LIKELIHOOD FUNCTION IS (G IS THE SHAPE
C     PARAMETER AND A IS THE LOCATION PARAMETER, THE
C     PARETO TYPICALLY NOT USED WITH A SCALE PARAMETER).
C
C     N*LOG(G) + N*G*LOG(A) -
C     SUM[i=1 to N][(G+1)*LOG(X(i))]
C
      DN=DBLE(N)
      DG=DBLE(SHAPE)
      DA=DBLE(THRESH)
      DTERM1=DN*DLOG(DG) + DN*DG*DLOG(DA)
      DSUM1=0.0D0
      DO1000I=1,N
        DX=DBLE(Y(I))
        DSUM1=DSUM1 + (DG+1.0D0)*DLOG(DX)
 1000 CONTINUE
      DLIK=DTERM1 - DSUM1
C
      ALIK=REAL(DLIK)
      DNP=2.0D0
      AIC=REAL(-2.0D0*DLIK + 2.0D0*DNP)
      DTERM3=(2.0D0*DNP*(DNP+1.0D0))/(DN-DNP-1.0D0)
      AICC=REAL(-2.0D0*DLIK + 2.0D0*DNP + DTERM3)
      BIC=REAL(-2.0D0*DLIK + DNP*LOG(DN))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RLI1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF PARLI1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)DSUM1,DTERM1,DTERM3
 9013   FORMAT('DSUM1,DTERM1,DTERM3 = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9014)ALIK,AIC,AICC,BIC
 9014   FORMAT('ALIK,AIC,AICC,BIC = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PARML1(Y,N,
     1                  DTEMP1,
     1                  XMEAN,XSD,XMIN,XMAX,
     1                  AMOM,SHAPMO,
     1                  AMM,SHAPMM,
     1                  AML,SHAPML,AMLSE,SHAPSE,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE PARETO DISTRIBUTION FOR THE RAW DATA CASE (I.E.,
C              NO CENSORING AND NO GROUPING).
C
C              THIS WILL RETURN MOMENT, MODIFIED MOMENT, AND MODIFIED
C              MAXIMUM LIKELIHOOD ESTIMATES.  THE MODIFIED MAXIMUM
C              LIKLIHOOD ESTIMATES USE THE MODIFIED MOMENT ESTIMATE
C              FOR THE THRESHOLD AND THEN THE STANDARD MAXIMUM LIKELIHOOD
C              ESTIMATE FOR THE SHAPE PARAMETER (THE STANDARD ML
C              ESTIMATES HAVE REGULARITY PROBLEMS WHEN THE THRESHOLD
C              PARAMETER IS UNKNOWN).
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLPA WILL GENERATE THE OUTPUT
C              FOR THE PARETO MLE COMMAND).
C
C     REFERENCE--COHEN AND WHITTEN (1988), "PARAMETER ESTIMATION IN
C                RELIABILITY AND LIFE SPAN MODELS", MARCEL DEKKER, INC.,
C                CHAPTER 11.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/07
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLPA)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 ICASPL
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
C
      DOUBLE PRECISION DP
      DOUBLE PRECISION DX
      DOUBLE PRECISION DN
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DVAR
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
      DOUBLE PRECISION DEPS
C
      DOUBLE PRECISION DAE
      DOUBLE PRECISION DRE
      DOUBLE PRECISION DXSTRT
      DOUBLE PRECISION DXLOW
      DOUBLE PRECISION DXUP
      DOUBLE PRECISION XLOWSV
      DOUBLE PRECISION XUPSV
C
      DOUBLE PRECISION PARFUN
      EXTERNAL PARFUN
C
      INTEGER IN
      DOUBLE PRECISION DXBAR
      DOUBLE PRECISION DXMIN
      COMMON/PARCOM/DXBAR,DXMIN,IN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PARM'
      ISUBN2='L1  '
C
      IWRITE='OFF'
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF PARML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N,MAXNXT
   52   FORMAT('IBUGA3,ISUBRO,N,MAXNXT = ',2(A4,2X),2I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CARRY OUT CALCULATIONS                **
C               **  FOR PARETO MLE ESTIMATE               **
C               ********************************************
C
      ISTEPN='1'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='PARETO'
      IFLAG=1
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C     MOMENT ESTIMATES:
C
C       GAMMAHAT = 1 + SQRT(1 + (XBAR/S)**2)
C       AHAT     = XBAR*(GAMMAHAT - 1)/GAMMAHAT
C
      SHAPMO=1.0 + SQRT(1.0 + (XMEAN/XSD)**2)
      AMOM=XMEAN*(SHAPMO - 1.0)/SHAPMO
      IF(AMOM.GT.XMIN)THEN
        AMOM=CPUMIN
        SHAPMO=CPUMIN
      ENDIF
C
C     MODIFIED MOMENT ESTIMATES:
C
C        GAMMAHAT = (N*XBAR - XMIN)/(N*(XBAR - XMIN))
C        AHAT     = (N-1)*XMIN*XBAR/(N*XBAR - XMIN)
C
      AN=REAL(N)
      SHAPMM=(AN*XMEAN - XMIN)/(AN*(XMEAN - XMIN))
      AMM=(AN-1.0)*XMIN*XMEAN/(N*XMEAN - XMIN)
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')THEN
        WRITE(ICOUT,1055)N,XMEAN,XSD,XMIN,XMAX
 1055   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,6G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1057)AMOM,SHAPMO,AMM,SHAPMM
 1057   FORMAT('AMOM,SHAPMO,AMM,SHAPMM = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
C     MODIFIED MAXIMUM LIKELIHOOD ESTIMATES:
C
C     ITERATIVELY SOLVE FOR THE THRESHOLD PARAMETER:
C
C        N*(XMIN - AHAT)/XMIN - (1/N)*SUM[i=1 to N][LOG(X(i)/AHAT) = 0
C
C     THEN
C
C        GAMMAHAT = N/SUM[i=1 to N][LOG(X(i)/AHAT)]
C
C
      DXBAR=DBLE(XMEAN)
      DXMIN=DBLE(XMIN)
      IN=N
      DO2010I=1,N
        DTEMP1(I)=DBLE(Y(I))
 2010 CONTINUE
C
      DEPS=1.0D-12
      DXSTRT=DBLE(AMM)
      DAE=2.0*0.000001D0*DXSTRT
      DRE=DAE
      IFLAG=0
CCCCC DXLOW=0.0D0
CCCCC DXLOW=DEPS
      DXLOW=DXSTRT/2.0D0
      DXUP=DBLE(XMIN) - DEPS
      ITBRAC=0
      CALL DFZER2(PARFUN,DXLOW,DXUP,DXSTRT,DRE,DAE,IFLAG,DTEMP1)
C
      IF(IFLAG.EQ.2)THEN
C
C       NOTE: SUPPRESS THIS MESSAGE FOR NOW.
CCCCC   WRITE(ICOUT,999)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,111)
CC111   FORMAT('***** WARNING FROM PARETO MAXIMUM ',
CCCCC1         'LIKELIHOOD--')
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,113)
CC113   FORMAT('      ESTIMATE OF THRESHOLD MAY NOT BE COMPUTED TO ',
CCCCC1         'DESIRED TOLERANCE.')
CCCCC   CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.3)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
  121   FORMAT('***** WARNING FROM PARETO MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,123)
  123   FORMAT('      ESTIMATE OF THRESHOLD MAY BE NEAR A ',
     1         'SINGULAR POINT.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.4)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,131)
  131   FORMAT('***** ERROR FROM PARETO MAXIMUM LIKELIHOOD--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,133)
  133   FORMAT('      APPROPRIATE BRACKETING INTERVAL NOT FOUND.')
        CALL DPWRST('XXX','BUG ')
      ELSEIF(IFLAG.EQ.5)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,121)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,143)
  143   FORMAT('      MAXIMUM ITERATIONS EXCEEDED.')
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      AML=REAL(DXLOW)
C
      DSUM=0.0D0
      DO4110I=1,N
        DTERM1=DBLE(LOG(Y(I)/DBLE(AML)))
        DSUM=DSUM + DTERM1
 4110 CONTINUE
      GAMMA=REAL(DSUM)/AN
      SHAPML=1.0/GAMMA
C
      AN=REAL(N)
      SHAPSE=CPUMIN
      AMLSE=CPUMIN
      IF(N.GT.3)THEN
        TERM1=(AN**2)*(SHAPML**2)/((AN-2.0)**2*(AN-3.0))
        SHAPSE=SQRT(TERM1)
      ENDIF
      IF(AN.GT.2.0/SHAPML)THEN
        AMLSE=(AML/(AN*SHAPML - 1.0))*SQRT(AN*SHAPML/(AN*SHAPML - 2.0))
      ENDIF
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'RML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF PARML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9058)AML,SHAPML,AMLSE,SHAPSE
 9058   FORMAT('AML,SHAPML,AMLSE,SHAPSE = ',4G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PARPDF(X,GAMMA,A,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE PARETO
C              DISTRIBUTION WITH SINGLE PRECISION 
C              TAIL LENGTH PARAMETER = GAMMA.
C              THE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO A, 
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X**(GAMMA+1))  X >= A.
C                                                    A, GAMMA > 0
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO ALOC.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                ALOC SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN OR EQUAL TO A.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 233-249.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 102.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1994. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.A)THEN
        WRITE(ICOUT,4)A
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PARPDF IS LESS THAN ',
     1       'THE LOCATION PARAMETER ',G15.7)
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT (THE SHAPE PARAMETER) ',
     1       'TO PARPDF IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PARPDF (THE ',
     1       'LOCATION PARAMETER) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      PDF=GAMMA*A**GAMMA/(X**(GAMMA+1.0))
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PARPPF(P,GAMMA,A,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE PARETO
C              DISTRIBUTION WITH SINGLE PRECISION
C              TAIL LENGTH PARAMETER = GAMMA
C              AND LOCATION PARAMETER = A.
C              THE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO A,
C              AND HAS THE PERCENT POINT FUNCTION
C              G(P) = A*(1.0-P)**(-1.0/GAMMA)
C              NOTE THAT THE PERCENT POINT FUNCTION OF A DISTRIBUTION
C              IS IDENTICALLY THE SAME AS THE INVERSE CUMULATIVE
C              DISTRIBUTION FUNCTION OF THE DISTRIBUTION.
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (INCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C             VALUE PPF FOR THE PARETO DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 233-249.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 102.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      PPF=0.0
      IF(P.LT.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PARPPF IS OUTSIDE ',
     1       'THE ALLOWABLE [0,1) INTERVAL')
   15 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PARPPF (THE SHAPE ',
     1       'PARAMETER) IS NON-POSITIVE')
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PARPPF (THE ',
     1       'LOCATION PARAMETER) IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      PPF=A*(1.0-P)**(-1.0/GAMMA)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PARRAN(N,GAMMA,A,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE PARETO DISTRIBUTION
C              WITH TAIL LENGTH PARAMETER VALUE = GAMMA.
C              THE PROTOTYPE PARETO DISTRIBUTION USED
C              HEREIN IS DEFINED FOR ALL X GREATER THAN
C              OR EQUAL TO 1,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X**(GAMMA+1)).
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE PARETO DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             LOCATION PARAMETER VALUE = A
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --GAMMA AND A SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 14-15.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 36.
C               --JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1970, PAGES 233-249.
C               --HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--A HANDBOOK FOR
C                 STUDENTS AND PRACTITIONERS, 1975,
C                 PAGE 104.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--82.6
C     ORIGINAL VERSION--NOVEMBER  1975.
C     UPDATED         --DECEMBER  1981.
C     UPDATED         --MAY       1982.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,16) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,26) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF PARETO RANDOM ',
     1'NUMBERS IS NON-POSITIVE ******')
   15 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE PARPDF ',
     1       'SUBROUTINE')
   16 FORMAT('      (THE SHAPE PARAMETER) IS NON-POSITIVE *****')
   25 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO THE PARPDF ',
     1       'SUBROUTINE')
   26 FORMAT('      (THE LOCATION PARAMETER) IS NON-POSITIVE *****')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N PARETO DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
      X(I)=A*(1.0-X(I))**(-1.0/GAMMA)
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PA2CDF(X,GAMMA,A,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE PARETO TYPE II
C              DISTRIBUTION WITH SINGLE PRECISION TAIL LENGTH
C              PARAMETER = GAMMA AND LOCATION PARAMETER = A.
C              THE PARETO DISTRIBUTION USED HEREIN IS DEFINED FOR
C              ALL X GREATER THAN OR EQUAL TO 0, 
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X+A)**(GAMMA+1)
C              THE CUMULATIVE DISTRIBUTION FUNCTION IS:
C              F(X) = 1 - A**GAMMA/(X+A)**GAMMA
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE CUMULATIVE DISTRIBUTION 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO 1.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--CDF    = THE SINGLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN
C                   OR EQUAL TO 0.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 20
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--CHAPTER 30
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2899
C     ORIGINAL VERSION--OCTOBER   1995. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DA
      DOUBLE PRECISION DG
      DOUBLE PRECISION DX
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        CDF=0.0
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE PA2CDF ',
     1       'SUBROUTINE IS NEGATIVE.')
   15 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE PA2CDF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   25 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO THE PA2CDF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
C-----START POINT-----------------------------------------------------
C
      DA=DBLE(A)
      DG=DBLE(GAMMA)
      DX=DBLE(X)
      DCDF=1.0D0 - DA**DG/((DX+DA)**DG)
      CDF=REAL(DCDF)
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PA2PDF(X,GAMMA,A,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE PARETO DISTRIBUTION OF THE
C              SECOND KIND WITH SINGLE PRECISION TAIL LENGTH
C              PARAMETER = GAMMA AND LOCATION PARAMETER A.
C              THE PARETO DISTRIBUTION USED HEREIN IS DEFINED FOR
C              ALL X GREATER THAN OR EQUAL TO 0, 
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X+A)**(GAMMA+1)
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VALUE 
C                                AT WHICH THE PROBABILITY DENSITY 
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE GREATER THAN
C                                OR EQUAL TO 1.
C                     --GAMMA  = THE SINGLE PRECISION VALUE 
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE NON-NEGATIVE.
C     OUTPUT ARGUMENTS--PDF    = THE SINGLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE PDF FOR THE PARETO
C             DISTRIBUTION WITH TAIL LENGTH PARAMETER VALUE = GAMMA
C             AND LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --X SHOULD BE GREATER THAN OR EQUAL TO 1.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 20
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--CHAPTER 30
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--OCTOBER   1995. 
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DG
      DOUBLE PRECISION DA
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DTERM1
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(X.LT.0.0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)X
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE PA2PDF ',
     1       'SUBROUTINE IS NEGATIVE.')
   15 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE PA2PDF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   25 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO THE PA2PDF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
C-----START POINT-----------------------------------------------------
C
      DX=DBLE(X)
      DG=DBLE(GAMMA)
      DA=DBLE(A)
      DTERM1=DLOG(DG) + DG*DLOG(DA) - (DG+1.0D0)*DLOG(DX+DA)
      DPDF=DEXP(DTERM1)
      PDF=SNGL(DPDF)
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PA2PPF(P,GAMMA,A,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT FUNCTION
C              VALUE FOR THE PARETO DISTRIBUTION OF THE SECOND KIND
C              WITH SINGLE PRECISION TAIL LENGTH PARAMETER = GAMMA
C              AND LOCATION PARAMETER A.
C              THE PARETO DISTRIBUTION USED HEREIN IS DEFINED FOR
C              ALL X GREATER THAN OR EQUAL TO 0, 
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X+A)**(GAMMA+1)
C
C              THE PERCENT POINT FUNCTION IS
C
C              G(P) = (A**GAMMA/(1-P))**(1/GAMMA) - A
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--P      = THE SINGLE PRECISION VALUE
C                                (BETWEEN 0.0 (INCLUSIVELY)
C                                AND 1.0 (EXCLUSIVELY))
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE
C                                OF THE TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--PPF    = THE SINGLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE SINGLE PRECISION PERCENT POINT FUNCTION .
C             VALUE PPF FOR THE PARETO DISTRIBUTION
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA AND LOCATION
C             PARAMETER = A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--GAMMA AND A SHOULD BE POSITIVE.
C                 --P SHOULD BE BETWEEN 0.0 (EXCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON AND KOTZ, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 1994, CHAPTER 20
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--CHAPTER 30
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--95/10
C     ORIGINAL VERSION--OCTOBER   1995.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION DP
      DOUBLE PRECISION DA
      DOUBLE PRECISION DG
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(P.LT.0.0.OR.P.GE.1.0)THEN
        WRITE(ICOUT,1)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)P
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25) 
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        PPF=0.0
        GOTO9999
      ENDIF
    1 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE PA2PPF ',
     1       'SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL.')
   15 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE PA2PPF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   25 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO THE PA2PPF ',
     1       'SUBROUTINE IS NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
      IF(P.LE.0.0)THEN
        PPF=0.0
      ELSE
        DP=DBLE(P)
        DA=DBLE(A)
        DG=DBLE(GAMMA)
        DPPF=(DA**DG/(1.0D0-DP))**(1.0D0/DG) - DA
        PPF=REAL(DPPF)
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PA2RAN(N,GAMMA,A,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE PARETO DISTRIBUTION OF THE SECOND KIND
C              WITH TAIL LENGTH PARAMETER VALUE = GAMMA AND
C              LOCATION PARAMETER A.
C              THE PARETO DISTRIBUTION USED HEREIN IS DEFINED FOR
C              ALL X GREATER THAN OR EQUAL TO 0, 
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C              F(X) = GAMMA*A**GAMMA/(X+A)**(GAMMA+1)
C
C              NOTE THAT ALTHOUGH A IS COMMONLY REFERRED TO AS A
C              LOCATION PARAMETER, IT IS NOT IN THE TECHNICAL
C              SENSE OF
C
C                 f(X;A) = f(X-A),0)
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                TAIL LENGTH PARAMETER.
C                                GAMMA SHOULD BE POSITIVE.
C                     --A      = THE SINGLE PRECISION VALUE 
C                                OF THE LOCATION PARAMETER.
C                                A SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE PARETO DISTRIBUTION OF THE SECOND KIND
C             WITH TAIL LENGTH PARAMETER VALUE = GAMMA AND
C             LOCATION PARAMETER A.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --GAMMA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--TOCHER, THE ART OF SIMULATION,
C                 1963, PAGES 14-15.
C               --HAMMERSLEY AND HANDSCOMB, MONTE CARLO METHODS,
C                 1964, PAGE 36.
C               --JOHNSON, KOTZ, AND BALAKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--1, 1994.
C               --EVANS, HASTINGS AND PEACOCK, STATISTICAL
C                 DISTRIBUTIONS--THIRD EDITION, 2000.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1966)
C               EXCEPTION--HOLLERITH STRINGS IN FORMAT STATEMENTS
C                          DENOTED BY QUOTES RATHER THAN NH.
C     VERSION NUMBER--2003.6
C     ORIGINAL VERSION--JUNE      2003.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(GAMMA.LE.0.0)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)GAMMA
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ELSEIF(A.LE.0.0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)A
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE NUMBER OF REQUESTED PARETO SECOND ',
     1'KIND RANDOM NUMBERS IS NON-POSITIVE.')
   15 FORMAT('***** ERROR--THE SHAPE PARAMETER FOR THE PARETO ',
     1'SECOND KIND RANDOM NUMBERS IS NON-POSITIVE.')
   25 FORMAT('***** ERROR--THE LOCATION PARAMETER FOR THE PARETO ',
     1'SECOND KIND RANDOM NUMBERS IS NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8,' *****')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N PARETO SECOND KIND DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        CALL PA2PPF(X(I),GAMMA,A,PPF)
        X(I)=PPF
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PASSB(NAC,IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)    
C***BEGIN PROLOGUE  PASSB
C***REFER TO  CFFTB 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSB  
      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
     1                C1(IDO,L1,IP)          ,WA(*)      ,C2(IDL1,IP),
     2                CH2(IDL1,IP) 
C***FIRST EXECUTABLE STATEMENT  PASSB   
      IDOT = IDO/2  
      IPP2 = IP+2   
      IPPH = (IP+1)/2    
      IDP = IP*IDO  
C    
      IF (IDO .LT. L1) GO TO 106   
      DO 103 J=2,IPPH    
         JC = IPP2-J
         DO 102 K=1,L1   
CDIR$ IVDEP    
            DO 101 I=1,IDO    
               CH(I,K,J) = CC(I,J,K)+CC(I,JC,K)   
               CH(I,K,JC) = CC(I,J,K)-CC(I,JC,K)  
  101       CONTINUE
  102    CONTINUE   
  103 CONTINUE 
      DO 105 K=1,L1 
CDIR$ IVDEP    
         DO 104 I=1,IDO  
            CH(I,K,1) = CC(I,1,K)  
  104    CONTINUE   
  105 CONTINUE 
      GO TO 112
  106 DO 109 J=2,IPPH    
         JC = IPP2-J
         DO 108 I=1,IDO  
CDIR$ IVDEP    
            DO 107 K=1,L1
               CH(I,K,J) = CC(I,J,K)+CC(I,JC,K)   
               CH(I,K,JC) = CC(I,J,K)-CC(I,JC,K)  
  107       CONTINUE
  108    CONTINUE   
  109 CONTINUE 
      DO 111 I=1,IDO
CDIR$ IVDEP    
         DO 110 K=1,L1   
            CH(I,K,1) = CC(I,1,K)  
  110    CONTINUE   
  111 CONTINUE 
  112 IDL = 2-IDO   
      INC = 0  
      DO 116 L=2,IPPH    
         LC = IPP2-L
         IDL = IDL+IDO   
CDIR$ IVDEP    
         DO 113 IK=1,IDL1
            C2(IK,L) = CH2(IK,1)+WA(IDL-1)*CH2(IK,2)   
            C2(IK,LC) = WA(IDL)*CH2(IK,IP)   
  113    CONTINUE   
         IDLJ = IDL 
         INC = INC+IDO   
         DO 115 J=3,IPPH 
            JC = IPP2-J  
            IDLJ = IDLJ+INC   
            IF (IDLJ .GT. IDP) IDLJ = IDLJ-IDP    
            WAR = WA(IDLJ-1)  
            WAI = WA(IDLJ)    
CDIR$ IVDEP    
            DO 114 IK=1,IDL1  
               C2(IK,L) = C2(IK,L)+WAR*CH2(IK,J)  
               C2(IK,LC) = C2(IK,LC)+WAI*CH2(IK,JC)    
  114       CONTINUE
  115    CONTINUE   
  116 CONTINUE 
      DO 118 J=2,IPPH    
CDIR$ IVDEP    
         DO 117 IK=1,IDL1
            CH2(IK,1) = CH2(IK,1)+CH2(IK,J)  
  117    CONTINUE   
  118 CONTINUE 
      DO 120 J=2,IPPH    
         JC = IPP2-J
CDIR$ IVDEP    
         DO 119 IK=2,IDL1,2   
            CH2(IK-1,J) = C2(IK-1,J)-C2(IK,JC)    
            CH2(IK-1,JC) = C2(IK-1,J)+C2(IK,JC)   
            CH2(IK,J) = C2(IK,J)+C2(IK-1,JC) 
            CH2(IK,JC) = C2(IK,J)-C2(IK-1,JC)
  119    CONTINUE   
  120 CONTINUE 
      NAC = 1  
      IF (IDO .EQ. 2) RETURN  
      NAC = 0  
      DO 121 IK=1,IDL1   
         C2(IK,1) = CH2(IK,1) 
  121 CONTINUE 
      DO 123 J=2,IP 
CDIR$ IVDEP    
         DO 122 K=1,L1   
            C1(1,K,J) = CH(1,K,J)  
            C1(2,K,J) = CH(2,K,J)  
  122    CONTINUE   
  123 CONTINUE 
      IF (IDOT .GT. L1) GO TO 127  
      IDIJ = 0 
      DO 126 J=2,IP 
         IDIJ = IDIJ+2   
         DO 125 I=4,IDO,2
            IDIJ = IDIJ+2
CDIR$ IVDEP    
            DO 124 K=1,L1
               C1(I-1,K,J) = WA(IDIJ-1)*CH(I-1,K,J)-WA(IDIJ)*CH(I,K,J)
               C1(I,K,J) = WA(IDIJ-1)*CH(I,K,J)+WA(IDIJ)*CH(I-1,K,J)  
  124       CONTINUE
  125    CONTINUE   
  126 CONTINUE 
      RETURN   
  127 IDJ = 2-IDO   
      DO 130 J=2,IP 
         IDJ = IDJ+IDO   
         DO 129 K=1,L1   
            IDIJ = IDJ   
CDIR$ IVDEP    
            DO 128 I=4,IDO,2  
               IDIJ = IDIJ+2  
               C1(I-1,K,J) = WA(IDIJ-1)*CH(I-1,K,J)-WA(IDIJ)*CH(I,K,J)
               C1(I,K,J) = WA(IDIJ-1)*CH(I,K,J)+WA(IDIJ)*CH(I-1,K,J)  
  128       CONTINUE
  129    CONTINUE   
  130 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSB2(IDO,L1,CC,CH,WA1)    
C***BEGIN PROLOGUE  PASSB2    
C***REFER TO  CFFTB 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSB2 
      DIMENSION       CC(IDO,2,L1)           ,CH(IDO,L1,2)           ,
     1                WA1(*)  
C***FIRST EXECUTABLE STATEMENT  PASSB2  
      IF (IDO .GT. 2) GO TO 102    
      DO 101 K=1,L1 
         CH(1,K,1) = CC(1,1,K)+CC(1,2,K)
         CH(1,K,2) = CC(1,1,K)-CC(1,2,K)
         CH(2,K,1) = CC(2,1,K)+CC(2,2,K)
         CH(2,K,2) = CC(2,1,K)-CC(2,2,K)
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            CH(I-1,K,1) = CC(I-1,1,K)+CC(I-1,2,K) 
            TR2 = CC(I-1,1,K)-CC(I-1,2,K)    
            CH(I,K,1) = CC(I,1,K)+CC(I,2,K)  
            TI2 = CC(I,1,K)-CC(I,2,K)   
            CH(I,K,2) = WA1(I-1)*TI2+WA1(I)*TR2   
            CH(I-1,K,2) = WA1(I-1)*TR2-WA1(I)*TI2 
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            CH(I-1,K,1) = CC(I-1,1,K)+CC(I-1,2,K) 
            TR2 = CC(I-1,1,K)-CC(I-1,2,K)    
            CH(I,K,1) = CC(I,1,K)+CC(I,2,K)  
            TI2 = CC(I,1,K)-CC(I,2,K)   
            CH(I,K,2) = WA1(I-1)*TI2+WA1(I)*TR2   
            CH(I-1,K,2) = WA1(I-1)*TR2-WA1(I)*TI2 
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSB3(IDO,L1,CC,CH,WA1,WA2)
C***BEGIN PROLOGUE  PASSB3    
C***REFER TO  CFFTB 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSB3 
      DIMENSION       CC(IDO,3,L1)           ,CH(IDO,L1,3)           ,
     1                WA1(*)     ,WA2(*)
C***FIRST EXECUTABLE STATEMENT  PASSB3  
      TAUR = -.5    
      TAUI = .5*SQRT(3.) 
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TR2 = CC(1,2,K)+CC(1,3,K) 
         CR2 = CC(1,1,K)+TAUR*TR2  
         CH(1,K,1) = CC(1,1,K)+TR2 
         TI2 = CC(2,2,K)+CC(2,3,K) 
         CI2 = CC(2,1,K)+TAUR*TI2  
         CH(2,K,1) = CC(2,1,K)+TI2 
         CR3 = TAUI*(CC(1,2,K)-CC(1,3,K))    
         CI3 = TAUI*(CC(2,2,K)-CC(2,3,K))    
         CH(1,K,2) = CR2-CI3  
         CH(1,K,3) = CR2+CI3  
         CH(2,K,2) = CI2+CR3  
         CH(2,K,3) = CI2-CR3  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TR2 = CC(I-1,2,K)+CC(I-1,3,K)    
            CR2 = CC(I-1,1,K)+TAUR*TR2  
            CH(I-1,K,1) = CC(I-1,1,K)+TR2    
            TI2 = CC(I,2,K)+CC(I,3,K)   
            CI2 = CC(I,1,K)+TAUR*TI2    
            CH(I,K,1) = CC(I,1,K)+TI2   
            CR3 = TAUI*(CC(I-1,2,K)-CC(I-1,3,K))  
            CI3 = TAUI*(CC(I,2,K)-CC(I,3,K)) 
            DR2 = CR2-CI3
            DR3 = CR2+CI3
            DI2 = CI2+CR3
            DI3 = CI2-CR3
            CH(I,K,2) = WA1(I-1)*DI2+WA1(I)*DR2   
            CH(I-1,K,2) = WA1(I-1)*DR2-WA1(I)*DI2 
            CH(I,K,3) = WA2(I-1)*DI3+WA2(I)*DR3   
            CH(I-1,K,3) = WA2(I-1)*DR3-WA2(I)*DI3 
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TR2 = CC(I-1,2,K)+CC(I-1,3,K)    
            CR2 = CC(I-1,1,K)+TAUR*TR2  
            CH(I-1,K,1) = CC(I-1,1,K)+TR2    
            TI2 = CC(I,2,K)+CC(I,3,K)   
            CI2 = CC(I,1,K)+TAUR*TI2    
            CH(I,K,1) = CC(I,1,K)+TI2   
            CR3 = TAUI*(CC(I-1,2,K)-CC(I-1,3,K))  
            CI3 = TAUI*(CC(I,2,K)-CC(I,3,K)) 
            DR2 = CR2-CI3
            DR3 = CR2+CI3
            DI2 = CI2+CR3
            DI3 = CI2-CR3
            CH(I,K,2) = WA1(I-1)*DI2+WA1(I)*DR2   
            CH(I-1,K,2) = WA1(I-1)*DR2-WA1(I)*DI2 
            CH(I,K,3) = WA2(I-1)*DI3+WA2(I)*DR3   
            CH(I-1,K,3) = WA2(I-1)*DR3-WA2(I)*DI3 
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSB4(IDO,L1,CC,CH,WA1,WA2,WA3) 
C***BEGIN PROLOGUE  PASSB4    
C***REFER TO  CFFTB 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSB4 
      DIMENSION       CC(IDO,4,L1)           ,CH(IDO,L1,4)           ,
     1                WA1(*)     ,WA2(*)     ,WA3(*)   
C***FIRST EXECUTABLE STATEMENT  PASSB4  
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TI1 = CC(2,1,K)-CC(2,3,K) 
         TI2 = CC(2,1,K)+CC(2,3,K) 
         TR4 = CC(2,4,K)-CC(2,2,K) 
         TI3 = CC(2,2,K)+CC(2,4,K) 
         TR1 = CC(1,1,K)-CC(1,3,K) 
         TR2 = CC(1,1,K)+CC(1,3,K) 
         TI4 = CC(1,2,K)-CC(1,4,K) 
         TR3 = CC(1,2,K)+CC(1,4,K) 
         CH(1,K,1) = TR2+TR3  
         CH(1,K,3) = TR2-TR3  
         CH(2,K,1) = TI2+TI3  
         CH(2,K,3) = TI2-TI3  
         CH(1,K,2) = TR1+TR4  
         CH(1,K,4) = TR1-TR4  
         CH(2,K,2) = TI1+TI4  
         CH(2,K,4) = TI1-TI4  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TI1 = CC(I,1,K)-CC(I,3,K)   
            TI2 = CC(I,1,K)+CC(I,3,K)   
            TI3 = CC(I,2,K)+CC(I,4,K)   
            TR4 = CC(I,4,K)-CC(I,2,K)   
            TR1 = CC(I-1,1,K)-CC(I-1,3,K)    
            TR2 = CC(I-1,1,K)+CC(I-1,3,K)    
            TI4 = CC(I-1,2,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,2,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = TR2+TR3  
            CR3 = TR2-TR3
            CH(I,K,1) = TI2+TI3    
            CI3 = TI2-TI3
            CR2 = TR1+TR4
            CR4 = TR1-TR4
            CI2 = TI1+TI4
            CI4 = TI1-TI4
            CH(I-1,K,2) = WA1(I-1)*CR2-WA1(I)*CI2 
            CH(I,K,2) = WA1(I-1)*CI2+WA1(I)*CR2   
            CH(I-1,K,3) = WA2(I-1)*CR3-WA2(I)*CI3 
            CH(I,K,3) = WA2(I-1)*CI3+WA2(I)*CR3   
            CH(I-1,K,4) = WA3(I-1)*CR4-WA3(I)*CI4 
            CH(I,K,4) = WA3(I-1)*CI4+WA3(I)*CR4   
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TI1 = CC(I,1,K)-CC(I,3,K)   
            TI2 = CC(I,1,K)+CC(I,3,K)   
            TI3 = CC(I,2,K)+CC(I,4,K)   
            TR4 = CC(I,4,K)-CC(I,2,K)   
            TR1 = CC(I-1,1,K)-CC(I-1,3,K)    
            TR2 = CC(I-1,1,K)+CC(I-1,3,K)    
            TI4 = CC(I-1,2,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,2,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = TR2+TR3  
            CR3 = TR2-TR3
            CH(I,K,1) = TI2+TI3    
            CI3 = TI2-TI3
            CR2 = TR1+TR4
            CR4 = TR1-TR4
            CI2 = TI1+TI4
            CI4 = TI1-TI4
            CH(I-1,K,2) = WA1(I-1)*CR2-WA1(I)*CI2 
            CH(I,K,2) = WA1(I-1)*CI2+WA1(I)*CR2   
            CH(I-1,K,3) = WA2(I-1)*CR3-WA2(I)*CI3 
            CH(I,K,3) = WA2(I-1)*CI3+WA2(I)*CR3   
            CH(I-1,K,4) = WA3(I-1)*CR4-WA3(I)*CI4 
            CH(I,K,4) = WA3(I-1)*CI4+WA3(I)*CR4   
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSB5(IDO,L1,CC,CH,WA1,WA2,WA3,WA4)  
C***BEGIN PROLOGUE  PASSB5    
C***REFER TO  CFFTB 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSB5 
      DIMENSION       CC(IDO,5,L1)           ,CH(IDO,L1,5)           ,
     1                WA1(*)     ,WA2(*)     ,WA3(*)     ,WA4(*) 
C***FIRST EXECUTABLE STATEMENT  PASSB5  
      PI = 4.*ATAN(1.)   
      TR11 = SIN(.1*PI)  
      TI11 = SIN(.4*PI)  
      TR12 = -SIN(.3*PI) 
      TI12 = SIN(.2*PI)  
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TI5 = CC(2,2,K)-CC(2,5,K) 
         TI2 = CC(2,2,K)+CC(2,5,K) 
         TI4 = CC(2,3,K)-CC(2,4,K) 
         TI3 = CC(2,3,K)+CC(2,4,K) 
         TR5 = CC(1,2,K)-CC(1,5,K) 
         TR2 = CC(1,2,K)+CC(1,5,K) 
         TR4 = CC(1,3,K)-CC(1,4,K) 
         TR3 = CC(1,3,K)+CC(1,4,K) 
         CH(1,K,1) = CC(1,1,K)+TR2+TR3  
         CH(2,K,1) = CC(2,1,K)+TI2+TI3  
         CR2 = CC(1,1,K)+TR11*TR2+TR12*TR3   
         CI2 = CC(2,1,K)+TR11*TI2+TR12*TI3   
         CR3 = CC(1,1,K)+TR12*TR2+TR11*TR3   
         CI3 = CC(2,1,K)+TR12*TI2+TR11*TI3   
         CR5 = TI11*TR5+TI12*TR4   
         CI5 = TI11*TI5+TI12*TI4   
         CR4 = TI12*TR5-TI11*TR4   
         CI4 = TI12*TI5-TI11*TI4   
         CH(1,K,2) = CR2-CI5  
         CH(1,K,5) = CR2+CI5  
         CH(2,K,2) = CI2+CR5  
         CH(2,K,3) = CI3+CR4  
         CH(1,K,3) = CR3-CI4  
         CH(1,K,4) = CR3+CI4  
         CH(2,K,4) = CI3-CR4  
         CH(2,K,5) = CI2-CR5  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TI5 = CC(I,2,K)-CC(I,5,K)   
            TI2 = CC(I,2,K)+CC(I,5,K)   
            TI4 = CC(I,3,K)-CC(I,4,K)   
            TI3 = CC(I,3,K)+CC(I,4,K)   
            TR5 = CC(I-1,2,K)-CC(I-1,5,K)    
            TR2 = CC(I-1,2,K)+CC(I-1,5,K)    
            TR4 = CC(I-1,3,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,3,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = CC(I-1,1,K)+TR2+TR3
            CH(I,K,1) = CC(I,1,K)+TI2+TI3    
            CR2 = CC(I-1,1,K)+TR11*TR2+TR12*TR3   
            CI2 = CC(I,1,K)+TR11*TI2+TR12*TI3
            CR3 = CC(I-1,1,K)+TR12*TR2+TR11*TR3   
            CI3 = CC(I,1,K)+TR12*TI2+TR11*TI3
            CR5 = TI11*TR5+TI12*TR4
            CI5 = TI11*TI5+TI12*TI4
            CR4 = TI12*TR5-TI11*TR4
            CI4 = TI12*TI5-TI11*TI4
            DR3 = CR3-CI4
            DR4 = CR3+CI4
            DI3 = CI3+CR4
            DI4 = CI3-CR4
            DR5 = CR2+CI5
            DR2 = CR2-CI5
            DI5 = CI2-CR5
            DI2 = CI2+CR5
            CH(I-1,K,2) = WA1(I-1)*DR2-WA1(I)*DI2 
            CH(I,K,2) = WA1(I-1)*DI2+WA1(I)*DR2   
            CH(I-1,K,3) = WA2(I-1)*DR3-WA2(I)*DI3 
            CH(I,K,3) = WA2(I-1)*DI3+WA2(I)*DR3   
            CH(I-1,K,4) = WA3(I-1)*DR4-WA3(I)*DI4 
            CH(I,K,4) = WA3(I-1)*DI4+WA3(I)*DR4   
            CH(I-1,K,5) = WA4(I-1)*DR5-WA4(I)*DI5 
            CH(I,K,5) = WA4(I-1)*DI5+WA4(I)*DR5   
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TI5 = CC(I,2,K)-CC(I,5,K)   
            TI2 = CC(I,2,K)+CC(I,5,K)   
            TI4 = CC(I,3,K)-CC(I,4,K)   
            TI3 = CC(I,3,K)+CC(I,4,K)   
            TR5 = CC(I-1,2,K)-CC(I-1,5,K)    
            TR2 = CC(I-1,2,K)+CC(I-1,5,K)    
            TR4 = CC(I-1,3,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,3,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = CC(I-1,1,K)+TR2+TR3
            CH(I,K,1) = CC(I,1,K)+TI2+TI3    
            CR2 = CC(I-1,1,K)+TR11*TR2+TR12*TR3   
            CI2 = CC(I,1,K)+TR11*TI2+TR12*TI3
            CR3 = CC(I-1,1,K)+TR12*TR2+TR11*TR3   
            CI3 = CC(I,1,K)+TR12*TI2+TR11*TI3
            CR5 = TI11*TR5+TI12*TR4
            CI5 = TI11*TI5+TI12*TI4
            CR4 = TI12*TR5-TI11*TR4
            CI4 = TI12*TI5-TI11*TI4
            DR3 = CR3-CI4
            DR4 = CR3+CI4
            DI3 = CI3+CR4
            DI4 = CI3-CR4
            DR5 = CR2+CI5
            DR2 = CR2-CI5
            DI5 = CI2-CR5
            DI2 = CI2+CR5
            CH(I-1,K,2) = WA1(I-1)*DR2-WA1(I)*DI2 
            CH(I,K,2) = WA1(I-1)*DI2+WA1(I)*DR2   
            CH(I-1,K,3) = WA2(I-1)*DR3-WA2(I)*DI3 
            CH(I,K,3) = WA2(I-1)*DI3+WA2(I)*DR3   
            CH(I-1,K,4) = WA3(I-1)*DR4-WA3(I)*DI4 
            CH(I,K,4) = WA3(I-1)*DI4+WA3(I)*DR4   
            CH(I-1,K,5) = WA4(I-1)*DR5-WA4(I)*DI5 
            CH(I,K,5) = WA4(I-1)*DI5+WA4(I)*DR5   
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSF(NAC,IDO,IP,L1,IDL1,CC,C1,C2,CH,CH2,WA)    
C***BEGIN PROLOGUE  PASSF
C***REFER TO  CFFTF 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSF  
      DIMENSION       CH(IDO,L1,IP)          ,CC(IDO,IP,L1)          ,
     1                C1(IDO,L1,IP)          ,WA(*)      ,C2(IDL1,IP),
     2                CH2(IDL1,IP) 
C***FIRST EXECUTABLE STATEMENT  PASSF   
      IDOT = IDO/2  
      IPP2 = IP+2   
      IPPH = (IP+1)/2    
      IDP = IP*IDO  
C    
      IF (IDO .LT. L1) GO TO 106   
      DO 103 J=2,IPPH    
         JC = IPP2-J
         DO 102 K=1,L1   
CDIR$ IVDEP    
            DO 101 I=1,IDO    
               CH(I,K,J) = CC(I,J,K)+CC(I,JC,K)   
               CH(I,K,JC) = CC(I,J,K)-CC(I,JC,K)  
  101       CONTINUE
  102    CONTINUE   
  103 CONTINUE 
      DO 105 K=1,L1 
CDIR$ IVDEP    
         DO 104 I=1,IDO  
            CH(I,K,1) = CC(I,1,K)  
  104    CONTINUE   
  105 CONTINUE 
      GO TO 112
  106 DO 109 J=2,IPPH    
         JC = IPP2-J
         DO 108 I=1,IDO  
CDIR$ IVDEP    
            DO 107 K=1,L1
               CH(I,K,J) = CC(I,J,K)+CC(I,JC,K)   
               CH(I,K,JC) = CC(I,J,K)-CC(I,JC,K)  
  107       CONTINUE
  108    CONTINUE   
  109 CONTINUE 
      DO 111 I=1,IDO
CDIR$ IVDEP    
         DO 110 K=1,L1   
            CH(I,K,1) = CC(I,1,K)  
  110    CONTINUE   
  111 CONTINUE 
  112 IDL = 2-IDO   
      INC = 0  
      DO 116 L=2,IPPH    
         LC = IPP2-L
         IDL = IDL+IDO   
CDIR$ IVDEP    
         DO 113 IK=1,IDL1
            C2(IK,L) = CH2(IK,1)+WA(IDL-1)*CH2(IK,2)   
            C2(IK,LC) = -WA(IDL)*CH2(IK,IP)  
  113    CONTINUE   
         IDLJ = IDL 
         INC = INC+IDO   
         DO 115 J=3,IPPH 
            JC = IPP2-J  
            IDLJ = IDLJ+INC   
            IF (IDLJ .GT. IDP) IDLJ = IDLJ-IDP    
            WAR = WA(IDLJ-1)  
            WAI = WA(IDLJ)    
CDIR$ IVDEP    
            DO 114 IK=1,IDL1  
               C2(IK,L) = C2(IK,L)+WAR*CH2(IK,J)  
               C2(IK,LC) = C2(IK,LC)-WAI*CH2(IK,JC)    
  114       CONTINUE
  115    CONTINUE   
  116 CONTINUE 
      DO 118 J=2,IPPH    
CDIR$ IVDEP    
         DO 117 IK=1,IDL1
            CH2(IK,1) = CH2(IK,1)+CH2(IK,J)  
  117    CONTINUE   
  118 CONTINUE 
      DO 120 J=2,IPPH    
         JC = IPP2-J
CDIR$ IVDEP    
         DO 119 IK=2,IDL1,2   
            CH2(IK-1,J) = C2(IK-1,J)-C2(IK,JC)    
            CH2(IK-1,JC) = C2(IK-1,J)+C2(IK,JC)   
            CH2(IK,J) = C2(IK,J)+C2(IK-1,JC) 
            CH2(IK,JC) = C2(IK,J)-C2(IK-1,JC)
  119    CONTINUE   
  120 CONTINUE 
      NAC = 1  
      IF (IDO .EQ. 2) RETURN  
      NAC = 0  
CDIR$ IVDEP    
      DO 121 IK=1,IDL1   
         C2(IK,1) = CH2(IK,1) 
  121 CONTINUE 
      DO 123 J=2,IP 
CDIR$ IVDEP    
         DO 122 K=1,L1   
            C1(1,K,J) = CH(1,K,J)  
            C1(2,K,J) = CH(2,K,J)  
  122    CONTINUE   
  123 CONTINUE 
      IF (IDOT .GT. L1) GO TO 127  
      IDIJ = 0 
      DO 126 J=2,IP 
         IDIJ = IDIJ+2   
         DO 125 I=4,IDO,2
            IDIJ = IDIJ+2
CDIR$ IVDEP    
            DO 124 K=1,L1
               C1(I-1,K,J) = WA(IDIJ-1)*CH(I-1,K,J)+WA(IDIJ)*CH(I,K,J)
               C1(I,K,J) = WA(IDIJ-1)*CH(I,K,J)-WA(IDIJ)*CH(I-1,K,J)  
  124       CONTINUE
  125    CONTINUE   
  126 CONTINUE 
      RETURN   
  127 IDJ = 2-IDO   
      DO 130 J=2,IP 
         IDJ = IDJ+IDO   
         DO 129 K=1,L1   
            IDIJ = IDJ   
CDIR$ IVDEP    
            DO 128 I=4,IDO,2  
               IDIJ = IDIJ+2  
               C1(I-1,K,J) = WA(IDIJ-1)*CH(I-1,K,J)+WA(IDIJ)*CH(I,K,J)
               C1(I,K,J) = WA(IDIJ-1)*CH(I,K,J)-WA(IDIJ)*CH(I-1,K,J)  
  128       CONTINUE
  129    CONTINUE   
  130 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSF2(IDO,L1,CC,CH,WA1)    
C***BEGIN PROLOGUE  PASSF2    
C***REFER TO  CFFTF 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSF2 
      DIMENSION       CC(IDO,2,L1)           ,CH(IDO,L1,2)           ,
     1                WA1(*)  
C***FIRST EXECUTABLE STATEMENT  PASSF2  
      IF (IDO .GT. 2) GO TO 102    
      DO 101 K=1,L1 
         CH(1,K,1) = CC(1,1,K)+CC(1,2,K)
         CH(1,K,2) = CC(1,1,K)-CC(1,2,K)
         CH(2,K,1) = CC(2,1,K)+CC(2,2,K)
         CH(2,K,2) = CC(2,1,K)-CC(2,2,K)
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            CH(I-1,K,1) = CC(I-1,1,K)+CC(I-1,2,K) 
            TR2 = CC(I-1,1,K)-CC(I-1,2,K)    
            CH(I,K,1) = CC(I,1,K)+CC(I,2,K)  
            TI2 = CC(I,1,K)-CC(I,2,K)   
            CH(I,K,2) = WA1(I-1)*TI2-WA1(I)*TR2   
            CH(I-1,K,2) = WA1(I-1)*TR2+WA1(I)*TI2 
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
      DO 106 K=1,L1 
            CH(I-1,K,1) = CC(I-1,1,K)+CC(I-1,2,K) 
            TR2 = CC(I-1,1,K)-CC(I-1,2,K)    
            CH(I,K,1) = CC(I,1,K)+CC(I,2,K)  
            TI2 = CC(I,1,K)-CC(I,2,K)   
            CH(I,K,2) = WA1(I-1)*TI2-WA1(I)*TR2   
            CH(I-1,K,2) = WA1(I-1)*TR2+WA1(I)*TI2 
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSF3(IDO,L1,CC,CH,WA1,WA2)
C***BEGIN PROLOGUE  PASSF3    
C***REFER TO  CFFTF 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSF3 
      DIMENSION       CC(IDO,3,L1)           ,CH(IDO,L1,3)           ,
     1                WA1(*)     ,WA2(*)
C***FIRST EXECUTABLE STATEMENT  PASSF3  
      TAUR = -.5    
      TAUI = -.5*SQRT(3.)
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TR2 = CC(1,2,K)+CC(1,3,K) 
         CR2 = CC(1,1,K)+TAUR*TR2  
         CH(1,K,1) = CC(1,1,K)+TR2 
         TI2 = CC(2,2,K)+CC(2,3,K) 
         CI2 = CC(2,1,K)+TAUR*TI2  
         CH(2,K,1) = CC(2,1,K)+TI2 
         CR3 = TAUI*(CC(1,2,K)-CC(1,3,K))    
         CI3 = TAUI*(CC(2,2,K)-CC(2,3,K))    
         CH(1,K,2) = CR2-CI3  
         CH(1,K,3) = CR2+CI3  
         CH(2,K,2) = CI2+CR3  
         CH(2,K,3) = CI2-CR3  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TR2 = CC(I-1,2,K)+CC(I-1,3,K)    
            CR2 = CC(I-1,1,K)+TAUR*TR2  
            CH(I-1,K,1) = CC(I-1,1,K)+TR2    
            TI2 = CC(I,2,K)+CC(I,3,K)   
            CI2 = CC(I,1,K)+TAUR*TI2    
            CH(I,K,1) = CC(I,1,K)+TI2   
            CR3 = TAUI*(CC(I-1,2,K)-CC(I-1,3,K))  
            CI3 = TAUI*(CC(I,2,K)-CC(I,3,K)) 
            DR2 = CR2-CI3
            DR3 = CR2+CI3
            DI2 = CI2+CR3
            DI3 = CI2-CR3
            CH(I,K,2) = WA1(I-1)*DI2-WA1(I)*DR2   
            CH(I-1,K,2) = WA1(I-1)*DR2+WA1(I)*DI2 
            CH(I,K,3) = WA2(I-1)*DI3-WA2(I)*DR3   
            CH(I-1,K,3) = WA2(I-1)*DR3+WA2(I)*DI3 
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TR2 = CC(I-1,2,K)+CC(I-1,3,K)    
            CR2 = CC(I-1,1,K)+TAUR*TR2  
            CH(I-1,K,1) = CC(I-1,1,K)+TR2    
            TI2 = CC(I,2,K)+CC(I,3,K)   
            CI2 = CC(I,1,K)+TAUR*TI2    
            CH(I,K,1) = CC(I,1,K)+TI2   
            CR3 = TAUI*(CC(I-1,2,K)-CC(I-1,3,K))  
            CI3 = TAUI*(CC(I,2,K)-CC(I,3,K)) 
            DR2 = CR2-CI3
            DR3 = CR2+CI3
            DI2 = CI2+CR3
            DI3 = CI2-CR3
            CH(I,K,2) = WA1(I-1)*DI2-WA1(I)*DR2   
            CH(I-1,K,2) = WA1(I-1)*DR2+WA1(I)*DI2 
            CH(I,K,3) = WA2(I-1)*DI3-WA2(I)*DR3   
            CH(I-1,K,3) = WA2(I-1)*DR3+WA2(I)*DI3 
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSF4(IDO,L1,CC,CH,WA1,WA2,WA3) 
C***BEGIN PROLOGUE  PASSF4    
C***REFER TO  CFFTF 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSF4 
      DIMENSION       CC(IDO,4,L1)           ,CH(IDO,L1,4)           ,
     1                WA1(*)     ,WA2(*)     ,WA3(*)   
C***FIRST EXECUTABLE STATEMENT  PASSF4  
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TI1 = CC(2,1,K)-CC(2,3,K) 
         TI2 = CC(2,1,K)+CC(2,3,K) 
         TR4 = CC(2,2,K)-CC(2,4,K) 
         TI3 = CC(2,2,K)+CC(2,4,K) 
         TR1 = CC(1,1,K)-CC(1,3,K) 
         TR2 = CC(1,1,K)+CC(1,3,K) 
         TI4 = CC(1,4,K)-CC(1,2,K) 
         TR3 = CC(1,2,K)+CC(1,4,K) 
         CH(1,K,1) = TR2+TR3  
         CH(1,K,3) = TR2-TR3  
         CH(2,K,1) = TI2+TI3  
         CH(2,K,3) = TI2-TI3  
         CH(1,K,2) = TR1+TR4  
         CH(1,K,4) = TR1-TR4  
         CH(2,K,2) = TI1+TI4  
         CH(2,K,4) = TI1-TI4  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TI1 = CC(I,1,K)-CC(I,3,K)   
            TI2 = CC(I,1,K)+CC(I,3,K)   
            TI3 = CC(I,2,K)+CC(I,4,K)   
            TR4 = CC(I,2,K)-CC(I,4,K)   
            TR1 = CC(I-1,1,K)-CC(I-1,3,K)    
            TR2 = CC(I-1,1,K)+CC(I-1,3,K)    
            TI4 = CC(I-1,4,K)-CC(I-1,2,K)    
            TR3 = CC(I-1,2,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = TR2+TR3  
            CR3 = TR2-TR3
            CH(I,K,1) = TI2+TI3    
            CI3 = TI2-TI3
            CR2 = TR1+TR4
            CR4 = TR1-TR4
            CI2 = TI1+TI4
            CI4 = TI1-TI4
            CH(I-1,K,2) = WA1(I-1)*CR2+WA1(I)*CI2 
            CH(I,K,2) = WA1(I-1)*CI2-WA1(I)*CR2   
            CH(I-1,K,3) = WA2(I-1)*CR3+WA2(I)*CI3 
            CH(I,K,3) = WA2(I-1)*CI3-WA2(I)*CR3   
            CH(I-1,K,4) = WA3(I-1)*CR4+WA3(I)*CI4 
            CH(I,K,4) = WA3(I-1)*CI4-WA3(I)*CR4   
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TI1 = CC(I,1,K)-CC(I,3,K)   
            TI2 = CC(I,1,K)+CC(I,3,K)   
            TI3 = CC(I,2,K)+CC(I,4,K)   
            TR4 = CC(I,2,K)-CC(I,4,K)   
            TR1 = CC(I-1,1,K)-CC(I-1,3,K)    
            TR2 = CC(I-1,1,K)+CC(I-1,3,K)    
            TI4 = CC(I-1,4,K)-CC(I-1,2,K)    
            TR3 = CC(I-1,2,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = TR2+TR3  
            CR3 = TR2-TR3
            CH(I,K,1) = TI2+TI3    
            CI3 = TI2-TI3
            CR2 = TR1+TR4
            CR4 = TR1-TR4
            CI2 = TI1+TI4
            CI4 = TI1-TI4
            CH(I-1,K,2) = WA1(I-1)*CR2+WA1(I)*CI2 
            CH(I,K,2) = WA1(I-1)*CI2-WA1(I)*CR2   
            CH(I-1,K,3) = WA2(I-1)*CR3+WA2(I)*CI3 
            CH(I,K,3) = WA2(I-1)*CI3-WA2(I)*CR3   
            CH(I-1,K,4) = WA3(I-1)*CR4+WA3(I)*CI4 
            CH(I,K,4) = WA3(I-1)*CI4-WA3(I)*CR4   
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PASSF5(IDO,L1,CC,CH,WA1,WA2,WA3,WA4)  
C***BEGIN PROLOGUE  PASSF5    
C***REFER TO  CFFTF 
C***ROUTINES CALLED  (NONE)   
C***END PROLOGUE  PASSF5 
      DIMENSION       CC(IDO,5,L1)           ,CH(IDO,L1,5)           ,
     1                WA1(*)     ,WA2(*)     ,WA3(*)     ,WA4(*) 
C***FIRST EXECUTABLE STATEMENT  PASSF5  
      PI = 4.*ATAN(1.)   
      TR11 = SIN(.1*PI)  
      TI11 = -SIN(.4*PI) 
      TR12 = -SIN(.3*PI) 
      TI12 = -SIN(.2*PI) 
      IF (IDO .NE. 2) GO TO 102    
      DO 101 K=1,L1 
         TI5 = CC(2,2,K)-CC(2,5,K) 
         TI2 = CC(2,2,K)+CC(2,5,K) 
         TI4 = CC(2,3,K)-CC(2,4,K) 
         TI3 = CC(2,3,K)+CC(2,4,K) 
         TR5 = CC(1,2,K)-CC(1,5,K) 
         TR2 = CC(1,2,K)+CC(1,5,K) 
         TR4 = CC(1,3,K)-CC(1,4,K) 
         TR3 = CC(1,3,K)+CC(1,4,K) 
         CH(1,K,1) = CC(1,1,K)+TR2+TR3  
         CH(2,K,1) = CC(2,1,K)+TI2+TI3  
         CR2 = CC(1,1,K)+TR11*TR2+TR12*TR3   
         CI2 = CC(2,1,K)+TR11*TI2+TR12*TI3   
         CR3 = CC(1,1,K)+TR12*TR2+TR11*TR3   
         CI3 = CC(2,1,K)+TR12*TI2+TR11*TI3   
         CR5 = TI11*TR5+TI12*TR4   
         CI5 = TI11*TI5+TI12*TI4   
         CR4 = TI12*TR5-TI11*TR4   
         CI4 = TI12*TI5-TI11*TI4   
         CH(1,K,2) = CR2-CI5  
         CH(1,K,5) = CR2+CI5  
         CH(2,K,2) = CI2+CR5  
         CH(2,K,3) = CI3+CR4  
         CH(1,K,3) = CR3-CI4  
         CH(1,K,4) = CR3+CI4  
         CH(2,K,4) = CI3-CR4  
         CH(2,K,5) = CI2-CR5  
  101 CONTINUE 
      RETURN   
  102 IF(IDO/2.LT.L1) GO TO 105    
      DO 104 K=1,L1 
CDIR$ IVDEP    
         DO 103 I=2,IDO,2
            TI5 = CC(I,2,K)-CC(I,5,K)   
            TI2 = CC(I,2,K)+CC(I,5,K)   
            TI4 = CC(I,3,K)-CC(I,4,K)   
            TI3 = CC(I,3,K)+CC(I,4,K)   
            TR5 = CC(I-1,2,K)-CC(I-1,5,K)    
            TR2 = CC(I-1,2,K)+CC(I-1,5,K)    
            TR4 = CC(I-1,3,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,3,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = CC(I-1,1,K)+TR2+TR3
            CH(I,K,1) = CC(I,1,K)+TI2+TI3    
            CR2 = CC(I-1,1,K)+TR11*TR2+TR12*TR3   
            CI2 = CC(I,1,K)+TR11*TI2+TR12*TI3
            CR3 = CC(I-1,1,K)+TR12*TR2+TR11*TR3   
            CI3 = CC(I,1,K)+TR12*TI2+TR11*TI3
            CR5 = TI11*TR5+TI12*TR4
            CI5 = TI11*TI5+TI12*TI4
            CR4 = TI12*TR5-TI11*TR4
            CI4 = TI12*TI5-TI11*TI4
            DR3 = CR3-CI4
            DR4 = CR3+CI4
            DI3 = CI3+CR4
            DI4 = CI3-CR4
            DR5 = CR2+CI5
            DR2 = CR2-CI5
            DI5 = CI2-CR5
            DI2 = CI2+CR5
            CH(I-1,K,2) = WA1(I-1)*DR2+WA1(I)*DI2 
            CH(I,K,2) = WA1(I-1)*DI2-WA1(I)*DR2   
            CH(I-1,K,3) = WA2(I-1)*DR3+WA2(I)*DI3 
            CH(I,K,3) = WA2(I-1)*DI3-WA2(I)*DR3   
            CH(I-1,K,4) = WA3(I-1)*DR4+WA3(I)*DI4 
            CH(I,K,4) = WA3(I-1)*DI4-WA3(I)*DR4   
            CH(I-1,K,5) = WA4(I-1)*DR5+WA4(I)*DI5 
            CH(I,K,5) = WA4(I-1)*DI5-WA4(I)*DR5   
  103    CONTINUE   
  104 CONTINUE 
      RETURN   
  105 DO 107 I=2,IDO,2   
CDIR$ IVDEP    
         DO 106 K=1,L1   
            TI5 = CC(I,2,K)-CC(I,5,K)   
            TI2 = CC(I,2,K)+CC(I,5,K)   
            TI4 = CC(I,3,K)-CC(I,4,K)   
            TI3 = CC(I,3,K)+CC(I,4,K)   
            TR5 = CC(I-1,2,K)-CC(I-1,5,K)    
            TR2 = CC(I-1,2,K)+CC(I-1,5,K)    
            TR4 = CC(I-1,3,K)-CC(I-1,4,K)    
            TR3 = CC(I-1,3,K)+CC(I-1,4,K)    
            CH(I-1,K,1) = CC(I-1,1,K)+TR2+TR3
            CH(I,K,1) = CC(I,1,K)+TI2+TI3    
            CR2 = CC(I-1,1,K)+TR11*TR2+TR12*TR3   
            CI2 = CC(I,1,K)+TR11*TI2+TR12*TI3
            CR3 = CC(I-1,1,K)+TR12*TR2+TR11*TR3   
            CI3 = CC(I,1,K)+TR12*TI2+TR11*TI3
            CR5 = TI11*TR5+TI12*TR4
            CI5 = TI11*TI5+TI12*TI4
            CR4 = TI12*TR5-TI11*TR4
            CI4 = TI12*TI5-TI11*TI4
            DR3 = CR3-CI4
            DR4 = CR3+CI4
            DI3 = CI3+CR4
            DI4 = CI3-CR4
            DR5 = CR2+CI5
            DR2 = CR2-CI5
            DI5 = CI2-CR5
            DI2 = CI2+CR5
            CH(I-1,K,2) = WA1(I-1)*DR2+WA1(I)*DI2 
            CH(I,K,2) = WA1(I-1)*DI2-WA1(I)*DR2   
            CH(I-1,K,3) = WA2(I-1)*DR3+WA2(I)*DI3 
            CH(I,K,3) = WA2(I-1)*DI3-WA2(I)*DR3   
            CH(I-1,K,4) = WA3(I-1)*DR4+WA3(I)*DI4 
            CH(I,K,4) = WA3(I-1)*DI4-WA3(I)*DR4   
            CH(I-1,K,5) = WA4(I-1)*DR5+WA4(I)*DI5 
            CH(I,K,5) = WA4(I-1)*DI5-WA4(I)*DR5   
  106    CONTINUE   
  107 CONTINUE 
      RETURN   
      END 
      SUBROUTINE PBDV(V,X,DV,DP,PDF,PDD)
C
C       ====================================================
C       Purpose: Compute parabolic cylinder functions Dv(x)
C                and their derivatives
C       Input:   x --- Argument of Dv(x)
C                v --- Order of Dv(x)
C       Output:  DV(na) --- Dn+v0(x)
C                DP(na) --- Dn+v0'(x)
C                ( na = |n|, v0 = v-n, |v0| < 1, 
C                  n = 0,1,2, )
C                PDF --- Dv(x)
C                PDD --- Dv'(x)
C       Routines called:
C             (1) DVSA for computing Dv(x) for small |x|
C             (2) DVLA for computing Dv(x) for large |x|
C       ====================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        DIMENSION DV(0:*),DP(0:*)
        XA=DABS(X)
        VH=V
        V=V+DSIGN(1.0D0,V)
        NV=INT(V)
        V0=V-NV
        NA=ABS(NV)
        EP=DEXP(-.25D0*X*X)
        IF (NA.GE.1) JA=1
        IF (V.GE.0.0) THEN
           IF (V0.EQ.0.0) THEN
              PD0=EP
              PD1=X*EP
           ELSE
              DO 10 L=0,JA
                 V1=V0+L
                 IF (XA.LE.5.8) CALL DVSA(V1,X,PD1)
                 IF (XA.GT.5.8) CALL DVLA(V1,X,PD1)
                 IF (L.EQ.0) PD0=PD1
10            CONTINUE
           ENDIF
           DV(0)=PD0
           DV(1)=PD1
           DO 15 K=2,NA
              PDF=X*PD1-(K+V0-1.0D0)*PD0
              DV(K)=PDF
              PD0=PD1
15            PD1=PDF
        ELSE
           IF (X.LE.0.0) THEN
              IF (XA.LE.5.8D0)  THEN
                 CALL DVSA(V0,X,PD0)
                 V1=V0-1.0D0
                 CALL DVSA(V1,X,PD1)
              ELSE
                 CALL DVLA(V0,X,PD0)
                 V1=V0-1.0D0
                 CALL DVLA(V1,X,PD1)
              ENDIF
              DV(0)=PD0
              DV(1)=PD1
              DO 20 K=2,NA
                 PD=(-X*PD1+PD0)/(K-1.0D0-V0)
                 DV(K)=PD
                 PD0=PD1
20               PD1=PD
           ELSE IF (X.LE.2.0) THEN
              V2=NV+V0
              IF (NV.EQ.0) V2=V2-1.0D0
              NK=INT(-V2)
              CALL DVSA(V2,X,F1)
              V1=V2+1.0D0
              CALL DVSA(V1,X,F0)
              DV(NK)=F1
              DV(NK-1)=F0
              DO 25 K=NK-2,0,-1
                 F=X*F0+(K-V0+1.0D0)*F1
                 DV(K)=F
                 F1=F0
25               F0=F
           ELSE
              IF (XA.LE.5.8) CALL DVSA(V0,X,PD0)
              IF (XA.GT.5.8) CALL DVLA(V0,X,PD0)
              DV(0)=PD0
              M=100+NA
              F1=0.0D0
              F0=1.0D-30
              DO 30 K=M,0,-1
                 F=X*F0+(K-V0+1.0D0)*F1
                 IF (K.LE.NA) DV(K)=F
                 F1=F0
30               F0=F
              S0=PD0/F
              DO 35 K=0,NA
35               DV(K)=S0*DV(K)
           ENDIF
        ENDIF
        DO 40 K=0,NA-1
           V1=ABS(V0)+K
           IF (V.GE.0.0D0) THEN
              DP(K)=0.5D0*X*DV(K)-DV(K+1)
           ELSE
              DP(K)=-0.5D0*X*DV(K)-V1*DV(K+1)
           ENDIF
40      CONTINUE
        PDF=DV(NA-1)
        PDD=DP(NA-1)
        V=VH
        RETURN
        END
      SUBROUTINE PBNCOR(X,Y,N,IWRITE,XTEMP1,XTEMP2,MAXNXT,PBCORR,BETA,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE PERCENTAGE BEND CORRELATION
C              OF THE DATA IN THE INPUT VECTORS X AND Y.
C              THIS IS A ROBUST MEASURE OF SCALE DESCRIBED IN
C              "INTRODUCTION TO ROBUST ESTIMATION AND HYPOTHESIS
C              TESTING", RAND R. WILCOX, ACADEMIC PRESS, 1997.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --Y      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--PBCORR = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE PERCENTAGE BEND
C                                CORRELATION.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PERCENTAGE BEND CORRELATION (WITH DENOMINATOR N-1).
C     OTHER DATAPAC   SUBROUTINES NEEDED--MEDIAN AND SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--"INTRODUCTION TO ROBUST ESTIMATION AND HYPOTHESIS
C                 TESTING", RAND R. WILCOX, ACADEMIC PRESS, 1997.
C                 COMPUTATIONAL STEPS DESCRIBED IN THIS REFERENCE.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2002/7
C     ORIGINAL VERSION--JULY      2002.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRIT2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DTERM5
      DOUBLE PRECISION DTERM6
C
      DIMENSION X(*)
      DIMENSION Y(*)
      DIMENSION XTEMP1(*)
      DIMENSION XTEMP2(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NCOR'
      ISUBN2='    '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF PBNCOR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I),Y(I)
   56 FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN PBNCOR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE PERCENTAGE BEND CORRELATION IS TO BE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      COMPUTED, MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,121)
  121 FORMAT('***** NON-FATAL DIAGNOSTIC IN PBNCOR--',
     1'THE SECOND INPUT ARGUMENT (N) HAS THE VALUE 1')
      CALL DPWRST('XXX','BUG ')
      PBCORR=0.0
      GOTO9000
  129 CONTINUE
C
  190 CONTINUE
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  COMPUTE THE PERCENTAGE BEND CORRELATION.   **
C               *************************************************
C
      IWRIT2='OFF'
C
      CALL MEDIAN(X,N,IWRIT2,XTEMP1,MAXNXT,XMED,IBUGA3,IERROR)
      CALL MEDIAN(Y,N,IWRIT2,XTEMP1,MAXNXT,YMED,IBUGA3,IERROR)
C
      DO300I=1,N
        XTEMP1(I)=ABS(X(I)-XMED)
        XTEMP2(I)=ABS(Y(I)-YMED)
  300 CONTINUE
C
      IF(BETA.LE.0.01 .OR. BETA.GT.0.99)THEN
        WRITE(ICOUT,121)
  321   FORMAT('***** NON-FATAL DIAGNOSTIC IN PBNCOR--',
     1         'THE VALUE OF BETA OUTSIDE THE (0.01,0.99) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,323)
  323   FORMAT('      DEFAULT VALUE OF 0.1 USED.')
        CALL DPWRST('XXX','BUG ')
        BETA=0.1
      ENDIF
C
      CALL SORT(XTEMP1,N,XTEMP1)
      CALL SORT(XTEMP2,N,XTEMP2)
C
      AN=REAL(N)
      AM=(1.0 - BETA)*AN + 0.5
      M=INT(AM)
      WBETAX=XTEMP1(M)
      WBETAY=XTEMP2(M)
C
      I1=0
      I2=0
      I3=0
      I6=0
      I7=0
      I8=0
      DTERM1=0.0D0
      DTERM6=0.0D0
      DO400I=1,N
        IF(ABS((X(I)-XMED)/WBETAX).LE.1.0)THEN
          DTERM1=DTERM1 + X(I)
          I3=I3 + 1
        ELSEIF((X(I)-XMED)/WBETAX.LT.-1.0)THEN
          I1=I1 + 1
        ELSEIF((X(I)-XMED)/WBETAX.GT.1.0)THEN
          I2=I2 + 1
        ENDIF
C
        IF(ABS((Y(I)-YMED)/WBETAY).LE.1.0)THEN
          DTERM6=DTERM6 + Y(I)
          I8=I8+1
        ELSEIF((Y(I)-YMED)/WBETAY.LT.-1.0)THEN
          I6=I6 + 1
        ELSEIF((Y(I)-YMED)/WBETAY.GT.1.0)THEN
          I7=I7 + 1
        ENDIF
  400 CONTINUE
      PHIX=(WBETAX*REAL(I2-I1) + REAL(DTERM1))/REAL(N - I1 - I2)
      PHIY=(WBETAY*REAL(I7-I6) + REAL(DTERM6))/REAL(N - I6 - I7)
C
      DTERM1=0.0D0
      DTERM2=0.0D0
      DTERM3=0.0D0
      DO500I=1,N
        UI=(X(I) - PHIX)/WBETAX
        VI=(Y(I) - PHIY)/WBETAY
        DTERM4=MAX(-1.0D0,MIN(1.0D0,DBLE(UI)))
        DTERM5=MAX(-1.0D0,MIN(1.0D0,DBLE(VI)))
        DTERM1=DTERM1 + DTERM4*DTERM4
        DTERM2=DTERM2 + DTERM5*DTERM5
        DTERM3=DTERM3 + DTERM4*DTERM5
  500 CONTINUE
      DTERM4=0.0D0
      IF(DTERM1*DTERM2.GT.0.0D0)DTERM4=DTERM3/DSQRT(DTERM1*DTERM2)
      PBCORR=REAL(DTERM4)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,PBCORR
  811 FORMAT('THE PERCENTAGE BEND CORRELATION OF THE ',I8,
     1' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF PBNCOR--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)XMED,WBETAX,YMED,WBETAY
 9014 FORMAT('XMED,WBETAX,YMED,WBETAY = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PBCORR
 9015 FORMAT('PBCORR = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)DTERM1,DTERM2,DTERM3,DTERM3
 9016 FORMAT('DTERM1,DTERM2,DTERM3,DTERM3 = ',4D15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9018)I1,I2,I3,I6,I7,I8
 9018 FORMAT('I1,I2,I3,I6,I7,I8 = ',6I8)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE PBNMDV(X,N,IWRITE,XTEMP,MAXNXT,PBMDVA,BETA,
     1                  IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE PERCENTAGE BEND MIDVARIANCE
C              OF THE DATA IN THE INPUT VECTOR X.
C              THIS IS A ROBUST MEASURE OF SCALE DESCRIBED IN
C              "INTRODUCTION TO ROBUST ESTIMATION AND HYPOTHESIS
C              TESTING", RAND R. WILCOX, ACADEMIC PRESS, 1997.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--PBMDVA    = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE PERCENTAGE BEND MIDVARIANCE.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PERCENTAGE BEND MIDVARIANCE (WITH DENOMINATOR N-1).
C     OTHER DATAPAC   SUBROUTINES NEEDED--MEDIAN AND SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--"INTRODUCTION TO ROBUST ESTIMATION AND HYPOTHESIS
C                 TESTING", RAND R. WILCOX, ACADEMIC PRESS, 1997.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2002/7
C     ORIGINAL VERSION--JULY      2002.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRIT2
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
C
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
C
      DIMENSION X(*)
      DIMENSION XTEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='NMDV '
      ISUBN2='    '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF PBNMDV--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IBUGA3
   52 FORMAT('IBUGA3 = ',A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN PBNMDV--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE PERCENTAGE BEND MIDVARIANCE IS TO BE')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      COMPUTED, MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,121)
  121 FORMAT('***** NON-FATAL DIAGNOSTIC IN PBNMDV--',
     1'THE SECOND INPUT ARGUMENT (N) HAS THE VALUE 1')
      CALL DPWRST('XXX','BUG ')
      PBMDVA=0.0
      GOTO9000
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,136)HOLD
  136 FORMAT('***** NON-FATAL DIAGNOSTIC IN PBNMDV--',
     1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      PBMDVA=0.0
      GOTO9000
  139 CONTINUE
C
  190 CONTINUE
C
C               *************************************************
C               **  STEP 2--                                   **
C               **  COMPUTE THE PERCENTAGE BEND MIDVARIANCE.   **
C               *************************************************
C
      IWRIT2='OFF'
      CALL MEDIAN(X,N,IWRIT2,XTEMP,MAXNXT,XMED,IBUGA3,IERROR)
C
      DO300I=1,N
      XTEMP(I)=ABS(X(I)-XMED)
  300 CONTINUE
C
      IF(BETA.LE.0.01 .OR. BETA.GT.0.99)THEN
        WRITE(ICOUT,121)
  321   FORMAT('***** NON-FATAL DIAGNOSTIC IN PBNMDV--',
     1         'THE VALUE OF BETA OUTSIDE THE (0.01,0.99) INTERVAL.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,323)
  323   FORMAT('      DEFAULT VALUE OF 0.1 USED.')
        CALL DPWRST('XXX','BUG ')
        BETA=0.1
      ENDIF
C
      CALL SORT(XTEMP,N,XTEMP)
      AN=REAL(N)
      AM=(1.0 - BETA)*AN + 0.5
      M=INT(AM)
      WBETA=XTEMP(M)
C
      DTERM2=0.0D0
      DO400I=1,N
      X(I)=(X(I) - XMED)/WBETA
      IF(ABS(X(I)).LT.1.0)DTERM2=DTERM2+1.0D0
  400 CONTINUE
      DTERM2=DTERM2*DTERM2
C
      DTERM1=DBLE(WBETA)/DTERM2
      DTERM1=DTERM1*DBLE(WBETA)*DBLE(N)
      DTERM3=0.0D0
      DO500I=1,N
        DTERM4=MAX(-1.0D0,MIN(1.0D0,DBLE(X(I))))
        DTERM3=DTERM3 + DTERM4*DTERM4
  500 CONTINUE
      PBMDVA=REAL(DTERM1*DTERM3)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)N,PBMDVA
  811 FORMAT('THE PERCENTAGE BEND MIDVARIANCE OF THE ',I8,
     1' OBSERVATIONS = ',E15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF PBNMDV--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IBUGA3,IERROR
 9012 FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)XMED,WBETA
 9014 FORMAT('XMED,WBETA = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)PBMDVA
 9015 FORMAT('PBMDVA = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)DTERM1,DTERM2,DTERM3,DTERM4
 9016 FORMAT('DTERM1,DTERM2,DTERM3,DTERM4 = ',4D15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE PBVV(V,X,VV,VP,PVF,PVD)
C
C       ===================================================
C       Purpose: Compute parabolic cylinder functions Vv(x)
C                and their derivatives
C       Input:   x --- Argument of Vv(x)
C                v --- Order of Vv(x)
C       Output:  VV(na) --- Vv(x)
C                VP(na) --- Vv'(x)
C                ( na = |n|, v = n+v0, |v0| < 1
C                  n = 0,1,2, )
C                PVF --- Vv(x)
C                PVD --- Vv'(x)
C       Routines called:
C             (1) VVSA for computing Vv(x) for small |x|
C             (2) VVLA for computing Vv(x) for large |x|
C       ===================================================
C
        IMPLICIT DOUBLE PRECISION (A-H,O-Z)
        DIMENSION VV(0:*),VP(0:*)
        PI=3.141592653589793D0
        XA=DABS(X)
        VH=V
        V=V+DSIGN(1.0D0,V)
        NV=INT(V)
        V0=V-NV
        NA=ABS(NV)
        QE=DEXP(0.25D0*X*X)
        Q2P=DSQRT(2.0D0/PI)
        IF (NA.GE.1) JA=1
        IF (V.LE.0.0) THEN
           IF (V0.EQ.0.0) THEN
              IF (XA.LE.7.5) CALL VVSA(V0,X,PV0)
              IF (XA.GT.7.5) CALL VVLA(V0,X,PV0)
              F0=Q2P*QE
              F1=X*F0
              VV(0)=PV0
              VV(1)=F0
              VV(2)=F1
           ELSE
              DO 10 L=0,JA
                 V1=V0-L
                 IF (XA.LE.7.5) CALL VVSA(V1,X,F1)
                 IF (XA.GT.7.5) CALL VVLA(V1,X,F1)
                 IF (L.EQ.0) F0=F1
10            CONTINUE
              VV(0)=F0
              VV(1)=F1
           ENDIF
           KV=2
           IF (V0.EQ.0.0) KV=3
           DO 15 K=KV,NA
              F=X*F1+(K-V0-2.0D0)*F0
              VV(K)=F
              F0=F1
15            F1=F
        ELSE
           IF (X.GE.0.0.AND.X.LE.7.5D0) THEN
              V2=V
              IF (V2.LT.1.0) V2=V2+1.0D0
              CALL VVSA(V2,X,F1)
              V1=V2-1.0D0
              KV=INT(V2)
              CALL VVSA(V1,X,F0)
              VV(KV)=F1
              VV(KV-1)=F0
              DO 20 K=KV-2,0,-1
                 F=X*F0-(K+V0+2.0D0)*F1
                 IF (K.LE.NA) VV(K)=F
                 F1=F0
20               F0=F
           ELSE IF (X.GT.7.5D0) THEN
              CALL VVLA(V0,X,PV0)
              M=100+ABS(NA)
              VV(1)=PV0
              F1=0.0D0
              F0=1.0D-40
              DO 25 K=M,0,-1
                 F=X*F0-(K+V0+2.0D0)*F1
                 IF (K.LE.NA) VV(K)=F
                 F1=F0
25               F0=F
              S0=PV0/F
              DO 30 K=0,NA
30               VV(K)=S0*VV(K)
           ELSE
              IF (XA.LE.7.5D0) THEN
                 CALL VVSA(V0,X,F0)
                 V1=V0+1.0
                 CALL VVSA(V1,X,F1)
              ELSE
                 CALL VVLA(V0,X,F0)
                 V1=V0+1.0D0
                 CALL VVLA(V1,X,F1)
              ENDIF
              VV(0)=F0
              VV(1)=F1
              DO 35 K=2,NA
                 F=(X*F1-F0)/(K+V0)
                 VV(K)=F
                 F0=F1
35               F1=F
           ENDIF
        ENDIF
        DO 40 K=0,NA-1
           V1=V0+K
           IF (V.GE.0.0D0) THEN
              VP(K)=0.5D0*X*VV(K)-(V1+1.0D0)*VV(K+1)
           ELSE
              VP(K)=-0.5D0*X*VV(K)+VV(K+1)
           ENDIF
40      CONTINUE
        PVF=VV(NA-1)
        PVD=VP(NA-1)
        V=VH
        RETURN
        END
        SUBROUTINE PBWA(A,X,W1F,W1D,W2F,W2D)
C
C       ======================================================
C       Purpose: Compute parabolic cylinder functions W(a,x)
C                and their derivatives
C       Input  : a --- Parameter  ( 0  |a|  5 )
C                x --- Argument of W(a,x)  ( 0  |x|  5 )
C       Output : W1F --- W(a,x)
C                W1D --- W'(a,x)
C                W2F --- W(a,-x)
C                W2D --- W'(a,-x)
C       Routine called:
C               CGAMA for computing complex gamma function
C       ======================================================
C
        IMPLICIT DOUBLE PRECISION (A,B,D-H,O-Y)
CCCCC   IMPLICIT COMPLEX *16 (C,Z)
        DIMENSION H(100),D(100)
        EPS=1.0D-15
        P0=0.59460355750136D0
        IF (A.EQ.0.0D0) THEN
           G1=3.625609908222D0
           G2=1.225416702465D0
        ELSE
           X1=0.25D0
           Y1=0.5D0*A
           CALL CGAMA(X1,Y1,1,UGR,UGI)
           G1=DSQRT(UGR*UGR+UGI*UGI)
           X2=0.75D0
           CALL CGAMA(X2,Y1,1,VGR,VGI)
           G2=DSQRT(VGR*VGR+VGI*VGI)
        ENDIF
        F1=DSQRT(G1/G2)
        F2=DSQRT(2.0D0*G2/G1)
        H0=1.0D0
        H1=A
        H(1)=A
        DO 10 L1=4,200,2
           M=L1/2
           HL=A*H1-0.25D0*(L1-2.0D0)*(L1-3.0D0)*H0
           H(M)=HL
           H0=H1
10         H1=HL
        Y1F=1.0D0
        R=1.0D0
        DO 15 K=1,100
           R=0.5D0*R*X*X/(K*(2.0D0*K-1.0D0))
           R1=H(K)*R
           Y1F=Y1F+R1
           IF (DABS(R1/Y1F).LE.EPS.AND.K.GT.30) GO TO 20
15      CONTINUE
20      Y1D=A
        R=1.0D0
        DO 25 K=1,100
           R=0.5D0*R*X*X/(K*(2.0D0*K+1.0D0))
           R1=H(K+1)*R
           Y1D=Y1D+R1
           IF (DABS(R1/Y1D).LE.EPS.AND.K.GT.30) GO TO 30
25      CONTINUE
30      Y1D=X*Y1D
        D1=1.0D0
        D2=A
        D(1)=1.0D0
        D(2)=A
        DO 40 L2=5,160,2
           M=(L2+1)/2
           DL=A*D2-0.25D0*(L2-2.0D0)*(L2-3.0D0)*D1
           D(M)=DL
           D1=D2
40         D2=DL
        Y2F=1.0D0
        R=1.0D0
        DO 45 K=1,100
           R=0.5D0*R*X*X/(K*(2.0D0*K+1.0D0))
           R1=D(K+1)*R
           Y2F=Y2F+R1
           IF (DABS(R1/Y2F).LE.EPS.AND.K.GT.30) GO TO 50
45      CONTINUE
50      Y2F=X*Y2F
        Y2D=1.0D0
        R=1.0D0
        DO 55 K=1,100
           R=0.5D0*R*X*X/(K*(2.0D0*K-1.0D0))
           R1=D(K+1)*R
           Y2D=Y2D+R1
           IF (DABS(R1/Y2D).LE.EPS.AND.K.GT.30) GO TO 60
55      CONTINUE
60      W1F=P0*(F1*Y1F-F2*Y2F)
        W2F=P0*(F1*Y1F+F2*Y2F)
        W1D=P0*(F1*Y1D-F2*Y2D)
        W2D=P0*(F1*Y1D+F2*Y2D)
        RETURN
        END
      DOUBLE PRECISION FUNCTION PDFWAK(X,PARA)
C
C
C  PROBABILITY DENSITY FUNCTION OF THE WAKEBY DISTRIBUTION
C
C  OTHER ROUTINES USED: CDFWAK
C
C  USE THE RELATION (FROM PAGE 46 OF JOHNSON, KOTZ AND
C  BALAKRISHNAN, "CONTINUOUS UNIVARIATE DISTRIBUTIONS: VOLUME 1",
C  SECOND EDITION, WILE, 1994):
C
C     f(X) = [(1 - F(X))**(DELTA+1)*(ALPHA*T + GAMMA)**(-1)
C
C  WHERE
C
C     T = (1 - F(X))**(BETA+DELTA)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(5)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C     XI = LOCATION
C     A  = SCALE (ALPHA)
C     B  = BETA
C     C  = GAMMA
C     D  = DELTA
C
      XI=PARA(1)
      A=PARA(2)
      B=PARA(3)
      C=PARA(4)
      D=PARA(5)
C
C         TEST FOR VALID PARAMETERS
C
      IF(B+D.LE.ZERO.AND.(B.NE.ZERO.OR.C.NE.ZERO.OR.D.NE.ZERO))GOTO 1000
      IF(A.EQ.ZERO.AND.B.NE.ZERO)GOTO 1000
      IF(C.EQ.ZERO.AND.D.NE.ZERO)GOTO 1000
      IF(C.LT.ZERO.OR.A+C.LT.ZERO)GOTO 1000
      IF(A.EQ.ZERO.AND.C.EQ.ZERO)GOTO 1000
C
      DTERM1=CDFWAK(X,PARA)
      DT=(1.0D0 - DTERM1)**(B+D)
      DTERM2=(1.0D0 - DTERM1)**(D+1.0D0)
      DTERM3=A*DT + C
      PDFWAK=DTERM2/DTERM3
      GOTO9000
C
 1000 CONTINUE
      WRITE(ICOUT,7000)
 7000 FORMAT('***** ERROR IN WAKCDF--PARAMETERS INVALID.')
      CALL DPWRST('XXX','WRIT')
      PDFWAK=0.0D0
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PE3CDF(DX,DGAMMA,DMU,DSIGMA,DCDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DENSITY
C              FUNCTION VALUE FOR THE PEARSON TYPE 3 DISTRIBUTION
C              WITH SHAPE PARAMETERS GAMMA.
C
C              FOR GAMMA > 0, THE CDF FOR THE DISTRIBUTION IS
C
C                 F(X;GAMMA,MU,SIGMA) = G(ALPHA,(X-XI)/BETA)/G(ALPHA)
C                                       XI <= X < INFINITY
C                         
C              FOR GAMMA < 0, THE CDF FOR THE DISTRIBUTION IS
C
C                 F(X;GAMMA,MU,SIGMA) = 1 - G(ALPHA,(XI-XI)/BETA)/
C                                       G(ALPHA)
C                                       -INFINITY < X <= XI
C                         
C              FOR GAMMA = 0, THE PEARSON TYPE 3 IS EQUIVALENT
C              TO THE NORMAL DISTRIBUTION.
C
C              WHERE
C
C                 ALPHA = 4/GAMMA**2
C                 BETA  = 0.5*SIGMA*|GAMMA|
C                 XI    = MU - 2*SIGMA/GAMMA
C                 G(x)  = GAMMA FUNCTION
C                 G(A,X) = INCOMPLETE GAMMA FUNCTION
C          
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --DGAMMA = THE FIRST SHAPE PARAMETER
C                     --DMU    = THE LOCATION PARAMETER
C                     --DSIGMA = THE SCALE PARAMETER
C     OUTPUT ARGUMENTS--DCDF   = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF FOR THE PEARSON TYPE 3 DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--RANGE OF X DEPENDENT ON GAMMA
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--HOSKING AND WALLIS (1997), "REGIONAL FREQUENCY
C                 ANALYSIS: AN APPROACH BASED ON L-MOMENTS",
C                 CAMBRIDGE UNVERSITY PRESS, PP. 200-202.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/5
C     ORIGINAL VERSION--MAY       2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DGAMMA
      DOUBLE PRECISION DMU
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DXI
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION CDFPE3
      EXTERNAL CDFPE3
C
      DOUBLE PRECISION PARA(3)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DXI=DMU - 2.0D0*DSIGMA/DGAMMA
C
      IF(DSIGMA.LE.0.0D0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DSIGMA
        CALL DPWRST('XXX','BUG ')
        DCDF=0.0D0
        GOTO9999
   25 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PE3CDF ',
     1       '(THE SCALE PARAMETER) IS NON-POSITIVE')
C
      ELSEIF(DGAMMA.GT.0.0D0 .AND. DX.LT.DXI)THEN
CCCCC   WRITE(ICOUT,5)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,6)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,46)DX
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,7)DXI
CCCCC   CALL DPWRST('XXX','BUG ')
        DCDF=0.0D0
        GOTO9999
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3CDF IS ',
     1       '< MU - 2*SIGMA/GAMMA')
    6 FORMAT('      WHEN THE SHAPE PARAMETER (GAMMA) IS POSITIVE.')
    7 FORMAT('      THE VALUE OF MU - 2*SIGMA/GAMMA IS ',G15.7)
C
      ELSEIF(DGAMMA.LT.0.0D0 .AND. DX.GT.DXI)THEN
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,16)
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,46)DX
CCCCC   CALL DPWRST('XXX','BUG ')
CCCCC   WRITE(ICOUT,17)DXI
CCCCC   CALL DPWRST('XXX','BUG ')
        DCDF=1.0D0
        GOTO9999
      ENDIF
   15 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3CDF IS ',
     1       '> MU - 2*SIGMA/GAMMA')
   16 FORMAT('      WHEN THE SHAPE PARAMETER (GAMMA) IS NEGATIVE.')
   17 FORMAT('      THE VALUE OF MU - 2*SIGMA/GAMMA IS ',G15.7)
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
      PARA(1)=DMU
      PARA(2)=DSIGMA
      PARA(3)=DGAMMA
      DCDF=CDFPE3(DX,PARA)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PE3ML1(Y,N,
     1                  DTEMP1,XMOM,NMOM,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,
     1                  ALOCML,SCALML,SHAPML,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE L-MOMENTS ESTIMATES FOR THE
C              PEARSON TYPE 3 DISTRIBUTION FOR THE RAW DATA CASE (I.E.,
C              NO CENSORING AND NO GROUPING).  THIS ROUTINE RETURNS ONLY
C              THE POINT ESTIMATES.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLP3 WILL GENERATE THE OUTPUT
C              FOR THE PEARSON TYPE 3 MLE COMMAND).
C
C     REFERENCE--FORTRAN CODE WRITTEN FOR INCLUSION IN IBM
C                RESEARCH REPORT RC20525, 'FORTRAN ROUTINES FOR
C                USE WITH THE METHOD OF L-MOMENTS, VERSION 3',
C                J. R. M. HOSKING, IBM RESEARCH DIVISION,
C                T. J. WATSON RESEARCH CENTER, YORKTOWN HEIGHTS
C                NEW YORK 10598, U.S.A., VERSION 3     AUGUST 1996
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLP3)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DOUBLE PRECISION DTEMP1(*)
      DOUBLE PRECISION XMOM(*)
      DOUBLE PRECISION XPAR(3)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PE3M'
      ISUBN2='L1  '
C
      IERROR='NO'
      IWRITE='NO'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'3ML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF PE3ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               *******************************************
C               **  STEP 2--                             **
C               **  CARRY OUT CALCULATIONS               **
C               **  FOR PEARSON TYPE 3 MLE ESTIMATE      **
C               *******************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'3ML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='PEARSON TYPE 3'
      ALOCML=CPUMIN
      SCALML=CPUMIN
      SHAPML=CPUMIN
C
      IFLAG=0
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
C
      CALL SORT(Y,N,Y)
      NMOM=3
      DO2110I=1,N
        DTEMP1(I)=DBLE(Y(I))
 2110 CONTINUE
      CALL SAMLMU(DTEMP1,N,XMOM,NMOM)
      CALL PELPE3(XMOM,XPAR,IFAIL)
C
      IF(IFAIL.EQ.1)GOTO9000
C
      ALOCML=REAL(XPAR(1))
      SCALML=REAL(XPAR(2))
      SHAPML=REAL(XPAR(3))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'3ML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF PE3ML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9015)XMOM(1),XMOM(2),XMOM(3)
 9015   FORMAT('XMOM(1),XMOM(2),XMOM(3) = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9016)XPAR(1),XPAR(2),XPAR(3)
 9016   FORMAT('XPAR(1),XPAR(2),XPAR(3) = ',3G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)SHAPML,SCALML,ALOCML
 9017   FORMAT('SHAPML,SCALML,ALOCML =  ',3G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PE3PDF(DX,DGAMMA,DMU,DSIGMA,DPDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE PEARSON TYPE 3 DISTRIBUTION
C              WITH SHAPE PARAMETERS GAMMA.
C
C              FOR GAMMA > 0, THE PDF FOR THE DISTRIBUTION IS
C
C                 f(X;GAMMA,MU,SIGMA) = (X-XI)**(ALPHA-1)*EXP(-(X-XI)/BETA)/
C                                       {BETA**ALPHA*G(ALPHA}
C                                       XI <= X < INFINITY
C                         
C              FOR GAMMA < 0, THE PDF FOR THE DISTRIBUTION IS
C
C                 f(X;GAMMA,MU,SIGMA) = (XI-X)**(ALPHA-1)*EXP(-(XI-X)/BETA)/
C                                       {BETA**ALPHA*G(ALPHA}
C                                       -INFINITY < X <= XI
C                         
C              FOR GAMMA = 0, THE PEARSON TYPE 3 IS EQUIVALENT
C              TO THE NORMAL DISTRIBUTION.
C
C              WHERE
C
C                 ALPHA = 4/GAMMA**2
C                 BETA  = 0.5*SIGMA*|GAMMA|
C                 XI    = MU - 2*SIGMA/GAMMA
C                 G(x)  = GAMMA FUNCTION
C                 G(A,X) = INCOMPLETE GAMMA FUNCTION
C          
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --DGAMMA = THE FIRST SHAPE PARAMETER
C                     --DMU    = THE LOCATION PARAMETER
C                     --DSIGMA = THE SCALE PARAMETER
C     OUTPUT ARGUMENTS--DPDF   = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE PDF FOR THE PEARSON TYPE 3 DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--RANGE OF X DEPENDENT ON GAMMA
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--HOSKING AND WALLIS (1997), "REGIONAL FREQUENCY
C                 ANALYSIS: AN APPROACH BASED ON L-MOMENTS",
C                 CAMBRIDGE UNVERSITY PRESS, PP. 200-202.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/5
C     ORIGINAL VERSION--MAY       2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DGAMMA
      DOUBLE PRECISION DMU
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DXI
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
      DOUBLE PRECISION DTERM3
      DOUBLE PRECISION DTERM4
      DOUBLE PRECISION DLGAMA
      DOUBLE PRECISION DEPS
      EXTERNAL DLGAMA
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DEPS=1.0D-7
      DXI=DMU - 2.0D0*DSIGMA/DGAMMA
      IF(DGAMMA.GT.0.0D0)THEN
        IF(DABS(DX-DXI).LE.DEPS)DX=DXI+DEPS
      ELSEIF(DGAMMA.LT.0.0D0)THEN
        IF(DABS(DX-DXI).LE.DEPS)DX=DXI-DEPS
      ENDIF
      DBETA=0.5D0*DSIGMA*DABS(DGAMMA)
      DALPHA=4.0D0/DGAMMA**2
      DPDF=0.0D0
C
      IF(DSIGMA.LE.0.0D0)THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DSIGMA
        CALL DPWRST('XXX','BUG ')
        GOTO9999
   25   FORMAT('***** ERROR--THE THIRD ARGUMENT TO PE3PDF ',
     1       '(THE SCALE PARAMETER) IS NON-POSITIVE')
C
      ELSEIF(DGAMMA.GT.0.0D0 .AND. DX.LT.DXI)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,7)DXI
        CALL DPWRST('XXX','BUG ')
        GOTO9999
    5   FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3PDF IS ',
     1         '< MU - 2*SIGMA/GAMMA')
    6   FORMAT('      WHEN THE SHAPE PARAMETER (GAMMA) IS POSITIVE.')
    7   FORMAT('      THE VALUE OF MU - 2*SIGMA/GAMMA IS ',G15.7)
C
      ELSEIF(DGAMMA.LT.0.0D0 .AND. DX.GT.DXI)THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,16)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,17)DXI
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
   15 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3PDF IS ',
     1       '> MU - 2*SIGMA/GAMMA')
   16 FORMAT('      WHEN THE SHAPE PARAMETER (GAMMA) IS NEGATIVE.')
   17 FORMAT('      THE VALUE OF MU - 2*SIGMA/GAMMA IS ',G15.7)
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
      IF(DGAMMA.EQ.0.0D0)THEN
        DTERM1=(DX-DMU)/DSIGMA
        CALL NODPDF(DTERM1,DTERM2)
        DPDF=DTERM2/DSIGMA
      ELSEIF(DGAMMA.GT.0.0D0)THEN
        DTERM1=(DALPHA-1.0D0)*DLOG(DX-DXI)
        DTERM2=-(DX-DXI)/DBETA
        DTERM3=DALPHA*DLOG(DBETA)
        DTERM4=DLGAMA(DALPHA)
        DPDF=DTERM1 + DTERM2 - DTERM3 - DTERM4
        DPDF=DEXP(DPDF)
      ELSEIF(DGAMMA.LT.0.0D0)THEN
        DTERM1=(DALPHA-1.0D0)*DLOG(DXI-DX)
        DTERM2=-(DXI-DX)/DBETA
        DTERM3=DALPHA*DLOG(DBETA)
        DTERM4=DLGAMA(DALPHA)
        DPDF=DTERM1 + DTERM2 - DTERM3 - DTERM4
        DPDF=DEXP(DPDF)
      ENDIF
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PE3PPF(DP,DGAMMA,DMU,DSIGMA,DPPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE PEARSON TYPE 3 DISTRIBUTION
C              WITH SHAPE PARAMETERS GAMMA.
C
C              FOR GAMMA > 0, THE CDF FOR THE DISTRIBUTION IS
C
C                 F(X;GAMMA,MU,SIGMA) = G(ALPHA,(X-XI)/BETA)/G(ALPHA)
C                                       XI <= X < INFINITY
C                         
C              FOR GAMMA < 0, THE CDF FOR THE DISTRIBUTION IS
C
C                 F(X;GAMMA,MU,SIGMA) = 1 - G(ALPHA,(XI-XI)/BETA)/
C                                       G(ALPHA)
C                                       -INFINITY < X <= XI
C                         
C              FOR GAMMA = 0, THE PEARSON TYPE 3 IS EQUIVALENT
C              TO THE NORMAL DISTRIBUTION.
C
C              WHERE
C
C                 ALPHA = 4/GAMMA**2
C                 BETA  = 0.5*SIGMA*|GAMMA|
C                 XI    = MU - 2*SIGMA/GAMMA
C                 G(x)  = GAMMA FUNCTION
C                 G(A,X) = INCOMPLETE GAMMA FUNCTION
C          
C              THE PERCENT POINT FUNCTION IS COMPUTED BY
C              NUMERICALLY INVERTING THE CDF FUNCTION.
C
C     INPUT  ARGUMENTS--DP     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     --DGAMMA = THE SHAPE PARAMETER
C                     --DMU    = THE LOCATION PARAMETER
C                     --DSIGMA = THE SCALE PARAMETER
C     OUTPUT ARGUMENTS--DPPF   = THE DOUBLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUE
C             PPF FOR THE PEARSON TYPE 3 DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--0 < P < 1
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--HOSKING AND WALLIS (1997), "REGIONAL FREQUENCY
C                 ANALYSIS: AN APPROACH BASED ON L-MOMENTS",
C                 CAMBRIDGE UNVERSITY PRESS, PP. 200-202.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008/5
C     ORIGINAL VERSION--MAY       2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DP
      DOUBLE PRECISION DGAMMA
      DOUBLE PRECISION DMU
      DOUBLE PRECISION DSIGMA
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION QUAPE3
      EXTERNAL QUAPE3
C
      DOUBLE PRECISION PARA(3)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----DATA STATEMENTS-------------------------------------------------
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(DGAMMA.GT.0.0D0 .AND.
     1   (DP.LT.0.0D0 .OR. DP.GE.1.0D0))THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3PPF IS ',
     1       'OUTSIDE THE (0,1] INTERVAL')
C
      ELSEIF(DGAMMA.LT.0.0D0 .AND.
     1   (DP.LE.0.0D0 .OR. DP.GT.1.0D0))THEN
        WRITE(ICOUT,15)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
   15 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3PPF IS ',
     1       'OUTSIDE THE [0,1) INTERVAL')
C
      ELSEIF(DGAMMA.EQ.0.0D0 .AND.
     1   (DP.LE.0.0D0 .OR. DP.GE.1.0D0))THEN
        WRITE(ICOUT,25)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
   25 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PE3PPF IS ',
     1       'OUTSIDE THE (0,1) INTERVAL')
C
      ELSEIF(DSIGMA.LE.0.0D0)THEN
        WRITE(ICOUT,35)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)DSIGMA
        CALL DPWRST('XXX','BUG ')
        DPPF=0.0D0
        GOTO9999
   35 FORMAT('***** ERROR--THE THIRD ARGUMENT TO PE3PPF ',
     1       '(THE SCALE PARAMETER) IS NON-POSITIVE')
      ENDIF
C
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',E15.8,' *****')
C
      PARA(1)=DMU
      PARA(2)=DSIGMA
      PARA(3)=DGAMMA
      DPPF=QUAPE3(DP,PARA)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PE3RAN(N,GAMMA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE PEARSON TYPE 3 DISTRIBUTION WITH SHAPE
C              PARAMETER GAMMA.
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE GENERATED.
C                     --GAMMA  = THE SINGLE PRECISION VALUE OF THE
C                                SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N FROM THE PEARSON TYPE 3
C             DISTRIBUTION WITH SHAPE PARAMETER GAMMA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, QUAPE3.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2008.5
C     ORIGINAL VERSION--MAY       2008.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION QUAPE3
      DOUBLE PRECISION PARA(3)
C
      EXTERNAL QUAPE3
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9999
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF PEARSON TYPE 3 ',
     1       'RANDOM NUMBERS IS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N PEARSON TYPE 3 DISTRIBUTION RANDOM NUMBERS USING
C     THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      PARA(1)=0.0D0
      PARA(2)=1.0D0
      PARA(3)=DBLE(GAMMA)
C
      DO100I=1,N
        DPPF=QUAPE3(DBLE(X(I)),PARA)
        X(I)=REAL(DPPF)
  100 CONTINUE
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PEARCC(Y1,Y2,N,IWRITE,XIDTEM,XIDTE2,TEMP1,STAT,
     1           IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES PEARSON'S CONTINGENCY
C              COEFFICIENT FOR RXC CONTINGENCY TABLES.  THIS IS
C
C                  SQRT(T/(N+T))
C
C              WHERE
C
C                  T = CHI-SQUARE STATISTIC
C                    = SUM[i=1 to r][SUM[j=1 to c]
C                      [(O(ij)-E(ij))**2/E(ij)]]
C
C                      O = OBSERVED COUNT
C                      E = EXPECTED COUNT
C                        = ROW TOTAL*COL TOTAL/GRAND TOTAL
C
C                  N = TOTAL NUMBER OF OBSERVATIONS
C
C     REFERENCE--CONOVER (1999), "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, WILEY, PP. 231-232.
C     NOTE--THIS SUBROUTINE HANDLES THE RAW DATA CASE.  USE
C           THE COMMAND
C
C               LET A = MATRIX PEARSON CONTINGENCY COEFFICENT M
C
C           IF YOUR DATA CONSISTS OF AN RXC TABLE.
C     INPUT  ARGUMENTS--Y1     = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE FIRST SET
C                                OF DATA.
C                     --Y2     = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED) OBSERVATIONS
C                                WHICH CONSTITUTE THE SECOND SET
C                                OF DATA.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X, OR EQUIVALENTLY,
C                                THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C     OUTPUT ARGUMENTS--STAT   = THE SINGLE PRECISION VALUE OF THE
C                                PEARSON'S CONTINGENCY COEFFICIENT
C                                BETWEEN THE 2 SETS OF DATA
C                                IN THE INPUT VECTORS X AND Y.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PEARSON'S CONTINGENCY COEFFICENT BETWEEN THE
C             2 SETS OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DISTIN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/3
C     ORIGINAL VERSION--MARCH     2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      PARAMETER(MAXLEV=20000)
      PARAMETER(IWORK1=0)
      PARAMETER(IWORK2=20000)
      PARAMETER(IWORK3=40000)
      PARAMETER(IWORK4=60000)
      PARAMETER(IWORK5=80000)
C
      DIMENSION Y1(*)
      DIMENSION Y2(*)
      DIMENSION XIDTEM(*)
      DIMENSION XIDTE2(*)
      DIMENSION TEMP1(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='CRAM'
      ISUBN2='ER  '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF PEARCC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)N
   53   FORMAT('N = ',I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,Y1(I),Y2(I)
   56     FORMAT('I,Y1(I),Y2(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(N.LT.2)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('****** ERROR IN PEARSON CONTINGENCY COEFFICIENT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2101)
 2101   FORMAT('      THE NUMBER OF OBSERVATIONS IS LESS THAN 2.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2103)N
 2103   FORMAT('SAMPLE SIZE = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ******************************************************
C               **  STEP 2.2--                                      **
C               **  DETERMINE THE NUMBER OF DISTINCT VALUES         **
C               **  FOR THE GROUP VARIABLES (Y1, Y2).               **
C               ******************************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      CALL DISTIN(Y1,N,IWRITE,XIDTEM,NUMSE1,IBUGA3,IERROR)
      CALL SORT(XIDTEM,NUMSE1,XIDTEM)
      CALL DISTIN(Y2,N,IWRITE,XIDTE2,NUMSE2,IBUGA3,IERROR)
      CALL SORT(XIDTE2,NUMSE2,XIDTE2)
C
      IF(NUMSE1.LT.1 .OR. NUMSE1.GT.MAXLEV)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2202)MAXLEV
 2202   FORMAT('      NUMBER OF SETS FOR VARIABLE ONE IS OUTSIDE ',
     1         'THE INTERVAL (1,',I8,')')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)NUMSE1
 2204   FORMAT('      THE NUMBER OF SET = ',I10)
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NUMSE2.LT.1 .OR. NUMSE2.GT.MAXLEV)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2212)MAXLEV
 2212   FORMAT('      NUMBER OF SETS FOR VARIABLE TWO IS OUTSIDE ',
     1         'THE INTERVAL (1,',I8,')')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,2204)NUMSE2
        CALL DPWRST('XXX','BUG ')
        IERROR='YES'
        GOTO9000
      ENDIF
C
C               ***********************************************
C               **  STEP 2.3--                               **
C               **  COMPUTE THE CHI-SQUARE STATISTIC         **
C               ***********************************************
C
      ISTEPN='23'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
C     COMPUTE COUNTS FOR EACH CELL
C
      J=0
      DO2310ISET1=1,NUMSE1
        DO2320ISET2=1,NUMSE2
C
          K=0
          DO2330I=1,N
            IF(XIDTEM(ISET1).EQ.Y1(I).AND.XIDTE2(ISET2).EQ.Y2(I))THEN
              K=K+1
            ENDIF
 2330     CONTINUE
          NTEMP=K
          J=J+1
          TEMP1(IWORK1+J)=REAL(K)
          TEMP1(IWORK2+J)=XIDTEM(ISET1)
          TEMP1(IWORK3+J)=XIDTE2(ISET2)
C
 2320   CONTINUE
 2310 CONTINUE
      NTEMP2=J
C
C     COMPUTE ROW AND COLUMN TOTALS AND GRAND TOTAL.
C
      J=0
      GTOTAL=0.0
C
      DO2340ISET1=1,NUMSE1
        TEMP1(IWORK4+ISET1)=0.0
        DO2350ISET2=1,NUMSE2
          J=J+1
          TEMP1(IWORK4+ISET1)=TEMP1(IWORK4+ISET1) + TEMP1(IWORK1+J)
          GTOTAL=GTOTAL + TEMP1(IWORK1+J)
 2350   CONTINUE
C
        IF(IBUGA3.EQ.'ON')THEN
          WRITE(ICOUT,2352)ISET1,TEMP1(IWORK4+ISET1)
 2352     FORMAT('ISET1,ROWTOT(ISET1)=',I5,1X,G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
 2340 CONTINUE
C
      DO2360ISET2=1,NUMSE2
        TEMP1(IWORK5+ISET2)=0.0
        DO2370J=1,NTEMP2
          IF(TEMP1(IWORK3+J).EQ.XIDTE2(ISET2))THEN
            TEMP1(IWORK5+ISET2)=TEMP1(IWORK5+ISET2) + TEMP1(IWORK1+J)
          ENDIF
 2370   CONTINUE
C
        IF(IBUGA3.EQ.'ON')THEN
          WRITE(ICOUT,2372)ISET2,TEMP1(IWORK5+ISET2)
 2372     FORMAT('ISET2,COLTOT(ISET2)=',I5,1X,G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
 2360 CONTINUE
C
C     NOW COMPUTE THE CHI-SQUARE TEST STATISTIC
C
      STAT=0.0
      J=0
C
      DO2380ISET1=1,NUMSE1
        DO2390ISET2=1,NUMSE2
          J=J+1
          EXP=TEMP1(IWORK4+ISET1)*TEMP1(IWORK5+ISET2)/GTOTAL
          STAT=STAT + (TEMP1(IWORK1+J) - EXP)**2/EXP
 2390   CONTINUE
 2380 CONTINUE
      T=STAT
      STAT=STAT/(GTOTAL+T)
      STAT=SQRT(STAT)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)STAT
  811 FORMAT('THE PEARSON CONTINGENCY COEFFICIENT = ',G15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF PEARCC--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)T,GTOTAL,STAT
 9015   FORMAT('T,GTOTAL,STAT = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PEARC2(XMAT,MAXOBV,NR1,NC1,IWRITE,
     1           TEMP1,STAT,
     1           IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES PEARSON'S CONTINGENCY
C              COEFFICIENT FOR RXC CONTINGENCY TABLES.  THIS IS
C
C                  SQRT(T/(N+T))
C
C              WHERE
C
C                  T = CHI-SQUARE STATISTIC
C                    = SUM[i=1 to r][SUM[j=1 to c]
C                      [(O(ij)-E(ij))**2/E(ij)]]
C
C                      O = OBSERVED COUNT
C                      E = EXPECTED COUNT
C                        = ROW TOTAL*COL TOTAL/GRAND TOTAL
C
C                  N = TOTAL NUMBER OF OBSERVATIONS
C
C     REFERENCE--CONOVER (1999), "PRACTICAL NONPARAMETRIC
C                STATISTICS", THIRD EDITION, WILEY, PP. 231-232.
C     NOTE--THIS SUBROUTINE HANDLES THE SUMMARY DATA CASE (I.E..
C           THE DATA IS GIVEN AS AN RXC TABLE).   THE "PEARSON"
C           SUBROUTINE IS USED FOR THE RAW DATA CASE.
C     INPUT  ARGUMENTS--XMAT   = THE SINGLE PRECISION MATRIX OF
C                                OBSERVATIONS (RXC TABLE)
C                     --MAXOBV = THE INTEGER NUMBER THAT SPECIFIES
C                                THE MAXIMUM NUMBER OF ROWS IN THE
C                                MATRIX.
C                     --NR1    = THE INTEGER NUMBER OF ROWS
C                                IN THE MATRIX XMAT.
C                     --NC1    = THE INTEGER NUMBER OF COLUMNS
C                                IN THE MATRIX XMAT.
C     OUTPUT ARGUMENTS--STAT   = THE SINGLE PRECISION VALUE OF THE
C                                PEARSON'S CONTINGENCY COEFFICIENT
C                                OF THE DATA IN THE MATRIX XMAT.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PEARSON'S CONTINGENCY COEFFICENT OF THE DATA
C             IN THE MATRIX XMAT.
C     RESTRICTIONS--THE MAXIMUM NUMBER OF LEVELS IS 50,000.
C     OTHER DATAPAC   SUBROUTINES NEEDED--DISTIN.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTIUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/3
C     ORIGINAL VERSION--MARCH     2007.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISTEPN
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      PARAMETER(MAXLEV=50000)
      PARAMETER(IWORK1=0)
      PARAMETER(IWORK2=50000)
C
      DIMENSION XMAT(MAXOBV,NC1)
      DIMENSION TEMP1(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PEAR'
      ISUBN2='C2  '
C
      IERROR='NO'
C
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF PEARC2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3
   52   FORMAT('IBUGA3 = ',A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)NR1,NC1
   53   FORMAT('N = ',2I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,NR1
          DO60J=1,NC1
            WRITE(ICOUT,56)I,J,XMAT(I,J)
   56       FORMAT('I,J,XMAT(I,J) = ',2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
   60     CONTINUE
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 21--                             **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(NR1.LT.2 .OR. NR1.GT.MAXLEV)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
 1201   FORMAT('****** ERROR IN MATRIX PEARSON CONTINGENCY ',
     1         'COEFFICIENT--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2101)
 2101   FORMAT('      THE NUMBER OF ROWS IN THE MATRIX IS LESS ',
     1         'THAN 2')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2102)MAXLEV
 2102   FORMAT('      OR GREATER THAN ',I10,'.')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2103)NR1
 2103   FORMAT('NUMBER OF ROWS = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      IF(NC1.LT.2 .OR. NC1.GT.MAXLEV)THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,1201)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2111)
 2111   FORMAT('      THE NUMBER OF COLUMNS IN THE MATRIX IS LESS ',
     1         'THAN 2')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2102)MAXLEV
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,2113)NC1
 2113   FORMAT('NUMBER OF COLUMNS = ',I8)
        CALL DPWRST('XXX','WRIT')
        IERROR='YES'
        GOTO9000
      ENDIF
C
      GTOTAL=0.0
      DO2120J=1,NC1
        DO2130I=1,NR1
          ITEMP=INT(XMAT(I,J)+0.5)
          IF(ITEMP.LT.0)THEN
            WRITE(ICOUT,999)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,1201)
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2131)
 2131       FORMAT('      A NEGATIVE COUNT WAS ENCOUNTERED IN THE ',
     1             'INPUT MATRIX.')
            CALL DPWRST('XXX','WRIT')
            WRITE(ICOUT,2133)I,J,ITEMP
 2133       FORMAT('      COUNT FOR ROW ',I8,' COLUMN ',I8,' = ',I8)
            CALL DPWRST('XXX','WRIT')
            IERROR='YES'
            GOTO9000
          ENDIF
          XMAT(I,J)=REAL(ITEMP)
          GTOTAL=GTOTAL + XMAT(I,J)
 2130   CONTINUE
 2120 CONTINUE
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,2344)GTOTAL
 2344   FORMAT('GTOTAL = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               ******************************************************
C               **  STEP 2.2--                                      **
C               **  COMPUTE THE ROW AND COLUMN TOTALS.              **
C               ******************************************************
C
      ISTEPN='22'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      DO2340ISET1=1,NR1
        TEMP1(IWORK1+ISET1)=0.0
        DO2350ISET2=1,NC1
          TEMP1(IWORK1+ISET1)=TEMP1(IWORK1+ISET1) + XMAT(ISET1,ISET2)
          IF(IBUGA3.EQ.'ON')THEN
            WRITE(ICOUT,2342)ISET1,ISET2,XMAT(ISET1,ISET2)
 2342       FORMAT('ISET1,ISET2,XMAT(I,J) =',2I8,G15.7)
            CALL DPWRST('XXX','BUG ')
          ENDIF
 2350   CONTINUE
C
        IF(IBUGA3.EQ.'ON')THEN
          WRITE(ICOUT,2352)ISET1,TEMP1(IWORK1+ISET1)
 2352     FORMAT('ISET1,ROWTOT(ISET1)=',I5,1X,G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
 2340 CONTINUE
C
      DO2360ISET2=1,NC1
        TEMP1(IWORK2+ISET2)=0.0
        DO2370ISET1=1,NR1
          TEMP1(IWORK2+ISET2)=TEMP1(IWORK2+ISET2) + XMAT(ISET1,ISET2)
 2370   CONTINUE
C
        IF(IBUGA3.EQ.'ON')THEN
          WRITE(ICOUT,2372)ISET2,TEMP1(IWORK2+ISET2)
 2372     FORMAT('ISET2,COLTOT(ISET2)=',I5,1X,G15.7)
          CALL DPWRST('XXX','BUG ')
        ENDIF
C
 2360 CONTINUE
C
C               ******************************************************
C               **  STEP 2.3--                                      **
C               **  COMPUTE THE CHI-SQUARE STATISTIC.               **
C               ******************************************************
C
      ISTEPN='23'
      IF(IBUGA3.EQ.'ON')CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      STAT=0.0
C
      DO2380ISET1=1,NR1
        DO2390ISET2=1,NC1
          EXP=TEMP1(IWORK1+ISET1)*TEMP1(IWORK2+ISET2)/GTOTAL
          STAT=STAT + (XMAT(ISET1,ISET2) - EXP)**2/EXP
 2390   CONTINUE
 2380 CONTINUE
      T=STAT
      STAT=STAT/(GTOTAL+STAT)
      STAT=SQRT(STAT)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,811)STAT
  811 FORMAT('THE PEARSON CONTINGENCY COEFFICIENT = ',G15.7)
      CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF PEARC2--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9012)IBUGA3,IERROR
 9012   FORMAT('IBUGA3,IERROR = ',A4,2X,A4)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)T,GTOTAL,STAT
 9015   FORMAT('T,GTOTAL,STAT = ',3G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PELGLO(XMOM,PARA)
C===================================================== PELGLO.FOR
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GENERALIZED LOGISTIC
C  DISTRIBUTION
C
C  PARAMETERS OF ROUTINE:
C  XMOM   * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C                  LAMBDA-2, TAU-3.
C  PARA   *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C                  IN THE ORDER XI, ALPHA, K (LOCATION, SCALE, SHAPE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ZERO/0.0D0/
      DATA ONE/1.0D0/
      DATA PI/3.141592653589793238D0/
C
C         SMALL IS USED TO TEST WHETHER K IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
C
C         ESTIMATE K
C
      G=-XMOM(3)
      IF(XMOM(2).LE.ZERO.OR.DABS(G).GE.ONE)THEN
        WRITE(ICOUT,7000)
 7000   FORMAT('***** ERROR IN GENERALIZED LOGISTIC L-MOMENTS ',
     1         'ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,7005)
 7005   FORMAT('      L-MOMENTS INVALID')
        CALL DPWRST('XXX','WRIT')
        PARA(3)=ZERO
        PARA(2)=ZERO
        PARA(1)=ZERO
        GOTO9000
      ENDIF
C
C         ESTIMATED K EFFECTIVELY ZERO (I.E., USE LOGISTIC RATHER THAN
C         GENERALIZED LOGISTIC)
C
      IF(DABS(G).LE.SMALL)THEN
        PARA(3)=ZERO
        PARA(2)=XMOM(2)
        PARA(1)=XMOM(1)
        GOTO9000
      ENDIF
C
C         ESTIMATE ALPHA, XI
C
      GG=G*PI/DSIN(G*PI)
      A=XMOM(2)/GG
      PARA(1)=XMOM(1)-A*(ONE-GG)/G
      PARA(2)=A
      PARA(3)=G
C
 9000 CONTINUE
      RETURN
      END
C===================================================== PELKAP.FOR
      SUBROUTINE PELKAP(XMOM,PARA,IFAIL)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  PARAMETER ESTIMATION VIA L-MOMENTS FOR THE KAPPA DISTRIBUTION
C
C  PARAMETERS OF ROUTINE:
C  XMOM   * INPUT* ARRAY OF LENGTH 4. CONTAINS THE L-MOMENTS LAMBDA-1,
C                  LAMBDA-2, TAU-3, TAU-4.
C  PARA   *OUTPUT* ARRAY OF LENGTH 4. ON EXIT, CONTAINS THE PARAMETERS
C                  IN THE ORDER XI, ALPHA, K, H.
C  IFAIL  *OUTPUT* FAIL FLAG. ON EXIT, IT IS SET AS FOLLOWS.
C                  0  SUCCESSFUL EXIT
C                  1  L-MOMENTS INVALID
C                  2  (TAU-3, TAU-4) LIES ABOVE THE GENERALIZED-LOGISTIC
C                     LINE (SUGGESTS THAT L-MOMENTS ARE NOT CONSISTENT
C                     WITH ANY KAPPA DISTRIBUTION WITH H.GT.-1)
C                  3  ITERATION FAILED TO CONVERGE
C                  4  UNABLE TO MAKE PROGRESS FROM CURRENT POINT IN
C                     ITERATION
C                  5  ITERATION ENCOUNTERED NUMERICAL DIFFICULTIES -
C                     OVERFLOW WOULD HAVE BEEN LIKELY TO OCCUR
C                  6  ITERATION FOR H AND K CONVERGED, BUT OVERFLOW
C                     WOULD HAVE OCCURRED WHEN CALCULATING XI AND ALPHA
C
C  N.B.  PARAMETERS ARE SOMETIMES NOT UNIQUELY DEFINED BY THE FIRST 4
C  L-MOMENTS. IN SUCH CASES THE ROUTINE GOTO9000S THE SOLUTION FOR WHICH
C  THE H PARAMETER IS LARGEST.
C
C  OTHER ROUTINES USED: DLGAMA,DIGAMD
C
C  NOTE 6/2008: USE DPSI ROUTINE INSTEAD OF DIGAMD.
C
C  THE SHAPE PARAMETERS K AND H ARE ESTIMATED USING NEWTON-RAPHSON
C  ITERATION ON THE RELATIONSHIP BETWEEN (TAU-3,TAU-4) AND (K,H).
C  THE CONVERGENCE CRITERION IS THAT TAU-3 AND TAU-4 CALCULATED FROM
C  THE ESTIMATED VALUES OF K AND H SHOULD DIFFER BY LESS THAN 'EPS'
C  FROM THE VALUES SUPPLIED IN ARRAY XMOM.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(4),PARA(4)
C
      EXTERNAL DPSI
C
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/
      DATA FIVE/5D0/,SIX/6D0/,TWELVE/12D0/,TWENTY/20D0/,THIRTY/30D0/
      DATA P725/0.725D0/,P8/0.8D0/
C
C         EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF N-R ITERATION
C         MAXSR IS THE MAX. NO. OF STEPLENGTH REDUCTIONS PER ITERATION
C         HSTART IS THE STARTING VALUE FOR H
C         BIG IS USED TO INITIALIZE THE CRITERION FUNCTION
C         OFLEXP IS SUCH THAT DEXP(OFLEXP) JUST DOES NOT CAUSE OVERFLOW
C         OFLGAM IS SUCH THAT DEXP(DLGAMA(OFLGAM)) JUST DOES NOT CAUSE
C           OVERFLOW
C
      DATA EPS/1D-6/,MAXIT/20/,MAXSR/10/,HSTART/1.001D0/,BIG/10D0/
      DATA OFLEXP/170D0/,OFLGAM/53D0/
C
      T3=XMOM(3)
      T4=XMOM(4)
      DO 10 I=1,4
        PARA(I)=ZERO
   10 CONTINUE
C
C         TEST FOR FEASIBILITY
C
      IF(XMOM(2).LE.ZERO)GOTO 1000
      IF(DABS(T3).GE.ONE.OR.DABS(T4).GE.ONE)GOTO 1000
      IF(T4.LE.(FIVE*T3*T3-ONE)/FOUR)GOTO 1000
      IF(T4.GE.(FIVE*T3*T3+ONE)/SIX )GOTO 1010
C
C         SET STARTING VALUES FOR N-R ITERATION:
C         G IS CHOSEN TO GIVE THE CORRECT VALUE OF TAU-3 ON THE
C         ASSUMPTION THAT H=1 (I.E. A GENERALIZED PARETO FIT) -
C         BUT H IS ACTUALLY SET TO 1.001 TO AVOID NUMERICAL
C         DIFFICULTIES WHICH CAN SOMETIMES ARISE WHEN H=1 EXACTLY
C
      G=(ONE-THREE*T3)/(ONE+T3)
      H=HSTART
      Z=G+H*P725
      XDIST=BIG
C
C         START OF NEWTON-RAPHSON ITERATION
C
      DO 100 IT=1,MAXIT
C
C         REDUCE STEPLENGTH UNTIL WE ARE NEARER TO THE REQUIRED
C         VALUES OF TAU-3 AND TAU-4 THAN WE WERE AT THE PREVIOUS STEP
C
      DO 40 I=1,MAXSR
C
C         - CALCULATE CURRENT TAU-3 AND TAU-4
C
C           NOTATION:
C           U.    - RATIOS OF GAMMA FUNCTIONS WHICH OCCUR IN THE PWM'S
C                   BETA-SUB-R
C           ALAM. - L-MOMENTS (APART FROM A LOCATION AND SCALE SHIFT)
C           TAU.  - L-MOMENT RATIOS
C
      IF(G.GT.OFLGAM)GOTO 1020
      IF(H.GT.ZERO)GOTO 20
      U1=DEXP(DLGAMA(  -ONE/H-G)-DLGAMA(  -ONE/H+ONE))
      U2=DEXP(DLGAMA(  -TWO/H-G)-DLGAMA(  -TWO/H+ONE))
      U3=DEXP(DLGAMA(-THREE/H-G)-DLGAMA(-THREE/H+ONE))
      U4=DEXP(DLGAMA( -FOUR/H-G)-DLGAMA( -FOUR/H+ONE))
      GOTO 30
   20 U1=DEXP(DLGAMA(  ONE/H)-DLGAMA(  ONE/H+ONE+G))
      U2=DEXP(DLGAMA(  TWO/H)-DLGAMA(  TWO/H+ONE+G))
      U3=DEXP(DLGAMA(THREE/H)-DLGAMA(THREE/H+ONE+G))
      U4=DEXP(DLGAMA( FOUR/H)-DLGAMA( FOUR/H+ONE+G))
   30 CONTINUE
      ALAM2=U1-TWO*U2
      ALAM3=-U1+SIX*U2-SIX*U3
      ALAM4=U1-TWELVE*U2+THIRTY*U3-TWENTY*U4
      IF(ALAM2.EQ.ZERO)GOTO 1020
      TAU3=ALAM3/ALAM2
      TAU4=ALAM4/ALAM2
      E1=TAU3-T3
      E2=TAU4-T4
C
C         - IF NEARER THAN BEFORE, EXIT THIS LOOP
C
      DIST=DMAX1(DABS(E1),DABS(E2))
      IF(DIST.LT.XDIST)GOTO 50
C
C         - OTHERWISE, HALVE THE STEPLENGTH AND TRY AGAIN
C
      DEL1=HALF*DEL1
      DEL2=HALF*DEL2
      G=XG-DEL1
      H=XH-DEL2
   40 CONTINUE
C
C         TOO MANY STEPLENGTH REDUCTIONS
C
      GOTO1050
C
C         TEST FOR CONVERGENCE
C
   50 CONTINUE
      IF(DIST.LT.EPS)GOTO 110
C
C         NOT CONVERGED: CALCULATE NEXT STEP
C
C         NOTATION:
C         U1G  - DERIVATIVE OF U1 W.R.T. G
C         DL2G - DERIVATIVE OF ALAM2 W.R.T. G
C         D..  - MATRIX OF DERIVATIVES OF TAU-3 AND TAU-4 W.R.T. G AND H
C         H..  - INVERSE OF DERIVATIVE MATRIX
C         DEL. - STEPLENGTH
C
      XG=G
      XH=H
      XZ=Z
      XDIST=DIST
      RHH=ONE/(H*H)
      IF(H.GT.ZERO)GOTO 60
      U1G=-U1*DPSI(  -ONE/H-G)
      U2G=-U2*DPSI(  -TWO/H-G)
      U3G=-U3*DPSI(-THREE/H-G)
      U4G=-U4*DPSI( -FOUR/H-G)
      U1H=      RHH*(-U1G-U1*DPSI(  -ONE/H+ONE))
      U2H=  TWO*RHH*(-U2G-U2*DPSI(  -TWO/H+ONE))
      U3H=THREE*RHH*(-U3G-U3*DPSI(-THREE/H+ONE))
      U4H= FOUR*RHH*(-U4G-U4*DPSI( -FOUR/H+ONE))
      GOTO 70
   60 U1G=-U1*DPSI(  ONE/H+ONE+G)
      U2G=-U2*DPSI(  TWO/H+ONE+G)
      U3G=-U3*DPSI(THREE/H+ONE+G)
      U4G=-U4*DPSI( FOUR/H+ONE+G)
      U1H=      RHH*(-U1G-U1*DPSI(  ONE/H))
      U2H=  TWO*RHH*(-U2G-U2*DPSI(  TWO/H))
      U3H=THREE*RHH*(-U3G-U3*DPSI(THREE/H))
      U4H= FOUR*RHH*(-U4G-U4*DPSI( FOUR/H))
   70 CONTINUE
      DL2G=U1G-TWO*U2G
      DL2H=U1H-TWO*U2H
      DL3G=-U1G+SIX*U2G-SIX*U3G
      DL3H=-U1H+SIX*U2H-SIX*U3H
      DL4G=U1G-TWELVE*U2G+THIRTY*U3G-TWENTY*U4G
      DL4H=U1H-TWELVE*U2H+THIRTY*U3H-TWENTY*U4H
      D11=(DL3G-TAU3*DL2G)/ALAM2
      D12=(DL3H-TAU3*DL2H)/ALAM2
      D21=(DL4G-TAU4*DL2G)/ALAM2
      D22=(DL4H-TAU4*DL2H)/ALAM2
      DET=D11*D22-D12*D21
      H11= D22/DET
      H12=-D12/DET
      H21=-D21/DET
      H22= D11/DET
      DEL1=E1*H11+E2*H12
      DEL2=E1*H21+E2*H22
C
C         TAKE NEXT N-R STEP
C
      G=XG-DEL1
      H=XH-DEL2
      Z=G+H*P725
C
C         REDUCE STEP IF G AND H ARE OUTSIDE THE PARAMETER SPACE
C
      FACTOR=ONE
      IF(G.LE.-ONE)FACTOR=P8*(XG+ONE)/DEL1
      IF(H.LE.-ONE)FACTOR=DMIN1(FACTOR,P8*(XH+ONE)/DEL2)
      IF(Z.LE.-ONE)FACTOR=DMIN1(FACTOR,P8*(XZ+ONE)/(XZ-Z))
      IF(H.LE.ZERO.AND.G*H.LE.-ONE)
     *  FACTOR=DMIN1(FACTOR,P8*(XG*XH+ONE)/(XG*XH-G*H))
      IF(FACTOR.EQ.ONE)GOTO 80
      DEL1=DEL1*FACTOR
      DEL2=DEL2*FACTOR
      G=XG-DEL1
      H=XH-DEL2
      Z=G+H*P725
   80 CONTINUE
C
C         END OF NEWTON-RAPHSON ITERATION
C
  100 CONTINUE
C
C         NOT CONVERGED
C
      GOTO1040
C
C         CONVERGED
C
  110 IFAIL=0
      PARA(4)=H
      PARA(3)=G
      TEMP=DLGAMA(ONE+G)
      IF(TEMP.GT.OFLEXP)GOTO 1030
      GAM=DEXP(TEMP)
      TEMP=(ONE+G)*DLOG(DABS(H))
      IF(TEMP.GT.OFLEXP)GOTO 1030
      HH=DEXP(TEMP)
      PARA(2)=XMOM(2)*G*HH/(ALAM2*GAM)
      PARA(1)=XMOM(1)-PARA(2)/G*(ONE-GAM*U1/HH)
      GOTO9000
C
 1000 CONTINUE
      IFAIL=1
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
 1001 FORMAT('**** ERROR IN KAPPA L-MOMENTS ESTIMATION--')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1003)
 1003 FORMAT('     THE L-MOMENTS ARE INVALID')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 1010 CONTINUE
      IFAIL=2
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1013)
 1013 FORMAT('     (TAU-3, TAU-4) LIES ABOVE THE GENERALIZED ',
     1       'LOGISTIC LINE.')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1014)
 1014 FORMAT('     THIS SUGGEST THAT THE L-MOMENTS ARE NOT CONSISTENT',
     1       ' WITH ANY KAPPA')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1015)
 1015 FORMAT('     DISTRIBUTION WITH H GREATER THAN -1.')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 1020 CONTINUE
      IFAIL=5
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1023)
 1023 FORMAT('     THE ITERATION ENCOUNTERED NUMERICAL DIFFICULTIIES.')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1024)
 1024 FORMAT('     OVERFLOW WOULD HAVE BEEN LIKELY TO OCCUR.')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
C                  6  ITERATION FOR H AND K CONVERGED, BUT OVERFLOW
C                     WOULD HAVE OCCURRED WHEN CALCULATING XI AND ALPHA
 1030 CONTINUE
      IFAIL=6
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1033)
 1033 FORMAT('     THE ITERATION FOR H AND K CONVERGED, BUT OVERFLOW')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1034)
 1034 FORMAT('     WOULD HAVE OCCURRED WHEN CALCULATING THE ',
     1       'LOCATION AND SCALE ESTIMATES.')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 1040 CONTINUE
      IFAIL=3
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1043)
 1043 FORMAT('     THE L-MOMENTS ESTIMATION FAILED TO CONVERGE.')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 1050 CONTINUE
      IFAIL=4
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1001)
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1053)
 1053 FORMAT('     THE L-MOMENTS ESTIMATION IS UNABLE TO MAKE PROGRESS')
      CALL DPWRST('XXX','WRIT')
      WRITE(ICOUT,1054)
 1054 FORMAT('     FROM THE CURRENT POINT IN THE ITERATION.')
      CALL DPWRST('XXX','WRIT')
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
C===================================================== PELPE3.FOR
      SUBROUTINE PELPE3(XMOM,PARA,IFAIL)
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  PARAMETER ESTIMATION VIA L-MOMENTS FOR THE PEARSON TYPE 3 DISTRIBUTION
C
C  PARAMETERS OF ROUTINE:
C  XMOM   * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C                  LAMBDA-2 AND TAU-3.
C  PARA   *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C                  IN THE ORDER MU, SIGMA, GAMMA (MEAN, S.D., SKEWNESS).
C
C  OTHER ROUTINES USED: DLGAMA
C
C  METHOD: RATIONAL APPROXIMATION IS USED TO EXPRESS ALPHA, THE SHAPE
C  PARAMETER OF THE GAMMA DISTRIBUTION, AS A FUNCTION OF TAU-3.
C  RELATIVE ACCURACY OF THE APPROXIMATION IS BETTER THAN 3E-5.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      EXTERNAL DLGAMA
C
      REAL CPUMIN
      REAL CPUMAX
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ZERO/0D0/,THIRD/0.33333333D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/
C
C         SMALL IS USED TO TEST WHETHER SKEWNESS IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
C
C         CONSTANTS USED IN MINIMAX APPROXIMATIONS
C
      DATA C1,C2,C3/ 0.2906D0,  0.1882D0,  0.0442D0/
      DATA D1,D2,D3/ 0.36067D0,-0.59567D0, 0.25361D0/
      DATA D4,D5,D6/-2.78861D0, 2.56096D0,-0.77045D0/
      DATA PI3,ROOTPI/9.4247780D0,1.7724539D0/
C
      IFAIL=0
      T3=DABS(XMOM(3))
      IF(XMOM(2).LE.ZERO.OR.T3.GE.ONE)THEN
        IFAIL=1
        WRITE(ICOUT,7000)
 7000   FORMAT('****** ERROR IN PEARSON TYPE 3 L-MOMENTS ESTIMATION--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,7001)
 7001   FORMAT('       L-MOMENTS ARE INVALID.')
        CALL DPWRST('XXX','WRIT')
        DO 1010 I=1,3
          PARA(I)=ZERO
 1010   CONTINUE
        GOTO9000
      ELSEIF(T3.LE.SMALL)THEN
C
C       ZERO SKEWNESS
C
        PARA(1)=XMOM(1)
        PARA(2)=XMOM(2)*ROOTPI
        PARA(3)=ZERO
        GOTO9000
      ELSEIF(T3.GE.THIRD)THEN
        T=ONE-T3
        ALPHA=T*(D1+T*(D2+T*D3))/(ONE+T*(D4+T*(D5+T*D6)))
      ELSE
        T=PI3*T3*T3
        ALPHA=(ONE+C1*T)/(T*(ONE+T*(C2+T*C3)))
      ENDIF
C
      RTALPH=DSQRT(ALPHA)
      BETA=ROOTPI*XMOM(2)*DEXP(DLGAMA(ALPHA)-DLGAMA(ALPHA+HALF))
      PARA(1)=XMOM(1)
      PARA(2)=BETA*RTALPH
      PARA(3)=TWO/RTALPH
      IF(XMOM(3).LT.ZERO)PARA(3)=-PARA(3)
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PELWAK(XMOM,PARA,IFAIL)
C===================================================== PELWAK.FOR
C***********************************************************************
C*                                                                     *
C*  FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C*  'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C*                                                                     *
C*  J. R. M. HOSKING                                                   *
C*  IBM RESEARCH DIVISION                                              *
C*  T. J. WATSON RESEARCH CENTER                                       *
C*  YORKTOWN HEIGHTS                                                   *
C*  NEW YORK 10598, U.S.A.                                             *
C*                                                                     *
C*  VERSION 3     AUGUST 1996                                          *
C*                                                                     *
C***********************************************************************
C
C  PARAMETER ESTIMATION VIA L-MOMENTS FOR THE WAKEBY DISTRIBUTION
C
C  PARAMETERS OF ROUTINE:
C  XMOM   * INPUT* ARRAY OF LENGTH 5. CONTAINS THE L-MOMENTS LAMBDA-1,
C                  LAMBDA-2, TAU-3, TAU-4, TAU-5.
C  PARA   *OUTPUT* ARRAY OF LENGTH 5. ON EXIT, CONTAINS THE PARAMETERS
C                  IN THE ORDER XI, ALPHA, BETA, GAMMA, DELTA.
C  IFAIL  *OUTPUT* FAIL FLAG. ON EXIT, IT IS SET AS FOLLOWS.
C                  0 SUCCESSFUL EXIT
C                  1 ESTIMATES COULD ONLY BE OBTAINED BY SETTING XI=0
C                  2 ESTIMATES COULD ONLY BE OBTAINED BY FITTING A
C                    GENERALIZED PARETO DISTRIBUTION
C                  3 L-MOMENTS INVALID
C
C  PROCEDURE:
C  1. LOOK FOR A SOLUTION WITH XI UNCONSTRAINED;
C  2. IF NONE FOUND, LOOK FOR A SOLUTION WITH XI=0;
C  3. IF NONE FOUND, FIT A GENERALIZED PARETO DISTRIBUTION TO THE
C     FIRST 3 L-MOMENTS.
C  ESTIMATES ARE CALCULATED USING THE FORMULAS GIVEN BY GREENWOOD ET AL.
C  (1979, WATER RESOUR. RES., TABLE 5), BUT EXPRESSED IN TERMS OF
C  L-MOMENTS RATHER THAN PROBABILITY WEIGHTED MOMENTS.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(5),PARA(5)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      REAL CPUMIN
      REAL CPUMAX
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/
      DATA X2/2D0/,X3/3D0/,X4/4D0/,X5/5D0/,X7/7D0/,X8/8D0/,X9/9D0/,
     *  X10/10D0/,X11/11D0/,X16/16D0/,X25/25D0/,X29/29D0/,X32/32D0/,
     *  X35/35D0/,X85/85D0/,X125/125D0/,X203/203D0/
C
      IF(DABS(XMOM(2)).LE.ZERO)GOTO 1000
      IF(DABS(XMOM(3)).GE.ONE)GOTO 1000
      IF(DABS(XMOM(4)).GE.ONE)GOTO 1000
      IF(DABS(XMOM(5)).GE.ONE)GOTO 1000
      IFAIL=0
C
C         CALCULATE THE L-MOMENTS (LAMBDA'S)
C
      ALAM1=XMOM(1)
      ALAM2=XMOM(2)
      ALAM3=XMOM(3)*ALAM2
      ALAM4=XMOM(4)*ALAM2
      ALAM5=XMOM(5)*ALAM2
C
C         ESTIMATE N1,N2,N3,C1,C2,C3 WHEN XI.NE.0
C
      XN1= X3*ALAM2-X25*ALAM3 +X32*ALAM4
      XN2=-X3*ALAM2 +X5*ALAM3  +X8*ALAM4
      XN3= X3*ALAM2 +X5*ALAM3  +X2*ALAM4
      XC1= X7*ALAM2-X85*ALAM3+X203*ALAM4-X125*ALAM5
      XC2=-X7*ALAM2+X25*ALAM3  +X7*ALAM4 -X25*ALAM5
      XC3= X7*ALAM2 +X5*ALAM3  -X7*ALAM4  -X5*ALAM5
C
C         ESTIMATE B AND D
C
      XA=XN2*XC3-XC2*XN3
      XB=XN1*XC3-XC1*XN3
      XC=XN1*XC2-XC1*XN2
      DISC=XB*XB-FOUR*XA*XC
      IF(DISC.LT.ZERO)GOTO 10
      DISC=DSQRT(DISC)
      ROOT1=HALF*(-XB+DISC)/XA
      ROOT2=HALF*(-XB-DISC)/XA
      B= DMAX1(ROOT1,ROOT2)
      D=-DMIN1(ROOT1,ROOT2)
      IF(D.GE.ONE)GOTO 10
C
C         ESTIMATE A, C AND XI
C
      A=(ONE+B)*(TWO+B)*(THREE+B)/
     *  (FOUR*(B+D))*((ONE+D)*ALAM2-(THREE-D)*ALAM3)
      C=-(ONE-D)*(TWO-D)*(THREE-D)/
     *  (FOUR*(B+D))*((ONE-B)*ALAM2-(THREE+B)*ALAM3)
      XI=ALAM1-A/(ONE+B)-C/(ONE-D)
C
C         CHECK FOR VALID PARAMETERS
C
      IF(C.GE.ZERO.AND.A+C.GE.ZERO)GOTO 30
C
C         CAN'T FIND VALID ESTIMATES FOR XI UNRESTRICTED, SO TRY XI=0
C
C         ESTIMATE B AND D FOR XI=0
C
   10 CONTINUE
      IFAIL=1
      XI=ZERO
      ZN1=X4*ALAM1-X11*ALAM2+X9*ALAM3
      ZN2=-ALAM2+X3*ALAM3
      ZN3=ALAM2+ALAM3
      ZC1=X10*ALAM1-X29*ALAM2+X35*ALAM3-X16*ALAM4
      ZC2=-ALAM2+X5*ALAM3-X4*ALAM4
      ZC3=ALAM2-ALAM4
      ZA=ZN2*ZC3-ZC2*ZN3
      ZB=ZN1*ZC3-ZC1*ZN3
      ZC=ZN1*ZC2-ZC1*ZN2
      DISC=ZB*ZB-FOUR*ZA*ZC
      IF(DISC.LT.ZERO)GOTO 20
      DISC=DSQRT(DISC)
      ROOT1=HALF*(-ZB+DISC)/ZA
      ROOT2=HALF*(-ZB-DISC)/ZA
      B= DMAX1(ROOT1,ROOT2)
      D=-DMIN1(ROOT1,ROOT2)
      IF(D.GE.ONE)GOTO 20
C
C         ESTIMATE A AND C
C
      A= (ONE+B)*(TWO+B)/(B+D)*(ALAM1-(TWO-D)*ALAM2)
      C=-(ONE-D)*(TWO-D)/(B+D)*(ALAM1-(TWO+B)*ALAM2)
      IF(C.GE.ZERO.AND.A+C.GE.ZERO)GOTO 30
C
C         CAN'T FIND VALID ESTIMATES EVEN WITH XI=0 -
C         FIT GENERALIZED PARETO DISTRIBUTION INSTEAD
C
   20 CONTINUE
      IFAIL=2
      D=-(ONE-THREE*XMOM(3))/(ONE+XMOM(3))
      C=(ONE-D)*(TWO-D)*XMOM(2)
      B=ZERO
      A=ZERO
      XI=XMOM(1)-C/(ONE-D)
      IF(D.GT.ZERO)GOTO 30
      A=C
      B=-D
      C=ZERO
      D=ZERO
C
C         COPY RESULTS INTO ARRAY PARA
C
   30 CONTINUE
      PARA(1)=XI
      PARA(2)=A
      PARA(3)=B
      PARA(4)=C
      PARA(5)=D
      GOTO9000
C
 1000 IFAIL=3
      DO 1010 I=1,5
        PARA(I)=ZERO
 1010 CONTINUE
      GOTO9000
C
 9000 CONTINUE
      RETURN
      END
      COMPLEX FUNCTION PEQ(Z)
C
C     WEIERSTRASS: P-FUNCTION IN THE EQUIANHARMONIC CASE
C     FOR COMPLEX ARGUMENT WITH UNIT PERIOD PARALLELOGRAM
C
      INCLUDE 'DPCOMC.INC'
      COMPLEX Z, Z2, Z4, Z6
      REAL ZR, ZI
      INTEGER M, N
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C     REDUCTION TO FUNDAMENTAL PARALLELOGRAM
C
      ZI = 1.1547005383792515E0*AIMAG(Z) + 0.5E0
      M = INT(ZI)
      IF (ZI.LT.0E0) M = M - 1
      ZR = REAL(Z) - 0.5E0*FLOAT(M) + 0.5E0
      N = INT(ZR)
      IF (ZR.LT.0E0) N = N - 1
      Z2 = Z - FLOAT(N) - (0.5E0,0.86602540378443865E0)*FLOAT(M)
C
C     IF Z2=0 THEN Z COINCIDES WITH A LATTICE POINT.
C     SINCE P HAS POLES AT THE LATTICE POINTS,
C     A DIVISION ERROR WILL OCCUR
C
      IF(REAL(Z2).EQ.0.0.AND.AIMAG(Z2).EQ.0.0)THEN
        PEQ=R1MACH(2)
        WRITE(ICOUT,91)
        CALL DPWRST('XXX','BUG ')
        RETURN
      ENDIF
   91 FORMAT('***** ERROR: INPUT POINT CORRESPONDS TO A LATTICE ',
     1'POINT.  VALUE SET TO LARGEST REAL. *****')
      Z2 = Z2*Z2
      Z4 = Z2*Z2
      Z6 = Z4*Z2
      PEQ = 1E0/Z2 + 6E0*Z4*(5E0+Z6)/(1E0-Z6)**2 + Z4*
     * (((((-2.6427662E-10*Z6+1.610954818E-8)*Z6+7.38610752879E-6)*
     * Z6+4.3991444671178E-4)*Z6+7.477288220490697E-2)*
     * Z6-6.8484153287299201E-1)/(((((6.2252191E-10*Z6+2.553314573E-7)*
     * Z6-2.619832920421E-5)*Z6-5.6444801847646E-4)*
     * Z6+4.565553484820106E-2)*Z6+1E0)
      RETURN
      END
      COMPLEX FUNCTION PEQ1(Z)
C
C     FIRST DERIVATIVE OF WEIERSTRASS: P-FUNCTION IN THE
C     EQUIANHARMONIC CASE FOR COMPLEX ARGUMENT
C     WITH UNIT PERIOD PARALLELOGRAM
C
      INCLUDE 'DPCOMC.INC'
      COMPLEX Z, Z3, Z6
      REAL ZR, ZI
      INTEGER M, N
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C
C     REDUCTION TO FUNDAMENTAL PARALLELOGRAM
C
      ZI = 1.1547005383792515E0*AIMAG(Z) + 0.5E0
      M = INT(ZI)
      IF (ZI.LT.0E0) M = M - 1
      ZR = REAL(Z) - 0.5E0*FLOAT(M) + 0.5E0
      N = INT(ZR)
      IF (ZR.LT.0E0) N = N - 1
      Z3 = Z - FLOAT(N) - (0.5E0,0.86602540378443865E0)*FLOAT(M)
C
C     IF Z3=0 THEN Z COINCIDES WITH A LATTICE POINT.
C     SINCE P: HAS POLES AT THE LATTICE POINTS,
C     A DIVISION ERROR WILL OCCUR
C
      IF(REAL(Z3).EQ.0.0.AND.AIMAG(Z3).EQ.0.0)THEN
        PEQ1=R1MACH(2)
        WRITE(ICOUT,91)
        CALL DPWRST('XXX','BUG ')
        RETURN
      ENDIF
   91 FORMAT('***** ERROR: INPUT POINT CORRESPONDS TO A LATTICE ',
     1'POINT.  VALUE SET TO LARGEST REAL. *****')
      Z3 = Z3*Z3*Z3
      Z6 = Z3*Z3
      PEQ1 = (((14E0*Z6+294E0)*Z6+126E0)*Z6-2E0)/(Z3*(1E0-Z6)**3) +
     * Z3*((((((-2.95539175E-9*Z6-2.6764693031E-7)*Z6+2.402192743346E-5)
     * *Z6+1.9656661451391E-4)*Z6+1.760135529461036E-2)*
     * Z6+8.1026243498822636E-1)*Z6-2.73936613149196804E0)/
     * ((((((4.6397763E-10*Z6+5.413482233E-8)*Z6-1.56293298374E-6)*
     * Z6-1.0393701076352E-4)*Z6+9.5553182532237E-4)*
     * Z6+9.131106969640212E-2)*Z6+1E0)
      RETURN
      END
      SUBROUTINE PERAGR(X,Y,N,IWRITE,RIGHT,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT AGREEMENT
C              BETWEEN THE 2 SETS OF DATA IN THE INPUT VECTORS X AND Y.
C              THIS IS USEFUL IN THE CONTEXT OF DETERMINING WHAT
C              PERCENTAGE OF THE TIME TWO METHODS RESULT IN THE
C              SAME DECISION.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF UNSORTED
C                                OBSERVATIONS WHICH CONSTITUTE THE FIRST
C                                SET OF DATA.
C                     --Y      = THE SINGLE PRECISION VECTOR OF UNSORTED
C                                OBSERVATIONS WHICH CONSTITUTE THE SECOND
C                                SET OF DATA.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X, OR EQUIVALENTLY,
C                                THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR Y.
C     OUTPUT ARGUMENTS--RIGHT  = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED PERCENTAGE OF AGREEMENT
C                                BETWEEN THE 2 SETS OF DATA IN THE
C                                INPUT VECTORS X AND Y.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PERCENTAGE AGREEMENT BETWEEN THE 2 SETS
C             OF DATA IN THE INPUT VECTORS X AND Y.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2011/7
C     ORIGINAL VERSION--JULY      2011.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION Y(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA EPS /1.0E-12/
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PERA'
      ISUBN2='GR  '
      IERROR='NO'
      RIGHT=CPUMIN
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RAGR')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF PERAGR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I),Y(I)
   56     FORMAT('I,X(I),Y(I) = ',I8,2E15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN PERCENTAGE AGREEMENT--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE NUMBER OF OBSERVATIONS FOR THE RESPONSE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      VARIABLES IS NON-POSITIVE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)N
  117   FORMAT('      THE NUMBER OF OBSERVATIONS      = ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               ************************************************
C               **  STEP 2--                                  **
C               **  COMPUTE THE PERCENTAGE AGREEMENT.         **
C               ************************************************
C
      NMATCH=0
      DO200I=1,N
        IF(ABS(Y(I) - X(I)).LE.EPS)NMATCH=NMATCH+1
  200 CONTINUE
      RIGHT=REAL(NMATCH)/REAL(N)
      RIGHT=100.0*RIGHT
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)N,RIGHT
  811   FORMAT('THE PERCENTAGE ARGEEMENT OF THE ',I8,
     1         ' OBSERVATIONS = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RAGR')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF PERAGR--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)N,NMATCH,RIGHT
 9015   FORMAT('N,NMATCH,RIGHT = ',2I8,G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PERCEN(P100,X,N,IWRITE,XTEMP,MAXNXT,
     1                  XPERC,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              SAMPLE PERCENTILE
C              OF THE DATA IN THE INPUT VECTOR X.
C     INPUT  ARGUMENTS--P100   = THE SINGLE PRECISION PERCENTAGE
C                                (BETWEEN 0 AND 100)
C                     --X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XPERC  = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE PERCENTILE.
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PERCENTILE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--SORT.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     VERSION NUMBER--87.11
C     ORIGINAL VERSION--SEPTEMBER 1987.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XTEMP(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PERC'
      ISUBN2='EN  '
C
      IERROR='NO'
C
      NI=0
      NIP1=0
C
      ANI=0.0
      A2NI=0.0
      REM=0.0
C
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF PERCEN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,53)P100,N,IBUGA3
   53   FORMAT('P100,N,IBUGA3, = ',G15.7,I8,2X,A4)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               ******************************
C               **  COMPUTE PERCENTILE      **
C               ******************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(P100.LE.0.0 .OR. P100.GE.100.0)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN PERCENTILE--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,112)
  112   FORMAT('      THE INPUT PERCENTAGE FOR WHICH THE PERCENTILE ',
     1         'IS TO BE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,115)
  115   FORMAT('      COMPUTED MUST BE LARGER THAN 0 AND SMALLER ',
     1         'THAN 100.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,117)P100
  117   FORMAT('      SUCH WAS NOT THE CASE HERE.  THE INPUT ',
     1         'PERCENTAGE = ',G15.7)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.LT.1 .OR. N.GT.MAXNXT)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,122)
  122   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS FOR THE ',
     1         'RESPONSE VARIABLE')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,125)MAXNXT
  125   FORMAT('      MUST BE BETWEEN 1 AND ',I8,' (INCLUSIVELY).')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,127)N
  127   FORMAT('      THE INPUT NUMBER OF OBSERVATIONS = ',I8,'.')
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
      IF(N.EQ.1)THEN
        XPERC=X(1)
        GOTO9000
      ENDIF
C
      HOLD=X(1)
      DO145I=2,N
        IF(X(I).NE.HOLD)GOTO149
  145 CONTINUE
      XPERC=HOLD
      GOTO9000
  149 CONTINUE
C
C               ***********************************
C               **  STEP 2--                     **
C               **  COMPUTE THE PERCENTILE.      **
C               ***********************************
C
      CALL SORT(X,N,XTEMP)
C
      P=P100/100.0
C
      ANI=P*(AN+1.0)
      NI=ANI
      A2NI=NI
      REM=ANI-A2NI
      NIP1=NI+1
      IF(NI.LE.1)NI=1
      IF(NI.GE.N)NI=N
      IF(NIP1.LE.1)NIP1=1
      IF(NIP1.GE.N)NIP1=N
CCCCC BUG FIX.  WEIGHTS IN WRONG ORDER!  NOVEMBER 1998.
CCCCC XPERC=REM*XTEMP(NI)+(1.0-REM)*XTEMP(NIP1)
      XPERC=(1.0-REM)*XTEMP(NI)+REM*XTEMP(NIP1)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,811)P100,N,XPERC
  811   FORMAT('THE ',F10.2,'-PERCENTILE OF THE ',I8,
     1         ' OBSERVATIONS = ',G15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END       OF PERCEN--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9013)IERROR,P100,N,P
 9013   FORMAT('IERROR,P100,N,P = ',A4,2X,G15.7,I8,G15.7)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9014)ANI,NI,A2NI,REM,NIP1
 9014   FORMAT('ANI,NI,A2NI,REM,NIP1 = ',E15.7,I8,E15.7,E15.7,I8)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9015)XPERC
 9015   FORMAT('XPERC = ',E15.7)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PERCRA(X,N,IWRITE,XR,XS,MAXOBV,IBUGA3,ISUBRO,IERROR)
C
C     PURPOSE--THIS SUBROUTINE GENERATES THE PERCENTAGE RANK OF
C              EACH OF THE N ELEMENTS OF THE VECTOR X AND PUTS THE
C              RESULTING N RANKS INTO THE VECTOR XR.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                OBSERVATIONS FOR WHICH THE PERCENTAGE
C                                RANKS WILL BE COMPUTED.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C     OUTPUT ARGUMENTS--XR     = THE SINGLE PRECISION VECTOR WHERE THE
C                                PERCNTAGE RANKS WILL BE PLACED.
C     OUTPUT--THE SINGLE PRECISION VECTOR XR CONTAINING THE RANKS
C             (IN ASCENDING ORDER) OF THE VALUES IN THE VECTOR X.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     OTHER DATAPAC   SUBROUTINES NEEDED--RANK.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--ISO 13528, FIRST EDITION, STATISTICAL METHODS FOR USE
C                 IN PROFICIENCY TESTING BY INTERLABORATORY COMPARISONS,
C                 2005.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATION INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2012.1
C     ORIGINAL VERSION--JANUARY   2012.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IBUGA3
      CHARACTER*4 ISUBRO
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
      DIMENSION XR(*)
      DIMENSION XS(MAXOBV)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PERC'
      ISUBN2='RA  '
C
      IERROR='NO'
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RCRA')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,51)
   51   FORMAT('***** AT THE BEGINNING OF PERCRA--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',2(A4,2X),I8)
        CALL DPWRST('XXX','BUG ')
        DO55I=1,N
          WRITE(ICOUT,56)I,X(I)
   56     FORMAT('I,X(I) = ',I8,G15.7)
          CALL DPWRST('XXX','BUG ')
   55   CONTINUE
      ENDIF
C
C               *******************************************
C               **  COMPUTE THE PERCENTAGE RANK VALUES.  **
C               *******************************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.LT.1)THEN
        IERROR='YES'
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,111)
  111   FORMAT('***** ERROR IN PERCENTAGE RANK--')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,113)
  113   FORMAT('      THE NUMBER OF OBSERVATIONS IS LESS THAN ONE.')
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,118)N
  118   FORMAT('      THE NUMBER OF OBSERVATIONS IS ',I8)
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
C
C               ***************************************************
C               **  STEP 2--                                     **
C               **  FIRST RANK THE DATA FROM THE INPUT VECTOR X  **
C               **  INTO THE INTERMEDIATE STORAGE VECTOR XR.     **
C               ***************************************************
C
      CALL RANK(X,N,IWRITE,XR,XS,MAXOBV,IBUGA3,IERROR)
C
C               *********************************************************
C               **  STEP 3--                                           **
C               **  NOW COMPUTE THE PERCENTAGE RANKS:                  **
C               **      PERCENTAGE RANK(I) = 100*(RANK(I)-0.5)/N       **
C               **********************************************************
C
      DO210I=1,N
        XR(I)=100.0*(XR(I) - 0.5)/AN
  210 CONTINUE
C
C               ******************************
C               **  STEP 4--                **
C               **  WRITE OUT A FEW LINES   **
C               **  OF SUMMARY INFORMATION  **
C               **  ABOUT THE CODING.       **
C               ******************************
C
      IF(IFEEDB.EQ.'ON' .AND. IWRITE.EQ.'ON')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        AI=1
        WRITE(ICOUT,912)XR(1)
  912   FORMAT('THE FIRST ELEMENT HAS PERCENTAGE RANK ',F14.2)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,914)XR(N)
  914   FORMAT('THE LAST  ELEMENT HAS PERCENTAGE RANK ',F14.2)
        CALL DPWRST('XXX','BUG ')
      ENDIF
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
C
      IF(IBUGA3.EQ.'ON' .OR. ISUBRO.EQ.'RCRA')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,9011)
 9011   FORMAT('***** AT THE END OF PERCRA--')
        CALL DPWRST('XXX','BUG ')
        DO9015I=1,N
          WRITE(ICOUT,9016)I,X(I),XR(I)
 9016     FORMAT('I,X(I),XR(I) = ',I8,2G15.7)
          CALL DPWRST('XXX','BUG ')
 9015   CONTINUE
      ENDIF
C
      RETURN
      END
      SUBROUTINE PERDEF(X,N,ENGLSL,ENGUSL,IWRITE,XACTPD,XTHEPD,
     1XACTL,XTHEL,XACTU,XTHEU,
     1IFLAG,IBUGA3,IERROR)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE
C              ACTUAL PERCENT DEFECTIVE (XACTPD) AND
C              THOERETICAL PERCENT DEFECTIVE (XTHEPD)
C              FROM THE DATA IN THE INPUT VECTOR X.
C              THIS CALCULATION ASSUMES--
C                 1) A NORMAL DISTRIBUTION
C                 2) WITH MEAN XBAR AND STANDARD DEVIATION S
C                 3) THE TARGET IS MIDWAY BETWEEN ENGUSL AND ENGLSL
C              XTHEPD = 100*(AREA UNDER NORMAL CURVE ABOVE USL AND BELOW LSL)
C     THE FINAL FORM FOR XTHEPD IS QUITE SIMPLE--
C        XTHEPD = 100(1-(NORCDF(ZUPPER)-NORCDF(ZLOWER)))
C     WHERE ZUPPER = (ENGUSL-MU)/SIGMA
C     AND   ZLOWER = (ENGLSL-MU)/SIGMA
C     IN PRACTICE, WE USE XBAR FOR MU AND S FOR SIGMA.
C     NOTE--XTHEPD IS A MEASURE OF PROCESS QUALITY AND IS
C           SENSITIVE TO LOSS OF QUALITY FROM BOTH BIAS AND FROM VARIATION.
C     NOTE--XTHEPD IS A MEASURE WHICH TAKES ON
C           THE VALUES 0% TO 100%
C           A GOOD PROCESS YIELDS VALUES OF
C           PERCENT DEFECTIVE NEAR 0%.
C     INPUT  ARGUMENTS--X      = THE SINGLE PRECISION VECTOR OF
C                                (UNSORTED OR SORTED) OBSERVATIONS.
C                     --N      = THE INTEGER NUMBER OF OBSERVATIONS
C                                IN THE VECTOR X.
C                     --ENGLSL = LOWER (ENGINEERING) SPEC LIMIT
C                     --ENGUSL = UPPER (ENGINEERING) SPEC LIMIT
C                     --IFLAG  = WRITE FLAG (THEO, ACTU, BOTH)
C     OUTPUT ARGUMENTS--PERDEF = THE SINGLE PRECISION VALUE OF THE
C                                COMPUTED SAMPLE PERCENT DEFECTIVE
C     OUTPUT--THE COMPUTED SINGLE PRECISION VALUE OF THE
C             SAMPLE PERCENT DEFECTIVE (IN XTHEPD)
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DSQRT.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION & SINGLE PRECISION
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--R&M 2000 AIR FORCE MANUAL
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--89.5
C     ORIGINAL VERSION--MAY       1989.
C     UPDATED         --SEPTEMBER 1990. REVERSE INPUT ARGS
C     UPDATED         --APRIL     2001. ADD XACTL, XTHEL, XACTU, XTHEU
C                                       THESE ARE ONE SIDED LIMITS
C                                       (CAPABILITY ANALYSIS PRINTS
C                                       THEM)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      CHARACTER*4 IWRITE
      CHARACTER*4 IFLAG
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DN
      DOUBLE PRECISION DX
      DOUBLE PRECISION DSUM
      DOUBLE PRECISION DMEAN
      DOUBLE PRECISION DVAR
      DOUBLE PRECISION DSD
C
      DOUBLE PRECISION DUSL
      DOUBLE PRECISION DLSL
C
      DIMENSION X(*)
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PERD'
      ISUBN2='EF  '
C
      IERROR='NO'
C
      DMEAN=0.0D0
C
      IF(IBUGA3.EQ.'OFF')GOTO90
      WRITE(ICOUT,999)
  999 FORMAT(1X)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,51)
   51 FORMAT('***** AT THE BEGINNING OF PERDEF--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,52)IFLAG,IBUGA3
   52 FORMAT('IFLAG,IBUGA3 = ',A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,53)N
   53 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,54)ENGUSL,ENGLSL
   54 FORMAT('ENGUSL,ENGLSL = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
      DO55I=1,N
      WRITE(ICOUT,56)I,X(I)
   56 FORMAT('I,X(I) = ',I8,E15.7)
      CALL DPWRST('XXX','BUG ')
   55 CONTINUE
   90 CONTINUE
C
C               ********************************************
C               **  COMPUTE PROCESS CAPABILITY INDEX PERDEF  **
C               ********************************************
C
C               ********************************************
C               **  STEP 1--                              **
C               **  CHECK THE INPUT ARGUMENTS FOR ERRORS  **
C               ********************************************
C
      AN=N
C
      IF(N.GE.1)GOTO119
      IERROR='YES'
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,111)
  111 FORMAT('***** ERROR IN PERDEF--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,112)
  112 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,113)
  113 FORMAT('      IN THE VARIABLE FOR WHICH')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,114)
  114 FORMAT('      THE PERCENT DEFECTIVE IS TO BE COMPUTED')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,115)
  115 FORMAT('      MUST BE 1 OR LARGER.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,116)
  116 FORMAT('      SUCH WAS NOT THE CASE HERE.')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,117)N
  117 FORMAT('      THE INPUT NUMBER OF OBSERVATIONS HERE = ',I8,
     1'.')
      CALL DPWRST('XXX','BUG ')
      GOTO9000
  119 CONTINUE
C
      IF(N.EQ.1)GOTO120
      GOTO129
  120 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,121)
CC121 FORMAT('***** NON-FATAL DIAGNOSTIC IN PERDEF--',
CCCCC1'THE SECOND INPUT ARGUMENT (N) HAS THE VALUE 1')
CCCCC CALL DPWRST('XXX','BUG ')
      XSD=0.0
      GOTO9000
  129 CONTINUE
C
      HOLD=X(1)
      DO135I=2,N
      IF(X(I).NE.HOLD)GOTO139
  135 CONTINUE
CCCCC WRITE(ICOUT,999)
CCCCC CALL DPWRST('XXX','BUG ')
CCCCC WRITE(ICOUT,136)HOLD
CC136 FORMAT('***** NON-FATAL DIAGNOSTIC IN PERDEF--',
CCCCC1'THE FIRST INPUT ARGUMENT (A VECTOR) HAS ALL ELEMENTS = ',E15.7)
CCCCC CALL DPWRST('XXX','BUG ')
      XSD=0.0
      GOTO9000
  139 CONTINUE
C
  190 CONTINUE
C
C               ***************************************
C               **  STEP 2--                         **
C               **  COMPUTE THE STANDARD DEVIATION.  **
C               ***************************************
C
      DN=N
      DSUM=0.0D0
      DO200I=1,N
      DX=X(I)
      DSUM=DSUM+DX
  200 CONTINUE
      DMEAN=DSUM/DN
C
      DSUM=0.0D0
      DO300I=1,N
      DX=X(I)
      DSUM=DSUM+(DX-DMEAN)**2
  300 CONTINUE
      DVAR=DSUM/(DN-1.0D0)
      DSD=0.0D0
      IF(DVAR.GT.0.0D0)DSD=DSQRT(DVAR)
      XSD=DSD
C
C               **************************************************
C               **  STEP 3--                                    **
C               **  COMPUTE THE ACTUAL      PERCENT DEFECTIVE   **
C               **  COMPUTE THE THEORETICAL PERCENT DEFECTIVE   **
C               **************************************************
C
      DUSL=ENGUSL
      DLSL=ENGLSL
C
      IF(DSD.EQ.0.0D0)GOTO410
      GOTO420
C
  410 CONTINUE
      XTHEPD=0.0
      IF(DMEAN.GT.DUSL)XTHEPD=100.0
      IF(DMEAN.LT.DLSL)XTHEPD=100.0
      GOTO490
C
  420 CONTINUE
      ZUPPER=(DUSL-DMEAN)/DSD
      ZLOWER=(DLSL-DMEAN)/DSD
      CALL NORCDF(ZUPPER,CDFUPP)
      CALL NORCDF(ZLOWER,CDFLOW)
      XTHEPD=100.0*(1.0-(CDFUPP-CDFLOW))
      XTHEL=100.0*(CDFLOW)
      XTHEU=100.0*(1.0-CDFUPP)
C
  490 CONTINUE
C
      XACTPD=0.0
      XACTL=0.0
      XACTU=0.0
      ICOUNT=0
      DO510I=1,N
      IF(X(I).LT.ENGLSL.OR.X(I).GT.ENGUSL)ICOUNT=ICOUNT+1
      IF(X(I).LT.ENGLSL)XACTL=XACTL+1.0
      IF(X(I).GT.ENGUSL)XACTU=XACTU+1.0
  510 CONTINUE
      ACOUNT=ICOUNT
      IF(AN.NE.0.0)XACTPD=100.0*(ACOUNT/AN)
      IF(AN.NE.0.0)XACTL=100.0*(XACTL/AN)
      IF(AN.NE.0.0)XACTU=100.0*(XACTU/AN)
C
C               *******************************
C               **  STEP 3--                 **
C               **  WRITE OUT A LINE         **
C               **  OF SUMMARY INFORMATION.  **
C               *******************************
C
      IF(IFEEDB.EQ.'OFF')GOTO890
      IF(IWRITE.EQ.'OFF')GOTO890
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      IF(IFLAG.EQ.'THEO'.OR.IFLAG.EQ.'BOTH')
     1WRITE(ICOUT,811)N,XTHEPD
  811 FORMAT('THE (THEORETICAL) PERCENT DEFECTIVE OF THE ',I8,
     1' OBSERVATIONS = ',E15.7)
      IF(IFLAG.EQ.'THEO'.OR.IFLAG.EQ.'BOTH')
     1CALL DPWRST('XXX','BUG ')
      IF(IFLAG.EQ.'ACTU'.OR.IFLAG.EQ.'BOTH')
     1WRITE(ICOUT,812)N,XACTPD
  812 FORMAT('THE (ACTUAL     ) PERCENT DEFECTIVE OF THE ',I8,
     1' OBSERVATIONS = ',E15.7)
      IF(IFLAG.EQ.'ACTU'.OR.IFLAG.EQ.'BOTH')
     1CALL DPWRST('XXX','BUG ')
  890 CONTINUE
C
C               *****************
C               **  STEP 90--  **
C               **  EXIT.      **
C               *****************
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'OFF')GOTO9090
      WRITE(ICOUT,999)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9011)
 9011 FORMAT('***** AT THE END       OF PERDEF--')
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9012)IFLAG,IBUGA3,IERROR
 9012 FORMAT('IFLAG,IBUGA3,IERROR = ',A4,2X,A4,2X,A4)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9013)N
 9013 FORMAT('N = ',I8)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9014)DMEAN
 9014 FORMAT('DMEAN = ',D15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9015)DSD
 9015 FORMAT('DSD = ',E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9016)DUSL,DLSL
 9016 FORMAT('DUSL,DLSL = ',2D15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9017)ZUPPER,ZLOWER,CDFUPP,CDFLOW,XTHEPD
 9017 FORMAT('ZUPPER,ZLOWER,CDFUPP,CDFLOW,XTHEPD = ',5E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9021)ENGLSL,ENGUSL,ACOUNT,AN
 9021 FORMAT('ENGLSL,ENGUSL,ACOUNT,AN = ',4E15.7)
      CALL DPWRST('XXX','BUG ')
      WRITE(ICOUT,9022)XACTPD,XTHEPD
 9022 FORMAT('XACTPD,XTHEPD = ',2E15.7)
      CALL DPWRST('XXX','BUG ')
 9090 CONTINUE
C
      RETURN
      END
      SUBROUTINE PEXCDF(DX,DBETA,DCDF)
CCCCC SUBROUTINE PEXCDF(X,ALPHA,BETA,CDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE DISTRIBUTION
C              FUNCTION VALUE FOR THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA AND SCALE PARAMETER
C              ALPHA.  THIS DISTRIBUTION IS DEFINED FOR ALL
C              NON-NEGATIVE X, AND HAS THE CUMULATIVE DISTRIBUTION
C              FUNCTION
C
C                 F(X) = 1-EXP(1-EXP((X/ALPHA)**B))
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE.
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE DISTRIBUTION
C                                FUNCTION IS TO BE EVALUATED.
C                     --DBETA  = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--CDF    = THE DOUBLE PRECISION CUMULATIVE
C                                DISTRIBUTION FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE DISTRIBUTION
C             FUNCTION VALUE CDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--DECEMBER  1995. 
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C     UPDATED         --NOVEMBER  2007. MAKE ARGUMENTS DOUBLE PRECISON
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
CCCCC DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DCDF
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DCDF=0.0D0
      IF(DX.LT.0.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
CCCCC IF(ALPHA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,14)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,46)ALPHA
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   GOTO9999
CCCCC ENDIF
      IF(DBETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DBETA
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXCDF IS NEGATIVE.')
CCC14 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO')
CCC15 FORMAT('      THE PEXCDF SUBROUTINE IS ZERO OR NEGATIVE *****')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PEXCDF IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IF(DX.LE.0.0D0)THEN
        DCDF=0.0D0
        GOTO9999
      ENDIF
C
      DTERM1=1.0D0 - DEXP(DX**DBETA)
      DTERM2=DEXP(DTERM1)
      DCDF=1.0D0 - DTERM2
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PEXCHA(DX,DBETA,DHAZ)
CCCCC SUBROUTINE PEXCHA(X,ALPHA,BETA,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE CUMULATIVE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA AND SCALE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X.
C
C              THE CUMULATIVE HAZARD FUNCTION IS:
C
C                 H(X;BETA)=EXP(X**BETA) - 1
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE).
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE CUMULATIVE HAZARD
C                                FUNCTION IS TO BE EVALUATED.
C                     --DBETA  = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DHAZ   = THE DOUBLE PRECISION CUMULATIVE 
C                                HAZARD FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION CUMULATIVE HAZARD
C             FUNCTION VALUE DHAZ.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C                 SMITH AND BAIN, "AN EXPONENTIAL POWER LIFE-TESTING
C                 DISTRIBUTION", COMMUNICATIONS IN STATISITCS, 1975,
C                 PP. 469-481.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY (205.03)
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C     UPDATED         --NOVEMBER  2007. MAKE ARGUMENTS DOUBLE PRECISON
C
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DOUBLE PRECISION DX
CCCCC DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DHAZ
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DHAZ=0.0D0
      IF(DX.LT.0.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DX
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
CCCCC IF(ALPHA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,14)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,46)ALPHA
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   GOTO9999
CCCCC ENDIF
      IF(DBETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DBETA
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXCHAZ IS NEGATIVE.')
CCC14 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO')
CCC15 FORMAT('      THE PEXCHAZ SUBROUTINE IS ZERO OR NEGATIVE *****')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PEXCHAZ IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      DHAZ=DEXP(DX**DBETA) - 1.0D0
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PEXHAZ(DX,DBETA,DHAZ)
CCCCC SUBROUTINE PEXHAZ(X,ALPHA,BETA,HAZ)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE HAZARD
C              FUNCTION VALUE FOR THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA AND SCALE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE HAZARD FUNCTION:
C
C              H(X;ALPHA,BETA)=ALPHA*BETA*X**(X-1)*EXP(ALPHA*X**BETA)
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE.
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE HAZARD
C                                FUNCTION IS TO BE EVALUATED.
C                     --DBETA  = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DHAZ   = THE DOUBLE PRECISION 
C                                HAZARD FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION HAZARD FUNCTION VALUE DHAZ.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C                 SMITH AND BAIN, "AN EXPONENTIAL POWER LIFE-TESTING
C                 DISTRIBUTION", COMMUNICATIONS IN STATISITCS, 1975,
C                 PP. 469-481.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--APRIL     1998. 
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C     UPDATED         --NOVEMBER  2007. MAKE ARGUMENTS DOUBLE PRECISON
C
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
CCCCC DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DHAZ
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3, DTERM4, DTERM5
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DHAZ=0.0D0
      IF(DBETA.GE.1.0D0)THEN
        IF(DX.LT.0.0D0)THEN
          WRITE(ICOUT,4)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,46)DX
          CALL DPWRST('XXX','BUG')
          GOTO9999
        ENDIF
      ELSE
        IF(DX.LE.0.0D0)THEN
          WRITE(ICOUT,5)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,46)DX
          CALL DPWRST('XXX','BUG')
          GOTO9999
        ENDIF
      ENDIF
CCCCC IF(ALPHA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,14)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,46)ALPHA
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   GOTO9999
CCCCC ENDIF
      IF(DBETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DBETA
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXHAZ IS NEGATIVE.')
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXPDF IS ',
     1       'NON-POSITIVE.')
CCC14 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO')
CCC15 FORMAT('      THE PEXHAZ SUBROUTINE IS ZERO OR NEGATIVE *****')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PEXHAZ IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      DTERM1=DLOG(DBETA)
      DTERM2=(DBETA-1.0D0)*DLOG(DX)
      DTERM3=DX**DBETA
      DTERM4=DTERM1+DTERM2+DTERM3
      DHAZ=DEXP(DTERM4)
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PEXFUN (N, X, FVEC, IFLAG, XDATA, NOBS)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE FUNCTIONS FOR THE
C              EXPONENTIAL POWER MAXIMUM LIKELIHOOD EQUATIONS.
C
C                (N/BETA) + N*LOG(ALPHA) + SUM[A(i)] -
C                SUM[B(i)*C(i)*EXP(B(i))] +SUM[B(i)*C(i)] = 0
C
C                (BETA*N/ALPHA) - (BETA/ALPHA)*SUM[B(i)*EXP(B(i))] +
C                (BETA/ALPHA)*SUM[B(i)] = 0
C
C              WHERE
C
C                BETA     = SHAPE PARAMETER
C                ALPHA    = SCALE PARAMETER
C                A(i)     = LOG(X(i)]
C                B(i)     = (ALPHA*X(i))**BETA
C                C(i)     = LOG(ALPHA*X(i))
C
C
C              CALLED BY DNSQE ROUTINE FOR SOLVING SIMULTANEOUS
C              NONLINEAR EQUATIONS.  NOTE THAT THE CALLING SEQUENCE
C              DID NOT ACCOMODATE A DATA ARRAY (AND ASSCIATED NUMBER OF
C              OBSERVATIONS), SO THESE WERE ADDED TO THE CALL LIST.
C     EXAMPLE--EXPONENTIAL POWER MAXIMUM LIKELIHOOD Y
C     REFERENCE--DHILLON (1981), "LIFE DISTRIBUTIONS", IEEE
C                TRANSACTIONS ON RELIABILITY, VOL. R-30, NO. 5,
C                PP. 457-459.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL BUREAU OF STANDARDS.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2007/11
C     ORIGINAL VERSION--NOVEMBER  2007.
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION X(*)
      DOUBLE PRECISION FVEC(*)
      REAL XDATA(*)
C
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DN
      DOUBLE PRECISION DX
      DOUBLE PRECISION DA
      DOUBLE PRECISION DB
      DOUBLE PRECISION DC
      DOUBLE PRECISION DSUM1
      DOUBLE PRECISION DSUM2
      DOUBLE PRECISION DSUM3
      DOUBLE PRECISION DSUM4
      DOUBLE PRECISION DSUM5
      DOUBLE PRECISION DTERM1
      DOUBLE PRECISION DTERM2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C  COMPUTE SOME SUMS
C
      DN=DBLE(NOBS)
      DBETA=DBLE(X(1))
      DALPHA=DBLE(X(2))
C
      DTERM1=(DN/DBETA)  + DN*DLOG(DALPHA)
      DTERM2=(DBETA*DN/DALPHA)
      DSUM1=0.0D0
      DSUM2=0.0D0
      DSUM3=0.0D0
      DSUM4=0.0D0
      DSUM5=0.0D0
C
      DO200I=1,NOBS
C
        DX=DBLE(XDATA(I))
        DA=DLOG(DX)
        DB=(DALPHA*DX)**DBETA
        DC=DLOG(DALPHA*DX)
C
        DSUM1=DSUM1 + DA
        DSUM2=DSUM2 + DB*DC*DEXP(DB)
        DSUM3=DSUM3 + DB*DC
C
        DSUM4=DSUM4 + DB*DEXP(DB)
        DSUM5=DSUM5 + DB
C
  200 CONTINUE
C
      FVEC(1)=DTERM1 + DSUM1 - DSUM2 + DSUM3
      FVEC(2)=DTERM2 - (DBETA/DALPHA)*DSUM4 + (DBETA/DALPHA)*DSUM5
C
      RETURN
      END
      SUBROUTINE PEXML1(Y,N,BETASV,SCALSV,MAXNXT,
     1                  TEMP1,TEMP2,DISPAR,DTEMP1,
     1                  XMEAN,XSD,XVAR,XMIN,XMAX,
     1                  BETAML,SCALML,
     1                  ISUBRO,IBUGA3,IERROR)
C
C     PURPOSE--THIS ROUTINE COMPUTES THE MAXIMUM LIKELIHOOD ESTIMATES
C              FOR THE EXPONENTIAL POWER DISTRIBUTION FOR THE RAW DATA
C              CASE (I.E., NO CENSORING AND NO GROUPING).  THIS ROUTINE
C              RETURNS ONLY THE POINT ESTIMATES.
C
C              IT IS ASSUMED THAT BASIC ERROR CHECKING HAS ALREADY BEEN
C              PERFORMED.
C
C              PUT THIS IN A SEPARATE ROUTINE AS IT MAY BE CALLED
C              FROM MULTIPLE PLACES (DPMLPX WILL GENERATE THE OUTPUT
C              FOR THE ALPHA MLE COMMAND).
C
C     NOTE--THE MAXIMIUM LIKELIHOOD ESTIMATES ARE THE SOLUTIONS
C           TO THE FOLLOWING EQUATIONS:
C
C             (N/BETA) + N*LOG(ALPHA) + SUM[A(i)] -
C             SUM[B(i)*C(i)*EXP(B(i))] +SUM[B(i)*C(i)] = 0
C
C             (BETA*N/ALPHA) - (BETA/ALPHA)*SUM[B(i)*EXP(B(i))] +
C             (BETA/ALPHA)*SUM[B(i)] = 0
C
C           WHERE
C
C             BETA     = SHAPE PARAMETER
C             ALPHA    = SCALE PARAMETER
C             A(i)     = LOG(X(i)]
C             B(i)     = (ALPHA*X(i))**BETA
C             C(i)     = LOG(ALPHA*X(i))
C
C     REFERENCE--DHILLON (1981), "LIFE DISTRIBUTIONS", IEEE
C                TRANSACTIONS ON RELIABILITY, VOL. R-30, NO. 5,
C                PP. 457-459.
C              --JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C             -- SMITH AND BAIN, "AN EXPONENTIAL POWER LIFE-TESTING
C                DISTRIBUTION", COMMUNICATIONS IN STATISITCS, 1975,
C                PP. 469-481.
C     WRITTEN BY--ALAN HECKERT
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2899
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2010/7
C     ORIGINAL VERSION--JULY      2010. EXTRACTED AS A SEPARATE
C                                       SUBROUTINE (FROM DPMLAL)
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
      DIMENSION Y(*)
      DIMENSION TEMP1(*)
      DIMENSION TEMP2(*)
      DIMENSION DISPAR(*)
      DIMENSION DISPA2(1)
      INTEGER   IPPCAP(2)
      DOUBLE PRECISION DTEMP1(*)
C
      EXTERNAL PEXFUN
C
      DOUBLE PRECISION DPPF
      DOUBLE PRECISION TOL
      DOUBLE PRECISION XPAR(2)
      DOUBLE PRECISION FVEC(2)
C
      CHARACTER*4 ISUBRO
      CHARACTER*4 IBUGA3
      CHARACTER*4 IERROR
C
      CHARACTER*4 IWRITE
      CHARACTER*40 IDIST
C
      CHARACTER*4 ISUBN1
      CHARACTER*4 ISUBN2
      CHARACTER*4 ISTEPN
C
      CHARACTER*4 IADEDF
      CHARACTER*4 IGEPDF
      CHARACTER*4 IMAKDF
      CHARACTER*4 IBEIDF
      CHARACTER*4 ILGADF
      CHARACTER*4 ISKNDF
      CHARACTER*4 IGLDDF
      CHARACTER*4 IBGEDF
      CHARACTER*4 IGETDF
      CHARACTER*4 ICONDF
      CHARACTER*4 IGOMDF
      CHARACTER*4 IKATDF
      CHARACTER*4 IGIGDF
      CHARACTER*4 IGEODF
      CHARACTER*4 ICASPL
      CHARACTER*4 ICASP2
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
      ISUBN1='PEXM'
      ISUBN2='L1  '
C
      IERROR='NO'
      IWRITE='OFF'
C
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
  999   FORMAT(1X)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,51)
   51   FORMAT('**** AT THE BEGINNING OF GL5ML3--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,52)IBUGA3,ISUBRO,N
   52   FORMAT('IBUGA3,ISUBRO,N = ',A4,2X,A4,2X,I8)
        CALL DPWRST('XXX','WRIT')
        DO56I=1,MIN(N,100)
          WRITE(ICOUT,57)I,Y(I)
   57     FORMAT('I,Y(I) = ',I8,G15.7)
          CALL DPWRST('XXX','WRIT')
   56   CONTINUE
      ENDIF
C
C               ****************************************************
C               **  STEP 2--                                      **
C               **  CARRY OUT CALCULATIONS                        **
C               **  FOR ALPHA MLE ESTIMATE                        **
C               ****************************************************
C
      ISTEPN='2'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IDIST='EXPONENTIAL POWER'
      SCALML=CPUMIN
      BETAML=CPUMIN
C
      IFLAG=2
      CALL SUMRAW(Y,N,IDIST,IFLAG,
     1            XMEAN,XVAR,XSD,XMIN,XMAX,
     1            ISUBRO,IBUGA3,IERROR)
      IF(IERROR.EQ.'YES')GOTO9000
C
C               **********************************
C               **  STEP 21--                   **
C               **  CARRY OUT CALCULATIONS      **
C               **  FOR ALPHA MLE               **
C               **  ESTIMATE (FULL SAMPLE CASE) **
C               **********************************
C
      ISTEPN='21'
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'MLAL')
     1CALL TRACE2(ISTEPN,ISUBN1,ISUBN2)
C
      IF(BETASV.GT.0.0 .AND. SCALSV.GT.0.0)THEN
        XPAR(1)=DBLE(BETASV)
        XPAR(2)=DBLE(SCALSV)
      ELSE
C
C       IF NO STARTING VALUES SPECIFIED, COMPUTE STARTING
C       VALUES BASED ON PPCC METHOD.
C
        CALL UNIMED(N,TEMP1)
        CALL SORT(Y,N,Y)
        ICASP2='PEXP'
        ICASPL='PPCC'
        IPPCAP(1)=100
        IPPCAP(2)=1
C
C       OBTAIN LOWER/UPPER LIMITS FOR SHAPE PARAMETER
C
        CALL EXTPA2(ICASP2,IDIST,A,B,
     1              SHAP11,SHAP12,SHAP21,SHAP22,
     1              SHAPE1,SHAPE2,SHAPE3,SHAPE4,SHAPE5,
     1              IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1              ILGADF,ISKNDF,IGLDDF,IBGEDF,
     1              IGETDF,ICONDF,IGOMDF,IKATDF,
     1              IGIGDF,IGEODF,
     1              ISUBRO,IBUGA3,IERROR)
C
C       CREATE ARRAY FOR THE CANDIDATE VALUES OF SHAPE PARAMETER
C
        NUMSHA=1
        CALL DPPPC7(ICASPL,ICASP2,IPPCAP,
     1              SHAP11,SHAP12,SHAP21,SHAP22,
     1              SHAPE1,SHAPE2,SHAPE3,SHAPE4,
     1              XMIN,XMAX,A,B,
     1              DISPAR,DISPA2,NUMDIS,NUMSHA,
     1              IADEDF,IGEPDF,IMAKDF,IBEIDF,
     1              ILGADF,ISKNDF,IGLDDF,IBGEDF,IGETDF,
     1              ICONDF,IGOMDF,IKATDF,IGIGDF,IGEODF,
     1              IBUGA3,ISUBRO,IERROR)
C
        CORRMX=-1.0
        IWRITE='OFF'
        DO1010IDIS=1,NUMDIS
          SHAPE=DISPAR(IDIS)
          DO1020I=1,N
            CALL PEXPPF(DBLE(TEMP1(I)),DBLE(SHAPE),DPPF)
            TEMP2(I)=REAL(DPPF)
 1020     CONTINUE
          CALL CORR(Y,TEMP2,N,IWRITE,CC,IBUGA3,IERROR)
          IF(CC.GT.CORRMX)THEN
            SHAPE1=SHAPE
            CALL LINFI2(Y,TEMP2,N,PPA0,PPA1,ISUBRO,IBUGA3,IERROR)
            CORRMX=CC
            SCALE2=PPA1
          ENDIF
 1010   CONTINUE
        XPAR(1)=DBLE(SHAPE1)
        XPAR(2)=DBLE(SCALE2)
      ENDIF
C
      IOPT=2
      TOL=1.0D-5
      NVAR=2
      NPRINT=-1
      INFO=0
      CALL DNSQE(PEXFUN,JAC,IOPT,NVAR,XPAR,FVEC,TOL,NPRINT,INFO,
     1           DTEMP1,MAXNXT,Y,N)
C
      BETAML=REAL(XPAR(1))
      SCALML=1.0/REAL(XPAR(2))
C
 9000 CONTINUE
      IF(IBUGA3.EQ.'ON'.OR.ISUBRO.EQ.'XML1')THEN
        WRITE(ICOUT,999)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9011)
 9011   FORMAT('**** AT THE END OF PEXML1--')
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9013)N,XMEAN,XSD,XMIN,XMAX
 9013   FORMAT('N,XMEAN,XSD,XMIN,XMAX = ',I8,4G15.7)
        CALL DPWRST('XXX','WRIT')
        WRITE(ICOUT,9017)BETAML,SCALML
 9017   FORMAT('BETAML,SCALML =  ',2G15.7)
        CALL DPWRST('XXX','WRIT')
      ENDIF
C
      RETURN
      END
      SUBROUTINE PEXPDF(DX,DBETA,DPDF)
CCCCC SUBROUTINE PEXPDF(X,ALPHA,BETA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY DENSITY
C              FUNCTION VALUE FOR THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA AND SCALE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PROBABILITY DENSITY FUNCTION
C
C              f(X;BETA) = BETA*X**(BETA-1)A*EXP(X**BETA)*
C                          EXP(1 - EXP(X**BETA))
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE.
C
C     INPUT  ARGUMENTS--DX     = THE DOUBLE PRECISION VALUE AT
C                                WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                     --DBETA  = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER
C     OUTPUT ARGUMENTS--DPDF   = THE DOUBLE PRECISION PROBABILITY
C                                DENSITY FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY DENSITY
C             FUNCTION VALUE DPDF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS. 
C     RESTRICTIONS--X SHOULD BE NON-NEGATIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--EXP.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN. 
C     REFERENCES--JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C                 SMITH AND BAIN, "AN EXPONENTIAL POWER LIFE-TESTING
C                 DISTRIBUTION", COMMUNICATIONS IN STATISITCS, 1975,
C                 PP. 469-481.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     ORIGINAL VERSION--DECEMBER  1995. 
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C     UPDATED         --NOVEMBER  2007. MAKE ARGUMENTS DOUBLE PRECISON
C
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DX
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DPDF
      DOUBLE PRECISION DTERM1, DTERM2, DTERM3, DTERM4, DTERM5
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C---------------------------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
C     NOTE: IF BETA < 1, THEN PDF IS INFINITE AT X = 0.
C
      DPDF=0.0D0
      IF(DBETA.GE.1.0D0)THEN
        IF(DX.LT.0.0D0)THEN
          WRITE(ICOUT,4)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,46)DX
          CALL DPWRST('XXX','BUG')
          GOTO9999
        ENDIF
      ELSE
        IF(DX.LE.0.0D0)THEN
          WRITE(ICOUT,5)
          CALL DPWRST('XXX','BUG')
          WRITE(ICOUT,46)DX
          CALL DPWRST('XXX','BUG')
          GOTO9999
        ENDIF
      ENDIF
CCCCC IF(ALPHA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,14)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,46)ALPHA
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   GOTO9999
CCCCC ENDIF
      IF(DBETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DBETA
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXPDF IS NEGATIVE.')
    5 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXPDF IS ',
     1       'NON-POSITIVE.')
CCC14 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO')
CCC15 FORMAT('      THE PEXPDF SUBROUTINE IS ZERO OR NEGATIVE *****')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PEXPDF IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
C-----START POINT-----------------------------------------------------
C
      DTERM1=DLOG(DBETA)
      DTERM2=(DBETA-1.0D0)*DLOG(DX)
      DTERM3=DX**DBETA
      DTERM4=1.0D0 - DEXP(DX**DBETA)
      DTERM5=DTERM1+DTERM2+DTERM3+DTERM4
      DPDF=DEXP(DTERM5)
C
 9999 CONTINUE
      RETURN
      END 
      SUBROUTINE PEXPPF(DP,DBETA,DPPF)
CCCCC SUBROUTINE PEXPPF(P,ALPHA,BETA,PPF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PERCENT POINT
C              FUNCTION VALUE FOR THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA AND SCALE PARAMETER ALPHA.
C              THIS DISTRIBUTION IS DEFINED FOR ALL NON-NEGATIVE X,
C              AND HAS THE PERCENT POINT FUNCTION
C
C              G(P;BETA) = -{LOG[1 - LOG(1-P)]}**(1/BETA)
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE.
C
C     INPUT  ARGUMENTS--DP     = THE DOUBLE PRECISION VALUE
C                                (BETWEEN 0.0 AND 1.0)
C                                AT WHICH THE PERCENT POINT
C                                FUNCTION IS TO BE EVALUATED.
C                     -DBETA   = THE DOUBLE PRECISION VALUE OF
C                                THE SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--DPPF   = THE DOUBLE PRECISION PERCENT
C                                POINT FUNCTION VALUE.
C     OUTPUT--THE DOUBLE PRECISION PERCENT POINT FUNCTION VALUE DPPF.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--P SHOULD BE BETWEEN 0.0 (INCLUSIVELY)
C                   AND 1.0 (EXCLUSIVELY).
C     OTHER DATAPAC   SUBROUTINES NEEDED--NONE.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DLOG.
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND BALKRISHNAN, CONTINUOUS UNIVARIATE
C                 DISTRIBUTIONS--2, 2ND ED 1994, PAGES 643-644.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE:  301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--96/1
C     ORIGINAL VERSION--JANUARY   1996.
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C     UPDATED         --NOVEMBER  2007. MAKE ARGUMENTS DOUBLE PRECISON
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DOUBLE PRECISION DP
CCCCC DOUBLE PRECISION DALPHA
      DOUBLE PRECISION DBETA
      DOUBLE PRECISION DPPF
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      DPPF=0.0D0
      IF(DP.LT.0.0D0 .OR. DP.GE.1.0D0)THEN
        WRITE(ICOUT,4)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DP
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
CCCCC IF(ALPHA.LE.0.0)THEN
CCCCC   WRITE(ICOUT,14)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,15)
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   WRITE(ICOUT,46)ALPHA
CCCCC   CALL DPWRST('XXX','BUG')
CCCCC   GOTO9999
CCCCC ENDIF
      IF(DBETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,46)DBETA
        CALL DPWRST('XXX','BUG')
        GOTO9999
      ENDIF
    4 FORMAT('***** ERROR--THE FIRST ARGUMENT TO PEXPPF IS OUTSIDE ',
     1       'THE ALLOWABLE (0,1] INTERVAL.')
CCC14 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO')
CCC15 FORMAT('      THE PEXPPF SUBROUTINE IS ZERO OR NEGATIVE *****')
   24 FORMAT('***** ERROR--THE SECOND ARGUMENT TO PEXPPF IS ',
     1       'NON-POSITIVE.')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
C
      IF(DP.LE.0.0D0)THEN
        PPF=0.0
        GOTO9999
      ENDIF
C
      DPPF=DLOG(1.0D0-DLOG(1.0D0-DP))**(1.0D0/DBETA)
C
 9999 CONTINUE
      RETURN
      END
      SUBROUTINE PEXRAN(N,BETA,ISEED,X)
CCCCC SUBROUTINE PEXRAN(N,ALPHA,BETA,ISEED,X)
C
C     PURPOSE--THIS SUBROUTINE GENERATES A RANDOM SAMPLE OF SIZE N
C              FROM THE EXPONENTIAL POWER DISTRIBUTION
C              WITH SHAPE PARAMETER BETA.
C
C              NOTE 11/2007: ROUTINE PREVIOSLY TREATED ALPHA AS A
C                            SHAPE PARAMETER.  CORRECT SO THAT
C                            ALPHA IS A SCALE PARAMETER (AND
C                            SO CAN BE ASSUMED TO BE 1 IN THIS
C                            ROUTINE).
C
C     INPUT  ARGUMENTS--N      = THE DESIRED INTEGER NUMBER
C                                OF RANDOM NUMBERS TO BE
C                                GENERATED.
C                     --BETA  = THE SINGLE PRECISION VALUE OF THE SHAPE
C                               PARAMETER.  BETA SHOULD BE POSITIVE.
C     OUTPUT ARGUMENTS--X      = A SINGLE PRECISION VECTOR
C                                (OF DIMENSION AT LEAST N)
C                                INTO WHICH THE GENERATED
C                                RANDOM SAMPLE WILL BE PLACED.
C     OUTPUT--A RANDOM SAMPLE OF SIZE N
C             FROM THE POWER EXPONENTIAL DISTRIBUTION
C             WITH SHAPE PARAMETER VALUES = ALPHA AND BETA.
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--THERE IS NO RESTRICTION ON THE MAXIMUM VALUE
C                   OF N FOR THIS SUBROUTINE.
C                 --BETA SHOULD BE POSITIVE.
C     OTHER DATAPAC   SUBROUTINES NEEDED--UNIRAN, PEXPPF.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--NONE.
C     MODE OF INTERNAL OPERATIONS--SINGLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2001.10
C     ORIGINAL VERSION--OCTOBER   2001.
C     UPDATED         --NOVEMBER  2007. ALPHA IS A SCALE PARAMETER,
C                                       SO ASSUME = 1
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      DIMENSION X(*)
C
      DOUBLE PRECISION DTEMP
C
C---------------------------------------------------------------------
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
C-----START POINT-----------------------------------------------------
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(N.LT.1)THEN
        WRITE(ICOUT, 5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT, 6)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)N
        CALL DPWRST('XXX','BUG ')
        GOTO9000
      ENDIF
    5 FORMAT('***** ERROR--THE REQUESTED NUMBER OF EXPONENTIAL ',
     1       'POWER')
    6 FORMAT('      RANDOM NUMBERS IS NON-POSITIVE.')
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
      IF(BETA.LE.0.0D0)THEN
        WRITE(ICOUT,24)
        CALL DPWRST('XXX','BUG')
        WRITE(ICOUT,47)BETA
        CALL DPWRST('XXX','BUG')
        GOTO9000
      ENDIF
   24 FORMAT('***** ERROR--THE VALUE OF THE BETA SHAPE PARAMETER ',
     1       'IS NON-POSITIVE.')
C
C     GENERATE N UNIFORM (0,1) RANDOM NUMBERS;
C
      CALL UNIRAN(N,ISEED,X)
C
C     GENERATE N EXPONENTIAL POWER DISTRIBUTION RANDOM NUMBERS
C     USING THE PERCENT POINT FUNCTION TRANSFORMATION METHOD.
C
      DO100I=1,N
        CALL PEXPPF(DBLE(X(I)),DBLE(BETA),DTEMP)
        X(I)=REAL(DTEMP)
  100 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
      SUBROUTINE PHASMP(A,ZINV,K,PP,QQ) 
C THIS ROUTINE DOES PHASE-AMPLITUDE CALCULATIONS FOR BESSEL FUNCTIONS.
C A IS THE ORDER OF THE FUNCTION, AT MOST 1 IN ABSOLUTE VALUE.  ZINV IS
C 2./Z, WHERE Z IS THE ARGUMENT.  TO ACHIEVE 14 FIGURES ACCURACY, ABS(Z)
C MUST BE AT LEAST 14, OR A MUST BE .5 OR -.5.  IF K=0, PHASMP RETURNS
C PP AND QQ FOR EQUATIONS 9.2.5 TO 9.2.8 OF REFERENCE (1) LISTED IN
C BESJCF.  IF K=1 (-1) PHASMP RETURNS PP FOR EQUATION 9.7.2 (9.7.1).
C
C-----COMMON----------------------------------------------------------
C
      INCLUDE 'DPCOMC.INC'
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      COMPLEX PP,QQ,ZI,ZINV,TERM(25),ZDUMMY
C-----------------------------------------------------------------------
C
C  MACHINE DEPENDENT CONSTANTS.
C  ---------------------------
C
      SAVE ISAVE, DYOUK
      DATA ISAVE /1/
      DATA TERM(1)/(1.,0.)/
C
C Definition of real and imaginary parts of complex number,
C standard Fortran and will work on Convex with -r8 -i8.
      REALP(ZDUMMY) = REAL(ZDUMMY)
      AIMAGP(ZDUMMY) = REAL((0,-1)*ZDUMMY)
C
      IF (ISAVE.GT.0) THEN
        ISAVE = 0
        DYOUK = R1MACH (4)
      ENDIF
C
C-----------------------------------------------------------------------
      ZI=.0625*ZINV 
      S=K 
      IF(K.EQ.0) S=-1.
      C=(DBLE(2.*A))**2-1.D0
      DO 1 N=1,24
      IF(K.EQ.0) S=-S
      TERM(N+1)=TERM(N)*ZI*(S*(C/REAL(N)+REAL(4-4*N)))
      IF(MAX(ABS(REALP(TERM(N+1))),ABS(AIMAGP(TERM(N+1)))).LE.DYOUK)
     1 GO TO 2
    1 CONTINUE
      N=25
    2 PP = (0.0, 0.0)
      QQ = (0.0, 0.0)
      IF ((K .NE. 0) .OR. (MOD (N, 2) .NE. 0)) GO TO 4
    3 QQ=QQ+TERM(N) 
      N=N-1
    4 PP=PP+TERM(N) 
      N=N-1
      IF(N.EQ.0) RETURN
CCCCC IF(K) 4,3,4
      IF(K.EQ.0) GOTO3
      GOTO4
      END 
      DOUBLE PRECISION FUNCTION PHI(Z)
*     
*     Normal distribution probabilities accurate to 1.e-15.
*     Z = no. of standard deviations from the mean.
*     
*     Based upon algorithm 5666 for the error function, from:
*     Hart, J.F. et al, 'Computer Approximations', Wiley 1968
*     
*     Programmer: Alan Miller
*     
*     Latest revision - 30 March 1986
*     
      DOUBLE PRECISION P0, P1, P2, P3, P4, P5, P6, 
     &     Q0, Q1, Q2, Q3, Q4, Q5, Q6, Q7,
     &     Z, P, EXPNTL, CUTOFF, ROOTPI, ZABS
      PARAMETER(
     &     P0 = 220.20 68679 12376 1D0,
     &     P1 = 221.21 35961 69931 1D0, 
     &     P2 = 112.07 92914 97870 9D0,
     &     P3 = 33.912 86607 83830 0D0,
     &     P4 = 6.3739 62203 53165 0D0,
     &     P5 = .70038 30644 43688 1D0, 
     &     P6 = .035262 49659 98910 9D0)
      PARAMETER(
     &     Q0 = 440.41 37358 24752 2D0,
     &     Q1 = 793.82 65125 19948 4D0, 
     &     Q2 = 637.33 36333 78831 1D0,
     &     Q3 = 296.56 42487 79673 7D0, 
     &     Q4 = 86.780 73220 29460 8D0,
     &     Q5 = 16.064 17757 92069 5D0, 
     &     Q6 = 1.7556 67163 18264 2D0,
     &     Q7 = .088388 34764 83184 4D0)
      PARAMETER(ROOTPI = 2.5066 28274 63100 1D0)
      PARAMETER(CUTOFF = 7.0710 67811 86547 5D0)
*     
      ZABS = ABS(Z)
*     
*     |Z| > 37
*     
      IF (ZABS .GT. 37) THEN
         P = 0
      ELSE
*     
*     |Z| <= 37
*     
         EXPNTL = EXP(-ZABS**2/2)
*     
*     |Z| < CUTOFF = 10/SQRT(2)
*     
         IF (ZABS .LT. CUTOFF) THEN
            P = EXPNTL*((((((P6*ZABS + P5)*ZABS + P4)*ZABS + P3)*ZABS
     &           + P2)*ZABS + P1)*ZABS + P0)/(((((((Q7*ZABS + Q6)*ZABS
     &           + Q5)*ZABS + Q4)*ZABS + Q3)*ZABS + Q2)*ZABS + Q1)*ZABS
     &           + Q0)
*     
*     |Z| >= CUTOFF.
*     
         ELSE
            P = EXPNTL/(ZABS + 1/(ZABS + 2/(ZABS + 3/(ZABS + 4/
     &           (ZABS + 0.65D0)))))/ROOTPI
         END IF
      END IF
      IF (Z .GT. 0) P = 1 - P
      PHI = P
C
      RETURN
      END
      DOUBLE PRECISION FUNCTION PHINV(P)
*
*	ALGORITHM AS241  APPL. STATIST. (1988) VOL. 37, NO. 3
*
*	Produces the normal deviate Z corresponding to a given lower
*	tail area of P.
*
*	The hash sums below are the sums of the mantissas of the
*	coefficients.   They are included for use in checking
*	transcription.
*
      DOUBLE PRECISION SPLIT1, SPLIT2, CONST1, CONST2, 
     &     A0, A1, A2, A3, A4, A5, A6, A7, B1, B2, B3, B4, B5, B6, B7, 
     &     C0, C1, C2, C3, C4, C5, C6, C7, D1, D2, D3, D4, D5, D6, D7, 
     &     E0, E1, E2, E3, E4, E5, E6, E7, F1, F2, F3, F4, F5, F6, F7, 
     &     P, Q, R
      PARAMETER (SPLIT1 = 0.425, SPLIT2 = 5,
     &     CONST1 = 0.180625D0, CONST2 = 1.6D0)
*     
*     Coefficients for P close to 0.5
*     
      PARAMETER (
     &     A0 = 3.38713 28727 96366 6080D0,
     &     A1 = 1.33141 66789 17843 7745D+2,
     &     A2 = 1.97159 09503 06551 4427D+3,
     &     A3 = 1.37316 93765 50946 1125D+4,
     &     A4 = 4.59219 53931 54987 1457D+4,
     &     A5 = 6.72657 70927 00870 0853D+4,
     &     A6 = 3.34305 75583 58812 8105D+4,
     &     A7 = 2.50908 09287 30122 6727D+3,
     &     B1 = 4.23133 30701 60091 1252D+1,
     &     B2 = 6.87187 00749 20579 0830D+2,
     &     B3 = 5.39419 60214 24751 1077D+3,
     &     B4 = 2.12137 94301 58659 5867D+4,
     &     B5 = 3.93078 95800 09271 0610D+4,
     &     B6 = 2.87290 85735 72194 2674D+4,
     &     B7 = 5.22649 52788 52854 5610D+3)
*     HASH SUM AB    55.88319 28806 14901 4439
*     
*     Coefficients for P not close to 0, 0.5 or 1.
*     
      PARAMETER (
     &     C0 = 1.42343 71107 49683 57734D0,
     &     C1 = 4.63033 78461 56545 29590D0,
     &     C2 = 5.76949 72214 60691 40550D0,
     &     C3 = 3.64784 83247 63204 60504D0,
     &     C4 = 1.27045 82524 52368 38258D0,
     &     C5 = 2.41780 72517 74506 11770D-1,
     &     C6 = 2.27238 44989 26918 45833D-2,
     &     C7 = 7.74545 01427 83414 07640D-4,
     &     D1 = 2.05319 16266 37758 82187D0,
     &     D2 = 1.67638 48301 83803 84940D0,
     &     D3 = 6.89767 33498 51000 04550D-1,
     &     D4 = 1.48103 97642 74800 74590D-1,
     &     D5 = 1.51986 66563 61645 71966D-2,
     &     D6 = 5.47593 80849 95344 94600D-4,
     &     D7 = 1.05075 00716 44416 84324D-9)
*     HASH SUM CD    49.33206 50330 16102 89036
*
*   Coefficients for P near 0 or 1.
*
      PARAMETER (
     &     E0 = 6.65790 46435 01103 77720D0,
     &     E1 = 5.46378 49111 64114 36990D0,
     &     E2 = 1.78482 65399 17291 33580D0,
     &     E3 = 2.96560 57182 85048 91230D-1,
     &     E4 = 2.65321 89526 57612 30930D-2,
     &     E5 = 1.24266 09473 88078 43860D-3,
     &     E6 = 2.71155 55687 43487 57815D-5,
     &     E7 = 2.01033 43992 92288 13265D-7,
     &     F1 = 5.99832 20655 58879 37690D-1,
     &     F2 = 1.36929 88092 27358 05310D-1,
     &     F3 = 1.48753 61290 85061 48525D-2,
     &     F4 = 7.86869 13114 56132 59100D-4,
     &     F5 = 1.84631 83175 10054 68180D-5,
     &     F6 = 1.42151 17583 16445 88870D-7,
     &     F7 = 2.04426 31033 89939 78564D-15)
*     HASH SUM EF    47.52583 31754 92896 71629
*     
      Q = ( 2*P - 1 )/2
      IF ( ABS(Q) .LE. SPLIT1 ) THEN
         R = CONST1 - Q*Q
         PHINV = Q*(((((((A7*R + A6)*R + A5)*R + A4)*R + A3)
     &        *R + A2)*R + A1)*R + A0) /
     &        (((((((B7*R + B6)*R + B5)*R + B4)*R + B3)
     &        *R + B2)*R + B1)*R + 1)
      ELSE
         R = MIN( P, 1 - P )
         IF (R .GT. 0) THEN
            R = SQRT( -LOG(R) )
            IF ( R .LE. SPLIT2 ) THEN
               R = R - CONST2
               PHINV = (((((((C7*R + C6)*R + C5)*R + C4)*R + C3)
     &              *R + C2)*R + C1)*R + C0) /
     &              (((((((D7*R + D6)*R + D5)*R + D4)*R + D3)
     &              *R + D2)*R + D1)*R + 1)
            ELSE
               R = R - SPLIT2
               PHINV = (((((((E7*R + E6)*R + E5)*R + E4)*R + E3)
     &              *R + E2)*R + E1)*R + E0) /
     &              (((((((F7*R + F6)*R + F5)*R + F4)*R + F3)
     &              *R + F2)*R + F1)*R + 1)
            END IF
         ELSE
            PHINV = 9
         END IF
         IF ( Q .LT. 0 ) PHINV = - PHINV
      END IF
C
      RETURN
      END
      SUBROUTINE PIGPDF(X,THETA,ALPHA,PDF)
C
C     PURPOSE--THIS SUBROUTINE COMPUTES THE PROBABILITY MASS
C              FUNCTION VALUE AT THE DOUBLE PRECISION VALUE X
C              FOR THE POISSON-INVERSE GAUSSIAN DISTRIBUTION
C              WITH DOUBLE PRECISION SHAPE PARAMETERS ALPHA AND
C              THETA.  THIS DISTRIBUTION IS DEFINED FOR ALL
C              NON-NEGATIVE INTEGER X = 0, 1, 2, ...
C              THIS DISTRIBUTION HAS THE PROBABILITY FUNCTION
C              p(X;ALPHA,THETA) = SQRT(2*ALPHA/PI)*
C                  EXP(ALPHA*SQRT(1-THETA))*(ALPHA*THETA/2)**X*
C                  K(X-1/2)(ALPHA)/X!
C                  ALPHA > 0; 0 < THETA < 1
C                  K(V) IS THE MODIFIED BESSEL FUNCTION
C     INPUT  ARGUMENTS--X      = THE DOUBLE PRECISION VALUE
C                                AT WHICH THE PROBABILITY DENSITY
C                                FUNCTION IS TO BE EVALUATED.
C                                X SHOULD BE A NON-NEGATIVE INTEGR
C                     --ALPHA  = THE DOUBLE PRECISION VALUE
C                                OF THE FIRST SHAPE PARAMETER.
C                     --THETA  = THE DOUBLE PRECISION VALUE
C                                OF THE SECOND SHAPE PARAMETER.
C     OUTPUT ARGUMENTS--PDF    = THE DOUBLE PRECISION PROBABILITY
C                                MASS FUNCTION VALUE
C     OUTPUT--THE DOUBLE PRECISION PROBABILITY MASS
C             FUNCTION VALUE PDF
C             FOR THE POISSON-INVERSE GAUSSIAN DISTRIBUTION
C     PRINTING--NONE UNLESS AN INPUT ARGUMENT ERROR CONDITION EXISTS.
C     RESTRICTIONS--X SHOULD BE A NON-NEGATIVE INTEGER
C                 --0 < THETA < 1,  AND ALPHA > 0
C     OTHER DATAPAC   SUBROUTINES NEEDED--LNGAMM, DBESK.
C     FORTRAN LIBRARY SUBROUTINES NEEDED--DEXP, DLOG
C     MODE OF INTERNAL OPERATIONS--DOUBLE PRECISION.
C     LANGUAGE--ANSI FORTRAN (1977)
C     REFERENCES--JOHNSON, KOTZ, AND KEMP (1992).  "UNIVARIATE
C                 DISCRETE DISTRIBUTIONS", SECOND EDITION, 
C                 WILEY, PP. 455-457.
C     WRITTEN BY--JAMES J. FILLIBEN
C                 STATISTICAL ENGINEERING DIVISION
C                 INFORMATION TECHNOLOGY LABORATORY
C                 NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY
C                 GAITHERSBURG, MD 20899-8980
C                 PHONE--301-975-2855
C     NOTE--DATAPLOT IS A REGISTERED TRADEMARK
C           OF THE NATIONAL INSTITUTE OF STANDARDS AND TECHNOLOGY.
C           THIS SUBROUTINE MAY NOT BE COPIED, EXTRACTED,
C           MODIFIED, OR OTHERWISE USED IN A CONTEXT
C           OUTSIDE OF THE DATAPLOT LANGUAGE/SYSTEM.
C     LANGUAGE--ANSI FORTRAN (1977)
C     VERSION NUMBER--2006/7
C     ORIGINAL VERSION--JULY      2006.
C
C-----CHARACTER STATEMENTS FOR NON-COMMON VARIABLES-------------------
C
C---------------------------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
C---------------------------------------------------------------------
C
      REAL CPUMIN
      REAL CPUMAX
      DOUBLE PRECISION Y(1)
C
      CHARACTER*4 IFEEDB
      CHARACTER*4 IPRINT
      CHARACTER*240 ICOUT
C
      COMMON /MACH/IRD,IPR,CPUMIN,CPUMAX,NUMBPC,NUMCPW,NUMBPW
      COMMON /PRINT/IFEEDB,IPRINT
      COMMON /TEXTOU/ICOUT,NCOUT,ILOUT
C
      DATA DPI / 3.1415926535 8979323846 2643383279 503 D0 /
C
C-----START POINT-----------------------------------------------------
C
      PDF=0.0
C
C     CHECK THE INPUT ARGUMENTS FOR ERRORS
C
      IF(THETA.LE.0.0 .OR. THETA.GE.1.0)THEN
        WRITE(ICOUT,11)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)THETA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
C
      IF(ALPHA.LE.0.0)THEN
        WRITE(ICOUT,12)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,46)ALPHA
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
      INTX=X+0.5
      IF(INTX.LT.0)THEN
        WRITE(ICOUT,5)
        CALL DPWRST('XXX','BUG ')
        WRITE(ICOUT,47)INTX
        CALL DPWRST('XXX','BUG ')
        PDF=0.0
        GOTO9999
      ENDIF
C
    5 FORMAT('***** ERROR--THE FIRST INPUT ARGUMENT TO THE PIGPDF ',
     1'SUBROUTINE IS NON-POSITIVE')
   11 FORMAT('***** ERROR--THE SECOND INPUT ARGUMENT TO THE ',
     1' PIGPDF SUBROUTINE IS OUTSIDE THE ALLOWABLE (0,1) INTERVAL')
   12 FORMAT('***** ERROR--THE THIRD INPUT ARGUMENT TO THE ',
     1' PIGPDF SUBROUTINE IS NON-POSITIVE')
   46 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',G15.7)
   47 FORMAT('***** THE VALUE OF THE ARGUMENT IS ',I8)
C
      DX=DBLE(INTX)
C
      DTERM1=0.5D0*(DLOG(2.0D0) + DLOG(ALPHA) - DLOG(DPI))
      DTERM2=ALPHA*DSQRT(1.0D0 - THETA)
      DTERM3=DX*(DLOG(ALPHA) + DLOG(THETA) - DLOG(2.0D0))
      IF(INTX.EQ.0)THEN
        DTERM4=-ALPHA + 0.5D0*(DLOG(DPI) - DLOG(2.0D0*ALPHA))
      ELSEIF(INTX.EQ.1)THEN
        DTERM4=-ALPHA + 0.5D0*(DLOG(DPI) - DLOG(2.0D0*ALPHA))
      ELSE
        FNU=DX-0.5
        KODE=1
        N=1
        CALL DBESK(ALPHA,FNU,KODE,N,Y,NZ)
        DTERM4=DBLE(Y(1))
        IF(DTERM4.GE.0.0D0)THEN
          DTERM4=DLOG(DTERM4)
        ELSE
          PDF=0.0D0
          GOTO9999
        ENDIF
      ENDIF
      DTERM5=DLNGAM(DX+1.0D0)
      DPDF=DTERM1 + DTERM2 + DTERM3 + DTERM4 - DTERM5
      PDF=DEXP(DPDF)
C
 9999 CONTINUE
      RETURN
      END
      REAL FUNCTION PKS2(N, D)
C     ALGORITHM 487 COLLECTED ALGORITHMS FROM ACM.
C     ALGORITHM APPEARED IN COMM. ACM, VOL. 17, NO. 12,
C     P. 703.
      INTEGER N
C N IS THE SAMPLE SIZE USED.
      REAL D
C D IS THE MAXIMUM MAGNITUDE (OF THE DISCREPANCY
C BETWEEN THE EMPIRICAL AND PROPOSED DISTRIBUTIONS)
C IN EITHER THE POSITIVE OR NEGATIVE DIRECTION.
C PKS2 IS THE EXACT PROBABILITY OF OBTAINING A
C DEVIATION NO LARGER THAN D.
C THESE FORMULAS APPEAR AS (23) AND (24) IN
C J. DURBIN.  THE PROBABILITY THAT THE SAMPLE
C DISTRIBUTION FUNCTION LIES BETWEEN TWO PARALLEL
C STRAIGHT LINES. ANNALS OF MATHEMATICAL STATISTICS
C 39, 2(APRIL 1968),398-411.
      DOUBLE PRECISION Q(141), FACT(141), SUM, CI,
     * FT, FU, FV
      IF (N.EQ.1) GO TO 90
      FN = FLOAT(N)
      FND = FN*D
      NDT = IFIX(2.*FND)
      IF (NDT.LT.1) GO TO 100
      ND = IFIX(FND)
      NDD = MIN0(2*ND,N)
      NDP = ND + 1
      NDDP = NDD + 1
      FACT(1) = 1.
      CI =