License: distributable
Source: rhd-dg-en-%{version}.tbz
Release: 3
Name: rhd-dg-en
Group: Documentation
Version: 4
Summary: The Red Hat Desktop %{version} Deployment Guide in HTML format.
BuildArch: noarch
Buildroot: %{_tmppath}/%{name}-%{version}-buildroot
Requires: htmlview

%description
The Red Hat Desktop Deployment Guide is intended to address the
more general topic of system administration and the GNOME Desktop.
Topics include the GConf editor tool, GNOME Panel configuration,
and remote desktop administration.

The %{name} package contains the Red Hat Desktop %{version}
Deployment Guide in HTML format.  PDF, RPM, HTML tarball, and
browsable HTML formats are available from the Red Hat Docs webpage at
http://www.redhat.com/docs/.

%prep
%define _builddir %(mkdir -p %{buildroot}%{_defaultdocdir} ; echo %{buildroot}%{_defaultdocdir})
%setup -q -c
for i in *
do
if [ -d $i ]; then
   cd $i
   mv -f * ../
   cd ..
   rmdir $i
fi
done

%build
 
%install
mkdir -p $RPM_BUILD_ROOT/usr/share/applications/

cat > $RPM_BUILD_ROOT/usr/share/applications/%{name}.desktop <<'EOF'
[Desktop Entry]
Name=Red Hat Desktop Deployment Guide
Comment=Read about desktop administration and configuration
Exec=htmlview file:%{_defaultdocdir}/%{name}-%{version}/index.html
Icon=/%{_defaultdocdir}/%{name}-%{version}/docs.png
Categories=Documentation;X-Red-Hat-Base;
Type=Application
Encoding=UTF-8
Terminal=false
EOF

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(644,root,root,755)
%{_datadir}/applications/%{name}.desktop
/%{_defaultdocdir}/%{name}-%{version}

%changelog
* Wed Feb 16 2005 John Ha <jha@redhat.com> - 4-2
- rebuilt to fix some entity mix-ups

