# See the file LICENSE for redistribution information.
#
# Copyright (c) 2000
#	Sleepycat Software.  All rights reserved.
#
#	$Id: test076.tcl,v 1.1.1.1.2.2 2000/02/08 00:48:24 noriko Exp $
#
# DB Test 76: Test creation of many small databases in an env
proc test076 { method { ndbs 1000  } { tnum 76 } args } {
	source ./include.tcl

	set omethod [convert_method $method]
	set args [convert_args $method $args]

	cleanup $testdir
	
	set key "key" 
	set data "datamoredatamoredata"

	# Create an env if we weren't passed one.
	set eindex [lsearch -exact $args "-env"]
	if { $eindex == -1 } {
		set deleteenv 1
		set env [eval {berkdb env -create -home} $testdir \
		    {-cachesize {0 102400 1}}]
		error_check_good env [is_valid_env $env] TRUE
		set args "$args -env $env"
	} else {
		set deleteenv 0
	}

	for { set i 0 } { $i < $ndbs } { incr i } {
		set testfile test0$tnum.$i.db
		
		set db [eval {berkdb open -create -truncate -mode 0644}\
		    $args $omethod $testfile]
		error_check_good db_open($i) [is_valid_db $db] TRUE

		error_check_good db_put($i) [$db put $key$i $data$i] 0
		error_check_good db_close($i) [$db close] 0
	}
	
	# We don't want the upgrade tests to grab all these dbs.  :-/
	cleanup $testdir

	if { $deleteenv == 1 } {
		error_check_good env_close [$env close] 0
	}
}
