/* -*- buffer-read-only: t -*-
 *
 *    regcharclass.h
 *
 *    Copyright (C) 2007, 2011 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/regcharclass.pl.
 * Any changes made here will be lost!
 * WARNING: These macros are for internal Perl core use only, and may be
 * changed or removed without notice.
 */


#ifndef PERL_REGCHARCLASS_H_ /* Guard against nested #includes */
#define PERL_REGCHARCLASS_H_

#if 'A' == 65 /* ASCII/Latin1 */
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0C ) ? 1        \
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x0A == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( is_utf8 ) ?                                                         \
	( ( 0xC2 == ((const U8*)s)[0] ) ?                                   \
	    ( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                       \
	: ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
    : ( 0x85 == ((const U8*)s)[0] ) )                                       \
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0C ) ? 1        \
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x0A == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( is_utf8 ) ?                                                         \
	( ( ( 0xC2 == ((const U8*)s)[0] ) && ( 0x85 == ((const U8*)s)[1] ) ) ? 2 : 0 )\
    : ( 0x85 == ((const U8*)s)[0] ) )                                       \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) ? 1        \
    : ( !( is_utf8 ) ) ?                                                    \
	( 0x85 == ((const U8*)s)[0] )                                       \
    : 0 )                                                                   \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0C ) ? 1        \
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x0A == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( 0xC2 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                           \
    : ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0C ) ? 1        \
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x0A == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( 0xC2 == ((const U8*)s)[0] ) && ( 0x85 == ((const U8*)s)[1] ) ) ? 2 : 0 )\
: ((e)-(s) > 0) ?                                                           \
    ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D )              \
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0C ) || 0x85 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x0A == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0A <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x85 == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x9A == ((const U8*)s)[1] ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] <= 0x8A ) || 0xAF == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((const U8*)s)[1] ) && ( 0x9F == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( 0xEF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBC == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x90 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x99 ) || ( 0xA1 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0xA6 ) ) ? 3 : 0 )\
    : ( ( 0xBD == ((const U8*)s)[1] ) && ( 0x81 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x9A == ((const U8*)s)[1] ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] <= 0x8A ) || ( ((const U8*)s)[2] & 0xFE ) == 0xA8 || 0xAF == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x81 == ((const U8*)s)[1] ) && ( 0x9F == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xE3 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( 0x80 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xEF == ((const U8*)s)[0] ) ?\
	    ( ( 0xB7 == ((const U8*)s)[1] ) ?                               \
		( ( 0x90 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0xAF ) ? 3 : 0 )\
	    : ( ( 0xBF == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xBE ) ) ? 3 : 0 )\
	: ( 0xF0 == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ((const U8*)s)[1] == 0x9F || ( ( ((const U8*)s)[1] & 0xEF ) == 0xAF ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( ( ((const U8*)s)[3] & 0xFE ) == 0xBE ) ) ? 4 : 0 )\
	: ( 0xF1 <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0xF3 ) ?      \
	    ( ( ( ( ( ((const U8*)s)[1] & 0xCF ) == 0x8F ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( ( ((const U8*)s)[3] & 0xFE ) == 0xBE ) ) ? 4 : 0 )\
	: ( ( ( ( 0xF4 == ((const U8*)s)[0] ) && ( 0x8F == ((const U8*)s)[1] ) ) && ( 0xBF == ((const U8*)s)[2] ) ) && ( ( ((const U8*)s)[3] & 0xFE ) == 0xBE ) ) ? 4 : 0 ) : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xED == ((const U8*)s)[0] ) ) && ( ( ((const U8*)s)[1] & 0xE0 ) == 0xA0 ) ) && ( ( ((const U8*)s)[2] & 0xC0 ) == 0x80 ) ) ? 3 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x8F == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xD8 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9C == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x85 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x9F == ((const U8*)s)[2] || 0xA0 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x9A == ((const U8*)s)[1] ) ?                                       \
	( ( 0x80 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( 0x9E == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] & 0xFE ) == 0xB4 ) ? 3 : 0 )                \
    : ( ( 0xA0 == ((const U8*)s)[1] ) && ( 0x8B <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x8E ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] <= 0xBE ) ? 3 : 0 )                           \
    : ( 0x81 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x81 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x93 ) || ( 0x95 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0xAF ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] >= 0x90 ) ? 3 : 0 )                           \
    : ( ( 0x87 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x90 ) || ( 0x94 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x9C ) || ( 0x9F <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0xAF ) || ( ((const U8*)s)[1] & 0xFE ) == 0xB8 ) ?\
	3                                                                   \
    : ( 0x91 == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] <= 0x9F ) ? 3 : 0 )                           \
    : ( 0x9D == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] <= 0xB5 ) ? 3 : 0 )                           \
    : ( ( 0x9E == ((const U8*)s)[1] ) && ( ((const U8*)s)[2] >= 0x94 ) ) ? 3 : 0 )\
: ( 0xE3 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x80 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] <= 0x83 ) || ( 0x88 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0xA0 ) || 0xB0 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x85 == ((const U8*)s)[1] ) && ( 0xA4 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xEF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB4 == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] >= 0xBE ) ? 3 : 0 )                           \
    : ( 0xB8 == ((const U8*)s)[1] ) ?                                       \
	( ( ((const U8*)s)[2] <= 0x8F ) ? 3 : 0 )                           \
    : ( 0xB9 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x85 == ((const U8*)s)[2] || 0x86 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0xBB == ((const U8*)s)[1] ) ?                                       \
	( ( 0xBF == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( 0xBE == ((const U8*)s)[1] ) ?                                       \
	( ( 0xA0 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0xBF == ((const U8*)s)[1] ) && ( 0xB0 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0xB8 ) ) ? 3 : 0 )\
: ( 0xF0 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9B == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0xB2 == ((const U8*)s)[2] ) && ( ( ((const U8*)s)[3] & 0xFC ) == 0xA0 ) ) ? 4 : 0 )\
    : ( ( ( 0x9D == ((const U8*)s)[1] ) && ( 0x85 == ((const U8*)s)[2] ) ) && ( 0xB3 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0xBA ) ) ? 4 : 0 )\
: ( ( 0xF3 == ((const U8*)s)[0] ) && ( 0xA0 == ((const U8*)s)[1] ) ) ? 4 : 0 )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x61 == ((const U8*)s)[0] ) ?                                           \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x66 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x69 == ((const U8*)s)[2] || 0x6C == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x69 == ((const U8*)s)[1] || 0x6C == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x68 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x73 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] || 0x74 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x74 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x77 == ((const U8*)s)[0] || 0x79 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0xBF == ((const U8*)s)[1] ) && ( 0xC5 == ((const U8*)s)[2] ) ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( 0x6E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x61 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x66 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x69 == ((const U8*)s)[2] || 0x6C == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x69 == ((const U8*)s)[1] || 0x6C == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x68 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x73 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] || 0x74 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x74 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x77 == ((const U8*)s)[0] || 0x79 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0xBF == ((const U8*)s)[1] ) && ( 0xC5 == ((const U8*)s)[2] ) ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( 0x6E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0xB9 == ((const U8*)s)[1] ) && ( 0xCD == ((const U8*)s)[2] ) ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x93 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x61 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x66 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x69 == ((const U8*)s)[2] || 0x6C == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x69 == ((const U8*)s)[1] || 0x6C == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x68 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x73 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] || 0x74 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x74 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x77 == ((const U8*)s)[0] || 0x79 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0xBC == ((const U8*)s)[1] ) ) && ( 0x6E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x66 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x66 == ((const U8*)s)[1] || 0x69 == ((const U8*)s)[1] || 0x6C == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0x73 == ((const U8*)s)[0] ) && ( 0x73 == ((const U8*)s)[1] || 0x74 == ((const U8*)s)[1] ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x61 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCA == ((const U8*)s)[1] ) && ( 0xBE == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x66 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x66 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x69 == ((const U8*)s)[2] || 0x6C == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x69 == ((const U8*)s)[1] || 0x6C == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x68 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x87 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8C == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x73 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[1] || 0x74 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x74 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x88 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x77 == ((const U8*)s)[0] || 0x79 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xCC == ((const U8*)s)[1] ) && ( 0x8A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xC5 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0xBF == ((const U8*)s)[1] ) && ( 0xC5 == ((const U8*)s)[2] ) ) && ( 0xBF == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xCA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xBC == ((const U8*)s)[1] ) && ( 0x6E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xCE == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFD ) == 0xAC ) ?                        \
	    ( ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB1 == ((const U8*)s)[1] || 0xB7 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB9 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( ( ((const U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xCF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x81 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xCC == ((const U8*)s)[2] ) && ( 0x93 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x85 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCC == ((const U8*)s)[2] ) ?                               \
		( ( 0x88 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( ( ((const U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 0 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x93 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xCC == ((const U8*)s)[4] ) ?                       \
			( ( ( ((const U8*)s)[5] & 0xFE ) == 0x80 ) ? 6 : 4 )\
		    : ( ( 0xCD == ((const U8*)s)[4] ) && ( 0x82 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCD == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x89 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xCD == ((const U8*)s)[2] ) ?                               \
		( ( 0x82 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xCE == ((const U8*)s)[4] ) && ( 0xB9 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xCE == ((const U8*)s)[2] ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x8E == ((const U8*)s)[1] ) && ( 0xCE == ((const U8*)s)[2] ) ) && ( 0xB9 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xD5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xA5 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD6 == ((const U8*)s)[2] ) && ( 0x82 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xB4 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xD5 == ((const U8*)s)[2] ) && ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0xA5 ) || ((const U8*)s)[3] == 0xAB || ((const U8*)s)[3] == 0xB6 ) ) ? 4 : 0 )\
	: ( ( ( 0xBE == ((const U8*)s)[1] ) && ( 0xD5 == ((const U8*)s)[2] ) ) && ( 0xB6 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xE1 == ((const U8*)s)[0] ) ?                                       \
	( ( 0xBC == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[2] & 0xD8 ) == 0x80 ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0xBD == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xF8 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFB ) == 0xB0 ) || ((const U8*)s)[2] == 0xBC ) ) && ( 0xCE == ((const U8*)s)[3] ) ) && ( 0xB9 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 0x46 ) ?                            \
	( ( ( ((const U8*)s)[1] & 0xDF ) == 0x46 ) ?                        \
	    ( ( ( ( ((const U8*)s)[2] & 0xDF ) == 0x49 ) || ( ( ((const U8*)s)[2] & 0xDF ) == 0x4C ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((const U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((const U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xDF ) == 0x46 ) ?                            \
	( ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x46 ) || ( ( ((const U8*)s)[1] & 0xDF ) == 0x49 ) || ( ( ((const U8*)s)[1] & 0xDF ) == 0x4C ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xDF ) == 0x53 ) && ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x53 ) || ( ( ((const U8*)s)[1] & 0xDF ) == 0x54 ) ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0xC3 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x9F == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xC4 == ((const U8*)s)[0] || 0xC7 == ((const U8*)s)[0] ) ?              \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x90 ) ? 2 : 0 )                    \
: ( 0xD6 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x87 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBA == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x96 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x9A ) || 0x9E == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0xBD == ((const U8*)s)[1] ) ?                                       \
	( ( ( ((const U8*)s)[2] & 0xF9 ) == 0x90 ) ? 3 : 0 )                \
    : ( 0xBE == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( ((const U8*)s)[2] & 0xE0 ) == 0x80 ) || ( ( ((const U8*)s)[2] & 0xF0 ) == 0xA0 ) || ( ( ((const U8*)s)[2] & 0xFA ) == 0xB2 ) || ( ( ((const U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ? 3 : 0 )\
    : ( ( 0xBF == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xCA ) == 0x82 ) || ( ( ((const U8*)s)[2] & 0xF7 ) == 0x84 ) || ((const U8*)s)[2] == 0xA4 || ( ( ((const U8*)s)[2] & 0xF7 ) == 0xB4 ) ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] <= 0x86 ) || ( 0x93 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x97 ) ) ) ? 3 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ((const U8*)s)[0] <= 0x7F ) ? 1                                         \
: ( ( ((const U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                \
    2                                                                       \
: ( 0xC4 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xFE ) == 0xB0 ) ? 2 : 0 )                    \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] || 0xB8 == ((const U8*)s)[1] || 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )\
: ( 0xC7 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x87 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                    \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0xBA == ((const U8*)s)[1] ) && ( ( 0x96 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x9A ) || 0x9E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x84 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( ((const U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ((const U8*)s)[0] <= 0x7F ) ? 1                                         \
: ( ( ((const U8*)s)[0] & 0xFE ) == 0xC2 ) ?                                \
    2                                                                       \
: ( 0xC4 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xFE ) == 0xB0 ) ? 2 : 0 )                    \
: ( 0xC5 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x89 == ((const U8*)s)[1] || 0xB8 == ((const U8*)s)[1] || 0xBF == ((const U8*)s)[1] ) ? 2 : 0 )\
: ( 0xC7 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xB0 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0xBC == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ((const U8*)s)[1] & 0xDF ) == 0x9C ) ? 2 : 0 )                    \
: ( 0xE1 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0xBA == ((const U8*)s)[1] ) && ( ( 0x96 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x9A ) || 0x9E == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xE2 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x84 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0xAA ) ) ? 3 : 0 )\
: ( ( ( 0xEF == ((const U8*)s)[0] ) && ( 0xAC == ((const U8*)s)[1] ) ) && ( ((const U8*)s)[2] <= 0x86 ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( 0x09 <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x20 == ((const U8*)s)[0] ) ? 1\
    : (! is_utf8 ) ?                                                        \
	    ( 0x85 == ((const U8*)s)[0] )                                   \
	: ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ?                          \
	    ( ( 0xC2 == ((const U8*)s)[0] ) ?                               \
		( ( 0x85 == ((const U8*)s)[1] ) ? 2 : 0 )                   \
	    : ( ( ( 0xE2 == ((const U8*)s)[0] ) && ( 0x80 == ((const U8*)s)[1] ) ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0x8E || ( ((const U8*)s)[2] & 0xFE ) == 0xA8 ) ) ? 3 : 0 )\
	: 0 )                                                               \
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( ( 0x09 <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x20 == cp || ( 0x20 < cp &&                                              \
( 0x85 == cp || ( 0x85 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	HANGUL_ED: Hangul syllables whose first character is \xED

	0xD000 - 0xD7FF
*/
/*** GENERATED CODE ***/
#define is_HANGUL_ED_utf8_safe(s,e)                                         \
( ( ( ( ( ((e) - (s)) >= 3 ) && ( 0xED == ((const U8*)s)[0] ) ) && ( ( ((const U8*)s)[1] & 0xE0 ) == 0x80 ) ) && ( ( ((const U8*)s)[2] & 0xC0 ) == 0x80 ) ) ? 3 : 0 )

#endif	/* ASCII/Latin1 */

#if 'A' == 193 /* EBCDIC 1047 */ \
     && '\\' == 224 && '[' == 173 && ']' == 189 && '{' == 192 && '}' == 208 \
     && '^' == 95 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121 && '\n' == 21
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x15 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((const U8*)s)[0] ) ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x15 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x15 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x15 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x15 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || 0x51 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x73 == ((const U8*)s)[1] ) ) ? ( ( 0x67 == ((const U8*)s)[2] ) ?\
	    ( ( ( 0x57 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x68 ) ) ? 4 : 0 )\
	: ( ( ( ((const U8*)s)[2] & 0xFE ) == 0x68 ) && ( 0x42 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || 0x51 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xDD == ((const U8*)s)[0] ) ?\
	    ( ( 0x73 == ((const U8*)s)[1] ) ?                               \
		( ( 0x55 == ((const U8*)s)[2] ) ?                           \
		    ( ( ( 0x57 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( ((const U8*)s)[3] & 0xFC ) == 0x70 ) ? 4 : 0 )\
		: ( 0x56 == ((const U8*)s)[2] ) ?                           \
		    ( ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
		: ( ( 0x73 == ((const U8*)s)[2] ) && ( ( ((const U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
	    : 0 )                                                           \
	: ( 0xDF == ((const U8*)s)[0] || 0xEA == ((const U8*)s)[0] || 0xEC == ((const U8*)s)[0] ) ?\
	    ( ( ( ( 0x73 == ((const U8*)s)[1] ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( ( ((const U8*)s)[3] & 0xFE ) == 0x72 ) ) ? 4 : 0 )\
	: ( 0xED == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x52 || ( ( ((const U8*)s)[1] & 0xFD ) == 0x54 ) || ((const U8*)s)[1] == 0x58 || ((const U8*)s)[1] == 0x62 || ( ( ((const U8*)s)[1] & 0xFD ) == 0x64 ) || ( ( ((const U8*)s)[1] & 0xFD ) == 0x68 ) || ( ( ((const U8*)s)[1] & 0xFD ) == 0x71 ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( ( ((const U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 )\
	: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x73 == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) && ( ( ((const U8*)s)[4] & 0xFE ) == 0x72 ) ) ? 5 : 0 ) : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((const U8*)s)[0] ) ) && ( 0x65 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( ((const U8*)s)[3] & 0xFC ) == 0x70 ) ) ? 4 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x41 == ((const U8*)s)[1] || ( 0x54 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( ((const U8*)s)[1] & 0xFC ) == 0x70 ) ?\
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x43 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x42 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x62 == ((const U8*)s)[2] || ( 0x64 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x44 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((const U8*)s)[1] ) && ( ( 0x57 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xCB == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( ((const U8*)s)[1] & 0xE7 ) == 0x41 ) || ( ( ((const U8*)s)[1] & 0xCE ) == 0x42 ) || ((const U8*)s)[1] == 0x4A || ( ( ((const U8*)s)[1] & 0xFC ) == 0x54 ) || ((const U8*)s)[1] == 0x58 || ( ( ((const U8*)s)[1] & 0xFC ) == 0x64 ) || ( ( ((const U8*)s)[1] & 0xFE ) == 0x68 ) || ((const U8*)s)[1] == 0x71 ) ?\
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x64 ) ) ? 3 : 0 )\
    : ( ( 0x70 == ((const U8*)s)[1] ) && ( ( 0x63 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( ((const U8*)s)[1] & 0xFC ) == 0x70 ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( 0x57 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x62 == ((const U8*)s)[1] ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ) ? 3 : 0 )\
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x44 ) || ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] || 0x57 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x45 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x73 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x4A == ((const U8*)s)[2] ) ?                                   \
	    ( ( ( ((const U8*)s)[3] & 0xFE ) == 0x72 ) ? 4 : 0 )            \
	: ( 0x57 == ((const U8*)s)[2] ) ?                                   \
	    ( ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((const U8*)s)[2] ) ?                                   \
	    ( ( ( ((const U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )            \
	: ( 0x66 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x73 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( 0x71 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( ( 0x73 == ((const U8*)s)[2] ) && ( ( 0x57 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x67 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x46 == ((const U8*)s)[2] ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x63 == ((const U8*)s)[1] ) && ( 0x52 == ((const U8*)s)[2] ) ) && ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x69 ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((const U8*)s)[0] ) && ( 0x70 == ((const U8*)s)[1] ) ) && ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( ((const U8*)s)[3] & 0xFC ) == 0x70 ) ) && ( ( 0x41 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x6A ) || ( ((const U8*)s)[4] & 0xFC ) == 0x70 ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xB1 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB8 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x57 == ((const U8*)s)[1] ) && ( 0x70 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBB == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x51 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x73 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x63 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x71 == ((const U8*)s)[1] ) && ( 0x63 == ((const U8*)s)[2] || 0x64 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x41 == ((const U8*)s)[1] ) && ( 0x52 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x86 == ((const U8*)s)[1] ) ?                                           \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ( 0x88 == ((const U8*)s)[0] ) ?                                           \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x73 == ((const U8*)s)[1] ) && ( 0x8F == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x68 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x62 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAF == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xB1 == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB4 == ((const U8*)s)[4] ) && ( 0x68 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB8 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x52 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x63 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB8 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x46 == ((const U8*)s)[5] || 0x52 == ((const U8*)s)[5] || 0x54 == ((const U8*)s)[5] || 0x65 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x72 == ((const U8*)s)[2] ) && ( 0xB8 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x65 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x67 == ((const U8*)s)[1] || 0x68 == ((const U8*)s)[1] ) ?      \
	    ( ( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) || 0x57 == ((const U8*)s)[2] || 0x63 == ((const U8*)s)[2] || 0x70 == ((const U8*)s)[2] ) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e)                             \
( ( 0x81 == ((const U8*)s)[0] ) ?                                           \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x73 == ((const U8*)s)[1] ) && ( 0x8F == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( 0x67 == ((const U8*)s)[1] || 0x68 == ((const U8*)s)[1] ) ?      \
	    ( ( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x6A == ((const U8*)s)[1] ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) || 0x57 == ((const U8*)s)[2] || 0x63 == ((const U8*)s)[2] || 0x70 == ((const U8*)s)[2] ) ) && ( 0xB4 == ((const U8*)s)[3] ) ) && ( 0x68 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8F == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x73 == ((const U8*)s)[1] ) && ( 0x8F == ((const U8*)s)[2] ) ) && ( 0x73 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAB == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x70 == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x66 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x68 == ((const U8*)s)[1] ) && ( 0xB1 == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB5 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x62 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x62 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB1 == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xB1 == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB4 == ((const U8*)s)[2] ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB4 == ((const U8*)s)[2] ) ) && ( 0x68 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xB0 == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAF == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( 0xAB == ((const U8*)s)[0] ) && ( 0x70 == ((const U8*)s)[1] ) ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] || 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((const U8*)s)[0] ) && ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAB == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )\
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 0x86 ) ?                            \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 0x86 ) ?                        \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((const U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 0x86 ) ?                            \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((const U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x8A == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8D == ((const U8*)s)[0] || 0x9C == ((const U8*)s)[0] || ( 0xB3 == ((const U8*)s)[0] || 0xB4 == ((const U8*)s)[0] ) ) ?\
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB8 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x53 == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x63 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x65 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x69 ) || 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x57 == ((const U8*)s)[2] || 0x59 == ((const U8*)s)[2] || 0x63 == ((const U8*)s)[2] || 0x65 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x70 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFC ) == 0x70 ) ? 3 : 0 )\
    : ( 0x71 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x56 ) || 0x59 == ((const U8*)s)[2] || ( ((const U8*)s)[2] & 0xFE ) == 0x62 || ( 0x65 == ((const U8*)s)[2] || 0x66 == ((const U8*)s)[2] ) || 0x70 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x72 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( ((const U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((const U8*)s)[2] & 0xFE ) == 0x44 ) || ((const U8*)s)[2] == 0x48 || ((const U8*)s)[2] == 0x53 || ((const U8*)s)[2] == 0x59 || ( ( ((const U8*)s)[2] & 0xFB ) == 0x62 ) || ((const U8*)s)[2] == 0x65 ) ? 3 : 0 )\
    : ( ( 0x73 == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((const U8*)s)[2] & 0xFE ) == 0x44 ) || ((const U8*)s)[2] == 0x48 || ((const U8*)s)[2] == 0x59 || ( ( ((const U8*)s)[2] & 0xFE ) == 0x62 ) || ((const U8*)s)[2] == 0x65 || ((const U8*)s)[2] == 0x66 || ((const U8*)s)[2] == 0x70 ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((const U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((const U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((const U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((const U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0x60 ) || ((const U8*)s)[0] == 0x79 || ( ( ((const U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x88 ) || ((const U8*)s)[0] == 0xA1 || ( ( ((const U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((const U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((const U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((const U8*)s)[0] & 0xCE ) == 0xC8 ) || ((const U8*)s)[0] == 0xE0 || ( ( ((const U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((const U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((const U8*)s)[0] || ( ((const U8*)s)[0] & 0xFE ) == 0x8A ) ?   \
    ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( ((const U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] || 0x58 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8F == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x67 == ((const U8*)s)[1] || 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x48 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB3 == ((const U8*)s)[0] || 0xB4 == ((const U8*)s)[0] ) ?              \
    ( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( ( 0x65 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x69 ) || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] || 0x52 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((const U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((const U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((const U8*)s)[0] & 0xCC ) == 0x4C ) || ( ( ((const U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0x60 ) || ((const U8*)s)[0] == 0x79 || ( ( ((const U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x88 ) || ((const U8*)s)[0] == 0xA1 || ( ( ((const U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((const U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0xA8 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0xAD ) || ( ( ((const U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((const U8*)s)[0] & 0xCE ) == 0xC8 ) || ((const U8*)s)[0] == 0xE0 || ( ( ((const U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((const U8*)s)[0] == 0xFF ) ? 1\
: ( 0x80 == ((const U8*)s)[0] || ( ((const U8*)s)[0] & 0xFE ) == 0x8A ) ?   \
    ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( ((const U8*)s)[1] & 0xFC ) == 0x70 ) ? 2 : 0 )\
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] || 0x58 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8F == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x67 == ((const U8*)s)[1] || 0x73 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAB == ((const U8*)s)[0] || ( 0xB3 == ((const U8*)s)[0] || 0xB4 == ((const U8*)s)[0] ) ) ?\
    ( ( 0x70 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x63 == ((const U8*)s)[1] ) && ( ( 0x65 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x69 ) || 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] || 0x52 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) && ( 0x67 == ((const U8*)s)[2] ) ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((const U8*)s)[0] & 0xEF ) == 0x05 ) || ((const U8*)s)[0] == 0x0B || ( ( ((const U8*)s)[0] & 0xFE ) == 0x0C ) || ((const U8*)s)[0] == 0x25 || ((const U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((const U8*)s)[0] ) ) ? ( ( 0x41 == ((const U8*)s)[1] ) ?\
		    ( ( 0x55 == ((const U8*)s)[2] || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 1047 */

#if 'A' == 193 /* EBCDIC 037 */ \
     && '\\' == 224 && '[' == 186 && ']' == 187 && '{' == 192 && '}' == 208 \
     && '^' == 176 && '~' == 161 && '!' == 90 && '#' == 123 && '|' == 79 \
     && '$' == 91 && '@' == 124 && '`' == 121 && '\n' == 37
/*
	LNBREAK: Line Break: \R

	"\x0D\x0A"      # CRLF - Network (Windows) line ending
	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_LNBREAK_safe(s,e,is_utf8)                                        \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x25 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( ( is_utf8 ) && ( 0xCA == ((const U8*)s)[0] ) ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x25 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_utf8_safe(s,e)                                           \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x25 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x25 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*** GENERATED CODE ***/
#define is_LNBREAK_latin1_safe(s,e)                                         \
( ((e)-(s) > 1) ?                                                           \
    ( ( ( 0x0B == ((const U8*)s)[0] || 0x0C == ((const U8*)s)[0] ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] ) ? 1\
    : ( 0x0D == ((const U8*)s)[0] ) ?                                       \
	( ( 0x25 == ((const U8*)s)[1] ) ? 2 : 1 )                           \
    : 0 )                                                                   \
: ((e)-(s) > 0) ?                                                           \
    ( ( 0x0B <= ((const U8*)s)[0] && ((const U8*)s)[0] <= 0x0D ) || 0x15 == ((const U8*)s)[0] || 0x25 == ((const U8*)s)[0] )\
: 0 )

/*
	HORIZWS: Horizontal Whitespace: \h \H

	\p{HorizSpace}
*/
/*** GENERATED CODE ***/
#define is_HORIZWS_high(s)                                                  \
( ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || 0x51 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_HORIZWS_cp_high(cp)                                              \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) )

/*
	VERTWS: Vertical Whitespace: \v \V

	\p{VertSpace}
*/
/*** GENERATED CODE ***/
#define is_VERTWS_high(s)                                                   \
( ( ( ( 0xCA == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_VERTWS_cp_high(cp)                                               \
( 0x2028 == cp || 0x2029 == cp )

/*
	XDIGIT: Hexadecimal digits

	\p{XDigit}
*/
/*** GENERATED CODE ***/
#define is_XDIGIT_high(s)                                                   \
( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x72 == ((const U8*)s)[1] ) ) ? ( ( 0x66 == ((const U8*)s)[2] ) ?\
	    ( ( ( ( ((const U8*)s)[3] & 0xF7 ) == 0x57 ) || ( ( ((const U8*)s)[3] & 0xFE ) == 0x58 ) || ( ( ((const U8*)s)[3] & 0xFE ) == 0x62 ) || ( ( ((const U8*)s)[3] & 0xFC ) == 0x64 ) ) ? 4 : 0 )\
	: ( ( 0x67 == ((const U8*)s)[2] || 0x68 == ((const U8*)s)[2] ) && ( 0x42 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 ) : 0 )

/*** GENERATED CODE ***/
#define is_XDIGIT_cp_high(cp)                                               \
( ( 0xFF10 <= cp && cp <= 0xFF19 ) || ( 0xFF19 < cp &&                      \
( ( 0xFF21 <= cp && cp <= 0xFF26 ) || ( 0xFF41 <= cp && cp <= 0xFF46 ) ) ) )

/*
	XPERLSPACE: \p{XPerlSpace}

	\p{XPerlSpace}
*/
/*** GENERATED CODE ***/
#define is_XPERLSPACE_high(s)                                               \
( ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || 0x51 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x43 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( 0xCE == ((const U8*)s)[0] ) && ( 0x41 == ((const U8*)s)[1] ) ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )

/*** GENERATED CODE ***/
#define is_XPERLSPACE_cp_high(cp)                                           \
( 0x1680 == cp || ( 0x1680 < cp &&                                          \
( ( 0x2000 <= cp && cp <= 0x200A ) || ( 0x200A < cp &&                      \
( 0x2028 == cp || ( 0x2028 < cp &&                                          \
( 0x2029 == cp || ( 0x2029 < cp &&                                          \
( 0x202F == cp || ( 0x202F < cp &&                                          \
( 0x205F == cp || 0x3000 == cp ) ) ) ) ) ) ) ) ) ) )

/*
	NONCHAR: Non character code points

	\p{_Perl_Nchar}
*/
/*** GENERATED CODE ***/
#define is_NONCHAR_utf8_safe(s,e)                                           \
( ( ( LIKELY((e) > (s)) ) && ( LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) ) ? ( ( 0xDD == ((const U8*)s)[0] ) ?\
	    ( ( 0x72 == ((const U8*)s)[1] ) ?                               \
		( ( 0x55 == ((const U8*)s)[2] ) ?                           \
		    ( ( ( 0x57 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x72 ) ) ? 4 : 0 )\
		: ( 0x56 == ((const U8*)s)[2] ) ?                           \
		    ( ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
		: ( ( 0x72 == ((const U8*)s)[2] ) && ( 0x71 == ((const U8*)s)[3] || 0x72 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	    : 0 )                                                           \
	: ( 0xDF == ((const U8*)s)[0] || 0xEA == ((const U8*)s)[0] || 0xEC == ((const U8*)s)[0] ) ?\
	    ( ( ( ( 0x72 == ((const U8*)s)[1] ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x71 == ((const U8*)s)[3] || 0x72 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0xED == ((const U8*)s)[0] ) ?                                   \
	    ( ( ( ( ( ((const U8*)s)[1] == 0x4A || ((const U8*)s)[1] == 0x52 || ( ( ((const U8*)s)[1] & 0xFD ) == 0x54 ) || ((const U8*)s)[1] == 0x58 || ((const U8*)s)[1] == 0x5F || ((const U8*)s)[1] == 0x63 || ( ( ((const U8*)s)[1] & 0xFD ) == 0x65 ) || ((const U8*)s)[1] == 0x69 || ( ( ((const U8*)s)[1] & 0xFD ) == 0x70 ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( 0x71 == ((const U8*)s)[4] || 0x72 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( ( 0xEE == ((const U8*)s)[0] ) && ( 0x42 == ((const U8*)s)[1] ) ) && ( 0x72 == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) && ( 0x71 == ((const U8*)s)[4] || 0x72 == ((const U8*)s)[4] ) ) ? 5 : 0 ) : 0 )

/*
	SURROGATE: Surrogate code points

	\p{_Perl_Surrogate}
*/
/*** GENERATED CODE ***/
#define is_SURROGATE_utf8_safe(s,e)                                         \
( ( ( ( ( ( ((e) - (s)) >= 4 ) && ( 0xDD == ((const U8*)s)[0] ) ) && ( ( ((const U8*)s)[1] & 0xFE ) == 0x64 ) ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x72 ) ) ) ? 4 : 0 )

/*
	QUOTEMETA: Meta-characters that \Q should quote

	\p{_Perl_Quotemeta}
*/
/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part0(s)                                          \
( ( 0x41 == ((const U8*)s)[1] || ( 0x54 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x5F == ((const U8*)s)[1] || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( ((const U8*)s)[2] & 0xFE ) == 0x70 ) ? 3 : 0 )\
    : ( 0x43 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x42 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x63 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x44 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x56 ) ) ? 3 : 0 )\
    : ( ( 0x53 == ((const U8*)s)[1] ) && ( ( 0x57 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high_part1(s)                                          \
( ( 0xCB == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x43 ) || ( 0x49 == ((const U8*)s)[1] || 0x4A == ((const U8*)s)[1] ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x5F == ((const U8*)s)[1] || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x68 ) || ( 0x70 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x72 ) ) ?\
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x69 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( ((const U8*)s)[2] & 0xFE ) == 0x62 ) ? 3 : 0 )\
    : ( ( 0x6A == ((const U8*)s)[1] ) && ( ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCC == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x5F == ((const U8*)s)[1] || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x72 ) ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCD == ((const U8*)s)[0] ) ?                                           \
    ( ( ( ( ( ((const U8*)s)[1] & 0xF7 ) == 0x57 ) || ( ( ((const U8*)s)[1] & 0xFE ) == 0x58 ) ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ) ? 3 : 0 )\
: ( 0xCE == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x41 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x44 ) || ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x42 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] || 0x57 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x45 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xDD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x72 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x4A == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x71 == ((const U8*)s)[3] || 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )\
	: ( 0x57 == ((const U8*)s)[2] ) ?                                   \
	    ( ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x56 ) ) ? 4 : 0 )\
	: ( 0x59 == ((const U8*)s)[2] ) ?                                   \
	    ( ( ( ((const U8*)s)[3] & 0xFE ) == 0x46 ) ? 4 : 0 )            \
	: ( 0x65 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x72 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( 0x70 == ((const U8*)s)[2] ) ?                                   \
	    ( ( 0x41 == ((const U8*)s)[3] ) ? 4 : 0 )                       \
	: ( ( 0x72 == ((const U8*)s)[2] ) && ( ( 0x57 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x66 ) ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ( 0xDF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x46 == ((const U8*)s)[2] ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x44 ) ) ? 4 : 0 )\
    : ( ( ( 0x62 == ((const U8*)s)[1] ) && ( 0x52 == ((const U8*)s)[2] ) ) && ( 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x68 ) ) ) ? 4 : 0 )\
: ( ( ( ( ( 0xED == ((const U8*)s)[0] ) && ( 0x6A == ((const U8*)s)[1] ) ) && ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x44 ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x59 ) || 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x72 ) ) ) && ( ( 0x41 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x59 ) || 0x5F == ((const U8*)s)[4] || ( 0x62 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[4] && ((const U8*)s)[4] <= 0x72 ) ) ) ? 5 : 0 )


/*** GENERATED CODE ***/
#define is_QUOTEMETA_high(s)                                                \
( ( 0xAF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x56 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB7 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x57 == ((const U8*)s)[1] ) && ( 0x6A == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBC == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x51 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x72 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x52 == ((const U8*)s)[1] ) && ( 0x41 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x62 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x41 == ((const U8*)s)[2] ) ? 3 : 0 )                           \
    : ( ( 0x70 == ((const U8*)s)[1] ) && ( ( ((const U8*)s)[2] & 0xFE ) == 0x62 ) ) ? 3 : 0 )\
: ( 0xBE == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x41 == ((const U8*)s)[1] ) && ( 0x52 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x55 ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ? is_QUOTEMETA_high_part0(s) : is_QUOTEMETA_high_part1(s) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(1)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e)                             \
( ( 0x86 == ((const U8*)s)[1] ) ?                                           \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e)                             \
( ( 0x88 == ((const U8*)s)[0] ) ?                                           \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x72 == ((const U8*)s)[1] ) && ( 0x8E == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x67 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: 0 )                                                               \
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x49 == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 0 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
		: ( 0x5F == ((const U8*)s)[3] ) ?                           \
		    ( ( 0xAD == ((const U8*)s)[4] ) ?                       \
			( ( 0x41 == ((const U8*)s)[5] || 0x42 == ((const U8*)s)[5] ) ? 6 : 4 )\
		    : ( ( 0xAF == ((const U8*)s)[4] ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ?                           \
		    ( ( ( 0xB3 == ((const U8*)s)[4] ) && ( 0x67 == ((const U8*)s)[5] ) ) ? 6 : 4 )\
		: 0 )                                                       \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB7 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x52 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x46 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x53 == ((const U8*)s)[4] ) ) && ( 0x43 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( 0x62 == ((const U8*)s)[2] ) ?                               \
		( ( ( ( 0xB7 == ((const U8*)s)[3] ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x46 == ((const U8*)s)[5] || 0x52 == ((const U8*)s)[5] || 0x54 == ((const U8*)s)[5] || 0x64 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	    : ( ( ( ( 0x71 == ((const U8*)s)[2] ) && ( 0xB7 == ((const U8*)s)[3] ) ) && ( 0x52 == ((const U8*)s)[4] ) ) && ( 0x64 == ((const U8*)s)[5] ) ) ? 6 : 0 )\
	: 0 )                                                               \
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0x66 ) ?                        \
	    ( ( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((const U8*)s)[1] ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) || 0x57 == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || 0x6A == ((const U8*)s)[2] ) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e)                             \
( ( 0x81 == ((const U8*)s)[0] ) ?                                           \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x72 == ((const U8*)s)[1] ) && ( 0x8E == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xBF == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0x66 ) ?                        \
	    ( ( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
	: ( ( ( ( 0x69 == ((const U8*)s)[1] ) && ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x48 ) || 0x57 == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || 0x6A == ((const U8*)s)[2] ) ) && ( 0xB3 == ((const U8*)s)[3] ) ) && ( 0x67 == ((const U8*)s)[4] ) ) ? 5 : 0 )\
    : 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e)                             \
( ((e)-(s) > 3) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x8E == ((const U8*)s)[0] ) ?                                       \
	( ( ( ( 0x72 == ((const U8*)s)[1] ) && ( 0x8E == ((const U8*)s)[2] ) ) && ( 0x72 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xAA == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0x6A == ((const U8*)s)[1] ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xB3 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x53 == ((const U8*)s)[1] || 0x55 == ((const U8*)s)[1] ) ?      \
	    ( ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x58 == ((const U8*)s)[1] || 0x65 == ((const U8*)s)[1] ) ?      \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x67 == ((const U8*)s)[1] ) && ( 0xAF == ((const U8*)s)[2] ) ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : ( 0xB4 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x42 == ((const U8*)s)[1] ) ?                                   \
	    ( ( ( 0xAD == ((const U8*)s)[2] ) && ( 0x5F == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x46 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAD == ((const U8*)s)[2] ) ?                               \
		( ( 0x5F == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xAF == ((const U8*)s)[2] ) && ( 0x43 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( 0x4A == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0xAF == ((const U8*)s)[2] ) ?                               \
		( ( 0x43 == ((const U8*)s)[3] ) ? 4 : 0 )                   \
	    : ( ( 0xB3 == ((const U8*)s)[2] ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
	: ( ( ( 0x55 == ((const U8*)s)[1] ) && ( 0xB3 == ((const U8*)s)[2] ) ) && ( 0x67 == ((const U8*)s)[3] ) ) ? 4 : 0 )\
    : 0 )                                                                   \
: ((e)-(s) > 2) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] ) ?                                   \
	    ( ( 0x89 == ((const U8*)s)[2] || 0x93 == ((const U8*)s)[2] ) ? 3 : 2 )\
	: ( 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( 0x88 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAE == ((const U8*)s)[1] ) && ( 0x58 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x89 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x91 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x53 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA2 == ((const U8*)s)[0] ) ?                                       \
	( ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ? 2 : 0 )                \
    : ( 0xA3 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0xA6 == ((const U8*)s)[0] || 0xA8 == ((const U8*)s)[0] ) ?          \
	( ( ( 0xAD == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( ( ( 0xAA == ((const U8*)s)[0] ) && ( 0x6A == ((const U8*)s)[1] ) ) && ( 0x95 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( 0x86 == ((const U8*)s)[0] ) ?                                       \
	( ( 0x86 == ((const U8*)s)[1] || 0x89 == ((const U8*)s)[1] || 0x93 == ((const U8*)s)[1] ) ? 2 : 0 )\
    : ( ( 0xA2 == ((const U8*)s)[0] ) && ( ( ((const U8*)s)[1] & 0xFE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )


/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_utf8_safe(s,e)                                   \
( ((e)-(s) > 5) ?                                                           \
    ( ( 0x81 == ((const U8*)s)[0] ) ?                                       \
	( ( ( 0xAA == ((const U8*)s)[1] ) && ( 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
    : ( 0x86 == ((const U8*)s)[0] ) ? is_MULTI_CHAR_FOLD_utf8_safe_part0(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part1(s,e) )\
: ((e)-(s) > 4) ? is_MULTI_CHAR_FOLD_utf8_safe_part2(s,e) : is_MULTI_CHAR_FOLD_utf8_safe_part3(s,e) )

/*
	MULTI_CHAR_FOLD: multi-char strings that are folded to by a single character

	&regcharclass_multi_char_folds::multi_char_folds(0)
*/
/*** GENERATED CODE ***/
#define is_MULTI_CHAR_FOLD_latin1_safe(s,e)                                 \
( ((e)-(s) > 2) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 0x86 ) ?                            \
	( ( ( ((const U8*)s)[1] & 0xBF ) == 0x86 ) ?                        \
	    ( ( ( ( ((const U8*)s)[2] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[2] & 0xBF ) == 0x93 ) ) ? 3 : 2 )\
	: ( ( ( ((const U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((const U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: ((e)-(s) > 1) ?                                                           \
    ( ( ( ((const U8*)s)[0] & 0xBF ) == 0x86 ) ?                            \
	( ( ( ( ((const U8*)s)[1] & 0xBF ) == 0x86 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x89 ) || ( ( ((const U8*)s)[1] & 0xBF ) == 0x93 ) ) ? 2 : 0 )\
    : ( ( ( ((const U8*)s)[0] & 0xBF ) == 0xA2 ) && ( ( ((const U8*)s)[1] & 0xBE ) == 0xA2 ) ) ? 2 : 0 )\
: 0 )

/*
	FOLDS_TO_MULTI: characters that fold to multi-char strings

	\p{_Perl_Folds_To_Multi_Char}
*/
/*** GENERATED CODE ***/
#define is_FOLDS_TO_MULTI_utf8(s)                                           \
( ( 0x80 == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8C == ((const U8*)s)[0] || 0x9B == ((const U8*)s)[0] || ( ((const U8*)s)[0] & 0xFE ) == 0xB2 ) ?\
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xB7 == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x53 == ((const U8*)s)[1] ) && ( 0x48 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x62 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x64 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x68 ) || 0x71 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x68 == ((const U8*)s)[1] ) ?                                       \
	( ( 0x57 == ((const U8*)s)[2] || 0x59 == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || 0x64 == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x6A == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x59 ) || 0x5F == ((const U8*)s)[2] || ( 0x62 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x72 ) ) ? 3 : 0 )\
    : ( 0x70 == ((const U8*)s)[1] ) ?                                       \
	( ( ( 0x41 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x56 ) || 0x59 == ((const U8*)s)[2] || 0x5F == ((const U8*)s)[2] || 0x62 == ((const U8*)s)[2] || ( ((const U8*)s)[2] & 0xFE ) == 0x64 || 0x6A == ((const U8*)s)[2] ) ? 3 : 0 )\
    : ( 0x71 == ((const U8*)s)[1] ) ?                                       \
	( ( ( ( ((const U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((const U8*)s)[2] & 0xDE ) == 0x44 ) || ((const U8*)s)[2] == 0x48 || ((const U8*)s)[2] == 0x53 || ((const U8*)s)[2] == 0x59 || ((const U8*)s)[2] == 0x5F ) ? 3 : 0 )\
    : ( ( 0x72 == ((const U8*)s)[1] ) && ( ( ( ((const U8*)s)[2] & 0xFB ) == 0x43 ) || ( ( ((const U8*)s)[2] & 0xDE ) == 0x44 ) || ((const U8*)s)[2] == 0x48 || ((const U8*)s)[2] == 0x59 || ((const U8*)s)[2] == 0x5F || ( ( ((const U8*)s)[2] & 0xF7 ) == 0x62 ) ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) || 0x5F == ((const U8*)s)[3] || ( 0x62 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x65 ) ) ) ? 4 : 0 )

/*
	PROBLEMATIC_LOCALE_FOLD: characters whose fold is problematic under locale

	\p{_Perl_Problematic_Locale_Folds}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_utf8(s)                                  \
( ( ( ( ((const U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((const U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((const U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((const U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0x5C ) || ((const U8*)s)[0] == 0x5E || ( ( ((const U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x6C ) || ((const U8*)s)[0] == 0x79 || ( ( ((const U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x88 ) || ((const U8*)s)[0] == 0xA1 || ( ( ((const U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((const U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0xA8 ) || ((const U8*)s)[0] == 0xB0 || ( ( ((const U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((const U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((const U8*)s)[0] & 0xCE ) == 0xC8 ) || ((const U8*)s)[0] == 0xE0 || ( ( ((const U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((const U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((const U8*)s)[0] || 0x80 == ((const U8*)s)[0] || 0x8A == ((const U8*)s)[0] ) ?\
    ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x5F == ((const U8*)s)[1] || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] || 0x58 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x66 == ((const U8*)s)[1] || 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9B == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAD == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x48 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( ( ((const U8*)s)[0] & 0xFE ) == 0xB2 ) ?                                \
    ( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( ( 0x64 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x68 ) || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] || 0x52 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLD_cp(cp)                                   \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x307 == cp || ( 0x307 < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PROBLEMATIC_LOCALE_FOLDEDS_START: The first folded character of folds which are problematic under locale

	\p{_Perl_Problematic_Locale_Foldeds_Start}
*/
/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_utf8(s)                         \
( ( ( ( ((const U8*)s)[0] & 0xC0 ) == 0x00 ) || ( ( ((const U8*)s)[0] & 0xEF ) == 0x40 ) || ( ( ((const U8*)s)[0] & 0xDF ) == 0x4B ) || ( ( ((const U8*)s)[0] & 0xFC ) == 0x4C ) || ( ( ((const U8*)s)[0] & 0xDE ) == 0x5A ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0x5C ) || ((const U8*)s)[0] == 0x5E || ( ( ((const U8*)s)[0] & 0xFE ) == 0x60 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x6C ) || ((const U8*)s)[0] == 0x79 || ( ( ((const U8*)s)[0] & 0xEF ) == 0x81 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x82 ) || ( ( ((const U8*)s)[0] & 0xEC ) == 0x84 ) || ( ( ((const U8*)s)[0] & 0xEE ) == 0x88 ) || ((const U8*)s)[0] == 0xA1 || ( ( ((const U8*)s)[0] & 0xBE ) == 0xA2 ) || ( ( ((const U8*)s)[0] & 0xBC ) == 0xA4 ) || ( ( ((const U8*)s)[0] & 0xFE ) == 0xA8 ) || ((const U8*)s)[0] == 0xB0 || ( ( ((const U8*)s)[0] & 0xFE ) == 0xBA ) || ( ( ((const U8*)s)[0] & 0xE8 ) == 0xC0 ) || ( ( ((const U8*)s)[0] & 0xCE ) == 0xC8 ) || ((const U8*)s)[0] == 0xE0 || ( ( ((const U8*)s)[0] & 0xF8 ) == 0xF0 ) || ((const U8*)s)[0] == 0xFF ) ? 1\
: ( 0x78 == ((const U8*)s)[0] || 0x80 == ((const U8*)s)[0] || 0x8A == ((const U8*)s)[0] ) ?\
    ( ( ( 0x41 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x4A ) || ( 0x51 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x59 ) || 0x5F == ((const U8*)s)[1] || ( 0x62 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x6A ) || ( 0x70 <= ((const U8*)s)[1] && ((const U8*)s)[1] <= 0x72 ) ) ? 2 : 0 )\
: ( 0x8C == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] || 0x58 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x8D == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x4A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0x8E == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x66 == ((const U8*)s)[1] || 0x72 == ((const U8*)s)[1] ) ? 2 : 0 )  \
: ( 0x9B == ((const U8*)s)[0] ) ?                                           \
    ( ( 0x57 == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xAA == ((const U8*)s)[0] || ( ((const U8*)s)[0] & 0xFE ) == 0xB2 ) ?   \
    ( ( 0x6A == ((const U8*)s)[1] ) ? 2 : 0 )                               \
: ( 0xBF == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x62 == ((const U8*)s)[1] ) && ( ( 0x64 <= ((const U8*)s)[2] && ((const U8*)s)[2] <= 0x68 ) || 0x71 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( 0xCA == ((const U8*)s)[0] ) ?                                           \
    ( ( ( 0x4A == ((const U8*)s)[1] ) && ( 0x51 == ((const U8*)s)[2] || 0x52 == ((const U8*)s)[2] ) ) ? 3 : 0 )\
: ( ( ( ( 0xDD == ((const U8*)s)[0] ) && ( 0x71 == ((const U8*)s)[1] ) ) && ( 0x66 == ((const U8*)s)[2] ) ) && ( 0x41 <= ((const U8*)s)[3] && ((const U8*)s)[3] <= 0x47 ) ) ? 4 : 0 )

/*** GENERATED CODE ***/
#define is_PROBLEMATIC_LOCALE_FOLDEDS_START_cp(cp)                          \
( cp <= 0xFF || ( 0xFF < cp &&                                              \
( 0x130 == cp || ( 0x130 < cp &&                                            \
( 0x131 == cp || ( 0x131 < cp &&                                            \
( 0x149 == cp || ( 0x149 < cp &&                                            \
( 0x178 == cp || ( 0x178 < cp &&                                            \
( 0x17F == cp || ( 0x17F < cp &&                                            \
( 0x1F0 == cp || ( 0x1F0 < cp &&                                            \
( 0x2BC == cp || ( 0x2BC < cp &&                                            \
( 0x39C == cp || ( 0x39C < cp &&                                            \
( 0x3BC == cp || ( 0x3BC < cp &&                                            \
( ( 0x1E96 <= cp && cp <= 0x1E9A ) || ( 0x1E9A < cp &&                      \
( 0x1E9E == cp || ( 0x1E9E < cp &&                                          \
( 0x212A == cp || ( 0x212A < cp &&                                          \
( 0x212B == cp || ( 0xFB00 <= cp && cp <= 0xFB06 ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

/*
	PATWS: pattern white space

	\p{_Perl_PatWS}
*/
/*** GENERATED CODE ***/
#define is_PATWS_safe(s,e,is_utf8)                                          \
( ( LIKELY((e) > (s)) ) ?                                                   \
    ( ( ( ( ((const U8*)s)[0] & 0xEF ) == 0x05 ) || ((const U8*)s)[0] == 0x0B || ( ( ((const U8*)s)[0] & 0xFE ) == 0x0C ) || ((const U8*)s)[0] == 0x25 || ((const U8*)s)[0] == 0x40 ) ? 1\
    : ( ( is_utf8 && LIKELY(((e) - (s)) >= UTF8SKIP(s)) ) && ( 0xCA == ((const U8*)s)[0] ) ) ? ( ( 0x41 == ((const U8*)s)[1] ) ?\
		    ( ( 0x55 == ((const U8*)s)[2] || 0x56 == ((const U8*)s)[2] ) ? 3 : 0 )\
		: ( ( 0x42 == ((const U8*)s)[1] ) && ( 0x49 == ((const U8*)s)[2] || 0x4A == ((const U8*)s)[2] ) ) ? 3 : 0 ) : 0 )\
: 0 )

/*** GENERATED CODE ***/
#define is_PATWS_cp(cp)                                                     \
( 0x05 == cp || ( 0x05 < cp &&                                              \
( ( 0x0B <= cp && cp <= 0x0D ) || ( 0x0D < cp &&                            \
( 0x15 == cp || ( 0x15 < cp &&                                              \
( 0x25 == cp || ( 0x25 < cp &&                                              \
( 0x40 == cp || ( 0x40 < cp &&                                              \
( 0x200E == cp || ( 0x200E < cp &&                                          \
( 0x200F == cp || ( 0x200F < cp &&                                          \
( 0x2028 == cp || 0x2029 == cp ) ) ) ) ) ) ) ) ) ) ) ) ) ) )

#endif	/* EBCDIC 037 */

#endif /* PERL_REGCHARCLASS_H_ */

/* Generated from:
 * d34c77b7e7a94986cc82056919f4ffc1503b73091561e16bd8ef145ac0fd04c5 lib/Unicode/UCD.pm
 * fdc543859433c4578ec7991d8c3238a3638d59962eb0db446d0228cccb7a48da lib/unicore/ArabicShaping.txt
 * 530831b8bdbb2a8a6bc1f2eef88224991513c7371c16537d0a7e09386a2cd326 lib/unicore/BidiBrackets.txt
 * f07f44839398bc33792d988f14fcbcaf382abc3b79119e7e0bb083104260b890 lib/unicore/BidiMirroring.txt
 * a1a3ca4381eb91f7b65afe7cb7df615cdcf67993fef4b486585f66b349993a10 lib/unicore/Blocks.txt
 * d6caa458afc9a76d86bc2ef26a5423f4e663981904de450c97dd53ee0ab5c125 lib/unicore/CaseFolding.txt
 * 08a52bd7f893f5c9a34a6d4cc3a0b2d7a44293ee45fb15d581e729b9f8584dfa lib/unicore/CompositionExclusions.txt
 * 269ff9d35cbe3cb05dfadb262a6d9d89d7ad43ac6ecd7ec71f47ec036e174912 lib/unicore/DAge.txt
 * b559c5ac28549ec48b9f6f14d189b503d35e33158db6b5f63e6103f51aded2cd lib/unicore/DCoreProperties.txt
 * 8b4210273920c013e736332434222b73786e6c468a360710f6799eeace9b3d38 lib/unicore/DNormalizationProps.txt
 * f7e61d7cd168d4496c6019148579af3adfd6e0dac8fa7cd98d8617bcd8732b28 lib/unicore/EastAsianWidth.txt
 * cb048696ab01434bac59c30e5cb1f682d95022c972d8d1ebd5ea79b3841ba66c lib/unicore/EmojiData.txt
 * af2928fa86e77dc2d91ed268270ca13895ede2bf29e9f0f7533f1873c0aeb4b5 lib/unicore/EquivalentUnifiedIdeograph.txt
 * 2791813c07488ad72b3943bbcb2eb85bb03222271829c13bf25f79edfb214330 lib/unicore/HangulSyllableType.txt
 * 1df3666ef987e492b4323a9cd907738e41656e6428752f4b1f6fd95f9bfc8adb lib/unicore/IndicPositionalCategory.txt
 * b3932cf25d7ea43e1bf6be6d45094d4552f753f6b651a7a869464028f1aa88a1 lib/unicore/IndicSyllabicCategory.txt
 * 035d78d5e1fb60c3b44fb7049a96c660a6d045be27ac8f4425abfbc3733724de lib/unicore/Jamo.txt
 * 5afea13d57e5b11c761a9b2553806b12a5fe4e96b729398d9bf0dd94b7e6d7eb lib/unicore/LineBreak.txt
 * 46cce9be0639999e6a903bfa9f1313def3c361c7ae68f411cef244132ee8097b lib/unicore/NameAliases.txt
 * 0911bfd49367059219a74c69fb2c1440d256869e713619a2a231afd24357ec6e lib/unicore/NamedSequences.txt
 * adf1323156ef56014549698eab7b482a3682c8e02c251a7c19f68e427b391189 lib/unicore/PropList.txt
 * 648e1cb9942f02b9358edc52d523803efa491ff576aa7063d4b9aebdef7d7217 lib/unicore/PropValueAliases.txt
 * 402e075e4b9d56bf46d32c950d693e5bb52c1a324a652f732401dbf5a9a4d269 lib/unicore/PropertyAliases.txt
 * b77739d4b7c35069c10f8e156b71c88c5955800240c22e3a32b2ed3ea9620e5f lib/unicore/ScriptExtensions.txt
 * bd327cbb8bffd2e4b40b1e9842c9a7d641d1c4e91c34a41020cf174f3a1c86a1 lib/unicore/Scripts.txt
 * 22b1bff498f08633f72468d46eebb65e30dc325fbb6822dde319cb605af014c2 lib/unicore/SpecialCasing.txt
 * 57913fdb1c1271fa9fd51dea08d49370f33d5bfda6bbaba348f44d90029ea11d lib/unicore/UnicodeData.txt
 * 36900e28ff01fa810d8a7e0848e1075289975188525f2c1d14487d561bbf595a lib/unicore/VerticalOrientation.txt
 * 238635e1dfcc190345ffbcab734f7017dea05d2a66f2291745c11067893689a7 lib/unicore/auxiliary/GCBTest.txt
 * b49f36b98cdd4c996fc7971b8b4d25e3c13b45f0a71f4ad0c5e70a9cebe0b956 lib/unicore/auxiliary/GraphemeBreakProperty.txt
 * d7ae54c2704f27b3a8f40ae934c2f6f3ee87bec20a865e0f9689bc1cd3f92335 lib/unicore/auxiliary/LBTest.txt
 * a9fafe0badc760379957a282bbe3d82d5a6ba113911b89501781fd6b6ad66377 lib/unicore/auxiliary/SBTest.txt
 * 5bf7faf5898403b6adad2d94f1a9ddf26de650cc7a8f2ee00590f05bbea9bd03 lib/unicore/auxiliary/SentenceBreakProperty.txt
 * 12e02e6158929ae29c9b47f76ab95d68194b1d0c295d7b4f6df31487590222a5 lib/unicore/auxiliary/WBTest.txt
 * 9be679d9772dc4842697a3a5b6e1845022f876c1f230ecea38f1be5d6d5673d8 lib/unicore/auxiliary/WordBreakProperty.txt
 * 9e6955b173a13a8a91e3c1b468c9d7e122c588aa288f707bfcef35790a828f8a lib/unicore/extracted/DBidiClass.txt
 * 80e94d5bb24639c9f322bd3b4b8159a8e9a7c33ac45076eff9cd3ecb0b9b812e lib/unicore/extracted/DBinaryProperties.txt
 * 6dc031734cd287af8b33c99435d41f6c836e8e08a7a6cb6cb07e8453cbebdb3b lib/unicore/extracted/DCombiningClass.txt
 * b143bb87f041dcb69335806cb0a1a6b2328eb25cdfa04fe6fcd4c77c6a06fe82 lib/unicore/extracted/DDecompositionType.txt
 * f63f08d36d01eb45f34ff8d2b36681252211f92db690fa1258a399a9a86df3bb lib/unicore/extracted/DEastAsianWidth.txt
 * 6fa015f11f19a9407d590827276f9884c1ee4c71fbc826a09008f7d9d7c1b255 lib/unicore/extracted/DGeneralCategory.txt
 * 1b24a2d586a8b91c0768d4da8919634463bdf126b7479a8e76b85d007cbef8a0 lib/unicore/extracted/DJoinGroup.txt
 * 8095565a527d3d0918a17e30a7bcc0c7864ac3ad748defc21027b3e1ad436368 lib/unicore/extracted/DJoinType.txt
 * 5f98a68d5aa76b06052fe16312d2fdf17547fd69c4e648532845e11beaf2002b lib/unicore/extracted/DLineBreak.txt
 * 8011b1733f6d2cc17576b2a1e20067eca51205e8e0b740d00ebd52afbec2ea39 lib/unicore/extracted/DNumType.txt
 * 8b677a4cf17a4c6949632146fa8a99aaa65689a41b9dd231f81783e81600ff36 lib/unicore/extracted/DNumValues.txt
 * 56461f8238f671a5e686ca8cacd508e67d6d0b7a14ac6096938af435f76d36e0 lib/unicore/mktables
 * 93cc868487ef3345596041bcb90c302b1b056733bb95233101bc10dc2dbe36b4 lib/unicore/version
 * 2680b9254eb236c5c090f11b149605043e8c8433661b96efc4a42fb4709342a5 regen/charset_translations.pl
 * 88bd981dbb45f57767c414170f85067c6e01b5afbc1e40c6514a2bc41ed8c1d8 regen/regcharclass.pl
 * c6b0b0b7e4ac4f5a57d203e84194749987477ea55b2366e3b343aadf8cc7d6b5 regen/regcharclass_multi_char_folds.pl
 * ex: set ro: */
