use 5.014;
use warnings;
use Test::More 0.98;

sub is_close {
    my ($x, $y, $desc) = @_;

    ok(abs($x - $y) < 1e-9, $desc);
}

sub out_of_range {
    my $bspline;
    my $u;
    my $s;
    my $template;
    my $Nip;

    $bspline = Math::BSpline::Basis->new(
        degree      => 2,
        knot_vector => [0, 0, 0, 1, 2, 3, 4, 4, 5, 5, 5],
    );

    $u = -0.1;
    $s = $bspline->find_knot_span($u);
    is($s, 2, 'knot span index 2');
    $template = [0, 0, 0];
    $Nip      = $bspline->evaluate_basis_functions($s, $u);
    is(
        scalar(@$Nip),
        scalar(@$template),
        sprintf(
            '%d evaluated basis functions',
            scalar(@$template),
        )
    );
    for (my $i=0;$i<@$template;$i++) {
        is_close(
            $Nip->[$i],
            $template->[$i],
            sprintf(
                'function value %d (%.3f) is close to %.3f',
                $i,
                $Nip->[$i],
                $template->[$i],
            ),
        );
    }

    $u = 5.1;
    $s = $bspline->find_knot_span($u);
    is($s, 7, 'knot span index 2');
    $template = [0, 0, 0];
    $Nip      = $bspline->evaluate_basis_functions($s, $u);
    is(
        scalar(@$Nip),
        scalar(@$template),
        sprintf(
            '%d evaluated basis functions',
            scalar(@$template),
        )
    );
    for (my $i=0;$i<@$template;$i++) {
        is_close(
            $Nip->[$i],
            $template->[$i],
            sprintf(
                'function value %d (%.3f) is close to %.3f',
                $i,
                $Nip->[$i],
                $template->[$i],
            ),
        );
    }
}

sub example01 {
    my $bspline;
    my $u;
    my $s;
    my $template;
    my $Nip;

    $bspline = Math::BSpline::Basis->new(
        degree      => 2,
        knot_vector => [0, 0, 0, 1, 2, 3, 4, 4, 5, 5, 5],
    );

    $u = 5/2;
    $s = $bspline->find_knot_span($u);
    is($s, 4, 'knot span index 4');
    $template = [1/8, 3/4, 1/8];
    $Nip = $bspline->evaluate_basis_functions($s, $u);
    is(
        scalar(@$Nip),
        scalar(@$template),
        sprintf(
            '%d evaluated basis functions',
            scalar(@$template),
        )
    );
    for (my $i=0;$i<@$template;$i++) {
        is_close(
            $Nip->[$i],
            $template->[$i],
            sprintf(
                'function value %d (%.3f) is close to %.3f',
                $i,
                $Nip->[$i],
                $template->[$i],
            ),
        );
    }
}

# These test data were created using the GSL in a C program.
sub example02 {
    my $bspline;
    my $u;
    my $s;
    my $template;
    my $Nip;
    my $p;

    $p = 3;
    $bspline = Math::BSpline::Basis->new(
        degree      => $p,
        knot_vector => [0, 0, 0, 0, 2, 4, 6, 8, 8, 8, 8],
    );
    $template = [
        [0.00, 1.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000, 0.0000000000],
        [0.20, 0.7290000000, 0.2567500000, 0.0140833333, 0.0001666667, 0.0000000000, 0.0000000000, 0.0000000000],
        [0.40, 0.5120000000, 0.4340000000, 0.0526666667, 0.0013333333, 0.0000000000, 0.0000000000, 0.0000000000],
        [0.60, 0.3430000000, 0.5422500000, 0.1102500000, 0.0045000000, 0.0000000000, 0.0000000000, 0.0000000000],
        [0.80, 0.2160000000, 0.5920000000, 0.1813333333, 0.0106666667, 0.0000000000, 0.0000000000, 0.0000000000],
        [1.00, 0.1250000000, 0.5937500000, 0.2604166667, 0.0208333333, 0.0000000000, 0.0000000000, 0.0000000000],
        [1.20, 0.0640000000, 0.5580000000, 0.3420000000, 0.0360000000, 0.0000000000, 0.0000000000, 0.0000000000],
        [1.40, 0.0270000000, 0.4952500000, 0.4205833333, 0.0571666667, 0.0000000000, 0.0000000000, 0.0000000000],
        [1.60, 0.0080000000, 0.4160000000, 0.4906666667, 0.0853333333, 0.0000000000, 0.0000000000, 0.0000000000],
        [1.80, 0.0010000000, 0.3307500000, 0.5467500000, 0.1215000000, 0.0000000000, 0.0000000000, 0.0000000000],
        [2.00, 0.0000000000, 0.2500000000, 0.5833333333, 0.1666666667, 0.0000000000, 0.0000000000, 0.0000000000],
        [2.20, 0.0000000000, 0.1822500000, 0.5964166667, 0.2211666667, 0.0001666667, 0.0000000000, 0.0000000000],
        [2.40, 0.0000000000, 0.1280000000, 0.5880000000, 0.2826666667, 0.0013333333, 0.0000000000, 0.0000000000],
        [2.60, 0.0000000000, 0.0857500000, 0.5615833333, 0.3481666667, 0.0045000000, 0.0000000000, 0.0000000000],
        [2.80, 0.0000000000, 0.0540000000, 0.5206666667, 0.4146666667, 0.0106666667, 0.0000000000, 0.0000000000],
        [3.00, 0.0000000000, 0.0312500000, 0.4687500000, 0.4791666667, 0.0208333333, 0.0000000000, 0.0000000000],
        [3.20, 0.0000000000, 0.0160000000, 0.4093333333, 0.5386666667, 0.0360000000, 0.0000000000, 0.0000000000],
        [3.40, 0.0000000000, 0.0067500000, 0.3459166667, 0.5901666667, 0.0571666667, 0.0000000000, 0.0000000000],
        [3.60, 0.0000000000, 0.0020000000, 0.2820000000, 0.6306666667, 0.0853333333, 0.0000000000, 0.0000000000],
        [3.80, 0.0000000000, 0.0002500000, 0.2210833333, 0.6571666667, 0.1215000000, 0.0000000000, 0.0000000000],
        [4.00, 0.0000000000, 0.0000000000, 0.1666666667, 0.6666666667, 0.1666666667, 0.0000000000, 0.0000000000],
        [4.20, 0.0000000000, 0.0000000000, 0.1215000000, 0.6571666667, 0.2210833333, 0.0002500000, 0.0000000000],
        [4.40, 0.0000000000, 0.0000000000, 0.0853333333, 0.6306666667, 0.2820000000, 0.0020000000, 0.0000000000],
        [4.60, 0.0000000000, 0.0000000000, 0.0571666667, 0.5901666667, 0.3459166667, 0.0067500000, 0.0000000000],
        [4.80, 0.0000000000, 0.0000000000, 0.0360000000, 0.5386666667, 0.4093333333, 0.0160000000, 0.0000000000],
        [5.00, 0.0000000000, 0.0000000000, 0.0208333333, 0.4791666667, 0.4687500000, 0.0312500000, 0.0000000000],
        [5.20, 0.0000000000, 0.0000000000, 0.0106666667, 0.4146666667, 0.5206666667, 0.0540000000, 0.0000000000],
        [5.40, 0.0000000000, 0.0000000000, 0.0045000000, 0.3481666667, 0.5615833333, 0.0857500000, 0.0000000000],
        [5.60, 0.0000000000, 0.0000000000, 0.0013333333, 0.2826666667, 0.5880000000, 0.1280000000, 0.0000000000],
        [5.80, 0.0000000000, 0.0000000000, 0.0001666667, 0.2211666667, 0.5964166667, 0.1822500000, 0.0000000000],
        [6.00, 0.0000000000, 0.0000000000, 0.0000000000, 0.1666666667, 0.5833333333, 0.2500000000, 0.0000000000],
        [6.20, 0.0000000000, 0.0000000000, 0.0000000000, 0.1215000000, 0.5467500000, 0.3307500000, 0.0010000000],
        [6.40, 0.0000000000, 0.0000000000, 0.0000000000, 0.0853333333, 0.4906666667, 0.4160000000, 0.0080000000],
        [6.60, 0.0000000000, 0.0000000000, 0.0000000000, 0.0571666667, 0.4205833333, 0.4952500000, 0.0270000000],
        [6.80, 0.0000000000, 0.0000000000, 0.0000000000, 0.0360000000, 0.3420000000, 0.5580000000, 0.0640000000],
        [7.00, 0.0000000000, 0.0000000000, 0.0000000000, 0.0208333333, 0.2604166667, 0.5937500000, 0.1250000000],
        [7.20, 0.0000000000, 0.0000000000, 0.0000000000, 0.0106666667, 0.1813333333, 0.5920000000, 0.2160000000],
        [7.40, 0.0000000000, 0.0000000000, 0.0000000000, 0.0045000000, 0.1102500000, 0.5422500000, 0.3430000000],
        [7.60, 0.0000000000, 0.0000000000, 0.0000000000, 0.0013333333, 0.0526666667, 0.4340000000, 0.5120000000],
        [7.80, 0.0000000000, 0.0000000000, 0.0000000000, 0.0001666667, 0.0140833333, 0.2567500000, 0.7290000000],
    ];

    foreach my $row (@$template) {
        $u   = $row->[0];
        $s   = $bspline->find_knot_span($u);
        $Nip = $bspline->evaluate_basis_functions($s, $u);
        my $test_row = [
            $u,
            (map { 0 } (1..($s-$p))),
            @$Nip,
        ];

        ok(
            scalar(@$test_row) <= scalar(@$row),
            sprintf(
                'at most %d basis functions',
                scalar(@$row),
            )
        );
        for (my $i=0;$i<@$row;$i++) {
            is_close(
                $test_row->[$i] // 0,
                $row->[$i],
                sprintf(
                    'function value %d (%.3f) is close to %.3f',
                    $i,
                    $test_row->[$i] // 0,
                    $row->[$i],
                ),
            );
        }
    }
}

use_ok('Math::BSpline::Basis');
out_of_range;
example01;
example02;
done_testing;
