#!/usr/bin/env perl6

use v6;
use Inline::Perl5;

my $p5 = Inline::Perl5.new();
$p5.run(q/
    use Test::More;

    sub test {
        my ($perl6) = @_;
        for (1 .. 100) {
            my @retval = $perl6->test('Perl6');
            is_deeply \@retval, ['Perl6'];
            my @retval = $perl6->test('Perl', 6);
            is_deeply \@retval, ['Perl', 6];
        }
    };
/);

class Foo {
    method test(*@args) {
        return @args;
    }
}

my $foo = Foo.new;

$p5.call('test', $foo);

$p5.run(q/
    done_testing;
/);

$p5.DESTROY;

# vim: ft=perl6

