use strict;
use warnings;

use Test::More;
use PDL;
use PDL::IO::Image;
use Test::Number::Delta within => 0.0000001;

my $expected = [
  [0 .. 12],
  [13 .. 25],
  [26 .. 38],
  [39 .. 51],
  [52 .. 64],
  [65 .. 77],
  [78 .. 90],
];

my $expected_region = [
  [27 .. 34],
  [40 .. 47],
];

for my $file (<t/bpp-8/*.*>) {
  my $pimage = PDL::IO::Image->new_from_file($file);
  is($pimage->get_image_type , "BITMAP", "get_image_type: $file");
  is($pimage->get_color_type , "PALETTE", "get_color_type: $file");
  is($pimage->get_colors_used,256, "get_colors_used: $file");
  is($pimage->get_width      , 13, "get_width: $file");
  is($pimage->get_height     ,  7, "get_height: $file");
  is($pimage->get_bpp        ,  8, "get_bpp: $file");
  my $pix = $pimage->pixels_to_pdl;
  is($pix->info, 'PDL: Byte D [13,7]', "info: $file");
  is($pix->sum, 4095, "sum: $file");
  delta_ok($pix->unpdl, $expected, "pixels: $file");
  #wread
  delta_ok(rimage($file)->unpdl, $expected, "pixels: $file");
  #region
  $pix = $pimage->pixels_to_pdl(1,8,2,3);
  is($pix->info, 'PDL: Byte D [8,2]',     "reg.info: $file");
  is($pix->sum, 592,                      "reg.sum: $file");
  delta_ok($pix->unpdl, $expected_region, "reg.pixels: $file");
  $pix = $pimage->pixels_to_pdl(1,-4,2,-3);
  is($pix->info, 'PDL: Byte D [8,2]',     "regneg.info: $file");
  is($pix->sum, 592,                      "regneg.sum: $file");
  delta_ok($pix->unpdl, $expected_region, "regneg.pixels: $file");
}

my $expected_pal = [
  [15, 34, 15],
  [14, 164, 13],
  [15, 143, 158],
  [138, 15, 31],
  [164, 143, 143],
  [145, 144, 32],
  [141, 14, 162],
  [33, 16, 140],
  [81, 28, 9],
  [99, 143, 143],
  [159, 212, 145],
  [208, 15, 31],
  [160, 143, 80],
  [156, 17, 208],
  [98, 145, 20],
  [80, 30, 142],
  [81, 207, 160],
  [17, 35, 80],
  [207, 15, 157],
  [226, 145, 78],
  [161, 143, 206],
  [144, 77, 29],
  [99, 71, 14],
  [226, 143, 15],
  [224, 208, 144],
  [14, 206, 34],
  [166, 77, 208],
  [207, 97, 8],
  [79, 76, 159],
  [97, 207, 14],
  [29, 143, 208],
  [30, 16, 207],
  [80, 143, 229],
  [81, 77, 89],
  [144, 96, 143],
  [208, 144, 227],
  [164, 208, 16],
  [78, 208, 226],
  [15, 79, 97],
  [142, 228, 77],
  [210, 16, 225],
  [143, 79, 99],
  [223, 206, 208],
  [222, 19, 76],
  [225, 208, 79],
  [136, 12, 95],
  [29, 79, 14],
  [15, 206, 91],
  [16, 210, 225],
  [81, 28, 207],
  [34, 142, 76],
  [207, 220, 16],
  [80, 138, 100],
  [96, 205, 78],
  [80, 78, 223],
  [226, 81, 139],
  [144, 207, 221],
  [206, 141, 160],
  [207, 99, 207],
  [205, 78, 88],
  [25, 80, 204],
  [16, 96, 143],
  [78, 24, 79],
  [16, 206, 160],
  [113, 90, 78],
  [164, 206, 50],
  [162, 78, 177],
  [86, 175, 158],
  [143, 48, 94],
  [206, 162, 49],
  [101, 143, 56],
  [139, 154, 115],
  [226, 209, 241],
  [15, 157, 110],
  [101, 112, 203],
  [223, 144, 112],
  [98, 238, 143],
  [48, 101, 81],
  [239, 146, 219],
  [175, 31, 143],
  [32, 144, 240],
  [221, 10, 113],
  [48, 207, 97],
  [172, 31, 21],
  [144, 32, 239],
  [142, 159, 175],
  [13, 94, 241],
  [96, 174, 207],
  [238, 93, 206],
  [32, 15, 48],
  [176, 161, 15],
  [115, 11, 159],
  [144, 175, 227],
  [100, 73, 48],
  [22, 90, 48],
  [111, 206, 227],
  [81, 240, 96],
  [156, 241, 207],
  [49, 33, 79],
  [207, 112, 99],
  [229, 45, 144],
  [161, 113, 17],
  [28, 176, 144],
  [175, 220, 81],
  [224, 242, 79],
  [111, 14, 227],
  [160, 113, 209],
  [225, 46, 17],
  [218, 177, 145],
  [95, 208, 47],
  [48, 225, 16],
  [163, 208, 175],
  [46, 77, 158],
  [26, 141, 48],
  [238, 225, 17],
  [222, 50, 207],
  [157, 114, 82],
  [238, 91, 16],
  [217, 210, 176],
  [13, 49, 162],
  [80, 23, 110],
  [218, 75, 170],
  [112, 150, 102],
  [47, 206, 158],
  [33, 48, 208],
  [33, 240, 208],
  [90, 110, 141],
  [112, 22, 12],
  [112, 93, 110],
  [89, 242, 176],
  [221, 206, 114],
  [161, 176, 79],
  [230, 243, 240],
  [207, 176, 220],
  [79, 111, 96],
  [159, 113, 177],
  [166, 241, 14],
  [26, 176, 239],
  [95, 143, 177],
  [240, 14, 35],
  [168, 32, 52],
  [110, 47, 218],
  [29, 112, 17],
  [155, 239, 47],
  [145, 47, 160],
  [49, 239, 99],
  [177, 31, 240],
  [117, 175, 159],
  [222, 176, 81],
  [239, 16, 162],
  [32, 46, 48],
  [99, 113, 241],
  [155, 239, 241],
  [177, 49, 92],
  [177, 97, 143],
  [228, 52, 82],
  [175, 163, 47],
  [172, 14, 92],
  [92, 178, 21],
  [98, 176, 239],
  [49, 159, 112],
  [162, 240, 175],
  [239, 158, 50],
  [32, 178, 78],
  [14, 34, 112],
  [46, 95, 111],
  [238, 80, 99],
  [96, 106, 16],
  [226, 178, 15],
  [243, 100, 241],
  [181, 79, 36],
  [163, 177, 143],
  [157, 143, 239],
  [223, 106, 173],
  [78, 39, 176],
  [78, 241, 224],
  [48, 100, 242],
  [32, 175, 49],
  [14, 110, 98],
  [240, 220, 49],
  [115, 240, 92],
  [95, 177, 55],
  [220, 239, 208],
  [175, 155, 177],
  [226, 46, 113],
  [49, 145, 155],
  [176, 225, 113],
  [177, 36, 176],
  [111, 143, 217],
  [223, 175, 113],
  [206, 94, 240],
  [157, 111, 241],
  [176, 176, 224],
  [46, 46, 165],
  [227, 241, 175],
  [241, 94, 50],
  [138, 48, 34],
  [171, 164, 112],
  [157, 48, 209],
  [15, 238, 33],
  [47, 114, 159],
  [28, 176, 176],
  [142, 177, 30],
  [96, 104, 47],
  [144, 219, 109],
  [31, 175, 206],
  [112, 77, 220],
  [240, 143, 160],
  [31, 111, 208],
  [222, 47, 240],
  [240, 113, 94],
  [241, 177, 225],
  [89, 205, 113],
  [14, 241, 91],
  [113, 239, 221],
  [47, 227, 47],
  [13, 94, 176],
  [113, 45, 164],
  [174, 79, 99],
  [111, 28, 111],
  [49, 32, 14],
  [114, 204, 158],
  [99, 239, 51],
  [27, 240, 239],
  [163, 80, 239],
  [222, 176, 175],
  [220, 48, 174],
  [49, 30, 113],
  [104, 240, 12],
  [241, 16, 220],
  [177, 205, 218],
  [53, 98, 47],
  [15, 239, 159],
  [78, 30, 238],
  [37, 47, 238],
  [161, 113, 45],
  [78, 169, 102],
  [35, 15, 239],
  [157, 112, 112],
  [155, 244, 143],
  [80, 30, 40],
  [208, 103, 42],
  [221, 49, 49],
  [111, 21, 77],
  [102, 110, 170],
  [50, 238, 165],
  [225, 238, 143],
  [206, 221, 47],
  [47, 159, 17],
  [30, 17, 170],
  [48, 205, 223],
  [113, 181, 102],
  [220, 241, 112],
  [109, 78, 151],
  [224, 113, 141],
  [111, 21, 44],
];

{
  #my $pix = (random(100,100,3) * 256)->byte;
  #my $pimage = PDL::IO::Image->new_from_pdl($pix);
  #$pimage->color_quantize->save('t/bpp-8/special/big.png');
  my ($px, $pa) = rimage('t/bpp-8/special/big.png', {palette=>1});
  delta_ok($pa->unpdl, $expected_pal, "palette");
}

done_testing();