use strict;
use warnings;

use Test::More tests => 34;

BEGIN {#1
    use_ok( 'Graph::Dijkstra' ) || print "Bail out!\n";
}

{# infinity test
	my $PINF = 1e9999;
	ok("$PINF" eq '1.#INF', "positive infinity, $PINF");
}

{#tests 3-7


	my $graph = Graph::Dijkstra->new();
	ok(defined($graph), 'Dijkstra->new()');
	
	my $filename = 't/data/graphML2.xml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGraphML($filename),'$graph->inputGraphfromGraphML($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");
}

{#tests 8-11

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.gml';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromGML($filename),'$graph->inputGraphfromGML($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}


{#tests 12-15

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.json';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromJSON($filename),'$graph->inputGraphfromJSON($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}


{#tests 16-19

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.csv';
	
	ok(-e $filename, "found $filename");
	
	ok($graph->inputGraphfromCSV($filename),'$graph->inputGraphfromCSV($filename)');
	
	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"\$graph->farthestNode('1', \\\%Solution)");
	
	my $pathCost = $graph->shortestPath('1', '5', \%Solution);
	
	ok( ($pathCost == 1.8 and $Solution{edges}->[0]->{target} eq '3'),"\$graph->shortestPath('1','5', \\\%Solution)");

}

{# 20-24
	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML2.xml';
	$graph->inputGraphfromGraphML($filename);
	
	$filename = 't/data/graphML3.csv';
	$graph->outputGraphtoCSV($filename);
	ok(-e $filename, '$graph->outputGraphtoCSV($filename);');
	
	$filename = 't/data/graphML3.gml';
	$graph->outputGraphtoGML($filename, 'Test Test');
	ok(-e $filename, "\$graph->outputGraphtoGML(\$filename, 'Test Test');");
	
	$filename = 't/data/graphML3.json';
	$graph->outputGraphtoJSON($filename);
	ok(-e $filename, '$graph->outputGraphtoJSON($filename);');
	
	$filename = 't/data/graphML3.graphml.xml';
	$graph->outputGraphtoGraphML($filename, {});
	ok(-e $filename, '$graph->outputGraphtoGraphML($filename, {});');
	
	$filename = 't/data/graphML3.gexf.xml';
	$graph->outputGraphtoGEXF($filename);
	ok(-e $filename, '$graph->outputGraphtoGEXF($filename);');
	

}

{# 25-26

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.csv';
	ok($graph->inputGraphfromCSV($filename),'$graph->inputGraphfromCSV($filename)');

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"CSV: \$graph->farthestNode('1', \\\%Solution)");
	
	unlink($filename);
}

{# 27-28

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.json';
	ok($graph->inputGraphfromJSON($filename),'$graph->inputGraphfromJSON($filename)');

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"JSON: \$graph->farthestNode('1', \\\%Solution)");
	
	unlink($filename);
}

{# 29-30

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.gexf.xml';
	ok($graph->inputGraphfromGEXF($filename),'$graph->inputGraphfromGEXF($filename)');

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"GEXF: \$graph->farthestNode('1', \\\%Solution)");
	
	unlink($filename);
}

{# 31-32

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.gml';
	ok($graph->inputGraphfromGML($filename),'$graph->inputGraphfromGML($filename)');

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"GML: \$graph->farthestNode('1', \\\%Solution)");
	
	unlink($filename);
}

{# 33-34

	my $graph = Graph::Dijkstra->new();
	
	my $filename = 't/data/graphML3.graphml.xml';
	ok($graph->inputGraphfromGraphML($filename),'$graph->inputGraphfromGraphML($filename)');

	my %Solution = ();
	my $solutionCost = $graph->farthestNode('1', \%Solution);
	
	ok( ($solutionCost == 1.8 and $Solution{path}{1}{destination} eq '5'),"GraphML: \$graph->farthestNode('1', \\\%Solution)");
	
	unlink($filename);
}


exit(0);