package Google::Ads::AdWords::v201806::DataUploadResult;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/rm/v201806' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %uploadStatus_of :ATTR(:get<uploadStatus>);
my %removeAllStatus_of :ATTR(:get<removeAllStatus>);

__PACKAGE__->_factory(
    [ qw(        uploadStatus
        removeAllStatus

    ) ],
    {
        'uploadStatus' => \%uploadStatus_of,
        'removeAllStatus' => \%removeAllStatus_of,
    },
    {
        'uploadStatus' => 'Google::Ads::AdWords::v201806::UserListUploadStatus',
        'removeAllStatus' => 'Google::Ads::AdWords::v201806::UserListUploadStatus',
    },
    {

        'uploadStatus' => 'uploadStatus',
        'removeAllStatus' => 'removeAllStatus',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201806::DataUploadResult

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
DataUploadResult from the namespace https://adwords.google.com/api/adwords/rm/v201806.

A class represents the data upload result for CRM based lists. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * uploadStatus


=item * removeAllStatus




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

