/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.util.Iterator;
import net.sf.saxon.expr.CallableExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.NamespaceIterator;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InScopePrefixes
extends SystemFunction
implements CallableExpression {
    public SequenceIterator iterate(XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)this.argument[0].evaluateItem(context);
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(element);
        return this.sequenceIterator(iter, context);
    }

    public SequenceIterator sequenceIterator(final Iterator<NamespaceBinding> iter, final XPathContext context) {
        return new SequenceIterator(){
            private Item current = null;
            private int position = 0;

            public Item current() {
                return this.current;
            }

            public SequenceIterator getAnother() throws XPathException {
                return InScopePrefixes.this.iterate(context);
            }

            public int getProperties() {
                return 0;
            }

            public Item next() throws XPathException {
                if (this.position == 0) {
                    this.current = new StringValue("xml");
                    ++this.position;
                    return this.current;
                }
                if (iter.hasNext()) {
                    String prefix = ((NamespaceBinding)iter.next()).getPrefix();
                    this.current = prefix.length() == 0 ? StringValue.EMPTY_STRING : new StringValue(prefix, BuiltInAtomicType.NCNAME);
                    ++this.position;
                    return this.current;
                }
                this.current = null;
                this.position = -1;
                return null;
            }

            public int position() {
                return this.position;
            }

            public void close() {
            }
        };
    }

    public SequenceIterator call(SequenceIterator[] arguments, XPathContext context) throws XPathException {
        NodeInfo element = (NodeInfo)arguments[0].next();
        Iterator<NamespaceBinding> iter = NamespaceIterator.iterateNamespaces(element);
        return this.sequenceIterator(iter, context);
    }
}

