/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Result;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public class UncommittedSerializer
extends ProxyReceiver {
    boolean committed = false;
    List<PendingNode> pending = null;
    Result finalResult;
    Properties outputProperties;

    public UncommittedSerializer(Result finalResult, Receiver next, Properties outputProperties) {
        super(next);
        this.finalResult = finalResult;
        this.outputProperties = outputProperties;
    }

    public void open() throws XPathException {
        this.committed = false;
    }

    public void close() throws XPathException {
        if (!this.committed) {
            this.switchToMethod("xml");
        }
        this.getUnderlyingReceiver().close();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().characters(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 3;
            node.name = null;
            node.content = ((Object)chars).toString();
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
            if (!Whitespace.isWhite(chars)) {
                this.switchToMethod("xml");
            }
        }
    }

    public void processingInstruction(String target, CharSequence data, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().processingInstruction(target, data, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 7;
            node.name = target;
            node.content = data;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) throws XPathException {
        if (this.committed) {
            this.getUnderlyingReceiver().comment(chars, locationId, properties);
        } else {
            if (this.pending == null) {
                this.pending = new ArrayList<PendingNode>(10);
            }
            PendingNode node = new PendingNode();
            node.kind = 8;
            node.name = null;
            node.content = chars;
            node.locationId = locationId;
            node.properties = properties;
            this.pending.add(node);
        }
    }

    public void startElement(NodeName elemName, SchemaType typeCode, int locationId, int properties) throws XPathException {
        if (!this.committed) {
            String name = elemName.getLocalPart();
            String uri = elemName.getURI();
            if (name.equalsIgnoreCase("html") && uri.length() == 0) {
                this.switchToMethod("html");
            } else if (name.equals("html") && uri.equals("http://www.w3.org/1999/xhtml")) {
                String version = this.outputProperties.getProperty("{http://saxon.sf.net/}stylesheet-version");
                if ("1.0".equals(version)) {
                    this.switchToMethod("xml");
                } else {
                    this.switchToMethod("xhtml");
                }
            } else {
                this.switchToMethod("xml");
            }
        }
        this.getUnderlyingReceiver().startElement(elemName, typeCode, locationId, properties);
    }

    private void switchToMethod(String method) throws XPathException {
        Properties newProperties = new Properties(this.outputProperties);
        newProperties.setProperty("method", method);
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        Receiver target = sf.getReceiver(this.finalResult, this.getPipelineConfiguration(), newProperties);
        this.committed = true;
        target.open();
        target.startDocument(0);
        if (this.pending != null) {
            for (PendingNode node : this.pending) {
                switch (node.kind) {
                    case 8: {
                        target.comment(node.content, node.locationId, node.properties);
                        break;
                    }
                    case 7: {
                        target.processingInstruction(node.name, node.content, node.locationId, node.properties);
                        break;
                    }
                    case 3: {
                        target.characters(node.content, node.locationId, node.properties);
                    }
                }
            }
            this.pending = null;
        }
        this.setUnderlyingReceiver(target);
    }

    private static final class PendingNode {
        int kind;
        String name;
        CharSequence content;
        int properties;
        int locationId;

        private PendingNode() {
        }
    }
}

