package Daje::Workflow::Loader;
use Mojo::Base -base, -signatures;



# NAME
# ====
#
# Daje::Workflow::Loader - Just loads Daje-Workflow JSON based workflows
#
#
# SYNOPSIS
# ========
#
#    use Daje::Workflow::Loader;
#
#    my $workflows = Daje::Workflow::Loader->new(
#         path => 'path
#    )->load();
#
#    my $workflow = $workflows->get_workflow('workflow');
#
#    my $state = $workflows->get_state('workflow','state');
#
#    my $pre_checks = $workflows->get_pre_checks('workflow','state');
#
#    my $post_checks = $workflows->get_post_checks('workflow','state');
#
#    my $activity = get_activity($workflow, $state_name, $activity_name);
#
# DESCRIPTION
# ===========
#
# Daje::Workflow::Loader is a workflow loader for
#
# the Daje-Workflow engine
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#

use Daje::Config;

has 'workflow';
has 'path';

our $VERSION = "0.06";

# Load the data into the object
sub load($self) {
    my $workflow = Daje::Config->new(
        path => $self->path,
        type => 'workflow',
    )->load();

    $self->workflow($workflow);

    return 1;
}

# Get the entire workflow as a hashref
sub get_workflow($self, $workflow) {
    return $self->workflow()->{workflow};
}

#
sub get_state($self, $workflow, $state_name) {
    my $flow = $self->workflow->{$workflow};
    my $length = scalar @{$flow};
    my $state;
    for (my $i = 0; $i < $length; $i++) {
        if (@{$flow}[$i]->{name} eq $state_name) {
            $state = @{$flow}[$i];
        }
    }

    return $state;
}

sub get_pre_checks($self, $workflow, $state_name) {
    my $state = $self->get_state($workflow, $state_name);
    return $state->{state}->{pre_checks};
}

sub get_post_checks($self, $workflow, $state_name) {
    my $state = $self->get_state($workflow, $state_name);
    return $state->{state}->{post_checks};
}

sub get_next_state($self, $workflow, $state_name) {
    my $state = $self->get_state($workflow, $state_name);
    return $state->{next_state};
}

sub get_state_observers($self, $workflow, $state_name) {
    my $state = $self->get_state($workflow, $state_name);
    return $state->{state}->{observers};
}

sub get_activity($self, $workflow, $state_name, $activity_name) {
    my $activity;
    my $activities = $self->get_state($workflow, $state_name)->{state}->{activities};
    my $length = scalar @{$activities};
    for (my $i = 0; $i < $length; $i++) {
        if (@{$activities}[$i]->{name} eq $activity_name) {
            $activity = @{$activities}[$i];
        }
    }
    return $activity;
}

1;
__END__











#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Workflow::Loader - Just loads Daje-Workflow JSON based workflows




=head1 SYNOPSIS


   use Daje::Workflow::Loader;

   my $workflows = Daje::Workflow::Loader->new(
        path => 'path
   )->load();

   my $workflow = $workflows->get_workflow('workflow');

   my $state = $workflows->get_state('workflow','state');

   my $pre_checks = $workflows->get_pre_checks('workflow','state');

   my $post_checks = $workflows->get_post_checks('workflow','state');

   my $activity = get_activity($workflow, $state_name, $activity_name);



=head1 DESCRIPTION


Daje::Workflow::Loader is a workflow loader for

the Daje-Workflow engine



=head1 REQUIRES

L<Daje::Config> 

L<Mojo::Base> 


=head1 METHODS

=head2 get_activity($self,

 get_activity($self,();

=head2 get_next_state($self,

 get_next_state($self,();

=head2 get_post_checks($self,

 get_post_checks($self,();

=head2 get_pre_checks($self,

 get_pre_checks($self,();

=head2 get_state($self,

 get_state($self,();

=head2 get_state_observers($self,

 get_state_observers($self,();

=head2 get_workflow($self,

 get_workflow($self,();

Get the entire workflow as a hashref


=head2 load($self)

 load($self)();

Load the data into the object



=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>



=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

