--
-- PostgreSQL database dump
--

-- Dumped from database version 13.4
-- Dumped by pg_dump version 13.4

-- Started on 2022-05-12 18:18:25 CEST

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 6 (class 2615 OID 3185447)
-- Name: OMOP_cdm_eunomia; Type: SCHEMA; Schema: -; Owner: juanma
--

CREATE SCHEMA "OMOP_cdm_eunomia";


ALTER SCHEMA "OMOP_cdm_eunomia" OWNER TO juanma;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 201 (class 1259 OID 3185448)
-- Name: attribute_definition; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".attribute_definition (
    attribute_definition_id integer NOT NULL,
    attribute_name character varying(255) NOT NULL,
    attribute_description text,
    attribute_type_concept_id integer NOT NULL,
    attribute_syntax text
);


ALTER TABLE "OMOP_cdm_eunomia".attribute_definition OWNER TO juanma;

--
-- TOC entry 202 (class 1259 OID 3185454)
-- Name: care_site; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".care_site (
    care_site_id integer NOT NULL,
    care_site_name character varying(255),
    place_of_service_concept_id integer,
    location_id integer,
    care_site_source_value character varying(50),
    place_of_service_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".care_site OWNER TO juanma;

--
-- TOC entry 203 (class 1259 OID 3185457)
-- Name: cdm_source; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".cdm_source (
    cdm_source_name character varying(255) NOT NULL,
    cdm_source_abbreviation character varying(25),
    cdm_holder character varying(255),
    source_description text,
    source_documentation_reference character varying(255),
    cdm_etl_reference character varying(255),
    source_release_date date,
    cdm_release_date date,
    cdm_version character varying(10),
    vocabulary_version character varying(20)
);


ALTER TABLE "OMOP_cdm_eunomia".cdm_source OWNER TO juanma;

--
-- TOC entry 204 (class 1259 OID 3185463)
-- Name: cohort; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".cohort (
    cohort_definition_id integer NOT NULL,
    subject_id integer NOT NULL,
    cohort_start_date date NOT NULL,
    cohort_end_date date NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".cohort OWNER TO juanma;

--
-- TOC entry 205 (class 1259 OID 3185466)
-- Name: cohort_attribute; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".cohort_attribute (
    cohort_definition_id integer NOT NULL,
    subject_id integer NOT NULL,
    cohort_start_date date NOT NULL,
    cohort_end_date date NOT NULL,
    attribute_definition_id integer NOT NULL,
    value_as_number numeric,
    value_as_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".cohort_attribute OWNER TO juanma;

--
-- TOC entry 206 (class 1259 OID 3185472)
-- Name: cohort_definition; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".cohort_definition (
    cohort_definition_id integer NOT NULL,
    cohort_definition_name character varying(255) NOT NULL,
    cohort_definition_description text,
    definition_type_concept_id integer NOT NULL,
    cohort_definition_syntax text,
    subject_concept_id integer NOT NULL,
    cohort_initiation_date date
);


ALTER TABLE "OMOP_cdm_eunomia".cohort_definition OWNER TO juanma;

--
-- TOC entry 207 (class 1259 OID 3185478)
-- Name: concept; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".concept (
    concept_id integer NOT NULL,
    concept_name character varying(255) NOT NULL,
    domain_id character varying(20) NOT NULL,
    vocabulary_id character varying(20) NOT NULL,
    concept_class_id character varying(20) NOT NULL,
    standard_concept character varying(1),
    concept_code character varying(50) NOT NULL,
    valid_start_date date NOT NULL,
    valid_end_date date NOT NULL,
    invalid_reason character varying(1)
);


ALTER TABLE "OMOP_cdm_eunomia".concept OWNER TO juanma;

--
-- TOC entry 208 (class 1259 OID 3185481)
-- Name: concept_ancestor; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".concept_ancestor (
    ancestor_concept_id integer NOT NULL,
    descendant_concept_id integer NOT NULL,
    min_levels_of_separation integer NOT NULL,
    max_levels_of_separation integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".concept_ancestor OWNER TO juanma;

--
-- TOC entry 209 (class 1259 OID 3185484)
-- Name: concept_class; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".concept_class (
    concept_class_id character varying(20) NOT NULL,
    concept_class_name character varying(255) NOT NULL,
    concept_class_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".concept_class OWNER TO juanma;

--
-- TOC entry 210 (class 1259 OID 3185487)
-- Name: concept_relationship; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".concept_relationship (
    concept_id_1 integer NOT NULL,
    concept_id_2 integer NOT NULL,
    relationship_id character varying(20) NOT NULL,
    valid_start_date date NOT NULL,
    valid_end_date date NOT NULL,
    invalid_reason character varying(1)
);


ALTER TABLE "OMOP_cdm_eunomia".concept_relationship OWNER TO juanma;

--
-- TOC entry 211 (class 1259 OID 3185490)
-- Name: concept_synonym; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".concept_synonym (
    concept_id integer NOT NULL,
    concept_synonym_name character varying(1000) NOT NULL,
    language_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".concept_synonym OWNER TO juanma;

--
-- TOC entry 212 (class 1259 OID 3185496)
-- Name: condition_era; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".condition_era (
    condition_era_id integer NOT NULL,
    person_id integer NOT NULL,
    condition_concept_id integer NOT NULL,
    condition_era_start_date date NOT NULL,
    condition_era_end_date date NOT NULL,
    condition_occurrence_count integer
);


ALTER TABLE "OMOP_cdm_eunomia".condition_era OWNER TO juanma;

--
-- TOC entry 213 (class 1259 OID 3185499)
-- Name: condition_occurrence; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".condition_occurrence (
    condition_occurrence_id integer NOT NULL,
    person_id integer NOT NULL,
    condition_concept_id integer NOT NULL,
    condition_start_date date NOT NULL,
    condition_start_datetime timestamp without time zone,
    condition_end_date date,
    condition_end_datetime timestamp without time zone,
    condition_type_concept_id integer NOT NULL,
    stop_reason character varying(20),
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    condition_source_value character varying(50),
    condition_source_concept_id integer,
    condition_status_source_value character varying(50),
    condition_status_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".condition_occurrence OWNER TO juanma;

--
-- TOC entry 214 (class 1259 OID 3185502)
-- Name: cost; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".cost (
    cost_id integer NOT NULL,
    cost_event_id integer NOT NULL,
    cost_domain_id character varying(20) NOT NULL,
    cost_type_concept_id integer NOT NULL,
    currency_concept_id integer,
    total_charge numeric,
    total_cost numeric,
    total_paid numeric,
    paid_by_payer numeric,
    paid_by_patient numeric,
    paid_patient_copay numeric,
    paid_patient_coinsurance numeric,
    paid_patient_deductible numeric,
    paid_by_primary numeric,
    paid_ingredient_cost numeric,
    paid_dispensing_fee numeric,
    payer_plan_period_id integer,
    amount_allowed numeric,
    revenue_code_concept_id integer,
    reveue_code_source_value character varying(50),
    drg_concept_id integer,
    drg_source_value character varying(3)
);


ALTER TABLE "OMOP_cdm_eunomia".cost OWNER TO juanma;

--
-- TOC entry 215 (class 1259 OID 3185508)
-- Name: death; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".death (
    person_id integer NOT NULL,
    death_date date NOT NULL,
    death_datetime timestamp without time zone,
    death_type_concept_id integer NOT NULL,
    cause_concept_id integer,
    cause_source_value character varying(50),
    cause_source_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".death OWNER TO juanma;

--
-- TOC entry 216 (class 1259 OID 3185511)
-- Name: device_exposure; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".device_exposure (
    device_exposure_id integer NOT NULL,
    person_id integer NOT NULL,
    device_concept_id integer NOT NULL,
    device_exposure_start_date date NOT NULL,
    device_exposure_start_datetime timestamp without time zone,
    device_exposure_end_date date,
    device_exposure_end_datetime timestamp without time zone,
    device_type_concept_id integer NOT NULL,
    unique_device_id character varying(50),
    quantity integer,
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    device_source_value character varying(100),
    device_source_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".device_exposure OWNER TO juanma;

--
-- TOC entry 217 (class 1259 OID 3185514)
-- Name: domain; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".domain (
    domain_id character varying(20) NOT NULL,
    domain_name character varying(255) NOT NULL,
    domain_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".domain OWNER TO juanma;

--
-- TOC entry 218 (class 1259 OID 3185517)
-- Name: dose_era; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".dose_era (
    dose_era_id integer NOT NULL,
    person_id integer NOT NULL,
    drug_concept_id integer NOT NULL,
    unit_concept_id integer NOT NULL,
    dose_value numeric NOT NULL,
    dose_era_start_date date NOT NULL,
    dose_era_end_date date NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".dose_era OWNER TO juanma;

--
-- TOC entry 219 (class 1259 OID 3185523)
-- Name: drug_era; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".drug_era (
    drug_era_id integer NOT NULL,
    person_id integer NOT NULL,
    drug_concept_id integer NOT NULL,
    drug_era_start_date date NOT NULL,
    drug_era_end_date date NOT NULL,
    drug_exposure_count integer,
    gap_days integer
);


ALTER TABLE "OMOP_cdm_eunomia".drug_era OWNER TO juanma;

--
-- TOC entry 220 (class 1259 OID 3185526)
-- Name: drug_exposure; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".drug_exposure (
    drug_exposure_id integer NOT NULL,
    person_id integer NOT NULL,
    drug_concept_id integer NOT NULL,
    drug_exposure_start_date date NOT NULL,
    drug_exposure_start_datetime timestamp without time zone,
    drug_exposure_end_date date NOT NULL,
    drug_exposure_end_datetime timestamp without time zone,
    verbatim_end_date date,
    drug_type_concept_id integer NOT NULL,
    stop_reason character varying(20),
    refills integer,
    quantity numeric,
    days_supply integer,
    sig text,
    route_concept_id integer,
    lot_number character varying(50),
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    drug_source_value character varying(50),
    drug_source_concept_id integer,
    route_source_value character varying(50),
    dose_unit_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".drug_exposure OWNER TO juanma;

--
-- TOC entry 221 (class 1259 OID 3185532)
-- Name: drug_strength; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".drug_strength (
    drug_concept_id integer NOT NULL,
    ingredient_concept_id integer NOT NULL,
    amount_value numeric,
    amount_unit_concept_id integer,
    numerator_value numeric,
    numerator_unit_concept_id integer,
    denominator_value numeric,
    denominator_unit_concept_id integer,
    box_size integer,
    valid_start_date date NOT NULL,
    valid_end_date date NOT NULL,
    invalid_reason character varying(1)
);


ALTER TABLE "OMOP_cdm_eunomia".drug_strength OWNER TO juanma;

--
-- TOC entry 222 (class 1259 OID 3185538)
-- Name: fact_relationship; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".fact_relationship (
    domain_concept_id_1 integer NOT NULL,
    fact_id_1 integer NOT NULL,
    domain_concept_id_2 integer NOT NULL,
    fact_id_2 integer NOT NULL,
    relationship_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".fact_relationship OWNER TO juanma;

--
-- TOC entry 223 (class 1259 OID 3185541)
-- Name: location; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".location (
    location_id integer NOT NULL,
    address_1 character varying(50),
    address_2 character varying(50),
    city character varying(50),
    state character varying(2),
    zip character varying(9),
    county character varying(20),
    location_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".location OWNER TO juanma;

--
-- TOC entry 224 (class 1259 OID 3185544)
-- Name: measurement; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".measurement (
    measurement_id integer NOT NULL,
    person_id integer NOT NULL,
    measurement_concept_id integer NOT NULL,
    measurement_date date NOT NULL,
    measurement_datetime timestamp without time zone,
    measurement_time character varying(10),
    measurement_type_concept_id integer NOT NULL,
    operator_concept_id integer,
    value_as_number numeric,
    value_as_concept_id integer,
    unit_concept_id integer,
    range_low numeric,
    range_high numeric,
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    measurement_source_value character varying(50),
    measurement_source_concept_id integer,
    unit_source_value character varying(50),
    value_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".measurement OWNER TO juanma;

--
-- TOC entry 225 (class 1259 OID 3185550)
-- Name: metadata; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".metadata (
    metadata_concept_id integer NOT NULL,
    metadata_type_concept_id integer NOT NULL,
    name character varying(250) NOT NULL,
    value_as_string text,
    value_as_concept_id integer,
    metadata_date date,
    metadata_datetime timestamp without time zone
);


ALTER TABLE "OMOP_cdm_eunomia".metadata OWNER TO juanma;

--
-- TOC entry 226 (class 1259 OID 3185556)
-- Name: note; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".note (
    note_id integer NOT NULL,
    person_id integer NOT NULL,
    note_date date NOT NULL,
    note_datetime timestamp without time zone,
    note_type_concept_id integer NOT NULL,
    note_class_concept_id integer NOT NULL,
    note_title character varying(250),
    note_text text,
    encoding_concept_id integer NOT NULL,
    language_concept_id integer NOT NULL,
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    note_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".note OWNER TO juanma;

--
-- TOC entry 227 (class 1259 OID 3185562)
-- Name: note_nlp; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".note_nlp (
    note_nlp_id integer NOT NULL,
    note_id integer NOT NULL,
    section_concept_id integer,
    snippet character varying(250),
    "offset" character varying(250),
    lexical_variant character varying(250) NOT NULL,
    note_nlp_concept_id integer,
    note_nlp_source_concept_id integer,
    nlp_system character varying(250),
    nlp_date date NOT NULL,
    nlp_datetime timestamp without time zone,
    term_exists character varying(1),
    term_temporal character varying(50),
    term_modifiers character varying(2000)
);


ALTER TABLE "OMOP_cdm_eunomia".note_nlp OWNER TO juanma;

--
-- TOC entry 228 (class 1259 OID 3185568)
-- Name: observation; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".observation (
    observation_id integer NOT NULL,
    person_id integer NOT NULL,
    observation_concept_id integer NOT NULL,
    observation_date date NOT NULL,
    observation_datetime timestamp without time zone,
    observation_type_concept_id integer NOT NULL,
    value_as_number numeric,
    value_as_string character varying(60),
    value_as_concept_id integer,
    qualifier_concept_id integer,
    unit_concept_id integer,
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    observation_source_value character varying(50),
    observation_source_concept_id integer,
    unit_source_value character varying(50),
    qualifier_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".observation OWNER TO juanma;

--
-- TOC entry 229 (class 1259 OID 3185574)
-- Name: observation_period; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".observation_period (
    observation_period_id integer NOT NULL,
    person_id integer NOT NULL,
    observation_period_start_date date NOT NULL,
    observation_period_end_date date NOT NULL,
    period_type_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".observation_period OWNER TO juanma;

--
-- TOC entry 230 (class 1259 OID 3185577)
-- Name: payer_plan_period; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".payer_plan_period (
    payer_plan_period_id integer NOT NULL,
    person_id integer NOT NULL,
    payer_plan_period_start_date date NOT NULL,
    payer_plan_period_end_date date NOT NULL,
    payer_concept_id integer,
    payer_source_value character varying(50),
    payer_source_concept_id integer,
    plan_concept_id integer,
    plan_source_value character varying(50),
    plan_source_concept_id integer,
    sponsor_concept_id integer,
    sponsor_source_value character varying(50),
    sponsor_source_concept_id integer,
    family_source_value character varying(50),
    stop_reason_concept_id integer,
    stop_reason_source_value character varying(50),
    stop_reason_source_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".payer_plan_period OWNER TO juanma;

--
-- TOC entry 231 (class 1259 OID 3185580)
-- Name: person; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".person (
    person_id integer NOT NULL,
    gender_concept_id integer NOT NULL,
    year_of_birth integer NOT NULL,
    month_of_birth integer,
    day_of_birth integer,
    birth_datetime timestamp without time zone,
    race_concept_id integer NOT NULL,
    ethnicity_concept_id integer NOT NULL,
    location_id integer,
    provider_id integer,
    care_site_id integer,
    person_source_value character varying(50),
    gender_source_value character varying(50),
    gender_source_concept_id integer,
    race_source_value character varying(50),
    race_source_concept_id integer,
    ethnicity_source_value character varying(50),
    ethnicity_source_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".person OWNER TO juanma;

--
-- TOC entry 232 (class 1259 OID 3185583)
-- Name: procedure_occurrence; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".procedure_occurrence (
    procedure_occurrence_id integer NOT NULL,
    person_id integer NOT NULL,
    procedure_concept_id integer NOT NULL,
    procedure_date date NOT NULL,
    procedure_datetime timestamp without time zone,
    procedure_type_concept_id integer NOT NULL,
    modifier_concept_id integer,
    quantity integer,
    provider_id integer,
    visit_occurrence_id integer,
    visit_detail_id integer,
    procedure_source_value character varying(50),
    procedure_source_concept_id integer,
    modifier_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".procedure_occurrence OWNER TO juanma;

--
-- TOC entry 233 (class 1259 OID 3185586)
-- Name: provider; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".provider (
    provider_id integer NOT NULL,
    provider_name character varying(255),
    npi character varying(20),
    dea character varying(20),
    specialty_concept_id integer,
    care_site_id integer,
    year_of_birth integer,
    gender_concept_id integer,
    provider_source_value character varying(50),
    specialty_source_value character varying(50),
    specialty_source_concept_id integer,
    gender_source_value character varying(50),
    gender_source_concept_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".provider OWNER TO juanma;

--
-- TOC entry 234 (class 1259 OID 3185589)
-- Name: relationship; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".relationship (
    relationship_id character varying(20) NOT NULL,
    relationship_name character varying(255) NOT NULL,
    is_hierarchical character varying(1) NOT NULL,
    defines_ancestry character varying(1) NOT NULL,
    reverse_relationship_id character varying(20) NOT NULL,
    relationship_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".relationship OWNER TO juanma;

--
-- TOC entry 235 (class 1259 OID 3185592)
-- Name: source_to_concept_map; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".source_to_concept_map (
    source_code character varying(50) NOT NULL,
    source_concept_id integer NOT NULL,
    source_vocabulary_id character varying(20) NOT NULL,
    source_code_description character varying(255),
    target_concept_id integer NOT NULL,
    target_vocabulary_id character varying(20) NOT NULL,
    valid_start_date date NOT NULL,
    valid_end_date date NOT NULL,
    invalid_reason character varying(1)
);


ALTER TABLE "OMOP_cdm_eunomia".source_to_concept_map OWNER TO juanma;

--
-- TOC entry 236 (class 1259 OID 3185595)
-- Name: specimen; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".specimen (
    specimen_id integer NOT NULL,
    person_id integer NOT NULL,
    specimen_concept_id integer NOT NULL,
    specimen_type_concept_id integer NOT NULL,
    specimen_date date NOT NULL,
    specimen_datetime timestamp without time zone,
    quantity numeric,
    unit_concept_id integer,
    anatomic_site_concept_id integer,
    disease_status_concept_id integer,
    specimen_source_id character varying(50),
    specimen_source_value character varying(50),
    unit_source_value character varying(50),
    anatomic_site_source_value character varying(50),
    disease_status_source_value character varying(50)
);


ALTER TABLE "OMOP_cdm_eunomia".specimen OWNER TO juanma;

--
-- TOC entry 237 (class 1259 OID 3185601)
-- Name: visit_detail; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".visit_detail (
    visit_detail_id integer NOT NULL,
    person_id integer NOT NULL,
    visit_detail_concept_id integer NOT NULL,
    visit_detail_start_date date NOT NULL,
    visit_detail_start_datetime timestamp without time zone,
    visit_detail_end_date date NOT NULL,
    visit_detail_end_datetime timestamp without time zone,
    visit_detail_type_concept_id integer NOT NULL,
    provider_id integer,
    care_site_id integer,
    admitting_source_concept_id integer,
    discharge_to_concept_id integer,
    preceding_visit_detail_id integer,
    visit_detail_source_value character varying(50),
    visit_detail_source_concept_id integer,
    admitting_source_value character varying(50),
    discharge_to_source_value character varying(50),
    visit_detail_parent_id integer,
    visit_occurrence_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".visit_detail OWNER TO juanma;

--
-- TOC entry 238 (class 1259 OID 3185604)
-- Name: visit_occurrence; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".visit_occurrence (
    visit_occurrence_id integer NOT NULL,
    person_id integer NOT NULL,
    visit_concept_id integer NOT NULL,
    visit_start_date date NOT NULL,
    visit_start_datetime timestamp without time zone,
    visit_end_date date NOT NULL,
    visit_end_datetime timestamp without time zone,
    visit_type_concept_id integer NOT NULL,
    provider_id integer,
    care_site_id integer,
    visit_source_value character varying(50),
    visit_source_concept_id integer,
    admitting_source_concept_id integer,
    admitting_source_value character varying(50),
    discharge_to_concept_id integer,
    discharge_to_source_value character varying(50),
    preceding_visit_occurrence_id integer
);


ALTER TABLE "OMOP_cdm_eunomia".visit_occurrence OWNER TO juanma;

--
-- TOC entry 239 (class 1259 OID 3185607)
-- Name: vocabulary; Type: TABLE; Schema: OMOP_cdm_eunomia; Owner: juanma
--

CREATE TABLE "OMOP_cdm_eunomia".vocabulary (
    vocabulary_id character varying(20) NOT NULL,
    vocabulary_name character varying(255) NOT NULL,
    vocabulary_reference character varying(255) NOT NULL,
    vocabulary_version character varying(255),
    vocabulary_concept_id integer NOT NULL
);


ALTER TABLE "OMOP_cdm_eunomia".vocabulary OWNER TO juanma;

--
-- TOC entry 3879 (class 0 OID 3185448)
-- Dependencies: 201
-- Data for Name: attribute_definition; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".attribute_definition (attribute_definition_id, attribute_name, attribute_description, attribute_type_concept_id, attribute_syntax) FROM stdin;
\.


--
-- TOC entry 3880 (class 0 OID 3185454)
-- Dependencies: 202
-- Data for Name: care_site; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".care_site (care_site_id, care_site_name, place_of_service_concept_id, location_id, care_site_source_value, place_of_service_source_value) FROM stdin;
\.


--
-- TOC entry 3881 (class 0 OID 3185457)
-- Dependencies: 203
-- Data for Name: cdm_source; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".cdm_source (cdm_source_name, cdm_source_abbreviation, cdm_holder, source_description, source_documentation_reference, cdm_etl_reference, source_release_date, cdm_release_date, cdm_version, vocabulary_version) FROM stdin;
Synthea synthetic health database	Synthea	OHDSI Community	SyntheaTM is a Synthetic Patient Population Simulator. The goal is to output synthetic, realistic (but not real), patient data and associated health records in a variety of formats.	https://synthetichealth.github.io/synthea/	https://github.com/OHDSI/ETL-Synthea	2019-05-25	2019-05-25	v5.3.1	v5.0 18-JAN-19
\.


--
-- TOC entry 3882 (class 0 OID 3185463)
-- Dependencies: 204
-- Data for Name: cohort; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".cohort (cohort_definition_id, subject_id, cohort_start_date, cohort_end_date) FROM stdin;
\.


--
-- TOC entry 3883 (class 0 OID 3185466)
-- Dependencies: 205
-- Data for Name: cohort_attribute; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".cohort_attribute (cohort_definition_id, subject_id, cohort_start_date, cohort_end_date, attribute_definition_id, value_as_number, value_as_concept_id) FROM stdin;
\.


--
-- TOC entry 3884 (class 0 OID 3185472)
-- Dependencies: 206
-- Data for Name: cohort_definition; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".cohort_definition (cohort_definition_id, cohort_definition_name, cohort_definition_description, definition_type_concept_id, cohort_definition_syntax, subject_concept_id, cohort_initiation_date) FROM stdin;
\.


--
-- TOC entry 3885 (class 0 OID 3185478)
-- Dependencies: 207
-- Data for Name: concept; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".concept (concept_id, concept_name, domain_id, vocabulary_id, concept_class_id, standard_concept, concept_code, valid_start_date, valid_end_date, invalid_reason) FROM stdin;
35208414	Gastrointestinal hemorrhage, unspecified	Condition	ICD10CM	4-char billing code		K92.2	2007-01-01	2099-12-31	
1118088	celecoxib 200 MG Oral Capsule [Celebrex]	Drug	RxNorm	Branded Drug	S	213469	1970-01-01	2099-12-31	
40213201	pneumococcal polysaccharide vaccine, 23 valent	Drug	CVX	CVX	S	33	2008-12-01	2099-12-31	
1557272	Alendronate	Drug	RxNorm	Ingredient	S	46041	1970-01-01	2099-12-31	
4336464	Coronary artery bypass graft	Procedure	SNOMED	Procedure	S	232717009	1970-01-01	2099-12-31	
4295880	Intramuscular injection	Procedure	SNOMED	Procedure	S	76601001	1970-01-01	2099-12-31	
3020630	Protein serum/plasma	Measurement	LOINC	Lab Test	S	2885-2	1970-01-01	2099-12-31	
19129655	Ampicillin 100 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	789980	2008-03-30	2099-12-31	
44923712	celecoxib 200 MG Oral Capsule [Celebrex]	Drug	NDC	11-digit NDC		00025152531	2000-01-01	2099-12-31	
1569708	Other diseases of digestive system	Condition	ICD10CM	3-char nonbill code		K92	2012-01-01	2099-12-31	
40213216	rotavirus, live, monovalent vaccine	Drug	CVX	CVX	S	119	2008-12-01	2099-12-31	
708298	Midazolam	Drug	RxNorm	Ingredient	S	6960	1970-01-01	2099-12-31	
4301346	Surgical manipulation of shoulder joint	Procedure	SNOMED	Procedure	S	387685009	1970-01-01	2099-12-31	
4246502	Neonatal screening	Procedure	SNOMED	Procedure	S	60151004	1970-01-01	2099-12-31	
3020655	Honey bee IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6844-5	1970-01-01	2099-12-31	
4116491	Escherichia coli urinary tract infection	Condition	SNOMED	Clinical Finding	S	301011002	1970-01-01	2099-12-31	
45011828	Diclofenac Sodium 75 MG Delayed Release Oral Tablet	Drug	NDC	11-digit NDC		00781178901	2000-01-01	2099-12-31	
40162359	Diclofenac Sodium 75 MG Delayed Release Oral Tablet	Drug	RxNorm	Clinical Drug	S	855926	2009-08-02	2099-12-31	
40213227	tetanus and diphtheria toxoids, adsorbed, preservative free, for adult use	Drug	CVX	CVX	S	113	2008-12-01	2099-12-31	
701322	Memantine	Drug	RxNorm	Ingredient	S	6719	1970-01-01	2099-12-31	
3002385	Erythrocyte distribution width [Ratio]	Measurement	LOINC	Lab Test	S	30385-9	1970-01-01	2099-12-31	
4199276	Removal of subcutaneous contraceptive	Procedure	SNOMED	Procedure	S	301807007	1970-01-01	2099-12-31	
3005136	Cladosporium herbarum IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6075-6	1970-01-01	2099-12-31	
4113008	Laceration of hand	Condition	SNOMED	Clinical Finding	S	284549007	1970-01-01	2099-12-31	
40213230	tetanus toxoid, reduced diphtheria toxoid, and acellular pertussis vaccine, adsorbed	Drug	CVX	CVX	S	115	2008-12-01	2099-12-31	
723013	Diazepam	Drug	RxNorm	Ingredient	S	3322	1970-01-01	2099-12-31	
3001247	Common Ragweed IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6085-5	1970-01-01	2099-12-31	
4234705	Evaluation of psychiatric state of patient	Procedure	SNOMED	Procedure	S	90407005	1970-01-01	2099-12-31	
3004501	Glucose lab	Measurement	LOINC	Lab Test	S	2345-7	1970-01-01	2099-12-31	
4156265	Facial laceration	Condition	SNOMED	Clinical Finding	S	370247008	1970-01-01	2099-12-31	
40213160	poliovirus vaccine, inactivated	Drug	CVX	CVX	S	10	2008-12-01	2099-12-31	
1129625	Diphenhydramine	Drug	RxNorm	Ingredient	S	3498	1970-01-01	2099-12-31	
3036780	American house dust mite IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6095-4	1970-01-01	2099-12-31	
4238715	Removal of intrauterine device	Procedure	SNOMED	Procedure	S	68254000	1970-01-01	2099-12-31	
3006734	White Oak IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6189-5	1970-01-01	2099-12-31	
4155034	Laceration of forearm	Condition	SNOMED	Clinical Finding	S	283371005	1970-01-01	2099-12-31	
40213180	meningococcal polysaccharide (groups A, C, Y and W-135) diphtheria toxoid conjugate vaccine (MCV4P)	Drug	CVX	CVX	S	114	2008-12-01	2099-12-31	
1149196	Cetirizine	Drug	RxNorm	Ingredient	S	20610	1970-01-01	2099-12-31	
3006451	Walnut IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6273-7	1970-01-01	2099-12-31	
4198190	Appendectomy	Procedure	SNOMED	Procedure	S	80146002	1970-01-01	2099-12-31	
3027970	Globulin [Mass/volume] in Serum by calculation	Measurement	LOINC	Lab Test	S	10834-0	1970-01-01	2099-12-31	
4109685	Laceration of foot	Condition	SNOMED	Clinical Finding	S	284551006	1970-01-01	2099-12-31	
40213251	varicella virus vaccine	Drug	CVX	CVX	S	21	2008-12-01	2099-12-31	
1149380	fluticasone	Drug	RxNorm	Ingredient	S	41126	1970-01-01	2099-12-31	
3006923	Alanine aminotransferase serum/plasma	Measurement	LOINC	Lab Test	S	1742-6	1970-01-01	2099-12-31	
4202832	Intubation	Procedure	SNOMED	Procedure	S	52765003	1970-01-01	2099-12-31	
3023103	Potassium serum/plasma	Measurement	LOINC	Lab Test	S	2823-3	1970-01-01	2099-12-31	
4048169	Allergy to house dust mite	Observation	SNOMED	Clinical Finding	S	232350006	1970-01-01	2099-12-31	
40213260	zoster vaccine, live	Drug	CVX	CVX	S	121	2008-12-01	2099-12-31	
1150770	Astemizole	Drug	RxNorm	Ingredient	S	42328	1970-01-01	2099-12-31	
3007461	Platelet count	Measurement	LOINC	Lab Test	S	26515-7	1970-01-01	2099-12-31	
4151422	Sputum examination	Procedure	SNOMED	Procedure	S	269911007	1970-01-01	2099-12-31	
3023430	Cat dander IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6833-8	1970-01-01	2099-12-31	
4240902	Allergy to peanuts	Observation	SNOMED	Clinical Finding	S	91935009	1970-01-01	2099-12-31	
40213281	diphtheria, tetanus toxoids and acellular pertussis vaccine	Drug	CVX	CVX	S	20	2008-12-01	2099-12-31	
1150836	Terfenadine	Drug	RxNorm	Ingredient	S	42330	1970-01-01	2099-12-31	
3008598	Thyroxine (T4) free [Mass/volume] in Serum or Plasma	Measurement	LOINC	Lab Test	S	3024-7	1970-01-01	2099-12-31	
4163872	Plain chest X-ray	Procedure	SNOMED	Procedure	S	399208008	1970-01-01	2099-12-31	
3027231	Wheat IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6276-0	1970-01-01	2099-12-31	
4052083	Measurement of respiratory function	Measurement	SNOMED	Procedure	S	23426006	1970-01-01	2099-12-31	
40213296	hepatitis A vaccine, adult dosage	Drug	CVX	CVX	S	52	2008-12-01	2099-12-31	
1124300	Diclofenac	Drug	RxNorm	Ingredient	S	3355	1970-01-01	2099-12-31	
3009201	Thyrotropin [Units/volume] in Serum or Plasma	Measurement	LOINC	Lab Test	S	3016-3	1970-01-01	2099-12-31	
4163951	Electrocardiographic procedure	Procedure	SNOMED	Procedure	S	29303009	1970-01-01	2099-12-31	
3026361	Red blood cell (RBC) count	Measurement	LOINC	Lab Test	S	26453-1	1970-01-01	2099-12-31	
4012477	Glucose tolerance test	Measurement	SNOMED	Procedure	S	113076002	1970-01-01	2099-12-31	
40213299	hepatitis A vaccine, pediatric/adolescent dosage, 2 dose schedule	Drug	CVX	CVX	S	83	2008-12-01	2099-12-31	
1153428	fexofenadine	Drug	RxNorm	Ingredient	S	87636	1970-01-01	2099-12-31	
3009542	Hematocrit	Measurement	LOINC	Lab Test	S	20570-8	1970-01-01	2099-12-31	
4163971	Laparoscopic cholecystectomy	Procedure	SNOMED	Procedure	S	45595009	1970-01-01	2099-12-31	
3024731	MCV	Measurement	LOINC	Lab Test	S	30428-7	1970-01-01	2099-12-31	
4047491	Radiography of humerus	Procedure	SNOMED	Procedure	S	1225002	1970-01-01	2099-12-31	
40213306	hepatitis B vaccine, adult dosage	Drug	CVX	CVX	S	43	2008-12-01	2099-12-31	
1107830	Loratadine	Drug	RxNorm	Ingredient	S	28889	1970-01-01	2099-12-31	
3010813	White Blood cell (WBC) count (leukocyte)	Measurement	LOINC	Lab Test	S	26464-8	1970-01-01	2099-12-31	
4094814	Bullet wound	Condition	SNOMED	Clinical Finding	S	262574004	1970-01-01	2099-12-31	
3024561	Albumin serum/plasma	Measurement	LOINC	Lab Test	S	1751-7	1970-01-01	2099-12-31	
4078793	Direct current cardioversion	Procedure	SNOMED	Procedure	S	180325003	1970-01-01	2099-12-31	
40213314	Haemophilus influenzae type b vaccine, PRP-OMP conjugate	Drug	CVX	CVX	S	49	2008-12-01	2099-12-31	
1110410	Morphine	Drug	RxNorm	Ingredient	S	7052	1970-01-01	2099-12-31	
3012494	Peanut IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6206-7	1970-01-01	2099-12-31	
4048695	Fracture of vertebral column without spinal cord injury	Condition	SNOMED	Clinical Finding	S	15724005	1970-01-01	2099-12-31	
40486433	Perennial allergic rhinitis	Condition	SNOMED	Clinical Finding	S	446096008	2011-01-31	2099-12-31	
4043071	Cognitive and behavioral therapy	Procedure	SNOMED	Procedure	S	228557008	1970-01-01	2099-12-31	
40213320	human papilloma virus vaccine, quadrivalent	Drug	CVX	CVX	S	62	2008-12-01	2099-12-31	
1115008	Naproxen	Drug	RxNorm	Ingredient	S	7258	1970-01-01	2099-12-31	
3013682	Urea nitrogen serum/plasma	Measurement	LOINC	Lab Test	S	3094-0	1970-01-01	2099-12-31	
4051466	Childhood asthma	Condition	SNOMED	Clinical Finding	S	233678006	1970-01-01	2099-12-31	
40769179	Percentage area affected by eczema Head and Neck [PhenX]	Measurement	LOINC	Clinical Observation	S	66519-0	2011-06-17	2099-12-31	
4037675	Brief general examination	Procedure	SNOMED	Procedure	S	162676008	1970-01-01	2099-12-31	
40213198	pneumococcal conjugate vaccine, 13 valent	Drug	CVX	CVX	S	133	2009-10-15	2099-12-31	
753626	Propofol	Drug	RxNorm	Ingredient	S	8782	1970-01-01	2099-12-31	
3011505	FEV1/FVC	Measurement	LOINC	Clinical Observation	S	19926-5	1970-01-01	2099-12-31	
4142905	Fracture of rib	Condition	SNOMED	Clinical Finding	S	33737001	1970-01-01	2099-12-31	
40769184	Percentage area affected by eczema Upper extremity - bilateral [PhenX]	Measurement	LOINC	Clinical Observation	S	66524-0	2011-06-17	2099-12-31	
4275113	Insertion of intrauterine contraceptive device	Procedure	SNOMED	Procedure	S	65200003	1970-01-01	2099-12-31	
40213154	Influenza, seasonal, injectable, preservative free	Drug	CVX	CVX	S	140	2011-11-04	2099-12-31	
1728416	Penicillin G	Drug	RxNorm	Ingredient	S	7980	1970-01-01	2099-12-31	
933724	Phenazopyridine	Drug	RxNorm	Ingredient	S	8120	1970-01-01	2099-12-31	
4144583	Diabetes mellitus due to cystic fibrosis	Condition	SNOMED	Clinical Finding	S	427089005	1970-01-01	2099-12-31	
40769189	Percentage area affected by eczema Trunk [PhenX]	Measurement	LOINC	Clinical Observation	S	66529-9	2011-06-17	2099-12-31	
4108705	Intravenous blood transfusion of packed cells	Procedure	SNOMED	Procedure	S	180207008	1970-01-01	2099-12-31	
42902245	{5 (Ethinyl Estradiol 0.02 MG / norethindrone acetate 1 MG Oral Tablet) / 7 (Ethinyl Estradiol 0.03 MG / norethindrone acetate 1 MG Oral Tablet) / 9 (Ethinyl Estradiol 0.035 MG / norethindrone acetate 1 MG Oral Tablet) / 7 (Ferrous fumarate 75 MG Oral Tab	Drug	RxNorm	Branded Pack	S	1359133	2012-12-03	2099-12-31	
738818	Doxylamine	Drug	RxNorm	Ingredient	S	3642	1970-01-01	2099-12-31	
926487	Pancreatin	Drug	RxNorm	Ingredient	S	7880	1970-01-01	2099-12-31	
4296204	First degree burn	Condition	SNOMED	Clinical Finding	S	403190006	1970-01-01	2099-12-31	
40769194	Percentage area affected by eczema Lower extremity - bilateral [PhenX]	Measurement	LOINC	Clinical Observation	S	66534-9	2011-06-17	2099-12-31	
4242997	Cholecystectomy	Procedure	SNOMED	Procedure	S	38102005	1970-01-01	2099-12-31	
40221415	{5 (dienogest 2 MG / estradiol valerate 2 MG Oral Tablet) / 17 (dienogest 3 MG / estradiol valerate 2 MG Oral Tablet) / 2 (estradiol valerate 1 MG Oral Tablet) / 2 (estradiol valerate 3 MG Oral Tablet) / 2 (Inert Ingredients 1 MG Oral Tablet) } Pack [Nata	Drug	RxNorm	Branded Pack	S	978950	2010-06-06	2099-12-31	
1124957	Oxycodone	Drug	RxNorm	Ingredient	S	7804	1970-01-01	2099-12-31	
1102527	Meperidine	Drug	RxNorm	Ingredient	S	6754	1970-01-01	2099-12-31	
4296205	Second degree burn	Condition	SNOMED	Clinical Finding	S	403191005	1970-01-01	2099-12-31	
3035995	Alkaline phosphatase serum/plasma	Measurement	LOINC	Lab Test	S	6768-6	1996-08-15	2099-12-31	
4293740	Injection of tetanus antitoxin	Procedure	SNOMED	Procedure	S	384700001	1970-01-01	2099-12-31	
43012433	21 DAY Ethinyl Estradiol 0.000625 MG/HR / Etonogestrel 0.005 MG/HR Vaginal Ring [NuvaRing]	Drug	RxNorm	Quant Branded Drug	S	1367439	2013-02-04	2099-12-31	
1125315	Acetaminophen	Drug	RxNorm	Ingredient	S	161	1970-01-01	2099-12-31	
782043	Isoflurane	Drug	RxNorm	Ingredient	S	6026	1970-01-01	2099-12-31	
4294548	Acute bacterial sinusitis	Condition	SNOMED	Clinical Finding	S	75498004	1970-01-01	2099-12-31	
1310034	3 ML Amiodarone hydrochloride 50 MG/ML Prefilled Syringe	Drug	RxNorm	Quant Clinical Drug	S	834357	2009-03-01	2099-12-31	
4243062	Radiography of wrist	Procedure	SNOMED	Procedure	S	60027007	1970-01-01	2099-12-31	
40169216	120 ACTUAT Fluticasone propionate 0.044 MG/ACTUAT Metered Dose Inhaler	Drug	RxNorm	Quant Clinical Drug	S	895994	2010-01-31	2099-12-31	
1125443	Dornase Alfa	Drug	RxNorm	Ingredient	S	337623	1970-01-01	2099-12-31	
791967	Lorazepam	Drug	RxNorm	Ingredient	S	6470	1970-01-01	2099-12-31	
4278672	Fracture of forearm	Condition	SNOMED	Clinical Finding	S	65966004	1970-01-01	2099-12-31	
40173590	Alendronic acid 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	904419	2010-04-04	2099-12-31	
4117038	Bilateral tubal ligation	Procedure	SNOMED	Procedure	S	287664005	1970-01-01	2099-12-31	
40243436	1 ML Atropine Sulfate 1 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1190795	2011-11-06	2099-12-31	
1118084	celecoxib	Drug	RxNorm	Ingredient	S	140587	1970-01-01	2099-12-31	
920293	Nitrofurantoin	Drug	RxNorm	Ingredient	S	7454	1970-01-01	2099-12-31	
4237458	Fracture of clavicle	Condition	SNOMED	Clinical Finding	S	58150001	1970-01-01	2099-12-31	
42707627	rocuronium bromide 10 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	1234995	2012-05-07	2099-12-31	
4107731	Subcutaneous immunotherapy	Procedure	SNOMED	Procedure	S	180256009	1970-01-01	2099-12-31	
40224132	0.65 ML medroxyprogesterone acetate 160 MG/ML Prefilled Syringe	Drug	RxNorm	Quant Clinical Drug	S	1000156	2010-09-05	2099-12-31	
1119510	Dextromethorphan	Drug	RxNorm	Ingredient	S	3289	1970-01-01	2099-12-31	
19010482	Cyclosporine	Drug	RxNorm	Ingredient	S	3008	1970-01-01	2099-12-31	
4283893	Sinusitis	Condition	SNOMED	Clinical Finding	S	36971009	1970-01-01	2099-12-31	
4216130	Percutaneous coronary intervention	Procedure	SNOMED	Procedure	S	415070008	1970-01-01	2099-12-31	
4218389	Whiplash injury to neck	Condition	SNOMED	Clinical Finding	S	39848009	1970-01-01	2099-12-31	
40224805	1 ML medroxyprogesterone acetate 150 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1000126	2010-09-05	2099-12-31	
1137529	salmeterol	Drug	RxNorm	Ingredient	S	36117	1970-01-01	2099-12-31	
19078219	Sufentanil	Drug	RxNorm	Ingredient	S	56795	1970-01-01	2099-12-31	
4280726	Seasonal allergic rhinitis	Condition	SNOMED	Clinical Finding	S	367498001	1970-01-01	2099-12-31	
4306014	Allergy to tree pollen	Observation	SNOMED	Clinical Finding	S	419263009	1970-01-01	2099-12-31	
4310024	Angiodysplasia of stomach	Condition	SNOMED	Clinical Finding	S	424802006	1970-01-01	2099-12-31	
1154615	200 ACTUAT Albuterol 0.09 MG/ACTUAT Metered Dose Inhaler	Drug	RxNorm	Quant Clinical Drug	S	745679	2007-12-30	2099-12-31	
757627	Galantamine	Drug	RxNorm	Ingredient	S	4637	1970-01-01	2099-12-31	
19054876	dienogest	Drug	RxNorm	Ingredient	S	22968	1970-01-01	2099-12-31	
4285898	Polyp of colon	Condition	SNOMED	Clinical Finding	S	68496003	1970-01-01	2099-12-31	
19133679	{28 (Norethindrone 0.35 MG Oral Tablet) } Pack [Errin 28 Day]	Drug	RxNorm	Branded Pack	S	831533	2009-03-01	2099-12-31	
4146173	Injury of tendon of the rotator cuff of shoulder	Condition	SNOMED	Clinical Finding	S	307731004	1970-01-01	2099-12-31	
40220386	100 ML Propofol 10 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1808217	2016-10-03	2099-12-31	
740275	Carbamazepine	Drug	RxNorm	Ingredient	S	2002	1970-01-01	2099-12-31	
19074841	12 HR Cefaclor 500 MG Extended Release Oral Tablet	Drug	RxNorm	Quant Clinical Drug	S	309043	1970-01-01	2099-12-31	
4149245	Rupture of patellar tendon	Condition	SNOMED	Clinical Finding	S	30832001	1970-01-01	2099-12-31	
44805732	Reinsertion of subcutaneous contraceptive	Procedure	SNOMED	Procedure	S	755621000000101	2014-04-01	2099-12-31	
4266809	Diverticular disease	Condition	SNOMED	Clinical Finding	S	397881000	1970-01-01	2099-12-31	
40223774	Donepezil hydrochloride 23 MG [Aricept]	Drug	RxNorm	Branded Drug Comp	S	998582	2010-08-01	2099-12-31	
1154029	Fentanyl	Drug	RxNorm	Ingredient	S	4337	1970-01-01	2099-12-31	
1127078	Acetaminophen 160 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	282464	1970-01-01	2099-12-31	
4152936	Laceration of thigh	Condition	SNOMED	Clinical Finding	S	283385000	1970-01-01	2099-12-31	
42535580	Ultrasonography of abdomen, right upper quadrant and epigastrium	Procedure	SNOMED	Procedure	S	426701000119108	2018-01-31	2099-12-31	
4230399	Closed fracture of hip	Condition	SNOMED	Clinical Finding	S	359817006	1970-01-01	2099-12-31	
40171902	Verapamil hydrochloride 40 MG	Drug	RxNorm	Clinical Drug Comp	S	897718	2010-02-28	2099-12-31	
1154343	Albuterol	Drug	RxNorm	Ingredient	S	435	1970-01-01	2099-12-31	
1127433	Acetaminophen 325 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	313782	1970-01-01	2099-12-31	
4166224	Rupture of appendix	Condition	SNOMED	Clinical Finding	S	47693006	1970-01-01	2099-12-31	
21494966	Physical findings of Abdomen by Palpation	Measurement	LOINC	Clinical Observation	S	80271-0	2016-06-24	2099-12-31	
4304110	Allergy to mold	Observation	SNOMED	Clinical Finding	S	419474003	1970-01-01	2099-12-31	
1718412	Levonorgestrel 0.000729 MG/HR Intrauterine System [Kyleena]	Drug	RxNorm	Branded Drug	S	1856546	2017-01-03	2099-12-31	
9201	Inpatient Visit	Visit	Visit	Visit	S	IP	1970-01-01	2099-12-31	
920300	Nitrofurantoin 5 MG/ML Oral Suspension	Drug	RxNorm	Clinical Drug	S	311989	1970-01-01	2099-12-31	
3014599	Egg white IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6106-9	1970-01-01	2099-12-31	
45769019	Female infertility due to cystic fibrosis	Condition	SNOMED	Clinical Finding	S	707577004	2015-01-31	2099-12-31	
4169137	Allergy to wheat	Observation	SNOMED	Clinical Finding	S	420174000	1970-01-01	2099-12-31	
40174880	Levothyroxine Sodium 0.075 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	966222	2010-04-04	2099-12-31	
9202	Outpatient Visit	Visit	Visit	Visit	S	OP	1970-01-01	2099-12-31	
920334	NITROFURANTOIN, MACROCRYSTALS 50 MG Oral Capsule	Drug	RxNorm	Clinical Drug	S	311995	1970-01-01	2099-12-31	
1332419	Amlodipine 5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	197361	1970-01-01	2099-12-31	
45766064	History of single seizure	Observation	SNOMED	Context-dependent	S	703151001	2015-01-31	2099-12-31	
4219399	Allergy to fish	Observation	SNOMED	Clinical Finding	S	417532002	1970-01-01	2099-12-31	
40222846	Memantine hydrochloride 2 MG/ML Oral Solution	Drug	RxNorm	Clinical Drug	S	996740	2010-07-04	2099-12-31	
9203	Emergency Room Visit	Visit	Visit	Visit	S	ER	1970-01-01	2099-12-31	
19019273	Naproxen 500 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	198014	1970-01-01	2099-12-31	
19057271	Lorazepam 2 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	238100	1970-01-01	2099-12-31	
46221626	Levonorgestrel 0.000813 MG/HR Intrauterine System [Liletta]	Drug	RxNorm	Branded Drug	S	1605257	2015-05-04	2099-12-31	
4314290	Cystic fibrosis sweat test	Measurement	SNOMED	Procedure	S	86964003	1970-01-01	2099-12-31	
40223768	Donepezil hydrochloride 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	997223	2010-08-01	2099-12-31	
0	No matching concept	Metadata	None	Undefined		No matching concept	1970-01-01	2099-12-31	
19007333	Methotrexate 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	105586	1970-01-01	2099-12-31	
1589505	Levonorgestrel	Drug	RxNorm	Ingredient	S	6373	1970-01-01	2099-12-31	
45892894	24 HR Donepezil hydrochloride 10 MG / Memantine hydrochloride 28 MG Extended Release Oral Capsule	Drug	RxNorm	Quant Clinical Drug	S	1599803	2015-03-02	2099-12-31	
4133840	Spirometry	Measurement	SNOMED	Procedure	S	127783003	1970-01-01	2099-12-31	
40223821	Fexofenadine hydrochloride 30 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	997488	2010-08-01	2099-12-31	
433644	Shellfish allergy	Observation	SNOMED	Clinical Finding	S	300913006	1970-01-01	2099-12-31	
19019979	Ibuprofen 100 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	198405	1970-01-01	2099-12-31	
705944	Methylphenidate	Drug	RxNorm	Ingredient	S	6901	1970-01-01	2099-12-31	
19112599	Chlorpheniramine Maleate 2 MG/ML Oral Solution	Drug	RxNorm	Clinical Drug	S	477045	1970-01-01	2099-12-31	
4252419	Radiologic examination of knee	Procedure	SNOMED	Procedure	S	74016001	1970-01-01	2099-12-31	
40223834	Fexofenadine hydrochloride 60 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	997501	2010-08-01	2099-12-31	
442116	Allergy to eggs	Observation	SNOMED	Clinical Finding	S	91930004	1970-01-01	2099-12-31	
19074843	Cefaclor 250 MG Oral Capsule	Drug	RxNorm	Clinical Drug	S	309045	1970-01-01	2099-12-31	
715997	donepezil	Drug	RxNorm	Ingredient	S	135447	1970-01-01	2099-12-31	
19077344	ferrous sulfate 325 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	310325	1970-01-01	2099-12-31	
4218408	Collection of blood specimen for laboratory	Procedure	SNOMED	Procedure	S	82078001	1970-01-01	2099-12-31	
40220960	alteplase 100 MG Injection	Drug	RxNorm	Clinical Drug	S	1804799	2016-10-03	2099-12-31	
438614	Allergy to nut	Observation	SNOMED	Clinical Finding	S	91934008	1970-01-01	2099-12-31	
19075001	Cefuroxime 250 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	309097	1970-01-01	2099-12-31	
1322184	clopidogrel	Drug	RxNorm	Ingredient	S	32968	1970-01-01	2099-12-31	
19078924	Midazolam 1 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	311700	1970-01-01	2099-12-31	
4170947	Bone immobilization	Procedure	SNOMED	Procedure	S	274474001	1970-01-01	2099-12-31	
43012036	Chlorpheniramine Maleate 4 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1363309	2013-01-07	2099-12-31	
198809	Acute cholecystitis	Condition	SNOMED	Clinical Finding	S	65275009	1970-01-01	2099-12-31	
19073183	Amoxicillin 250 MG Oral Capsule	Drug	RxNorm	Clinical Drug	S	308182	1970-01-01	2099-12-31	
1367571	heparin	Drug	RxNorm	Ingredient	S	5224	1970-01-01	2099-12-31	
19076374	Diazepam 5 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	309845	1970-01-01	2099-12-31	
4230209	Psychiatric follow-up	Procedure	SNOMED	Procedure	S	88848003	1970-01-01	2099-12-31	
1594382	NDA020800 0.3 ML Epinephrine 1 MG/ML Auto-Injector	Drug	RxNorm	Clinical Drug	S	1870230	2017-08-07	2099-12-31	
195588	Cystitis	Condition	SNOMED	Clinical Finding	S	38822007	1970-01-01	2099-12-31	
19073188	Amoxicillin 500 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	308192	1970-01-01	2099-12-31	
1500211	Medroxyprogesterone	Drug	RxNorm	Ingredient	S	6691	1970-01-01	2099-12-31	
19079524	Sodium Chloride 9 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	313002	1970-01-01	2099-12-31	
4337138	Transplant of lung	Procedure	SNOMED	Procedure	S	88039007	1970-01-01	2099-12-31	
43012754	Levonorgestrel 0.00354 MG/HR Drug Implant	Drug	RxNorm	Clinical Drug	S	1366343	2013-02-04	2099-12-31	
378001	Concussion with no loss of consciousness	Condition	SNOMED	Clinical Finding	S	62106007	1970-01-01	2099-12-31	
19075601	clopidogrel 75 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	309362	1970-01-01	2099-12-31	
1309944	Amiodarone	Drug	RxNorm	Ingredient	S	703	1970-01-01	2099-12-31	
19077572	Galantamine 4 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	310436	1970-01-01	2099-12-31	
4337611	Single lung transplant	Procedure	SNOMED	Procedure	S	232657004	1970-01-01	2099-12-31	
40229134	Acetaminophen 21.7 MG/ML / Dextromethorphan Hydrobromide 1 MG/ML / doxylamine succinate 0.417 MG/ML Oral Solution	Drug	RxNorm	Clinical Drug	S	1043400	2010-12-05	2099-12-31	
378419	Alzheimer's disease	Condition	SNOMED	Clinical Finding	S	26929004	1970-01-01	2099-12-31	
19059056	Aspirin 81 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	243670	1970-01-01	2099-12-31	
1305058	Methotrexate	Drug	RxNorm	Ingredient	S	6851	1970-01-01	2099-12-31	
19029476	Dornase Alfa 1 MG/ML Inhalant Solution [Pulmozyme]	Drug	RxNorm	Branded Drug	S	205532	1970-01-01	2099-12-31	
4168004	Burn injury	Observation	SNOMED	Morph Abnormality	S	48333001	1970-01-01	2099-12-31	
40236824	Phenazopyridine hydrochloride 100 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1094107	2011-04-03	2099-12-31	
317009	Asthma	Condition	SNOMED	Clinical Finding	S	195967001	1970-01-01	2099-12-31	
19078461	Ibuprofen 200 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	310965	1970-01-01	2099-12-31	
1347450	alteplase	Drug	RxNorm	Ingredient	S	8410	1970-01-01	2099-12-31	
19045231	Pancreatin 600 MG Oral Tablet [Pancreatin 4X]	Drug	RxNorm	Branded Drug	S	210856	1970-01-01	2099-12-31	
19016749	remifentanil	Drug	RxNorm	Ingredient	S	73032	1970-01-01	2099-12-31	
40236446	Methylphenidate Hydrochloride 20 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1091392	2011-03-06	2099-12-31	
317576	Coronary arteriosclerosis	Condition	SNOMED	Clinical Finding	S	53741008	1970-01-01	2099-12-31	
4323902	Lung volume reduction surgery	Procedure	SNOMED	Procedure	S	429609002	2008-01-31	2099-12-31	
1310149	Warfarin	Drug	RxNorm	Ingredient	S	11289	1970-01-01	2099-12-31	
19074679	Carbamazepine 20 MG/ML Oral Suspension [Tegretol]	Drug	RxNorm	Branded Drug	S	308971	1970-01-01	2099-12-31	
19003953	Rocuronium	Drug	RxNorm	Ingredient	S	68139	1970-01-01	2099-12-31	
1713671	Amoxicillin 250 MG / Clavulanate 125 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	562251	2005-09-11	2099-12-31	
258780	Emphysematous bronchitis	Condition	SNOMED	Clinical Finding	S	185086009	1970-01-01	2099-12-31	
4324181	History of cardiac arrest	Observation	SNOMED	Context-dependent	S	429007001	2008-01-31	2099-12-31	
1326303	Digoxin	Drug	RxNorm	Ingredient	S	3407	1970-01-01	2099-12-31	
1729720	Penicillin V	Drug	RxNorm	Ingredient	S	7984	1970-01-01	2099-12-31	
19006318	Penicillin G 375 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	105078	1970-01-01	2099-12-31	
964261	Vitamin B 12 5 MG/ML Injectable Solution	Drug	RxNorm	Clinical Drug	S	2001499	2018-04-02	2099-12-31	
260139	Acute bronchitis	Condition	SNOMED	Clinical Finding	S	10509002	1970-01-01	2099-12-31	
40481087	Viral sinusitis	Condition	SNOMED	Clinical Finding	S	444814009	2010-07-31	2099-12-31	
1332418	Amlodipine	Drug	RxNorm	Ingredient	S	17767	1970-01-01	2099-12-31	
742185	atomoxetine	Drug	RxNorm	Ingredient	S	38400	1970-01-01	2099-12-31	
44816277	168 HR Ethinyl Estradiol 0.00146 MG/HR / norelgestromin 0.00625 MG/HR Transdermal System	Drug	RxNorm	Quant Clinical Drug	S	1534809	2014-05-05	2099-12-31	
40231925	Acetaminophen 325 MG / Oxycodone Hydrochloride 5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1049221	2011-01-02	2099-12-31	
133834	Atopic dermatitis	Condition	SNOMED	Clinical Finding	S	24079001	1970-01-01	2099-12-31	
3006906	Calcium serum/plasma serum/plasma	Measurement	LOINC	Lab Test	S	17861-6	1998-07-09	2099-12-31	
1361711	Nitroglycerin	Drug	RxNorm	Ingredient	S	4917	1970-01-01	2099-12-31	
1112807	Aspirin	Drug	RxNorm	Ingredient	S	1191	1970-01-01	2099-12-31	
35605482	2 ML Ondansetron 2 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1740467	2016-05-02	2099-12-31	
1115171	Naproxen sodium 220 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	849574	2009-05-31	2099-12-31	
134438	Contact dermatitis	Condition	SNOMED	Clinical Finding	S	40275004	1970-01-01	2099-12-31	
3045716	Anion gap serum/plasma	Measurement	LOINC	Lab Test	S	33037-3	2002-11-06	2099-12-31	
372328	Otitis media	Condition	SNOMED	Clinical Finding	S	65363002	1970-01-01	2099-12-31	
967823	Sodium Chloride	Drug	RxNorm	Ingredient	S	9863	1970-01-01	2099-12-31	
35605858	1 ML Morphine Sulfate 5 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1732136	2016-05-02	2099-12-31	
40163554	Warfarin Sodium 5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	855332	2009-08-02	2099-12-31	
78272	Sprain of wrist	Condition	SNOMED	Clinical Finding	S	70704007	1970-01-01	2099-12-31	
3028833	Bilirubin.total [Mass/volume] in Blood	Measurement	LOINC	Lab Test	S	42719-5	2005-10-18	2099-12-31	
375671	Concussion with loss of consciousness	Condition	SNOMED	Clinical Finding	S	62564004	1970-01-01	2099-12-31	
1778162	Cefuroxime	Drug	RxNorm	Ingredient	S	2194	1970-01-01	2099-12-31	
40766240	Are you covered by health insurance or some other kind of health care plan [PhenX]	Measurement	LOINC	Clinical Observation	S	63513-6	2011-02-17	2099-12-31	
40162522	Acetaminophen 325 MG / Hydrocodone Bitartrate 7.5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	857005	2009-08-02	2099-12-31	
80809	Rheumatoid arthritis	Condition	SNOMED	Clinical Finding	S	69896004	1970-01-01	2099-12-31	
40232448	Diphenhydramine Hydrochloride 25 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1049630	2011-01-02	2099-12-31	
313217	Atrial fibrillation	Condition	SNOMED	Clinical Finding	S	49436004	1970-01-01	2099-12-31	
1512674	drospirenone	Drug	RxNorm	Ingredient	S	11636	1970-01-01	2099-12-31	
46275444	Piperacillin 4000 MG / tazobactam 500 MG Injection	Drug	RxNorm	Clinical Drug	S	1659149	2015-09-08	2099-12-31	
1519937	Etonogestrel 68 MG Drug Implant	Drug	RxNorm	Clinical Drug	S	389221	1970-01-01	2099-12-31	
81151	Sprain of ankle	Condition	SNOMED	Clinical Finding	S	44465007	1970-01-01	2099-12-31	
782047	Isoflurane 999 MG/ML Inhalant Solution	Drug	RxNorm	Clinical Drug	S	542347	2005-09-11	2099-12-31	
321042	Cardiac arrest	Condition	SNOMED	Clinical Finding	S	410429000	1970-01-01	2099-12-31	
1177480	Ibuprofen	Drug	RxNorm	Ingredient	S	5640	1970-01-01	2099-12-31	
46275916	1 ML Epinephrine 1 MG/ML Injection	Drug	RxNorm	Quant Clinical Drug	S	1660014	2015-09-08	2099-12-31	
1551192	Prednisone 5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	312617	1970-01-01	2099-12-31	
28060	Streptococcal sore throat	Condition	SNOMED	Clinical Finding	S	43878008	1970-01-01	2099-12-31	
4048171	Perennial allergic rhinitis with seasonal variation	Condition	SNOMED	Clinical Finding	S	232353008	1970-01-01	2099-12-31	
261325	Pulmonary emphysema	Condition	SNOMED	Clinical Finding	S	87433001	1970-01-01	2099-12-31	
1192710	Chlorpheniramine	Drug	RxNorm	Ingredient	S	2400	1970-01-01	2099-12-31	
1396131	ferrous sulfate	Drug	RxNorm	Ingredient	S	24947	1970-01-01	2099-12-31	
1539411	Simvastatin 20 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	312961	1970-01-01	2099-12-31	
30753	Esophagitis	Condition	SNOMED	Clinical Finding	S	16761005	1970-01-01	2099-12-31	
4035415	Tear of meniscus of knee	Condition	SNOMED	Clinical Finding	S	239720000	1970-01-01	2099-12-31	
441267	Cystic fibrosis	Condition	SNOMED	Clinical Finding	S	190905008	1970-01-01	2099-12-31	
1343916	Epinephrine	Drug	RxNorm	Ingredient	S	3992	1970-01-01	2099-12-31	
1307863	Verapamil	Drug	RxNorm	Ingredient	S	11170	1970-01-01	2099-12-31	
1545959	atorvastatin 80 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	259255	1970-01-01	2099-12-31	
196456	Gallstone	Condition	SNOMED	Clinical Finding	S	235919008	1970-01-01	2099-12-31	
4112343	Acute viral pharyngitis	Condition	SNOMED	Clinical Finding	S	195662009	1970-01-01	2099-12-31	
439777	Anemia	Condition	SNOMED	Clinical Finding	S	271737000	1970-01-01	2099-12-31	
19039298	sevoflurane	Drug	RxNorm	Ingredient	S	36453	1970-01-01	2099-12-31	
1308738	Vitamin B 12	Drug	RxNorm	Ingredient	S	11248	1970-01-01	2099-12-31	
1150771	Astemizole 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	197378	1970-01-01	2099-12-31	
80180	Osteoarthritis	Condition	SNOMED	Clinical Finding	S	396275006	1970-01-01	2099-12-31	
914335	Atropine	Drug	RxNorm	Ingredient	S	1223	1970-01-01	2099-12-31	
380378	Epilepsy	Condition	SNOMED	Clinical Finding	S	84757009	1970-01-01	2099-12-31	
19059528	Alfentanil	Drug	RxNorm	Ingredient	S	480	1970-01-01	2099-12-31	
1501700	levothyroxine	Drug	RxNorm	Ingredient	S	10582	1970-01-01	2099-12-31	
1150837	Terfenadine 60 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	141918	1970-01-01	2099-12-31	
80502	Osteoporosis	Condition	SNOMED	Clinical Finding	S	64859006	1970-01-01	2099-12-31	
836654	Tacrine	Drug	RxNorm	Ingredient	S	10318	1970-01-01	2099-12-31	
381316	Cerebrovascular accident	Condition	SNOMED	Clinical Finding	S	230690007	1970-01-01	2099-12-31	
40479422	Injury of medial collateral ligament of knee	Condition	SNOMED	Clinical Finding	S	444448004	2010-01-31	2099-12-31	
1503184	Mestranol	Drug	RxNorm	Ingredient	S	6782	1970-01-01	2099-12-31	
1107882	Loratadine 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	311372	1970-01-01	2099-12-31	
81893	Ulcerative colitis	Condition	SNOMED	Clinical Finding	S	64766004	1970-01-01	2099-12-31	
836659	Tacrine 10 MG Oral Capsule	Drug	RxNorm	Clinical Drug	S	313185	1970-01-01	2099-12-31	
433125	Infection due to Staphylococcus aureus	Condition	SNOMED	Clinical Finding	S	406602003	1970-01-01	2099-12-31	
40479768	Injury of anterior cruciate ligament	Condition	SNOMED	Clinical Finding	S	444470001	2010-01-31	2099-12-31	
40480160	Pathological fracture due to osteoporosis	Condition	SNOMED	Clinical Finding	S	443165006	2010-01-31	2099-12-31	
1595799	Ferrous fumarate	Drug	RxNorm	Ingredient	S	24941	1970-01-01	2099-12-31	
198199	Pyelonephritis	Condition	SNOMED	Clinical Finding	S	45816000	1970-01-01	2099-12-31	
3000963	Hemoglobin	Measurement	LOINC	Lab Test	S	718-7	1970-01-01	2099-12-31	
440086	Child attention deficit disorder	Condition	SNOMED	Clinical Finding	S	192127007	1970-01-01	2099-12-31	
40478878	Cystic fibrosis 20 common mutation test	Measurement	SNOMED	Procedure	S	444260001	2010-01-31	2099-12-31	
4202451	Percutaneous mechanical thrombectomy of portal vein using fluoroscopic guidance	Procedure	SNOMED	Procedure	S	433112001	2009-01-31	2099-12-31	
1717327	Ampicillin	Drug	RxNorm	Ingredient	S	733	1970-01-01	2099-12-31	
255848	Pneumonia	Condition	SNOMED	Clinical Finding	S	233604007	1970-01-01	2099-12-31	
3001488	Cow milk IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	7258-7	1970-01-01	2099-12-31	
440448	Appendicitis	Condition	SNOMED	Clinical Finding	S	74400008	1970-01-01	2099-12-31	
3006322	Oral temperature	Measurement	LOINC	Clinical Observation	S	8331-1	1996-09-06	2099-12-31	
19089061	Prednisone 2.5 MG [Deltasone]	Drug	RxNorm	Branded Drug Comp	S	567645	2005-09-11	2099-12-31	
1738521	Doxycycline	Drug	RxNorm	Ingredient	S	3640	1970-01-01	2099-12-31	
257012	Chronic sinusitis	Condition	SNOMED	Clinical Finding	S	40055000	1970-01-01	2099-12-31	
3019550	Sodium serum/plasma	Measurement	LOINC	Lab Test	S	2951-2	1970-01-01	2099-12-31	
4001336	Concussion injury of brain	Condition	SNOMED	Clinical Finding	S	110030002	1970-01-01	2099-12-31	
4125906	Suture open wound	Procedure	SNOMED	Procedure	S	288086009	1970-01-01	2099-12-31	
19115351	Diazepam 5 MG [Valium]	Drug	RxNorm	Branded Drug Comp	S	563026	2005-09-11	2099-12-31	
975125	Hydrocortisone	Drug	RxNorm	Ingredient	S	5492	1970-01-01	2099-12-31	
192671	Gastrointestinal hemorrhage	Condition	SNOMED	Clinical Finding	S	74474003	1970-01-01	2099-12-31	
3015632	Carbon dioxide serum/plasma	Measurement	LOINC	Lab Test	S	2028-9	1970-01-01	2099-12-31	
4029498	Seizure disorder	Condition	SNOMED	Clinical Finding	S	128613002	1970-01-01	2099-12-31	
4132546	Traumatic brain injury	Condition	SNOMED	Clinical Finding	S	127295002	1970-01-01	2099-12-31	
19128263	{7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.18 MG Oral Tablet) / 7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.215 MG Oral Tablet) / 7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.25 MG Oral Tablet) / 7 (Inert Ingredients 1 MG Oral Tablet) } Pack [Tr	Drug	RxNorm	Branded Pack	S	751905	2008-01-27	2099-12-31	
1000560	Ondansetron	Drug	RxNorm	Ingredient	S	26225	1970-01-01	2099-12-31	
140673	Hypothyroidism	Condition	SNOMED	Clinical Finding	S	40930008	1970-01-01	2099-12-31	
3015076	Soybean IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6248-9	1970-01-01	2099-12-31	
4027663	Peptic ulcer	Condition	SNOMED	Clinical Finding	S	13200003	1970-01-01	2099-12-31	
4174876	Allergy to bee venom	Observation	SNOMED	Clinical Finding	S	424213003	1970-01-01	2099-12-31	
19127904	{24 (drospirenone 3 MG / Ethinyl Estradiol 0.02 MG Oral Tablet) / 4 (Inert Ingredients 1 MG Oral Tablet) } Pack [Yaz 28 Day]	Drug	RxNorm	Branded Pack	S	748856	2007-12-30	2099-12-31	
1741122	tazobactam	Drug	RxNorm	Ingredient	S	37617	1970-01-01	2099-12-31	
4066995	Fracture of vertebral column with spinal cord injury	Condition	SNOMED	Clinical Finding	S	1734006	1970-01-01	2099-12-31	
3016723	Creatinine serum/plasma	Measurement	LOINC	Lab Test	S	2160-0	1970-01-01	2099-12-31	
4043241	Familial Alzheimer's disease of early onset	Condition	SNOMED	Clinical Finding	S	230265002	1970-01-01	2099-12-31	
4139681	Allergy to dairy product	Observation	SNOMED	Clinical Finding	S	425525006	1970-01-01	2099-12-31	
19127918	{21 (Ethinyl Estradiol 0.03 MG / Levonorgestrel 0.15 MG Oral Tablet) / 7 (Inert Ingredients 1 MG Oral Tablet) } Pack [Levora 0.15/30 28 Day]	Drug	RxNorm	Branded Pack	S	748879	2007-12-30	2099-12-31	
1759842	Clavulanate	Drug	RxNorm	Ingredient	S	48203	1970-01-01	2099-12-31	
4059173	Fracture of ankle	Condition	SNOMED	Clinical Finding	S	16114001	1970-01-01	2099-12-31	
3021226	Shrimp IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6246-3	1970-01-01	2099-12-31	
4084167	Acute allergic reaction	Condition	SNOMED	Clinical Finding	S	241929008	1970-01-01	2099-12-31	
19018935	Digoxin 0.125 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	197604	1970-01-01	2099-12-31	
19127922	{28 (Norethindrone 0.35 MG Oral Tablet) } Pack [Camila 28 Day]	Drug	RxNorm	Branded Pack	S	748962	2007-12-30	2099-12-31	
1713332	Amoxicillin	Drug	RxNorm	Ingredient	S	723	1970-01-01	2099-12-31	
4056621	Recurrent urinary tract infection	Condition	SNOMED	Clinical Finding	S	197927001	1970-01-01	2099-12-31	
3019406	Latex IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6158-0	1970-01-01	2099-12-31	
4134304	Fracture subluxation of wrist	Condition	SNOMED	Clinical Finding	S	263102004	1970-01-01	2099-12-31	
19023398	sevoflurane 1000 MG/ML Inhalant Solution	Drug	RxNorm	Clinical Drug	S	200243	1970-01-01	2099-12-31	
19128009	{7 (Ethinyl Estradiol 0.01 MG Oral Tablet) / 84 (Ethinyl Estradiol 0.03 MG / Levonorgestrel 0.15 MG Oral Tablet) } Pack [Seasonique]	Drug	RxNorm	Branded Pack	S	749762	2007-12-30	2099-12-31	
1746114	Piperacillin	Drug	RxNorm	Ingredient	S	8339	1970-01-01	2099-12-31	
4299128	Third degree burn	Condition	SNOMED	Clinical Finding	S	403192003	1970-01-01	2099-12-31	
3014576	Chloride serum/plasma	Measurement	LOINC	Lab Test	S	2075-0	1970-01-01	2099-12-31	
4015189	Microbial culture of sputum	Measurement	SNOMED	Procedure	S	104173009	1970-01-01	2099-12-31	
19023423	desflurane 990 MG/ML Inhalant Solution	Drug	RxNorm	Clinical Drug	S	200252	1970-01-01	2099-12-31	
19128022	{7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.18 MG Oral Tablet) / 7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.215 MG Oral Tablet) / 7 (Ethinyl Estradiol 0.035 MG / norgestimate 0.25 MG Oral Tablet) / 7 (Inert Ingredients 1 MG Oral Tablet) } Pack [Or	Drug	RxNorm	Branded Pack	S	749785	2007-12-30	2099-12-31	
1768849	Cefaclor	Drug	RxNorm	Ingredient	S	2176	1970-01-01	2099-12-31	
4329847	Myocardial infarction	Condition	SNOMED	Clinical Finding	S	22298006	1970-01-01	2099-12-31	
3013721	Aspartate aminotransferase serum/plasma	Measurement	LOINC	Lab Test	S	1920-8	1970-01-01	2099-12-31	
4010253	Nasal sinus endoscopy	Procedure	SNOMED	Procedure	S	112790001	1970-01-01	2099-12-31	
19008572	Hydrocortisone 10 MG/ML Topical Cream	Drug	RxNorm	Clinical Drug	S	106258	1970-01-01	2099-12-31	
19127890	Inert Ingredients	Drug	RxNorm	Ingredient	S	748794	2007-12-30	2099-12-31	
1174888	Hydrocodone	Drug	RxNorm	Ingredient	S	5489	1970-01-01	2099-12-31	
439406	Allergy to animal dander	Observation	SNOMED	Clinical Finding	S	232347008	1970-01-01	2099-12-31	
3000876	Codfish IgE Ab [Units/volume] in Serum	Measurement	LOINC	Lab Test	S	6082-2	1970-01-01	2099-12-31	
4035793	Pulmonary rehabilitation	Procedure	SNOMED	Procedure	S	15081005	1970-01-01	2099-12-31	
19002770	desflurane	Drug	RxNorm	Ingredient	S	27340	1970-01-01	2099-12-31	
19123231	atomoxetine 100 MG Oral Capsule	Drug	RxNorm	Clinical Drug	S	608139	2006-02-26	2099-12-31	
1515774	norgestimate	Drug	RxNorm	Ingredient	S	31994	1970-01-01	2099-12-31	
443279	Attempted suicide - cut/stab	Observation	SNOMED	Clinical Finding	S	287185009	1970-01-01	2099-12-31	
3051031	History of Hospitalizations+Outpatient visits Narrative	Measurement	LOINC	Clinical Observation	S	46240-8	1970-01-01	2099-12-31	
4186930	Replacement of intrauterine contraceptive device	Procedure	SNOMED	Procedure	S	46706006	1970-01-01	2099-12-31	
19132304	Levonorgestrel 0.000833 MG/HR Intrauterine System [Mirena]	Drug	RxNorm	Branded Drug	S	807283	2008-09-28	2099-12-31	
44782520	Chronic paralysis due to lesion of spinal cord	Condition	SNOMED	Clinical Finding	S	698754002	2014-01-31	2099-12-31	
1518198	norelgestromin	Drug	RxNorm	Ingredient	S	326374	1970-01-01	2099-12-31	
4102123	Latex allergy	Observation	SNOMED	Clinical Finding	S	300916003	1970-01-01	2099-12-31	
4326177	Medication Reconciliation	Procedure	SNOMED	Procedure	S	430193006	2009-01-31	2099-12-31	
4191853	Allergy screening test	Procedure	SNOMED	Procedure	S	395142003	1970-01-01	2099-12-31	
19134077	cyclosporine, modified 100 MG [Neoral]	Drug	RxNorm	Branded Drug Comp	S	835900	2009-04-05	2099-12-31	
40758406	HIV status	Measurement	LOINC	Clinical Observation	S	55277-8	2009-03-26	2099-12-31	
1519936	Etonogestrel	Drug	RxNorm	Ingredient	S	14584	1970-01-01	2099-12-31	
4302207	Allergy to grass pollen	Observation	SNOMED	Clinical Finding	S	418689008	1970-01-01	2099-12-31	
4323208	History of appendectomy	Observation	SNOMED	Context-dependent	S	428251008	2008-01-31	2099-12-31	
4181917	Electroencephalogram	Procedure	SNOMED	Procedure	S	54550000	1970-01-01	2099-12-31	
19128065	{7 (Inert Ingredients 1 MG Oral Tablet) / 21 (Mestranol 0.05 MG / Norethindrone 1 MG Oral Tablet) } Pack [Norinyl 1+50 28 Day]	Drug	RxNorm	Branded Pack	S	749882	2007-12-30	2099-12-31	
46235214	Sexual orientation	Measurement	LOINC	Clinical Observation	S	76690-7	2015-03-13	2099-12-31	
1521369	Norethindrone	Drug	RxNorm	Ingredient	S	7514	1970-01-01	2099-12-31	
4024958	Throat culture	Measurement	SNOMED	Procedure	S	117015009	1970-01-01	2099-12-31	
40492359	Insertion of biventricular implantable cardioverter defibrillator	Procedure	SNOMED	Procedure	S	447365002	2011-01-31	2099-12-31	
4187458	Review of systems	Procedure	SNOMED	Procedure	S	415300000	1970-01-01	2099-12-31	
19129144	{28 (Norethindrone 0.35 MG Oral Tablet) } Pack [Jolivette 28 Day]	Drug	RxNorm	Branded Pack	S	757594	2008-03-02	2099-12-31	
37017711	Allergy to soy	Observation	SNOMED	Clinical Finding	S	714035009	2016-01-31	2099-12-31	
1551099	Prednisone	Drug	RxNorm	Ingredient	S	8640	1970-01-01	2099-12-31	
4024289	Radiography of ankle	Procedure	SNOMED	Procedure	S	19490002	1970-01-01	2099-12-31	
40169281	60 ACTUAT Fluticasone propionate 0.25 MG/ACTUAT / salmeterol 0.05 MG/ACTUAT Dry Powder Inhaler	Drug	RxNorm	Quant Clinical Drug	S	896209	2010-01-31	2099-12-31	
4145310	Pelvis X-ray	Procedure	SNOMED	Procedure	S	268425006	1970-01-01	2099-12-31	
19133768	Acetaminophen 750 MG / Hydrocodone Bitartrate 7.5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	833036	2009-03-01	2099-12-31	
46233710	Doxycycline Monohydrate 100 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1650142	2015-07-06	2099-12-31	
1539403	Simvastatin	Drug	RxNorm	Ingredient	S	36567	1970-01-01	2099-12-31	
4057420	Catheter ablation of tissue of heart	Procedure	SNOMED	Procedure	S	18286008	1970-01-01	2099-12-31	
40228214	cetirizine hydrochloride 10 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1014678	2010-10-31	2099-12-31	
4197460	Injection of epinephrine	Procedure	SNOMED	Procedure	S	313191000	1970-01-01	2099-12-31	
19133873	Penicillin V Potassium 250 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	834061	2009-03-01	2099-12-31	
46233988	Doxycycline Monohydrate 50 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1652673	2015-07-06	2099-12-31	
1545958	atorvastatin	Drug	RxNorm	Ingredient	S	83367	1970-01-01	2099-12-31	
4059978	Insertion of subcutaneous contraceptive	Procedure	SNOMED	Procedure	S	169553002	1970-01-01	2099-12-31	
40228230	cetirizine hydrochloride 5 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	1014676	2010-10-31	2099-12-31	
4195803	Bone density scan	Procedure	SNOMED	Procedure	S	312681000	1970-01-01	2099-12-31	
19133905	Penicillin V Potassium 500 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	834102	2009-03-01	2099-12-31	
44783196	Surgical manipulation of joint of knee	Procedure	SNOMED	Procedure	S	699253003	2014-01-31	2099-12-31	
1548195	Estradiol	Drug	RxNorm	Ingredient	S	4083	1970-01-01	2099-12-31	
4062501	Asthma screening	Procedure	SNOMED	Procedure	S	171231001	1970-01-01	2099-12-31	
40165015	Meperidine Hydrochloride 50 MG Oral Tablet	Drug	RxNorm	Clinical Drug	S	861467	2009-09-06	2099-12-31	
4330583	Vasectomy	Procedure	SNOMED	Procedure	S	22523008	1970-01-01	2099-12-31	
19125062	Loratadine 5 MG Chewable Tablet	Drug	RxNorm	Clinical Drug	S	665078	2006-12-17	2099-12-31	
1549786	Ethinyl Estradiol	Drug	RxNorm	Ingredient	S	4124	1970-01-01	2099-12-31	
4058899	Plain X-ray of clavicle	Procedure	SNOMED	Procedure	S	168594001	1970-01-01	2099-12-31	
4163874	History of myocardial infarction	Observation	SNOMED	Context-dependent	S	399211009	1970-01-01	2099-12-31	
3049273	DXA Radius and Ulna [T-score] Bone density	Measurement	LOINC	Clinical Observation	S	38265-5	1970-01-01	2099-12-31	
19126352	Nitroglycerin 0.4 MG/ACTUAT Mucosal Spray	Drug	RxNorm	Clinical Drug	S	705129	2007-05-27	2099-12-31	
8507	MALE	Gender	Gender	Gender	S	M	1970-01-01	2099-12-31	
8532	FEMALE	Gender	Gender	Gender	S	F	1970-01-01	2099-12-31	
\.


--
-- TOC entry 3886 (class 0 OID 3185481)
-- Dependencies: 208
-- Data for Name: concept_ancestor; Type: TABLE DATA; Schema: OMOP_cdm_eunomia; Owner: juanma
--

COPY "OMOP_cdm_eunomia".concept_ancestor (ancestor_concept_id, descendant_concept_id, min_levels_of_separation, max_levels_of_separation) FROM stdin;
4180628	313217	5	6
4179141	4146173	2	2
21500574	1118084	4	4
21505770	1119510	0	0
21503967	40162522	5	6
36203060	40479422	4	4
36151386	1119510	0	0
21502552	1112807	4	4
40765628	40769189	2	2
44339646	19128009	2	2
44337799	1521369	0	0
44339264	1124957	0	0
45652937	1125315	0	0
45622421	1713332	0	0
45640391	1125315	0	0
45632061	1119510	0	0
45629773	1539403	0	0
45654298	1177480	0	0
45624364	19008572	2	3
45686394	975125	0	0
45781198	933724	0	0
45687104	46233710	2	3
45687749	19008572	2	3
46242471	1112807	0	0
45703024	1728416	0	0
46242546	40229134	2	3
45798499	1000560	0	0
46297520	1119510	0	0
45691093	1125315	0	0
46293532	1125315	0	0
45799320	1119510	0	0
46309333	1129625	0	0
45897346	1107882	2	3
253549	4048695	5	6
4179141	4149245	2	2
21500574	1177480	4	4
21505770	1192710	0	0
21500363	46275916	5	6
35902851	198809	4	4
36155724	1119510	0	0
21502552	1367571	4	4
40765628	40769179	2	2
44362889	40223834	2	3
44337803	933724	0	0
44339286	1539403	0	0
45652938	1125315	0	0
45622707	791967	0	0
45640297	1125315	0	0
45632149	1119510	0	0
45629693	1521369	0	0
45655401	1177480	0	0
45624375	43012036	2	3
45686437	975125	0	0
45781644	1717327	0	0
45687187	19074843	2	3
45687303	40232448	2	3
46242526	1115008	0	0
45702872	920293	0	0
46242294	19008572	2	3
45798500	1310149	0	0
46292863	1119510	0	0
45691287	1125315	0	0
46293704	1125315	0	0
45799552	1119510	0	0
46309473	1129625	0	0
45894646	43012036	2	3
253549	4149245	5	6
4154161	4296205	2	2
21500574	1305058	4	4
21505771	1174888	0	0
21505691	40173590	5	6
35802133	40480160	4	4
36155807	1119510	0	0
21502552	1310149	4	4
40765628	40769184	2	2
44362900	1154615	2	3
44337807	1115008	0	0
44339423	1738521	0	0
45653079	1125315	0	0
45622708	1343916	0	0
45640350	1125315	0	0
45632086	1119510	0	0
45629693	19127890	0	0
45654761	1177480	0	0
45624843	40162522	2	3
45686512	975125	0	0
45781652	1124300	0	0
45687237	1107882	2	3
45687230	1115171	2	3
46242529	1738521	0	0
45702874	1307863	0	0
46242368	19008572	2	3
45798510	1124300	0	0
46293239	1119510	0	0
45691366	1125315	0	0
46293589	1125315	0	0
45799671	1119510	0	0
46309362	1129625	0	0
45894753	43012036	2	3
253549	4278672	5	6
4154161	4299128	2	2
21500574	1112807	4	4
21505771	1129625	0	0
21505696	40236446	5	6
36002886	4048171	4	4
36155941	1119510	0	0
21502552	1322184	4	4
40765628	40769194	2	2
44363088	19059056	2	3
44337888	1000560	0	0
44339288	705944	0	0
45653127	1125315	0	0
45622661	1115008	0	0
45640480	1125315	0	0
45632160	1119510	0	0
45629693	1549786	0	0
45654876	1177480	0	0
45668913	40232448	2	3
45685530	975125	0	0
45781436	967823	0	0
45687171	40232448	2	3
45687690	40232448	2	3
46242531	757627	0	0
45702879	967823	0	0
46241199	40232448	2	3
45798292	967823	0	0
46293425	1119510	0	0
45691370	1125315	0	0
46293606	1125315	0	0
45799659	1119510	0	0
46303833	1129625	0	0
45894768	1127433	2	3
253549	40479768	5	6
4154161	4001336	2	2
21500574	19010482	4	4
21505771	1192710	0	0
21601238	46275916	5	6
36002141	4280726	4	4
36156016	1119510	0	0
4180941	4125906	4	4
37520653	44783196	2	2
44362914	40231925	2	3
44337890	1343916	0	0
44339290	975125	0	0
45653151	1125315	0	0
45622723	738818	0	0
45640534	1125315	0	0
45631865	1119510	0	0
45629671	1500211	0	0
45654802	1177480	0	0
45668842	40228230	2	3
45680343	975125	0	0
45781446	1115008	0	0
45687184	19075001	2	3
45687839	19077572	2	3
46240468	1192710	0	0
45702968	920293	0	0
46241250	1545959	2	3
45798300	1729720	0	0
46293304	1119510	0	0
45691344	1125315	0	0
46293610	1125315	0	0
45799578	1119510	0	0
46303855	1129625	0	0
45896749	40232448	2	3
253549	4066995	5	6
4027255	4329847	2	2
21500574	1129625	4	4
21505775	1174888	0	0
21604253	40229134	5	6
36002141	40486433	4	4
36155943	1119510	0	0
21502550	1000560	4	4
37219942	255848	2	2
44362916	1115171	2	3
44337891	1539403	0	0
44339090	1149380	0	0
45653423	1125315	0	0
45622950	738818	0	0
45640523	1125315	0	0
45632192	1119510	0	0
45629677	740275	0	0
45651402	1177480	0	0
45668889	920334	2	3
45676890	975125	0	0
45781202	967823	0	0
45687209	19075601	2	3
45684256	19019273	2	3
46240499	1539403	0	0
45702980	1729720	0	0
46241163	19077572	2	3
45798302	1112807	0	0
46293457	1119510	0	0
45690976	1125315	0	0
46293746	1125315	0	0
45796709	1119510	0	0
46303929	1129625	0	0
45896653	40163554	2	3
253549	40479422	5	6
4105895	4295880	2	2
21500574	1115008	4	4
21505776	1119510	0	0
21604253	19133768	5	6
36002868	40486433	4	4
36155882	1119510	0	0
21502550	975125	4	4
37622482	317576	2	2
44363103	40162522	2	3
44338028	1112807	0	0
44339293	1545958	0	0
45653425	1125315	0	0
45622557	1174888	0	0
45640442	1125315	0	0
45632006	1119510	0	0
45629620	1107830	0	0
45651651	1177480	0	0
45668843	19073183	2	3
45677086	975125	0	0
45781591	933724	0	0
45687210	19133905	2	3
45684374	40163554	2	3
46240710	1545958	0	0
45702986	1551099	0	0
46238234	1332419	2	3
45798424	1759842	0	0
46296565	1119510	0	0
45688744	1125315	0	0
46293751	1125315	0	0
45796843	1119510	0	0
46307067	1129625	0	0
45896421	782047	2	3
253549	4059173	5	6
4105895	4197460	2	2
21500574	1125315	4	4
21505819	1129625	0	0
21604253	40162522	5	6
36002139	433644	4	4
36156211	1119510	0	0
21502550	914335	4	4
40228299	42902245	2	2
44363026	40162522	2	3
44338031	1129625	0	0
44339580	1129625	0	0
45653531	1125315	0	0
45622736	1115008	0	0
45640538	1125315	0	0
45632012	1119510	0	0
45629628	738818	0	0
45651272	1177480	0	0
45668645	19075001	2	3
45677281	975125	0	0
45781215	738818	0	0
45687210	19133873	2	3
45684300	40223768	2	3
46240710	1332418	0	0
45703055	1332418	0	0
46238508	1127433	2	3
45798523	1107830	0	0
46296644	1119510	0	0
45688020	1125315	0	0
46293520	1125315	0	0
45796991	1119510	0	0
46306400	1129625	0	0
45896517	40232448	2	3
4024567	40481087	5	6
4043026	4047491	2	2
21502510	1713332	4	4
21503326	1149380	0	0
21603365	40229134	5	6
36002139	4240902	4	4
36156028	1119510	0	0
21502550	967823	4	4
37520731	4057420	2	2
44363228	19019273	2	3
44338035	1738521	0	0
44339386	1115008	0	0
45653103	1125315	0	0
45622868	1153428	0	0
45640610	1125315	0	0
45632213	1119510	0	0
45629757	1174888	0	0
45648308	1177480	0	0
45668661	1551192	2	3
45673977	975125	0	0
45778663	1124957	0	0
45684124	19008572	2	3
45684311	19078924	2	3
45703202	1112807	0	0
45703816	1548195	0	0
46238531	1332419	2	3
45798228	975125	0	0
46296803	1119510	0	0
45688115	1125315	0	0
46293811	1125315	0	0
45796801	1119510	0	0
46307077	1129625	0	0
45896772	19059056	2	3
4024567	28060	5	6
4178818	372328	2	2
21502510	1768849	4	4
21503373	1129625	0	0
21603365	40162522	5	6
35204998	4310024	4	4
36156029	1119510	0	0
21502550	1177480	4	4
37622481	381316	2	2
44363251	40232448	2	3
44338045	1192710	0	0
44339459	1177480	0	0
45652984	1125315	0	0
45622869	1102527	0	0
45640512	1125315	0	0
45632024	1119510	0	0
45629759	1310149	0	0
45648403	1177480	0	0
45668880	40229134	2	3
45673935	975125	0	0
45778878	967823	0	0
45684158	1107882	2	3
45684269	19077344	2	3
45703250	1124957	0	0
45703946	1107830	0	0
46238339	40232448	2	3
45795455	1153428	0	0
46296600	1119510	0	0
45688064	1125315	0	0
46293725	1125315	0	0
45797104	1119510	0	0
46304172	1129625	0	0
45896792	40236824	2	3
4028076	4048171	5	6
4178818	134438	2	2
21502510	1759842	4	4
21503373	975125	0	0
21603365	19133768	5	6
35205038	441267	4	4
36156132	1119510	0	0
36217216	19127922	3	4
40037552	40221415	2	2
44363252	1115171	2	3
45619727	738818	0	0
44339459	1174888	0	0
45653285	1125315	0	0
45622812	1728416	0	0
45640513	1125315	0	0
45634086	1119510	0	0
45629763	1192710	0	0
45648412	1177480	0	0
45668952	19007333	2	3
45674014	975125	0	0
45779076	967823	0	0
45684098	19023398	2	3
45685586	19075601	2	3
45703223	1501700	0	0
45703575	1149196	0	0
46238409	19059056	2	3
45795361	1589505	0	0
46296728	1119510	0	0
45688107	1125315	0	0
46293530	1125315	0	0
45796891	1119510	0	0
46304183	1129625	0	0
45803821	40229134	2	3
4162282	4112343	5	6
4178818	198199	2	2
21502510	1741122	4	4
21503365	975125	0	0
21496206	3049273	4	5
36203067	4156265	4	4
36156001	1119510	0	0
36217216	19128022	3	4
40758298	40758406	2	2
44363143	1154615	2	3
45619794	1310149	0	0
44339460	1129625	0	0
45653300	1125315	0	0
45622822	1713332	0	0
45640518	1125315	0	0
45634228	1119510	0	0
45629739	1729720	0	0
45645154	1177480	0	0
45670291	40173590	2	3
45673895	975125	0	0
45779085	1545958	0	0
45684206	19008572	2	3
45685467	43012036	2	3
45703180	1118084	0	0
45703771	1310149	0	0
46238635	19019273	2	3
45795361	19127890	0	0
46296660	1119510	0	0
45688088	1125315	0	0
46293952	1125315	0	0
45797038	1119510	0	0
46304101	1129625	0	0
45803602	40162522	2	3
432795	4132546	4	6
4178818	195588	2	2
21502510	1746114	4	4
21503366	975125	0	0
21604147	40173590	4	5
36000000	438614	4	4
36156195	1119510	0	0
36600000	4280726	4	4
37520664	4301346	2	2
44363181	1115171	2	3
45619795	1129625	0	0
44339461	1521369	0	0
45653326	1125315	0	0
45622822	1759842	0	0
45640559	1125315	0	0
45628849	1119510	0	0
45629741	738818	0	0
45645256	1177480	0	0
45670398	19078461	2	3
45673896	975125	0	0
45779195	1192710	0	0
45684239	19008572	2	3
45685478	1127433	2	3
45703206	705944	0	0
45703772	1192710	0	0
46238672	40232448	2	3
45795361	1549786	0	0
46296661	1119510	0	0
45688093	1125315	0	0
46293846	1125315	0	0
45797042	1119510	0	0
46320438	1129625	0	0
45803804	19018935	2	3
4024567	255848	4	6
4108616	4010253	2	2
21502510	1729720	4	4
21503367	975125	0	0
21604792	45892894	4	5
36000000	4139681	4	4
36156198	1119510	0	0
36600000	40480160	4	4
40789542	3006451	2	2
44363159	40232448	2	3
45619955	1112807	0	0
44339461	1549786	0	0
45653095	1125315	0	0
45622830	1332418	0	0
45640619	1125315	0	0
45629045	1119510	0	0
45629749	1759842	0	0
45645125	1177480	0	0
45666599	1115171	2	3
45673906	975125	0	0
45779197	1124957	0	0
45684129	40163554	2	3
45685704	1713671	2	3
45703362	1501700	0	0
45704070	1308738	0	0
46238754	1127433	2	3
45795364	1112807	0	0
46296517	1119510	0	0
45688133	1125315	0	0
46288728	1125315	0	0
45797083	1119510	0	0
46320124	1129625	0	0
45803866	40229134	2	3
4180628	4310024	4	6
4158691	4186930	2	2
21502510	1717327	4	4
21503344	1125315	0	0
21503965	19007333	4	5
36203066	4066995	4	4
36156206	1119510	0	0
36600000	4056621	5	5
40765347	3000963	2	2
44363193	40229134	2	3
45619826	1129625	0	0
44339463	1548195	0	0
45653361	1125315	0	0
45622746	1309944	0	0
45640756	1125315	0	0
45629161	1119510	0	0
45629749	1713332	0	0
45645460	1177480	0	0
45666857	19008572	2	3
45671370	975125	0	0
45779106	1174888	0	0
45684372	1127433	2	3
45685708	19133905	2	3
45703296	1738521	0	0
45703651	1728416	0	0
46238703	40169216	2	3
45795399	933724	0	0
46293572	1119510	0	0
45688140	1125315	0	0
46288617	1125315	0	0
45797027	1119510	0	0
46320460	1129625	0	0
45803673	40229134	2	3
255919	4156265	4	6
4042836	4029498	2	2
21502510	1174888	4	4
21503326	975125	0	0
21604070	42707627	4	5
36203066	40479768	4	4
36156435	1119510	0	0
36600000	81151	5	8
37520651	4301346	2	2
44363591	19133905	2	3
45619873	738818	0	0
44339268	1154029	0	0
45653133	1125315	0	0
45623042	1307863	0	0
45640757	1125315	0	0
45629164	1119510	0	0
45629750	1545958	0	0
45642529	1177480	0	0
45664254	40232448	2	3
45671246	975125	0	0
45779108	1192710	0	0
45680884	19008572	2	3
45685708	19133873	2	3
45703141	1307863	0	0
45703653	1308738	0	0
45897488	19018935	2	3
45795404	1738521	0	0
46293746	1119510	0	0
45688125	1125315	0	0
46288885	1125315	0	0
46318051	1119510	0	0
46320692	1129625	0	0
45803962	19008572	2	3
255919	4132546	4	6
4043161	4218408	2	2
21502510	1778162	4	4
21503375	975125	0	0
21500007	1713671	4	5
36203066	4048695	4	4
36158854	1119510	0	0
36600000	4149245	6	6
37520651	44783196	2	2
44358586	19019273	2	3
45620074	1149196	0	0
44339271	1713332	0	0
45653136	1125315	0	0
45622957	1154343	0	0
45637439	1125315	0	0
45629192	1119510	0	0
45629886	1713332	0	0
45642372	1177480	0	0
45664479	1154615	2	3
45670706	975125	0	0
45778879	1107830	0	0
45683993	1332419	2	3
45684391	40228230	2	3
45703253	1501700	0	0
45704079	1361711	0	0
45897557	40236446	2	3
45795407	1174888	0	0
46293811	1119510	0	0
45688174	1125315	0	0
46288816	1125315	0	0
46318054	1119510	0	0
46320631	1129625	0	0
45894840	42707627	2	3
4022922	4152936	4	6
4043161	4295880	2	2
21502510	1728416	4	4
21503351	1396131	0	0
21500007	46275444	4	5
36203066	40479422	4	4
36158858	1119510	0	0
36600000	40479768	7	7
37522278	4035793	3	3
44358687	40236824	2	3
45619980	1177480	0	0
44339588	1129625	0	0
45653442	1125315	0	0
45622973	1713332	0	0
45637502	1125315	0	0
45629096	1119510	0	0
45629886	1759842	0	0
45642405	1177480	0	0
45664280	1115171	2	3
45781372	975125	0	0
45778948	1149196	0	0
45680558	1127433	2	3
45684580	19059056	2	3
45703224	1309944	0	0
45703717	1124957	0	0
45897639	1127433	2	3
45795397	1149196	0	0
46293530	1119510	0	0
45688208	1125315	0	0
46288632	1125315	0	0
46317552	1119510	0	0
46321388	1129625	0	0
45896869	1107882	2	3
4022922	4149245	4	6
4043022	4202451	2	2
21500582	1174888	4	4
21500206	1361711	0	0
21500010	19074843	4	5
36203066	4001336	4	4
36158935	1119510	0	0
36600000	40479422	7	7
37522278	4197460	3	3
44356475	1115171	2	3
45620028	1177480	0	0
44339374	1539403	0	0
45653114	1125315	0	0
45623071	1115008	0	0
45637537	1125315	0	0
45629102	1119510	0	0
45629835	1713332	0	0
45642550	1177480	0	0
45664309	40229134	2	3
45781186	975125	0	0
45778957	1153428	0	0
45680558	19078461	2	3
45684581	40232448	2	3
45703422	791967	0	0
45703122	1545958	0	0
45897589	40229134	2	3
45795572	1332418	0	0
46288728	1119510	0	0
45688321	1125315	0	0
46291556	1125315	0	0
45793890	1119510	0	0
46320810	1129625	0	0
45650773	19018935	2	3
253549	40480160	4	6
4048365	4133840	2	2
21500582	1124957	4	4
21500544	708298	0	0
21500010	19075001	4	5
36102149	40486433	4	4
36158971	1119510	0	0
36600000	78272	9	9
37622481	317576	3	3
44356269	19008572	2	3
45620337	975125	0	0
44339097	1729720	0	0
45653299	1125315	0	0
45623058	1309944	0	0
45637160	1125315	0	0
45629257	1119510	0	0
45629846	1192710	0	0
45642477	1177480	0	0
45664548	40232448	2	3
45779017	975125	0	0
45778960	1124300	0	0
45783587	19075601	2	3
45684574	1115171	2	3
45703425	1124300	0	0
45703124	1551099	0	0
45897597	1107882	2	3
45795574	1112807	0	0
46288885	1119510	0	0
45688203	1125315	0	0
46291649	1125315	0	0
45794190	1119510	0	0
46314285	1129625	0	0
45675631	40236446	2	3
253549	4237458	4	6
4040396	4238715	2	2
21500582	1102527	4	4
21500544	791967	0	0
21500010	19074841	4	5
36102149	4280726	4	4
36158677	1119510	0	0
36300000	42535580	5	10
37622481	4310024	3	3
44356464	1115171	2	3
45620106	1738521	0	0
44816277	44816277	0	0
45649962	1125315	0	0
45623061	1124300	0	0
45637480	1125315	0	0
45629316	1119510	0	0
45629809	1124300	0	0
45642658	1177480	0	0
45778402	1332419	2	3
45779154	975125	0	0
45779161	1501700	0	0
45693193	40223768	2	3
45681447	1154615	2	3
45703230	1545958	0	0
45703127	1551099	0	0
45897642	19129655	2	3
45795577	933724	0	0
46288852	1119510	0	0
45688205	1125315	0	0
46291655	1125315	0	0
45794024	1119510	0	0
46314894	1129625	0	0
45894852	1551192	2	3
253549	4142905	4	6
4180941	4199276	2	2
21500582	1154029	4	4
21500561	705944	0	0
21500341	40229134	4	5
36203062	381316	4	4
36159085	1119510	0	0
36300000	4037675	6	9
40786258	3049273	3	3
44356471	19059056	2	3
45620075	1322184	0	0
44816279	44816277	0	0
45649985	1125315	0	0
45623062	1308738	0	0
45637483	1125315	0	0
45629271	1119510	0	0
45629775	1115008	0	0
45642797	1177480	0	0
45661668	1115171	2	3
45779184	975125	0	0
45779163	1174888	0	0
45671526	19078461	2	3
45681284	1115171	2	3
45703240	1551099	0	0
45703147	782043	0	0
45897711	40232448	2	3
45795464	1717327	0	0
46288649	1119510	0	0
45688244	1125315	0	0
46289487	1125315	0	0
45794153	1119510	0	0
46314173	1129625	0	0
45675431	19019273	2	3
4028071	198809	6	6
4040400	4163951	2	2
21500582	1110410	4	4
21500553	1192710	0	0
21500327	1107830	5	5
36203062	4329847	4	4
36158776	1119510	0	0
36300000	4243062	6	8
37622411	381316	3	3
44349379	40232448	2	3
45620201	975125	0	0
44805732	44805732	0	0
45649976	1125315	0	0
45622778	967823	0	0
45637322	1125315	0	0
45628278	1119510	0	0
45629933	1308738	0	0
45640254	1177480	0	0
45661775	40174880	2	3
45778791	975125	0	0
45778790	1501700	0	0
45692448	1332419	2	3
45681521	1115171	2	3
45703382	1112807	0	0
45703242	19127890	0	0
45895289	19019273	2	3
45795485	1000560	0	0
46291629	1119510	0	0
45688355	1125315	0	0
46289317	1125315	0	0
45794772	1119510	0	0
46314192	1129625	0	0
45675333	19019273	2	3
436670	4144583	6	6
4047779	261325	5	8
21500582	1112807	4	4
21003515	1000560	0	0
21500327	1192710	5	5
36203062	4094814	4	4
36159114	1119510	0	0
36300000	4151422	6	6
37622411	321042	3	3
44349357	40231925	2	3
45619965	1309944	0	0
45619686	791967	0	0
45649620	1125315	0	0
45622781	1124957	0	0
45637327	1125315	0	0
45626200	1119510	0	0
45629853	1367571	0	0
45640168	1177480	0	0
45661806	1332419	2	3
45708016	975125	0	0
45779250	738818	0	0
45692702	1107882	2	3
45681317	19008572	2	3
45703521	701322	0	0
45703242	1589505	0	0
45895456	40232448	2	3
45795593	914335	0	0
46291649	1119510	0	0
45688305	1125315	0	0
46288982	1125315	0	0
45794801	1119510	0	0
46314835	1129625	0	0
45650772	1551192	2	3
4162282	4048171	6	6
4047779	4001336	5	8
21500120	40221415	4	4
21004249	738818	0	0
21500327	1153428	5	5
36206173	3049273	4	4
36159122	1119510	0	0
36300000	4062501	7	7
37522284	4337138	3	3
44349417	40232448	2	3
45619876	1129625	0	0
44360447	723013	0	0
45649871	1125315	0	0
45622782	1115008	0	0
45637560	1125315	0	0
45626428	1119510	0	0
45629822	967823	0	0
45640258	1177480	0	0
45661146	40231925	2	3
45707992	975125	0	0
45779189	1174888	0	0
45676251	19078461	2	3
45681560	1127433	2	3
45703255	1310149	0	0
45703242	1549786	0	0
45895368	40165015	2	3
45795661	1124300	0	0
46289097	1119510	0	0
45688431	1125315	0	0
46243494	1125315	0	0
45794313	1119510	0	0
46314690	1129625	0	0
45894821	1107882	2	3
4024567	257012	3	6
4047779	4066995	5	8
4247371	380378	4	4
21004249	1192710	0	0
21500327	1125315	5	5
36203066	4230399	3	3
36159003	1119510	0	0
36300000	40479422	11	14
37520731	4336464	3	3
44349463	19008572	2	3
45619845	1112807	0	0
44360453	738818	0	0
45649957	1125315	0	0
45623119	740275	0	0
45637562	1125315	0	0
45626262	1119510	0	0
45629785	1124957	0	0
45639646	1177480	0	0
45661155	19078924	2	3
45705094	975125	0	0
45779340	1192710	0	0
45673417	19075601	2	3
45679754	40229134	2	3
45703265	975125	0	0
45703164	1149380	0	0
45895480	40232448	2	3
45795666	1549786	0	0
46288982	1119510	0	0
45688375	1125315	0	0
46243597	1125315	0	0
45794282	1119510	0	0
46317745	1129625	0	0
45650645	1551192	2	3
4102111	4285898	3	6
4047779	4237458	5	8
4247371	372328	4	4
21004249	1115008	0	0
21500327	1150836	5	5
36203066	4134304	3	3
36159147	1119510	0	0
36300000	4174876	8	9
37302323	4102123	3	3
44349451	19057271	2	3
45619848	1112807	0	0
44360457	1713332	0	0
45651886	1125315	0	0
45622769	1149196	0	0
45637265	1125315	0	0
45626302	1119510	0	0
45629787	791967	0	0
45639651	1177480	0	0
45661365	19019273	2	3
45633081	1548195	0	0
45779341	1713332	0	0
45680569	40228214	2	3
45679777	19008572	2	3
45703275	1154343	0	0
45703386	967823	0	0
45895385	40232448	2	3
45795666	19127890	0	0
46243599	1119510	0	0
45688169	1125315	0	0
46243598	1125315	0	0
45791453	1119510	0	0
46317093	1129625	0	0
45894954	40223768	2	3
320136	4280726	2	6
4047779	40480160	5	8
4247371	381316	4	4
21004387	1112807	0	0
21500327	1149196	5	5
36203066	4146173	3	3
36158929	1119510	0	0
36300000	4035415	8	12
37521809	4337611	3	3
44349429	1115171	2	3
45619850	1589505	0	0
44360457	1759842	0	0
45652002	1125315	0	0
45623160	1124957	0	0
45637269	1125315	0	0
45626305	1119510	0	0
45629788	701322	0	0
45639652	1177480	0	0
45777849	40229134	2	3
45633084	1124957	0	0
45779178	1110410	0	0
45680773	19078461	2	3
45679759	19057271	2	3
45703586	791967	0	0
45703192	1174888	0	0
45895249	19008572	2	3
45795666	1521369	0	0
46243487	1119510	0	0
45685006	1125315	0	0
46243599	1125315	0	0
45791709	1119510	0	0
46315097	1129625	0	0
45897164	46233988	2	3
4024567	4280726	3	7
4047779	4152936	5	7
21500093	1500211	4	4
21004232	1713332	0	0
35100000	4056621	5	5
36203066	4132546	3	3
36158915	1119510	0	0
36300000	4109685	8	12
37502347	4186930	3	3
44349749	40231925	2	3
45619910	1192710	0	0
44360460	933724	0	0
45651938	1125315	0	0
45623169	1154029	0	0
45637270	1125315	0	0
45626381	1119510	0	0
45629918	1728416	0	0
45639526	1177480	0	0
45777823	40229134	2	3
45633061	1149196	0	0
45779374	1192710	0	0
45677425	19078461	2	3
45697811	19019273	2	3
45703348	1174888	0	0
45703278	1192710	0	0
45895505	40232448	2	3
45795678	1539403	0	0
46243721	1119510	0	0
45684923	1125315	0	0
46243487	1125315	0	0
45791405	1119510	0	0
46315304	1129625	0	0
45897164	46233710	2	3
432795	40480160	7	7
4047779	4266809	5	7
21500136	19128065	4	4
21004249	1174888	0	0
21503650	1125315	5	5
35702124	28060	3	3
36159235	1119510	0	0
36300000	4112343	8	14
37502347	44805732	3	3
44349751	19133905	2	3
45619912	1322184	0	0
44360561	1154029	0	0
45650045	1125315	0	0
45621245	1332418	0	0
45637412	1125315	0	0
45626439	1119510	0	0
45629944	1539403	0	0
45636642	1177480	0	0
45654802	19078461	2	3
45633070	738818	0	0
45779125	19010482	0	0
45705521	19075601	2	3
45696898	920334	2	3
45703547	1778162	0	0
45703282	1107830	0	0
45895487	19008572	2	3
45795597	19010482	0	0
46243638	1119510	0	0
45684981	1125315	0	0
46243625	1125315	0	0
45791685	1119510	0	0
46309601	1129625	0	0
45803688	19075601	2	3
4022922	40479422	6	7
4047779	258780	5	9
21500136	19127918	4	4
21004387	975125	0	0
21503650	19003953	5	5
36002869	433644	3	3
36159082	1119510	0	0
36300000	321042	9	13
40490903	44805732	3	3
44349557	40162522	2	3
45619920	1112807	0	0
44360632	1129625	0	0
45646739	1125315	0	0
45621277	1149196	0	0
45639940	1125315	0	0
45626313	1119510	0	0
45629719	914335	0	0
45636974	1177480	0	0
45654849	19008572	2	3
45633136	1110410	0	0
45778924	791967	0	0
45686956	1332419	2	3
45697017	19133905	2	3
45703630	1107830	0	0
45703108	1729720	0	0
45894537	40162522	2	3
45795684	1548195	0	0
46243512	1119510	0	0
45685105	1125315	0	0
46243638	1125315	0	0
45791554	1119510	0	0
46309862	1129625	0	0
45894790	19078461	2	3
4022922	40479768	6	7
4047779	81893	5	11
21500136	19132304	4	4
21003586	914335	0	0
21503650	1112807	5	5
36002869	4219399	3	3
36159130	1119510	0	0
36300000	28060	9	12
40763497	3013682	3	3
44349660	40232448	2	3
45620001	1107830	0	0
44360651	967823	0	0
45646744	1125315	0	0
45621235	914335	0	0
45640208	1125315	0	0
45623148	1119510	0	0
45629800	1192710	0	0
45637250	1177480	0	0
45654793	40232448	2	3
45633142	738818	0	0
45779075	791967	0	0
45686879	19075601	2	3
45697018	40232448	2	3
45703505	914335	0	0
45703118	1000560	0	0
45803236	43012036	2	3
45795686	1153428	0	0
46243504	1119510	0	0
45685064	1125315	0	0
46243640	1125315	0	0
45791692	1119510	0	0
46309746	1129625	0	0
45894814	40223768	2	3
4024567	261325	4	7
4185115	4336464	5	8
21500136	19127904	4	4
21004249	1119510	0	0
21502584	708298	5	5
36002869	4240902	3	3
36159273	1119510	0	0
36300000	255848	9	12
40763497	3023103	3	3
44349861	40232448	2	3
45619886	738818	0	0
44360691	1332418	0	0
45646745	1125315	0	0
45621218	1149196	0	0
45640029	1125315	0	0
45622983	1119510	0	0
45629804	914335	0	0
45633285	1177480	0	0
45645239	1107882	2	3
45633115	1107830	0	0
45778989	1000560	0	0
45695657	19075601	2	3
45697308	1115171	2	3
45703301	1107830	0	0
45699801	1310149	0	0
45803421	1127433	2	3
45795689	1115008	0	0
46243655	1119510	0	0
45684713	1125315	0	0
46243642	1125315	0	0
45791837	1119510	0	0
46309912	1129625	0	0
45894819	40228214	2	3
4024567	260139	4	7
4180627	4107731	5	8
21500136	19128009	4	4
21004249	1177480	0	0
21502584	1125315	5	5
36002869	37017711	3	3
36159044	1119510	0	0
36300000	198199	9	12
40763497	3016723	3	3
44350046	40229134	2	3
45620126	791967	0	0
44360570	1115008	0	0
45646598	1125315	0	0
45621256	1778162	0	0
45639982	1125315	0	0
45623090	1119510	0	0
45629987	1149380	0	0
45633287	1177480	0	0
45655484	1545959	2	3
45633122	1174888	0	0
45707620	1589505	0	0
45693168	19075601	2	3
45693945	19008572	2	3
45703310	1149196	0	0
45700035	19002770	0	0
45803357	40229134	2	3
45795694	1549786	0	0
46243586	1119510	0	0
45685077	1125315	0	0
46243732	1125315	0	0
45791786	1119510	0	0
46304703	1129625	0	0
45894608	1107882	2	3
4024567	4294548	4	7
4180628	4237458	5	7
21500136	42902245	4	4
21004249	1112807	0	0
21502584	1115008	5	5
36203067	4109685	3	3
36159343	1119510	0	0
36300000	440448	9	14
37219970	317576	3	3
44341796	40232448	2	3
45619838	1177480	0	0
44360575	791967	0	0
45646879	1125315	0	0
45621259	1309944	0	0
45639945	1125315	0	0
45623011	1119510	0	0
45629988	1153428	0	0
45633223	1177480	0	0
45639569	1332419	2	3
45633128	1000560	0	0
45707624	1118084	0	0
45692638	1332419	2	3
45693946	40174880	2	3
45703314	1107830	0	0
45699813	1332418	0	0
45876069	3024561	2	3
45795694	1521369	0	0
46243811	1119510	0	0
45685083	1125315	0	0
46243611	1125315	0	0
45791585	1119510	0	0
46304704	1129625	0	0
45803818	1107882	2	3
4024567	40486433	4	7
4178818	4048171	5	7
21500136	19128263	4	4
21004386	1551099	0	0
21502584	740275	5	5
36203067	4152936	3	3
36159212	1119510	0	0
36300000	442116	9	10
37219970	321042	3	3
44342122	40229134	2	3
45620032	1149196	0	0
44360714	705944	0	0
45647035	1125315	0	0
45621171	1149196	0	0
45640084	1125315	0	0
45623013	1119510	0	0
45629990	1110410	0	0
45633451	1177480	0	0
45630227	1107882	2	3
45633088	1192710	0	0
45707629	1153428	0	0
45680940	19078461	2	3
45693954	40231925	2	3
45703326	1717327	0	0
45700048	1589505	0	0
45803527	40163554	2	3
45796826	1149196	0	0
46243772	1119510	0	0
45685110	1125315	0	0
46243523	1125315	0	0
45791826	1119510	0	0
46304945	1129625	0	0
45675321	1107882	2	3
4180628	40486433	4	7
4178818	4112343	5	7
21500136	40221415	4	4
21004571	914335	0	0
21502584	1119510	5	5
36203067	4296204	3	3
36159363	1119510	0	0
36300000	4169137	9	10
40760929	3013682	3	3
44341873	40162522	2	3
45620216	975125	0	0
44360717	1153428	0	0
45646844	1125315	0	0
45620973	1717327	0	0
45634207	1125315	0	0
45623019	1119510	0	0
45629770	1174888	0	0
45633621	1177480	0	0
45631207	40228214	2	3
45633162	1713332	0	0
45707637	1149196	0	0
45673098	19078461	2	3
45694085	40229134	2	3
45703330	1102527	0	0
45700119	1000560	0	0
45803507	1115171	2	3
45796936	1115008	0	0
46243838	1119510	0	0
45685137	1125315	0	0
46243649	1125315	0	0
45791730	1119510	0	0
46304763	1129625	0	0
45896962	1107882	2	3
4180628	260139	4	7
4043022	4336464	5	7
21500136	19128022	4	4
21004572	975125	0	0
21502584	705944	5	5
36203067	4113008	3	3
36159480	1119510	0	0
36300000	78272	9	15
40760929	3016723	3	3
44342020	1713671	2	3
45620042	1129625	0	0
44360720	1129625	0	0
45646848	1125315	0	0
45620974	723013	0	0
45634181	1125315	0	0
45623249	1119510	0	0
45626917	1310149	0	0
45633308	1177480	0	0
45636950	1539411	2	3
45633149	1521369	0	0
45707638	1343916	0	0
45692382	19078461	2	3
45693743	19018935	2	3
45703442	1107830	0	0
45700125	914335	0	0
45803606	19133873	2	3
45797138	1521369	0	0
46243752	1119510	0	0
45685140	1125315	0	0
46243504	1125315	0	0
45791750	1119510	0	0
46305277	1129625	0	0
45896991	1107882	2	3
4180628	4048695	4	7
4178545	4280726	5	6
21500136	46221626	4	4
21004493	1717327	0	0
21502584	742185	5	5
36203067	4155034	3	3
36159482	1119510	0	0
36300000	433125	10	10
36902266	440086	3	3
44342224	19008572	2	3
45620045	1112807	0	0
44360732	1192710	0	0
45646952	1125315	0	0
45621281	1110410	0	0
45634040	1125315	0	0
45624908	1119510	0	0
45626921	1326303	0	0
45633654	1177480	0	0
45633505	40173590	2	3
45633270	1548195	0	0
45707639	1192710	0	0
45680427	40228214	2	3
45694034	19019273	2	3
45703444	19003953	0	0
45699985	1102527	0	0
45803615	43012036	2	3
45797138	1549786	0	0
46243701	1119510	0	0
45685013	1125315	0	0
46243582	1125315	0	0
45791756	1119510	0	0
46321155	1129625	0	0
46317593	40223768	2	3
253549	81151	4	7
4178545	40486433	5	6
21500175	1557272	4	4
21004249	1149196	0	0
21502584	926487	5	5
36002139	4139681	3	3
36159488	1119510	0	0
36300000	45769019	10	12
37521609	4117038	3	3
44342093	40231925	2	3
45620047	1174888	0	0
44360741	1112807	0	0
45647137	1125315	0	0
45621241	1548195	0	0
45634051	1125315	0	0
45625112	1119510	0	0
45626702	738818	0	0
45633750	1177480	0	0
45666544	40173590	2	3
45633270	1512674	0	0
45707648	1545958	0	0
45692652	40228214	2	3
45694161	19008572	2	3
45703477	1174888	0	0
45700103	1149196	0	0
45803632	1551192	2	3
45796938	1107830	0	0
46243799	1119510	0	0
45685114	1125315	0	0
46243586	1125315	0	0
45791763	1119510	0	0
46321167	1129625	0	0
46313270	40232448	2	3
4012185	4336464	4	7
4180938	4047491	5	6
4229909	4048171	4	4
21004233	1713332	0	0
21503645	1174888	5	5
35802841	40480160	3	3
36159489	1119510	0	0
36300000	4219399	10	11
40789542	3012494	3	3
44342077	46221626	2	3
45620054	738818	0	0
44360896	1129625	0	0
45647245	1125315	0	0
45621269	1115008	0	0
45634149	1125315	0	0
45621629	1119510	0	0
45626985	1332418	0	0
45633698	1177480	0	0
45639680	1107882	2	3
45633173	1115008	0	0
45777908	1000560	0	0
45695718	40228214	2	3
45694016	19133873	2	3
45700219	1192710	0	0
45700239	1310149	0	0
45800836	19132304	2	3
45796947	967823	0	0
46241412	1119510	0	0
45684867	1125315	0	0
46243811	1125315	0	0
45791769	1119510	0	0
46320829	1129625	0	0
46313423	40232448	2	3
432795	4146173	5	7
4180938	42535580	5	6
4299725	4336464	4	4
21004346	1738521	0	0
21503645	1124300	5	5
35802841	4066995	3	3
36159500	1119510	0	0
36300000	313217	10	15
40789542	3006734	3	3
44342163	1551192	2	3
45620057	1177480	0	0
44360697	738818	0	0
45647075	1125315	0	0
45621138	1124300	0	0
45634154	1125315	0	0
45621530	1119510	0	0
45627026	1149196	0	0
45630288	1177480	0	0
45627223	1107882	2	3
45676449	1192710	0	0
45777924	1307863	0	0
45655222	19078461	2	3
45694028	35605482	2	3
45700369	1343916	0	0
45700111	975125	0	0
45801016	1115171	2	3
45796949	1738521	0	0
46241242	1119510	0	0
45685209	1125315	0	0
46243744	1125315	0	0
45789003	1119510	0	0
46321173	1129625	0	0
46313534	40231925	2	3
432795	4142905	5	7
4103662	375671	5	6
4306074	4337138	4	4
21004249	1129625	0	0
21503645	1110410	5	5
36203090	40480160	3	3
36159320	1119510	0	0
36303153	433125	8	8
37521341	4163971	3	3
44342253	19074843	2	3
45620060	1112807	0	0
44360672	1112807	0	0
45647080	1125315	0	0
45621142	1713332	0	0
45634398	1125315	0	0
45621664	1119510	0	0
45626699	1192710	0	0
45630474	1177480	0	0
45654781	19078461	2	3
45676781	1107830	0	0
45777862	1124300	0	0
45779408	1332419	2	3
45694896	40231925	2	3
45700401	1307863	0	0
45699933	1501700	0	0
45801074	40163554	2	3
45796952	1115008	0	0
46241313	1119510	0	0
45685840	1125315	0	0
46243766	1125315	0	0
45789006	1119510	0	0
46321184	1129625	0	0
46313331	1115171	2	3
4180628	133834	5	7
4103662	378001	5	6
4247120	81893	4	4
21004346	1728416	0	0
21503645	1112807	5	5
36203060	4146173	3	3
36159327	1119510	0	0
36303153	45769019	8	10
37220016	40486433	3	3
44342375	19073183	2	3
45620064	1177480	0	0
44360673	1192710	0	0
45647114	1125315	0	0
45621220	1539403	0	0
45634399	1125315	0	0
45621862	1119510	0	0
45626841	1192710	0	0
45630402	1177480	0	0
45648127	1332419	2	3
45676395	1110410	0	0
45777864	1343916	0	0
45690064	40228214	2	3
45690950	19018935	2	3
45700445	1549786	0	0
45699935	1192710	0	0
45800887	19008572	2	3
45797073	1738521	0	0
46241474	1119510	0	0
45685887	1125315	0	0
46243772	1125315	0	0
45789053	1119510	0	0
46321194	1129625	0	0
46313501	1115171	2	3
4180628	4149245	5	7
4115390	313217	5	6
21505881	40173590	4	5
21004496	1717327	0	0
21502620	1778162	5	5
36000000	439406	3	3
36159582	1119510	0	0
36303153	433644	8	9
37220016	4280726	3	3
44337822	1107882	2	3
45620064	1129625	0	0
44360674	1322184	0	0
45647142	1125315	0	0
45621296	1115008	0	0
45634506	1125315	0	0
45667317	1119510	0	0
45626968	1154029	0	0
45630691	1177480	0	0
45642624	1332419	2	3
45676401	933724	0	0
45692516	1125315	0	0
45781730	40228230	2	3
45690951	19008572	2	3
45700445	19127890	0	0
45699936	715997	0	0
45801183	19019273	2	3
45795701	1000560	0	0
46241335	1119510	0	0
45681890	1125315	0	0
46243834	1125315	0	0
45788941	1119510	0	0
46321080	1129625	0	0
46313544	40232448	2	3
4024567	258780	5	8
4103320	4048171	5	6
21500121	1551192	4	5
21004497	1717327	0	0
21502620	1728416	5	5
36000000	133834	3	3
36159585	1119510	0	0
36303153	40486433	7	12
37502339	4197460	3	3
44337826	40223834	2	3
45620111	1177480	0	0
44360699	1539403	0	0
45647152	1125315	0	0
45621267	1343916	0	0
45634507	1125315	0	0
45667491	1119510	0	0
45626819	1174888	0	0
45630758	1177480	0	0
45649225	1332419	2	3
45676454	1551099	0	0
45692519	1125315	0	0
45781730	40228214	2	3
45691060	40174880	2	3
45700445	1589505	0	0
45700153	967823	0	0
45799770	40229134	2	3
45795711	1118084	0	0
46241339	1119510	0	0
45682155	1125315	0	0
46243685	1125315	0	0
45789144	1119510	0	0
46320954	1129625	0	0
46314215	1115171	2	3
4024567	4048171	5	8
4027403	4337611	5	6
21501218	19079524	4	5
21001849	1713332	0	0
21502620	1746114	5	5
35902851	196456	3	3
36159614	1119510	0	0
36303153	4139681	7	8
37219785	258780	3	3
44337838	40236824	2	3
45619894	1115008	0	0
44360702	1551099	0	0
45646987	1125315	0	0
45621304	1000560	0	0
45634336	1125315	0	0
45665342	1119510	0	0
45626977	1545958	0	0
45627635	1177480	0	0
45660666	19078461	2	3
45676458	738818	0	0
45692604	1125315	0	0
45692386	1539411	2	3
45691039	1310034	2	3
45700447	1124300	0	0
45700159	1308738	0	0
45799771	1115171	2	3
45795719	1322184	0	0
46241351	1119510	0	0
45681967	1125315	0	0
46243838	1125315	0	0
45789138	1119510	0	0
46320967	1129625	0	0
46313945	1115171	2	3
432795	378001	5	8
4040392	4117038	5	6
4208786	4237458	4	5
21001857	1137529	0	0
21502620	1713332	5	5
21602567	19128065	3	3
36151143	1119510	0	0
36303153	442116	7	8
37219785	261325	3	3
44337847	1115171	2	3
45619896	791967	0	0
44360703	920293	0	0
45646993	1125315	0	0
45621307	1501700	0	0
45634241	1125315	0	0
45665165	1119510	0	0
45626962	1551099	0	0
45627655	1177480	0	0
45636594	19075601	2	3
45676845	1310149	0	0
45692390	1125315	0	0
45683943	40228214	2	3
45691206	40229134	2	3
45700305	914335	0	0
45699994	1713332	0	0
45799709	1332419	2	3
45792994	1174888	0	0
46241517	1119510	0	0
45682026	1125315	0	0
46243752	1125315	0	0
46301961	1119510	0	0
46321582	1129625	0	0
46313959	40231925	2	3
4024567	4112343	4	8
4042836	375671	5	6
4208786	4142905	4	5
21001857	1149380	0	0
21502620	1729720	5	5
36211375	4001336	3	3
36151146	1119510	0	0
36303153	4047491	7	8
40789541	3020655	3	3
44337684	19059056	2	3
45620092	1129625	0	0
44360857	1177480	0	0
45646994	1125315	0	0
45622168	1713332	0	0
45634341	1125315	0	0
45665306	1119510	0	0
45626939	1107830	0	0
45627686	1177480	0	0
45661221	1332419	2	3
45676981	1539403	0	0
45692655	1125315	0	0
45781780	19079524	2	3
45691188	1539411	2	3
45700324	1107830	0	0
45700004	723013	0	0
45799751	40162522	2	3
45792995	1738521	0	0
46241574	1119510	0	0
45682053	1125315	0	0
46243701	1125315	0	0
46301965	1119510	0	0
46321585	1129625	0	0
46313902	19019273	2	3
4028071	440448	7	7
4042836	4048171	5	6
4297887	4112343	4	5
21001842	1768849	0	0
21502620	1741122	5	5
21602627	933724	3	3
36151292	1119510	0	0
36303153	4048695	7	11
40786244	3009201	3	3
44363316	1127433	2	3
45620105	1137529	0	0
44360842	1177480	0	0
45647087	1125315	0	0
45621922	1361711	0	0
45634313	1125315	0	0
45665399	1119510	0	0
45627008	1549786	0	0
45624460	1177480	0	0
45668446	40228214	2	3
45676990	1310149	0	0
45692550	1125315	0	0
45682455	40228214	2	3
45691028	40163554	2	3
45700222	1107830	0	0
45700005	967823	0	0
45798171	40232448	2	3
45793001	1729720	0	0
46241655	1119510	0	0
45682060	1125315	0	0
46243817	1125315	0	0
46301827	1119510	0	0
46321588	1129625	0	0
46308405	46233710	2	3
4028071	313217	5	8
4154161	78272	5	5
4297887	4285898	4	5
21001860	975125	0	0
21502620	1768849	5	5
35902136	196456	3	3
36152440	1119510	0	0
36303153	321042	7	11
42889666	4066995	3	3
44363708	19018935	2	3
44777976	1149196	0	0
44360875	1129625	0	0
45647004	1125315	0	0
45621947	740275	0	0
45634471	1125315	0	0
45665380	1119510	0	0
45627008	1521369	0	0
45624488	1177480	0	0
45636508	40228214	2	3
45676994	1174888	0	0
45692615	1125315	0	0
45674495	40228214	2	3
45691129	19008572	2	3
45700374	1589505	0	0
45700104	1539403	0	0
45798407	1115171	2	3
45792981	1332418	0	0
46241556	1119510	0	0
45682067	1125315	0	0
46243902	1125315	0	0
46301801	1119510	0	0
46321589	1129625	0	0
46308049	1115171	2	3
255919	257012	5	7
4179141	78272	5	5
4247371	4132546	4	5
21001866	1551099	0	0
21502620	933724	5	5
36203042	4059173	3	3
36152277	1119510	0	0
36303153	255848	7	10
42889666	4048695	3	3
44363717	40236824	2	3
44777982	1738521	0	0
44360656	1118084	0	0
45647211	1125315	0	0
45621948	1124957	0	0
45634638	1125315	0	0
45665242	1119510	0	0
45627016	1310149	0	0
45624639	1177480	0	0
45624156	19075601	2	3
45676997	1549786	0	0
45692705	1125315	0	0
45783977	40228214	2	3
45688115	40162522	2	3
45700374	1549786	0	0
45700084	1115008	0	0
45798069	40229134	2	3
45792920	967823	0	0
46241613	1119510	0	0
45682092	1125315	0	0
46243779	1125315	0	0
46301887	1119510	0	0
46315694	1129625	0	0
46308517	19073183	2	3
255919	4112343	5	8
4154162	378001	5	5
21500562	19077572	4	5
21001849	1768849	0	0
21502620	1717327	5	5
36203042	4048695	3	3
36152284	1119510	0	0
36303153	381316	6	9
40786225	3013721	3	3
44363412	19059056	2	3
44777990	1124957	0	0
44360490	1177480	0	0
45647230	1125315	0	0
45621954	1174888	0	0
45634585	1125315	0	0
45665247	1119510	0	0
45628023	1501700	0	0
45624530	1177480	0	0
45666805	19078461	2	3
45676997	1589505	0	0
45692546	1125315	0	0
45680669	19079524	2	3
45688115	19133768	2	3
45700380	708298	0	0
45699926	967823	0	0
45798130	19008572	2	3
45792921	1713332	0	0
46241529	1119510	0	0
45682108	1125315	0	0
46243791	1125315	0	0
46302174	1119510	0	0
46316026	1129625	0	0
46308568	1551192	2	3
255919	40486433	6	8
4154162	375671	5	5
21500562	40222846	4	5
21001866	975125	0	0
21604489	19115351	4	4
35702767	4027663	3	3
36152287	1119510	0	0
36303153	4112343	6	12
37503997	4202451	3	3
44363417	920300	2	3
44777995	1124300	0	0
44360469	1129625	0	0
45647237	1125315	0	0
45622048	753626	0	0
45634276	1125315	0	0
45667429	1119510	0	0
45628030	914335	0	0
45624807	1177480	0	0
45624760	19075601	2	3
45676542	1343916	0	0
45692669	1125315	0	0
45677662	19078461	2	3
45688065	40232448	2	3
45700458	19010482	0	0
45700236	1713332	0	0
45798261	40229134	2	3
45792853	1115008	0	0
46238795	1119510	0	0
45682118	1125315	0	0
46243799	1125315	0	0
46302046	1119510	0	0
46315963	1129625	0	0
46308194	40174880	2	3
255919	378419	6	7
4180938	4202451	5	5
21500562	836659	4	5
21001878	1137529	0	0
21604489	723013	3	3
21602551	19127922	3	3
36152397	1119510	0	0
36303153	40479422	9	12
37521376	4330583	3	3
44363530	1127433	2	3
44777996	1112807	0	0
44360646	1000560	0	0
45645894	1125315	0	0
45621321	1118084	0	0
45634526	1125315	0	0
45667275	1119510	0	0
45628073	1149196	0	0
45624995	1177480	0	0
45666721	40223768	2	3
45676722	1548195	0	0
45692681	1125315	0	0
45692822	40228214	2	3
45688151	19078461	2	3
45700229	1112807	0	0
45700088	1501700	0	0
45798397	40229134	2	3
45793134	1115008	0	0
46238546	1119510	0	0
45682277	1125315	0	0
46243804	1125315	0	0
46302141	1119510	0	0
46315964	1129625	0	0
46308311	40229134	2	3
1107882	1107882	0	0
4040559	4163971	5	5
21500595	19078461	4	5
21001878	1149380	0	0
21604489	791967	3	3
21602551	19133679	3	3
36151398	1119510	0	0
36303153	4062501	5	5
42889648	378001	3	3
44363573	40232448	2	3
44777998	1124300	0	0
44360790	1124957	0	0
45645860	1125315	0	0
45621417	1549786	0	0
45634372	1125315	0	0
45662909	1119510	0	0
45628210	738818	0	0
45624998	1177480	0	0
45657997	40228214	2	3
45676462	1332418	0	0
45692694	1125315	0	0
45655014	40228214	2	3
45688323	920334	2	3
45700463	1361711	0	0
45700350	1308738	0	0
45798290	1107882	2	3
45793137	1174888	0	0
46238828	1119510	0	0
45682343	1125315	0	0
46243921	1125315	0	0
46299549	1119510	0	0
46315749	1129625	0	0
46308616	46275444	2	3
1580874	1000560	0	0
4154739	4134304	5	5
21500595	19019273	4	5
21001848	1713332	0	0
21604489	708298	3	3
21602551	19129144	3	3
36151458	1119510	0	0
36303153	4024958	5	6
42889648	375671	3	3
44363624	40229134	2	3
44778029	1177480	0	0
44360818	1305058	0	0
45643853	1125315	0	0
45621417	1521369	0	0
45634619	1125315	0	0
45662915	1119510	0	0
45628214	1557272	0	0
45624742	1177480	0	0
45645385	40228214	2	3
45676767	920293	0	0
45692709	1125315	0	0
45705338	19078461	2	3
45688333	1115171	2	3
45700498	1112807	0	0
45700207	1307863	0	0
45798412	19019273	2	3
45793137	1192710	0	0
46238829	1119510	0	0
45682460	1125315	0	0
46243922	1125315	0	0
46299384	1119510	0	0
46316038	1129625	0	0
46308692	40229134	2	3
1580858	1332418	0	0
4180627	4037675	5	5
4326426	4117038	4	5
21001848	1778162	0	0
21604489	19057271	3	6
21604034	1124300	3	3
36151496	1119510	0	0
36303153	4066995	5	11
37203783	4048171	3	3
44363553	1551192	2	3
44778007	933724	0	0
44360658	975125	0	0
45643855	1125315	0	0
45621342	1115008	0	0
45634620	1125315	0	0
45662966	1119510	0	0
45628216	723013	0	0
45668945	1177480	0	0
45666870	40228214	2	3
45676918	715997	0	0
45692716	1125315	0	0
45705491	40223768	2	3
45688194	19008572	2	3
45700327	1149196	0	0
45700363	1115008	0	0
45798300	19133905	2	3
45793140	967823	0	0
46238830	1119510	0	0
45682220	1125315	0	0
46241412	1125315	0	0
46299553	1119510	0	0
46315997	1129625	0	0
46308647	19008572	2	3
1580860	1115008	0	0
4042641	40492359	5	5
4322976	4186930	4	8
21001848	1717327	0	0
21604489	19076374	3	6
21604034	1177480	3	3
36151472	1119510	0	0
36303153	198809	5	11
37219939	258780	3	3
44363982	19008572	2	3
44778120	1129625	0	0
44360604	1112807	0	0
45643860	1125315	0	0
45621611	1124300	0	0
45634377	1125315	0	0
45662706	1119510	0	0
45628217	1549786	0	0
45668878	1177480	0	0
45666138	19078461	2	3
45676804	791967	0	0
45692620	1125315	0	0
45781381	19078461	2	3
45688355	19133768	2	3
45700335	1107830	0	0
45700355	967823	0	0
45798300	19133873	2	3
45793106	1174888	0	0
46238831	1119510	0	0
45682000	1125315	0	0
46241481	1125315	0	0
46299396	1119510	0	0
46312011	1129625	0	0
46312357	19126352	2	3
1580939	1501700	0	0
4041285	45769019	5	5
4322976	4107731	4	9
21001874	1551099	0	0
21604489	19078924	3	6
36203055	4001336	3	3
36151424	1119510	0	0
36303153	4043241	4	13
40789521	3036780	3	3
44356620	1127433	2	3
44778130	1729720	0	0
44360606	738818	0	0
45643926	1125315	0	0
45621732	1310149	0	0
45634386	1125315	0	0
45662850	1119510	0	0
45628217	1521369	0	0
45670398	1177480	0	0
45635087	40228214	2	3
45676491	1728416	0	0
45692701	1125315	0	0
45783714	40223768	2	3
45685164	1115171	2	3
45700337	19010482	0	0
45700489	1192710	0	0
45798424	1713671	2	3
45792866	1326303	0	0
46238561	1119510	0	0
45682369	1125315	0	0
46241313	1125315	0	0
46299205	1119510	0	0
46310305	1129625	0	0
46303166	1115171	2	3
1580942	1367571	0	0
4047779	4113008	5	5
4322976	40492359	4	10
21001882	1551099	0	0
21605007	1192710	4	4
36002872	4048171	3	3
36151748	1119510	0	0
36303153	4181917	4	5
40760921	3019550	3	3
44356751	19019273	2	3
44778131	1118084	0	0
44360620	1713332	0	0
45643866	1125315	0	0
45621426	1174888	0	0
45634607	1125315	0	0
45662863	1119510	0	0
45628217	1595799	0	0
45666565	1177480	0	0
45683497	40236446	2	3
45676916	1713332	0	0
45689581	1125315	0	0
45680785	40223768	2	3
45685064	40229134	2	3
45700342	1112807	0	0
45700286	1501700	0	0
45795455	40223834	2	3
45792867	1153428	0	0
46238760	1119510	0	0
45682176	1125315	0	0
46241315	1125315	0	0
46299240	1119510	0	0
46310372	1129625	0	0
45650532	19115351	1	1
1580779	1595799	0	0
4047779	4155034	5	5
4274025	4294548	4	9
21001879	1551099	0	0
21605007	1125443	4	4
36009725	4280726	3	3
36151750	1119510	0	0
36313966	198809	4	10
37203786	28060	2	3
44357096	19073183	2	3
44778030	1501700	0	0
44361161	1307863	0	0
45643928	1125315	0	0
45621323	1551099	0	0
45631284	1125315	0	0
45662974	1119510	0	0
45628224	1110410	0	0
45666596	1177480	0	0
45683504	19019273	2	3
45676805	738818	0	0
45689587	1125315	0	0
45705305	1332419	2	3
45685013	19133768	2	3
45700349	1154343	0	0
45700433	1308738	0	0
45795572	1332419	2	3
45793069	1112807	0	0
46238761	1119510	0	0
45682182	1125315	0	0
46241462	1125315	0	0
46299243	1119510	0	0
46310490	1129625	0	0
45897273	40223774	1	1
1580779	1521369	0	0
4178545	28060	5	5
4274025	378419	4	9
21001876	1149380	0	0
21605007	1119510	4	4
36009725	40486433	3	3
36151546	1119510	0	0
36313966	80180	4	6
37220048	4112343	2	3
44357010	19075001	2	3
44361607	1713332	0	0
44360885	738818	0	0
45643876	1125315	0	0
45621326	1521369	0	0
45631359	1125315	0	0
45664639	1119510	0	0
45628064	967823	0	0
45666552	1177480	0	0
45685493	40174880	2	3
45676818	1738521	0	0
45689123	1125315	0	0
45686733	19078461	2	3
45685222	19077572	2	3
45700467	1115008	0	0
45697843	1149196	0	0
45795416	1332419	2	3
45793077	1112807	0	0
46238809	1119510	0	0
45678634	1125315	0	0
46241474	1125315	0	0
46299247	1119510	0	0
46305306	1129625	0	0
46308205	46275916	1	1
1580876	975125	0	0
4178545	40481087	5	5
4274025	381316	4	7
21001871	1551099	0	0
21605007	1150770	4	4
36009869	4048171	3	3
36151591	1119510	0	0
36313966	4296204	6	9
40760921	3023103	2	3
44349779	19008572	2	3
44361327	1115008	0	0
44360890	791967	0	0
45643931	1125315	0	0
45621326	1549786	0	0
45631027	1125315	0	0
45664555	1119510	0	0
45627061	1149196	0	0
45666646	1177480	0	0
45685497	40232448	2	3
45676897	1192710	0	0
45689423	1125315	0	0
45683821	19078461	2	3
45685507	19077572	2	3
45700069	1118084	0	0
45697677	1521369	0	0
45795689	1115171	2	3
45792844	1717327	0	0
46239916	1119510	0	0
45678912	1125315	0	0
46241321	1125315	0	0
46299522	1119510	0	0
46305126	1129625	0	0
46303372	46275916	1	1
1580880	1115008	0	0
4178545	257012	5	5
4274025	195588	4	8
21001848	1768849	0	0
21605007	1150836	4	4
35902853	198809	3	3
36151592	1119510	0	0
36313966	4230399	6	11
37219945	4051466	2	3
44349794	40229134	2	3
44361611	1343916	0	0
44361077	738818	0	0
45643969	1125315	0	0
45621326	1595799	0	0
45631091	1125315	0	0
45664655	1119510	0	0
45627038	1154343	0	0
45666852	1177480	0	0
45680237	1551192	2	3
45676501	1124300	0	0
45691470	1125315	0	0
45692618	19078461	2	3
45685780	19078924	2	3
45700506	1124300	0	0
45697611	1549786	0	0
45796925	40229134	2	3
45792947	1332418	0	0
45897657	1119510	0	0
45678743	1125315	0	0
46241433	1125315	0	0
46299251	1119510	0	0
46305466	1129625	0	0
46309096	46275916	1	1
1580962	1149196	0	0
4103352	40486433	5	5
4274025	30753	4	8
21001900	1110410	0	0
21605007	1153428	4	4
35909435	198809	3	3
36151683	1119510	0	0
36313966	440448	6	11
36902269	378419	1	3
44349474	19008572	2	3
44361613	1310149	0	0
44361015	1149196	0	0
45643946	1125315	0	0
45621381	1154343	0	0
45631295	1125315	0	0
45664436	1119510	0	0
45627041	708298	0	0
45666805	1177480	0	0
45680090	40229134	2	3
45676880	1149196	0	0
45691621	1125315	0	0
45684135	19078461	2	3
45685718	920334	2	3
45700507	1192710	0	0
45697611	1589505	0	0
45796936	1115171	2	3
45792958	1124300	0	0
45897755	1119510	0	0
45678744	1125315	0	0
46241363	1125315	0	0
46301578	1119510	0	0
46305490	1129625	0	0
46307114	19079524	1	1
1580964	1129625	0	0
4103352	4280726	5	5
4247371	257012	4	6
21001853	1713332	0	0
21605007	1150837	4	7
36202157	4149245	3	4
36151779	1119510	0	0
36313966	4306014	6	7
37502350	4337138	2	4
44349475	40231925	2	3
44361622	738818	0	0
44360828	738818	0	0
45643939	1125315	0	0
45664835	738818	0	0
45631316	1125315	0	0
45663016	1119510	0	0
45627063	1115008	0	0
45664263	1177480	0	0
45680295	40229134	2	3
45676688	1713332	0	0
45691489	1125315	0	0
45686801	19078461	2	3
45685725	19008572	2	3
45700170	1367571	0	0
45697611	19127890	0	0
45797137	1545959	2	3
45793163	1153428	0	0
45897839	1119510	0	0
45678746	1125315	0	0
46241339	1125315	0	0
46301581	1119510	0	0
46306699	1129625	0	0
44361246	1125315	0	0
1580906	1539403	0	0
4043017	4337138	5	5
4247371	40481087	4	6
21001888	1738521	0	0
21605007	19029476	4	7
36000000	80809	3	4
36151852	1119510	0	0
36313966	4048169	6	7
42888893	40480160	4	4
44349976	40232448	2	3
44361601	1729720	0	0
44360833	1112807	0	0
45643891	1125315	0	0
45664898	723013	0	0
45633925	1125315	0	0
45659787	1119510	0	0
45627045	791967	0	0
45664204	1177480	0	0
45680380	1115171	2	3
45676688	1759842	0	0
45691606	1125315	0	0
45654841	19078461	2	3
45685731	40174880	2	3
45700257	1326303	0	0
45697809	1124300	0	0
45792994	40162522	2	3
45793166	1174888	0	0
45897866	1119510	0	0
45699779	46275916	1	1
46241341	1125315	0	0
46295371	1119510	0	0
46321686	1129625	0	0
44361247	1125315	0	0
1580916	1367571	0	0
4043018	4242997	5	5
4326426	4336464	4	6
21001890	1728416	0	0
21605007	19125062	4	7
35702761	4285898	3	4
36198912	1119510	0	0
36313966	4296205	6	6
37522278	4043071	4	4
44350088	40229134	2	3
44361502	1545958	0	0
44360629	1129625	0	0
45643912	1125315	0	0
45664909	1107830	0	0
45633899	1125315	0	0
45659599	1119510	0	0
45627083	1778162	0	0
45664534	1177480	0	0
45680407	19073188	2	3
45676769	791967	0	0
45691610	1125315	0	0
45686865	19078461	2	3
45685733	1551192	2	3
45700422	1112807	0	0
45697811	1115008	0	0
45792995	46233710	2	3
45793068	1110410	0	0
45897734	1119510	0	0
45688630	46275916	1	1
46241348	1125315	0	0
46295741	1119510	0	0
46321698	1129625	0	0
44361249	1125315	0	0
1580813	1361711	0	0
4180628	380378	5	5
4297090	4202451	3	6
21001891	1728416	0	0
21605007	43012036	4	7
35702778	81893	3	4
36198916	1119510	0	0
36313966	433125	7	7
37103722	4116491	3	4
44350077	19078461	2	3
44361508	1713332	0	0
44360630	1115008	0	0
45644067	1125315	0	0
45664878	1326303	0	0
45633823	1125315	0	0
45659534	1119510	0	0
45627071	1501700	0	0
45660971	1177480	0	0
45680392	19075601	2	3
45677048	1153428	0	0
45691613	1125315	0	0
45783725	19078461	2	3
45682153	1332419	2	3
45896815	1549786	0	0
45697774	967823	0	0
45793001	19133905	2	3
45793061	1149196	0	0
45897821	1119510	0	0
45694031	46275916	1	1
46241404	1125315	0	0
46296037	1119510	0	0
46321871	1129625	0	0
45650724	1125315	0	0
1580821	1154343	0	0
4180628	4144583	5	5
4297090	4015189	3	6
21001920	1154343	0	0
21605007	40223834	4	7
36203056	4142905	3	4
36159654	1119510	0	0
36313966	433644	7	8
42888893	4066995	3	4
44349839	40162522	2	3
44361627	1124300	0	0
44361039	1174888	0	0
45644070	1125315	0	0
45664934	738818	0	0
45633901	1125315	0	0
45659490	1119510	0	0
45627072	1149196	0	0
45661437	1177480	0	0
45680484	1115171	2	3
45676953	1174888	0	0
45691661	1125315	0	0
45701779	19078461	2	3
45682101	19008572	2	3
45896815	1521369	0	0
45697682	1713332	0	0
45793005	40232448	2	3
45793063	1741122	0	0
45897918	1119510	0	0
45706039	19079524	1	1
46241359	1125315	0	0
46296052	1119510	0	0
46315738	1129625	0	0
45650541	1125315	0	0
1580827	914335	0	0
4028071	260139	5	5
4208786	81151	3	6
21001922	1137529	0	0
21605007	40223821	4	7
35702767	4310024	3	4
36198892	1119510	0	0
36313966	4219399	7	8
37219970	4329847	3	4
44350150	40231925	2	3
44362743	1521369	0	0
44361041	1521369	0	0
45643915	1125315	0	0
45665008	1154029	0	0
45633842	1125315	0	0
45659493	1119510	0	0
45627055	1153428	0	0
45661644	1177480	0	0
45680497	19133768	2	3
45676954	1124300	0	0
45691624	1125315	0	0
45680590	19078461	2	3
45682106	1545959	2	3
45896820	1174888	0	0
45697798	1124300	0	0
45792852	1127433	2	3
45793063	1746114	0	0
45897764	1119510	0	0
45700603	19079524	1	1
46241446	1125315	0	0
46296246	1119510	0	0
46316286	1129625	0	0
45650281	1125315	0	0
1580830	1124300	0	0
4028071	196456	5	5
4274025	44782520	3	6
21001922	1154343	0	0
21605007	40228214	4	7
35702767	4266809	3	4
36198843	1119510	0	0
36313966	313217	7	12
37220041	4112343	3	4
44342506	40169281	2	3
44362751	1177480	0	0
44361041	1595799	0	0
45644046	1125315	0	0
45665081	1501700	0	0
45633844	1125315	0	0
45659701	1119510	0	0
45623810	1548195	0	0
45661370	1177480	0	0
45680365	1115171	2	3
45676955	1149196	0	0
45689713	1125315	0	0
45684220	19078461	2	3
45682036	19008572	2	3
45896821	1343916	0	0
45696898	920293	0	0
45792853	1115171	2	3
45793065	1713332	0	0
45897853	1119510	0	0
45684832	19127922	1	1
46241547	1125315	0	0
46295685	1119510	0	0
46316357	1129625	0	0
45650836	1125315	0	0
1580838	967823	0	0
4178818	40481087	5	5
4274025	257012	3	8
21001903	1551099	0	0
21605007	40229134	6	7
35702767	30753	3	4
36198941	1119510	0	0
35800000	375671	9	11
37521144	4108705	3	4
44342408	19073183	2	3
44362755	791967	0	0
44361041	1549786	0	0
45644015	1125315	0	0
45665083	1124957	0	0
45633946	1125315	0	0
45659853	1119510	0	0
45623818	1545958	0	0
45661176	1177480	0	0
45680356	19079524	2	3
45676958	738818	0	0
45689719	1125315	0	0
45698685	40174880	2	3
45682118	1127433	2	3
45896900	1713332	0	0
45696939	1192710	0	0
45793134	1115171	2	3
45793065	1759842	0	0
45897958	1119510	0	0
45684832	19133679	1	1
46241548	1125315	0	0
46295602	1119510	0	0
46316368	1129625	0	0
45650733	1125315	0	0
1580844	1332418	0	0
4178818	255848	5	5
4247371	4283893	3	5
21001877	1154343	0	0
21605007	40162522	6	7
21602819	1713671	3	4
36198946	1119510	0	0
35800000	257012	8	10
37102306	45769019	3	4
44342414	46275916	2	3
44362758	1177480	0	0
44361043	1512674	0	0
45644096	1125315	0	0
45664881	1115008	0	0
45631382	1125315	0	0
45659935	1119510	0	0
45623924	1310149	0	0
45661267	1177480	0	0
45680685	40228230	2	3
45676961	1310149	0	0
45689702	1125315	0	0
45686915	19078461	2	3
45682277	1127433	2	3
45896869	1107830	0	0
45696961	1367571	0	0
45792839	40232448	2	3
45793081	975125	0	0
45897960	1119510	0	0
45684832	19129144	1	1
46241495	1125315	0	0
46296425	1119510	0	0
46316062	1129625	0	0
45650736	1125315	0	0
1580847	1332418	0	0
4178818	257012	5	5
4208786	40480160	3	5
21001883	1728416	0	0
21605007	40232448	6	7
21602819	46275444	3	4
36198983	1119510	0	0
35800000	4132546	7	9
40760929	3023103	3	4
44342518	1127433	2	3
44362793	1177480	0	0
44361043	1549786	0	0
45644225	1125315	0	0
45664886	1551099	0	0
45631424	1125315	0	0
45656923	1119510	0	0
45623690	740275	0	0
45661278	1177480	0	0
45677086	19008572	2	3
45676964	1124957	0	0
45689703	1125315	0	0
45690050	19078461	2	3
45682251	19073183	2	3
45896851	1118084	0	0
45696942	1713332	0	0
45793203	40223768	2	3
45793209	1107830	0	0
45897990	1119510	0	0
45681820	19089061	1	1
46241517	1125315	0	0
46291237	1119510	0	0
46316660	1129625	0	0
45650467	1125315	0	0
1580955	715997	0	0
4043022	42535580	5	5
4269838	4108705	3	5
21001935	967823	0	0
21605007	19133768	6	7
21602627	40236824	3	6
36151812	1119510	0	0
35800000	40486433	6	11
37522308	4336464	3	4
44342551	40228230	2	3
44362796	1112807	0	0
44361044	933724	0	0
45644232	1125315	0	0
45664940	1153428	0	0
45631505	1125315	0	0
45656693	1119510	0	0
45623945	1115008	0	0
45654781	1177480	0	0
45677007	19019273	2	3
45676965	1501700	0	0
45689797	1125315	0	0
45701855	19078461	2	3
45682198	19019273	2	3
45896908	1112807	0	0
45696912	1192710	0	0
45792956	40232448	2	3
45793241	1549786	0	0
45897932	1119510	0	0
45672770	19074679	1	1
46241450	1125315	0	0
46291135	1119510	0	0
46316182	1129625	0	0
45650764	1125315	0	0
1588689	1512674	0	0
4043022	4323902	5	5
21500563	40223768	3	4
21001900	914335	0	0
21604180	40236446	4	7
36203062	4296204	3	6
36151819	1119510	0	0
35800000	4280726	6	11
37219945	441267	3	4
44342541	19019273	2	3
44362799	1129625	0	0
44361048	1129625	0	0
45641216	1125315	0	0
45664849	1717327	0	0
45631662	1125315	0	0
45656695	1119510	0	0
45624068	1174888	0	0
45634974	1129625	0	0
45679392	40223768	2	3
45677019	1539403	0	0
45689765	1125315	0	0
45699093	19078461	2	3
45682465	19018935	2	3
45697106	975125	0	0
45696962	791967	0	0
45793163	40223834	2	3
45793223	1713332	0	0
45895500	1119510	0	0
45772679	4304110	1	1
46241571	1125315	0	0
46291136	1119510	0	0
46316188	1129625	0	0
45650812	1125315	0	0
1589505	1589505	0	0
4274025	80180	3	5
21500563	836659	3	4
21001909	1551099	0	0
21604180	782047	4	7
35702738	4027663	3	6
36151803	1119510	0	0
35800000	4285898	6	9
37622411	317576	3	4
44342707	19133873	2	3
44362608	1322184	0	0
44361059	1149380	0	0
45640901	1125315	0	0
45665090	705944	0	0
45631665	1125315	0	0
45656700	1119510	0	0
45624072	1192710	0	0
45634895	1129625	0	0
45677173	35605482	2	3
45676941	738818	0	0
45689731	1125315	0	0
45680703	19078461	2	3
45678937	19125062	2	3
45697088	1149196	0	0
45696989	1154343	0	0
45793166	40162522	2	3
45793223	1759842	0	0
45895463	1119510	0	0
45703785	19079524	1	1
46241574	1125315	0	0
46291137	1119510	0	0
46310688	1129625	0	0
45650823	1125315	0	0
1367571	1367571	0	0
4274025	4066995	3	9
21500563	40222846	3	4
21001853	1759842	0	0
21604180	40222846	4	7
36100000	260139	3	5
36151719	1119510	0	0
35800000	4043241	11	12
37622411	4329847	3	4
43531392	4238715	2	3
45619689	1119510	0	0
44360755	1192710	0	0
45641227	1125315	0	0
45665092	1310149	0	0
45631384	1125315	0	0
45656710	1119510	0	0
45623806	1778162	0	0
45635051	1129625	0	0
45677144	1127433	2	3
45677094	19010482	0	0
45689842	1125315	0	0
45692532	19078461	2	3
45678867	43012036	2	3
45697096	1149380	0	0
45697008	1154029	0	0
45793215	40232448	2	3
45793241	1521369	0	0
45895536	1119510	0	0
45697864	46275916	1	1
46241453	1125315	0	0
46291142	1119510	0	0
46305655	1129625	0	0
45650683	1125315	0	0
1110410	1110410	0	0
4274025	40480160	3	9
21500563	19077572	3	4
21001875	1551099	0	0
21604180	40231925	6	7
36203062	4142905	3	8
36151828	1119510	0	0
36427861	1551099	0	0
37520685	44783196	4	4
44784217	313217	2	3
45619693	1119510	0	0
44361016	1124300	0	0
45641012	1125315	0	0
45665097	1124957	0	0
45631434	1125315	0	0
45657079	1119510	0	0
45623843	738818	0	0
45635203	1129625	0	0
45677200	19018935	2	3
45676979	1309944	0	0
45689750	1125315	0	0
45671665	19078461	2	3
45678920	19078461	2	3
45697213	1595799	0	0
45696934	1361711	0	0
45793341	1107882	2	3
45793341	1107830	0	0
45895542	1119510	0	0
45697465	46275916	1	1
46241613	1125315	0	0
46290922	1119510	0	0
46305736	1129625	0	0
45675332	1125315	0	0
1107830	1107830	0	0
4274025	4027663	3	7
4297887	4166224	3	4
21001882	975125	0	0
21604180	19133768	6	7
36206173	3023430	3	7
36151944	1119510	0	0
36427938	753626	0	0
37520685	4301346	4	4
44359490	46275444	2	3
45621961	1119510	0	0
44361018	1738521	0	0
45641116	1125315	0	0
45665016	1539403	0	0
45631403	1125315	0	0
45657228	1119510	0	0
45623773	1174888	0	0
45630137	1129625	0	0
45674081	40243436	2	3
45676708	1557272	0	0
45689708	1125315	0	0
45670042	19078461	2	3
45678949	1519937	2	3
45697208	740275	0	0
45696944	1557272	0	0
45793186	19059056	2	3
45792919	791967	0	0
45896696	1119510	0	0
45691219	46275916	1	1
46241616	1125315	0	0
46291152	1119510	0	0
46305749	1129625	0	0
45675600	1125315	0	0
1129625	1129625	0	0
4274025	4283893	4	7
19127890	19128022	3	4
21001924	1713332	0	0
21604180	705944	4	4
36206173	3019550	3	7
36151659	1119510	0	0
36426679	705944	0	0
37502350	4323902	2	5
44359501	19078461	2	3
45621608	1119510	0	0
44361021	19127890	0	0
45640912	1125315	0	0
45665107	1153428	0	0
45631550	1125315	0	0
45657271	1119510	0	0
45623916	1551099	0	0
45630142	1129625	0	0
45674099	40232448	2	3
45677062	791967	0	0
45690003	1125315	0	0
45708265	19078461	2	3
45679370	35605482	2	3
45697109	1107830	0	0
45696949	975125	0	0
45792081	1127433	2	3
45793328	1548195	0	0
45896731	1119510	0	0
45688055	46275916	1	1
46241597	1125315	0	0
46291201	1119510	0	0
46305791	1129625	0	0
45675484	1125315	0	0
964261	964261	0	0
4274025	4056621	4	7
19127890	19128263	3	4
21001947	1728416	0	0
21604180	1154029	4	4
36206173	3023103	3	7
36152085	1119510	0	0
36426867	1115008	0	0
37219945	4283893	2	5
44359502	40223834	2	3
45621671	1119510	0	0
44361021	1589505	0	0
45641017	1125315	0	0
45664861	1343916	0	0
45628426	1125315	0	0
45653557	1119510	0	0
45623956	1332418	0	0
45630078	1129625	0	0
45674218	1551192	2	3
45677116	1595799	0	0
45689920	1125315	0	0
45702220	19078461	2	3
45702986	1551192	2	3
45697118	1343916	0	0
45696919	1551099	0	0
45791978	40229134	2	3
45793411	1192710	0	0
45679532	1125315	0	0
45681900	46275916	1	1
46241600	1125315	0	0
46244837	1119510	0	0
46306021	1129625	0	0
45675445	1125315	0	0
701322	701322	0	0
4274025	261325	4	9
19127890	19128065	3	4
21001947	1738521	0	0
21604180	1112807	4	4
36206173	3014599	3	7
36151769	1119510	0	0
36424218	723013	0	0
37521375	4330583	5	5
44359764	43012036	2	3
45621977	1119510	0	0
44361021	1549786	0	0
45641132	1125315	0	0
45665059	19010482	0	0
45628140	1125315	0	0
45653560	1119510	0	0
45623977	1713332	0	0
45630019	1129625	0	0
45674000	19019273	2	3
45676534	914335	0	0
45690010	1125315	0	0
45698861	19078461	2	3
45685734	19019273	2	3
45697350	1149196	0	0
45696921	1153428	0	0
45791963	19078924	2	3
45793186	1112807	0	0
45679720	1125315	0	0
45682158	46275916	1	1
46241604	1125315	0	0
46244971	1119510	0	0
46306043	1129625	0	0
45675617	1125315	0	0
705944	705944	0	0
4274025	4285898	4	11
19127890	19127918	3	4
21001924	1746114	0	0
21604180	1110410	4	4
36206173	3004501	3	6
36151834	1119510	0	0
36424226	1124300	0	0
37502350	4337611	3	5
44359705	1115171	2	3
45619802	1119510	0	0
44341366	1551099	0	0
45641134	1125315	0	0
45665112	1124300	0	0
45628146	1125315	0	0
45653429	1119510	0	0
45623680	1153428	0	0
45629950	1129625	0	0
45674114	40163554	2	3
45676535	1551099	0	0
45689678	1125315	0	0
45779139	19078461	2	3
45691089	19019273	2	3
45697220	1361711	0	0
45696926	1192710	0	0
45790256	1127433	2	3
45793334	1112807	0	0
45679463	1125315	0	0
45697095	46275916	1	1
46241673	1125315	0	0
46239873	1119510	0	0
46322078	1129625	0	0
45675624	1125315	0	0
708298	708298	0	0
4274025	4029498	4	6
19127890	19127904	3	4
21001879	975125	0	0
21604180	19016749	4	4
36206173	3027231	3	6
36152244	1119510	0	0
36424236	19054876	0	0
37203786	4112343	3	5
44355625	1551192	2	3
45619818	1119510	0	0
44341455	1177480	0	0
45641137	1125315	0	0
45665216	1713332	0	0
45628148	1125315	0	0
45653224	1119510	0	0
45623682	1124957	0	0
45630389	1129625	0	0
45673771	40174880	2	3
45677117	1174888	0	0
45689876	1125315	0	0
45690195	19078461	2	3
45682043	19078924	2	3
45697223	1174888	0	0
45697017	1729720	0	0
45790707	40232448	2	3
45792132	1112807	0	0
45679471	1125315	0	0
45672407	46275916	1	1
46241526	1125315	0	0
46239963	1119510	0	0
46322290	1129625	0	0
45675708	1125315	0	0
438614	438614	0	0
4274025	372328	4	6
4208786	4146173	3	4
21001880	1728416	0	0
21602795	920334	4	7
36206173	3006906	3	6
36152252	1119510	0	0
36424373	1738521	0	0
36902269	4043241	3	5
44356160	1127433	2	3
45619806	1119510	0	0
44341337	1112807	0	0
45641145	1125315	0	0
45665218	1110410	0	0
45628536	1125315	0	0
45653650	1119510	0	0
45623686	1107830	0	0
45627143	1129625	0	0
45673934	40232448	2	3
45673493	1551099	0	0
45689935	1125315	0	0
45781836	19078461	2	3
45694148	19078924	2	3
45697425	914335	0	0
45696976	1149380	0	0
45790364	35605482	2	3
45792079	1367571	0	0
45679009	1125315	0	0
45706243	46275916	1	1
46241529	1125315	0	0
46240119	1119510	0	0
46322627	1129625	0	0
45675723	1125315	0	0
3020630	3020630	0	0
4274025	4218389	4	6
21500578	1127433	3	4
21600886	967823	0	0
21602795	19074843	4	7
36206173	3006734	3	6
36152253	1119510	0	0
36425373	1367571	0	0
37502344	4163971	3	5
44352661	19133873	2	3
44361376	1119510	0	0
44341459	1149380	0	0
45641253	1125315	0	0
45665226	1107830	0	0
45628668	1125315	0	0
45653700	1119510	0	0
45623966	1115008	0	0
45627185	1129625	0	0
45674263	40232448	2	3
45673485	1118084	0	0
45689686	1125315	0	0
45693201	19078461	2	3
45684751	46233988	2	3
45697430	1310149	0	0
45696892	1192710	0	0
45790335	19008572	2	3
45791842	1112807	0	0
45678963	1125315	0	0
45687774	19079524	1	1
46238757	1125315	0	0
46240122	1119510	0	0
46322080	1129625	0	0
45675589	1125315	0	0
3020655	3020655	0	0
4274025	4174876	4	5
4209223	4285898	3	3
21600270	1309944	0	0
21602795	19073183	4	7
36206173	3012494	3	6
36152417	1119510	0	0
36424390	1512674	0	0
37219945	40481087	3	6
44352838	40236824	2	3
44361542	1119510	0	0
44341460	1153428	0	0
45641299	1125315	0	0
45665131	1500211	0	0
45628512	1125315	0	0
45653686	1119510	0	0
45623969	967823	0	0
45627314	1129625	0	0
45674269	40223834	2	3
45673431	738818	0	0
45689632	1125315	0	0
45781663	40223768	2	3
45684751	46233710	2	3
45697433	1549786	0	0
45696894	1343916	0	0
45790307	1127433	2	3
45791943	1124300	0	0
45679086	1125315	0	0
45703204	19079524	1	1
46238758	1125315	0	0
45896629	1119510	0	0
46317129	1129625	0	0
45896982	1125315	0	0
3036780	3036780	0	0
4274025	140673	4	5
4300157	4146173	3	3
21600303	1343916	0	0
21602795	19133905	4	7
36206173	3027970	3	6
36152093	1119510	0	0
36416551	80502	0	0
37219945	28060	3	6
44352844	1115171	2	3
44361669	1119510	0	0
44341510	1589505	0	0
45641300	1125315	0	0
45664958	715997	0	0
45628305	1125315	0	0
45653243	1119510	0	0
45623980	967823	0	0
45627215	1129625	0	0
45674269	40223821	2	3
45673433	1717327	0	0
45689866	1125315	0	0
45690150	1332419	2	3
45705161	40174880	2	3
45697433	19127890	0	0
45697022	715997	0	0
45790539	1115171	2	3
45791952	1367571	0	0
45679152	1125315	0	0
45682685	19079524	1	1
46238459	1125315	0	0
45896592	1119510	0	0
46317147	1129625	0	0
45897039	1125315	0	0
3035995	3035995	0	0
4274025	317009	4	4
21600600	975125	3	3
21503381	1124300	0	0
21602795	46275444	5	7
36206173	3001247	3	6
36152238	1119510	0	0
36311902	4163951	0	0
37502342	4108705	3	6
44352826	40229134	2	3
44361702	1119510	0	0
44341510	1549786	0	0
45641260	1125315	0	0
45665145	1729720	0	0
45628307	1125315	0	0
45653823	1119510	0	0
45624062	1521369	0	0
45627543	1129625	0	0
45674358	1115171	2	3
45673605	1551099	0	0
45686767	1125315	0	0
45692888	1332419	2	3
45697682	19073183	2	3
45697433	1512674	0	0
45697026	1110410	0	0
45790606	40229134	2	3
45791963	708298	0	0
45679166	1125315	0	0
45678766	19079524	1	1
46238795	1125315	0	0
45896485	1119510	0	0
46317296	1129625	0	0
45896953	1125315	0	0
1112807	1112807	0	0
4274025	4094814	4	4
4212076	4230399	3	3
21503428	967823	0	0
21602795	1713671	6	7
36206173	3006451	3	5
36152068	1119510	0	0
36222374	40223834	1	2
37303796	134438	3	6
44353215	43012036	2	3
44360954	1119510	0	0
44341510	19127890	0	0
45641244	1125315	0	0
45665240	738818	0	0
45628355	1125315	0	0
45653826	1119510	0	0
45624062	1549786	0	0
45623901	1129625	0	0
45674049	1551192	2	3
45673519	1307863	0	0
45686780	1125315	0	0
45699090	1332419	2	3
45697682	19073188	2	3
45697436	1192710	0	0
45696999	933724	0	0
45787560	40231925	2	3
45791986	1361711	0	0
45679167	1125315	0	0
45682620	19079524	1	1
46238796	1125315	0	0
45896497	1119510	0	0
46311273	1129625	0	0
45897050	1125315	0	0
1115171	1115171	0	0
4274025	4139681	5	6
4324765	40479422	3	3
21503515	1308738	0	0
35200000	4112343	7	11
36217214	19128009	3	4
36152171	1119510	0	0
36222374	40223821	1	2
37302322	4296204	6	6
44352869	19008572	2	3
44361677	1119510	0	0
44341513	1115008	0	0
45642972	1125315	0	0
45665285	1551099	0	0
45628631	1125315	0	0
45653703	1119510	0	0
45624062	1595799	0	0
45625214	1129625	0	0
45674184	19078924	2	3
45673522	1310149	0	0
45686455	1125315	0	0
45705480	1332419	2	3
45703693	19078461	2	3
45697439	1107830	0	0
45697005	1107830	0	0
45787569	40165015	2	3
45790262	1107830	0	0
45678970	1125315	0	0
45703025	19079524	1	1
46238546	1125315	0	0
45896679	1119510	0	0
46311614	1129625	0	0
45897054	1125315	0	0
1115008	1115008	0	0
4274025	4169137	5	6
4324765	40479768	3	3
21500772	1308738	0	0
35200000	258780	8	11
36217214	19133679	3	4
36152214	1119510	0	0
36226418	19023398	1	2
37219945	257012	2	6
44353015	40222846	2	3
44361107	1119510	0	0
44341540	1129625	0	0
45642913	1125315	0	0
45665347	791967	0	0
45628728	1125315	0	0
45653745	1119510	0	0
45624063	1738521	0	0
45625248	1129625	0	0
45674349	40232448	2	3
45673527	1343916	0	0
45686866	1125315	0	0
45671544	40174880	2	3
45700363	19019273	2	3
45697440	1153428	0	0
45697077	1000560	0	0
45787668	1551192	2	3
45790241	967823	0	0
45679026	1125315	0	0
45690718	19079524	1	1
46238567	1125315	0	0
45896682	1119510	0	0
46311348	1129625	0	0
45897099	1125315	0	0
1119510	1119510	0	0
4274025	4001336	5	9
4229909	4280726	3	3
21500753	967823	0	0
35200000	4048171	8	11
36216998	1127078	1	2
36151987	1119510	0	0
36226326	19007333	1	2
37502350	4336464	6	7
44352915	1115171	2	3
44361270	1119510	0	0
44341549	1124300	0	0
45642931	1125315	0	0
45665256	1115008	0	0
45625164	1125315	0	0
45653767	1119510	0	0
45624088	1115008	0	0
45624217	1129625	0	0
45673889	19078924	2	3
45673530	1759842	0	0
45686677	1125315	0	0
45684043	1545959	2	3
45779682	1332419	2	3
45697120	1192710	0	0
45697033	1332418	0	0
45787625	40223834	2	3
45790265	1551099	0	0
45679129	1125315	0	0
45690718	46275916	1	1
46238826	1125315	0	0
45896686	1119510	0	0
46311827	1129625	0	0
45896922	1125315	0	0
1118084	1118084	0	0
4274025	4142905	5	9
4229909	40486433	3	3
21500754	967823	0	0
35200000	261325	7	10
36216998	1127433	1	2
36155101	1125315	0	0
36226327	19007333	1	2
37302322	133834	7	7
44349135	40231925	2	3
44361277	1119510	0	0
44338318	1119510	0	0
45643080	1125315	0	0
45662516	1149196	0	0
45625348	1125315	0	0
45650225	1119510	0	0
45623800	738818	0	0
45624355	1129625	0	0
45673896	19008572	2	3
45673530	1713332	0	0
45686615	1125315	0	0
45654931	1545959	2	3
45687962	19073183	2	3
45697261	1107830	0	0
45697048	1154343	0	0
45787629	40162522	2	3
45790369	1124300	0	0
45786006	1125315	0	0
45678625	46275916	1	1
46238828	1125315	0	0
45896554	1119510	0	0
46319315	1129625	0	0
45896969	1125315	0	0
1124957	1124957	0	0
4274025	40481087	5	8
21500543	738818	3	3
21500755	967823	0	0
35200000	40486433	7	10
36217055	19073188	1	2
36155158	1125315	0	0
36225011	19126352	1	2
37302323	134438	2	7
44349060	40231925	2	3
44361283	1119510	0	0
44338327	1119510	0	0
45642921	1125315	0	0
45662524	738818	0	0
45625329	1125315	0	0
45650165	1119510	0	0
45624096	1110410	0	0
45624381	1129625	0	0
45671085	1115171	2	3
45673531	1154029	0	0
45686624	1125315	0	0
45677434	1545959	2	3
45696942	19073183	2	3
45697396	967823	0	0
45697049	975125	0	0
45789173	19077572	2	3
45790280	1521369	0	0
45785847	1125315	0	0
45693774	46275916	1	1
46238829	1125315	0	0
45896510	1119510	0	0
46319734	1129625	0	0
45897000	1125315	0	0
4024289	4024289	0	0
4274025	28060	5	8
21500543	1129625	3	3
21500781	1308738	0	0
35200000	4294548	7	10
36217055	19073183	1	2
36154754	1125315	0	0
36215488	19019273	1	2
37502345	4330583	2	7
44348801	19019273	2	3
44361690	1119510	0	0
44338462	1119510	0	0
45643799	1125315	0	0
45662642	1322184	0	0
45625378	1125315	0	0
45650138	1119510	0	0
45623601	1192710	0	0
45624288	1129625	0	0
45671253	1115171	2	3
45673447	1149196	0	0
45686647	1125315	0	0
45694627	1539411	2	3
46240144	40173590	2	3
45697403	1307863	0	0
45697130	1501700	0	0
45789305	40231925	2	3
45790280	1549786	0	0
45785848	1125315	0	0
45693774	19079524	1	1
46238830	1125315	0	0
45894365	1119510	0	0
46313410	1119510	0	0
45897002	1125315	0	0
3005136	3005136	0	0
4274025	81151	5	10
4247371	4029498	3	3
21500782	1125315	0	0
35200000	260139	7	10
36216999	1127433	1	2
36154755	1125315	0	0
36215488	1115171	1	2
37502341	4198190	2	7
44351751	40162522	2	3
44360968	1119510	0	0
44338280	1119510	0	0
45641319	1125315	0	0
45662384	1305058	0	0
45625285	1125315	0	0
45650385	1119510	0	0
45623867	1521369	0	0
45624229	1129625	0	0
45671106	40163554	2	3
45673535	1521369	0	0
45686661	1125315	0	0
45681408	19079524	1	1
45684534	1332419	2	3
45697265	1000560	0	0
45697065	1149196	0	0
45789310	1115171	2	3
45790364	1000560	0	0
45786031	1125315	0	0
45673399	19079524	1	1
46238831	1125315	0	0
45894424	1119510	0	0
46313307	1119510	0	0
45897005	1125315	0	0
3006322	3006322	0	0
4274025	258780	5	10
4297887	28060	3	3
21500785	1595799	0	0
35200000	4280726	6	10
36216999	1127078	1	2
36154756	1125315	0	0
36222613	46275916	1	2
37219945	4294548	2	7
44349254	19008572	2	3
44361476	1119510	0	0
44338521	1119510	0	0
45641362	1125315	0	0
45662482	1124957	0	0
45625290	1125315	0	0
45650547	1119510	0	0
45623867	1549786	0	0
45668238	1129625	0	0
45671190	1127433	2	3
45673535	1549786	0	0
45686738	1125315	0	0
45678261	19079524	1	1
45693754	19073183	2	3
45697166	715997	0	0
45697232	1174888	0	0
45787825	1115171	2	3
45790366	1551099	0	0
45786036	1125315	0	0
45684685	19079524	1	1
46238561	1125315	0	0
45894511	1119510	0	0
46313437	1119510	0	0
45897136	1125315	0	0
3006451	3006451	0	0
4274025	4051466	5	5
4297887	196456	3	3
21500785	1396131	0	0
35200000	4283893	7	8
36217056	19073183	1	2
36154677	1125315	0	0
36222613	1594382	1	2
37219945	4280726	2	7
44349296	40236824	2	3
44361347	1119510	0	0
44338482	1119510	0	0
45641374	1125315	0	0
45662488	1107830	0	0
45625293	1125315	0	0
45650245	1119510	0	0
45623868	967823	0	0
45668422	1129625	0	0
45671144	40236824	2	3
45673538	738818	0	0
45686846	1125315	0	0
45675288	19079524	1	1
45672870	19073183	2	3
45697285	1308738	0	0
45697238	1174888	0	0
45787845	43012433	2	3
45790335	975125	0	0
45786543	1125315	0	0
45706694	19079524	1	1
46238640	1125315	0	0
45799942	1119510	0	0
46313457	1119510	0	0
45897083	1125315	0	0
3000876	3000876	0	0
4274025	4296205	5	5
4297090	4181917	3	3
21500785	1308738	0	0
35200000	257012	6	9
36216121	40162522	1	2
36154684	1125315	0	0
36215489	19019273	1	2
37219945	261325	3	7
44349317	1115171	2	3
44361306	1119510	0	0
44338484	1119510	0	0
45638136	1125315	0	0
45662581	967823	0	0
45625272	1125315	0	0
45650450	1119510	0	0
45623984	1308738	0	0
45668633	1129625	0	0
45671504	40232448	2	3
45673546	1713332	0	0
45686985	1125315	0	0
45678149	46275916	1	1
45699994	19073183	2	3
45697408	1154343	0	0
45697304	975125	0	0
45787871	40229134	2	3
45790291	1112807	0	0
45786544	1125315	0	0
45682084	19079524	1	1
46238617	1125315	0	0
46317845	1119510	0	0
46314235	1119510	0	0
45897086	1125315	0	0
3000963	3000963	0	0
4274025	78272	5	11
4297090	4151422	3	3
21500767	1308738	0	0
35200000	40481087	8	9
36216121	19133768	1	2
36154678	1125315	0	0
36215489	1115171	1	2
37219945	260139	3	7
44345055	40165015	2	3
44360980	1119510	0	0
44338252	1119510	0	0
45638137	1125315	0	0
45662586	1124957	0	0
45625419	1125315	0	0
45647280	1119510	0	0
45623993	1778162	0	0
45668782	1129625	0	0
45671289	40223834	2	3
45673546	1759842	0	0
45686883	1125315	0	0
45678149	19079524	1	1
45687603	40228214	2	3
45697414	1174888	0	0
45697307	1107830	0	0
45786307	40228214	2	3
45790303	1713332	0	0
45786549	1125315	0	0
45678943	19079524	1	1
46238759	1125315	0	0
46318078	1119510	0	0
46314236	1119510	0	0
45897270	1125315	0	0
3008598	3008598	0	0
4274025	4116491	5	7
4297090	4246502	3	3
21500734	1595799	0	0
35200000	28060	8	9
36216122	40162522	1	2
36155047	1125315	0	0
36222254	19075601	1	2
37219945	40486433	3	7
44345231	40174880	2	3
44360985	1119510	0	0
44338619	1119510	0	0
45638120	1125315	0	0
45662592	1110410	0	0
45625728	1125315	0	0
45647266	1119510	0	0
45624055	738818	0	0
45666343	1129625	0	0
45671510	19057271	2	3
45673555	1713332	0	0
45686821	1125315	0	0
45696278	19079524	1	1
45678514	1107882	2	3
45697419	1539403	0	0
45697308	1115008	0	0
45786325	40232448	2	3
45790397	1115008	0	0
45786561	1125315	0	0
45706889	19079524	1	1
46238760	1125315	0	0
46318082	1119510	0	0
46314016	1119510	0	0
45897111	1125315	0	0
1396131	1396131	0	0
4274025	198199	5	7
4297090	4133840	3	3
21500740	1192710	0	0
35200000	255848	7	9
36216122	19133768	1	2
36155128	1125315	0	0
36215522	1154615	1	2
37219945	4112343	2	8
44345154	35605482	2	3
44361480	1119510	0	0
44338234	1119510	0	0
45638151	1125315	0	0
45662282	740275	0	0
45625471	1125315	0	0
45649009	1119510	0	0
45623894	1115008	0	0
45667365	1129625	0	0
45671278	40163554	2	3
45673559	1310149	0	0
45686822	1125315	0	0
45702424	46275916	1	1
45681601	40228214	2	3
45697355	1192710	0	0
45693938	1174888	0	0
45786216	40229134	2	3
45790308	1717327	0	0
45786383	1125315	0	0
45678429	19079524	1	1
46238761	1125315	0	0
46317603	1119510	0	0
46314423	1119510	0	0
45897113	1125315	0	0
1500211	1500211	0	0
4274025	4166224	7	10
21502522	920300	5	6
21500721	1595799	0	0
35202051	28060	7	8
36218152	40228214	1	2
36154806	1125315	0	0
36416551	40480160	1	1
37103722	198199	3	5
44345157	19018935	2	3
44361153	1119510	0	0
44338392	1119510	0	0
45638075	1125315	0	0
45662284	1000560	0	0
45625640	1125315	0	0
45649042	1119510	0	0
45623595	1309944	0	0
45667341	1129625	0	0
45669810	1127433	2	3
45673564	1110410	0	0
45686964	1125315	0	0
45702424	19079524	1	1
45684756	19075001	2	3
45697367	1149196	0	0
45693945	975125	0	0
45786231	40229134	2	3
45790310	920293	0	0
45786134	1125315	0	0
45700672	19079524	1	1
46238809	1125315	0	0
46317825	1119510	0	0
46313627	1119510	0	0
45897292	1125315	0	0
1124300	1124300	0	0
4274025	4134304	7	11
21502522	920334	5	6
21500786	1595799	0	0
35202051	40481087	7	8
36216027	19018935	1	2
36155130	1125315	0	0
36313907	4010253	1	1
37103722	45769019	4	5
44345423	40229134	2	3
44357434	1119510	0	0
44338547	1119510	0	0
45637970	1125315	0	0
45662450	1174888	0	0
45625616	1125315	0	0
45649182	1119510	0	0
45623698	1000560	0	0
45666469	1129625	0	0
45669729	40174880	2	3
45673610	1115008	0	0
45687002	1125315	0	0
45706041	19079524	1	1
45681794	19019273	2	3
45697375	1149380	0	0
45693946	1501700	0	0
45786301	40162522	2	3
45790440	1112807	0	0
45786210	1125315	0	0
45700177	19079524	1	1
46238825	1125315	0	0
46318162	1119510	0	0
46308506	1119510	0	0
45894710	1125315	0	0
1125443	1125443	0	0
4274025	133834	7	9
21500136	40224132	5	6
21500786	1308738	0	0
35202051	255848	6	8
36216028	19018935	1	2
36155136	1125315	0	0
36427861	19089061	1	1
37502353	4337611	6	7
44345380	40232448	2	3
44357408	1119510	0	0
44338534	1119510	0	0
45638057	1125315	0	0
45662497	1115008	0	0
45625603	1125315	0	0
45647404	1119510	0	0
45624112	1308738	0	0
45666362	1129625	0	0
45669826	43012036	2	3
45673533	1000560	0	0
45687015	1125315	0	0
45706041	46275916	1	1
45705081	19078461	2	3
45697646	1149196	0	0
45693879	1343916	0	0
45786313	40231925	2	3
45790539	1115008	0	0
45786122	1125315	0	0
45700112	19079524	1	1
46240078	1125315	0	0
46317860	1119510	0	0
46307889	1119510	0	0
45894756	1125315	0	0
1125315	1125315	0	0
4274025	196456	7	7
21500136	44816277	5	6
21500786	1396131	0	0
35202051	4294548	6	9
36203047	4066995	1	2
36156449	1125315	0	0
36302172	4012477	2	2
37502353	4323902	4	8
44345717	40162522	2	3
44357385	1119510	0	0
44338630	1119510	0	0
45638042	1125315	0	0
45662287	1738521	0	0
45625805	1125315	0	0
45647408	1119510	0	0
45667867	738818	0	0
45664515	1129625	0	0
45669787	19075601	2	3
45673570	1548195	0	0
45687017	1125315	0	0
45678066	19079524	1	1
45681702	1107882	2	3
45697252	1110410	0	0
45693952	1124957	0	0
45786362	40222846	2	3
45790386	705944	0	0
45786166	1125315	0	0
45687815	19079524	1	1
46239916	1125315	0	0
46318139	1119510	0	0
46308409	1119510	0	0
45894760	1125315	0	0
914335	914335	0	0
4274025	4048171	6	10
21500136	1519937	5	6
21500701	1308738	0	0
35202051	40486433	6	9
36002872	4280726	1	2
36151054	1125315	0	0
36402186	80502	2	2
37502353	4197460	4	5
44345497	19018935	2	3
44357502	1119510	0	0
44341207	1119510	0	0
45638165	1125315	0	0
45662401	705944	0	0
45625676	1125315	0	0
45644213	1119510	0	0
45668022	715997	0	0
45663965	1129625	0	0
45670409	40223768	2	3
45673598	1501700	0	0
45686896	1125315	0	0
45702623	19079524	1	1
45672673	40174880	2	3
45697258	1367571	0	0
45693887	757627	0	0
46296886	1115171	2	3
45790668	715997	0	0
45786168	1125315	0	0
45687815	46275916	1	1
46240179	1125315	0	0
46317781	1119510	0	0
46308533	1119510	0	0
45894764	1125315	0	0
442116	442116	0	0
4274025	378001	6	10
21500136	40224805	5	6
21500710	1308738	0	0
35202051	260139	6	9
36153492	19128263	1	2
36150849	1125315	0	0
36312757	42535580	2	2
37502353	4330583	3	10
44345277	19018935	2	3
44357702	1119510	0	0
44359814	1119510	0	0
45638183	1125315	0	0
45662358	1124957	0	0
45625633	1125315	0	0
45644278	1119510	0	0
45667645	1549786	0	0
45664159	1129625	0	0
45670278	1545959	2	3
45673671	1738521	0	0
45686802	1125315	0	0
45702623	46275916	1	1
45783644	1107882	2	3
45697353	1107830	0	0
45693954	1124957	0	0
46296996	40232448	2	3
45790410	1326303	0	0
45786173	1125315	0	0
45706502	19079524	1	1
45897691	1125315	0	0
46318096	1119510	0	0
46308558	1119510	0	0
45894765	1125315	0	0
260131	260139	2	2
4274025	4266809	6	8
4246502	4246502	0	0
21500712	1396131	0	0
35202051	261325	6	9
36216955	1310034	1	2
36150930	1125315	0	0
36313276	439777	2	2
37502353	4337138	5	6
44345298	1127433	2	3
44357703	1119510	0	0
44359850	1119510	0	0
45638382	1125315	0	0
45662554	1154343	0	0
45625751	1125315	0	0
45644342	1119510	0	0
45667645	19127890	0	0
45664163	1129625	0	0
45781244	40232448	2	3
45673674	1332418	0	0
45686809	1125315	0	0
45672266	19079524	1	1
45688177	1107882	2	3
45697508	1501700	0	0
45693671	1137529	0	0
46296817	1107882	2	3
45793271	975125	0	0
45786184	1125315	0	0
45693724	19079524	1	1
45897697	1125315	0	0
46318168	1119510	0	0
46308297	1119510	0	0
45894594	1125315	0	0
256451	258780	2	2
4274025	45769019	6	7
21001192	975125	0	0
21500714	1308738	0	0
35202051	4048171	7	10
35902852	198809	1	2
36150907	1125315	0	0
36402192	140673	2	2
37502353	4108705	5	7
44345312	1713671	2	3
44357529	1119510	0	0
44359725	1119510	0	0
45638262	1125315	0	0
45662314	1326303	0	0
45625758	1125315	0	0
45644345	1119510	0	0
45667645	1589505	0	0
45664002	1129625	0	0
45781372	19008572	2	3
45673621	740275	0	0
45687034	1125315	0	0
45674815	19079524	1	1
45780285	1107882	2	3
45697566	1501700	0	0
45693671	1149380	0	0
46296924	19075001	2	3
45793288	1115008	0	0
45786296	1125315	0	0
45681957	46275916	1	1
45897870	1125315	0	0
46318193	1119510	0	0
46308570	1119510	0	0
45894846	1125315	0	0
4013842	439777	2	2
4274025	433644	6	7
21001125	1551099	0	0
21500721	1308738	0	0
35202051	258780	7	10
35702751	81893	1	2
36150913	1125315	0	0
36502198	4059173	2	4
37300000	4156265	6	6
44345519	40229134	2	3
44357649	1119510	0	0
44359730	1119510	0	0
45638270	1125315	0	0
45662691	1107830	0	0
45625723	1125315	0	0
45644201	1119510	0	0
45667975	914335	0	0
45664109	1129625	0	0
45781226	40174880	2	3
45673622	1124957	0	0
45687035	1125315	0	0
45680024	46275916	1	1
45706834	1107882	2	3
45697288	1000560	0	0
45694083	1192710	0	0
46297079	1127078	2	3
45793113	1107830	0	0
46292667	1125315	0	0
45681957	19079524	1	1
45897657	1125315	0	0
45794483	1119510	0	0
46308311	1119510	0	0
45894859	1125315	0	0
4016263	4134304	2	2
4274025	4240902	6	7
21001125	975125	0	0
21500727	1308738	0	0
35202051	4112343	6	10
21602517	40221415	1	4
36150992	1125315	0	0
36502198	4066995	2	4
37300000	4066995	7	8
44345483	40229134	2	3
44357760	1119510	0	0
44360001	1119510	0	0
45637128	1125315	0	0
45662701	1174888	0	0
45622067	1125315	0	0
45644433	1119510	0	0
45667991	1192710	0	0
45664094	1129625	0	0
45781389	1115171	2	3
45673628	1551099	0	0
45683553	1125315	0	0
45680024	19079524	1	1
45672667	1107882	2	3
45697420	975125	0	0
45693978	1343916	0	0
46293236	19075001	2	3
45793406	791967	0	0
46292737	1125315	0	0
45681721	19079524	1	1
45897665	1125315	0	0
45794403	1119510	0	0
46308750	1119510	0	0
45894888	1125315	0	0
437409	4001336	2	2
4274025	4109685	6	7
21001259	975125	0	0
21013536	1746114	0	0
21602359	19127904	6	8
21602657	40236824	1	4
36150961	1125315	0	0
36502198	4278672	2	4
37300000	4048695	7	8
44345503	40232448	2	3
44357875	1119510	0	0
44359837	1119510	0	0
45637132	1125315	0	0
45662321	1332418	0	0
45622124	1125315	0	0
45644462	1119510	0	0
45667996	967823	0	0
45660997	1129625	0	0
45781625	40229134	2	3
45673629	914335	0	0
45683577	1125315	0	0
45693311	19079524	1	1
46240339	1539411	2	3
45894782	1115008	0	0
45694056	1174888	0	0
46293113	40163554	2	3
45793203	715997	0	0
46292640	1125315	0	0
45681721	46275916	1	1
45897866	1125315	0	0
45794520	1119510	0	0
46308617	1119510	0	0
45894826	1125315	0	0
4015311	4015189	2	2
4274025	37017711	6	7
21001163	1551099	0	0
21013536	1741122	0	0
35202461	258780	6	9
36203055	375671	1	4
36151014	1125315	0	0
36502198	4142905	2	4
37300000	134438	3	8
44341263	46275444	2	3
44357881	1119510	0	0
44360070	1119510	0	0
45634945	1125315	0	0
45662601	1107830	0	0
45622146	1125315	0	0
45644299	1119510	0	0
45668002	1343916	0	0
45660631	1129625	0	0
45781700	1107882	2	3
45673711	914335	0	0
45683708	1125315	0	0
45702280	19079524	1	1
45703946	1107882	2	3
45894875	920293	0	0
45694056	1192710	0	0
46293426	19059056	2	3
45793480	1124957	0	0
46292643	1125315	0	0
45693626	19079524	1	1
45897734	1125315	0	0
46312374	1119510	0	0
46308473	1119510	0	0
45894683	1125315	0	0
4028074	78272	2	2
4274025	81893	6	12
21001267	967823	0	0
21013610	1305058	0	0
35202461	4112343	5	9
36203048	4142905	1	1
36151026	1125315	0	0
36502198	4237458	2	4
37300000	133834	3	10
44341399	1127433	2	3
44357884	1119510	0	0
44360078	1119510	0	0
45634892	1125315	0	0
45662514	738818	0	0
45622164	1125315	0	0
45644396	1119510	0	0
45668004	1110410	0	0
45660886	1129625	0	0
45781590	40232448	2	3
45673879	1367571	0	0
45683709	1125315	0	0
45696317	19079524	1	1
45782356	1332419	2	3
45894821	1107830	0	0
45694062	1153428	0	0
46293290	1551192	2	3
45793439	1192710	0	0
46292672	1125315	0	0
45688159	19079524	1	1
45897821	1125315	0	0
46312108	1119510	0	0
46308669	1119510	0	0
45894755	1125315	0	0
4024567	317009	2	2
4274025	441267	6	6
21001195	975125	0	0
21013645	1308738	0	0
35202461	4280726	4	8
36211378	4218389	1	1
36150766	1125315	0	0
36502199	80180	2	4
37300000	4109685	5	5
44344370	40162522	2	3
44357802	1119510	0	0
44360143	1119510	0	0
45634884	1125315	0	0
45662738	1717327	0	0
45625096	1125315	0	0
45641530	1119510	0	0
45667978	1174888	0	0
45657981	1129625	0	0
45781591	40236824	2	3
45673676	1192710	0	0
45683747	1125315	0	0
45679984	46275916	1	1
45681492	40173590	2	3
45694683	791967	0	0
45694078	1332418	0	0
46293314	1115171	2	3
45793298	1149196	0	0
46292797	1125315	0	0
45672689	46275916	1	1
45897910	1125315	0	0
46312109	1119510	0	0
46308670	1119510	0	0
45894695	1125315	0	0
254068	4283893	2	2
4274025	4113008	6	6
21001138	740275	0	0
21013627	1307863	0	0
35202461	4294548	5	8
36009740	438614	1	1
36151304	1125315	0	0
36302173	4015189	2	6
37300000	4155034	5	5
44344374	40232448	2	3
44353848	1119510	0	0
44359741	1119510	0	0
45634875	1125315	0	0
45662634	1308738	0	0
45624835	1125315	0	0
45641582	1119510	0	0
45667654	1332418	0	0
45657876	1129625	0	0
45778663	40231925	2	3
45673831	1551099	0	0
45683591	1125315	0	0
45679984	19079524	1	1
45688422	40173590	2	3
45694551	1124957	0	0
45694088	1110410	0	0
46296565	40229134	2	3
45793305	791967	0	0
46292821	1125315	0	0
45672689	19079524	1	1
45897874	1125315	0	0
46312329	1119510	0	0
46308714	1119510	0	0
45894699	1125315	0	0
1589542	19127918	2	2
4274025	4155034	6	6
21001258	975125	0	0
21013671	1307863	0	0
35202461	261325	5	8
36009740	4139681	1	1
36151307	1125315	0	0
36517012	81151	2	5
37300000	4113008	5	5
44344603	43012433	2	3
44354163	1119510	0	0
44360174	1119510	0	0
44362725	1119510	0	0
45662772	1551099	0	0
45624954	1125315	0	0
45641419	1119510	0	0
45667731	1713332	0	0
45657881	1129625	0	0
45779017	19008572	2	3
45673651	1557272	0	0
45683602	1125315	0	0
45680158	19079524	1	1
45780450	1332419	2	3
45694447	1759842	0	0
45693673	1361711	0	0
46296805	1115171	2	3
45793389	1154343	0	0
46293071	1125315	0	0
45696932	46275916	1	1
45897915	1125315	0	0
46312520	1119510	0	0
46308692	1119510	0	0
45894711	1125315	0	0
1589542	19128009	2	2
4274025	4278672	6	9
21001205	1343916	0	0
21013671	1326303	0	0
35202461	40486433	5	8
36009740	442116	1	1
36151316	1125315	0	0
36502199	80809	2	5
37300000	4102123	4	4
44341622	40232448	2	3
44355319	1119510	0	0
44359919	1119510	0	0
44361829	1119510	0	0
45662773	19059528	0	0
45622261	1125315	0	0
45641606	1119510	0	0
45667869	1759842	0	0
45658155	1129625	0	0
45778790	40174880	2	3
45673807	1115008	0	0
45683653	1125315	0	0
45675099	46275916	1	1
45703039	19079524	2	3
45694447	1713332	0	0
45693675	1307863	0	0
46296717	19008572	2	3
45793390	1322184	0	0
46292711	1125315	0	0
45696932	19079524	1	1
45897770	1125315	0	0
46312770	1119510	0	0
46312106	1119510	0	0
45894832	1125315	0	0
4010109	4301346	2	2
4274025	4048695	6	9
21001219	914335	0	0
21013658	715997	0	0
35202461	260139	5	8
36009740	4169137	1	1
36151348	1125315	0	0
36302173	4024958	2	5
42805599	1515774	0	0
44341633	46275444	2	3
44355351	1119510	0	0
44360187	1119510	0	0
44361756	1119510	0	0
45662526	1124957	0	0
45622330	1125315	0	0
45641613	1119510	0	0
45667869	1713332	0	0
45658157	1129625	0	0
45779340	43012036	2	3
45673515	701322	0	0
45683714	1125315	0	0
45675099	19079524	1	1
45784616	19075601	2	3
45694453	1110410	0	0
45693757	1115008	0	0
46293520	40162522	2	3
45793375	1124300	0	0
46293009	1125315	0	0
45685128	19079524	1	1
45897846	1125315	0	0
46312661	1119510	0	0
46312152	1119510	0	0
45894768	1125315	0	0
4010109	44783196	2	2
4029205	4293740	4	6
21001228	1124300	0	0
21013543	1307863	0	0
35300000	4144583	8	8
36002872	133834	1	1
36151326	1125315	0	0
36517149	4146173	2	3
42805599	19127890	0	0
44341685	40231925	2	3
44355355	1119510	0	0
44359970	1119510	0	0
44361834	1119510	0	0
45662719	1501700	0	0
45622305	1125315	0	0
45641664	1119510	0	0
45667880	1746114	0	0
45654640	1129625	0	0
45779341	19073183	2	3
45673846	738818	0	0
45683693	1125315	0	0
45699571	46275916	1	1
45678887	19075601	2	3
45694215	1107830	0	0
45693765	1361711	0	0
46293837	19057271	2	3
45793044	1501700	0	0
46292928	1125315	0	0
45690923	19079524	1	1
45897850	1125315	0	0
46312830	1119510	0	0
46312350	1119510	0	0
45894743	1125315	0	0
4028071	198199	3	5
4029205	4202451	4	7
21001149	1551099	0	0
21013671	1309944	0	0
21602754	1501700	0	0
36002869	134438	1	1
36151222	1125315	0	0
36502196	80502	2	3
42805599	1549786	0	0
44341657	19133905	2	3
44355464	1119510	0	0
44360280	1119510	0	0
44361769	1119510	0	0
45662726	1310149	0	0
45622373	1125315	0	0
45641786	1119510	0	0
45667880	1741122	0	0
45654564	1129625	0	0
45779375	1127433	2	3
45673851	1501700	0	0
45683658	1125315	0	0
45699571	19079524	1	1
45706491	19075601	2	3
45694216	975125	0	0
45693850	1153428	0	0
46288885	40229134	2	3
45793308	1192710	0	0
46293047	1125315	0	0
45699839	19079524	1	1
45897852	1125315	0	0
46312831	1119510	0	0
46311838	1119510	0	0
45894817	1125315	0	0
4020346	78272	3	5
4029205	4186930	4	7
21001116	1125315	0	0
21013672	1309944	0	0
21603392	1125443	0	0
36009700	4051466	1	1
36151242	1125315	0	0
36603316	4285898	2	3
42805680	715997	0	0
44341957	920334	2	3
44354286	1119510	0	0
44359901	1119510	0	0
44361966	1119510	0	0
45662775	1729720	0	0
45622558	1125315	0	0
45638247	1119510	0	0
45668007	1738521	0	0
45654657	1129625	0	0
45779165	40232448	2	3
45673954	1115008	0	0
45683734	1125315	0	0
45672521	19079524	1	1
45779671	40228214	2	3
45694194	1174888	0	0
45693766	1149196	0	0
46288900	1115171	2	3
45793310	1115008	0	0
46293048	1125315	0	0
45699964	19079524	1	1
45897960	1125315	0	0
46307057	1119510	0	0
46311915	1119510	0	0
45894818	1125315	0	0
4086181	4132546	3	5
4029205	4295880	4	5
21001248	975125	0	0
21013658	757627	0	0
21603641	1124300	0	0
35702735	441267	1	1
36151102	1125315	0	0
36225034	19127922	2	3
42805555	1177480	0	0
44341736	19133873	2	3
44354369	1119510	0	0
44353281	1119510	0	0
44362295	1119510	0	0
45662629	1124300	0	0
45622318	1125315	0	0
45640079	1119510	0	0
45668011	1308738	0	0
45654658	1129625	0	0
45707637	40228230	2	3
45673958	1149196	0	0
45683770	1125315	0	0
45705632	19079524	1	1
45705259	1539411	2	3
45694303	1174888	0	0
45693856	1332418	0	0
46288644	1115171	2	3
45793228	914335	0	0
46292659	1125315	0	0
45688215	19079524	1	1
45897988	1125315	0	0
46307154	1119510	0	0
46303613	1119510	0	0
45896562	1125315	0	0
4028076	40486433	4	5
4029205	4059978	4	4
21001191	1551099	0	0
21004615	1717327	0	0
21602837	1717327	0	0
36211374	4156265	1	1
36151386	1125315	0	0
36225034	19133679	2	3
42805785	1115008	0	0
44363048	40163554	2	3
44354436	1119510	0	0
44353319	1119510	0	0
44362064	1119510	0	0
45662847	1539403	0	0
45622319	1125315	0	0
45640200	1119510	0	0
45668012	914335	0	0
45654289	1129625	0	0
45707638	1594382	2	3
45673962	1115008	0	0
45683773	1125315	0	0
45706039	46275916	1	1
45684983	19075601	2	3
45694196	1738521	0	0
45693857	1307863	0	0
46288656	1115171	2	3
45793231	1741122	0	0
46292961	1125315	0	0
45688196	46275916	1	1
45897990	1125315	0	0
46307226	1119510	0	0
46303622	1119510	0	0
45896568	1125315	0	0
4028076	4280726	4	5
4029205	4202832	4	4
21001191	914335	0	0
21004494	1717327	0	0
21602735	1551099	0	0
36203073	4296204	1	1
36151155	1125315	0	0
36225034	19129144	2	3
42805788	914335	0	0
42802638	40174880	2	3
44354432	1119510	0	0
44353326	1119510	0	0
45655996	1119510	0	0
45662776	1000560	0	0
45622502	1125315	0	0
45638467	1119510	0	0
45670122	1154029	0	0
45654299	1129625	0	0
45707648	1545959	2	3
45673867	1000560	0	0
45683876	1125315	0	0
45678331	19079524	1	1
45784853	19078461	2	3
45694221	1174888	0	0
45693861	1174888	0	0
46288830	19019273	2	3
45793236	1107830	0	0
46293181	1125315	0	0
45688196	19079524	1	1
45897927	1125315	0	0
46307411	1119510	0	0
46303279	1119510	0	0
45896766	1125315	0	0
201618	81893	4	5
4029205	4145310	5	5
21001191	975125	0	0
21004495	1717327	0	0
21602737	975125	0	0
36203073	4296205	1	1
36155724	1125315	0	0
36225033	19133679	2	3
42805789	740275	0	0
44345264	19018935	2	3
44354461	1119510	0	0
44353244	1119510	0	0
45655832	1119510	0	0
45661406	723013	0	0
45622507	1125315	0	0
45638571	1119510	0	0
45670123	738818	0	0
45654611	1129625	0	0
45777937	40223768	2	3
45673869	1153428	0	0
45683888	1125315	0	0
45690208	19079524	1	1
45681591	19078461	2	3
45694296	1154343	0	0
45694050	1149196	0	0
46291631	43012036	2	3
45793460	723013	0	0
46293194	1125315	0	0
45700038	19079524	1	1
45897929	1125315	0	0
46307235	1119510	0	0
46303580	1119510	0	0
45896774	1125315	0	0
253549	4146173	4	5
4029205	4275113	5	7
21001252	975125	0	0
21004491	1717327	0	0
21604762	742185	0	0
36203073	4299128	1	1
36155726	1125315	0	0
36225033	19127922	2	3
42805650	723013	0	0
44344880	19019273	2	3
44350683	1119510	0	0
44353258	1119510	0	0
45656102	1119510	0	0
45661203	1746114	0	0
45622458	1125315	0	0
45638505	1119510	0	0
45670267	791967	0	0
45655435	1129625	0	0
45707818	40232448	2	3
45673824	1115008	0	0
45683889	1125315	0	0
45690208	46275916	1	1
45693408	40228214	2	3
45694307	1557272	0	0
45694151	1778162	0	0
46291649	40229134	2	3
45793455	1557272	0	0
46293210	1125315	0	0
45690864	19079524	1	1
45897708	1125315	0	0
46307236	1119510	0	0
46303722	1119510	0	0
45896530	1125315	0	0
4024567	4283893	4	5
4029205	4107731	5	7
21001283	1125315	0	0
21004199	1738521	0	0
21604206	19016749	0	0
35602665	4280726	1	1
36155807	1125315	0	0
36225033	19129144	2	3
42805739	920293	0	0
44353184	19019273	2	3
44350513	1119510	0	0
44353163	1119510	0	0
45656103	1119510	0	0
45661203	1741122	0	0
45622600	1125315	0	0
45635235	1119510	0	0
45670000	740275	0	0
45651234	1129625	0	0
45704945	1127433	2	3
45673942	1107830	0	0
45683879	1125315	0	0
45674837	46275916	1	1
45779899	1539411	2	3
45694227	1308738	0	0
45694152	1549786	0	0
46288935	40236446	2	3
45793345	1308738	0	0
46293420	1125315	0	0
45684781	46275916	1	1
45895341	1125315	0	0
46307241	1119510	0	0
46303676	1119510	0	0
45894897	1125315	0	0
4180628	317576	4	5
4029205	4301346	5	6
21001283	1129625	0	0
21004249	1125315	0	0
35507492	1332418	0	0
35909419	198809	1	1
36155836	1125315	0	0
36427938	40220386	2	3
42805741	920293	0	0
44355219	19075001	2	3
44350541	1119510	0	0
44355240	1119510	0	0
45655911	1119510	0	0
45661206	19127890	0	0
45622444	1125315	0	0
45635251	1119510	0	0
45670001	1174888	0	0
45651216	1129625	0	0
45705125	40232448	2	3
45674073	1149196	0	0
45683890	1125315	0	0
45674837	19079524	1	1
45685108	1539411	2	3
45694315	1112807	0	0
45694152	1515774	0	0
46289317	40231925	2	3
45793158	967823	0	0
46293166	1125315	0	0
45684781	19079524	1	1
45895500	1125315	0	0
46307267	1119510	0	0
46303559	1119510	0	0
45894903	1125315	0	0
4180628	4329847	4	5
4029205	40492359	5	9
21001283	1177480	0	0
21004249	1150836	0	0
35507625	1192710	0	0
35702748	440448	1	1
36155941	1125315	0	0
36426867	1115171	2	3
42805745	1713332	0	0
42802725	19019273	2	3
44350546	1119510	0	0
44355303	1119510	0	0
45656027	1119510	0	0
45661206	1515774	0	0
45622376	1125315	0	0
45635407	1119510	0	0
45670005	1192710	0	0
45651478	1129625	0	0
45704800	40163554	2	3
45670538	1149196	0	0
45683971	1125315	0	0
45691417	19079524	1	1
45690931	1539411	2	3
45694328	705944	0	0
45694098	1149196	0	0
46289069	1332419	2	3
45793349	1149196	0	0
46293232	1125315	0	0
45706602	19079524	1	1
45895502	1125315	0	0
46307593	1119510	0	0
46303789	1119510	0	0
45803591	1125315	0	0
4028071	4056621	4	5
4029205	4336464	6	10
21001283	1192710	0	0
21004249	1107830	0	0
35507625	1112807	0	0
35702743	192671	1	1
36155900	1125315	0	0
36426867	19019273	2	3
42805745	1759842	0	0
44363014	19019273	2	3
44350726	1119510	0	0
44355328	1119510	0	0
45656029	1119510	0	0
45661206	1549786	0	0
45620712	1125315	0	0
45635267	1119510	0	0
45670055	1107830	0	0
45651665	1129625	0	0
45704928	19077572	2	3
45670549	1000560	0	0
45683978	1125315	0	0
45696262	46275916	1	1
45706148	19079524	2	3
45694348	740275	0	0
45694155	1000560	0	0
46243630	19008572	2	3
45793259	1361711	0	0
46292844	1125315	0	0
45699929	19079524	1	1
45895463	1125315	0	0
46307545	1119510	0	0
46303619	1119510	0	0
45803625	1125315	0	0
4023995	317576	4	5
4029205	4037675	6	7
21001385	1717327	0	0
21011303	1361711	0	0
35507392	1149196	0	0
35702744	192671	1	1
36156016	1125315	0	0
36426668	19007333	2	3
42805695	1137529	0	0
44353107	19019273	2	3
44350941	1119510	0	0
44353447	1119510	0	0
45656405	1119510	0	0
45661284	1549786	0	0
45620828	1125315	0	0
45635359	1119510	0	0
45670012	1154343	0	0
45651561	1129625	0	0
45691799	19078461	2	3
45670656	1717327	0	0
45684000	1125315	0	0
45696755	19079524	1	1
45678759	1539411	2	3
45694349	1174888	0	0
45694161	975125	0	0
46243732	1127433	2	3
45793260	705944	0	0
46293398	1125315	0	0
45875957	3051031	2	2
45895542	1125315	0	0
46307312	1119510	0	0
46303755	1119510	0	0
45803821	1125315	0	0
4023995	4329847	4	5
4029205	4314290	6	6
21001430	975125	0	0
21011419	1154029	0	0
35507497	1149196	0	0
35702754	30753	1	1
36155838	1125315	0	0
36426679	40236446	2	3
42805695	1149380	0	0
44359019	1551192	2	3
44350919	1119510	0	0
44353409	1119510	0	0
45656411	1119510	0	0
45661284	19127890	0	0
45620938	1125315	0	0
45635533	1119510	0	0
45670079	1192710	0	0
45648510	1129625	0	0
45703632	40228214	2	3
45673280	967823	0	0
45684012	1125315	0	0
45687698	46275916	1	1
45682201	19079524	2	3
45694352	1154343	0	0
45694041	1192710	0	0
46243736	1115171	2	3
45793355	1549786	0	0
46287953	1125315	0	0
46239754	46233988	2	3
45896804	1125315	0	0
46307210	1119510	0	0
46303320	1119510	0	0
45803897	1125315	0	0
4022922	4035415	4	5
4029205	4243062	6	6
21001385	1729720	0	0
21011419	1110410	0	0
35507600	740275	0	0
35702775	4027663	1	1
36155943	1125315	0	0
36424292	40232448	2	3
42805699	1177480	0	0
44362653	1551192	2	3
44350925	1119510	0	0
44345742	1119510	0	0
45652628	1119510	0	0
45661284	1589505	0	0
45620984	1125315	0	0
45635645	1119510	0	0
45670081	1149196	0	0
45648427	1129625	0	0
45778879	1107882	2	3
45672997	1107830	0	0
45684018	1125315	0	0
45682476	19079524	1	1
45688319	40228214	2	3
45694261	1326303	0	0
45693752	1310149	0	0
46243586	40229134	2	3
45793355	19127890	0	0
46287955	1125315	0	0
46239754	46233710	2	3
45896728	1125315	0	0
46307632	1119510	0	0
46303697	1119510	0	0
45803899	1125315	0	0
4022922	4059173	4	5
4029205	4125906	6	6
21001430	1112807	0	0
21011415	1154029	0	0
35507614	740275	0	0
35604745	40224805	1	1
36155780	1125315	0	0
36424373	46233710	2	3
42805889	1738521	0	0
44341618	1545959	2	3
44350766	1119510	0	0
44345437	1119510	0	0
45652667	1119510	0	0
45661287	1548195	0	0
45620986	1125315	0	0
45635660	1119510	0	0
45670086	1192710	0	0
45645280	1129625	0	0
45670805	1107882	2	3
45673080	1115008	0	0
45680702	1125315	0	0
45677741	46275916	1	1
45685146	40228214	2	3
45694445	1310149	0	0
45693754	1713332	0	0
46243772	40229134	2	3
45793355	1515774	0	0
46288160	1125315	0	0
45894621	1107882	2	3
45875969	3004501	2	2
46307681	1119510	0	0
46303685	1119510	0	0
45803900	1125315	0	0
4022922	4109685	4	5
4029205	4195803	3	3
21001427	1728416	0	0
21004631	1728416	0	0
35507601	1713332	0	0
35605480	35605482	1	1
36155882	1125315	0	0
36424373	46233988	2	3
42805793	1713332	0	0
44359421	19123231	2	3
44346851	1119510	0	0
44348085	1119510	0	0
45652446	1119510	0	0
45661289	1713332	0	0
45621153	1125315	0	0
45634235	1119510	0	0
45670312	1192710	0	0
45645345	1129625	0	0
45676781	1107882	2	3
45673081	1307863	0	0
45680750	1125315	0	0
45679775	46275916	1	1
45684902	40228214	2	3
45694465	1107830	0	0
45694133	1308738	0	0
46241313	40229134	2	3
45793361	1549786	0	0
46288022	1125315	0	0
45796664	1107882	2	3
45875971	3049273	2	2
46302151	1119510	0	0
46304024	1119510	0	0
45803684	1125315	0	0
4027553	261325	2	5
4029205	4187458	3	3
21001283	738818	0	0
21004631	1717327	0	0
35507603	1153428	0	0
36002868	133834	1	1
36156211	1125315	0	0
36244035	19125062	2	3
42805793	1759842	0	0
44356246	40223834	2	3
44346947	1119510	0	0
44348037	1119510	0	0
45652639	1119510	0	0
45661542	1367571	0	0
45621046	1125315	0	0
45632284	1119510	0	0
45670314	1501700	0	0
45645452	1129625	0	0
45701293	1107882	2	3
45673003	738818	0	0
45680457	1125315	0	0
45708101	46275916	1	1
45706587	40228214	2	3
45694466	1112807	0	0
45694136	1124957	0	0
46241331	19057271	2	3
45793361	19127890	0	0
46287961	1125315	0	0
46240291	40173590	2	3
45791320	19128022	2	2
46302156	1119510	0	0
46303918	1119510	0	0
45803594	1125315	0	0
254068	4112343	2	5
4029205	4199276	3	3
21001283	1149196	0	0
21004620	1551099	0	0
35507671	740275	0	0
36002868	317009	1	1
36156217	1125315	0	0
36426817	35605858	2	3
42805810	742185	0	0
44356246	40223821	2	3
44346913	1119510	0	0
44345853	1119510	0	0
45655036	1119510	0	0
45659462	1110410	0	0
45620772	1125315	0	0
45632324	1119510	0	0
45670263	1713332	0	0
45645406	1129625	0	0
45778595	1107882	2	3
45673410	1728416	0	0
45680668	1125315	0	0
45763613	4285898	1	1
45693483	40228214	2	3
45694479	1112807	0	0
45694141	914335	0	0
46241352	920334	2	3
45793361	1521369	0	0
46288045	1125315	0	0
46244860	40223768	2	3
45791320	19128263	2	2
46302005	1119510	0	0
46303494	1119510	0	0
45803552	1125315	0	0
4034850	4015189	2	5
4029205	4163951	3	3
21000198	1738521	0	0
21004633	1717327	0	0
35507673	1115008	0	0
35604830	35605858	1	1
36156026	1125315	0	0
36217214	40232448	2	3
42805814	1124957	0	0
44352901	1545959	2	3
44346916	1119510	0	0
44345839	1119510	0	0
45655043	1119510	0	0
45659342	1539403	0	0
45620770	1125315	0	0
45632508	1119510	0	0
45670450	920293	0	0
45642367	1129625	0	0
45671147	19073183	2	3
45673131	740275	0	0
45680574	1125315	0	0
45763653	4230399	1	1
45693784	40228214	2	3
45694485	1112807	0	0
45694144	1367571	0	0
46241520	19059056	2	3
45793364	975125	0	0
46288056	1125315	0	0
45790835	19078461	2	3
45875968	3000963	2	3
46301868	1119510	0	0
46300876	1119510	0	0
45803602	1125315	0	0
4162282	40486433	5	5
4029205	4012477	3	6
21000199	1738521	0	0
21004633	1778162	0	0
35507607	1153428	0	0
36203051	134438	1	1
36156044	1125315	0	0
36425676	19019979	2	3
42805822	1515774	0	0
44351536	19123231	2	3
44347116	1119510	0	0
44345891	1119510	0	0
45655170	1119510	0	0
45659420	701322	0	0
45621202	1125315	0	0
45632355	1119510	0	0
45670452	1154343	0	0
45642409	1129625	0	0
45674274	1107882	2	3
45673136	1521369	0	0
45680436	1125315	0	0
45766333	4294548	1	1
45678776	40228214	2	3
45694489	1512674	0	0
45694148	708298	0	0
46241600	40162522	2	3
45793365	1149196	0	0
46288298	1125315	0	0
45896108	1107882	2	3
45875968	40766240	2	3
46302300	1119510	0	0
46300885	1119510	0	0
45803805	1125315	0	0
435244	440086	5	5
4029205	4010253	3	7
21000220	1738521	0	0
21004634	1728416	0	0
35507610	933724	0	0
36102149	4048171	5	5
36156027	1125315	0	0
36425676	19078461	2	3
42805544	1713332	0	0
44348645	1545959	2	3
44347038	1119510	0	0
44345921	1119510	0	0
45655334	1119510	0	0
45659376	1343916	0	0
45621205	1125315	0	0
45632612	1119510	0	0
45668067	1717327	0	0
45642439	1129625	0	0
45679291	1332419	2	3
45673004	1713332	0	0
45680710	1125315	0	0
45765647	4132546	1	1
45690828	40228214	2	3
45694613	1174888	0	0
45693862	1738521	0	0
46241603	19008572	2	3
45794637	1539403	0	0
46288301	1125315	0	0
45790801	40223768	2	3
45875968	40769179	2	3
46302395	1119510	0	0
46301079	1119510	0	0
45803866	1125315	0	0
437515	4144583	5	5
4029205	4323902	3	7
21000221	1738521	0	0
21004634	1778162	0	0
35507733	1322184	0	0
36100000	40486433	5	5
36156001	1125315	0	0
36217216	1127078	2	3
42805544	1759842	0	0
44345477	19019273	2	3
44347009	1119510	0	0
44345933	1119510	0	0
45655346	1119510	0	0
45659381	738818	0	0
45620904	1125315	0	0
45629465	1119510	0	0
45668116	1174888	0	0
45642585	1129625	0	0
45701137	1332419	2	3
45673004	1759842	0	0
45680721	1125315	0	0
45766714	134438	1	1
45699914	40228214	2	3
45694489	1549786	0	0
45693863	1557272	0	0
46241606	1115171	2	3
45794860	740275	0	0
46288311	1125315	0	0
45796553	19075001	2	3
45875968	40769194	2	3
46302257	1119510	0	0
46301694	1119510	0	0
45803845	1125315	0	0
432795	4113008	5	5
4029205	4163971	3	8
21000219	1738521	0	0
21004634	1717327	0	0
35507373	1125315	0	0
36102898	28060	5	5
36156195	1125315	0	0
36217216	19007333	2	3
42805549	1738521	0	0
44349312	1107882	2	3
44347024	1119510	0	0
44341222	1119510	0	0
45652778	1119510	0	0
45659435	1149196	0	0
45621089	1125315	0	0
45629168	1119510	0	0
45668153	1174888	0	0
45642578	1129625	0	0
45707879	19073183	2	3
45673087	1557272	0	0
45680722	1125315	0	0
45705650	46275916	1	1
45682622	40228214	2	3
45694435	1112807	0	0
45694016	1729720	0	0
46241628	19075601	2	3
45794730	705944	0	0
46288259	1125315	0	0
46244872	40223768	2	3
45875968	40769189	2	3
46302427	1119510	0	0
46301915	1119510	0	0
45803673	1125315	0	0
4101796	4001336	5	5
4029205	42535580	7	8
21000224	1738521	0	0
21004632	1728416	0	0
35507561	791967	0	0
36102898	433125	5	5
36156198	1125315	0	0
36300000	4310024	8	12
42805830	1500211	0	0
44341860	19078461	2	3
44347092	1119510	0	0
44338687	1119510	0	0
45652781	1119510	0	0
45659444	723013	0	0
45621193	1125315	0	0
45629605	1119510	0	0
45668155	967823	0	0
45642749	1129625	0	0
45669314	19078461	2	3
45673129	1000560	0	0
45680732	1125315	0	0
45703996	19079524	1	1
45693766	40228214	2	3
45694280	715997	0	0
45694017	1174888	0	0
46241673	40231925	2	3
45794807	1115008	0	0
46288203	1125315	0	0
46299474	1107882	2	3
45875968	40769184	2	3
46306832	1119510	0	0
46301336	1119510	0	0
45803678	1125315	0	0
4028071	4266809	5	5
4029205	4078793	2	2
21000222	1738521	0	0
21004632	1717327	0	0
35507567	1000560	0	0
35202461	441267	5	5
36156199	1125315	0	0
36300000	4152936	8	13
42805551	1551099	0	0
42803038	19075601	2	3
44347184	1119510	0	0
44338675	1119510	0	0
45652929	1119510	0	0
45659514	1713332	0	0
45621197	1125315	0	0
45629237	1119510	0	0
45668169	1000560	0	0
45640168	1129625	0	0
45698445	1107882	2	3
45670722	723013	0	0
45680558	1125315	0	0
45702426	40171902	1	1
45691001	40228214	2	3
45694602	975125	0	0
45693864	791967	0	0
46238795	40229134	2	3
45794658	1153428	0	0
46288335	1125315	0	0
45896062	19073183	2	3
46289275	46275916	1	1
46306867	1119510	0	0
46301192	1119510	0	0
45803954	1125315	0	0
4028071	255848	5	5
4029205	4191853	2	2
21000223	1738521	0	0
21004633	1728416	0	0
35507568	914335	0	0
36202155	81151	5	5
36156201	1125315	0	0
36300000	4285898	8	15
42805822	1549786	0	0
44352347	19078924	2	3
44347248	1119510	0	0
44338682	1119510	0	0
45652812	1119510	0	0
45659382	1501700	0	0
45621159	1125315	0	0
45629573	1119510	0	0
45668175	1115008	0	0
45639452	1129625	0	0
45633115	1107882	2	3
45700521	1129625	0	0
45680743	1125315	0	0
45699186	46275916	1	1
45706412	40228214	2	3
45694506	1551099	0	0
45694028	1000560	0	0
46238561	40229134	2	3
45794661	1110410	0	0
46288360	1125315	0	0
45791435	19073183	2	3
46301326	19079524	1	1
46306971	1119510	0	0
46301200	1119510	0	0
45803880	1125315	0	0
200174	133834	5	5
4199402	81893	10	11
21000217	1738521	0	0
21004635	1728416	0	0
35507572	1115008	0	0
36202155	40479422	5	5
36156202	1125315	0	0
36300000	4094814	8	8
42805824	1738521	0	0
44344696	1107882	2	3
44343221	1119510	0	0
44338741	1119510	0	0
45652765	1119510	0	0
45659386	1307863	0	0
45664674	1125315	0	0
45629475	1119510	0	0
45668190	1118084	0	0
45639593	1129625	0	0
45677220	1107882	2	3
45698987	1129625	0	0
45680862	1125315	0	0
45699528	46275916	1	1
45706856	19079524	2	3
45691242	1149196	0	0
45693990	967823	0	0
46238782	19076374	2	3
45794685	1115008	0	0
46288417	1125315	0	0
45787996	19073183	2	3
46301391	46275916	1	1
46299800	1119510	0	0
46301319	1119510	0	0
45803979	1125315	0	0
4024000	195588	5	5
4199402	4218389	4	5
21000242	1738521	0	0
21004635	1746114	0	0
35507374	1129625	0	0
35202461	4283893	5	6
36156203	1125315	0	0
36300000	4142905	9	13
42805577	1125315	0	0
44359234	1107882	2	3
44343229	1119510	0	0
44338882	1119510	0	0
45649459	1119510	0	0
45659396	753626	0	0
45664678	1125315	0	0
45629495	1119510	0	0
45668086	1501700	0	0
45639759	1129625	0	0
45686376	1545959	2	3
45698973	1129625	0	0
45680863	1125315	0	0
45696085	40171902	1	1
45691285	40228214	2	3
45691244	1112807	0	0
45693985	1110410	0	0
46238624	19077572	2	3
45794688	975125	0	0
46288443	1125315	0	0
45796532	19073183	2	3
46301478	46275916	1	1
46299907	1119510	0	0
46301309	1119510	0	0
45675364	19127904	3	4
4023995	4310024	5	5
4199402	4043241	9	10
21000247	1738521	0	0
21004635	1741122	0	0
35507734	1115008	0	0
35205038	28060	5	6
36156435	1125315	0	0
36300000	4001336	9	13
42805894	708298	0	0
44359444	1107882	2	3
44343285	1119510	0	0
44339050	1119510	0	0
45649535	1119510	0	0
45659354	1310149	0	0
45664598	1125315	0	0
45629409	1119510	0	0
45668088	1521369	0	0
45636313	1129625	0	0
45704576	19019273	2	3
45699005	1129625	0	0
45680888	1125315	0	0
45694630	19079524	1	1
45706215	40228214	2	3
45691329	1307863	0	0
45694112	1149196	0	0
46238818	19008572	2	3
45787926	1728416	0	0
46288456	1125315	0	0
45798316	40228214	2	3
46322460	19079524	2	3
46299926	1119510	0	0
46301405	1119510	0	0
45896768	19129144	3	4
254068	4048171	5	5
4199402	440448	9	9
21000227	1738521	0	0
21004635	1778162	0	0
35507736	1759842	0	0
35205038	40481087	5	6
36156437	1125315	0	0
36300000	4048695	9	13
42805895	1310149	0	0
44341645	1107882	2	3
44343113	1119510	0	0
44338806	1119510	0	0
45649601	1119510	0	0
45659357	1326303	0	0
45664712	1125315	0	0
45626510	1119510	0	0
45668183	1174888	0	0
45636509	1129625	0	0
45778896	1332419	2	3
45695514	1129625	0	0
45677405	1125315	0	0
45693724	46275916	1	1
45777725	19079524	2	3
45691322	1149196	0	0
45694034	1115008	0	0
46238825	1127433	2	3
45787930	975125	0	0
46288772	1125315	0	0
45795984	40223768	2	3
46321959	1107882	2	3
46299938	1119510	0	0
46301325	1119510	0	0
441840	313217	7	12
4199402	195588	5	8
21000235	1738521	0	0
21004635	1717327	0	0
35507736	1713332	0	0
36100000	258780	5	6
36156604	1125315	0	0
36300000	4146173	9	13
42805871	1322184	0	0
44362578	1332419	2	3
44343417	1119510	0	0
44339063	1119510	0	0
45649615	1119510	0	0
45659459	1308738	0	0
45664714	1125315	0	0
45626737	1119510	0	0
45668123	1347450	0	0
45636395	1129625	0	0
45680650	40228214	2	3
45695572	1129625	0	0
45677390	1125315	0	0
45691425	19079524	1	1
45690805	40228214	2	3
45691131	1112807	0	0
45694118	967823	0	0
46240079	1115171	2	3
45787943	1000560	0	0
46288803	1125315	0	0
45796385	1107882	2	3
46306989	1107882	2	3
46299870	1119510	0	0
46301409	1119510	0	0
441840	4048171	7	12
4199402	4142905	5	8
21000228	1738521	0	0
21004737	1308738	0	0
35507640	1125315	0	0
21604181	40220386	5	6
36158860	1125315	0	0
36300000	40481087	9	13
42805647	1115008	0	0
44356127	40173590	2	3
44343422	1119510	0	0
44339070	1119510	0	0
45649886	1119510	0	0
45659545	19003953	0	0
45667415	1125315	0	0
45626619	1119510	0	0
45668124	1153428	0	0
45636485	1129625	0	0
45692346	1332419	2	3
45695613	1129625	0	0
45677427	1125315	0	0
45687440	19079524	1	1
45694112	40228214	2	3
45691133	1192710	0	0
45694122	1307863	0	0
45897645	40232448	2	3
45787944	1738521	0	0
46288684	1125315	0	0
45893969	1107882	2	3
46311462	19075601	2	3
46300027	1119510	0	0
46301441	1119510	0	0
441840	81893	7	13
4199402	4285898	5	10
21502534	1307863	0	0
21004854	1717327	0	0
35507684	1713332	0	0
36102154	4056621	5	7
36158838	1125315	0	0
36300000	4149245	9	13
42805904	1177480	0	0
42802893	19078461	2	3
44343423	1119510	0	0
44360409	1119510	0	0
45649715	1119510	0	0
45659546	742185	0	0
45664745	1125315	0	0
45626540	1119510	0	0
45668130	920293	0	0
45636493	1129625	0	0
45683385	1332419	2	3
45695766	1129625	0	0
45677499	1125315	0	0
45681611	19079524	1	1
45678916	19079524	2	3
45691303	1112807	0	0
45694896	1124957	0	0
45897657	40229134	2	3
45787990	1115008	0	0
46288691	1125315	0	0
46293919	40222846	2	3
46321769	19078461	2	3
46300089	1119510	0	0
46301712	1119510	0	0
441840	433644	7	8
4199402	4066995	5	7
21502524	920293	0	0
21004855	975125	0	0
35507684	1759842	0	0
36203062	4156265	5	7
36158849	1125315	0	0
36300000	81151	9	14
42805905	1549786	0	0
44345193	40173590	2	3
44343465	1119510	0	0
44360396	1119510	0	0
45649941	1119510	0	0
45659547	1738521	0	0
45664822	1125315	0	0
45626979	1119510	0	0
45668319	1308738	0	0
45637250	1129625	0	0
45705050	40173590	2	3
45695833	1129625	0	0
45677323	1125315	0	0
45681515	46275916	1	1
45678489	19079524	2	3
45691305	1154029	0	0
45694415	975125	0	0
45897686	40163554	2	3
45787996	1713332	0	0
46288701	1125315	0	0
46244034	1107882	2	3
46310951	19078461	2	3
46300226	1119510	0	0
46319235	1119510	0	0
441840	441267	6	7
4199402	198199	5	7
21501259	967823	0	0
21004856	1728416	0	0
35507941	1154343	0	0
36203062	4132546	5	7
36158935	1125315	0	0
36300000	4230399	9	14
42805905	1519936	0	0
44355207	19075601	2	3
44343514	1119510	0	0
44360060	1119510	0	0
45649001	1119510	0	0
45659509	1174888	0	0
45664795	1125315	0	0
45623286	1119510	0	0
45668321	920293	0	0
45633536	1129625	0	0
45695190	1332419	2	3
45694511	1129625	0	0
45677541	1125315	0	0
45678625	19079524	1	1
45672772	19079524	2	3
45691324	740275	0	0
45690931	1539403	0	0
45897732	1551192	2	3
45787950	933724	0	0
46288761	1125315	0	0
45790939	1107882	2	3
46321908	19079524	2	3
46300040	1119510	0	0
46319770	1119510	0	0
441840	442116	6	7
4199402	78272	5	7
19010482	19010482	0	0
21004756	975125	0	0
35507576	1124300	0	0
35702767	4285898	5	7
36158677	1125315	0	0
36300000	40486433	9	14
42805794	715997	0	0
44352163	1332419	2	3
44343527	1119510	0	0
44360349	1119510	0	0
45649106	1119510	0	0
45659513	1310149	0	0
45664870	1125315	0	0
45623294	1119510	0	0
45668325	1124957	0	0
45633398	1129625	0	0
45676708	40173590	2	3
45692411	1129625	0	0
45677417	1125315	0	0
45678943	46275916	1	1
45697022	40223768	2	3
45802509	791967	0	0
45690939	975125	0	0
45897738	40224132	2	3
45787982	975125	0	0
46288716	1125315	0	0
46244219	1107882	2	3
46322127	40228214	2	3
46299996	1119510	0	0
46319771	1119510	0	0
441840	28060	6	9
4199402	140673	5	5
19010530	19134077	0	0
21004758	1595799	0	0
35507577	1501700	0	0
36102144	4294548	5	7
36159085	1125315	0	0
36300000	4296204	9	12
42805797	1125315	0	0
44345297	19075601	2	3
44343648	1119510	0	0
44360239	1119510	0	0
45646491	1119510	0	0
45659582	1551099	0	0
45664759	1125315	0	0
45623295	1119510	0	0
45668326	1307863	0	0
45633343	1129625	0	0
45707385	1332419	2	3
45692425	1129625	0	0
45677422	1125315	0	0
45678141	19127922	1	1
45682237	19078461	2	3
45802487	1545958	0	0
45690941	1717327	0	0
45897744	40232448	2	3
45788011	1149196	0	0
46244800	1125315	0	0
45801712	19078461	2	3
46321937	19078461	2	3
46300111	1119510	0	0
46322571	1119510	0	0
441840	255848	6	9
4199402	4029498	5	5
21003349	914335	0	0
21004758	1396131	0	0
35507642	975125	0	0
36102144	4116491	5	7
36159086	1125315	0	0
36300000	439406	9	10
42805800	19127890	0	0
44356224	19075601	2	3
44339818	1119510	0	0
44359936	1119510	0	0
45646528	1119510	0	0
45659529	1539403	0	0
45664968	1125315	0	0
45623513	1119510	0	0
45668286	705944	0	0
45633637	1129625	0	0
45698218	1332419	2	3
45692734	1129625	0	0
45677453	1125315	0	0
45678141	19133679	1	1
45678632	19078461	2	3
45802488	1153428	0	0
45690950	1326303	0	0
45897836	1539411	2	3
45787962	967823	0	0
46244804	1125315	0	0
45896089	1107882	2	3
46306460	19078461	2	3
46300113	1119510	0	0
46319844	1119510	0	0
441840	4149245	6	10
4199402	4166224	8	9
21003376	1129625	0	0
21004753	1746114	0	0
35507644	1129625	0	0
35802134	4285898	5	8
36159092	1125315	0	0
36300000	4306014	9	10
42805800	1589505	0	0
44345802	19079524	2	3
44339793	1119510	0	0
44359938	1119510	0	0
45646467	1119510	0	0
45659584	715997	0	0
45664879	1125315	0	0
45623520	1119510	0	0
45668106	1192710	0	0
45633440	1129625	0	0
45680418	40228214	2	3
45692390	1129625	0	0
45677593	1125315	0	0
45678141	19129144	1	1
45690780	19078461	2	3
45802323	1521369	0	0
45690951	975125	0	0
45897703	19059056	2	3
45788002	1124300	0	0
46244751	1125315	0	0
46242523	19078461	2	3
46316821	40228214	2	3
46300104	1119510	0	0
46319857	1119510	0	0
441840	4278672	6	10
4199402	258780	8	8
21003376	1343916	0	0
21004753	1741122	0	0
35507650	1129625	0	0
35205038	258780	5	8
36158776	1125315	0	0
36300000	4048169	9	10
42805800	1549786	0	0
44344946	19078461	2	3
44339906	1119510	0	0
44360306	1119510	0	0
45646646	1119510	0	0
45659472	1551099	0	0
45665068	1125315	0	0
45623363	1119510	0	0
45668108	1307863	0	0
45633544	1129625	0	0
45676402	19078461	2	3
45692615	1129625	0	0
45677700	1125315	0	0
45676347	19079524	1	1
45696917	19078461	2	3
45802323	1595799	0	0
45691054	1192710	0	0
45897917	40224805	2	3
45788024	1174888	0	0
46244656	1125315	0	0
45788113	19078461	2	3
46311229	19078461	2	3
46300340	1119510	0	0
46319936	1119510	0	0
441840	321042	6	10
4199402	372328	6	6
21003375	1129625	0	0
21004852	975125	0	0
35507651	1125315	0	0
35205038	4048171	5	8
36158903	1125315	0	0
36300000	4296205	9	9
42805553	1713332	0	0
44338265	19078461	2	3
44339885	1119510	0	0
44360262	1119510	0	0
45646605	1119510	0	0
45659473	1738521	0	0
45665071	1125315	0	0
45623630	1119510	0	0
45668161	738818	0	0
45633750	1129625	0	0
45698405	19078461	2	3
45692567	1129625	0	0
45677712	1125315	0	0
45769811	4001336	1	1
45690696	19078461	2	3
45802323	1549786	0	0
45691060	1501700	0	0
45897856	920300	2	3
45788026	1149196	0	0
46244657	1125315	0	0
46243963	40173590	2	3
45787463	1115171	2	3
46300245	1119510	0	0
46320058	1119510	0	0
441840	80502	5	7
4199402	4113008	6	6
21003385	1551099	0	0
21002821	1125315	0	0
35507652	1125315	0	0
36102154	4294548	5	8
36159114	1125315	0	0
36300000	4059173	10	13
42805520	967823	0	0
44345655	40228214	2	3
44339871	1119510	0	0
44362727	1119510	0	0
45646727	1119510	0	0
45656518	1174888	0	0
45664622	1125315	0	0
45623636	1119510	0	0
45668113	1548195	0	0
45630496	1129625	0	0
45683318	19078461	2	3
45692670	1129625	0	0
45677763	1125315	0	0
45702780	19079524	1	1
45780020	19078461	2	3
45802620	1549786	0	0
45691003	1713332	0	0
45897961	1107882	2	3
45788005	1192710	0	0
46243272	1125315	0	0
45801651	40173590	2	3
45787504	19059056	2	3
46300159	1119510	0	0
46319976	1119510	0	0
441840	260139	5	10
4199402	4155034	6	6
21003223	1129625	0	0
21002811	1124300	0	0
35507653	1125315	0	0
36100000	4056621	5	8
36158924	1125315	0	0
36300000	81893	10	16
42805911	1551099	0	0
44352766	1539411	2	3
44339876	1119510	0	0
44362800	1119510	0	0
45646585	1119510	0	0
45656316	738818	0	0
45664321	1125315	0	0
45667703	1119510	0	0
45665999	1332418	0	0
45630507	1129625	0	0
45669527	19075601	2	3
45692694	1129625	0	0
45677779	1125315	0	0
45702671	46275916	1	1
45694183	19078461	2	3
45802620	1521369	0	0
45691003	1759842	0	0
45895497	40232448	2	3
45788006	791967	0	0
46243284	1125315	0	0
45793455	40173590	2	3
45787509	782047	2	3
46296475	1119510	0	0
46320009	1119510	0	0
441840	4329847	5	11
4199402	380378	6	6
21003205	738818	0	0
21002812	975125	0	0
35507653	1119510	0	0
36203062	4001336	5	8
36159122	1125315	0	0
36300000	433644	10	11
42805922	1729720	0	0
44352685	40228214	2	3
44340117	1119510	0	0
44360555	1119510	0	0
45643811	1119510	0	0
45656536	1124957	0	0
45664329	1125315	0	0
45667842	1119510	0	0
45666000	1107830	0	0
45630323	1129625	0	0
45698518	19078461	2	3
45692709	1129625	0	0
45677781	1125315	0	0
45702668	46275916	1	1
45699715	19078461	2	3
45802631	1545958	0	0
45690898	1000560	0	0
45895570	19133873	2	3
45788038	757627	0	0
46243296	1125315	0	0
45798606	1332419	2	3
45787683	19074841	2	3
46296065	1119510	0	0
46320014	1119510	0	0
441840	133834	8	10
4199402	4109685	6	7
21003371	1000560	0	0
21002827	1115008	0	0
35507658	715997	0	0
36202157	40479768	5	10
36159003	1125315	0	0
36500000	381316	6	6
42805632	1557272	0	0
44359433	40228214	2	3
44340125	1119510	0	0
44360534	1119510	0	0
45643324	1119510	0	0
45656220	1361711	0	0
45662086	1125315	0	0
45667913	1119510	0	0
45665936	1310149	0	0
45630328	1129625	0	0
45674103	19075601	2	3
45692701	1129625	0	0
45677926	1125315	0	0
45696828	19079524	1	1
45706173	19078461	2	3
45802498	1124957	0	0
45690863	1107830	0	0
45895573	1332419	2	3
45788128	975125	0	0
46243301	1125315	0	0
46239381	40173590	2	3
45787739	19008572	2	3
46296348	1119510	0	0
46320029	1119510	0	0
441840	40479422	8	11
4199402	4056621	6	7
21003226	1129625	0	0
21002827	1551099	0	0
35507596	1174888	0	0
36203062	4230399	5	9
36158929	1125315	0	0
36500000	4310024	5	7
42805717	1119510	0	0
44345358	19079524	2	3
44340256	1119510	0	0
44360541	1119510	0	0
45643739	1119510	0	0
45656228	1343916	0	0
45662037	1125315	0	0
45667738	1119510	0	0
45665773	1309944	0	0
45630547	1129625	0	0
45779128	19078461	2	3
45689589	1129625	0	0
45677845	1125315	0	0
45692832	46275916	1	1
45780104	19078461	2	3
45802654	920293	0	0
45691080	1738521	0	0
45896724	19008572	2	3
45788040	723013	0	0
46243364	1125315	0	0
46294692	1332419	2	3
45787492	19019273	2	3
46318427	1119510	0	0
46319883	1119510	0	0
441840	4280726	4	11
4199402	4310024	6	7
21003246	914335	0	0
21002822	1125315	0	0
35507596	1125315	0	0
36203062	40479768	5	9
36159294	1125315	0	0
36500000	4280726	7	7
42805718	1149380	0	0
44359115	19078461	2	3
44340285	1119510	0	0
44353470	1119510	0	0
45643485	1119510	0	0
45656434	1149196	0	0
45662147	1125315	0	0
45667750	1119510	0	0
45665774	1717327	0	0
45630756	1129625	0	0
45707180	19075601	2	3
45689596	1129625	0	0
45677857	1125315	0	0
45692855	46275916	1	1
45706463	19078461	2	3
45802331	1332418	0	0
45691036	1713332	0	0
45896728	1127433	2	3
45788041	1149196	0	0
46243381	1125315	0	0
45801501	1332419	2	3
45801113	46233710	2	3
46318429	1119510	0	0
46313781	1119510	0	0
441840	134438	3	8
4199402	4294548	6	9
21003205	1125315	0	0
21002822	1112807	0	0
35507661	1112807	0	0
36203062	40479422	5	9
36159298	1125315	0	0
36500000	40486433	7	7
42805720	1307863	0	0
44352523	19078461	2	3
44338045	1119510	0	0
44353456	1119510	0	0
45643341	1119510	0	0
45656508	1367571	0	0
45662069	1125315	0	0
45667837	1119510	0	0
45665794	914335	0	0
45630575	1129625	0	0
45683257	19075601	2	3
45689275	1129625	0	0
45677791	1125315	0	0
45692887	46275916	1	1
45684735	19078461	2	3
45802567	967823	0	0
45691036	1759842	0	0
45896701	1713671	2	3
45788063	791967	0	0
46243370	1125315	0	0
46242380	19079524	2	3
45801205	1115171	2	3
46318452	1119510	0	0
46313826	1119510	0	0
441840	192671	2	7
4199402	4001336	6	8
21003220	1000560	0	0
21002811	1118084	0	0
35507479	1107830	0	0
36200000	4230399	5	11
36159235	1125315	0	0
36500000	317576	7	7
42902788	1310034	0	0
44353090	19078461	2	3
44338048	1119510	0	0
44353460	1119510	0	0
45643500	1119510	0	0
45656509	1309944	0	0
45662101	1125315	0	0
45667596	1119510	0	0
45665804	742185	0	0
45630582	1129625	0	0
45676407	40228214	2	3
45691624	1129625	0	0
45674401	1125315	0	0
45690025	46275916	1	1
45691035	19078461	2	3
45802585	1738521	0	0
45691039	1309944	0	0
45799698	19073183	2	3
45787972	1124957	0	0
46243332	1125315	0	0
45896077	19078461	2	3
45802355	19076374	2	3
46318454	1119510	0	0
46313798	1119510	0	0
1125443	19029476	2	3
4199402	4152936	6	8
21003250	1124300	0	0
21002827	1118084	0	0
35507482	1729720	0	0
36200000	4109685	5	9
36159130	1125315	0	0
36500000	134438	7	7
42902852	40224132	0	0
44359077	19078461	2	3
45619873	1119510	0	0
44353430	1119510	0	0
45643614	1119510	0	0
45656510	19127890	0	0
45662014	1125315	0	0
45668017	1119510	0	0
45665614	933724	0	0
45627588	1129625	0	0
45778723	19079524	2	3
45689697	1129625	0	0
45674005	1125315	0	0
45690088	46275916	1	1
45684614	40174880	2	3
45802389	1153428	0	0
45691089	1115008	0	0
46242289	1107882	2	3
45788104	1545958	0	0
46243320	1125315	0	0
45791529	19078461	2	3
45802515	40229134	2	3
46318574	1119510	0	0
46313687	1119510	0	0
920293	920334	2	3
4199402	261325	6	8
21003251	933724	0	0
21002839	1551099	0	0
35507485	1125315	0	0
36200000	4152936	5	10
36159131	1125315	0	0
36500000	40479768	6	11
42806840	1738521	0	0
44345088	19078461	2	3
45619849	1119510	0	0
44353649	1119510	0	0
45643631	1119510	0	0
45656510	1549786	0	0
45662173	1125315	0	0
45667861	1119510	0	0
45665615	967823	0	0
45627686	1129625	0	0
45780900	40228214	2	3
45689676	1129625	0	0
45674157	1125315	0	0
45688740	19079524	1	1
45700037	19078461	2	3
45802538	1149196	0	0
45691102	753626	0	0
45801071	46233710	2	3
45788051	1309944	0	0
46243416	1125315	0	0
45791216	19075601	2	3
45802406	19078461	2	3
46318534	1119510	0	0
46313725	1119510	0	0
4042650	4024289	2	3
4199402	81151	7	8
21003348	914335	0	0
21002813	975125	0	0
35507485	738818	0	0
21604344	1127078	0	3
36159343	1125315	0	0
36500000	40479422	6	11
42806978	1124957	0	0
44359352	19078461	2	3
45619886	1119510	0	0
44353419	1119510	0	0
45640743	1119510	0	0
45656450	1768849	0	0
45662269	1125315	0	0
45667249	1119510	0	0
45665904	1154343	0	0
45624613	1129625	0	0
45707824	19079524	2	3
45686779	1129625	0	0
45674282	1125315	0	0
45688519	19079524	1	1
45699731	19078461	2	3
45802402	1521369	0	0
45691188	1539403	0	0
45786045	19078461	2	3
45788219	1124957	0	0
46243468	1125315	0	0
45791068	19075601	2	3
45802939	1125315	0	0
46318677	1119510	0	0
46314041	1119510	0	0
4024656	4108705	2	3
4199402	4134304	7	8
21003119	1129625	0	0
21002844	1115008	0	0
35507485	1119510	0	0
21604344	1127433	0	3
36159293	1125315	0	0
36500000	78272	5	11
42806983	1129625	0	0
44362856	19078461	2	3
45620127	1119510	0	0
44353544	1119510	0	0
45640970	1119510	0	0
45656586	1149196	0	0
45662337	1125315	0	0
45665590	1119510	0	0
45665820	1149196	0	0
45624620	1129625	0	0
45676847	40228214	2	3
45686455	1129625	0	0
45674408	1125315	0	0
45683758	19079524	1	1
45684591	19078461	2	3
45802539	1115008	0	0
45690982	1110410	0	0
45798523	1107882	2	3
45788226	1174888	0	0
46243345	1125315	0	0
45798740	19075601	2	3
45802949	1125315	0	0
46318889	1119510	0	0
46314360	1119510	0	0
4165549	4198190	2	3
4199402	196456	7	7
21002691	1149380	0	0
21002844	1112807	0	0
35507641	1713332	0	0
35205189	4329847	0	0
36159212	1125315	0	0
36500000	4296204	5	8
42807194	1738521	0	0
44345523	19078461	2	3
45620213	1119510	0	0
44353666	1119510	0	0
45640729	1119510	0	0
45656371	1149196	0	0
45662050	1125315	0	0
45665680	1119510	0	0
45666022	1124300	0	0
45624451	1129625	0	0
45780810	19078461	2	3
45686693	1129625	0	0
45676229	1125315	0	0
45671438	19079524	1	1
45706494	19078461	2	3
45802540	914335	0	0
45690909	975125	0	0
46240804	1557272	0	0
45788262	1501700	0	0
46243348	1125315	0	0
46293961	19075601	2	3
45803213	1125315	0	0
46319028	1119510	0	0
46314363	1119510	0	0
201618	4166224	2	3
4199402	4266809	7	7
21002690	975125	0	0
21002845	975125	0	0
35507757	1000560	0	0
35204966	321042	0	0
36159404	1125315	0	0
36500000	4048171	8	8
42807022	705944	0	0
44362819	19078461	2	3
45620054	1119510	0	0
44353881	1119510	0	0
45640996	1119510	0	0
45656562	1332418	0	0
45662052	1125315	0	0
45665633	1119510	0	0
45666201	1332418	0	0
45624685	1129625	0	0
45685403	40228214	2	3
45686731	1129625	0	0
45676260	1125315	0	0
45688731	19079524	1	1
45685015	19078461	2	3
45802574	791967	0	0
45691285	1149196	0	0
46240805	1549786	0	0
45788239	1107830	0	0
46243419	1125315	0	0
45793390	19075601	2	3
45802957	1125315	0	0
46319097	1119510	0	0
46313849	1119510	0	0
1310149	40163554	2	3
4199402	375671	7	9
21002692	1149380	0	0
21002744	43012036	2	3
35507885	1759842	0	0
35204966	4324181	0	0
36159418	1125315	0	0
36500000	4113008	8	8
42806883	933724	0	0
44356177	19078461	2	3
45620067	1119510	0	0
44353519	1119510	0	0
45640984	1119510	0	0
45656259	1545958	0	0
45662210	1125315	0	0
45663134	1119510	0	0
45666053	1501700	0	0
45668467	1129625	0	0
45674073	40228214	2	3
45686985	1129625	0	0
45674414	1125315	0	0
45699218	19079524	1	1
45699721	19078461	2	3
45802632	1154343	0	0
45691259	1149196	0	0
46240805	1521369	0	0
45788241	1115008	0	0
46243479	1125315	0	0
45801511	19075601	2	3
45803069	1125315	0	0
46318776	1119510	0	0
46314068	1119510	0	0
1309944	1310034	2	3
4117930	313217	6	9
21002691	975125	0	0
21002744	19112599	2	3
35507885	1713332	0	0
35205160	317576	0	0
36159162	1125315	0	0
36500000	4152936	8	10
42807280	1738521	0	0
44345484	19078461	2	3
44361622	1119510	0	0
44353815	1119510	0	0
45641072	1119510	0	0
45656261	1115008	0	0
45662544	1125315	0	0
45663231	1119510	0	0
45666057	1713332	0	0
45668913	1129625	0	0
45686448	19078461	2	3
45687035	1129625	0	0
45674472	1125315	0	0
45702227	46275916	1	1
45780474	19078461	2	3
45802570	1192710	0	0
45691020	1115008	0	0
46240805	19127890	0	0
45788242	1549786	0	0
46243481	1125315	0	0
45791119	19075601	2	3
45803205	1125315	0	0
46313174	1119510	0	0
46314075	1119510	0	0
705944	40236446	2	3
4117930	4266809	6	6
21002322	1741122	0	0
21002744	40232448	2	3
35507888	1154343	0	0
21604086	19003953	0	0
36159174	1125315	0	0
36500000	4230399	5	10
42806991	1549786	0	0
44345401	19078461	2	3
44341469	1125315	0	0
44353939	1119510	0	0
45640935	1119510	0	0
45656593	1000560	0	0
45662260	1125315	0	0
45663184	1119510	0	0
45666059	738818	0	0
45668957	1129625	0	0
45695178	40228214	2	3
45683560	1129625	0	0
45674547	1125315	0	0
45702227	19079524	1	1
45782796	19078461	2	3
45688448	1501700	0	0
45691027	1551099	0	0
46240917	705944	0	0
45788272	1548195	0	0
46240852	1125315	0	0
46243684	19075601	2	3
45803313	1125315	0	0
46313177	1119510	0	0
46314372	1119510	0	0
1589505	1718412	2	3
4117930	255848	6	6
21002299	920293	0	0
21505757	40222846	2	3
35507890	1119510	0	0
21603967	1177480	0	0
36159369	1125315	0	0
36500000	4149245	4	10
42806991	1512674	0	0
44338115	19078461	2	3
45619689	1125315	0	0
44346021	1119510	0	0
45641047	1119510	0	0
45656467	1551099	0	0
45658830	1125315	0	0
45663347	1119510	0	0
45666064	1778162	0	0
45666636	1129625	0	0
45778587	1539411	2	3
45683708	1129625	0	0
45674432	1125315	0	0
45695379	19079524	1	1
45699922	19078461	2	3
45688456	933724	0	0
45691028	1310149	0	0
46241039	1000560	0	0
45788273	1115008	0	0
46240858	1125315	0	0
46238966	19075601	2	3
45803288	1125315	0	0
46312710	1119510	0	0
46314264	1119510	0	0
1589505	46221626	2	3
4117930	260139	6	6
21002321	1717327	0	0
21013432	19129655	2	3
35507873	1112807	0	0
21603968	1115008	0	0
36159543	1125315	0	0
36500000	4146173	4	10
42807242	1177480	0	0
44352684	1545959	2	3
45619706	1125315	0	0
44346190	1119510	0	0
45640939	1119510	0	0
45656472	1332418	0	0
45659078	1125315	0	0
45663358	1119510	0	0
45665665	738818	0	0
45666712	1129625	0	0
45676880	40228214	2	3
45683801	1129625	0	0
45674507	1125315	0	0
45689807	19079524	1	1
45780113	19078461	2	3
45688457	1112807	0	0
45691030	920293	0	0
46241025	1192710	0	0
45788254	1713332	0	0
46241050	1125315	0	0
45896210	19075601	2	3
45803390	1125315	0	0
46312960	1119510	0	0
46314535	1119510	0	0
723013	19076374	2	3
4117930	196456	6	6
21002321	1713332	0	0
21004223	19073188	2	3
35507820	1332418	0	0
21603980	1177480	0	0
36159363	1125315	0	0
36500000	81151	4	10
42807303	708298	0	0
44348791	1539411	2	3
45621554	1125315	0	0
44346195	1119510	0	0
45640822	1119510	0	0
45656042	1322184	0	0
45658967	1125315	0	0
45663405	1119510	0	0
45665668	1154029	0	0
45664247	1129625	0	0
45676880	40228230	2	3
45683781	1129625	0	0
45674436	1125315	0	0
45692707	19079524	1	1
45685101	19078461	2	3
45688459	1174888	0	0
45691343	1343916	0	0
46240975	1738521	0	0
45788159	1192710	0	0
46242537	1125315	0	0
46296697	40228214	2	3
45803392	1125315	0	0
46312697	1119510	0	0
46314592	1119510	0	0
715997	40223768	2	3
4117930	4056621	5	6
21002325	920293	0	0
21004223	19073183	2	3
35507901	1125315	0	0
21603312	1154343	0	0
36159488	1125315	0	0
36500000	4109685	8	9
42807306	1548195	0	0
44341723	40174880	2	3
45621608	1125315	0	0
44346153	1119510	0	0
45637669	1119510	0	0
45656615	1738521	0	0
45659083	1125315	0	0
45663373	1119510	0	0
45665925	1110410	0	0
45664254	1129625	0	0
45633061	40228214	2	3
45683850	1129625	0	0
45674525	1125315	0	0
45686763	19079524	1	1
45694103	19078461	2	3
45688282	1500211	0	0
45691355	1332418	0	0
46240985	1000560	0	0
45788201	1343916	0	0
46242546	1125315	0	0
45896200	19075601	2	3
45803400	1125315	0	0
46312605	1119510	0	0
46314551	1119510	0	0
715997	45892894	2	3
4117930	4310024	5	6
21002325	1717327	0	0
21004232	19073188	2	3
35507967	1551099	0	0
36156685	723013	0	0
36159489	1125315	0	0
36500000	4048695	4	9
42806922	1125315	0	0
44352675	1332419	2	3
45621610	1125315	0	0
44346258	1119510	0	0
45637847	1119510	0	0
45656594	1501700	0	0
45659085	1125315	0	0
45663194	1119510	0	0
45666109	1551099	0	0
45664263	1129625	0	0
45778886	1539411	2	3
45684060	1129625	0	0
45671471	1125315	0	0
45670075	19079524	1	1
45702971	19078461	2	3
45688542	1713332	0	0
45691316	1307863	0	0
46240988	1729720	0	0
45788324	1115008	0	0
46242486	1125315	0	0
46242374	40223768	2	3
45803130	1125315	0	0
46313148	1119510	0	0
46314567	1119510	0	0
1305058	19007333	2	3
4117930	45769019	5	6
21002325	1746114	0	0
21004232	19073183	2	3
35507968	967823	0	0
36156591	1501700	0	0
36159500	1125315	0	0
36500000	4035415	4	9
42806879	1125315	0	0
44352780	1539411	2	3
45621666	1125315	0	0
44346160	1119510	0	0
45637687	1119510	0	0
45656378	967823	0	0
45659091	1125315	0	0
45663456	1119510	0	0
45666038	1149196	0	0
45664269	1129625	0	0
45688968	40228214	2	3
45680702	1129625	0	0
45671604	1125315	0	0
45671618	19079524	1	1
45690729	1332419	2	3
45688640	975125	0	0
45691167	723013	0	0
46241100	705944	0	0
45788330	1500211	0	0
46242163	1125315	0	0
46244832	40228214	2	3
45803384	1125315	0	0
46313150	1119510	0	0
46314582	1119510	0	0
1308738	964261	2	3
4117930	4329847	5	8
21002227	926487	0	0
21004635	46275444	2	3
35507780	1125315	0	0
36156592	1713332	0	0
36159320	1125315	0	0
36500000	133834	9	9
42806879	1174888	0	0
44359432	1539411	2	3
45621696	1125315	0	0
44346310	1119510	0	0
45637889	1119510	0	0
45656543	1124957	0	0
45659118	1125315	0	0
45663459	1119510	0	0
45666095	1539403	0	0
45664368	1129625	0	0
45781100	40228214	2	3
45680750	1129625	0	0
45671642	1125315	0	0
45701784	46275916	1	1
45699900	1332419	2	3
45688528	1192710	0	0
45691384	1149196	0	0
46241110	1124957	0	0
45788116	1539403	0	0
46242166	1125315	0	0
45875959	40758406	2	3
45803326	1125315	0	0
46312928	1119510	0	0
46314674	1119510	0	0
975125	19008572	2	3
4117930	4116491	5	5
21001798	1746114	0	0
21004635	19129655	2	3
21604271	1102527	0	0
36156691	1343916	0	0
36159572	1125315	0	0
36313966	4280726	4	11
42807110	701322	0	0
44786893	3013682	1	1
45621717	1125315	0	0
44346228	1119510	0	0
45637909	1119510	0	0
45656241	1713332	0	0
45658979	1125315	0	0
45663596	1119510	0	0
45666190	1551099	0	0
45664548	1129625	0	0
45779076	19079524	2	3
45680763	1129625	0	0
45671647	1125315	0	0
45692911	19079524	1	1
45678678	1332419	2	3
45800047	1000560	0	0
45691129	975125	0	0
46241111	975125	0	0
45788082	1713332	0	0
46242170	1125315	0	0
45804315	40228214	2	3
45803075	1125315	0	0
46312932	1119510	0	0
46314686	1119510	0	0
967823	19079524	2	3
4117930	261325	5	7
21001801	1717327	0	0
21004233	19073183	2	3
21604272	1154029	0	0
36156692	1343916	0	0
36159584	1125315	0	0
36313966	257012	4	10
42807159	1125315	0	0
44786911	3016723	1	1
45619802	1125315	0	0
44346465	1119510	0	0
45637700	1119510	0	0
45656243	1343916	0	0
45658981	1125315	0	0
45659665	1119510	0	0
45666195	1361711	0	0
45661113	1129625	0	0
45695206	40228214	2	3
45680721	1129625	0	0
45671648	1125315	0	0
45695666	19079524	1	1
45703055	1332419	2	3
45799993	1192710	0	0
45691181	1107830	0	0
46240641	738818	0	0
45788081	1367571	0	0
46242490	1125315	0	0
45801573	40228214	2	3
45803079	1125315	0	0
46313223	1119510	0	0
46314340	1119510	0	0
4042646	4186930	3	3
4117930	321042	5	7
21001796	1759842	0	0
21004233	19073188	2	3
21603404	1119510	0	0
36156784	1119510	0	0
36159152	1125315	0	0
36313966	40479422	8	11
42807159	1124957	0	0
44359617	19074679	1	1
45619744	1125315	0	0
44346267	1119510	0	0
45634696	1119510	0	0
45656245	1343916	0	0
45659193	1125315	0	0
45659917	1119510	0	0
45666166	1149196	0	0
45661114	1129625	0	0
45778624	40228214	2	3
45680743	1129625	0	0
45671599	1125315	0	0
45708101	19079524	1	1
45684876	40174880	2	3
45799791	1149196	0	0
45691174	1192710	0	0
46240642	1107830	0	0
45788231	1332418	0	0
46242494	1125315	0	0
45787962	19079524	2	3
45800456	1125315	0	0
46313074	1119510	0	0
46315024	1119510	0	0
201618	440448	3	3
4117930	4166224	7	8
21001801	1713332	0	0
21601121	964261	2	3
21603398	1174888	0	0
36156787	1118084	0	0
36159585	1125315	0	0
36313966	4144583	8	8
42807198	1309944	0	0
44353136	46275916	1	1
45619820	1125315	0	0
44346383	1119510	0	0
45634669	1119510	0	0
45658433	723013	0	0
45659316	1125315	0	0
45659845	1119510	0	0
45666042	1153428	0	0
45661323	1129625	0	0
45698368	40228214	2	3
45677360	1129625	0	0
45671575	1125315	0	0
45677461	19079524	1	1
45876002	3008598	1	1
45800082	757627	0	0
45688744	1124957	0	0
46238197	1549786	0	0
45788363	1149196	0	0
46242362	1125315	0	0
46239324	40228214	2	3
45800485	1125315	0	0
46313236	1119510	0	0
46308793	1119510	0	0
254068	40481087	3	3
4117930	440448	8	8
21001801	1768849	0	0
21004633	19129655	2	3
21601747	1332418	0	0
36156768	1129625	0	0
36159597	1125315	0	0
36313966	4218389	5	7
42807203	1738521	0	0
44345292	19127922	1	1
44360997	1125315	0	0
44346644	1119510	0	0
45634673	1119510	0	0
45658355	1332418	0	0
44341743	1125315	0	0
45659846	1119510	0	0
45666199	1521369	0	0
45661278	1129625	0	0
45707695	40223768	2	3
45677404	1129625	0	0
45671629	1125315	0	0
45699186	19079524	1	1
45697275	19079524	1	1
45800056	1107830	0	0
45688381	967823	0	0
46238197	19127890	0	0
45788365	1124957	0	0
46241203	1125315	0	0
46238882	40228214	2	3
45800470	1125315	0	0
46307767	1119510	0	0
46308992	1119510	0	0
254068	28060	3	3
4042150	4198190	8	8
21001802	1713332	0	0
21002491	19019979	2	3
35507961	1551099	0	0
36156772	1119510	0	0
36159614	1125315	0	0
36313966	4051466	5	6
42807011	1595799	0	0
44345292	19133679	1	1
44360998	1125315	0	0
44339012	1119510	0	0
45634802	1119510	0	0
45658363	738818	0	0
44357596	1125315	0	0
45659868	1119510	0	0
45666049	1192710	0	0
45654793	1129625	0	0
45704551	40228214	2	3
45677607	1129625	0	0
45671540	1125315	0	0
45701653	46275916	1	1
45675904	19079524	1	1
45800090	1343916	0	0
45688020	1124957	0	0
46233988	46233988	0	0
45788082	1759842	0	0
46241209	1125315	0	0
45896664	19078461	2	3
45800518	1125315	0	0
46307833	1119510	0	0
46309421	1119510	0	0
254068	257012	3	3
1332450	1332419	1	1
21001801	1741122	0	0
21002491	1127078	2	3
35507929	740275	0	0
36156780	1119510	0	0
36159615	1125315	0	0
36313966	4174876	5	6
42807011	1521369	0	0
44345292	19129144	1	1
44360940	1125315	0	0
44339235	1119510	0	0
45634808	1119510	0	0
45658367	1343916	0	0
44357916	1125315	0	0
45649369	1129625	0	0
45665760	914335	0	0
45635062	1112807	0	0
45669478	40223768	2	3
45677326	1129625	0	0
45673015	1125315	0	0
45701653	19079524	1	1
45675920	19079524	1	1
45800200	975125	0	0
45688068	1000560	0	0
46240075	1112807	0	0
45788084	1595799	0	0
46241297	1125315	0	0
45896332	40228214	2	3
45800525	1125315	0	0
46307504	1119510	0	0
46308948	1119510	0	0
4024567	4051466	3	3
1322187	19075601	1	1
21001801	1759842	0	0
21004493	19129655	2	3
35507934	967823	0	0
36156619	1307863	0	0
36151146	1125315	0	0
36313966	30753	5	9
42807011	1549786	0	0
44362889	1153428	0	0
44361446	1125315	0	0
44339121	1119510	0	0
45634419	1119510	0	0
45658413	914335	0	0
44357894	1125315	0	0
45649441	1129625	0	0
45665762	1174888	0	0
45635103	1112807	0	0
45698744	40228214	2	3
45677533	1129625	0	0
45673147	1125315	0	0
45686755	19079524	1	1
45672963	19079524	1	1
45800202	1107830	0	0
45688115	1174888	0	0
46240076	1549786	0	0
45788084	1521369	0	0
46241248	1125315	0	0
46239578	40228214	2	3
45800492	1125315	0	0
46307508	1119510	0	0
46308896	1119510	0	0
4101796	381316	3	3
1539465	1539411	1	1
21001801	1746114	0	0
21002154	46275444	2	3
35507935	967823	0	0
36156620	967823	0	0
36151289	1125315	0	0
36313966	4035415	5	9
42807012	738818	0	0
44362962	1112807	0	0
44361373	1125315	0	0
44339125	1119510	0	0
45634552	1119510	0	0
45658376	1778162	0	0
44358058	1125315	0	0
45631774	1129625	0	0
45665887	738818	0	0
45635056	1112807	0	0
45676918	40223768	2	3
45677713	1129625	0	0
45673354	1125315	0	0
45692894	19079524	1	1
45675848	19079524	1	1
45800204	1149196	0	0
45688040	1545958	0	0
46240076	1512674	0	0
45788084	1549786	0	0
46241375	1125315	0	0
46239080	40228214	2	3
45800635	1125315	0	0
46307863	1119510	0	0
46309229	1119510	0	0
4011630	4029498	3	3
753630	40220386	1	1
21001801	1778162	0	0
21001950	46233710	2	3
35507976	1738521	0	0
36156298	1119510	0	0
36151282	1125315	0	0
36313966	4132546	5	9
42807063	1551099	0	0
44363068	1177480	0	0
44361372	1125315	0	0
44339023	1119510	0	0
45636907	1119510	0	0
45658417	1102527	0	0
44357717	1125315	0	0
45632049	1129625	0	0
45666257	1713332	0	0
45635085	1112807	0	0
45781241	19078461	2	3
45677480	1129625	0	0
45673318	1125315	0	0
45699045	19079524	1	1
45681043	19079524	1	1
45800213	975125	0	0
45688044	1332418	0	0
46239971	1107830	0	0
45788208	715997	0	0
46241282	1125315	0	0
46294109	40228214	2	3
45800638	1125315	0	0
46307864	1119510	0	0
46309119	1119510	0	0
4028074	4134304	3	3
1137537	40169281	1	1
21001804	1778162	0	0
21001950	46233988	2	3
35507978	1177480	0	0
36156232	1000560	0	0
36152163	1125315	0	0
36313966	380378	5	8
42807064	1778162	0	0
44362900	1154343	0	0
44361542	1125315	0	0
44339025	1119510	0	0
45637120	1119510	0	0
45658426	1713332	0	0
44357760	1125315	0	0
45632016	1129625	0	0
45666257	1759842	0	0
45635164	1112807	0	0
45683530	19078461	2	3
45677781	1129625	0	0
45673266	1125315	0	0
45680848	46275916	1	1
45676089	19079524	1	1
45800215	1778162	0	0
45688160	1322184	0	0
46240073	757627	0	0
45788337	1713332	0	0
46241229	1125315	0	0
45791253	19079524	2	3
45800561	1125315	0	0
46307935	1119510	0	0
46309334	1119510	0	0
252662	260139	3	3
1000599	35605482	1	1
21001802	1759842	0	0
21001692	40163554	2	3
35507590	1177480	0	0
36156398	975125	0	0
36152284	1125315	0	0
36313966	381316	5	8
42807176	1115008	0	0
44363088	1112807	0	0
44361547	1125315	0	0
44339263	1119510	0	0
45631644	1119510	0	0
45658447	1174888	0	0
44357910	1125315	0	0
45632226	1129625	0	0
45666260	1501700	0	0
45635137	1112807	0	0
45669673	40223768	2	3
45674401	1129625	0	0
45673101	1125315	0	0
45680848	19079524	1	1
45694310	19079524	1	1
45800221	1115008	0	0
45688126	1124957	0	0
46239987	1112807	0	0
45788337	1759842	0	0
46241269	1125315	0	0
46294544	40228214	2	3
45800531	1125315	0	0
46307718	1119510	0	0
46309256	1119510	0	0
201820	4144583	3	3
25297	4112343	1	1
21001802	1717327	0	0
21004386	1551192	2	3
35508001	1125315	0	0
35506945	1322184	0	0
36152391	1125315	0	0
36313966	378419	5	10
42806885	1310149	0	0
44363093	1107830	0	0
44361662	1125315	0	0
44339580	1119510	0	0
45631618	1119510	0	0
45656650	1551099	0	0
44357992	1125315	0	0
45634096	1129625	0	0
45666271	1115008	0	0
45635390	1112807	0	0
45677126	19078461	2	3
45674284	1129625	0	0
45671670	1125315	0	0
45701931	19079524	1	1
45703277	46275916	1	1
45800174	708298	0	0
45688165	1539403	0	0
46239987	1124957	0	0
46293988	1310149	0	0
46241272	1125315	0	0
46238179	40228214	2	3
45800694	1125315	0	0
46307726	1119510	0	0
46309183	1119510	0	0
260131	261325	3	3
1127495	1127078	1	1
21001804	1768849	0	0
21004634	19129655	2	3
35508049	715997	0	0
35506947	1589505	0	0
36151398	1125315	0	0
36313966	4152936	5	10
42807275	1545958	0	0
44362983	1115008	0	0
44361702	1125315	0	0
44339454	1119510	0	0
45631466	1119510	0	0
45656640	1115008	0	0
44357863	1125315	0	0
45634211	1129625	0	0
45665725	967823	0	0
45629980	1112807	0	0
45779055	19078461	2	3
45674394	1129625	0	0
45671663	1125315	0	0
45701931	46275916	1	1
45703277	19079524	1	1
45800188	1548195	0	0
45688319	1149196	0	0
46239990	1192710	0	0
46294014	975125	0	0
46241391	1125315	0	0
45893588	40228214	2	3
45800545	1125315	0	0
46308217	1119510	0	0
46309434	1119510	0	0
260131	258780	3	3
920335	920300	1	1
21001806	1717327	0	0
21001874	1551192	2	3
35102374	439777	2	2
35506824	1119510	0	0
36151458	1125315	0	0
36313966	4294548	5	11
42807276	1512674	0	0
44362914	1124957	0	0
44361579	1125315	0	0
44339588	1119510	0	0
45631651	1119510	0	0
45656632	1124300	0	0
44358095	1125315	0	0
45628972	1129625	0	0
45666089	791967	0	0
45630166	1112807	0	0
45677191	19078461	2	3
45674404	1129625	0	0
45669946	1125315	0	0
45702201	19079524	1	1
45697526	19079524	1	1
45799908	975125	0	0
45688321	1174888	0	0
46240041	1332418	0	0
46294020	1326303	0	0
46238440	1125315	0	0
45894123	19078461	2	3
45800720	1125315	0	0
46308266	1119510	0	0
46309472	1119510	0	0
437409	375671	3	3
440059	4280726	1	1
21001804	1713332	0	0
21001909	1551192	2	3
35102391	4280726	2	2
35506829	705944	0	0
36151496	1125315	0	0
36313966	4112343	5	11
42807276	19127890	0	0
44362916	1115008	0	0
44361677	1125315	0	0
44360451	1119510	0	0
45631806	1119510	0	0
45652901	1343916	0	0
44357874	1125315	0	0
45629049	1129625	0	0
45666244	715997	0	0
45627110	1112807	0	0
45695240	19078461	2	3
45674547	1129625	0	0
45669956	1125315	0	0
45674516	19079524	1	1
45700439	19079524	1	1
45800063	1112807	0	0
45688323	920293	0	0
46240047	967823	0	0
46293927	1738521	0	0
46238327	1125315	0	0
45796482	19079524	2	3
45800735	1125315	0	0
46308280	1119510	0	0
46309192	1119510	0	0
437409	378001	3	3
317009	4051466	1	1
21001804	1717327	0	0
21001912	1551192	2	3
35104392	4056621	2	2
35506818	1119510	0	0
36151602	1125315	0	0
36313966	4285898	5	12
42807276	1549786	0	0
44362919	1305058	0	0
44361269	1125315	0	0
44360453	1119510	0	0
45631782	1119510	0	0
45652908	1501700	0	0
44357975	1125315	0	0
45629050	1129625	0	0
45666168	1717327	0	0
45627511	1112807	0	0
45695276	19078461	2	3
45674529	1129625	0	0
45669979	1125315	0	0
45674413	46275916	1	1
45694233	19079524	1	1
45800354	975125	0	0
45688333	1115008	0	0
46240128	1000560	0	0
46293933	1115008	0	0
46238395	1125315	0	0
45893841	19078461	2	3
45800507	1125315	0	0
46307917	1119510	0	0
46309394	1119510	0	0
4013518	439777	3	3
318443	317576	1	1
21001806	1778162	0	0
21001903	1551192	2	3
21604186	782043	2	2
35506822	1501700	0	0
36151472	1125315	0	0
36313966	40486433	6	11
42807047	1549786	0	0
44362995	738818	0	0
44361277	1125315	0	0
44360582	1119510	0	0
45631736	1119510	0	0
45653050	1118084	0	0
44358075	1125315	0	0
45627886	1129625	0	0
45666250	1000560	0	0
45624044	1112807	0	0
45778634	19078461	2	3
45674578	1129625	0	0
45669983	1125315	0	0
45674413	19079524	1	1
45703381	19079524	1	1
45800359	1521369	0	0
45688194	975125	0	0
46240165	1729720	0	0
46293662	1551099	0	0
46238397	1125315	0	0
46239526	40228214	2	3
45800593	1125315	0	0
46308291	1119510	0	0
46309396	1119510	0	0
4148091	440086	3	3
256440	4283893	1	1
21001808	1746114	0	0
21001850	19075001	2	3
21604186	19039298	2	2
35506959	1119510	0	0
36151502	1125315	0	0
36313966	4156265	6	9
42807047	19127890	0	0
44363103	1174888	0	0
44360965	1125315	0	0
44360509	1119510	0	0
45632199	1119510	0	0
45653053	967823	0	0
44358082	1125315	0	0
45628009	1129625	0	0
45666254	1174888	0	0
45624136	1112807	0	0
45778617	19078461	2	3
45671555	1129625	0	0
45670155	1125315	0	0
45680835	19079524	1	1
45681060	19079524	1	1
45800359	19127890	0	0
45688203	1192710	0	0
46238234	1332418	0	0
46294131	1174888	0	0
46238502	1125315	0	0
46298769	40228214	2	3
45800699	1125315	0	0
46308179	1119510	0	0
46303659	1119510	0	0
4087571	4107731	3	3
140708	4066995	1	1
21001809	1746114	0	0
21001841	19075001	2	3
21604186	19002770	2	2
35506963	1177480	0	0
36151488	1125315	0	0
36313966	255848	6	9
42807047	1512674	0	0
44363243	738818	0	0
44361476	1125315	0	0
44360896	1119510	0	0
45632200	1119510	0	0
45653058	1107830	0	0
44358028	1125315	0	0
45626119	1129625	0	0
45666175	738818	0	0
45624186	1112807	0	0
45698267	19078461	2	3
45673346	1129625	0	0
45670157	1125315	0	0
45655021	46275916	1	1
45681060	46275916	1	1
45800359	1549786	0	0
45688205	1174888	0	0
46238238	1115008	0	0
46293776	975125	0	0
46238507	1125315	0	0
45791026	40228214	2	3
45800711	1125315	0	0
46308438	1119510	0	0
46306393	1119510	0	0
253549	80502	3	3
24818	4218389	1	1
21001806	1759842	0	0
21001741	19075001	2	3
35102392	4280726	2	2
35506838	1729720	0	0
36151454	1125315	0	0
36313966	28060	6	9
42807051	705944	0	0
44363026	1174888	0	0
44361304	1125315	0	0
44360697	1119510	0	0
45632152	1119510	0	0
45653040	791967	0	0
44358234	1125315	0	0
45626139	1129625	0	0
45666183	1000560	0	0
45624190	1112807	0	0
45669563	19078461	2	3
45669916	1129625	0	0
45670013	1125315	0	0
45655021	19079524	1	1
45673095	19079524	1	1
45800326	1174888	0	0
45688240	1343916	0	0
46238244	1107830	0	0
46293779	1192710	0	0
46238508	1125315	0	0
46291786	19079524	1	1
45800808	1125315	0	0
46308427	1119510	0	0
46307005	1119510	0	0
253549	4035415	3	3
31610	30753	1	1
21001809	1778162	0	0
21001860	46275916	2	3
35102395	4280726	2	2
35506841	975125	0	0
36151646	1125315	0	0
36313966	4048695	6	10
42806895	1343916	0	0
44363029	1149380	0	0
44361347	1125315	0	0
44360673	1119510	0	0
45628600	1119510	0	0
45652832	1310149	0	0
44358237	1125315	0	0
45626205	1129625	0	0
45663605	1107830	0	0
45624247	1112807	0	0
45780908	19078461	2	3
45783716	1129625	0	0
45669916	1125315	0	0
45684194	19079524	1	1
45703626	19079524	1	1
45800128	723013	0	0
45688244	1174888	0	0
46238216	1713332	0	0
46293780	1115008	0	0
46238532	1125315	0	0
46289784	19079524	1	1
45800814	1125315	0	0
46308413	1119510	0	0
46306477	1119510	0	0
4012176	4125906	3	3
73571	40480160	1	1
21001626	1112807	0	0
21013627	1551192	2	3
35102398	4280726	2	2
35506842	705944	0	0
36151607	1125315	0	0
36313966	321042	6	10
42807263	933724	0	0
44363031	740275	0	0
44361306	1125315	0	0
44360606	1119510	0	0
45628602	1119510	0	0
45652919	1322184	0	0
44358150	1125315	0	0
45626210	1129625	0	0
45663619	1149196	0	0
45668261	1112807	0	0
45633146	19078461	2	3
45783762	1129625	0	0
45783735	1125315	0	0
45686880	19079524	1	1
45691342	19079524	1	1
45685677	1305058	0	0
45688355	1174888	0	0
46238216	1759842	0	0
46293961	1322184	0	0
46238310	1125315	0	0
46295154	46275916	1	1
45800818	1125315	0	0
46308425	1119510	0	0
46307118	1119510	0	0
4012185	4057420	3	3
73553	80180	1	1
21001630	1332418	0	0
21503326	19008572	2	3
21603821	1500211	0	0
35506843	1177480	0	0
36151424	1125315	0	0
36313966	4146173	6	10
42807269	1548195	0	0
44363228	1115008	0	0
44360980	1125315	0	0
44360885	1119510	0	0
45631044	1119510	0	0
45653016	1174888	0	0
44358161	1125315	0	0
45626418	1129625	0	0
45663636	967823	0	0
45668403	1112807	0	0
45683241	19078461	2	3
45783757	1129625	0	0
45783768	1125315	0	0
45706099	19127918	2	2
45673113	19079524	1	1
45685900	1154343	0	0
45688358	1548195	0	0
46238284	1149196	0	0
46293537	1539403	0	0
46238318	1125315	0	0
46295154	19079524	1	1
45800839	1125315	0	0
46302645	1119510	0	0
46307073	1119510	0	0
4012907	4301346	3	3
75909	80502	1	1
21001654	1322184	0	0
21013411	19074843	2	3
21603058	920293	0	0
35507048	1332418	0	0
36151748	1125315	0	0
36313966	438614	6	7
42807153	1177480	0	0
44363461	1307863	0	0
44361312	1125315	0	0
44361077	1119510	0	0
45628856	1119510	0	0
45653021	738818	0	0
44357746	1125315	0	0
45626141	1129625	0	0
45663643	1332418	0	0
45668436	1112807	0	0
45671301	19078461	2	3
45783849	1129625	0	0
45783701	1125315	0	0
45784715	42902245	2	2
45694597	19079524	1	1
45685845	1367571	0	0
45688422	1557272	0	0
46238272	1115008	0	0
46294059	1192710	0	0
46238320	1125315	0	0
46289245	19079524	1	1
45800643	1125315	0	0
46302551	1119510	0	0
46306624	1119510	0	0
4012907	44783196	3	3
3049150	3006734	1	1
21001589	1361711	0	0
21013411	19073188	2	3
35104074	439777	0	0
35506845	1500211	0	0
36151750	1125315	0	0
36313966	442116	6	7
42807298	701322	0	0
44363246	1112807	0	0
44361494	1125315	0	0
44361169	1119510	0	0
45625742	1119510	0	0
45653171	1124957	0	0
44358266	1125315	0	0
45626327	1129625	0	0
45663649	1107830	0	0
45668594	1112807	0	0
45778596	19078461	2	3
45783794	1129625	0	0
45783825	1125315	0	0
45700048	19128009	2	2
45676122	46275916	1	1
45685852	967823	0	0
45688431	1192710	0	0
46238418	1149380	0	0
46294064	1192710	0	0
46238344	1125315	0	0
45787205	1549786	0	0
45800744	1125315	0	0
46302578	1119510	0	0
46304054	1119510	0	0
4042646	4117038	3	4
3049209	3001247	1	1
21001630	1539403	0	0
21001960	1127433	2	3
21603924	19010482	0	0
35506848	1589505	0	0
36151546	1125315	0	0
36313966	439406	6	7
42807301	1115008	0	0
44363054	1149196	0	0
44361139	1125315	0	0
44361172	1119510	0	0
45626013	1119510	0	0
45652938	1174888	0	0
44358269	1125315	0	0
45626366	1129625	0	0
45663655	1174888	0	0
45666018	1112807	0	0
45707831	19078461	2	3
45783808	1129625	0	0
45783836	1125315	0	0
45700048	19127918	2	2
45679447	19079524	1	1
45685518	914335	0	0
45688177	1107830	0	0
46238428	975125	0	0
46294032	701322	0	0
46238346	1125315	0	0
45787225	1102527	0	0
45797841	1125315	0	0
46302816	1119510	0	0
46304220	1119510	0	0
201618	4285898	3	4
3049209	3006734	1	1
21001626	1322184	0	0
21001960	1127078	2	3
35507285	1000560	0	0
35506942	1177480	0	0
36151551	1125315	0	0
36313966	4139681	6	7
42806968	1153428	0	0
44363104	1177480	0	0
44357373	1125315	0	0
44360828	1119510	0	0
45625883	1119510	0	0
45653120	1110410	0	0
44358187	1125315	0	0
45622799	1129625	0	0
45663382	1778162	0	0
45664612	1112807	0	0
45686327	19078461	2	3
45781455	1129625	0	0
45783881	1125315	0	0
45694152	19128022	2	2
45682130	46275916	1	1
45685302	914335	0	0
45688266	1361711	0	0
46238430	1174888	0	0
46294050	1192710	0	0
46238405	1125315	0	0
45787207	1124957	0	0
45797774	1125315	0	0
46302979	1119510	0	0
46304131	1119510	0	0
1595799	42902245	3	4
3049219	3001247	1	1
21001622	1112807	0	0
21001960	1115171	2	3
35507288	1119510	0	0
35506943	1549786	0	0
36151585	1125315	0	0
36313966	78272	6	12
42806969	1177480	0	0
44363060	1118084	0	0
44357434	1125315	0	0
44338294	1125315	0	0
45625885	1119510	0	0
45653079	738818	0	0
44358193	1125315	0	0
45622808	1129625	0	0
45663768	1000560	0	0
45663945	1112807	0	0
45704930	19078461	2	3
45781709	1129625	0	0
45783753	1125315	0	0
45706783	19008572	2	3
45675824	19079524	1	1
45685305	1174888	0	0
45688180	1332418	0	0
46238433	1713332	0	0
46294109	1149196	0	0
46238352	1125315	0	0
45787228	1521369	0	0
45797647	1125315	0	0
46303295	1119510	0	0
46304261	1119510	0	0
4020346	4278672	3	4
3050400	3006734	1	1
21001626	1310149	0	0
21002145	46275444	2	3
35507258	1539403	0	0
35506943	1512674	0	0
36151592	1125315	0	0
36313966	375671	7	11
42807004	1000560	0	0
44363212	967823	0	0
44357475	1125315	0	0
44338318	1125315	0	0
45625835	1119510	0	0
45653115	1545958	0	0
44358293	1125315	0	0
45622760	1129625	0	0
45663772	1192710	0	0
45664029	1112807	0	0
45671089	19078461	2	3
45781814	1129625	0	0
45783795	1125315	0	0
45706701	19008572	2	3
45697095	19079524	1	1
45685314	1110410	0	0
45688184	1551099	0	0
46238433	1759842	0	0
46294185	1149196	0	0
46238754	1125315	0	0
45787228	1595799	0	0
45797763	1125315	0	0
46303298	1119510	0	0
46304232	1119510	0	0
3039466	3023103	2	4
3050400	3001247	1	1
21001643	1545958	0	0
21013658	19077572	2	3
35507259	975125	0	0
35507041	1332418	0	0
36151724	1125315	0	0
36313966	4059173	7	10
42807342	1177480	0	0
44363141	967823	0	0
44357482	1125315	0	0
44338280	1125315	0	0
45625676	1119510	0	0
45653152	1308738	0	0
44358132	1125315	0	0
45622880	1129625	0	0
45663787	1192710	0	0
45664143	1112807	0	0
45704736	19078461	2	3
45781729	1129625	0	0
45783808	1125315	0	0
45706858	1115171	2	3
45688255	19079524	1	1
45685318	715997	0	0
45685055	1343916	0	0
46238435	1192710	0	0
46294190	1548195	0	0
46238706	1125315	0	0
45787228	1549786	0	0
45797915	1125315	0	0
46303236	1119510	0	0
46304120	1119510	0	0
254068	4294548	2	4
3050409	3006734	1	1
21001662	1112807	0	0
21001947	19133905	2	3
35507253	1125315	0	0
35506892	1149196	0	0
36151683	1125315	0	0
36313966	81893	7	13
42807215	701322	0	0
44363143	1154343	0	0
44357440	1125315	0	0
44338102	1125315	0	0
45626072	1119510	0	0
45653423	738818	0	0
44358255	1125315	0	0
45621512	1129625	0	0
45663742	1717327	0	0
45661030	1112807	0	0
45671104	19078461	2	3
45781767	1129625	0	0
45783989	1125315	0	0
45705181	19078924	2	3
45703534	46275916	1	1
45685319	1115008	0	0
45685007	1545958	0	0
46238436	1557272	0	0
46293795	1551099	0	0
46238477	1125315	0	0
45787548	967823	0	0
45797714	1125315	0	0
46300280	1119510	0	0
46304155	1119510	0	0
3039459	3000963	4	4
3050409	3001247	1	1
21001655	1310149	0	0
21001947	46233988	2	3
35507256	1119510	0	0
35506898	1129625	0	0
36151850	1125315	0	0
36313966	45769019	7	9
42807216	19127890	0	0
44363147	1500211	0	0
44357486	1125315	0	0
44338375	1125315	0	0
45625773	1119510	0	0
45653425	1174888	0	0
44358118	1125315	0	0
45621857	1129625	0	0
45663700	791967	0	0
45657996	1112807	0	0
45778905	19078461	2	3
45783504	1129625	0	0
45783990	1125315	0	0
45705240	1127433	2	3
45703482	46275916	1	1
45685321	1112807	0	0
45685058	1149196	0	0
46238332	1107830	0	0
46293899	1501700	0	0
46238755	1125315	0	0
45787463	1115008	0	0
45797888	1125315	0	0
46300291	1119510	0	0
46304292	1119510	0	0
4162282	28060	4	4
3050415	3006734	1	1
21001665	1305058	0	0
21001947	19133873	2	3
35507250	1119510	0	0
35506941	1174888	0	0
36198916	1125315	0	0
36302170	81893	9	15
42807216	1549786	0	0
44363149	1551099	0	0
44357555	1125315	0	0
44338482	1125315	0	0
45622841	1119510	0	0
45653530	1154343	0	0
44354504	1125315	0	0
45667278	1129625	0	0
45663706	1110410	0	0
45658147	1112807	0	0
45676634	19078461	2	3
45783568	1129625	0	0
45783993	1125315	0	0
45780010	40229134	2	3
45700298	19079524	1	1
45685351	1746114	0	0
45685062	1310149	0	0
46238333	1557272	0	0
46294114	1332418	0	0
46238491	1125315	0	0
45787710	1549786	0	0
45798025	1125315	0	0
46300293	1119510	0	0
46320081	1119510	0	0
4042640	4337611	4	4
3050415	3001247	1	1
21001669	1305058	0	0
21001947	46233710	2	3
35507250	1125315	0	0
35506904	1149380	0	0
36159654	1125315	0	0
36302170	433125	9	9
42807283	1768849	0	0
44363252	1115008	0	0
44357502	1125315	0	0
44338484	1125315	0	0
45622406	1119510	0	0
45653572	967823	0	0
44354647	1125315	0	0
45667405	1129625	0	0
45663708	1110410	0	0
45657894	1112807	0	0
45669919	19078461	2	3
45779245	1129625	0	0
45781562	1125315	0	0
45780167	19019273	2	3
45700458	19134077	1	1
45685351	1741122	0	0
45685105	1192710	0	0
46238305	1332418	0	0
46294507	742185	0	0
45897432	1125315	0	0
45787710	1515774	0	0
45797704	1125315	0	0
46300386	1119510	0	0
46320362	1119510	0	0
4020347	4134304	4	4
3050420	3006734	1	1
21001653	1367571	0	0
21002821	1127433	2	3
35507250	738818	0	0
35507131	1174888	0	0
36198892	1125315	0	0
36302170	45769019	9	11
42807339	1539403	0	0
44363284	1154343	0	0
44357678	1125315	0	0
44338434	1125315	0	0
45622415	1119510	0	0
45652981	1115008	0	0
44354518	1125315	0	0
45665035	1129625	0	0
45663711	1545958	0	0
45654661	1112807	0	0
45777982	19078461	2	3
45779287	1129625	0	0
45781308	1125315	0	0
45780175	19133768	2	3
45694952	19079524	1	1
45685360	1501700	0	0
45685108	1539403	0	0
46238307	967823	0	0
46294727	1149196	0	0
45897494	1125315	0	0
45787710	19127890	0	0
45797875	1125315	0	0
46300313	1119510	0	0
46320454	1119510	0	0
435742	4116491	4	4
3050426	3001247	1	1
21001661	1551099	0	0
21002821	1127078	2	3
35507290	1125315	0	0
35507108	1119510	0	0
36198837	1125315	0	0
36302170	4219399	9	10
42807340	1000560	0	0
44363337	1149380	0	0
44357702	1125315	0	0
44338503	1125315	0	0
45622416	1119510	0	0
45653357	1595799	0	0
44354528	1125315	0	0
45665355	1129625	0	0
45663799	1539403	0	0
45654597	1112807	0	0
45676760	19078461	2	3
45779291	1129625	0	0
45781816	1125315	0	0
45780175	40162522	2	3
45688443	46275916	1	1
45685257	1124957	0	0
45685164	1115008	0	0
46238261	1124300	0	0
46294474	1729720	0	0
45897459	1125315	0	0
45787509	782043	0	0
45797876	1125315	0	0
46300474	1119510	0	0
46320459	1119510	0	0
252662	258780	4	4
3050442	3006734	1	1
21001685	1310149	0	0
21001740	19075001	2	3
35507329	1115008	0	0
35506992	1177480	0	0
36198843	1125315	0	0
36302170	4048169	8	9
42804458	1545958	0	0
44363345	1308738	0	0
44357703	1125315	0	0
44338448	1125315	0	0
45622547	1119510	0	0
45653315	1154343	0	0
44354767	1125315	0	0
45667358	1129625	0	0
45663804	1396131	0	0
45654431	1112807	0	0
45669470	19078461	2	3
45780629	1129625	0	0
45781818	1125315	0	0
45780060	40174880	2	3
45685246	46275916	1	1
45685420	1343916	0	0
45685063	740275	0	0
46238363	1107830	0	0
46294149	1118084	0	0
45897495	1125315	0	0
45787779	1107830	0	0
45797796	1125315	0	0
46300545	1119510	0	0
46320366	1119510	0	0
252662	261325	4	4
3050442	3001247	1	1
21001643	1332418	0	0
21004199	46233988	2	3
35507294	791967	0	0
35506993	1500211	0	0
36198946	1125315	0	0
36302170	4306014	8	9
42804459	1545958	0	0
44363517	1124300	0	0
44357709	1125315	0	0
44338234	1125315	0	0
45622723	1119510	0	0
45653322	914335	0	0
44354772	1125315	0	0
45667455	1129625	0	0
45663805	1118084	0	0
45655516	1112807	0	0
45781314	19078461	2	3
45780862	1129625	0	0
45781289	1125315	0	0
45780127	782047	2	3
45682319	46275916	1	1
45685421	1124957	0	0
45685066	1551099	0	0
46238368	1124957	0	0
46294372	1192710	0	0
45897504	1125315	0	0
45787586	1153428	0	0
45797803	1125315	0	0
46300517	1119510	0	0
46320274	1119510	0	0
4024000	4056621	4	4
3050445	3001247	1	1
21001643	1539403	0	0
21004199	46233710	2	3
35507354	738818	0	0
35506987	1551099	0	0
36151821	1125315	0	0
36302170	4146173	8	12
42804484	1177480	0	0
44363175	975125	0	0
44357529	1125315	0	0
44338388	1125315	0	0
45622726	1119510	0	0
45653346	920293	0	0
44354723	1125315	0	0
45662461	1129625	0	0
45663428	1192710	0	0
45651483	1112807	0	0
45674273	19078461	2	3
45779454	1129625	0	0
45781611	1125315	0	0
45780194	40236824	2	3
45676299	19079524	1	1
45685504	708298	0	0
45684716	914335	0	0
46238246	1729720	0	0
46294375	1589505	0	0
45897518	1125315	0	0
45787572	1539403	0	0
45797931	1125315	0	0
46300626	1119510	0	0
46320333	1119510	0	0
4024000	198199	4	4
3050445	3006734	1	1
21001603	1551099	0	0
21001875	1551192	2	3
35507354	1119510	0	0
35506988	1548195	0	0
36151803	1125315	0	0
36302170	42535580	7	9
42804460	1539403	0	0
44363177	1000560	0	0
44357532	1125315	0	0
44338605	1125315	0	0
45622950	1119510	0	0
45653347	1738521	0	0
44354683	1125315	0	0
45662900	1129625	0	0
45663438	1124957	0	0
45651603	1112807	0	0
45671078	40223768	2	3
45779460	1129625	0	0
45781636	1125315	0	0
45780098	19018935	2	3
46272790	4024289	1	1
45685289	1102527	0	0
45684944	1192710	0	0
45897248	1361711	0	0
46293919	701322	0	0
45897572	1125315	0	0
45787683	1768849	0	0
45797717	1125315	0	0
46300735	1119510	0	0
46320592	1119510	0	0
4011630	380378	4	4
3050465	3006734	1	1
21001654	1367571	0	0
21001775	40232448	2	3
35507354	1125315	0	0
35506991	1129625	0	0
36152004	1125315	0	0
36302170	4218389	7	9
42805324	1728416	0	0
44363389	1112807	0	0
44357538	1125315	0	0
44338404	1125315	0	0
45622553	1119510	0	0
45653348	1124300	0	0
44354807	1125315	0	0
45664740	1129625	0	0
45663443	1149196	0	0
45651252	1112807	0	0
45633042	19078461	2	3
45708244	1129625	0	0
45781722	1125315	0	0
45780057	1127433	2	3
46272790	4252419	1	1
45685261	1112807	0	0
45685168	1149196	0	0
45897250	1149196	0	0
46294494	1778162	0	0
45897638	1125315	0	0
45787739	975125	0	0
45798061	1125315	0	0
46300598	1119510	0	0
46320650	1119510	0	0
4101796	4132546	4	4
3050465	3001247	1	1
21001288	1738521	0	0
21001775	19112599	2	3
35507330	1112807	0	0
35507109	705944	0	0
36151929	1125315	0	0
36302170	440086	7	9
42805457	1149380	0	0
44363181	1115008	0	0
44357628	1125315	0	0
44338547	1125315	0	0
45622824	1119510	0	0
45653089	1713332	0	0
44354898	1125315	0	0
45664552	1129625	0	0
45663898	1000560	0	0
45651347	1112807	0	0
45698234	19078461	2	3
45708325	1129625	0	0
45781542	1125315	0	0
45779781	1107882	2	3
45687679	738818	0	0
45685263	1107830	0	0
45685109	920293	0	0
45897265	1112807	0	0
46294596	1738521	0	0
45897639	1125315	0	0
45787740	975125	0	0
45797819	1125315	0	0
46300992	1119510	0	0
46320722	1119510	0	0
4042646	4275113	4	4
3037839	3024561	1	1
21001283	1150770	0	0
21013610	19007333	2	3
35507314	791967	0	0
35506996	920293	0	0
36151659	1125315	0	0
36302170	4132546	7	11
42805460	1322184	0	0
44363163	914335	0	0
44357629	1125315	0	0
44338534	1125315	0	0
45621237	1119510	0	0
45653089	1759842	0	0
44354623	1125315	0	0
45664434	1129625	0	0
45663855	1741122	0	0
45648294	1112807	0	0
45705097	1332419	2	3
45708328	1129625	0	0
45781290	1125315	0	0
45780153	920334	2	3
45687447	967823	0	0
45685266	1149196	0	0
45685110	1174888	0	0
45897293	1153428	0	0
46293973	1589505	0	0
45897589	1125315	0	0
45787741	1192710	0	0
45797946	1125315	0	0
46300916	1119510	0	0
46320410	1119510	0	0
4180628	192671	4	4
3037839	3013682	1	1
21001283	1112807	0	0
21002775	1551192	2	3
35507315	738818	0	0
35506998	1177480	0	0
36151872	1125315	0	0
36302170	4152936	7	12
42805465	1343916	0	0
44363287	1308738	0	0
44357649	1125315	0	0
44338630	1125315	0	0
45621112	1119510	0	0
45653090	1149196	0	0
44354993	1125315	0	0
45663001	1129625	0	0
45663855	1746114	0	0
45649208	1112807	0	0
45669399	1332419	2	3
45705551	1129625	0	0
45781545	1125315	0	0
45780154	40236446	2	3
45687451	1149196	0	0
45685269	1124957	0	0
45685222	757627	0	0
45897139	1124300	0	0
46293973	19127890	0	0
45897772	1125315	0	0
45787749	1000560	0	0
45797980	1125315	0	0
46300996	1119510	0	0
46320411	1119510	0	0
4180628	80502	4	4
3037839	3006906	1	1
21001283	1107830	0	0
21002775	19007333	2	3
35507315	1119510	0	0
35506998	1129625	0	0
36151981	1125315	0	0
36302170	40480160	6	12
42805658	1112807	0	0
44363258	1192710	0	0
44357650	1125315	0	0
44338638	1125315	0	0
45621260	1119510	0	0
45653357	1308738	0	0
44355011	1125315	0	0
45663037	1129625	0	0
45663858	1501700	0	0
45649231	1112807	0	0
45674247	1332419	2	3
45705399	1129625	0	0
45781546	1125315	0	0
45707022	40236446	2	3
45687460	1728416	0	0
45685425	1153428	0	0
45685084	1192710	0	0
45897147	1124957	0	0
46293973	1549786	0	0
45897643	1125315	0	0
45787700	1551099	0	0
45797991	1125315	0	0
46301002	1119510	0	0
46320434	1119510	0	0
4024567	441267	4	4
3037839	3004501	1	1
21001283	1153428	0	0
21002836	1127078	2	3
35507315	1125315	0	0
35506999	1177480	0	0
36152085	1125315	0	0
36302170	257012	6	12
42805416	1322184	0	0
44363260	1107830	0	0
44357587	1125315	0	0
44341207	1125315	0	0
45622001	1119510	0	0
45653361	1174888	0	0
44355036	1125315	0	0
45659791	1129625	0	0
45663868	1305058	0	0
45648379	1112807	0	0
45673674	1332419	2	3
45705321	1129625	0	0
45781842	1125315	0	0
45707026	19008572	2	3
45687598	1115008	0	0
45799951	1539403	0	0
45685132	967823	0	0
45897369	1361711	0	0
46294501	1713332	0	0
45897575	1125315	0	0
45787701	1305058	0	0
45797992	1125315	0	0
46301003	1119510	0	0
46320867	1119510	0	0
4017459	4198190	4	4
3037839	3016723	1	1
21001284	975125	0	0
21002836	1127433	2	3
35507266	1545958	0	0
35507034	1545958	0	0
36151764	1125315	0	0
36302170	198809	6	12
42805468	705944	0	0
44363186	1149380	0	0
44357957	1125315	0	0
44359814	1125315	0	0
45621315	1119510	0	0
45653542	1124300	0	0
44355078	1125315	0	0
45659613	1129625	0	0
45663546	1548195	0	0
45642445	1112807	0	0
45704761	1332419	2	3
45705423	1129625	0	0
45781689	1125315	0	0
45707125	40232448	2	3
45687600	1174888	0	0
45800009	791967	0	0
45685146	1149196	0	0
45897372	1124957	0	0
46294501	1759842	0	0
45897621	1125315	0	0
45787702	1124300	0	0
45797995	1125315	0	0
46301127	1119510	0	0
46320662	1119510	0	0
255919	4029498	4	4
3044031	3016723	1	1
21001352	975125	0	0
21001871	1551192	2	3
35507336	975125	0	0
35507056	1112807	0	0
36151769	1125315	0	0
36302170	4047491	6	9
42805341	1326303	0	0
44363193	738818	0	0
44357884	1125315	0	0
44359725	1125315	0	0
45664835	1119510	0	0
45653439	1332418	0	0
44354740	1125315	0	0
45659624	1129625	0	0
45663550	1174888	0	0
45642672	1112807	0	0
45692062	1332419	2	3
45705483	1129625	0	0
45781398	1125315	0	0
45706894	19057271	2	3
45687540	1107830	0	0
45800043	1153428	0	0
45684788	1521369	0	0
45897026	1115008	0	0
46294443	1124300	0	0
45897604	1125315	0	0
45787763	1713332	0	0
45797905	1125315	0	0
46319195	1119510	0	0
46320671	1119510	0	0
200174	4296204	4	4
3044460	3016723	1	1
21001299	975125	0	0
21001853	19074841	2	3
35507303	1129625	0	0
35507059	1153428	0	0
36151770	1125315	0	0
36302170	4062501	6	6
42805342	1125315	0	0
44363434	1738521	0	0
44357755	1125315	0	0
44359730	1125315	0	0
45664934	1119510	0	0
45653129	914335	0	0
44354741	1125315	0	0
45659927	1129625	0	0
45663924	1124957	0	0
45642566	1112807	0	0
45669593	40223768	2	3
45705466	1129625	0	0
45781529	1125315	0	0
45706149	19008572	2	3
45687551	1310149	0	0
45799872	723013	0	0
45684788	19127890	0	0
45897106	1112807	0	0
46294458	1153428	0	0
45895374	1125315	0	0
45787608	1713332	0	0
45799744	1125315	0	0
46319219	1119510	0	0
46320918	1119510	0	0
4023995	381316	4	4
3048501	3006734	1	1
21001373	975125	0	0
21001853	1713671	2	3
35507304	1119510	0	0
35507148	1129625	0	0
36152244	1125315	0	0
36302170	40479768	10	13
42804547	1545958	0	0
44363395	1112807	0	0
44357832	1125315	0	0
44359837	1125315	0	0
45664883	1119510	0	0
45653136	1174888	0	0
44354819	1125315	0	0
45656672	1129625	0	0
45663839	967823	0	0
45639416	1112807	0	0
45699361	1539411	2	3
45705498	1129625	0	0
45781532	1125315	0	0
45706198	1115171	2	3
45687552	19127890	0	0
45799788	1548195	0	0
45684788	1549786	0	0
45897221	1118084	0	0
46294686	975125	0	0
45895244	1125315	0	0
45787608	1759842	0	0
45795194	1125315	0	0
46319102	1119510	0	0
46321392	1119510	0	0
4023995	321042	4	4
3048501	3001247	1	1
21001374	975125	0	0
21004620	1551192	2	3
35306246	441267	0	0
35507136	1177480	0	0
36152252	1125315	0	0
36302170	4181917	5	6
42804543	1551099	0	0
44363197	1713332	0	0
44353848	1125315	0	0
44360143	1125315	0	0
45664845	1119510	0	0
45653294	967823	0	0
44351191	1125315	0	0
45656947	1129625	0	0
45663688	1124300	0	0
45639420	1112807	0	0
45669691	1539411	2	3
45705572	1129625	0	0
45781658	1125315	0	0
45706158	40223834	2	3
45687552	1548195	0	0
45799702	1154029	0	0
45684880	975125	0	0
45897211	1322184	0	0
46294619	1192710	0	0
45895422	1125315	0	0
45787611	1309944	0	0
45795335	1125315	0	0
46319481	1119510	0	0
46321395	1119510	0	0
254068	40486433	4	4
3048567	3006734	1	1
21001283	975125	0	0
21001688	40163554	2	3
21604793	40223768	1	4
35507105	1112807	0	0
36152080	1125315	0	0
36302170	40478878	5	6
42804576	1738521	0	0
44363197	1759842	0	0
44355300	1125315	0	0
44359967	1125315	0	0
45665189	1119510	0	0
45652952	1713332	0	0
44351194	1125315	0	0
45657006	1129625	0	0
45663449	738818	0	0
45639430	1112807	0	0
45684084	19078461	2	3
45705664	1129625	0	0
45781777	1125315	0	0
45706174	1127433	2	3
45687603	1149196	0	0
45799722	1738521	0	0
45685013	1174888	0	0
45897213	1738521	0	0
46293977	1153428	0	0
45895431	1125315	0	0
45787305	1332418	0	0
45795355	1125315	0	0
46319365	1119510	0	0
46315054	1119510	0	0
254068	4280726	4	4
3048567	3001247	1	1
21001283	1150836	0	0
21001839	19075001	2	3
21604186	19023398	1	4
35507106	1177480	0	0
36152418	1125315	0	0
36302170	4015189	4	8
42804757	1177480	0	0
44363203	1149380	0	0
44355448	1125315	0	0
44359675	1125315	0	0
45665135	1119510	0	0
45652956	1326303	0	0
44350870	1125315	0	0
45657202	1129625	0	0
45663450	967823	0	0
45639514	1112807	0	0
45692808	1539411	2	3
45701894	1129625	0	0
45783596	1125315	0	0
45706175	19073188	2	3
45687552	19054876	0	0
45799733	1551099	0	0
45685112	740275	0	0
45897218	1729720	0	0
46294720	1115008	0	0
45895252	1125315	0	0
45787492	1115008	0	0
45795435	1125315	0	0
46319146	1119510	0	0
46313872	1119510	0	0
4029205	4117038	3	7
3048584	3006734	1	1
21001378	1778162	0	0
21001839	19074841	2	3
21604186	782047	1	4
35507226	1548195	0	0
36152093	1125315	0	0
36302170	4145310	4	6
42804771	1177480	0	0
44363208	1107830	0	0
44355336	1125315	0	0
44359741	1125315	0	0
45665236	1119510	0	0
45653197	967823	0	0
44350873	1125315	0	0
45653687	1129625	0	0
45663558	1738521	0	0
45639534	1112807	0	0
45689833	1539411	2	3
45702067	1129625	0	0
45783778	1125315	0	0
45706292	19019273	2	3
45687639	1551099	0	0
45799680	1717327	0	0
45685113	1717327	0	0
45897305	791967	0	0
46294388	1192710	0	0
45895514	1125315	0	0
45800997	1361711	0	0
45795516	1125315	0	0
46319150	1119510	0	0
46314894	1119510	0	0
4047779	381316	3	6
3048584	3001247	1	1
21001349	914335	0	0
21001840	19074841	2	3
21604186	19023423	1	4
35507227	1129625	0	0
36152099	1125315	0	0
36302170	4052083	4	4
42804551	740275	0	0
44363289	1107830	0	0
44355269	1125315	0	0
44360174	1125315	0	0
45665172	1119510	0	0
45649934	1713332	0	0
44350875	1125315	0	0
45653783	1129625	0	0
45663576	1551099	0	0
45639654	1112807	0	0
45673398	19129144	3	4
45702139	1129625	0	0
45779237	1125315	0	0
45706293	19077344	2	3
45687640	1107830	0	0
45799687	1174888	0	0
45685116	920293	0	0
45897335	1174888	0	0
46294522	1118084	0	0
45895515	1125315	0	0
45801189	1548195	0	0
45795372	1125315	0	0
46319449	1119510	0	0
46314899	1119510	0	0
4047779	4283893	3	6
3048591	3024561	1	1
21001319	19010482	0	0
21001840	19075001	2	3
35104392	4280726	1	1
35507151	1177480	0	0
36152068	1125315	0	0
36502203	4149245	5	5
42804594	1539403	0	0
44363445	1307863	0	0
44355272	1125315	0	0
44359919	1125315	0	0
45665282	1119510	0	0
45649990	723013	0	0
44351168	1125315	0	0
45653804	1129625	0	0
45663584	1343916	0	0
45639665	1112807	0	0
45654931	1545958	0	0
45702022	1129625	0	0
45779238	1125315	0	0
45699710	42707627	2	3
45687541	1174888	0	0
45797317	1539403	0	0
45685125	1118084	0	0
45897339	1738521	0	0
46294525	967823	0	0
45895517	1125315	0	0
45801191	1118084	0	0
45795528	1125315	0	0
46319167	1119510	0	0
46314901	1119510	0	0
4047779	30753	3	7
3048591	3020630	1	1
21001358	975125	0	0
21001840	1713671	2	3
35104353	4280726	1	1
35507154	1149196	0	0
36152171	1125315	0	0
36502203	78272	8	8
42804597	1124300	0	0
44363271	1738521	0	0
44355380	1125315	0	0
44359970	1125315	0	0
45662294	1119510	0	0
45649994	967823	0	0
44351013	1125315	0	0
45650225	1129625	0	0
45663814	1115008	0	0
45639687	1112807	0	0
45654908	1124300	0	0
45699219	1129625	0	0
45779377	1125315	0	0
45699774	40229134	2	3
45687608	967823	0	0
45797339	1192710	0	0
45685127	967823	0	0
45897346	1107830	0	0
46294534	1118084	0	0
45894537	1125315	0	0
45801195	1551099	0	0
45795448	1125315	0	0
46319390	1119510	0	0
46314811	1119510	0	0
4047779	4310024	3	7
3048604	3001247	1	1
21600654	975125	0	0
21001882	1551192	2	3
35302583	441267	1	1
35507080	1515774	0	0
36151987	1125315	0	0
36502203	40479768	6	6
42804579	1177480	0	0
44363273	1124957	0	0
44355360	1125315	0	0
44360280	1125315	0	0
45662505	1119510	0	0
45649995	967823	0	0
44351016	1125315	0	0
45650349	1129625	0	0
45660285	1153428	0	0
45639623	1112807	0	0
45654909	1110410	0	0
45695932	1129625	0	0
45627300	40228214	2	3
45699742	40232448	2	3
45687645	1746114	0	0
45797367	715997	0	0
45685098	1192710	0	0
45897306	738818	0	0
46294539	1549786	0	0
45894562	1125315	0	0
45801200	1501700	0	0
45795304	1125315	0	0
46319490	1119510	0	0
46314821	1119510	0	0
4047779	195588	3	7
3048604	3006734	1	1
21506099	967823	0	0
21002839	1551192	2	3
35102367	439777	1	1
35507080	1549786	0	0
35809207	4048171	4	4
36502203	40479422	6	6
42804583	1177480	0	0
44363563	1713332	0	0
44355364	1125315	0	0
44360283	1125315	0	0
45662654	1119510	0	0
45649905	1549786	0	0
44351130	1125315	0	0
45650364	1129625	0	0
45660296	1738521	0	0
45639760	1112807	0	0
45654911	1310149	0	0
45695587	1129625	0	0
45642434	40223768	2	3
45699769	19019273	2	3
45687645	1741122	0	0
45797377	1738521	0	0
45685196	933724	0	0
45897315	1112807	0	0
46294539	1595799	0	0
45803193	1125315	0	0
45801104	1149196	0	0
45795378	1125315	0	0
46319538	1119510	0	0
46315082	1119510	0	0
4047779	4329847	3	8
3048875	3006734	1	1
21506100	967823	0	0
21002597	19075001	2	3
35104186	439777	1	1
35507125	1112807	0	0
36002868	4280726	4	4
36502203	81151	4	7
42804566	920293	0	0
44363323	738818	0	0
44354286	1125315	0	0
44359901	1125315	0	0
45662669	1119510	0	0
45649905	19127890	0	0
44351138	1125315	0	0
45649031	1129625	0	0
45660302	1343916	0	0
45639552	1112807	0	0
45655072	920293	0	0
45695881	1129625	0	0
45630203	40228214	2	3
45700147	40236824	2	3
45687649	738818	0	0
45797347	1107830	0	0
45685210	1153428	0	0
45897323	1107830	0	0
46294539	1521369	0	0
45803199	1125315	0	0
45801203	723013	0	0
45792717	1125315	0	0
46240001	1119510	0	0
46314767	1119510	0	0
4027384	4112343	3	9
3048875	3001247	1	1
21506102	1125315	0	0
21002597	19133905	2	3
21601237	1326303	4	4
35507127	920293	0	0
35708294	81893	4	4
36602217	4285898	5	5
42804592	1124300	0	0
44363292	1305058	0	0
44354355	1125315	0	0
44353309	1125315	0	0
45662514	1119510	0	0
45649905	1515774	0	0
44350883	1125315	0	0
45647369	1129625	0	0
45660306	1153428	0	0
45639916	1112807	0	0
45655014	1149196	0	0
45697328	1129625	0	0
45639590	40228214	2	3
45693380	1127433	2	3
45687576	708298	0	0
45797318	1729720	0	0
45685216	791967	0	0
45897355	1192710	0	0
46243886	1310149	0	0
45803421	1125315	0	0
45801113	1738521	0	0
45792719	1125315	0	0
46239885	1119510	0	0
46314940	1119510	0	0
4027384	260139	3	8
3048880	3001247	1	1
21506104	1125315	0	0
21002597	19074841	2	3
21601237	1343916	4	4
35507158	1115008	0	0
36102976	258780	4	4
36503288	80809	4	4
42804620	914335	0	0
44363301	1149380	0	0
44354432	1125315	0	0
44353319	1125315	0	0
45662727	1119510	0	0
45649757	1322184	0	0
44351146	1125315	0	0
45644273	1129625	0	0
45660282	1153428	0	0
45636585	1112807	0	0
45655016	1115008	0	0
45697871	1129625	0	0
45661370	19078461	2	3
45693510	42707627	2	3
45687578	975125	0	0
45797383	1521369	0	0
45685553	1738521	0	0
45897190	1149196	0	0
46243569	1309944	0	0
45803342	1125315	0	0
45801115	1332418	0	0
45792590	1125315	0	0
46239837	1119510	0	0
46314979	1119510	0	0
4027384	4294548	3	8
3048880	3006734	1	1
21506104	1192710	0	0
21002597	19133873	2	3
21601237	1539403	4	4
35507168	1149380	0	0
36102976	4048171	4	4
36503288	78272	4	9
42804629	1322184	0	0
44363302	738818	0	0
44354554	1125315	0	0
44353326	1125315	0	0
45662530	1119510	0	0
45649997	19127890	0	0
44350960	1125315	0	0
45644281	1129625	0	0
45660253	1343916	0	0
45633283	1112807	0	0
45655002	791967	0	0
45695999	1129625	0	0
45666494	40228214	2	3
45693574	1115171	2	3
45687779	1738521	0	0
45797385	1332418	0	0
45685554	1501700	0	0
45897191	975125	0	0
46243828	19010482	0	0
45803429	1125315	0	0
45801126	715997	0	0
45792591	1125315	0	0
46239838	1119510	0	0
46314919	1119510	0	0
4040392	4330583	3	7
3045262	3016723	1	1
21501247	19010482	0	0
21001686	40163554	2	3
21601237	1307863	4	4
35507174	1119510	0	0
35809212	40486433	4	4
36503288	4134304	6	9
42804630	1115008	0	0
44363230	1539403	0	0
44354452	1125315	0	0
44353337	1125315	0	0
45661222	1119510	0	0
45649997	1549786	0	0
44350971	1125315	0	0
45644410	1129625	0	0
45660391	1768849	0	0
45633386	1112807	0	0
45655008	1153428	0	0
45696067	1129625	0	0
45625155	40228214	2	3
45693726	40232448	2	3
45687594	1713332	0	0
45797387	975125	0	0
45685557	1343916	0	0
45897235	753626	0	0
46243571	1154343	0	0
45803270	1125315	0	0
45801137	1153428	0	0
45794548	1125315	0	0
46239944	1119510	0	0
46314908	1119510	0	0
4180628	4280726	3	7
3048238	3006734	1	1
21502520	1174888	0	0
21001848	19074841	2	3
21601237	1332418	4	4
35507129	1119510	0	0
35809212	4280726	4	4
36503288	81151	5	8
42804581	1000560	0	0
44363236	715997	0	0
44354666	1125315	0	0
44353244	1125315	0	0
45661216	1119510	0	0
45649967	1713332	0	0
44351028	1125315	0	0
45644377	1129625	0	0
45660310	1308738	0	0
45633557	1112807	0	0
45655109	738818	0	0
45692794	1129625	0	0
45661004	40228214	2	3
45693604	19074843	2	3
45687696	1107830	0	0
45797393	1192710	0	0
45685507	757627	0	0
45897118	967823	0	0
46243874	1332418	0	0
45803357	1125315	0	0
45802442	967823	0	0
45794568	1125315	0	0
46321960	1119510	0	0
46314910	1119510	0	0
4028071	4142905	3	6
3048257	3006734	1	1
21502622	1746114	0	0
21001848	19075001	2	3
21601237	1361711	4	4
35507129	1129625	0	0
35809320	4084167	4	4
36503288	4109685	6	7
42804696	1332418	0	0
44363591	1729720	0	0
42802374	1125315	0	0
44353258	1125315	0	0
45659381	1119510	0	0
45649971	1557272	0	0
44351149	1125315	0	0
45644210	1129625	0	0
45660336	1115008	0	0
45633692	1112807	0	0
45655184	1521369	0	0
45692820	1129625	0	0
45668554	40228214	2	3
45693958	19008572	2	3
45687609	1107830	0	0
45797395	1521369	0	0
45685780	708298	0	0
45897423	1149196	0	0
46243932	975125	0	0
45803367	1125315	0	0
45802355	723013	0	0
45794525	1125315	0	0
46321962	1119510	0	0
46314699	1119510	0	0
4028071	195588	3	6
3050489	3049273	1	1
21502622	1741122	0	0
21001848	19073188	2	3
21601237	1545959	4	7
35507244	1124300	0	0
36002139	4219399	4	4
36503288	4237458	5	7
42804690	1545958	0	0
44363303	791967	0	0
42802374	1124957	0	0
44353351	1125315	0	0
45659388	1119510	0	0
45651843	1149196	0	0
44352377	1125315	0	0
45644171	1129625	0	0
45660340	1192710	0	0
45633667	1112807	0	0
45655009	1332418	0	0
45692765	1129625	0	0
45636423	40228214	2	3
45693608	40229134	2	3
45687224	975125	0	0
45682416	723013	0	0
45685718	920293	0	0
45897356	1118084	0	0
46243933	1361711	0	0
45803455	1125315	0	0
45802447	1367571	0	0
45794610	1125315	0	0
46322225	1119510	0	0
46314700	1119510	0	0
4041285	195588	3	6
3049225	3006734	1	1
21502623	1759842	0	0
21001848	19073183	2	3
21601237	1310034	4	7
35507193	1149196	0	0
36002139	37017711	4	4
36503288	4035415	4	7
42804614	1713332	0	0
44363306	1343916	0	0
42802650	1728416	0	0
44353163	1125315	0	0
45659648	1119510	0	0
45651855	1548195	0	0
44352253	1125315	0	0
45644164	1129625	0	0
45660392	1192710	0	0
45630286	1112807	0	0
45654784	1115008	0	0
45692828	1129625	0	0
45636555	40228214	2	3
45693812	19078924	2	3
45687542	1332418	0	0
45682524	1149196	0	0
45685723	967823	0	0
45897332	1192710	0	0
46243861	1728416	0	0
45803471	1125315	0	0
45802454	1545958	0	0
45792779	1125315	0	0
46321749	1119510	0	0
46317746	1119510	0	0
4103320	4112343	3	6
3049225	3001247	1	1
21502623	1717327	0	0
21001796	19073188	2	3
21601237	19018935	4	7
35507196	1332418	0	0
36000000	4051466	4	4
36503288	4048695	4	7
42804677	1118084	0	0
44363329	1192710	0	0
42802751	1115008	0	0
44355240	1125315	0	0
45659526	1119510	0	0
45651985	1149196	0	0
44352260	1125315	0	0
45641492	1129625	0	0
45660393	1154029	0	0
45630470	1112807	0	0
45654785	738818	0	0
45692995	1129625	0	0
45642725	40228214	2	3
45693905	40229134	2	3
45687726	967823	0	0
45682442	1112807	0	0
45685725	975125	0	0
45897285	1521369	0	0
46243670	1174888	0	0
45803481	1125315	0	0
45802367	1551099	0	0
45792735	1125315	0	0
46322180	1119510	0	0
46317806	1119510	0	0
4028908	4015189	3	6
3049228	3006734	1	1
21502687	740275	0	0
21001796	19073183	2	3
21604180	19076374	4	7
35507198	19078219	0	0
36000000	4102123	4	4
36502202	4035415	5	8
42804554	19127890	0	0
44363569	1545958	0	0
42802714	1713332	0	0
44355303	1125315	0	0
45659403	1119510	0	0
45651991	1115008	0	0
44352362	1125315	0	0
45641561	1129625	0	0
45660359	738818	0	0
45630476	1112807	0	0
45655120	1549786	0	0
45693183	1129625	0	0
45639461	19079524	2	3
45693887	19077572	2	3
45687728	1717327	0	0
45682317	1149196	0	0
45685731	1501700	0	0
45897285	1595799	0	0
46243809	975125	0	0
45803485	1125315	0	0
45802228	975125	0	0
45792764	1125315	0	0
46322189	1119510	0	0
46317359	1119510	0	0
4042140	4029498	3	6
3049249	3001247	1	1
21500564	757627	0	0
21004346	46233710	2	3
21604180	40223768	4	7
35507201	1154029	0	0
36000000	442116	4	4
36502202	134438	6	6
42804554	1515774	0	0
44363663	1124300	0	0
42802714	1759842	0	0
44353447	1125315	0	0
45659511	1119510	0	0
45652002	738818	0	0
44352364	1125315	0	0
45641459	1129625	0	0
45660369	1501700	0	0
45631254	1112807	0	0
45655120	19127890	0	0
45693278	1129625	0	0
45661003	40223768	2	3
45691568	1551192	2	3
45687788	1192710	0	0
45682446	1102527	0	0
45685733	1551099	0	0
45897285	1549786	0	0
46243949	1192710	0	0
45803690	1125315	0	0
45802590	1174888	0	0
45792765	1125315	0	0
46322190	1119510	0	0
46315093	1119510	0	0
4027384	4283893	3	6
3049249	3006734	1	1
21500564	715997	0	0
21004346	46233988	2	3
21604180	19023398	4	7
35507204	1119510	0	0
36200000	196456	4	4
36502202	4109685	7	8
42804554	1549786	0	0
44358781	1000560	0	0
42802692	1589505	0	0
44345742	1125315	0	0
45659677	1119510	0	0
45652006	1551099	0	0
44351881	1125315	0	0
45641589	1129625	0	0
45660603	1115008	0	0
45630714	1112807	0	0
45655012	1124957	0	0
45689958	1129625	0	0
45658165	19078461	2	3
45690723	19076374	2	3
45687792	1539403	0	0
45682286	1192710	0	0
45685734	1115008	0	0
45897374	1112807	0	0
46243893	1102527	0	0
45803695	1125315	0	0
45801233	742185	0	0
45792882	1125315	0	0
46322050	1119510	0	0
46315315	1119510	0	0
4180628	257012	3	6
3045783	3019550	1	1
21500577	1125315	0	0
21001849	19075001	2	3
21604180	40220386	6	7
35507205	1115008	0	0
36203042	4230399	3	4
36503249	4237458	4	5
42804756	1738521	0	0
44358786	1310149	0	0
42802692	1549786	0	0
44345322	1125315	0	0
45656316	1119510	0	0
45650015	1501700	0	0
44351817	1125315	0	0
45641412	1129625	0	0
45660771	791967	0	0
45630763	1112807	0	0
45655089	1307863	0	0
45689963	1129625	0	0
45624172	40223768	2	3
45690632	40232448	2	3
45687613	1738521	0	0
45682288	1124300	0	0
45685747	1768849	0	0
45894922	1000560	0	0
46243675	1174888	0	0
45800751	1125315	0	0
45801262	1107830	0	0
45792858	1125315	0	0
46322479	1119510	0	0
46309502	1119510	0	0
4180628	195588	3	6
3045783	3023103	1	1
21500583	1154029	0	0
21001849	19074841	2	3
21604180	40162522	6	7
35506890	1713332	0	0
35702109	4285898	3	4
36503249	4048695	4	5
42804674	1177480	0	0
44358788	1322184	0	0
42802693	975125	0	0
44345437	1125315	0	0
45656557	1119510	0	0
45650039	1343916	0	0
44352370	1125315	0	0
45641650	1129625	0	0
45660463	1118084	0	0
45630653	1112807	0	0
45655285	1000560	0	0
45690049	1129625	0	0
45666528	40223768	2	3
45690692	19008572	2	3
45687617	1332418	0	0
45682295	1124957	0	0
45685882	1107830	0	0
45894914	1124957	0	0
46243678	1309944	0	0
45800893	1125315	0	0
45801236	1521369	0	0
45792970	1125315	0	0
46321925	1119510	0	0
46310079	1119510	0	0
4178367	4058899	3	5
3049512	3001247	1	1
21500583	1124957	0	0
21001849	19073188	2	3
21604180	40229134	6	7
21604201	1154029	0	0
36202155	4048695	3	4
36503249	4066995	4	5
42804707	1125315	0	0
44358898	1177480	0	0
42802704	1000560	0	0
44345791	1125315	0	0
45656561	1119510	0	0
45650046	1115008	0	0
44351257	1125315	0	0
45641759	1129625	0	0
45660617	1738521	0	0
45627571	1112807	0	0
45655093	1110410	0	0
45690077	1129625	0	0
45624530	19078461	2	3
45690616	40223834	2	3
45687749	975125	0	0
45682510	1124957	0	0
45685508	1310149	0	0
45894984	1118084	0	0
46243684	1322184	0	0
45800897	1125315	0	0
45801236	1549786	0	0
45792974	1125315	0	0
46321930	1119510	0	0
46309867	1119510	0	0
4041285	198199	3	5
3049512	3006734	1	1
21500580	1129625	0	0
21001849	1713671	2	3
21604180	19078219	4	4
21604202	19059528	0	0
36202155	40480160	3	4
36503249	4142905	4	5
42804708	1361711	0	0
44358577	1713332	0	0
42802830	1125315	0	0
44345639	1125315	0	0
45656603	1119510	0	0
45650083	1551099	0	0
44351252	1125315	0	0
45641666	1129625	0	0
45660618	1149380	0	0
45627525	1112807	0	0
45655098	975125	0	0
45687072	1129625	0	0
45666552	19078461	2	3
45690744	40224805	2	3
45687750	715997	0	0
45682514	1192710	0	0
45685562	1154029	0	0
45894987	1115008	0	0
46244779	1124957	0	0
45800658	1125315	0	0
45801236	1595799	0	0
45792977	1125315	0	0
46322139	1119510	0	0
46309874	1119510	0	0
4168335	4152936	3	5
3049558	3051031	1	1
21500580	1112807	0	0
21001849	19073183	2	3
21604180	753626	4	4
21604203	19078219	0	0
36151891	19127918	3	4
36503249	4059173	5	5
42804709	1713332	0	0
44358580	920293	0	0
42802857	791967	0	0
44348037	1125315	0	0
45656176	1119510	0	0
45650067	738818	0	0
44351288	1125315	0	0
45641725	1129625	0	0
45660620	1549786	0	0
45627634	1112807	0	0
45655290	1174888	0	0
45687133	1129625	0	0
45648403	19078461	2	3
45690884	40232448	2	3
45687230	1115008	0	0
45682398	1107830	0	0
45681881	1124300	0	0
45895004	715997	0	0
46244789	1000560	0	0
45800673	1125315	0	0
45801239	1549786	0	0
45792863	1125315	0	0
46322157	1119510	0	0
46309895	1119510	0	0
4103320	4294548	3	5
3053269	3001247	1	1
21500580	1125315	0	0
21001842	19074841	2	3
21604180	757627	4	4
36156236	1119510	0	0
36102976	4283893	1	1
36503249	4278672	5	5
42802009	1125315	0	0
44358584	1110410	0	0
42802768	701322	0	0
44348190	1125315	0	0
45658363	1119510	0	0
45650153	1713332	0	0
44347310	1125315	0	0
45638309	1129625	0	0
45660403	1367571	0	0
45627409	1112807	0	0
45655191	1343916	0	0
45687043	1129625	0	0
45668561	19078461	2	3
45690955	40232448	2	3
45687231	1713332	0	0
45682400	1343916	0	0
45681887	1149196	0	0
45895004	701322	0	0
46244893	1521369	0	0
45800864	1125315	0	0
45801239	19127890	0	0
45792792	1125315	0	0
46322481	1119510	0	0
46309899	1119510	0	0
4115259	261325	3	5
3053269	3006734	1	1
21500590	1112807	0	0
21001842	1713671	2	3
21604180	782043	4	4
36156287	1322184	0	0
35909441	198809	1	1
36503249	4134304	7	7
42802009	1124957	0	0
44358687	933724	0	0
42802770	1112807	0	0
44348420	1125315	0	0
45653066	1119510	0	0
45646739	738818	0	0
44347496	1125315	0	0
45638212	1129625	0	0
45660422	738818	0	0
45624346	1112807	0	0
45655293	1778162	0	0
45687289	1129625	0	0
45660857	19078461	2	3
45691000	19126352	2	3
45687850	1310149	0	0
45682430	967823	0	0
45681883	1110410	0	0
45894931	1112807	0	0
46244893	1549786	0	0
45800931	1125315	0	0
45801239	1589505	0	0
45792908	1125315	0	0
46322486	1119510	0	0
46309910	1119510	0	0
4027384	30753	3	5
3049843	3006734	1	1
21500590	1125315	0	0
21001879	1551192	2	3
21604180	19059528	4	4
36152470	1118084	0	0
36002886	81893	1	1
36503249	4230399	6	6
42801754	1000560	0	0
44358494	1501700	0	0
42802677	975125	0	0
44345803	1125315	0	0
45653011	1119510	0	0
45646740	1548195	0	0
44347485	1125315	0	0
45638466	1129625	0	0
45660434	1713332	0	0
45624452	1112807	0	0
45655250	1539403	0	0
45687099	1129625	0	0
45642550	19078461	2	3
45690885	19019273	2	3
45687839	757627	0	0
45794842	740275	0	0
45682153	1332418	0	0
45894933	1137529	0	0
46244859	914335	0	0
45801002	1125315	0	0
45801248	967823	0	0
45790129	1125315	0	0
46322065	1119510	0	0
46309556	1119510	0	0
4028387	4296204	3	5
3049861	3006734	1	1
21500591	1102527	0	0
21001907	1551192	2	3
21604180	1124957	4	4
36152553	723013	0	0
36002868	439406	1	1
36503269	4230399	7	7
42801853	701322	0	0
44358698	1149380	0	0
42802983	1125315	0	0
44345853	1125315	0	0
45653021	1119510	0	0
45646757	1551099	0	0
44347741	1125315	0	0
45638528	1129625	0	0
45660475	738818	0	0
45624792	1112807	0	0
45655032	1717327	0	0
45687240	1129625	0	0
45627213	19078461	2	3
45687696	1107882	2	3
45687304	1124957	0	0
45794843	740275	0	0
45682101	975125	0	0
45894935	1551099	0	0
46244860	715997	0	0
45801116	1125315	0	0
45801388	740275	0	0
45790131	1125315	0	0
46322495	1119510	0	0
46309543	1119510	0	0
4155793	4058899	3	5
3050719	3006734	1	1
21500591	1125315	0	0
21002783	1551192	2	3
21604180	701322	4	4
36152493	1192710	0	0
36009773	40486433	1	1
36503269	4134304	8	8
42801859	1589505	0	0
44358630	1521369	0	0
42802929	1589505	0	0
44345839	1125315	0	0
45653079	1119510	0	0
45646590	1149196	0	0
44347402	1125315	0	0
45638542	1129625	0	0
45660572	1713332	0	0
45624793	1112807	0	0
45655253	1115008	0	0
45687171	1129625	0	0
45661006	19078461	2	3
45687663	19008572	2	3
45684374	1310149	0	0
45794845	1192710	0	0
45681984	1149196	0	0
45894948	1589505	0	0
46244826	791967	0	0
45800968	1125315	0	0
45801229	1192710	0	0
45790052	1125315	0	0
46322509	1119510	0	0
46309958	1119510	0	0
4178683	4057420	3	5
3050752	3006734	1	1
21500592	1125315	0	0
21002783	19007333	2	3
21604180	19039298	4	4
36152498	975125	0	0
36009773	4280726	1	1
36503269	4048695	6	6
42801859	19127890	0	0
44358630	1549786	0	0
42802942	1332418	0	0
44345875	1125315	0	0
45653127	1119510	0	0
45646591	1115008	0	0
44347657	1125315	0	0
45638475	1129625	0	0
45660572	1759842	0	0
45668711	1112807	0	0
45700760	1174888	0	0
45687116	1129625	0	0
45630402	19078461	2	3
45687744	40231925	2	3
45684256	1115008	0	0
45794710	1545958	0	0
45682028	1110410	0	0
45895007	1000560	0	0
46244832	1149196	0	0
45800958	1125315	0	0
45801231	1539403	0	0
45789900	1125315	0	0
46316081	1119510	0	0
46309562	1119510	0	0
4180628	198199	3	5
3050752	3001247	1	1
21500592	1112807	0	0
21002811	19059056	2	3
21604180	1125315	4	4
36152480	1515774	0	0
36009799	80809	1	1
36503269	4066995	6	6
42801859	1549786	0	0
44358829	1713332	0	0
42802775	1125315	0	0
44345879	1125315	0	0
45653531	1119510	0	0
45646595	1115008	0	0
44347529	1125315	0	0
45638582	1129625	0	0
45660610	1343916	0	0
45668543	1112807	0	0
45700766	1124300	0	0
45684116	1129625	0	0
45627260	19078461	2	3
45688594	19019273	2	3
45684241	1107830	0	0
45794926	1332418	0	0
45682036	975125	0	0
45895008	1549786	0	0
46244871	1539403	0	0
45800979	1125315	0	0
45801335	1713332	0	0
45790150	1125315	0	0
46316224	1119510	0	0
46309974	1119510	0	0
4047779	372328	3	5
3052062	3006734	1	1
21500587	1125315	0	0
21002811	19019979	2	3
21602819	1717327	2	2
36152480	1549786	0	0
35708294	4027663	1	1
36503269	4278672	6	6
42801861	1149380	0	0
44358632	1177480	0	0
42802777	1124300	0	0
44345891	1125315	0	0
45653103	1119510	0	0
45646781	1548195	0	0
44347545	1125315	0	0
45635401	1129625	0	0
45660728	1501700	0	0
45668840	1112807	0	0
45700892	975125	0	0
45684084	1129625	0	0
45630428	40223768	2	3
45688490	40236824	2	3
45684343	1551099	0	0
45794928	1153428	0	0
45682039	1332418	0	0
45894966	1192710	0	0
46244872	715997	0	0
45800770	1125315	0	0
45801310	1307863	0	0
45790160	1125315	0	0
46316311	1119510	0	0
46309572	1119510	0	0
4047779	4218389	3	5
3052062	3001247	1	1
21500587	1112807	0	0
21002811	19019273	2	3
36002869	438614	2	2
36152554	1107830	0	0
36102976	257012	1	2
36503269	4059173	6	6
42801824	1305058	0	0
44358716	1149380	0	0
42802894	1177480	0	0
44345862	1125315	0	0
45653104	1119510	0	0
45646782	1000560	0	0
44347661	1125315	0	0
45635408	1129625	0	0
45660682	1110410	0	0
45668979	1112807	0	0
45700976	1551099	0	0
45684165	1129625	0	0
45624765	1332419	2	3
45684642	1127433	2	3
45684269	1396131	0	0
45794850	1149196	0	0
45681971	1115008	0	0
45894969	1124300	0	0
46243956	715997	0	0
45801046	1125315	0	0
45801291	1501700	0	0
45789923	1125315	0	0
46316316	1119510	0	0
46309574	1119510	0	0
4047779	4029498	3	5
3051724	3001247	1	1
21500588	1125315	0	0
21002846	1115171	2	3
36002869	4139681	2	2
36152482	1759842	0	0
36221037	43012754	1	2
36503269	4237458	5	6
42801866	1125315	0	0
44356307	1738521	0	0
42802799	1307863	0	0
44345958	1125315	0	0
45653278	1119510	0	0
45646744	738818	0	0
44347691	1125315	0	0
45635247	1129625	0	0
45660553	715997	0	0
45668958	1112807	0	0
45701485	1124957	0	0
45684231	1129625	0	0
45660928	19078461	2	3
45684612	40232448	2	3
45684270	1549786	0	0
45794821	1124957	0	0
45682043	708298	0	0
45895039	967823	0	0
46243963	1557272	0	0
45800875	1125315	0	0
45801339	975125	0	0
45789810	1125315	0	0
46316270	1119510	0	0
46309931	1119510	0	0
4027403	4293740	3	5
3051724	3006734	1	1
21500588	1112807	0	0
21002844	1115171	2	3
36002869	4169137	2	2
36152482	1713332	0	0
36221037	1718412	1	2
36503269	40480160	4	6
42801900	1192710	0	0
44356321	933724	0	0
42802893	1177480	0	0
44345933	1125315	0	0
45652988	1119510	0	0
45646745	738818	0	0
44347206	1125315	0	0
45635300	1129625	0	0
45660528	791967	0	0
45668921	1112807	0	0
45701540	1000560	0	0
45684317	1129625	0	0
45633308	19078461	2	3
45684798	1551192	2	3
45684274	1149196	0	0
45794876	715997	0	0
45682099	1557272	0	0
45895189	19003953	0	0
46243974	1149196	0	0
45801212	1125315	0	0
45801379	1107830	0	0
45789814	1125315	0	0
46311135	1119510	0	0
46309457	1119510	0	0
4042641	4202451	3	4
3050153	3014599	1	1
21500589	1174888	0	0
21002844	19019273	2	3
36002869	442116	2	2
36152485	1129625	0	0
36214470	1150771	1	2
36516993	40479422	5	6
42801900	1174888	0	0
44356256	1112807	0	0
42802870	920293	0	0
44345938	1125315	0	0
45653325	1119510	0	0
45646795	1361711	0	0
44347212	1125315	0	0
45635572	1129625	0	0
45660529	1154343	0	0
45668557	1112807	0	0
45701610	1307863	0	0
45684281	1129625	0	0
45668878	19078461	2	3
45684840	19059056	2	3
45685586	1322184	0	0
45794874	1738521	0	0
45681917	1713332	0	0
45894960	933724	0	0
46244051	1174888	0	0
45800777	1125315	0	0
45795764	1124300	0	0
45790175	1125315	0	0
46311214	1119510	0	0
46310155	1119510	0	0
4043016	44805732	3	4
3050153	3012494	1	1
21500589	1177480	0	0
21004249	19112599	2	3
36002869	4102123	2	2
36152488	1124300	0	0
36214805	19112599	1	2
36516993	40479768	5	6
42801904	1713332	0	0
44356247	1539403	0	0
42802658	1332418	0	0
44346034	1125315	0	0
45653339	1119510	0	0
45646869	757627	0	0
44347215	1125315	0	0
45632323	1129625	0	0
45660734	1149196	0	0
45668805	1112807	0	0
45701815	975125	0	0
45684354	1129625	0	0
45634991	19078461	2	3
45684726	40229134	2	3
45685450	1713332	0	0
45794714	1124957	0	0
45682092	1192710	0	0
45894962	708298	0	0
46244052	1115008	0	0
45801039	1125315	0	0
45795708	975125	0	0
45789992	1125315	0	0
46310857	1119510	0	0
46310156	1119510	0	0
4103352	40481087	3	4
3050153	3001488	1	1
21500589	1125315	0	0
21004249	40229134	2	3
36203066	4218389	2	2
36152586	19127890	0	0
36214807	43012036	1	2
36516993	40486433	4	4
42801904	1759842	0	0
44356282	715997	0	0
42802660	1154343	0	0
44341228	1125315	0	0
45653095	1119510	0	0
45646870	1154343	0	0
44347360	1125315	0	0
45632394	1129625	0	0
45660646	1778162	0	0
45668884	1112807	0	0
45701712	708298	0	0
45654798	1119510	0	0
45666596	19078461	2	3
45685030	40223834	2	3
45685450	1759842	0	0
45794880	1501700	0	0
45682116	1551099	0	0
45895008	1589505	0	0
46243978	1545958	0	0
45800888	1125315	0	0
45795710	1154343	0	0
45790092	1125315	0	0
46310861	1119510	0	0
46310158	1119510	0	0
4027384	195588	3	4
3050153	3006451	1	1
21500589	1112807	0	0
21004249	43012036	2	3
36203066	78272	2	2
36152586	1515774	0	0
36159556	19127904	1	2
36516993	4280726	4	4
42801908	1124300	0	0
44356341	1177480	0	0
42802944	1177480	0	0
44341182	1125315	0	0
45653442	1119510	0	0
45646879	1174888	0	0
44347922	1125315	0	0
45632287	1129625	0	0
45660788	1759842	0	0
45666511	1112807	0	0
45701734	1124957	0	0
45654855	1119510	0	0
45664517	19078461	2	3
45682585	1115171	2	3
45685467	1192710	0	0
45794907	1115008	0	0
45682272	1154343	0	0
45894972	1112807	0	0
46244005	1174888	0	0
45801087	1125315	0	0
45795801	1107830	0	0
45790085	1125315	0	0
46310933	1119510	0	0
46309769	1119510	0	0
4027384	372328	3	4
3050153	3021226	1	1
21500583	1110410	0	0
21001846	19073188	2	3
36203066	4113008	2	2
36152586	1549786	0	0
36222375	40223821	1	2
36313965	42535580	6	7
42801912	1738521	0	0
44356441	1174888	0	0
42802904	1551099	0	0
44341322	1125315	0	0
45653458	1119510	0	0
45646883	1322184	0	0
44347620	1125315	0	0
45632432	1129625	0	0
45660788	1713332	0	0
45666495	1112807	0	0
45701675	19003953	0	0
45654738	1119510	0	0
45624460	19078461	2	3
45682625	19078461	2	3
45685577	1124300	0	0
45794913	1192710	0	0
45682106	1545958	0	0
45894973	933724	0	0
46244034	1107830	0	0
45800993	1125315	0	0
45795765	19002770	0	0
45790086	1125315	0	0
46310935	1119510	0	0
46310059	1119510	0	0
4115259	255848	3	4
3050153	3000876	1	1
21500583	1102527	0	0
21001846	19075001	2	3
36203090	196456	2	2
36152455	1307863	0	0
36222375	40223834	1	2
36313965	4037675	6	6
42801979	1154343	0	0
44356442	1549786	0	0
42802905	715997	0	0
44338715	1125315	0	0
45649770	1119510	0	0
45646905	1501700	0	0
44343625	1125315	0	0
45632365	1129625	0	0
45657464	1759842	0	0
45666502	1112807	0	0
45701676	1713332	0	0
45655079	1119510	0	0
45664021	19078461	2	3
45681678	43012036	2	3
45685579	1000560	0	0
45794634	1326303	0	0
45682250	1149196	0	0
45894991	1107830	0	0
46244055	1545958	0	0
45801150	1125315	0	0
45795766	1729720	0	0
45790011	1125315	0	0
46310938	1119510	0	0
46310062	1119510	0	0
4103183	4329847	3	4
3050153	3027231	1	1
21500143	1500211	0	0
21001846	19129655	2	3
21604036	1177480	2	2
36152558	1192710	0	0
36221667	836659	1	2
36503263	4134304	5	8
42801830	1154343	0	0
44356442	1595799	0	0
42803034	1124300	0	0
44338722	1125315	0	0
45652002	1119510	0	0
45646888	1000560	0	0
44344842	1125315	0	0
45632442	1129625	0	0
45657464	1713332	0	0
45666444	1112807	0	0
45701677	975125	0	0
45655104	1119510	0	0
45642658	19078461	2	3
45681679	19023398	2	3
45685700	740275	0	0
45794779	1309944	0	0
45682251	1713332	0	0
45895026	1717327	0	0
46244181	1332418	0	0
45799700	1125315	0	0
45795778	1110410	0	0
45790188	1125315	0	0
46310942	1119510	0	0
46310007	1119510	0	0
4086181	381316	3	4
3050153	3015076	1	1
21500143	1548195	0	0
21001846	19073183	2	3
21604036	1124300	2	2
36152544	705944	0	0
36221668	836659	1	2
36503263	40479422	5	6
42801841	1154029	0	0
44356442	1521369	0	0
42802678	723013	0	0
44338649	1125315	0	0
45651938	1119510	0	0
45646826	1310149	0	0
44344725	1125315	0	0
45629297	1129625	0	0
45657465	1107830	0	0
45666520	1112807	0	0
45701797	1107830	0	0
45655109	1119510	0	0
45633223	19078461	2	3
45681939	1127433	2	3
45685704	1713332	0	0
45794940	1322184	0	0
45682382	1548195	0	0
45895036	1192710	0	0
46243988	1307863	0	0
45799770	1125315	0	0
45795822	1307863	0	0
45792021	1125315	0	0
46311163	1119510	0	0
46304428	1119510	0	0
4086181	4066995	3	4
3052929	3006734	1	1
21500146	1589505	0	0
21001846	1713671	2	3
36002868	4051466	2	2
36152550	1738521	0	0
36214641	40236824	1	2
36503263	40479768	5	6
42802142	1545958	0	0
44356444	920293	0	0
42802977	1115008	0	0
44338729	1125315	0	0
45650025	1119510	0	0
45646827	1551099	0	0
44344749	1125315	0	0
45629300	1129625	0	0
45657467	1124300	0	0
45666682	1112807	0	0
45701820	1713332	0	0
45654785	1119510	0	0
45664534	19078461	2	3
45681820	1551192	2	3
45685704	1759842	0	0
45679221	1332418	0	0
45682198	1115008	0	0
45894982	791967	0	0
46243993	1115008	0	0
45799751	1125315	0	0
45795784	1149196	0	0
45792078	1125315	0	0
46311185	1119510	0	0
46304430	1119510	0	0
4091532	4166224	3	4
3052929	3001247	1	1
21500147	1521369	0	0
21001924	19074841	2	3
36203060	4218389	2	2
36152552	1177480	0	0
1738521	46233710	2	3
36503263	4149245	4	5
42802036	1153428	0	0
44356450	1107830	0	0
42802978	1500211	0	0
44338772	1125315	0	0
45646673	1119510	0	0
45646841	1110410	0	0
44343724	1125315	0	0
45629510	1129625	0	0
45657480	1000560	0	0
45666706	1112807	0	0
45701793	723013	0	0
45655118	1119510	0	0
45624808	19079524	2	3
45681866	19019273	2	3
45685660	1107830	0	0
45679326	1107830	0	0
45682201	967823	0	0
45895107	975125	0	0
46244008	19010482	0	0
45799752	1125315	0	0
45795794	1174888	0	0
45787435	1125315	0	0
46311304	1119510	0	0
46304526	1119510	0	0
4181063	4112343	3	4
3052932	3001247	1	1
21500147	933724	0	0
21001924	19075001	2	3
21602657	933724	2	2
36152528	1549786	0	0
36213587	19127918	2	3
36503263	81151	4	6
42802175	1515774	0	0
44356452	1713332	0	0
42802982	1125315	0	0
44338682	1125315	0	0
45646739	1119510	0	0
45646924	1361711	0	0
44343732	1125315	0	0
45629378	1129625	0	0
45658564	1115008	0	0
45666858	1112807	0	0
45701935	1713332	0	0
45655201	1119510	0	0
45666788	1545959	2	3
45678570	40163554	2	3
45685708	1729720	0	0
45679383	1545958	0	0
45682324	975125	0	0
45895109	1174888	0	0
46240097	975125	0	0
45798065	1125315	0	0
45795794	1192710	0	0
45787436	1125315	0	0
46311594	1119510	0	0
46304410	1119510	0	0
4172024	4174876	3	4
3052932	3006734	1	1
21500147	1500211	0	0
21001924	19074843	2	3
36002874	80809	2	2
36152529	1713332	0	0
36213587	19128009	2	3
36502196	4059173	6	6
42802175	1549786	0	0
44356452	1759842	0	0
42802474	1332418	0	0
44338791	1125315	0	0
45646744	1119510	0	0
45646926	1728416	0	0
44343715	1125315	0	0
45629179	1129625	0	0
45658565	1192710	0	0
45664414	1112807	0	0
45701914	1729720	0	0
45700759	1119510	0	0
45635088	1332419	2	3
45678574	40162522	2	3
45685539	1343916	0	0
45678980	1112807	0	0
45682465	1326303	0	0
45895062	1332418	0	0
46238902	1192710	0	0
45798085	1125315	0	0
45795861	1000560	0	0
45787438	1125315	0	0
46322095	1119510	0	0
46304633	1119510	0	0
4103662	4132546	3	4
3052978	3001247	1	1
21500131	1548195	0	0
21001924	19073183	2	3
35702741	30753	2	2
36152532	1177480	0	0
36158196	19078461	2	3
36502196	4142905	5	6
42802224	1549786	0	0
44356343	1332418	0	0
42802578	1539403	0	0
44338732	1125315	0	0
45646848	1119510	0	0
45646954	1738521	0	0
44343956	1125315	0	0
45629601	1129625	0	0
45658547	1713332	0	0
45664304	1112807	0	0
45701772	1548195	0	0
45700839	1119510	0	0
45636777	1545959	2	3
45678696	40232448	2	3
45684429	1149196	0	0
45679272	975125	0	0
45681995	1107830	0	0
45895015	1112807	0	0
46238931	1332418	0	0
45798111	1125315	0	0
45795839	1174888	0	0
45787439	1125315	0	0
46322418	1119510	0	0
46304668	1119510	0	0
4176642	4107731	3	4
3052978	3006734	1	1
21500145	19127890	0	0
21001924	19073188	2	3
36211677	40480160	2	2
36152532	1174888	0	0
35507075	1545959	2	3
36502196	4237458	5	6
42801990	1107830	0	0
44356344	738818	0	0
44355398	1129625	0	0
44338736	1125315	0	0
45646952	1119510	0	0
45647105	1557272	0	0
44344038	1125315	0	0
45629549	1129625	0	0
45658344	1110410	0	0
45660965	1112807	0	0
45701874	1124957	0	0
45701611	1119510	0	0
45668550	1545959	2	3
45678554	19008572	2	3
45684394	967823	0	0
45679274	1115008	0	0
45682218	1501700	0	0
45895051	1713332	0	0
46238882	1149196	0	0
45798145	1125315	0	0
45795915	1551099	0	0
45787370	1125315	0	0
46322611	1119510	0	0
46304905	1119510	0	0
4178367	4024289	3	4
3052983	3006734	1	1
21500145	1589505	0	0
21013671	1310034	2	3
36203047	4048695	2	2
36152622	1549786	0	0
35506822	40174880	2	3
36502205	78272	6	8
42802063	1125315	0	0
44356293	1521369	0	0
44355398	1125315	0	0
44339050	1125315	0	0
45646862	1119510	0	0
45647133	1153428	0	0
44344046	1125315	0	0
45629567	1129625	0	0
45658346	967823	0	0
45661676	1112807	0	0
45701886	1713332	0	0
45701626	1119510	0	0
45664361	1539411	2	3
45678556	1154615	2	3
45684379	738818	0	0
45679225	1107830	0	0
45682230	1174888	0	0
45895052	791967	0	0
46238918	1107830	0	0
45798185	1125315	0	0
45795921	791967	0	0
45787475	1125315	0	0
46316495	1119510	0	0
46304911	1119510	0	0
4178367	4252419	3	4
3052983	3001247	1	1
21500145	1595799	0	0
21001866	1551192	2	3
36002141	81893	2	2
36152627	1153428	0	0
36217212	19126352	2	3
36502197	4142905	6	8
42802073	1125315	0	0
44356293	1549786	0	0
44355568	1177480	0	0
44339075	1125315	0	0
45646993	1119510	0	0
45647135	1717327	0	0
44344016	1125315	0	0
45629364	1129625	0	0
45658351	1521369	0	0
45661656	1112807	0	0
45701886	1759842	0	0
45701706	1119510	0	0
45633279	1545959	2	3
45678667	40231925	2	3
45684380	1154343	0	0
45679231	1112807	0	0
45682231	1501700	0	0
45895067	1112807	0	0
46238966	1322184	0	0
45798069	1125315	0	0
45795922	1000560	0	0
45787256	1125315	0	0
46316522	1119510	0	0
46305172	1119510	0	0
4042835	4294548	3	4
3053021	3006734	1	1
21500145	1521369	0	0
21002827	19019273	2	3
36203055	4132546	2	2
36152629	975125	0	0
1728416	19006318	2	3
36503289	4048171	6	6
42802073	1174888	0	0
44356358	1551099	0	0
44355524	1521369	0	0
44338908	1125315	0	0
45646994	1119510	0	0
45647138	1501700	0	0
44344223	1125315	0	0
45629483	1129625	0	0
45658401	1549786	0	0
45654775	1112807	0	0
45701967	1154343	0	0
45701795	1119510	0	0
45630921	1539411	2	3
45678908	19008572	2	3
45684472	1500211	0	0
45679145	1112807	0	0
45682364	975125	0	0
45895069	1124957	0	0
46238893	1192710	0	0
45798276	1125315	0	0
45795799	1361711	0	0
45787417	1125315	0	0
46317367	1119510	0	0
46305184	1119510	0	0
4040392	4238715	3	4
3053021	3001247	1	1
21500145	1503184	0	0
21002827	1551192	2	3
36002872	40486433	2	2
36152632	1149196	0	0
36157948	19078461	2	3
36502205	40479422	5	6
42801938	1177480	0	0
44356473	1124300	0	0
44355524	1549786	0	0
44338806	1125315	0	0
45647087	1119510	0	0
45647139	19010482	0	0
44340088	1125315	0	0
45629492	1129625	0	0
45658401	1518198	0	0
45654895	1112807	0	0
45701971	738818	0	0
45701764	1119510	0	0
45636894	1539411	2	3
45672404	40228230	2	3
45684397	1192710	0	0
45679342	1192710	0	0
45682377	975125	0	0
45895055	967823	0	0
46239033	1539403	0	0
45798159	1125315	0	0
45795866	1332418	0	0
45787196	1125315	0	0
46318012	1119510	0	0
46304500	1119510	0	0
4040721	4010253	3	4
3013094	3013721	1	1
21500145	1515774	0	0
21013433	46233710	2	3
21602553	19127922	2	2
36152633	1149196	0	0
21603968	19019273	2	3
36502205	40479768	5	6
42802151	1545958	0	0
44356475	1115008	0	0
44355574	1115008	0	0
44338798	1125315	0	0
45646109	1119510	0	0
45646709	1548195	0	0
44340093	1125315	0	0
45629414	1129625	0	0
45658386	1115008	0	0
45654883	1112807	0	0
45701974	1738521	0	0
45701806	1119510	0	0
45688793	1539411	2	3
45673384	40231925	2	3
45684406	19127890	0	0
45679348	1107830	0	0
45682010	1110410	0	0
45895133	1112807	0	0
46238980	1115008	0	0
45798261	1125315	0	0
45795982	1154343	0	0
45787483	1125315	0	0
46317538	1119510	0	0
46304961	1119510	0	0
4155793	4024289	3	4
3013094	3024561	1	1
21500145	1549786	0	0
21013433	19129655	2	3
21602553	19133679	2	2
36152626	1322184	0	0
35506892	40228214	2	3
36603422	78272	7	7
42802154	914335	0	0
44356269	975125	0	0
44355592	1549786	0	0
44338903	1125315	0	0
45645860	1119510	0	0
45647114	1174888	0	0
44340439	1125315	0	0
45631097	1129625	0	0
45657513	1778162	0	0
45634911	1149196	0	0
45701996	975125	0	0
45701921	1119510	0	0
45648856	1539411	2	3
45672723	1551192	2	3
45684406	1549786	0	0
45679352	1112807	0	0
45682014	1149380	0	0
45895212	1361711	0	0
46238981	1192710	0	0
45798397	1125315	0	0
45795809	1326303	0	0
45787280	1125315	0	0
46316840	1119510	0	0
46305194	1119510	0	0
4180628	44782520	3	4
3013094	3035995	1	1
21500145	1512674	0	0
21013433	920334	2	3
21602553	19129144	2	2
36152655	975125	0	0
36152237	19078461	2	3
36516772	4134304	7	8
42802156	1125315	0	0
44356350	975125	0	0
44355592	1521369	0	0
44339201	1125315	0	0
45643853	1119510	0	0
45647147	1713332	0	0
44340504	1125315	0	0
45626534	1129625	0	0
45657550	1549786	0	0
45634844	920293	0	0
45701998	1149380	0	0
45701971	1119510	0	0
45648644	1539411	2	3
45672649	920334	2	3
45684391	1149196	0	0
45679189	1539403	0	0
45678933	1115008	0	0
45895121	701322	0	0
46239068	1115008	0	0
45798508	1125315	0	0
45795850	1307863	0	0
45875962	21494966	2	2
46316841	1119510	0	0
46304936	1119510	0	0
4180628	372328	3	4
3013094	3006923	1	1
21500146	19127890	0	0
21013433	1713671	2	3
36153492	19128022	2	2
36152601	1119510	0	0
36152697	1107882	2	3
36516825	4134304	7	7
42802209	723013	0	0
44356463	975125	0	0
44355593	1119510	0	0
44339207	1125315	0	0
45643926	1119510	0	0
45647141	1174888	0	0
44340387	1125315	0	0
45626537	1129625	0	0
45657550	1521369	0	0
45634966	1501700	0	0
45701998	1137529	0	0
45698488	1119510	0	0
45651698	46275916	1	1
45672731	40232448	2	3
45684453	1326303	0	0
45679207	1305058	0	0
45678937	1107830	0	0
45895087	1361711	0	0
46239043	1332418	0	0
45798302	1125315	0	0
45795871	1307863	0	0
46244893	42902245	2	2
46311484	1119510	0	0
46320891	1119510	0	0
4042836	4132546	3	4
3013094	3020630	1	1
21500146	1521369	0	0
21013433	46233988	2	3
21602537	1500211	2	2
36152730	1741122	0	0
36157005	1107882	2	3
36503266	4134304	4	6
42802220	975125	0	0
44356464	1115008	0	0
44355501	1125315	0	0
44339063	1125315	0	0
45643928	1119510	0	0
45646861	715997	0	0
44340039	1125315	0	0
45626771	1129625	0	0
45657563	1326303	0	0
45634972	1713332	0	0
45701938	1124300	0	0
45698821	1119510	0	0
45651698	19079524	1	1
45672758	19059056	2	3
45684455	1309944	0	0
45679245	715997	0	0
45678759	1539403	0	0
45895197	1192710	0	0
46239035	975125	0	0
45795364	1125315	0	0
45795872	1149196	0	0
46243956	40223768	2	3
46311630	1119510	0	0
46321160	1119510	0	0
4042836	257012	3	4
1718400	19132304	1	1
21500146	1595799	0	0
21013433	920300	2	3
21602551	1521369	2	2
36152730	1746114	0	0
36156854	1107882	2	3
36502205	4146173	4	5
42802181	1154343	0	0
44356404	1177480	0	0
44355596	1539403	0	0
44339070	1125315	0	0
45643946	1119510	0	0
45646981	1154343	0	0
44339948	1125315	0	0
45626661	1129625	0	0
45657521	1539403	0	0
45634972	1759842	0	0
45701964	975125	0	0
45700548	1119510	0	0
45704402	19079524	1	1
45672856	40232448	2	3
45684473	1501700	0	0
45679252	1307863	0	0
45678760	975125	0	0
45895235	1549786	0	0
46239042	1192710	0	0
45795402	1125315	0	0
45795984	715997	0	0
46238947	19078461	2	3
46306376	1119510	0	0
46321559	1119510	0	0
4042836	40481087	3	4
1718400	1718412	1	1
21500146	1515774	0	0
21013433	19075001	2	3
36211382	4066995	2	2
36152567	1124300	0	0
21603266	40169281	2	3
36475214	1119510	0	0
42802077	1000560	0	0
44356483	1115008	0	0
44355600	1154343	0	0
44360302	1125315	0	0
45644070	1119510	0	0
45647197	1545958	0	0
44340369	1125315	0	0
45626582	1129625	0	0
45657576	1107830	0	0
45635064	1149196	0	0
45698817	1343916	0	0
45698943	1119510	0	0
45648780	46275916	1	1
45672982	40231925	2	3
45684407	1501700	0	0
45679182	1154343	0	0
45678883	19127890	0	0
45895235	1515774	0	0
46239002	920293	0	0
45795407	1125315	0	0
45795814	791967	0	0
45798614	19078461	2	3
46306501	1119510	0	0
46321191	1119510	0	0
4047779	140673	3	4
1718400	46221626	1	1
21500146	1549786	0	0
21002591	46233710	2	3
36211382	4048695	2	2
36152589	1149196	0	0
36152939	40228214	2	3
36475223	1521369	0	0
42802228	1124300	0	0
44356416	738818	0	0
44355531	1125315	0	0
44360316	1125315	0	0
45643992	1119510	0	0
44352155	1549786	0	0
44340032	1125315	0	0
45626687	1129625	0	0
45657659	1332418	0	0
45634941	1149196	0	0
45698853	1149196	0	0
45699029	1119510	0	0
45648780	19079524	1	1
45672845	40232448	2	3
45684416	1149196	0	0
45679441	715997	0	0
45678883	1549786	0	0
45895241	1343916	0	0
46238993	1192710	0	0
45795411	1125315	0	0
45795882	1551099	0	0
45787961	19078461	2	3
46306218	1119510	0	0
46321308	1119510	0	0
4027403	4295880	3	4
1718402	46221626	1	1
21500137	1521369	0	0
21002591	19074841	2	3
36009740	37017711	2	2
36152760	1149196	0	0
35506945	19075601	2	3
36475223	1549786	0	0
42802224	1589505	0	0
44356491	1332418	0	0
44355531	1119510	0	0
44360413	1125315	0	0
45644015	1119510	0	0
44352291	715997	0	0
44340637	1125315	0	0
45626868	1129625	0	0
45657666	1521369	0	0
45635001	1115008	0	0
45698863	1305058	0	0
45699043	1119510	0	0
45695031	19079524	1	1
45672850	19008572	2	3
45684440	1713332	0	0
45679445	1112807	0	0
45678634	1174888	0	0
45895324	738818	0	0
46238998	975125	0	0
45795570	1125315	0	0
45795892	975125	0	0
46239183	19078461	2	3
46306516	1119510	0	0
46321331	1119510	0	0
4028902	4151422	3	3
1718403	19132304	1	1
21012460	715997	0	0
21002591	19129655	2	3
36009740	433644	2	2
36152762	1119510	0	0
21502734	1310034	2	3
36475351	1149196	0	0
42802043	1177480	0	0
44356471	1112807	0	0
44355657	1119510	0	0
44360049	1125315	0	0
45641216	1119510	0	0
44352370	738818	0	0
44340196	1125315	0	0
45626904	1129625	0	0
45657666	1548195	0	0
45635035	1192710	0	0
45698880	791967	0	0
45698933	1119510	0	0
45642831	19079524	1	1
45672771	19076374	2	3
45684543	1332418	0	0
45679448	1154029	0	0
45678678	1332418	0	0
45895173	740275	0	0
46239292	975125	0	0
45795669	1125315	0	0
45796122	1000560	0	0
45798690	19078461	2	3
46306244	1119510	0	0
46321354	1119510	0	0
4040394	4108705	3	3
1718405	1718412	1	1
21013408	1551099	0	0
21002591	46275444	2	3
36009740	4240902	2	2
36152735	19003953	0	0
36156287	19075601	2	3
36475417	1119510	0	0
42802139	1115008	0	0
44356494	1177480	0	0
44355657	1125315	0	0
44360209	1125315	0	0
45640901	1119510	0	0
44352373	1521369	0	0
44340197	1125315	0	0
45623310	1129625	0	0
45657595	1174888	0	0
45635150	975125	0	0
45698884	1124300	0	0
45695474	1119510	0	0
45636743	46275916	1	1
45784682	40232448	2	3
45684574	1115008	0	0
45679492	1746114	0	0
45678867	1192710	0	0
45895091	1713332	0	0
46239056	1107830	0	0
45795547	1125315	0	0
45796043	1124957	0	0
45788231	1332419	2	3
46306468	1119510	0	0
46321108	1119510	0	0
4032257	42535580	3	3
1718411	1718412	1	1
21012460	701322	0	0
21002591	46233988	2	3
36009740	4219399	2	2
36152736	1177480	0	0
36152376	40228214	2	3
36475856	1119510	0	0
42802120	1551099	0	0
44356584	1149380	0	0
44355659	1551099	0	0
44360349	1125315	0	0
45640912	1119510	0	0
44352373	1549786	0	0
44340203	1125315	0	0
45623370	1129625	0	0
45657678	1107830	0	0
45635151	738818	0	0
45698480	708298	0	0
45695556	1119510	0	0
45636743	19079524	1	1
45784550	40232448	2	3
45684576	1539403	0	0
45679492	1741122	0	0
45678868	791967	0	0
45895091	1759842	0	0
46239187	1115008	0	0
45795658	1125315	0	0
45795932	967823	0	0
45896146	19078461	2	3
46306739	1119510	0	0
46320954	1119510	0	0
4176644	372328	3	3
1718993	1718412	1	1
21013408	19010482	0	0
21002591	19075001	2	3
36009869	4280726	2	2
36152880	1119510	0	0
36157655	19078461	2	3
36474269	1332418	0	0
42802048	975125	0	0
44356588	1112807	0	0
44355663	1361711	0	0
44360239	1125315	0	0
45641116	1119510	0	0
44352373	1595799	0	0
44340204	1125315	0	0
45623373	1129625	0	0
45657838	1000560	0	0
45635343	1149196	0	0
45698712	1738521	0	0
45695778	1119510	0	0
45645758	19079524	1	1
45784558	1551192	2	3
45681442	1115008	0	0
45679501	1343916	0	0
45678647	1539403	0	0
45895097	1149196	0	0
46239009	1713332	0	0
45795690	1125315	0	0
45795900	1124957	0	0
46299418	19078461	2	3
46306230	1119510	0	0
46321588	1119510	0	0
4176944	4294548	3	3
1545961	1545959	1	1
21013411	1717327	0	0
21002591	1713671	2	3
36009869	40486433	2	2
36152880	738818	0	0
36213586	19128009	2	3
36474281	1119510	0	0
42802051	1125315	0	0
44356590	1713332	0	0
44355664	1119510	0	0
44359936	1125315	0	0
45641130	1119510	0	0
44351211	1149196	0	0
44340324	1125315	0	0
45623374	1129625	0	0
45657683	1115008	0	0
45634992	1307863	0	0
45698723	1124957	0	0
45694383	1119510	0	0
45688814	19079524	1	1
45784788	40232448	2	3
45681447	1154343	0	0
45679651	1153428	0	0
45678916	967823	0	0
45895099	975125	0	0
46239093	1713332	0	0
45796925	1125315	0	0
45796049	791967	0	0
46298940	19078461	2	3
46306577	1119510	0	0
46321595	1119510	0	0
4148703	4330583	3	3
1326409	19018935	1	1
21013409	1551099	0	0
21002591	19074843	2	3
35702732	4266809	2	2
36152889	1115008	0	0
36213586	19127918	2	3
36473642	1548195	0	0
42802053	1149380	0	0
44356590	1759842	0	0
44355667	1125315	0	0
44359938	1125315	0	0
45641137	1119510	0	0
44351230	1149196	0	0
44337465	1125315	0	0
45623529	1129625	0	0
45657688	1729720	0	0
45634994	967823	0	0
45698484	1107830	0	0
45694701	1119510	0	0
45694997	19079524	1	1
45784665	40162522	2	3
45681454	1192710	0	0
45679291	1332418	0	0
45678851	1768849	0	0
45895151	967823	0	0
46239093	1759842	0	0
45796935	1125315	0	0
45790672	967823	0	0
46290880	19078461	2	3
46317158	1119510	0	0
46321457	1119510	0	0
4063381	258780	3	3
1150866	1150837	1	1
21013418	1305058	0	0
21002591	19073188	2	3
36203068	4066995	2	2
36152570	1149196	0	0
36152626	19075601	2	3
36473662	1119510	0	0
42802125	1307863	0	0
44356578	723013	0	0
44355667	1119510	0	0
44360306	1125315	0	0
45641139	1119510	0	0
44351280	1332418	0	0
44337366	1125315	0	0
45623743	1129625	0	0
45657677	19127890	0	0
45634984	1115008	0	0
45698488	738818	0	0
45692438	1119510	0	0
45627846	19079524	1	1
45784924	40163554	2	3
45681458	1521369	0	0
45792050	1149196	0	0
45678735	1549786	0	0
45895186	967823	0	0
46239101	975125	0	0
45796937	1125315	0	0
45790355	1192710	0	0
46239452	19078461	2	3
46317299	1119510	0	0
46315373	1119510	0	0
4042822	4330583	3	3
1150808	1150771	1	1
21013411	1778162	0	0
21002805	1551192	2	3
35902852	196456	2	2
36152462	1551099	0	0
36213592	42902245	2	3
36473711	1149196	0	0
42802231	975125	0	0
44356629	1174888	0	0
44355667	738818	0	0
44360262	1125315	0	0
45641253	1119510	0	0
44351323	1521369	0	0
45620324	1125315	0	0
45623422	1129625	0	0
45657677	1549786	0	0
45634985	738818	0	0
45698887	1545958	0	0
45692414	1119510	0	0
45688943	19079524	1	1
45784764	19008572	2	3
45681458	1595799	0	0
45792058	1115008	0	0
45678735	1589505	0	0
45895330	1149196	0	0
46239102	1118084	0	0
45797231	1125315	0	0
45790359	1149196	0	0
45801560	19078461	2	3
45896740	1125315	0	0
46315661	1119510	0	0
4028970	258780	3	3
764205	4056621	1	1
21013403	1551099	0	0
21002805	1115171	2	3
35902853	196456	2	2
36152463	1115008	0	0
36213593	42902245	2	3
36473773	1177480	0	0
42802236	1125315	0	0
44356631	1738521	0	0
44355669	1729720	0	0
44360270	1125315	0	0
45641300	1119510	0	0
44351323	19127890	0	0
45620277	1125315	0	0
45623452	1129625	0	0
45657542	1551099	0	0
45634986	1322184	0	0
45698675	1343916	0	0
45692427	1119510	0	0
45704399	19079524	1	1
45784734	19133905	2	3
45681458	1549786	0	0
45792103	1539403	0	0
45678854	967823	0	0
45894334	1309944	0	0
46239110	975125	0	0
45797233	1125315	0	0
45790459	1115008	0	0
46244086	19078461	2	3
45895704	1125315	0	0
46315667	1119510	0	0
4040560	4163971	3	3
443723	439777	1	1
21013390	1309944	0	0
21002805	19007333	2	3
35909418	198809	2	2
36152703	975125	0	0
36152633	40228214	2	3
36473817	1309944	0	0
42802236	1174888	0	0
44349193	1738521	0	0
44355670	975125	0	0
44360344	1125315	0	0
45641362	1119510	0	0
44351323	1549786	0	0
45620165	1125315	0	0
45623407	1129625	0	0
45657652	1310149	0	0
45635068	1000560	0	0
45698736	1549786	0	0
45692430	1119510	0	0
45666914	19079524	1	1
45784734	19133873	2	3
45681329	1332418	0	0
45792031	1713332	0	0
45678739	1521369	0	0
45894492	19010482	0	0
46239318	1149196	0	0
45796943	1125315	0	0
45790676	1332418	0	0
46244253	19078461	2	3
45895587	1125315	0	0
46315968	1119510	0	0
4027717	4186930	3	3
440320	4116491	1	1
21013433	1713332	0	0
21002805	19019979	2	3
35702777	4027663	2	2
36152576	933724	0	0
36156842	40228214	2	3
36473881	1125315	0	0
42802237	740275	0	0
44349312	1107830	0	0
44355671	1124300	0	0
44360346	1125315	0	0
45641374	1119510	0	0
44351256	1545958	0	0
45620187	1125315	0	0
45667907	1129625	0	0
45657775	738818	0	0
45635004	1115008	0	0
45698736	19127890	0	0
45692729	1119510	0	0
45676465	19079524	1	1
45782439	40224805	2	3
45681464	1551099	0	0
45792031	1759842	0	0
45678739	19127890	0	0
45894477	1174888	0	0
45790468	1545958	0	0
45792994	1125315	0	0
45790519	1332418	0	0
45793266	19078461	2	3
45895639	1125315	0	0
46315780	1119510	0	0
4133611	4001336	3	3
3050951	3016723	1	2
21013433	1717327	0	0
21002805	19059056	2	3
35508412	40162522	2	3
36152577	1119510	0	0
36157771	40228214	2	3
36473965	1124300	0	0
42801926	1149380	0	0
44349328	1192710	0	0
44355570	1125315	0	0
44362727	1125315	0	0
45641398	1119510	0	0
44351342	1717327	0	0
45620384	1125315	0	0
45667935	1129625	0	0
45657786	1107830	0	0
45634977	723013	0	0
45698736	1589505	0	0
45692519	1119510	0	0
45695037	19079524	1	1
45783590	42707627	2	3
45681472	1192710	0	0
45792258	1548195	0	0
45678739	1549786	0	0
45894313	1501700	0	0
45790474	740275	0	0
45793009	1125315	0	0
45790522	1115008	0	0
45801557	19078461	2	3
45895642	1125315	0	0
46316029	1119510	0	0
4028876	260139	3	3
3051542	3013682	1	2
21013457	740275	0	0
21600248	1310034	2	5
35508270	1115171	2	3
36152579	1124957	0	0
36152760	40228214	2	3
36474109	1125315	0	0
42801928	920293	0	0
44349328	1174888	0	0
44355723	1174888	0	0
44362523	1125315	0	0
45638137	1119510	0	0
44351287	1322184	0	0
45620441	1125315	0	0
45667613	1129625	0	0
45657787	1124957	0	0
45635092	1332418	0	0
45698685	1501700	0	0
45692431	1119510	0	0
45645661	19079524	1	1
45783579	19129655	2	3
45681473	738818	0	0
45792266	705944	0	0
45678742	1149196	0	0
45894408	1153428	0	0
45790613	1332418	0	0
45793017	1125315	0	0
45790525	1115008	0	0
46243775	19078461	2	3
45895578	1125315	0	0
46315592	1119510	0	0
4063579	4062501	3	3
1718406	1718412	1	2
21003385	975125	0	0
21600269	1310034	1	4
35508602	40224805	2	3
36152581	1107830	0	0
36152874	40228214	2	3
36468849	1177480	0	0
42802184	1545958	0	0
44349214	1149196	0	0
44355729	1713332	0	0
44362704	1125315	0	0
45638015	1119510	0	0
44351350	1713332	0	0
45620442	1125315	0	0
45667742	1129625	0	0
45657813	1110410	0	0
45635093	738818	0	0
45698687	1110410	0	0
45692491	1119510	0	0
45683153	19079524	1	1
45782678	1115171	2	3
45681583	1124957	0	0
45792062	1115008	0	0
45678744	1124957	0	0
45894412	1332418	0	0
45790418	1112807	0	0
45792825	1125315	0	0
45790638	1192710	0	0
46243853	19078461	2	3
45895626	1125315	0	0
46316009	1119510	0	0
4032377	4230209	3	3
320136	4112343	3	7
21003387	1129625	0	0
21503165	1119510	1	1
35508625	40229134	2	3
36152638	1589505	0	0
35507154	40228214	2	3
36475983	1177480	0	0
42801992	1548195	0	0
44349397	1177480	0	0
44355729	1759842	0	0
44350839	1125315	0	0
45637957	1119510	0	0
44351354	723013	0	0
45620550	1125315	0	0
45667743	1129625	0	0
45657822	1192710	0	0
45635042	1310149	0	0
45698911	1174888	0	0
45692604	1119510	0	0
45691704	19079524	1	1
45782969	40228230	2	3
45681197	1778162	0	0
45792251	1000560	0	0
45678949	1519936	0	0
45894413	1110410	0	0
45787596	705944	0	0
45792831	1125315	0	0
45790644	1115008	0	0
46294316	19078461	2	3
45895645	1125315	0	0
46310178	1119510	0	0
4032377	4234705	3	3
320136	261325	3	6
21003387	1343916	0	0
21503165	1125315	1	1
35508513	40229134	2	3
36152939	1149196	0	0
36152946	19078461	2	3
36476757	1149380	0	0
42802094	1521369	0	0
44349525	1307863	0	0
44355692	1110410	0	0
44350683	1125315	0	0
45637939	1119510	0	0
44351377	791967	0	0
45620362	1125315	0	0
45667817	1129625	0	0
45657522	1713332	0	0
45635057	1192710	0	0
45700518	1307863	0	0
45692550	1119510	0	0
45660118	19079524	1	1
45782855	40162522	2	3
45681284	1115008	0	0
45792338	1332418	0	0
45679366	1149196	0	0
45894495	1107830	0	0
45787766	1738521	0	0
45792756	1125315	0	0
45790661	1174888	0	0
45893946	19078461	2	3
45895664	1125315	0	0
46309811	1119510	0	0
4154739	4059173	3	3
320136	4294548	3	6
21003377	1192710	0	0
21503166	1119510	1	1
36203042	4142905	2	3
36152946	1177480	0	0
36157581	19078461	2	3
36476385	1129625	0	0
42802204	1322184	0	0
44349530	1521369	0	0
44355845	1107830	0	0
44350535	1125315	0	0
45638106	1119510	0	0
44347267	1545958	0	0
45620357	1125315	0	0
45665454	1129625	0	0
45657637	1124957	0	0
45635161	1500211	0	0
45700586	19127890	0	0
45692583	1119510	0	0
45704463	46275916	1	1
45782710	19018935	2	3
45681291	975125	0	0
45792197	975125	0	0
45679370	1000560	0	0
45894454	1149196	0	0
45787402	1307863	0	0
45793089	1125315	0	0
45790486	1174888	0	0
46294543	19078461	2	3
45895679	1125315	0	0
46310038	1119510	0	0
4154739	4048695	3	3
320136	40486433	3	6
21003377	1129625	0	0
21503166	1112807	1	1
35702718	4285898	2	3
36152607	1119510	0	0
35506942	19078461	2	3
36476385	1125315	0	0
42802101	1115008	0	0
44349530	1549786	0	0
44355542	1118084	0	0
44350541	1125315	0	0
45638151	1119510	0	0
44347473	791967	0	0
45620509	1125315	0	0
45665573	1129625	0	0
45657944	1501700	0	0
45635087	1149196	0	0
45700586	1549786	0	0
45692620	1119510	0	0
45704463	19079524	1	1
45782771	40231925	2	3
45681293	1326303	0	0
45792182	1112807	0	0
45705238	738818	0	0
45894456	19127890	0	0
45787426	1112807	0	0
45792852	1125315	0	0
45790487	1332418	0	0
46239541	19078461	2	3
45895686	1125315	0	0
46311900	1119510	0	0
4154739	4278672	3	3
320136	260139	3	6
21003402	19010482	0	0
21503166	1125315	1	1
36203060	4149245	2	3
36152611	738818	0	0
36157711	19078461	2	3
36476510	1125315	0	0
42802192	1119510	0	0
44349337	1545958	0	0
44355549	1112807	0	0
44350529	1125315	0	0
45638077	1119510	0	0
44347239	1545958	0	0
44362219	1125315	0	0
45665583	1129625	0	0
45657790	1107830	0	0
45635088	1332418	0	0
45700589	975125	0	0
45689619	1119510	0	0
45707121	19079524	1	1
45780544	40232448	2	3
45681298	975125	0	0
45792089	1174888	0	0
45705267	738818	0	0
45894456	1515774	0	0
45787432	1539403	0	0
45792931	1125315	0	0
45790618	1738521	0	0
45790976	19078461	2	3
45802504	1125315	0	0
46311849	1119510	0	0
4154739	4066995	3	3
77960	81151	3	5
21003378	975125	0	0
21503166	1129625	1	1
36152833	19008572	2	3
36152611	1119510	0	0
36157610	1332419	2	3
36476549	1119510	0	0
42802168	1738521	0	0
44349402	1322184	0	0
44355615	1308738	0	0
44350825	1125315	0	0
45637970	1119510	0	0
44347269	1778162	0	0
44362100	1125315	0	0
45665709	1129625	0	0
45654046	740275	0	0
45635381	1174888	0	0
45700526	914335	0	0
45689593	1119510	0	0
45645945	19079524	1	1
45780781	19133905	2	3
45681302	1149196	0	0
45792093	1124957	0	0
45780010	738818	0	0
45894456	1549786	0	0
45787408	1112807	0	0
45792935	1125315	0	0
45790492	1000560	0	0
45801472	1545959	2	3
45801989	1125315	0	0
46312027	1119510	0	0
4154739	40480160	3	3
3050940	3023103	3	5
21003400	19010482	0	0
21503166	738818	1	1
36153433	1127433	2	3
36152872	1119510	0	0
35507048	1332419	2	3
36476549	1125315	0	0
42807218	1545958	0	0
44349334	1713332	0	0
44355617	1177480	0	0
44350638	1125315	0	0
45638057	1119510	0	0
44347162	1149196	0	0
44362104	1125315	0	0
45663134	1129625	0	0
45654048	738818	0	0
45635382	1174888	0	0
45700615	1713332	0	0
45691569	1119510	0	0
45667161	19079524	1	1
45780632	19019273	2	3
45681502	1174888	0	0
45792096	1174888	0	0
45780053	738818	0	0
45894461	1174888	0	0
45787560	1124957	0	0
45793095	1125315	0	0
45790593	1549786	0	0
45796246	1545959	2	3
45801993	1125315	0	0
46310242	1119510	0	0
4103661	4066995	3	3
372887	4132546	3	3
21003404	19010482	0	0
21503166	1192710	1	1
36153336	1115171	2	3
36152923	1112807	0	0
1717327	19129655	2	3
36476622	1154343	0	0
42807040	1177480	0	0
44349354	723013	0	0
44355400	1177480	0	0
44350546	1125315	0	0
45638042	1119510	0	0
44347592	1153428	0	0
44362091	1125315	0	0
45663283	1129625	0	0
45654116	1174888	0	0
45635118	1192710	0	0
45700615	1759842	0	0
45691574	1119510	0	0
45704452	19079524	1	1
45780895	40162522	2	3
45681468	967823	0	0
45792097	1192710	0	0
45780138	738818	0	0
45894579	1332418	0	0
45787567	1112807	0	0
45793106	1125315	0	0
45790593	19127890	0	0
45790979	1332419	2	3
45801994	1125315	0	0
46310392	1119510	0	0
4042640	4337138	3	3
440142	317576	3	3
21003404	1551099	0	0
21503197	19010482	1	1
36153439	1127433	2	3
36152748	1124300	0	0
35507034	1545959	2	3
36427690	1746114	0	0
42807040	1174888	0	0
44349343	1124300	0	0
44355505	1129625	0	0
44350557	1125315	0	0
45638183	1119510	0	0
44347487	1551099	0	0
44362221	1125315	0	0
45663275	1129625	0	0
45654117	1107830	0	0
45635119	1308738	0	0
45700547	1149380	0	0
45689702	1119510	0	0
45669246	19079524	1	1
45780952	40236446	2	3
45681566	1124957	0	0
45792097	1112807	0	0
45706100	738818	0	0
45894580	1124957	0	0
45787568	1124300	0	0
45792840	1125315	0	0
45790593	1589505	0	0
46239457	1545959	2	3
45801954	1125315	0	0
46310506	1119510	0	0
4115574	196456	3	3
440142	321042	3	3
21003322	975125	0	0
21503064	1343916	1	1
36153041	1127433	2	3
36152898	975125	0	0
21502741	46233988	2	3
36426272	1107830	0	0
42807038	1551099	0	0
44349410	1539403	0	0
44355509	1112807	0	0
44350726	1125315	0	0
45638255	1119510	0	0
44347475	701322	0	0
44362323	1125315	0	0
45663349	1129625	0	0
45654120	1149196	0	0
45635392	1713332	0	0
45700549	1549786	0	0
45689765	1119510	0	0
45669387	19079524	1	1
45780291	19078924	2	3
45681436	738818	0	0
45792135	1124300	0	0
45706221	738818	0	0
45803000	1361711	0	0
45787569	1102527	0	0
45793104	1125315	0	0
45790596	705944	0	0
46243874	1332419	2	3
45801964	1125315	0	0
46310453	1119510	0	0
4040395	4010253	3	3
75053	4230399	3	3
21003393	975125	0	0
21503220	1308738	1	1
36153051	1115171	2	3
36153184	1177480	0	0
21502741	46233710	2	3
36426273	791967	0	0
42807056	1539403	0	0
44349357	1124957	0	0
44355717	1129625	0	0
44350941	1125315	0	0
45638436	1119510	0	0
44347481	1367571	0	0
44362326	1125315	0	0
45663665	1129625	0	0
45654195	1551099	0	0
45629889	1115008	0	0
45700549	1521369	0	0
45689708	1119510	0	0
45666873	19079524	1	1
45780266	40231925	2	3
45681440	1367571	0	0
45792136	1343916	0	0
45706165	738818	0	0
45803011	914335	0	0
45787660	1713332	0	0
45792869	1125315	0	0
45790599	1343916	0	0
46239540	1332419	2	3
45801951	1125315	0	0
46310414	1119510	0	0
4027553	255848	3	3
256440	4294548	3	3
21003394	1551099	0	0
21503258	1343916	1	1
36153083	1127433	2	3
36152665	1177480	0	0
21502759	40174880	2	3
36422742	1545958	0	0
42807058	705944	0	0
44349413	1515774	0	0
44355850	708298	0	0
44350925	1125315	0	0
45638270	1119510	0	0
44347272	1367571	0	0
44362330	1125315	0	0
45659991	1129625	0	0
45654199	1307863	0	0
45629897	1124300	0	0
45700549	1595799	0	0
45689871	1119510	0	0
45648486	46275916	1	1
45780202	19008572	2	3
45681312	1149196	0	0
45792139	1107830	0	0
45706176	738818	0	0
45802848	791967	0	0
45787660	1759842	0	0
45792957	1125315	0	0
45790732	1332418	0	0
46239043	1332419	2	3
45802164	1125315	0	0
46310653	1119510	0	0
4180938	4145310	3	3
443419	4156265	3	3
21003393	1551099	0	0
21503258	1119510	1	1
36153137	19008572	2	3
36152673	1124300	0	0
4180941	4275113	2	3
36422768	914335	0	0
42807091	1545958	0	0
44349512	1149380	0	0
44355864	1129625	0	0
44351058	1125315	0	0
45638279	1119510	0	0
44347603	1124300	0	0
44362261	1125315	0	0
45660009	1129625	0	0
45654202	1124957	0	0
45629899	1115008	0	0
45700573	1110410	0	0
45689686	1119510	0	0
45648515	19079524	1	1
45780328	40229134	2	3
45681419	1192710	0	0
45792268	1115008	0	0
45706265	738818	0	0
45803133	1000560	0	0
45787668	1551099	0	0
45793166	1125315	0	0
45790757	1367571	0	0
45788116	1539411	2	3
45801937	1125315	0	0
46310656	1119510	0	0
4088217	4293740	3	3
75865	4056621	3	3
21011418	1110410	0	0
21505763	914335	1	1
36153775	40223834	2	3
36153245	914335	0	0
21502750	1551192	2	3
36422731	1150770	0	0
42807125	1125315	0	0
44349514	1713332	0	0
44355864	1125315	0	0
44348371	1125315	0	0
45637128	1119510	0	0
44347498	1713332	0	0
44362199	1125315	0	0
45649367	1177480	0	0
45654211	1551099	0	0
45629900	1124957	0	0
45700574	1713332	0	0
45689632	1119510	0	0
45648540	46275916	1	1
45780275	19019273	2	3
45681422	1107830	0	0
45792270	1549786	0	0
45699774	738818	0	0
45803149	975125	0	0
45787525	967823	0	0
45793119	1125315	0	0
45790763	1500211	0	0
46290394	1539411	2	3
45801953	1125315	0	0
46310671	1119510	0	0
4088217	4197460	3	3
75865	198199	3	3
21011418	1154029	0	0
21505763	1192710	1	1
36153812	1115171	2	3
36152677	1589505	0	0
21603967	19078461	2	3
36314177	4012477	0	0
42807125	1124957	0	0
44349454	1118084	0	0
44355753	1125315	0	0
44348529	1125315	0	0
45634859	1119510	0	0
44347639	1305058	0	0
44362216	1125315	0	0
45649468	1177480	0	0
45654181	1149196	0	0
45629905	1326303	0	0
45700661	1124957	0	0
45689854	1119510	0	0
45645614	46275916	1	1
45780230	19018935	2	3
45681521	1115008	0	0
45792270	19127890	0	0
45699781	738818	0	0
45802823	1557272	0	0
45787669	1174888	0	0
45793067	1125315	0	0
45790845	1124300	0	0
45791073	1545959	2	3
45802040	1125315	0	0
46310569	1119510	0	0
4042645	4216130	3	3
134057	381316	3	3
21011412	1110410	0	0
21505957	1738521	1	1
36153544	1115171	2	3
36152798	1112807	0	0
21604344	40229134	2	3
36315060	4181917	0	0
42807128	1326303	0	0
44349463	975125	0	0
44355753	1119510	0	0
44348655	1125315	0	0
44362725	1129625	0	0
44347652	1332418	0	0
44362333	1125315	0	0
45632049	1177480	0	0
45654156	1548195	0	0
45629882	1595799	0	0
45698936	1322184	0	0
45689866	1119510	0	0
45642876	46275916	1	1
45780400	42707627	2	3
45681317	975125	0	0
45792270	1589505	0	0
45699818	738818	0	0
45803025	1322184	0	0
45787674	975125	0	0
45793080	1125315	0	0
45790854	1326303	0	0
46243978	1545959	2	3
45802045	1125315	0	0
46310596	1119510	0	0
4042673	4078793	3	3
443883	260139	3	3
21009234	1746114	0	0
21505772	1112807	1	1
36153672	40232448	2	3
36152639	1512674	0	0
21604344	40231925	2	3
40236824	40236824	0	0
42807317	742185	0	0
44349467	1308738	0	0
44355852	1545958	0	0
44346851	1125315	0	0
44361848	1129625	0	0
44347654	1115008	0	0
44362334	1125315	0	0
45632058	1177480	0	0
45654264	1589505	0	0
45629864	1110410	0	0
45698941	1501700	0	0
45686543	1119510	0	0
45642840	46275916	1	1
45777763	19133905	2	3
45681574	1107830	0	0
45792340	1000560	0	0
45693523	738818	0	0
45803093	1501700	0	0
45787676	1115008	0	0
45793218	1125315	0	0
45790548	1521369	0	0
46244285	1539411	2	3
45802046	1125315	0	0
46310755	1119510	0	0
4176967	4058899	3	3
443883	4112343	3	3
21011412	1154029	0	0
21505772	1125315	1	1
36154122	1115171	2	3
36152682	1119510	0	0
21502747	1545959	2	3
40236446	40236446	0	0
42807135	19039298	0	0
44349368	1118084	0	0
44355853	1125315	0	0
44346930	1125315	0	0
44361951	1129625	0	0
44347283	791967	0	0
44362411	1125315	0	0
45632127	1177480	0	0
45654264	1549786	0	0
45630009	1539403	0	0
45698943	738818	0	0
45686780	1119510	0	0
45685611	46275916	1	1
45777763	19133873	2	3
45681643	1149196	0	0
45792202	975125	0	0
45693494	738818	0	0
45802828	757627	0	0
45787625	1153428	0	0
45793220	1125315	0	0
45790557	1551099	0	0
46239701	1539411	2	3
45802105	1125315	0	0
46310770	1119510	0	0
4176967	4047491	3	3
440921	4296205	3	3
21011074	1112807	0	0
21505772	1129625	1	1
36154123	40232448	2	3
36152639	1549786	0	0
21502747	1539411	2	3
36429173	1150836	0	0
42807139	1728416	0	0
44349447	1174888	0	0
44355853	1124957	0	0
44346880	1125315	0	0
44362206	1129625	0	0
44347440	1738521	0	0
44362422	1125315	0	0
45632208	1177480	0	0
45654379	1326303	0	0
45630112	1551099	0	0
45698920	1115008	0	0
45686450	1119510	0	0
45685964	46275916	1	1
45777720	19019273	2	3
45681594	1539403	0	0
45792212	975125	0	0
45693608	738818	0	0
45802931	1551099	0	0
45787629	1174888	0	0
45793324	1125315	0	0
45790558	1115008	0	0
46239033	1539411	2	3
45802108	1125315	0	0
46310532	1119510	0	0
4115260	255848	3	3
75047	4134304	3	3
21011104	1367571	0	0
21505758	1177480	1	1
36153271	40229134	2	3
36152716	1177480	0	0
36217206	19008572	2	3
36429128	1741122	0	0
42807229	1115008	0	0
44349451	791967	0	0
44355869	1119510	0	0
44346947	1125315	0	0
44362171	1129625	0	0
44347738	1149196	0	0
44362475	1125315	0	0
45632017	1177480	0	0
45654387	738818	0	0
45630115	1589505	0	0
45698988	1549786	0	0
45686866	1119510	0	0
45636779	46275916	1	1
45777726	40229134	2	3
45681555	1332418	0	0
45792376	1112807	0	0
45693905	738818	0	0
45802937	1521369	0	0
45787722	1192710	0	0
45793027	1125315	0	0
45790564	967823	0	0
45804168	19127918	2	2
45802111	1125315	0	0
46304885	1119510	0	0
4154162	4132546	3	3
3050951	3045716	3	3
21011189	967823	0	0
21505772	1192710	1	1
36153996	19008572	2	3
36152874	1149196	0	0
36217210	19078924	2	3
36427783	1548195	0	0
42807236	19127890	0	0
44349608	1717327	0	0
44355956	1125315	0	0
44346916	1125315	0	0
45655998	1129625	0	0
44347742	1124300	0	0
44362564	1125315	0	0
45634073	1177480	0	0
45654310	738818	0	0
45630119	1124957	0	0
45698988	1512674	0	0
45686615	1119510	0	0
45633559	19079524	1	1
45777656	1115171	2	3
45681580	1149196	0	0
45792377	1153428	0	0
45690768	738818	0	0
45802937	1549786	0	0
45787723	1137529	0	0
45793334	1125315	0	0
45790979	1332418	0	0
45804168	19128009	2	2
45801919	1125315	0	0
46305431	1119510	0	0
4154162	4156265	3	3
3050951	3015632	3	3
21011191	967823	0	0
21505758	1129625	1	1
36153929	19077344	2	3
36153080	1112807	0	0
36217210	40224805	2	3
36426554	701322	0	0
42807236	1515774	0	0
44349429	1115008	0	0
44355873	1149196	0	0
44347048	1125315	0	0
45656327	1129625	0	0
44347451	1713332	0	0
44362450	1125315	0	0
45633949	1177480	0	0
45654311	1124957	0	0
45630127	1115008	0	0
45698988	19127890	0	0
45686738	1119510	0	0
45633766	46275916	1	1
45777796	19008572	2	3
45681630	1149196	0	0
45792384	19039298	0	0
45690819	738818	0	0
45802943	1512674	0	0
45787724	1174888	0	0
45792132	1125315	0	0
45790838	1551099	0	0
45787205	19128022	2	2
45802122	1125315	0	0
46305003	1119510	0	0
4103320	4283893	3	3
3033521	3000963	3	3
21011482	1551099	0	0
21503358	1343916	1	1
36153328	1115171	2	3
36152640	1107830	0	0
36217210	40220960	2	3
36426524	1500211	0	0
42807236	1549786	0	0
44349618	1549786	0	0
44355967	1551099	0	0
44347071	1125315	0	0
45656155	1129625	0	0
44347451	1759842	0	0
44362668	1125315	0	0
45634226	1177480	0	0
45654327	1149196	0	0
45630133	1174888	0	0
45699041	1115008	0	0
45686720	1119510	0	0
45633851	19079524	1	1
45777790	43012036	2	3
45681636	1332418	0	0
45792391	1115008	0	0
45687758	738818	0	0
45802943	19127890	0	0
45787735	1548195	0	0
45792081	1125315	0	0
45790957	975125	0	0
46296901	40232448	2	3
45801982	1125315	0	0
46305008	1119510	0	0
4181063	258780	3	3
3051542	3045716	3	3
21011491	723013	0	0
21503364	975125	1	1
36153330	1127433	2	3
36152646	1115008	0	0
36217210	46275916	2	3
36424040	1308738	0	0
42807238	1729720	0	0
44349619	975125	0	0
44355972	1129625	0	0
44347175	1125315	0	0
45656406	1129625	0	0
44347396	1729720	0	0
44362684	1125315	0	0
45634244	1177480	0	0
45654271	1545958	0	0
45630139	1521369	0	0
45698933	738818	0	0
45686883	1119510	0	0
45633871	46275916	1	1
45706422	40224805	2	3
45681612	738818	0	0
45675985	1192710	0	0
45687895	738818	0	0
45802943	1549786	0	0
45787759	967823	0	0
45790256	1125315	0	0
45790812	1519936	0	0
46296702	19073183	2	3
45802117	1125315	0	0
46305445	1119510	0	0
4181063	40486433	3	3
3051542	3015632	3	3
21011655	975125	0	0
21503371	1129625	1	1
36154133	1127433	2	3
36152908	1107830	0	0
36217220	40229134	2	3
36425676	1177480	0	0
42807286	1501700	0	0
44349621	1118084	0	0
44356088	1361711	0	0
44347009	1125315	0	0
45656409	1129625	0	0
44347398	1778162	0	0
44362440	1125315	0	0
45629263	1177480	0	0
45654313	1124957	0	0
45629882	1308738	0	0
45699008	1307863	0	0
45686964	1119510	0	0
45628268	46275916	1	1
45706450	19019273	2	3
45679754	738818	0	0
45675884	1124300	0	0
45687504	738818	0	0
45802945	1110410	0	0
45787791	975125	0	0
45790372	1125315	0	0
45790899	1322184	0	0
46295026	40232448	2	3
45802252	1125315	0	0
46305016	1119510	0	0
4103183	317576	3	3
443784	317576	3	3
21002690	1149380	0	0
21503371	975125	1	1
36154189	19057271	2	3
36152742	1107830	0	0
36217220	19112599	2	3
36426641	1503184	0	0
42807288	1125315	0	0
44349572	1149196	0	0
44356105	738818	0	0
44347022	1125315	0	0
45652522	1129625	0	0
44347399	1115008	0	0
44362487	1125315	0	0
45629070	1177480	0	0
45654402	1308738	0	0
45630251	1501700	0	0
45699111	1501700	0	0
45687002	1119510	0	0
45628658	19079524	1	1
45706462	19133768	2	3
45679777	975125	0	0
45676046	1149196	0	0
45684607	738818	0	0
45803101	723013	0	0
45787801	1149196	0	0
45790704	1125315	0	0
45790902	1124300	0	0
46295107	19018935	2	3
45802086	1125315	0	0
46305571	1119510	0	0
4103183	321042	3	3
443784	4310024	3	3
21002731	1521369	0	0
21503445	1125315	1	1
36154199	40232448	2	3
36152743	1153428	0	0
36217220	40222846	2	3
36423453	1768849	0	0
42807330	1000560	0	0
44349574	1000560	0	0
44356105	1125315	0	0
44347024	1125315	0	0
45652751	1129625	0	0
44347456	1551099	0	0
45661796	1125315	0	0
45627994	1177480	0	0
45654150	914335	0	0
45629866	1174888	0	0
45695458	1153428	0	0
45687015	1119510	0	0
45628409	19079524	1	1
45706462	40162522	2	3
45679759	791967	0	0
45675972	1545958	0	0
45684726	738818	0	0
45803102	1112807	0	0
45789173	757627	0	0
45790361	1125315	0	0
45790907	1713332	0	0
46295113	40236824	2	3
45802152	1125315	0	0
46305574	1119510	0	0
4103662	381316	3	3
320136	441267	3	3
21002731	1548195	0	0
21500540	740275	1	1
36154057	19008572	2	3
36152687	1521369	0	0
36217220	19074679	2	3
36423483	1118084	0	0
42807384	1177480	0	0
44349734	1361711	0	0
44356105	1119510	0	0
44347092	1125315	0	0
45655054	1129625	0	0
44347528	1310149	0	0
44355092	1125315	0	0
45626134	1177480	0	0
45654152	1332418	0	0
45629994	975125	0	0
45695466	1115008	0	0
45687017	1119510	0	0
45627877	46275916	1	1
45706668	1115171	2	3
45679416	1107830	0	0
45675973	975125	0	0
45681281	738818	0	0
45803108	1332418	0	0
45789335	1309944	0	0
45790299	1125315	0	0
45790572	1154029	0	0
46295173	19019273	2	3
45802156	1125315	0	0
46305330	1119510	0	0
4178367	4163872	3	3
443783	4056621	3	3
21002731	975125	0	0
21503445	1308738	1	1
36154110	1127433	2	3
36152810	1177480	0	0
36217214	19078461	2	3
36423477	1778162	0	0
42807390	1124300	0	0
44349373	1332418	0	0
44355862	1557272	0	0
44347111	1125315	0	0
45655180	1129625	0	0
44347529	1192710	0	0
44354966	1125315	0	0
45626327	1177480	0	0
45654243	757627	0	0
45630079	1149196	0	0
45695472	1551099	0	0
45687034	1119510	0	0
45676210	46275916	1	1
45706826	40232448	2	3
45679424	1110410	0	0
45676047	1115008	0	0
45681927	738818	0	0
45803218	1343916	0	0
45789286	1501700	0	0
45790347	1125315	0	0
45790626	1589505	0	0
46295153	40232448	2	3
45802089	1125315	0	0
46305332	1119510	0	0
4178367	4243062	3	3
443783	261325	3	3
21002731	1595799	0	0
21503592	967823	1	1
36154111	40232448	2	3
36152812	1119510	0	0
36217214	19125062	2	3
36423476	1778162	0	0
42807382	723013	0	0
44349749	1124957	0	0
42805192	1177480	0	0
44347297	1125315	0	0
45655314	1129625	0	0
44347560	975125	0	0
44354713	1125315	0	0
45626328	1177480	0	0
45654252	1115008	0	0
45630082	975125	0	0
45695474	738818	0	0
45683632	1119510	0	0
45625025	46275916	1	1
45706799	40231925	2	3
45678190	1521369	0	0
45676051	1115008	0	0
45681941	738818	0	0
45803059	1112807	0	0
45789298	1557272	0	0
45790243	1125315	0	0
45790626	1549786	0	0
46295408	1115171	2	3
45802127	1125315	0	0
46305506	1119510	0	0
4043686	4047491	3	3
444089	4266809	3	3
21002731	19054876	0	0
21503467	1595799	1	1
36156311	40232448	2	3
36152812	738818	0	0
36217214	40229134	2	3
36428377	1154343	0	0
42807366	1124300	0	0
44349751	1729720	0	0
42805196	701322	0	0
44347298	1125315	0	0
45652791	1129625	0	0
44347567	1713332	0	0
44355015	1125315	0	0
45626337	1177480	0	0
45654390	1778162	0	0
45630083	1124957	0	0
45695511	1308738	0	0
45683709	1119510	0	0
45625060	19079524	1	1
45706835	40232448	2	3
45678190	1548195	0	0
45676078	1192710	0	0
45681735	738818	0	0
45803242	1115008	0	0
45789305	1124957	0	0
45790291	1125315	0	0
45790786	1174888	0	0
46295213	35605482	2	3
45802248	1125315	0	0
46305360	1119510	0	0
4168644	438614	3	3
135930	80180	3	3
21002731	1589505	0	0
21503474	1595799	1	1
36156375	1551192	2	3
36152823	933724	0	0
4181063	260139	2	2
36423511	1149196	0	0
42809676	1177480	0	0
44349753	1153428	0	0
42805204	1738521	0	0
44347449	1125315	0	0
45652760	1129625	0	0
44347567	1759842	0	0
44355226	1125315	0	0
45626282	1177480	0	0
45654320	791967	0	0
45630099	1192710	0	0
45695644	1332418	0	0
45683747	1119510	0	0
45670485	19079524	1	1
45702765	40232448	2	3
45678191	738818	0	0
45676142	933724	0	0
45681944	738818	0	0
45803249	791967	0	0
45789307	1174888	0	0
45790307	1125315	0	0
45790789	715997	0	0
46295628	40224805	2	3
45802233	1125315	0	0
46305384	1119510	0	0
4168644	4306014	3	3
1521369	19127922	3	4
21002731	1549786	0	0
21503474	1396131	1	1
36154202	40162522	2	3
36152647	791967	0	0
4181063	255848	2	2
36502197	40480160	6	8
42807353	1549786	0	0
44349603	1112807	0	0
42805283	1713332	0	0
44347057	1125315	0	0
45652849	1129625	0	0
44347460	1115008	0	0
44355138	1125315	0	0
45626342	1177480	0	0
45654499	1717327	0	0
45630108	1741122	0	0
45695627	1153428	0	0
45683693	1119510	0	0
45670722	19115351	1	1
45703088	40231925	2	3
45678151	1501700	0	0
45676148	1115008	0	0
45673297	738818	0	0
45803250	975125	0	0
45789406	1717327	0	0
45790440	1125315	0	0
45790683	1557272	0	0
46295252	40232448	2	3
45802213	1125315	0	0
46306723	1119510	0	0
4168644	439406	3	3
1521369	42902245	3	4
21002731	1738521	0	0
21503474	1308738	1	1
36154247	35605482	2	3
36152648	1129625	0	0
4181063	80809	2	2
36502197	4066995	7	8
42810048	1177480	0	0
44349653	1396131	0	0
42805286	1549786	0	0
44343221	1125315	0	0
45649681	1129625	0	0
44347545	738818	0	0
44354940	1125315	0	0
45626366	1177480	0	0
45654447	738818	0	0
45630108	1746114	0	0
45695487	1307863	0	0
45683658	1119510	0	0
45669222	46275916	1	1
45703089	40229134	2	3
45678124	1717327	0	0
45676344	1310149	0	0
45784507	738818	0	0
45803205	1124957	0	0
45789411	1000560	0	0
45790532	1125315	0	0
45790685	1124957	0	0
46244325	40229134	2	3
45802343	1125315	0	0
46306979	1119510	0	0
4168644	4102123	3	3
1521369	19133679	3	4
21002731	1515774	0	0
21503478	967823	1	1
36154251	19018935	2	3
36152654	1539403	0	0
4181063	440448	2	2
36502197	4048695	7	8
42808536	1125315	0	0
44349654	1738521	0	0
42805286	1518198	0	0
44343229	1125315	0	0
45649649	1129625	0	0
44347871	1713332	0	0
44354945	1125315	0	0
45622801	1177480	0	0
45654392	1154343	0	0
45630227	1107830	0	0
45695657	1322184	0	0
45670732	1713332	0	0
45669201	46275916	1	1
45702869	40232448	2	3
45678092	1539403	0	0
45676483	920293	0	0
45784993	738818	0	0
45803311	1124957	0	0
45789310	1115008	0	0
45790535	1125315	0	0
45790687	1174888	0	0
46244337	40229134	2	3
45802335	1125315	0	0
46321684	1119510	0	0
4168644	4048169	3	3
1521369	19129144	3	4
21002731	19127890	0	0
21503584	1192710	1	1
36154294	1551192	2	3
36152688	1124300	0	0
4181063	134438	2	2
36502197	4059173	7	8
42808536	738818	0	0
44349659	1713332	0	0
42805212	1332418	0	0
44342974	1125315	0	0
45649830	1129625	0	0
44347775	1326303	0	0
44354949	1125315	0	0
45623224	1177480	0	0
45654506	708298	0	0
45630043	1310149	0	0
45695494	1521369	0	0
45670732	1759842	0	0
45666866	46275916	1	1
45702980	19133905	2	3
45678097	1115008	0	0
45676570	1361711	0	0
45782435	738818	0	0
45803313	1112807	0	0
45789312	914335	0	0
45790538	1125315	0	0
45790990	1174888	0	0
46244419	40232448	2	3
45799184	1125315	0	0
46321817	1119510	0	0
4168644	4304110	3	3
1521369	19128065	3	4
21002692	975125	0	0
21503469	1192710	1	1
36154284	1551192	2	3
36152689	1119510	0	0
4181060	44805732	2	2
36502197	40479422	7	8
42808536	1119510	0	0
44349557	1174888	0	0
42805213	1115008	0	0
44342977	1125315	0	0
45646323	1129625	0	0
44347777	1107830	0	0
44355051	1125315	0	0
45624897	1177480	0	0
45654507	742185	0	0
45630061	1154343	0	0
45695635	967823	0	0
45670883	1738521	0	0
45666974	46275916	1	1
45702980	19133873	2	3
45678081	791967	0	0
45676351	1501700	0	0
45782749	738818	0	0
45803314	1149196	0	0
45789315	967823	0	0
45790545	1125315	0	0
45790717	975125	0	0
46244497	1115171	2	3
45799390	1125315	0	0
46321718	1119510	0	0
4168644	4169137	3	3
135930	80502	3	4
21002694	1129625	0	0
21500744	967823	1	1
36154341	1127433	2	3
36152697	1107830	0	0
21603283	40169281	2	2
36502197	40479768	7	8
42810317	1125315	0	0
44349659	1759842	0	0
42805274	1125315	0	0
44343361	1125315	0	0
45646327	1129625	0	0
44347625	1192710	0	0
44355181	1125315	0	0
45624905	1177480	0	0
45654515	1000560	0	0
45630018	1149196	0	0
45695272	1713332	0	0
45670843	1192710	0	0
45666951	46275916	1	1
45703938	40232448	2	3
45678364	1115008	0	0
45789118	1545958	0	0
45782775	738818	0	0
45802968	967823	0	0
45787825	1115008	0	0
45790414	1125315	0	0
46297546	1115008	0	0
46244434	40236446	2	3
45799492	1125315	0	0
46321723	1119510	0	0
4168644	4302207	3	3
440142	4329847	3	4
21002745	1149196	0	0
21500709	1396131	1	1
35902849	198809	2	3
36153255	1192710	0	0
36102149	255848	2	2
36502197	4278672	7	8
42807391	1343916	0	0
44349562	1118084	0	0
42805289	715997	0	0
44343362	1125315	0	0
45646367	1129625	0	0
44347778	791967	0	0
44355202	1125315	0	0
45625103	1177480	0	0
45654255	1107830	0	0
45629915	1115008	0	0
45695433	715997	0	0
45670829	1149196	0	0
45707347	19079524	1	1
45703771	40163554	2	3
45678492	1551099	0	0
45789120	1310149	0	0
45780328	738818	0	0
45803210	1332418	0	0
45787826	1149380	0	0
45790418	1125315	0	0
46297692	1154029	0	0
46244596	40229134	2	3
45799621	1125315	0	0
46321792	1119510	0	0
4168644	4139681	3	3
320136	4283893	3	4
21002694	1192710	0	0
21500709	1308738	1	1
36203066	4156265	2	3
35529060	1177480	0	0
36102149	440448	2	2
36502197	4149245	7	8
42810072	1119510	0	0
44349700	933724	0	0
42805291	723013	0	0
44343071	1125315	0	0
45649109	1129625	0	0
44347576	1557272	0	0
45655494	1125315	0	0
45623258	1177480	0	0
45654455	1539403	0	0
45630027	1192710	0	0
45695517	1500211	0	0
45670836	920293	0	0
45704229	46275916	1	1
45704079	19126352	2	3
45678494	1778162	0	0
45789123	920293	0	0
45780306	738818	0	0
45803290	975125	0	0
45787827	1112807	0	0
45790606	1125315	0	0
46297699	1153428	0	0
46244606	40236824	2	3
45799392	1125315	0	0
46316468	1119510	0	0
4168644	442116	3	3
1515774	19128263	3	4
21002743	1150836	0	0
21500720	1595799	1	1
36152830	1545959	2	3
35529067	19127890	0	0
36102149	372328	2	2
36502197	4134304	9	10
42810072	1125315	0	0
44349664	742185	0	0
42805183	1124300	0	0
44343113	1125315	0	0
45646545	1129625	0	0
44347792	740275	0	0
44347846	1125315	0	0
45621404	1177480	0	0
45654080	1308738	0	0
45630191	1545958	0	0
45695578	1539403	0	0
45670767	738818	0	0
45704332	46275916	1	1
45703717	40231925	2	3
45678428	1153428	0	0
45789127	1192710	0	0
45777762	738818	0	0
45803119	1112807	0	0
45787908	1115008	0	0
45790501	1125315	0	0
46297716	1153428	0	0
46244458	19019273	2	3
45799449	1125315	0	0
46316410	1119510	0	0
4043016	4199276	3	3
1515774	19128022	3	4
21002745	1129625	0	0
21500720	1308738	1	1
36156274	1107882	2	3
35529067	1515774	0	0
36102149	4283893	2	2
36502197	78272	9	10
42810275	1112807	0	0
44349856	1115008	0	0
42805184	1332418	0	0
44343161	1125315	0	0
45646477	1129625	0	0
44347802	1115008	0	0
44347517	1125315	0	0
45621523	1177480	0	0
45654474	1110410	0	0
45629982	914335	0	0
45695645	1738521	0	0
45670775	1713332	0	0
45704538	46275916	1	1
45703129	40232448	2	3
45678131	1154343	0	0
45789130	1124300	0	0
45777726	738818	0	0
45803400	738818	0	0
45787845	1549786	0	0
45787597	1125315	0	0
46297721	1192710	0	0
46244459	43012036	2	3
45799456	1125315	0	0
46316404	1119510	0	0
4155793	4163872	3	3
134057	317576	3	4
21002731	1512674	0	0
21503179	40169281	1	1
36217219	1519937	2	3
35529067	1549786	0	0
36102149	195588	2	2
36502197	81151	6	9
42804734	1000560	0	0
44349859	1713332	0	0
42805220	1177480	0	0
44343407	1125315	0	0
45646458	1129625	0	0
44347214	1521369	0	0
44347826	1125315	0	0
45621766	1177480	0	0
45654456	1332418	0	0
45630276	1307863	0	0
45695441	1326303	0	0
45670775	1759842	0	0
45700802	40220386	1	1
45703108	19133905	2	3
45678141	1521369	0	0
45789390	1149196	0	0
45777748	738818	0	0
45803373	1149196	0	0
45787845	1519936	0	0
45787560	1125315	0	0
46297472	1549786	0	0
46244547	19059056	2	3
45799460	1125315	0	0
46316429	1119510	0	0
4155793	4243062	3	3
31057	4112343	3	4
21002745	1107830	0	0
21001868	1154615	1	1
36217219	43012754	2	3
35509184	1110410	0	0
21604753	705944	2	2
36502197	4230399	8	9
42804735	1738521	0	0
44349761	1326303	0	0
42805301	1118084	0	0
44343411	1125315	0	0
45646733	1129625	0	0
44347812	1539403	0	0
44347526	1125315	0	0
45621811	1177480	0	0
45654486	1110410	0	0
45630258	738818	0	0
45695619	1332418	0	0
45670821	1738521	0	0
45700982	46275916	1	1
45703147	782047	2	3
45678142	19127890	0	0
45789379	1174888	0	0
45703089	738818	0	0
45803260	1396131	0	0
45787875	1000560	0	0
45787669	1125315	0	0
46297637	1343916	0	0
45893781	46233710	2	3
45799319	1125315	0	0
46316605	1119510	0	0
4071689	381316	3	3
75909	4237458	3	4
21002745	1150836	0	0
21002499	19128263	1	1
36217219	1718412	2	3
35509188	1119510	0	0
21604753	742185	2	2
36208978	3004501	3	3
42804736	1125315	0	0
44350045	1124957	0	0
42805306	967823	0	0
44343422	1125315	0	0
45646767	1129625	0	0
44347363	1500211	0	0
44347717	1125315	0	0
45665266	1177480	0	0
45654494	1107830	0	0
45630259	19010482	0	0
45695816	1738521	0	0
45671092	1361711	0	0
45700887	46275916	1	1
45703165	1127433	2	3
45678142	1549786	0	0
45789319	1107830	0	0
45699984	738818	0	0
45803326	1124957	0	0
45787865	967823	0	0
45787629	1125315	0	0
46297576	914335	0	0
45789280	19078461	2	3
45799320	1125315	0	0
46316693	1119510	0	0
4168335	4109685	3	3
3050940	3016723	3	4
21002694	975125	0	0
21002499	42902245	1	1
36217219	19132304	2	3
36157065	1119510	0	0
4041268	4010253	2	2
36211303	381316	3	3
42804736	1174888	0	0
44350046	738818	0	0
42805293	1124300	0	0
44343423	1125315	0	0
45643458	1129625	0	0
44347781	1149380	0	0
44347720	1125315	0	0
45665370	1177480	0	0
45654086	791967	0	0
45630172	738818	0	0
45695849	708298	0	0
45670797	1738521	0	0
45694971	46275916	1	1
45703192	19133768	2	3
45678176	1149196	0	0
45789333	920293	0	0
45700199	738818	0	0
45803331	1124957	0	0
45788118	1149196	0	0
45787722	1125315	0	0
46297744	1124957	0	0
45802222	19075601	2	3
45799466	1125315	0	0
46316546	1119510	0	0
4168335	4155034	3	3
3050940	3013682	3	4
21002745	1192710	0	0
21002499	19128022	1	1
36217219	46221626	2	3
36157237	1129625	0	0
21603991	1118084	2	2
36211303	4329847	3	3
42804737	723013	0	0
44341980	1107830	0	0
42805295	1310149	0	0
44343501	1125315	0	0
45643700	1129625	0	0
44347922	1124957	0	0
44347722	1125315	0	0
45667455	1177480	0	0
45654369	1548195	0	0
45630175	1551099	0	0
45695670	1305058	0	0
45670799	1115008	0	0
45694999	46275916	1	1
45703192	40162522	2	3
45678182	1154029	0	0
45791746	967823	0	0
45700282	738818	0	0
45800456	738818	0	0
45788120	1521369	0	0
45787724	1125315	0	0
46297754	1174888	0	0
45802426	19075001	2	3
45799559	1125315	0	0
46316191	1119510	0	0
4168335	4113008	3	3
1512675	19127904	2	2
21002694	738818	0	0
21001920	1154615	1	1
36217219	43012433	2	3
36156633	1343916	0	0
19109535	40221415	2	2
36211303	4094814	3	3
42804709	1759842	0	0
44341760	1112807	0	0
42805281	1118084	0	0
44343515	1125315	0	0
45643577	1129625	0	0
44347931	1118084	0	0
44347913	1125315	0	0
45662801	1177480	0	0
45652033	920293	0	0
45630181	1124957	0	0
45695678	1174888	0	0
45670853	1512674	0	0
45688947	46275916	1	1
45703108	19133873	2	3
45678284	1717327	0	0
45791748	1000560	0	0
45696895	738818	0	0
45800463	1713332	0	0
45786307	1149196	0	0
45787726	1125315	0	0
46297643	967823	0	0
45793657	19078924	2	3
45799613	1125315	0	0
46310788	1119510	0	0
4090615	4149245	3	3
443783	44782520	2	2
21002708	1124300	0	0
21001857	40169281	1	1
36203090	4066995	2	3
36156634	1177480	0	0
35624868	4156265	2	2
36211325	4155034	3	3
42804811	1713332	0	0
44341765	1177480	0	0
42805361	1149380	0	0
44343477	1125315	0	0
45643690	1129625	0	0
44347685	1107830	0	0
44347957	1125315	0	0
45662751	1177480	0	0
45652042	1501700	0	0
45630183	1521369	0	0
45695727	1367571	0	0
45670853	19127890	0	0
45686174	19074679	1	1
45703118	35605482	2	3
45678292	1192710	0	0
45792111	967823	0	0
45693880	738818	0	0
45800463	1759842	0	0
45786329	708298	0	0
45787733	1125315	0	0
46297239	975125	0	0
45794630	19075001	2	3
45799540	1125315	0	0
46310690	1119510	0	0
4168166	4336464	3	3
443783	257012	2	2
21002745	738818	0	0
21001878	40169281	1	1
36153566	1107882	2	3
36157208	1512674	0	0
4112892	4295880	2	2
36211325	4109685	3	3
42804811	1759842	0	0
44341801	738818	0	0
44348936	701322	0	0
44343479	1125315	0	0
45643518	1129625	0	0
44347686	1154343	0	0
44348450	1125315	0	0
45664428	1177480	0	0
45652187	738818	0	0
45630354	1192710	0	0
45695718	1149196	0	0
45670853	1549786	0	0
45682386	19079524	1	1
45700111	19008572	2	3
45678294	738818	0	0
45792112	1112807	0	0
45693897	738818	0	0
45800400	1107830	0	0
45786223	1500211	0	0
45787792	1125315	0	0
46297427	975125	0	0
45788663	40223768	2	3
45799671	1125315	0	0
46305763	1119510	0	0
4180653	4181917	3	3
443783	4280726	2	2
21002745	1150770	0	0
21503379	1192710	1	1
36152955	1107882	2	3
36157258	1515774	0	0
35602099	4280726	2	2
36211325	4113008	3	3
42804666	1713332	0	0
44341803	1118084	0	0
44348944	1759842	0	0
44343484	1125315	0	0
45643761	1129625	0	0
44343618	1501700	0	0
44348553	1125315	0	0
45659659	1177480	0	0
45652193	914335	0	0
45630359	1310149	0	0
45695683	1149196	0	0
45670805	1107830	0	0
45659884	1107830	0	0
45700004	19076374	2	3
45678243	1310149	0	0
45792073	1154029	0	0
45693955	738818	0	0
45800412	967823	0	0
45786337	1548195	0	0
45787796	1125315	0	0
46297449	933724	0	0
46298457	40223768	2	3
45799578	1125315	0	0
46305830	1119510	0	0
4090614	40486433	3	3
31821	140673	2	2
21002745	1153428	0	0
21002491	40221415	1	1
36153762	1107882	2	3
36157258	19127890	0	0
4268896	44783196	2	2
35809117	195588	3	3
42804622	1000560	0	0
44342121	1000560	0	0
44348706	757627	0	0
44343527	1125315	0	0
45640699	1129625	0	0
44343349	1713332	0	0
44348556	1125315	0	0
45659619	1177480	0	0
45651962	1521369	0	0
45630365	1192710	0	0
45695758	1778162	0	0
45671015	1115008	0	0
45660029	1548195	0	0
45700084	1115171	2	3
45678264	1713332	0	0
45792076	1112807	0	0
45694085	738818	0	0
45800427	1778162	0	0
45786399	1000560	0	0
45787820	1125315	0	0
46297663	1174888	0	0
45788866	40223768	2	3
45799638	1125315	0	0
46305896	1119510	0	0
4090614	4280726	3	3
320136	4051466	2	2
21002775	1305058	0	0
21001919	1154615	1	1
36154366	40228214	2	3
36157258	1549786	0	0
36102932	28060	2	2
36211091	40479422	3	3
42804694	933724	0	0
44342122	738818	0	0
44348707	1521369	0	0
44339802	1125315	0	0
45640726	1129625	0	0
44343358	1124300	0	0
44348562	1125315	0	0
45659971	1177480	0	0
45651962	1595799	0	0
45630183	1549786	0	0
45695497	1124300	0	0
45670742	1192710	0	0
45660102	738818	0	0
45700236	19073183	2	3
45678247	1174888	0	0
45792070	1124957	0	0
45694158	738818	0	0
45800483	1107830	0	0
45786301	1174888	0	0
45789299	1125315	0	0
46297607	1115008	0	0
46244274	19078461	2	3
45799592	1125315	0	0
46305901	1119510	0	0
4154161	4155034	3	3
1521406	19128065	2	2
21002773	1746114	0	0
21013627	40171902	1	1
36218509	40221415	2	3
36157261	19127890	0	0
21604200	19059528	2	2
36211091	40479768	3	3
42804679	1713332	0	0
44341805	1192710	0	0
44348707	1549786	0	0
44339847	1125315	0	0
45641039	1129625	0	0
44343552	738818	0	0
44348001	1125315	0	0
45659823	1177480	0	0
45651962	1549786	0	0
45630203	1149196	0	0
45695687	920293	0	0
45670863	19002770	0	0
45661337	1717327	0	0
45700286	40174880	2	3
45678250	1192710	0	0
45789421	715997	0	0
45694015	738818	0	0
45800458	1326303	0	0
45786313	1124957	0	0
45789278	1125315	0	0
46297622	1153428	0	0
46295329	1107882	2	3
45799600	1125315	0	0
46306119	1119510	0	0
4154161	4152936	3	3
321588	317576	2	2
21002773	1717327	0	0
21002502	40221415	1	1
35508273	19078461	2	3
36157261	1549786	0	0
21604200	1154029	2	2
36211088	40479422	3	3
42804695	1545958	0	0
44341806	1549786	0	0
44348711	1125315	0	0
44339906	1125315	0	0
45640849	1129625	0	0
44343564	1118084	0	0
44348002	1125315	0	0
45659946	1177480	0	0
45652052	1500211	0	0
45630401	1551099	0	0
45695596	1149196	0	0
45671099	914335	0	0
45661465	715997	0	0
45682143	1192710	0	0
45678389	1110410	0	0
45789435	1778162	0	0
45691206	738818	0	0
45800437	1713332	0	0
45786362	701322	0	0
45789305	1125315	0	0
46298058	1738521	0	0
45788322	1107882	2	3
45796811	1125315	0	0
46305843	1119510	0	0
4154161	378001	3	3
440059	4056621	2	2
21002743	1149196	0	0
21002502	19128009	1	1
36154304	40228214	2	3
36156741	1589505	0	0
21604200	19016749	2	2
36211088	40479768	3	3
42804815	1125315	0	0
44341806	1515774	0	0
44348713	723013	0	0
44339775	1125315	0	0
45640852	1129625	0	0
44343579	1515774	0	0
44348105	1125315	0	0
45659784	1177480	0	0
45651968	1000560	0	0
45629956	1545958	0	0
45695601	723013	0	0
45671017	1153428	0	0
45661620	1367571	0	0
45679989	1107830	0	0
45678393	1124957	0	0
45789447	975125	0	0
45691093	738818	0	0
45800437	1759842	0	0
45786414	1307863	0	0
45789307	1125315	0	0
46297832	1192710	0	0
45788305	1107882	2	3
45796665	1125315	0	0
46306138	1119510	0	0
4154161	4113008	3	3
75053	4059173	2	2
21002743	1107830	0	0
21002502	42902245	1	1
36153639	19078461	2	3
36156821	1119510	0	0
21603940	1124300	2	2
36211088	81151	3	3
42804952	1115008	0	0
44341848	914335	0	0
44348494	1545958	0	0
44339754	1125315	0	0
45640874	1129625	0	0
44343579	1549786	0	0
44348111	1125315	0	0
45660049	1177480	0	0
45652196	1149196	0	0
45630392	1115008	0	0
45695602	1149196	0	0
45671020	1589505	0	0
45661298	701322	0	0
45680007	708298	0	0
45678210	967823	0	0
45789453	1174888	0	0
45691366	738818	0	0
45800472	708298	0	0
46296817	1107830	0	0
45789401	1125315	0	0
46297846	1192710	0	0
46295071	1107882	2	3
45796710	1125315	0	0
46306214	1119510	0	0
4154161	4109685	3	3
75053	4048695	2	2
21002743	1153428	0	0
21002502	19128065	1	1
36153941	19078461	2	3
36156750	1124300	0	0
4130851	4155034	2	2
36000000	134438	3	3
42804667	1545958	0	0
44341883	1154343	0	0
44349143	1119510	0	0
44339810	1125315	0	0
45640987	1129625	0	0
44344787	1501700	0	0
44348066	1125315	0	0
45656904	1177480	0	0
45652125	1124957	0	0
45627086	1539403	0	0
45695605	791967	0	0
45670917	967823	0	0
45661547	967823	0	0
45679946	1107830	0	0
45678235	1500211	0	0
45789465	1174888	0	0
45688741	738818	0	0
45800476	1112807	0	0
46296958	1153428	0	0
45787829	1125315	0	0
46297958	975125	0	0
45895826	1107882	2	3
45796868	1125315	0	0
46306028	1119510	0	0
4154161	375671	3	3
75053	4066995	2	2
21002743	1150770	0	0
21002502	19128263	1	1
36153655	19078461	2	3
36156751	1107830	0	0
21603311	1154343	2	2
35802848	4027663	3	3
42804642	1332418	0	0
44341889	738818	0	0
44349143	738818	0	0
44339885	1125315	0	0
45641071	1129625	0	0
44344789	975125	0	0
44348140	1125315	0	0
45657008	1177480	0	0
45652237	1326303	0	0
45627211	757627	0	0
45695698	1154343	0	0
45671036	967823	0	0
45661551	1174888	0	0
45679953	1343916	0	0
45678238	742185	0	0
45789472	1738521	0	0
45688107	738818	0	0
45800479	1115008	0	0
46296886	1115008	0	0
45787871	1125315	0	0
46297967	1332418	0	0
45801335	19073183	2	3
45796991	1125315	0	0
46305856	1119510	0	0
4154161	4296204	3	3
75053	4278672	2	2
21002744	738818	0	0
21002502	19128022	1	1
36153954	19078461	2	3
36156741	1549786	0	0
35204998	4324181	2	2
36211305	4156265	3	3
42804643	975125	0	0
44341892	1192710	0	0
44349151	975125	0	0
44339887	1125315	0	0
45640933	1129625	0	0
44344790	19003953	0	0
44348246	1125315	0	0
45657110	1177480	0	0
45652245	1174888	0	0
45627230	1713332	0	0
45695821	933724	0	0
45670958	1107830	0	0
45661659	1332418	0	0
45679967	1107830	0	0
45678240	1332418	0	0
45789477	1549786	0	0
45688169	738818	0	0
45800564	1713332	0	0
46296767	1174888	0	0
45787910	1125315	0	0
46297862	705944	0	0
45801262	1107882	2	3
45796801	1125315	0	0
46322299	1119510	0	0
4103352	4156265	3	3
75053	4237458	2	2
21002775	1551099	0	0
21002502	19127918	1	1
36153616	19078461	2	3
36157070	1000560	0	0
21604148	1557272	2	2
36207528	3013682	3	3
42804681	1000560	0	0
44341766	1118084	0	0
44348822	1119510	0	0
44339993	1125315	0	0
45641097	1129625	0	0
44344910	740275	0	0
44348214	1125315	0	0
45657184	1177480	0	0
45650895	920293	0	0
45627104	975125	0	0
45695827	1110410	0	0
45671058	1124957	0	0
45661668	1115008	0	0
45679970	975125	0	0
45678242	1115008	0	0
45789477	1515774	0	0
45685059	738818	0	0
45800513	1115008	0	0
46296997	1118084	0	0
45786083	1125315	0	0
46297906	967823	0	0
46239358	19073183	2	3
45796849	1125315	0	0
46322450	1119510	0	0
4103352	4283893	3	3
75053	40480160	2	2
21002326	1713332	0	0
21002502	19132304	1	1
36217220	920300	2	3
36157209	1539403	0	0
35204989	321042	2	2
36207528	3006906	3	3
42804644	1124957	0	0
44341864	1521369	0	0
44348572	1548195	0	0
44339975	1125315	0	0
45641283	1129625	0	0
44344823	1548195	0	0
44341580	1125315	0	0
45653082	1177480	0	0
45650901	1548195	0	0
45627229	1713332	0	0
45695832	1713332	0	0
45671061	1110410	0	0
45661369	967823	0	0
45679971	1107830	0	0
45678314	1154029	0	0
45789479	975125	0	0
45685064	738818	0	0
45800486	1589505	0	0
46297025	1112807	0	0
45786216	1125315	0	0
46297923	1174888	0	0
46239371	40229134	2	3
45796854	1125315	0	0
46322617	1119510	0	0
4043019	4181917	3	3
73553	80809	2	2
21002326	1759842	0	0
21500746	967823	1	1
36217210	1594382	2	3
36156759	705944	0	0
35204989	317576	2	2
36211136	4134304	3	3
42804644	1125315	0	0
44341865	933724	0	0
44348593	1125315	0	0
44340018	1125315	0	0
45641010	1129625	0	0
44344824	1746114	0	0
44340704	1125315	0	0
45653381	1177480	0	0
45650918	1545958	0	0
45627229	1759842	0	0
45695860	1110410	0	0
45670978	1332418	0	0
45661727	1713332	0	0
45680040	1551099	0	0
45678227	1310149	0	0
45789481	1115008	0	0
45681986	738818	0	0
45800443	1153428	0	0
46296924	1778162	0	0
45786231	1125315	0	0
46297929	1107830	0	0
46239459	19008572	2	3
45796975	1125315	0	0
46322618	1119510	0	0
4028908	4012477	3	3
443419	4155034	2	2
21002658	1551099	0	0
21002493	19128022	1	1
36217210	19006318	2	3
36156754	1119510	0	0
4141937	4337138	2	2
35809321	4084167	3	3
42804806	1174888	0	0
44342040	738818	0	0
44348867	1177480	0	0
44340173	1125315	0	0
45637730	1129625	0	0
44344824	1741122	0	0
44340654	1125315	0	0
45653648	1177480	0	0
45650981	1107830	0	0
45627239	975125	0	0
45695903	1153428	0	0
45671037	1102527	0	0
45661394	1124957	0	0
45680041	1367571	0	0
45678220	1545958	0	0
45789459	1549786	0	0
45682067	738818	0	0
45800527	967823	0	0
46296929	1112807	0	0
45786401	1125315	0	0
46297990	975125	0	0
46239548	1115171	2	3
45796981	1125315	0	0
46322626	1119510	0	0
4042835	257012	3	3
443419	4152936	2	2
21002327	1759842	0	0
21001812	1746114	0	0
36217210	964261	2	3
36156825	1124957	0	0
4092881	195588	2	2
36211089	78272	3	3
42804806	1125315	0	0
44341896	1332418	0	0
44348332	1149196	0	0
44339868	1125315	0	0
45637690	1129625	0	0
44344712	1107830	0	0
44340657	1125315	0	0
45653506	1177480	0	0
45650982	1174888	0	0
45627241	1107830	0	0
45695904	791967	0	0
45669691	1539403	0	0
45661396	1741122	0	0
45680283	1305058	0	0
45678220	1332418	0	0
45789428	1548195	0	0
45682000	738818	0	0
45800486	1549786	0	0
46297109	1000560	0	0
45786408	1125315	0	0
46297994	1107830	0	0
46239551	19059056	2	3
45796985	1125315	0	0
46316970	1119510	0	0
4072499	4035793	3	3
443419	4109685	2	2
21002327	1713332	0	0
21001816	1713332	0	0
36217210	1310034	2	3
36157232	1545958	0	0
4056681	4163872	2	2
35809215	4285898	3	3
42804915	1713332	0	0
44342043	933724	0	0
44348931	1125315	0	0
44339871	1125315	0	0
45637872	1129625	0	0
44344750	1310149	0	0
44340673	1125315	0	0
45650156	1177480	0	0
45650986	1115008	0	0
45627186	1192710	0	0
45694387	1149196	0	0
45669350	920293	0	0
45661396	1746114	0	0
45680023	933724	0	0
45678499	738818	0	0
45789492	1000560	0	0
45678912	738818	0	0
45800490	19010482	0	0
46296938	1112807	0	0
45786301	1125315	0	0
46297489	1307863	0	0
46239325	40231925	2	3
45796872	1125315	0	0
46311332	1119510	0	0
4177089	4125906	3	3
443419	4113008	2	2
21002328	1746114	0	0
21001819	1741122	0	0
36217210	19076374	2	3
36157210	1119510	0	0
4056681	4058899	2	2
36211258	40479422	3	3
42804915	1759842	0	0
44342153	1177480	0	0
44348933	1119510	0	0
44339876	1125315	0	0
45637780	1129625	0	0
44344813	1149196	0	0
44340744	1125315	0	0
45650241	1177480	0	0
45651017	1521369	0	0
45627192	1115008	0	0
45694709	1174888	0	0
45669365	740275	0	0
45660228	1115008	0	0
45679996	1713332	0	0
45678426	1149196	0	0
45789608	1000560	0	0
45678923	738818	0	0
45800620	1501700	0	0
46296939	1153428	0	0
45786313	1125315	0	0
46297398	1192710	0	0
46239658	40229134	2	3
45796967	1125315	0	0
46311410	1119510	0	0
4178818	80809	3	3
31057	28060	2	2
21002327	920293	0	0
21001819	1713332	0	0
36217210	40220386	2	3
36157269	1521369	0	0
4042505	80502	2	2
36211258	40479768	3	3
42804916	1717327	0	0
44341922	1149196	0	0
44348933	1125315	0	0
44340117	1125315	0	0
45637910	1129625	0	0
44343706	1322184	0	0
44340823	1125315	0	0
45650329	1177480	0	0
45651017	19127890	0	0
45627243	1713332	0	0
45694393	1713332	0	0
45669369	1192710	0	0
45660158	1149196	0	0
45680070	1551099	0	0
45678506	1149380	0	0
45789849	1310149	0	0
45706755	1112807	0	0
45800633	967823	0	0
46296933	1332418	0	0
45786363	1125315	0	0
46297765	753626	0	0
46239659	40224805	2	3
45796738	1125315	0	0
46311625	1119510	0	0
4178818	30753	3	3
257907	255848	2	2
21002327	1746114	0	0
21001816	1759842	0	0
36217214	1332419	2	3
36157269	1549786	0	0
4092876	196456	2	2
36502199	4146173	4	5
42804646	1124957	0	0
44342233	1548195	0	0
44348791	1539403	0	0
44340255	1125315	0	0
45637694	1129625	0	0
44343713	1759842	0	0
44340954	1125315	0	0
45650384	1177480	0	0
45651017	1549786	0	0
45627198	1738521	0	0
45694364	1549786	0	0
45669407	1118084	0	0
45660192	1137529	0	0
45680072	1343916	0	0
45678583	1149196	0	0
45789852	1115008	0	0
45705278	1112807	0	0
45800467	1332418	0	0
46297090	933724	0	0
46296767	1125315	0	0
46297799	1192710	0	0
46239611	19059056	2	3
45796879	1125315	0	0
46311814	1119510	0	0
4042836	381316	3	3
1515777	19128022	2	2
21002327	1778162	0	0
21001824	1746114	0	0
36217214	40223768	2	3
36157281	1119510	0	0
4181187	372328	2	2
36502199	4035415	4	5
42804883	1713332	0	0
44341942	933724	0	0
44348676	1125315	0	0
44340285	1125315	0	0
45637702	1129625	0	0
44343713	1713332	0	0
44340798	1125315	0	0
45650542	1177480	0	0
45651017	1503184	0	0
45627276	1521369	0	0
45694523	1124957	0	0
45669336	1107830	0	0
45660192	1149380	0	0
45679957	1361711	0	0
45678335	738818	0	0
45789856	975125	0	0
45705234	1112807	0	0
45800600	1332418	0	0
46297179	1332418	0	0
46296986	1125315	0	0
46289296	1322184	0	0
46239735	40232448	2	3
45797104	1125315	0	0
46311822	1119510	0	0
4042836	380378	3	3
1515777	19128263	2	2
21002328	920293	0	0
21001824	1741122	0	0
36217214	19075601	2	3
36156842	1149196	0	0
4144290	4324181	2	2
36502198	4230399	4	5
42804668	1124300	0	0
44342113	1000560	0	0
44348677	1125315	0	0
44340076	1125315	0	0
45634691	1129625	0	0
44343734	1124957	0	0
44340981	1125315	0	0
45650181	1177480	0	0
45650931	1124957	0	0
45627276	1549786	0	0
45694712	1154029	0	0
45669439	1308738	0	0
45658289	967823	0	0
45680010	1124300	0	0
45678336	1192710	0	0
45789863	1367571	0	0
45779998	1112807	0	0
45800602	1545958	0	0
46296966	1115008	0	0
46297008	1125315	0	0
46289301	1174888	0	0
45895940	40232448	2	3
45797038	1125315	0	0
46311423	1119510	0	0
4042836	4156265	3	3
256440	257012	2	2
21002328	1759842	0	0
21001833	1738521	0	0
36217214	19074843	2	3
36156844	1115008	0	0
4113552	4166224	2	2
36211071	4134304	3	5
42804669	1713332	0	0
44342020	1713332	0	0
44348677	1129625	0	0
44338028	1125315	0	0
45634679	1129625	0	0
44343823	1343916	0	0
44340832	1125315	0	0
45650204	1177480	0	0
45650991	967823	0	0
45627276	19127890	0	0
45692456	1118084	0	0
45669427	19039298	0	0
45658296	1322184	0	0
45680117	1308738	0	0
45678337	975125	0	0
45789869	1713332	0	0
45780180	1112807	0	0
45800534	1112807	0	0
46296967	1110410	0	0
46297021	1125315	0	0
46289140	1305058	0	0
45896157	1127433	2	3
45797208	1125315	0	0
46311435	1119510	0	0
4042836	372328	3	3
256440	40481087	2	2
21002337	1746114	0	0
21001813	1746114	0	0
36217216	19133873	2	3
36156981	1551099	0	0
4113552	440448	2	2
36211088	4134304	3	5
42804647	1149380	0	0
44341873	1174888	0	0
44348689	1154029	0	0
44338056	1125315	0	0
45634768	1129625	0	0
44343815	975125	0	0
44340769	1125315	0	0
45647257	1177480	0	0
45650906	1124957	0	0
45627236	1149196	0	0
45692463	1107830	0	0
45669527	1322184	0	0
45658330	967823	0	0
45680119	1396131	0	0
45678338	1115008	0	0
45789541	1551099	0	0
45780120	1112807	0	0
45800495	1174888	0	0
46297323	1110410	0	0
46297025	1125315	0	0
46289148	1326303	0	0
45896192	1551192	2	3
45797088	1125315	0	0
46311440	1119510	0	0
4047779	317009	3	3
135526	4066995	2	2
21002329	1746114	0	0
21001819	1759842	0	0
36217216	1150771	2	3
36156854	1107830	0	0
4201944	4151422	2	2
36211325	4152936	3	5
42804762	1322184	0	0
44341874	1107830	0	0
44348691	1153428	0	0
45619720	1125315	0	0
45634564	1129625	0	0
44343938	1110410	0	0
44340770	1125315	0	0
45647171	1177480	0	0
45650995	1322184	0	0
45627317	1310149	0	0
45692480	1174888	0	0
45669453	1115008	0	0
45658090	1153428	0	0
45680122	1738521	0	0
45678345	967823	0	0
45789456	1153428	0	0
45706122	1112807	0	0
45800505	1500211	0	0
46297331	1112807	0	0
46297054	1125315	0	0
46289166	914335	0	0
45895887	19133905	2	3
45797216	1125315	0	0
46319609	1119510	0	0
4180628	4051466	3	3
136779	4155034	2	2
21002333	1713332	0	0
21001827	1746114	0	0
36217216	920334	2	3
36156984	1177480	0	0
21600315	1361711	2	2
36211258	78272	5	5
42804923	1177480	0	0
44342154	1115008	0	0
44348871	1129625	0	0
45619727	1125315	0	0
45634754	1129625	0	0
44343872	1107830	0	0
44340952	1125315	0	0
45649032	1177480	0	0
45650919	1768849	0	0
45627107	738818	0	0
45692481	1124957	0	0
45669575	1124957	0	0
45658026	1717327	0	0
45680164	1500211	0	0
45678370	975125	0	0
45789459	1521369	0	0
45706197	1112807	0	0
45800509	1501700	0	0
46297522	975125	0	0
46296937	1125315	0	0
46289191	705944	0	0
45895994	1115171	2	3
45797024	1125315	0	0
46319394	1119510	0	0
4180628	140673	3	3
77960	80180	2	2
21002328	1778162	0	0
21001827	1741122	0	0
36217216	1332419	2	3
36157143	1539403	0	0
35204952	313217	2	2
36516972	4113008	5	5
42804652	1000560	0	0
44342163	1551099	0	0
44348872	1149380	0	0
45619778	1125315	0	0
45634780	1129625	0	0
44343947	1149196	0	0
44340843	1125315	0	0
45647340	1177480	0	0
45650923	1000560	0	0
45627109	738818	0	0
45692427	738818	0	0
45669399	1332418	0	0
45658093	791967	0	0
45680003	1326303	0	0
45678371	1192710	0	0
45789569	1112807	0	0
45706217	1112807	0	0
45800595	1307863	0	0
46297139	975125	0	0
46296938	1125315	0	0
46289209	791967	0	0
45896058	19008572	2	3
45797027	1125315	0	0
46319719	1119510	0	0
4180628	80180	3	3
76611	4146173	2	2
21002335	1746114	0	0
21001834	1768849	0	0
36217216	40223768	2	3
36157291	1112807	0	0
21604752	742185	2	2
36211315	81151	5	5
42804655	914335	0	0
44342286	1539403	0	0
44348999	705944	0	0
45619826	1125315	0	0
45637312	1129625	0	0
44343772	1308738	0	0
44341042	1125315	0	0
45647346	1177480	0	0
45650917	1110410	0	0
45627112	738818	0	0
45692431	738818	0	0
45669531	1310149	0	0
45658168	738818	0	0
45680013	1326303	0	0
45678418	1102527	0	0
45786488	1000560	0	0
45706570	1112807	0	0
45800599	757627	0	0
46297129	1115008	0	0
46294816	1115008	0	0
46289213	1115008	0	0
45896040	1127433	2	3
46318051	1125315	0	0
46319821	1119510	0	0
4029205	4326177	3	3
3048927	3023430	2	2
21002336	1741122	0	0
21001819	1778162	0	0
36217216	19125062	2	3
36157295	1129625	0	0
21604752	705944	2	2
36502197	4035415	5	5
42804657	1343916	0	0
44342020	1759842	0	0
44349001	1124957	0	0
45619873	1125315	0	0
45631471	1129625	0	0
44343677	920293	0	0
44340914	1125315	0	0
45647392	1177480	0	0
45651130	1713332	0	0
45627115	1521369	0	0
45692403	1107830	0	0
45669643	1000560	0	0
45658238	1310149	0	0
45680147	1738521	0	0
45678697	975125	0	0
45786533	1589505	0	0
45706250	1112807	0	0
45800702	967823	0	0
46292890	933724	0	0
46294933	753626	0	0
46289480	1149196	0	0
45896041	40163554	2	3
46318054	1125315	0	0
46317507	1119510	0	0
4029205	4052083	3	3
3048927	3005136	2	2
21002336	1746114	0	0
21001820	1738521	0	0
36217216	19078461	2	3
36157295	1177480	0	0
21603933	1124300	2	2
36211303	4113008	5	5
42804658	1343916	0	0
44342119	1153428	0	0
44349004	701322	0	0
45619837	1125315	0	0
45631649	1129625	0	0
44344038	738818	0	0
44340921	1125315	0	0
45644272	1177480	0	0
45651130	1759842	0	0
45627287	1501700	0	0
45692728	19003953	0	0
45669539	1174888	0	0
45658240	1000560	0	0
45680080	1551099	0	0
45678352	1000560	0	0
45786527	1738521	0	0
45700640	1112807	0	0
45800704	1192710	0	0
46293438	1501700	0	0
46294807	1107830	0	0
46289222	1000560	0	0
45895997	40229134	2	3
46317552	1125315	0	0
46317509	1119510	0	0
4027403	4186930	3	3
3049150	3005136	2	2
21002337	1741122	0	0
21001819	1717327	0	0
36202155	4278672	2	4
36157305	701322	0	0
21603302	1154343	2	2
36211303	4218389	5	5
42804763	914335	0	0
44342023	1112807	0	0
44349131	1125315	0	0
45619910	1125315	0	0
45628700	1129625	0	0
44344041	975125	0	0
44340922	1125315	0	0
45644281	1177480	0	0
45651190	791967	0	0
45627288	1322184	0	0
45692409	1545958	0	0
45669583	1174888	0	0
45658243	1595799	0	0
45677616	1310149	0	0
45675117	975125	0	0
45786837	1115008	0	0
45699886	1112807	0	0
45800537	738818	0	0
46293236	1778162	0	0
46294548	1501700	0	0
46289606	1738521	0	0
45896184	40232448	2	3
45793893	1125315	0	0
46317521	1119510	0	0
4027403	4059978	3	3
1759843	1713671	1	1
21002344	1759842	0	0
21001819	1738521	0	0
35902136	198809	2	4
36156990	1119510	0	0
21604182	753626	2	2
36211303	4296204	5	5
42804661	1343916	0	0
44341926	1713332	0	0
44349133	1129625	0	0
45619914	1125315	0	0
45631040	1129625	0	0
44344048	1307863	0	0
44340924	1125315	0	0
45644284	1177480	0	0
45651194	1149196	0	0
45627118	1551099	0	0
45692448	1332418	0	0
45669644	1124300	0	0
45658246	1149380	0	0
45677727	975125	0	0
45675121	1310149	0	0
45786733	1778162	0	0
45693571	1112807	0	0
45800808	1192710	0	0
46292916	1192710	0	0
46294364	1000560	0	0
46289264	1367571	0	0
45804352	40236446	2	3
45793887	1125315	0	0
46317268	1119510	0	0
4027403	4202832	3	3
1713545	19073183	1	1
21001804	1728416	0	0
21001823	1768849	0	0
36203060	81151	2	5
36156990	738818	0	0
36152480	19128022	2	2
36211303	4155034	5	5
42804866	1115008	0	0
44341926	1759842	0	0
44348940	708298	0	0
45620003	1125315	0	0
45628858	1129625	0	0
44343793	1110410	0	0
44340888	1125315	0	0
45644373	1177480	0	0
45651373	738818	0	0
45627122	1110410	0	0
45692520	1124957	0	0
45669510	1310149	0	0
45658118	1000560	0	0
45677545	1124957	0	0
45675176	1149196	0	0
45786509	1713332	0	0
45693607	1112807	0	0
45800818	1192710	0	0
46292918	1112807	0	0
46294281	1549786	0	0
46289271	920293	0	0
45804319	19018935	2	3
45793911	1125315	0	0
46317591	1125315	0	0
4067285	4242997	3	3
1713547	19073188	1	1
21001819	1746114	0	0
21001669	1551099	0	0
35702738	192671	2	5
36156861	1119510	0	0
36152480	19128263	2	2
36300000	375671	10	14
42804854	920293	0	0
44341928	708298	0	0
44348952	1548195	0	0
45619886	1125315	0	0
45628885	1129625	0	0
44343795	1192710	0	0
44340894	1125315	0	0
45644426	1177480	0	0
45651374	1124957	0	0
45627364	1501700	0	0
45692485	1154343	0	0
45669684	1501700	0	0
45704016	1713332	0	0
45677740	920293	0	0
45675157	738818	0	0
45786509	1759842	0	0
45693706	1112807	0	0
45800616	1115008	0	0
46293110	1501700	0	0
46294281	1521369	0	0
46289620	1332418	0	0
45804388	40163554	2	3
45794001	1125315	0	0
46313409	1125315	0	0
4067285	4117038	3	3
1154459	1154615	1	1
21000483	1551099	0	0
21001666	1551099	0	0
21602628	40236824	2	5
36156861	738818	0	0
21603966	19019273	2	2
36300000	4166224	10	14
42804986	1310149	0	0
44342104	1149196	0	0
44348942	738818	0	0
45620213	1125315	0	0
45625796	1129625	0	0
44343858	1307863	0	0
45637302	1125315	0	0
45644178	1177480	0	0
45651093	1539403	0	0
45627366	1124957	0	0
45692496	1107830	0	0
45669686	1343916	0	0
45704016	1759842	0	0
45677560	1110410	0	0
45675158	1548195	0	0
45786535	1149196	0	0
45691503	1112807	0	0
45800530	1332418	0	0
46293113	1310149	0	0
46294411	1305058	0	0
46289637	920293	0	0
45797167	19008572	2	3
45794186	1125315	0	0
46313410	1125315	0	0
4067285	4330583	3	3
4020466	4336464	1	1
21000482	1305058	0	0
21001796	1713332	0	0
36202157	375671	2	10
36156999	1153428	0	0
21603966	19078461	2	2
36300000	37017711	10	11
42804995	1177480	0	0
44342214	705944	0	0
44348942	1119510	0	0
45620250	1125315	0	0
45625921	1129625	0	0
44344162	1557272	0	0
45638161	19078461	2	3
45644511	1177480	0	0
45651280	1501700	0	0
45627369	1343916	0	0
45692501	1326303	0	0
45669521	738818	0	0
45704085	1738521	0	0
45677561	738818	0	0
45674849	1332418	0	0
45786725	1154343	0	0
45691447	1112807	0	0
45800843	967823	0	0
46293132	1149196	0	0
46294430	1192710	0	0
46289524	967823	0	0
45796694	19008572	2	3
45794190	1125315	0	0
46313418	1125315	0	0
4042140	4056621	6	8
3023227	3000963	1	1
21000485	1305058	0	0
21500574	19019979	6	7
35702738	440448	2	9
36157005	1107830	0	0
21603966	1115008	2	2
36300000	438614	9	10
42804998	1551099	0	0
44342224	975125	0	0
44348942	1125315	0	0
45620047	1125315	0	0
45625951	1129625	0	0
44343923	1738521	0	0
45640890	19078461	2	3
45644663	1177480	0	0
45651107	1713332	0	0
45627383	1738521	0	0
45692386	1539403	0	0
45669525	701322	0	0
45703842	1332418	0	0
45677563	1154029	0	0
45674852	975125	0	0
45786719	1309944	0	0
45690734	1112807	0	0
45800844	1124300	0	0
46293426	1112807	0	0
46294544	1149196	0	0
46289069	1332418	0	0
45796727	19018935	2	3
45794024	1125315	0	0
46313308	1125315	0	0
4042140	4048171	6	11
3002665	3006906	1	1
21000486	1305058	0	0
21500574	1115171	6	7
35702738	4166224	2	9
36157017	1589505	0	0
21603966	1177480	2	2
36300000	4156265	9	12
42804870	1713332	0	0
44342058	1124957	0	0
44348944	1713332	0	0
45620054	1125315	0	0
45625819	1129625	0	0
44344158	740275	0	0
45656538	19078461	2	3
45641544	1177480	0	0
45651160	1149196	0	0
45627388	1124300	0	0
45692514	1149380	0	0
45669603	1326303	0	0
45703636	1153428	0	0
45677518	1107830	0	0
45675272	1124300	0	0
45786664	1107830	0	0
45690740	1112807	0	0
45800845	1713332	0	0
46293136	1112807	0	0
46294667	1551099	0	0
46289786	975125	0	0
45796669	1551192	2	3
45794009	1125315	0	0
46313437	1125315	0	0
4042140	378001	6	10
3003169	3004501	1	1
21000482	975125	0	0
21500574	19007333	6	7
35702738	4266809	2	7
36157024	1153428	0	0
4180941	4202832	2	2
36300000	4266809	9	12
42805064	1149380	0	0
44342093	1124957	0	0
44348914	1738521	0	0
45620060	1125315	0	0
45625983	1129625	0	0
44344095	1192710	0	0
45631797	19078461	2	3
45641640	1177480	0	0
45647867	1738521	0	0
45627264	1343916	0	0
45692638	1332418	0	0
45669604	1174888	0	0
45703788	1118084	0	0
45677938	914335	0	0
45674935	738818	0	0
45786512	1112807	0	0
45687691	1112807	0	0
45800845	1759842	0	0
46293127	1174888	0	0
46294669	1738521	0	0
46289325	1310149	0	0
45791202	1551192	2	3
45794158	1125315	0	0
46313457	1125315	0	0
4029205	4330583	6	9
77162	81151	1	1
21000495	1305058	0	0
21500574	19078461	6	7
21602484	19128022	2	2
36157031	1129625	0	0
4180941	4010253	2	2
36300000	4299128	9	9
42804840	1129625	0	0
44342094	1595799	0	0
44348962	1129625	0	0
45620067	1125315	0	0
45622578	1129625	0	0
44343976	1115008	0	0
45656647	19078461	2	3
45638404	1177480	0	0
45647713	1589505	0	0
45627268	1154029	0	0
45692547	1124300	0	0
45669662	1153428	0	0
45704143	1500211	0	0
45677995	1154343	0	0
45674945	1545958	0	0
45786618	1174888	0	0
45687351	1112807	0	0
45800729	933724	0	0
46293432	1124957	0	0
46294670	1549786	0	0
46289787	1738521	0	0
45791405	40229134	2	3
45794824	1125315	0	0
46313517	1125315	0	0
4029205	4242997	6	7
77162	4059173	1	1
21000526	1305058	0	0
21500574	1127078	6	7
21602516	19128009	2	2
36157147	967823	0	0
4180941	4057420	2	2
36300000	4155034	8	11
42804979	1713332	0	0
44342094	1549786	0	0
44348962	1125315	0	0
45620092	1125315	0	0
45622841	1129625	0	0
44340081	1367571	0	0
45647179	19078461	2	3
45638394	1177480	0	0
45647899	1310149	0	0
45627269	1332418	0	0
45692554	1124957	0	0
45669607	1192710	0	0
45703982	1107830	0	0
45677520	1115008	0	0
45674856	914335	0	0
45786805	1545958	0	0
45687632	1112807	0	0
45800847	1729720	0	0
46293150	1545958	0	0
46294670	1521369	0	0
46289800	1124300	0	0
45791489	40232448	2	3
45794772	1125315	0	0
46313534	1125315	0	0
4029205	4252419	6	7
80004	4113008	1	1
19078461	19078461	0	0
21500175	40173590	6	7
21602568	19128065	2	2
36157156	1589505	0	0
4180941	4059978	2	2
36300000	380378	8	11
42804979	1759842	0	0
44342094	1521369	0	0
44348601	1759842	0	0
45620161	1125315	0	0
45622546	1129625	0	0
44340084	1115008	0	0
45641070	40228214	2	3
45640202	1177480	0	0
45647640	1000560	0	0
45627395	1778162	0	0
45692612	19010482	0	0
45669790	1548195	0	0
45703985	1174888	0	0
45677634	723013	0	0
45674858	738818	0	0
45786737	1551099	0	0
45687989	1112807	0	0
45800749	1332418	0	0
46293283	1713332	0	0
46294677	1192710	0	0
46289555	1343916	0	0
45791424	1551192	2	3
45794452	1125315	0	0
46313542	1125315	0	0
4029205	4058899	6	8
80502	40480160	1	1
19079524	19079524	0	0
21500582	19133768	6	7
21602537	1521369	2	2
36157169	967823	0	0
36217214	1150771	2	3
36300000	30753	8	12
42804980	1778162	0	0
44342096	1548195	0	0
44348923	1343916	0	0
44778120	1125315	0	0
45622651	1129625	0	0
44340091	1149196	0	0
45662823	19078461	2	3
45635211	1177480	0	0
45647643	791967	0	0
45627423	1551099	0	0
45692613	1154343	0	0
45669793	19010482	0	0
45703952	19127890	0	0
45678069	1192710	0	0
45675289	1192710	0	0
45786830	1112807	0	0
45687489	1112807	0	0
45800750	1549786	0	0
46293283	1759842	0	0
46294842	1115008	0	0
46289814	1192710	0	0
45791547	40229134	2	3
45794801	1125315	0	0
46313474	1125315	0	0
4027384	4048171	6	9
1519940	43012433	1	1
4297090	42535580	6	7
21500582	40165015	6	7
21602537	19054876	2	2
36157188	1501700	0	0
36217214	19133873	2	3
36300000	378419	8	13
42804875	1125315	0	0
44342073	738818	0	0
44348859	1154343	0	0
44361324	1125315	0	0
45622673	1129625	0	0
44340096	705944	0	0
45641011	19078461	2	3
45635562	1177480	0	0
45647904	1343916	0	0
45627486	1310149	0	0
45692591	1115008	0	0
45669478	715997	0	0
45703952	19054876	0	0
45677669	1305058	0	0
45675293	1192710	0	0
45786941	1332418	0	0
45687938	1112807	0	0
45797674	1107830	0	0
46293290	1551099	0	0
46296702	1713332	0	0
46289823	1118084	0	0
45791292	19008572	2	3
45794330	1125315	0	0
46313482	1125315	0	0
4027384	133834	6	6
443883	4084167	1	1
4297090	4047491	6	7
21500582	40231925	6	7
35508659	19128263	2	2
36157308	1119510	0	0
36217214	40173590	2	3
36300000	4294548	8	14
42804875	1174888	0	0
44342074	1539403	0	0
44348860	1125315	0	0
44361622	1125315	0	0
45622858	1129625	0	0
44340104	1107830	0	0
45646640	19078461	2	3
45635401	1177480	0	0
45647870	791967	0	0
45627487	1332418	0	0
45692673	975125	0	0
45669480	738818	0	0
45703952	1548195	0	0
45677998	1545958	0	0
45675210	1551099	0	0
45786811	1115008	0	0
45687940	1112807	0	0
45797836	701322	0	0
46293312	914335	0	0
46296765	1332418	0	0
46289582	1549786	0	0
46298473	19059056	2	3
45794332	1125315	0	0
46313376	1125315	0	0
4028387	133834	6	6
740348	19074679	1	1
4322976	4037675	6	8
21502510	19074843	6	7
35508659	19128022	2	2
36157194	1119510	0	0
36217214	40236824	2	3
36300000	4144583	11	11
42804971	1124300	0	0
44342077	1589505	0	0
44348866	1539403	0	0
44363023	40171902	1	1
45622776	1129625	0	0
44340145	715997	0	0
45631793	19078461	2	3
45632296	1177480	0	0
45647989	1192710	0	0
45627357	1551099	0	0
45692675	1729720	0	0
45669488	1548195	0	0
45703919	738818	0	0
45677871	1501700	0	0
45675211	738818	0	0
45786815	791967	0	0
45687903	1112807	0	0
45797647	1174888	0	0
46293314	1115008	0	0
46296879	708298	0	0
46289582	19127890	0	0
46298674	40232448	2	3
45794317	1125315	0	0
46313379	1125315	0	0
4029205	4024958	6	6
192956	198809	1	1
4274025	4296204	6	8
21502510	19133905	6	7
35502639	140673	2	2
36199678	1119510	0	0
36217214	19074679	2	3
36300000	4134304	11	15
42804972	1713332	0	0
44342102	1589505	0	0
44349113	19039298	0	0
44337665	19115351	1	1
45621312	1129625	0	0
44340147	1326303	0	0
45622696	19078461	2	3
45632310	1177480	0	0
45647916	1192710	0	0
45627512	1332418	0	0
45692682	723013	0	0
45669488	1512674	0	0
45703972	1501700	0	0
45677885	1154343	0	0
45675113	975125	0	0
45786949	1107830	0	0
45687974	1112807	0	0
45797763	1192710	0	0
46293264	1539403	0	0
46244044	1115008	0	0
46289987	967823	0	0
46298902	40236824	2	3
45794282	1125315	0	0
46313626	1125315	0	0
4029205	4163872	6	6
195632	4149245	1	1
21500574	1127433	6	7
21502510	19073183	6	7
21602003	1129625	2	2
36157310	723013	0	0
36217214	40222846	2	3
36300000	4084167	6	9
42804841	1115008	0	0
44342102	1549786	0	0
44349135	1124957	0	0
44784217	321042	1	1
45621288	1129625	0	0
44339937	1539403	0	0
45641363	19078461	2	3
45632323	1177480	0	0
45648001	723013	0	0
45627431	1361711	0	0
45692697	1124300	0	0
45669591	1107830	0	0
45704155	1124300	0	0
45678011	1124300	0	0
45675228	975125	0	0
45786740	1112807	0	0
45684749	1112807	0	0
45797651	1124957	0	0
46296446	967823	0	0
46244116	1149196	0	0
46289643	1000560	0	0
46298586	40163554	2	3
45794477	1125315	0	0
46313959	1125315	0	0
4032251	4243062	2	2
4001868	4301346	1	1
21500574	19059056	6	7
21502510	19129655	6	7
21602004	1129625	2	2
36157329	1738521	0	0
36217214	19073183	2	3
36300000	439777	5	11
42804843	1154343	0	0
44342243	1177480	0	0
44349135	1125315	0	0
44361661	19127918	3	4
45622017	1129625	0	0
44340505	19127890	0	0
45656208	19078461	2	3
45632402	1177480	0	0
45647907	1115008	0	0
45627223	1107830	0	0
45692624	1154029	0	0
45669497	1551099	0	0
45704113	1738521	0	0
45678014	975125	0	0
45675248	1713332	0	0
45786741	1000560	0	0
45684499	1112807	0	0
45797912	1332418	0	0
46296584	1124957	0	0
46244111	757627	0	0
46289656	1545958	0	0
46298724	40232448	2	3
45791453	1125315	0	0
46314016	1125315	0	0
4149795	44805732	2	2
1175452	3020630	1	1
4274025	192671	6	6
21502510	19133873	6	7
21603672	1343916	2	2
36157344	1112807	0	0
36217214	19133905	2	3
36208978	3014576	3	4
42804845	920293	0	0
44342295	1149196	0	0
44348601	1713332	0	0
44339931	19133679	3	4
45621996	1129625	0	0
44340505	1549786	0	0
45649708	19078461	2	3
45632496	1177480	0	0
45648050	1551099	0	0
45627447	1548195	0	0
45692775	1115008	0	0
45669500	1192710	0	0
45704120	1310149	0	0
45678015	1174888	0	0
45675254	19059528	0	0
45786631	1548195	0	0
45684840	1112807	0	0
45797777	1149196	0	0
46296697	1149196	0	0
46244207	1332418	0	0
46289721	1154343	0	0
46298556	19133873	2	3
45791456	1125315	0	0
46314423	1125315	0	0
4132546	375671	2	2
1175606	3023103	1	1
4208786	4230399	6	6
21502510	19073188	6	7
36157133	19128022	2	2
36157488	1119510	0	0
36217214	40163554	2	3
36208978	3000963	3	4
42804973	1738521	0	0
44342175	1107830	0	0
42802094	19133679	1	1
43531071	4275113	5	6
45621365	1129625	0	0
44340506	920293	0	0
45649845	19078461	2	3
45632561	1177480	0	0
45648056	1107830	0	0
45627448	1310149	0	0
45692719	1521369	0	0
45669593	715997	0	0
45704099	1115008	0	0
45678046	1149196	0	0
45675255	1310149	0	0
45786704	1309944	0	0
45682578	1112807	0	0
45797781	1000560	0	0
46296805	1115008	0	0
46244121	1500211	0	0
46289771	1124300	0	0
46298556	19133905	2	3
45791726	1125315	0	0
46313896	1125315	0	0
4132546	378001	2	2
1176181	3020630	1	1
4297090	4037675	6	6
21502510	1713671	6	7
21602628	933724	2	2
36157488	738818	0	0
36217214	40228214	2	3
36208978	3006906	3	4
42804975	1177480	0	0
44342375	1713332	0	0
42802094	19127922	1	1
43531072	4330583	4	6
45664896	1129625	0	0
44340510	1107830	0	0
44362009	19078461	2	3
45632519	1177480	0	0
45648057	19127890	0	0
45627251	1549786	0	0
45692719	19127890	0	0
45669765	1118084	0	0
45703780	738818	0	0
45677796	1778162	0	0
45675257	1115008	0	0
45786954	1557272	0	0
45682644	1112807	0	0
45797661	967823	0	0
46296717	975125	0	0
46244081	791967	0	0
46289594	975125	0	0
46299041	43012036	2	3
45791728	1125315	0	0
46308388	1125315	0	0
4103192	4329847	2	2
1175900	3008598	1	1
4247371	4048171	6	8
21502510	19075001	6	7
21602540	40224805	2	3
36157420	1107830	0	0
36217214	40223821	2	3
36208978	3009542	3	4
42804976	1310149	0	0
44342024	1557272	0	0
42802094	19129144	1	1
43531072	4117038	4	4
45664927	1129625	0	0
44340511	914335	0	0
45643929	40223768	2	3
45629431	1177480	0	0
45648057	1549786	0	0
45627251	1515774	0	0
45692719	1549786	0	0
45669772	1192710	0	0
45704031	1174888	0	0
45677816	1557272	0	0
45675236	975125	0	0
45786871	1589505	0	0
45681685	1112807	0	0
45797714	1174888	0	0
46296661	1192710	0	0
46244082	1110410	0	0
46289431	1107830	0	0
46299224	40232448	2	3
45791386	1125315	0	0
46308506	1125315	0	0
4063579	4246502	2	2
433524	4166224	1	1
4247371	375671	6	7
21502510	46275444	6	7
21602540	40224132	2	3
36157466	1107830	0	0
36217210	19129655	2	3
36207528	3016723	3	4
42805028	1153428	0	0
44342028	1149380	0	0
44786889	3023103	2	2
44786889	3013682	2	2
45664931	1129625	0	0
44340251	1713332	0	0
45637941	19078461	2	3
45629385	1177480	0	0
45648059	914335	0	0
45627251	19127890	0	0
45692723	1308738	0	0
45780877	791967	0	0
45703896	1308738	0	0
45677909	1192710	0	0
45674866	1107830	0	0
45786713	757627	0	0
45678512	1112807	0	0
45797715	1112807	0	0
46296810	1124957	0	0
46244021	1174888	0	0
46289744	1115008	0	0
46298939	40229134	2	3
45791405	1125315	0	0
46308533	1125315	0	0
4047120	440086	2	2
433524	440448	1	1
4247371	378001	6	7
21502510	19074841	6	7
35508755	1594382	2	3
36157468	1129625	0	0
36217210	46275444	2	3
36207528	3000963	3	4
42805032	19010482	0	0
44342034	1746114	0	0
45619703	1115171	2	3
44783379	4058899	2	2
45665096	1129625	0	0
44340251	1759842	0	0
45659395	19078461	2	3
45626640	1177480	0	0
45648077	1332418	0	0
45627296	1310149	0	0
45692844	715997	0	0
45780900	1149196	0	0
45703899	1000560	0	0
45677923	1308738	0	0
45675005	1115008	0	0
45786818	1738521	0	0
45672758	1112807	0	0
45797887	967823	0	0
46296815	1153428	0	0
46244085	1154343	0	0
46289750	1343916	0	0
46298760	40236824	2	3
45791709	1125315	0	0
46308529	1125315	0	0
4028876	255848	2	2
434621	80809	1	1
4274025	40479422	7	9
21500148	1539403	6	6
35508769	35605482	2	3
36157468	1119510	0	0
36217210	35605858	2	3
36207528	3024561	3	4
42804860	1115008	0	0
44342034	1741122	0	0
45619706	40162522	2	3
44782549	4066995	2	2
45665117	1129625	0	0
44340497	1548195	0	0
45646861	40223768	2	3
45626441	1177480	0	0
45647923	967823	0	0
45627454	1102527	0	0
45692699	1713332	0	0
45780718	723013	0	0
45704064	1361711	0	0
45677742	975125	0	0
45675051	1343916	0	0
45786919	1112807	0	0
45672761	1112807	0	0
45797895	1149196	0	0
46293557	1500211	0	0
46244129	1310149	0	0
46289926	1713332	0	0
46291664	40232448	2	3
45791685	1125315	0	0
46308558	1125315	0	0
4028902	4187458	2	2
257907	261325	1	1
21502709	1125315	7	7
21502709	40223834	9	10
35508683	19133873	2	3
36157365	1551099	0	0
36217210	42707627	2	3
35702800	4112343	3	4
42805061	1343916	0	0
44342133	1177480	0	0
45621976	40165015	2	3
44782549	4048695	2	2
45665055	1129625	0	0
44340236	1713332	0	0
45656382	19078461	2	3
45626728	1177480	0	0
45648081	1367571	0	0
45627461	1713332	0	0
45692803	1361711	0	0
45780797	1361711	0	0
45703904	1326303	0	0
45677823	1192710	0	0
45675126	1778162	0	0
45786927	920293	0	0
45784497	1112807	0	0
45797868	1539403	0	0
46293639	1738521	0	0
46244219	1107830	0	0
46289926	1759842	0	0
46290507	40163554	2	3
45791550	1125315	0	0
46308297	1125315	0	0
4028970	260139	2	2
260123	4294548	1	1
4208786	4134304	7	7
21502709	40228214	9	10
35508683	19133905	2	3
36157368	920293	0	0
36217210	19057271	2	3
36211258	81151	4	4
42803300	1539403	0	0
44342189	1713332	0	0
45619795	40232448	2	3
44337624	19128009	2	2
45665108	1129625	0	0
44340370	975125	0	0
45646890	19078461	2	3
45623312	1177480	0	0
45648148	1192710	0	0
45627461	1759842	0	0
45689272	1551099	0	0
45780905	1149380	0	0
45703906	1174888	0	0
45677837	1154343	0	0
45675096	1326303	0	0
45786769	967823	0	0
45784539	1112807	0	0
45797876	738818	0	0
46293679	701322	0	0
46244209	1332418	0	0
46289880	1308738	0	0
46290476	1115171	2	3
45791554	1125315	0	0
46308570	1125315	0	0
4168666	378419	2	2
1766555	19127904	1	2
4208786	78272	7	7
21502709	19125062	9	10
35508686	46275444	2	3
36157369	1115008	0	0
36217210	40243436	2	3
36211260	78272	4	4
42803276	1322184	0	0
44342390	1177480	0	0
44360997	40231925	2	3
44337624	19127918	2	2
45665142	1129625	0	0
44340371	1124300	0	0
45653162	19078461	2	3
45623365	1177480	0	0
45647857	1539403	0	0
45627462	975125	0	0
45689532	1738521	0	0
45780812	1326303	0	0
45703907	1174888	0	0
45677838	1717327	0	0
45675200	1308738	0	0
45786772	914335	0	0
45784618	1112807	0	0
45797881	1115008	0	0
46293606	1174888	0	0
46244225	1310149	0	0
46289835	1115008	0	0
46290428	42707627	2	3
45791697	1125315	0	0
46308311	1125315	0	0
4042645	4163951	2	2
77960	78272	3	6
21601120	1308738	2	2
21502709	1112807	7	7
35508981	1115171	2	3
36157373	1154343	0	0
36217216	40174880	2	3
36517140	40479422	4	4
42803279	1119510	0	0
44342182	1112807	0	0
44361403	1115171	2	3
44337577	19128009	2	2
45665176	1129625	0	0
44340373	1110410	0	0
45662563	19078461	2	3
45623329	1177480	0	0
45648164	933724	0	0
45627463	920293	0	0
45689422	1501700	0	0
45780816	1174888	0	0
45706791	715997	0	0
45677754	975125	0	0
45675266	738818	0	0
45786931	1192710	0	0
45784829	1112807	0	0
45798014	1149196	0	0
46293610	1174888	0	0
46244140	1124957	0	0
46289836	1343916	0	0
46290698	40232448	2	3
45791837	1125315	0	0
46308750	1125315	0	0
4059308	4163971	2	2
4002031	4336464	3	6
21500624	723013	2	2
21502709	1115008	7	7
35508845	40162522	2	3
36157376	1119510	0	0
36208978	3051031	2	3
36517140	40479768	4	4
42803287	975125	0	0
44342305	1192710	0	0
44361462	19008572	2	3
45637521	19128009	2	2
45662295	1129625	0	0
44340374	757627	0	0
45637681	19078461	2	3
45623747	1177480	0	0
45647825	1361711	0	0
45627538	1115008	0	0
45691616	1124300	0	0
45780835	1153428	0	0
45651760	705944	0	0
45677962	1153428	0	0
45676416	1192710	0	0
45786875	1174888	0	0
45784831	1112807	0	0
45797788	1124957	0	0
46293614	1115008	0	0
46244145	914335	0	0
46289839	1326303	0	0
46290863	19073188	2	3
45791786	1125315	0	0
46308612	1125315	0	0
4132552	4112343	2	2
74726	4134304	3	5
21500624	740275	2	2
4247371	4043241	7	8
35502093	140673	2	3
36157376	738818	0	0
36208195	3005136	2	3
36517012	40479422	4	4
42803295	1124300	0	0
44342007	1124300	0	0
44361374	19059056	2	3
45656037	19128022	1	2
45662697	1129625	0	0
44340379	705944	0	0
45641351	19078461	2	3
45623640	1177480	0	0
45648233	1332418	0	0
45627539	738818	0	0
45691511	1738521	0	0
45780914	1174888	0	0
45651472	1310149	0	0
45678050	1501700	0	0
45676338	975125	0	0
45786850	1521369	0	0
45782402	1112807	0	0
45797814	1545958	0	0
46293719	1713332	0	0
46244146	791967	0	0
46289842	975125	0	0
46290718	19078924	2	3
45791671	1125315	0	0
46308617	1125315	0	0
4132552	198809	2	2
193460	4152936	3	5
21500624	19074679	2	2
21500120	40173590	9	10
35506609	4144583	2	3
36157379	1115008	0	0
36208195	3036780	2	3
36517012	40479768	4	4
42803298	1545958	0	0
44342532	1332418	0	0
44361193	1115171	2	3
45656037	19128263	1	2
45662728	1129625	0	0
44340382	1107830	0	0
45652927	19078461	2	3
45623642	1177480	0	0
45648172	19054876	0	0
45627547	19010482	0	0
45691477	1778162	0	0
45783268	1717327	0	0
45651717	1738521	0	0
45678052	920293	0	0
45676423	1115008	0	0
45786851	1174888	0	0
45783586	1112807	0	0
45797973	1310149	0	0
46293520	1174888	0	0
46244159	1326303	0	0
46289902	1192710	0	0
46290779	40162522	2	3
45791831	1125315	0	0
46308473	1125315	0	0
4044889	4047491	2	2
193460	4149245	3	5
21500612	1343916	2	2
21500120	1551192	9	10
35508948	19008572	2	3
36157397	975125	0	0
36208195	3010813	2	3
36302172	4314290	4	4
42803299	1326303	0	0
44342316	1501700	0	0
44361547	40231925	2	3
44337577	19127918	1	2
45662433	1129625	0	0
44340537	975125	0	0
45640630	19079524	2	3
45623349	1177480	0	0
45648172	1548195	0	0
45627468	1738521	0	0
45691488	1551099	0	0
45783372	1192710	0	0
45651722	1154343	0	0
45677967	1107830	0	0
45676430	1307863	0	0
45786856	1154343	0	0
45782727	1112807	0	0
45797931	738818	0	0
46293809	1153428	0	0
46244161	1154029	0	0
46241667	1192710	0	0
46290814	40232448	2	3
45791729	1125315	0	0
46308660	1125315	0	0
4115260	261325	2	2
77960	4149245	3	4
21500215	1307863	2	2
21500120	1589505	7	7
35509044	40236824	2	3
36157403	1129625	0	0
36208195	3023430	2	3
36517149	4149245	4	4
42803432	1309944	0	0
44337665	723013	0	0
44361702	40229134	2	3
44778030	40174880	2	3
45662887	1129625	0	0
44340540	1000560	0	0
45637740	1332419	2	3
45667537	1177480	0	0
45648172	19127890	0	0
45627555	1310149	0	0
45691566	1501700	0	0
45783389	1174888	0	0
45651762	1521369	0	0
45678079	1310149	0	0
45676293	1000560	0	0
45786787	1124957	0	0
45782769	1112807	0	0
45797717	738818	0	0
46293730	1501700	0	0
46244249	1728416	0	0
46241669	1192710	0	0
46290815	40232448	2	3
45791730	1125315	0	0
46308670	1125315	0	0
4133611	4132546	2	2
75909	4142905	3	4
21503193	1759842	2	2
21500120	1500211	7	7
35509076	40229134	2	3
36157404	1119510	0	0
36217207	19023398	2	3
36211375	378001	4	4
42803435	1124300	0	0
44337826	1153428	0	0
44361679	1115171	2	3
44778286	40232448	2	3
45661355	1129625	0	0
44339943	1729720	0	0
45638234	1332419	2	3
45667886	1177480	0	0
45648173	1396131	0	0
45627560	1154343	0	0
45691579	967823	0	0
45783181	933724	0	0
45651783	1332418	0	0
45679563	738818	0	0
45676367	715997	0	0
45786959	1548195	0	0
45780850	1112807	0	0
45797898	967823	0	0
46293827	742185	0	0
46244149	1000560	0	0
46241637	914335	0	0
46290683	40236824	2	3
45791794	1125315	0	0
46308672	1125315	0	0
4027369	4310024	2	2
4022449	4146173	3	4
21503193	1343916	2	2
21500120	933724	7	7
35509096	40232448	2	3
36157337	1149196	0	0
36217209	43012433	2	3
36211375	375671	4	4
42803247	1729720	0	0
44337827	1149380	0	0
44361399	1115171	2	3
44778271	40231925	2	3
45659340	1129625	0	0
44340472	1110410	0	0
45637862	1332419	2	3
45667202	1177480	0	0
45648061	933724	0	0
45627569	19127890	0	0
45691516	975125	0	0
45783272	791967	0	0
45651691	1332418	0	0
45679713	1521369	0	0
45676370	1124957	0	0
45786960	1713332	0	0
45780948	1112807	0	0
45798044	1153428	0	0
46293735	1174888	0	0
46244228	1192710	0	0
46241568	1309944	0	0
46291113	40229134	2	3
45791795	1125315	0	0
46308674	1125315	0	0
4091532	4266809	2	2
4022201	4142905	3	4
21500216	1309944	2	2
21500120	1551099	7	7
36156889	1115171	2	3
36157448	1129625	0	0
36155989	1545959	2	3
36211065	4134304	4	4
42803439	1119510	0	0
44337832	1192710	0	0
44361522	19008572	2	3
44778219	40229134	2	3
45659676	1129625	0	0
44340473	1307863	0	0
45646620	1332419	2	3
45665512	1177480	0	0
45647981	1124300	0	0
45623707	1192710	0	0
45691609	723013	0	0
45783485	1549786	0	0
45651757	708298	0	0
45679772	1000560	0	0
45676376	1115008	0	0
45786798	1192710	0	0
45780244	1112807	0	0
45798054	1548195	0	0
46293735	1192710	0	0
46244229	1551099	0	0
46241587	975125	0	0
46242371	40232448	2	3
45791754	1125315	0	0
46308714	1125315	0	0
4168644	4174876	2	2
4022201	4237458	3	4
21503143	914335	2	2
21500120	1549786	7	7
36156890	19125062	2	3
36009704	133834	0	0
36150893	1545959	2	3
36500000	4218389	4	4
42803441	975125	0	0
44337836	1174888	0	0
44361351	43012036	2	3
44778069	46275916	2	3
45659504	1129625	0	0
44340476	975125	0	0
45634815	1332419	2	3
45665518	1177480	0	0
45648270	1115008	0	0
45623900	738818	0	0
45691615	914335	0	0
45783485	1595799	0	0
45651641	1107830	0	0
45679627	1124300	0	0
45676379	1539403	0	0
45786886	1192710	0	0
45780315	1112807	0	0
45797819	1112807	0	0
46293837	791967	0	0
46244147	1545958	0	0
46241706	1124957	0	0
46242223	1127433	2	3
45791756	1125315	0	0
46308692	1125315	0	0
4176946	80809	2	2
4022139	4108705	3	4
21503147	1154029	2	2
21500120	19054876	7	7
36156623	1127433	2	3
36151990	1153428	0	0
36156033	1332419	2	3
36211308	4152936	4	4
42803246	1713332	0	0
44337838	933724	0	0
44361309	19008572	2	3
44778070	46275916	2	3
45659464	1129625	0	0
44340039	1174888	0	0
45656594	40174880	2	3
45665846	1177480	0	0
45648225	1549786	0	0
45624029	1154029	0	0
45691722	757627	0	0
45783485	1521369	0	0
45651644	1713332	0	0
45679628	1713332	0	0
45676387	1307863	0	0
45786967	1551099	0	0
45780231	1112807	0	0
45797954	1713332	0	0
46293846	1124957	0	0
46244271	1309944	0	0
46241639	1309944	0	0
46242338	40228214	2	3
45791763	1125315	0	0
46308702	1125315	0	0
4177703	4027663	2	2
4022923	4149245	3	4
21500595	1177480	2	2
21500120	975125	7	7
36157205	40229134	2	3
36152190	1539403	0	0
36150969	19078461	2	3
36603345	4285898	4	4
42803405	1129625	0	0
44337847	1115008	0	0
44357482	40231925	2	3
44358143	43012036	2	3
45656523	1129625	0	0
44340369	738818	0	0
45653115	1545959	2	3
45663129	1177480	0	0
45648225	1589505	0	0
45625137	1309944	0	0
45691742	1115008	0	0
45783501	1149196	0	0
45651644	1759842	0	0
45679628	1759842	0	0
45676477	914335	0	0
45786975	1000560	0	0
45777738	1112807	0	0
45797903	1124300	0	0
46288767	1112807	0	0
46244293	1717327	0	0
46241625	723013	0	0
46242356	40229134	2	3
45791769	1125315	0	0
46312106	1125315	0	0
4058419	4323208	2	2
4004041	4336464	3	4
21500595	1124300	2	2
4274025	4299128	5	5
36156878	35605858	2	3
36151910	1119510	0	0
36155793	19078461	2	3
36211088	78272	4	4
42803087	1759842	0	0
44337684	1112807	0	0
44357494	19133905	2	3
44357923	19059056	2	3
45656353	1129625	0	0
44340543	1149380	0	0
45647197	1545959	2	3
45663242	1177480	0	0
45648232	1174888	0	0
45625180	1174888	0	0
45691658	1332418	0	0
45780995	1557272	0	0
45651646	1595799	0	0
45679630	1500211	0	0
45676298	1110410	0	0
45786900	1174888	0	0
45777778	1112807	0	0
45797980	738818	0	0
46288619	1738521	0	0
46244380	1738521	0	0
46241740	1192710	0	0
46239615	40232448	2	3
45789048	1125315	0	0
46312186	1125315	0	0
4090615	78272	2	2
193460	4059173	3	4
21500595	1129625	2	2
4274025	442116	5	6
36157062	1115171	2	3
36152267	1129625	0	0
36155906	19078461	2	3
36502199	80502	4	4
42803087	1713332	0	0
44338018	791967	0	0
44357502	40229134	2	3
44359132	42707627	2	3
45656463	1129625	0	0
44340512	1118084	0	0
45641598	1539411	2	3
45663021	1177480	0	0
45648273	738818	0	0
45625186	1332418	0	0
45691661	1174888	0	0
45780998	1000560	0	0
45651326	1174888	0	0
45679631	1149196	0	0
45672259	1738521	0	0
45786903	1717327	0	0
45706371	1112807	0	0
45798040	1343916	0	0
46288881	1549786	0	0
46244373	1192710	0	0
46241745	1118084	0	0
46239621	19059056	2	3
45788965	1125315	0	0
46312205	1125315	0	0
4042835	4283893	2	2
193460	4109685	3	4
21500604	1115008	2	2
4274025	439406	5	6
35507067	46275916	2	3
36152267	1112807	0	0
36151342	19078461	2	3
36211677	4084167	4	4
42803088	1112807	0	0
44337733	1759842	0	0
44357714	46275916	2	3
44359180	1115171	2	3
45656624	1129625	0	0
44340486	1115008	0	0
45659558	1539411	2	3
45663249	1177480	0	0
45647860	705944	0	0
45625245	1174888	0	0
45691663	1115008	0	0
45781031	1551099	0	0
45651327	1174888	0	0
45679639	791967	0	0
45672304	1332418	0	0
45786904	1115008	0	0
45706486	1112807	0	0
45797993	1545958	0	0
46288889	1310149	0	0
46244194	1153428	0	0
46241748	975125	0	0
46240237	40229134	2	3
45789003	1125315	0	0
46312350	1125315	0	0
4042835	4156265	2	2
1548195	40221415	3	4
21500604	1125315	2	2
4274025	4306014	5	6
35507212	1115171	2	3
36151910	738818	0	0
36154974	40228214	2	3
36516993	317576	4	4
42803145	1539403	0	0
44363691	1343916	0	0
44354569	40232448	2	3
44359185	43012036	2	3
45652995	1129625	0	0
44340494	920293	0	0
45665241	1539411	2	3
45663466	1177480	0	0
45648287	1322184	0	0
45625194	975125	0	0
45691435	1519936	0	0
45781032	738818	0	0
45651329	1124957	0	0
45679716	1589505	0	0
45671925	1551099	0	0
45786908	975125	0	0
45706443	1112807	0	0
45797824	1115008	0	0
46288461	1738521	0	0
46244258	1149196	0	0
46241691	1738521	0	0
45896227	1115171	2	3
45789006	1125315	0	0
46312287	1125315	0	0
4152154	4202451	2	2
73553	4149245	3	3
21500604	1124300	2	2
4274025	4156265	5	7
36212328	19128022	2	3
36151911	1177480	0	0
36155203	40228214	2	3
36211325	4156265	4	4
42803184	1125315	0	0
44363312	1115008	0	0
44350813	1551192	2	3
44358931	19008572	2	3
45652923	1129625	0	0
44340417	1115008	0	0
45653553	1539411	2	3
45660111	1177480	0	0
45648115	1308738	0	0
45625195	1545958	0	0
45691527	1308738	0	0
45781044	1192710	0	0
45651331	1107830	0	0
45679242	1000560	0	0
45671926	975125	0	0
45786433	1107830	0	0
45706604	1112807	0	0
45797998	1713332	0	0
46288372	1153428	0	0
46244199	1738521	0	0
46241674	1124957	0	0
45896231	19019273	2	3
45789057	1125315	0	0
46312430	1125315	0	0
4176801	4057420	2	2
77960	80809	3	3
21500653	1112807	2	2
4274025	4230399	7	10
35508397	19019273	2	3
36151911	1129625	0	0
36224185	19127904	2	3
36211325	4230399	4	4
42803112	1332418	0	0
44363669	1177480	0	0
44350612	1115171	2	3
44358396	40162522	2	3
45652937	1129625	0	0
44340502	1332418	0	0
45632431	19079524	1	1
45634196	1112807	0	0
45648192	1154029	0	0
45625198	1149196	0	0
45689757	1000560	0	0
45781051	738818	0	0
45651338	1501700	0	0
45679565	1551099	0	0
45672201	1000560	0	0
45786434	975125	0	0
45703245	1112807	0	0
45797998	1759842	0	0
46288866	1112807	0	0
46244202	1000560	0	0
46241766	705944	0	0
45896253	19126352	2	3
45788949	1125315	0	0
46311837	1125315	0	0
4172515	4107731	2	3
77960	4146173	3	3
21500653	1125315	2	2
4274025	40479768	7	9
35508775	19019273	2	3
36152105	1119510	0	0
36151177	1107882	2	3
36211315	40479768	4	4
42802260	1557272	0	0
44363708	1326303	0	0
44350419	40232448	2	3
44358420	1127433	2	3
45653178	1129625	0	0
44340611	1332418	0	0
45632271	19079524	1	1
45634084	1112807	0	0
45648254	1343916	0	0
45625201	1174888	0	0
45689701	1174888	0	0
45781052	1115008	0	0
45651341	1000560	0	0
45674500	1713332	0	0
45672202	967823	0	0
45786577	753626	0	0
45703095	1112807	0	0
45798005	1107830	0	0
46288867	1124300	0	0
46244203	1124957	0	0
46241764	1539403	0	0
45896240	40232448	2	3
45789144	1125315	0	0
46311838	1125315	0	0
4101219	4285898	2	3
432795	4094814	3	3
21500643	19003953	2	2
4274025	4144583	7	7
21603453	40229134	2	3
36152294	1539403	0	0
36155937	1107882	2	3
36211315	40479422	4	4
42802245	1307863	0	0
44363716	1361711	0	0
44350711	40232448	2	3
44358369	782047	2	3
45653352	1129625	0	0
44340636	19127890	0	0
45623345	19079524	1	1
45629132	1112807	0	0
45648257	933724	0	0
45625145	1521369	0	0
45689703	1124957	0	0
45781055	1124957	0	0
45651461	715997	0	0
45674623	740275	0	0
45671909	738818	0	0
45786579	1539403	0	0
45703099	1112807	0	0
45798007	1115008	0	0
46288816	1174888	0	0
46244347	757627	0	0
46242602	1174888	0	0
45896396	19008572	2	3
45789138	1125315	0	0
46311912	1125315	0	0
4115106	4285898	2	3
432795	381316	3	3
21001758	19133905	2	3
4274025	375671	6	10
36156644	40228214	2	3
36152297	1124300	0	0
36150763	1107882	2	3
36000000	4169137	4	4
42802303	1124300	0	0
44363717	933724	0	0
44350517	40236824	2	3
44358474	1127433	2	3
45653151	1129625	0	0
44340636	1515774	0	0
45665452	19079524	1	1
45628973	1112807	0	0
45648258	1115008	0	0
45625145	1595799	0	0
45689795	1107830	0	0
45781025	1307863	0	0
45651447	1310149	0	0
45674625	1174888	0	0
45672188	1124957	0	0
45786583	975125	0	0
45703219	1112807	0	0
45799744	738818	0	0
46288881	1589505	0	0
46244350	975125	0	0
46242611	1307863	0	0
45896342	1310034	2	3
45789032	1125315	0	0
46311997	1125315	0	0
4042835	40481087	2	3
432586	440086	3	3
21001758	19133873	2	3
4274025	4146173	6	8
35509025	1107882	2	3
36152299	738818	0	0
36156485	1107882	2	3
36211303	4299128	4	4
42802273	1307863	0	0
44363475	1124300	0	0
44350532	40232448	2	3
44358612	46275916	2	3
45653276	1129625	0	0
44340636	1549786	0	0
45626583	19079524	1	1
45629269	1112807	0	0
45648022	1548195	0	0
45625145	1549786	0	0
45689765	738818	0	0
45781143	1174888	0	0
45651449	791967	0	0
45674583	1589505	0	0
45672243	1107830	0	0
45785255	967823	0	0
45700010	1112807	0	0
45795188	967823	0	0
46288900	1115008	0	0
46239174	975125	0	0
46242578	1501700	0	0
45896607	920334	2	3
45789148	1125315	0	0
46311999	1125315	0	0
4027384	198809	2	6
432586	378419	3	3
21003223	40232448	2	3
4274025	433125	6	6
36156637	19078461	2	3
36152412	1549786	0	0
36207527	3000963	2	3
36211303	4296205	4	4
42802282	1153428	0	0
44363412	1112807	0	0
44350685	19076374	2	3
44358656	19073183	2	3
45653345	1129625	0	0
44340462	967823	0	0
45665375	19079524	1	1
45627888	1112807	0	0
45648026	1322184	0	0
45625215	738818	0	0
45689745	791967	0	0
45781013	1115008	0	0
45651462	738818	0	0
45674585	967823	0	0
45672311	791967	0	0
45785306	1738521	0	0
45700030	1112807	0	0
45795158	1713332	0	0
46288632	1192710	0	0
46239394	1713332	0	0
46242566	1153428	0	0
45896610	43012036	2	3
46301922	1125315	0	0
46308790	1125315	0	0
4028902	4037675	5	6
443883	4294548	3	3
21003185	46275916	2	3
4274025	4237458	6	9
36156620	19079524	2	3
36151913	1118084	0	0
36207527	3006906	2	3
36300000	4191853	4	4
42802332	1124300	0	0
44363417	920293	0	0
44350522	19133873	2	3
44358661	1115171	2	3
45653133	1129625	0	0
44340197	1174888	0	0
45626391	19079524	1	1
45627984	1112807	0	0
45648127	1332418	0	0
45625220	791967	0	0
45689749	19127890	0	0
45780980	1500211	0	0
45651463	1548195	0	0
45674691	19002770	0	0
45672199	1361711	0	0
45785340	1192710	0	0
45697125	1112807	0	0
45795151	967823	0	0
46288644	1115008	0	0
46239358	1713332	0	0
46241837	1118084	0	0
45893954	40236824	2	3
46301961	1125315	0	0
46308813	1125315	0	0
4172024	433644	5	6
200174	134438	3	3
21002670	46233710	2	3
4274025	4059173	6	9
36156671	19079524	2	3
36151923	1119510	0	0
36207527	3014576	2	3
36206173	3028833	5	5
42802309	723013	0	0
44363673	1112807	0	0
44350713	1115171	2	3
44351379	19133905	2	3
45653114	1129625	0	0
44340200	1713332	0	0
45647284	19079524	1	1
45626121	1112807	0	0
45644802	1102527	0	0
45625238	1000560	0	0
45689749	1589505	0	0
45780982	1174888	0	0
45651705	753626	0	0
45674706	1589505	0	0
45672327	1192710	0	0
45785309	1174888	0	0
45697043	1112807	0	0
45795189	1107830	0	0
46288648	1124300	0	0
46239372	1000560	0	0
46241850	1545958	0	0
45894024	1127433	2	3
46301965	1125315	0	0
46303622	1125315	0	0
4091532	81893	5	6
197917	198809	3	3
21002455	46275444	2	3
21500972	1149380	2	2
36157232	1545959	2	3
36151927	1177480	0	0
36207527	3009542	2	3
36206173	3020655	6	6
42802295	1154029	0	0
44363356	1124300	0	0
44350721	19073188	2	3
44351293	40229134	2	3
45653216	1129625	0	0
44340334	1118084	0	0
45626240	19079524	1	1
45626130	1112807	0	0
45644789	1192710	0	0
45625312	1738521	0	0
45689749	1549786	0	0
45780987	1107830	0	0
45652199	738818	0	0
45674711	1118084	0	0
45672263	1500211	0	0
45785283	1174888	0	0
45693900	1112807	0	0
45795194	738818	0	0
46288656	1115008	0	0
46239373	1557272	0	0
46241863	1107830	0	0
45894025	1127433	2	3
46301827	1125315	0	0
46303312	1125315	0	0
4091363	4112343	5	6
4021915	439777	3	3
21002421	46275444	2	3
21500972	1129625	2	2
36156867	19078461	2	3
36152361	975125	0	0
36150937	19078461	2	3
36206173	3007461	3	7
42802394	715997	0	0
44363507	1124300	0	0
44351071	40232448	2	3
44351356	40229134	2	3
45649975	1129625	0	0
44340602	708298	0	0
45623116	19079524	1	1
45626148	1112807	0	0
45644786	19127890	0	0
45625155	1149196	0	0
45689772	1551099	0	0
45780989	967823	0	0
45652200	1154343	0	0
45674714	1713332	0	0
45672432	1501700	0	0
45785283	1192710	0	0
45694055	1112807	0	0
45795323	1549786	0	0
46288825	1115008	0	0
46239435	1174888	0	0
46241838	1192710	0	0
45894026	1127433	2	3
46298967	1125315	0	0
46303279	1125315	0	0
4042836	378001	5	6
4021780	195588	3	3
21003454	40224132	2	3
21500972	975125	2	2
35509015	19078461	2	3
36152363	975125	0	0
36211065	4230399	2	3
36206173	3014576	3	7
42802406	1000560	0	0
44363762	1000560	0	0
44351079	19059056	2	3
44351429	40236824	2	3
45649991	1129625	0	0
44340605	1332418	0	0
45657041	19079524	1	1
45626375	1112807	0	0
45644786	1521369	0	0
45625202	1332418	0	0
45689841	1557272	0	0
45780990	1746114	0	0
45652301	1107830	0	0
45674714	1759842	0	0
45672051	1174888	0	0
45785284	1115008	0	0
45690966	1112807	0	0
45795323	19127890	0	0
46288830	1115008	0	0
46239578	1149196	0	0
46241887	19010482	0	0
45894027	1127433	2	3
46299548	1125315	0	0
46303442	1125315	0	0
4115259	258780	5	5
4022571	28060	3	3
21003454	1519937	2	3
4179713	4163971	2	2
36156949	40228214	2	3
36152365	1149196	0	0
36224164	42902245	2	3
36206173	3045716	3	7
42802410	791967	0	0
44363806	1149380	0	0
44348529	1127433	2	3
44351514	1551192	2	3
45646780	1129625	0	0
44340203	738818	0	0
45641661	19079524	1	1
45622762	1112807	0	0
45644786	1549786	0	0
45624124	967823	0	0
45689708	738818	0	0
45780990	1741122	0	0
45652256	1107830	0	0
45674835	1124300	0	0
45672052	1343916	0	0
45785359	1367571	0	0
45688086	1112807	0	0
45795323	1521369	0	0
46288842	1107830	0	0
46239457	1545958	0	0
46241871	1309944	0	0
45894028	1127433	2	3
46299549	1125315	0	0
46303452	1125315	0	0
4177703	81893	5	5
4020347	78272	3	3
21003454	40224805	2	3
21600985	1322184	2	2
36218510	40221415	2	3
36152368	975125	0	0
36151049	19123231	2	3
36206173	3026361	3	8
42802418	19127890	0	0
44363811	1177480	0	0
44348654	40236824	2	3
44351616	1127433	2	3
45647131	1129625	0	0
44340357	1153428	0	0
45632281	19079524	1	1
45623179	1112807	0	0
45644990	967823	0	0
45624125	1500211	0	0
45689659	1332418	0	0
45781015	1115008	0	0
45651978	1595799	0	0
45674957	1192710	0	0
45672271	1343916	0	0
45785299	1112807	0	0
45688088	1112807	0	0
45795109	1326303	0	0
46291628	975125	0	0
46239532	1124957	0	0
46241814	1322184	0	0
45894122	782047	2	3
46299384	1125315	0	0
46303719	1125315	0	0
4132647	4336464	5	5
444089	196456	3	3
21003454	44816277	2	3
21600985	1112807	2	2
35508889	40228214	2	3
36157452	933724	0	0
36224165	42902245	2	3
36502202	80180	4	4
42802418	1521369	0	0
44363813	1343916	0	0
44347072	40236824	2	3
44351559	35605482	2	3
45647137	1129625	0	0
44340608	1124300	0	0
45644543	19079524	1	1
45623103	1112807	0	0
45644852	791967	0	0
45624128	1308738	0	0
45689899	1305058	0	0
45781064	738818	0	0
45651978	1521369	0	0
45674958	1174888	0	0
45672331	975125	0	0
45785314	1326303	0	0
45688131	1112807	0	0
45795112	1310149	0	0
46291631	1192710	0	0
46239540	1332418	0	0
46241818	1738521	0	0
45894097	19133905	2	3
46299553	1125315	0	0
46303722	1125315	0	0
4028908	4024958	5	5
1176472	3023103	2	2
21002671	19008572	2	3
4187630	45766064	2	2
35509157	19079524	2	3
36157453	1129625	0	0
36151074	1545959	2	3
36502202	381316	5	5
42802418	1549786	0	0
44363817	738818	0	0
44346976	1551192	2	3
44351466	19133905	2	3
45646891	1129625	0	0
44340224	1107830	0	0
45667849	19079524	1	1
45621504	1112807	0	0
45644894	1307863	0	0
45624129	1729720	0	0
45689666	738818	0	0
45780450	1332418	0	0
45651978	1549786	0	0
45674953	715997	0	0
45672445	1149196	0	0
45785304	705944	0	0
45688190	1112807	0	0
45795197	1307863	0	0
46290991	1778162	0	0
46239458	791967	0	0
46241851	723013	0	0
45894097	19133873	2	3
46299178	1125315	0	0
46303114	1125315	0	0
4042835	4048171	5	5
1176472	3016723	2	2
21500645	42707627	2	3
21604793	836654	2	2
35509152	19078461	2	3
36157457	1118084	0	0
36155267	1545959	2	3
36502202	80809	5	5
42802384	1551099	0	0
44363817	1112807	0	0
42804388	1177480	0	0
44351775	43012036	2	3
45646710	1129625	0	0
44340450	715997	0	0
45663375	19079524	1	1
45667461	1112807	0	0
45644895	738818	0	0
45624137	1192710	0	0
45689678	1174888	0	0
45780454	967823	0	0
45652013	1713332	0	0
45674734	1361711	0	0
45672343	914335	0	0
45785323	791967	0	0
45688247	1112807	0	0
45795221	1500211	0	0
46291655	1112807	0	0
46239459	975125	0	0
46242004	1551099	0	0
45894062	19019273	2	3
46299396	1125315	0	0
46303115	1125315	0	0
4029205	4062501	5	5
444089	195588	2	2
21500599	19007333	2	3
4179873	80180	2	2
35506858	19078461	2	3
36157757	1192710	0	0
36150758	1551192	2	3
36502202	80502	5	5
42802362	1177480	0	0
44363831	738818	0	0
42804389	1177480	0	0
44351820	40236824	2	3
45647119	1129625	0	0
44340324	738818	0	0
45660084	46275916	1	1
45665265	1112807	0	0
45644896	1551099	0	0
45624149	1521369	0	0
45689680	1326303	0	0
45780692	1343916	0	0
45652013	1759842	0	0
45674737	1759842	0	0
45672281	1332418	0	0
45785354	1551099	0	0
45688313	1112807	0	0
45795199	914335	0	0
46291783	1545958	0	0
46239686	1000560	0	0
46241831	1548195	0	0
45894164	40236824	2	3
46299210	1125315	0	0
46303814	1125315	0	0
4029205	40478878	5	5
73553	4146173	2	2
21502881	19007333	2	3
4179873	317576	2	2
35508924	1332419	2	3
36157761	1119510	0	0
36151340	19019273	2	3
36502202	4310024	4	6
42802386	1500211	0	0
44363922	1177480	0	0
42804430	1551099	0	0
44351362	40163554	2	3
45647121	1129625	0	0
44340346	1551099	0	0
45660084	19079524	1	1
45665338	1112807	0	0
45644900	933724	0	0
45624149	1549786	0	0
45689684	975125	0	0
45778579	723013	0	0
45651914	1332418	0	0
45674737	1713332	0	0
45672353	1551099	0	0
45785317	1115008	0	0
45684697	1112807	0	0
45795200	933724	0	0
46291306	1153428	0	0
46239548	1115008	0	0
45897899	1115008	0	0
45801567	19019273	2	3
46298815	1125315	0	0
46303618	1125315	0	0
4029205	44805732	5	5
73553	4035415	2	2
21500203	19018935	2	3
21500851	1713671	2	2
36156536	1545959	2	3
36157761	1192710	0	0
36155808	19018935	2	3
36502202	40486433	6	6
42802527	1119510	0	0
44363998	1149380	0	0
42804205	1332418	0	0
44351869	40232448	2	3
45647128	1129625	0	0
44340356	1124300	0	0
45663287	19079524	1	1
45665038	1112807	0	0
45644902	967823	0	0
45624154	967823	0	0
45689871	738818	0	0
45778592	1713332	0	0
45651914	1545958	0	0
45674741	1115008	0	0
45672354	1545958	0	0
45785473	967823	0	0
45685021	1112807	0	0
45795352	1515774	0	0
46288949	1539403	0	0
46239638	791967	0	0
45897902	1738521	0	0
46240275	19078461	2	3
46298847	1125315	0	0
46303754	1125315	0	0
4086181	4043241	7	8
444090	4109685	2	2
21003205	40232448	2	3
21500027	1738521	2	2
35506817	1545959	2	3
36157524	1129625	0	0
36151362	42707627	2	3
36502202	317576	6	6
42802375	1124300	0	0
44363987	1545958	0	0
42804282	1738521	0	0
44343976	19019273	2	3
45647142	1129625	0	0
44340442	1545958	0	0
45663287	46275916	1	1
45665360	1112807	0	0
45644922	738818	0	0
45624143	1332418	0	0
45689685	914335	0	0
45778592	1759842	0	0
45652062	1515774	0	0
45674757	1124957	0	0
45672290	967823	0	0
45785581	1713332	0	0
45684713	1112807	0	0
45795352	1549786	0	0
46288920	1149196	0	0
46239639	1192710	0	0
45897903	1738521	0	0
45790827	1545959	2	3
46299007	1125315	0	0
46303779	1125315	0	0
4029205	4047491	7	8
77635	4113008	2	2
21002332	920300	2	3
4042678	4216130	2	2
36217210	35605482	2	3
36157313	1107830	0	0
36154962	40236446	2	3
36502202	4280726	6	6
42802441	975125	0	0
44363359	1149380	0	0
42804477	1500211	0	0
44343831	40228230	2	3
45647199	1129625	0	0
44340443	1149196	0	0
45641742	19079524	1	1
45662465	1112807	0	0
45644924	1000560	0	0
45624203	933724	0	0
45689692	975125	0	0
45778624	1149196	0	0
45652062	19127890	0	0
45674659	738818	0	0
45672097	975125	0	0
45785581	1759842	0	0
45684787	1112807	0	0
45795352	19127890	0	0
46288931	967823	0	0
46239554	1332418	0	0
45897978	1124957	0	0
46290560	19019273	2	3
46299511	1125315	0	0
46303320	1125315	0	0
4042140	40479768	7	10
433128	40480160	2	2
21002332	920334	2	3
4077953	4035793	2	2
36217216	1713671	2	3
36157511	1309944	0	0
36210656	3000963	2	3
36502202	4134304	7	10
42802529	1738521	0	0
44363360	1521369	0	0
42804421	1125315	0	0
44343895	40232448	2	3
45646987	1129625	0	0
44340581	1332418	0	0
45626544	19079524	1	1
45662892	1112807	0	0
45644931	1115008	0	0
45624523	975125	0	0
45689694	1115008	0	0
45778637	1738521	0	0
45652062	1549786	0	0
45674592	975125	0	0
45672458	1149196	0	0
45785584	975125	0	0
45682053	1112807	0	0
45795416	1332418	0	0
46288932	1124300	0	0
46239515	1713332	0	0
45897961	1107830	0	0
46244225	40163554	2	3
46299240	1125315	0	0
46303697	1125315	0	0
4042140	40479422	7	10
433128	4066995	2	2
21002475	40224132	2	3
4300244	4337138	2	2
36217216	19019273	2	3
36157347	1129625	0	0
36210656	3016723	2	3
36502202	40479768	6	10
42802514	933724	0	0
44363360	1549786	0	0
42804421	1124957	0	0
44343995	1594382	2	3
45645773	1129625	0	0
44340600	1332418	0	0
45659649	19079524	1	1
45662911	1112807	0	0
45644933	1118084	0	0
45624185	1549786	0	0
45689853	1115008	0	0
45778587	1539403	0	0
45652392	1115008	0	0
45674634	1307863	0	0
45672565	1326303	0	0
45785454	1521369	0	0
45682160	1112807	0	0
45795417	1192710	0	0
46288936	1557272	0	0
46239515	1759842	0	0
45897962	1174888	0	0
46243886	40163554	2	3
46299522	1125315	0	0
46303971	1125315	0	0
4042140	133834	7	9
443784	381316	2	2
21002475	40224805	2	3
21600972	1367571	2	2
36217214	19019979	2	3
36157353	1129625	0	0
36210656	3024561	2	3
36502202	40479422	6	10
42802532	1177480	0	0
44363365	1308738	0	0
42804422	1125315	0	0
44344029	19008572	2	3
45645946	1129625	0	0
44337263	1539403	0	0
45626114	19079524	1	1
45662936	1112807	0	0
45645012	738818	0	0
45624185	1515774	0	0
45689864	1549786	0	0
45778618	1343916	0	0
45652264	1149196	0	0
45674874	742185	0	0
45672389	1332418	0	0
45785586	1332418	0	0
45682015	1112807	0	0
45795419	1149196	0	0
46288935	705944	0	0
46239702	1149196	0	0
45897804	705944	0	0
45804361	40163554	2	3
46299251	1125315	0	0
46304015	1125315	0	0
4088727	4125906	1	1
197917	196456	2	2
21004035	19076374	2	3
21500098	1305058	2	2
36217214	19075001	2	3
36157355	1154029	0	0
36154987	1154615	2	3
36502202	78272	5	10
42802605	1589505	0	0
44363421	967823	0	0
42804422	1124957	0	0
44344074	46275916	2	3
45643877	1129625	0	0
44337290	1778162	0	0
45621446	19079524	1	1
45664352	1112807	0	0
45645022	1551099	0	0
45624191	1124957	0	0
45689864	19127890	0	0
45778595	1107830	0	0
45652307	1124300	0	0
45674648	1551099	0	0
45672402	1717327	0	0
45785482	1149196	0	0
45705081	1177480	0	0
45795500	1738521	0	0
46289108	1124300	0	0
46239324	1149196	0	0
45897805	1000560	0	0
46244386	1332419	2	3
46301569	1125315	0	0
46304024	1125315	0	0
4098879	4198190	1	1
78831	4059173	2	2
21001751	19073188	2	3
4042646	4145310	2	2
36217214	1107882	2	3
36157361	1119510	0	0
36155154	40232448	2	3
36502202	4296204	4	7
42802605	1549786	0	0
44364013	1539403	0	0
42804471	920293	0	0
44344240	40162522	2	3
45644004	1129625	0	0
44337399	1115008	0	0
45650401	19079524	1	1
45664561	1112807	0	0
45644936	1124957	0	0
45624142	1332418	0	0
45686619	975125	0	0
45778604	1149196	0	0
45652315	1115008	0	0
45674955	1192710	0	0
45672403	1322184	0	0
45785399	740275	0	0
45705294	1177480	0	0
45795242	1112807	0	0
46289280	1192710	0	0
46239325	1124957	0	0
45897993	1539403	0	0
46244129	40163554	2	3
46301578	1125315	0	0
46303914	1125315	0	0
4178452	4144583	1	1
75053	4142905	2	2
21002374	46233988	2	3
4042646	4238715	2	2
36217214	46233710	2	3
36157361	1129625	0	0
36154677	1127433	2	3
36502202	4155034	7	7
42902702	40169216	0	0
44364017	1332418	0	0
42804400	914335	0	0
44344172	19019273	2	3
45644217	1129625	0	0
44337339	1000560	0	0
45635418	19079524	1	1
45659803	1112807	0	0
45644869	1149196	0	0
45624156	1322184	0	0
45686785	1589505	0	0
45778605	920293	0	0
45651797	1343916	0	0
45675053	1589505	0	0
45672463	975125	0	0
45785403	1112807	0	0
45779987	1177480	0	0
45795431	1521369	0	0
46289008	1738521	0	0
46239326	1174888	0	0
45897883	1308738	0	0
45792063	46233710	2	3
46301646	1125315	0	0
46303918	1125315	0	0
4149795	4059978	1	1
75865	4116491	2	2
21002374	46233710	2	3
21601079	1595799	2	2
36217214	19019273	2	3
36157363	1174888	0	0
36155061	1115171	2	3
36502202	4048171	7	7
42804136	1118084	0	0
44363533	1124957	0	0
42804242	1326303	0	0
44344687	19008572	2	3
45644236	1129625	0	0
44337410	1124957	0	0
45635418	46275916	1	1
45657177	1112807	0	0
45644806	1149196	0	0
45624226	1308738	0	0
45686785	1549786	0	0
45778606	1124957	0	0
45651860	705944	0	0
45675055	1124957	0	0
45672466	1361711	0	0
45785589	1149196	0	0
45780104	1177480	0	0
45795433	1112807	0	0
46289316	1149196	0	0
46239579	1512674	0	0
45897887	967823	0	0
46242317	1332419	2	3
46301851	1125315	0	0
46300925	1125315	0	0
4151199	4237458	1	1
75128	4142905	2	2
21003421	46233710	2	3
21601079	1396131	2	2
36217214	1713671	2	3
36157364	1119510	0	0
36155215	19008572	2	3
36502202	4113008	7	7
42804188	1713332	0	0
44363991	1107830	0	0
42804245	1322184	0	0
44344425	19008572	2	3
45641127	1129625	0	0
44337411	1107830	0	0
45662917	19079524	1	1
45656730	1112807	0	0
45645027	1192710	0	0
45624198	1549786	0	0
45686546	1115008	0	0
45778612	1110410	0	0
45697737	1115008	0	0
45675056	740275	0	0
45672567	914335	0	0
45785412	782043	0	0
45780020	1177480	0	0
45795435	1174888	0	0
46289317	1124957	0	0
46239579	1549786	0	0
45897946	1713332	0	0
45796549	40163554	2	3
46301813	1125315	0	0
46300875	1125315	0	0
4151202	4142905	1	1
443583	81151	2	2
21003421	46233988	2	3
4034850	4012477	2	2
21602818	19073188	2	5
36157554	1149196	0	0
36155230	19018935	2	3
36502202	4230399	8	9
42804111	708298	0	0
44363994	1124300	0	0
42804303	1396131	0	0
44337523	40236824	2	3
45641165	1129625	0	0
44337319	1000560	0	0
45632171	19079524	1	1
45653407	1112807	0	0
45645097	920293	0	0
45624198	1521369	0	0
45686552	791967	0	0
45778613	738818	0	0
45697861	1332418	0	0
45675037	1539403	0	0
45672568	967823	0	0
45785370	1107830	0	0
45780054	1177480	0	0
45795441	1310149	0	0
46288974	1000560	0	0
46239580	1192710	0	0
45895744	1738521	0	0
45801453	1713671	2	3
46295832	1125315	0	0
46300876	1125315	0	0
4149519	4012477	1	1
193666	4230399	2	2
21001753	19074841	2	3
21500909	1343916	2	2
21602818	19133905	2	5
36157387	1000560	0	0
36155275	19008572	2	3
36502202	81151	5	9
42804168	1713332	0	0
44363511	1713332	0	0
42804356	1124300	0	0
44337556	1594382	2	3
45641299	1129625	0	0
44337348	1118084	0	0
45665408	19079524	1	1
45653826	1112807	0	0
45645099	1539403	0	0
45624165	1192710	0	0
45686555	1551099	0	0
45778719	1000560	0	0
45697862	1154343	0	0
45675001	1539403	0	0
45672569	975125	0	0
45785452	753626	0	0
45780113	1177480	0	0
45795285	1149196	0	0
46288940	1501700	0	0
46239674	1000560	0	0
45895786	1115008	0	0
45793188	19078461	2	3
46296075	1125315	0	0
46300885	1125315	0	0
4149530	4010253	1	1
195771	4144583	2	2
21001753	19074843	2	3
21500909	1738521	2	2
21602818	19133873	2	5
36157426	1115008	0	0
36156317	1551192	2	3
36502202	4149245	5	9
42804168	1759842	0	0
44363623	1307863	0	0
42804357	1124300	0	0
44337651	40236446	2	3
45641237	1129625	0	0
44337353	1115008	0	0
45665366	19079524	1	1
45653710	1112807	0	0
45645092	1115008	0	0
45637384	1125315	0	0
45686556	1746114	0	0
45778639	19002770	0	0
45700778	1738521	0	0
45674976	1174888	0	0
45672580	1545958	0	0
45785465	1305058	0	0
45706102	1177480	0	0
45795287	1115008	0	0
46288946	1322184	0	0
46239444	975125	0	0
45895790	1153428	0	0
45798757	19019273	2	3
46296104	1125315	0	0
46301811	1125315	0	0
4152129	4197460	1	1
195856	198809	2	2
21001769	46233988	2	3
4042673	4216130	2	2
21602818	19073183	2	5
36157430	1153428	0	0
36156552	19123231	2	3
36502202	4152936	7	9
42804154	1322184	0	0
44363624	738818	0	0
42804415	1729720	0	0
44337594	19008572	2	3
45641247	1129625	0	0
44337401	1310149	0	0
45647249	19079524	1	1
45650266	1112807	0	0
45645087	1332418	0	0
45637337	1125315	0	0
45686556	1741122	0	0
45778642	1174888	0	0
45700720	1000560	0	0
45674879	738818	0	0
45672469	1115008	0	0
45785573	1118084	0	0
45706173	1177480	0	0
45795292	1713332	0	0
46288976	1332418	0	0
46239447	1149380	0	0
45895747	1149380	0	0
45801461	40174880	2	3
46295741	1125315	0	0
46301663	1125315	0	0
4152932	4155034	1	1
4022173	4108705	2	2
21001769	46233710	2	3
21500094	742185	2	2
21602515	40221415	2	5
36157437	1129625	0	0
36223493	40221415	2	3
36502202	4059173	7	8
42804118	1177480	0	0
44363625	1738521	0	0
42804416	920293	0	0
44337586	1127433	2	3
45642972	1129625	0	0
44337354	1738521	0	0
45667570	19079524	1	1
45650389	1112807	0	0
45644888	1539403	0	0
45621844	1125315	0	0
45686602	1549786	0	0
45778764	1539403	0	0
45700722	791967	0	0
45674882	1124300	0	0
45672571	791967	0	0
45785677	967823	0	0
45706184	1177480	0	0
45795293	1115008	0	0
46288983	933724	0	0
46239755	1192710	0	0
45895757	19003953	0	0
46294669	46233710	2	3
46295934	1125315	0	0
46301628	1125315	0	0
4152932	4113008	1	1
1177480	19019979	2	3
21506167	19019273	2	3
4046698	4336464	2	2
21603445	19112599	2	5
36157412	1129625	0	0
36223494	40221415	2	3
36502202	4237458	6	8
42804122	1305058	0	0
44363789	1174888	0	0
42804325	1177480	0	0
44337569	19008572	2	3
45642973	1129625	0	0
44337413	723013	0	0
45623540	19079524	1	1
45650120	1112807	0	0
45645089	1713332	0	0
45621793	1125315	0	0
45686869	914335	0	0
45778673	1153428	0	0
45700723	1174888	0	0
45674884	1107830	0	0
45672363	1332418	0	0
45785425	1713332	0	0
45706463	1177480	0	0
45795300	1000560	0	0
46289101	1738521	0	0
46239757	1192710	0	0
45895849	1759842	0	0
46298522	19078461	2	3
46295984	1125315	0	0
46302071	1125315	0	0
4152960	4152936	1	1
1177480	19078461	2	3
21003404	1551192	2	3
21501012	1192710	2	2
35702113	4266809	3	8
36157529	1119510	0	0
36151026	1127433	2	3
36502202	40480160	6	8
42804227	1332418	0	0
44363582	975125	0	0
42804472	1177480	0	0
44337726	40232448	2	3
45638153	1129625	0	0
44337328	1539403	0	0
45623540	46275916	1	1
45650451	1112807	0	0
45645089	1759842	0	0
45621984	1125315	0	0
45686872	1738521	0	0
45778674	1778162	0	0
45700726	1738521	0	0
45675071	1149196	0	0
45672470	1149380	0	0
45785382	1174888	0	0
45706578	1177480	0	0
45795284	1309944	0	0
46289285	1332418	0	0
46239659	1500211	0	0
45896002	967823	0	0
45801848	19078461	2	3
46296028	1125315	0	0
46301279	1125315	0	0
4152960	4109685	1	1
1154343	1154615	2	3
21500206	19126352	2	3
4078460	4202451	2	2
35702113	30753	3	8
36157534	914335	0	0
36150872	1115171	2	3
36502202	4278672	6	8
42804137	1332418	0	0
44363583	1149196	0	0
42804450	1310149	0	0
45622216	40163554	2	3
45638045	1129625	0	0
44337330	701322	0	0
45650243	19079524	1	1
45650368	1112807	0	0
45645044	1192710	0	0
45620584	1125315	0	0
45686457	1717327	0	0
45778678	738818	0	0
45700730	1551099	0	0
45675074	1728416	0	0
45672219	791967	0	0
45785388	1154343	0	0
45706494	1177480	0	0
45795518	19010482	0	0
46289135	742185	0	0
46239725	1124300	0	0
45895794	975125	0	0
46295357	46275916	1	1
46296037	1125315	0	0
46301259	1125315	0	0
4132082	375671	1	1
1713332	19073188	2	3
21001746	1713671	2	3
21600962	1310149	2	2
21602796	920300	3	6
36157536	738818	0	0
36151307	1127433	2	3
36502202	4142905	6	8
42804096	1115008	0	0
44363551	975125	0	0
42804461	1713332	0	0
45622184	1545959	2	3
45638174	1129625	0	0
45620321	975125	0	0
45632212	19079524	1	1
45650630	1112807	0	0
45645106	738818	0	0
45620590	1125315	0	0
45686604	1548195	0	0
45778925	738818	0	0
45700735	1149196	0	0
45674666	1174888	0	0
45672585	1107830	0	0
45785392	1310149	0	0
45699715	1177480	0	0
45795541	1557272	0	0
46243596	19010482	0	0
46239758	1539403	0	0
45895825	1107830	0	0
46295531	19079524	1	1
46296051	1125315	0	0
46301336	1125315	0	0
4132546	4001336	1	1
1174888	40162522	2	3
21002434	46275444	2	3
4042642	4181917	2	2
21602796	19133905	3	6
36157536	1119510	0	0
36151320	46275444	2	3
36502202	4048695	5	8
42804190	1738521	0	0
44363553	1551099	0	0
42804461	1759842	0	0
44358682	40232448	2	3
45638165	1129625	0	0
45620324	1174888	0	0
45647145	19079524	1	1
45648872	1112807	0	0
45645172	914335	0	0
45620565	1125315	0	0
45686879	1322184	0	0
45778929	914335	0	0
45700659	1305058	0	0
45674668	1174888	0	0
45672485	1174888	0	0
45782957	1307863	0	0
45699721	1177480	0	0
45795542	975125	0	0
46243715	1332418	0	0
46239747	1110410	0	0
45895813	740275	0	0
46297566	19079524	1	1
46295996	1125315	0	0
46301192	1125315	0	0
4056125	4314290	1	1
1174888	19133768	2	3
21506158	19079524	2	3
21600961	1310149	2	2
21602796	920334	3	6
36157538	1112807	0	0
36151326	40229134	2	3
36502202	4066995	5	8
42804158	1115008	0	0
44363557	742185	0	0
42804469	1118084	0	0
45658451	1551192	2	3
45638382	1129625	0	0
45620190	1308738	0	0
45667591	19079524	1	1
45644274	1112807	0	0
45645287	920293	0	0
45620643	1125315	0	0
45686634	1118084	0	0
45778647	1000560	0	0
45648719	791967	0	0
45674769	1110410	0	0
45672488	1192710	0	0
45783342	723013	0	0
45699773	1177480	0	0
45795305	967823	0	0
46243553	1154029	0	0
46239731	1738521	0	0
45895826	1107830	0	0
46234524	46233710	1	1
46295963	1125315	0	0
46301200	1125315	0	0
4059308	4242997	1	1
1192710	19112599	2	3
21013496	1551192	2	3
21600961	1112807	2	2
21602796	19073183	3	6
36157581	1177480	0	0
36151215	40232448	2	3
36502202	133834	8	8
42804206	1545958	0	0
44363495	738818	0	0
42804424	1551099	0	0
45658680	40174880	2	3
45638383	1129625	0	0
45620271	1322184	0	0
45635204	19079524	1	1
45644372	1112807	0	0
45645211	1768849	0	0
45620785	1125315	0	0
45686650	1154343	0	0
45778723	967823	0	0
45648666	1154343	0	0
45675084	738818	0	0
45672588	1713332	0	0
45783411	1501700	0	0
45699731	1177480	0	0
45795617	1717327	0	0
46243718	1500211	0	0
46239732	1713332	0	0
45895857	914335	0	0
46234352	920334	1	1
46296238	1125315	0	0
46301319	1125315	0	0
4059978	44805732	1	1
1545958	1545959	2	3
21001745	19073183	2	3
21600961	1322184	2	2
21602796	1717327	3	3
36157472	1115008	0	0
36151242	40229134	2	3
36302170	4084167	5	8
42804141	1322184	0	0
44363836	920293	0	0
42804457	19002770	0	0
45658699	40229134	2	3
45637132	1129625	0	0
45620273	723013	0	0
45632317	19079524	1	1
45644297	1112807	0	0
45645059	708298	0	0
45620654	1125315	0	0
45686845	967823	0	0
45778724	1192710	0	0
45648725	1551099	0	0
45675086	1343916	0	0
45672378	1124300	0	0
45783321	1153428	0	0
45699749	1177480	0	0
45795620	1501700	0	0
46243624	1332418	0	0
46239736	1192710	0	0
45895838	1305058	0	0
46234411	46233988	1	1
46295328	1125315	0	0
46301325	1125315	0	0
4061650	4197460	1	1
1766397	1545959	2	3
21001745	19073188	2	3
21600961	1367571	2	2
21602796	1738521	3	3
36157541	1501700	0	0
36151106	19008572	2	3
36302170	4243062	5	7
42804194	1759842	0	0
44363964	1332418	0	0
42804480	1000560	0	0
45658709	19075601	2	3
45634945	1129625	0	0
45620379	1717327	0	0
45653412	46275916	1	1
45644469	1112807	0	0
45645176	1124300	0	0
45620658	1125315	0	0
45686847	933724	0	0
45778896	1332418	0	0
45648727	1501700	0	0
45675060	1307863	0	0
45672496	1343916	0	0
45783350	914335	0	0
45693717	1177480	0	0
45795638	1729720	0	0
46243625	1174888	0	0
45896022	967823	0	0
45895849	1713332	0	0
46296490	19079524	1	1
46295973	1125315	0	0
46301409	1125315	0	0
4063381	257012	1	1
1580772	1332419	2	3
21001739	19075001	2	3
4174389	4242997	2	2
21602796	1713332	3	3
36157685	1545958	0	0
36151155	1127433	2	3
36302170	134438	5	10
42804194	1713332	0	0
44363608	1192710	0	0
42804482	1177480	0	0
45658747	40232448	2	3
45634856	1129625	0	0
45620384	1192710	0	0
45656666	19079524	1	1
45641431	1112807	0	0
45645317	1501700	0	0
45620701	1125315	0	0
45686853	1551099	0	0
45778651	1174888	0	0
45648728	1115008	0	0
45675062	1102527	0	0
45672498	1713332	0	0
45783420	1112807	0	0
45693599	1177480	0	0
45795380	1307863	0	0
46243630	975125	0	0
45896023	1713332	0	0
45895839	975125	0	0
46316915	42902245	2	2
46296246	1125315	0	0
46301441	1125315	0	0
4042673	4163951	1	1
1768849	19074843	2	3
21001757	19074843	2	3
21500988	1343916	2	2
21602796	1746114	3	3
36157598	1549786	0	0
36211232	4142905	2	3
36302170	439777	5	10
42804196	1717327	0	0
44363608	1112807	0	0
42804283	1124300	0	0
45658796	40229134	2	3
44362714	1177480	0	0
45620170	738818	0	0
45667730	46275916	1	1
45641435	1112807	0	0
45645320	1153428	0	0
45620724	1125315	0	0
45686921	1738521	0	0
45778886	1539403	0	0
45648534	967823	0	0
45675026	1149196	0	0
45672592	1310149	0	0
45783448	1174888	0	0
45690724	1177480	0	0
45795382	1107830	0	0
46243511	1154029	0	0
45896089	1107830	0	0
45895830	1343916	0	0
45794269	40228214	2	3
46296152	1125315	0	0
46301329	1125315	0	0
4044368	4058899	1	1
1768849	19074841	2	3
21001757	19133905	2	3
136779	4278672	2	2
21602796	1768849	3	3
36157610	1332418	0	0
36155823	1545959	2	3
36302170	196456	5	11
42804237	1713332	0	0
44363910	1177480	0	0
42804288	1545958	0	0
45658798	1115171	2	3
44362717	1177480	0	0
45620173	1332418	0	0
45629534	46275916	1	1
45641458	1112807	0	0
45645222	1110410	0	0
45620723	1125315	0	0
45686864	920293	0	0
45778889	1115008	0	0
45648492	1501700	0	0
45674725	1115008	0	0
45672596	975125	0	0
45783450	1310149	0	0
45690696	1177480	0	0
45792547	1115008	0	0
46243562	1741122	0	0
45895937	1153428	0	0
45895910	1192710	0	0
46242059	40228214	2	3
46295581	1125315	0	0
46319235	1125315	0	0
4044900	4170947	1	1
1759842	1713671	2	3
21001757	19073188	2	3
21601625	1361711	2	2
21602796	1778162	3	3
36157473	1308738	0	0
36155724	40229134	2	3
36302170	4195803	4	4
42804237	1759842	0	0
44363914	975125	0	0
42804531	1177480	0	0
45658808	19059056	2	3
44361965	1177480	0	0
45620187	1174888	0	0
45629534	19079524	1	1
45641648	1112807	0	0
45645202	738818	0	0
45620746	1125315	0	0
45686718	967823	0	0
45778966	1174888	0	0
45648593	1174888	0	0
45675038	1149196	0	0
45672605	1738521	0	0
45783463	1115008	0	0
45690780	1177480	0	0
45792683	1115008	0	0
46243562	1746114	0	0
45895990	933724	0	0
45895929	1192710	0	0
45789345	19075601	2	3
46295682	1125315	0	0
46319449	1125315	0	0
4028919	4234705	1	1
1539403	1539411	2	3
21001757	19133873	2	3
21500879	975125	2	2
21602796	920293	3	3
36157475	1119510	0	0
36157928	1125315	0	0
36302170	4012477	4	7
42804295	1115008	0	0
44363770	701322	0	0
42804512	1501700	0	0
45659004	1127433	2	3
44362009	1177480	0	0
45620294	1192710	0	0
45649507	19079524	1	1
45641542	1112807	0	0
45645203	1589505	0	0
45620752	1125315	0	0
45686939	967823	0	0
45778966	1192710	0	0
45648595	967823	0	0
45674779	1396131	0	0
45672615	1107830	0	0
45783163	1307863	0	0
45690810	1177480	0	0
45792655	1343916	0	0
46243736	1115008	0	0
45896062	1713332	0	0
45895954	1332418	0	0
45793924	40228214	2	3
46295685	1125315	0	0
46319699	1125315	0	0
4028919	4230209	1	1
1557272	40173590	2	3
21001757	19073183	2	3
21500879	1738521	2	2
35502617	140673	3	3
36157475	738818	0	0
36158305	1125315	0	0
36302170	4144583	10	10
42804297	1332418	0	0
44363966	1124957	0	0
42804529	1000560	0	0
45658482	40174880	2	3
44362023	1177480	0	0
45620260	1110410	0	0
45659834	19079524	1	1
45641792	1112807	0	0
45645326	740275	0	0
45620710	1125315	0	0
45686940	1500211	0	0
45778834	1115008	0	0
45648603	1307863	0	0
45674780	1549786	0	0
45672227	715997	0	0
45783514	975125	0	0
45687426	1177480	0	0
45792593	1501700	0	0
46243739	933724	0	0
45896063	1521369	0	0
45895956	1778162	0	0
46241557	19078461	2	3
46295591	1125315	0	0
46319701	1125315	0	0
4183452	372328	1	1
1766561	1107882	2	3
21003656	46233988	2	3
21500925	975125	2	2
21603248	1154343	3	3
36157515	1119510	0	0
36158308	1125315	0	0
36302170	80180	6	8
42804340	1545958	0	0
44364016	1177480	0	0
42804491	1309944	0	0
45658853	19008572	2	3
45656208	1177480	0	0
45620429	1149196	0	0
45650146	19079524	1	1
45638297	1112807	0	0
45645378	1174888	0	0
45661584	1125315	0	0
45687000	1501700	0	0
45778690	1549786	0	0
45648735	1115008	0	0
45674780	19127890	0	0
45784027	1738521	0	0
45783369	1738521	0	0
45688581	1177480	0	0
45792719	1192710	0	0
46243610	1149196	0	0
45896064	1000560	0	0
45896019	1000560	0	0
45793690	40228214	2	3
46296402	1125315	0	0
46319453	1125315	0	0
4133611	381316	1	1
1580765	1107882	2	3
21003174	40229134	2	3
21500925	1361711	2	2
21603248	1137529	3	3
36157517	1119510	0	0
36158206	1125315	0	0
36302170	317576	6	12
42804299	1713332	0	0
44363982	975125	0	0
42804493	914335	0	0
45658739	1551192	2	3
45656274	1177480	0	0
45620437	967823	0	0
45638260	19079524	1	1
45638391	1112807	0	0
45645307	1174888	0	0
45661734	1125315	0	0
45686967	1115008	0	0
45778658	1713332	0	0
45648742	1738521	0	0
45674783	1154343	0	0
45784343	1000560	0	0
45783370	1738521	0	0
45684625	1177480	0	0
45792721	1174888	0	0
46243611	1112807	0	0
45896076	715997	0	0
45896108	1107830	0	0
45799002	40228214	2	3
46296413	1125315	0	0
46319461	1125315	0	0
4115576	196456	1	1
1766414	1107882	2	3
21003174	1107882	2	3
21500999	967823	2	2
21603248	1149380	3	3
36157520	1177480	0	0
36158207	1125315	0	0
36302170	4156265	8	11
42804270	1717327	0	0
44356737	1521369	0	0
42804495	1129625	0	0
45658923	19126352	2	3
45652440	1177480	0	0
45620442	1174888	0	0
45623557	46275916	1	1
45638402	1112807	0	0
45642135	1501700	0	0
45661519	1125315	0	0
45687002	738818	0	0
45778877	1361711	0	0
45648776	1768849	0	0
45674899	1589505	0	0
45784344	1589505	0	0
45783362	723013	0	0
45684735	1177480	0	0
45792495	1149196	0	0
46243614	1322184	0	0
45896107	975125	0	0
45896057	1309944	0	0
46298341	40228214	2	3
46296417	1125315	0	0
46319652	1125315	0	0
4091589	4012477	1	1
791967	19057271	2	3
21003174	1150837	2	3
21600033	975125	2	2
21603932	1115008	3	3
36157687	1115008	0	0
36157936	1125315	0	0
36302170	81151	8	13
42804254	1545958	0	0
44356737	1549786	0	0
42804496	1343916	0	0
45658893	19075601	2	3
45652524	1177480	0	0
45620553	1115008	0	0
45632147	46275916	1	1
45638486	1112807	0	0
45642139	1124957	0	0
45661744	1125315	0	0
45687005	1115008	0	0
45778692	1343916	0	0
45648579	1110410	0	0
45674900	1549786	0	0
45784351	1154343	0	0
45783058	1551099	0	0
45684591	1177480	0	0
45792584	1115008	0	0
46243616	975125	0	0
45896192	1551099	0	0
45895979	1367571	0	0
45788675	19079524	2	3
46295592	1125315	0	0
46319770	1125315	0	0
4029205	4170947	1	1
77960	4035415	2	3
21003174	19125062	2	3
21600003	975125	2	2
21603932	1118084	3	3
36157689	1149196	0	0
36158342	1125315	0	0
36302170	4142905	8	12
42804274	1713332	0	0
44356531	1713332	0	0
42804498	1361711	0	0
45658499	1127433	2	3
45652638	1177480	0	0
45620265	1110410	0	0
45634139	19079524	1	1
45638465	1112807	0	0
45642150	1551099	0	0
45661961	1125315	0	0
45687015	738818	0	0
45707538	1115008	0	0
45648684	1713332	0	0
45674900	1521369	0	0
45784353	738818	0	0
45783063	975125	0	0
45684594	1177480	0	0
45792614	1112807	0	0
46243522	1112807	0	0
45895887	1729720	0	0
45895984	1192710	0	0
45798931	19079524	2	3
46295602	1125315	0	0
46319771	1125315	0	0
4090616	78272	1	1
444089	4310024	2	3
21003174	43012036	2	3
21601119	1308738	2	2
21604181	19039298	3	3
36157628	1149380	0	0
36158371	1125315	0	0
36302170	4169137	8	9
42804280	1713332	0	0
44356531	1759842	0	0
42804501	914335	0	0
45658864	40232448	2	3
45652713	1177480	0	0
45620402	1124300	0	0
45628919	46275916	1	1
45638547	1112807	0	0
45643026	1174888	0	0
45661861	1125315	0	0
45686931	742185	0	0
45707178	1515774	0	0
45648746	1124300	0	0
45674900	1595799	0	0
45784256	1174888	0	0
45783518	1501700	0	0
45684810	1177480	0	0
45792667	1112807	0	0
46243525	933724	0	0
45895994	1115008	0	0
45895957	1149196	0	0
46241681	19078461	2	3
46291186	1125315	0	0
46322554	1125315	0	0
4132804	4323902	1	1
920293	920300	2	3
21003174	19112599	2	3
21604564	791967	2	2
21602002	1129625	3	3
36157630	1107830	0	0
36158338	1125315	0	0
36302170	438614	8	9
42804280	1759842	0	0
44356505	738818	0	0
42804250	1118084	0	0
45659013	43012036	2	3
45652802	1177480	0	0
45620403	1107830	0	0
45629144	46275916	1	1
45638627	1112807	0	0
45643040	723013	0	0
45661873	1125315	0	0
45686807	1308738	0	0
45707178	19127890	0	0
45648701	920293	0	0
45674912	1115008	0	0
45784260	1768849	0	0
45783522	1551099	0	0
45684762	1177480	0	0
45792595	1112807	0	0
46243645	1118084	0	0
45896058	975125	0	0
45803982	1153428	0	0
45795784	40228214	2	3
46291142	1125315	0	0
46322564	1125315	0	0
4168004	4168004	0	0
1766598	19073183	2	3
21001738	40229134	2	3
21604564	723013	2	2
21602515	19128009	3	3
36157635	1119510	0	0
36158436	1125315	0	0
36302170	4304110	8	9
42804222	1322184	0	0
44356540	1174888	0	0
42804251	1396131	0	0
44352123	19077344	2	3
45649708	1177480	0	0
45620545	1589505	0	0
45628096	19079524	1	1
45635399	1112807	0	0
45643041	1548195	0	0
45661877	1125315	0	0
45685658	1713332	0	0
45707178	1549786	0	0
45648750	1115008	0	0
45674914	1174888	0	0
45784262	738818	0	0
45783529	1551099	0	0
45684844	1177480	0	0
45792609	1124957	0	0
46243647	975125	0	0
45896148	1154343	0	0
45803985	1174888	0	0
46297972	19078461	2	3
46291149	1125315	0	0
46322567	1125315	0	0
4151422	4151422	0	0
77630	4146173	2	3
21001743	19073188	2	3
21601606	1361711	2	2
21603551	975125	3	3
36157635	1192710	0	0
36158375	1125315	0	0
36302170	4299128	8	8
42804150	920293	0	0
44356740	738818	0	0
42804252	1177480	0	0
44351940	40231925	2	3
45649845	1177480	0	0
45620545	1549786	0	0
45621561	19079524	1	1
45635314	1112807	0	0
45643042	1307863	0	0
45661521	1125315	0	0
45683553	1174888	0	0
45707369	757627	0	0
45648794	1115008	0	0
45675145	1548195	0	0
45784316	1000560	0	0
45783262	1332418	0	0
45684818	1177480	0	0
45792623	1521369	0	0
46243651	1153428	0	0
45896129	1118084	0	0
45804114	1549786	0	0
45788881	19078461	2	3
46291276	1125315	0	0
46322571	1125315	0	0
4152936	4152936	0	0
1519936	1519937	2	3
21001743	19129655	2	3
21604792	757627	2	2
21603551	1124300	3	3
36157715	1549786	0	0
36157824	1125315	0	0
36302170	140673	7	9
42804316	1124300	0	0
44356544	1545958	0	0
42804313	1115008	0	0
44352072	19078461	2	3
45649974	1177480	0	0
45620133	1778162	0	0
45663020	46275916	1	1
45635413	1112807	0	0
45643043	1174888	0	0
45661524	1125315	0	0
45683557	1149196	0	0
45707120	1102527	0	0
45648853	1174888	0	0
45671682	1729720	0	0
45784280	738818	0	0
46291160	1501700	0	0
45681386	1177480	0	0
45792623	1503184	0	0
46243724	1500211	0	0
45896133	1174888	0	0
45804114	1515774	0	0
45893803	19078461	2	3
46290893	1125315	0	0
46319913	1125315	0	0
4132546	4132546	0	0
1519936	43012433	2	3
21001743	1713671	2	3
4176944	40481087	2	2
21603551	914335	3	3
36157718	1500211	0	0
36158346	1125315	0	0
36302170	4051466	7	8
42804152	1177480	0	0
44356579	1768849	0	0
42804338	1545958	0	0
45652119	40232448	2	3
45646328	1177480	0	0
45620268	1738521	0	0
45656910	19079524	1	1
45635653	1112807	0	0
45643021	738818	0	0
45661878	1125315	0	0
45683559	1548195	0	0
45707517	1512674	0	0
45648948	1000560	0	0
45671686	975125	0	0
45784361	1115008	0	0
46291165	1149196	0	0
45681591	1177480	0	0
45792623	19127890	0	0
46243502	1549786	0	0
45896041	1310149	0	0
45804116	1343916	0	0
46297764	19078461	2	3
46290922	1125315	0	0
46320058	1125315	0	0
4144583	4144583	0	0
1153428	40223834	2	3
21001743	19073183	2	3
4122944	4252419	2	2
21603551	1343916	3	3
36157722	1119510	0	0
36158348	1125315	0	0
36302170	4109685	7	11
42804397	791967	0	0
44356668	1332418	0	0
42804442	1125315	0	0
45652120	40232448	2	3
45648942	1177480	0	0
45620362	1192710	0	0
45656679	46275916	1	1
45632296	1112807	0	0
45643116	1549786	0	0
45661881	1125315	0	0
45683568	708298	0	0
45707517	19127890	0	0
45648836	914335	0	0
45671729	1000560	0	0
45784250	1595799	0	0
46291170	1551099	0	0
45682625	1177480	0	0
45792623	1549786	0	0
46243502	19127890	0	0
45896044	1713332	0	0
45804242	1115008	0	0
45787767	19078461	2	3
46291152	1125315	0	0
46319953	1125315	0	0
4059173	4059173	0	0
192438	4285898	2	3
21001770	1150771	2	3
4122944	4024289	2	2
21603551	967823	3	3
36157735	1115008	0	0
36158445	1125315	0	0
36302170	30753	7	11
42804333	1332418	0	0
44356612	975125	0	0
42804339	1545958	0	0
45652026	40223768	2	3
45648795	1177480	0	0
45620556	1107830	0	0
45657031	19079524	1	1
45632288	1112807	0	0
45643116	1521369	0	0
45661535	1125315	0	0
45683561	1107830	0	0
45707517	1549786	0	0
45648782	1110410	0	0
45671731	753626	0	0
45784250	1521369	0	0
46291172	1115008	0	0
45681824	1177480	0	0
45792590	1174888	0	0
46243502	1515774	0	0
45896153	1124957	0	0
45804102	920293	0	0
45793933	19078461	2	3
46244757	1125315	0	0
46320014	1125315	0	0
4059978	4059978	0	0
1766450	1127433	2	3
21001770	19125062	2	3
4185916	4243062	2	2
35622751	4218408	1	1
36157741	1112807	0	0
36158447	1125315	0	0
36302170	4283893	7	11
42804223	1545958	0	0
44356624	738818	0	0
42804533	1326303	0	0
45652330	1115171	2	3
45646449	1177480	0	0
45620542	1107830	0	0
45646902	46275916	1	1
45632516	1112807	0	0
45643116	1595799	0	0
45662011	1125315	0	0
45683675	1551099	0	0
45707522	1149196	0	0
45648847	1000560	0	0
45671706	920293	0	0
45784250	1549786	0	0
46291177	1192710	0	0
45678490	1177480	0	0
45794547	1322184	0	0
46243623	708298	0	0
45896091	1115008	0	0
45804122	1192710	0	0
46289803	19078461	2	3
46244695	1125315	0	0
46320029	1125315	0	0
4062501	4062501	0	0
1766494	19126352	2	3
21001770	40228230	2	3
257007	4048171	2	2
36157208	19127904	1	2
36157901	1129625	0	0
36158457	1125315	0	0
36302170	380378	7	10
42804267	1310149	0	0
44356628	1177480	0	0
42804508	1343916	0	0
45652164	40232448	2	3
45646640	1177480	0	0
45620545	19127890	0	0
45647074	46275916	1	1
45632518	1112807	0	0
45642266	1310149	0	0
45661842	1125315	0	0
45683704	19127890	0	0
45707523	1501700	0	0
45648848	1115008	0	0
45671715	740275	0	0
45784151	1000560	0	0
46291826	933724	0	0
45672298	1177480	0	0
45794548	1112807	0	0
46243579	1107830	0	0
45896645	740275	0	0
45804136	1000560	0	0
46289987	19079524	2	3
46244971	1125315	0	0
46320039	1125315	0	0
4058899	4058899	0	0
1766609	920334	2	3
21001770	1107882	2	3
192353	198809	2	2
36157133	19128263	1	2
36157645	975125	0	0
36158495	1125315	0	0
36302170	4113008	7	10
42804352	1118084	0	0
44356604	1549786	0	0
42804510	1307863	0	0
45652359	1551192	2	3
45646685	1177480	0	0
45620492	1107830	0	0
45647430	19079524	1	1
45629292	1112807	0	0
45642194	1115008	0	0
45661895	1125315	0	0
45683704	1512674	0	0
45707524	738818	0	0
45648970	920293	0	0
45671732	1551099	0	0
45784369	975125	0	0
46291831	1192710	0	0
45784517	1177480	0	0
45794558	791967	0	0
46243769	1332418	0	0
45896743	1124300	0	0
45804245	1153428	0	0
45793681	40228214	2	3
46244634	1125315	0	0
46319997	1125315	0	0
4066995	4066995	0	0
1766595	19008572	2	3
21001770	43012036	2	3
4042660	44783196	2	2
36212271	19074679	1	2
36157646	1177480	0	0
36158496	1125315	0	0
36302170	378419	7	12
42902746	40169281	0	0
44356604	1521369	0	0
42804428	1551099	0	0
45652176	40169281	2	3
45646785	1177480	0	0
45620447	1713332	0	0
45644257	19079524	1	1
45629525	1112807	0	0
45642247	1153428	0	0
45661847	1125315	0	0
45683704	1549786	0	0
45707180	1322184	0	0
45648979	1115008	0	0
45671840	1713332	0	0
45784264	1367571	0	0
46291860	1192710	0	0
45784642	1177480	0	0
45794568	1124957	0	0
46243771	1310149	0	0
45896721	1107830	0	0
45804070	1115008	0	0
46241941	19078461	2	3
46244637	1125315	0	0
46320202	1125315	0	0
4047491	4047491	0	0
4022201	4146173	2	3
21001770	19112599	2	3
4186167	4237458	2	2
36009833	80809	0	1
36157696	1119510	0	0
36158215	1125315	0	0
36302170	4294548	7	13
42902244	42902245	0	0
44356604	19127890	0	0
42804429	1551099	0	0
45652229	40174880	2	3
45643250	1177480	0	0
45620137	975125	0	0
45641486	46275916	1	1
45629180	1112807	0	0
45642179	1149196	0	0
45661692	1125315	0	0
45683740	1115008	0	0
45707185	1309944	0	0
45648981	933724	0	0
45671840	1759842	0	0
45784268	1149196	0	0
46291349	1551099	0	0
45784853	1177480	0	0
45794539	1115008	0	0
46243814	1112807	0	0
45896722	967823	0	0
45803748	1115008	0	0
46297906	19079524	2	3
46244638	1125315	0	0
46313788	1125315	0	0
4169137	4169137	0	0
75909	40480160	2	4
21001750	19074841	2	3
4188027	37017711	2	2
21602823	19073183	0	3
36157699	1119510	0	0
36158417	1125315	0	0
36302170	4166224	9	13
42902245	42902245	0	0
44356605	1174888	0	0
42804522	1115008	0	0
44344444	19077344	2	3
45643577	1177480	0	0
45620149	1308738	0	0
45641651	46275916	1	1
45629610	1112807	0	0
45642180	1149380	0	0
45661777	1125315	0	0
45683746	1154029	0	0
45707580	1192710	0	0
45648944	1149196	0	0
45671813	1595799	0	0
45784310	1149196	0	0
46291353	1551099	0	0
45782692	1177480	0	0
45794437	715997	0	0
46243690	1738521	0	0
45896200	1322184	0	0
45804038	914335	0	0
45795874	19078461	2	3
46239908	1125315	0	0
46313563	1125315	0	0
442264	4149245	4	4
194526	4142905	2	4
21001750	46233710	2	3
4188027	433644	2	2
36202157	4278672	7	9
36157699	738818	0	0
36158477	1125315	0	0
36302170	375671	9	13
42903088	1154615	0	0
44356610	738818	0	0
42801720	1125315	0	0
44344273	46275916	2	3
45643671	1177480	0	0
45620151	1332418	0	0
45635453	46275916	1	1
45629596	1112807	0	0
45642185	738818	0	0
45661785	1125315	0	0
45683582	914335	0	0
45707376	740275	0	0
45648612	1153428	0	0
45671938	1124957	0	0
45784341	1551099	0	0
46291366	1728416	0	0
45782708	1177480	0	0
45794612	1118084	0	0
46243749	1713332	0	0
45804251	1153428	0	0
45804071	1322184	0	0
45788834	19078461	2	3
46240010	1125315	0	0
46313912	1125315	0	0
4103320	40481087	4	4
432795	4001336	4	7
21001750	19074843	2	3
4188027	4240902	2	2
36202157	4237458	8	9
36157564	1119510	0	0
36158530	1125315	0	0
36302170	378001	9	13
42806682	1112807	0	0
44356751	1115008	0	0
42801720	1174888	0	0
44344082	1115171	2	3
45643747	1177480	0	0
45620448	19039298	0	0
45632452	46275916	1	1
45626651	1112807	0	0
45642199	1305058	0	0
45661837	1125315	0	0
45683597	1124300	0	0
45707305	1115008	0	0
45648991	1124300	0	0
45671950	1367571	0	0
45786442	1307863	0	0
46291574	705944	0	0
45782796	1177480	0	0
45794615	1343916	0	0
46243695	1000560	0	0
45804257	975125	0	0
45804047	1174888	0	0
46241697	19078461	2	3
46239923	1125315	0	0
46313836	1125315	0	0
4040738	45769019	4	4
4020346	4146173	4	6
21001750	19133905	2	3
4188027	4219399	2	2
36203062	4134304	7	10
36157566	1149196	0	0
36154376	1125315	0	0
36302170	37017711	9	10
42806671	1177480	0	0
44356803	933724	0	0
42801724	705944	0	0
44344647	19059056	2	3
45643557	1177480	0	0
45620370	1500211	0	0
45632620	46275916	1	1
45626787	1112807	0	0
45642253	1124957	0	0
45661982	1125315	0	0
45683710	757627	0	0
45707311	1500211	0	0
45649126	1124300	0	0
45671738	1549786	0	0
45786359	1107830	0	0
46291594	1713332	0	0
45780220	1177480	0	0
45794603	914335	0	0
46243701	1192710	0	0
45804352	705944	0	0
45804051	1192710	0	0
46297506	40223768	2	3
46239931	1125315	0	0
46313719	1125315	0	0
4105895	4107731	4	4
4022201	4134304	4	6
21001750	19133873	2	3
4180154	45769019	2	2
36203062	78272	6	10
36157567	1124300	0	0
36154346	1125315	0	0
36516972	80809	3	3
42806667	1119510	0	0
44356804	1310149	0	0
42801642	933724	0	0
45646038	19075601	2	3
45645773	1177480	0	0
45620484	1332418	0	0
45629394	46275916	1	1
45626716	1112807	0	0
45642236	1107830	0	0
45661985	1125315	0	0
45683599	740275	0	0
45707385	1332418	0	0
45648622	705944	0	0
45671738	19127890	0	0
45786417	1000560	0	0
46291600	914335	0	0
45780474	1177480	0	0
45794610	1192710	0	0
46243902	1192710	0	0
45804336	1307863	0	0
45804054	1501700	0	0
45798907	19078461	2	3
46240106	1125315	0	0
46314050	1125315	0	0
4040722	40492359	4	4
73553	4134304	4	6
21001750	19073188	2	3
4077352	4163874	2	2
36203062	81151	6	9
36157568	1149196	0	0
36154583	1125315	0	0
36516972	80502	3	3
42806669	1149380	0	0
44356672	1192710	0	0
42801644	1000560	0	0
45646385	40236446	2	3
45640698	1177480	0	0
45620495	791967	0	0
45626592	46275916	1	1
45626672	1112807	0	0
45642240	1102527	0	0
45661901	1125315	0	0
45683600	1310149	0	0
45707387	1551099	0	0
45648629	1768849	0	0
45671738	1515774	0	0
45786456	1124957	0	0
46291615	1112807	0	0
45706533	1177480	0	0
45794734	757627	0	0
46243819	1551099	0	0
45804317	1738521	0	0
45804171	975125	0	0
46244518	19078461	2	3
46239873	1125315	0	0
46313849	1125315	0	0
4115390	321042	4	4
444112	4296204	4	6
21013536	46275444	2	3
4078068	4168004	2	2
36203062	375671	6	9
36157574	1119510	0	0
36154317	1125315	0	0
36516772	80502	3	3
42806728	1521369	0	0
44356673	1154029	0	0
42801684	1549786	0	0
45646293	19018935	2	3
45640890	1177480	0	0
45620505	1192710	0	0
45626704	19079524	1	1
45623298	1112807	0	0
45642209	1501700	0	0
45655525	1125315	0	0
45683747	738818	0	0
45707388	1107830	0	0
45649084	1174888	0	0
45671813	1308738	0	0
45786475	1192710	0	0
46291621	1778162	0	0
45706294	1177480	0	0
45794444	1548195	0	0
46243824	1000560	0	0
45804287	1310149	0	0
45803830	1545958	0	0
45788688	19078461	2	3
46239950	1125315	0	0
46314075	1125315	0	0
4042640	4323902	4	4
4028071	261325	4	6
21013536	1713671	2	3
4030886	4108705	2	2
36203062	378001	6	9
36157577	1119510	0	0
36154472	1125315	0	0
36516772	4035415	3	3
42806728	1595799	0	0
44356611	723013	0	0
42801684	1512674	0	0
45646408	40232448	2	3
45641042	1177480	0	0
45620509	1192710	0	0
45667963	46275916	1	1
45623357	1112807	0	0
45642272	1149380	0	0
45655569	1125315	0	0
45683640	1521369	0	0
45707195	1000560	0	0
45649152	967823	0	0
45671814	1343916	0	0
45786481	920293	0	0
46291793	1112807	0	0
45706419	1177480	0	0
45794446	1545958	0	0
46243825	1000560	0	0
45804319	1326303	0	0
45803924	791967	0	0
45793581	19079524	2	3
46240070	1125315	0	0
46314785	1125315	0	0
4180938	4163872	4	4
193460	81151	4	5
21001768	46233710	2	3
4122424	4202451	2	2
35702118	4285898	4	8
36157578	1119510	0	0
36154473	1125315	0	0
36703477	381316	3	3
42806728	1549786	0	0
44356692	975125	0	0
42801685	1119510	0	0
45645975	43012036	2	3
45640849	1177480	0	0
45620528	975125	0	0
45663454	40220386	1	1
45623567	1112807	0	0
45642216	1778162	0	0
45658264	1125315	0	0
45683640	1549786	0	0
45707383	1713332	0	0
45649134	1107830	0	0
45671976	1149380	0	0
45784394	1307863	0	0
46291751	1107830	0	0
45706459	1177480	0	0
45792779	738818	0	0
46243906	1738521	0	0
45804359	967823	0	0
45803926	1000560	0	0
45793553	19078461	2	3
46239968	1125315	0	0
46314535	1125315	0	0
4181063	4048171	4	4
193460	4230399	4	5
21001768	46233988	2	3
4098910	4117038	2	2
36203062	4059173	6	8
36157578	738818	0	0
36154476	1125315	0	0
36315348	4037675	3	3
42806735	1125315	0	0
44356758	1115008	0	0
42801729	1125315	0	0
45646196	19008572	2	3
45640800	1177480	0	0
44362084	1124300	0	0
45659674	46275916	1	1
45667662	1112807	0	0
45642330	738818	0	0
45658334	1125315	0	0
45683648	1154343	0	0
45707383	1759842	0	0
45649160	1501700	0	0
45671746	1343916	0	0
45784372	967823	0	0
46291762	1112807	0	0
45706621	1177480	0	0
45792734	1192710	0	0
46243780	1149196	0	0
45804361	1310149	0	0
45803935	1332418	0	0
46289942	19079524	2	3
46240130	1125315	0	0
46314544	1125315	0	0
4154739	4230399	4	4
444112	134438	4	5
21002349	920300	2	3
4099350	4116491	2	2
36203062	4278672	6	8
36157766	1129625	0	0
36154443	1125315	0	0
36602219	40480160	3	3
42806735	1174888	0	0
44356654	1512674	0	0
42801609	1177480	0	0
45643070	920334	2	3
45641176	1177480	0	0
44362250	975125	0	0
45649391	1125315	0	0
45667800	1112807	0	0
45642332	1332418	0	0
45658010	1125315	0	0
45683649	738818	0	0
45707497	708298	0	0
45649143	1307863	0	0
45671758	1149196	0	0
45784382	1778162	0	0
46291765	1115008	0	0
45706603	1177480	0	0
45792764	738818	0	0
46243783	705944	0	0
45804380	1174888	0	0
45804181	1521369	0	0
46241982	19078461	2	3
46240021	1125315	0	0
46314629	1125315	0	0
4154162	4001336	4	4
4028071	45769019	4	5
21002349	920334	2	3
4100621	4293740	2	2
36203062	4146173	6	8
36157643	1129625	0	0
36154444	1125315	0	0
40792670	3014576	3	3
42806680	1107830	0	0
44356710	738818	0	0
42801688	1153428	0	0
45643316	19019979	2	3
45641044	1177480	0	0
44362280	1713332	0	0
45649333	1125315	0	0
45667908	1112807	0	0
45642317	738818	0	0
45658341	1125315	0	0
45683788	1115008	0	0
45707503	1367571	0	0
45646162	1115008	0	0
45671954	1110410	0	0
45784392	1174888	0	0
46292019	1112807	0	0
45703045	1177480	0	0
45792770	1332418	0	0
46243786	1521369	0	0
45804379	1778162	0	0
45804181	1549786	0	0
45795852	19078461	2	3
46240119	1125315	0	0
46314569	1125315	0	0
4041285	4116491	4	4
4022201	81151	4	5
21001744	19073188	2	3
4101079	372328	2	2
36203062	40480160	8	8
36157643	1119510	0	0
36154389	1125315	0	0
36503296	4149245	3	4
42806756	19127890	0	0
44356717	967823	0	0
42801631	1738521	0	0
44357062	1125315	0	0
45641283	1177480	0	0
44362280	1759842	0	0
45649520	1125315	0	0
45667951	1112807	0	0
45642335	1305058	0	0
45655599	1125315	0	0
45683798	1549786	0	0
45707679	1115008	0	0
45646159	1110410	0	0
45671856	914335	0	0
45784457	738818	0	0
46291776	1107830	0	0
45703091	1177480	0	0
45792789	1343916	0	0
46243786	1549786	0	0
45804315	1149196	0	0
45804186	1332418	0	0
45794032	19078461	2	3
45896588	1125315	0	0
46314582	1125315	0	0
4042641	4078793	4	4
4022571	4112343	4	5
21001744	19073183	2	3
4100932	4035415	2	2
36203062	4237458	7	8
36157708	1332418	0	0
36154554	1125315	0	0
36516728	4237458	3	4
42806756	1589505	0	0
44356718	1112807	0	0
42801771	1000560	0	0
44357064	1125315	0	0
45641211	1177480	0	0
44362350	1343916	0	0
45649465	1125315	0	0
45667956	1112807	0	0
45642310	1759842	0	0
45655689	1125315	0	0
45683798	1589505	0	0
45707727	1326303	0	0
45645996	738818	0	0
45671897	1149196	0	0
45784440	1149380	0	0
46291452	1501700	0	0
45702971	1177480	0	0
45792746	715997	0	0
46243919	975125	0	0
45804388	1310149	0	0
45804022	1501700	0	0
45795857	19078461	2	3
45896592	1125315	0	0
46314674	1125315	0	0
4042641	4057420	4	4
444089	4166224	4	5
21002805	19019273	2	3
4309075	4047491	2	2
36203062	4048695	7	8
36157710	1112807	0	0
36154656	1125315	0	0
36503297	4146173	3	4
42806756	1549786	0	0
44356662	738818	0	0
42801766	1322184	0	0
44357176	1125315	0	0
45637584	1177480	0	0
44362353	1549786	0	0
45649441	1125315	0	0
45665456	1112807	0	0
45642310	1713332	0	0
45655700	1125315	0	0
45683798	19127890	0	0
45707665	1738521	0	0
45646235	1107830	0	0
45671994	1124300	0	0
45784442	1154029	0	0
46291458	975125	0	0
45699956	1177480	0	0
45792731	1539403	0	0
46243873	1149196	0	0
45796288	1115008	0	0
45804032	920293	0	0
45788461	19078461	2	3
45896485	1125315	0	0
46314994	1125315	0	0
4179141	40479768	4	4
4027553	260139	4	4
21002805	19078461	2	3
4309188	192671	2	2
36203062	4066995	7	8
36157616	1129625	0	0
36154647	1125315	0	0
36703500	44782520	3	4
42806758	1124300	0	0
44356654	1549786	0	0
42801706	708298	0	0
44357108	1125315	0	0
45637730	1177480	0	0
44362353	1521369	0	0
45649446	1125315	0	0
45665457	1112807	0	0
45642360	1545958	0	0
45655647	1125315	0	0
45683656	1729720	0	0
45707681	1110410	0	0
45646062	1149196	0	0
45672145	19127890	0	0
45784414	1000560	0	0
46291470	1124957	0	0
45700037	1177480	0	0
45792750	1332418	0	0
46241234	1118084	0	0
45796294	1557272	0	0
45804160	1310149	0	0
46301431	19078461	2	3
45896527	1125315	0	0
46315024	1125315	0	0
4179141	40479422	4	4
75053	4134304	4	4
21003410	1551192	2	3
21604214	40220386	2	3
36000000	4066995	7	8
36157620	1332418	0	0
36154652	1125315	0	0
36516781	4149245	3	4
42806761	1361711	0	0
44356731	715997	0	0
42801711	1521369	0	0
44357111	1125315	0	0
45637681	1177480	0	0
44362358	1361711	0	0
45649448	1125315	0	0
45665435	1112807	0	0
45642361	1107830	0	0
45655664	1125315	0	0
45683658	738818	0	0
45707683	1551099	0	0
45646331	1124300	0	0
45672145	1589505	0	0
45784488	1361711	0	0
46291693	1343916	0	0
45700120	1177480	0	0
45792881	1521369	0	0
46241235	1110410	0	0
45796389	1000560	0	0
45804168	1589505	0	0
46290232	19078461	2	3
45896438	1125315	0	0
46314723	1125315	0	0
4178367	4202451	4	4
4003568	40492359	4	4
21003153	1115171	2	3
35507611	1115171	2	3
35508496	1119510	0	0
36157793	1545958	0	0
36154728	1125315	0	0
36313967	40478878	3	4
42806763	1154343	0	0
44356847	933724	0	0
42801712	701322	0	0
44357116	1125315	0	0
45637690	1177480	0	0
44361983	1149196	0	0
45649449	1125315	0	0
45663232	1112807	0	0
45642391	1713332	0	0
45655760	1125315	0	0
45683698	740275	0	0
45707222	1192710	0	0
45646334	1310149	0	0
45672145	1549786	0	0
45784608	1307863	0	0
46291700	723013	0	0
45699922	1177480	0	0
45792881	1549786	0	0
46241478	1154029	0	0
45797153	1115008	0	0
45804168	1549786	0	0
45790789	40223768	2	3
45896503	1125315	0	0
46308793	1125315	0	0
4103662	4066995	4	4
432545	433125	4	4
21003153	1127078	2	3
35507491	40229134	2	3
35508496	1125315	0	0
36157771	1149196	0	0
36154731	1125315	0	0
36516781	81151	3	5
42806766	920293	0	0
44356930	1521369	0	0
42801767	1738521	0	0
44358910	1125315	0	0
45637948	1177480	0	0
44362219	1192710	0	0
45649492	1125315	0	0
45660069	1112807	0	0
45642391	1759842	0	0
45655980	1125315	0	0
45683699	19010482	0	0
45707225	1110410	0	0
45646339	1539403	0	0
45672146	1192710	0	0
45784435	1115008	0	0
46291978	1107830	0	0
45700073	1177480	0	0
45792882	738818	0	0
46241483	1115008	0	0
45797167	975125	0	0
45798784	975125	0	0
46298141	19078461	2	3
45896472	1125315	0	0
46308797	1125315	0	0
4178545	4283893	4	4
432545	28060	4	4
21003153	19078461	2	3
35507616	35605482	2	3
35508496	738818	0	0
36157711	1177480	0	0
36154732	1125315	0	0
36703500	381316	3	5
42806699	1153428	0	0
44357200	1115008	0	0
42801744	1118084	0	0
44358920	1125315	0	0
45637998	1177480	0	0
44361999	1545958	0	0
45631754	1125315	0	0
45649376	975125	0	0
45642399	1343916	0	0
45655818	1125315	0	0
45683700	1149380	0	0
45707490	1310149	0	0
45645683	1154343	0	0
45671871	1174888	0	0
45784490	1332418	0	0
46291906	1112807	0	0
45700395	1177480	0	0
45792890	1149380	0	0
46241279	1539403	0	0
45797298	1551099	0	0
45798791	1332418	0	0
46241902	19078461	2	3
45896473	1125315	0	0
46308801	1125315	0	0
4178545	372328	4	4
4022201	4059173	4	4
21003153	19059056	2	3
35507585	40162522	2	3
35508499	933724	0	0
36157939	975125	0	0
36154734	1125315	0	0
36516825	40480160	3	5
42806706	1000560	0	0
44357206	1308738	0	0
42801730	738818	0	0
44358718	1125315	0	0
45634502	1177480	0	0
44362085	1149196	0	0
45632050	1125315	0	0
45632175	975125	0	0
45638877	1717327	0	0
45655744	1125315	0	0
45683754	1118084	0	0
45707582	1115008	0	0
45645632	1115008	0	0
45672112	1343916	0	0
45784480	742185	0	0
46291909	791967	0	0
45700480	1177480	0	0
45792892	738818	0	0
46241441	1332418	0	0
45796532	1713332	0	0
45798792	1548195	0	0
46289970	19078461	2	3
45896681	1125315	0	0
46309180	1125315	0	0
4154161	4156265	4	4
4022201	40480160	4	4
21002350	19074843	2	3
35507492	1332419	2	3
35508502	791967	0	0
36157940	1738521	0	0
36154735	1125315	0	0
36500000	80180	3	5
42806748	1124300	0	0
44357270	1154343	0	0
42801655	1149380	0	0
44358751	1125315	0	0
45634800	1177480	0	0
44362088	1149380	0	0
45632149	1125315	0	0
45631974	975125	0	0
45638879	1308738	0	0
45655750	1125315	0	0
45683768	1729720	0	0
45707685	967823	0	0
45645618	1713332	0	0
45671903	1361711	0	0
45784482	723013	0	0
46291917	1738521	0	0
45697580	1177480	0	0
45792974	738818	0	0
46241407	1551099	0	0
45796501	1107830	0	0
45798882	1738521	0	0
46310895	19078461	2	3
45896682	1125315	0	0
46308948	1125315	0	0
4185115	4125906	4	4
4022201	40479768	4	4
21002350	920300	2	3
903386	45892894	2	3
35508456	738818	0	0
36157675	1119510	0	0
36154745	1125315	0	0
36300000	4163951	3	5
42806686	791967	0	0
44356722	1192710	0	0
42801735	1332418	0	0
44357302	1125315	0	0
45634738	1177480	0	0
44362094	1729720	0	0
45632086	1125315	0	0
45631874	975125	0	0
45639313	1521369	0	0
45655729	1125315	0	0
45683670	975125	0	0
45707598	1192710	0	0
45645804	1149196	0	0
45671907	1322184	0	0
45782311	1174888	0	0
46295773	1501700	0	0
45696908	1177480	0	0
45792979	1115008	0	0
46241315	1112807	0	0
45796512	975125	0	0
45798930	1174888	0	0
46310964	19078461	2	3
45896686	1125315	0	0
46308896	1125315	0	0
4071689	317576	4	4
4022201	4048695	4	4
21002350	920334	2	3
4044900	4058899	2	3
35508412	1174888	0	0
36157676	1549786	0	0
36154746	1125315	0	0
36500000	80502	3	6
42806842	975125	0	0
44356961	1107830	0	0
42801659	1177480	0	0
44357394	1125315	0	0
45634423	1177480	0	0
44362176	975125	0	0
45632160	1125315	0	0
45632227	975125	0	0
45639315	1551099	0	0
45655783	1125315	0	0
45683807	967823	0	0
45707599	1174888	0	0
45645708	1154343	0	0
45672030	738818	0	0
45782212	1539403	0	0
46295789	975125	0	0
45696917	1177480	0	0
45792980	1738521	0	0
46241458	1124300	0	0
45796549	1310149	0	0
45798931	967823	0	0
46316930	40223768	2	3
45896687	1125315	0	0
46308919	1125315	0	0
4071689	4310024	4	4
4022201	4278672	4	4
21002811	19078461	2	3
4180169	372328	2	3
35508412	1125315	0	0
36157676	19127890	0	0
36154748	1125315	0	0
36500000	80809	3	6
42806802	1000560	0	0
44356777	1713332	0	0
42801661	1192710	0	0
44357398	1125315	0	0
45634535	1177480	0	0
44362255	1332418	0	0
45632185	1125315	0	0
45634087	975125	0	0
45639222	1153428	0	0
45655943	1125315	0	0
45683773	1124957	0	0
45707318	1000560	0	0
45645610	1332418	0	0
45672038	1551099	0	0
45782316	1192710	0	0
46295795	1192710	0	0
45697075	1177480	0	0
45792741	1332418	0	0
46241464	1124957	0	0
45796669	1551099	0	0
45798673	1192710	0	0
46316862	19078461	2	3
45896554	1125315	0	0
46309286	1125315	0	0
4028071	4116491	4	4
4022201	40479422	4	4
21002811	1115171	2	3
4032251	4024289	2	3
35508268	1125315	0	0
36157676	1589505	0	0
36154751	1125315	0	0
36313966	439777	3	8
42806904	1548195	0	0
44356783	1545958	0	0
42801775	1557272	0	0
44357311	1125315	0	0
45634785	1177480	0	0
44362138	19010482	0	0
45632249	1125315	0	0
45634216	975125	0	0
45639135	738818	0	0
44348130	1125315	0	0
45683778	1741122	0	0
45707422	1192710	0	0
45645724	1310149	0	0
45672158	1154343	0	0
45782328	1000560	0	0
46244923	1149196	0	0
45697238	1177480	0	0
45792793	1717327	0	0
46241469	1149196	0	0
45796503	1115008	0	0
45798674	1115008	0	0
45799832	1332419	2	3
45896576	1125315	0	0
46309409	1125315	0	0
4103352	257012	4	4
4022201	4066995	4	4
21002491	1127433	2	3
4032251	4252419	2	3
35508506	975125	0	0
36157683	1112807	0	0
36154752	1125315	0	0
36516993	78272	3	8
42806777	1118084	0	0
44356764	1713332	0	0
42801778	1000560	0	0
44357345	1125315	0	0
45636982	1177480	0	0
44362457	1589505	0	0
45631989	1125315	0	0
45629075	975125	0	0
45639158	1174888	0	0
44348409	1125315	0	0
45683778	1746114	0	0
45707510	1000560	0	0
45645764	1124300	0	0
45671772	1192710	0	0
45782335	1729720	0	0
46244924	1322184	0	0
45696988	1177480	0	0
45792819	920293	0	0
46241473	1149196	0	0
45796479	19010482	0	0
45798682	1115008	0	0
45802454	1545959	2	3
45894735	1125315	0	0
46309131	1125315	0	0
4072499	4043071	4	4
4021667	4113008	4	4
21002491	19078461	2	3
1102527	40165015	2	3
35508507	1125315	0	0
36157684	1154343	0	0
36154564	1125315	0	0
36500000	4059173	3	9
42806754	1713332	0	0
44356971	1124300	0	0
42801781	1589505	0	0
44353627	1125315	0	0
45636795	1177480	0	0
44362461	975125	0	0
45631991	1125315	0	0
45629154	975125	0	0
45639229	1107830	0	0
44348200	1125315	0	0
45683783	1589505	0	0
45707406	1115008	0	0
45645792	1149196	0	0
45672071	1501700	0	0
45782422	1000560	0	0
46244927	1000560	0	0
45697303	1177480	0	0
45792903	1501700	0	0
46241326	1713332	0	0
45796553	1778162	0	0
45798560	1000560	0	0
45893732	1332419	2	3
45894624	1125315	0	0
46309307	1125315	0	0
4067285	4163971	4	4
4021667	4109685	4	4
21002491	19019273	2	3
21003024	19023398	2	3
35508413	791967	0	0
36157831	791967	0	0
36154573	1125315	0	0
36500000	4278672	3	9
42806811	1589505	0	0
44356697	1118084	0	0
42801781	19127890	0	0
44353941	1125315	0	0
45637317	1177480	0	0
44362463	1154029	0	0
45632004	1125315	0	0
45629215	975125	0	0
45639230	1548195	0	0
44348413	1125315	0	0
45683851	975125	0	0
45707415	1115008	0	0
45642677	1115008	0	0
45672077	1149380	0	0
45782221	1192710	0	0
46244928	1728416	0	0
45693938	1177480	0	0
45792908	1174888	0	0
46241328	1192710	0	0
45796482	967823	0	0
45798671	1174888	0	0
45790676	1332419	2	3
45894720	1125315	0	0
46309310	1125315	0	0
4043022	4163872	4	4
4021667	4155034	4	4
21002491	19059056	2	3
21003024	782047	2	3
35508415	1125315	0	0
36157833	1124300	0	0
36154812	1125315	0	0
36500000	4237458	3	9
42806870	19016749	0	0
44356703	975125	0	0
42801781	1549786	0	0
44353895	1125315	0	0
45631793	1177480	0	0
44362261	1124957	0	0
45632006	1125315	0	0
45628987	975125	0	0
45639272	967823	0	0
44348416	1125315	0	0
45683867	1501700	0	0
45707695	715997	0	0
45642688	967823	0	0
45672083	738818	0	0
45782357	975125	0	0
46275444	46275444	0	0
45694103	1177480	0	0
45792910	1112807	0	0
46241331	791967	0	0
45796490	1149196	0	0
45798781	1307863	0	0
46244441	1332419	2	3
45894340	1125315	0	0
46309318	1125315	0	0
4043022	4163951	4	4
433128	4084167	4	4
21002491	1115171	2	3
21013966	46233710	2	3
35508415	1174888	0	0
36157835	1124300	0	0
36152381	1125315	0	0
36500000	4142905	3	9
42806821	1118084	0	0
44356704	705944	0	0
42801810	1125315	0	0
44354225	1125315	0	0
45631797	1177480	0	0
44362262	967823	0	0
45632013	1125315	0	0
45629317	975125	0	0
45639308	1192710	0	0
44348267	1125315	0	0
45683873	1343916	0	0
45704433	967823	0	0
45642703	1713332	0	0
45672086	19127890	0	0
45782360	975125	0	0
45678097	19019273	2	3
45694183	1177480	0	0
45792798	1192710	0	0
46241344	19127890	0	0
45796679	1110410	0	0
45798474	1551099	0	0
45795866	1332419	2	3
45894511	1125315	0	0
46309342	1125315	0	0
4043022	4145310	4	4
4020346	4113008	4	4
21002808	1551192	2	3
21013966	46233988	2	3
35508458	1119510	0	0
36157837	1153428	0	0
36152179	1125315	0	0
36516972	78272	3	8
42806832	1115008	0	0
44356830	975125	0	0
42801810	1112807	0	0
44353844	1125315	0	0
45631778	1177480	0	0
44362186	1110410	0	0
45632016	1125315	0	0
45628274	975125	0	0
45639362	1107830	0	0
45651975	1125315	0	0
45683875	723013	0	0
45704631	1000560	0	0
45642703	1759842	0	0
45672086	1589505	0	0
45782368	1115008	0	0
45678079	40163554	2	3
45694153	1177480	0	0
45792799	1115008	0	0
46241344	1521369	0	0
45796694	975125	0	0
45798475	708298	0	0
46297938	19079524	2	3
45799644	1125315	0	0
46309344	1125315	0	0
4178818	133834	4	4
4020346	4155034	4	4
21002808	19019273	2	3
21003063	40232448	2	3
35508460	1119510	0	0
36157842	1112807	0	0
36152180	1125315	0	0
36516972	4066995	3	6
42806958	1177480	0	0
44356842	723013	0	0
42801810	1129625	0	0
44354144	1125315	0	0
45631902	1177480	0	0
44362194	791967	0	0
45632213	1125315	0	0
45626116	975125	0	0
45639335	1124957	0	0
45649324	1125315	0	0
45683891	1000560	0	0
45704635	1713332	0	0
45642758	757627	0	0
45672086	1549786	0	0
45782281	715997	0	0
45678352	35605482	2	3
45694038	1177480	0	0
45792811	1115008	0	0
46241344	1549786	0	0
45796727	1326303	0	0
45798481	1124300	0	0
45787572	1539411	2	3
45799648	1125315	0	0
46309461	1125315	0	0
4178818	198809	4	4
73553	81151	4	4
21002808	19019979	2	3
701322	45892894	2	3
35508461	1729720	0	0
36157715	1589505	0	0
36152328	1125315	0	0
36516972	4035415	3	6
42806972	1154343	0	0
44356994	1174888	0	0
42801785	1332418	0	0
44354145	1125315	0	0
45628705	1177480	0	0
44362213	791967	0	0
45632238	1125315	0	0
45626223	975125	0	0
45639260	1110410	0	0
45649327	1125315	0	0
45683859	19010482	0	0
45704578	1310149	0	0
45642770	19127890	0	0
45672088	1539403	0	0
45782464	1557272	0	0
45678243	40163554	2	3
45693852	1177480	0	0
45790027	1174888	0	0
46241347	1308738	0	0
45796809	1322184	0	0
45798592	1174888	0	0
46316298	19079524	1	1
45799932	1125315	0	0
46309183	1125315	0	0
4178818	4283893	4	4
432795	4296205	4	4
21002808	19059056	2	3
21500806	40163554	2	3
35508462	1177480	0	0
36157870	1115008	0	0
36152150	1125315	0	0
36516781	78272	2	6
42806973	1125315	0	0
44356998	1557272	0	0
42801816	1738521	0	0
44354235	1125315	0	0
45631175	1177480	0	0
44362216	1192710	0	0
45632240	1125315	0	0
45623110	975125	0	0
45639261	1192710	0	0
45649331	1125315	0	0
45683898	1107830	0	0
45704594	1309944	0	0
45642770	1549786	0	0
45671908	1107830	0	0
45782428	967823	0	0
45678393	40231925	2	3
45694135	1177480	0	0
45790027	1192710	0	0
46241348	1192710	0	0
45796547	1174888	0	0
45798889	975125	0	0
46311271	19079524	1	1
46317845	1125315	0	0
46309472	1125315	0	0
4178818	440448	4	4
432795	4299128	4	4
21002808	19078461	2	3
21002958	19129655	2	3
35508269	1112807	0	0
36157871	1119510	0	0
36152156	1125315	0	0
36503296	81151	2	6
42807077	1125315	0	0
44356768	1000560	0	0
42801819	920293	0	0
44354212	1125315	0	0
45631095	1177480	0	0
44362305	1361711	0	0
45634196	1125315	0	0
45623318	975125	0	0
45639002	1149196	0	0
45649348	1125315	0	0
45683901	1545958	0	0
45704595	19039298	0	0
45642829	1322184	0	0
45671780	1174888	0	0
45782374	1589505	0	0
45678235	40224805	2	3
45691035	1177480	0	0
45790036	1551099	0	0
46241489	1107830	0	0
45796601	1000560	0	0
45798894	975125	0	0
45876009	3009542	1	1
46318082	1125315	0	0
46309189	1125315	0	0
4027403	44805732	4	4
193460	4035415	4	4
21002808	1115171	2	3
21002912	1551192	2	3
35508270	1115008	0	0
36157772	1589505	0	0
36158271	1125315	0	0
36313967	4015189	2	6
42807077	1112807	0	0
44357095	1322184	0	0
42801821	1112807	0	0
44354249	1125315	0	0
45628936	1177480	0	0
44362307	701322	0	0
45634218	1125315	0	0
45621508	975125	0	0
45639364	1557272	0	0
45649408	1125315	0	0
45683844	1332418	0	0
45704761	1332418	0	0
45642812	1115008	0	0
45671784	975125	0	0
45782528	738818	0	0
45678242	1115171	2	3
45690983	1177480	0	0
45790037	19010482	0	0
46241372	1112807	0	0
45796664	1107830	0	0
45798898	1545958	0	0
45876009	3024731	1	1
46317603	1125315	0	0
46309192	1125315	0	0
4047779	378001	6	9
75909	4066995	4	4
21601119	964261	4	5
21002975	40243436	2	3
35508594	1125315	0	0
36157883	1177480	0	0
36158539	1125315	0	0
36503297	4149245	2	5
42807030	1125315	0	0
44357096	1713332	0	0
42801823	1154343	0	0
44354187	1125315	0	0
45626026	1177480	0	0
44362456	715997	0	0
45634228	1125315	0	0
45621768	975125	0	0
45639065	1192710	0	0
45649566	1125315	0	0
45683943	1149196	0	0
45704853	1539403	0	0
45642817	1115008	0	0
45671874	1149380	0	0
45782547	1326303	0	0
45678406	19059056	2	3
45690908	1177480	0	0
45790040	1115008	0	0
46241352	920293	0	0
45796634	1124300	0	0
45798597	1713332	0	0
45876009	3002385	1	1
46318162	1125315	0	0
46309366	1125315	0	0
4047779	313217	6	9
75909	4059173	4	4
21600279	46275916	4	5
21500523	19076374	2	3
35508596	738818	0	0
36157884	791967	0	0
36158612	1125315	0	0
36422731	1150771	2	3
42806854	1124957	0	0
44357006	1177480	0	0
42801993	1738521	0	0
44354196	1125315	0	0
45626097	1177480	0	0
44362333	738818	0	0
45629015	1125315	0	0
45621858	975125	0	0
45639070	1515774	0	0
45649574	1125315	0	0
45683939	1310149	0	0
45704445	1717327	0	0
45642859	1124957	0	0
45671874	1137529	0	0
45782551	1549786	0	0
45678341	1127433	2	3
45691155	1177480	0	0
45789986	975125	0	0
46241542	1000560	0	0
45796637	1548195	0	0
45798708	1343916	0	0
45876009	3010813	1	1
46317754	1125315	0	0
46303662	1125315	0	0
4047779	4230399	6	9
75909	4048695	4	4
21500562	45892894	4	5
35507421	19019273	2	3
35508602	1500211	0	0
36158055	1177480	0	0
36158602	1125315	0	0
36429173	1150837	2	3
42806854	1125315	0	0
44356885	1738521	0	0
42801959	1112807	0	0
44354207	1125315	0	0
45622696	1177480	0	0
44362457	1549786	0	0
45629132	1125315	0	0
45667289	975125	0	0
45639070	19127890	0	0
45649219	1125315	0	0
45683820	1000560	0	0
45704718	1539403	0	0
45642796	723013	0	0
45671878	1549786	0	0
45782551	19127890	0	0
45678428	40223834	2	3
45691312	1177480	0	0
45790129	1192710	0	0
46241432	1107830	0	0
45791253	967823	0	0
45799774	1343916	0	0
45876009	3026361	1	1
46318139	1125315	0	0
46303716	1125315	0	0
4047779	40479768	6	8
444089	198809	4	4
21500562	40223768	4	5
35507532	1107882	2	3
35508213	1129625	0	0
36157898	1107830	0	0
36158634	1125315	0	0
36427861	1551192	2	3
42806861	975125	0	0
44357009	1174888	0	0
42802001	1125315	0	0
44354279	1125315	0	0
45622673	1177480	0	0
44362559	1717327	0	0
45629136	1125315	0	0
45667425	975125	0	0
45639070	1549786	0	0
44343579	19128022	1	2
45683825	1115008	0	0
45704448	715997	0	0
45688706	1124957	0	0
45671878	1595799	0	0
45782562	1589505	0	0
45678428	40223821	2	3
45688151	1177480	0	0
45790130	975125	0	0
46241553	1118084	0	0
45791129	1501700	0	0
45799777	1549786	0	0
45876009	3007461	1	1
46317781	1125315	0	0
46303861	1125315	0	0
4047779	40479422	6	8
1361711	1361711	0	0
21500643	42707627	4	5
21002902	40173590	2	3
35508214	1119510	0	0
36158061	975125	0	0
36150709	1125315	0	0
36429128	46275444	2	3
42806942	1000560	0	0
44356875	723013	0	0
42802003	1118084	0	0
44352387	1125315	0	0
45622680	1177480	0	0
44362411	738818	0	0
45629197	1125315	0	0
45667450	975125	0	0
45639073	1548195	0	0
44343579	19128263	1	2
45683973	975125	0	0
45704551	1149196	0	0
45688471	1310149	0	0
45671878	1521369	0	0
45782565	738818	0	0
45678370	19008572	2	3
45688226	1177480	0	0
45790131	1192710	0	0
46241570	705944	0	0
45791119	1322184	0	0
45799777	1521369	0	0
45876009	3000963	1	1
46318249	1125315	0	0
46303865	1125315	0	0
4047779	133834	6	8
198809	198809	0	0
21600190	40243436	4	5
21003174	1150771	2	3
35508215	1125315	0	0
36158064	1112807	0	0
36150855	1125315	0	0
36426273	19057271	2	3
42806943	1000560	0	0
44357044	1107830	0	0
42802107	1551099	0	0
44352235	1125315	0	0
45622959	1177480	0	0
44362422	1174888	0	0
45629200	1125315	0	0
45667314	975125	0	0
45639080	1738521	0	0
44362457	19128009	1	2
45683975	1153428	0	0
45704643	705944	0	0
45688571	740275	0	0
45784050	1000560	0	0
45782505	1124300	0	0
45678418	40165015	2	3
45688379	1177480	0	0
45790048	1326303	0	0
46241451	1112807	0	0
45791221	1115008	0	0
45799809	1153428	0	0
45896736	1738521	0	0
46318096	1125315	0	0
46303929	1125315	0	0
4047779	196456	6	6
198199	198199	0	0
21500215	1332419	4	5
21003174	40232448	2	3
35508603	1738521	0	0
36157948	1177480	0	0
36150663	1125315	0	0
36427690	46275444	2	3
42806938	1738521	0	0
44357010	1778162	0	0
42802110	1177480	0	0
44352239	1125315	0	0
45622969	1177480	0	0
44362471	1308738	0	0
45629045	1125315	0	0
45662814	975125	0	0
45639083	1149196	0	0
45640662	46275916	1	1
45684071	19010482	0	0
45704816	1307863	0	0
45688660	1308738	0	0
45784051	1548195	0	0
45782509	708298	0	0
45674853	1127433	2	3
45684964	1177480	0	0
45790052	1112807	0	0
46241496	1107830	0	0
45791193	791967	0	0
45799709	1332418	0	0
45896739	1154343	0	0
46318168	1125315	0	0
46307067	1125315	0	0
4047779	441267	5	5
4010253	4010253	0	0
21500216	1310034	4	5
21013948	46233988	2	3
35508604	1119510	0	0
36158112	975125	0	0
36150844	1125315	0	0
36424954	1149380	0	0
42807080	742185	0	0
44357024	738818	0	0
42802110	1174888	0	0
44352352	1125315	0	0
45620878	1177480	0	0
44362496	1107830	0	0
45629161	1125315	0	0
45664648	975125	0	0
45639171	1595799	0	0
45637107	46275916	1	1
45683963	1549786	0	0
45704651	1307863	0	0
45691232	715997	0	0
45783789	723013	0	0
45782580	1192710	0	0
45674863	19059056	2	3
45685016	1177480	0	0
45790134	723013	0	0
46241512	1309944	0	0
45791073	1545958	0	0
45799850	1545958	0	0
45895584	1000560	0	0
46318210	1125315	0	0
46307005	1125315	0	0
4047779	192671	5	5
1595799	1595799	0	0
21500595	19019979	4	5
4042650	4252419	2	3
35508607	738818	0	0
36158115	1119510	0	0
36150845	1125315	0	0
36425092	757627	0	0
42807014	1125315	0	0
44356771	723013	0	0
42801966	1125315	0	0
44350269	1125315	0	0
45621125	1177480	0	0
44362584	738818	0	0
45629164	1125315	0	0
45656794	975125	0	0
45639171	1308738	0	0
45634639	46275916	1	1
45683963	1589505	0	0
45704825	1326303	0	0
45691234	1305058	0	0
45783885	1115008	0	0
45782649	1154029	0	0
45675210	1551192	2	3
45685101	1177480	0	0
45790056	708298	0	0
46241576	1112807	0	0
45791333	1557272	0	0
45799832	1332418	0	0
45895663	1322184	0	0
46318216	1125315	0	0
46306477	1125315	0	0
4047779	45769019	5	6
1594382	1594382	0	0
21500595	1115171	4	5
21501230	19079524	2	3
35508607	1119510	0	0
36158121	738818	0	0
36150935	1125315	0	0
36423756	1322184	0	0
42806951	1501700	0	0
44356955	1738521	0	0
42801935	1713332	0	0
44350257	1125315	0	0
45621386	1177480	0	0
44362594	1549786	0	0
45629205	1125315	0	0
45657205	975125	0	0
45639185	1110410	0	0
45628194	19127918	1	1
45680699	1589505	0	0
45704775	1174888	0	0
45691298	1000560	0	0
45783888	1124957	0	0
45782651	1589505	0	0
45675236	19008572	2	3
45685015	1177480	0	0
45790136	1539403	0	0
46241579	1595799	0	0
45791216	1322184	0	0
45799859	1124957	0	0
45895607	967823	0	0
46322544	1125315	0	0
46307073	1125315	0	0
4047779	4109685	5	6
1308738	1308738	0	0
21506173	40171902	4	4
1101544	40173590	2	3
35508611	1119510	0	0
36158121	1119510	0	0
36156431	1125315	0	0
36422341	1309944	0	0
42804384	1174888	0	0
44357132	1153428	0	0
42802079	1000560	0	0
44350342	1125315	0	0
45664833	1177480	0	0
44362478	1124300	0	0
45629192	1125315	0	0
45656890	975125	0	0
45639191	1174888	0	0
45620848	19074679	1	1
45680418	1149196	0	0
45704576	1115008	0	0
45691387	1107830	0	0
45783895	1729720	0	0
45782589	738818	0	0
45675005	19019273	2	3
45684995	1177480	0	0
45790138	1153428	0	0
46241650	1332418	0	0
45791156	1738521	0	0
45798973	1332418	0	0
45895573	1332418	0	0
46318325	1125315	0	0
46307077	1125315	0	0
4047779	4056621	5	6
1305058	1305058	0	0
21503082	914335	4	4
21002670	46233988	2	3
35508611	1125315	0	0
36157655	1177480	0	0
36156432	1125315	0	0
36422418	1713332	0	0
42804384	1125315	0	0
44350113	738818	0	0
42802081	975125	0	0
44350244	1125315	0	0
45664834	1177480	0	0
44362564	738818	0	0
45628973	1125315	0	0
45653776	975125	0	0
45639204	738818	0	0
45664228	19079524	1	1
45680762	1000560	0	0
45705097	1332418	0	0
45691389	933724	0	0
45783897	1309944	0	0
45782532	1551099	0	0
45675013	1127433	2	3
45685089	1177480	0	0
45789989	1545958	0	0
46241519	1322184	0	0
45791178	1192710	0	0
45798977	1501700	0	0
45895613	740275	0	0
45794374	1125315	0	0
46304054	1125315	0	0
4047779	4048171	5	9
967823	967823	0	0
21503082	967823	4	4
21002623	46275444	2	3
35508611	1192710	0	0
36158076	1119510	0	0
36155451	1125315	0	0
36422348	1332418	0	0
42804385	1125315	0	0
44350117	1112807	0	0
42801867	1124300	0	0
44350395	1125315	0	0
45664913	1177480	0	0
44362480	1713332	0	0
45628975	1125315	0	0
45653820	975125	0	0
45639339	1107830	0	0
45662205	19115351	1	1
45680872	723013	0	0
45704955	1149196	0	0
45691390	1551099	0	0
45784225	1746114	0	0
45782537	1551099	0	0
45675096	19018935	2	3
45685727	1177480	0	0
45790041	1545958	0	0
46241520	1112807	0	0
45791245	1174888	0	0
45799000	1115008	0	0
45895588	1308738	0	0
45794380	1125315	0	0
46304220	1125315	0	0
4047779	4146173	5	7
715997	715997	0	0
21503082	933724	4	4
21003027	46275916	2	3
35508625	738818	0	0
36158076	738818	0	0
36155565	1125315	0	0
36422432	1717327	0	0
42804385	1174888	0	0
44349758	1545958	0	0
42801873	1589505	0	0
44350336	1125315	0	0
45665083	1177480	0	0
44362366	1717327	0	0
45629092	1125315	0	0
45653637	975125	0	0
45638913	723013	0	0
45643657	19079524	1	1
45680741	1154029	0	0
45704878	1501700	0	0
45639745	1307863	0	0
45784225	1741122	0	0
45782544	1713332	0	0
45676423	1115171	2	3
45685885	1177480	0	0
45789916	1361711	0	0
46241600	1174888	0	0
45791249	1118084	0	0
45799056	1000560	0	0
45895639	738818	0	0
45794483	1125315	0	0
46304172	1125315	0	0
4047779	198809	5	7
723013	723013	0	0
21503082	920293	4	4
21003217	40232448	2	3
35508625	1125315	0	0
36158022	1124300	0	0
36155438	1125315	0	0
36503269	4142905	5	6
42804387	1125315	0	0
44349627	1332418	0	0
42801845	1149196	0	0
44350271	1125315	0	0
45665124	1177480	0	0
44362367	19127890	0	0
45629102	1125315	0	0
45653770	975125	0	0
45638979	1154343	0	0
45643372	19079524	1	1
45680526	1343916	0	0
45704882	1192710	0	0
45639634	1551099	0	0
45783954	791967	0	0
45782666	738818	0	0
45676429	40232448	2	3
45682152	1177480	0	0
45789905	1738521	0	0
46241603	975125	0	0
45791424	1551099	0	0
45799002	1149196	0	0
45895575	1149196	0	0
45794416	1125315	0	0
46304101	1125315	0	0
4047779	317576	5	7
723164	19115351	0	0
21500582	1177480	4	4
1101489	19007333	2	3
35508625	1119510	0	0
36158023	1119510	0	0
36155439	1125315	0	0
36516972	4059173	5	6
42804387	1174888	0	0
44349628	975125	0	0
42801873	1549786	0	0
44350249	1125315	0	0
45665057	1177480	0	0
44362367	1549786	0	0
45629049	1125315	0	0
45650232	975125	0	0
45638981	1332418	0	0
45634190	46275916	1	1
45680527	1713332	0	0
45704886	914335	0	0
45639919	1174888	0	0
45783958	1115008	0	0
45782383	1149196	0	0
45676376	1115171	2	3
45682269	1177480	0	0
45790150	1174888	0	0
46241604	1112807	0	0
45791320	1515774	0	0
45799037	920293	0	0
45895768	1343916	0	0
45794503	1125315	0	0
46304120	1125315	0	0
4047779	321042	5	7
260139	260139	0	0
21500582	1125315	4	4
21500819	19075601	2	3
35508555	1119510	0	0
36158023	1129625	0	0
36155440	1125315	0	0
36516772	4059173	5	6
42804421	40231925	2	3
44349635	1110410	0	0
42801877	975125	0	0
44350591	1125315	0	0
45665214	1177480	0	0
44362368	1738521	0	0
45629257	1125315	0	0
45650141	975125	0	0
45638983	1174888	0	0
45664746	46275916	1	1
45680529	1549786	0	0
45704888	19010482	0	0
45639695	1174888	0	0
45783905	1326303	0	0
45782238	1115008	0	0
45671925	1551192	2	3
45682332	1177480	0	0
45790155	1326303	0	0
46241606	1115008	0	0
45791320	1549786	0	0
45799041	1124300	0	0
45895725	1192710	0	0
45794399	1125315	0	0
46304187	1125315	0	0
4047779	4296204	5	7
261325	261325	0	0
21500541	1129625	4	4
21002901	40173590	2	3
35508555	1125315	0	0
36158029	1322184	0	0
36155398	1125315	0	0
36516772	4066995	5	6
42804242	19018935	2	3
44349801	791967	0	0
42801792	19127890	0	0
44350458	1125315	0	0
45665186	1177480	0	0
44362663	1149380	0	0
45629210	1125315	0	0
45650201	975125	0	0
45639355	1738521	0	0
45659077	46275916	1	1
45680529	1589505	0	0
45704562	1174888	0	0
45639670	1107830	0	0
45783971	1102527	0	0
45782419	975125	0	0
45671926	19008572	2	3
45682230	1177480	0	0
45790159	738818	0	0
46241673	1124957	0	0
45791202	1551099	0	0
45794629	740275	0	0
45895601	1332418	0	0
45794403	1125315	0	0
46304292	1125315	0	0
4047779	4059173	5	8
258780	258780	0	0
21500541	738818	4	4
1101553	40169216	2	3
35508630	1119510	0	0
36158176	1124300	0	0
36155400	1125315	0	0
36516772	4048695	5	6
42804303	19077344	2	3
44349803	1124300	0	0
42801792	1589505	0	0
44350698	1125315	0	0
45662584	1177480	0	0
44362534	19127890	0	0
45629268	1125315	0	0
45647289	975125	0	0
45639122	1557272	0	0
45643524	19079524	1	1
45680535	1154029	0	0
45704890	1154029	0	0
45639878	1154343	0	0
45783998	1115008	0	0
45782421	715997	0	0
45672097	19008572	2	3
45682237	1177480	0	0
45790160	738818	0	0
46241628	1322184	0	0
45791237	1521369	0	0
45794630	1778162	0	0
45895645	1124957	0	0
45794436	1125315	0	0
46304310	1125315	0	0
4047779	4278672	5	8
4012477	4012477	0	0
21500541	1125315	4	4
1101539	19019979	2	3
35508630	1125315	0	0
36157980	1557272	0	0
36155415	1125315	0	0
36516772	40479422	5	6
42804415	19133873	2	3
44349473	1361711	0	0
42801792	1549786	0	0
44350703	1125315	0	0
45662450	1177480	0	0
44362534	1549786	0	0
45629316	1125315	0	0
45647347	975125	0	0
45639241	1778162	0	0
45620907	46275916	1	1
45680356	967823	0	0
45704891	1192710	0	0
45639882	1738521	0	0
45784006	1110410	0	0
45782483	1192710	0	0
45672463	19008572	2	3
45678632	1177480	0	0
45789920	1102527	0	0
46238493	975125	0	0
45791360	791967	0	0
45793563	1153428	0	0
45895651	1107830	0	0
45794459	1125315	0	0
45794225	1107882	2	3
4047779	4048695	5	8
1307863	1307863	0	0
21500541	708298	4	4
1101539	1115171	2	3
35508513	1125315	0	0
36157982	1119510	0	0
36155443	1125315	0	0
36703500	378001	5	8
42804251	19077344	2	3
44349779	975125	0	0
42535580	42535580	0	0
44350492	1125315	0	0
45662410	1177480	0	0
44362534	1521369	0	0
45627888	1125315	0	0
45644457	975125	0	0
45639379	1717327	0	0
45637158	19079524	1	1
45680463	1107830	0	0
45704570	1174888	0	0
45639886	1548195	0	0
45783845	1545958	0	0
45782501	1539403	0	0
45672470	40169216	2	3
45678869	1177480	0	0
45790207	1322184	0	0
46238444	1545958	0	0
45791484	1521369	0	0
45793497	1110410	0	0
45895741	1107830	0	0
46312374	1125315	0	0
45799812	19078461	2	3
4047779	134438	4	6
1310034	1310034	0	0
21500541	791967	4	4
1101539	19019273	2	3
35508513	738818	0	0
36158165	1153428	0	0
36155353	1125315	0	0
36516972	4155034	5	5
42801688	40223834	2	3
44349781	1112807	0	0
42529093	3023103	1	1
44346388	1125315	0	0
45662692	1177480	0	0
44362669	1738521	0	0
45628275	1125315	0	0
45644446	975125	0	0
45639380	1500211	0	0
45664480	19079524	1	1
45680569	1149196	0	0
45704965	738818	0	0
45639997	1149196	0	0
45784300	1539403	0	0
45782490	791967	0	0
45672496	46275916	2	3
45678920	1177480	0	0
45789926	1174888	0	0
46238452	1741122	0	0
45791484	19127890	0	0
45793576	723013	0	0
45895742	791967	0	0
46312108	1125315	0	0
45802517	19078461	2	3
4047779	257012	4	7
1310149	1310149	0	0
21500648	1125315	4	4
1101539	19078461	2	3
35508513	1119510	0	0
36158236	1177480	0	0
36155356	1125315	0	0
36503290	40479422	5	5
42801655	40169216	2	3
44349794	738818	0	0
42529414	3051031	1	1
44346468	1125315	0	0
45662823	1177480	0	0
44362512	1115008	0	0
45628278	1125315	0	0
45641555	975125	0	0
45639252	1107830	0	0
45659018	19079524	1	1
45680658	1713332	0	0
45704893	1551099	0	0
45640009	1107830	0	0
45784000	975125	0	0
45782610	738818	0	0
45672592	40163554	2	3
45678952	1177480	0	0
45789810	738818	0	0
46238756	1112807	0	0
45791484	1549786	0	0
45793556	1310149	0	0
45895782	975125	0	0
46312304	1125315	0	0
45788704	1107882	2	3
4047779	4132546	4	7
1309944	1309944	0	0
21500648	1112807	4	4
1101498	1115171	2	3
35508515	1119510	0	0
36156508	738818	0	0
36155369	1125315	0	0
36503290	40479768	5	5
42801661	43012036	2	3
44349799	1153428	0	0
42529473	3049273	1	1
44346471	1125315	0	0
45662652	1177480	0	0
44362687	1589505	0	0
45626120	1125315	0	0
45641601	975125	0	0
45640143	1192710	0	0
45634139	46275916	1	1
45680658	1759842	0	0
45704655	1738521	0	0
45639846	708298	0	0
45784103	1115008	0	0
45782614	1551099	0	0
45784260	19074843	2	3
45706690	1129625	0	0
45789936	19127890	0	0
46238591	1367571	0	0
45791413	1713332	0	0
45793675	1332418	0	0
45895681	1557272	0	0
46312314	1125315	0	0
45795974	19078461	2	3
4047779	255848	4	7
975125	975125	0	0
21600959	1322184	4	4
1101498	19019273	2	3
35508564	1177480	0	0
36156508	1112807	0	0
36155370	1125315	0	0
36516993	4048171	5	5
42801819	920334	2	3
44349474	975125	0	0
42902167	42902245	1	1
44346140	1125315	0	0
45662563	1177480	0	0
44362687	1549786	0	0
45626196	1125315	0	0
45638248	975125	0	0
45640218	1343916	0	0
45662193	46275916	1	1
45680666	1367571	0	0
45704869	742185	0	0
45639892	1115008	0	0
45783928	1192710	0	0
45782623	1154343	0	0
45784262	40229134	2	3
45706866	1129625	0	0
45789936	1549786	0	0
46238543	1738521	0	0
45791413	1759842	0	0
45793612	1589505	0	0
45895685	1589505	0	0
46312241	1125315	0	0
46295431	1332419	2	3
4047779	28060	4	7
255848	255848	0	0
21600959	1595799	4	4
1101498	19019979	2	3
35508781	1125315	0	0
36156510	738818	0	0
36155371	1125315	0	0
36516993	4296204	4	5
42804111	19078924	2	3
44349475	1124957	0	0
42902242	42902245	1	1
44346648	1125315	0	0
45661232	1177480	0	0
44362791	1149196	0	0
45626200	1125315	0	0
45640224	975125	0	0
45640221	1738521	0	0
45662193	19079524	1	1
45680574	738818	0	0
45704870	738818	0	0
45639939	1539403	0	0
45783933	1154029	0	0
45782624	1000560	0	0
45784280	40229134	2	3
45705372	1129625	0	0
45790219	1112807	0	0
46238548	1149196	0	0
45791325	1149196	0	0
45793681	1149196	0	0
45895743	1713332	0	0
46312329	1125315	0	0
46244425	1107882	2	3
4047779	40481087	4	7
4024958	4024958	0	0
21503444	1125315	4	4
4030660	4242997	3	3
35508781	1119510	0	0
36156510	1119510	0	0
36155525	1125315	0	0
36302167	439777	4	5
42806182	43012036	2	3
44349646	1149196	0	0
42902243	42902245	1	1
44346749	1125315	0	0
45661538	1177480	0	0
44362482	967823	0	0
45626171	1125315	0	0
45638456	975125	0	0
45640219	1332418	0	0
45634034	19079524	1	1
45680575	1326303	0	0
45704798	1539403	0	0
45640035	1768849	0	0
45784063	1115008	0	0
45769019	45769019	0	0
45784341	1551192	2	3
45779955	1129625	0	0
45789814	1174888	0	0
46238826	1192710	0	0
45791166	1539403	0	0
45793779	1192710	0	0
45895743	1759842	0	0
46312444	1125315	0	0
45801884	1107882	2	3
4047779	80180	4	4
4015189	4015189	0	0
21503444	1595799	4	4
4133169	4330583	3	3
35508713	1125315	0	0
36156510	1112807	0	0
36155483	1125315	0	0
36516993	134438	4	4
42806129	1154615	2	3
44349483	1332418	0	0
42801873	19128009	2	2
44346575	1125315	0	0
45661457	1177480	0	0
44354914	975125	0	0
45626219	1125315	0	0
45638538	975125	0	0
45640176	1153428	0	0
45622385	19079524	1	1
45680579	738818	0	0
45704899	723013	0	0
45639727	738818	0	0
45784121	1713332	0	0
45702582	1192710	0	0
45784361	1115171	2	3
45779959	1129625	0	0
45790167	1501700	0	0
46238827	1192710	0	0
45791421	1192710	0	0
45793785	1557272	0	0
45801999	1738521	0	0
46312506	1125315	0	0
46241863	1107882	2	3
4047779	4051466	4	4
4166224	4166224	0	0
21503444	1308738	4	4
4133169	4117038	3	3
35508713	1119510	0	0
36156274	1107830	0	0
36155491	1125315	0	0
36703458	378419	4	4
42806260	19073188	2	3
44349975	1112807	0	0
42529086	3023103	2	2
44346533	1125315	0	0
45659352	1177480	0	0
44355002	740275	0	0
45626132	1125315	0	0
45635184	975125	0	0
45640244	1000560	0	0
45621246	19079524	1	1
45680868	1307863	0	0
45705006	1343916	0	0
45639827	705944	0	0
45784227	920293	0	0
45702588	19127890	0	0
45784480	19123231	2	3
45779870	1129625	0	0
45790175	1192710	0	0
46238830	1192710	0	0
45791423	933724	0	0
45793725	1759842	0	0
45801965	1102527	0	0
46312567	1125315	0	0
46297929	1107882	2	3
4047779	80809	4	5
4149245	4149245	0	0
21503444	1396131	4	4
4300244	4323902	3	3
35508273	1177480	0	0
36156512	1738521	0	0
36155507	1125315	0	0
36503290	4149245	4	4
42806262	19133905	2	3
44349977	1738521	0	0
42529086	3016723	2	2
44346764	1125315	0	0
45659395	1177480	0	0
44355007	1000560	0	0
45626137	1125315	0	0
45635608	975125	0	0
45635777	723013	0	0
45621246	46275916	1	1
45680779	1501700	0	0
45704970	738818	0	0
45640122	1713332	0	0
45784073	1309944	0	0
45702588	1512674	0	0
45784392	40162522	2	3
45780030	1129625	0	0
45790178	1124300	0	0
46238831	1192710	0	0
45791490	1738521	0	0
45793835	1309944	0	0
45801907	723013	0	0
46312600	1125315	0	0
46289431	1107882	2	3
4047779	80502	4	5
4180628	378001	6	8
21503444	967823	4	4
4176642	4246502	3	3
21602553	1521369	0	0
36154202	1174888	0	0
36155581	1125315	0	0
36302166	42535580	4	4
42806288	19018935	2	3
44349990	708298	0	0
42888893	196456	3	3
44346776	1125315	0	0
45659680	1177480	0	0
44355043	1124300	0	0
45626139	1125315	0	0
45632565	975125	0	0
45635780	1124300	0	0
45622175	19079524	1	1
45680427	1149196	0	0
45704971	1343916	0	0
45685910	740275	0	0
45784130	723013	0	0
45702588	1549786	0	0
45784457	40229134	2	3
45706104	1129625	0	0
45789990	1308738	0	0
46238565	1153428	0	0
45791435	1713332	0	0
45793832	1738521	0	0
45802021	705944	0	0
46312473	1125315	0	0
45790487	1332419	2	3
4047779	4116491	4	5
253549	4230399	6	7
21503444	1192710	4	4
141960	134438	3	3
21603992	1118084	0	0
36154202	1125315	0	0
36155637	1125315	0	0
36516728	4048695	4	4
42806345	40224805	2	3
44349993	1174888	0	0
42888894	4037675	5	5
44346782	1125315	0	0
45656432	1177480	0	0
44354751	1549786	0	0
45626262	1125315	0	0
45632627	975125	0	0
45635793	1115008	0	0
45628735	19079524	1	1
45680810	1115008	0	0
45704911	1322184	0	0
45685855	1149196	0	0
45784239	738818	0	0
45702570	1115008	0	0
45784435	1115171	2	3
45706356	1129625	0	0
45789992	738818	0	0
46238599	1332418	0	0
45791430	1713332	0	0
45793520	1153428	0	0
45802024	914335	0	0
46312829	1125315	0	0
45790668	40223768	2	3
4047779	40486433	4	8
4180628	4059173	6	7
21503146	753626	4	4
4034850	40478878	3	3
21604051	1124300	0	0
36154216	1177480	0	0
36155609	1125315	0	0
36516728	4059173	4	4
42806426	19133905	2	3
44349996	1515774	0	0
43530877	40479422	6	7
44346685	1125315	0	0
45656257	1177480	0	0
44354751	1589505	0	0
45626344	1125315	0	0
45632481	975125	0	0
45635794	1154343	0	0
45620864	19079524	1	1
45680816	975125	0	0
45705013	1124300	0	0
45685829	738818	0	0
45784240	1115008	0	0
45702633	1174888	0	0
45782211	40232448	2	3
45706296	1129625	0	0
45789995	1551099	0	0
46238603	19010482	0	0
45791430	1759842	0	0
45793637	967823	0	0
45802028	1149196	0	0
46312831	1125315	0	0
45801126	40223768	2	3
4047779	4149245	4	8
4101796	378001	6	6
21503146	1343916	4	4
4077953	4043071	3	3
21602848	1728416	0	0
36154234	1545958	0	0
36155749	1125315	0	0
36516728	4066995	4	4
42806320	40231925	2	3
44349996	1549786	0	0
40490903	4107731	5	5
44346617	1125315	0	0
45656611	1177480	0	0
44354755	914335	0	0
45626338	1125315	0	0
45632707	975125	0	0
45635850	1305058	0	0
45646249	19079524	1	1
45680821	1149196	0	0
45705018	738818	0	0
45685807	705944	0	0
45784234	1322184	0	0
45702644	1110410	0	0
45782335	19133873	2	3
45699742	1129625	0	0
45789996	1332418	0	0
46238604	1107830	0	0
45791438	967823	0	0
45793683	1124300	0	0
45802002	1153428	0	0
46306958	1125315	0	0
46242114	1107882	2	3
4047779	4294548	4	8
4086921	4324181	6	6
21503146	1154029	4	4
4172515	4035793	3	3
21602849	1728416	0	0
36154247	1000560	0	0
36102977	198199	1	3
36516728	4278672	4	4
42803988	40229134	2	3
44350007	1713332	0	0
43531052	4166224	5	6
44346665	1125315	0	0
45656538	1177480	0	0
44354711	1545958	0	0
45626305	1125315	0	0
45629387	975125	0	0
45635901	1310149	0	0
45643148	19079524	1	1
45680785	715997	0	0
45705026	791967	0	0
45685816	1310149	0	0
45784081	1107830	0	0
45702843	791967	0	0
45782221	43012036	2	3
45699917	1129625	0	0
45790022	1738521	0	0
46238667	1174888	0	0
45791564	1192710	0	0
45793640	1124300	0	0
45802013	1102527	0	0
46307109	1125315	0	0
45790359	40228214	2	3
4047779	260139	4	8
4086921	4163874	7	7
21503146	19039298	4	4
4300185	4337138	3	3
21602823	1713332	0	0
36154249	1125315	0	0
36110715	4112343	1	3
36516972	4146173	1	7
42804038	1551192	2	3
44349953	1000560	0	0
45655713	19079524	1	1
44346667	1125315	0	0
45656382	1177480	0	0
44355050	1115008	0	0
45626381	1125315	0	0
45629502	975125	0	0
45635907	738818	0	0
45628496	19079524	1	1
45680430	967823	0	0
45704912	791967	0	0
45685817	1551099	0	0
45784297	1322184	0	0
45702850	1107830	0	0
45782357	19008572	2	3
45699843	1129625	0	0
45790025	1501700	0	0
46238779	1107830	0	0
45791565	975125	0	0
45793690	1149196	0	0
45802018	1115008	0	0
46312038	1125315	0	0
45893834	19078461	2	3
4047779	440448	4	9
253549	78272	7	8
21503146	19002770	4	4
4042673	4057420	3	3
36009742	4102123	0	0
36154211	1177480	0	0
36110715	4294548	1	3
36228634	19045231	1	2
42803681	19018935	2	3
44350195	914335	0	0
45655713	46275916	1	1
44346713	1125315	0	0
45656647	1177480	0	0
44355079	1149196	0	0
45626312	1125315	0	0
45629503	975125	0	0
45636072	1153428	0	0
45625376	19079524	1	1
45680708	1305058	0	0
45704934	967823	0	0
45685876	740275	0	0
45783942	1149196	0	0
45702595	967823	0	0
45782368	1115171	2	3
45699851	1129625	0	0
45790118	19003953	0	0
46238782	723013	0	0
45791447	1717327	0	0
45793536	1738521	0	0
45802039	1115008	0	0
46312066	1125315	0	0
46242267	19075601	2	3
4047779	4112343	4	9
253549	4134304	7	8
21503146	708298	4	4
4185916	4047491	3	3
36009768	133834	0	0
36154250	1129625	0	0
36102977	4056621	3	3
36228635	19045231	1	2
42804049	40162522	2	3
44350196	1515774	0	0
45620644	19079524	1	1
44346715	1125315	0	0
45652927	1177480	0	0
44355017	1124300	0	0
45622799	1125315	0	0
45629585	975125	0	0
45636073	791967	0	0
45643249	19079524	1	1
45680553	1115008	0	0
45701268	738818	0	0
45685792	967823	0	0
45781904	723013	0	0
45702476	1000560	0	0
45782544	19073188	2	3
45693338	1129625	0	0
45790231	1154343	0	0
46238639	1501700	0	0
45791443	1149196	0	0
45793725	1713332	0	0
45801970	1367571	0	0
46307337	1125315	0	0
46291822	19078461	2	3
4047779	78272	4	10
255919	4048171	7	9
21503146	782043	4	4
4179871	45769019	3	3
36009735	134438	0	0
36154250	1125315	0	0
36110704	4048171	3	3
36230662	19074679	1	2
42804051	1551192	2	3
44350196	19127890	0	0
45655577	46275916	1	1
44346717	1125315	0	0
45653162	1177480	0	0
44355020	1124300	0	0
45622808	1125315	0	0
45631323	975125	0	0
45636004	1539403	0	0
45637536	19079524	1	1
45680713	1154343	0	0
45701270	1149380	0	0
45685959	1115008	0	0
45781883	1308738	0	0
45702608	1551099	0	0
45782509	19078924	2	3
45693460	1129625	0	0
45790095	1309944	0	0
46238651	967823	0	0
45791545	791967	0	0
45793618	1501700	0	0
45801909	1545958	0	0
46307154	1125315	0	0
45895785	19078461	2	3
4180628	317009	2	2
4028071	81893	8	9
21500223	1332418	4	4
21500594	19078461	5	6
36009691	439406	0	0
36154251	1326303	0	0
36110712	258780	3	3
36230663	19074679	1	2
42804058	19133905	2	3
44350196	1549786	0	0
45655577	19079524	1	1
44346518	1125315	0	0
45653416	1177480	0	0
44355081	715997	0	0
45622756	1125315	0	0
45631233	975125	0	0
45636101	1548195	0	0
45631399	19079524	1	1
45680729	1110410	0	0
45701144	1153428	0	0
45685941	1174888	0	0
45781941	1115008	0	0
45702744	1000560	0	0
45782537	1551192	2	3
45693726	1129625	0	0
45790087	1112807	0	0
46238615	1738521	0	0
45791500	1124957	0	0
45793630	975125	0	0
45802092	1000560	0	0
46307165	1125315	0	0
45804071	19075601	2	3
4180628	4066995	4	7
77960	40479422	5	5
21500223	1307863	4	4
21500594	19019273	5	6
36009700	317009	0	0
36154236	1545958	0	0
36110570	40481087	3	3
36230245	43012433	1	2
42805404	19073183	2	3
44349970	1177480	0	0
45655710	19079524	1	1
44346146	1125315	0	0
45653317	1177480	0	0
44355108	1149380	0	0
45622760	1125315	0	0
45626642	975125	0	0
45636101	1515774	0	0
44782620	4152936	4	4
45680731	1124957	0	0
45701163	791967	0	0
45685643	1713332	0	0
45781891	1154343	0	0
45702651	738818	0	0
45782238	1115171	2	3
45693728	1129625	0	0
45790003	1367571	0	0
46238619	705944	0	0
45791292	975125	0	0
45793641	1115008	0	0
45802049	975125	0	0
46307380	1125315	0	0
45893835	19078461	2	3
4180628	261325	4	7
77960	40479768	5	5
21506125	19074679	1	1
21500594	1115171	5	6
36211457	4296205	0	0
36154238	1129625	0	0
35702118	192671	3	3
36230246	43012433	1	2
42804107	1551192	2	3
44350162	1177480	0	0
45620721	19079524	1	1
44346830	1125315	0	0
45652950	1177480	0	0
44355109	1154343	0	0
45622910	1125315	0	0
45626727	975125	0	0
45636106	19010482	0	0
44782620	4035415	3	3
45680669	967823	0	0
45701272	738818	0	0
45685613	1174888	0	0
45781967	738818	0	0
45702652	738818	0	0
45782419	19008572	2	3
45693792	1129625	0	0
45790021	1124957	0	0
46238624	757627	0	0
46298711	1192710	0	0
45793642	1115008	0	0
45802050	1153428	0	0
46307219	1125315	0	0
45795943	19079524	2	3
4180628	4112343	4	8
432795	4218389	5	5
21003454	19127904	1	1
21500594	19019979	5	6
36211458	4299128	0	0
36154239	1129625	0	0
36212270	19074679	1	2
36232608	19132304	1	2
42801330	920300	2	3
44350168	1192710	0	0
45620545	19127918	1	1
44346820	1125315	0	0
45653452	1177480	0	0
44355113	1107830	0	0
45623138	1125315	0	0
45623534	975125	0	0
45636093	1326303	0	0
44782620	4059173	3	3
45680856	1124957	0	0
45701275	1154029	0	0
45686077	1000560	0	0
45781971	1110410	0	0
45702653	738818	0	0
45702528	40232448	2	3
45693797	1129625	0	0
45790106	1000560	0	0
46238750	1110410	0	0
46298597	1124300	0	0
45793650	1153428	0	0
45802065	1307863	0	0
46307226	1125315	0	0
45789181	40174880	2	3
4180628	78272	4	9
4021667	4230399	5	5
21003454	19132304	1	1
21503082	920334	6	7
36152830	1545958	0	0
36154240	1192710	0	0
36212774	40229134	1	2
36516728	80502	1	1
42801389	1551192	2	3
44350168	1112807	0	0
45620365	46275916	1	1
44346288	1125315	0	0
45649921	1177480	0	0
44355149	1548195	0	0
45623148	1125315	0	0
45623361	975125	0	0
45636126	1361711	0	0
44782620	4109685	3	3
45680672	1115008	0	0
45701250	1548195	0	0
45686080	1332418	0	0
45782117	19003953	0	0
45702691	1343916	0	0
45702589	1127433	2	3
45690632	1129625	0	0
45790188	738818	0	0
46238658	1149196	0	0
46298600	1000560	0	0
45793793	1000560	0	0
45801915	975125	0	0
46307235	1125315	0	0
45788721	19075601	2	3
1589505	19132304	2	3
4021667	4156265	5	5
21003454	19127918	1	1
21503082	920300	6	7
36152833	975125	0	0
36154240	1125315	0	0
36212775	40229134	1	2
36427424	1127433	2	3
43053690	4142905	2	3
44349485	1112807	0	0
45620543	46275916	1	1
44346299	1125315	0	0
45649621	1177480	0	0
44355154	1110410	0	0
45623153	1125315	0	0
45623569	975125	0	0
45636097	1174888	0	0
44782620	81151	3	4
45680674	1000560	0	0
45701129	1713332	0	0
45685619	738818	0	0
45781925	1118084	0	0
45702543	1174888	0	0
45702472	40232448	2	3
45690678	1129625	0	0
45787360	1149380	0	0
46238788	1738521	0	0
46298265	1539403	0	0
45793762	1539403	0	0
45802100	1501700	0	0
46307417	1125315	0	0
46295242	19075601	2	3
1500211	40224132	2	3
441840	4116491	6	8
21003454	19128065	1	1
21503082	40236824	6	7
36152772	1177480	0	0
36154241	1125315	0	0
36220586	40169281	1	2
36427424	40231925	2	3
43053690	40480160	2	3
44350206	1332418	0	0
44347714	40220386	1	1
44346790	1125315	0	0
45649758	1177480	0	0
44355164	705944	0	0
45622880	1125315	0	0
45667941	975125	0	0
45636223	1551099	0	0
44782620	40479768	5	5
45682498	1124957	0	0
45701208	1174888	0	0
45686089	1124300	0	0
45781929	967823	0	0
45702546	738818	0	0
45702608	1551192	2	3
45690659	1129625	0	0
45787360	1137529	0	0
46238818	975125	0	0
46298741	1343916	0	0
45793839	1149196	0	0
45802103	19039298	0	0
46307974	1125315	0	0
45893837	19078461	2	3
1500211	40224805	2	3
441840	4146173	6	10
21003454	19128009	1	1
21503146	19078924	6	7
36152895	1177480	0	0
36154241	1112807	0	0
36221037	19132304	1	2
36427424	40229134	2	3
42806227	1154615	2	3
44349882	1115008	0	0
44347911	19129144	1	1
44346792	1125315	0	0
45649962	1177480	0	0
44354976	738818	0	0
45623190	1125315	0	0
45665476	975125	0	0
45636145	1551099	0	0
44782620	40479422	5	5
45682455	1149196	0	0
45701214	1107830	0	0
45686174	740275	0	0
45782076	1549786	0	0
45702548	1192710	0	0
45702651	40229134	2	3
45690704	1129625	0	0
45787436	738818	0	0
46240079	1115008	0	0
46298529	1500211	0	0
45793657	708298	0	0
45801973	1107830	0	0
46307593	1125315	0	0
45801852	19078461	2	3
1361711	19126352	2	3
441840	4001336	6	10
21003454	19127922	1	1
21503146	782047	6	7
36153082	1125315	0	0
36154242	1119510	0	0
36221037	46221626	1	2
36427424	40162522	2	3
42806380	1115171	2	3
44349896	1124300	0	0
44347911	19127922	1	1
44346601	1125315	0	0
45651888	1177480	0	0
44355138	738818	0	0
45623090	1125315	0	0
45665711	975125	0	0
45644673	40228214	2	3
44783379	4301346	3	4
45682544	1713332	0	0
45701219	1713332	0	0
45686201	1153428	0	0
45782076	1518198	0	0
45702852	1174888	0	0
45702660	19019273	2	3
45690884	1129625	0	0
45787441	1112807	0	0
46240157	975125	0	0
46298416	1118084	0	0
45793798	1309944	0	0
45802056	1545958	0	0
46307545	1125315	0	0
45897887	19079524	2	3
1107830	1107882	2	3
441840	81151	6	11
21003454	19128263	1	1
21500582	40162522	6	7
36153148	975125	0	0
36154242	1125315	0	0
36223222	19123231	1	2
36427424	19133768	2	3
42801515	920334	2	3
44350088	738818	0	0
44347911	19133679	1	1
44346608	1125315	0	0
45646852	1177480	0	0
44355091	1322184	0	0
45623019	1125315	0	0
45665520	975125	0	0
45663443	40228214	2	3
45622194	19128009	3	4
45682560	1326303	0	0
45701219	1759842	0	0
45637423	1174888	0	0
45781946	1174888	0	0
45702853	1396131	0	0
45702941	40162522	2	3
45690955	1129625	0	0
45787441	1192710	0	0
46240158	1115008	0	0
46298601	1309944	0	0
45793799	1115008	0	0
45801919	738818	0	0
46307312	1125315	0	0
46297643	19079524	2	3
1107830	19125062	2	3
441840	258780	6	11
21003454	43012433	1	1
21500574	19019273	6	7
36153037	1112807	0	0
36154233	1545958	0	0
36223223	19123231	1	2
36427424	1127078	2	3
42806225	40236446	2	3
44349498	1149380	0	0
44348134	19074679	1	1
44348442	1125315	0	0
45646891	1177480	0	0
44354937	1107830	0	0
45623037	1125315	0	0
45665875	975125	0	0
45647507	19078461	2	3
45620913	19128022	3	4
45680883	1759842	0	0
45701221	791967	0	0
45637226	1149196	0	0
45781990	1738521	0	0
45702725	1343916	0	0
45702922	40163554	2	3
45687759	1129625	0	0
45787443	1112807	0	0
46240163	1000560	0	0
46298488	1174888	0	0
45793803	1738521	0	0
45801922	975125	0	0
46307523	1125315	0	0
46317471	19018935	2	3
701322	40222846	2	3
441840	4230399	6	11
21003454	40221415	1	1
21502709	40169216	9	10
36153265	975125	0	0
36154338	1738521	0	0
36223455	1551192	1	2
36422418	19073188	2	3
42806596	19019273	2	3
44350066	1192710	0	0
45661980	46275916	1	1
44348446	1125315	0	0
45647082	1177480	0	0
44354940	738818	0	0
45623103	1125315	0	0
45659836	975125	0	0
45648066	19078461	2	3
45664748	19127918	3	4
45680905	1154029	0	0
45701166	1539403	0	0
45637234	1115008	0	0
45781992	975125	0	0
45702696	1174888	0	0
45702755	40232448	2	3
45687734	1129625	0	0
45787475	738818	0	0
46240036	1000560	0	0
46298488	1192710	0	0
45793581	967823	0	0
45801976	1115008	0	0
46307204	1125315	0	0
46317726	40236824	2	3
1396131	19077344	2	3
441840	4296204	6	9
21003454	42902245	1	1
21502709	19112599	9	10
36153330	1125315	0	0
36154305	1125315	0	0
36221044	40236446	1	2
36422418	1713671	2	3
42806471	19019273	2	3
44350071	1192710	0	0
45661813	46275916	1	1
44348381	1125315	0	0
45647141	1177480	0	0
44354949	738818	0	0
45623232	1125315	0	0
45659982	975125	0	0
45651063	19078461	2	3
45662172	19127922	3	4
45680887	1738521	0	0
45701358	967823	0	0
45637237	920293	0	0
45782121	738818	0	0
45702558	1192710	0	0
45702902	19019273	2	3
45688505	1129625	0	0
45787477	1343916	0	0
45897591	1501700	0	0
46298494	1154343	0	0
45793819	1308738	0	0
45802093	723013	0	0
46307210	1125315	0	0
46319831	1551192	2	3
1115008	1115171	2	3
441840	4306014	6	7
21003454	19133679	1	1
21502709	40223821	9	10
36152839	1119510	0	0
36154366	1149196	0	0
36220458	19077572	1	2
36422348	1332419	2	3
42806134	19019273	2	3
44350077	1177480	0	0
45658006	40220386	1	1
44348382	1125315	0	0
45647179	1177480	0	0
44355051	738818	0	0
45625063	1125315	0	0
45660004	975125	0	0
45641956	19078461	2	3
44784102	195588	3	3
45677361	708298	0	0
45701361	1713332	0	0
45637300	1153428	0	0
45781948	1551099	0	0
45702659	1738521	0	0
45702908	1545959	2	3
45684544	1129625	0	0
45787244	1548195	0	0
45897693	1551099	0	0
46298723	1107830	0	0
45793761	1557272	0	0
45802059	1115008	0	0
46307802	1125315	0	0
46319409	19019273	2	3
1115008	19019273	2	3
441840	439406	6	7
21003454	19128022	1	1
21502709	40232448	9	10
36153428	1112807	0	0
36154259	1177480	0	0
36219948	19077344	1	2
36428377	1154615	2	3
42801396	1551192	2	3
44350095	1112807	0	0
45655823	1127433	1	1
44342672	1125315	0	0
45646890	1177480	0	0
44355180	1738521	0	0
45624908	1125315	0	0
45660142	975125	0	0
45624105	19078461	2	3
44783028	4146173	3	3
45677232	1501700	0	0
45701365	1192710	0	0
45637333	1308738	0	0
45782095	1549786	0	0
45702660	1115008	0	0
45696704	19018935	2	3
45684670	1129625	0	0
45787244	1589505	0	0
45897787	1149380	0	0
46298603	1361711	0	0
45793588	975125	0	0
45801984	1115008	0	0
46307804	1125315	0	0
45895578	1127433	2	3
708298	19078924	2	3
441840	4285898	5	12
21003454	19129144	1	1
21502709	1343916	7	7
36152839	1125315	0	0
36154261	1118084	0	0
36220457	19077572	1	2
36423716	1713671	2	3
42804080	19075001	2	3
44350097	920293	0	0
45649227	46275916	1	1
44342766	1125315	0	0
45644062	1177480	0	0
44355183	1107830	0	0
45625112	1125315	0	0
45659741	975125	0	0
45657582	19078461	2	3
44783378	4301346	3	3
45677354	1310149	0	0
45701379	1501700	0	0
45636684	1115008	0	0
45782095	19127890	0	0
45702790	1192710	0	0
45696779	40174880	2	3
45684672	1129625	0	0
45787256	738818	0	0
45897870	1192710	0	0
46298941	1551099	0	0
45793669	1174888	0	0
45802072	1153428	0	0
46307681	1125315	0	0
45895645	40231925	2	3
1580955	40223768	2	3
3049150	3036780	2	2
21003454	46221626	1	1
21502709	738818	7	7
36153096	1125315	0	0
36154284	1551099	0	0
36220587	40169216	1	2
36424953	40169281	2	3
42806332	1551192	2	3
44350127	738818	0	0
45661643	19079524	1	1
44342777	1125315	0	0
45643952	1177480	0	0
44354970	1545958	0	0
45625018	1125315	0	0
45649377	1192710	0	0
45644825	19078461	2	3
44782619	4230399	3	3
45677390	738818	0	0
45701230	1124300	0	0
45636693	1107830	0	0
45782095	1512674	0	0
45702941	1174888	0	0
45696780	19008572	2	3
45684588	1129625	0	0
45787257	1107830	0	0
45897873	1738521	0	0
46298902	933724	0	0
45788431	1738521	0	0
45802125	1118084	0	0
46307367	1125315	0	0
45895741	1107882	2	3
914335	40243436	2	3
3049150	3023430	2	2
21002475	19128009	1	1
21502709	1150770	7	7
36153096	1119510	0	0
36154293	1124957	0	0
36223225	1545959	1	2
36424953	40169216	2	3
42804295	19019273	2	3
44349832	933724	0	0
45649244	19079524	1	1
44342760	1125315	0	0
45644041	1177480	0	0
44355055	975125	0	0
45623280	1125315	0	0
45649348	1192710	0	0
45644383	19078461	2	3
44782503	4301346	3	3
45677492	1115008	0	0
45701292	1124957	0	0
45636777	1545958	0	0
45781919	1192710	0	0
45702954	1548195	0	0
45672469	19019273	2	3
45684612	1129625	0	0
45787373	1149196	0	0
45897686	1310149	0	0
46298586	1310149	0	0
45788233	1000560	0	0
45802252	1192710	0	0
46302204	1125315	0	0
45876029	3005136	2	3
1129625	40232448	2	3
3049209	3023430	2	2
21002475	42902245	1	1
21502709	1125443	7	7
36153335	1177480	0	0
36154294	1551099	0	0
36223224	1545959	1	2
36424954	40169216	2	3
42804522	19019273	2	3
44349839	1174888	0	0
44345811	46275916	1	1
44342762	1125315	0	0
45644121	1177480	0	0
45655591	708298	0	0
45621487	1125315	0	0
45649300	1192710	0	0
45639138	19078461	2	3
45651648	19127918	2	2
45677651	1124300	0	0
45701293	1107830	0	0
45636717	715997	0	0
45782045	1149380	0	0
45702958	1501700	0	0
45784027	46233710	2	3
45684601	1129625	0	0
45787380	967823	0	0
45897778	1713332	0	0
46298593	975125	0	0
45788547	975125	0	0
45802083	705944	0	0
46302376	1125315	0	0
45876029	3036780	2	3
1192710	43012036	2	3
3049209	3005136	2	2
21001669	1551192	2	3
21502709	1107830	7	7
36153336	1115008	0	0
36154295	1551099	0	0
36214108	19019979	1	2
36424954	40169281	2	3
42807080	19123231	2	3
44349852	1112807	0	0
44345863	46275916	1	1
44342788	1125315	0	0
45644145	1177480	0	0
45655496	1501700	0	0
45621511	1125315	0	0
45649453	1192710	0	0
45668005	19078461	2	3
45651648	19128009	2	2
45677657	914335	0	0
45701177	1713332	0	0
45636721	1501700	0	0
45782122	1322184	0	0
45702960	1501700	0	0
45680007	19078924	2	3
45681727	1129625	0	0
45787196	738818	0	0
45897716	1110410	0	0
46299300	1000560	0	0
45788186	975125	0	0
45802085	1124300	0	0
46302151	1125315	0	0
45876029	3023430	2	3
1713332	1713671	2	3
3049209	3036780	2	2
21002326	1713671	2	3
21502709	967823	7	7
36153337	1125315	0	0
36154288	1154343	0	0
36214108	19078461	1	2
36426127	40174880	2	3
42804313	19019273	2	3
44350009	1177480	0	0
43530876	4329847	1	1
44343084	1125315	0	0
45644192	1177480	0	0
45655537	975125	0	0
45629763	43012036	2	3
45632050	1192710	0	0
45629789	19078461	2	3
45624185	19128022	2	2
45677408	1307863	0	0
45701177	1759842	0	0
45636757	1738521	0	0
45782065	1174888	0	0
45702813	738818	0	0
45672259	46233988	2	3
45681844	1129625	0	0
45787197	1154343	0	0
45897837	1332418	0	0
46298946	1343916	0	0
45788553	705944	0	0
45802088	723013	0	0
46301861	1125315	0	0
45876033	3015632	2	3
1713332	19073183	2	3
3049219	3036780	2	2
21002731	46233988	2	3
21502709	1137529	7	7
36153337	1119510	0	0
36154304	1149196	0	0
36214107	19019979	1	2
36428442	1539411	2	3
42803971	1545959	2	3
44350190	1501700	0	0
44786912	3023103	1	1
44342925	1125315	0	0
45644096	1177480	0	0
45655137	1539403	0	0
45629739	19133905	2	3
45632255	1192710	0	0
45657322	19078461	2	3
45639424	19128022	2	2
45677428	1153428	0	0
45701181	1501700	0	0
45636758	1124300	0	0
45782071	1521369	0	0
45702920	1539403	0	0
45672259	46233710	2	3
45681790	1129625	0	0
45787269	738818	0	0
45897665	1192710	0	0
46298948	1551099	0	0
45788357	1738521	0	0
45802152	738818	0	0
46302300	1125315	0	0
45876033	3023103	2	3
1110410	35605858	2	3
3050400	3005136	2	2
21002731	46233710	2	3
21500120	1512674	7	7
36153338	1589505	0	0
36154402	791967	0	0
36214107	19078461	1	2
36422432	19129655	2	3
42804110	1545959	2	3
44350146	1177480	0	0
44786936	3051031	1	1
44342931	1125315	0	0
45644227	1177480	0	0
45655588	933724	0	0
45629739	19133873	2	3
45632125	1192710	0	0
45657391	19078461	2	3
45634966	40174880	2	3
45677496	1307863	0	0
45701184	1107830	0	0
45636773	1000560	0	0
45782099	1149196	0	0
45702922	1310149	0	0
45672298	19078461	2	3
45681973	1129625	0	0
45787533	1107830	0	0
45897781	1332418	0	0
46298769	1149196	0	0
45788401	1107830	0	0
45802062	1545958	0	0
46302389	1125315	0	0
45876033	3014576	2	3
1112807	19059056	2	3
3050400	3036780	2	2
21003385	1551192	2	3
21502620	19133873	7	8
36153339	1112807	0	0
36154341	1125315	0	0
36110229	433125	0	1
36426182	19132304	2	3
42804254	1545959	2	3
44350148	1112807	0	0
44816088	44816277	1	1
44343091	1125315	0	0
45641011	1177480	0	0
45655217	1149196	0	0
45629775	19019273	2	3
45631870	1192710	0	0
45635578	19078461	2	3
45635001	1115171	2	3
45677506	1000560	0	0
45703455	1501700	0	0
45636821	791967	0	0
45782056	1174888	0	0
45702931	967823	0	0
45699371	19075001	2	3
45681950	1129625	0	0
45787535	742185	0	0
45897864	1174888	0	0
46298783	1501700	0	0
45788312	1124957	0	0
45802165	1545958	0	0
46302395	1125315	0	0
45876033	3027970	2	3
1119510	40229134	2	3
3050400	3023430	2	2
21003393	1551192	2	3
21502620	19073188	7	8
36153600	1112807	0	0
36154342	933724	0	0
36110584	260139	0	1
36426182	46221626	2	3
42801993	46233988	2	3
44350150	1124957	0	0
44361161	40171902	1	1
44343011	1125315	0	0
45641148	1177480	0	0
45655144	1595799	0	0
45629915	19019273	2	3
45632002	1192710	0	0
45633031	19078461	2	3
45634986	19075601	2	3
45677446	1501700	0	0
45703461	1000560	0	0
45636826	723013	0	0
45782061	967823	0	0
45702756	967823	0	0
45696027	40228214	2	3
45678521	1129625	0	0
45787482	1149196	0	0
45897864	1192710	0	0
46299006	1545958	0	0
45788302	1154029	0	0
45802168	1154029	0	0
46302433	1125315	0	0
45802381	19078461	2	3
1125315	1127433	2	3
3050409	3005136	2	2
21001833	46233988	2	3
21503160	1129625	6	6
36153602	1129625	0	0
36154344	1129625	0	0
36102977	195588	1	1
36426182	43012754	2	3
42801993	46233710	2	3
44349678	1332418	0	0
44786889	3016723	2	2
44343292	1125315	0	0
45641210	1177480	0	0
45655144	1308738	0	0
45629770	19133768	2	3
45632233	1192710	0	0
45629766	19078461	2	3
45635004	19019273	2	3
45677434	1545958	0	0
45703632	1149196	0	0
45636865	723013	0	0
45781997	705944	0	0
45702763	1149380	0	0
45687750	40223768	2	3
45678545	1129625	0	0
45787541	967823	0	0
45897723	1107830	0	0
46298556	1729720	0	0
45788305	1107830	0	0
45802261	1551099	0	0
46302464	1125315	0	0
45801999	46233710	2	3
1125315	19133768	2	3
3050409	3036780	2	2
21001833	46233710	2	3
21503160	1119510	6	6
36153197	1192710	0	0
35604747	40224805	0	0
36110229	28060	1	1
36426182	1718412	2	3
42806938	46233710	2	3
44349866	1738521	0	0
43530807	4174876	2	2
44343098	1125315	0	0
45641165	1177480	0	0
45655146	1149380	0	0
45626918	40232448	2	3
45634228	1192710	0	0
45650927	19078461	2	3
45635042	40163554	2	3
45677532	1107830	0	0
45703721	1515774	0	0
45636787	738818	0	0
45782142	1174888	0	0
45702764	967823	0	0
45784382	19075001	2	3
45672619	1129625	0	0
45787542	1501700	0	0
45897732	1551099	0	0
46298561	967823	0	0
45788383	1713332	0	0
45802251	1501700	0	0
46302487	1125315	0	0
45802024	40243436	2	3
1125315	40231925	2	3
3050409	3023430	2	2
21001820	46233710	2	3
21503160	1115008	6	6
36153197	1112807	0	0
35605482	35605482	0	0
36110265	28060	1	1
36425092	19077572	2	3
42801381	40223768	2	3
44349871	1118084	0	0
44359965	19128009	2	2
44343190	1125315	0	0
45641267	1177480	0	0
45655266	1149196	0	0
45626921	19018935	2	3
45629320	1192710	0	0
45663871	19078461	2	3
45635286	40228214	2	3
45677417	1174888	0	0
45703721	1549786	0	0
45636958	1307863	0	0
45782108	1118084	0	0
45702902	1115008	0	0
45672227	40223768	2	3
45672421	1129625	0	0
45787278	1307863	0	0
45897738	1500211	0	0
46298876	1713332	0	0
45788392	1174888	0	0
45802213	738818	0	0
46306891	1125315	0	0
45802059	1115171	2	3
1125315	40229134	2	3
3050415	3023430	2	2
21001820	46233988	2	3
21503160	1177480	6	6
36153198	1112807	0	0
35605483	35605482	0	0
35702780	4027663	1	1
36423756	19075601	2	3
42801554	19075001	2	3
44350041	1545958	0	0
44338512	19128009	2	2
44343203	1125315	0	0
45642908	1177480	0	0
45655326	1557272	0	0
45626841	43012036	2	3
45628002	1192710	0	0
45653851	19078461	2	3
45635376	40232448	2	3
45677645	1107830	0	0
45703721	19127890	0	0
45636827	1124957	0	0
45782128	1778162	0	0
45702906	19127890	0	0
45684241	1107882	2	3
45673404	1129625	0	0
45787205	1515774	0	0
45897745	1548195	0	0
46298879	1115008	0	0
45788557	1713332	0	0
45802271	1549786	0	0
46306832	1125315	0	0
45802013	40165015	2	3
1125315	40162522	2	3
3050415	3005136	2	2
21002745	40228230	2	3
21503160	1112807	6	6
36153200	1129625	0	0
35605858	35605858	0	0
36110736	4116491	1	1
36422341	1310034	2	3
42806474	19073183	2	3
44342344	1177480	0	0
44338512	19127918	2	2
44343287	1125315	0	0
45641363	1177480	0	0
45655272	1124957	0	0
45628216	19076374	2	3
45628275	1192710	0	0
45642093	19078461	2	3
45635345	19078461	2	3
45677649	1521369	0	0
45703722	1154343	0	0
45636964	740275	0	0
45782129	1115008	0	0
45702906	1548195	0	0
45702242	1127433	2	3
45672720	1129625	0	0
45787275	1545958	0	0
45897719	1713332	0	0
46299032	1549786	0	0
45788557	1759842	0	0
45802271	1589505	0	0
46306841	1125315	0	0
45802018	1115171	2	3
1125315	1127078	2	3
3050415	3036780	2	2
21002745	1150771	2	3
21503160	738818	6	6
36153228	1129625	0	0
35605859	35605858	0	0
36110687	4294548	1	1
36424218	19076374	2	3
42806558	40223768	2	3
44342347	1332418	0	0
43530877	4329847	2	2
44343173	1125315	0	0
45641351	1177480	0	0
44347889	1118084	0	0
45627041	19078924	2	3
45626345	1192710	0	0
45626769	19078461	2	3
45629899	1115171	2	3
45677447	1149196	0	0
45703726	1515774	0	0
45636969	723013	0	0
45782232	1713332	0	0
45702906	19054876	0	0
45702242	19078461	2	3
45672856	1129625	0	0
45696796	1177480	0	0
45897833	1118084	0	0
46299032	1521369	0	0
45788439	1545958	0	0
45802335	738818	0	0
46306850	1125315	0	0
45801909	1545959	2	3
3039467	3023103	1	3
3050420	3023430	2	2
21002745	19112599	2	3
21503160	1125315	6	6
36153595	1153428	0	0
36002139	4048695	6	7
36110708	257012	1	1
36516993	4310024	2	4
42803048	19073183	2	3
44342203	975125	0	0
43530877	381316	2	2
44343216	1125315	0	0
45637902	1177480	0	0
44347843	933724	0	0
45627083	19075001	2	3
45622983	1192710	0	0
45641968	19078461	2	3
45629903	1127433	2	3
45677585	1539403	0	0
45703726	1549786	0	0
45637104	1332418	0	0
45782232	1759842	0	0
45702908	1545958	0	0
45696023	1127433	2	3
45672731	1129625	0	0
45696383	1177480	0	0
45897836	1539403	0	0
46299041	1192710	0	0
45788439	1332418	0	0
45802338	1115008	0	0
46306311	1125315	0	0
45802103	19023398	2	3
442013	4296204	2	2
3050420	3036780	2	2
21002745	40223821	2	3
21503160	1150836	6	6
36153433	1125315	0	0
35500000	4144583	5	7
36110708	40481087	1	1
36516728	40480160	2	4
42801337	1107882	2	3
44342466	1149380	0	0
44360439	19128022	1	2
44343020	1125315	0	0
45638017	1177480	0	0
44347856	791967	0	0
45623716	1115171	2	3
45621462	1192710	0	0
45660369	40174880	2	3
45630127	1115171	2	3
45677695	1174888	0	0
45701508	1107830	0	0
45637005	1115008	0	0
45782201	975125	0	0
45703039	967823	0	0
45696023	19078461	2	3
45672845	1129625	0	0
45696887	1177480	0	0
45897874	1192710	0	0
46299044	1545958	0	0
45788440	1192710	0	0
45799429	1115008	0	0
46306256	1125315	0	0
45801919	40229134	2	3
4008565	440086	2	2
3050420	3005136	2	2
21002745	1107882	2	3
21503160	1149196	6	6
36153436	1112807	0	0
21604180	19078924	4	7
36111049	4112343	1	1
36503288	4146173	2	8
42805289	40223768	2	3
44342468	1174888	0	0
44360439	19128263	1	2
44339412	1125315	0	0
45637941	1177480	0	0
44347860	1521369	0	0
45623924	40163554	2	3
45621738	1192710	0	0
45644478	1539411	2	3
45629868	1127433	2	3
45677700	738818	0	0
45701544	1149196	0	0
45637011	1107830	0	0
45782204	1551099	0	0
45702912	1192710	0	0
45705409	19079524	2	3
45784682	1129625	0	0
45696750	1177480	0	0
45897905	1713332	0	0
46299134	1713332	0	0
45788565	975125	0	0
45799185	1000560	0	0
46306776	1125315	0	0
45801976	1115171	2	3
4006969	4112343	2	2
3050426	3023430	2	2
21002745	40232448	2	3
21503160	40229134	8	9
36153436	1192710	0	0
21604180	836659	4	7
36111056	40481087	1	1
36503295	4035415	2	2
42806546	1107882	2	3
44342479	791967	0	0
44361043	19127904	1	2
44339602	1125315	0	0
45637827	1177480	0	0
44347860	1549786	0	0
45623943	40232448	2	3
45621530	1192710	0	0
45663839	19079524	2	3
45629994	19008572	2	3
45677709	1115008	0	0
45701551	1115008	0	0
45636894	1539403	0	0
45782460	1154029	0	0
45696720	1539403	0	0
45779864	19075601	2	3
45784550	1129625	0	0
45696831	1177480	0	0
45897896	1112807	0	0
46299219	1713332	0	0
45788188	1000560	0	0
45799499	1367571	0	0
46306899	1125315	0	0
45801984	1115171	2	3
4006969	260139	2	2
3050426	3005136	2	2
21002745	1150837	2	3
21502550	40243436	6	7
36153439	1125315	0	0
21603248	40169281	4	6
36313965	4181917	3	3
36603352	40480160	2	2
42806680	1107882	2	3
44342524	1539403	0	0
44337968	43012036	2	3
44339606	1125315	0	0
45638161	1177480	0	0
44347895	1192710	0	0
45623806	19075001	2	3
45621862	1192710	0	0
45623956	1332419	2	3
45630108	46275444	2	3
45677474	975125	0	0
45701555	708298	0	0
45682784	1551099	0	0
45782187	1174888	0	0
45696501	1174888	0	0
45690570	19078924	2	3
45784552	1129625	0	0
45696864	1177480	0	0
45897703	1112807	0	0
46299219	1759842	0	0
45788452	1000560	0	0
45799500	738818	0	0
46306810	1125315	0	0
45802088	19076374	2	3
4006969	4294548	2	2
3050426	3036780	2	2
21002745	40228214	2	3
21502550	926487	4	4
36153451	1112807	0	0
21602796	46275444	4	6
36313965	4151422	3	3
36302161	4163951	2	2
42804137	1332419	2	3
44342325	1367571	0	0
44338101	1115171	2	3
44339512	1125315	0	0
45638451	1177480	0	0
44347895	1174888	0	0
45623922	1127433	2	3
45667579	1192710	0	0
45630009	1539411	2	3
45630019	40232448	2	3
45677483	914335	0	0
45701464	1396131	0	0
45682768	1124300	0	0
45782274	920293	0	0
45696618	738818	0	0
45693326	40228214	2	3
45789333	920300	2	3
45802662	1177480	0	0
45897917	1500211	0	0
46298926	1124957	0	0
45788322	1107830	0	0
45799416	1595799	0	0
46302579	1125315	0	0
45802152	40229134	2	3
1580779	42902245	2	2
3050442	3023430	2	2
21002745	40223834	2	3
21502550	1129625	4	4
36153470	1107830	0	0
36202157	4296205	6	6
36313965	4246502	3	3
36300000	4234705	3	3
42803300	1539411	2	3
44342528	1332418	0	0
44338294	1127433	2	3
44339242	1125315	0	0
45634854	1177480	0	0
44347817	1343916	0	0
45623456	19078461	2	3
45667481	1192710	0	0
45654152	1332419	2	3
45630191	1545959	2	3
45677487	1539403	0	0
45701468	1124300	0	0
45682769	1361711	0	0
45782276	1154029	0	0
45696621	967823	0	0
45687540	1107882	2	3
45789447	19008572	2	3
45802674	1177480	0	0
45897844	1115008	0	0
46298760	933724	0	0
45788568	1115008	0	0
45799416	1521369	0	0
46299637	1125315	0	0
45802338	1115171	2	3
1586134	40766240	2	2
3050442	3005136	2	2
21002745	19125062	2	3
21502550	738818	4	4
36152782	1548195	0	0
36203062	4218389	6	6
36313965	4133840	3	3
36516993	381316	3	3
42804297	1332419	2	3
44342273	1110410	0	0
44338519	43012036	2	3
44339623	1125315	0	0
45634839	1177480	0	0
44347935	1332418	0	0
45623682	40231925	2	3
45665243	1192710	0	0
45666620	1539411	2	3
45630175	1551192	2	3
45677763	1174888	0	0
45701440	708298	0	0
45682773	738818	0	0
45782011	738818	0	0
45696628	1332418	0	0
45699584	1107882	2	3
45789481	1115171	2	3
45802886	1177480	0	0
45897846	1124957	0	0
46299474	1107830	0	0
45788314	723013	0	0
45799416	1549786	0	0
46299663	1125315	0	0
45799429	1115171	2	3
4023316	81151	2	2
3050442	3036780	2	2
21002745	43012036	2	3
21502549	19074843	8	9
36152846	1119510	0	0
36202155	78272	6	6
36303153	4195803	3	3
36502205	4035415	3	3
42801735	1332419	2	3
44342443	1124300	0	0
44338448	1127433	2	3
44339627	1125315	0	0
44361857	1112807	0	0
44347512	701322	0	0
45624088	1115171	2	3
45662923	1192710	0	0
45627492	19079524	1	1
45630406	40223821	2	3
45677766	967823	0	0
45701445	1738521	0	0
45682717	1124957	0	0
45782130	1501700	0	0
45696666	1310149	0	0
45690509	1107882	2	3
45789869	19073183	2	3
45802728	1177480	0	0
45897856	920293	0	0
46298649	1154343	0	0
45788610	1174888	0	0
45799509	1149196	0	0
46299676	1125315	0	0
45799307	19018935	2	3
3039467	3027970	2	2
3050445	3036780	2	2
21002328	920300	2	3
21502549	19133873	8	9
36152850	1112807	0	0
36002868	4066995	5	6
36303153	4163951	3	3
36503269	4035415	3	3
42801526	19075601	2	3
44342330	1729720	0	0
44338503	40231925	2	3
44339484	1125315	0	0
44362201	1112807	0	0
44347711	1115008	0	0
45624090	1127433	2	3
45662911	1192710	0	0
45639512	19079524	1	1
45627211	19077572	2	3
45677769	791967	0	0
45701501	1192710	0	0
45682812	1149196	0	0
45782308	1322184	0	0
45696673	975125	0	0
45679996	19073183	2	3
45786837	1115171	2	3
45802918	1177480	0	0
45897921	1332418	0	0
46298652	740275	0	0
45788593	1501700	0	0
45799305	708298	0	0
46299887	1125315	0	0
45799549	40236824	2	3
3039467	3006906	2	2
3050445	3023430	2	2
21002328	19075001	2	3
21502549	19073188	8	9
36152850	1192710	0	0
36002868	4048695	5	6
36503288	80180	3	3
36503269	80502	3	3
42804154	19075601	2	3
44342457	738818	0	0
44338394	1154615	2	3
44339558	1125315	0	0
44362167	1112807	0	0
44347712	1713332	0	0
45623894	1115171	2	3
45662915	1192710	0	0
45668991	19079524	1	1
45627230	19073183	2	3
45677773	1589505	0	0
45701504	1192710	0	0
45682721	1149196	0	0
45779563	1192710	0	0
45696676	1778162	0	0
45702850	1107882	2	3
45786500	1127433	2	3
45802870	1177480	0	0
45897952	1738521	0	0
46290359	1713332	0	0
45788598	1174888	0	0
45799306	1713332	0	0
46299800	1125315	0	0
45799363	19019273	2	3
3039467	3004501	2	2
3050445	3005136	2	2
21002328	920334	2	3
21502549	19075001	8	9
36152784	1738521	0	0
36203060	78272	5	6
36303152	4145310	3	3
36603314	4285898	3	3
42804222	19075601	2	3
44342458	1124300	0	0
44341152	40232448	2	3
44339349	1125315	0	0
44362029	1112807	0	0
44347712	1759842	0	0
45668034	1127433	2	3
45662961	1192710	0	0
45654720	19079524	1	1
45627104	19008572	2	3
45677773	1549786	0	0
45701668	1107830	0	0
45682818	1149196	0	0
45779585	1549786	0	0
45696680	1107830	0	0
45685660	1107882	2	3
45786663	19018935	2	3
45802979	1177480	0	0
45897959	19127890	0	0
46290568	933724	0	0
45788427	1308738	0	0
45799306	1759842	0	0
46299933	1125315	0	0
45799526	19075001	2	3
3039467	3024561	2	2
3050465	3023430	2	2
21002328	1713671	2	3
21502549	46233710	8	9
36152785	1177480	0	0
35802832	4048171	5	6
36303130	42535580	3	3
36503249	40480160	3	5
42804141	19075601	2	3
44342530	1118084	0	0
44341206	35605482	2	3
44339438	1125315	0	0
44362068	1112807	0	0
44347714	753626	0	0
45667880	46275444	2	3
45664441	1192710	0	0
45639657	19079524	1	1
45627229	1713671	2	3
45677775	920293	0	0
45701630	1153428	0	0
45682797	1717327	0	0
45779585	19127890	0	0
45696595	967823	0	0
45672585	1107882	2	3
45786511	40232448	2	3
45802883	1177480	0	0
45897959	1549786	0	0
46290583	1738521	0	0
45788428	975125	0	0
45799307	1326303	0	0
46299870	1125315	0	0
45796615	19008572	2	3
3039467	3013721	2	2
3050465	3005136	2	2
21001283	1107882	2	3
21502549	46233988	8	9
36152785	1129625	0	0
21602537	40221415	5	6
36702254	4132546	3	3
36300000	4052083	3	5
42801766	19075601	2	3
44342506	1137529	0	0
44341157	19008572	2	3
44341300	1125315	0	0
45656115	1112807	0	0
44347957	1192710	0	0
45667886	19078461	2	3
45659534	1192710	0	0
45663963	19079524	1	1
45627317	40163554	2	3
45677779	738818	0	0
45701591	1174888	0	0
45682977	738818	0	0
45779585	1589505	0	0
45696702	1154343	0	0
45672243	1107882	2	3
45786512	19059056	2	3
45802847	1177480	0	0
45897937	1501700	0	0
46290469	920293	0	0
45788531	1192710	0	0
45799449	738818	0	0
46299810	1125315	0	0
45796715	19008572	2	3
3039467	3016723	2	2
3050465	3036780	2	2
21001283	1150771	2	3
21502549	19074841	8	9
36153041	1125315	0	0
36206173	3019406	6	6
36703499	375671	3	3
36502205	4149245	3	6
42804245	19075601	2	3
44342506	1149380	0	0
44359725	40229134	2	3
44341429	1125315	0	0
45656026	1112807	0	0
44347672	1149380	0	0
45667903	40232448	2	3
45659701	1192710	0	0
45666484	19079524	1	1
45627107	40229134	2	3
45677790	1738521	0	0
45698107	738818	0	0
45682979	1115008	0	0
45779589	1174888	0	0
45696704	1326303	0	0
45786359	1107882	2	3
45786811	1115171	2	3
45800122	1177480	0	0
45895521	1307863	0	0
46290382	967823	0	0
45788675	967823	0	0
45799454	975125	0	0
46299820	1125315	0	0
45796987	19018935	2	3
3039467	3035995	2	2
3050951	3024561	2	2
21001283	19125062	2	3
21502549	1713671	8	9
36153370	1125315	0	0
35500000	140673	3	5
36313949	4024289	3	3
36516972	4048695	3	6
42803999	1539411	2	3
44342277	1112807	0	0
44359826	19008572	2	3
44341163	1125315	0	0
45656066	1112807	0	0
44347676	1149380	0	0
45667907	40232448	2	3
45660042	1192710	0	0
45666484	46275916	1	1
45627109	40229134	2	3
45677858	1332418	0	0
45697983	1361711	0	0
45682987	1545958	0	0
45779559	1305058	0	0
45696447	967823	0	0
45690421	1107882	2	3
45786648	1127433	2	3
45800279	1177480	0	0
45895503	1367571	0	0
46290385	1192710	0	0
45788630	1153428	0	0
45799460	1174888	0	0
46300021	1125315	0	0
45796848	40232448	2	3
3039467	3006923	2	2
3050951	3013682	2	2
21001283	40232448	2	3
21502549	46275444	8	9
36153370	1112807	0	0
35902135	198809	3	5
36313949	4252419	3	3
36313965	4202451	3	6
42806494	40223768	2	3
44342414	1343916	0	0
44359799	19008572	2	3
44339692	1125315	0	0
45656428	1112807	0	0
44347677	1149196	0	0
45670043	19079524	2	3
45656943	1192710	0	0
45666587	19079524	1	1
45627110	19059056	2	3
45677795	1549786	0	0
45698083	738818	0	0
45682875	1713332	0	0
45779520	967823	0	0
45696553	1548195	0	0
45695989	1107882	2	3
45786710	40229134	2	3
45800295	1177480	0	0
45895346	1149196	0	0
46290394	1539403	0	0
45788541	1551099	0	0
45799317	1102527	0	0
46300027	1125315	0	0
45796809	19075601	2	3
3039467	3020630	2	2
3050951	3013721	2	2
21001283	1150837	2	3
21502549	19129655	8	9
36153374	1112807	0	0
21602818	46275444	3	5
36313913	4024289	3	4
36503263	78272	3	7
42806190	40223768	2	3
44342420	1549786	0	0
44359834	40236824	2	3
44339699	1125315	0	0
45652690	1112807	0	0
44347720	738818	0	0
45670086	43012036	2	3
45657001	1192710	0	0
45627354	19079524	1	1
45627288	19075601	2	3
45677795	1519936	0	0
45698091	1107830	0	0
45682885	1153428	0	0
45779618	967823	0	0
45696554	920293	0	0
45674884	1107882	2	3
45786713	19077572	2	3
45802517	1177480	0	0
45895567	1361711	0	0
46290397	740275	0	0
45788683	1149196	0	0
45799318	1310149	0	0
46300085	1125315	0	0
45796884	19133905	2	3
3039467	3013682	2	2
3050951	3006923	2	2
21001283	43012036	2	3
21502549	1174888	6	6
36153492	1549786	0	0
36100000	4280726	5	5
36303140	439777	3	4
36502205	81151	3	7
42801609	19078461	2	3
44342430	1738521	0	0
44359623	19019273	2	3
44339771	1125315	0	0
45655177	1112807	0	0
44347728	19127890	0	0
45670351	19059056	2	3
45653557	1192710	0	0
45627835	19079524	1	1
45627377	1127433	2	3
45674156	1759842	0	0
45698368	1149196	0	0
45633681	1154029	0	0
45779638	1153428	0	0
45696779	1501700	0	0
45679971	1107882	2	3
45786922	40229134	2	3
45802247	1177480	0	0
45895570	1729720	0	0
46290507	1310149	0	0
45788399	1545958	0	0
45799321	975125	0	0
46300089	1125315	0	0
45796884	19133873	2	3
3048893	3005136	2	2
3050951	3006906	2	2
21001283	19112599	2	3
21502549	1728416	6	6
36153050	1107830	0	0
35702777	81893	5	5
36516728	4142905	3	4
36426641	19128065	3	4
42806595	19078461	2	3
44342442	1118084	0	0
44360136	1115171	2	3
43531392	4186930	3	4
45655355	1112807	0	0
44347911	1521369	0	0
45668175	1115171	2	3
45653560	1192710	0	0
45664124	19079524	1	1
45627357	1551192	2	3
45674156	1713332	0	0
45698315	1115008	0	0
45633427	1551099	0	0
45779641	1549786	0	0
45696780	975125	0	0
45778140	19079524	2	3
45786927	920334	2	3
45797571	1177480	0	0
45895463	1192710	0	0
46290476	1115008	0	0
45788499	1115008	0	0
45799506	1738521	0	0
46300236	1125315	0	0
45796897	40163554	2	3
3048893	3036780	2	2
3050951	3027970	2	2
21001283	40228214	2	3
21502549	1729720	6	6
36153051	1115008	0	0
35809406	81893	5	5
36516993	4149245	3	4
36602211	4285898	3	4
42806412	1332419	2	3
44342593	1149380	0	0
44360080	40232448	2	3
44784106	4230399	4	4
45652854	1112807	0	0
44347728	1589505	0	0
45668183	40162522	2	3
45653243	1192710	0	0
45633497	19079524	1	1
45627448	40163554	2	3
45674163	1595799	0	0
45698782	1308738	0	0
45633470	1545958	0	0
45779641	19127890	0	0
45682141	1112807	0	0
45703048	19078461	2	3
45786794	40229134	2	3
45797582	1177480	0	0
45895468	1515774	0	0
46290428	19003953	0	0
45788677	1307863	0	0
45799363	1115008	0	0
46300111	1125315	0	0
45797027	40229134	2	3
3048893	3023430	2	2
3050951	3004501	2	2
21001283	40223821	2	3
21502549	1717327	6	6
36153053	1177480	0	0
36002868	4048171	5	5
36303152	4163872	3	4
36427783	40221415	3	4
42801338	1332419	2	3
44342594	1332418	0	0
44360143	40229134	2	3
44784105	40479422	4	4
45649526	1112807	0	0
44347728	1549786	0	0
45668123	40220960	2	3
45653619	1192710	0	0
45633497	46275916	1	1
45627463	920300	2	3
45674163	1308738	0	0
45698094	1124300	0	0
45633715	1308738	0	0
45779641	1589505	0	0
45679963	1112807	0	0
45678583	40228214	2	3
45786964	40229134	2	3
45797842	1177480	0	0
45895468	1549786	0	0
46290393	1174888	0	0
45788648	742185	0	0
45799549	933724	0	0
46300148	1125315	0	0
45797028	1154615	2	3
3048907	3036780	2	2
3050951	3020630	2	2
21001283	40228230	2	3
21502549	1768849	6	6
36153054	1125315	0	0
36000000	37017711	5	5
36427091	19127922	3	4
36503263	4035415	3	4
42801344	1332419	2	3
44342571	1539403	0	0
44359883	40236824	2	3
43531071	4238715	3	4
45649747	1112807	0	0
44347938	967823	0	0
45668124	40223834	2	3
45650157	1192710	0	0
45666564	19079524	1	1
45627538	19019273	2	3
45674008	975125	0	0
45698096	738818	0	0
45633780	1107830	0	0
45779725	1501700	0	0
45677673	1112807	0	0
45696337	19075601	2	3
45786886	40229134	2	3
45797562	1177480	0	0
45895544	1107830	0	0
46290550	1115008	0	0
45788654	1717327	0	0
45799485	791967	0	0
46300169	1125315	0	0
45797143	43012036	2	3
3048907	3023430	2	2
3050951	3035995	2	2
21001283	40223834	2	3
21502549	1738521	6	6
36153054	1112807	0	0
36000000	4240902	5	5
36427091	19133679	3	4
36503263	4146173	3	4
42801785	1332419	2	3
44342551	1149196	0	0
44360280	40229134	2	3
43531071	4330583	3	7
45649846	1112807	0	0
44347867	1713332	0	0
45668126	40232448	2	3
45650245	1192710	0	0
45664399	19079524	1	1
45623708	19078461	2	3
45674170	1713332	0	0
45698406	1713332	0	0
45633874	1149380	0	0
45779644	1115008	0	0
45677915	1112807	0	0
45778010	1539411	2	3
45786904	1115171	2	3
45797677	1177480	0	0
45896700	1322184	0	0
46290593	1124300	0	0
45788657	1729720	0	0
45799550	1154029	0	0
46300340	1125315	0	0
46317548	19019273	2	3
3048907	3005136	2	2
3037839	3045716	2	2
21001804	19073188	2	3
21502549	1741122	6	6
36153055	1112807	0	0
36202157	4094814	5	5
36427091	42902245	3	4
40049748	19008572	1	1
42804512	40174880	2	3
44342619	1310149	0	0
44353309	40162522	2	3
43531071	4145310	3	3
45649672	1112807	0	0
44347869	1738521	0	0
45668130	920300	2	3
45647404	1192710	0	0
45630158	19079524	1	1
45623900	40229134	2	3
45674170	1759842	0	0
45698406	1759842	0	0
45633789	967823	0	0
45779649	738818	0	0
45677827	1112807	0	0
45679366	40228214	2	3
45786908	19008572	2	3
45794980	1177480	0	0
45896701	1713332	0	0
46290863	1713332	0	0
46298026	975125	0	0
45799521	1154029	0	0
46300245	1125315	0	0
46317571	19008572	2	3
3048915	3036780	2	2
3037839	3019550	2	2
21001804	19074841	2	3
21502549	1759842	6	6
36153057	1112807	0	0
36203066	375671	5	5
36427091	19128065	3	4
40654138	3049273	1	1
42801630	1545959	2	3
44342616	1115008	0	0
44353316	40236824	2	3
43531071	4186930	4	5
45649925	1112807	0	0
44347952	1549786	0	0
45668169	35605482	2	3
45644415	1192710	0	0
45627321	19079524	1	1
45623901	40232448	2	3
45674173	1343916	0	0
45698387	1367571	0	0
45633877	1551099	0	0
45779729	723013	0	0
45674699	1112807	0	0
45679945	1332419	2	3
45785340	43012036	2	3
45795096	1177480	0	0
45896717	1000560	0	0
46290873	1124300	0	0
46297506	715997	0	0
45799553	1115008	0	0
46300246	1125315	0	0
45794186	40162522	2	3
3048915	3023430	2	2
3037839	3023103	2	2
21001804	19129655	2	3
21502549	1778162	6	6
36153108	1125315	0	0
36203066	378001	5	5
36427091	19129144	3	4
37522151	4107731	1	1
42806550	1539411	2	3
44342569	705944	0	0
44353322	19057271	2	3
43531071	4117038	4	6
45649898	1112807	0	0
44348538	1107830	0	0
45668286	40236446	2	3
45644433	1192710	0	0
45639393	19079524	1	1
45625137	1310034	2	3
45674409	1107830	0	0
45698504	967823	0	0
45633788	740275	0	0
45779730	738818	0	0
45674540	1112807	0	0
45705820	1332419	2	3
45785284	1115171	2	3
45792524	1177480	0	0
45896718	1124957	0	0
46290649	1192710	0	0
46297680	1124957	0	0
45799530	1539403	0	0
46300184	1125315	0	0
45794187	1115171	2	3
3048915	3005136	2	2
3037839	3014576	2	2
21001804	19074843	2	3
21502549	933724	6	6
36153108	1112807	0	0
36203062	4299128	5	5
36426182	19127918	3	4
40171037	40169281	1	1
42538830	439777	3	4
44342132	1154029	0	0
44353142	19008572	2	3
43531060	195588	3	4
45649930	1112807	0	0
44348662	1153428	0	0
45668365	1127433	2	3
45644299	1192710	0	0
45627710	19079524	1	1
45625194	19008572	2	3
45674397	1595799	0	0
45698239	1124957	0	0
45633792	1149196	0	0
45779799	1738521	0	0
45674754	1112807	0	0
45696628	1332419	2	3
45785299	19059056	2	3
45789503	1177480	0	0
45896805	933724	0	0
46290718	708298	0	0
46297688	1192710	0	0
45799568	1107830	0	0
46300159	1125315	0	0
45794192	920334	2	3
3048927	3036780	2	2
3037839	3015632	2	2
21001804	19073183	2	3
21502553	40171902	6	6
36153117	1112807	0	0
36203062	4296205	5	5
36426182	19128009	3	4
36303177	4181917	1	1
42888897	4037675	4	4
44342600	1000560	0	0
44353345	19008572	2	3
43531056	4329847	5	6
45649104	1112807	0	0
44348539	1332418	0	0
45665936	40163554	2	3
45641444	1192710	0	0
45645411	19079524	1	1
45625195	1545959	2	3
45676233	1115008	0	0
45698314	1308738	0	0
45679857	1115008	0	0
45779628	1343916	0	0
45674654	1112807	0	0
45782464	40173590	2	3
45785314	19018935	2	3
45789761	1177480	0	0
45896724	975125	0	0
46290719	1124957	0	0
46297938	967823	0	0
45799526	1778162	0	0
46296119	1125315	0	0
45794021	19133905	2	3
1503242	19128065	2	2
3044023	3045716	2	2
21001804	19075001	2	3
21502553	1539411	7	8
36153376	1192710	0	0
36203090	4084167	5	5
36424660	40221415	3	4
37522248	4035793	1	1
37502338	4336464	5	5
44342606	1000560	0	0
44355677	19008572	2	3
43531056	317576	5	5
45646509	1112807	0	0
44348553	738818	0	0
45665794	40243436	2	3
45641594	1192710	0	0
45630490	19079524	1	1
45625268	1332419	2	3
45676244	975125	0	0
45698218	1332418	0	0
45679872	1305058	0	0
45779632	740275	0	0
45674788	1112807	0	0
45779914	1107882	2	3
45785317	1115171	2	3
45789764	1177480	0	0
45896732	1557272	0	0
46290887	1118084	0	0
46301490	1545958	0	0
45799528	1738521	0	0
46296125	1125315	0	0
45794021	19133873	2	3
437385	375671	2	2
3044023	3023103	2	2
21002327	920300	2	3
21502553	1545959	7	8
36153376	1112807	0	0
21603249	40169281	4	5
36424688	42902245	3	4
36316010	4133840	1	1
37502338	4337611	4	4
44342253	1768849	0	0
44355421	19008572	2	3
43531056	258780	5	5
45646569	1112807	0	0
44348555	1000560	0	0
45665614	40236824	2	3
45641693	1192710	0	0
45666213	19079524	1	1
45625202	1332419	2	3
45676257	1310149	0	0
45698326	1154029	0	0
45679588	738818	0	0
45779634	1551099	0	0
45674722	1112807	0	0
45677518	1107882	2	3
45785364	1127433	2	3
45789879	1177480	0	0
45896701	1759842	0	0
46290560	1115008	0	0
46301446	705944	0	0
45799532	1115008	0	0
46296348	1125315	0	0
45794144	40236824	2	3
3006343	3014576	2	2
3044023	3019550	2	2
21002327	19075001	2	3
21502553	1343916	5	5
36153638	1125315	0	0
21602496	19127904	4	5
36424688	19128263	3	4
36403239	140673	1	1
37502341	4117038	5	5
44342257	1149196	0	0
44355232	1551192	2	3
43531056	321042	5	5
45643477	1112807	0	0
44348726	1521369	0	0
45666059	40229134	2	3
45638247	1192710	0	0
45666680	19079524	1	1
45624203	40236824	2	3
45676260	738818	0	0
45698338	1551099	0	0
45679591	1515774	0	0
45779737	1115008	0	0
45671971	1112807	0	0
45672403	19075601	2	3
45785371	40232448	2	3
45789237	1177480	0	0
45679921	738818	0	0
46290756	1713332	0	0
46301453	1174888	0	0
45799613	1174888	0	0
46296113	1125315	0	0
45794796	40236446	2	3
3006343	3023103	2	2
3044023	3014576	2	2
21002327	920334	2	3
21502553	1361711	5	5
36153063	975125	0	0
21602537	40224805	4	5
36424688	19128009	3	4
36316422	4314290	1	1
37502341	4330583	5	5
44342258	1110410	0	0
44355306	1332419	2	3
43531056	255848	4	4
45643781	1112807	0	0
44348726	1549786	0	0
45666163	40232448	2	3
45640079	1192710	0	0
45666778	19079524	1	1
45624234	1127433	2	3
45676407	1149196	0	0
45698243	1124957	0	0
45679591	19127890	0	0
45779742	1174888	0	0
45671753	1112807	0	0
45676342	19078461	2	3
45785412	782047	2	3
45789223	1177480	0	0
45679086	738818	0	0
46290756	1759842	0	0
46301466	1307863	0	0
45799538	1589505	0	0
46318426	1125315	0	0
45794801	40229134	2	3
3006343	3019550	2	2
3044023	3015632	2	2
21002327	1713671	2	3
21502553	1332418	5	5
36153492	1515774	0	0
21602868	19075001	4	5
36424688	19127904	3	4
37303797	134438	1	1
42537893	4048695	3	3
44342401	1112807	0	0
44345678	19008572	2	3
43531056	260139	4	4
45643610	1112807	0	0
44348322	1115008	0	0
45666030	19059056	2	3
45638467	1192710	0	0
45627762	46275916	1	1
45624523	19008572	2	3
45676411	1000560	0	0
45698248	1512674	0	0
45679591	1549786	0	0
45779747	1115008	0	0
45672028	1112807	0	0
45784234	19075601	2	3
45785389	40229134	2	3
45787046	1177480	0	0
45786031	738818	0	0
46290772	1174888	0	0
46301542	1729720	0	0
45799538	1549786	0	0
46318427	1125315	0	0
45794276	19129655	2	3
3006343	3015632	2	2
3048501	3036780	2	2
21001801	19075001	2	3
21502553	1308738	5	5
36153137	975125	0	0
35502089	4144583	4	5
36424688	19127918	3	4
40773226	3010813	1	1
42537893	4066995	3	3
44342406	1713332	0	0
44345441	19008572	2	3
43531056	261325	3	5
45643635	1112807	0	0
44348735	975125	0	0
45666195	19126352	2	3
45634235	1192710	0	0
45627762	19079524	1	1
45624263	40163554	2	3
45674425	1115008	0	0
45698248	1548195	0	0
45630668	1713332	0	0
45779526	1124300	0	0
45783787	1112807	0	0
45782308	19075601	2	3
45785392	40163554	2	3
45787067	1177480	0	0
45786544	738818	0	0
46290779	1174888	0	0
46298196	1174888	0	0
45799540	1174888	0	0
46318429	1125315	0	0
45794311	19073188	2	3
3006343	3045716	2	2
3048501	3005136	2	2
21001801	19074841	2	3
21502553	1539403	5	5
36153138	975125	0	0
21602818	1713671	4	5
36424688	19128022	3	4
40589905	4084167	1	1
37502338	4337138	3	3
44342406	1759842	0	0
44345769	19129655	2	3
43531056	313217	6	7
45643512	1112807	0	0
44348741	920293	0	0
45666042	40223834	2	3
45632428	1192710	0	0
45630649	19079524	1	1
45624208	1127433	2	3
45674447	1308738	0	0
45698250	1192710	0	0
45630668	1759842	0	0
45779803	738818	0	0
45783953	1112807	0	0
45708184	19078461	2	3
45783410	40229134	2	3
45787356	1177480	0	0
45786383	738818	0	0
46290658	1551099	0	0
46298147	1192710	0	0
45799657	1149196	0	0
46318451	1125315	0	0
45794424	40236824	2	3
1595936	42902245	2	2
3048501	3023430	2	2
21001801	19074843	2	3
21502553	1307863	5	5
36153616	1177480	0	0
21603933	19019273	4	5
36424689	19128009	3	4
40765798	40766240	1	1
37502338	4078793	3	3
44342408	1713332	0	0
44348087	19008572	2	3
43531057	4329847	6	7
45645832	1112807	0	0
44348556	738818	0	0
45666109	1551192	2	3
45629465	1192710	0	0
45624724	19079524	1	1
45624381	40232448	2	3
45674451	920293	0	0
45698389	1738521	0	0
45630671	967823	0	0
45779590	1192710	0	0
45784179	1112807	0	0
45699386	19078461	2	3
45783449	40229134	2	3
45785653	1177480	0	0
45786122	738818	0	0
46290833	1192710	0	0
46298268	967823	0	0
45799665	1154343	0	0
46318452	1125315	0	0
45794477	1127433	2	3
4023584	44805732	2	2
3048567	3036780	2	2
21001801	19073188	2	3
21600001	914335	4	4
36153616	1119510	0	0
21603933	19078461	4	5
36424689	42902245	3	4
40170032	35605858	1	1
43054942	3016723	3	3
44342541	1115008	0	0
44345803	1127433	2	3
43531057	258780	6	6
45641083	1112807	0	0
44348618	1192710	0	0
45666260	40174880	2	3
45626737	1192710	0	0
45664228	46275916	1	1
45624244	19008572	2	3
45674485	1115008	0	0
45698460	1305058	0	0
45630769	738818	0	0
45779705	738818	0	0
45784193	1112807	0	0
45696511	19075601	2	3
45783450	40163554	2	3
45785571	1177480	0	0
46292667	738818	0	0
46290563	1307863	0	0
46298293	967823	0	0
45799670	1322184	0	0
46318454	1125315	0	0
45791453	40229134	2	3
1107885	1107882	1	1
3048567	3023430	2	2
21001801	1713671	2	3
21600001	1000560	4	4
36153773	1307863	0	0
35702738	4285898	4	10
36424689	19128263	3	4
40047095	19077572	1	1
43054942	3023103	3	3
44344654	1713332	0	0
44345817	40232448	2	3
43531057	321042	6	6
45641181	1112807	0	0
44348432	1729720	0	0
45666271	19019273	2	3
45623325	1192710	0	0
45630077	19079524	1	1
45668312	40223834	2	3
45674419	1343916	0	0
45698557	1729720	0	0
45630770	1713332	0	0
45779687	1309944	0	0
45784287	1112807	0	0
45784297	19075601	2	3
45783178	19078461	2	3
45785606	1177480	0	0
46292717	738818	0	0
46290834	1308738	0	0
46298158	1192710	0	0
45799624	920293	0	0
46318459	1125315	0	0
45791380	1107882	2	3
437312	192671	1	1
3048567	3005136	2	2
21001801	19129655	2	3
21600001	975125	4	4
36153775	1153428	0	0
35702738	30753	4	7
36424689	19127904	3	4
40050254	782047	1	1
43054942	3013682	3	3
44344662	1149380	0	0
44341148	19019273	2	3
43531057	317576	6	6
45640895	1112807	0	0
44348010	1308738	0	0
45663644	19008572	2	3
45623481	1192710	0	0
45668934	19079524	1	1
45668197	19078924	2	3
45674495	1149196	0	0
45698433	1124957	0	0
45630715	1738521	0	0
45779781	1107830	0	0
45781866	1112807	0	0
45779600	19075601	2	3
45783522	1551192	2	3
45785641	1177480	0	0
46293194	738818	0	0
46291041	1124957	0	0
46298184	1124300	0	0
45799577	1738521	0	0
46318574	1125315	0	0
45791709	40229134	2	3
1127642	40229134	1	1
3048584	3036780	2	2
21001801	19073183	2	3
21500010	1768849	2	2
36153793	1713332	0	0
35702738	198809	5	7
36424689	19127918	3	4
37521794	4337138	1	1
37500000	4186930	4	4
44344949	1759842	0	0
44338730	46275444	2	3
43531057	4142905	6	6
45637567	1112807	0	0
44348122	975125	0	0
45663711	1545959	2	3
45623535	1192710	0	0
45668934	46275916	1	1
45668365	19078461	2	3
45674472	738818	0	0
45698560	1713332	0	0
45630832	1149196	0	0
45779784	967823	0	0
45782123	1112807	0	0
45671907	19075601	2	3
46291172	1115171	2	3
45785860	1177480	0	0
46288417	738818	0	0
46291064	705944	0	0
46298341	1149196	0	0
45799484	1738521	0	0
46318516	1125315	0	0
45791597	40224805	2	3
1113309	19059056	1	1
3048584	3005136	2	2
21001801	46275444	2	3
21500010	1741122	2	2
36153812	1115008	0	0
35702738	81893	5	11
36424689	19128022	3	4
37521795	4337611	1	1
37500000	4078793	4	4
44344949	1713332	0	0
44338678	40232448	2	3
43531057	260139	5	5
45637963	1112807	0	0
44347976	1110410	0	0
45663420	40232448	2	3
45623363	1192710	0	0
45648514	19079524	1	1
45668373	40229134	2	3
45674560	757627	0	0
45698533	967823	0	0
45630838	920293	0	0
45779814	967823	0	0
45782019	1112807	0	0
45705923	19075601	2	3
46291621	19075001	2	3
45785645	1177480	0	0
46288691	738818	0	0
46290683	933724	0	0
46298457	715997	0	0
45799578	738818	0	0
46318772	1125315	0	0
45791697	40231925	2	3
4018956	78272	1	1
3048584	3023430	2	2
21001819	46233710	2	3
21500010	1778162	2	2
36153823	1119510	0	0
35702738	4112343	5	9
36503289	4310024	3	5
37521588	4117038	1	1
37500000	4295880	6	6
44344952	1548195	0	0
44338740	19133905	2	3
43531057	255848	5	5
45634742	1112807	0	0
44347982	1713332	0	0
45663855	46275444	2	3
45667842	1192710	0	0
45642647	19079524	1	1
45668294	19073183	2	3
45674566	19039298	0	0
45698688	1115008	0	0
45630840	1729720	0	0
45779821	975125	0	0
45779523	1112807	0	0
45782122	19075601	2	3
46291540	1107882	2	3
45785983	1177480	0	0
46288761	738818	0	0
46290695	1549786	0	0
46298345	1501700	0	0
45799636	975125	0	0
46318677	1125315	0	0
45791614	920334	2	3
1585385	40766240	1	1
3048604	3036780	2	2
21001819	19075001	2	3
21604565	723013	2	2
36153083	1125315	0	0
35702738	196456	5	6
36313913	4058899	3	5
36918918	440086	1	1
42806218	19127904	1	2
44342629	1118084	0	0
44339207	40162522	2	3
43531057	261325	4	6
45634726	1112807	0	0
44347990	1110410	0	0
45663550	19133768	2	3
45667909	1192710	0	0
45627408	46275916	1	1
45668399	1551192	2	3
45674569	1307863	0	0
45698374	1367571	0	0
45630610	1548195	0	0
45779599	975125	0	0
45779800	1112807	0	0
45782501	1539411	2	3
46291751	1107882	2	3
45785935	1177480	0	0
46243300	738818	0	0
46290695	1521369	0	0
46298377	1000560	0	0
45799589	1549786	0	0
46318880	1125315	0	0
45791659	19019273	2	3
1107886	19125062	1	1
3048604	3023430	2	2
21001819	46275444	2	3
21604565	19115351	2	2
36153736	1112807	0	0
35702738	28060	6	7
36313957	439777	3	5
36918919	440086	1	1
43053794	4285898	1	2
44342707	1729720	0	0
44360400	40236824	2	3
43531057	313217	7	8
45634548	1112807	0	0
44348052	1521369	0	0
45663584	46275916	2	3
45667815	1192710	0	0
45627408	19079524	1	1
45668439	19073183	2	3
45674572	1551099	0	0
45698694	723013	0	0
45630843	1115008	0	0
45779600	1322184	0	0
45779633	1112807	0	0
45672088	1539411	2	3
46291765	1115171	2	3
46292163	1177480	0	0
46243301	738818	0	0
46291070	791967	0	0
46298408	742185	0	0
45799589	19127890	0	0
46319028	1125315	0	0
45791667	19059056	2	3
435459	433125	1	1
3048604	3005136	2	2
21001819	46233988	2	3
21604565	791967	2	2
36153750	1129625	0	0
35802829	381316	6	6
36503290	81151	3	6
36919236	443279	1	1
43053691	4066995	1	2
44342743	967823	0	0
44347441	19133905	2	3
43531059	45769019	4	4
45631581	1112807	0	0
44348052	1595799	0	0
45660242	19008572	2	3
45667838	1192710	0	0
45636470	19079524	1	1
45668381	1107882	2	3
45674508	975125	0	0
45698573	1124957	0	0
45630860	1107830	0	0
45779832	1309944	0	0
45779918	1112807	0	0
45784300	1539411	2	3
46291452	40174880	2	3
46292144	1177480	0	0
46242546	738818	0	0
46291236	715997	0	0
46298543	1713332	0	0
45799589	1515774	0	0
46319029	1125315	0	0
45791583	46233710	2	3
438409	440086	1	1
3048875	3036780	2	2
21001819	1713671	2	3
21602882	19075001	2	2
36152955	1107830	0	0
35802829	372328	6	6
36300000	4133840	3	6
40793378	3021226	1	1
37502353	44783196	5	7
44342722	1153428	0	0
44343243	1115171	2	3
43531059	195588	4	5
45631846	1112807	0	0
44348052	1549786	0	0
45660383	1127433	2	3
45667193	1192710	0	0
45636470	46275916	1	1
45668427	43012036	2	3
45674462	1713332	0	0
45698440	1501700	0	0
45630862	740275	0	0
45779881	1000560	0	0
45708301	1112807	0	0
45678092	1539411	2	3
46291678	40229134	2	3
46292278	1177480	0	0
46241209	738818	0	0
46290845	1192710	0	0
46298543	1759842	0	0
45799592	1174888	0	0
46318656	1125315	0	0
45791754	1127433	2	3
4023584	4059978	1	1
3048875	3005136	2	2
21001819	19129655	2	3
21602882	1768849	2	2
36153562	975125	0	0
35802829	380378	6	6
36303152	4058899	3	6
40793379	3006451	1	1
37502353	4301346	6	7
44342686	975125	0	0
44342974	40162522	2	3
43531058	81893	7	8
45628594	1112807	0	0
44348062	1115008	0	0
45660384	40232448	2	3
45663358	1192710	0	0
45668769	19079524	1	1
45668524	19029476	2	3
45674513	1149196	0	0
45698710	1738521	0	0
45630991	708298	0	0
45779913	1332418	0	0
45708025	1112807	0	0
45675176	40228214	2	3
46291693	46275916	2	3
46243082	1177480	0	0
46241391	738818	0	0
46290631	1000560	0	0
46298305	1551099	0	0
45796838	1521369	0	0
46318776	1125315	0	0
45791781	782047	2	3
3040986	3051031	1	1
3048875	3023430	2	2
21001643	1545959	2	3
21604148	40173590	2	2
36153878	1125315	0	0
35802829	28060	6	7
36503289	4296204	3	6
40652640	3013721	1	1
37502353	4117038	4	8
44342652	1738521	0	0
44343100	19133873	2	3
43531058	4166224	5	6
45628623	1112807	0	0
44348134	740275	0	0
45660336	1115171	2	3
45659846	1192710	0	0
45651207	19079524	1	1
45668632	35605482	2	3
45674525	738818	0	0
45698445	1107830	0	0
45630872	1343916	0	0
45779658	914335	0	0
45777970	1112807	0	0
45782212	1539411	2	3
46291888	40232448	2	3
46242909	1177480	0	0
46238440	738818	0	0
46242048	933724	0	0
46298326	967823	0	0
45796659	740275	0	0
46312781	1125315	0	0
45788963	19076374	2	3
3041250	3023430	1	1
3048880	3036780	2	2
21001643	1539411	2	3
21604793	715997	2	2
36153879	1112807	0	0
35802829	4001336	6	8
36313965	4015189	3	6
40652709	3028833	1	1
37502353	4163971	4	9
44342669	738818	0	0
44343394	40223834	2	3
43531058	198809	5	5
45631100	1112807	0	0
44348106	740275	0	0
45660453	19078461	2	3
45659753	1192710	0	0
45668487	19079524	1	1
45668496	1115171	2	3
45671433	1738521	0	0
45698576	1174888	0	0
45630921	1539403	0	0
45779914	1107830	0	0
45778222	1112807	0	0
45784268	40228214	2	3
46291917	46233710	2	3
46243078	1177480	0	0
46238395	738818	0	0
46242213	1124957	0	0
46289697	1192710	0	0
45796610	1322184	0	0
46312391	1125315	0	0
45788965	40231925	2	3
3041250	3005136	1	1
3048880	3023430	2	2
21001630	1545959	2	3
21604793	40223774	2	2
36153883	1000560	0	0
35802829	40481087	6	8
36300000	4181917	3	7
40652745	3006906	1	1
37502353	4035793	3	5
44342691	1713332	0	0
44343492	40232448	2	3
43531058	4266809	4	4
45631104	1112807	0	0
44348111	738818	0	0
45660618	40169216	2	3
45649511	1332418	0	0
45658229	19079524	1	1
45668585	19073183	2	3
45671471	1174888	0	0
45698578	1115008	0	0
45631007	1500211	0	0
45779920	738818	0	0
45705856	1112807	0	0
45684274	40228230	2	3
46295789	19008572	2	3
46243207	1177480	0	0
45897579	738818	0	0
46242435	1332418	0	0
46290110	1000560	0	0
45796611	1000560	0	0
46312403	1125315	0	0
45789006	40229134	2	3
3041250	3036780	1	1
3048880	3005136	2	2
21506101	1125315	1	1
21604793	757627	2	2
36153751	1129625	0	0
35802829	4112343	6	9
36300000	4163872	3	8
40652760	3015632	1	1
37502336	44783196	4	6
44363955	1500211	0	0
44343501	1127433	2	3
43531058	196456	4	4
45628813	1112807	0	0
44348113	933724	0	0
45660760	19019273	2	3
45649279	967823	0	0
45658229	46275916	1	1
45668409	19008572	2	3
45671544	1501700	0	0
45698593	1192710	0	0
45631011	1149196	0	0
45779666	1000560	0	0
45705659	1112807	0	0
45684274	40228214	2	3
46244994	1127433	2	3
46243216	1177480	0	0
45897589	738818	0	0
46242462	715997	0	0
46290122	1115008	0	0
45796615	975125	0	0
46312688	1125315	0	0
45788935	40228214	2	3
3048893	3006734	1	1
3048238	3023430	2	2
21506109	1332418	1	1
21503965	19010482	2	2
36153752	1129625	0	0
35802829	4294548	6	9
36300000	4024958	3	8
40652796	3014576	1	1
40087471	40174880	1	1
44364018	1539403	0	0
44343468	43012036	2	3
43531058	4285898	3	7
45628870	1112807	0	0
44348095	1149380	0	0
45660422	40229134	2	3
45649286	1332418	0	0
45635144	19079524	1	1
45665857	40229134	2	3
45671642	1174888	0	0
45698599	1149380	0	0
45630823	914335	0	0
45779671	1149196	0	0
45706047	1112807	0	0
45706019	40228214	2	3
46244995	40232448	2	3
46240910	1177480	0	0
45897643	738818	0	0
46242142	1124957	0	0
46289857	1149196	0	0
45796715	975125	0	0
46312996	1125315	0	0
45788944	19023398	2	3
3048893	3001247	1	1
3048238	3005136	2	2
21506109	1307863	1	1
21503965	1305058	2	2
36153757	1125315	0	0
35802829	4048171	8	10
36300000	4015189	3	9
40652525	3006923	1	1
40083920	1539411	1	1
44364056	1177480	0	0
44343477	40162522	2	3
43531058	195588	3	5
45626109	1112807	0	0
44348139	1548195	0	0
45660553	40223768	2	3
45649519	1124300	0	0
45627273	46275916	1	1
45665861	43012036	2	3
45671648	1174888	0	0
45698605	1107830	0	0
45631013	1332418	0	0
45779769	1539403	0	0
45705798	1112807	0	0
45681312	40228214	2	3
46290991	19075001	2	3
46240937	1177480	0	0
45895374	738818	0	0
46242217	1124957	0	0
46289879	1717327	0	0
45796721	1174888	0	0
46312917	1125315	0	0
45788993	19129655	2	3
3048915	3001247	1	1
3048238	3036780	2	2
21506098	967823	1	1
21604798	701322	2	2
36154119	1125315	0	0
35802829	140673	5	5
36313965	4010253	2	6
40652534	3024561	1	1
43021226	134438	1	1
44364037	1545958	0	0
44339798	1115171	2	3
43531058	4310024	3	4
45622590	1112807	0	0
44348140	1174888	0	0
45660526	19008572	2	3
45649350	1124300	0	0
45627273	19079524	1	1
45667239	19079524	2	3
45671649	1717327	0	0
45698616	782043	0	0
45630908	967823	0	0
45779711	1741122	0	0
45703693	1112807	0	0
45672445	40228214	2	3
46291317	1115171	2	3
46241063	1177480	0	0
45894650	738818	0	0
46242414	1332418	0	0
46289417	1367571	0	0
45796721	1192710	0	0
46313177	1125315	0	0
45788985	1115171	2	3
3048915	3006734	1	1
3048257	3036780	2	2
21501246	19010482	1	1
21500296	967823	2	2
36153018	1589505	0	0
35802829	4029498	5	5
36313913	4145310	2	2
40652549	3035995	1	1
43055200	3051031	1	1
44364046	1521369	0	0
44339802	1127433	2	3
43531058	440448	6	6
45622675	1112807	0	0
44348243	1115008	0	0
45658426	19073183	2	3
45649406	1738521	0	0
45624023	19079524	1	1
45667365	40232448	2	3
45671486	914335	0	0
45698628	1192710	0	0
45630905	1539403	0	0
45779711	1746114	0	0
45703604	1112807	0	0
45784310	40228214	2	3
46242704	920334	2	3
46241094	1177480	0	0
45803429	738818	0	0
46242492	1548195	0	0
46289961	1149196	0	0
45796730	1124300	0	0
46312463	1125315	0	0
45788986	40232448	2	3
1115092	19019273	1	1
3048257	3023430	2	2
21502613	1125315	1	1
21604416	740275	2	2
36153018	19127890	0	0
35802829	4283893	5	7
36313949	4163872	2	2
40652575	3001247	1	1
43053692	4142905	1	1
44364046	1549786	0	0
44339986	1115171	2	3
43531061	81893	8	9
45622867	1112807	0	0
44348246	738818	0	0
45658426	19073188	2	3
45649292	1501700	0	0
45645390	19079524	1	1
45667335	19008572	2	3
45671550	1548195	0	0
45698633	1713332	0	0
45630924	1174888	0	0
45779836	1551099	0	0
45703866	1112807	0	0
45702599	19079524	2	3
46242641	40223834	2	3
46241095	1177480	0	0
45803357	738818	0	0
46242083	757627	0	0
46290144	1115008	0	0
45796662	1367571	0	0
46312466	1125315	0	0
46302087	43012036	2	3
1115170	1115171	1	1
3048257	3005136	2	2
21502613	1115008	1	1
21604635	708298	2	2
36153018	1549786	0	0
35802829	4156265	5	7
36313949	4058899	2	2
40652611	3045716	1	1
40064724	19019273	1	1
44364091	1149380	0	0
45620074	40228230	2	3
43531061	198809	6	6
45622971	1112807	0	0
44348247	1713332	0	0
45658398	40232448	2	3
45649304	1305058	0	0
45645390	46275916	1	1
45667273	40223768	2	3
45671582	1548195	0	0
45698789	1500211	0	0
45631066	1539403	0	0
45779837	975125	0	0
45702242	1112807	0	0
45699406	19078461	2	3
46242719	40232448	2	3
46238232	1177480	0	0
45803452	738818	0	0
46242374	715997	0	0
46290148	1367571	0	0
45796813	1741122	0	0
46312710	1125315	0	0
46301817	19077344	2	3
3005833	3000963	1	1
3048273	3036780	2	2
21502621	1759842	1	1
21505881	1557272	2	2
36153020	1129625	0	0
35802829	4132546	5	7
36304718	3045716	2	2
40652614	3020655	1	1
40064724	1115171	1	1
44364094	738818	0	0
45620337	19008572	2	3
43531061	4166224	6	7
45622747	1112807	0	0
44348213	1551099	0	0
45658401	44816277	2	3
45649467	1124300	0	0
45657708	19079524	1	1
45667466	19133768	2	3
45671584	1153428	0	0
45698341	1729720	0	0
45630738	1332418	0	0
45779851	1110410	0	0
45702392	1112807	0	0
45779814	19079524	2	3
46242680	40229134	2	3
46238242	1177480	0	0
45800897	738818	0	0
46242380	967823	0	0
46289870	1124300	0	0
45796813	1746114	0	0
46312942	1125315	0	0
46299553	40229134	2	3
3006343	3004501	1	1
3048273	3023430	2	2
21502537	1367571	1	1
21604147	1557272	2	2
36153023	1125315	0	0
35802829	4043241	9	10
36304718	3019550	2	2
40652870	3016723	1	1
40067083	19133873	1	1
44364252	1309944	0	0
45619848	19059056	2	3
43531061	196456	5	5
45621130	1112807	0	0
44348214	1174888	0	0
45657513	19075001	2	3
45649380	1000560	0	0
45651287	46275916	1	1
45667466	40162522	2	3
45671595	1545958	0	0
45698344	1110410	0	0
45631001	1115008	0	0
45779862	1713332	0	0
45702458	1112807	0	0
45684416	40228214	2	3
46242773	40229134	2	3
45897149	1177480	0	0
45800931	738818	0	0
46242381	1110410	0	0
46289399	1192710	0	0
45796860	1332418	0	0
46312958	1125315	0	0
46299563	19008572	2	3
3006343	3016723	1	1
3048273	3005136	2	2
21500563	715997	1	1
21604606	708298	2	2
36153023	1119510	0	0
35802829	4218389	4	5
36304718	3015632	2	2
40653596	3023103	1	1
40067083	19133905	1	1
44364318	1124300	0	0
45619912	19075601	2	3
43531061	4266809	5	5
45621943	1112807	0	0
44348247	1759842	0	0
45657595	19133768	2	3
45649479	19127890	0	0
45651287	19079524	1	1
45666362	40232448	2	3
45671552	1154343	0	0
45698865	1549786	0	0
45676640	1110410	0	0
45779864	1322184	0	0
45699494	1112807	0	0
45681302	40228214	2	3
46242883	19008572	2	3
45897365	1177480	0	0
45801090	738818	0	0
46242477	723013	0	0
46289403	933724	0	0
45796987	1326303	0	0
46312962	1125315	0	0
46298835	19133873	2	3
3006343	3013682	1	1
3051542	3024561	2	2
21500578	1125315	1	1
21602861	46275444	2	2
36153566	1107830	0	0
35802829	40486433	7	9
36304718	3023103	2	2
40653626	3020630	1	1
40064205	19078924	1	1
44364321	1307863	0	0
45620133	19075001	2	3
43531061	4285898	4	8
45621389	1112807	0	0
44341413	1307863	0	0
45657842	19008572	2	3
45649479	1512674	0	0
45654553	19079524	1	1
45663597	1124300	0	0
45671558	1115008	0	0
45698865	1589505	0	0
45676641	1713332	0	0
45779939	1332418	0	0
45699668	1112807	0	0
45681302	40228230	2	3
46242888	40162522	2	3
45897219	1177480	0	0
45801046	738818	0	0
46242350	1000560	0	0
46289407	1174888	0	0
45796780	1326303	0	0
46312697	1125315	0	0
46299245	1107882	2	3
3001019	3009201	1	1
3051542	3020630	2	2
21500578	1112807	1	1
21604200	19078219	2	2
36153533	1125315	0	0
35802829	4280726	7	9
36304718	3014576	2	2
40653646	3006734	1	1
42868771	3013682	1	1
44364356	1332418	0	0
45620047	19133768	2	3
43531061	195588	4	6
45621419	1112807	0	0
44341556	715997	0	0
45657683	1115171	2	3
45649479	1549786	0	0
45623803	19079524	1	1
45660110	1124957	0	0
45671562	1308738	0	0
45698756	1124957	0	0
45676644	1107830	0	0
45708116	1551099	0	0
45699674	1112807	0	0
45681630	40228214	2	3
46242962	1127433	2	3
45897335	1177480	0	0
45800777	738818	0	0
46239745	1110410	0	0
46290025	1192710	0	0
45796801	738818	0	0
46313043	1125315	0	0
46301505	40232448	2	3
3001019	3008598	1	1
3051542	3006906	2	2
21500586	1125315	1	1
21602868	1768849	2	2
36153533	1129625	0	0
35802829	378001	7	9
36304850	3014576	2	2
40654005	3026361	1	1
42870588	3010813	1	1
44364307	975125	0	0
44778130	19133905	2	3
43531061	4310024	4	5
45665080	1112807	0	0
44341563	1332418	0	0
45657688	19133905	2	3
45649480	1149196	0	0
45624204	46275916	1	1
45659906	1153428	0	0
45671631	975125	0	0
45698654	1326303	0	0
45676716	1713332	0	0
45708180	1124300	0	0
45696059	1112807	0	0
45779618	19079524	2	3
46242823	40231925	2	3
45897465	1177480	0	0
45801150	738818	0	0
46239601	1332418	0	0
46290042	1124957	0	0
45796802	914335	0	0
46313055	1125315	0	0
46301574	19073188	2	3
3001643	3000963	1	1
3051542	3013721	2	2
21500586	1112807	1	1
21602868	1778162	2	2
36153535	1125315	0	0
35802829	375671	7	9
36304850	3045716	2	2
40654026	3010813	1	1
42870592	3000963	1	1
44364081	1149380	0	0
44361327	1115171	2	3
43531061	440448	7	7
45664973	1112807	0	0
44341119	1738521	0	0
45657542	1551192	2	3
45649492	738818	0	0
45654578	19079524	1	1
45659660	715997	0	0
45671540	1124957	0	0
45698670	967823	0	0
45627802	1501700	0	0
45766064	45766064	0	0
45696226	1112807	0	0
45681643	40228214	2	3
46242831	40232448	2	3
45897363	1177480	0	0
45799770	738818	0	0
46239690	1124300	0	0
46290150	705944	0	0
45796803	715997	0	0
46313058	1125315	0	0
46301854	19078924	2	3
3001643	3009542	1	1
3051542	3004501	2	2
21500138	1500211	1	1
21502568	1713332	2	2
36153535	1129625	0	0
35802829	378419	7	8
36304850	3019550	2	2
40654106	3007461	1	1
42870592	3024731	1	1
44364083	920293	0	0
44361601	19133873	2	3
44362457	19127918	2	2
45665093	1112807	0	0
44341541	1545958	0	0
45657787	40231925	2	3
45649493	1367571	0	0
45645423	19079524	1	1
45659661	1153428	0	0
45673012	1549786	0	0
45698808	1192710	0	0
45627790	791967	0	0
45708224	1548195	0	0
45696183	1112807	0	0
45675071	40228214	2	3
46242985	19008572	2	3
45897378	1177480	0	0
45798069	738818	0	0
46239754	1738521	0	0
46290182	975125	0	0
45796850	1728416	0	0
46313186	1125315	0	0
46301985	42707627	2	3
4145627	196456	1	1
3051542	3027970	2	2
21500138	1548195	1	1
21502571	19129144	2	2
36153536	1125315	0	0
21602496	1519937	1	4
36304850	3023103	2	2
40653762	3019550	1	1
42870592	3002385	1	1
44364110	740275	0	0
44347014	40236446	2	3
44347728	19128009	2	2
45665187	1112807	0	0
44341569	1124300	0	0
45657790	1107882	2	3
45631754	1174888	0	0
45624739	19079524	1	1
45659665	738818	0	0
45673016	1549786	0	0
45698814	1115008	0	0
45628253	1000560	0	0
45708370	1000560	0	0
45696454	1112807	0	0
45779784	19079524	2	3
46242804	40229134	2	3
45895110	1177480	0	0
45798274	738818	0	0
46239526	1149196	0	0
46289920	1174888	0	0
45796734	1149196	0	0
46313127	1125315	0	0
46299709	19008572	2	3
1125448	19029476	1	1
3051542	3016723	2	2
21500140	1519936	1	1
21502571	1595799	2	2
36153536	1119510	0	0
21603458	43012036	1	4
36304850	3015632	2	2
40653836	3009201	1	1
42870592	3007461	1	1
44364134	1549786	0	0
44360994	19018935	2	3
44362687	19128009	2	2
45665020	1112807	0	0
44341570	1149196	0	0
45654379	19018935	2	3
45632048	705944	0	0
45627081	19079524	1	1
45660082	1322184	0	0
45673016	1589505	0	0
45698815	791967	0	0
45628238	1000560	0	0
45708371	1326303	0	0
45696322	1112807	0	0
45699679	40223768	2	3
46242971	19018935	2	3
45895225	1177480	0	0
45798261	738818	0	0
46239701	1539403	0	0
46290275	1551099	0	0
45796903	1500211	0	0
46313131	1125315	0	0
46295715	1115171	2	3
4087571	4295880	1	1
3051542	3035995	2	2
21500140	975125	1	1
21502571	19054876	2	2
36153544	1115008	0	0
21603458	19112599	1	4
36403211	40480160	2	2
40653838	3008598	1	1
42870592	3009542	1	1
44364140	1396131	0	0
44341513	19019273	2	3
44357905	19128009	2	2
45665192	1112807	0	0
44341453	1192710	0	0
45654387	40229134	2	3
45632089	1307863	0	0
45625216	46275916	1	1
45659917	738818	0	0
45673016	19127890	0	0
45698350	1778162	0	0
45628372	1154029	0	0
45708228	1545958	0	0
45693144	1112807	0	0
45675226	19078461	2	3
46242931	40163554	2	3
45894320	1177480	0	0
45798397	738818	0	0
46240251	1589505	0	0
46289942	967823	0	0
45796858	1332418	0	0
46312871	1125315	0	0
46295502	19059056	2	3
442013	4299128	1	1
3051542	3006923	2	2
21500144	1503184	1	1
21502571	19127890	2	2
36153546	1119510	0	0
21603503	19125062	1	4
36302180	4163872	2	2
40653900	3013682	1	1
42870592	3026361	1	1
44364155	933724	0	0
44347251	19019273	2	3
44351995	42902245	2	2
45662482	1112807	0	0
44341107	1107830	0	0
45654390	19075001	2	3
45632172	1738521	0	0
45625279	19079524	1	1
45659974	1551099	0	0
45673028	1115008	0	0
45698521	914335	0	0
45628375	1501700	0	0
45708232	975125	0	0
45693233	1112807	0	0
45687367	19078461	2	3
46243069	40162522	2	3
45894496	1177480	0	0
45798293	738818	0	0
46240262	1174888	0	0
46290237	1124957	0	0
45796981	1124957	0	0
46312877	1125315	0	0
46295421	19074843	2	3
442013	4296205	1	1
3049219	3023430	2	2
21500144	1589505	1	1
21502571	1503184	2	2
36153663	1125315	0	0
21603503	40223834	1	4
36302180	4052083	2	2
40171019	40169216	1	1
42868693	3016723	1	1
44364175	715997	0	0
44354453	19019273	2	3
44357871	40232448	2	3
45662586	1112807	0	0
44341325	1738521	0	0
45654313	40231925	2	3
45632166	1332418	0	0
45668479	46275916	1	1
45660113	1539403	0	0
45673029	1589505	0	0
45698357	1501700	0	0
45628290	1713332	0	0
45708203	1332418	0	0
45693259	1112807	0	0
45783935	19078461	2	3
46242744	1115171	2	3
45894498	1177480	0	0
45795690	738818	0	0
46240241	1343916	0	0
46290173	1549786	0	0
45796749	1551099	0	0
46312928	1125315	0	0
46295704	40232448	2	3
1127524	1127433	1	1
3049219	3005136	2	2
21500144	1548195	1	1
21502571	19127922	2	2
36153672	1129625	0	0
21603503	1107882	1	4
36303152	4010253	2	2
40173589	40173590	1	1
42868693	3013682	1	1
44364178	1107830	0	0
44339811	19019273	2	3
44357909	43012036	2	3
45662501	1112807	0	0
44341330	1115008	0	0
45654243	19077572	2	3
45631861	1124300	0	0
45667190	46275916	1	1
45660066	1115008	0	0
45673030	1501700	0	0
45698744	1149196	0	0
45628290	1759842	0	0
45708337	1115008	0	0
45694890	1112807	0	0
45674953	40223768	2	3
46240720	40229134	2	3
45894461	1177480	0	0
45796925	738818	0	0
45896226	1713332	0	0
46290249	1115008	0	0
45796750	1361711	0	0
46312934	1125315	0	0
46296103	19008572	2	3
1127524	40231925	1	1
3049225	3036780	2	2
21500144	1521369	1	1
21502571	1548195	2	2
36153674	1125315	0	0
21603503	1150837	1	4
36302175	4234705	2	2
37522265	4330583	1	1
42868693	3004501	1	1
44364061	1177480	0	0
44354542	19073183	2	3
44357990	1115171	2	3
45662359	1112807	0	0
44340665	1000560	0	0
45654447	40229134	2	3
45631862	1501700	0	0
45666441	46275916	1	1
45660075	1149196	0	0
45673037	1549786	0	0
45698747	1521369	0	0
45628394	738818	0	0
45778138	1595799	0	0
45693449	1112807	0	0
45690604	19078461	2	3
45799694	19078461	2	3
45803106	1177480	0	0
45792831	738818	0	0
45896226	1759842	0	0
46290212	1545958	0	0
45796818	1549786	0	0
46313223	1125315	0	0
46295984	1127433	2	3
1127524	40162522	1	1
3049225	3023430	2	2
21500144	1595799	1	1
21502571	1515774	2	2
36153689	1129625	0	0
21603503	40223821	1	4
36302175	4181917	2	2
40796088	3014599	3	3
42868769	3024561	1	1
44364071	1174888	0	0
44343548	19075001	2	3
44358114	1115171	2	3
45662513	1112807	0	0
44340668	1717327	0	0
45654506	19078924	2	3
45632191	1589505	0	0
45660798	46275916	1	1
45660135	1110410	0	0
45673037	1521369	0	0
45698747	1548195	0	0
45628408	1153428	0	0
45778138	1308738	0	0
45687677	1112807	0	0
45671741	19078461	2	3
46240081	19078461	2	3
45802969	1177480	0	0
45791978	738818	0	0
45896227	1115008	0	0
46290286	975125	0	0
45796818	1521369	0	0
46313074	1125315	0	0
46296244	35605482	2	3
4178367	4047491	4	5
3049225	3005136	2	2
21500144	19054876	1	1
21502571	1589505	2	2
36153696	1177480	0	0
21603503	1150771	1	4
36313965	4052083	2	2
36303160	4314290	3	3
42868769	3006906	1	1
44364076	1717327	0	0
44361299	19019273	2	3
44358275	40236824	2	3
45662603	1112807	0	0
44340670	1118084	0	0
45654507	19123231	2	3
45631871	1124957	0	0
45658052	46275916	1	1
45660137	1729720	0	0
45673147	1124957	0	0
45697636	1192710	0	0
45628503	1124300	0	0
45777946	967823	0	0
45687537	1112807	0	0
45671787	19078461	2	3
45778285	19078461	2	3
45803289	1177480	0	0
45790243	738818	0	0
45896231	1115008	0	0
46290105	1149196	0	0
45796996	1332418	0	0
46313079	1125315	0	0
46296247	19059056	2	3
4115390	4329847	4	5
3049228	3036780	2	2
21500134	19127890	1	1
21502571	1512674	2	2
36153697	1125315	0	0
21603491	40228214	1	4
36313965	4163951	2	2
36902285	443279	3	3
42868770	3000963	1	1
44364078	1310149	0	0
44343607	19075001	2	3
44358121	19019273	2	3
45662663	1112807	0	0
44340641	1174888	0	0
45654371	19008572	2	3
45631986	1741122	0	0
45654823	19115351	1	1
45660144	1154343	0	0
45673037	19127890	0	0
45697782	1551099	0	0
45628381	1000560	0	0
45778208	1539403	0	0
45687727	1112807	0	0
45782480	19078461	2	3
45694824	19078461	2	3
45803117	1177480	0	0
45790249	738818	0	0
45896257	1738521	0	0
46290321	1501700	0	0
45796907	1332418	0	0
46307535	1125315	0	0
46296184	1115171	2	3
4091532	4285898	4	5
3049228	3023430	2	2
21500134	1515774	1	1
21502571	19133679	2	2
36153762	1107830	0	0
21603491	40228230	1	4
36313965	4195803	2	2
40796119	3002385	3	3
42868771	3016723	1	1
44364212	753626	0	0
44343317	19019273	2	3
44354488	35605482	2	3
45662742	1112807	0	0
44340644	1500211	0	0
45651952	19078461	2	3
45631986	1746114	0	0
45648430	46275916	1	1
45660146	1738521	0	0
45673337	975125	0	0
45697551	791967	0	0
45627848	1107830	0	0
45777957	920293	0	0
45685506	1112807	0	0
45784470	19078461	2	3
45703547	19075001	2	3
45803327	1177480	0	0
45790606	738818	0	0
45896210	1322184	0	0
46290329	1192710	0	0
45796968	1153428	0	0
46307761	1125315	0	0
46295588	19133905	2	3
4172024	4169137	4	5
3049228	3005136	2	2
21500134	19054876	1	1
21502571	1521369	2	2
36153766	1119510	0	0
35502623	4144583	3	4
36214642	40236824	1	2
40796119	3024731	3	3
42709780	44783196	1	1
44364123	1713332	0	0
45619857	40223834	2	3
44354613	35605482	2	3
45662846	1112807	0	0
44340648	1308738	0	0
45652237	19018935	2	3
45631991	1174888	0	0
45648772	19079524	1	1
45660057	1174888	0	0
45673344	1738521	0	0
45697480	723013	0	0
45627841	1153428	0	0
45777937	715997	0	0
45684465	1112807	0	0
45782365	19078461	2	3
45675663	19075001	2	3
45800510	1177480	0	0
45787559	738818	0	0
45896218	1309944	0	0
46289678	1551099	0	0
45796877	1332418	0	0
46307504	1125315	0	0
46295703	19133905	2	3
4172024	442116	4	5
3049249	3036780	2	2
21500134	1548195	1	1
21502571	1549786	2	2
36153771	1112807	0	0
21602858	46275444	3	4
36215230	19023423	1	2
36703477	380378	3	3
42808846	19008572	2	3
44364191	1545958	0	0
45619857	40223821	2	3
44354674	40236824	2	3
45661458	1112807	0	0
44340652	1110410	0	0
45650892	19008572	2	3
45631992	1154029	0	0
45645191	19079524	1	1
45659761	1539403	0	0
45673369	1149196	0	0
45697556	1549786	0	0
45627845	1149196	0	0
45777950	1149196	0	0
45684580	1112807	0	0
45779888	19078461	2	3
45778209	46233710	2	3
45800495	1177480	0	0
45787829	738818	0	0
45896253	1361711	0	0
46290219	1332418	0	0
45796878	975125	0	0
46307863	1125315	0	0
46295703	19133873	2	3
4172024	4102123	4	5
3049249	3023430	2	2
21500144	1515774	1	1
21500270	1545958	2	2
36154120	1125315	0	0
21603446	40229134	3	4
36215361	40220960	1	2
36703534	4001336	3	3
42808448	1115171	2	3
44364302	1149196	0	0
44347070	1545959	2	3
44354413	40236824	2	3
45659703	1112807	0	0
44340671	19003953	0	0
45650982	40162522	2	3
45632003	1501700	0	0
45642595	46275916	1	1
45659860	1115008	0	0
45673417	1322184	0	0
45697599	723013	0	0
45627938	1741122	0	0
45778140	967823	0	0
45681443	1112807	0	0
45674985	19078461	2	3
45778209	46233988	2	3
45800591	1177480	0	0
45787871	738818	0	0
45896284	1539403	0	0
46291928	1501700	0	0
45797002	1000560	0	0
46307864	1125315	0	0
46291236	40223768	2	3
4172024	439406	4	5
3049249	3005136	2	2
21500134	1589505	1	1
21500270	1332418	2	2
36154122	1115008	0	0
21603255	40169281	3	4
36002880	80809	1	2
36702253	4218389	3	3
42809410	1115171	2	3
44364201	1177480	0	0
44357639	1545959	2	3
44354772	40229134	2	3
45656533	1112807	0	0
44340731	1115008	0	0
45650919	19074843	2	3
45632004	1174888	0	0
45642615	19115351	1	1
45659866	1115008	0	0
45673038	1000560	0	0
45697481	1153428	0	0
45627938	1746114	0	0
45778220	1539403	0	0
45681101	1112807	0	0
45672260	19078461	2	3
45789435	19075001	2	3
45800704	1177480	0	0
45786216	738818	0	0
45896285	740275	0	0
46291540	1107830	0	0
45796737	1343916	0	0
46307780	1125315	0	0
46244890	19078461	2	3
4172024	4306014	4	5
3049512	3036780	2	2
21500134	1500211	1	1
21500334	1112807	2	2
36153999	1125315	0	0
35802829	195588	4	4
36224525	46233988	1	2
40796134	3010813	3	3
42807861	1127433	2	3
44364207	1746114	0	0
44361502	1545959	2	3
44354773	920334	2	3
45656534	1112807	0	0
44340743	1110410	0	0
45651160	40228214	2	3
45632006	738818	0	0
45636329	19079524	1	1
45623144	19128009	3	4
45673312	1174888	0	0
45697489	1778162	0	0
45627850	1124300	0	0
45778223	1551099	0	0
45681198	1112807	0	0
45681329	1332419	2	3
45791746	19079524	2	3
45800842	1177480	0	0
45786231	738818	0	0
45896276	19002770	0	0
46291545	1115008	0	0
45797105	1107830	0	0
46307935	1125315	0	0
46239821	40232448	2	3
4172024	438614	4	5
3049512	3023430	2	2
21500134	1521369	1	1
21500334	1119510	2	2
36153713	1124957	0	0
21603550	967823	4	4
36224525	46233710	1	2
40779592	3001247	3	3
42808572	19008572	2	3
44364207	1741122	0	0
44353948	19019273	2	3
44354803	19008572	2	3
45656439	1112807	0	0
44340753	1738521	0	0
45648164	40236824	2	3
45632131	1149196	0	0
45636592	19127922	1	1
45667443	19128009	3	4
45673398	1521369	0	0
45697496	1717327	0	0
45627895	1501700	0	0
45778025	1551099	0	0
45681661	1112807	0	0
45693292	19078461	2	3
46242359	19078461	2	3
45797886	1177480	0	0
45786363	738818	0	0
45896365	1124300	0	0
46291547	1310149	0	0
45796884	1729720	0	0
46307943	1125315	0	0
46240115	40223834	2	3
4172024	4302207	4	5
3049512	3005136	2	2
21500134	1512674	1	1
21500334	1125315	2	2
36153998	1125315	0	0
21603550	1343916	4	4
36224758	40222846	1	2
40779592	3015076	3	3
42804716	19126352	2	3
44364236	791967	0	0
44350410	19075601	2	3
44354695	1713671	2	3
45656617	1112807	0	0
44340757	1310149	0	0
45648173	19077344	2	3
45632139	1102527	0	0
45636592	19133679	1	1
45657003	19127922	3	4
45673101	738818	0	0
45697500	1551099	0	0
45627932	1149196	0	0
45778000	1124957	0	0
45679409	1112807	0	0
45678167	19078461	2	3
45786949	1107882	2	3
45797650	1177480	0	0
46296945	738818	0	0
45896330	1521369	0	0
46292005	1738521	0	0
45797108	967823	0	0
46307446	1125315	0	0
46240057	40232448	2	3
4172024	4048169	4	5
3049537	3036780	2	2
21500134	40221415	1	1
21500334	1129625	2	2
36154201	1738521	0	0
21603550	914335	4	4
36214852	42707627	1	2
40779570	3004501	3	3
42805045	40231925	2	3
44364222	1149380	0	0
44354075	40223768	2	3
44354815	19008572	2	3
45653045	1112807	0	0
44340813	1115008	0	0
45648061	40236824	2	3
45632213	738818	0	0
45636592	19129144	1	1
45638509	19127918	3	4
45671670	1174888	0	0
45697785	1154029	0	0
45627935	1107830	0	0
45778001	1124300	0	0
45678159	1112807	0	0
45699600	19078461	2	3
46291098	1107882	2	3
45795235	1177480	0	0
46297120	738818	0	0
45896439	933724	0	0
46291656	1539403	0	0
45797109	1174888	0	0
46307714	1125315	0	0
45896411	40232448	2	3
4172024	4304110	4	5
3049537	3023430	2	2
21500134	1549786	1	1
21500334	738818	2	2
36153971	1119510	0	0
21603550	1124300	4	4
36221329	19045231	1	2
40796115	3027231	3	3
42802493	1154615	2	3
44364352	740275	0	0
44357564	19075001	2	3
44351039	46275444	2	3
45653202	1112807	0	0
44340758	1124300	0	0
45648270	1115171	2	3
45631875	1717327	0	0
45633559	46275916	1	1
45661465	40223768	2	3
45671664	1713332	0	0
45697316	1332418	0	0
45627976	920293	0	0
45778104	1728416	0	0
45678329	1112807	0	0
45782152	19078461	2	3
45784935	1545959	2	3
45795131	1177480	0	0
46297520	738818	0	0
45896482	1738521	0	0
46241841	1551099	0	0
45796739	1149196	0	0
46307718	1125315	0	0
45896413	1115171	2	3
4103320	4280726	4	5
3049537	3005136	2	2
21500144	19127890	1	1
21500330	1112807	2	2
36154129	1112807	0	0
21603550	975125	4	4
36221330	19045231	1	2
40776230	3028833	3	3
42802591	1551192	2	3
44364245	1192710	0	0
44346926	19073183	2	3
44351164	35605482	2	3
45649962	1112807	0	0
44340778	1729720	0	0
45647865	19059056	2	3
45632019	738818	0	0
45630317	46275916	1	1
45661437	19078461	2	3
45671700	1549786	0	0
45695221	1174888	0	0
45627958	1713332	0	0
45705875	1115008	0	0
45678406	1112807	0	0
45782279	19078461	2	3
45685263	1107882	2	3
45795254	1177480	0	0
46292863	738818	0	0
45896357	1332418	0	0
46241855	705944	0	0
45797015	1154029	0	0
46307620	1125315	0	0
45896554	40229134	2	3
4103320	40486433	4	5
3053269	3023430	2	2
21500144	1512674	1	1
21500334	1192710	2	2
36154129	1125315	0	0
35506542	4144583	4	4
36225993	964261	1	2
36314523	4024958	3	3
42802374	40231925	2	3
44364289	738818	0	0
44357586	1107882	2	3
44351102	19019273	2	3
45650037	1112807	0	0
44340820	1149380	0	0
45648290	1127433	2	3
45632146	1107830	0	0
45631162	19079524	1	1
45661715	40232448	2	3
45671700	1589505	0	0
45695188	1713332	0	0
45676354	1174888	0	0
45705876	1589505	0	0
45674863	1112807	0	0
45672495	19078461	2	3
45673042	1107882	2	3
45795270	1177480	0	0
46293304	738818	0	0
45896357	1545958	0	0
46241859	19127890	0	0
45796893	1149196	0	0
46307627	1125315	0	0
45896418	19019273	2	3
4027384	80809	4	5
3053269	3036780	2	2
21500144	1549786	1	1
21500334	1177480	2	2
36154004	1125315	0	0
21602514	19128009	4	4
36214806	43012036	1	2
40796098	3015632	3	3
42802775	1127433	2	3
44364337	975125	0	0
44357687	1545959	2	3
44351171	19008572	2	3
45646809	1112807	0	0
44340822	1332418	0	0
45648258	1115171	2	3
45632237	1549786	0	0
45627572	46275916	1	1
45661369	19079524	2	3
45671712	1000560	0	0
45695200	1000560	0	0
45676360	1713332	0	0
45705565	1192710	0	0
45675301	1112807	0	0
45699473	19078461	2	3
45694465	1107882	2	3
45795279	1177480	0	0
46296565	738818	0	0
45896268	1153428	0	0
46241859	1549786	0	0
45797016	1713332	0	0
46308128	1125315	0	0
45896419	40223834	2	3
4103183	313217	4	5
3053269	3005136	2	2
21500146	19128263	1	1
21500292	1129625	2	2
36154008	1192710	0	0
35502087	140673	4	4
36214806	19112599	1	2
37119628	45769019	3	3
42802869	46233710	2	3
44364338	1107830	0	0
44357409	1332419	2	3
44351174	19133905	2	3
45646925	1112807	0	0
44340981	738818	0	0
45648252	40232448	2	3
45632237	19127890	0	0
45624599	46275916	1	1
45661727	19073183	2	3
45670025	1778162	0	0
45695206	1149196	0	0
45676362	1738521	0	0
45705566	1149196	0	0
45672057	1112807	0	0
45706079	1127433	2	3
45786733	19075001	2	3
45795301	1177480	0	0
46296728	738818	0	0
45896332	1149196	0	0
46241859	1512674	0	0
45796915	1332418	0	0
46308228	1125315	0	0
45894525	19077572	2	3
4086181	4001336	4	6
3049843	3023430	2	2
21500146	42902245	1	1
21500292	1192710	2	2
36154123	1129625	0	0
21602537	19133679	4	4
36221413	19006318	1	2
36702242	4029498	3	3
42802982	1127433	2	3
44364358	1192710	0	0
44350810	19075601	2	3
44351174	19133873	2	3
45647039	1112807	0	0
44340769	738818	0	0
45648026	19075601	2	3
45632237	1515774	0	0
45624738	46275916	1	1
45661396	46275444	2	3
45670026	1124300	0	0
45695222	1115008	0	0
45676611	1153428	0	0
45705822	1539403	0	0
45672390	1112807	0	0
45706079	19078461	2	3
45800056	1107882	2	3
45792721	1177480	0	0
46288885	738818	0	0
45896396	975125	0	0
46241961	1124957	0	0
45797041	1000560	0	0
46308235	1125315	0	0
45894248	19133905	2	3
4148948	4336464	4	6
3049843	3005136	2	2
21500146	19128022	1	1
21500333	914335	2	2
36154008	1112807	0	0
21602537	19129144	4	4
36224759	40222846	1	2
40779561	3000963	3	3
44355667	40229134	2	3
44356888	1000560	0	0
44348480	19075601	2	3
44351151	19019273	2	3
45647075	1112807	0	0
44340936	1343916	0	0
45644900	40236824	2	3
45632240	1174888	0	0
45668804	46275916	1	1
45660228	19019273	2	3
45669995	1326303	0	0
45695190	1332418	0	0
45676613	1768849	0	0
45705926	1713332	0	0
45672483	1112807	0	0
45699470	19078461	2	3
45673059	1107882	2	3
45792791	1177480	0	0
46291649	738818	0	0
45896342	1309944	0	0
46241967	1332418	0	0
45797058	1521369	0	0
46308266	1125315	0	0
45894171	19133905	2	3
4028902	4010253	4	6
3049843	3036780	2	2
21500137	19127922	1	1
21500333	1192710	2	2
36154124	967823	0	0
21602537	19127922	4	4
36221043	40236446	1	2
40779561	3009542	3	3
44355669	19133905	2	3
44356890	1149380	0	0
44343593	19075601	2	3
44347269	19075001	2	3
45647206	1112807	0	0
44340937	1713332	0	0
45645092	1115171	2	3
45632245	1308738	0	0
45668850	19074679	1	1
45658296	19075601	2	3
45670043	967823	0	0
45695148	757627	0	0
45676638	1322184	0	0
45705932	1501700	0	0
45784360	1112807	0	0
45675089	19078461	2	3
45697261	1107882	2	3
45790070	1177480	0	0
46243599	738818	0	0
45896449	1361711	0	0
46242106	975125	0	0
45797088	1174888	0	0
46307695	1125315	0	0
45894228	40223834	2	3
4027384	440448	4	6
3049861	3036780	2	2
21500137	19133679	1	1
21500341	1119510	2	2
36154024	1177480	0	0
21604180	19002770	4	4
36221423	19133905	1	2
40776231	3013682	3	3
44355670	19008572	2	3
44356905	1149380	0	0
44343330	19075601	2	3
44347396	19133873	2	3
45647090	1112807	0	0
45634281	19078461	2	3
45645115	40232448	2	3
45633986	1738521	0	0
45666974	19079524	1	1
45658090	40223834	2	3
45670153	1326303	0	0
45695153	1308738	0	0
45676615	1107830	0	0
45705936	738818	0	0
45784335	1112807	0	0
45784198	19078461	2	3
45797347	1107882	2	3
45790078	1177480	0	0
46243487	738818	0	0
45896370	791967	0	0
46242017	1149196	0	0
45796897	1310149	0	0
46307917	1125315	0	0
45894355	1115171	2	3
4027384	255848	4	7
3049861	3005136	2	2
21500137	19129144	1	1
21500341	1129625	2	2
36154043	1154343	0	0
21604180	742185	4	4
36221423	19133873	1	2
40776231	3016723	3	3
44355505	40232448	2	3
44356911	1738521	0	0
44361656	19075601	2	3
44347398	19075001	2	3
45646136	1112807	0	0
45634705	42707627	2	3
45645076	19078461	2	3
45634094	1115008	0	0
45664408	46275916	1	1
45704092	40232448	2	3
45670173	1551099	0	0
45695155	1361711	0	0
45676180	1124300	0	0
45705651	1124300	0	0
45786468	1112807	0	0
45779546	19078461	2	3
45802331	1332419	2	3
45789700	1177480	0	0
46243586	738818	0	0
45896435	1153428	0	0
46242020	1115008	0	0
45797019	738818	0	0
46308117	1125315	0	0
45894519	19077572	2	3
4027384	40481087	4	7
3049861	3023430	2	2
21013457	19074679	1	1
21500341	738818	2	2
36154046	1119510	0	0
35802134	4027663	4	4
36221147	19078924	1	2
37119620	45769019	3	3
44355967	1551192	2	3
44357030	757627	0	0
44354434	19075601	2	3
44347528	40163554	2	3
45644096	1112807	0	0
45634760	1115171	2	3
45645287	920334	2	3
45634198	1149196	0	0
45634967	1125315	0	0
45704143	40224132	2	3
45670174	1361711	0	0
45695159	1153428	0	0
45676214	1343916	0	0
45705800	1124957	0	0
45784381	1112807	0	0
45784099	19078461	2	3
45700324	1107882	2	3
45790141	1177480	0	0
46243811	738818	0	0
45896410	1713332	0	0
46241913	1548195	0	0
45797027	738818	0	0
46307908	1125315	0	0
45799936	19078924	2	3
4027384	28060	4	7
3050719	3036780	2	2
21011215	1154615	1	1
21500341	1192710	2	2
36154046	1125315	0	0
35702115	4116491	2	2
36214580	35605858	1	2
40770375	3023103	3	3
44356088	19126352	2	3
44357088	967823	0	0
45620075	19075601	2	3
44347560	19008572	2	3
45644218	1112807	0	0
45634768	40232448	2	3
45645320	40223834	2	3
45628917	1501700	0	0
45635062	1125315	0	0
45703985	40162522	2	3
45670060	1124300	0	0
45695192	740275	0	0
45676249	1107830	0	0
45705593	1545958	0	0
45782329	1112807	0	0
45696172	19078461	2	3
46240219	1107882	2	3
45790233	1177480	0	0
46243772	738818	0	0
45896606	1549786	0	0
46241913	1521369	0	0
45797028	1154343	0	0
46308179	1125315	0	0
46318162	40229134	2	3
4027384	258780	4	9
3050719	3005136	2	2
19010482	19134077	1	1
21500341	1125315	2	2
36154046	738818	0	0
35702115	440448	2	2
36221422	19133873	1	2
40770375	3016723	3	3
42805286	44816277	2	3
44357143	1545958	0	0
44362608	19075601	2	3
44347460	1115171	2	3
45644141	1112807	0	0
45634736	19008572	2	3
45645320	40223821	2	3
45628940	1107830	0	0
45634959	1125315	0	0
45703956	19008572	2	3
45670072	1115008	0	0
45695128	1548195	0	0
45676187	791967	0	0
45705655	967823	0	0
45782434	1112807	0	0
45681427	19078461	2	3
45700222	1107882	2	3
45787440	1177480	0	0
46243838	738818	0	0
45896606	1521369	0	0
46242025	757627	0	0
45797143	1192710	0	0
46308427	1125315	0	0
46318106	40243436	2	3
441840	80809	3	7
3050719	3023430	2	2
21500575	1112807	1	1
21500330	1129625	2	2
36154047	1119510	0	0
36102976	28060	2	2
36221422	19133905	1	2
40770375	3013682	3	3
44348706	19077572	2	3
44357052	1729720	0	0
44361400	19075601	2	3
44347775	19018935	2	3
45641136	1112807	0	0
45634805	1115171	2	3
45645199	19008572	2	3
45628898	1310149	0	0
45635035	1125315	0	0
45704146	19008572	2	3
45670041	1521369	0	0
45695208	1124957	0	0
45676203	1174888	0	0
45705861	975125	0	0
45782595	1112807	0	0
45782074	19078461	2	3
45785370	1107882	2	3
45787451	1177480	0	0
46241412	738818	0	0
45896606	1595799	0	0
46242123	1149196	0	0
45797175	1153428	0	0
46308335	1125315	0	0
46318256	46233710	2	3
441840	196456	3	9
3050752	3005136	2	2
21502687	19074679	1	1
21500330	1125315	2	2
36154047	1125315	0	0
36002139	439406	2	2
36313966	4048171	7	12
37503868	4057420	3	3
44349131	1127433	2	3
44357145	933724	0	0
44347121	19075601	2	3
44343349	19073183	2	3
45643296	1112807	0	0
45634793	19008572	2	3
45645307	40162522	2	3
45628996	1713332	0	0
45634985	1125315	0	0
45703780	40229134	2	3
45670076	723013	0	0
45695210	1000560	0	0
45676272	1332418	0	0
45705820	1332418	0	0
45782489	1112807	0	0
45693407	1332419	2	3
45700254	19078461	2	3
45696803	1129625	0	0
46241313	738818	0	0
45896607	920293	0	0
46242238	1549786	0	0
46318051	738818	0	0
46302527	1125315	0	0
46322526	40223834	2	3
4027384	4280726	5	8
3050752	3036780	2	2
21502534	40171902	1	1
21500330	1192710	2	2
36153271	1119510	0	0
36002139	317009	2	2
36313966	4166224	7	11
37503868	4337611	3	3
44349113	19023398	2	3
44357147	1115008	0	0
45619935	1539411	2	3
44344789	19008572	2	3
45643805	1112807	0	0
45631466	40229134	2	3
45642139	40231925	2	3
45628996	1759842	0	0
45635093	1125315	0	0
45704033	1127433	2	3
45670218	1759842	0	0
45695178	1149196	0	0
45676277	1174888	0	0
45706058	1713332	0	0
45782619	1112807	0	0
45684543	1332419	2	3
45792139	1107882	2	3
45696823	1129625	0	0
46241529	738818	0	0
45896610	1192710	0	0
46242238	19127890	0	0
46317665	1149196	0	0
46302542	1125315	0	0
45794376	1115171	2	3
4027384	40486433	5	8
3050752	3023430	2	2
21500145	19128065	1	1
21500345	738818	2	2
36153271	738818	0	0
36002139	134438	2	2
36313966	378001	7	11
37521802	4057420	3	3
42802751	19019273	2	3
44357240	1107830	0	0
44347147	40228214	2	3
44344790	42707627	2	3
45641353	1112807	0	0
45631649	40232448	2	3
45643039	40232448	2	3
45629017	1310149	0	0
45635096	1125315	0	0
45703904	19018935	2	3
45670218	1713332	0	0
45695214	1124957	0	0
45673503	1149196	0	0
45706058	1759842	0	0
45782675	1112807	0	0
45784490	1332419	2	3
46291776	1107882	2	3
45802689	1129625	0	0
46238795	738818	0	0
45896392	1000560	0	0
46242242	1501700	0	0
46317548	1115008	0	0
46302645	1125315	0	0
45794483	40229134	2	3
4042641	4336464	5	8
3050759	3036780	2	2
21500145	19127918	1	1
21500345	1192710	2	2
36153271	1125315	0	0
36002139	133834	2	2
36313966	4240902	7	8
40779250	3027970	3	3
44355574	19019273	2	3
44357246	1110410	0	0
44343498	40228214	2	3
44344767	40232448	2	3
45638128	1112807	0	0
45631916	40163554	2	3
45643048	40223768	2	3
45628904	1107830	0	0
45635057	1125315	0	0
45651760	40236446	2	3
45670187	1118084	0	0
45695226	1115008	0	0
45673482	1501700	0	0
45705944	1305058	0	0
45702587	1112807	0	0
45696720	1539411	2	3
45688382	19078461	2	3
45802802	1129625	0	0
46238561	738818	0	0
45896523	975125	0	0
46242172	1115008	0	0
46317411	1115008	0	0
46302551	1125315	0	0
45794397	1115171	2	3
4086181	378001	5	7
3050759	3023430	2	2
21500145	19127904	1	1
21500345	1125315	2	2
36153280	1119510	0	0
36102977	4116491	2	2
36313966	37017711	7	8
40779250	3024561	3	3
42816558	40223834	2	3
44356818	1545958	0	0
44777976	40228214	2	3
44343732	1127433	2	3
45638145	1112807	0	0
45631782	40229134	2	3
45643065	40228230	2	3
45628905	1310149	0	0
45635203	1125315	0	0
45651757	19078924	2	3
45670300	1154343	0	0
45695403	1310149	0	0
45624510	1361711	0	0
45706019	1149196	0	0
45702592	1112807	0	0
45681555	1332419	2	3
45785088	1107882	2	3
45802886	1129625	0	0
46238809	738818	0	0
45896611	1192710	0	0
46242178	19003953	0	0
45793897	1000560	0	0
46302582	1125315	0	0
46312314	40162522	2	3
4027384	81893	5	7
3050759	3005136	2	2
19081471	19008572	1	1
21500345	1129625	2	2
36153941	1177480	0	0
36158993	42902245	2	2
36313966	441267	6	7
37522193	4295880	3	3
42802587	40163554	2	3
44357064	1174888	0	0
44362758	19078461	2	3
44343687	40232448	2	3
45638149	1112807	0	0
45628451	40223768	2	3
45643043	19133768	2	3
45628895	715997	0	0
45635381	1125315	0	0
45651522	40232448	2	3
45670111	1545958	0	0
45695375	1539403	0	0
45624732	1343916	0	0
45705905	1124957	0	0
45702643	1112807	0	0
45702561	1332419	2	3
45778049	1332419	2	3
45802696	1129625	0	0
45897657	738818	0	0
45896619	933724	0	0
46241946	1192710	0	0
45793890	1192710	0	0
46302654	1125315	0	0
46312110	1115171	2	3
4042140	80809	5	6
3052062	3036780	2	2
21013430	19074679	1	1
21500345	1119510	2	2
35603355	40243436	0	0
36159540	42902245	2	2
36313966	4302207	6	7
37522193	4197460	3	3
42802496	1545959	2	3
44357065	1177480	0	0
44339983	40228214	2	3
44343823	1594382	2	3
45638052	1112807	0	0
45628746	43012036	2	3
45643021	40229134	2	3
45629060	723013	0	0
45635118	1125315	0	0
45651641	1107882	2	3
45669908	1149196	0	0
45695498	1713332	0	0
45624733	1174888	0	0
45705539	1107830	0	0
45702739	1112807	0	0
45705655	19079524	2	3
46240704	1107882	2	3
45802950	1129625	0	0
45897927	738818	0	0
45893939	1713332	0	0
46242319	975125	0	0
45794004	1149196	0	0
46302576	1125315	0	0
46312329	40229134	2	3
4042140	441267	5	6
3052062	3023430	2	2
21002731	40221415	1	1
21500345	1112807	2	2
36153996	975125	0	0
36202158	4299128	2	2
36313966	4102123	6	7
40792365	3005136	3	3
42805042	46233988	2	3
44357175	19127890	0	0
44351056	40228214	2	3
44343723	40232448	2	3
45638229	1112807	0	0
45628711	35605482	2	3
45643065	40228214	2	3
45629116	1154343	0	0
45629903	1125315	0	0
45651329	40231925	2	3
45669912	1551099	0	0
45695502	1154343	0	0
45624853	914335	0	0
45705540	708298	0	0
45702661	1112807	0	0
45672363	1332419	2	3
45785677	19079524	2	3
45802910	1129625	0	0
45895542	738818	0	0
45893985	1307863	0	0
46242059	1149196	0	0
45794186	1174888	0	0
46303349	1125315	0	0
46312591	40223834	2	3
4042140	134438	5	7
3052062	3005136	2	2
21002731	19127904	1	1
21500356	1192710	2	2
36153963	1112807	0	0
36202158	4296204	2	2
36313966	4304110	6	7
37303809	4113008	3	3
42805042	46233710	2	3
44357175	1549786	0	0
44341455	19078461	2	3
44344038	40229134	2	3
45634855	1112807	0	0
45628625	40165015	2	3
45643121	40232448	2	3
45629141	1115008	0	0
45629962	1125315	0	0
45651341	35605482	2	3
45669985	740275	0	0
45695504	1000560	0	0
45624854	791967	0	0
45705785	1192710	0	0
45702913	1112807	0	0
45687617	1332419	2	3
46240545	19078461	2	3
45800100	1129625	0	0
45896731	738818	0	0
45893991	1713332	0	0
46242114	1107830	0	0
45794187	1115008	0	0
46302856	1125315	0	0
46312752	19133905	2	3
4042140	4116491	5	7
3051724	3036780	2	2
21002731	19127918	1	1
21500355	1174888	2	2
36153639	1177480	0	0
36202158	4296205	2	2
36313966	4169137	6	7
37303809	4155034	3	3
44348866	1539411	2	3
44357184	1112807	0	0
44361401	40223768	2	3
44344041	19008572	2	3
44361752	975125	0	0
45631132	19008572	2	3
45642194	19019273	2	3
45629084	1361711	0	0
45630143	1125315	0	0
45651447	40163554	2	3
45670143	1124957	0	0
45695285	1549786	0	0
45624956	738818	0	0
45705786	1361711	0	0
45696630	1112807	0	0
45672389	1332419	2	3
45786954	40173590	2	3
45800234	1129625	0	0
45679031	1177480	0	0
45893952	1501700	0	0
46242148	1174888	0	0
45794191	1332418	0	0
46302858	1125315	0	0
46306918	19059056	2	3
4042140	4149245	5	9
3051724	3023430	2	2
21002731	42902245	1	1
21500356	1174888	2	2
36153648	1589505	0	0
36198925	42902245	2	2
36313966	4266809	6	9
37303809	4109685	3	3
44355850	19078924	2	3
44357070	1177480	0	0
45619714	19078461	2	3
45643264	19077344	2	3
44361773	975125	0	0
45631023	1107882	2	3
45642185	40229134	2	3
45629045	738818	0	0
45629885	1125315	0	0
45651717	46233988	2	3
45783634	1557272	0	0
45695285	1589505	0	0
45624797	1174888	0	0
45705787	1192710	0	0
45679978	1177480	0	0
45687542	1332419	2	3
45685363	19078461	2	3
45800152	1129625	0	0
45679149	1177480	0	0
45893998	1000560	0	0
46241987	1332418	0	0
45794192	920293	0	0
46302678	1125315	0	0
46307032	40232448	2	3
4042140	321042	5	9
3051724	3005136	2	2
21002731	19128263	1	1
21500356	1119510	2	2
36153651	1119510	0	0
36152230	19128263	2	2
36313966	198199	6	9
37303809	4152936	3	3
42805188	19073183	2	3
44356828	975125	0	0
45619858	19078461	2	3
45643146	40232448	2	3
44361926	975125	0	0
45631066	1539411	2	3
45642253	40231925	2	3
45629159	967823	0	0
45629866	1125315	0	0
45652256	1107882	2	3
45783636	1728416	0	0
45695139	1154343	0	0
45624800	1149196	0	0
45706043	1551099	0	0
45678072	1177480	0	0
45672304	1332419	2	3
45792034	19078461	2	3
45802288	1129625	0	0
45785945	1177480	0	0
45894168	1548195	0	0
46242190	1124300	0	0
45794197	1149196	0	0
46302701	1125315	0	0
46307109	1127433	2	3
4042140	260139	5	9
3053021	3023430	2	2
21002731	19128009	1	1
21500358	1119510	2	2
36153651	1125315	0	0
36152230	19128022	2	2
36313966	81151	6	11
37303809	4296204	3	3
44355845	1107882	2	3
44356992	1110410	0	0
44346869	19078461	2	3
45643448	19073183	2	3
45655954	975125	0	0
45628783	1107882	2	3
45642240	40165015	2	3
45629161	738818	0	0
45629868	1125315	0	0
45652204	1107882	2	3
45783640	1000560	0	0
45695287	1149196	0	0
45624815	1115008	0	0
45705915	1713332	0	0
45677687	1177480	0	0
45702355	1545959	2	3
45777733	1332419	2	3
45797540	1129625	0	0
45786045	1177480	0	0
45893924	1551099	0	0
46242192	975125	0	0
45794021	1729720	0	0
46302816	1125315	0	0
46311831	40222846	2	3
4042140	40481087	5	9
3053021	3005136	2	2
21002731	19128022	1	1
21500358	1192710	2	2
36153654	1112807	0	0
36009773	4048171	2	2
36313966	258780	6	11
40776269	3024561	3	3
42819196	1107882	2	3
44357071	1309944	0	0
44340062	19078461	2	3
45643534	1551192	2	3
45655965	975125	0	0
45628936	19078461	2	3
45642310	1713671	2	3
45629120	791967	0	0
45629908	1125315	0	0
45652089	19008572	2	3
45783714	715997	0	0
45695265	1501700	0	0
45625043	1154343	0	0
45705915	1759842	0	0
45677682	1177480	0	0
45699690	1539411	2	3
45792268	19019273	2	3
45797437	1129625	0	0
45786674	1177480	0	0
45893954	933724	0	0
46242198	1149196	0	0
45794144	933724	0	0
46302743	1125315	0	0
46307380	1127433	2	3
4042140	4278672	5	9
3053021	3036780	2	2
21506042	1332418	3	3
21500358	1174888	2	2
36153654	1125315	0	0
35809406	4027663	2	2
36313966	40481087	6	10
40776269	3026361	3	3
42802474	1332419	2	3
44357122	1738521	0	0
45619741	19078461	2	3
45643190	19073188	2	3
45652632	975125	0	0
45628890	1332419	2	3
45639269	19008572	2	3
45629164	738818	0	0
45630083	1125315	0	0
45651843	40228214	2	3
45783732	791967	0	0
45695321	1124957	0	0
45624963	708298	0	0
45705923	1322184	0	0
45674527	1177480	0	0
45705822	1539411	2	3
45694307	40173590	2	3
45797446	1129625	0	0
46292423	1177480	0	0
45894007	1332418	0	0
46242151	1548195	0	0
45794236	723013	0	0
46302746	1125315	0	0
46307234	1115171	2	3
4042140	4048695	5	9
3052929	3023430	2	2
21506042	1307863	3	3
21500359	1119510	2	2
36153655	1177480	0	0
35708308	81893	2	2
36313966	4278672	6	10
40776269	3007461	3	3
44348628	19078461	2	3
44357287	975125	0	0
44361591	19078461	2	3
45643192	19008572	2	3
45652770	975125	0	0
45625844	1332419	2	3
45639315	1551192	2	3
45628924	1000560	0	0
45630099	1125315	0	0
45697851	40232448	2	3
45783768	738818	0	0
45695410	967823	0	0
45624831	1332418	0	0
45705893	1192710	0	0
45674985	1177480	0	0
45784834	1539411	2	3
45876038	3010813	2	3
45797858	1129625	0	0
46292508	1177480	0	0
45893969	1107830	0	0
46242310	1154029	0	0
45794154	1713332	0	0
46302777	1125315	0	0
46307194	1115171	2	3
4042140	317576	5	9
3052929	3005136	2	2
21500129	19127890	3	3
21500359	1192710	2	2
36153893	1119510	0	0
35702112	441267	2	2
36313966	4149245	6	10
37320089	134438	3	3
42802894	19078461	2	3
44357289	1713332	0	0
44357490	1545959	2	3
45640292	1545959	2	3
45652891	975125	0	0
45625849	19008572	2	3
45638981	1332419	2	3
45629000	1153428	0	0
45630062	1125315	0	0
45700722	19057271	2	3
45783772	1307863	0	0
45695416	738818	0	0
45670283	1153428	0	0
45705901	1396131	0	0
45674807	1177480	0	0
45779769	1539411	2	3
45876038	3000963	2	3
45797178	1129625	0	0
46293178	1177480	0	0
45894144	1713332	0	0
46242326	1154343	0	0
45794810	1548195	0	0
46303039	1125315	0	0
46307364	1115171	2	3
4042140	196456	5	8
3052929	3036780	2	2
21500129	19054876	3	3
21500359	1125315	2	2
36153899	1129625	0	0
35909435	196456	2	2
36313966	4142905	6	10
40779168	3026361	3	3
42805451	19075601	2	3
44357215	1149380	0	0
44346938	1332419	2	3
45640335	19019273	2	3
45652872	975125	0	0
45625921	40232448	2	3
45635777	19076374	2	3
45628958	1548195	0	0
45630023	1125315	0	0
45700715	40232448	2	3
45783723	1137529	0	0
45695255	1124957	0	0
45670324	1115008	0	0
45705838	1713332	0	0
45675164	1177480	0	0
45693599	19078461	2	3
45675678	1332419	2	3
45797312	1129625	0	0
46293245	1177480	0	0
45894144	1759842	0	0
46242328	1332418	0	0
45794546	1332418	0	0
46302903	1125315	0	0
46307969	19059056	2	3
4042140	255848	5	8
3052932	3036780	2	2
21500129	1521369	3	3
21500353	1125315	2	2
36153899	1125315	0	0
35809320	40480160	2	2
36313966	4001336	6	10
40779168	3010813	3	3
42817786	40228214	2	3
44357289	1759842	0	0
44339989	1545959	2	3
45640424	40232448	2	3
45649544	975125	0	0
45625951	40232448	2	3
45636072	40223834	2	3
45629245	1000560	0	0
45630027	1125315	0	0
45648728	1115171	2	3
45783723	1149380	0	0
45695234	967823	0	0
45670575	1115008	0	0
45705839	1115008	0	0
45675089	1177480	0	0
45702920	1539411	2	3
45685527	19078461	2	3
45797219	1129625	0	0
46293198	1177480	0	0
45893910	1307863	0	0
46242146	1729720	0	0
45794751	1500211	0	0
46303185	1125315	0	0
46307305	19077572	2	3
4042140	28060	5	8
3052932	3023430	2	2
21500129	1500211	3	3
21500353	1119510	2	2
36153915	1112807	0	0
35702767	192671	2	2
36313966	4116491	6	8
36919117	440086	3	3
44355873	40228214	2	3
44357290	1177480	0	0
44339966	1539411	2	3
45640415	1551192	2	3
45649550	975125	0	0
45625980	19019273	2	3
45635894	19008572	2	3
45629192	738818	0	0
45630029	1125315	0	0
45648735	1115171	2	3
45783825	738818	0	0
45695269	757627	0	0
45670333	1595799	0	0
45705843	19010482	0	0
45671786	1177480	0	0
45672760	1539411	2	3
45685855	40228214	2	3
45795027	1129625	0	0
46293381	1177480	0	0
45894122	782043	0	0
46242311	1149196	0	0
45794796	705944	0	0
46303295	1125315	0	0
46307215	35605482	2	3
4042140	381316	4	7
3052932	3005136	2	2
21500129	1549786	3	3
21505744	1125315	2	2
36153928	1153428	0	0
35702116	30753	2	2
36313966	4299128	6	6
36919117	378419	3	3
42804941	1332419	2	3
44358904	1322184	0	0
43534937	40174880	2	3
45640546	19008572	2	3
45649862	975125	0	0
45626058	1107882	2	3
45635907	40229134	2	3
45628961	1115008	0	0
45630167	1125315	0	0
45648776	19074843	2	3
45783830	1153428	0	0
45695235	1501700	0	0
45670333	1521369	0	0
45705844	19127890	0	0
45671977	1177480	0	0
45675037	1539411	2	3
46242587	1332419	2	3
45795075	1129625	0	0
46292965	1177480	0	0
45893972	1551099	0	0
46242315	1115008	0	0
45794801	738818	0	0
46303019	1125315	0	0
46307576	1115171	2	3
4042140	4310024	4	8
3052978	3036780	2	2
21500129	40221415	3	3
21505744	1119510	2	2
36153929	1396131	0	0
35702114	192671	2	2
36313966	4094814	5	5
40776264	3009201	3	3
42805156	1332419	2	3
44358905	19127890	0	0
44343426	1539411	2	3
45640381	19008572	2	3
45646554	975125	0	0
45625836	1115171	2	3
45636072	40223821	2	3
45629095	1118084	0	0
45630258	1125315	0	0
45648684	19073183	2	3
45783879	753626	0	0
45695239	1367571	0	0
45670333	1549786	0	0
45705844	1589505	0	0
45671846	1177480	0	0
45688165	1539411	2	3
45782876	19075601	2	3
45792320	1129625	0	0
46288227	1177480	0	0
45894097	1729720	0	0
46242200	1729720	0	0
45794858	715997	0	0
46302992	1125315	0	0
46307495	19077572	2	3
4042140	4283893	4	8
3052978	3023430	2	2
21500129	1589505	3	3
21505749	1192710	2	2
36153323	1119510	0	0
36110584	258780	2	2
36313966	440086	5	7
37521809	4323902	3	3
42805212	1332419	2	3
44358905	1589505	0	0
43530807	4219399	4	4
45640757	19133768	2	3
45640875	975125	0	0
45626070	1107882	2	3
45635911	40232448	2	3
45629097	967823	0	0
45630172	1125315	0	0
45648686	19008572	2	3
45783910	1000560	0	0
45695339	1110410	0	0
45670416	1539403	0	0
45705844	1549786	0	0
45671787	1177480	0	0
45706099	19128009	1	2
45780494	19075601	2	3
45792500	1129625	0	0
46288109	1177480	0	0
45894062	1115008	0	0
46242203	1192710	0	0
45794752	1149196	0	0
46303473	1125315	0	0
46302194	40236824	2	3
4042140	195588	4	9
3052978	3005136	2	2
21500129	1548195	3	3
21505749	1125315	2	2
36153328	1115008	0	0
36110736	198199	2	2
36313966	80502	5	7
37503861	44783196	3	3
42848776	42902245	2	2
44358905	1549786	0	0
43530807	433644	4	4
45640757	40162522	2	3
45640637	975125	0	0
45625839	19018935	2	3
45636223	1551192	2	3
45629106	1332418	0	0
45630176	1125315	0	0
45648750	19019273	2	3
45783746	1521369	0	0
45695340	1124300	0	0
45670474	1551099	0	0
45705972	1310149	0	0
45671741	1177480	0	0
45694152	19128263	1	2
45680928	19078461	2	3
45789536	1129625	0	0
46288399	1177480	0	0
45894155	975125	0	0
46242267	1322184	0	0
45794270	1545958	0	0
46303236	1125315	0	0
46301878	1551192	2	3
4042140	192671	4	6
3052983	3023430	2	2
21500129	1512674	3	3
21506108	1332418	2	2
36154131	1125315	0	0
36110736	4056621	2	2
36313966	140673	5	7
37503861	4301346	3	3
42870592	3010813	2	2
44358910	1192710	0	0
43530807	4240902	4	4
45640758	19075601	2	3
45637612	975125	0	0
45626031	19008572	2	3
45636009	19078924	2	3
45629208	1000560	0	0
45630335	1125315	0	0
45648612	40223834	2	3
45783748	705944	0	0
45695364	1545958	0	0
45670616	1149196	0	0
45705977	967823	0	0
45672260	1177480	0	0
45706783	975125	0	0
45799961	40223768	2	3
45789969	1129625	0	0
46288500	1177480	0	0
45894156	1551099	0	0
46242046	1000560	0	0
45794276	1717327	0	0
46300280	1125315	0	0
46302358	40236824	2	3
4042140	80502	4	6
3052983	3005136	2	2
21500594	1177480	3	3
21500007	1759842	2	2
36154131	1129625	0	0
36110704	40486433	2	2
36313966	4283893	5	9
37520918	4117038	3	3
42868693	3015632	2	2
44358912	1115008	0	0
43530807	37017711	4	4
45640771	40223834	2	3
45637891	975125	0	0
45626033	19133768	2	3
45635924	19133768	2	3
45629284	1124300	0	0
45630353	1125315	0	0
45648848	19019273	2	3
45783759	1713332	0	0
45695371	738818	0	0
45670618	1107830	0	0
45705980	1118084	0	0
45783899	1177480	0	0
45706626	1545958	0	0
46240742	19075601	2	3
45789797	1129625	0	0
46244856	1177480	0	0
45894163	1738521	0	0
45893597	1309944	0	0
45794305	1149196	0	0
46300293	1125315	0	0
46302361	920334	2	3
4042140	4329847	4	10
3052983	3036780	2	2
21500594	1115008	3	3
21500007	1746114	2	2
36154133	1125315	0	0
36110704	4280726	2	2
36313966	4310024	5	9
37520918	4330583	3	3
42868693	3014576	2	2
44358914	1717327	0	0
43530897	4139681	4	4
45640772	1551192	2	3
45634667	975125	0	0
45626083	1551192	2	3
45633007	19078924	2	3
45629261	723013	0	0
45630354	1125315	0	0
45648853	19133768	2	3
45783867	1115008	0	0
45695390	1549786	0	0
45670619	1107830	0	0
45705991	1149196	0	0
45783935	1177480	0	0
45706856	967823	0	0
46244924	19075601	2	3
45789964	1129625	0	0
46244705	1177480	0	0
45894164	933724	0	0
45893599	1713332	0	0
45794311	1713332	0	0
46300368	1125315	0	0
46302306	40232448	2	3
4029205	4015189	4	7
3016782	3020630	2	2
21502522	914335	3	3
21500007	1728416	2	2
36154134	1119510	0	0
36110708	4294548	2	2
36313966	4056621	5	9
37520918	4242997	3	3
42868693	3023103	2	2
44358820	1177480	0	0
43530897	4302207	4	4
45637475	40232448	2	3
45634736	975125	0	0
45622618	19078924	2	3
45632772	40232448	2	3
45629316	738818	0	0
45630184	1125315	0	0
45648612	40223821	2	3
45783871	1551099	0	0
45691995	1738521	0	0
45670632	1501700	0	0
45705992	975125	0	0
45784043	1177480	0	0
45706701	975125	0	0
46242610	19078461	2	3
45789087	1129625	0	0
46243418	1177480	0	0
45798573	1112807	0	0
45893599	1759842	0	0
45794333	1539403	0	0
46300301	1125315	0	0
46302027	46221626	2	3
4029205	4337138	4	6
3016782	3027970	2	2
21502522	920293	3	3
21500007	1713332	2	2
36154135	1129625	0	0
36110712	260139	2	2
36313966	4109685	5	9
40772935	3020630	3	3
42868693	3019550	2	2
44358948	19127890	0	0
43530897	438614	4	4
45637170	40243436	2	3
45634446	975125	0	0
45622649	43012036	2	3
45632949	19077344	2	3
45629341	1396131	0	0
45630424	1125315	0	0
45648795	19078461	2	3
45783873	975125	0	0
45691996	1738521	0	0
45670683	1107830	0	0
45705997	967823	0	0
45784099	1177480	0	0
45706703	1124957	0	0
45794961	19078461	2	3
45789156	1129625	0	0
46242301	1177480	0	0
45798472	1112807	0	0
45893629	1174888	0	0
45794349	1728416	0	0
46300306	1125315	0	0
46302126	40236824	2	3
4029205	44783196	4	6
1521405	19127922	2	2
21502522	933724	3	3
21500007	1741122	2	2
36154135	1125315	0	0
36110715	40481087	2	2
36313966	4113008	5	8
37320108	134438	2	3
42868693	3045716	2	2
44358948	1521369	0	0
43530897	442116	4	4
45637110	19075601	2	3
45634793	975125	0	0
45622845	40236824	2	3
45632989	40232448	2	3
45629393	1124957	0	0
45630389	1125315	0	0
45648629	19074843	2	3
45783853	705944	0	0
45692004	1367571	0	0
45670595	1713332	0	0
45706002	738818	0	0
45784057	1177480	0	0
45706858	1115008	0	0
46244871	1539411	2	3
45787036	1129625	0	0
46241146	1177480	0	0
45798442	1112807	0	0
45893698	791967	0	0
45794282	738818	0	0
46300387	1125315	0	0
46302387	40228230	2	3
4029205	4197460	5	6
1521405	19133679	2	2
21500136	1595799	3	3
21500007	1717327	2	2
36154139	1115008	0	0
36111056	4112343	2	2
36313966	372328	5	8
36422768	40243436	2	3
44349077	19128009	2	2
44358948	1549786	0	0
43530897	4102123	4	4
45637432	1115171	2	3
45631727	975125	0	0
45622390	1127433	2	3
45632996	40231925	2	3
45629272	1367571	0	0
45627087	1125315	0	0
45649131	43012036	2	3
45783796	933724	0	0
45692203	1308738	0	0
45670605	1149196	0	0
45703704	1500211	0	0
45784294	1177480	0	0
45706862	1521369	0	0
45679189	1539411	2	3
45787010	1129625	0	0
46241386	1177480	0	0
45798563	1112807	0	0
45893650	1149196	0	0
45794284	740275	0	0
46300313	1125315	0	0
46302389	40162522	2	3
4029205	4238715	5	6
1521405	19129144	2	2
21500136	19054876	3	3
21604792	701322	2	2
36154141	1125315	0	0
36152003	19074843	2	3
36313966	4155034	5	8
36422742	1545959	2	3
42802692	19128009	2	2
44358821	1713332	0	0
43530897	4048169	4	4
45637491	1551192	2	3
45628596	975125	0	0
45622406	40229134	2	3
45633991	40236446	2	3
45629273	1107830	0	0
45627185	1125315	0	0
45645996	40229134	2	3
45783803	738818	0	0
45692011	1115008	0	0
45670721	1110410	0	0
45703709	1000560	0	0
45782074	1177480	0	0
45706862	1548195	0	0
46243041	19075601	2	3
45787046	1129625	0	0
46238467	1177480	0	0
45793476	1112807	0	0
45893676	1307863	0	0
45794288	1124300	0	0
46300474	1125315	0	0
46302464	1127433	2	3
4029205	4057420	5	8
440921	4094814	2	2
21500136	1521369	3	3
21604182	19078219	2	2
36153616	1125315	0	0
36151288	19019273	2	3
36313966	195588	5	10
36903633	378419	2	3
42802692	19127918	2	2
44358821	1759842	0	0
43530897	4304110	4	4
45637517	920300	2	3
45628770	975125	0	0
45622661	19019273	2	3
45642076	19075001	2	3
45627958	1759842	0	0
45627186	1125315	0	0
45646107	19078461	2	3
45783977	1149196	0	0
45692013	1149380	0	0
45670644	1512674	0	0
45703742	1154343	0	0
45782065	1177480	0	0
45706769	1192710	0	0
45672905	19078461	2	3
45787133	1129625	0	0
46238468	1177480	0	0
45793295	1112807	0	0
45893732	1332418	0	0
45794424	933724	0	0
46300480	1125315	0	0
46306891	40162522	2	3
4029205	4108705	5	7
1332418	1332419	2	3
21500136	1500211	3	3
21604182	19039298	2	2
36154150	1713332	0	0
36151808	40236446	2	3
36313966	260139	5	10
37002286	195588	2	3
44358988	1539403	0	0
44358952	1107830	0	0
43530897	4169137	4	4
45639825	19077344	2	3
45631132	975125	0	0
45622723	40229134	2	3
45663382	19075001	2	3
45628071	933724	0	0
45627191	1125315	0	0
45646235	1107882	2	3
45783989	738818	0	0
45691785	1115008	0	0
45670644	1548195	0	0
45703743	920293	0	0
45782152	1177480	0	0
45705270	1124300	0	0
45789421	40223768	2	3
45787172	1129625	0	0
46238471	1177480	0	0
45793297	1112807	0	0
45893635	791967	0	0
45794337	1107830	0	0
46300511	1125315	0	0
46306809	19129655	2	3
4029205	4337611	5	7
1149380	40169216	2	3
21500136	19127922	3	3
21604182	19002770	2	2
36154183	1192710	0	0
36158967	1551192	2	3
36313966	261325	5	10
37303797	133834	1	3
44359115	1177480	0	0
44358904	1112807	0	0
43530897	4306014	4	4
45639997	40228214	2	3
45625849	975125	0	0
45622736	19019273	2	3
45641626	19073183	2	3
45628007	1115008	0	0
45627107	1125315	0	0
45645589	1127433	2	3
45781454	705944	0	0
45692066	1539403	0	0
45670348	914335	0	0
45703863	1124300	0	0
45782142	1177480	0	0
45705281	1548195	0	0
45794940	19075601	2	3
45787333	1129625	0	0
46238387	1177480	0	0
45793392	1112807	0	0
45893736	1548195	0	0
45794293	975125	0	0
46300735	1125315	0	0
46306854	40232448	2	3
4040390	4186930	5	6
1149380	40169281	2	3
21500136	1503184	3	3
21604182	782043	2	2
36154186	1129625	0	0
36102976	40481087	2	3
36313966	4329847	5	11
36241494	19029476	1	2
44359123	738818	0	0
44358956	1149196	0	0
43530897	439406	4	4
45634051	1127433	2	3
45626031	975125	0	0
45622817	19008572	2	3
45658547	19073183	2	3
45628123	967823	0	0
45627109	1125315	0	0
45645886	1127433	2	3
45781568	19039298	0	0
45692224	1192710	0	0
45670493	967823	0	0
45703873	791967	0	0
45782010	1177480	0	0
45705283	1110410	0	0
45682439	19078461	2	3
45785602	1129625	0	0
46238777	1177480	0	0
45793153	1112807	0	0
45893705	933724	0	0
45794428	1557272	0	0
46300636	1125315	0	0
46306311	1127433	2	3
4040390	4057420	5	5
1729720	19133873	2	3
21500136	1518198	3	3
21604182	19059528	2	2
36154187	1192710	0	0
36158865	19008572	2	3
36313966	133834	8	10
37502354	4216130	2	2
44359130	1129625	0	0
44359054	1107830	0	0
43530897	37017711	5	5
45634398	40231925	2	3
45622700	975125	0	0
45623045	19008572	2	3
45639241	19075001	2	3
45628277	1549786	0	0
45627366	1125315	0	0
45645607	43012036	2	3
45781597	920293	0	0
45692279	791967	0	0
45670458	1149196	0	0
45703755	1153428	0	0
45782187	1177480	0	0
45705214	1343916	0	0
45802538	40228214	2	3
45785856	1129625	0	0
45897430	1177480	0	0
45793252	1112807	0	0
45893700	1738521	0	0
45791569	1124300	0	0
46300807	1125315	0	0
46306256	40231925	2	3
4040390	4078793	5	5
1729720	19133905	2	3
21500136	19127890	3	3
21602099	1149380	2	2
36154189	791967	0	0
36158843	19125062	2	3
36313966	40479768	8	11
36703533	4066995	2	2
44358995	1129625	0	0
44358638	1177480	0	0
43530897	4219399	5	5
45634123	43012036	2	3
45622817	975125	0	0
45622957	1154615	2	3
45627162	19078461	2	3
45628278	738818	0	0
45627375	1125315	0	0
45642677	1115171	2	3
45781710	1548195	0	0
45692281	1309944	0	0
45670384	1343916	0	0
45702248	1124957	0	0
45779768	1177480	0	0
45705181	708298	0	0
45797367	40223768	2	3
45785611	1129625	0	0
45897433	1177480	0	0
45793258	1112807	0	0
45893713	1000560	0	0
45791453	738818	0	0
46300429	1125315	0	0
46306901	40163554	2	3
4040390	4058899	5	7
1149196	40228230	2	3
21500136	1515774	3	3
21502573	40224805	2	3
36154191	1125315	0	0
36158968	19125062	2	3
36313966	4134304	8	12
36703534	4132546	2	2
44358996	1192710	0	0
44359023	1738521	0	0
43530897	4240902	5	5
45634313	1127433	2	3
45623045	975125	0	0
45622973	19073183	2	3
45632666	40228214	2	3
45626200	738818	0	0
45627377	1125315	0	0
45642719	19008572	2	3
45781298	1115008	0	0
45692191	1000560	0	0
45670291	1557272	0	0
45702282	1107830	0	0
45779546	1177480	0	0
45705242	1115008	0	0
45786535	40228214	2	3
45785613	1129625	0	0
45897456	1177480	0	0
45794492	1112807	0	0
45893755	1713332	0	0
45791456	1174888	0	0
46300598	1125315	0	0
46306336	1551192	2	3
4040390	4336464	6	9
1149196	40228214	2	3
21500136	1589505	3	3
21502573	40224132	2	3
36154191	738818	0	0
36158796	40232448	2	3
36313966	317009	4	5
40770464	3024561	2	2
44358997	1129625	0	0
44359055	708298	0	0
43530897	433644	5	5
45634456	40232448	2	3
45622956	975125	0	0
45621021	1332419	2	3
45639252	1107882	2	3
45626151	723013	0	0
45627126	1125315	0	0
45642844	19008572	2	3
45781301	1115008	0	0
45692324	1595799	0	0
45670298	1713332	0	0
45702346	1310149	0	0
45779980	1177480	0	0
45705191	1192710	0	0
45685266	40228214	2	3
45785657	1129625	0	0
45897512	1177480	0	0
45787843	1112807	0	0
45893755	1759842	0	0
45791295	1124957	0	0
46300569	1125315	0	0
46299663	1127433	2	3
4040390	4117038	6	7
1137529	40169281	2	3
21500136	43012433	3	3
21502575	1519937	2	3
36154191	1119510	0	0
36158821	1115171	2	3
36313966	4027663	4	8
40770464	3000963	2	2
44358755	1115008	0	0
44358841	1177480	0	0
43530897	4174876	3	3
45634585	1127433	2	3
45623183	975125	0	0
45620878	19078461	2	3
45647353	1332419	2	3
45626153	1778162	0	0
45627150	1125315	0	0
45642817	19019273	2	3
45781305	1125443	0	0
45692185	1545958	0	0
45670359	1738521	0	0
45702352	1307863	0	0
45779888	1177480	0	0
45705200	791967	0	0
46240350	40228214	2	3
45785669	1129625	0	0
45897520	1177480	0	0
45787918	1112807	0	0
45893760	975125	0	0
45791380	1107830	0	0
46300826	1125315	0	0
46299676	1127433	2	3
4040390	4047491	6	7
740275	19074679	2	3
21500136	1519936	3	3
21503951	19023398	2	3
36154193	1119510	0	0
36158800	1551192	2	3
36313966	317576	4	10
40770464	3016723	2	2
44358891	920293	0	0
44359037	715997	0	0
43530807	4306014	3	3
45634430	19008572	2	3
45621126	975125	0	0
45621269	1115171	2	3
45647555	1107882	2	3
45626170	1310149	0	0
45627363	1125315	0	0
45642832	19008572	2	3
45781816	1174888	0	0
45692363	1174888	0	0
45670095	1501700	0	0
45702244	1154029	0	0
45779924	1177480	0	0
45705208	1174888	0	0
45703253	40174880	2	3
45785694	1129625	0	0
45897644	1177480	0	0
45788146	1112807	0	0
45893729	1174888	0	0
45791381	1149196	0	0
46300829	1125315	0	0
46299726	19077344	2	3
4040390	4242997	6	6
1738521	46233988	2	3
21500136	19133679	3	3
21503951	782047	2	3
36154193	1125315	0	0
36158804	40232448	2	3
36313966	4237458	4	10
36423637	19010482	0	0
44359113	1112807	0	0
44359057	1332418	0	0
43530807	442116	3	3
45634276	40231925	2	3
45621955	975125	0	0
45621126	19008572	2	3
45623977	19073183	2	3
45626132	1124957	0	0
45627539	1125315	0	0
45688685	19078461	2	3
45781817	933724	0	0
45692372	1361711	0	0
45670459	1110410	0	0
45702245	791967	0	0
45708041	1177480	0	0
45705259	1539403	0	0
45802567	19079524	2	3
45785955	1129625	0	0
45895395	1177480	0	0
45788055	1112807	0	0
45893768	1115008	0	0
45791370	1728416	0	0
46300852	1125315	0	0
46299777	19059056	2	3
4040390	40492359	6	6
926487	19045231	2	3
21500136	1548195	3	3
21002075	46275444	2	3
36153954	1177480	0	0
36159148	40232448	2	3
36313966	4066995	4	10
36463150	1119510	0	0
44359317	933724	0	0
44358736	1729720	0	0
43530807	4102123	3	3
45634526	40229134	2	3
45664836	975125	0	0
45621296	1115171	2	3
45635923	1107882	2	3
45626187	1361711	0	0
45623707	1125315	0	0
45688381	19079524	2	3
45781535	701322	0	0
45692284	1124957	0	0
45670433	1000560	0	0
45702321	975125	0	0
45708184	1177480	0	0
45705253	1307863	0	0
46243040	19079524	2	3
46296258	1129625	0	0
45895410	1177480	0	0
45788198	1112807	0	0
45893744	933724	0	0
45791509	740275	0	0
46300854	1125315	0	0
46291258	19079524	1	1
4040390	4170947	4	4
757627	19077572	2	3
21500136	1549786	3	3
21002077	46275444	2	3
36154199	1129625	0	0
36159229	40232448	2	3
36313966	40480160	4	10
36463158	1129625	0	0
44359320	1115008	0	0
44358751	738818	0	0
43530807	4302207	3	3
45634363	19018935	2	3
45665122	975125	0	0
45621307	40174880	2	3
45663649	1107882	2	3
45626189	1107830	0	0
45623896	1125315	0	0
45688471	40163554	2	3
45781289	1174888	0	0
45683734	1119510	0	0
45670367	967823	0	0
45702267	1124957	0	0
45708362	1177480	0	0
45705162	1149196	0	0
45697646	40228214	2	3
46296263	1129625	0	0
45895405	1177480	0	0
45788280	1112807	0	0
45893781	1738521	0	0
45791468	1124300	0	0
46300911	1125315	0	0
46270317	4237458	1	1
4040390	4181917	4	4
1322184	19075601	2	3
21500136	975125	3	3
21002068	46275444	2	3
36153617	1125315	0	0
36159130	40229134	2	3
36313966	4029498	4	7
36463158	1125315	0	0
44359077	1177480	0	0
44357299	1713332	0	0
43530807	4169137	3	3
45634621	40236824	2	3
45664946	975125	0	0
45621823	1107882	2	3
45628061	19078461	2	3
45626222	1115008	0	0
45623900	1125315	0	0
45691232	40223768	2	3
45781631	967823	0	0
45683834	1119510	0	0
45669036	1307863	0	0
45702354	920293	0	0
45778115	1177480	0	0
45780013	1174888	0	0
45799825	19078461	2	3
46292033	1129625	0	0
45895528	1177480	0	0
46293937	1112807	0	0
45893879	1717327	0	0
45791709	738818	0	0
46300916	1125315	0	0
45802374	19115351	1	1
4040390	4199276	4	4
738818	40229134	2	3
21500136	19129144	3	3
21002069	46275444	2	3
36153617	1112807	0	0
36159139	1115171	2	3
36313966	44782520	4	7
36463159	1154343	0	0
44359321	1129625	0	0
44357299	1759842	0	0
43530807	438614	3	3
45634689	42707627	2	3
45665194	975125	0	0
45622168	19073183	2	3
45637032	1107882	2	3
45626216	1102527	0	0
45625135	1125315	0	0
45639813	19008572	2	3
45781636	738818	0	0
45683770	1119510	0	0
45669039	1149380	0	0
45702326	1115008	0	0
45706079	1177480	0	0
45780017	1713332	0	0
45794876	40223768	2	3
46292089	1129625	0	0
45895245	1177480	0	0
46293893	1112807	0	0
45894165	1115008	0	0
45791684	1174888	0	0
46301016	1125315	0	0
46312099	19079524	1	1
4040390	44783196	4	7
1746114	46275444	2	3
21500136	1512674	3	3
21002072	46275444	2	3
36153619	1129625	0	0
35702120	4027663	2	3
36313966	4043241	3	12
36463290	1125315	0	0
44359068	1515774	0	0
44357364	1717327	0	0
43530807	439406	3	3
45631091	40229134	2	3
45665275	975125	0	0
45621732	40163554	2	3
45647822	1107882	2	3
45626347	723013	0	0
45625211	1125315	0	0
45639634	1551192	2	3
45781728	1308738	0	0
45683857	1119510	0	0
45669045	1107830	0	0
45702327	1501700	0	0
45705538	1177480	0	0
45779963	1000560	0	0
45896849	19078461	2	3
46292094	1129625	0	0
45803293	1177480	0	0
46294064	1112807	0	0
45893897	19003953	0	0
45791601	1124300	0	0
46301018	1125315	0	0
46300050	46275916	1	1
4040390	4337611	4	7
1124957	40231925	2	3
21500575	19059056	3	4
21604795	45892894	2	3
36153619	1125315	0	0
36159049	1115171	2	3
36313966	4084167	3	6
36463291	975125	0	0
44359068	1549786	0	0
44357400	1729720	0	0
43530807	4048169	3	3
45633826	1115171	2	3
45665284	975125	0	0
45664836	19008572	2	3
45654255	1107882	2	3
45626261	1728416	0	0
45625178	1125315	0	0
45639919	19133768	2	3
45781730	1149196	0	0
45683863	1119510	0	0
45669056	1539403	0	0
45702561	1332418	0	0
45705955	1177480	0	0
45779988	1501700	0	0
45797412	19078461	2	3
46292299	1129625	0	0
45803349	1177480	0	0
46294123	1112807	0	0
45893809	1549786	0	0
45791597	1500211	0	0
46301127	1125315	0	0
46318333	46275916	1	1
4040390	4108705	4	7
753626	40220386	2	3
21500140	1519937	3	4
21604799	45892894	2	3
36153620	1119510	0	0
36159054	43012036	2	3
36313966	80809	3	7
36463200	1738521	0	0
44359253	738818	0	0
44357327	1545958	0	0
43530807	4139681	3	3
45631426	19073183	2	3
45664959	975125	0	0
45664896	40232448	2	3
45642346	40228214	2	3
45626343	1738521	0	0
45625180	1125315	0	0
45639670	1107882	2	3
45781537	1343916	0	0
45683889	1119510	0	0
45669091	1501700	0	0
45702355	1545958	0	0
45705728	1177480	0	0
45780167	1115008	0	0
45794637	1539411	2	3
46292326	1129625	0	0
45803475	1177480	0	0
46294219	1112807	0	0
45893809	1515774	0	0
45791554	738818	0	0
46319195	1125315	0	0
46303090	1115171	2	3
4040390	4216130	4	7
742185	19123231	2	3
21500138	40224132	3	4
21602860	46275444	2	3
36153847	1125315	0	0
36159418	1127433	2	3
36313966	196456	3	9
36463216	1125315	0	0
44359257	1149380	0	0
44357324	1153428	0	0
43530807	4304110	3	3
45631395	19019273	2	3
45662166	975125	0	0
45665081	40174880	2	3
45657678	1107882	2	3
45626394	1149196	0	0
45625182	1125315	0	0
45639843	1127433	2	3
45781539	1501700	0	0
45683890	1119510	0	0
45669026	1310149	0	0
45702268	1153428	0	0
45706006	1177480	0	0
45779682	1332418	0	0
45679441	40223768	2	3
46292451	1129625	0	0
45800902	1177480	0	0
46294448	1112807	0	0
45893843	1115008	0	0
45791656	1110410	0	0
46319219	1125315	0	0
46303311	1115171	2	3
4040390	4323902	4	7
1326303	19018935	2	3
21500138	40224805	3	4
21003263	40236824	2	3
36154200	1112807	0	0
36159545	40236824	2	3
36313966	134438	3	8
36463297	1332418	0	0
37100000	4056621	6	7
44357464	975125	0	0
43531053	45769019	3	3
45631500	19059056	2	3
45662509	975125	0	0
45664940	40223834	2	3
45626977	1545959	2	3
45626328	1124957	0	0
45625245	1125315	0	0
45639892	1115171	2	3
45781737	1713332	0	0
45683897	1119510	0	0
45669051	1713332	0	0
45702270	1174888	0	0
45703694	1177480	0	0
45780060	1501700	0	0
45697166	40223768	2	3
46292394	1129625	0	0
45800677	1177480	0	0
46243852	1112807	0	0
45893904	715997	0	0
45791697	1124957	0	0
46319097	1125315	0	0
46303437	46233710	2	3
4040390	4238715	4	5
1741122	46275444	2	3
21500578	1127078	3	4
21604152	40173590	2	3
36154157	1118084	0	0
36159597	40162522	2	3
36313966	192671	2	7
36463337	1545958	0	0
42802224	19128009	2	2
44357467	1124300	0	0
43531052	196456	4	4
45631610	19073183	2	3
45662318	975125	0	0
45665226	1107882	2	3
45628073	40228214	2	3
45626330	1738521	0	0
45625248	1125315	0	0
45639827	40236446	2	3
45781545	1174888	0	0
45683933	1119510	0	0
45669051	1759842	0	0
45702390	920293	0	0
45703615	1177480	0	0
45779899	1539403	0	0
45700468	19078461	2	3
46292607	1129625	0	0
45798184	1177480	0	0
46243857	1112807	0	0
45893831	1115008	0	0
45791698	1741122	0	0
46319285	1125315	0	0
46303115	40162522	2	3
4040390	44805732	4	5
933724	40236824	2	3
21012458	836654	0	0
21503925	19019273	2	3
36153848	1129625	0	0
36203042	40480160	2	3
36302170	4163872	4	7
36463252	1115008	0	0
42802224	19127918	2	2
44357471	723013	0	0
43531052	4266809	4	4
45628570	40232448	2	3
45662677	975125	0	0
45664954	1127433	2	3
45639339	1107882	2	3
45626333	1115008	0	0
45625201	1125315	0	0
45640122	19073183	2	3
45781546	738818	0	0
45683971	1119510	0	0
45669053	1549786	0	0
45702299	1548195	0	0
45702307	1177480	0	0
45780127	782043	0	0
45679365	19078461	2	3
46287942	1129625	0	0
45798278	1177480	0	0
46244731	1112807	0	0
45801715	1154343	0	0
45791698	1746114	0	0
46319065	1125315	0	0
46303377	1115171	2	3
4040390	4202451	4	5
3050951	3019550	2	3
21506167	1177480	0	0
21005779	1551192	2	3
36153856	1112807	0	0
36151279	46275444	2	3
36302170	4163951	4	4
36463329	1545958	0	0
40490903	4199276	2	2
44353630	1112807	0	0
43530815	4152936	3	5
45628539	40232448	2	3
45662735	975125	0	0
45665197	1127433	2	3
45657576	1107882	2	3
45626461	753626	0	0
45625144	1125315	0	0
45685697	19008572	2	3
45781837	1115008	0	0
45683978	1119510	0	0
45669074	1521369	0	0
45702302	1149380	0	0
45702376	1177480	0	0
45779779	1174888	0	0
45786666	19078461	2	3
46287985	1129625	0	0
45798423	1177480	0	0
46244787	1112807	0	0
45801687	1738521	0	0
45791511	1107830	0	0
46319076	1125315	0	0
45801237	40229134	2	3
4040390	4330583	4	8
3050951	3023103	2	3
21506125	740275	0	0
21500363	1154615	2	3
36153868	1125315	0	0
36152284	40229134	2	3
36302170	4202451	5	8
36463307	1125315	0	0
40490903	4059978	2	2
44353633	1149380	0	0
43530815	4059173	3	5
45628351	1551192	2	3
45662921	975125	0	0
45665145	19133905	2	3
45629620	1107882	2	3
45626464	1149196	0	0
45625215	1125315	0	0
45685829	40229134	2	3
45781844	914335	0	0
45683962	1119510	0	0
45669074	19127890	0	0
45702359	1110410	0	0
45699386	1177480	0	0
45780076	1545958	0	0
45784880	40223768	2	3
46288115	1129625	0	0
45798315	1177480	0	0
46244823	1112807	0	0
45801736	1153428	0	0
45791614	920293	0	0
46319115	1125315	0	0
45801231	1539411	2	3
4040390	4301346	4	8
3050951	3014576	2	3
21506147	1119510	0	0
21500002	19133905	2	3
36153871	1112807	0	0
36152288	19125062	2	3
36302170	4043241	5	14
36463331	1545958	0	0
42807353	19128009	2	2
44354052	723013	0	0
43530815	4146173	3	5
45628540	43012036	2	3
45662421	975125	0	0
45665285	1551192	2	3
45668022	40223768	2	3
45626237	1149196	0	0
45625230	1125315	0	0
45685807	40236446	2	3
45781295	1153428	0	0
45684008	1119510	0	0
45669074	1549786	0	0
45702426	1307863	0	0
45699473	1177480	0	0
45780161	1738521	0	0
46242664	19078461	2	3
46243147	1129625	0	0
45795494	1177480	0	0
46243975	1112807	0	0
45801767	1115008	0	0
45791785	1548195	0	0
46318965	1125315	0	0
45801339	19008572	2	3
4040390	4198190	7	9
3051542	3019550	2	3
21506187	967823	0	0
21500002	19133873	2	3
36153872	1589505	0	0
36151398	40229134	2	3
36302170	4246502	5	5
36463127	1332418	0	0
42805822	19128263	2	2
44353833	1177480	0	0
43530815	4142905	3	5
45628472	1115171	2	3
45661363	975125	0	0
45665347	19057271	2	3
45657490	1107882	2	3
45626299	967823	0	0
45624137	1125315	0	0
45685826	40232448	2	3
45781297	1549786	0	0
45684018	1119510	0	0
45669100	1124957	0	0
45702411	1332418	0	0
45699470	1177480	0	0
45780185	1118084	0	0
46240370	19078461	2	3
46242905	1129625	0	0
45795603	1177480	0	0
46238904	1112807	0	0
45801883	1000560	0	0
45791785	1521369	0	0
46319128	1125315	0	0
45795710	1154615	2	3
4040390	4163971	7	7
3051542	3023103	2	3
21506156	1115008	0	0
21002094	19129655	2	3
36153873	1129625	0	0
36157102	1129625	0	0
36302170	4133840	5	5
36463144	1501700	0	0
42805822	19128022	2	2
44353926	1124300	0	0
43530815	4278672	3	5
45628357	1551192	2	3
45659331	975125	0	0
45662166	19008572	2	3
45659106	1545959	2	3
45626381	738818	0	0
45624158	1125315	0	0
45685941	19133768	2	3
45781297	19127890	0	0
45680457	1119510	0	0
45669103	1367571	0	0
45702494	1501700	0	0
45699600	1177480	0	0
45780191	1107830	0	0
45685426	19078461	2	3
46242913	1129625	0	0
45795653	1177480	0	0
46239010	1112807	0	0
45801884	1107830	0	0
45791820	1595799	0	0
46319377	1125315	0	0
45795766	19133905	2	3
4040390	4107731	7	7
3051542	3014576	2	3
21502881	1305058	0	0
21505734	19079524	2	3
36154048	1129625	0	0
36157102	1125315	0	0
36302170	4151422	5	5
36463232	1119510	0	0
42805741	920334	2	3
44353931	1124300	0	0
43530815	78272	3	7
45625169	40232448	2	3
45659385	975125	0	0
45662284	35605482	2	3
45639122	40173590	2	3
45626244	1149196	0	0
45624356	1125315	0	0
45685882	1107882	2	3
45781677	975125	0	0
45680574	1119510	0	0
45669104	967823	0	0
45702441	1501700	0	0
45696023	1177480	0	0
45780194	933724	0	0
46244854	40223768	2	3
46243182	1129625	0	0
45795598	1177480	0	0
46239019	1112807	0	0
45801820	791967	0	0
45791820	1521369	0	0
46319146	1125315	0	0
45795841	40229134	2	3
4040390	4275113	7	7
1518198	44816277	2	3
21502889	967823	0	0
21003153	19019273	2	3
36154057	975125	0	0
36157102	1119510	0	0
36302170	4134304	10	14
36463232	738818	0	0
42805695	40169281	2	3
44353932	701322	0	0
43530815	4218389	3	3
45625301	40232448	2	3
45659393	975125	0	0
45662314	19018935	2	3
45635757	1107882	2	3
45626247	740275	0	0
45624183	1125315	0	0
45686080	1332419	2	3
45781685	1367571	0	0
45680579	1119510	0	0
45669130	1713332	0	0
45702502	975125	0	0
45696282	1177480	0	0
45780175	1174888	0	0
45794846	19078461	2	3
46242998	1129625	0	0
45795602	1177480	0	0
46239020	1112807	0	0
45801824	1551099	0	0
45791820	1549786	0	0
46319150	1125315	0	0
45795915	1551192	2	3
4040390	4218408	3	3
1150770	1150771	2	3
21503138	1112807	0	0
21003110	42707627	2	3
36154062	1125315	0	0
36156878	1110410	0	0
36302170	40479422	10	13
36463232	1125315	0	0
42805830	40224805	2	3
44354029	1124300	0	0
43530815	4296204	3	3
45625378	40229134	2	3
45659578	975125	0	0
45662410	19078461	2	3
45648233	1332419	2	3
45622793	1124300	0	0
45624190	1125315	0	0
45686201	40223834	2	3
45781689	1174888	0	0
45680863	1119510	0	0
45669245	705944	0	0
45702518	1332418	0	0
45696172	1177480	0	0
45780176	1107830	0	0
45783151	19078461	2	3
46243009	1129625	0	0
45797238	1177480	0	0
46239143	1112807	0	0
45801830	1192710	0	0
45791675	1124300	0	0
46319153	1125315	0	0
45795809	19018935	2	3
4040390	4163951	3	3
1150836	1150837	2	3
21503089	914335	0	0
21500286	40232448	2	3
36154062	1119510	0	0
36156881	1501700	0	0
36302170	133834	10	12
36463234	1118084	0	0
42805713	40163554	2	3
44354030	738818	0	0
43530815	4113008	3	3
45625272	19133768	2	3
45656231	975125	0	0
45662921	19008572	2	3
45657659	1332419	2	3
45623131	1545958	0	0
45624234	1125315	0	0
45637226	40228214	2	3
45781691	1367571	0	0
45677276	1119510	0	0
45669122	1107830	0	0
45702521	1717327	0	0
45693141	1177480	0	0
45780177	19127890	0	0
45700169	19078461	2	3
46243013	1129625	0	0
45795713	1177480	0	0
46239144	1112807	0	0
45801641	1539403	0	0
45791659	1115008	0	0
46295535	1125315	0	0
45795872	40228230	2	3
4040390	4295880	3	4
1153428	40223821	2	3
21502874	967823	0	0
21003108	42707627	2	3
36154062	738818	0	0
36156906	1717327	0	0
36302170	4024958	6	7
36463361	1107830	0	0
42805905	43012433	2	3
44354055	1107830	0	0
43530815	4155034	3	3
45625471	1127433	2	3
45656370	975125	0	0
45662775	19133873	2	3
45623686	1107882	2	3
45623144	1589505	0	0
45624236	1125315	0	0
45637234	19019273	2	3
45781517	1305058	0	0
45677390	1119510	0	0
45669189	1115008	0	0
45702599	967823	0	0
45693271	1177480	0	0
45780177	1549786	0	0
45681046	19078461	2	3
46243061	1129625	0	0
45793032	1177480	0	0
45894728	1112807	0	0
45801810	1309944	0	0
45791670	1343916	0	0
46295193	1125315	0	0
45790459	1115171	2	3
4040390	4059978	3	4
442983	4048171	4	4
21503154	967823	0	0
21005679	19073188	2	3
36154064	1112807	0	0
36157036	1713332	0	0
36302170	4027663	6	10
36463080	1738521	0	0
42805911	1551192	2	3
44354063	1521369	0	0
43530815	4109685	3	4
45625689	19078924	2	3
45656160	975125	0	0
45662421	19008572	2	3
45652196	40228214	2	3
45623144	1549786	0	0
45624208	1125315	0	0
45636740	40232448	2	3
45781529	738818	0	0
45677427	1119510	0	0
45669305	1778162	0	0
45699391	1174888	0	0
45693292	1177480	0	0
45780183	1557272	0	0
45681139	19078461	2	3
46243128	1129625	0	0
45792837	1177480	0	0
45893582	1112807	0	0
45801793	967823	0	0
45791671	1174888	0	0
46295537	1125315	0	0
45790644	1115171	2	3
4040390	4010253	3	5
432661	4048171	4	4
21503156	967823	0	0
21003056	40232448	2	3
36154065	1112807	0	0
36157036	1759842	0	0
36302170	44782520	6	9
36463083	705944	0	0
42805922	19133905	2	3
44354063	1549786	0	0
43530815	4132546	3	4
45625691	1551192	2	3
45656677	975125	0	0
45662965	40228214	2	3
45626985	1332419	2	3
45623148	738818	0	0
45624278	1125315	0	0
45636821	19057271	2	3
45781534	1309944	0	0
45677498	1119510	0	0
45669191	1539403	0	0
45699296	914335	0	0
45694831	1177480	0	0
45780085	920293	0	0
45681256	19078461	2	3
46240914	1129625	0	0
45793358	1177480	0	0
45801702	1112807	0	0
45801795	1115008	0	0
45791736	701322	0	0
46295551	1125315	0	0
45790576	40229134	2	3
4040390	4337138	3	6
442628	40479422	4	4
21502750	1551099	0	0
21002587	19075001	2	3
36154065	1192710	0	0
36157061	1501700	0	0
36302170	4237458	6	12
36463274	1129625	0	0
42805922	19133873	2	3
44354033	1124957	0	0
43530815	40480160	5	5
45625658	40224805	2	3
45652905	975125	0	0
45662728	40232448	2	3
45665664	1107882	2	3
45622991	1551099	0	0
45624229	1125315	0	0
45682977	40229134	2	3
45781663	715997	0	0
45677700	1119510	0	0
45669237	1107830	0	0
45699297	975125	0	0
45690301	1177480	0	0
45780089	1192710	0	0
45786720	19078461	2	3
46240998	1129625	0	0
45793053	1177480	0	0
45796140	1112807	0	0
45801813	1309944	0	0
45791741	1174888	0	0
46295439	1125315	0	0
45790448	40229134	2	3
4040390	4035793	2	2
442628	40479768	4	4
21502750	975125	0	0
21003076	40229134	2	3
36154067	1112807	0	0
36157062	1115008	0	0
36302170	4066995	6	12
36463282	1115008	0	0
42806883	40236824	2	3
44353758	1149380	0	0
43530815	40479768	5	6
45625752	19008572	2	3
45653017	975125	0	0
45662830	40223768	2	3
45651101	19078461	2	3
45623153	1124957	0	0
45668348	1125315	0	0
45682979	19019273	2	3
45781669	1149196	0	0
45677779	1119510	0	0
45669311	1115008	0	0
45699323	738818	0	0
45690484	1177480	0	0
45780002	723013	0	0
45676022	19078461	2	3
46241000	1129625	0	0
45793188	1177480	0	0
45796255	1112807	0	0
45801854	1115008	0	0
45791792	1149196	0	0
46295308	1125315	0	0
45790701	40229134	2	3
4042140	4134304	7	11
374009	4043241	4	4
21503094	933724	0	0
21503953	19078924	2	3
36154067	1192710	0	0
36157201	1129625	0	0
36302170	321042	8	12
36463287	1332418	0	0
42807063	1551192	2	3
44354035	19127890	0	0
43530815	375671	5	6
45625843	1115171	2	3
45653304	975125	0	0
45661363	19008572	2	3
45633040	19078461	2	3
45623177	1713332	0	0
45668261	1125315	0	0
45682985	19008572	2	3
45781772	1367571	0	0
45676260	1119510	0	0
45669196	1521369	0	0
45699299	914335	0	0
45690328	1177480	0	0
45780098	1326303	0	0
45673126	19078461	2	3
46240888	1129625	0	0
45791917	1177480	0	0
45796197	1112807	0	0
45801855	791967	0	0
45791794	1174888	0	0
46295243	1125315	0	0
45790558	1115171	2	3
4042140	4230399	7	10
4000731	4337611	4	4
21503209	975125	0	0
21003040	19078924	2	3
36154069	1112807	0	0
36156637	1177480	0	0
36302170	4048695	8	12
36463190	1500211	0	0
42807004	35605482	2	3
44354035	1521369	0	0
43530815	40479422	5	6
45622120	19018935	2	3
45653305	975125	0	0
45661203	46275444	2	3
45638671	19075601	2	3
45623177	1759842	0	0
45668365	1125315	0	0
45682987	1545959	2	3
45781775	1308738	0	0
45674481	1119510	0	0
45669196	1595799	0	0
45699585	1332418	0	0
45690604	1177480	0	0
45780107	19010482	0	0
45675921	19078461	2	3
46240749	1129625	0	0
45790272	1177480	0	0
45796207	1112807	0	0
45801876	1174888	0	0
45791797	1713332	0	0
46295245	1125315	0	0
45790838	1551192	2	3
4042140	4144583	7	7
440029	40481087	4	4
21503162	1192710	0	0
21005678	19073183	2	3
36154069	1192710	0	0
36156720	1149196	0	0
36302170	4266809	8	11
36463192	1112807	0	0
42805465	1594382	2	3
44354035	1549786	0	0
43530815	378001	5	6
45622124	40162522	2	3
45653208	975125	0	0
45661289	19073183	2	3
45627061	40228214	2	3
45623180	1589505	0	0
45668370	1125315	0	0
45682829	40232448	2	3
45781801	1174888	0	0
45674471	1119510	0	0
45669196	1549786	0	0
45699690	1539403	0	0
45690589	1177480	0	0
45780116	1310149	0	0
46240618	19078461	2	3
46240897	1129625	0	0
45787312	1177480	0	0
45796263	1112807	0	0
45801877	723013	0	0
45791805	1115008	0	0
46295351	1125315	0	0
45790957	19008572	2	3
4042140	4155034	6	7
440921	4113008	4	4
21503162	738818	0	0
21005678	19073188	2	3
36154075	975125	0	0
36157233	1177480	0	0
36302170	255848	8	11
36463332	1177480	0	0
42804566	920334	2	3
44354039	975125	0	0
43530815	4230399	4	6
45622124	19133768	2	3
45653459	975125	0	0
45659331	19008572	2	3
45644539	40228214	2	3
45623180	1549786	0	0
45668373	1125315	0	0
45682885	40223834	2	3
45781780	967823	0	0
45674472	1119510	0	0
45669294	1717327	0	0
45699342	1192710	0	0
45687367	1177480	0	0
45780122	1367571	0	0
45694531	19078461	2	3
46240836	1129625	0	0
45787719	1177480	0	0
45796265	1112807	0	0
45802413	1501700	0	0
45791582	975125	0	0
46295637	1125315	0	0
45790812	1519937	2	3
4042140	4109685	6	8
440921	4155034	4	4
21500583	1174888	0	0
21505795	19075601	2	3
36154077	1177480	0	0
35506909	1177480	0	0
36302170	28060	8	11
36463334	1177480	0	0
42802009	40231925	2	3
44354199	1713332	0	0
43530815	81151	4	6
45622139	40232448	2	3
45649767	975125	0	0
45659382	40174880	2	3
45632849	19075601	2	3
45623180	19127890	0	0
45668404	1125315	0	0
45633683	19008572	2	3
45781807	1110410	0	0
45674436	1119510	0	0
45669266	1307863	0	0
45699371	1778162	0	0
45687570	1177480	0	0
45780134	1713332	0	0
46242839	19078461	2	3
45696476	40174880	2	3
45787520	1177480	0	0
45796180	1112807	0	0
45802417	975125	0	0
45791583	1738521	0	0
46244325	1125315	0	0
45790899	19075601	2	3
4042140	81893	6	12
440921	4218389	4	4
21500599	1305058	0	0
21003205	19112599	2	3
36154078	933724	0	0
35506909	1129625	0	0
36302170	198199	8	11
36427424	1125315	0	0
42801830	1154615	2	3
44354225	1112807	0	0
43530815	4156265	4	4
45622164	40229134	2	3
45646880	975125	0	0
45659438	1127433	2	3
45648287	19075601	2	3
45622887	1124957	0	0
45668451	1125315	0	0
45633470	1545959	2	3
45783497	1343916	0	0
45674525	1119510	0	0
45669278	1115008	0	0
45699439	740275	0	0
45687279	1177480	0	0
45780154	705944	0	0
45673063	19078461	2	3
45792495	40228214	2	3
45789039	1177480	0	0
45790739	1112807	0	0
45802525	1110410	0	0
45791648	1548195	0	0
46244334	1125315	0	0
45790687	40162522	2	3
4042140	313217	6	11
444187	4152936	4	4
21500613	1343916	0	0
21002836	1125315	0	0
36154087	1112807	0	0
35506912	1149196	0	0
36302170	40486433	8	13
36424953	1149380	0	0
42802236	40162522	2	3
44354015	1177480	0	0
43530815	4134304	4	7
45625098	40223834	2	3
45646935	975125	0	0
45659393	19008572	2	3
45650995	19075601	2	3
45622890	1551099	0	0
45668422	1125315	0	0
45633733	40232448	2	3
45783512	1549786	0	0
45671608	1119510	0	0
45669379	738818	0	0
45699584	1107830	0	0
45684297	1177480	0	0
45780153	920293	0	0
45797317	1539411	2	3
45802672	19079524	2	3
45789280	1177480	0	0
45791890	1112807	0	0
45802320	1124300	0	0
45791752	1551099	0	0
46244446	1125315	0	0
45790717	19008572	2	3
4042140	4166224	6	10
375415	378001	4	4
21500606	1124300	0	0
21002846	1115008	0	0
36154108	1174888	0	0
35507013	791967	0	0
36302170	440448	8	13
36422283	1347450	0	0
42807125	40231925	2	3
44354257	1110410	0	0
43530815	4066995	4	5
45622287	19008572	2	3
45646969	975125	0	0
45659504	40232448	2	3
45639364	40173590	2	3
45622992	1500211	0	0
45668692	1125315	0	0
45633769	19008572	2	3
45783512	19127890	0	0
45671599	1119510	0	0
45669316	1000560	0	0
45699384	705944	0	0
45685610	1177480	0	0
45779872	1192710	0	0
46240492	1332419	2	3
46242909	19078461	2	3
45787907	1177480	0	0
45792007	1112807	0	0
45802600	1551099	0	0
45791775	1124300	0	0
46244583	1125315	0	0
46297637	46275916	2	3
4042140	258780	6	10
375415	375671	4	4
21500607	1125315	0	0
21002836	1112807	0	0
36154108	1125315	0	0
35507014	1119510	0	0
36302170	258780	8	13
36422228	1557272	0	0
42807128	19018935	2	3
44354155	791967	0	0
43530815	4048695	4	5
45622309	1154615	2	3
45647198	975125	0	0
45659357	19018935	2	3
45656953	19078461	2	3
45622906	967823	0	0
45668458	1125315	0	0
45633877	1551192	2	3
45783596	738818	0	0
45671569	1119510	0	0
45669318	1332418	0	0
45699436	1192710	0	0
45684390	1177480	0	0
45779873	975125	0	0
45785207	1332419	2	3
45797555	40223768	2	3
45787900	1177480	0	0
46294636	1112807	0	0
45798963	967823	0	0
45791777	1343916	0	0
46244514	1125315	0	0
46297239	19008572	2	3
4042140	4059173	6	9
4000740	4057420	4	4
21500616	1343916	0	0
21002822	1115008	0	0
36154110	1125315	0	0
35507024	1119510	0	0
36302170	4302207	8	9
36422111	1112807	0	0
42807135	19023398	2	3
44354018	1124300	0	0
43530815	4237458	4	5
45622597	1115171	2	3
45643892	975125	0	0
45659545	42707627	2	3
45635594	19078461	2	3
45623189	1717327	0	0
45668452	1125315	0	0
45633905	43012036	2	3
45783601	1107830	0	0
45671575	1119510	0	0
45669144	1124957	0	0
45699534	975125	0	0
45684578	1177480	0	0
45779972	1174888	0	0
45777813	1545959	2	3
45795235	19078461	2	3
45786095	1177480	0	0
46294909	1112807	0	0
45799074	1124300	0	0
45791781	782043	0	0
46244337	1125315	0	0
46297349	40232448	2	3
4042140	4152936	6	9
4003043	4275113	4	4
21500176	1557272	0	0
21002827	975125	0	0
36154111	1129625	0	0
35507028	1177480	0	0
36302170	441267	8	9
36463335	1115008	0	0
42807238	19133905	2	3
44353987	1307863	0	0
43530815	4001336	4	5
45622600	1127433	2	3
45644135	975125	0	0
45659546	19123231	2	3
45658434	19078461	2	3
45622891	1115008	0	0
45668492	1125315	0	0
45630745	19078461	2	3
45783614	1589505	0	0
45671542	1119510	0	0
45669466	1107830	0	0
45699535	975125	0	0
45681427	1177480	0	0
45779978	1000560	0	0
45675852	40174880	2	3
45802847	19078461	2	3
46296887	1177480	0	0
46294937	1112807	0	0
45799088	1124957	0	0
45788950	1713332	0	0
46244313	1125315	0	0
46297449	40236824	2	3
4180628	4146173	4	6
134057	4310024	4	4
21500203	1326303	0	0
21002827	1124300	0	0
36154118	1112807	0	0
35506977	1307863	0	0
36302170	4139681	8	9
36463429	1107830	0	0
42808536	40229134	2	3
44354020	715997	0	0
43530877	4296204	4	4
45622444	1127433	2	3
45642928	975125	0	0
45659509	40162522	2	3
45651888	19078461	2	3
45622894	1738521	0	0
45668501	1125315	0	0
45630714	19078461	2	3
45783682	740275	0	0
45673015	1119510	0	0
45669326	1149196	0	0
45699536	738818	0	0
45681656	1177480	0	0
45780032	1115008	0	0
45697419	1539411	2	3
46292144	19078461	2	3
46297097	1177480	0	0
46244063	1112807	0	0
45799091	705944	0	0
45788984	1539403	0	0
46244562	1125315	0	0
46297846	43012036	2	3
4180628	4132546	4	6
372887	4001336	4	4
21500166	1501700	0	0
21002846	975125	0	0
36156282	1000560	0	0
35507090	914335	0	0
36302170	442116	8	9
36463446	1125315	0	0
42804694	40236824	2	3
44353902	1307863	0	0
43530877	4113008	4	4
45622493	1115171	2	3
45637822	975125	0	0
45659464	40232448	2	3
45633021	40228214	2	3
45623030	1501700	0	0
45668521	1125315	0	0
45630840	19133873	2	3
45781850	975125	0	0
45673035	1119510	0	0
45666721	715997	0	0
45699440	1307863	0	0
45681512	1177480	0	0
45780042	1124957	0	0
45802631	1545959	2	3
45794980	19078461	2	3
46293377	1177480	0	0
46244162	1112807	0	0
45799097	1107830	0	0
45789046	19127890	0	0
46244526	1125315	0	0
46297958	19008572	2	3
4180628	198809	4	6
4000738	4163971	4	4
21003406	19010482	0	0
21002846	1124300	0	0
36156240	920293	0	0
35506982	1129625	0	0
36302170	78272	8	14
36463446	1119510	0	0
42804666	19073183	2	3
44354004	1149196	0	0
43530877	4155034	4	4
45620730	19059056	2	3
45638329	975125	0	0
45659582	1551192	2	3
45632496	19078461	2	3
45623031	933724	0	0
45668782	1125315	0	0
45630843	1115171	2	3
45778816	967823	0	0
45673372	1119510	0	0
45666789	1307863	0	0
45699563	1124300	0	0
45681623	1177480	0	0
45780045	1153428	0	0
45778220	1539411	2	3
45895110	19078461	2	3
46293488	1177480	0	0
46239456	1112807	0	0
45799140	1153428	0	0
45789046	1549786	0	0
46244298	1125315	0	0
46297908	40232448	2	3
4180628	4266809	4	6
133468	4278672	4	4
21003405	19010482	0	0
21002844	975125	0	0
36156400	975125	0	0
35507064	1177480	0	0
36302170	4174876	7	8
36463446	1129625	0	0
42804652	35605482	2	3
44354021	1738521	0	0
43530877	4218389	4	4
45620837	40232448	2	3
45637122	975125	0	0
45659541	1332419	2	3
45654181	40228214	2	3
45622897	1512674	0	0
45668789	1125315	0	0
45630856	40232448	2	3
45779232	738818	0	0
45673101	1119510	0	0
45666753	1174888	0	0
45699449	1332418	0	0
45679750	1177480	0	0
45780048	967823	0	0
45792103	1539411	2	3
46292163	19078461	2	3
46296593	1177480	0	0
46239551	1112807	0	0
45799159	740275	0	0
45789048	1174888	0	0
46244322	1125315	0	0
46297923	40162522	2	3
4180628	4283893	4	5
133468	4113008	4	4
21003421	1738521	0	0
21002844	1124300	0	0
36156355	1154343	0	0
35507067	1343916	0	0
36302170	372328	7	10
36463443	705944	0	0
42804655	40243436	2	3
44354109	1521369	0	0
43530877	4109685	4	5
45620771	1115171	2	3
44361834	1192710	0	0
45659472	1551192	2	3
45642179	40228214	2	3
45622897	1549786	0	0
45668790	1125315	0	0
45630991	19078924	2	3
45779237	738818	0	0
45671669	1119510	0	0
45666884	791967	0	0
45699635	1192710	0	0
45679783	1177480	0	0
45780049	1713332	0	0
46240499	1539411	2	3
45795131	19078461	2	3
46288475	1177480	0	0
46239677	1112807	0	0
45799249	1192710	0	0
45788963	723013	0	0
46244323	1125315	0	0
46297994	19125062	2	3
4180628	381316	4	5
133468	4155034	4	4
21003410	1551099	0	0
21002852	1728416	0	0
36156356	920293	0	0
35507069	1119510	0	0
36302170	4155034	7	10
36463418	738818	0	0
42804657	1594382	2	3
44353851	1501700	0	0
43530877	4059173	4	6
45621229	40223834	2	3
44361851	1192710	0	0
45656231	19008572	2	3
45635745	19079524	2	3
45622994	723013	0	0
45665857	1125315	0	0
45630809	19008572	2	3
45779238	738818	0	0
45669950	1119510	0	0
45666806	1110410	0	0
45699553	1501700	0	0
45678167	1177480	0	0
45706914	1551099	0	0
45876037	3013682	2	5
46243078	19078461	2	3
46288827	1177480	0	0
46239649	1112807	0	0
45799252	1713332	0	0
45788965	1124957	0	0
46244569	1125315	0	0
46289301	40162522	2	3
4180628	4056621	4	5
376337	380378	4	4
21003410	975125	0	0
21002493	1521369	0	0
36156465	1305058	0	0
35507075	1545958	0	0
36302170	381316	7	10
36463418	1119510	0	0
42804658	46275916	2	3
44354117	1115008	0	0
43530877	4001336	4	6
45621229	40223821	2	3
44361919	1192710	0	0
45656370	19008572	2	3
45654327	40228214	2	3
45623090	738818	0	0
45665987	1125315	0	0
45631001	1115171	2	3
45779358	705944	0	0
45670157	1119510	0	0
45666939	1118084	0	0
45699638	1174888	0	0
45678100	1177480	0	0
45706931	791967	0	0
45876037	3023103	2	6
46243207	19078461	2	3
46288967	1177480	0	0
46239726	1112807	0	0
45799166	1124300	0	0
45789006	738818	0	0
46244388	1125315	0	0
46289148	19018935	2	3
4180628	80809	4	4
376208	317576	4	4
21004035	708298	0	0
21002493	1589505	0	0
36156306	1149380	0	0
35507211	975125	0	0
36302170	4056621	7	11
36463418	1125315	0	0
42804875	40162522	2	3
44354091	1322184	0	0
43530877	4278672	4	6
45621183	19059056	2	3
44362295	1192710	0	0
45656259	1545959	2	3
45644806	40228214	2	3
45623198	1713332	0	0
45666102	1125315	0	0
45630976	19073183	2	3
45779359	914335	0	0
45670168	1119510	0	0
45666839	1110410	0	0
45699570	1738521	0	0
45678517	1177480	0	0
45707019	1192710	0	0
45876037	3016723	2	5
45789888	40223768	2	3
46288964	1177480	0	0
46239611	1112807	0	0
45799257	1539403	0	0
45789040	1545958	0	0
46244586	1125315	0	0
46289325	40163554	2	3
4180628	441267	4	4
376208	4280726	4	4
21003446	1595799	0	0
21002508	1549786	0	0
36156311	1129625	0	0
35507212	1115008	0	0
36302170	195588	7	12
36463393	705944	0	0
42804843	1154615	2	3
44354092	1112807	0	0
43530877	4142905	4	6
45621186	1115171	2	3
45655842	1192710	0	0
45656463	40232448	2	3
45647857	1539411	2	3
45623001	1153428	0	0
45666335	1125315	0	0
45628258	19078461	2	3
45779365	1551099	0	0
45670013	1119510	0	0
45666962	708298	0	0
45699402	1367571	0	0
45678779	1177480	0	0
45707022	705944	0	0
45783005	19128263	1	2
45789563	1332419	2	3
46289094	1177480	0	0
45896134	1112807	0	0
45799115	1521369	0	0
45789057	1174888	0	0
46244591	1125315	0	0
46289786	19008572	2	3
4180628	321042	4	4
376208	40486433	4	4
21003446	1308738	0	0
21002491	1124300	0	0
36156312	1129625	0	0
35507213	738818	0	0
36302170	261325	7	12
36463454	1717327	0	0
42805134	19078461	2	3
44354234	1115008	0	0
43530877	4146173	4	6
45621215	19059056	2	3
45655911	1192710	0	0
45658376	19075001	2	3
45666166	40228214	2	3
45623007	1738521	0	0
45666347	1125315	0	0
45628233	40232448	2	3
45779369	740275	0	0
45669989	1119510	0	0
45667030	933724	0	0
45699645	1115008	0	0
45675271	1177480	0	0
45707026	975125	0	0
45797383	19129144	1	2
45800510	19078461	2	3
46243589	1177480	0	0
45896145	1112807	0	0
45799252	1759842	0	0
45789041	1738521	0	0
46244596	1125315	0	0
46289555	46275916	2	3
4180628	4029498	4	4
376208	134438	4	4
21003452	1595799	0	0
21002491	1177480	0	0
36156312	1125315	0	0
35507213	1125315	0	0
36302170	260139	7	12
36463424	1307863	0	0
42803247	19133905	2	3
44354096	1149196	0	0
43530877	4152936	4	6
45621015	40232448	2	3
45655959	1192710	0	0
45658417	40165015	2	3
45636350	19078461	2	3
45623016	1332418	0	0
45667264	1125315	0	0
45627955	40232448	2	3
45779121	1332418	0	0
45783735	1119510	0	0
45666813	967823	0	0
45699471	1107830	0	0
45675226	1177480	0	0
45707028	1174888	0	0
45797383	19127922	1	2
45802662	19078461	2	3
46243529	1177480	0	0
45896838	1112807	0	0
45799242	1124957	0	0
45789042	1548195	0	0
46244535	1125315	0	0
46289594	19008572	2	3
4180628	4035415	4	4
4094284	81151	3	6
21003452	1308738	0	0
21002493	1548195	0	0
36156441	1125315	0	0
35507213	1119510	0	0
36302170	4329847	7	13
36469904	1153428	0	0
42802386	40224805	2	3
44354207	1177480	0	0
43530877	78272	4	8
45664682	1115171	2	3
45656310	1192710	0	0
45658447	40162522	2	3
45641870	19079524	2	3
45623019	738818	0	0
45667371	1125315	0	0
45627958	1713671	2	3
45779040	1501700	0	0
45783768	1119510	0	0
45666924	1174888	0	0
45699647	1343916	0	0
45672440	1177480	0	0
45706978	705944	0	0
45797383	19133679	1	2
45789764	19078461	2	3
46243764	1177480	0	0
45896839	1112807	0	0
45799332	1551099	0	0
45788935	1149196	0	0
46244611	1125315	0	0
46289835	1115171	2	3
4180628	4116491	4	4
4042641	4216130	3	6
21003454	1500211	0	0
21002502	19127890	0	0
36156442	1713332	0	0
35507214	1125315	0	0
36302170	4112343	7	13
36469247	1738521	0	0
42802514	40236824	2	3
44353962	1149196	0	0
43530877	40480160	6	6
45664596	19019273	2	3
45656216	1192710	0	0
45656677	19008572	2	3
45651194	40228214	2	3
45623099	967823	0	0
45667466	1125315	0	0
45676203	40162522	2	3
45779044	1115008	0	0
45783825	1119510	0	0
45667114	1154343	0	0
45699655	19003953	0	0
45672351	1177480	0	0
45707131	975125	0	0
45797184	40223774	1	1
45792746	40223768	2	3
46243652	1177480	0	0
45804276	1112807	0	0
45799337	1124957	0	0
45788936	1367571	0	0
46244571	1125315	0	0
46241667	43012036	2	3
4180628	4043241	8	9
4136694	40479422	3	3
21003454	1503184	0	0
21002502	1515774	0	0
36156442	1759842	0	0
35507214	1119510	0	0
36302170	4285898	7	14
36463387	1119510	0	0
42807303	19078924	2	3
44353755	1557272	0	0
43530877	40479768	6	7
45664712	19133768	2	3
45654980	1192710	0	0
45652901	1594382	2	3
45647691	40228214	2	3
45623217	1149196	0	0
45666428	1125315	0	0
45676278	1127433	2	3
45779264	1153428	0	0
45783753	1119510	0	0
45666840	19010482	0	0
45699679	715997	0	0
45672286	1177480	0	0
45706894	791967	0	0
45792456	40171902	1	1
46292278	19078461	2	3
46243815	1177480	0	0
45804312	1112807	0	0
45799121	1332418	0	0
45788940	1332418	0	0
46244552	1125315	0	0
46241668	1127433	2	3
4180628	28060	5	6
4136694	40479768	3	3
21000705	1332418	0	0
21002502	1548195	0	0
36156546	1738521	0	0
35507222	1539403	0	0
36302170	4094814	7	7
36463460	1119510	0	0
42807058	40236446	2	3
44354251	1551099	0	0
43530877	4132546	3	5
45664819	19008572	2	3
45655043	1192710	0	0
45653058	1107882	2	3
45654009	19079524	2	3
45623219	1154029	0	0
45666476	1125315	0	0
45676280	40232448	2	3
45779301	1174888	0	0
45783989	1119510	0	0
45666895	1115008	0	0
45699680	967823	0	0
45672572	1177480	0	0
45706896	791967	0	0
46275875	46275444	1	1
45792593	40174880	2	3
46243839	1177480	0	0
45797286	1112807	0	0
45799357	1107830	0	0
45788944	19039298	0	0
46240381	1125315	0	0
46241669	43012036	2	3
4180628	40481087	5	6
4181583	4294548	3	3
21000705	1545958	0	0
21002502	1595799	0	0
36156317	1551099	0	0
35202051	4280726	5	9
36302170	4240902	9	10
36463463	1332418	0	0
42805341	19018935	2	3
44354189	1713332	0	0
43530877	4134304	5	8
45664753	1154615	2	3
45649535	1192710	0	0
45652919	19075601	2	3
45644284	19078461	2	3
45623225	1149196	0	0
45666477	1125315	0	0
45673503	40228214	2	3
45779318	1326303	0	0
45783990	1119510	0	0
45666983	1000560	0	0
45699476	975125	0	0
45672495	1177480	0	0
45706099	1589505	0	0
46275915	46275916	1	1
45797993	1545959	2	3
46243784	1177480	0	0
45796656	1112807	0	0
45799174	1738521	0	0
45788993	1717327	0	0
46239771	1125315	0	0
46241587	19008572	2	3
4180628	255848	5	6
4181583	4112343	3	3
19123231	19123231	0	0
21002502	19054876	0	0
36156375	1551099	0	0
35702113	81893	6	12
36302170	433644	9	10
36463397	1717327	0	0
42805647	19019273	2	3
44354193	1177480	0	0
43530877	375671	5	7
45664886	1551192	2	3
45649601	1192710	0	0
45652923	40232448	2	3
45638394	19078461	2	3
45623247	1115008	0	0
45663829	1125315	0	0
45624732	1594382	2	3
45779346	1124300	0	0
45783993	1119510	0	0
45666816	1548195	0	0
45699484	1115008	0	0
45672631	1177480	0	0
45706099	1549786	0	0
46276149	1594382	1	1
45792741	1332419	2	3
46241434	1177480	0	0
45791196	1112807	0	0
45799348	975125	0	0
45789107	1192710	0	0
46239772	1125315	0	0
46241703	1127433	2	3
4180628	4142905	5	7
4042330	4301346	3	5
19074841	19074841	0	0
21002502	1589505	0	0
36156248	914335	0	0
35802134	81893	7	7
36302170	4048171	9	14
36469615	1154343	0	0
42804952	19019273	2	3
44354196	738818	0	0
43530877	378001	5	7
45664803	40232448	2	3
45649659	1192710	0	0
45653425	40162522	2	3
45629263	19078461	2	3
45625102	1713332	0	0
45664522	1125315	0	0
45624956	40229134	2	3
45780620	1115008	0	0
45781563	1119510	0	0
45667047	920293	0	0
45699685	1149196	0	0
45784309	1177480	0	0
45706117	1307863	0	0
46287614	40243436	1	1
45800467	1332419	2	3
46241444	1177480	0	0
45791357	1112807	0	0
45799126	1192710	0	0
45789107	1174888	0	0
46241859	19127904	3	4
46241646	40229134	2	3
4180628	4001336	5	7
4042503	4146173	3	5
19075001	19075001	0	0
21002502	1521369	0	0
36156508	1119510	0	0
21604180	723013	4	4
36302170	313217	9	14
36469629	1115008	0	0
42802101	19019273	2	3
44353845	1551099	0	0
43530877	4230399	5	7
45664806	40232448	2	3
45649059	1192710	0	0
45653425	19133768	2	3
45665286	40174880	2	3
45625063	1174888	0	0
45664515	1125315	0	0
45624815	1115171	2	3
45780624	975125	0	0
45781818	1119510	0	0
45667121	1768849	0	0
45699601	1124957	0	0
45784198	1177480	0	0
45706149	975125	0	0
45885352	4237458	1	1
45803108	1332419	2	3
46241636	1177480	0	0
45791211	1112807	0	0
45799132	1115008	0	0
45789101	1308738	0	0
46244407	19133679	3	4
46241623	1127433	2	3
4180628	40480160	5	7
4185503	261325	3	5
19076733	19029476	0	0
21002502	1549786	0	0
35507691	1307863	0	0
21604180	19074679	4	7
36303153	4037675	7	7
36463384	1125315	0	0
42802384	1551192	2	3
44353963	1738521	0	0
43530877	81151	5	7
45664810	40232448	2	3
45646568	1192710	0	0
45652981	1115171	2	3
45653438	1332419	2	3
45625102	1759842	0	0
45663965	1125315	0	0
45624963	19078924	2	3
45780701	738818	0	0
45781636	1119510	0	0
45667058	1738521	0	0
45699610	1305058	0	0
45786453	1177480	0	0
45706198	1115008	0	0
45876187	46235214	1	1
46243208	1332419	2	3
46238786	1177480	0	0
45791560	1112807	0	0
45799271	1501700	0	0
45788894	1746114	0	0
45876060	3024561	3	4
46241748	19008572	2	3
4180628	4048171	5	8
4180627	4295880	3	5
19077344	19077344	0	0
21002502	1503184	0	0
35507694	1728416	0	0
21604180	45892894	6	7
36303153	4299128	7	7
36469821	1125315	0	0
42807064	19075001	2	3
44354098	1539403	0	0
43530877	4156265	5	5
45664878	19018935	2	3
45646605	1192710	0	0
45653305	19008572	2	3
45635562	19078461	2	3
45625074	708298	0	0
45664005	1125315	0	0
45624673	19078461	2	3
45780857	738818	0	0
45781735	1119510	0	0
45667078	1115008	0	0
45699659	1149196	0	0
45784434	1177480	0	0
45706158	1153428	0	0
45696885	19079524	1	1
45696783	1332419	2	3
46238667	1177480	0	0
45791425	1112807	0	0
45799275	1549786	0	0
45788894	1741122	0	0
45876060	3013682	3	3
46241765	40229134	2	3
4180628	4166224	5	8
4180627	4059978	3	5
19076374	19076374	0	0
21002505	1521369	0	0
35507962	1107830	0	0
36217216	19133679	3	4
36303153	4266809	7	10
36469839	1119510	0	0
42804841	19019273	2	3
44354102	1192710	0	0
43530877	4048695	5	6
45664881	1115171	2	3
45643697	1192710	0	0
45653315	1154615	2	3
45650241	19078461	2	3
45624899	1110410	0	0
45663962	1125315	0	0
45670282	19008572	2	3
45780706	1107830	0	0
45781546	1119510	0	0
45667111	723013	0	0
45699667	1332418	0	0
45784470	1177480	0	0
45706148	967823	0	0
46292632	19079524	1	1
45789819	1332419	2	3
46238574	1177480	0	0
46298473	1112807	0	0
45799275	1589505	0	0
45789091	1551099	0	0
45893809	19128263	2	2
46242602	40162522	2	3
4180628	258780	5	8
4180627	4145310	3	5
19077572	19077572	0	0
21002524	1305058	0	0
35508016	715997	0	0
36217216	19128263	3	4
36303153	4156265	7	10
36469839	1125315	0	0
42804690	1545959	2	3
44354170	933724	0	0
43530877	4237458	5	6
45664407	40223834	2	3
45643797	1192710	0	0
45653361	19133768	2	3
45638404	19078461	2	3
45625076	1332418	0	0
45663938	1125315	0	0
45670283	40223834	2	3
45780697	1501700	0	0
45781308	1119510	0	0
45667082	738818	0	0
45699667	1545958	0	0
45782311	1177480	0	0
45706239	1154029	0	0
45876221	21494966	1	1
45785831	40174880	2	3
46240081	1177480	0	0
46298476	1112807	0	0
45799275	19127890	0	0
45788888	1589505	0	0
45893809	19128022	2	2
46242612	40229134	2	3
4180628	81151	5	8
4042330	44783196	3	4
21001432	1545958	0	0
21002493	19127890	0	0
35507965	1545958	0	0
36217216	19127918	3	4
36303153	4142905	7	11
36470033	1125315	0	0
42806885	40163554	2	3
44354278	920293	0	0
43530877	4066995	5	6
45664342	19059056	2	3
45643485	1192710	0	0
45653216	40232448	2	3
45649183	1539411	2	3
45624908	738818	0	0
45664078	1125315	0	0
45670614	40232448	2	3
45780844	1738521	0	0
45781529	1119510	0	0
45667140	1124957	0	0
45699669	1595799	0	0
45782253	1177480	0	0
45706347	1137529	0	0
45876220	40758406	1	1
45790041	1545959	2	3
45897701	1177480	0	0
46298685	1112807	0	0
45799278	1154343	0	0
45789080	1367571	0	0
46239815	19133768	2	3
46241850	1545959	2	3
4180628	81893	5	10
4134423	4238715	3	4
21001432	1332418	0	0
21002493	1515774	0	0
35507917	1310149	0	0
36217216	19127904	3	4
36303153	4169137	7	8
36470033	1119510	0	0
42807218	1545959	2	3
44354075	715997	0	0
44338301	1129625	0	0
45662043	19008572	2	3
45643500	1192710	0	0
45653459	19008572	2	3
45623782	1332419	2	3
45625126	742185	0	0
45664028	1125315	0	0
45670575	19019273	2	3
45780732	1174888	0	0
45781532	1119510	0	0
45667134	738818	0	0
45699669	1308738	0	0
45782220	1177480	0	0
45706347	1149380	0	0
45876220	3051031	1	1
45795055	1545959	2	3
45897794	1177480	0	0
46298859	1112807	0	0
45799209	19127890	0	0
45788985	1115008	0	0
46239815	40162522	2	3
46242004	1551192	2	3
4180628	45769019	5	5
4042504	4243062	3	4
21001432	1307863	0	0
21002510	1548195	0	0
35508059	1107830	0	0
36217216	19133905	2	3
36303153	42535580	7	8
36470077	1119510	0	0
42807091	1545959	2	3
44351701	1149196	0	0
44338311	1738521	0	0
45662158	1332419	2	3
45643614	1192710	0	0
45649767	19008572	2	3
45667395	1332419	2	3
45625018	1124957	0	0
45663986	1125315	0	0
45670474	1551192	2	3
45780734	1000560	0	0
45783596	1119510	0	0
45780960	738818	0	0
45699597	1539403	0	0
45782365	1177480	0	0
45706166	1149380	0	0
46276153	19079524	1	1
46240951	1545959	2	3
45897728	1177480	0	0
46298765	1112807	0	0
45799209	1549786	0	0
45789022	1310149	0	0
46239897	1115171	2	3
46241824	40229134	2	3
4180628	196456	5	5
4171379	4056621	3	4
19074843	19074843	0	0
21002493	1512674	0	0
35508029	1000560	0	0
36217216	40228214	2	3
36303153	81151	7	12
36470077	1125315	0	0
42804547	1545959	2	3
44352276	1738521	0	0
44338317	1149196	0	0
45662136	19008572	2	3
45643550	1192710	0	0
45651991	1115171	2	3
45667726	1539411	2	3
45623321	1149380	0	0
45663949	1125315	0	0
45670624	19059056	2	3
45779428	1174888	0	0
45783599	1119510	0	0
45780713	1174888	0	0
45699696	1107830	0	0
45782527	1177480	0	0
45706172	975125	0	0
45876249	3005136	3	4
45792731	1539411	2	3
45895522	1177480	0	0
46298892	1112807	0	0
45799216	1149196	0	0
45789031	1717327	0	0
46239944	40229134	2	3
45897899	1115171	2	3
4180628	4027663	5	5
4095203	4146173	3	4
19075601	19075601	0	0
21002508	1589505	0	0
35507923	1115008	0	0
36217216	40173590	2	3
36303153	258780	7	12
36470101	1119510	0	0
42807317	19123231	2	3
44352310	1322184	0	0
44338318	1192710	0	0
45662148	19059056	2	3
45640779	1192710	0	0
45652006	1551192	2	3
45653582	1332419	2	3
45621408	1107830	0	0
45664159	1125315	0	0
45670616	40228214	2	3
45779408	1332418	0	0
45783567	1119510	0	0
45780939	1115008	0	0
45699688	1192710	0	0
45782279	1177480	0	0
45706301	1154343	0	0
45876249	40758406	3	4
45790136	1539411	2	3
45896578	1177480	0	0
46290396	1112807	0	0
45799219	1305058	0	0
45789035	1501700	0	0
46321915	44816277	2	3
45897902	46233988	2	3
4180628	4134304	6	9
4029498	380378	1	1
4266169	4329847	3	4
21002508	1521369	0	0
35508036	1125315	0	0
36217216	46233988	2	3
36303153	37017711	8	9
36470162	1153428	0	0
42804866	19019273	2	3
44352401	1177480	0	0
44338319	1557272	0	0
45662106	19078924	2	3
45640970	1192710	0	0
45650046	1115171	2	3
45666201	1332419	2	3
45621482	1501700	0	0
45663995	1125315	0	0
45670595	19073183	2	3
45779431	723013	0	0
45779232	1119510	0	0
45780638	1000560	0	0
45699689	1153428	0	0
45782480	1177480	0	0
45706175	1713332	0	0
45876249	40769189	3	4
45895468	19128263	1	2
45679765	1129625	0	0
46290501	1112807	0	0
45799283	1115008	0	0
45789073	967823	0	0
46322225	40229134	2	3
45897978	40231925	2	3
4180628	4285898	6	9
4134312	4149245	1	1
4304916	30753	3	4
21002508	1512674	0	0
35508039	1545958	0	0
36217216	19059056	2	3
36303153	4166224	8	12
36469276	1177480	0	0
42804860	19019273	2	3
44352403	1557272	0	0
44338326	1124300	0	0
45662034	1551192	2	3
45641079	1192710	0	0
45650083	1551192	2	3
45641539	1332419	2	3
45621506	914335	0	0
45664109	1125315	0	0
45670538	40228214	2	3
45779437	738818	0	0
45779238	1119510	0	0
45780640	1343916	0	0
45696115	738818	0	0
45782603	1177480	0	0
45706334	1501700	0	0
45876249	21494966	3	4
46240071	42902245	1	2
45679794	1129625	0	0
46290717	1112807	0	0
45799402	1307863	0	0
46301961	1192710	0	0
46322236	46275916	2	3
45898002	19078461	2	3
4180628	4278672	6	7
4134439	4132546	1	1
4304916	4310024	3	4
21002508	1500211	0	0
35508040	791967	0	0
36217216	1551192	2	3
36303153	4243062	6	6
36470268	1129625	0	0
42802139	19019273	2	3
44352386	1115008	0	0
44338327	1112807	0	0
45662305	40169281	2	3
45640939	1192710	0	0
45650153	19073183	2	3
45659736	1332419	2	3
45621461	1110410	0	0
45664130	1125315	0	0
45670700	19008572	2	3
45779482	1548195	0	0
45779364	1119510	0	0
45780643	1124957	0	0
45695988	1107830	0	0
45782608	1177480	0	0
45706338	791967	0	0
45876249	40769194	3	4
45885352	4278672	1	2
45679032	1129625	0	0
46291036	1112807	0	0
45793765	1343916	0	0
46301975	1102527	0	0
46322040	40174880	2	3
45895786	19019273	2	3
4180628	40479422	6	7
4095263	4094814	1	1
4274025	317576	3	8
21002499	1595799	0	0
35507984	1309944	0	0
36217216	836659	2	3
36303153	4218389	6	8
36470268	1125315	0	0
42801990	1107882	2	3
44352003	1124300	0	0
44338327	738818	0	0
45662541	40228214	2	3
45637632	1192710	0	0
45646757	1551192	2	3
45623099	19079524	2	3
45621505	1332418	0	0
45664181	1125315	0	0
45670493	19079524	2	3
45779549	1521369	0	0
45779288	1119510	0	0
45778102	1118084	0	0
45695989	1107830	0	0
45702806	1177480	0	0
45706340	975125	0	0
45681484	1125315	0	0
45885352	4059173	1	2
45678963	1129625	0	0
46242086	1112807	0	0
45793960	967823	0	0
46301789	1124300	0	0
46321930	40229134	2	3
45895757	42707627	2	3
4040400	4078793	4	4
4050747	4278672	1	1
4223595	4048171	3	3
21002499	1515774	0	0
35508051	1332418	0	0
36217216	45892894	2	3
36303153	372328	6	9
36470446	1115008	0	0
42804642	1332419	2	3
44352228	1124300	0	0
44338464	1129625	0	0
45659150	19008572	2	3
45637673	1192710	0	0
45646775	40223821	2	3
45629608	19079524	2	3
45621621	1521369	0	0
45664139	1125315	0	0
45670458	40228214	2	3
45779549	1549786	0	0
45779290	1119510	0	0
45778450	1115008	0	0
45696105	1539403	0	0
45703048	1177480	0	0
45706302	1124300	0	0
45681567	1125315	0	0
46292579	46275916	1	1
45678968	1129625	0	0
46242519	1112807	0	0
45793924	1149196	0	0
46301827	1192710	0	0
46322265	43012036	2	3
45895794	19008572	2	3
4040400	4202451	4	4
4085546	4134304	1	1
4309188	4027663	3	3
21002499	1549786	0	0
35508052	1551099	0	0
36217216	1545959	2	3
36303153	4113008	6	9
36474554	1149196	0	0
42804696	1332419	2	3
44350234	1153428	0	0
44338212	1713332	0	0
45658878	19073183	2	3
45637766	1192710	0	0
45646869	19077572	2	3
45665249	1332419	2	3
45621621	19127890	0	0
45664144	1125315	0	0
45669045	1107882	2	3
45779549	1595799	0	0
45779319	1119510	0	0
45778451	1115008	0	0
45696207	1000560	0	0
45696263	1177480	0	0
45706215	1149196	0	0
45681436	1125315	0	0
45885353	4237458	1	1
45679073	1129625	0	0
46239621	1112807	0	0
45793970	1548195	0	0
46301878	1551099	0	0
46322283	40232448	2	3
45895857	40243436	2	3
4040400	4323902	4	4
4052559	441267	1	1
4268628	4037675	3	3
21002499	1589505	0	0
35507704	1310149	0	0
36217216	19123231	2	3
36303153	4109685	6	10
36475982	1367571	0	0
42810048	19078461	2	3
44350318	19127890	0	0
44338357	1589505	0	0
45659313	19008572	2	3
45634802	1192710	0	0
45646880	19008572	2	3
45660113	1539411	2	3
45621621	1549786	0	0
45660773	1125315	0	0
45669070	1127433	2	3
45779556	1713332	0	0
45779140	1119510	0	0
45778350	1367571	0	0
45696218	738818	0	0
45696741	1177480	0	0
45706219	1000560	0	0
45681419	1125315	0	0
45788120	19127922	1	1
45679125	1129625	0	0
46240257	1112807	0	0
45793975	1545958	0	0
46302040	1153428	0	0
46316255	1115171	2	3
45895901	40232448	2	3
4040400	4186930	4	4
4053602	4152936	1	1
4224259	4048171	3	3
21002499	19127890	0	0
35507707	967823	0	0
36217216	19073183	2	3
36303153	30753	6	10
36469202	1119510	0	0
42804629	19075601	2	3
44350318	1589505	0	0
44338361	1343916	0	0
44351574	40163554	2	3
45634552	1192710	0	0
45646888	35605482	2	3
45650279	1545959	2	3
45621433	1309944	0	0
45660925	1125315	0	0
45669122	1107882	2	3
45779508	1124300	0	0
45780701	1119510	0	0
45778473	1115008	0	0
45696085	1307863	0	0
45679964	1129625	0	0
45706309	1110410	0	0
45681552	1125315	0	0
45788120	19133679	1	1
45785848	1129625	0	0
45896258	1112807	0	0
45793975	1332418	0	0
46301761	753626	0	0
46311263	19133873	2	3
45895861	40229134	2	3
4040400	4337611	4	4
4043197	4238715	1	1
4223759	40486433	3	3
21002510	1500211	0	0
35507708	914335	0	0
36217216	40163554	2	3
36303153	378419	6	11
36427520	1729720	0	0
42805416	19075601	2	3
44350318	1549786	0	0
44338278	1107830	0	0
44351485	1545959	2	3
45637315	1192710	0	0
45646826	40163554	2	3
45656864	1545959	2	3
45621525	791967	0	0
45660946	1125315	0	0
45669215	43012036	2	3
45779461	738818	0	0
45779437	1119510	0	0
45778475	705944	0	0
45696068	19003953	0	0
45680078	1129625	0	0
45706313	1149196	0	0
45681632	1125315	0	0
45788120	19129144	1	1
45785851	1129625	0	0
45896444	1112807	0	0
45793978	1305058	0	0
46301766	1000560	0	0
46311134	1551192	2	3
45895851	40232448	2	3
4043161	4202451	4	4
4040976	4043071	1	1
4223759	4280726	3	3
21002510	1512674	0	0
35507710	967823	0	0
21604343	1127433	1	4
36303153	4134304	9	13
36427514	1728416	0	0
42805871	19075601	2	3
44350321	1549786	0	0
44338280	738818	0	0
44778204	1545959	2	3
45631644	1192710	0	0
45646951	19112599	2	3
45656846	1545959	2	3
45621497	1115008	0	0
45660947	1125315	0	0
45669178	19008572	2	3
45779606	1174888	0	0
45779438	1119510	0	0
45778546	1115008	0	0
45696225	1192710	0	0
45677944	1129625	0	0
45706271	1549786	0	0
45681612	1125315	0	0
46296921	46275916	1	1
45786040	1129625	0	0
45896359	1112807	0	0
45793986	1589505	0	0
46302059	920293	0	0
46311338	1154615	2	3
45895956	19075001	2	3
4040396	4275113	4	4
4040551	4218408	1	1
4224260	40486433	3	3
21002508	1548195	0	0
35507846	933724	0	0
21604753	19123231	1	4
36303153	317009	5	6
36427581	1102527	0	0
42804762	19075601	2	3
44350313	715997	0	0
44338088	1501700	0	0
45634111	19019273	2	3
45631651	1192710	0	0
45647105	40173590	2	3
45629773	1539411	2	3
45621565	1307863	0	0
45660997	1125315	0	0
45669161	43012036	2	3
45779515	1110410	0	0
45779489	1119510	0	0
45778549	738818	0	0
45696132	1521369	0	0
45677894	1129625	0	0
45706271	19127890	0	0
45681560	1125315	0	0
46289049	19079524	1	1
45786543	1129625	0	0
45896343	1112807	0	0
45794104	1539403	0	0
46302087	1192710	0	0
46311579	19133905	2	3
45896116	40229134	2	3
4040396	42535580	4	4
4134294	198809	1	1
4224260	4280726	3	3
21002510	1521369	0	0
35507858	975125	0	0
21604753	40236446	1	4
36303153	4027663	5	9
36423637	19134077	1	1
42802204	19075601	2	3
44350333	1778162	0	0
44338101	1115008	0	0
45625474	40223834	2	3
45632199	1192710	0	0
45647039	19059056	2	3
45663799	1539411	2	3
45621639	1551099	0	0
45660777	1125315	0	0
45669294	19129655	2	3
45779516	1557272	0	0
45779461	1119510	0	0
45778396	1343916	0	0
45696134	1149380	0	0
45677904	1129625	0	0
45706271	1589505	0	0
45679754	1125315	0	0
46238603	19134077	1	1
45786676	1129625	0	0
45893989	1112807	0	0
45794128	914335	0	0
46302095	1149380	0	0
46322125	19008572	2	3
45896167	40229134	2	3
4040396	4242997	4	4
4181187	4283893	1	1
4299725	4057420	3	3
21002572	1746114	0	0
35507862	1192710	0	0
35506943	19127904	1	2
36303153	44782520	5	8
36303194	4052083	1	1
42805460	19075601	2	3
44350258	1110410	0	0
44338102	1174888	0	0
45625474	40223821	2	3
45631840	1192710	0	0
45646969	19008572	2	3
45629944	1539411	2	3
45621745	1305058	0	0
45660829	1125315	0	0
45669278	19019273	2	3
45707934	975125	0	0
45707949	1119510	0	0
45778410	1367571	0	0
45696140	723013	0	0
45679771	1129625	0	0
45706283	975125	0	0
45679577	1125315	0	0
45696872	46275916	1	1
45786134	1129625	0	0
45894001	1112807	0	0
45793706	1500211	0	0
46302099	967823	0	0
46317368	19018935	2	3
45895984	43012036	2	3
4040396	4330583	4	4
4134423	4199276	1	1
4304916	4027663	3	3
21002574	1746114	0	0
35507869	967823	0	0
36216814	40231925	1	2
36303153	40480160	5	11
36313965	4191853	1	1
42804460	1539411	2	3
44350347	1539403	0	0
44338375	1192710	0	0
45658652	40223834	2	3
45631758	1192710	0	0
45647087	40229134	2	3
45632642	19078461	2	3
45621755	1595799	0	0
45660489	1125315	0	0
45669379	40229134	2	3
45707941	1713332	0	0
45708243	1119510	0	0
45778537	1149196	0	0
45696255	1115008	0	0
45674626	1129625	0	0
45706291	1110410	0	0
45679782	1125315	0	0
45696715	19079524	1	1
45786199	1129625	0	0
45894023	1112807	0	0
45794067	1717327	0	0
46301814	1332418	0	0
46306560	19133905	2	3
45804242	1115171	2	3
4043022	4337138	4	4
4169307	4174876	1	1
4266169	317576	3	3
21002574	1717327	0	0
35508008	1124300	0	0
36216815	40231925	1	2
36303153	134438	4	9
36503252	80502	1	1
42803145	1539411	2	3
44350323	715997	0	0
44338530	975125	0	0
45658652	40223821	2	3
45628746	1192710	0	0
45647004	1127433	2	3
45636004	1539411	2	3
45621755	1549786	0	0
45660533	1125315	0	0
45669144	40231925	2	3
45707997	967823	0	0
45708187	1119510	0	0
45778539	1396131	0	0
45696256	738818	0	0
45674646	1129625	0	0
45706249	1192710	0	0
45678191	1125315	0	0
45876168	3006322	1	1
46292643	1129625	0	0
45798527	738818	0	0
45794081	1124957	0	0
46301815	1551099	0	0
46305976	19133873	2	3
45804102	920300	2	3
4043023	4323902	4	4
4138127	4163971	1	1
4266169	321042	3	3
21002591	1728416	0	0
35508013	1177480	0	0
36219307	1150837	1	2
36303153	4084167	4	7
36503269	80180	1	1
42807056	1539411	2	3
44350270	1713332	0	0
44338519	1192710	0	0
45628470	1551192	2	3
45628602	1192710	0	0
45646143	1154615	2	3
45654049	1539411	2	3
45621755	1521369	0	0
45660661	1125315	0	0
45669466	1107882	2	3
45707962	740275	0	0
45707913	1119510	0	0
45778464	1500211	0	0
45696280	1192710	0	0
45674807	1129625	0	0
45706482	1154343	0	0
45678085	1125315	0	0
46291552	19079524	1	1
46293076	1129625	0	0
45798492	738818	0	0
45794086	1343916	0	0
46301817	1396131	0	0
46306190	19133905	2	3
45804104	40229134	2	3
4043023	4337611	4	4
4180627	4198190	7	10
4326835	4012477	3	3
21002510	1549786	0	0
35508139	1332418	0	0
36219308	1150837	1	2
36303153	4202451	4	7
36227313	19079524	1	2
42805680	40223768	2	3
44350244	738818	0	0
44338475	1548195	0	0
45652124	1332419	2	3
45628725	1192710	0	0
45643939	19133768	2	3
45639142	1539411	2	3
45621651	723013	0	0
45660880	1125315	0	0
45669314	1127433	2	3
45707973	1308738	0	0
45708297	1119510	0	0
45778491	920293	0	0
45696285	1192710	0	0
45674602	1129625	0	0
45706190	975125	0	0
45678292	1125315	0	0
46288534	19079524	1	1
46293166	1129625	0	0
45798843	738818	0	0
45794092	1717327	0	0
46301818	791967	0	0
46306574	1115171	2	3
45804138	1127433	2	3
4048365	4314290	4	4
4180627	4163971	7	8
4326835	4314290	3	3
21002511	1500211	0	0
35508172	1119510	0	0
36219363	19057271	1	2
36300000	4314290	4	8
36224524	46233710	1	2
42807153	19078461	2	3
44350596	1153428	0	0
44338433	1332418	0	0
45634185	19019273	2	3
45626013	1192710	0	0
45643892	19008572	2	3
45644888	1539411	2	3
45621760	1713332	0	0
45660951	1125315	0	0
45666632	19008572	2	3
45707974	791967	0	0
45705360	1119510	0	0
45778492	1501700	0	0
45696290	975125	0	0
45674980	1129625	0	0
45706194	1332418	0	0
45678294	1125315	0	0
45679150	19079524	1	1
46292990	1129625	0	0
45793192	738818	0	0
45793809	1545958	0	0
46301792	1539403	0	0
46306243	19059056	2	3
45803748	1115171	2	3
4048365	4012477	4	4
4094284	78272	7	7
4239721	433644	1	1
21002591	1768849	0	0
35508177	1119510	0	0
36213180	1150771	1	2
36300000	196456	6	12
36224524	46233988	1	2
42870893	3021226	3	3
44350563	19127890	0	0
44338289	791967	0	0
45628632	19019273	2	3
45622843	1192710	0	0
45644067	19133768	2	3
45645099	1539411	2	3
45621770	1713332	0	0
45660962	1125315	0	0
45666783	1127433	2	3
45707980	1118084	0	0
45705449	1119510	0	0
45778493	701322	0	0
45696476	1501700	0	0
45674898	1129625	0	0
45706292	1115008	0	0
45678247	1125315	0	0
46297099	19079524	1	1
46288160	1129625	0	0
45793194	738818	0	0
45794107	1124300	0	0
46301793	1115008	0	0
46306246	19008572	2	3
45804212	40229134	2	3
4096864	195588	4	4
4134598	4198190	7	7
4239721	4219399	1	1
21002597	1713332	0	0
35508177	1125315	0	0
36102932	433125	1	2
36300000	4246502	6	6
36227221	40220386	1	2
43531052	81893	7	8
44350563	1589505	0	0
44338434	1129625	0	0
45631427	19019273	2	3
45622396	1192710	0	0
45644043	42707627	2	3
45666095	1539411	2	3
45621742	1149196	0	0
45657861	1125315	0	0
45666962	19078924	2	3
45707981	753626	0	0
45705452	1119510	0	0
45778510	1107830	0	0
45696337	1322184	0	0
45674777	1129625	0	0
45706293	1396131	0	0
45678255	1125315	0	0
46288565	19079524	1	1
46288313	1129625	0	0
45793441	738818	0	0
45793945	1551099	0	0
46301863	1107830	0	0
46306773	40232448	2	3
45876069	3016723	2	3
4096864	198809	4	4
4113008	4113008	0	0
4238715	4186930	1	1
21002591	1778162	0	0
35508177	738818	0	0
36102934	28060	1	2
36300000	4029498	7	10
36227104	40165015	1	2
42802175	19128022	1	2
44350563	1549786	0	0
44338436	791967	0	0
45634501	19019273	2	3
45622649	1192710	0	0
45643993	43012036	2	3
45635950	46275916	1	1
45621871	1595799	0	0
45657981	1125315	0	0
45667030	40236824	2	3
45708042	914335	0	0
45705486	1119510	0	0
45778513	738818	0	0
45696232	1343916	0	0
45671816	1129625	0	0
45706305	1124957	0	0
45678393	1125315	0	0
45876060	3016723	3	4
46288045	1129625	0	0
45793294	738818	0	0
45793956	1115008	0	0
46298753	967823	0	0
46317223	40162522	2	3
45876069	3000963	2	3
4182161	4283893	4	4
4052083	4052083	0	0
4239975	4329847	1	1
21002591	1741122	0	0
35508142	1551099	0	0
36102971	260139	1	2
36300000	317576	7	13
36227038	920334	1	2
42802175	19128263	1	2
44350354	19010482	0	0
44338094	1177480	0	0
44778223	46233710	2	3
45622863	1192710	0	0
45644004	40232448	2	3
45635950	19079524	1	1
45621871	1521369	0	0
45657871	1125315	0	0
45667040	1127433	2	3
45708050	1548195	0	0
45705434	1119510	0	0
45778522	1124300	0	0
45696152	967823	0	0
45671826	1129625	0	0
45700609	1738521	0	0
45678396	1125315	0	0
45876060	3000963	3	4
46288741	1129625	0	0
45787862	738818	0	0
45794257	1124957	0	0
46299547	1551099	0	0
46322347	43012036	2	3
45798674	1115171	2	3
4182161	4156265	4	4
4195803	4195803	0	0
4250749	37017711	1	1
21002591	1713332	0	0
35508143	933724	0	0
36212939	40243436	1	2
36300000	133834	11	13
36227051	46275444	1	2
42810281	1149380	0	0
44350378	1112807	0	0
44338256	1307863	0	0
45621218	40228214	2	3
45621954	1192710	0	0
45644010	1107882	2	3
45666004	46275916	1	1
45621871	1549786	0	0
45658103	1125315	0	0
45666895	19019273	2	3
45708050	1589505	0	0
45705692	1119510	0	0
45780676	1149196	0	0
45696158	738818	0	0
45671972	1129625	0	0
45700669	1367571	0	0
45678499	1125315	0	0
45876060	3006906	3	3
46288685	1129625	0	0
45787878	738818	0	0
45794225	1107830	0	0
46299549	738818	0	0
46322654	1545959	2	3
45798475	19078924	2	3
4083787	4296204	4	4
4197460	4197460	0	0
4250749	4240902	1	1
21002591	1746114	0	0
35508084	1125315	0	0
36219362	1107882	1	2
36300000	381316	8	11
36227036	920300	1	2
42808846	975125	0	0
44350292	1713332	0	0
44338525	1332418	0	0
45662257	19078924	2	3
45621426	1192710	0	0
45643983	19078924	2	3
45666004	19079524	1	1
45621872	967823	0	0
45658102	1125315	0	0
45666847	19008572	2	3
45708065	1551099	0	0
45705510	1119510	0	0
45780603	914335	0	0
45696160	1192710	0	0
45671974	1129625	0	0
45700671	1307863	0	0
45678336	1125315	0	0
45885353	4230399	3	3
46244802	1129625	0	0
45788240	738818	0	0
45794228	933724	0	0
46299489	1174888	0	0
46317908	1332419	2	3
45798592	40162522	2	3
4134148	4275113	4	4
21000705	1539403	0	0
4251030	4243062	1	1
21002591	1729720	0	0
35508091	1000560	0	0
36219362	19125062	1	2
36300000	4283893	8	12
36227037	920334	1	2
42809095	1112807	0	0
44350296	738818	0	0
44338496	791967	0	0
45631287	19078924	2	3
45664883	1192710	0	0
45644096	1127433	2	3
45632971	46275916	1	1
45621823	1107830	0	0
45658181	1125315	0	0
45666852	19078461	2	3
45708146	1115008	0	0
45705734	1119510	0	0
45780608	1717327	0	0
45696163	1309944	0	0
45671743	1129625	0	0
45700675	1153428	0	0
45678341	1125315	0	0
45876047	3000963	4	4
46244646	1129625	0	0
45788070	738818	0	0
45794269	1149196	0	0
46298973	1124957	0	0
46321770	19019273	2	3
45798704	1127433	2	3
4083964	40479422	4	4
21000706	1332418	0	0
4252853	4112343	1	1
21002597	1717327	0	0
35508066	1332418	0	0
36222255	19075601	1	2
36300000	195588	8	13
36227037	920300	1	2
42807371	1118084	0	0
44350658	1112807	0	0
44338553	1177480	0	0
44351784	40223768	2	3
45662701	1192710	0	0
45644096	19078461	2	3
45632971	19079524	1	1
45621848	715997	0	0
45658161	1125315	0	0
45666983	35605482	2	3
45707884	1149380	0	0
45702004	1119510	0	0
45780518	1107830	0	0
45696266	967823	0	0
45672108	1129625	0	0
45700676	1124300	0	0
45678425	1125315	0	0
45795361	19127918	3	4
46244656	1129625	0	0
45788093	738818	0	0
45794204	791967	0	0
46299371	933724	0	0
46322302	19019273	2	3
45799681	40232448	2	3
4083964	40479768	4	4
21000713	1551099	0	0
4218017	4043241	1	1
21001912	1551099	0	0
35508148	1177480	0	0
36219361	19125062	1	2
36300000	260139	8	13
36503271	80809	1	2
42807373	1309944	0	0
44350253	742185	0	0
44338529	1149196	0	0
44344513	40223768	2	3
45662660	1192710	0	0
45644075	920334	2	3
45644856	19079524	1	1
45621849	1149196	0	0
45658217	1125315	0	0
45667047	920334	2	3
45707884	1137529	0	0
45702010	1119510	0	0
45780521	738818	0	0
45696165	975125	0	0
45672120	1129625	0	0
45700679	1549786	0	0
45678357	1125315	0	0
45679525	975125	0	0
46243358	1129625	0	0
46294030	738818	0	0
45794220	1154029	0	0
46299383	1717327	0	0
46239758	1539411	2	3
45799850	1545959	2	3
4029698	4198190	4	4
21000716	1177480	0	0
4219484	443279	1	1
21001947	1729720	0	0
21604757	705944	0	0
36219361	1107882	1	2
36300000	4329847	8	14
36227567	1519937	1	2
42809371	1125315	0	0
44350395	738818	0	0
44338508	1177480	0	0
45652540	19075001	2	3
45662662	1192710	0	0
45644236	40232448	2	3
45667985	19079524	1	1
45621852	1713332	0	0
45658148	1125315	0	0
45667121	19074843	2	3
45707855	705944	0	0
45702089	1119510	0	0
45780523	738818	0	0
45696171	1521369	0	0
45671905	1129625	0	0
45700679	1595799	0	0
45678353	1125315	0	0
45679375	975125	0	0
46243379	1129625	0	0
46293543	738818	0	0
45788663	715997	0	0
46299553	738818	0	0
45788820	1545959	2	3
45799859	40231925	2	3
4181187	4048171	4	4
21000716	1118084	0	0
4221994	4187458	1	1
21001953	975125	0	0
21604320	1112807	0	0
36213167	19059056	1	2
36300000	4116491	9	11
36303194	4133840	1	2
42808448	1115008	0	0
44350470	1551099	0	0
44338499	1112807	0	0
45633948	40173590	2	3
45656557	1192710	0	0
45641287	1115171	2	3
45641752	19079524	1	1
45621926	1154029	0	0
45658157	1125315	0	0
45667057	43012036	2	3
45708135	1115008	0	0
45701822	1119510	0	0
45706970	1124300	0	0
45696171	1595799	0	0
45672026	1129625	0	0
45700679	1521369	0	0
45674853	1125315	0	0
45679720	1174888	0	0
46243545	1129625	0	0
46243663	738818	0	0
45788666	1729720	0	0
46299563	975125	0	0
46289656	1545959	2	3
45798977	40174880	2	3
4049222	40486433	4	4
21000736	967823	0	0
19099291	44816277	1	1
21001868	1154343	0	0
21602499	1589505	0	0
36216540	19074843	1	2
36300000	4278672	9	13
36313965	4012477	2	5
42816239	1119510	0	0
44350334	1551099	0	0
44338503	1124957	0	0
45634052	19073183	2	3
45656176	1192710	0	0
45641012	1127433	2	3
45633020	19079524	1	1
45621927	1548195	0	0
45657764	1125315	0	0
45667088	19008572	2	3
45708136	1107830	0	0
45701824	1119510	0	0
45706982	1549786	0	0
45696171	1549786	0	0
45672157	1129625	0	0
45700642	1107830	0	0
45674935	1125315	0	0
45679706	1154029	0	0
46240943	1129625	0	0
46243774	738818	0	0
45788667	1154343	0	0
46299154	1551099	0	0
45788399	1545959	2	3
45799000	19019273	2	3
4049222	4280726	4	4
21000295	1738521	0	0
19020937	19029476	1	1
21001950	1738521	0	0
21602504	1519936	0	0
36216540	19074841	1	2
36300000	4102123	9	10
36503263	80809	2	4
42811089	1125315	0	0
44350336	1112807	0	0
44338449	1192710	0	0
45620884	19073183	2	3
45658412	1192710	0	0
45641118	19019273	2	3
45645194	19079524	1	1
45621597	920293	0	0
45657903	1125315	0	0
45780939	1115171	2	3
45708233	1501700	0	0
45701846	1119510	0	0
45706982	1595799	0	0
45696275	1110410	0	0
45671774	1129625	0	0
45699701	1549786	0	0
45675293	1125315	0	0
45679464	1548195	0	0
46242166	1129625	0	0
46244772	738818	0	0
45788674	1149196	0	0
46298821	1549786	0	0
46298265	1539411	2	3
45799006	40229134	2	3
4172515	4043071	4	4
21000290	1759842	0	0
4322048	4275113	1	1
21001919	1154343	0	0
21601767	1307863	0	0
36213168	19059056	1	2
36300000	441267	9	10
36503263	80180	2	3
42809371	1119510	0	0
44350426	1149196	0	0
44338615	1557272	0	0
45628166	19078461	2	3
45653011	1192710	0	0
45641128	40228230	2	3
45644845	19079524	1	1
45621882	1124300	0	0
45657919	1125315	0	0
45778415	40232448	2	3
45708234	1149380	0	0
45701852	1119510	0	0
45706982	1521369	0	0
45696273	723013	0	0
45784048	1129625	0	0
45699701	19127890	0	0
45675211	1125315	0	0
45679850	1501700	0	0
46242170	1129625	0	0
46244777	738818	0	0
45789345	1322184	0	0
46298823	791967	0	0
45793762	1539411	2	3
45793556	40163554	2	3
4121042	4202451	4	4
21000285	1778162	0	0
4287321	4202451	1	1
21001853	1768849	0	0
35508129	1119510	0	0
35205190	4329847	1	1
36300000	4302207	9	10
36463290	1127433	2	3
42809410	1115008	0	0
44350428	1149380	0	0
44338620	1112807	0	0
45634652	19078461	2	3
45653531	1192710	0	0
45641295	40174880	2	3
45648154	19079524	1	1
45667477	1107830	0	0
45658323	1125315	0	0
45778416	40232448	2	3
45707897	1738521	0	0
45702189	1119510	0	0
45706985	967823	0	0
45696341	1153428	0	0
45784041	1129625	0	0
45699701	1589505	0	0
45675214	1125315	0	0
45679853	1107830	0	0
46242299	1129625	0	0
46244780	738818	0	0
45789181	1501700	0	0
46299390	1115008	0	0
45893695	1539411	2	3
45793672	40229134	2	3
4043346	4142905	4	4
21000292	1738521	0	0
19112768	19074679	1	1
21001936	1746114	0	0
35508129	1125315	0	0
35204969	313217	1	1
36300000	4139681	9	10
36463190	40224805	2	3
42811090	1149196	0	0
44350435	1332418	0	0
44338561	1332418	0	0
45664503	19078461	2	3
45653103	1192710	0	0
45642908	19078461	2	3
45635732	19079524	1	1
45667316	1501700	0	0
45658326	1125315	0	0
45778450	1115171	2	3
45708150	1000560	0	0
45702068	1119510	0	0
45707166	1589505	0	0
45696485	738818	0	0
45784174	1129625	0	0
45699755	1115008	0	0
45675229	1125315	0	0
45678987	1343916	0	0
46241199	1129625	0	0
46238984	738818	0	0
45789417	1738521	0	0
46299402	1521369	0	0
45801641	1539411	2	3
45793641	1115171	2	3
4043346	321042	4	4
21000291	1738521	0	0
4267297	198809	1	1
21001936	1717327	0	0
35508129	1192710	0	0
35205164	317576	1	1
36300000	378001	10	14
36422283	40220960	2	3
42820455	738818	0	0
44350440	975125	0	0
44338234	738818	0	0
44778004	40228214	2	3
45652988	1192710	0	0
45642973	40232448	2	3
45641859	19079524	1	1
45667317	738818	0	0
45658329	1125315	0	0
45778451	1115171	2	3
45708105	1309944	0	0
45702129	1119510	0	0
45707050	1539403	0	0
45696604	1307863	0	0
45784070	1129625	0	0
45699760	1738521	0	0
45675231	1125315	0	0
45678989	1521369	0	0
46241297	1129625	0	0
46239295	738818	0	0
45788701	1501700	0	0
46299402	1549786	0	0
45799257	1539411	2	3
45793642	1115171	2	3
4180170	40486433	4	4
21000683	1308738	0	0
4226263	28060	1	1
21001907	975125	0	0
35508074	1501700	0	0
35502641	140673	1	1
36300000	4048171	10	15
36463335	1115171	2	3
42820568	1125315	0	0
44350441	1501700	0	0
44338512	1549786	0	0
45662243	1107882	2	3
45647017	1192710	0	0
45642987	40228214	2	3
45660471	46275916	1	1
45667276	715997	0	0
45658305	1125315	0	0
45778362	40232448	2	3
45708243	738818	0	0
45702159	1119510	0	0
45779383	1125315	0	0
45696321	967823	0	0
45784086	1129625	0	0
45699762	1118084	0	0
45675013	1125315	0	0
45678989	1548195	0	0
46238500	1129625	0	0
45894584	738818	0	0
45788780	742185	0	0
46298804	975125	0	0
46241764	1539411	2	3
45793790	40232448	2	3
4180170	260139	4	4
21000701	1332418	0	0
19123230	19123231	1	1
21001907	1551099	0	0
35508076	1000560	0	0
35506777	140673	1	1
36503289	40486433	5	5
36469629	1115171	2	3
42816558	1153428	0	0
44350445	1112807	0	0
44338512	1589505	0	0
45640438	1107882	2	3
45646951	1192710	0	0
45641309	19019273	2	3
45660471	19079524	1	1
45667279	1343916	0	0
45654640	1125315	0	0
45778363	1127433	2	3
45708075	1326303	0	0
45702224	1119510	0	0
45779399	1125315	0	0
45696608	1107830	0	0
45781961	1129625	0	0
45699710	19003953	0	0
45675193	1125315	0	0
45679017	1102527	0	0
46238507	1129625	0	0
45894620	738818	0	0
45788757	1149196	0	0
46299595	1539403	0	0
46297472	19128009	1	2
45793853	40232448	2	3
4180170	4280726	4	4
21000701	1545958	0	0
19076574	19045231	1	1
21001924	1768849	0	0
35508264	1501700	0	0
35708603	28060	1	1
36503289	317576	5	5
36470446	1115171	2	3
42807861	1125315	0	0
44350472	1118084	0	0
44338237	1107830	0	0
45664715	1107882	2	3
45643853	1192710	0	0
45641387	19019273	2	3
45648060	19079524	1	1
45667484	1174888	0	0
45654657	1125315	0	0
45778473	19019273	2	3
45708093	1115008	0	0
45699250	1119510	0	0
45779290	1125315	0	0
45696610	1192710	0	0
45781985	1129625	0	0
45699785	1174888	0	0
45675266	1125315	0	0
45679025	791967	0	0
46238484	1129625	0	0
45894666	738818	0	0
45788721	1322184	0	0
46298835	1729720	0	0
45804114	19128263	1	2
45793804	40229134	2	3
4180170	4294548	4	4
21000300	1728416	0	0
4288463	4238715	1	1
21001924	1778162	0	0
35508265	1501700	0	0
36102960	440448	1	1
36503289	4280726	5	5
36427581	40165015	2	3
42810477	1112807	0	0
44350588	1153428	0	0
44338242	1112807	0	0
45625076	1332419	2	3
45643926	1192710	0	0
45641463	42707627	2	3
45663811	46275916	1	1
45667495	1549786	0	0
45654665	1125315	0	0
45778414	43012036	2	3
45708185	791967	0	0
45699192	1119510	0	0
45780628	1125315	0	0
45696348	1738521	0	0
45782075	1129625	0	0
45699789	1309944	0	0
45676427	1125315	0	0
45679040	1112807	0	0
46238335	1129625	0	0
45801595	738818	0	0
45788762	914335	0	0
46298838	1343916	0	0
45804114	19128022	1	2
45793588	19008572	2	3
4181192	4108705	4	4
21000297	1738521	0	0
4287856	4202832	1	1
21002159	1746114	0	0
35508266	1177480	0	0
36102966	372328	1	1
36503289	134438	5	5
36463252	19019273	2	3
42810664	1589505	0	0
44350590	1124300	0	0
44338242	1192710	0	0
45658978	1107882	2	3
45643928	1192710	0	0
45641310	1107882	2	3
45663811	19079524	1	1
45667495	1589505	0	0
45654667	1125315	0	0
45778539	19077344	2	3
45708308	1107830	0	0
45699305	1119510	0	0
45780629	1125315	0	0
45696350	1305058	0	0
45781902	1129625	0	0
45699896	1153428	0	0
45672204	1125315	0	0
45679055	1149380	0	0
46238339	1129625	0	0
45801566	738818	0	0
45788704	1107830	0	0
46299511	1174888	0	0
500000503	192671	1	1
45788208	40223768	2	3
4042141	372328	4	4
21000299	1728416	0	0
21001459	40171902	1	1
21002159	1717327	0	0
35508232	1149196	0	0
36102971	255848	1	1
36503289	40479422	5	7
36463282	19019273	2	3
42810830	1119510	0	0
44350591	1174888	0	0
44338421	1149196	0	0
45658694	1107882	2	3
45643993	1192710	0	0
45637822	19008572	2	3
45644647	19079524	1	1
45667389	1308738	0	0
45654292	1125315	0	0
45778464	40224132	2	3
45708194	975125	0	0
45699185	1119510	0	0
45780701	1125315	0	0
45696360	1153428	0	0
45781995	1129625	0	0
45699900	1332418	0	0
45671909	1125315	0	0
45679059	1112807	0	0
46238357	1129625	0	0
45795901	738818	0	0
45788720	1589505	0	0
46299245	1107830	0	0
500000901	321042	1	1
45788176	40229134	2	3
4134134	375671	4	4
21000299	1729720	0	0
21000953	19074679	1	1
21002247	975125	0	0
35508238	1738521	0	0
21603288	40169281	1	1
36503289	40479768	5	7
36475983	19078461	2	3
42810849	1125315	0	0
44350592	967823	0	0
44338428	1310149	0	0
45643073	1107882	2	3
45644015	1192710	0	0
45638095	19077344	2	3
45642134	19079524	1	1
45667281	1367571	0	0
45654299	1125315	0	0
45778491	920334	2	3
45708195	1174888	0	0
45699355	1119510	0	0
45780862	1125315	0	0
45696504	1153428	0	0
45781956	1129625	0	0
45699914	1149196	0	0
45672251	1125315	0	0
45679087	1310149	0	0
46238672	1129625	0	0
45796250	738818	0	0
45788691	1309944	0	0
46299217	1738521	0	0
500000902	321042	1	1
45788317	40232448	2	3
4134134	378001	4	4
21000313	975125	0	0
21001432	40171902	1	1
21002132	1746114	0	0
35508240	1545958	0	0
21604343	19133768	3	4
36503289	133834	7	7
36428428	40169281	2	3
42817873	1119510	0	0
44350410	1322184	0	0
44338430	1107830	0	0
45622019	19078461	2	3
45641216	1192710	0	0
45638075	1127433	2	3
45653873	19079524	1	1
45665340	1545958	0	0
45654587	1125315	0	0
45778510	1107882	2	3
45707902	791967	0	0
45699512	1119510	0	0
45780732	1125315	0	0
45696511	1322184	0	0
45781958	1129625	0	0
45699817	1174888	0	0
45672312	1125315	0	0
45679152	1192710	0	0
45897433	1129625	0	0
45796199	738818	0	0
45788748	1549786	0	0
46299522	738818	0	0
500000903	321042	1	1
45788568	1115171	2	3
4043160	4107731	4	4
21000301	1728416	0	0
21001432	1332419	2	3
21002166	975125	0	0
35508371	1332418	0	0
35204998	317576	3	4
36503289	381316	4	4
36468849	19078461	2	3
42817902	1119510	0	0
44350599	1149380	0	0
44338588	1557272	0	0
45645968	1332419	2	3
45641116	1192710	0	0
45638059	19073183	2	3
45660354	46275916	1	1
45665034	1501700	0	0
45654703	1125315	0	0
45778521	19059056	2	3
45707903	1332418	0	0
45699517	1119510	0	0
45779428	1125315	0	0
45696512	738818	0	0
45782211	1129625	0	0
45699821	1343916	0	0
45672051	1125315	0	0
45679167	1192710	0	0
45897447	1129625	0	0
45796179	738818	0	0
45788748	1521369	0	0
46299283	1115008	0	0
500001801	321042	1	1
45788570	40232448	2	3
4104157	45769019	4	4
21000315	975125	0	0
21001455	19059056	2	3
21002168	975125	0	0
35508372	1115008	0	0
36100000	257012	3	4
36503289	4149245	4	5
36422228	40173590	2	3
42816848	1149380	0	0
44350602	1177480	0	0
44338595	1129625	0	0
44358062	1332419	2	3
45641253	1192710	0	0
45638045	40232448	2	3
45660354	19079524	1	1
45665241	1539403	0	0
45654415	1125315	0	0
45780608	19129655	2	3
45708012	1343916	0	0
45699518	1119510	0	0
45779403	1125315	0	0
45696517	1713332	0	0
45779738	1129625	0	0
45699769	1115008	0	0
45672213	1125315	0	0
45679169	1107830	0	0
45897638	1129625	0	0
45791011	738818	0	0
45788727	1137529	0	0
46299462	1307863	0	0
500001801	313217	1	1
45788607	19059056	2	3
4134443	40479422	4	4
21000301	1738521	0	0
21001455	1539411	2	3
21002134	1746114	0	0
35508463	1125315	0	0
36152687	19133679	3	4
36503289	81151	4	8
36463361	1107882	2	3
42816865	1149196	0	0
44350577	1738521	0	0
44338545	1332418	0	0
45640219	1332419	2	3
45642982	1192710	0	0
45638171	1713671	2	3
45635671	19079524	1	1
45665305	1310149	0	0
45654431	1125315	0	0
45707153	1115171	2	3
45708247	740275	0	0
45695749	1119510	0	0
45779437	1125315	0	0
45696519	1154343	0	0
45779760	1129625	0	0
45699831	1154343	0	0
45672200	1125315	0	0
45679178	1112807	0	0
45897575	1129625	0	0
45791895	738818	0	0
45788727	1149380	0	0
46301558	1343916	0	0
46311637	46275916	1	1
45788598	40162522	2	3
4134443	40479768	4	4
21000314	975125	0	0
21001455	19075601	2	3
21002135	1741122	0	0
35508463	1129625	0	0
36206173	3000876	3	6
36503289	78272	4	9
36463429	1107882	2	3
42816957	1149380	0	0
44350385	1154029	0	0
44338546	1118084	0	0
45664318	1332419	2	3
45642970	1192710	0	0
45638169	1154615	2	3
45623802	46275916	1	1
45665313	1343916	0	0
45654432	1125315	0	0
45707254	1107882	2	3
45708078	1115008	0	0
45697704	1119510	0	0
45779443	1125315	0	0
45696650	975125	0	0
45779793	1129625	0	0
45699838	975125	0	0
45672563	1125315	0	0
45679069	19010482	0	0
45897711	1129625	0	0
45791855	738818	0	0
45788699	1115008	0	0
46301720	1000560	0	0
45801388	19074679	1	1
45788541	1551192	2	3
4176642	4035793	4	4
19131647	19132304	0	0
21001455	1545959	2	3
21002146	1741122	0	0
35508463	1119510	0	0
36206173	3015076	3	6
36503288	4113008	6	6
36423511	40228214	2	3
42818360	1125315	0	0
44350567	1149380	0	0
44338589	920293	0	0
45625594	19075601	2	3
45642919	1192710	0	0
45638380	19133873	2	3
45623802	19079524	1	1
45665409	1557272	0	0
45655442	1125315	0	0
45707256	19008572	2	3
45708161	1557272	0	0
45697654	1119510	0	0
45779489	1125315	0	0
45696651	1192710	0	0
45779879	1129625	0	0
45699869	1308738	0	0
45672587	1125315	0	0
45679029	975125	0	0
45895292	1129625	0	0
45791922	738818	0	0
45788782	975125	0	0
46301574	1713332	0	0
45795850	40171902	1	1
45788684	40229134	2	3
4130526	4144583	4	4
19054876	19054876	0	0
21000703	1539411	2	3
21001967	914335	0	0
35508503	1332418	0	0
35205038	257012	3	6
36503288	4155034	6	6
36423511	40228230	2	3
42818360	1129625	0	0
44350570	1177480	0	0
44338388	1129625	0	0
44344137	1539411	2	3
45641346	1192710	0	0
45638451	19078461	2	3
45653940	19079524	1	1
45665323	1738521	0	0
45655512	1125315	0	0
45707048	40232448	2	3
45707910	1557272	0	0
45697833	1119510	0	0
45779460	1125315	0	0
45696407	1149196	0	0
45708354	1129625	0	0
45699872	967823	0	0
45672485	1125315	0	0
45679127	1717327	0	0
45895349	1129625	0	0
45792039	738818	0	0
45788783	1738521	0	0
46301590	1192710	0	0
45876029	3014599	2	2
45788499	1115171	2	3
4116777	261325	4	4
19016749	19016749	0	0
21000703	1545959	2	3
21001973	975125	0	0
35508505	1713332	0	0
4180941	4186930	3	6
36503288	4059173	6	7
36422111	19059056	2	3
42818440	1119510	0	0
44350657	1177480	0	0
44338390	1112807	0	0
45658442	19078461	2	3
45641398	1192710	0	0
45637104	1332419	2	3
45624091	19079524	1	1
45665325	1738521	0	0
45654726	1125315	0	0
45707343	40174880	2	3
45707912	1107830	0	0
45696005	1119510	0	0
45779461	1125315	0	0
45696534	1149196	0	0
45708362	1129625	0	0
45699873	1549786	0	0
45672602	1125315	0	0
45785989	1332418	0	0
45895456	1129625	0	0
46294808	738818	0	0
45788824	1738521	0	0
46301854	708298	0	0
45876029	3001247	2	2
45788505	40232448	2	3
4116777	258780	4	4
4299128	4299128	0	0
21001447	19126352	2	3
21001982	1119510	0	0
35508469	1119510	0	0
4201745	4112343	3	7
36503288	4152936	6	8
36427514	19006318	2	3
42808572	975125	0	0
44350700	933724	0	0
44338393	1124957	0	0
45643345	19079524	2	3
45638137	1192710	0	0
45634866	1154615	2	3
45639301	19079524	1	1
45665286	1501700	0	0
45654762	1125315	0	0
45707427	40228214	2	3
45707913	738818	0	0
45693077	1119510	0	0
45779606	1125315	0	0
45696543	1545958	0	0
45708348	1129625	0	0
45699873	1512674	0	0
45672381	1125315	0	0
45785936	1000560	0	0
45895385	1129625	0	0
46244039	738818	0	0
45788835	1548195	0	0
46301786	1343916	0	0
45876029	3006734	2	2
45788657	19133905	2	3
4169466	4152936	4	4
21000706	1545958	0	0
21001447	19059056	2	3
21001960	1115008	0	0
35508473	1119510	0	0
35205038	4280726	3	7
36503288	40479768	6	9
36423453	19074843	2	3
42817353	1125315	0	0
44350492	1192710	0	0
44338605	1174888	0	0
45628639	1539411	2	3
45637957	1192710	0	0
45634875	40162522	2	3
45654063	19079524	1	1
45665292	1149196	0	0
45651367	1125315	0	0
45707566	1127433	2	3
45708291	1549786	0	0
45692915	1119510	0	0
45779607	1125315	0	0
45696544	1153428	0	0
45777958	1129625	0	0
45699873	19127890	0	0
45784301	1125315	0	0
45786010	1149196	0	0
45895480	1129625	0	0
46244043	738818	0	0
45788835	1521369	0	0
46301983	975125	0	0
45876029	3015076	2	2
45788657	19133873	2	3
4042478	4163971	4	4
21000706	1539403	0	0
21000705	1545959	2	3
21001960	1125315	0	0
35508475	1192710	0	0
36200000	4296205	3	7
36503288	40479422	6	9
36423453	19074841	2	3
42820815	1125315	0	0
44350605	1192710	0	0
44338394	1154343	0	0
44351772	1539411	2	3
45638077	1192710	0	0
45648942	19078461	2	3
45623831	46275916	1	1
45665348	1124300	0	0
45651113	1125315	0	0
45707444	40228214	2	3
45708276	1110410	0	0
45692738	1119510	0	0
45707963	1125315	0	0
45696686	738818	0	0
45705945	1129625	0	0
45699857	1501700	0	0
45784353	1125315	0	0
45786052	1149196	0	0
45895505	1129625	0	0
46244100	738818	0	0
45788839	1551099	0	0
46301984	1110410	0	0
45876029	3000876	2	2
46298026	19008572	2	3
4042142	40486433	4	4
21000756	967823	0	0
21001448	19059056	2	3
21601121	1308738	0	0
35508579	1729720	0	0
36102970	4112343	3	7
36503288	4149245	5	8
36423477	19075001	2	3
42820816	1125315	0	0
44350608	1112807	0	0
44338609	1149196	0	0
45662076	1539411	2	3
45638053	1192710	0	0
45662847	1539411	2	3
45623831	19079524	1	1
45665357	1539403	0	0
45651302	1125315	0	0
45706779	19073183	2	3
45708177	1124300	0	0
45692992	1119510	0	0
45708004	1125315	0	0
45696415	1110410	0	0
45705942	1129625	0	0
45699885	1361711	0	0
45784256	1125315	0	0
45786046	1548195	0	0
45895422	1129625	0	0
46244075	738818	0	0
45788840	967823	0	0
46301985	19003953	0	0
45876029	3021226	2	2
46301446	40236446	2	3
4042142	4280726	4	4
21000713	975125	0	0
21001448	19075601	2	3
21600234	19018935	0	3
35508581	1521369	0	0
36102154	40481087	3	7
36503288	4278672	5	7
36423476	19075001	2	3
42820884	1129625	0	0
44350812	1149196	0	0
44338406	1548195	0	0
45659255	19079524	2	3
45638262	1192710	0	0
45646883	19075601	2	3
45642105	46275916	1	1
45665387	1107830	0	0
45651153	1125315	0	0
45706510	40165015	2	3
45708291	1589505	0	0
45693189	1119510	0	0
45707953	1125315	0	0
45696433	1192710	0	0
45705769	1129625	0	0
45699889	1192710	0	0
45784262	1125315	0	0
45785995	967823	0	0
45895431	1129625	0	0
46244165	738818	0	0
45788846	1115008	0	0
46302504	1322184	0	0
45876029	3001488	2	2
46301453	40162522	2	3
4094284	4149245	4	4
21000815	1729720	0	0
21001448	40163554	2	3
21600270	1310034	0	3
35508581	1549786	0	0
36102149	40481087	3	7
36503288	4142905	5	7
36305121	3023103	2	2
42817581	1129625	0	0
44346397	1549786	0	0
44338531	1149196	0	0
45625619	40228214	2	3
44362813	1332418	0	0
45655315	1332419	2	3
45642105	19079524	1	1
45665398	1000560	0	0
45651292	1125315	0	0
45704401	1127433	2	3
45708096	19010482	0	0
45693104	1119510	0	0
45707847	1125315	0	0
45692966	738818	0	0
45705951	1129625	0	0
45699962	1149196	0	0
45784318	1125315	0	0
45785997	1112807	0	0
45895252	1129625	0	0
46244402	738818	0	0
45788909	975125	0	0
46301653	1595799	0	0
45876029	3027231	2	2
46301542	19133905	2	3
4136694	81151	4	4
21000716	1124300	0	0
21001770	1551192	2	3
21505741	40229134	5	6
35508262	1501700	0	0
36102149	28060	3	7
36503288	40480160	5	7
36305121	3016723	2	2
42817597	1125315	0	0
44346389	1124300	0	0
44338532	1177480	0	0
45625604	40228214	2	3
44361721	715997	0	0
45649757	19075601	2	3
45663658	19079524	1	1
45665401	1149196	0	0
45651390	1125315	0	0
45704255	1154615	2	3
45708099	1548195	0	0
45692862	1119510	0	0
45707896	1125315	0	0
45693253	914335	0	0
45706088	1129625	0	0
45700048	1549786	0	0
45784280	1125315	0	0
45785976	1107830	0	0
45895514	1129625	0	0
46239371	738818	0	0
45789017	1149196	0	0
46299620	1551099	0	0
45876029	3006451	2	2
46298158	43012036	2	3
4042483	4330583	4	4
21000716	1115008	0	0
21001770	40229134	2	3
21500543	40232448	5	6
35508316	1112807	0	0
36100000	433125	3	8
36503288	4230399	7	8
36503249	80502	2	2
42817688	1112807	0	0
44346369	1332418	0	0
44338534	738818	0	0
45643226	19078461	2	3
44361748	1539403	0	0
45640962	1539411	2	3
45659060	46275916	1	1
45665384	1549786	0	0
45651478	1125315	0	0
45704256	19078924	2	3
45708333	1107830	0	0
45693067	1119510	0	0
45708243	1125315	0	0
45693235	975125	0	0
45706006	1129625	0	0
45700060	1521369	0	0
45784334	1125315	0	0
45786027	1107830	0	0
45803345	1129625	0	0
46239679	738818	0	0
45788866	715997	0	0
46299709	975125	0	0
45876029	3012494	2	2
46289859	40229134	2	3
4197094	440448	4	4
21000824	975125	0	0
21001770	40228214	2	3
21500731	19079524	5	6
35508319	1125315	0	0
36100000	28060	3	8
36503288	4066995	4	7
36303200	4314290	2	2
42817786	1149196	0	0
44346586	1112807	0	0
44338537	1124300	0	0
44344260	40228214	2	3
44361859	1153428	0	0
45656042	19075601	2	3
45659060	19079524	1	1
45665384	19127890	0	0
45651608	1125315	0	0
45704364	40224805	2	3
45708110	19010482	0	0
45690014	1119510	0	0
45708076	1125315	0	0
45693239	1192710	0	0
45703700	1129625	0	0
45700147	933724	0	0
45784270	1125315	0	0
45785844	1153428	0	0
45803761	1129625	0	0
46239658	738818	0	0
45788820	1545958	0	0
46295319	1107830	0	0
45876032	3004501	2	2
46290144	1115171	2	3
4190185	81893	3	4
21000830	975125	0	0
21001770	40232448	2	3
21500731	19077344	5	6
35508319	1174888	0	0
36100000	198199	3	8
36503288	80502	4	4
36503252	40480160	2	2
42848776	1521369	0	0
44346626	1107830	0	0
44338624	1332418	0	0
45643352	40228230	2	3
44361833	1118084	0	0
45622544	40228214	2	3
45660381	19079524	1	1
45665384	1515774	0	0
45651653	1125315	0	0
45624172	715997	0	0
45705161	1501700	0	0
45689788	1119510	0	0
45708195	1125315	0	0
45693245	1110410	0	0
45703862	1129625	0	0
45693372	1521369	0	0
45786318	1125315	0	0
45786014	723013	0	0
45800979	1129625	0	0
45896136	738818	0	0
45788818	705944	0	0
46295715	1115008	0	0
46300061	19019273	2	3
46290150	40236446	2	3
4155793	4252419	3	4
21000803	1308738	0	0
21001770	1150837	2	3
21601077	964261	5	6
35508363	1129625	0	0
36200000	4059173	3	10
36702253	375671	8	10
36503287	4218389	2	2
42848776	1549786	0	0
44346613	1107830	0	0
44338636	914335	0	0
45643352	40228214	2	3
44361755	1310149	0	0
45628704	1332419	2	3
45632538	19079524	1	1
45665421	1308738	0	0
45651556	1125315	0	0
45624263	1310149	0	0
45705389	1124300	0	0
45690141	1119510	0	0
45708163	1125315	0	0
45693198	1124300	0	0
45702251	1129625	0	0
45693372	1549786	0	0
45786569	1125315	0	0
45786029	1124957	0	0
45799752	1129625	0	0
45896031	738818	0	0
45788879	1174888	0	0
46295492	1115008	0	0
46300002	19008572	2	3
46290275	1551192	2	3
4130851	4134304	3	4
21000803	1396131	0	0
21001770	40223821	2	3
21600127	40243436	5	6
35508364	1000560	0	0
36200000	4142905	3	10
36402193	4144583	8	8
36718119	381316	2	2
42808617	1125315	0	0
44346392	1107830	0	0
44338637	791967	0	0
45646145	19078461	2	3
44361890	1729720	0	0
45649974	19078461	2	3
45632591	46275916	1	1
45665422	1361711	0	0
45651270	1125315	0	0
45624276	723013	0	0
45705165	1124957	0	0
45690249	1119510	0	0
45707913	1125315	0	0
45693206	1115008	0	0
45702242	1129625	0	0
45693564	1153428	0	0
45786256	1125315	0	0
45786054	1713332	0	0
45798171	1129625	0	0
45895997	738818	0	0
46296837	1192710	0	0
46295756	723013	0	0
46300174	19019273	2	3
46290237	40231925	2	3
4134148	4117038	3	4
21000717	1551099	0	0
21001770	40223834	2	3
21503645	1177480	5	5
35508300	1192710	0	0
36102154	4112343	3	8
36516772	78272	7	8
36718119	380378	2	2
42808624	1129625	0	0
44346527	1545958	0	0
44341152	1129625	0	0
45640380	19078461	2	3
44361891	1343916	0	0
45621171	40228214	2	3
45636329	46275916	1	1
45665163	920293	0	0
45651442	1125315	0	0
45624236	1124957	0	0
45705360	738818	0	0
45690055	1119510	0	0
45708140	1125315	0	0
45692969	1332418	0	0
45702287	1129625	0	0
45693524	975125	0	0
45786454	1125315	0	0
45786054	1759842	0	0
45798173	1129625	0	0
45896807	738818	0	0
46296845	1551099	0	0
46295712	1118084	0	0
46300340	40229134	2	3
46290294	40232448	2	3
4162054	4197460	3	4
21000819	1551099	0	0
21000571	1551192	2	3
21503645	1125315	5	5
35508210	1738521	0	0
36102149	4116491	3	8
36503290	78272	7	7
40181754	40221415	2	2
42808624	1177480	0	0
44346531	933724	0	0
44341207	738818	0	0
44337454	1332419	2	3
44361896	1124300	0	0
45662642	19075601	2	3
45647677	19079524	1	1
45665430	1308738	0	0
45651561	1125315	0	0
45624244	975125	0	0
45705335	967823	0	0
45690178	1119510	0	0
45708322	1125315	0	0
45693131	1501700	0	0
45702373	1129625	0	0
45693477	1153428	0	0
45786459	1125315	0	0
45786056	967823	0	0
45798126	1129625	0	0
45804357	738818	0	0
46296758	1305058	0	0
46295687	975125	0	0
46300532	1154615	2	3
46290105	40228230	2	3
4044900	4047491	3	4
21000758	967823	0	0
21000049	46233988	2	3
21503645	19010482	5	5
35508267	1125315	0	0
36102149	4112343	3	8
36702253	381316	6	7
40057995	19127904	2	2
42821356	1153428	0	0
44346502	1115008	0	0
44341157	975125	0	0
45662341	19078461	2	3
44361897	1589505	0	0
45643483	19075601	2	3
45648191	19079524	1	1
45665249	1332418	0	0
45651689	1125315	0	0
45624391	1343916	0	0
45705453	914335	0	0
45690244	1119510	0	0
45708300	1125315	0	0
45693132	1115008	0	0
45702447	1129625	0	0
45693483	1149196	0	0
45786467	1125315	0	0
45786036	1174888	0	0
45795402	1129625	0	0
45796287	738818	0	0
46296761	1367571	0	0
46295949	1713332	0	0
46300323	19019273	2	3
46290212	1545959	2	3
4042140	317009	3	4
21000760	967823	0	0
21000049	46233710	2	3
21503645	1305058	5	5
35508302	1738521	0	0
36102149	4294548	3	8
36703458	4043241	6	6
37522376	4202451	2	2
42822200	1119510	0	0
44346754	1115008	0	0
44341158	1177480	0	0
45640340	19078461	2	3
44361900	1115008	0	0
45643562	40228214	2	3
45663669	19079524	1	1
45665371	738818	0	0
45651569	1125315	0	0
45624392	1192710	0	0
45705549	1149196	0	0
45690365	1119510	0	0
45705215	1125315	0	0
45693134	1115008	0	0
45702500	1129625	0	0
45693510	19003953	0	0
45786468	1125315	0	0
45786068	1309944	0	0
45795564	1129625	0	0
45797162	738818	0	0
46296705	914335	0	0
46295473	1717327	0	0
46296306	19075001	2	3
46292015	40232448	2	3
4180627	4218408	3	4
21000766	1125443	0	0
21001463	1332419	2	3
21503645	1118084	5	5
35508279	1125315	0	0
36100000	372328	3	3
36516728	4134304	6	6
37202317	255848	2	2
42822200	1125315	0	0
44346574	1738521	0	0
44359842	1129625	0	0
45622053	19078461	2	3
44361727	1149380	0	0
45637968	40228214	2	3
45629888	19079524	1	1
45667423	1107830	0	0
45648185	1125315	0	0
45668197	708298	0	0
45705553	1149196	0	0
45690192	1119510	0	0
45705206	1125315	0	0
45693226	914335	0	0
45702435	1129625	0	0
45693566	1308738	0	0
45784392	1125315	0	0
45786064	1192710	0	0
45796940	1129625	0	0
45796524	738818	0	0
46296548	1149196	0	0
46295421	1768849	0	0
46296315	40232448	2	3
46291545	1115171	2	3
4043161	44805732	3	4
21000874	1551099	0	0
21000591	1551192	2	3
21503645	1124957	5	5
35508279	1119510	0	0
36100000	255848	3	3
36426668	1305058	0	0
37202317	4283893	2	2
42821742	1125315	0	0
44346536	1729720	0	0
44359562	1124300	0	0
45640406	19078461	2	3
44361731	1551099	0	0
45656371	40228214	2	3
45629888	46275916	1	1
45667429	738818	0	0
45648304	1125315	0	0
45668312	1153428	0	0
45705384	1501700	0	0
45690194	1119510	0	0
45705165	1125315	0	0
45693229	1000560	0	0
45702436	1129625	0	0
45693574	1115008	0	0
45784457	1125315	0	0
45786065	1124300	0	0
45797069	1129625	0	0
45796535	738818	0	0
46295107	1326303	0	0
46295264	1310149	0	0
46318372	40243436	2	3
46292005	46233710	2	3
4043023	4216130	3	4
21000819	975125	0	0
21000538	1551192	2	3
21503645	1102527	5	5
35508280	1125315	0	0
36100000	195588	3	3
36422232	19059528	0	0
40782521	3010813	2	2
42819679	1177480	0	0
44346543	1729720	0	0
44359661	1177480	0	0
45643401	19078461	2	3
44361733	1149380	0	0
45655909	19079524	2	3
45652131	19079524	1	1
45667354	1115008	0	0
45649239	1125315	0	0
45668354	975125	0	0
45705385	1115008	0	0
45690378	1119510	0	0
45705360	1125315	0	0
45693291	1115008	0	0
45699422	1129625	0	0
45693577	1717327	0	0
45784466	1125315	0	0
45786067	1501700	0	0
45795713	1129625	0	0
45791405	738818	0	0
46295146	1557272	0	0
46296103	975125	0	0
46318402	40232448	2	3
46241955	40229134	2	3
4040396	4117038	3	4
21000806	1308738	0	0
21001459	1332419	2	3
21503645	1154029	5	5
35508280	1119510	0	0
36100000	440448	3	3
36428428	1137529	0	0
36703452	381316	2	2
42819004	1125315	0	0
44346778	1713332	0	0
44359606	1149380	0	0
45664799	19078461	2	3
44361742	967823	0	0
45659435	40228214	2	3
45658342	19079524	1	1
45667440	1500211	0	0
45649210	1125315	0	0
45668200	1124300	0	0
45705388	1149196	0	0
45686795	1119510	0	0
45705551	1125315	0	0
45694754	1115008	0	0
45699346	1129625	0	0
45693543	1192710	0	0
45784447	1125315	0	0
45786726	1149196	0	0
45795718	1129625	0	0
45791547	738818	0	0
46295039	1343916	0	0
46295728	1149196	0	0
46318807	40236824	2	3
46241956	19078461	2	3
4043025	4047491	3	4
21000806	1396131	0	0
21001456	19075601	2	3
21503645	1129625	5	5
35508280	738818	0	0
36100000	4283893	3	3
36428442	1539403	0	0
37203741	261325	2	2
42822308	1177480	0	0
44346142	1149196	0	0
44359608	791967	0	0
44358502	19078461	2	3
44361765	1149380	0	0
45622769	40228214	2	3
45658419	19079524	1	1
45667443	1589505	0	0
45648361	1125315	0	0
45668442	1361711	0	0
45705396	975125	0	0
45688409	1119510	0	0
45705554	1125315	0	0
45694627	1539403	0	0
45699488	1129625	0	0
45693587	1501700	0	0
45784450	1125315	0	0
45786369	1728416	0	0
45793005	1129625	0	0
46298495	738818	0	0
46295113	933724	0	0
46295933	1521369	0	0
46318452	40229134	2	3
46241965	40229134	2	3
4040400	4057420	3	4
21000804	1308738	0	0
21000010	19073188	2	3
21503645	1115008	5	5
35508285	1125315	0	0
35600000	4280726	3	3
36426127	1501700	0	0
37203741	4051466	2	2
42820242	1149196	0	0
44346548	1512674	0	0
44359716	975125	0	0
45634240	19078461	2	3
44361810	1310149	0	0
45640845	40228214	2	3
45660276	19079524	1	1
45667443	1549786	0	0
45648438	1125315	0	0
45668262	1192710	0	0
45705518	1107830	0	0
45688411	1119510	0	0
45705341	1125315	0	0
45694366	1759842	0	0
45699490	1129625	0	0
45693408	1149196	0	0
45784479	1125315	0	0
45786677	19010482	0	0
45792926	1129625	0	0
46298782	738818	0	0
46295116	1000560	0	0
46295934	1124957	0	0
46318767	19008572	2	3
46241968	40229134	2	3
4050571	40492359	3	3
21000806	1595799	0	0
21000010	19129655	2	3
21503160	1174888	6	6
35508285	1112807	0	0
35300000	441267	3	3
36424292	1129625	0	0
37203747	255848	2	2
42820392	1177480	0	0
44346548	19127890	0	0
44359724	1177480	0	0
45628354	19078461	2	3
44361767	1778162	0	0
45621245	1332419	2	3
45654690	19079524	1	1
45667275	738818	0	0
45648455	1125315	0	0
45668269	738818	0	0
45705350	1107830	0	0
45688696	1119510	0	0
45705329	1125315	0	0
45694366	1713332	0	0
45699594	1129625	0	0
45693326	1149196	0	0
45782313	1125315	0	0
45786539	1000560	0	0
45792839	1129625	0	0
46298939	738818	0	0
46295071	1107830	0	0
46296037	738818	0	0
46318699	19133905	2	3
46242016	40229134	2	3
4042478	4242997	3	3
21000860	1367571	0	0
21000010	19073183	2	3
21503160	914335	6	6
35508291	715997	0	0
21603282	40169281	3	3
36423716	1759842	0	0
37202312	261325	2	2
42819169	1149196	0	0
44346548	1549786	0	0
44359823	1332418	0	0
45622228	40223768	2	3
44361850	1149380	0	0
45662516	40228214	2	3
45632711	19079524	1	1
45667452	1361711	0	0
45648316	1125315	0	0
45668391	738818	0	0
45705354	1149196	0	0
45688697	1119510	0	0
45705421	1125315	0	0
45694369	1713332	0	0
45696019	1129625	0	0
45693417	933724	0	0
45782315	1125315	0	0
45786682	1192710	0	0
45792956	1129625	0	0
46290400	738818	0	0
46295173	1115008	0	0
46295667	1149196	0	0
46318725	40232448	2	3
46242020	19019273	2	3
4094683	4142905	3	3
21000825	975125	0	0
21001430	19059056	2	3
21503160	1107830	6	6
35509012	1153428	0	0
35205038	4051466	3	3
36426182	1589505	0	0
37203744	255848	2	2
42819196	1107830	0	0
44346685	738818	0	0
44359725	738818	0	0
45628522	19078461	2	3
44361877	1308738	0	0
45631930	19079524	2	3
45652012	19079524	1	1
45662805	1326303	0	0
45648513	1125315	0	0
45668370	1192710	0	0
45705166	723013	0	0
45688730	1119510	0	0
45705423	1125315	0	0
45694369	1759842	0	0
45696061	1129625	0	0
45693484	1343916	0	0
45782320	1125315	0	0
45786381	1000560	0	0
45793119	1129625	0	0
46290686	738818	0	0
46295073	1107830	0	0
46296244	1000560	0	0
46313165	1115171	2	3
46242024	40232448	2	3
4105886	4084167	3	3
21000830	1551099	0	0
21001454	19075601	2	3
21503160	1153428	6	6
35509015	1177480	0	0
35204998	321042	3	3
36155942	1115171	2	3
37003664	4116491	2	2
42820405	1125315	0	0
44346511	1124300	0	0
44359984	1112807	0	0
45658457	19078461	2	3
44361908	1000560	0	0
45621277	40228214	2	3
45632600	19079524	1	1
45662813	1310149	0	0
45648322	1125315	0	0
45668373	738818	0	0
45705343	1154343	0	0
45687103	1119510	0	0
45705430	1125315	0	0
45694372	975125	0	0
45696129	1129625	0	0
45693495	1149196	0	0
45782329	1125315	0	0
45786384	723013	0	0
45793215	1129625	0	0
46290743	738818	0	0
46295094	1107830	0	0
46295485	975125	0	0
46312531	19019273	2	3
46242178	42707627	2	3
4134184	4134304	3	3
21000873	975125	0	0
21000548	19007333	2	3
21503160	1192710	6	6
35508709	1125315	0	0
21602098	975125	3	3
36156096	19133905	2	3
37503938	44805732	2	2
42848796	1512674	0	0
44346617	738818	0	0
44360001	1192710	0	0
45631270	1545959	2	3
44361909	1118084	0	0
45631574	40228214	2	3
45626925	46275916	1	1
45662455	1539403	0	0
45648630	1125315	0	0
45668380	1326303	0	0
45705323	1154343	0	0
45687173	1119510	0	0
45705434	1125315	0	0
45694832	1759842	0	0
45696159	1129625	0	0
45693422	1343916	0	0
45782222	1125315	0	0
45786133	1112807	0	0
45792127	1129625	0	0
46291113	738818	0	0
46295178	1192710	0	0
46295417	1149196	0	0
46312823	19059056	2	3
46242319	19008572	2	3
4189544	4015189	3	3
21000825	1551099	0	0
21001775	40229134	2	3
21503146	19023398	6	7
35508390	1125315	0	0
36102971	258780	3	3
36156026	1127433	2	3
37503938	4186930	2	2
42848796	1549786	0	0
44346665	1112807	0	0
44359573	1343916	0	0
45659239	19078461	2	3
44361910	1000560	0	0
45649962	19078461	2	3
45638826	46275916	1	1
45662783	740275	0	0
45648631	1125315	0	0
45668559	1000560	0	0
45705327	1149196	0	0
45684127	1119510	0	0
45705746	1125315	0	0
45694832	1713332	0	0
45696495	1129625	0	0
45693427	1174888	0	0
45782524	1125315	0	0
45786139	19002770	0	0
45790323	1129625	0	0
46242354	738818	0	0
46295385	967823	0	0
46296250	1154029	0	0
46312942	40162522	2	3
46242234	40229134	2	3
4193169	4112343	3	3
19132304	19132304	0	0
21001775	43012036	2	3
21500541	40232448	6	7
35508454	1119510	0	0
21604389	740275	3	3
36156044	1127433	2	3
36703484	378419	2	2
42848815	1129625	0	0
44346667	1174888	0	0
44359575	1332418	0	0
45625399	40223768	2	3
44361816	1729720	0	0
45649995	19079524	2	3
45654133	19079524	1	1
45662788	1332418	0	0
45648643	1125315	0	0
45668294	1713332	0	0
45705331	1307863	0	0
45684174	1119510	0	0
45705568	1125315	0	0
45694945	1110410	0	0
45696323	1129625	0	0
45693468	1521369	0	0
45782502	1125315	0	0
45786140	1500211	0	0
45790707	1129625	0	0
46242356	738818	0	0
46295404	914335	0	0
46295682	1174888	0	0
46313096	1551192	2	3
46242182	40229134	2	3
4117301	4107731	3	3
19133679	19133679	0	0
21000544	19007333	2	3
21503444	19079524	6	7
35508211	1125315	0	0
21604069	19003953	3	3
36156140	19073183	2	3
37396230	4024289	2	2
42848815	1119510	0	0
44346668	1177480	0	0
44360007	1149380	0	0
45628629	19079524	2	3
44361883	705944	0	0
45640813	1539411	2	3
45639363	46275916	1	1
45662898	19127890	0	0
45648553	1125315	0	0
45668296	933724	0	0
45705333	1738521	0	0
45684213	1119510	0	0
45705510	1125315	0	0
45694393	1759842	0	0
45696329	1129625	0	0
45693601	1154029	0	0
45782528	1125315	0	0
45786143	19127890	0	0
45790531	1129625	0	0
46240237	738818	0	0
46295408	1115008	0	0
46296184	1115008	0	0
46313043	1127433	2	3
46242192	19008572	2	3
4116777	260139	3	3
21000230	1738521	0	0
21000038	1551192	2	3
21503444	19077344	6	7
35508376	1125315	0	0
21604181	753626	3	3
36156186	19073188	2	3
37396230	4252419	2	2
42848925	1129625	0	0
44346818	701322	0	0
44359577	1153428	0	0
45637509	1332419	2	3
44361963	1115008	0	0
45649610	40228214	2	3
45657708	46275916	1	1
45662898	1549786	0	0
45648714	1125315	0	0
45668398	1501700	0	0
45705414	1305058	0	0
45684217	1119510	0	0
45705734	1125315	0	0
45694859	920293	0	0
45696532	1129625	0	0
45693604	1768849	0	0
45782283	1125315	0	0
45786143	1549786	0	0
45790471	1129625	0	0
45798493	1177480	0	0
46295413	967823	0	0
46296193	1305058	0	0
46312733	40174880	2	3
46242198	40228214	2	3
4134174	4134304	3	3
21000260	1738521	0	0
21000009	46233710	2	3
21503645	19019979	7	8
35508483	1115008	0	0
21604181	19016749	3	3
36155991	46275916	2	3
37503922	4330583	2	2
42848925	1119510	0	0
44346595	705944	0	0
44359583	1549786	0	0
45621158	19079524	2	3
44361937	715997	0	0
45653416	19078461	2	3
45657233	46275916	1	1
45662831	1154343	0	0
45648658	1125315	0	0
45668446	1149196	0	0
45705305	1332418	0	0
45654991	1125315	0	0
45705664	1125315	0	0
45694864	1548195	0	0
45693232	1129625	0	0
45693743	1326303	0	0
45782565	1125315	0	0
45786143	1589505	0	0
45790607	1129625	0	0
45798460	1177480	0	0
46295277	1713332	0	0
46296195	975125	0	0
46313032	40163554	2	3
46242309	40229134	2	3
4050747	4134304	3	3
21000260	1746114	0	0
21000009	46233988	2	3
21503645	19133768	7	8
35508488	1125315	0	0
36217214	19127922	3	4
36156196	19126352	2	3
37503940	4117038	2	2
42848925	1125315	0	0
44346758	1124300	0	0
44359583	19127890	0	0
44351937	1332419	2	3
44361972	1738521	0	0
45637993	40223768	2	3
45657118	46275916	1	1
45662608	1768849	0	0
45645345	1125315	0	0
45668399	1551099	0	0
45705521	1322184	0	0
45655070	1125315	0	0
45702004	1125315	0	0
45694891	1107830	0	0
45693126	1129625	0	0
45693958	975125	0	0
45782567	1125315	0	0
45786176	1149196	0	0
45787676	1129625	0	0
45798614	1177480	0	0
46295193	1192710	0	0
46295588	1729720	0	0
46312929	40223834	2	3
46241988	40229134	2	3
4170143	40481087	3	3
21000259	1738521	0	0
21000584	40174880	2	3
21503645	40165015	7	8
35508488	1119510	0	0
36102149	198199	2	7
36156200	19078461	2	3
37202310	441267	2	2
42848992	1112807	0	0
44346760	1149380	0	0
44359583	1515774	0	0
45646193	1539411	2	3
44361928	1149196	0	0
45646756	40223768	2	3
45657438	46275916	1	1
45662913	1549786	0	0
45645145	1125315	0	0
45668448	1557272	0	0
45705622	1545958	0	0
45655109	1125315	0	0
45702005	1125315	0	0
45693313	738818	0	0
45693231	1129625	0	0
45693440	1310149	0	0
45782586	1125315	0	0
45786197	975125	0	0
45787624	1129625	0	0
45798553	1177480	0	0
46295198	933724	0	0
46296417	738818	0	0
46313079	40162522	2	3
46242325	19059056	2	3
4134134	4066995	3	3
21000249	1728416	0	0
21000578	40174880	2	3
21503645	19059056	7	8
35508488	738818	0	0
4041262	4330583	2	6
36156204	40232448	2	3
37202310	317009	2	2
42848992	1125315	0	0
44346802	1343916	0	0
44359693	1713332	0	0
45658886	1332419	2	3
44361996	723013	0	0
45664958	40223768	2	3
45644836	46275916	1	1
45662913	19127890	0	0
45645238	1125315	0	0
45668439	1713332	0	0
45705625	1107830	0	0
45654785	1125315	0	0
45701894	1125315	0	0
45693395	1153428	0	0
45693298	1129625	0	0
45693589	1551099	0	0
45782589	1125315	0	0
45786206	1713332	0	0
45787792	1129625	0	0
45798690	1177480	0	0
46295210	975125	0	0
46296441	1310149	0	0
46307734	40236824	2	3
46242146	19133873	2	3
4134134	4001336	3	3
21000250	1728416	0	0
21001385	1713671	2	3
21503645	40231925	7	8
35508489	1129625	0	0
36103041	40481087	2	6
36156604	1127433	2	3
37003657	195588	2	2
42848992	1129625	0	0
44346518	1112807	0	0
44360067	1549786	0	0
45624981	40223768	2	3
44361942	1738521	0	0
45641211	19078461	2	3
45641824	46275916	1	1
45662913	1512674	0	0
45645258	1125315	0	0
45668381	1107830	0	0
45705603	1153428	0	0
45655118	1125315	0	0
45702091	1125315	0	0
45693398	1124300	0	0
45690317	1129625	0	0
45693616	1192710	0	0
45782590	1125315	0	0
45786102	1545958	0	0
45789261	1129625	0	0
45793370	1177480	0	0
46295213	1000560	0	0
46295874	791967	0	0
46308216	19008572	2	3
46242257	1127078	2	3
4043174	4336464	3	3
21000251	1728416	0	0
21001385	19074841	2	3
21600001	35605482	5	7
21604256	1110410	0	0
36102144	28060	2	6
36156592	19073183	2	3
37108852	4174876	2	2
42849011	1119510	0	0
44346618	1713332	0	0
44360067	19127890	0	0
45652430	40174880	2	3
44362057	1332418	0	0
45659352	19078461	2	3
45641977	46275916	1	1
45662927	1115008	0	0
45645434	1125315	0	0
45668678	1115008	0	0
45705608	1149380	0	0
45655290	1125315	0	0
45702089	1125315	0	0
45693399	1192710	0	0
45690397	1129625	0	0
45693594	1149196	0	0
45782596	1125315	0	0
45786108	1124300	0	0
45789401	1129625	0	0
45793386	1177480	0	0
46295383	705944	0	0
46296431	19059528	0	0
46308228	40162522	2	3
46242200	19133905	2	3
4134439	375671	3	3
21000252	1728416	0	0
21000012	19129655	2	3
21600001	40243436	6	7
21604260	1124957	0	0
36102144	433125	2	6
36156612	1594382	2	3
40782562	3019550	2	2
42849011	1125315	0	0
44346829	738818	0	0
44360067	1512674	0	0
45662023	40174880	2	3
44362208	1545958	0	0
45646785	19078461	2	3
45638751	46275916	1	1
45662957	1307863	0	0
45645556	1125315	0	0
45668427	1192710	0	0
45705611	967823	0	0
45654961	1125315	0	0
45701822	1125315	0	0
45693402	1308738	0	0
45690341	1129625	0	0
45693801	1738521	0	0
45782543	1125315	0	0
45786177	791967	0	0
45787896	1129625	0	0
45793227	1177480	0	0
46295241	1545958	0	0
46295611	1549786	0	0
46308286	920300	2	3
46242288	40229134	2	3
4134439	378001	3	3
21000253	1728416	0	0
21001750	46233988	2	3
21600001	967823	4	4
21603929	1305058	0	0
4180941	4238715	2	5
36156602	19133905	2	3
40782472	3001247	2	2
42849011	1129625	0	0
44346282	1112807	0	0
44359826	975125	0	0
45625348	19078461	2	3
44362168	1115008	0	0
45659584	40223768	2	3
45638857	46275916	1	1
45662965	1149196	0	0
45645563	1125315	0	0
45668489	1332418	0	0
45705313	975125	0	0
45655198	1125315	0	0
45701824	1125315	0	0
45693301	975125	0	0
45690326	1129625	0	0
45693807	1107830	0	0
45782483	1125315	0	0
45786184	1174888	0	0
45786325	1129625	0	0
45793266	1177480	0	0
46295329	1107830	0	0
46295611	1595799	0	0
46307694	1115171	2	3
45893688	46233710	2	3
4161193	28060	3	3
21000254	1728416	0	0
21001750	19073183	2	3
21601237	1545958	4	4
21604049	1177480	0	0
21604390	19074679	2	5
35909452	198809	2	2
40782476	3000876	2	2
42822312	1125315	0	0
44346820	1124957	0	0
44359828	1107830	0	0
44778278	40174880	2	3
44362173	1589505	0	0
45643671	19078461	2	3
45638854	46275916	1	1
45662841	1717327	0	0
45645126	1125315	0	0
45668585	1713332	0	0
45705492	1548195	0	0
45700755	1125315	0	0
45702197	1125315	0	0
45693337	1738521	0	0
45690495	1129625	0	0
45693784	1149196	0	0
45782484	1125315	0	0
45786320	1589505	0	0
45786233	1129625	0	0
45794723	1177480	0	0
46295431	1332418	0	0
46295611	1521369	0	0
46308117	40162522	2	3
45893688	46233988	2	3
4161193	433125	3	3
21000255	1728416	0	0
21000242	46233710	2	3
21601237	1309944	4	4
21602820	1717327	0	0
21604752	19123231	2	5
35707601	4285898	2	2
40782579	3006923	2	2
42822431	1119510	0	0
44346821	1153428	0	0
44359796	1307863	0	0
45659110	1539411	2	3
44362173	1549786	0	0
45630830	1539411	2	3
45638961	46275916	1	1
45662969	1124957	0	0
45645463	1125315	0	0
45668458	738818	0	0
45705613	1309944	0	0
45700900	1125315	0	0
45701852	1125315	0	0
45693563	738818	0	0
45690556	1129625	0	0
45693812	708298	0	0
45782489	1125315	0	0
45786320	1549786	0	0
45786303	1129625	0	0
45794686	1177480	0	0
46295441	1551099	0	0
46295703	1729720	0	0
46308095	19019273	2	3
45893649	40232448	2	3
4180170	28060	3	3
21000256	1728416	0	0
21000923	19076374	2	3
21601237	46275916	6	7
21601856	1539403	0	0
21604752	40236446	2	5
36211103	4230399	2	2
40782935	3049273	2	2
42804716	1361711	0	0
44346822	1124300	0	0
44359799	975125	0	0
45652616	1545959	2	3
44362064	738818	0	0
44362635	1125315	0	0
45636880	46275916	1	1
45662934	967823	0	0
45645133	1125315	0	0
45668550	1545958	0	0
45705685	1332418	0	0
45701485	1125315	0	0
45702044	1125315	0	0
45693629	1367571	0	0
45690501	1129625	0	0
45693907	1149380	0	0
45782673	1125315	0	0
45786081	975125	0	0
45786413	1129625	0	0
45794816	1177480	0	0
46295623	975125	0	0
46291142	1192710	0	0
46308088	19077344	2	3
45893768	19019273	2	3
4180170	255848	3	3
21000257	1728416	0	0
21001773	40228214	2	3
21601237	40171902	5	5
21601860	1545958	0	0
36102149	260139	2	4
36211267	4146173	2	2
40782883	3008598	2	2
42805045	1125315	0	0
44346661	1149196	0	0
44360160	723013	0	0
45634819	1545959	2	3
44361945	967823	0	0
44362738	1125315	0	0
45637158	46275916	1	1
45662947	1322184	0	0
45645395	1125315	0	0
45668524	1125443	0	0
45705491	715997	0	0
45701604	1125315	0	0
45702068	1125315	0	0
45693357	975125	0	0
45690428	1129625	0	0
45693909	1738521	0	0
45782606	1125315	0	0
45786287	1115008	0	0
46296864	1129625	0	0
45787979	1177480	0	0
46295628	1500211	0	0
46291187	1107830	0	0
46308342	1115171	2	3
45893744	40236824	2	3
4180170	40481087	3	3
21000258	1728416	0	0
21001772	19112599	2	3
21600959	964261	6	7
21601423	1305058	0	0
4130851	4146173	2	4
36211224	375671	2	2
40760140	3000963	2	2
42805045	1124957	0	0
44346298	1177480	0	0
44359864	1713332	0	0
45628607	1539411	2	3
44362217	967823	0	0
44360434	1125315	0	0
45631025	46275916	1	1
45662708	1539403	0	0
45645403	1125315	0	0
45668614	1107830	0	0
45705543	1551099	0	0
45701640	1125315	0	0
45702129	1125315	0	0
45693500	1519936	0	0
45687158	1129625	0	0
45693664	1738521	0	0
45782607	1125315	0	0
46292407	701322	0	0
46296996	1129625	0	0
45787961	1177480	0	0
46295242	1322184	0	0
46290800	1595799	0	0
46302576	40231925	2	3
45893839	1127433	2	3
4180170	257012	3	3
19133768	19133768	0	0
21001772	43012036	2	3
21600959	1310149	4	4
35406426	372328	0	0
4130852	4152936	2	4
36211224	378001	2	2
40760141	3000963	2	2
42805052	1112807	0	0
44346404	1115008	0	0
44359864	1759842	0	0
44344196	1539411	2	3
45655900	1310149	0	0
44360523	1125315	0	0
45626851	19079524	1	1
45662830	715997	0	0
45645406	1125315	0	0
45668760	1153428	0	0
45705545	723013	0	0
45701621	1125315	0	0
45702139	1125315	0	0
45693507	1310149	0	0
45687393	1129625	0	0
45693833	1361711	0	0
45782618	1125315	0	0
46292483	1124957	0	0
46297029	1129625	0	0
45788113	1177480	0	0
46295247	1738521	0	0
46290800	1549786	0	0
46302816	40229134	2	3
45893952	40174880	2	3
4171379	4116491	3	3
19133873	19133873	0	0
21001745	1713671	2	3
21600959	1396131	4	4
35406429	372328	0	0
36213602	19128263	2	3
36211259	4149245	2	2
40480513	439777	2	2
42805054	1119510	0	0
44346797	1738521	0	0
44359987	1149380	0	0
45641020	1539411	2	3
45655903	1343916	0	0
44360481	1125315	0	0
45623761	46275916	1	1
45662850	738818	0	0
45645510	1125315	0	0
45668632	1000560	0	0
45705409	967823	0	0
45701749	1125315	0	0
45702159	1125315	0	0
45693407	1332418	0	0
45687570	1129625	0	0
45693920	1310149	0	0
45782675	1125315	0	0
46292486	1112807	0	0
46297035	1129625	0	0
46294316	1177480	0	0
46295163	1153428	0	0
46290800	1521369	0	0
46302823	1551192	2	3
45894165	19019273	2	3
4049890	4107731	3	3
19133905	19133905	0	0
21000967	19076374	2	3
21600959	1367571	4	4
21603619	975125	0	0
36213602	19128022	2	3
36211065	40480160	2	2
40181757	40221415	2	2
42805124	1119510	0	0
44346813	1153428	0	0
44359834	933724	0	0
45620869	1539411	2	3
45655868	1110410	0	0
44360482	1125315	0	0
45667600	19079524	1	1
45662856	1115008	0	0
45646221	1125315	0	0
45668634	1153428	0	0
45705505	791967	0	0
45701706	1125315	0	0
45702026	1125315	0	0
45690296	701322	0	0
45687376	1129625	0	0
45691568	1551099	0	0
45702582	1125315	0	0
46292490	1332418	0	0
46297077	1129625	0	0
46294206	1177480	0	0
46295356	975125	0	0
46290904	1153428	0	0
46302693	40232448	2	3
45893897	42707627	2	3
4042501	4230399	3	3
19134077	19134077	0	0
21001382	19133873	2	3
21600959	1112807	4	4
21603448	1129625	0	0
4130851	78272	2	3
36211065	4278672	2	2
40181781	40221415	2	2
42805040	1713332	0	0
44346606	975125	0	0
44359837	1129625	0	0
45621220	1539411	2	3
45655873	1738521	0	0
44360555	1125315	0	0
45667603	46275916	1	1
45662937	1332418	0	0
45642367	1125315	0	0
45668685	1501700	0	0
45705480	1332418	0	0
45701713	1125315	0	0
45699021	1125315	0	0
45690457	1118084	0	0
45687686	1129625	0	0
45691446	1124300	0	0
45702589	1125315	0	0
46292421	1115008	0	0
46297113	1129625	0	0
46294394	1177480	0	0
46295637	1192710	0	0
46290981	1738521	0	0
46302772	19008572	2	3
45893843	1115171	2	3
4181195	4301346	3	3
19019273	19019273	0	0
21000919	19076374	2	3
21600959	1308738	4	4
21602106	975125	0	0
36213604	19128009	2	3
36211065	4066995	2	2
40181783	40221415	2	2
42805040	1759842	0	0
44346722	967823	0	0
44359991	1713332	0	0
45665016	1539411	2	3
45655875	1361711	0	0
44360560	1125315	0	0
45667730	19079524	1	1
45662973	1549786	0	0
45642315	1125315	0	0
45668409	975125	0	0
45705575	708298	0	0
45701795	1125315	0	0
45699152	1125315	0	0
45690284	1124300	0	0
45687303	1129625	0	0
45691450	1713332	0	0
45702592	1125315	0	0
46292576	1112807	0	0
46297229	1129625	0	0
46294543	1177480	0	0
46244425	1107830	0	0
46244910	1713332	0	0
46303280	19078461	2	3
45893831	1115171	2	3
4043346	255848	3	3
4314290	4314290	0	0
21000526	19007333	2	3
21600959	967823	4	4
21602115	975125	0	0
36213603	19128009	2	3
36211065	4237458	2	2
40062921	19128065	2	2
42805042	1738521	0	0
44346723	1713332	0	0
44360014	1332418	0	0
45622574	1539411	2	3
45655792	1124957	0	0
44360569	1125315	0	0
45668214	46275916	1	1
45662973	1521369	0	0
45642357	1125315	0	0
45668493	1124300	0	0
45705510	738818	0	0
45701808	1125315	0	0
45699204	1125315	0	0
45690285	1548195	0	0
45687690	1129625	0	0
45691466	1589505	0	0
45702533	1125315	0	0
46292576	1192710	0	0
46297525	1129625	0	0
46243853	1177480	0	0
46244285	1539403	0	0
46244914	1000560	0	0
46303214	40236824	2	3
45801715	1154615	2	3
4043346	260139	3	3
4275113	4275113	0	0
21000565	19007333	2	3
21600959	19075601	4	7
35507306	1125315	0	0
21604086	42707627	2	3
36211065	4048695	2	2
36718317	375671	2	2
42805129	1713332	0	0
44346738	1115008	0	0
44359622	1177480	0	0
45649773	19079524	1	1
45655829	1153428	0	0
44360534	1125315	0	0
45665592	19079524	1	1
45662973	19127890	0	0
45642358	1125315	0	0
45668496	1115008	0	0
45705513	1107830	0	0
45701790	1125315	0	0
45699162	1125315	0	0
45690287	1149196	0	0
45685475	1129625	0	0
45691466	1549786	0	0
45702633	1125315	0	0
46292635	1332418	0	0
46297155	1129625	0	0
46243775	1177480	0	0
46244475	1548195	0	0
46244836	1115008	0	0
46300425	19008572	2	3
45801767	1115171	2	3
4082416	372328	3	3
4278672	4278672	0	0
21001427	19133873	2	3
21600959	40163554	4	7
35507359	1332418	0	0
36156691	46275916	2	3
36211065	4059173	2	2
36718157	4043241	2	2
42805129	1759842	0	0
44348184	1107830	0	0
44359623	1115008	0	0
45649773	46275916	1	1
45655909	967823	0	0
44360547	1125315	0	0
45665855	46275916	1	1
45662946	1000560	0	0
45642370	1125315	0	0
45668497	742185	0	0
45705581	1539403	0	0
45701930	1125315	0	0
45699219	1125315	0	0
45690305	738818	0	0
45684426	1129625	0	0
45690640	1192710	0	0
45702749	1125315	0	0
46292673	1595799	0	0
46293093	1129625	0	0
46244653	1177480	0	0
46244441	1332418	0	0
46244974	1332418	0	0
46300301	40162522	2	3
45801638	19059056	2	3
4040549	4323902	3	3
4029498	4029498	0	0
19003953	42707627	2	3
21502553	46275916	7	8
35507274	1153428	0	0
35506838	19133905	2	3
36211305	4152936	2	2
36718162	4043241	2	2
42804941	1332418	0	0
44348291	1551099	0	0
44359557	1713332	0	0
45625987	19079524	1	1
45655882	708298	0	0
44353470	1125315	0	0
45663505	19079524	1	1
45664641	1545958	0	0
45642454	1125315	0	0
45668587	1310149	0	0
45705708	975125	0	0
45701882	1125315	0	0
45699148	1125315	0	0
45690306	975125	0	0
45684515	1129625	0	0
45690667	1307863	0	0
45702604	1125315	0	0
46292673	1308738	0	0
46293456	1129625	0	0
46244875	1177480	0	0
46244331	1192710	0	0
46244625	1149196	0	0
46300807	1127433	2	3
45801824	1551192	2	3
4040549	4337611	3	3
4094814	4094814	0	0
21001379	19133905	2	3
21500327	40229134	7	8
35507349	1107830	0	0
35506841	19008572	2	3
36211305	4113008	2	2
36718526	380378	2	2
42805156	1332418	0	0
44348297	740275	0	0
44359557	1759842	0	0
45644127	46275916	1	1
45655847	1107830	0	0
44353456	1125315	0	0
45657615	46275916	1	1
45664634	19078219	0	0
45642627	1125315	0	0
45668452	738818	0	0
45705710	1501700	0	0
45701883	1125315	0	0
45699308	1125315	0	0
45690467	1713332	0	0
45684581	1129625	0	0
45690711	1174888	0	0
45702742	1125315	0	0
46292796	1545958	0	0
46239320	1308738	0	0
46244056	1177480	0	0
46244411	1192710	0	0
46244636	738818	0	0
46300429	40162522	2	3
45801809	1127433	2	3
4043028	44783196	3	3
4048695	4048695	0	0
21000033	19129655	2	3
21502620	19075001	7	8
35507412	1154343	0	0
35506941	40162522	2	3
36211305	4109685	2	2
37521054	4198190	2	3
42805010	1124300	0	0
44348302	1177480	0	0
44360136	1115008	0	0
45644127	19079524	1	1
45655915	1124957	0	0
44353460	1125315	0	0
45658004	19079524	1	1
45664553	1115008	0	0
45642749	1125315	0	0
45668415	1154029	0	0
45705759	975125	0	0
45701971	1125315	0	0
45699249	1125315	0	0
45690473	975125	0	0
45681241	1129625	0	0
45690641	1153428	0	0
45702708	1125315	0	0
46292821	1174888	0	0
46239069	1124300	0	0
46244032	1177480	0	0
46244411	1174888	0	0
46244637	1174888	0	0
46300436	920300	2	3
45801854	1115171	2	3
4101796	380378	3	3
4181917	4181917	0	0
21001759	19133905	2	3
21502620	46233710	7	8
35507377	1738521	0	0
35506987	1551192	2	3
36211305	4155034	2	2
37202317	257012	2	3
42805157	967823	0	0
44348307	1112807	0	0
44360071	1115008	0	0
45649553	46275916	1	1
45655947	738818	0	0
44353614	1125315	0	0
45654465	46275916	1	1
45664555	738818	0	0
45642558	1125315	0	0
45668416	1501700	0	0
45702004	738818	0	0
45701932	1125315	0	0
45699352	1125315	0	0
45690307	1192710	0	0
45678100	1129625	0	0
45690723	723013	0	0
45702573	1125315	0	0
46292550	1741122	0	0
46239220	1115008	0	0
46238947	1177480	0	0
46244420	1107830	0	0
46239831	705944	0	0
46300484	19075001	2	3
45802417	19008572	2	3
4162054	4295880	3	3
4174876	4174876	0	0
21001759	19133873	2	3
21502620	19133905	7	8
35507382	1129625	0	0
35506993	40224805	2	3
36211375	4132546	2	2
37202317	28060	2	3
42805167	920293	0	0
44348372	1000560	0	0
44360076	1137529	0	0
45649553	19079524	1	1
45656199	1595799	0	0
44353618	1125315	0	0
45651175	46275916	1	1
45664569	1000560	0	0
45642559	1125315	0	0
45665857	738818	0	0
45702005	1174888	0	0
45701939	1125315	0	0
45699358	1125315	0	0
45690570	708298	0	0
45678104	1129625	0	0
45690728	1361711	0	0
45702675	1125315	0	0
46292550	1746114	0	0
46239200	1521369	0	0
46238985	1177480	0	0
46244482	1192710	0	0
46240037	1545958	0	0
46300598	40229134	2	3
45802604	19078461	2	3
4129747	4117038	3	3
4139681	4139681	0	0
21001751	19073183	2	3
21502620	19074843	7	8
35507382	1125315	0	0
35507205	1115171	2	3
36211375	4156265	2	2
37503958	4337611	2	3
42805008	1110410	0	0
44348438	701322	0	0
44360076	1149380	0	0
44360243	1115171	2	3
45656199	1308738	0	0
44353572	1125315	0	0
45647634	46275916	1	1
45664650	740275	0	0
45642479	1125315	0	0
45665861	1192710	0	0
45702016	1000560	0	0
45698765	1125315	0	0
45699407	1125315	0	0
45690403	1738521	0	0
45678091	1129625	0	0
45690643	1118084	0	0
45702680	1125315	0	0
46292558	1154343	0	0
46239234	1192710	0	0
46239185	1177480	0	0
46244483	1549786	0	0
46240115	1153428	0	0
46300564	19059056	2	3
45799091	40236446	2	3
4095631	317576	3	3
4084167	4084167	0	0
21001752	40229134	2	3
21502620	19074841	7	8
35507318	1738521	0	0
36152544	40236446	2	3
36210656	3013682	2	2
36718588	44782520	2	3
42805009	1110410	0	0
44348443	1115008	0	0
44360080	1129625	0	0
44360303	19133905	2	3
45656121	967823	0	0
44353581	1125315	0	0
45645351	19079524	1	1
45663013	1149196	0	0
45642564	1125315	0	0
45665873	1153428	0	0
45701748	1501700	0	0
45698766	1125315	0	0
45699512	1125315	0	0
45690318	1192710	0	0
45678164	1129625	0	0
45690637	1595799	0	0
45702651	1125315	0	0
46292711	1112807	0	0
46239080	1149196	0	0
45894748	1177480	0	0
46244483	1521369	0	0
46239873	1192710	0	0
46300633	19019273	2	3
45799332	1551192	2	3
4095793	45769019	3	3
4051466	4051466	0	0
19002770	19023423	2	3
21502620	46233988	7	8
35507319	975125	0	0
36152880	40229134	2	3
36210656	3006906	2	2
36427520	19133905	2	3
42805134	1177480	0	0
44348358	738818	0	0
44360015	1501700	0	0
44360306	40229134	2	3
45656029	738818	0	0
44353488	1125315	0	0
45642429	46275916	1	1
45663078	1149196	0	0
45642632	1125315	0	0
45665856	1107830	0	0
45702177	1115008	0	0
45698488	1125315	0	0
45699518	1125315	0	0
45690409	1149196	0	0
45678265	1129625	0	0
45690674	1124957	0	0
45702652	1125315	0	0
46292712	791967	0	0
46239381	1557272	0	0
45894575	1177480	0	0
46244497	1115008	0	0
46239883	1713332	0	0
46300852	40231925	2	3
45799337	40231925	2	3
4180169	198199	3	3
4043241	4043241	0	0
4226263	4112343	2	3
21502620	1713671	7	8
35507320	975125	0	0
36152889	1115171	2	3
35702800	28060	2	2
36427520	19133873	2	3
42805011	1177480	0	0
44342670	1177480	0	0
44360148	1332418	0	0
44360270	40162522	2	3
45656206	1310149	0	0
44353419	1125315	0	0
45638881	46275916	1	1
45663102	1174888	0	0
45642496	1125315	0	0
45666278	1332418	0	0
45701911	1107830	0	0
45698733	1125315	0	0
45695931	1125315	0	0
45690340	1192710	0	0
45678321	1129625	0	0
45690688	975125	0	0
45702653	1125315	0	0
46292997	1102527	0	0
46239067	1118084	0	0
45894443	1177480	0	0
46244434	705944	0	0
46239956	1713332	0	0
46300766	46233988	2	3
45799354	40229134	2	3
4180169	134438	3	3
21000261	1778162	0	0
4288734	261325	2	2
21502620	19129655	7	8
35507321	1119510	0	0
36152462	1551192	2	3
36211391	4296204	2	2
36718338	4029498	2	3
42805014	1501700	0	0
44342675	1549786	0	0
44360154	791967	0	0
44353471	46275916	2	3
45656032	1326303	0	0
44353544	1125315	0	0
45639139	46275916	1	1
45663104	1310149	0	0
45642500	1125315	0	0
45666322	1124300	0	0
45702087	975125	0	0
45698741	1125315	0	0
45695812	1125315	0	0
45690342	1154029	0	0
45678696	1129625	0	0
45690689	1192710	0	0
45702543	1125315	0	0
46292739	1124300	0	0
46239409	19127890	0	0
45801504	1177480	0	0
46244318	1115008	0	0
46240059	1308738	0	0
46301018	40231925	2	3
45799348	19008572	2	3
4044887	44783196	3	3
21000284	1778162	0	0
4223595	40486433	2	2
21502620	46275444	7	8
35507417	1125315	0	0
36152703	19008572	2	3
35809320	4066995	2	2
36718338	44782520	2	3
42805017	1501700	0	0
44342675	1521369	0	0
44360218	1521369	0	0
44353614	1127433	2	3
45656051	723013	0	0
44353697	1125315	0	0
45635790	46275916	1	1
45663016	738818	0	0
45640051	1125315	0	0
45666282	1124957	0	0
45702099	975125	0	0
45698911	1125315	0	0
45695744	1125315	0	0
45690345	19010482	0	0
45678779	1129625	0	0
45690692	975125	0	0
45702546	1125315	0	0
46292744	708298	0	0
46239409	1549786	0	0
45801560	1177480	0	0
46244319	1741122	0	0
46240071	1549786	0	0
46301122	19018935	2	3
45799132	1115171	2	3
4190185	198809	3	3
21000244	1728416	0	0
4223595	4280726	2	2
21502620	19073183	7	8
35507531	1119510	0	0
36152576	40236824	2	3
36207527	3049273	2	2
37503992	4035793	2	4
42805102	1332418	0	0
44342952	1149196	0	0
44360218	1549786	0	0
44353576	19126352	2	3
45655968	1713332	0	0
44353664	1125315	0	0
45659022	1125315	0	0
45663131	1343916	0	0
45640058	1125315	0	0
45666330	1500211	0	0
45701833	1500211	0	0
45700538	1125315	0	0
45695745	1125315	0	0
45690321	1515774	0	0
45678353	1129625	0	0
45690647	1521369	0	0
45702548	1125315	0	0
46292647	1322184	0	0
46239409	1589505	0	0
45801616	1177480	0	0
46244319	1746114	0	0
46240071	1521369	0	0
46319065	1127433	2	3
45799283	1115171	2	3
4190185	28060	3	3
21000244	1713332	0	0
4223616	4084167	2	2
21500120	1548195	7	7
35204953	313217	0	0
36152579	40231925	2	3
36207527	3004501	2	2
37503992	4107731	2	6
42805111	1500211	0	0
44342648	1557272	0	0
44360143	738818	0	0
44353415	19008572	2	3
45655969	1115008	0	0
44353666	1125315	0	0
45659125	1125315	0	0
45663176	1501700	0	0
45639476	1125315	0	0
45666105	1107830	0	0
45702194	1107830	0	0
45700548	1125315	0	0
45695587	1125315	0	0
45690321	1549786	0	0
45675283	1129625	0	0
45690650	914335	0	0
45702852	1125315	0	0
46292653	1115008	0	0
46239156	1192710	0	0
45801463	1177480	0	0
46244438	1124957	0	0
46240118	1549786	0	0
46319428	1115171	2	3
45793702	40232448	2	3
4190185	440448	3	3
21000244	1738521	0	0
4224259	40486433	2	2
21500120	1501700	7	7
21605060	914335	0	0
36152908	1107882	2	3
36211091	4146173	2	2
37503992	4330583	2	9
42804928	1177480	0	0
44342766	738818	0	0
44359769	1177480	0	0
44353779	40163554	2	3
45656075	1149196	0	0
44353706	1125315	0	0
45659129	1125315	0	0
45663018	1713332	0	0
45639450	1125315	0	0
45666345	1124300	0	0
45702061	1326303	0	0
45700661	1125315	0	0
45695753	1125315	0	0
45690323	975125	0	0
45675214	1129625	0	0
45690658	1154029	0	0
45702790	1125315	0	0
46293004	1115008	0	0
46239158	1192710	0	0
45801377	1177480	0	0
46244572	1118084	0	0
46240020	1557272	0	0
46319154	19059056	2	3
45794081	40231925	2	3
4042503	4155034	3	3
21000244	1729720	0	0
4224259	4280726	2	2
21500120	1557272	7	7
21605129	967823	0	0
36152742	19125062	2	3
36211091	4134304	2	2
37503898	4108705	2	5
42805000	1124300	0	0
44342695	1738521	0	0
44359670	705944	0	0
44353519	40229134	2	3
45656339	1343916	0	0
44353881	1125315	0	0
45659288	1125315	0	0
45663018	1759842	0	0
45639452	1125315	0	0
45667208	708298	0	0
45701852	738818	0	0
45700524	1125315	0	0
45695843	1125315	0	0
45690325	1124300	0	0
45675193	1129625	0	0
45690664	791967	0	0
45702696	1125315	0	0
46292936	1174888	0	0
45894583	1521369	0	0
45801574	1177480	0	0
46244386	1332418	0	0
46240134	1738521	0	0
46319524	40163554	2	3
45794086	1594382	2	3
4042503	4278672	3	3
21000245	1738521	0	0
4288463	4186930	2	2
21502709	40229134	9	10
21604305	1112807	0	0
36153255	43012036	2	3
36211091	4230399	2	2
37202310	258780	2	5
42805069	1124300	0	0
44342731	1124957	0	0
44359812	975125	0	0
44353731	40163554	2	3
45656349	1551099	0	0
44353519	1125315	0	0
45659135	1125315	0	0
45663062	723013	0	0
45639505	1125315	0	0
45667194	1332418	0	0
45702113	1102527	0	0
45698943	1125315	0	0
45695784	1125315	0	0
45690329	1124957	0	0
45676429	1129625	0	0
45690762	1174888	0	0
45702558	1125315	0	0
46292946	1549786	0	0
45894583	1549786	0	0
45801431	1177480	0	0
46244500	1738521	0	0
46240118	1589505	0	0
46295416	19078461	2	3
45794092	19129655	2	3
4042503	4113008	3	3
21000245	1728416	0	0
4304916	192671	2	2
21002855	19076374	2	3
21603392	19029476	0	3
35708603	4112343	2	3
36211315	4296204	2	2
36703500	4066995	2	5
42805142	1125315	0	0
44342812	1107830	0	0
44359965	1589505	0	0
44353736	1115171	2	3
45656328	1149380	0	0
44353715	1125315	0	0
45659251	1125315	0	0
45663208	1713332	0	0
45639514	1125315	0	0
45667322	1115008	0	0
45702116	1107830	0	0
45698972	1125315	0	0
45697753	1125315	0	0
45690492	738818	0	0
45672365	1129625	0	0
45690766	1124300	0	0
45702941	1125315	0	0
46292946	1512674	0	0
45894586	1310149	0	0
45801557	1177480	0	0
46244407	1521369	0	0
46240119	738818	0	0
46301752	1332419	2	3
45793956	1115171	2	3
4169307	4240902	3	3
21000261	1738521	0	0
4287856	40492359	2	2
21002644	19008572	2	3
21604271	40165015	0	3
35509194	1127433	2	3
36208978	46235214	2	2
37202320	4280726	2	5
42805346	1738521	0	0
44342814	1107830	0	0
44359965	1549786	0	0
44346121	1115171	2	3
45656156	1545958	0	0
44353805	1125315	0	0
45659324	1125315	0	0
45663208	1759842	0	0
45639533	1125315	0	0
45667380	1548195	0	0
45702184	723013	0	0
45699017	1125315	0	0
45697537	1125315	0	0
45690497	1717327	0	0
45672616	1129625	0	0
45690757	967823	0	0
45702813	1125315	0	0
46293031	1115008	0	0
45894374	1124300	0	0
45801446	1177480	0	0
46244605	1192710	0	0
45896592	1192710	0	0
45894291	19073183	2	3
45794228	40236824	2	3
4169307	4219399	3	3
21000267	1738521	0	0
4287856	4275113	2	2
21002602	1713671	2	3
21602504	1519937	0	3
35509201	40163554	2	3
36208978	3011505	2	2
36718338	4132546	2	5
42805479	914335	0	0
44342753	1149380	0	0
44360145	975125	0	0
44346258	40229134	2	3
45656270	1115008	0	0
44353939	1125315	0	0
45659325	1125315	0	0
45663221	1149196	0	0
45639466	1125315	0	0
45667323	19059528	0	0
45702232	1332418	0	0
45698963	1125315	0	0
45697598	1125315	0	0
45690439	1551099	0	0
45786339	1129625	0	0
45690758	1110410	0	0
45702817	1125315	0	0
46292956	1548195	0	0
45894653	914335	0	0
45801712	1177480	0	0
46244606	933724	0	0
45896487	1115008	0	0
45797016	19073183	2	3
45794204	19057271	2	3
4169307	37017711	3	3
21000260	1778162	0	0
4287856	44805732	2	2
21002899	40173590	2	3
21604762	19123231	0	3
36156844	1115171	2	3
36208195	3000876	2	2
37503919	4163971	2	4
42805589	791967	0	0
44342720	708298	0	0
44360228	1112807	0	0
44346209	19133873	2	3
45656272	1589505	0	0
44346082	1125315	0	0
45659272	1125315	0	0
45659629	791967	0	0
45639506	1125315	0	0
45667332	1115008	0	0
45701838	1717327	0	0
45695465	1125315	0	0
45697764	1125315	0	0
45690444	1115008	0	0
45786569	1129625	0	0
45690828	1149196	0	0
45702818	1125315	0	0
46292956	1521369	0	0
45894438	1174888	0	0
45796169	1177480	0	0
46244610	1305058	0	0
45896497	738818	0	0
46302101	19075001	2	3
45788661	40232448	2	3
4169307	433644	3	3
21000282	1728416	0	0
21503268	975125	2	2
21002659	1551192	2	3
21604757	40236446	0	3
36157291	19059056	2	3
36208195	3021226	2	2
37202317	260139	2	4
42805654	701322	0	0
44342756	1322184	0	0
44360171	1154343	0	0
44346320	1115171	2	3
45656272	19127890	0	0
44346096	1125315	0	0
45656908	1125315	0	0
45659632	1115008	0	0
45639593	1125315	0	0
45667335	975125	0	0
45702187	1115008	0	0
45695474	1125315	0	0
45697547	1125315	0	0
45690446	1501700	0	0
45782288	1129625	0	0
45690729	1332418	0	0
45702801	1125315	0	0
46293181	1124957	0	0
45894621	1107830	0	0
45795979	1177480	0	0
46244458	1115008	0	0
45896527	1192710	0	0
46301863	1107882	2	3
45788666	19133905	2	3
4181187	4280726	3	3
21000261	1746114	0	0
21600191	914335	2	2
21002685	19007333	2	3
21601747	1332419	0	3
36157305	40222846	2	3
36208195	3001488	2	2
37002289	198199	2	4
42805515	1124300	0	0
44342837	1124957	0	0
44360174	738818	0	0
44346244	19008572	2	3
45656272	1549786	0	0
44345942	1125315	0	0
45656855	1125315	0	0
45659706	1149380	0	0
45639596	1125315	0	0
45667181	967823	0	0
45702032	975125	0	0
45695477	1125315	0	0
45697726	1125315	0	0
45690551	1367571	0	0
45702528	1129625	0	0
45690779	975125	0	0
45702784	1125315	0	0
46293190	1124300	0	0
45892894	45892894	0	0
45796347	1177480	0	0
46244459	1192710	0	0
45896582	1124300	0	0
45794197	40228214	2	3
45788667	1154615	2	3
4181187	4294548	3	3
21000268	1746114	0	0
21600191	40243436	2	2
21003018	1310034	2	3
21601860	1545959	0	3
36156990	40229134	2	3
36208195	3024731	2	2
36718338	381316	2	4
42805443	920293	0	0
44342845	1343916	0	0
44359919	738818	0	0
44346245	19008572	2	3
45656274	1174888	0	0
44346176	1125315	0	0
45657291	1125315	0	0
45659708	1000560	0	0
45639654	1125315	0	0
45667187	1308738	0	0
45702042	933724	0	0
45695556	1125315	0	0
45697704	1125315	0	0
45690555	1501700	0	0
45702748	1129625	0	0
45690709	1192710	0	0
45696498	1125315	0	0
46293211	975125	0	0
45892895	45892894	0	0
45790835	1177480	0	0
46244463	975125	0	0
45896668	1124300	0	0
46299967	40223768	2	3
45788699	19019273	2	3
4181187	40486433	3	3
21000265	1738521	0	0
21600280	1343916	2	2
21003025	42707627	2	3
21601856	1539411	0	3
36157031	40232448	2	3
36208195	3002385	2	2
37503924	4330583	1	6
42805446	1119510	0	0
44342758	19078219	0	0
44360176	1177480	0	0
44346424	19008572	2	3
45656405	738818	0	0
44346178	1125315	0	0
45657174	1125315	0	0
45659638	1539403	0	0
45639524	1125315	0	0
45667230	1551099	0	0
45702044	1174888	0	0
45695572	1125315	0	0
45697711	1125315	0	0
45690603	1115008	0	0
45702751	1129625	0	0
45690787	1110410	0	0
45696501	1125315	0	0
46293224	1545958	0	0
45893564	1332418	0	0
45790976	1177480	0	0
46240140	19127890	0	0
45896534	1551099	0	0
45791511	1107882	2	3
45788822	40229134	2	3
4134148	4186930	3	3
4170947	4170947	0	0
21600280	46275916	2	2
21003025	40243436	2	3
35202055	317576	2	3
36157171	1127433	2	3
36208195	3009542	2	2
37503919	4242997	1	3
42805451	1322184	0	0
44342760	1192710	0	0
44360185	1308738	0	0
44346634	1127433	2	3
45656037	1549786	0	0
44346190	1125315	0	0
45657489	1125315	0	0
45659698	1149196	0	0
45639567	1125315	0	0
45667342	1343916	0	0
45702070	975125	0	0
45695577	1125315	0	0
45697654	1125315	0	0
45690565	1310149	0	0
45702472	1129625	0	0
45690614	1545958	0	0
45696776	1125315	0	0
46293085	791967	0	0
45893609	1738521	0	0
45791858	1177480	0	0
46240140	1549786	0	0
45896573	1107830	0	0
46307156	1107882	2	3
45788869	40229134	2	3
4182161	372328	3	3
21000292	46233710	2	3
21500215	1332418	2	2
21003025	19078924	2	3
35402084	372328	2	3
36157188	40174880	2	3
36208195	3009201	2	2
37503958	4323902	1	3
42805421	1549786	0	0
44342858	1177480	0	0
44360187	1112807	0	0
44346268	40232448	2	3
45656311	1501700	0	0
44346195	1125315	0	0
45657260	1125315	0	0
45659656	1521369	0	0
45639585	1125315	0	0
45667466	1174888	0	0
45701956	1149196	0	0
45695678	1125315	0	0
45697601	1125315	0	0
45690502	1501700	0	0
45702742	1129625	0	0
45690616	1153428	0	0
45696705	1125315	0	0
46292752	1332418	0	0
45893562	1192710	0	0
45791972	1177480	0	0
46240140	1512674	0	0
45896553	19010482	0	0
46300331	1107882	2	3
45788818	40236446	2	3
4111522	4010253	3	3
21000244	19133905	2	3
21600269	1309944	2	2
21002627	19008572	2	3
21603448	40232448	2	3
36157466	19125062	2	3
36208195	3008598	2	2
37503893	4198190	1	4
42805327	1309944	0	0
44342785	1110410	0	0
44360187	1192710	0	0
44346386	19008572	2	3
45656214	1713332	0	0
44346153	1125315	0	0
45657491	1125315	0	0
45659658	1332418	0	0
45639677	1125315	0	0
45667237	1154029	0	0
45701958	1343916	0	0
45695761	1125315	0	0
45697603	1125315	0	0
45690504	1000560	0	0
45702573	1129625	0	0
45690621	975125	0	0
45696194	1125315	0	0
46293408	1000560	0	0
45893688	1738521	0	0
46295000	1177480	0	0
46240291	1557272	0	0
45896686	1192710	0	0
46318571	1107882	2	3
600000005	19115351	2	2
4096864	4266809	3	3
21000244	19075001	2	3
21600316	1361711	2	2
21002863	1115171	2	3
35507274	40223834	2	3
36157378	1127433	2	3
36208195	3014599	2	2
36718338	4066995	1	4
42805185	1149380	0	0
44342789	967823	0	0
44359925	1332418	0	0
44346388	1127433	2	3
45656037	1515774	0	0
44346329	1125315	0	0
45657386	1125315	0	0
45659541	1332418	0	0
45639644	1125315	0	0
45666356	791967	0	0
45702209	1115008	0	0
45695778	1125315	0	0
45697670	1125315	0	0
45690509	1107830	0	0
45702945	1129625	0	0
45690870	1000560	0	0
45696448	1125315	0	0
46293162	1000560	0	0
45893588	1149196	0	0
46244067	1177480	0	0
46240144	1557272	0	0
45896693	1110410	0	0
45799568	1107882	2	3
45876033	3013721	2	2
4096864	4310024	3	3
21000244	46233710	2	3
21500658	1308738	2	2
21002863	1127433	2	3
35204989	4329847	2	3
36157403	40232448	2	3
36208195	3007461	2	2
37503958	4337138	1	2
42805188	1713332	0	0
44342861	1738521	0	0
44359876	1129625	0	0
44338937	40162522	2	3
45652509	1110410	0	0
44346258	1125315	0	0
45657398	1125315	0	0
45659550	1332418	0	0
45639665	1125315	0	0
45666425	740275	0	0
45702129	738818	0	0
45694698	1125315	0	0
45695956	1125315	0	0
45690576	1000560	0	0
45702755	1129625	0	0
45690744	1500211	0	0
45765647	375671	3	3
46292752	1545958	0	0
45893695	1539403	0	0
46244086	1177480	0	0
46239763	1595799	0	0
45896413	1115008	0	0
46295319	1107882	2	3
45876033	3006923	2	2
4096864	196456	3	3
21000244	19073183	2	3
21500658	1125315	2	2
21002863	1127078	2	3
21603929	19007333	2	3
36152361	19008572	2	3
36208195	3012494	2	2
37203741	258780	1	2
42802479	1112807	0	0
44342875	1322184	0	0
44359876	1177480	0	0
44338996	19008572	2	3
45652384	1110410	0	0
44346204	1125315	0	0
45657407	1125315	0	0
45659736	1332418	0	0
45639623	1125315	0	0
45666426	920293	0	0
45702159	738818	0	0
45694701	1125315	0	0
45696023	1125315	0	0
45690596	1115008	0	0
45702758	1129625	0	0
45690805	1149196	0	0
45765647	378001	3	3
46292755	975125	0	0
45893616	967823	0	0
46244253	1177480	0	0
46239763	1521369	0	0
45896554	738818	0	0
45894748	19078461	2	3
45876033	3035995	2	2
4043176	4216130	3	3
21000290	1713671	2	3
21505743	1119510	2	2
21003153	1127433	2	3
35507349	1107882	2	3
36152363	19008572	2	3
36208195	3026361	2	2
36718586	4066995	1	2
42802493	1154343	0	0
44342876	1326303	0	0
44359883	933724	0	0
44339115	19008572	2	3
45652386	19127890	0	0
44346160	1125315	0	0
45657050	1125315	0	0
45659558	1539403	0	0
45639913	1125315	0	0
45666412	708298	0	0
45703560	1153428	0	0
45694383	1125315	0	0
45695934	1125315	0	0
45690421	1107830	0	0
45702765	1129625	0	0
45690879	1000560	0	0
45766714	133834	3	3
46293248	1124300	0	0
45801383	1115008	0	0
46244218	1177480	0	0
46239763	1549786	0	0
45896703	1154343	0	0
45896573	1107882	2	3
45876033	3007461	2	2
4029698	4163971	3	3
21000261	46233988	2	3
21505743	1174888	2	2
21003153	19019979	2	3
21604256	35605858	2	3
36157472	1115171	2	3
36208195	3001247	2	2
37503938	4275113	1	1
42802496	1545958	0	0
44342953	1307863	0	0
44359972	1124300	0	0
44339227	1127433	2	3
45652386	1549786	0	0
44346327	1125315	0	0
45657336	1125315	0	0
45659720	1326303	0	0
45639916	1125315	0	0
45666451	975125	0	0
45703562	1107830	0	0
45694709	1125315	0	0
45692762	1125315	0	0
45690515	1192710	0	0
45682541	1119510	0	0
45690817	1149196	0	0
45671738	19128263	3	4
46293228	1000560	0	0
45801501	1332418	0	0
46239183	1177480	0	0
46239764	708298	0	0
45896706	1717327	0	0
46317705	1107882	2	3
45876033	3004501	2	2
4040551	4202451	3	3
21000261	46233710	2	3
21500766	1308738	2	2
21003205	40229134	2	3
21603398	40162522	2	3
36157538	19059056	2	3
36208195	3006451	2	2
37503938	4238715	1	1
42802327	1713332	0	0
44342874	1192710	0	0
44359688	1738521	0	0
44339232	40231925	2	3
45652387	1309944	0	0
44346228	1125315	0	0
45657343	1125315	0	0
45659604	708298	0	0
45639804	1125315	0	0
45666452	1307863	0	0
45703805	967823	0	0
45694523	1125315	0	0
45693086	1125315	0	0
45690517	1124300	0	0
45682143	1119510	0	0
45690846	1154029	0	0
45687552	40221415	3	4
46292768	1192710	0	0
45801507	1746114	0	0
46239435	1177480	0	0
46239772	1192710	0	0
45896709	1307863	0	0
46300103	1107882	2	3
46240118	19127918	2	2
4180627	4035793	3	3
21000285	46233988	2	3
21500764	967823	2	2
21002683	1551192	2	3
21604260	40231925	2	3
36157754	1127433	2	3
36208195	3027231	2	2
37396227	4145310	1	1
42802327	1759842	0	0
44343079	1713332	0	0
44360083	1545958	0	0
44339236	1718412	2	3
45652708	920293	0	0
44346465	1125315	0	0
45655025	1125315	0	0
45659622	1107830	0	0
45636358	1125315	0	0
45666377	1149196	0	0
45703806	975125	0	0
45694711	1125315	0	0
45693087	1125315	0	0
45690544	920293	0	0
45680071	1119510	0	0
45690848	1154029	0	0
45702906	40221415	3	4
46293159	1115008	0	0
45801507	1741122	0	0
46239684	1177480	0	0
45787504	1112807	0	0
45896574	1174888	0	0
46312926	1107882	2	3
45788984	1539411	2	3
4156363	443279	3	3
21000265	46233988	2	3
21500216	1307863	2	2
21002846	19019273	2	3
21604344	40162522	2	3
36157735	1115171	2	3
36208195	3006734	2	2
37397180	439406	1	1
42802587	1310149	0	0
44342964	1192710	0	0
44360280	738818	0	0
44339427	40236824	2	3
45652625	1778162	0	0
44346486	1125315	0	0
45655376	1125315	0	0
45659553	1174888	0	0
45636361	1125315	0	0
45666380	738818	0	0
45699090	1332418	0	0
45692413	1125315	0	0
45693088	1125315	0	0
45691412	975125	0	0
45680011	1119510	0	0
45691064	1154343	0	0
45771096	440086	4	4
46292887	967823	0	0
45801508	920293	0	0
46239541	1177480	0	0
45787741	1112807	0	0
45896574	1192710	0	0
45797105	1107882	2	3
46307916	1539411	2	3
4172515	4197460	3	3
21000265	46233710	2	3
21500676	1396131	2	2
21002827	1115171	2	3
21604344	19133768	2	3
36157901	40232448	2	3
36208195	3015076	2	2
37397180	4048169	1	1
42802372	1125315	0	0
44342925	1112807	0	0
44360283	1129625	0	0
44339523	920334	2	3
45652739	1153428	0	0
44346634	1125315	0	0
45655479	1125315	0	0
45659681	1332418	0	0
45636300	1125315	0	0
45666382	1107830	0	0
45699022	1124957	0	0
45692427	1125315	0	0
45692794	1125315	0	0
45691435	1549786	0	0
45680077	1119510	0	0
45690999	1000560	0	0
46235681	3023103	2	2
46288140	723013	0	0
45801509	1551099	0	0
45895936	1177480	0	0
45801029	1112807	0	0
45896576	1174888	0	0
46300232	1107882	2	3
45799530	1539411	2	3
4029549	4301346	3	3
21000284	46233988	2	3
21500676	1595799	2	2
21002842	1551192	2	3
21603926	1305058	2	2
36157568	40228230	2	3
36208978	40766240	2	4
37003658	195588	1	1
42802567	1539403	0	0
44342930	1343916	0	0
44360297	1112807	0	0
44339097	19133905	2	3
45652741	1512674	0	0
44346267	1125315	0	0
45655458	1125315	0	0
45659557	1174888	0	0
45636313	1125315	0	0
45666386	1154029	0	0
45699124	975125	0	0
45692431	1125315	0	0
45692922	1125315	0	0
45691489	1192710	0	0
45677561	1119510	0	0
45691000	1361711	0	0
46235681	3016723	2	2
46287865	1153428	0	0
45801511	1322184	0	0
45895938	1177480	0	0
45801102	1112807	0	0
45896416	1343916	0	0
46318722	1332419	2	3
600000004	19074679	1	4
4030028	44783196	3	3
21000267	46233710	2	3
21500676	1308738	2	2
21002673	1551192	2	3
21603926	19007333	2	2
36157578	40229134	2	3
36208978	40758406	2	4
36903656	443279	2	2
42802543	1549786	0	0
44342939	1149380	0	0
44353103	975125	0	0
44360460	40236824	2	3
45652741	1549786	0	0
44346433	1125315	0	0
45655462	1125315	0	0
45659814	1107830	0	0
45636217	1125315	0	0
45666387	1107830	0	0
45699132	975125	0	0
45692729	1125315	0	0
45692930	1125315	0	0
45691491	1501700	0	0
45677878	1119510	0	0
45690885	1115008	0	0
45800486	19128009	2	2
46287866	1115008	0	0
45801400	1110410	0	0
45896077	1177480	0	0
45802589	1112807	0	0
45896418	1115008	0	0
45794428	40173590	2	3
46307291	42902245	1	2
4043023	4163872	3	3
21000245	46233988	2	3
21500803	1367571	2	2
21002682	19007333	2	3
35104341	4056621	2	2
36157621	1127433	2	3
36208978	40769189	2	4
36903604	378419	2	2
42802543	19127890	0	0
44342880	1192710	0	0
44353105	1118084	0	0
44360732	43012036	2	3
45652741	19127890	0	0
44346383	1125315	0	0
45655463	1125315	0	0
45659853	738818	0	0
45636460	1125315	0	0
45666413	1115008	0	0
45699051	1154029	0	0
45692975	1125315	0	0
45692938	1125315	0	0
45687249	975125	0	0
45677891	1119510	0	0
45690886	975125	0	0
45800486	19127918	2	2
46287999	1310149	0	0
45801754	1729720	0	0
45896146	1177480	0	0
45801418	1112807	0	0
45896419	1153428	0	0
46307150	19079524	2	3
46318515	19127904	1	2
4043023	4337138	3	3
21000245	46233710	2	3
21500803	1310149	2	2
21002682	1551192	2	3
21603445	1153428	2	2
36157939	19008572	2	3
36208978	40769194	2	4
36919120	378419	2	2
42802543	1515774	0	0
44342797	1308738	0	0
44353230	1738521	0	0
44360702	1551192	2	3
45652692	1332418	0	0
44338937	1125315	0	0
45655466	1125315	0	0
45659857	914335	0	0
45636436	1125315	0	0
45666414	975125	0	0
45699097	1115008	0	0
45692290	1192710	0	0
45692755	1125315	0	0
45687338	1713332	0	0
45678032	1119510	0	0
45690888	1000560	0	0
45885349	4146173	2	2
46288479	1738521	0	0
45801756	1307863	0	0
45895892	1177480	0	0
45795823	1112807	0	0
45896764	1000560	0	0
46307511	1332419	2	3
46321021	46275916	1	1
4043023	4163951	3	3
4181195	44783196	2	3
21600190	914335	2	2
21002663	1551192	2	3
21603445	1107830	2	2
36158076	40229134	2	3
36208978	40769179	2	4
40795922	3001488	2	2
42802554	914335	0	0
44342799	1154029	0	0
44352939	1738521	0	0
44360469	40232448	2	3
45652673	1307863	0	0
44338928	1125315	0	0
45655470	1125315	0	0
45659957	1174888	0	0
45636442	1125315	0	0
45666440	701322	0	0
45699214	1154029	0	0
45692297	1115008	0	0
45692765	1125315	0	0
45687338	1759842	0	0
45677835	1119510	0	0
45690889	1778162	0	0
45876166	3006322	2	2
46288494	1713332	0	0
45801459	1000560	0	0
45896133	1177480	0	0
45795855	1112807	0	0
45894627	933724	0	0
46319575	1332419	2	3
46321021	19079524	1	1
4040396	4186930	3	3
4134443	4149245	2	3
21503342	1125315	2	2
21002655	1551192	2	3
21603445	1149196	2	2
36158001	40222846	2	3
36208978	40769184	2	4
40795725	3000963	2	2
42802626	1000560	0	0
44342999	1310149	0	0
44353281	738818	0	0
44360790	40231925	2	3
45652454	1154029	0	0
44339138	1125315	0	0
45655423	1125315	0	0
45660079	1539403	0	0
45636445	1125315	0	0
45666455	1308738	0	0
45699216	920293	0	0
45692299	1174888	0	0
45692992	1125315	0	0
45687361	1308738	0	0
45677990	1119510	0	0
45691001	1149196	0	0
45803035	42902245	2	2
46288494	1759842	0	0
45801461	1501700	0	0
45896033	1177480	0	0
45790421	1112807	0	0
45894630	1332418	0	0
45794344	19075601	2	3
45796838	19127922	1	1
4043161	4199276	3	3
4041261	4238715	2	3
21500562	757627	2	2
21002894	46275444	2	3
21603445	1192710	2	2
36102149	257012	2	3
36208978	3006322	2	4
40795727	3009201	2	2
42802558	1154343	0	0
44343138	1124300	0	0
44353307	1115008	0	0
44360875	40232448	2	3
45652594	1713332	0	0
44338997	1125315	0	0
45653856	1125315	0	0
45659769	1174888	0	0
45636437	1125315	0	0
45666471	1107830	0	0
45699067	1717327	0	0
45692314	1343916	0	0
45693000	1125315	0	0
45687469	1501700	0	0
45679563	1119510	0	0
45690930	1367571	0	0
45795011	19128009	2	2
46288502	1124300	0	0
45801462	1174888	0	0
45896072	1177480	0	0
45790793	1112807	0	0
45894525	757627	0	0
45794752	40228214	2	3
45796838	19129144	1	1
4042150	4218408	3	3
4170143	4112343	2	4
21500562	715997	2	2
21002025	19073183	2	3
21603445	1129625	2	2
36156759	40236446	2	3
36208978	21494966	2	4
40795730	3013682	2	2
42802591	1551099	0	0
44343289	1192710	0	0
44353284	1149196	0	0
44360658	19008572	2	3
45652594	1759842	0	0
44339012	1125315	0	0
45653955	1125315	0	0
45659772	1307863	0	0
45636395	1125315	0	0
45666528	715997	0	0
45699143	975125	0	0
45692341	933724	0	0
45693073	1125315	0	0
45687275	1738521	0	0
45679568	1119510	0	0
45687314	1309944	0	0
45785737	19128009	2	2
46288013	1112807	0	0
45801364	1115008	0	0
45896101	1177480	0	0
45790503	1112807	0	0
45894719	723013	0	0
45802251	40174880	2	3
45796838	19133679	1	1
4042150	4202451	3	3
4170143	4294548	2	4
21600885	967823	2	2
21002025	19073188	2	3
21603445	1150770	2	2
36152735	42707627	2	3
36517140	81151	2	5
40652452	3006322	2	2
42802464	914335	0	0
44343305	975125	0	0
44353309	1174888	0	0
44361014	1127433	2	3
45652581	1174888	0	0
44339227	1125315	0	0
45653921	1125315	0	0
45659774	1361711	0	0
45636153	1125315	0	0
45663828	967823	0	0
45699146	1361711	0	0
45692346	1332418	0	0
45693033	1125315	0	0
45687394	723013	0	0
45679569	1119510	0	0
45687700	1308738	0	0
46240118	19128009	2	2
46287970	1153428	0	0
45801573	1149196	0	0
45896185	1177480	0	0
45790868	1112807	0	0
45894170	1738521	0	0
45895663	19075601	2	3
46315219	42902245	2	2
4040400	4295880	3	3
4171379	195588	2	5
21600248	1309944	2	2
21002642	1551192	2	3
35104366	4056621	2	2
35507109	40236446	2	3
36208195	3004501	2	5
37320143	133834	2	2
42802423	1177480	0	0
44343092	1177480	0	0
44353316	933724	0	0
44360629	40232448	2	3
45652583	1124300	0	0
44339232	1125315	0	0
45654100	1125315	0	0
45659777	1549786	0	0
45636340	1125315	0	0
45664454	975125	0	0
45699148	1174888	0	0
45691936	1149196	0	0
45693189	1125315	0	0
45687471	1729720	0	0
45674689	1119510	0	0
45687348	975125	0	0
45895008	19128009	2	2
46288169	1738521	0	0
45801472	1545958	0	0
45896702	1177480	0	0
45790814	1112807	0	0
45894248	1729720	0	0
46298976	19079524	1	1
44361178	40231925	2	3
4040400	4238715	3	3
4029565	4198190	2	2
21600279	1343916	2	2
21002642	19008572	2	3
21605042	1149380	2	2
36213601	19128263	2	3
36208195	3013682	2	5
36903593	440086	2	2
44359268	1738521	0	0
44343094	1738521	0	0
44353319	1192710	0	0
44361059	40169216	2	3
45652646	1595799	0	0
44339168	1125315	0	0
45654165	1125315	0	0
45659777	19127890	0	0
45636326	1125315	0	0
45664518	920293	0	0
45699151	1310149	0	0
45692062	1332418	0	0
45693192	1125315	0	0
45687472	1192710	0	0
45674631	1119510	0	0
45687350	791967	0	0
45895008	19127918	2	2
46288518	1112807	0	0
45801473	1174888	0	0
45896827	1177480	0	0
45790568	1112807	0	0
45894171	1729720	0	0
46307852	19079524	1	1
44361216	40162522	2	3
4040400	4337138	3	3
4134443	4035415	2	2
21503332	975125	2	2
21002630	19008572	2	3
21603891	19010482	2	2
36213601	19128022	2	3
36208195	3020630	2	5
37522193	4293740	2	2
44359322	1129625	0	0
44343098	738818	0	0
44353322	791967	0	0
44360632	40232448	2	3
45652647	1124957	0	0
44339121	1125315	0	0
45647365	1125315	0	0
45659777	1521369	0	0
45636529	1125315	0	0
45664533	975125	0	0
45699077	1539403	0	0
45692143	967823	0	0
45693104	1125315	0	0
45687478	975125	0	0
45674957	1119510	0	0
45687429	914335	0	0
45802937	42902245	2	2
46288531	1501700	0	0
45801478	740275	0	0
45896664	1177480	0	0
45790686	1112807	0	0
45894184	920293	0	0
46302627	19079524	1	1
45650533	40232448	2	3
4040400	40492359	5	5
4134439	4001336	2	2
21503409	1396131	2	2
21002630	1551192	2	3
21603891	1305058	2	2
36156981	1551192	2	3
36208195	3024561	2	5
40795740	3004501	2	2
44359323	1112807	0	0
44343203	1192710	0	0
44353141	1177480	0	0
44338212	19073183	2	3
45652648	1713332	0	0
44339345	1125315	0	0
45647481	1125315	0	0
45660019	1305058	0	0
45636469	1125315	0	0
45664603	975125	0	0
45699274	1110410	0	0
45692159	1332418	0	0
45692859	1125315	0	0
45687480	1713332	0	0
45674659	1119510	0	0
45687773	1310149	0	0
45787205	19128263	2	2
46288056	1112807	0	0
45801371	1000560	0	0
45896744	1177480	0	0
46297571	1112807	0	0
45894228	1153428	0	0
46313268	46275916	1	1
45650556	40174880	2	3
4043022	4242997	5	5
4134439	4066995	2	2
21500770	1308738	2	2
21002630	40228214	2	3
21604077	42707627	2	2
36157365	1551192	2	3
36208195	3016723	2	5
40775801	3016723	2	2
44359325	1124300	0	0
44343211	1118084	0	0
44353064	975125	0	0
44359791	43012036	2	3
45655047	1115008	0	0
44339125	1125315	0	0
45647482	1125315	0	0
45660044	1115008	0	0
45636614	1125315	0	0
45664618	975125	0	0
45699244	1778162	0	0
45692379	1149196	0	0
45692862	1125315	0	0
45687406	1396131	0	0
45674784	1119510	0	0
45687824	1174888	0	0
45696797	19057271	2	3
46288057	975125	0	0
45801453	1713332	0	0
45804330	1177480	0	0
46297954	1112807	0	0
45894188	1551099	0	0
46313268	19079524	1	1
46319484	1125315	0	0
4043022	4337611	5	5
4136573	4134304	2	2
21500752	967823	2	2
21002630	40228230	2	3
21604077	19003953	2	2
36157685	1545959	2	3
36208195	3035995	2	5
37320127	4296204	2	2
44359329	1192710	0	0
44343287	1112807	0	0
44353065	1115008	0	0
44345969	42707627	2	3
45655059	1115008	0	0
44339023	1125315	0	0
45647393	1125315	0	0
45659895	1124300	0	0
45636615	1125315	0	0
45664733	1000560	0	0
45699413	1521369	0	0
45694654	1149196	0	0
45693058	1125315	0	0
45687410	1738521	0	0
45674842	1119510	0	0
45687999	1149196	0	0
45696730	19008572	2	3
46288171	1112807	0	0
45801589	1551099	0	0
45797301	1177480	0	0
46297756	1112807	0	0
45894191	1717327	0	0
46321640	19079524	1	1
46319580	1125315	0	0
4040396	4163971	5	5
4135090	4134304	2	2
21600884	967823	2	2
21500093	19007333	6	7
21605009	1149380	2	2
4130852	4059173	2	3
36208195	3027970	2	5
37522151	4197460	2	2
44359330	1192710	0	0
44343288	708298	0	0
44353067	791967	0	0
44359670	40236446	2	3
45655170	738818	0	0
44339025	1125315	0	0
45647398	1125315	0	0
45659901	1501700	0	0
45636409	1125315	0	0
45664670	1115008	0	0
45699413	1549786	0	0
45694622	1192710	0	0
45693067	1125315	0	0
45687329	1192710	0	0
45674975	1119510	0	0
45688002	1124957	0	0
45696374	1115171	2	3
46288178	1326303	0	0
45801453	1759842	0	0
45796703	1177480	0	0
46297422	1112807	0	0
45894196	1115008	0	0
46303642	19079524	1	1
46319581	1125315	0	0
4093991	317576	5	5
4135097	4134304	2	2
21601078	1396131	2	2
21500936	19008572	6	7
21604254	1154029	2	2
4130852	4109685	2	3
36208195	3006906	2	5
37303797	4102123	2	2
44359332	1713332	0	0
44343173	738818	0	0
44353244	738818	0	0
44355568	19078461	2	3
45655171	1309944	0	0
44339580	1125315	0	0
45647399	1125315	0	0
45660048	1115008	0	0
45636943	1125315	0	0
45663979	1549786	0	0
45699413	19127890	0	0
45694689	1124957	0	0
45690014	1125315	0	0
45687523	1107830	0	0
45674879	1119510	0	0
45688006	1153428	0	0
45696823	40232448	2	3
46288548	791967	0	0
45801611	1521369	0	0
45796547	1177480	0	0
46297966	1112807	0	0
45894262	715997	0	0
46307301	46275916	1	1
46319445	1125315	0	0
4180627	4170947	5	5
4138286	4149245	2	2
21601078	1595799	2	2
21602681	40174880	6	7
21603395	1119510	2	2
35406420	372328	1	1
36208195	3013721	2	5
37521809	4337138	2	2
44359338	1112807	0	0
44343238	1177480	0	0
44353142	975125	0	0
44353682	19019273	2	3
45655352	1332418	0	0
44339588	1125315	0	0
45647459	1125315	0	0
45660081	1310149	0	0
45637054	1125315	0	0
45663979	1519936	0	0
45699416	1174888	0	0
45689038	1501700	0	0
45689840	1125315	0	0
45687562	738818	0	0
45674887	1119510	0	0
45687888	1713332	0	0
45696848	920300	2	3
46288600	1713332	0	0
45801611	1595799	0	0
45791201	1177480	0	0
46289024	1112807	0	0
45894267	1115008	0	0
46307301	19079524	1	1
46319159	1125315	0	0
4043023	4057420	5	5
4101212	30753	2	2
21600192	40243436	2	3
21604795	40223768	0	3
21601421	1305058	2	2
35402603	372328	1	1
36208195	3006923	2	5
37522270	4323208	2	2
44359019	1551099	0	0
44343073	1322184	0	0
44353072	1112807	0	0
44346248	19019273	2	3
45655327	1310149	0	0
45619683	1125315	0	0
45647412	1125315	0	0
45659799	1174888	0	0
45633183	1125315	0	0
45663952	1124300	0	0
45699510	1149196	0	0
45689142	1118084	0	0
45689786	1125315	0	0
45687676	1115008	0	0
45674891	1119510	0	0
45687888	1759842	0	0
45696666	40163554	2	3
46288607	1549786	0	0
45801611	1549786	0	0
45791142	1177480	0	0
46289157	1112807	0	0
45894268	1500211	0	0
46308433	19079524	1	1
46319385	1125315	0	0
4043023	4078793	5	5
4048512	78272	2	2
21505737	19059056	2	3
21602842	19133873	0	3
21601854	1539403	2	2
35104366	4280726	1	1
36211303	4142905	2	7
40652424	3049273	2	2
44359234	1107830	0	0
44343216	738818	0	0
44353073	1149380	0	0
44353588	19019273	2	3
45655301	1118084	0	0
44360451	1125315	0	0
45647552	1125315	0	0
45660052	1107830	0	0
45633188	1125315	0	0
45663959	975125	0	0
45699361	1539403	0	0
45689150	1310149	0	0
45689790	1125315	0	0
45687280	1192710	0	0
45674772	1119510	0	0
45687834	1501700	0	0
45696834	19019273	2	3
46288301	1112807	0	0
45801612	1154343	0	0
45791259	1177480	0	0
46289060	1112807	0	0
45894278	1551099	0	0
46319612	19079524	1	1
46319390	1125315	0	0
4180169	133834	5	5
4042641	4218408	2	2
21505756	19019273	2	3
21602886	19074843	0	3
35402602	372328	2	2
35104341	4280726	1	1
36208195	3000963	2	6
40652448	3049273	2	2
44359196	1729720	0	0
44343012	723013	0	0
44353258	738818	0	0
44348279	19019273	2	3
45655315	1332418	0	0
44360453	1125315	0	0
45647585	1125315	0	0
45660053	1310149	0	0
45633203	1125315	0	0
45663945	1124957	0	0
45699381	1326303	0	0
45689152	1000560	0	0
45689898	1125315	0	0
45687379	1713332	0	0
45675084	1119510	0	0
45687492	975125	0	0
45802696	40232448	2	3
46287974	1322184	0	0
45801554	1309944	0	0
45791154	1177480	0	0
46289210	1112807	0	0
45894395	1192710	0	0
46304864	19079524	1	1
46239815	1125315	0	0
4180170	4048171	5	5
4042641	4163951	2	2
21003656	46233710	2	3
21604566	19076374	0	3
21603671	1343916	2	2
21601767	40171902	1	1
36208195	3045716	2	6
40652431	3024561	2	2
44359173	1549786	0	0
44343015	1759842	0	0
44353265	1500211	0	0
44346646	19019273	2	3
45655181	1307863	0	0
44360509	1125315	0	0
45647806	1125315	0	0
45656656	1000560	0	0
45633487	1125315	0	0
45663984	1322184	0	0
45699524	1115008	0	0
45689307	914335	0	0
45689824	1125315	0	0
45687534	738818	0	0
45674729	1119510	0	0
45687505	1738521	0	0
45802861	40229134	2	3
46288200	1322184	0	0
45801567	1115008	0	0
45791529	1177480	0	0
46289375	1112807	0	0
45894285	1332418	0	0
46309292	19079524	1	1
46239885	1125315	0	0
4180170	258780	5	5
4030292	4116491	2	2
21004496	19129655	2	3
21600989	19075601	0	3
21602099	975125	2	2
35202472	4329847	1	2
36208195	3014576	2	6
40652431	3016723	2	2
44359173	1515774	0	0
44343015	1713332	0	0
44353267	715997	0	0
44338725	19019273	2	3
45655304	1154343	0	0
44360741	1125315	0	0
45647501	1125315	0	0
45656923	738818	0	0
45633646	1125315	0	0
45663985	1110410	0	0
45695868	1110410	0	0
45689299	1115008	0	0
45690123	1125315	0	0
45687536	1738521	0	0
45671750	1119510	0	0
45687663	975125	0	0
45803046	19008572	2	3
46288060	1124300	0	0
45801440	1149196	0	0
46299140	1177480	0	0
46289975	1112807	0	0
45894235	791967	0	0
46316590	19079524	1	1
46239998	1125315	0	0
4134149	4330583	5	5
4030031	4057420	2	2
21004497	19129655	2	3
21604799	40222846	0	3
21605125	967823	2	2
35202471	317576	1	2
36208195	3019550	2	6
40652431	3013682	2	2
44359200	1551099	0	0
44343020	738818	0	0
44353345	975125	0	0
44360630	19019273	2	3
45655332	1115008	0	0
44360896	1125315	0	0
45647811	1125315	0	0
45657176	1326303	0	0
45633396	1125315	0	0
45664017	705944	0	0
45695901	740275	0	0
45689233	1000560	0	0
45689812	1125315	0	0
45686065	1125315	0	0
45671789	1119510	0	0
45687672	1124957	0	0
45802977	19007333	2	3
46288185	1521369	0	0
45801442	920293	0	0
46298940	1177480	0	0
46241617	1112807	0	0
45894291	1713332	0	0
46304638	19079524	1	1
46239837	1125315	0	0
4130852	40479422	5	5
4181251	78272	2	2
21600303	46275916	2	3
21604417	19074679	0	3
21605058	914335	2	2
35200000	4051466	6	6
36208195	3023103	2	6
40652431	3008598	2	2
44359293	1501700	0	0
44342909	1738521	0	0
44353269	975125	0	0
44355443	19078461	2	3
45655183	1149196	0	0
44360673	1125315	0	0
45647766	1125315	0	0
45656724	19127890	0	0
45633398	1125315	0	0
45664023	1310149	0	0
45695812	1124957	0	0
45689162	738818	0	0
45689954	1125315	0	0
45685933	1125315	0	0
45671857	1119510	0	0
45687928	1332418	0	0
45803131	40174880	2	3
46288185	1549786	0	0
45801446	1174888	0	0
46299349	1177480	0	0
46241847	1112807	0	0
45894355	1115008	0	0
46307013	19079524	1	1
46239838	1125315	0	0
4181192	4107731	4	5
4181583	40481087	2	2
21004494	19129655	2	3
21604797	19077572	0	3
21601422	1305058	2	2
35200000	381316	6	6
36208195	3015632	2	6
40652431	3004501	2	2
44359294	1129625	0	0
44342911	1551099	0	0
44353271	1129625	0	0
44359784	19019273	2	3
45655281	1595799	0	0
44360682	1125315	0	0
45647945	1125315	0	0
45656724	1521369	0	0
45633332	1125315	0	0
45664028	1124957	0	0
45695743	1741122	0	0
45689171	1124957	0	0
45689958	1125315	0	0
45688478	1125315	0	0
45671999	1119510	0	0
45687929	1551099	0	0
45800140	40231925	2	3
46288335	1174888	0	0
45801520	967823	0	0
46292007	1177480	0	0
46241886	1112807	0	0
45894396	1118084	0	0
46307197	19079524	1	1
46239851	1125315	0	0
4180170	4112343	4	5
4138262	4107731	2	2
21004495	19129655	2	3
21604571	19057271	0	3
21605126	967823	2	2
35200000	4163874	6	6
35707763	4027663	2	5
40652431	3006906	2	2
44359011	738818	0	0
44342914	1551099	0	0
44353163	738818	0	0
44360717	40223834	2	3
45655281	1521369	0	0
44360845	1125315	0	0
45647739	1125315	0	0
45656724	1549786	0	0
45633342	1125315	0	0
45664085	1332418	0	0
45695743	1746114	0	0
45689237	1174888	0	0
45690030	1125315	0	0
45682728	1125315	0	0
45672135	1119510	0	0
45687948	1759842	0	0
45800027	40236446	2	3
46288348	1149196	0	0
45801651	1557272	0	0
46290582	1177480	0	0
46241821	1112807	0	0
45894365	1192710	0	0
46314824	19079524	1	1
46239860	1125315	0	0
4190185	4112343	4	5
4119403	4323902	2	2
21004491	19129655	2	3
21600965	40163554	0	3
21603923	19010482	2	2
35202051	441267	6	6
35707763	4166224	2	8
40652431	3000963	2	2
44359000	975125	0	0
44343164	1177480	0	0
44353167	975125	0	0
44339041	19123231	2	3
45655281	1549786	0	0
44360642	1125315	0	0
45648014	1125315	0	0
45656673	1548195	0	0
45633623	1125315	0	0
45664165	975125	0	0
45695745	1174888	0	0
45688968	1149196	0	0
45690140	1125315	0	0
45682847	1125315	0	0
45672030	1119510	0	0
45687948	1713332	0	0
45800036	40163554	2	3
46288360	1192710	0	0
45801652	1343916	0	0
46290662	1177480	0	0
46241830	1112807	0	0
45894361	1000560	0	0
46314532	19079524	1	1
46239861	1125315	0	0
4043346	4329847	4	5
4084434	4149245	2	2
21009232	46233710	2	3
21602660	40236824	0	3
21605059	914335	2	2
35202051	4310024	6	6
35707763	4310024	1	6
40652431	3023103	2	2
44359304	738818	0	0
44343405	1738521	0	0
44353171	1112807	0	0
44346154	40163554	2	3
45652769	791967	0	0
44360790	1125315	0	0
45647828	1125315	0	0
45656864	1545958	0	0
45633637	1125315	0	0
45664030	1124300	0	0
45695747	1728416	0	0
45689253	1124957	0	0
45690117	1125315	0	0
45682854	1125315	0	0
45672036	1119510	0	0
45687959	1192710	0	0
45800123	19078924	2	3
46288366	1124300	0	0
45801657	19127890	0	0
46290880	1177480	0	0
45895928	1112807	0	0
45894419	1149196	0	0
46301157	19079524	1	1
46239944	1125315	0	0
4162054	4108705	4	5
4086016	4230209	2	2
21004631	19129655	2	3
21604794	836659	0	3
21604304	1112807	2	2
21602359	19127918	6	6
35707763	4266809	1	6
40652431	3028833	2	2
44359306	738818	0	0
44343051	1177480	0	0
44353377	1129625	0	0
44339293	1545959	2	3
45652776	705944	0	0
44360849	1125315	0	0
45647835	1125315	0	0
45656695	738818	0	0
45633438	1125315	0	0
45664037	1367571	0	0
45695584	1000560	0	0
45689397	1501700	0	0
45690042	1125315	0	0
45682858	1125315	0	0
45672083	1119510	0	0
45687795	1000560	0	0
45800373	19019273	2	3
46288438	1548195	0	0
45801657	1549786	0	0
46290772	1177480	0	0
45803832	1112807	0	0
45894424	1192710	0	0
46312891	19079524	1	1
46321843	1125315	0	0
4101796	378419	4	5
4086016	4234705	2	2
21004632	19129655	2	3
21502567	914335	0	0
21604269	1154029	2	2
21602359	42902245	6	6
35707763	192671	1	4
40652431	3020630	2	2
44359314	1539403	0	0
44342915	1551099	0	0
44353292	1129625	0	0
44338953	1713671	2	3
45652824	1124957	0	0
44360606	1125315	0	0
45647932	1125315	0	0
45656839	1309944	0	0
45633650	1125315	0	0
45663995	1174888	0	0
45695593	1309944	0	0
45689073	1124957	0	0
45690055	1125315	0	0
45682866	1125315	0	0
45783997	1119510	0	0
45687865	791967	0	0
45800381	19133873	2	3
46288447	1548195	0	0
45801658	1154343	0	0
46242523	1177480	0	0
45798936	1112807	0	0
45894511	738818	0	0
46302263	19079524	1	1
46321960	1125315	0	0
4172024	4139681	4	5
4049972	441267	2	2
21004854	19129655	2	3
21502572	1589505	0	0
21604269	1102527	2	2
21602359	19133679	6	6
36211260	81151	1	3
40652433	3006906	2	2
44359352	1177480	0	0
44343061	1115008	0	0
44353293	19127890	0	0
44348284	19019273	2	3
45652852	1000560	0	0
44360987	1125315	0	0
45647934	1125315	0	0
45656681	1149196	0	0
45633548	1125315	0	0
45663998	1549786	0	0
45695757	1717327	0	0
45689470	1332418	0	0
45690178	1125315	0	0
45683022	1125315	0	0
45784113	1119510	0	0
45687908	914335	0	0
45800232	19019273	2	3
45897778	19073183	2	3
45801710	715997	0	0
46242359	1177480	0	0
45798710	1112807	0	0
45894303	1000560	0	0
46302263	46275916	1	1
46321962	1125315	0	0
4042503	4134304	4	5
4051932	4078793	2	2
21002574	19129655	2	3
21502572	1549786	0	0
21604255	1110410	2	2
21602359	19129144	6	6
36207527	40766240	1	3
40652433	3014576	2	2
44351888	1129625	0	0
44343062	1310149	0	0
44353293	1521369	0	0
44353307	19019273	2	3
45652929	738818	0	0
44360885	1125315	0	0
45644496	1125315	0	0
45656899	1174888	0	0
45633687	1125315	0	0
45663998	1521369	0	0
45695846	1501700	0	0
45689367	1124957	0	0
45689967	1125315	0	0
45683084	1125315	0	0
45784069	1119510	0	0
45687915	967823	0	0
45800235	40229134	2	3
45787779	1107882	2	3
45801679	1549786	0	0
46239452	1177480	0	0
45799017	1112807	0	0
45894519	757627	0	0
46303493	19079524	1	1
46322225	1125315	0	0
4043176	4336464	4	5
4050572	40492359	2	2
21001936	19129655	2	3
21502572	1595799	0	0
21601855	1539403	2	2
21602359	19128009	6	6
36207527	40769179	1	3
40652433	3035995	2	2
44352323	920293	0	0
44339271	1759842	0	0
44353293	1549786	0	0
44360570	19019273	2	3
45652856	1000560	0	0
44361077	1125315	0	0
45644533	1125315	0	0
45656933	1713332	0	0
45633697	1125315	0	0
45664112	791967	0	0
45695873	1124300	0	0
45689373	1549786	0	0
45690181	1125315	0	0
45682942	1125315	0	0
45784188	1119510	0	0
45687741	1192710	0	0
45800309	19008572	2	3
46241489	1107882	2	3
45801679	19127890	0	0
45896232	1177480	0	0
45793779	1112807	0	0
45894400	1000560	0	0
46300083	19079524	1	1
46321749	1125315	0	0
4182161	40481087	4	5
4051796	4330583	2	2
21503065	46275916	2	3
21502572	19127890	0	0
21601855	1545958	2	2
21602359	19128263	6	6
36207527	40769194	1	3
40652433	3045716	2	2
44352326	967823	0	0
44339276	1153428	0	0
44355558	1149196	0	0
44353230	46233710	2	3
45652863	740275	0	0
44360854	1125315	0	0
45644670	1125315	0	0
45656752	1154343	0	0
45633413	1125315	0	0
45664116	1768849	0	0
45697539	1124300	0	0
45689344	723013	0	0
45690237	1125315	0	0
45683008	1125315	0	0
45784238	1119510	0	0
45687744	1124957	0	0
45802307	40236446	2	3
45803462	1107882	2	3
45801528	1738521	0	0
45896201	1177480	0	0
45793658	1112807	0	0
45802371	1539403	0	0
45876002	3028833	1	1
46321750	1125315	0	0
4042140	80180	4	5
4045900	4170947	2	2
21003586	40243436	2	3
21502572	1521369	0	0
21604343	1125315	2	2
21602359	19127922	6	6
36207527	3006322	1	3
40652433	3006923	2	2
44352327	1124300	0	0
44339410	705944	0	0
44355423	1149380	0	0
44341385	1332419	2	3
45653032	1174888	0	0
44361014	1125315	0	0
45644687	1125315	0	0
45656753	1501700	0	0
45630373	1125315	0	0
45664172	1343916	0	0
45697704	738818	0	0
45689536	1153428	0	0
45690244	1125315	0	0
45683103	1125315	0	0
45784095	1119510	0	0
45687962	1713332	0	0
45797369	19019273	2	3
46241496	1107882	2	3
45801679	1512674	0	0
45893968	1177480	0	0
45793544	1112807	0	0
45802374	723013	0	0
45876002	3016723	1	1
46321761	1125315	0	0
4180169	198809	4	5
4193783	4314290	2	2
21505859	40236446	2	3
21502573	1500211	0	0
21603396	1119510	2	2
21602359	19128022	6	6
36207527	21494966	1	3
40652433	3015632	2	2
44352051	1112807	0	0
44339412	1192710	0	0
44355677	975125	0	0
44339417	1107882	2	3
45652895	1174888	0	0
44360828	1125315	0	0
45644700	1125315	0	0
45656757	1310149	0	0
45630496	1125315	0	0
45664045	1107830	0	0
45697713	1115008	0	0
45689485	1154343	0	0
45690361	1125315	0	0
45682752	1125315	0	0
45784289	1119510	0	0
45688627	1539403	0	0
45797461	19073188	2	3
45798067	19075001	2	3
45801669	1107830	0	0
45894068	1177480	0	0
45788470	1112807	0	0
45802375	1192710	0	0
45876002	3045716	1	1
46322189	1125315	0	0
4134598	4323902	4	5
4194763	4037675	2	2
21004571	40243436	2	3
21502574	1589505	0	0
21603931	19019273	6	7
21602796	19075001	5	6
36207527	40769189	1	3
40652433	3004501	2	2
44352057	1551099	0	0
44339416	1521369	0	0
44355687	1177480	0	0
44353503	1107882	2	3
45649595	1124957	0	0
44361039	1125315	0	0
45644560	1125315	0	0
45656762	1107830	0	0
45630509	1125315	0	0
45664181	1192710	0	0
45697654	738818	0	0
45689489	19010482	0	0
45690194	1125315	0	0
45682756	1125315	0	0
45781878	1119510	0	0
45688594	1115008	0	0
45797477	19075001	2	3
45895250	1107882	2	3
45801673	967823	0	0
45893946	1177480	0	0
45788316	1112807	0	0
45802376	1115008	0	0
46317796	1149196	0	0
46321925	1125315	0	0
4042140	4296204	5	8
4182007	80809	2	2
21002822	1115171	2	3
21502574	975125	0	0
21603931	42707627	6	7
21602796	1713671	5	6
36207527	40758406	1	3
40652433	3013721	2	2
44352196	1309944	0	0
44339416	1548195	0	0
44355556	1112807	0	0
44359771	1107882	2	3
45649529	1539403	0	0
43534659	1361711	1	1
45644561	1125315	0	0
45656846	1545958	0	0
45630017	1125315	0	0
45664155	1154029	0	0
45697322	1309944	0	0
45689542	723013	0	0
45690263	1125315	0	0
45683162	1125315	0	0
45781967	1119510	0	0
45688394	975125	0	0
45797531	1115171	2	3
45801157	1107882	2	3
45801674	1501700	0	0
45893841	1177480	0	0
45788480	1112807	0	0
45802130	1118084	0	0
46313399	701322	0	0
46321928	1125315	0	0
4042140	4001336	5	9
4042518	4010253	2	2
21503375	19008572	2	3
21502575	975125	0	0
21603931	40173590	6	7
21603444	40232448	5	6
36207527	40769184	1	3
40652433	3013682	2	2
44352199	1174888	0	0
44339505	1174888	0	0
44355715	1112807	0	0
44338659	1107882	2	3
45649534	1501700	0	0
45620188	19079524	1	1
45644576	1125315	0	0
45656933	1759842	0	0
45630447	1125315	0	0
45664187	1149196	0	0
45697659	1717327	0	0
45689546	1110410	0	0
45690272	1125315	0	0
45683336	1125315	0	0
45782078	1119510	0	0
45688482	1326303	0	0
45797544	40229134	2	3
45790241	19079524	2	3
45801675	1149196	0	0
45893953	1177480	0	0
45788448	1112807	0	0
45802448	1361711	0	0
46313320	1738521	0	0
46321930	1125315	0	0
4042140	4142905	5	9
4185207	4218389	2	2
21013458	40236446	2	3
21502575	1519936	0	0
21603931	19078461	6	7
35200000	321042	3	6
36217373	19129655	1	2
40652433	3019550	2	2
44352207	1738521	0	0
44339512	738818	0	0
44355421	975125	0	0
44360265	1107882	2	3
45649684	740275	0	0
45620254	46275916	1	1
45645870	1125315	0	0
45656945	914335	0	0
45630514	1125315	0	0
45664361	1539403	0	0
45697821	1153428	0	0
45689609	1308738	0	0
45690203	1125315	0	0
45683093	1125315	0	0
45781915	1119510	0	0
45688490	933724	0	0
45797547	1115171	2	3
45790262	1107882	2	3
45801676	1174888	0	0
45894123	1177480	0	0
45788607	1112807	0	0
45799653	1153428	0	0
46313365	1501700	0	0
46322157	1125315	0	0
4042140	4027663	5	7
4095850	4066995	2	2
21500561	40236446	2	3
21500286	1129625	0	0
21602359	43012433	6	7
21603444	19112599	3	6
36212546	19076374	1	2
40652433	3028833	2	2
44352336	1343916	0	0
44339476	1177480	0	0
44355232	1551099	0	0
44360842	19078461	2	3
45649626	708298	0	0
45620254	19079524	1	1
45646102	1125315	0	0
45656948	1149196	0	0
45630152	1125315	0	0
45664065	1759842	0	0
45697830	1115008	0	0
45689568	1115008	0	0
45690157	1125315	0	0
45682953	1125315	0	0
45782047	1119510	0	0
45688504	975125	0	0
45797550	19018935	2	3
46238604	1107882	2	3
45801699	1326303	0	0
45894149	1177480	0	0
45788410	1112807	0	0
45799865	1000560	0	0
46313441	1332418	0	0
46322486	1125315	0	0
4042140	78272	5	11
4095850	4048695	2	2
21001710	46275916	2	3
21500299	1343916	0	0
21602359	40224805	6	7
21603444	1150771	3	6
36211065	4142905	1	2
40652433	3009201	2	2
44352347	708298	0	0
44339611	1124957	0	0
44355247	1112807	0	0
44353707	1107882	2	3
45649746	1115008	0	0
45621677	19079524	1	1
45645929	1125315	0	0
45656949	1124300	0	0
45630215	1125315	0	0
45664065	1713332	0	0
45697605	1000560	0	0
45686233	1501700	0	0
45690159	1125315	0	0
45682954	1125315	0	0
45782050	1119510	0	0
45684561	1512674	0	0
45797538	19018935	2	3
45786027	1107882	2	3
45801704	1115008	0	0
45894673	1177480	0	0
45788621	1112807	0	0
45799828	1539403	0	0
46313457	1192710	0	0
46321995	1125315	0	0
4042140	4043241	8	11
4134595	4056621	2	2
21001967	40243436	2	3
21500286	738818	0	0
21602359	40224132	6	7
21603444	40228214	3	6
36224505	19029476	1	2
40652433	3024561	2	2
44355207	1322184	0	0
44339616	1308738	0	0
44355277	791967	0	0
44359828	1107882	2	3
45649709	1174888	0	0
45619836	19079524	1	1
45645933	1125315	0	0
45656951	791967	0	0
45630218	1125315	0	0
45664138	1332418	0	0
45697677	1549786	0	0
45686259	1110410	0	0
45686794	1125315	0	0
45682967	1125315	0	0
45782200	1119510	0	0
45684561	19127890	0	0
45797644	1154615	2	3
45895355	1107882	2	3
45801729	1124300	0	0
45798249	1129625	0	0
46301463	1112807	0	0
45799961	715997	0	0
46313277	1545958	0	0
46322062	1125315	0	0
4042140	372328	4	7
4185206	4066995	2	2
21004753	46275444	2	3
21500337	1174888	0	0
35202051	4283893	6	7
21603444	1150837	3	6
36218126	19075001	1	2
40652433	3019406	2	2
44355208	1129625	0	0
44339482	740275	0	0
44355296	1589505	0	0
44339049	1107882	2	3
45649610	1149196	0	0
45647246	19128009	2	2
45644728	1125315	0	0
45656868	1332418	0	0
45630323	1125315	0	0
45664236	1115008	0	0
45695935	1149196	0	0
45686262	1154343	0	0
45688736	1125315	0	0
45683370	1125315	0	0
45782011	1119510	0	0
45684561	1549786	0	0
45797458	40162522	2	3
45679221	1332419	2	3
45796005	1000560	0	0
45798529	1129625	0	0
46289697	1112807	0	0
45799936	708298	0	0
46313277	1332418	0	0
46322312	1125315	0	0
4042140	4066995	4	9
4185206	4048695	2	2
21004035	19078924	2	3
21500293	1129625	0	0
35202461	40481087	6	7
21603444	40228230	3	6
36211677	4066995	1	2
40652433	3001247	2	2
44355210	1343916	0	0
44339504	975125	0	0
44355240	738818	0	0
44360339	1107882	2	3
45649612	1124957	0	0
45649292	40174880	2	3
45644828	1125315	0	0
45657130	1000560	0	0
45631255	1125315	0	0
45660789	1332418	0	0
45695949	1326303	0	0
45686247	1343916	0	0
45688409	1125315	0	0
45683069	1125315	0	0
45779578	1119510	0	0
45684571	1107830	0	0
45797575	19129655	2	3
45792920	19079524	2	3
45796133	791967	0	0
45798601	1129625	0	0
46290057	1112807	0	0
45799942	738818	0	0
46313322	1112807	0	0
46322338	1125315	0	0
4042140	261325	4	9
4040539	4301346	2	2
21001876	40169216	2	3
21500294	1192710	0	0
35202461	28060	6	7
21602796	19133873	3	6
36223749	40163554	1	2
40652433	3023103	2	2
44355219	1778162	0	0
44339617	1177480	0	0
44355303	738818	0	0
44338430	1107882	2	3
45649821	1107830	0	0
45631756	19075601	2	3
45644837	1125315	0	0
45656876	1107830	0	0
45630959	1125315	0	0
45660791	975125	0	0
45695950	791967	0	0
45686246	1174888	0	0
45688411	1125315	0	0
45682925	1125315	0	0
45779649	1119510	0	0
45684673	1107830	0	0
45797727	40231925	2	3
45895544	1107882	2	3
45796006	1310149	0	0
45798334	1129625	0	0
46290313	1112807	0	0
600000004	740275	0	0
46313583	1595799	0	0
46322495	1125315	0	0
4042140	140673	4	6
4101796	4029498	2	2
21004841	1551192	2	3
21500320	1119510	0	0
35202461	255848	5	7
21602796	19074841	3	6
36223748	40163554	1	2
40652433	3008598	2	2
44355222	738818	0	0
44339623	738818	0	0
44355244	715997	0	0
44339167	1332419	2	3
45649879	742185	0	0
45631986	46275444	2	3
45644840	1125315	0	0
45657079	738818	0	0
45630531	1125315	0	0
45660740	975125	0	0
45695953	1521369	0	0
45686338	1343916	0	0
45688697	1125315	0	0
45679609	1125315	0	0
45779730	1119510	0	0
45684679	1000560	0	0
45797583	19008572	2	3
45795719	19075601	2	3
45796008	975125	0	0
45798582	1129625	0	0
46242240	1112807	0	0
600000005	723013	0	0
46313583	1549786	0	0
46322344	1125315	0	0
4042140	4218389	4	6
4040537	4295880	2	2
21002222	19129655	2	3
21500343	1129625	0	0
35202461	257012	4	7
21602796	19073188	3	6
36223456	1551192	1	2
40652433	3016723	2	2
44355431	1149380	0	0
44339632	1332418	0	0
44353383	1539403	0	0
44338561	1332419	2	3
45649635	742185	0	0
45631991	40162522	2	3
45644747	1125315	0	0
45656993	914335	0	0
45630542	1125315	0	0
45660747	738818	0	0
45695953	1549786	0	0
45686299	738818	0	0
45687043	1125315	0	0
45679827	1125315	0	0
45779736	1119510	0	0
45684767	1149196	0	0
45797584	1115171	2	3
45897905	19073188	2	3
45796009	1115008	0	0
45798719	1129625	0	0
46242325	1112807	0	0
600000005	791967	0	0
46313583	1521369	0	0
46322350	1125315	0	0
4042140	4051466	4	5
19102032	1519937	1	1
21002222	1713671	2	3
21500343	1119510	0	0
35205038	261325	4	7
21602796	19074843	3	6
36218152	40228230	1	2
40652433	3020655	2	2
44355458	1107830	0	0
44339646	1549786	0	0
44353447	738818	0	0
44345840	1332419	2	3
45649644	1115008	0	0
45632004	40162522	2	3
45644866	1125315	0	0
45656994	1115008	0	0
45630543	1125315	0	0
45660924	1149196	0	0
45696037	1107830	0	0
45686323	1595799	0	0
45687103	1125315	0	0
45682379	1125315	0	0
45779803	1119510	0	0
45684522	967823	0	0
45797587	1115171	2	3
45897905	19073183	2	3
45796012	1310149	0	0
45793285	1129625	0	0
46242027	1112807	0	0
46317571	975125	0	0
46313512	1107830	0	0
46316011	1125315	0	0
4042140	4280726	4	10
4311853	198199	1	1
21500785	19077344	2	3
21500343	738818	0	0
35200000	4310024	7	7
35202457	313217	4	6
36218125	19075001	1	2
40652433	3006734	2	2
44355406	738818	0	0
44339251	1545958	0	0
44353422	1112807	0	0
44360103	19075601	2	3
45649849	1501700	0	0
45632013	1127433	2	3
45641962	1125315	0	0
45656999	1501700	0	0
45630617	1125315	0	0
45660753	708298	0	0
45695966	975125	0	0
45686213	1521369	0	0
45687240	1125315	0	0
45682315	1125315	0	0
45779590	1119510	0	0
45684640	1501700	0	0
45797600	19077344	2	3
45787711	19078461	2	3
45796014	1521369	0	0
45793372	1129625	0	0
45893706	1112807	0	0
46318076	1307863	0	0
46313517	1192710	0	0
46316068	1125315	0	0
4042140	4285898	4	11
4235863	4066995	1	1
21004615	19129655	2	3
21500343	1192710	0	0
35200000	441267	7	7
35204989	313217	3	4
36224044	40232448	1	2
40652433	3020630	2	2
44355442	1153428	0	0
44339484	1174888	0	0
44345748	1343916	0	0
44362506	19078461	2	3
45649853	1595799	0	0
45632139	40165015	2	3
45641851	1125315	0	0
45657000	1107830	0	0
45630547	1125315	0	0
45660946	1192710	0	0
45696064	723013	0	0
45686213	1595799	0	0
45687116	1125315	0	0
45682736	42902245	1	2
45779705	1119510	0	0
45684647	1192710	0	0
45797851	40224805	2	3
46288566	1332419	2	3
45796224	975125	0	0
45793117	1129625	0	0
45893710	1112807	0	0
46318026	1551099	0	0
46313534	1124957	0	0
46316316	1125315	0	0
4117930	81893	9	10
4199590	4230399	1	1
21002475	19128263	1	1
21500324	1125443	0	0
35202456	321042	1	1
35202457	321042	3	4
36218398	19008572	1	2
36700000	4218389	4	4
44352441	1310149	0	0
44339445	1589505	0	0
44345322	1192710	0	0
44353747	19078461	2	3
45649888	1174888	0	0
45631874	19008572	2	3
45641816	1125315	0	0
45657002	1549786	0	0
45630553	1125315	0	0
45661023	1551099	0	0
45696076	1332418	0	0
45686213	1549786	0	0
45687120	1125315	0	0
45703952	40221415	3	4
45779782	1119510	0	0
45684648	1192710	0	0
45797699	19077344	2	3
46241441	1332419	2	3
45795943	967823	0	0
45793118	1129625	0	0
45893840	1112807	0	0
46318059	967823	0	0
46313695	701322	0	0
46316325	1125315	0	0
4156265	4156265	0	0
21000766	19029476	1	1
21002475	19128022	1	1
21500360	1119510	0	0
35202456	4324181	1	1
35204998	4329847	3	4
36224043	40232448	1	2
40772935	3035995	4	4
44352445	1738521	0	0
44339446	1548195	0	0
44345752	1129625	0	0
44345675	19079524	2	3
45649657	1549786	0	0
45632226	40232448	2	3
45621451	1125315	0	0
45657002	1521369	0	0
45630686	1125315	0	0
45661024	1115008	0	0
45696027	1149196	0	0
45686283	1501700	0	0
45687121	1125315	0	0
45700857	19127918	3	4
45779823	1119510	0	0
45684747	1174888	0	0
45794794	42707627	2	3
46243285	40173590	2	3
45796249	1343916	0	0
45793386	1129625	0	0
45893844	1112807	0	0
46318162	738818	0	0
46313469	1154029	0	0
46316379	1125315	0	0
4163872	4163872	0	0
19132303	19132304	1	1
21002475	19127918	1	1
21500360	1192710	0	0
35104382	4280726	1	1
21604255	40231925	3	4
36224173	40223768	1	2
40772935	3045716	4	4
44352466	920293	0	0
44339553	1112807	0	0
44345791	1112807	0	0
44355244	40223768	2	3
45649657	1589505	0	0
45632227	19008572	2	3
45621462	1125315	0	0
45657002	19127890	0	0
45630642	1125315	0	0
45660986	1110410	0	0
45695969	1738521	0	0
45686681	738818	0	0
45683950	1125315	0	0
45876033	3006906	2	2
45779533	1119510	0	0
45684798	1551099	0	0
45794853	19075601	2	3
45897781	1332419	2	3
45795992	914335	0	0
45794721	1129625	0	0
45893833	1112807	0	0
46318279	1154029	0	0
46313490	1124300	0	0
46316270	1125315	0	0
4163874	4163874	0	0
19133767	40162522	1	1
21002493	19127904	1	1
21500360	1125315	0	0
35104704	439777	1	1
21604255	35605858	3	4
36223969	40223768	1	2
40772935	3019550	4	4
44352516	1115008	0	0
44339558	738818	0	0
44345791	1177480	0	0
44360674	19075601	2	3
45649657	19127890	0	0
45634094	19019273	2	3
45621530	1125315	0	0
45657003	1521369	0	0
45630713	1125315	0	0
45660760	1115008	0	0
45695973	1361711	0	0
45686683	1149196	0	0
45684094	1125315	0	0
45876033	3000963	2	2
45779884	1119510	0	0
45684534	1332418	0	0
45797134	40231925	2	3
45895340	40223768	2	3
45796028	1115008	0	0
45794809	1129625	0	0
45801734	1112807	0	0
46318293	1124300	0	0
46313597	1112807	0	0
46310638	1125315	0	0
4146173	4146173	0	0
19133767	19133768	1	1
21002493	42902245	1	1
21013676	1000560	0	0
35104347	4280726	1	1
21604343	40229134	3	4
36218151	40228214	1	2
40772935	3004501	4	4
44352418	1738521	0	0
44339561	1112807	0	0
44345791	1129625	0	0
44339040	40228214	2	3
45649666	1308738	0	0
45634096	40232448	2	3
45621746	1125315	0	0
45657004	1549786	0	0
45630625	1125315	0	0
45660670	1343916	0	0
45696081	19039298	0	0
45686330	723013	0	0
45684127	1125315	0	0
45876033	3024561	2	2
45779920	1119510	0	0
45684751	1738521	0	0
45796916	40231925	2	3
45789298	40173590	2	3
45796031	967823	0	0
45794662	1129625	0	0
45801529	1112807	0	0
46317862	1521369	0	0
46313611	1124300	0	0
46311214	1125315	0	0
4134304	4134304	0	0
19133904	19133905	1	1
21002493	19128263	1	1
21013627	1551099	0	0
35508066	1332419	2	3
21604343	40162522	3	4
36218151	40228230	1	2
40772935	3015632	4	4
44352472	1129625	0	0
44339348	1332418	0	0
44345753	1545958	0	0
44338676	40228214	2	3
45649727	1107830	0	0
45634211	40232448	2	3
45621643	1125315	0	0
45657004	19127890	0	0
45627718	1125315	0	0
45660672	1192710	0	0
45692652	1149196	0	0
45686375	920293	0	0
45684180	1125315	0	0
45876033	3009201	2	2
45779838	1119510	0	0
45684653	1308738	0	0
45797184	40223768	2	3
46296446	19079524	2	3
45796238	1549786	0	0
45787864	1129625	0	0
45801638	1112807	0	0
46317862	1549786	0	0
46313547	975125	0	0
46310857	1125315	0	0
4116491	4116491	0	0
19133872	19133873	1	1
21002493	40221415	1	1
21013692	740275	0	0
35507962	1107882	2	3
21604343	40231925	3	4
36217723	1332419	1	2
40772935	3016723	4	4
44352551	1112807	0	0
44339361	1149380	0	0
44345725	1177480	0	0
44338973	40228214	2	3
45649735	1149196	0	0
45634216	19008572	2	3
45621537	1125315	0	0
45657004	1512674	0	0
45627722	1125315	0	0
45660675	1107830	0	0
45692940	1308738	0	0
45686376	1545958	0	0
45684201	1125315	0	0
45876033	3013682	2	2
45779932	1119510	0	0
45684756	1778162	0	0
45797188	40229134	2	3
45792981	1332419	2	3
45796238	1518198	0	0
45787886	1129625	0	0
45798990	1112807	0	0
46317866	975125	0	0
46313550	1112807	0	0
46311487	1125315	0	0
4117038	4117038	0	0
19083337	19045231	1	1
21002506	42902245	1	1
21002594	975125	0	0
35508059	1107882	2	3
21603396	40229134	3	4
36217722	1332419	1	2
40772935	3006906	4	4
44352434	1124300	0	0
44339437	1177480	0	0
44345675	967823	0	0
44338531	40228214	2	3
45649899	1548195	0	0
45628898	40163554	2	3
45621817	1125315	0	0
45656720	708298	0	0
45627731	1125315	0	0
45660661	1124957	0	0
45692915	738818	0	0
45686377	705944	0	0
45684020	1125315	0	0
45876033	3008598	2	2
45708117	1119510	0	0
45684800	1192710	0	0
45795013	40162522	2	3
46296765	1332419	2	3
45796259	715997	0	0
45788010	1129625	0	0
45799205	1112807	0	0
46318020	1118084	0	0
46313551	1539403	0	0
46311507	1125315	0	0
4107731	4107731	0	0
4312749	4198190	1	1
21002506	19128022	1	1
21002591	1717327	0	0
35507479	1107882	2	3
21603396	40162522	3	4
36207527	3051031	1	2
40772935	3006923	4	4
44352556	1713332	0	0
44339438	1174888	0	0
44345678	975125	0	0
44360319	19079524	2	3
45649901	708298	0	0
45629060	19076374	2	3
45621544	1125315	0	0
45657110	1174888	0	0
45627529	1125315	0	0
45660993	1115008	0	0
45692938	1174888	0	0
45686365	1192710	0	0
45684084	1125315	0	0
45876033	3016723	2	2
45705936	1119510	0	0
45684502	1153428	0	0
45794977	40231925	2	3
46288946	19075601	2	3
45796375	975125	0	0
45787983	1129625	0	0
45799360	1112807	0	0
46318139	738818	0	0
46313340	1307863	0	0
46310928	1125315	0	0
4108705	4108705	0	0
4313889	4010253	1	1
21002506	19128263	1	1
21002597	1778162	0	0
35508291	40223768	2	3
21601746	1332419	1	4
35909445	196456	1	1
40772935	3027970	4	4
44352606	19127890	0	0
44339439	723013	0	0
44345336	1332418	0	0
44353141	19078461	2	3
45649831	1153428	0	0
45629141	1115171	2	3
45667579	1125315	0	0
45657112	1396131	0	0
45627530	1125315	0	0
45661003	715997	0	0
45692940	1595799	0	0
45686401	1124957	0	0
45684213	1125315	0	0
45785087	19128009	2	2
45705852	1119510	0	0
45684614	1501700	0	0
45795075	40232448	2	3
46241519	19075601	2	3
45796262	1115008	0	0
45787960	1129625	0	0
45793881	1112807	0	0
46317775	914335	0	0
46313391	1112807	0	0
46310933	1125315	0	0
4109685	4109685	0	0
4054054	4146173	1	1
21002506	19127918	1	1
21002597	1759842	0	0
35508016	40223768	2	3
21604343	1127078	1	4
35909452	196456	1	1
40772948	3006451	4	4
44352606	1515774	0	0
44341206	1000560	0	0
44345337	708298	0	0
44359769	19078461	2	3
45649721	1153428	0	0
45629197	1127433	2	3
45667317	1125315	0	0
45657231	1115008	0	0
45627620	1125315	0	0
45660697	1115008	0	0
45693072	1322184	0	0
45686529	738818	0	0
45684217	1125315	0	0
45783005	19128022	2	2
45705785	1119510	0	0
45684850	1332418	0	0
45795048	19008572	2	3
46241257	19075601	2	3
45796055	1310149	0	0
45788037	1129625	0	0
45794098	1112807	0	0
46317781	738818	0	0
46313505	1713332	0	0
46310935	1125315	0	0
4048169	4048169	0	0
4196958	4163971	1	1
21003455	19127918	1	1
21002598	1728416	0	0
35507965	1545959	2	3
21603379	19029476	1	4
35707753	4166224	1	1
36900000	443279	4	4
44352606	1549786	0	0
44341481	1332418	0	0
44345436	1129625	0	0
44345725	19078461	2	3
45649931	1107830	0	0
45629214	1115171	2	3
45667481	1125315	0	0
45657271	738818	0	0
45627752	1125315	0	0
45660703	975125	0	0
45692818	933724	0	0
45686427	1192710	0	0
45684294	1125315	0	0
45777688	42902245	2	2
45705787	1119510	0	0
45684832	1521369	0	0
45795092	1115171	2	3
46243614	19075601	2	3
45796057	1115008	0	0
45787973	1129625	0	0
45794176	1112807	0	0
46317957	1154029	0	0
46313505	1759842	0	0
46310938	1125315	0	0
4048171	4048171	0	0
19081496	19078461	1	1
21506111	1332418	1	1
21002591	1738521	0	0
35509012	40223834	2	3
21602819	19073188	1	4
35707605	4285898	1	1
36400000	40480160	4	4
44352607	1124300	0	0
44341064	1545958	0	0
44345441	975125	0	0
44338553	19078461	2	3
45649940	1309944	0	0
45629192	40229134	2	3
45667484	1125315	0	0
45656889	1107830	0	0
45627699	1125315	0	0
45660704	1124300	0	0
45692702	1107830	0	0
45686429	1521369	0	0
45684029	1125315	0	0
46240251	19127918	2	2
45705893	1119510	0	0
45684837	1115008	0	0
45795095	19018935	2	3
45790519	1332419	2	3
45796058	1501700	0	0
45788203	1129625	0	0
45794121	1112807	0	0
46318249	1174888	0	0
46313655	1154343	0	0
46310942	1125315	0	0
4163951	4163951	0	0
4237320	4218408	1	1
21506123	967823	1	1
21002597	1728416	0	0
35507923	19019273	2	3
21602840	19133873	1	4
35707694	4266809	1	1
37520918	4163971	4	4
44352542	791967	0	0
44341017	1332418	0	0
44345632	1129625	0	0
44345832	19078461	2	3
45649695	1149196	0	0
45628961	19019273	2	3
45667487	1125315	0	0
45657044	1154029	0	0
45627702	1125315	0	0
45660989	1000560	0	0
45692632	975125	0	0
45686429	19127890	0	0
45684231	1125315	0	0
46240251	19128009	2	2
45705971	1119510	0	0
45684983	1322184	0	0
45792272	40236446	2	3
46288200	19075601	2	3
45796061	975125	0	0
45788283	1129625	0	0
45794055	1112807	0	0
46318014	1154343	0	0
46313621	1521369	0	0
46311085	1125315	0	0
4043071	4043071	0	0
4237321	4191853	1	1
21506140	1332418	1	1
21002587	1778162	0	0
35508372	19019273	2	3
21603057	920300	1	4
35707753	440448	1	1
37320089	4296204	4	4
44352523	1177480	0	0
44339679	1177480	0	0
44345793	1112807	0	0
44359823	1332419	2	3
45649698	1174888	0	0
45629092	1127433	2	3
45667405	1125315	0	0
45657047	1500211	0	0
45627771	1125315	0	0
45660951	1192710	0	0
45692774	1768849	0	0
45686429	1549786	0	0
45684317	1125315	0	0
45876038	3002385	2	2
45703751	1119510	0	0
45684986	1110410	0	0
45792274	920334	2	3
46243449	19075601	2	3
45796065	1332418	0	0
46294138	1129625	0	0
45794218	1112807	0	0
46318307	1332418	0	0
46313674	1343916	0	0
46311118	1125315	0	0
4191853	4191853	0	0
4237321	4078793	3	3
21506220	1115008	1	1
21002597	1768849	0	0
35508300	43012036	2	3
21603057	920334	1	4
36210621	3049273	1	1
36903632	378419	4	4
44352547	920293	0	0
44339762	1107830	0	0
44345794	933724	0	0
44360083	1545959	2	3
45649702	1595799	0	0
45628009	40232448	2	3
45667408	1125315	0	0
45657182	1110410	0	0
45627412	1125315	0	0
45660953	1501700	0	0
45692744	1309944	0	0
45686407	1192710	0	0
45684299	1125315	0	0
45876038	3009542	2	2
45702371	1119510	0	0
45684951	1307863	0	0
45792351	1115171	2	3
45897599	19075601	2	3
45796393	975125	0	0
46294143	1129625	0	0
45788733	1112807	0	0
46317705	1107830	0	0
46313936	975125	0	0
46311163	1125315	0	0
4112343	4112343	0	0
4237321	4062501	3	3
21506150	967823	1	1
21002601	1717327	0	0
35507862	43012036	2	3
21604269	40165015	1	4
36211076	40480160	1	1
36903632	440086	4	4
44352425	1309944	0	0
44339833	1124300	0	0
44345754	1129625	0	0
44353478	1332419	2	3
45649702	1308738	0	0
45626116	19008572	2	3
45665342	1125315	0	0
45657186	1549786	0	0
45627838	1125315	0	0
45660906	1759842	0	0
45692754	1115008	0	0
45686462	1110410	0	0
45684326	1125315	0	0
45876038	3026361	2	2
45702478	1119510	0	0
45684958	1738521	0	0
45792420	19077572	2	3
46292647	19075601	2	3
45796246	1545958	0	0
46293892	1129625	0	0
45789011	1112807	0	0
46318096	1192710	0	0
46313948	1557272	0	0
46311185	1125315	0	0
4027663	4027663	0	0
4042516	4170947	3	3
21503152	1129625	1	1
21002597	1741122	0	0
21602831	46275444	2	3
21601855	1539411	1	4
36211103	4059173	1	1
40792793	3009542	4	4
44352433	757627	0	0
44339692	1174888	0	0
44345766	975125	0	0
44345925	1332419	2	3
45649950	1107830	0	0
45626200	40229134	2	3
45665265	1125315	0	0
45657186	1521369	0	0
45627651	1125315	0	0
45660906	1713332	0	0
45692756	1115008	0	0
45686518	19127890	0	0
45684356	1125315	0	0
45876038	3024731	2	2
45702415	1119510	0	0
45684902	1149196	0	0
46244870	705944	0	0
46241636	19078461	2	3
45796189	1521369	0	0
46294057	1129625	0	0
46296760	1112807	0	0
46318106	914335	0	0
46313959	1124957	0	0
46311203	1125315	0	0
4163971	4163971	0	0
4275564	4336464	3	3
21503083	920293	1	1
21002600	1759842	0	0
21602754	40174880	2	3
21601855	1545959	1	4
36211136	4278672	1	1
40792793	3000963	4	4
44352595	740275	0	0
44339699	738818	0	0
44345769	1717327	0	0
44338624	1332419	2	3
45649978	1305058	0	0
45626130	19059056	2	3
45665405	1125315	0	0
45657097	1717327	0	0
45627680	1125315	0	0
45661041	738818	0	0
45693011	1307863	0	0
45686518	1589505	0	0
45684372	1125315	0	0
45876038	3007461	2	2
45699323	1119510	0	0
45684876	1501700	0	0
46244980	914335	0	0
45787865	19079524	2	3
45796189	19127890	0	0
46294239	1129625	0	0
46296893	1112807	0	0
46317720	1738521	0	0
46314014	1501700	0	0
46311094	1125315	0	0
4102123	4102123	0	0
4326426	4337138	3	3
21503144	914335	1	1
21002600	1746114	0	0
35507607	40223834	2	3
21602795	1741122	4	4
36211123	4048695	1	1
37502353	4293740	4	4
44352494	19127890	0	0
44339709	1361711	0	0
44348344	1501700	0	0
44353383	1539411	2	3
45646309	1115008	0	0
45626132	40231925	2	3
45665165	1125315	0	0
45656784	1124957	0	0
45627696	1125315	0	0
45660920	967823	0	0
45693014	1343916	0	0
45686518	1549786	0	0
45655185	46275916	1	1
45680892	40231925	2	3
45699342	1119510	0	0
45684730	1713332	0	0
46244990	708298	0	0
46243532	19075601	2	3
45796175	1174888	0	0
46293901	1129625	0	0
46295432	1112807	0	0
46317908	1332418	0	0
46314024	1549786	0	0
46311304	1125315	0	0
4186930	4186930	0	0
4195288	4202451	3	3
21503148	1154029	1	1
21002607	1746114	0	0
35507567	35605482	2	3
21602795	1778162	4	4
35708073	81893	1	1
37502353	4323208	4	4
44352494	1589505	0	0
44339729	1149380	0	0
44348248	1539403	0	0
44345954	1545959	2	3
45646251	920293	0	0
45626222	1115171	2	3
45665399	1125315	0	0
45653550	1124300	0	0
45624202	1125315	0	0
45661004	1149196	0	0
45692888	1332418	0	0
45686361	1174888	0	0
45701741	46275916	1	1
45680989	19077572	2	3
45699622	1119510	0	0
45684730	1759842	0	0
46291423	1521369	0	0
46241279	1539411	2	3
45796178	791967	0	0
46294209	1129625	0	0
46244575	1112807	0	0
46318195	1332418	0	0
46314024	19127890	0	0
46311239	1125315	0	0
4187458	4187458	0	0
4054054	40479422	3	3
21503149	1154029	1	1
21002600	1717327	0	0
35507572	1115171	2	3
21602795	1768849	4	4
35708038	81893	1	1
40792803	3010813	4	4
44352494	1549786	0	0
44339771	738818	0	0
44348087	975125	0	0
44345791	19078461	2	3
45646318	1115008	0	0
45626223	19008572	2	3
45665380	1125315	0	0
45653582	1332418	0	0
45624341	1125315	0	0
45661050	1713332	0	0
45692636	1545958	0	0
45686700	914335	0	0
45698370	19079524	1	1
45680995	19073183	2	3
45699623	1119510	0	0
45685030	1153428	0	0
46291423	1549786	0	0
46293132	40228214	2	3
45796271	933724	0	0
46294216	1129625	0	0
46244313	1112807	0	0
46318256	1738521	0	0
46314024	1589505	0	0
46311578	1125315	0	0
4155034	4155034	0	0
4054054	40479768	3	3
21503133	19003953	1	1
21002591	1759842	0	0
35507941	1154615	2	3
21602795	920293	4	4
35707843	30753	1	1
40792803	3026361	4	4
44352814	1177480	0	0
44339731	791967	0	0
44348037	738818	0	0
44345791	40232448	2	3
45646370	933724	0	0
45626210	40232448	2	3
45665162	1125315	0	0
45653375	1124957	0	0
45624608	1125315	0	0
45661051	723013	0	0
45692808	1539403	0	0
45686602	1521369	0	0
45695485	46275916	1	1
45681009	19019273	2	3
45699625	1119510	0	0
45685034	1738521	0	0
46291423	1595799	0	0
45803493	40228214	2	3
45796272	1115008	0	0
46294452	1129625	0	0
46244521	1112807	0	0
46318262	933724	0	0
46313969	1332418	0	0
46311594	1125315	0	0
4125906	4125906	0	0
4054054	81151	3	3
21502867	967823	1	1
21002607	1741122	0	0
35507482	19133905	2	3
21602795	1717327	4	4
36517129	4035415	1	1
40796128	3004501	4	4
44352503	1174888	0	0
44339667	1500211	0	0
44348284	1115008	0	0
44339374	1539411	2	3
45646375	1310149	0	0
45626345	43012036	2	3
45665242	1125315	0	0
45653463	1539403	0	0
45624616	1125315	0	0
45661053	975125	0	0
45692809	975125	0	0
45683170	738818	0	0
45695494	19127922	1	1
45681132	40228230	2	3
45699635	1119510	0	0
45681601	1149196	0	0
46291098	1107830	0	0
45786010	40228214	2	3
45796322	975125	0	0
46294579	1129625	0	0
46244547	1112807	0	0
46322396	975125	0	0
46314423	1192710	0	0
46305986	1125315	0	0
4041436	439777	4	6
4043197	4275113	3	3
21503152	738818	1	1
21002592	975125	0	0
35507780	1127433	2	3
21602795	1738521	4	4
36517132	4035415	1	1
37303790	134438	4	4
44352803	1545958	0	0
44339713	1149196	0	0
44348039	920293	0	0
44362717	19078461	2	3
45648856	1539403	0	0
45623153	40231925	2	3
45665368	1125315	0	0
45653411	1107830	0	0
45624620	1125315	0	0
45661076	975125	0	0
45692822	1149196	0	0
45683176	753626	0	0
45695494	19133679	1	1
45681098	920300	2	3
45699576	1119510	0	0
45681602	1174888	0	0
46291223	791967	0	0
45793032	19078461	2	3
45796189	1549786	0	0
46243884	1129625	0	0
45787640	738818	0	0
46322526	1153428	0	0
46313631	1332418	0	0
46322655	1125315	0	0
4179141	4134304	4	6
4184252	140673	3	3
21503197	975125	1	1
21002598	1778162	0	0
35508052	1551192	2	3
21602795	1713332	4	4
36211268	4149245	1	1
37303809	4156265	4	4
44352725	701322	0	0
44339719	1110410	0	0
44348190	1129625	0	0
44362814	19133873	2	3
45648993	1551099	0	0
45622890	1551192	2	3
45665371	1125315	0	0
45653432	1551099	0	0
45624413	1125315	0	0
45661089	1713332	0	0
45692827	705944	0	0
45683115	1738521	0	0
45695494	19129144	1	1
45681369	19059056	2	3
45699350	1119510	0	0
45681492	1557272	0	0
46291521	1174888	0	0
45785945	19078461	2	3
45796398	1713332	0	0
46243714	1129625	0	0
45787293	738818	0	0
46318366	1332418	0	0
46313739	1551099	0	0
46322091	1125315	0	0
4178545	4294548	4	6
4184252	4218389	3	3
21503197	1124300	1	1
21002602	1759842	0	0
35508143	40236824	2	3
21602795	1746114	4	4
36211224	4001336	1	1
37521802	4336464	4	4
44352705	1177480	0	0
44362941	1129625	0	0
44348420	1129625	0	0
44361890	19133905	2	3
45648999	1501700	0	0
45622891	1115171	2	3
45667429	1125315	0	0
45653438	1332418	0	0
45624448	1125315	0	0
45661044	1501700	0	0
45692983	740275	0	0
45683111	1343916	0	0
45695848	46275916	1	1
45675559	19019273	2	3
45699494	1119510	0	0
45682610	1551099	0	0
46291716	1728416	0	0
45787759	19079524	2	3
45796308	975125	0	0
46243936	1129625	0	0
45787777	738818	0	0
45794465	967823	0	0
46313763	1000560	0	0
46322095	1125315	0	0
4178818	4280726	4	6
4043671	4280726	3	3
21503152	1192710	1	1
21002602	1713332	0	0
35508084	1127433	2	3
21601907	1129625	4	4
36211402	4066995	1	1
40599742	4168004	4	4
44352453	738818	0	0
44363251	1129625	0	0
44348422	1107830	0	0
44361891	46275916	2	3
45649002	1326303	0	0
45623030	40174880	2	3
45667275	1125315	0	0
45653697	1107830	0	0
45624452	1125315	0	0
45660845	1110410	0	0
45692910	1521369	0	0
45683514	738818	0	0
45695601	19115351	1	1
45675988	19008572	2	3
45699672	1119510	0	0
45682613	1174888	0	0
46291102	1539403	0	0
46238671	40228214	2	3
45796385	1107830	0	0
46243943	1129625	0	0
45802515	738818	0	0
45794376	1115008	0	0
46313997	1107830	0	0
46322422	1125315	0	0
4178818	40486433	4	6
4043671	4294548	3	3
21503199	975125	1	1
21002597	1729720	0	0
35508091	35605482	2	3
21601907	1149380	4	4
35707759	4310024	1	1
40796010	3007461	4	4
44352727	1177480	0	0
44363368	1129625	0	0
44348315	1129625	0	0
44361900	19019273	2	3
45649175	1149196	0	0
45623247	1115171	2	3
45667308	1125315	0	0
45653674	1110410	0	0
45624453	1125315	0	0
45657969	1115008	0	0
45692910	1549786	0	0
45683129	705944	0	0
45692566	46275916	1	1
45675669	43012036	2	3
45696017	1119510	0	0
45682628	1549786	0	0
46291309	1545958	0	0
46238658	40228214	2	3
45796457	1361711	0	0
46243851	1129625	0	0
45801237	738818	0	0
45794483	738818	0	0
46313903	1310149	0	0
46322581	1125315	0	0
4180628	30753	4	6
4043671	40486433	3	3
21503205	1343916	1	1
21002621	1746114	0	0
35202055	4329847	2	3
21601907	975125	4	4
36211677	196456	1	1
40796010	3010813	4	4
44352639	738818	0	0
44363514	1129625	0	0
44348274	1129625	0	0
44361726	1127433	2	3
45649106	738818	0	0
45625063	40162522	2	3
45662787	1125315	0	0
45653678	1501700	0	0
45624457	1125315	0	0
45657978	1713332	0	0
45692992	738818	0	0
45683460	914335	0	0
45689277	46275916	1	1
45675902	19008572	2	3
45696115	1119510	0	0
45682628	1521369	0	0
46291317	1115008	0	0
45786056	19079524	2	3
45796468	1521369	0	0
46243854	1129625	0	0
45795841	738818	0	0
45794419	975125	0	0
46308405	1738521	0	0
46322608	1125315	0	0
4040391	4301346	4	6
4184974	4336464	3	3
21501229	967823	1	1
21002600	1778162	0	0
21602504	43012433	2	3
35202457	381316	4	4
36211088	4146173	1	1
37522205	4301346	4	4
44352753	1713332	0	0
44363159	1129625	0	0
44348277	708298	0	0
44361755	40163554	2	3
45649107	1107830	0	0
45625074	19078924	2	3
45662800	1125315	0	0
45653253	1115008	0	0
45624539	1125315	0	0
45657978	1759842	0	0
45693162	19127890	0	0
45683482	1713332	0	0
45689779	46275916	1	1
45676100	40231925	2	3
45696200	1119510	0	0
45682629	1174888	0	0
46291374	1112807	0	0
45786176	40228214	2	3
45796468	1549786	0	0
46244899	1129625	0	0
45790405	738818	0	0
45794503	1192710	0	0
46307885	1548195	0	0
46322611	1125315	0	0
4027403	4107731	4	6
4196016	4108705	3	3
21500615	1343916	1	1
21002617	1746114	0	0
35508579	19133905	2	3
35202457	4163874	4	4
36211091	4113008	1	1
36919120	4043241	4	4
44352756	1115008	0	0
44363592	1129625	0	0
44348279	1115008	0	0
44361767	19075001	2	3
45649187	791967	0	0
45624908	40229134	2	3
45662900	1125315	0	0
45653256	1549786	0	0
45624541	1125315	0	0
45657937	1107830	0	0
45693162	1512674	0	0
45683377	723013	0	0
45680864	46275916	1	1
45676101	1551192	2	3
45696218	1119510	0	0
45682632	975125	0	0
46291398	1000560	0	0
45895346	40228214	2	3
45796349	1115008	0	0
46244820	1129625	0	0
45790576	738818	0	0
45794393	920293	0	0
46308517	1713332	0	0
46316495	1125315	0	0
4027403	4275113	4	6
4198525	30753	3	3
21500155	1539403	1	1
21002615	1746114	0	0
35508262	40174880	2	3
21602359	933724	4	4
36211091	78272	1	1
36314523	4015189	4	4
44352761	1129625	0	0
44363595	1129625	0	0
44345805	1521369	0	0
44361851	43012036	2	3
45648857	1539403	0	0
45623318	19008572	2	3
45662923	1125315	0	0
45653256	1521369	0	0
45624867	1125315	0	0
45657993	1343916	0	0
45693162	1549786	0	0
45683246	1738521	0	0
45680904	46275916	1	1
45672791	40228214	2	3
45696221	1119510	0	0
45682673	1308738	0	0
46242704	920293	0	0
45787520	19078461	2	3
45796350	1192710	0	0
46244882	1129625	0	0
45790448	738818	0	0
45794396	1343916	0	0
46308568	1551099	0	0
46316744	1125315	0	0
4027403	4108705	4	6
4196708	380378	3	3
21500165	1501700	1	1
21002597	1746114	0	0
21603404	40229134	2	3
21602359	1521369	4	4
36207527	46235214	1	1
36903604	4043241	4	4
44352765	1308738	0	0
44363305	1129625	0	0
44345805	1549786	0	0
44361816	19133905	2	3
45649202	1361711	0	0
45623321	40169216	2	3
45662915	1125315	0	0
45653553	1539403	0	0
45624879	1125315	0	0
45657997	1149196	0	0
45693004	1551099	0	0
45683256	1310149	0	0
45676178	46275916	1	1
45672959	19019273	2	3
45696145	1119510	0	0
45682579	1174888	0	0
46242711	1343916	0	0
45895161	40223768	2	3
45796310	1174888	0	0
46243984	1129625	0	0
45790586	738818	0	0
45794397	1115008	0	0
46308194	1501700	0	0
46318008	1125315	0	0
4028071	321042	4	6
4185643	4237458	3	3
21500201	1326303	1	1
21002602	1746114	0	0
21602473	19127904	3	3
21602359	1589505	4	4
36207527	3011505	1	1
40796118	3008598	4	4
44352712	1713332	0	0
44358707	1129625	0	0
44345815	1110410	0	0
44361963	19019273	2	3
45648859	1326303	0	0
45621487	1127433	2	3
45662961	1125315	0	0
45653826	738818	0	0
45624985	1125315	0	0
45657950	1110410	0	0
45692896	1115008	0	0
45683257	1322184	0	0
45676210	19079524	1	1
45672914	19057271	2	3
45696256	1119510	0	0
45682585	1115008	0	0
46242675	1713332	0	0
46297179	1332419	2	3
45796311	1361711	0	0
46238900	1129625	0	0
45790701	738818	0	0
45794399	1174888	0	0
46308574	975125	0	0
46318012	1125315	0	0
4028071	317576	4	6
4182210	4043241	3	3
21506220	1124300	1	1
21002602	1778162	0	0
21602473	19128022	3	3
21602359	1549786	4	4
36211303	4156265	6	6
37522205	44783196	3	4
44352712	1759842	0	0
44356261	1129625	0	0
44345817	1129625	0	0
44361883	40236446	2	3
45646490	1149380	0	0
45621508	19008572	2	3
45662836	1125315	0	0
45653831	1124957	0	0
45624784	1125315	0	0
45658048	1192710	0	0
45692897	1149196	0	0
45683259	1124957	0	0
45671713	19079524	1	1
45673051	40229134	2	3
45696158	1119510	0	0
45682590	1154343	0	0
46242675	1759842	0	0
46238511	40223768	2	3
45796312	967823	0	0
46238903	1129625	0	0
45790860	738818	0	0
45794403	738818	0	0
46308577	1589505	0	0
46317192	1125315	0	0
4047779	4035415	4	6
4276675	4314290	3	3
21506220	1177480	1	1
21002615	1717327	0	0
21602473	42902245	3	3
21603931	1124300	4	4
36516993	133834	6	6
40254301	40221415	3	4
44352616	1149380	0	0
44356306	1129625	0	0
44345885	1177480	0	0
44362168	1115171	2	3
45646491	738818	0	0
45621738	43012036	2	3
45662969	1125315	0	0
45653490	1110410	0	0
45624789	1125315	0	0
45657716	1326303	0	0
45693033	738818	0	0
45683261	914335	0	0
45670219	19079524	1	1
45673222	1594382	2	3
45696485	1119510	0	0
45682622	1149196	0	0
46242684	723013	0	0
45801164	40223768	2	3
45796426	740275	0	0
46238965	1129625	0	0
46297191	738818	0	0
45794344	1322184	0	0
46308585	1738521	0	0
46317882	1125315	0	0
4047779	380378	4	6
4043671	4112343	3	4
21500620	19002770	1	1
21002615	1778162	0	0
21602473	19128263	3	3
21603931	19003953	4	4
36416692	4144583	6	6
37320108	4296204	3	4
44352618	740275	0	0
44349379	1129625	0	0
44345865	1000560	0	0
44362064	40229134	2	3
45646498	782043	0	0
45621849	40228230	2	3
45662617	1125315	0	0
45653652	1149196	0	0
45624536	1125315	0	0
45657718	1192710	0	0
45693034	975125	0	0
45683270	1000560	0	0
45783746	19127922	1	1
45673176	43012036	2	3
45696244	1119510	0	0
45682648	1115008	0	0
46242582	1738521	0	0
45897512	19078461	2	3
45796433	1521369	0	0
46238897	1129625	0	0
46297601	738818	0	0
45794459	1124957	0	0
46308732	1112807	0	0
46317631	1125315	0	0
4047779	4156265	4	6
4182536	4108705	3	4
21500620	19039298	1	1
21002601	1746114	0	0
21602473	19128009	3	3
36217214	19128065	3	4
36416680	4144583	6	6
37522270	4337138	3	4
44352619	1310149	0	0
44349610	1129625	0	0
44345839	1192710	0	0
45655829	40223834	2	3
45646499	920293	0	0
45665355	40232448	2	3
45662850	1125315	0	0
45653402	1545958	0	0
45624843	1125315	0	0
45657719	1124957	0	0
45693168	1322184	0	0
45683145	1192710	0	0
45783746	19129144	1	1
45673307	19078461	2	3
45696327	1119510	0	0
45681719	1149196	0	0
46242679	1746114	0	0
46243815	19078461	2	3
45796279	1000560	0	0
46238898	1129625	0	0
46297565	738818	0	0
45794491	1539403	0	0
46308738	1595799	0	0
46317660	1125315	0	0
4028071	4329847	4	7
4300157	4142905	3	4
21500620	782043	1	1
21002599	1717327	0	0
21602473	19127918	3	3
36217214	19128263	3	4
36211315	78272	6	6
36900000	378419	2	6
44352736	1717327	0	0
44349738	1129625	0	0
44345832	1177480	0	0
45655954	19008572	2	3
45646472	1713332	0	0
45667354	19019273	2	3
45662863	1125315	0	0
45653466	1738521	0	0
45668794	1125315	0	0
45658060	708298	0	0
45693046	1713332	0	0
45683147	1107830	0	0
45783746	19133679	1	1
45785005	43012036	2	3
45696610	1119510	0	0
45681678	1192710	0	0
46242679	1741122	0	0
45800902	19078461	2	3
45796434	708298	0	0
46238989	1129625	0	0
46289024	738818	0	0
46312365	1326303	0	0
46308739	975125	0	0
46317538	1125315	0	0
4180628	4294548	4	7
4300157	4237458	3	4
21002499	19127918	1	1
21002616	1746114	0	0
21601765	40171902	3	3
36217214	19127918	3	4
35802848	81893	6	6
36603422	81151	3	6
44352742	701322	0	0
44349708	1129625	0	0
44345840	1332418	0	0
45656051	19076374	2	3
45646528	738818	0	0
45667314	19008572	2	3
45662975	1125315	0	0
45653787	1149196	0	0
45668704	1125315	0	0
45658053	1521369	0	0
45693189	738818	0	0
45683477	1153428	0	0
45707981	40220386	1	1
45784872	19019273	2	3
45696423	1119510	0	0
45681679	19039298	0	0
46242769	1192710	0	0
46243529	19078461	2	3
45796305	1149196	0	0
46238990	1129625	0	0
46289221	738818	0	0
46312378	1124957	0	0
46308764	914335	0	0
46316790	1125315	0	0
4178545	4112343	4	7
4043371	4112343	3	4
21502653	933724	1	1
21002616	1717327	0	0
21602471	19054876	3	3
36217214	19127904	3	4
36517012	78272	6	6
37103722	195588	3	6
44352742	715997	0	0
44349660	1129625	0	0
44345870	920293	0	0
45655965	19008572	2	3
45646537	1515774	0	0
45662805	19018935	2	3
45664555	1125315	0	0
45653468	1713332	0	0
45668978	1125315	0	0
45658053	1595799	0	0
45693104	738818	0	0
45683237	1332418	0	0
45708007	46275916	1	1
45784861	43012036	2	3
45696433	1119510	0	0
45681705	1115008	0	0
46242771	975125	0	0
45798278	19078461	2	3
45796398	1759842	0	0
46238991	1129625	0	0
46289774	738818	0	0
46312108	1192710	0	0
46308782	705944	0	0
46316841	1125315	0	0
4027403	40492359	4	8
4040563	4198190	3	4
21002491	19128022	1	1
21002600	1713332	0	0
21602471	1589505	3	3
36217214	19129144	3	4
36517140	78272	6	6
36702247	4066995	3	6
44352744	1153428	0	0
44349861	1129625	0	0
44345871	1124300	0	0
45656032	19018935	2	3
45646537	1549786	0	0
45662461	40232448	2	3
45664560	1125315	0	0
45653668	1548195	0	0
45668551	1125315	0	0
45658053	1549786	0	0
45692859	1174888	0	0
45683539	1124300	0	0
45708317	19079524	1	1
45785016	40229134	2	3
45696438	1119510	0	0
45681708	1521369	0	0
46242652	1545958	0	0
46293377	19078461	2	3
45796399	1154029	0	0
46239014	1129625	0	0
46241646	738818	0	0
46312314	1174888	0	0
46308468	1118084	0	0
46316852	1125315	0	0
4027384	134438	4	4
4279903	4323902	3	4
21002491	19128263	1	1
21505734	967823	0	0
21602471	1521369	3	3
36217214	40221415	3	4
36502198	4134304	5	6
37320122	4296204	3	6
44352483	1115008	0	0
44341796	1129625	0	0
44345875	1129625	0	0
45656069	1127433	2	3
45646546	708298	0	0
45662608	19074843	2	3
45663001	1125315	0	0
45653812	1153428	0	0
45668944	1125315	0	0
45658081	738818	0	0
45693184	1332418	0	0
45683543	1738521	0	0
45705314	46275916	1	1
45785161	40229134	2	3
45692966	1119510	0	0
45681708	1595799	0	0
46242883	975125	0	0
46238387	19078461	2	3
45790722	1174888	0	0
46239234	1129625	0	0
46241725	738818	0	0
46312110	1115008	0	0
46308596	975125	0	0
46316940	1125315	0	0
4071948	4330583	4	4
19054876	40221415	3	4
21002491	19127918	1	1
21505776	1192710	0	0
21602471	1500211	3	3
36217214	40165015	2	3
36502196	4066995	5	6
36900000	440086	4	6
44352486	1192710	0	0
44341849	1129625	0	0
44345880	1110410	0	0
45656349	1551192	2	3
45646461	1107830	0	0
45664560	1127433	2	3
45663102	1125315	0	0
45653821	1551099	0	0
45668958	1125315	0	0
45658082	1149196	0	0
45693186	1539403	0	0
45683382	1539403	0	0
45705701	46275916	1	1
45785244	1115171	2	3
45694729	1119510	0	0
45681708	1549786	0	0
46242888	1174888	0	0
45795494	19078461	2	3
45790725	1192710	0	0
46239414	1129625	0	0
46241735	738818	0	0
46312129	975125	0	0
46308616	1741122	0	0
46311630	1125315	0	0
4047779	81151	4	9
4311041	4336464	3	4
21002491	42902245	1	1
21505823	1192710	0	0
21602471	1548195	3	3
36217214	19077572	2	3
36502199	4149245	5	6
37002287	198199	4	6
44352766	1539403	0	0
44342045	1129625	0	0
44345881	1124300	0	0
45656155	40232448	2	3
45646467	738818	0	0
45659632	19019273	2	3
45663016	1125315	0	0
45653836	1154343	0	0
45668963	1125315	0	0
45658164	1551099	0	0
45692980	975125	0	0
45683247	1153428	0	0
45702012	46275916	1	1
45784843	40229134	2	3
45693313	1119510	0	0
45681682	1154029	0	0
46242696	1107830	0	0
46243764	19078461	2	3
45790766	1549786	0	0
46239426	1129625	0	0
46241765	738818	0	0
46312131	1501700	0	0
46308616	1746114	0	0
46306374	1125315	0	0
4047779	4142905	4	8
4042504	44783196	3	5
21002491	19128009	1	1
21505819	1125315	0	0
21602471	1512674	3	3
36217214	920334	2	3
36211303	4109685	5	6
37002287	4056621	4	6
44352576	1124300	0	0
44341920	1129625	0	0
44345891	738818	0	0
45656270	1115171	2	3
45646633	708298	0	0
45659613	40232448	2	3
45663034	1125315	0	0
45653479	1310149	0	0
45668728	1125315	0	0
45657743	1778162	0	0
45693048	1124300	0	0
45683254	1149196	0	0
45699313	46275916	1	1
45785077	1545959	2	3
45693563	1119510	0	0
45681756	1738521	0	0
46242821	1778162	0	0
46293245	19078461	2	3
45790766	19127890	0	0
45894433	1129625	0	0
46242612	738818	0	0
46312329	738818	0	0
46308617	1192710	0	0
46306501	1125315	0	0
4047779	44782520	4	5
4042505	4278672	3	5
21601120	964261	3	4
21505820	1192710	0	0
21602471	1549786	3	3
36217214	40162522	2	3
36211303	4132546	4	6
36403239	439777	4	6
42802580	1729720	0	0
44341921	1129625	0	0
44345897	1118084	0	0
45656406	40232448	2	3
45646561	1107830	0	0
45659624	40232448	2	3
45663210	1125315	0	0
45653608	967823	0	0
45668880	1125315	0	0
45658140	1545958	0	0
45693053	1310149	0	0
45683385	1332418	0	0
45699329	46275916	1	1
45785202	19133768	2	3
45693498	1119510	0	0
45681757	1713332	0	0
46242823	1124957	0	0
45895395	19078461	2	3
45790766	1521369	0	0
45801503	1129625	0	0
46241811	738818	0	0
46312246	1000560	0	0
46308660	1174888	0	0
46306183	1125315	0	0
4067285	4198190	4	5
4042505	4048695	3	5
21502709	1154615	3	4
21505820	1112807	0	0
21602471	1519936	3	3
36217214	40228230	2	3
36516972	4237458	4	6
37200000	321042	6	6
42802779	1343916	0	0
44341869	1129625	0	0
44345912	1112807	0	0
45656409	40232448	2	3
45646571	1124300	0	0
45659814	19125062	2	3
45659569	1125315	0	0
45653711	1124957	0	0
45668882	1125315	0	0
45658066	1557272	0	0
45693064	1115008	0	0
45683497	705944	0	0
45692950	46275916	1	1
45784942	1115171	2	3
45690305	1119510	0	0
45681711	1308738	0	0
46242834	1112807	0	0
46292965	19078461	2	3
45790930	1115008	0	0
45801409	1129625	0	0
46241824	738818	0	0
46312444	1174888	0	0
46308670	1192710	0	0
46306186	1125315	0	0
4040392	4186930	4	5
4042505	40480160	3	5
21503530	19075601	3	4
21505821	1177480	0	0
21601387	1305058	3	3
36217214	1127078	2	3
36516972	4142905	4	6
37502354	4108705	6	6
42802781	1713332	0	0
44341876	1129625	0	0
44345914	1149380	0	0
45656216	43012036	2	3
45646644	933724	0	0
45659769	40162522	2	3
45659794	1125315	0	0
45653504	1154029	0	0
45666462	1125315	0	0
45658069	975125	0	0
45693065	19039298	0	0
45683492	1545958	0	0
45707153	1115008	0	0
45785068	19008572	2	3
45690402	1119510	0	0
45681724	1545958	0	0
46242872	1192710	0	0
45793053	19078461	2	3
45790931	1501700	0	0
45801482	1129625	0	0
45897971	738818	0	0
46312224	723013	0	0
46308673	1738521	0	0
46306073	1125315	0	0
4040391	44783196	4	5
4182165	4066995	3	5
21503530	19059056	3	4
21505821	1192710	0	0
21604685	701322	3	3
36217214	19007333	2	3
36600000	4285898	4	6
36702253	4029498	6	6
42802783	1124300	0	0
44342087	1129625	0	0
44345923	1137529	0	0
45652708	920334	2	3
45646647	1124300	0	0
45660048	1115171	2	3
45659628	1125315	0	0
45653713	1332418	0	0
45666516	1125315	0	0
45658070	1102527	0	0
45693193	715997	0	0
45683504	1115008	0	0
45707060	1367571	0	0
45786482	40229134	2	3
45690554	1119510	0	0
45681747	1557272	0	0
46242876	1124957	0	0
46243589	19078461	2	3
45790939	1107830	0	0
45801574	1129625	0	0
45895806	738818	0	0
46312322	791967	0	0
46308630	740275	0	0
46306516	1125315	0	0
4028071	4310024	4	5
4182165	4048695	3	5
21501229	19079524	3	4
21505823	1129625	0	0
21604685	715997	3	3
35802845	4285898	4	7
35707763	30753	3	6
40792793	3024731	6	6
42802795	723013	0	0
44342137	1129625	0	0
44345923	1149380	0	0
45652625	19075001	2	3
45646650	1361711	0	0
45659927	40232448	2	3
45659534	1125315	0	0
45653515	1557272	0	0
45666497	1125315	0	0
45657877	1000560	0	0
45689835	1149196	0	0
45685286	723013	0	0
45707032	1000560	0	0
45786594	19018935	2	3
45690609	1119510	0	0
45681732	1102527	0	0
46243040	967823	0	0
46238574	19078461	2	3
45790775	791967	0	0
45801695	1129625	0	0
45895861	738818	0	0
46312675	1332418	0	0
46308486	1149196	0	0
46306592	1125315	0	0
4155793	4047491	4	5
4215793	4275113	3	5
21500563	45892894	3	4
21505735	967823	0	0
21604685	705944	3	3
35800000	378419	9	10
36208978	3049273	3	7
40779591	3001488	6	6
42802796	1124300	0	0
44363811	1129625	0	0
44345954	1545958	0	0
45652664	1127433	2	3
45646576	1124957	0	0
45656695	40229134	2	3
45659490	1125315	0	0
45653629	1115008	0	0
45666487	1125315	0	0
45658230	1310149	0	0
45689837	1124957	0	0
45685403	1149196	0	0
45707286	1107830	0	0
45786250	40229134	2	3
45690343	1119510	0	0
45681700	1589505	0	0
46242794	1713332	0	0
46288274	1545959	2	3
45791009	975125	0	0
45801650	1129625	0	0
45896009	738818	0	0
46312581	701322	0	0
46308490	705944	0	0
46306298	1125315	0	0
4155793	42535580	4	5
4054054	4134304	3	5
21503474	19077344	3	4
21505915	1119510	0	0
21601853	1545958	3	3
35800000	28060	8	9
36211303	4001336	4	7
36703532	380378	6	6
42802582	1738521	0	0
44363929	1129625	0	0
44345958	1129625	0	0
45655047	1115171	2	3
45646579	782043	0	0
45656794	19008572	2	3
45659701	1125315	0	0
45653727	1124957	0	0
45666548	1125315	0	0
45658173	1728416	0	0
45690017	1717327	0	0
45685232	1124957	0	0
45707254	1107830	0	0
45782906	19019979	2	3
45690387	1119510	0	0
45681702	1107830	0	0
46242801	1738521	0	0
46238467	19078461	2	3
45790801	715997	0	0
45795962	1129625	0	0
45896116	738818	0	0
46312591	1153428	0	0
46308714	1192710	0	0
46306244	1125315	0	0
4178818	28060	4	5
4042516	4301346	3	7
21503133	42707627	3	4
21505915	1192710	0	0
21601853	1539403	3	3
35800000	4001336	8	10
36502199	4059173	7	7
40796132	3026361	6	6
42803038	1322184	0	0
44363573	1129625	0	0
44345959	1115008	0	0
45655059	1115171	2	3
45646678	1153428	0	0
45656899	19133768	2	3
45659553	1125315	0	0
45653733	1310149	0	0
45666595	1125315	0	0
45658183	975125	0	0
45690018	1115008	0	0
45685243	1174888	0	0
45707108	1124957	0	0
45783017	40229134	2	3
45690492	1119510	0	0
45681794	1115008	0	0
46242983	1778162	0	0
46293150	1545959	2	3
45790741	1307863	0	0
45796169	1129625	0	0
45896167	738818	0	0
46312423	1149196	0	0
46308702	1192710	0	0
46306991	1125315	0	0
4178818	81893	4	5
4042516	44783196	3	6
21500201	19018935	3	4
21505921	1125315	0	0
21603932	1177480	3	3
35800000	81893	8	8
36502199	4066995	7	7
40796132	3010813	6	6
42802638	1501700	0	0
44363634	1129625	0	0
44345940	1192710	0	0
45655170	40229134	2	3
45646694	967823	0	0
45656753	40174880	2	3
45659557	1125315	0	0
45653636	708298	0	0
45666670	1125315	0	0
45658153	1115008	0	0
45689833	1539403	0	0
45685245	1545958	0	0
45707049	1107830	0	0
45782891	40162522	2	3
45690559	1119510	0	0
45681820	1551099	0	0
46242985	975125	0	0
45897993	1539411	2	3
45790876	1738521	0	0
45796378	1129625	0	0
45804104	738818	0	0
46312752	1729720	0	0
46308641	1149196	0	0
46306993	1125315	0	0
4041285	4056621	4	5
4213101	4048695	4	6
21500746	19079524	3	4
21505922	1192710	0	0
21603932	1124300	3	3
35800000	380378	8	8
36502199	4048695	7	7
36702242	4001336	6	6
42802725	1115008	0	0
44363639	1129625	0	0
44345940	1112807	0	0
45655327	40163554	2	3
45646433	1107830	0	0
45656762	1107882	2	3
45659853	1125315	0	0
45653525	1154029	0	0
45666729	1125315	0	0
45657891	967823	0	0
45689785	1521369	0	0
45685488	1107830	0	0
45707343	1501700	0	0
45782999	40229134	2	3
45690578	1119510	0	0
45681834	1738521	0	0
46242971	1326303	0	0
45792947	1332419	2	3
45790806	1713332	0	0
45796257	1129625	0	0
45804212	738818	0	0
46312327	1332418	0	0
46308647	975125	0	0
46306468	1125315	0	0
4103352	4294548	4	5
4275431	4057420	4	6
21503152	40232448	3	4
21505922	1174888	0	0
21603444	1153428	3	3
35800000	372328	8	8
36502199	4278672	7	7
37320108	133834	4	5
42802728	975125	0	0
44363736	1129625	0	0
44345969	19003953	0	0
45655445	19008572	2	3
45646606	1174888	0	0
45656943	43012036	2	3
45659855	1125315	0	0
45653745	738818	0	0
45666756	1125315	0	0
45658316	975125	0	0
45689785	1549786	0	0
45685493	1501700	0	0
45707427	1149196	0	0
45782992	1115171	2	3
45690515	1119510	0	0
45681862	1192710	0	0
46243068	1332418	0	0
46243331	1332419	2	3
45790827	1545958	0	0
45796212	1129625	0	0
45804189	738818	0	0
46312831	1192710	0	0
46308682	1545958	0	0
46306739	1125315	0	0
4103662	4001336	4	5
4042516	4058899	4	6
21503152	43012036	3	4
21505930	1177480	0	0
21603444	1192710	3	3
35800000	381316	8	8
36502199	81151	5	7
37520918	4198190	4	5
42803074	1713332	0	0
44363768	1129625	0	0
44341262	1177480	0	0
45655180	40232448	2	3
45646610	1332418	0	0
45656868	1332419	2	3
45659957	1125315	0	0
45653755	1713332	0	0
45666712	1125315	0	0
45658322	1153428	0	0
45689785	19127890	0	0
45685484	1154343	0	0
45707349	1545958	0	0
45783194	40232448	2	3
45690534	1119510	0	0
45681866	1115008	0	0
46242924	1112807	0	0
46296933	1332419	2	3
45790828	1174888	0	0
45796268	1129625	0	0
45799006	738818	0	0
46312780	1118084	0	0
46312351	1501700	0	0
46306230	1125315	0	0
4043022	4216130	4	5
4042504	4301346	4	6
21503152	19112599	3	4
21505930	1308738	0	0
21603444	1150836	3	3
35800000	4294548	8	11
36502199	40480160	5	7
37521809	4336464	4	5
42803074	1759842	0	0
44363769	1129625	0	0
44341385	1332418	0	0
45655183	40228214	2	3
45646620	1332418	0	0
45657034	1127433	2	3
45659769	1125315	0	0
45653755	1759842	0	0
45666867	1125315	0	0
45657903	1174888	0	0
45689786	1174888	0	0
45685441	933724	0	0
45707444	1149196	0	0
45783111	40229134	2	3
45687472	1119510	0	0
45681880	1000560	0	0
46242929	1110410	0	0
45897921	1332419	2	3
45790942	1551099	0	0
45796467	1129625	0	0
45799038	738818	0	0
46306913	1343916	0	0
46312352	1361711	0	0
46306606	1125315	0	0
4027403	4197460	4	5
4299602	4198190	4	5
21503083	920300	3	4
21505970	1154343	0	0
21603444	738818	3	3
35800000	4112343	8	11
36211303	4146173	5	7
36313967	4024958	4	5
42802914	1124957	0	0
44363986	1129625	0	0
44341010	1545958	0	0
45652824	40231925	2	3
45646718	1343916	0	0
45657079	40229134	2	3
45659779	1125315	0	0
45653761	1545958	0	0
45666972	1125315	0	0
45657923	1595799	0	0
45689896	1124300	0	0
45685599	1308738	0	0
45706869	1115008	0	0
45783458	40162522	2	3
45687562	1119510	0	0
45678508	1149196	0	0
46242931	1310149	0	0
46241650	1332419	2	3
45790945	1551099	0	0
45796430	1129625	0	0
45793548	738818	0	0
46306919	1343916	0	0
46312354	1124300	0	0
46317223	1125315	0	0
4027403	4337138	4	5
4040561	4198190	4	5
21503083	920334	3	4
21505971	1137529	0	0
21602722	975125	3	3
35800000	4156265	7	9
36211303	4278672	5	7
36903633	4043241	4	5
42803062	1759842	0	0
44356506	1129625	0	0
44341221	1129625	0	0
45652840	1127433	2	3
45646726	757627	0	0
45656994	19019273	2	3
45660042	1125315	0	0
45650086	1501700	0	0
45664267	1125315	0	0
45657923	1308738	0	0
45690026	1367571	0	0
45685609	705944	0	0
45706504	967823	0	0
45783077	1115171	2	3
45687280	1119510	0	0
45678608	1361711	0	0
46243069	1174888	0	0
46238639	40174880	2	3
45790890	914335	0	0
45790773	1129625	0	0
45793672	738818	0	0
46306960	1118084	0	0
46312357	1361711	0	0
46317310	1125315	0	0
4042836	40486433	4	5
4042505	4142905	4	5
21500620	19023398	3	4
21505972	1549786	0	0
21604181	19059528	3	3
35800000	4283893	7	9
36211303	4152936	5	7
36703532	44782520	4	5
42803062	1713332	0	0
44356509	1129625	0	0
44341222	1192710	0	0
45649544	19008572	2	3
45646704	1149380	0	0
45657112	19077344	2	3
45659799	1125315	0	0
45650101	967823	0	0
45664393	1125315	0	0
45658329	1192710	0	0
45690021	1149196	0	0
45680106	1343916	0	0
45706779	1713332	0	0
45783141	40229134	2	3
45687534	1119510	0	0
45678623	920293	0	0
46243071	1118084	0	0
46243349	1332419	2	3
45790897	723013	0	0
45790893	1129625	0	0
45793804	738818	0	0
46307029	1343916	0	0
46312428	1112807	0	0
46317460	1125315	0	0
4042836	4280726	4	5
4197094	4285898	4	5
21500620	782047	3	4
21505972	1548195	0	0
21604181	19002770	3	3
35800000	4218389	6	7
36211303	4059173	5	7
37103722	4056621	4	5
42802734	1778162	0	0
44356718	1129625	0	0
44341183	1713332	0	0
45649747	19059056	2	3
45646688	1115008	0	0
45657205	19008572	2	3
45659935	1125315	0	0
45650314	738818	0	0
45664537	1125315	0	0
45654634	1332418	0	0
45689876	1174888	0	0
45680224	1308738	0	0
45706754	1539403	0	0
45783140	40232448	2	3
45687453	1119510	0	0
45678712	1118084	0	0
46243041	1322184	0	0
46238551	1332419	2	3
45790952	1115008	0	0
45792013	1129625	0	0
45793666	738818	0	0
46307106	1589505	0	0
46311947	1551099	0	0
45876037	3035995	3	5
4042836	4294548	4	5
4247371	4156265	4	5
21500165	40174880	3	4
21505972	1512674	0	0
21603512	1150771	0	3
35800000	4084167	6	7
36502197	4146173	6	7
37522191	4108705	3	5
42802869	1738521	0	0
44356720	1129625	0	0
44341183	1759842	0	0
45649746	19019273	2	3
45646735	1549786	0	0
45653552	1127433	2	3
45656923	1125315	0	0
45650381	1717327	0	0
45664414	1125315	0	0
45654641	1107830	0	0
45689895	1115008	0	0
45680168	1154343	0	0
45706806	1738521	0	0
45783206	19133905	2	3
45687649	1119510	0	0
45678489	967823	0	0
46242812	1115008	0	0
45897837	1332419	2	3
45791002	1549786	0	0
45791189	1129625	0	0
45788176	738818	0	0
46307108	1124300	0	0
46311958	1713332	0	0
600000010	40163554	3	4
4042836	378419	4	5
4042504	4047491	4	5
21506150	19079524	3	4
21505795	1322184	0	0
21604191	782047	0	3
35800000	4027663	5	5
36502199	40479422	6	7
36902280	378419	3	5
42802684	975125	0	0
44356729	1129625	0	0
44341340	1177480	0	0
45649649	40232448	2	3
45646735	1521369	0	0
45653776	19008572	2	3
45656672	1125315	0	0
45650383	1153428	0	0
45664309	1125315	0	0
45654535	920293	0	0
45690150	1332418	0	0
45680053	791967	0	0
45706880	791967	0	0
45783206	19133873	2	3
45687716	1119510	0	0
45678590	1110410	0	0
46242744	1115008	0	0
46243254	1332419	2	3
45791002	1515774	0	0
46294895	1129625	0	0
45788306	738818	0	0
46307058	1551099	0	0
46311906	1500211	0	0
600000007	40173590	3	4
4042836	4001336	4	5
4279903	4330583	4	4
21506220	19078461	3	4
21503939	975125	0	0
21604192	19023423	0	3
35800000	40480160	5	5
36502199	4237458	6	7
37320122	134438	2	5
42803013	1129625	0	0
44357012	1129625	0	0
44341241	1118084	0	0
45649950	1107882	2	3
45646768	1713332	0	0
45653253	19019273	2	3
45656693	1125315	0	0
45650337	708298	0	0
45664544	1125315	0	0
45654665	1124957	0	0
45689956	1361711	0	0
45680317	1738521	0	0
45706510	1102527	0	0
45783212	19019273	2	3
45687720	1119510	0	0
45678592	1110410	0	0
46242815	914335	0	0
45801097	1332419	2	3
45791002	19127890	0	0
46294906	1129625	0	0
45788684	738818	0	0
46307110	1124957	0	0
46308816	1118084	0	0
500000301	198809	4	4
4042836	4043241	6	7
4054054	78272	4	4
21506220	19019979	3	4
21503948	1107830	0	0
21604193	19023398	0	3
35800000	4066995	5	5
36502199	40479768	6	7
36702253	4066995	3	7
42803026	1545958	0	0
44357074	1129625	0	0
44338783	1521369	0	0
45649879	19123231	2	3
45646768	1759842	0	0
45653652	40228230	2	3
45656695	1125315	0	0
45650273	1149196	0	0
45778333	1125315	0	0
45654656	1107830	0	0
45689814	1713332	0	0
45680087	1149196	0	0
45706516	1551099	0	0
45780575	40232448	2	3
45687747	1119510	0	0
45678514	1107830	0	0
46242817	1124957	0	0
46238412	1545959	2	3
45791003	1361711	0	0
46294263	1129625	0	0
46289859	738818	0	0
46311831	701322	0	0
46308829	1738521	0	0
500000301	196456	3	3
4180628	378419	6	7
4297887	440448	4	4
21506220	19019273	3	4
21503948	1150836	0	0
21603513	1150837	0	3
21604180	1127433	4	7
36502199	4142905	6	7
36700000	4029498	3	7
44344770	1129625	0	0
44357130	1129625	0	0
44338783	1549786	0	0
45649821	1107882	2	3
45646772	1149196	0	0
45653783	40232448	2	3
45656899	1125315	0	0
45650274	1124957	0	0
45778053	1125315	0	0
45654295	1154343	0	0
45689939	1738521	0	0
45680128	738818	0	0
45706686	1539403	0	0
46244726	19008572	2	3
45684246	1119510	0	0
45678439	1192710	0	0
46243095	1112807	0	0
46241283	1545959	2	3
45791026	1149196	0	0
46296634	1129625	0	0
46289865	738818	0	0
46311833	975125	0	0
46308851	1305058	0	0
600000005	19057271	3	4
4178545	4048171	6	7
4215793	4337138	4	4
21506220	1115171	3	4
21503953	708298	0	0
21603525	40223834	0	3
21604180	19023423	4	7
36211303	4048695	6	7
37502353	4107731	3	7
44345074	1129625	0	0
44350112	1129625	0	0
44338667	1124957	0	0
45649635	19123231	2	3
45646756	715997	0	0
45653812	40223834	2	3
45656751	1125315	0	0
45650279	1545958	0	0
45778324	1125315	0	0
45654463	753626	0	0
45689960	1332418	0	0
45680129	1154343	0	0
45704257	1308738	0	0
46244684	19008572	2	3
45684379	1119510	0	0
45678444	1107830	0	0
46242782	1154343	0	0
46238444	1545959	2	3
45791029	1713332	0	0
46244109	1129625	0	0
46290333	738818	0	0
46312044	975125	0	0
46303398	933724	0	0
600000005	19076374	3	4
4028071	4166224	6	7
4300157	40480160	4	4
21500215	40171902	3	3
21503929	1124300	0	0
21603525	40223821	0	3
21604180	19123231	4	7
36211303	4066995	6	7
37303796	4296204	3	7
44344875	967823	0	0
44349757	1129625	0	0
44338725	1115008	0	0
45649849	40174880	2	3
45646775	1153428	0	0
45653820	19008572	2	3
45656710	1125315	0	0
45650138	738818	0	0
45778246	1125315	0	0
45654589	1124300	0	0
45689960	1545958	0	0
45680237	1551099	0	0
45704260	1501700	0	0
46244687	1127433	2	3
45681444	1119510	0	0
45678472	933724	0	0
46242783	1192710	0	0
46243554	1545959	2	3
45791029	1759842	0	0
46244224	1129625	0	0
46241955	738818	0	0
46312045	1305058	0	0
46303763	1192710	0	0
46307705	19075601	2	3
4029205	4024289	6	7
4300157	4278672	4	4
21500216	40171902	3	3
21503948	1153428	0	0
21602842	19133905	0	3
21604180	19057271	4	7
36211303	4237458	6	7
37320122	133834	4	7
44344880	1115008	0	0
44349976	1129625	0	0
44338668	1149380	0	0
45649862	19008572	2	3
45643442	1124300	0	0
45653821	1551192	2	3
45656770	1125315	0	0
45650413	1102527	0	0
45778101	1125315	0	0
45654591	1501700	0	0
45690132	967823	0	0
45680240	1361711	0	0
45704206	1000560	0	0
45778126	40229134	2	3
45681473	1119510	0	0
45678475	914335	0	0
46243102	705944	0	0
46288949	1539411	2	3
45792004	1124957	0	0
46244372	1129625	0	0
46241965	738818	0	0
46307150	967823	0	0
46303350	975125	0	0
46302465	19075601	2	3
4180628	375671	6	8
4300157	4066995	4	4
21506173	1332418	3	3
21503948	1150770	0	0
21603462	43012036	0	3
21604180	35605858	6	7
35707763	440448	3	8
36702239	4043241	7	7
44344946	1177480	0	0
44350005	1129625	0	0
44338670	1112807	0	0
45649735	40228230	2	3
45643447	1713332	0	0
45653836	1154615	2	3
45656947	1125315	0	0
45650112	1149196	0	0
45660965	1125315	0	0
45654700	1110410	0	0
45690140	1174888	0	0
45680090	738818	0	0
45704276	738818	0	0
45778079	19008572	2	3
45681294	1119510	0	0
45678570	1310149	0	0
46242790	757627	0	0
45895389	1539411	2	3
45791875	1589505	0	0
46239164	1129625	0	0
46241968	738818	0	0
46307156	1107830	0	0
46303309	1309944	0	0
46302504	19075601	2	3
4043018	4198190	6	8
4300157	40479422	4	4
21506173	1307863	3	3
21503951	19002770	0	0
21603462	19112599	0	3
4201745	81893	4	9
36402192	4144583	8	8
36702242	375671	7	7
44345101	1124300	0	0
44349943	1129625	0	0
44338702	1589505	0	0
45649931	1107882	2	3
45643447	1759842	0	0
45653479	40163554	2	3
45657034	1125315	0	0
45650418	1367571	0	0
45660978	1125315	0	0
45654703	1174888	0	0
45690114	723013	0	0
45680093	1115008	0	0
45704285	738818	0	0
46244647	1127433	2	3
45681104	1119510	0	0
45678574	1174888	0	0
46240492	1332418	0	0
46243470	1539411	2	3
45791877	1549786	0	0
46239339	1129625	0	0
46242016	738818	0	0
46307280	1713332	0	0
46303312	1112807	0	0
45799670	19075601	2	3
4047779	4134304	6	10
4043671	4048171	4	4
21503193	1713671	3	3
21503951	782043	0	0
21603514	19125062	0	3
4201745	440448	4	7
36400000	439777	6	8
36702242	378001	7	7
44345188	975125	0	0
44349950	1129625	0	0
44338702	1549786	0	0
45649721	40223834	2	3
45643581	1124300	0	0
45653629	19019273	2	3
45656717	1125315	0	0
45650345	1778162	0	0
45661832	1125315	0	0
45654603	1115008	0	0
45690119	708298	0	0
45680094	1124300	0	0
45704287	1124957	0	0
46244705	19078461	2	3
45681436	1119510	0	0
45678576	1746114	0	0
46240496	1545958	0	0
46243537	19128263	1	2
45791877	19127890	0	0
46239345	1129625	0	0
46242234	738818	0	0
46307337	1174888	0	0
46303268	1112807	0	0
45796610	19075601	2	3
4047779	4166224	6	9
4186164	4134304	4	4
21500154	1539403	3	3
21503951	19039298	0	0
21603514	1107882	0	3
4201745	4166224	4	7
36211303	375671	5	8
37302325	4048695	6	7
44344957	1713332	0	0
44350207	1129625	0	0
44338707	1149380	0	0
45649934	19073183	2	3
45643603	1545958	0	0
45653637	19008572	2	3
45657079	1125315	0	0
45650491	715997	0	0
45661649	1125315	0	0
45654718	1738521	0	0
45689964	1501700	0	0
45680295	738818	0	0
45704187	1124300	0	0
46244628	40163554	2	3
45681612	1119510	0	0
45678577	1343916	0	0
46240587	1332418	0	0
45885353	4059173	1	2
45791877	1512674	0	0
46239583	1129625	0	0
46242182	738818	0	0
46307338	791967	0	0
46303437	1738521	0	0
46300396	1545959	2	3
4047779	375671	6	9
4043346	258780	4	4
21501117	967823	3	3
21503955	1154029	0	0
21602823	19073188	0	3
4227253	81893	7	8
36211303	378001	5	8
36900000	4043241	4	8
44344797	1129625	0	0
44350130	1129625	0	0
44338712	1539403	0	0
45649777	1127433	2	3
45643605	1521369	0	0
45653745	40229134	2	3
45657001	1125315	0	0
45650497	1174888	0	0
45661377	1125315	0	0
45654411	1713332	0	0
45690041	1501700	0	0
45680380	1115008	0	0
45704326	723013	0	0
46240377	40232448	2	3
45681539	1119510	0	0
45678710	933724	0	0
46240591	975125	0	0
45885353	4278672	1	2
45791885	1115008	0	0
46239652	1129625	0	0
46242185	738818	0	0
46307166	1343916	0	0
46303440	1521369	0	0
46319141	19075601	2	3
4178818	4294548	6	6
4043346	317576	4	4
21500617	782043	3	3
21503956	1154029	0	0
21603497	40228214	0	3
4227253	4285898	6	7
36211303	81151	6	8
36702242	4043241	7	8
44344798	738818	0	0
44350146	1129625	0	0
44338887	967823	0	0
45646309	19019273	2	3
45643605	1549786	0	0
45650141	19008572	2	3
45657006	1125315	0	0
45650499	1713332	0	0
45661767	1125315	0	0
45654417	1310149	0	0
45689976	1307863	0	0
45680568	1549786	0	0
45704328	1501700	0	0
46240217	19059056	2	3
45681606	1119510	0	0
45678579	1192710	0	0
46240553	1118084	0	0
45803566	19127922	1	2
45791888	1367571	0	0
46239727	1129625	0	0
46242309	738818	0	0
46307411	738818	0	0
46303440	1549786	0	0
45894675	19078461	2	3
4178818	260139	6	6
4040559	4242997	4	4
21500617	19002770	3	3
21503947	1149196	0	0
21603497	40228230	0	3
35802131	4043241	10	11
36211303	4230399	6	8
37200000	313217	7	8
44345008	1129625	0	0
44364124	1129625	0	0
44338894	1110410	0	0
45646323	40232448	2	3
45643605	1595799	0	0
45650138	40229134	2	3
45657271	1125315	0	0
45650511	1515774	0	0
45661109	1125315	0	0
45654672	975125	0	0
45690062	1149196	0	0
45680568	1515774	0	0
45704212	1501700	0	0
46240307	43012036	2	3
45679754	1119510	0	0
45678684	1308738	0	0
46240669	1124300	0	0
45803566	19133679	1	2
45791854	1110410	0	0
46239615	1129625	0	0
46241988	738818	0	0
46307231	1332418	0	0
46303451	1738521	0	0
46300214	1539411	2	3
4043022	4163971	6	6
4042505	4059173	5	5
21500617	753626	3	3
21503932	1343916	0	0
35202455	313217	1	3
21502709	1150771	9	10
36211303	4134304	6	9
36700000	381316	3	8
44344773	1115008	0	0
44364188	1129625	0	0
44338649	1129625	0	0
45646327	40232448	2	3
45643448	1713332	0	0
45650349	40232448	2	3
45656850	1125315	0	0
45650511	1549786	0	0
45661146	1125315	0	0
45654673	975125	0	0
45690097	1107830	0	0
45680568	19127890	0	0
45704213	1107830	0	0
46240431	40236446	2	3
45679577	1119510	0	0
45678546	740275	0	0
46240670	1115008	0	0
45803566	19129144	1	2
45791898	1107830	0	0
46239735	1129625	0	0
46242288	738818	0	0
46307234	1115008	0	0
46303452	1174888	0	0
45796739	40228214	2	3
4043022	4078793	6	6
4300157	4230399	5	5
21500617	19039298	3	3
21504550	1124300	0	0
35202050	313217	2	4
21502709	1150837	9	10
36211303	78272	5	9
36700000	380378	3	8
44344986	1112807	0	0
44356898	1129625	0	0
44338766	914335	0	0
45646367	40232448	2	3
45643460	1149380	0	0
45650514	40236446	2	3
45653557	1125315	0	0
45650511	19127890	0	0
45661148	1125315	0	0
45654677	1149196	0	0
45690462	967823	0	0
45680180	1310149	0	0
45704290	738818	0	0
46240091	19059056	2	3
45678085	1119510	0	0
45678554	975125	0	0
46240568	1738521	0	0
45892893	45892894	1	1
45791931	1396131	0	0
45895940	1129625	0	0
45893603	738818	0	0
46307235	738818	0	0
46303097	1124957	0	0
46300839	1539411	2	3
4040392	4275113	6	6
4214956	4163874	5	5
21500617	1154029	3	3
21504027	1112807	0	0
21602496	43012433	3	4
21502709	1107882	9	10
35707763	4285898	3	9
37000000	195588	3	8
44345104	1112807	0	0
44356899	1129625	0	0
44338768	1308738	0	0
45646375	40163554	2	3
45643562	1149196	0	0
45650174	40163554	2	3
45653560	1125315	0	0
45650512	1713332	0	0
45661130	1125315	0	0
45654543	1154029	0	0
45690244	738818	0	0
45680407	1713332	0	0
45704226	738818	0	0
46240451	19133905	2	3
45678161	1119510	0	0
45678556	1154343	0	0
46240714	1124300	0	0
45796433	19129144	1	1
45791864	1549786	0	0
45895948	1129625	0	0
45799173	738818	0	0
46307236	738818	0	0
46303115	1174888	0	0
46319060	1539411	2	3
4103352	4048171	6	6
4247371	378419	5	6
21500617	708298	3	3
21504028	1125315	0	0
21604208	40220386	3	4
21502549	19133905	8	9
36426817	1110410	0	0
36303153	192671	3	8
44345106	1115008	0	0
44357137	1129625	0	0
44338899	1589505	0	0
45649002	19018935	2	3
45643251	1500211	0	0
45650187	40223834	2	3
45653552	1125315	0	0
45650512	1759842	0	0
45661186	1125315	0	0
45654547	1107830	0	0
45689982	933724	0	0
45680411	1557272	0	0
45704296	1174888	0	0
46240362	40229134	2	3
45678165	1119510	0	0
45678650	1149196	0	0
46240663	1112807	0	0
45796433	19127922	1	1
45791864	1595799	0	0
45895949	1129625	0	0
45799194	738818	0	0
46307241	1192710	0	0
46303722	1192710	0	0
46302788	40228214	2	3
4043017	4323902	6	6
4040559	4198190	5	6
21503134	1125315	3	3
21504552	1308738	0	0
21603396	19133768	3	4
21502549	19073183	8	9
36425574	975125	0	0
36300000	4012477	3	8
44345112	738818	0	0
44357056	1129625	0	0
44338730	1741122	0	0
45649107	1107882	2	3
45643565	1332418	0	0
45650356	19074679	2	3
45653224	1125315	0	0
45650514	705944	0	0
45661113	1125315	0	0
45654550	1717327	0	0
45689988	975125	0	0
45680392	1322184	0	0
45704297	1713332	0	0
46240374	40232448	2	3
45678292	1119510	0	0
45678776	1149196	0	0
46240742	1322184	0	0
45796433	19133679	1	1
45791864	1521369	0	0
45896137	1129625	0	0
45799354	738818	0	0
46307247	1343916	0	0
46303723	1310149	0	0
45799657	40228214	2	3
4043017	4337611	6	6
4042505	4134304	5	7
21503134	1112807	3	3
21500003	1717327	0	0
21602472	42902245	4	4
1717327	1717327	0	0
36500000	4134304	6	11
36703532	378419	7	8
44345009	738818	0	0
44356915	1129625	0	0
44338730	1746114	0	0
45646498	782047	2	3
45643668	1115008	0	0
45650630	19059056	2	3
45653385	1125315	0	0
45650397	1326303	0	0
45661453	1125315	0	0
45654552	1115008	0	0
45689994	1713332	0	0
45680468	1595799	0	0
45704297	1759842	0	0
46242385	1127433	2	3
45678294	1119510	0	0
45678660	1124300	0	0
46240743	1501700	0	0
45790741	40171902	1	1
45791871	1174888	0	0
45896184	1129625	0	0
45794130	738818	0	0
46307249	1741122	0	0
46303162	1153428	0	0
46312423	40228214	2	3
4028071	258780	6	6
4040551	4336464	5	7
21500205	1361711	3	3
21500002	1728416	0	0
21602472	19128022	4	4
1728416	1728416	0	0
36502199	4134304	5	9
37502353	4242997	7	8
44345010	1129625	0	0
44357111	1129625	0	0
44338899	1549786	0	0
45646472	19073183	2	3
45643708	1153428	0	0
45647250	1551192	2	3
45653782	1125315	0	0
45650429	1548195	0	0
45777849	1125315	0	0
45654710	914335	0	0
45689994	1759842	0	0
45680468	1549786	0	0
45704420	1174888	0	0
46242462	40223768	2	3
45678250	1119510	0	0
45678664	1545958	0	0
46240736	1124300	0	0
46294933	40220386	1	1
45792063	1738521	0	0
45896651	1129625	0	0
45794202	738818	0	0
46307174	1310149	0	0
46303378	1521369	0	0
46295417	40228214	2	3
4047779	4144583	6	6
4247371	4294548	5	7
21500164	1501700	3	3
21500003	1713332	0	0
21602472	19128009	4	4
4056621	4056621	0	0
36502199	78272	4	8
36702247	378001	6	9
44345022	1500211	0	0
44357119	1129625	0	0
44338676	1149196	0	0
45646568	43012036	2	3
45643779	1551099	0	0
45647302	19133768	2	3
45653823	1125315	0	0
45650174	1310149	0	0
45777823	1125315	0	0
45654714	975125	0	0
45690103	1154343	0	0
45680468	1521369	0	0
45704255	1154343	0	0
46242471	19059056	2	3
45678395	1119510	0	0
45678667	1124957	0	0
46240704	1107830	0	0
46299010	19079524	1	1
45792042	1717327	0	0
45896749	1129625	0	0
45788822	738818	0	0
46307194	1115008	0	0
46303382	1112807	0	0
46318351	40228214	2	3
4047779	4027663	6	6
4274025	313217	7	10
21500594	1124300	3	3
21500005	1746114	0	0
21602472	19127918	4	4
4057420	4057420	0	0
36502199	4230399	8	8
36703532	378001	7	9
44345024	1112807	0	0
44358638	1129625	0	0
44338678	1129625	0	0
45646561	1107882	2	3
45643816	1149196	0	0
45647266	40229134	2	3
45653831	1125315	0	0
45650552	1713332	0	0
45654754	1125315	0	0
45655509	1367571	0	0
45690064	1149196	0	0
45680471	1192710	0	0
45704256	708298	0	0
46240496	1545959	2	3
45678499	1119510	0	0
45678676	1308738	0	0
45681062	738818	0	0
46298553	19079524	1	1
45792068	975125	0	0
45804369	1129625	0	0
45788906	738818	0	0
46307291	1549786	0	0
46303134	1738521	0	0
45894262	40223768	2	3
4043018	4163971	6	6
4339410	4134304	7	7
21500594	1129625	3	3
21500002	1729720	0	0
21602472	19128263	4	4
4142905	4142905	0	0
36502197	4237458	6	8
36702253	378419	8	9
44345031	1308738	0	0
44358835	1129625	0	0
44338736	1174888	0	0
45646458	40232448	2	3
45643321	1332418	0	0
45647165	19077572	2	3
45653555	1125315	0	0
45650246	1110410	0	0
45654850	1125315	0	0
45655484	1545958	0	0
45690068	1713332	0	0
45680478	1153428	0	0
45704364	1500211	0	0
46240515	40232448	2	3
45678335	1119510	0	0
45678887	1322184	0	0
45675832	738818	0	0
46242477	19115351	1	1
45791043	1548195	0	0
45804343	1129625	0	0
45788869	738818	0	0
46307291	1521369	0	0
46303816	1112807	0	0
45799828	1539411	2	3
4043016	4107731	6	6
19057271	19057271	0	0
21500594	1118084	3	3
21500012	1778162	0	0
21603931	1118084	4	4
4145310	4145310	0	0
36424688	44816277	2	3
36702253	4001336	7	9
44345036	1129625	0	0
44357394	1129625	0	0
44338737	1501700	0	0
45646633	19078924	2	3
45643373	1154029	0	0
45649205	19073183	2	3
45653804	1125315	0	0
45641900	1125315	0	0
45654883	1125315	0	0
45655445	975125	0	0
45690068	1759842	0	0
45680185	1107830	0	0
45704474	1738521	0	0
46240516	40232448	2	3
45678357	1119510	0	0
45678875	1192710	0	0
45675909	738818	0	0
45896285	19074679	1	1
45791044	967823	0	0
45804382	1129625	0	0
46295245	738818	0	0
46307429	1309944	0	0
46303692	1308738	0	0
45802028	40228214	2	3
4042641	4108705	6	6
19059056	19059056	0	0
21500657	1125315	3	3
21500012	1768849	0	0
21603931	1115008	4	4
4202451	4202451	0	0
36424688	43012433	2	3
37200000	257012	3	9
44344935	742185	0	0
44353898	1129625	0	0
44338740	1729720	0	0
45646579	782047	2	3
45643737	1501700	0	0
45648859	19018935	2	3
45653833	1125315	0	0
45641905	1125315	0	0
45634985	1119510	0	0
45655028	1115008	0	0
45690078	1124957	0	0
45680484	1115008	0	0
45704475	1115008	0	0
45703170	40232448	2	3
45674935	1119510	0	0
45678879	1713332	0	0
45673051	738818	0	0
46299021	19079524	1	1
45791062	1107830	0	0
45804330	1129625	0	0
46295351	738818	0	0
46307432	1124300	0	0
46303818	1738521	0	0
45799300	19078461	2	3
4157607	44782520	1	1
4337138	4337138	0	0
21500657	1308738	3	3
21005673	1310149	0	0
21603931	1557272	4	4
4202832	4202832	0	0
36424689	44816277	2	3
36303153	196456	4	10
44344975	738818	0	0
44354151	1129625	0	0
44338900	1713332	0	0
45646688	19019273	2	3
45643723	1153428	0	0
45648822	40236446	2	3
45653619	1125315	0	0
45641912	1125315	0	0
45635093	1119510	0	0
45654729	791967	0	0
45690185	1551099	0	0
45680244	1539403	0	0
45704487	1545958	0	0
45703223	40174880	2	3
45674858	1119510	0	0
45678895	975125	0	0
45673228	738818	0	0
46299021	46275916	1	1
45791068	1322184	0	0
45796407	1129625	0	0
46244325	738818	0	0
46307364	1115008	0	0
46303736	1501700	0	0
45796734	40228214	2	3
4163273	4330583	1	1
4337611	4337611	0	0
21601077	1308738	3	3
21005678	1713332	0	0
21603931	1177480	4	4
21505925	1343916	0	0
36424689	43012433	2	3
36700000	378419	3	10
44344890	1129625	0	0
44354132	1129625	0	0
44338656	705944	0	0
45646704	40169216	2	3
45643730	1548195	0	0
45649023	40236824	2	3
45653720	1125315	0	0
45642072	1125315	0	0
45635057	1119510	0	0
45654747	1361711	0	0
45690253	1107830	0	0
45680258	738818	0	0
45704492	723013	0	0
45703230	1545959	2	3
45675293	1119510	0	0
45678825	723013	0	0
45784743	738818	0	0
46294371	19079524	1	1
45791082	967823	0	0
45797282	1129625	0	0
46244337	738818	0	0
46307973	920293	0	0
46303646	975125	0	0
45794004	40228214	2	3
4134145	44782520	1	1
4218389	4218389	0	0
21601077	1396131	3	3
21006763	1396131	0	0
35202051	4324181	4	4
21506022	914335	0	0
36427086	964261	2	3
36703532	4043241	9	10
44345051	1192710	0	0
44354235	1129625	0	0
44338659	1107830	0	0
45646775	40223834	2	3
45643783	1738521	0	0
45648872	19059056	2	3
45653628	1125315	0	0
45641919	1125315	0	0
45635151	1119510	0	0
45654764	1595799	0	0
45690110	1115008	0	0
45680497	1174888	0	0
45704503	738818	0	0
45703240	1551192	2	3
45675294	1119510	0	0
45678908	975125	0	0
45784855	738818	0	0
45875979	3011505	1	1
45791109	1000560	0	0
45796485	1129625	0	0
46244558	738818	0	0
46307361	1738521	0	0
46303683	1332418	0	0
46302691	19079524	2	3
4116976	4306014	1	1
4218408	4218408	0	0
21001775	738818	0	0
21006763	1308738	0	0
35202051	317009	4	4
21502734	1309944	0	0
36427078	19126352	2	3
36702247	4043241	8	10
44345037	1174888	0	0
44350314	1129625	0	0
44338859	1308738	0	0
45643464	40228214	2	3
45643784	1307863	0	0
45649175	40228214	2	3
45653630	1125315	0	0
45642038	1125315	0	0
45630110	1119510	0	0
45654867	1149196	0	0
45690111	967823	0	0
45680498	1174888	0	0
45704511	1149380	0	0
45703275	1154615	2	3
45674865	1119510	0	0
45678718	1149196	0	0
45784871	738818	0	0
45875977	40769184	1	1
45791099	1500211	0	0
45796595	1129625	0	0
46244596	738818	0	0
46307425	1713332	0	0
46303690	975125	0	0
46313224	40228214	2	3
4116976	4302207	1	1
21000890	1713332	0	0
21001775	967823	0	0
21008439	1551099	0	0
21605007	1149196	4	4
21502741	1738521	0	0
36427229	35605482	2	3
36700000	375671	3	11
44344916	1124300	0	0
44350245	1129625	0	0
44338860	1124300	0	0
45643565	1332419	2	3
45643483	1322184	0	0
45647309	1545959	2	3
45653745	1125315	0	0
45641755	1125315	0	0
45630143	1119510	0	0
45654870	1192710	0	0
45690257	1738521	0	0
45680501	1549786	0	0
45704512	1124957	0	0
45703348	40162522	2	3
45675211	1119510	0	0
45678826	1310149	0	0
45785016	738818	0	0
45875977	40769189	1	1
45791100	967823	0	0
45796656	1129625	0	0
45787711	1177480	0	0
46307425	1759842	0	0
46303692	1595799	0	0
46312074	1539411	2	3
4108467	4296204	1	1
21000890	1746114	0	0
21001775	1125315	0	0
21008461	738818	0	0
21605007	1129625	4	4
21502752	1548195	0	0
36416791	19078924	2	3
36700000	378001	6	11
44344917	1551099	0	0
44350491	1129625	0	0
44338865	1153428	0	0
45643723	40223834	2	3
45643375	1149196	0	0
45647406	1115171	2	3
45653767	1125315	0	0
45641955	1125315	0	0
45630099	1119510	0	0
45654815	967823	0	0
45690268	1501700	0	0
45680501	1521369	0	0
45704356	920293	0	0
45703491	40229134	2	3
45675258	1119510	0	0
45678926	1539403	0	0
45785161	738818	0	0
45875977	40769194	1	1
45791048	1738521	0	0
45791489	1129625	0	0
45787690	1177480	0	0
46307426	1361711	0	0
46303176	1332418	0	0
46307371	1539411	2	3
4189601	4010253	1	1
21000802	975125	0	0
21001775	1150836	0	0
21008225	1713332	0	0
21605007	738818	4	4
21502752	1512674	0	0
36427387	19045231	2	3
36702253	4043241	10	11
44345130	1192710	0	0
44350365	1129625	0	0
44338973	1149196	0	0
45643518	40232448	2	3
45643494	1149380	0	0
45644362	1115171	2	3
45650222	1125315	0	0
45642046	1125315	0	0
45630025	1119510	0	0
45654816	1343916	0	0
45690203	1174888	0	0
45680365	1115008	0	0
45704357	1307863	0	0
45703472	40229134	2	3
45674869	1119510	0	0
45672501	1778162	0	0
45784952	738818	0	0
45875977	40769179	1	1
45791104	1551099	0	0
46298674	1129625	0	0
45787591	1177480	0	0
46307590	1717327	0	0
46303878	1174888	0	0
45791792	40228214	2	3
4189847	4117038	1	1
21000803	1595799	0	0
21001791	975125	0	0
21008225	1759842	0	0
21605007	1154343	4	4
21503001	1129625	0	0
36226536	19127904	2	3
37502353	4336464	7	11
44345132	1110410	0	0
44346772	1129625	0	0
44339049	1107830	0	0
45646062	40228214	2	3
45643790	1115008	0	0
45644457	19008572	2	3
45650225	1125315	0	0
45642054	1125315	0	0
45630275	1119510	0	0
45654817	1501700	0	0
45690204	1124957	0	0
45680366	738818	0	0
45700959	967823	0	0
45703330	40165015	2	3
45675205	1119510	0	0
45672507	1548195	0	0
45784843	738818	0	0
45875977	40766240	1	1
45791096	1115008	0	0
46298689	1129625	0	0
45787767	1177480	0	0
46307593	738818	0	0
46303989	1551099	0	0
46318040	19078461	2	3
4164337	4285898	1	1
21000890	1759842	0	0
21001778	967823	0	0
21008226	1713332	0	0
21605007	1174888	4	4
21502752	1549786	0	0
36424575	1594382	2	3
37522270	4323902	2	6
44344922	1548195	0	0
44346776	1129625	0	0
44339050	738818	0	0
45640509	19077572	2	3
45643624	723013	0	0
45644289	40165015	2	3
45650314	1125315	0	0
45638735	1125315	0	0
45630167	1119510	0	0
45654823	723013	0	0
45690161	1309944	0	0
45680376	1589505	0	0
45700961	1115008	0	0
45700402	40229134	2	3
45675264	1119510	0	0
45672404	1149196	0	0
45785220	738818	0	0
45875996	3006734	1	1
46294692	1332418	0	0
46298517	1129625	0	0
45801234	1177480	0	0
46307598	975125	0	0
46304006	1589505	0	0
46302099	19079524	2	3
4159963	195588	1	1
21000890	1741122	0	0
21001797	1778162	0	0
21008226	1759842	0	0
21605007	1149380	4	4
21502759	1501700	0	0
36423360	19074679	2	3
37522270	4117038	2	6
44345338	1137529	0	0
44346593	1129625	0	0
44338953	1759842	0	0
45640779	43012036	2	3
45643406	1738521	0	0
45644510	19057271	2	3
45650165	1125315	0	0
45638726	1125315	0	0
45630258	1119510	0	0
45654824	975125	0	0
45686952	1308738	0	0
45680376	1549786	0	0
45700802	753626	0	0
45700114	1127433	2	3
45675266	1119510	0	0
45672620	19127890	0	0
45785228	738818	0	0
45875996	3000876	1	1
46294744	1343916	0	0
46298724	1129625	0	0
45795769	1177480	0	0
46307305	757627	0	0
46304015	1192710	0	0
46312664	19078461	2	3
4159963	198199	1	1
21000874	975125	0	0
21001797	1759842	0	0
21008236	1759842	0	0
21605007	1137529	4	4
21502747	1545958	0	0
36427076	920300	2	3
37522270	4057420	4	7
44345338	1149380	0	0
44346805	1129625	0	0
44339075	1129625	0	0
45640889	1713671	2	3
45643412	1124300	0	0
45644424	40224805	2	3
45650267	1125315	0	0
45638922	1125315	0	0
45630335	1119510	0	0
45651176	1115008	0	0
45686954	1551099	0	0
45680344	1174888	0	0
45700874	1107830	0	0
45700309	40232448	2	3
45671909	1119510	0	0
45672620	1549786	0	0
45785074	738818	0	0
45875996	3021226	1	1
46294749	1000560	0	0
46298991	1129625	0	0
45795857	1177480	0	0
46307307	975125	0	0
46303903	1118084	0	0
45794277	19078461	2	3
4080926	133834	1	1
21000873	1551099	0	0
21001797	1746114	0	0
21008236	1713332	0	0
21605007	1107830	4	4
21502747	1539403	0	0
36427076	920334	2	3
37522270	44783196	4	5
44345240	1192710	0	0
44346742	1129625	0	0
44338981	1549786	0	0
45640847	1713671	2	3
45643749	738818	0	0
45641444	43012036	2	3
45650274	1125315	0	0
45638923	1125315	0	0
45630354	1119510	0	0
45651199	1738521	0	0
45686724	1738521	0	0
45680367	1501700	0	0
45700885	1717327	0	0
45700502	40232448	2	3
45672327	1119510	0	0
45672626	1154343	0	0
45786482	738818	0	0
45875996	3001488	1	1
46294092	975125	0	0
46299011	1129625	0	0
45795974	1177480	0	0
46307201	1501700	0	0
46303388	1551099	0	0
46307480	19078461	2	3
4082382	4326177	1	1
21000907	1310149	0	0
21001796	1728416	0	0
21011415	1110410	0	0
21602359	1519936	4	4
21600317	1361711	0	0
36424251	19018935	2	3
37522270	4337611	4	5
44344925	1332418	0	0
44346288	1129625	0	0
44338981	1521369	0	0
45640868	782047	2	3
45643509	1717327	0	0
45641413	1127433	2	3
45650276	1125315	0	0
45638762	1125315	0	0
45627107	1119510	0	0
45651367	738818	0	0
45686797	1153428	0	0
45680368	1713332	0	0
45700981	967823	0	0
45700349	1154615	2	3
45672550	1119510	0	0
45672531	1310149	0	0
45786250	738818	0	0
45875996	3023430	1	1
46294093	1310149	0	0
46299224	1129625	0	0
45795874	1177480	0	0
46307203	1192710	0	0
46303389	1153428	0	0
46299723	19078461	2	3
4083499	4078793	1	1
21001351	1343916	0	0
21001775	1174888	0	0
21011420	1343916	0	0
21602359	1500211	4	4
21604214	753626	0	0
36302180	4133840	2	3
36700000	4043241	5	12
44344928	1124957	0	0
44346601	1129625	0	0
44338745	1124957	0	0
45640997	40231925	2	3
45643512	1124957	0	0
45641650	40232448	2	3
45650138	1125315	0	0
45638771	1125315	0	0
45627109	1119510	0	0
45651215	1115008	0	0
45686956	1332418	0	0
45680368	1759842	0	0
45700689	740275	0	0
45700257	19018935	2	3
45672276	1119510	0	0
45672540	920293	0	0
45782873	738818	0	0
45875996	3019406	1	1
46294096	1000560	0	0
46291664	1129625	0	0
45795954	1177480	0	0
46307203	1174888	0	0
46301035	1361711	0	0
46302164	19078461	2	3
4190759	4163872	1	1
21001355	975125	0	0
21001775	1107830	0	0
21011856	1713332	0	0
21602359	19054876	4	4
1713671	1713671	0	0
36225403	19128065	2	3
36700000	4001336	5	10
44345245	1115008	0	0
44348579	1129625	0	0
44338908	1112807	0	0
45640998	40223834	2	3
45643763	1549786	0	0
44340904	1115008	0	0
45650493	1125315	0	0
45638892	1125315	0	0
45627363	1119510	0	0
45651164	19010482	0	0
45686949	708298	0	0
45680373	738818	0	0
45701069	1149196	0	0
45896820	40162522	2	3
45672594	1119510	0	0
45672543	791967	0	0
45782822	738818	0	0
45875996	3015076	1	1
46294630	1361711	0	0
46291843	1129625	0	0
45795852	1177480	0	0
46307204	1174888	0	0
46301052	1107830	0	0
46307458	19078461	2	3
4191948	40492359	1	1
21001359	1124300	0	0
21001796	1717327	0	0
21002077	1746114	0	0
21602359	1548195	4	4
21502553	1332419	7	8
36225402	19128065	2	3
36400000	4144583	5	9
44345079	1738521	0	0
44348445	1129625	0	0
44338811	967823	0	0
45640998	40223821	2	3
45643763	19127890	0	0
44340908	933724	0	0
45650497	1125315	0	0
45638898	1125315	0	0
45627539	1119510	0	0
45651166	1310149	0	0
45688737	1746114	0	0
45680353	1192710	0	0
45701097	1124957	0	0
45896880	1127433	2	3
45784024	1119510	0	0
45673275	1124957	0	0
45783017	738818	0	0
45875996	3006451	1	1
46294889	975125	0	0
46291156	1129625	0	0
45796046	1177480	0	0
46307523	738818	0	0
46301062	933724	0	0
46307682	19078461	2	3
4161134	4202451	1	1
21001359	975125	0	0
21001775	1192710	0	0
21002077	1741122	0	0
21602359	1512674	4	4
21502553	19018935	7	8
36463297	1332419	2	3
37522270	4336464	5	9
44345340	1738521	0	0
44342776	1129625	0	0
44338815	920293	0	0
45640874	40232448	2	3
45643837	742185	0	0
44340939	1545958	0	0
45650500	1125315	0	0
45639089	1125315	0	0
45623707	1119510	0	0
45651149	1149196	0	0
45688737	1741122	0	0
45680630	1305058	0	0
45700945	1713332	0	0
45697106	19008572	2	3
45784342	1119510	0	0
45673276	1192710	0	0
45783033	738818	0	0
45875996	3005136	1	1
46294639	1149380	0	0
46290402	1129625	0	0
45790654	1177480	0	0
46307215	1000560	0	0
46301067	975125	0	0
45799483	19078461	2	3
4112341	4294548	1	1
21001379	1759842	0	0
21001775	1149196	0	0
21002084	975125	0	0
21601386	19010482	4	4
21502553	1310034	7	8
36424721	1519937	2	3
36702247	4001336	5	8
44345251	740275	0	0
44342721	1129625	0	0
44338849	1177480	0	0
45640976	19133905	2	3
45645839	701322	0	0
44340962	1361711	0	0
45650616	1125315	0	0
45639103	1125315	0	0
45623900	1119510	0	0
45651169	1000560	0	0
45688532	1367571	0	0
45680681	1501700	0	0
45701137	1332418	0	0
45697394	40229134	2	3
45784353	1119510	0	0
45673276	1174888	0	0
45783154	738818	0	0
45875996	3001247	1	1
46294639	1137529	0	0
46290514	1129625	0	0
46297242	1177480	0	0
46307576	1115008	0	0
46300923	1501700	0	0
45802061	19078461	2	3
4112341	4112343	1	1
21001381	1717327	0	0
21001688	1310149	0	0
21002052	1713332	0	0
21601386	1500211	4	4
21502553	19126352	7	8
36424721	43012433	2	3
37303796	133834	5	8
44345043	1177480	0	0
44342762	1129625	0	0
44338999	1000560	0	0
45640976	19133873	2	3
45640772	1551099	0	0
44340909	1124300	0	0
45650188	1125315	0	0
45635369	1125315	0	0
45625144	1119510	0	0
45651406	1107830	0	0
45688406	1149196	0	0
45680650	1149196	0	0
45700817	1310149	0	0
45697397	40229134	2	3
45784262	1119510	0	0
45673186	1154343	0	0
45782999	738818	0	0
45875996	3020655	1	1
46294644	1713332	0	0
46290430	1129625	0	0
46297764	1177480	0	0
46307587	1307863	0	0
46300925	1112807	0	0
46318480	19078461	2	3
4043174	4216130	1	1
21001382	1713332	0	0
21001686	1310149	0	0
21002094	1717327	0	0
21604208	753626	2	2
35702767	81893	6	8
36427297	40231925	2	3
37522270	4330583	5	8
44345043	1129625	0	0
44342792	1129625	0	0
44339004	1129625	0	0
45640987	40232448	2	3
45640527	1738521	0	0
44340945	701322	0	0
45650368	1125315	0	0
45635625	1125315	0	0
45625215	1119510	0	0
45651174	975125	0	0
45688409	738818	0	0
45680349	1557272	0	0
45700986	1124957	0	0
45697369	1127433	2	3
45784280	1119510	0	0
45673384	1124957	0	0
45783111	738818	0	0
45875996	3012494	1	1
46294644	1759842	0	0
46290698	1129625	0	0
46297972	1177480	0	0
46307802	1174888	0	0
46300773	1332418	0	0
46300307	40223768	2	3
4043029	4024289	1	1
21001378	1717327	0	0
21001686	1367571	0	0
21002088	975125	0	0
21602496	1512674	2	2
36200000	4084167	7	7
36424211	40229134	2	3
40776263	3026361	5	7
44345046	1589505	0	0
44343082	1129625	0	0
44339004	1177480	0	0
45640639	40236824	2	3
45640646	1153428	0	0
44340952	738818	0	0
45650262	1125315	0	0
45635627	1125315	0	0
45625230	1119510	0	0
45651359	1115008	0	0
45688517	1115008	0	0
45680633	1110410	0	0
45700952	1738521	0	0
45697509	19078461	2	3
45784253	1119510	0	0
45673386	723013	0	0
45783315	738818	0	0
45875996	3036780	1	1
46294648	1307863	0	0
46290757	1129625	0	0
46289803	1177480	0	0
46307443	1153428	0	0
46300542	1310149	0	0
45895602	19078461	2	3
4027255	317576	1	1
21001379	1717327	0	0
21001701	975125	0	0
21002068	1741122	0	0
21602496	1589505	2	2
21502709	1149196	7	7
36244042	44816277	2	3
40776263	3010813	5	7
44345157	1326303	0	0
44343019	1129625	0	0
44338817	1501700	0	0
45641180	1127433	2	3
45640750	753626	0	0
44340911	1115008	0	0
45647280	1125315	0	0
45635629	1125315	0	0
45624137	1119510	0	0
45651388	1310149	0	0
45688697	738818	0	0
45680636	791967	0	0
45701082	1107830	0	0
45697420	19008572	2	3
45784270	1119510	0	0
45673296	1192710	0	0
45783141	738818	0	0
45875996	3014599	1	1
46294656	1549786	0	0
46290948	1129625	0	0
46241557	1177480	0	0
46307489	933724	0	0
46300678	1112807	0	0
46296219	19078461	2	3
4178680	80180	1	1
21001357	1124300	0	0
21001738	1174888	0	0
21002068	1746114	0	0
21604255	1124957	2	2
21502709	1177480	7	7
36429708	40171902	1	1
36703532	4132546	5	7
44344993	1729720	0	0
44339492	1129625	0	0
44338826	740275	0	0
45641097	40232448	2	3
45640589	1149196	0	0
44340884	1305058	0	0
45647302	1125315	0	0
45637187	1125315	0	0
45624209	1119510	0	0
45651390	738818	0	0
45688729	1124300	0	0
45680643	1759842	0	0
45700989	1000560	0	0
45894727	19078461	2	3
45786454	1119510	0	0
45672666	1115008	0	0
45783205	738818	0	0
45875996	3027231	1	1
46294656	1512674	0	0
46290669	1129625	0	0
46241590	1177480	0	0
46307495	757627	0	0
46300875	1174888	0	0
46318469	19078461	2	3
4178431	4035415	1	1
21001380	1778162	0	0
21001707	967823	0	0
21002069	1741122	0	0
21602100	975125	2	2
21502709	1154343	7	7
36303102	4163951	1	1
36700000	44782520	5	7
44344994	1115008	0	0
44339550	1129625	0	0
44339057	1177480	0	0
45637612	19008572	2	3
45640889	1713332	0	0
44340688	1115008	0	0
45647266	1125315	0	0
45637034	1125315	0	0
45624183	1119510	0	0
45651391	1115008	0	0
45687059	967823	0	0
45680643	1713332	0	0
45701199	1308738	0	0
45894819	40228230	2	3
45786455	1119510	0	0
45672633	1192710	0	0
45783333	738818	0	0
45875980	3049273	1	1
46294657	975125	0	0
46290814	1129625	0	0
46241697	1177480	0	0
46307681	738818	0	0
46300878	1545958	0	0
46312420	19078461	2	3
4064927	4062501	1	1
21001379	1778162	0	0
21001738	1125315	0	0
21002069	1746114	0	0
21602478	42902245	2	2
21502552	19059056	6	7
36424218	19115351	1	1
36300000	4145310	5	7
44345089	1192710	0	0
44339353	1129625	0	0
44339198	1129625	0	0
45637646	40163554	2	3
45640889	1759842	0	0
44340841	1118084	0	0
45647160	1125315	0	0
45636837	1125315	0	0
45624165	1119510	0	0
45651398	1332418	0	0
45687084	1738521	0	0
45680685	1149196	0	0
45701203	1343916	0	0
45694415	19008572	2	3
45786459	1119510	0	0
45672647	1738521	0	0
45778126	738818	0	0
45876002	3019550	1	1
46294802	1154343	0	0
46290815	1129625	0	0
46241681	1177480	0	0
46302194	933724	0	0
46300888	1548195	0	0
46312534	19078461	2	3
4068155	313217	1	1
21001379	1728416	0	0
21001710	1343916	0	0
21002070	1741122	0	0
35202454	313217	2	2
21502552	40163554	6	7
36303181	4234705	1	1
40792793	3026361	5	7
44345089	1177480	0	0
44341422	1129625	0	0
44339201	1129625	0	0
45637766	43012036	2	3
45640509	757627	0	0
44340843	1192710	0	0
45647169	1125315	0	0
45636838	1125315	0	0
45624256	1119510	0	0
45651306	1396131	0	0
45687130	975125	0	0
45680690	1192710	0	0
45701001	1174888	0	0
45694447	1713671	2	3
45784371	1119510	0	0
45672667	1107830	0	0
46242632	738818	0	0
45876002	3013721	1	1
46294806	723013	0	0
46291084	1129625	0	0
45897976	1177480	0	0
46302311	1521369	0	0
46301070	1501700	0	0
46296392	19078461	2	3
4063381	4280726	1	1
21001378	1759842	0	0
21001738	1129625	0	0
21002071	1741122	0	0
21602752	1501700	2	2
21502552	19075601	6	7
36304718	3013682	1	1
36902280	4043241	5	7
44345092	1177480	0	0
44341300	1129625	0	0
44339207	1174888	0	0
45637892	19019273	2	3
45640709	1174888	0	0
44340844	1332418	0	0
45649009	1125315	0	0
45637150	1125315	0	0
45624392	1119510	0	0
45651612	920293	0	0
45687066	715997	0	0
45676886	1192710	0	0
45701165	967823	0	0
45694261	19018935	2	3
45784385	1119510	0	0
45672649	920293	0	0
46240248	738818	0	0
45876002	3015632	1	1
46296566	1129625	0	0
46291057	1129625	0	0
45898002	1177480	0	0
46302358	933724	0	0
46301618	1589505	0	0
46308120	19078461	2	3
4187067	317576	1	1
21001380	1759842	0	0
21001738	1192710	0	0
21002072	1746114	0	0
21602480	19128009	2	2
4093991	4296204	5	6
36304718	3024561	1	1
36402192	439777	5	7
44345088	1177480	0	0
44339773	1129625	0	0
44338920	1177480	0	0
45637904	1115171	2	3
45640992	740275	0	0
44340849	1115008	0	0
45649012	1125315	0	0
45636928	1125315	0	0
45668478	1119510	0	0
45651619	1549786	0	0
45687069	1149196	0	0
45676699	738818	0	0
45701353	740275	0	0
45694435	19059056	2	3
45784457	1119510	0	0
45672654	975125	0	0
46240362	738818	0	0
45876002	3006923	1	1
46296648	1129625	0	0
46291069	1129625	0	0
45897964	1177480	0	0
46302361	920293	0	0
46301678	1557272	0	0
46318225	19078461	2	3
4187096	4059173	1	1
21001382	1759842	0	0
21001688	1367571	0	0
21002072	1741122	0	0
21602480	19127918	2	2
4227253	4166224	5	6
36304718	3004501	1	1
37303814	4066995	5	6
44345006	1129625	0	0
44362940	1119510	0	0
44339067	1129625	0	0
45637909	40229134	2	3
45640813	1539403	0	0
44340985	1000560	0	0
45649016	1125315	0	0
45637220	1125315	0	0
45668269	1119510	0	0
45651619	19127890	0	0
45687097	740275	0	0
45676847	1149196	0	0
45701245	967823	0	0
45694602	19008572	2	3
45784409	1119510	0	0
45672656	1124957	0	0
45703272	738818	0	0
45876002	3027970	1	1
46293651	1129625	0	0
46290618	1129625	0	0
45895702	1177480	0	0
46302369	1124957	0	0
46301663	1174888	0	0
46319088	19078461	2	3
4180765	4252419	1	1
21000912	1728416	0	0
21013411	1768849	0	0
21002073	1741122	0	0
35202050	321042	2	2
4227253	313217	5	6
36304718	3016723	1	1
37303814	4048695	5	6
44338115	1177480	0	0
44363082	1119510	0	0
44360400	933724	0	0
45637992	19073183	2	3
45640718	1539403	0	0
44340922	738818	0	0
45647369	1125315	0	0
45637222	1125315	0	0
45668271	1119510	0	0
45651619	1512674	0	0
45687284	1343916	0	0
45677074	1548195	0	0
45701065	1107830	0	0
45694596	40163554	2	3
45784487	1119510	0	0
45672695	1717327	0	0
45703276	738818	0	0
45876002	3035995	1	1
46293589	1129625	0	0
46290628	1129625	0	0
45895780	1177480	0	0
46302471	1174888	0	0
46301702	1713332	0	0
45799501	19078461	2	3
4180765	4024289	1	1
21000912	1729720	0	0
21013411	1713332	0	0
21002074	1741122	0	0
35202050	4324181	2	2
4180938	4058899	4	6
36303158	4012477	1	1
36703532	381316	5	6
44338173	1326303	0	0
44362987	1119510	0	0
44360088	1112807	0	0
44343795	43012036	2	3
45640728	1307863	0	0
44340924	738818	0	0
45647408	1125315	0	0
45635940	1125315	0	0
45668276	1119510	0	0
45651648	1589505	0	0
45687137	1124957	0	0
45677087	1501700	0	0
45700857	1589505	0	0
45691336	40232448	2	3
45784433	1119510	0	0
45672698	1549786	0	0
45703491	738818	0	0
45876002	3023103	1	1
46293751	1129625	0	0
46242437	1129625	0	0
45895785	1177480	0	0
46302167	1332418	0	0
46301748	1326303	0	0
45796915	1332419	2	3
4115236	40481087	1	1
21000931	791967	0	0
21013430	740275	0	0
21002075	1741122	0	0
21604303	1125315	2	2
4213101	4066995	4	6
36304850	3006906	1	1
40792793	3010813	5	6
44338174	1307863	0	0
44362995	1119510	0	0
44360413	1174888	0	0
44340084	1115171	2	3
45640847	1713332	0	0
44340934	975125	0	0
45644240	1125315	0	0
45635834	1125315	0	0
45668239	1119510	0	0
45651648	1549786	0	0
45687104	1738521	0	0
45677007	1115008	0	0
45700857	1549786	0	0
45802647	40229134	2	3
45782313	1119510	0	0
45672702	1107830	0	0
45703472	738818	0	0
45876002	3004501	1	1
46293494	1129625	0	0
46242371	1129625	0	0
45895869	1177480	0	0
46301992	914335	0	0
46301750	1343916	0	0
46299644	19078461	2	3
4105866	81151	1	1
21000919	791967	0	0
21013433	1746114	0	0
21002075	1746114	0	0
21604303	1112807	2	2
4042505	4230399	6	6
36304850	3024561	1	1
36702242	378419	5	6
44338215	1738521	0	0
44363243	1119510	0	0
44360383	1129625	0	0
44340147	19018935	2	3
45640847	1759842	0	0
44340890	723013	0	0
45644309	1125315	0	0
45635762	1125315	0	0
45668387	1119510	0	0
45651653	738818	0	0
45687187	1768849	0	0
45677008	1124957	0	0
45700857	19127890	0	0
45802539	1115171	2	3
45782315	1119510	0	0
45672711	1124957	0	0
45700402	738818	0	0
45876002	3014576	1	1
46293811	1129625	0	0
46242522	1129625	0	0
45896011	1177480	0	0
46302115	1000560	0	0
46301847	1322184	0	0
46313035	19078461	2	3
4074815	81893	1	1
21000467	1548195	0	0
21013448	1539403	0	0
21002059	1112807	0	0
21603395	1174888	2	2
35802131	140673	6	6
36304850	3013682	1	1
36702253	44782520	5	6
44338226	1326303	0	0
44363466	1119510	0	0
44360391	933724	0	0
44340255	1127433	2	3
45640854	738818	0	0
44340891	1115008	0	0
45644147	1125315	0	0
45635768	1125315	0	0
45668391	1119510	0	0
45651555	1154343	0	0
45687235	975125	0	0
45677010	1124957	0	0
45700860	1149196	0	0
45876033	3020630	2	3
45782316	1119510	0	0
45672772	967823	0	0
45697394	738818	0	0
45876002	3013682	1	1
46293725	1129625	0	0
46242353	1129625	0	0
45804223	1177480	0	0
46302282	1107830	0	0
46301618	1549786	0	0
46307409	19078461	2	3
4074298	4238715	1	1
21000404	1551099	0	0
21013455	1124300	0	0
21002089	975125	0	0
21603366	1125443	2	2
21502549	1308738	6	6
36304850	3004501	1	1
36702247	380378	5	6
44338227	738818	0	0
44363381	1119510	0	0
44359771	1107830	0	0
44340370	19008572	2	3
45640856	1551099	0	0
45636975	1107830	0	0
45644273	1125315	0	0
45636064	1125315	0	0
45668370	1119510	0	0
45651493	1729720	0	0
45687237	1107830	0	0
45679392	715997	0	0
45700871	738818	0	0
45876033	3045716	2	3
45782502	1119510	0	0
45672641	967823	0	0
45697397	738818	0	0
45876002	3009201	1	1
46293952	1129625	0	0
46242548	1129625	0	0
45804216	1177480	0	0
46302017	1501700	0	0
46301752	1332418	0	0
46299662	19078461	2	3
4074298	4275113	1	1
21000423	975125	0	0
21013432	1717327	0	0
21002089	1551099	0	0
21603617	975125	2	2
21502549	1746114	6	6
36304850	3016723	1	1
37503887	4198190	5	6
44338229	1557272	0	0
44363179	1119510	0	0
44360037	1110410	0	0
44340374	19077572	2	3
45640862	1521369	0	0
45637302	738818	0	0
45644278	1125315	0	0
45632547	1125315	0	0
45668373	1119510	0	0
45651382	1729720	0	0
45687241	1154029	0	0
45679452	1154029	0	0
45700788	1305058	0	0
45876033	3019550	2	3
45782528	1119510	0	0
45672645	1192710	0	0
45894805	738818	0	0
45876002	3024561	1	1
46288772	1129625	0	0
46240264	1129625	0	0
45804047	1177480	0	0
46302311	1549786	0	0
46301939	723013	0	0
45791657	19078461	2	3
4085100	40481087	1	1
21000404	975125	0	0
21013432	1778162	0	0
21002084	1551099	0	0
21603638	1124300	2	2
21502549	1713332	6	6
36403211	80502	1	1
37522270	4242997	5	6
44338190	1549786	0	0
44363257	1119510	0	0
44360042	1305058	0	0
44339943	19133905	2	3
45640862	1549786	0	0
45637393	1124300	0	0
45644372	1125315	0	0
45632642	1125315	0	0
45668452	1119510	0	0
45651412	1192710	0	0
45687184	1778162	0	0
45679287	723013	0	0
45700792	1107830	0	0
45688459	40162522	2	3
45782565	1119510	0	0
45672686	1192710	0	0
45694981	738818	0	0
45876002	3020630	1	1
46289124	1129625	0	0
45896240	1129625	0	0
45803835	1177480	0	0
46302022	1521369	0	0
46301240	1000560	0	0
46318696	40174880	2	3
4043017	4035793	1	1
21000472	975125	0	0
21013431	791967	0	0
21002098	975125	0	0
21602723	975125	2	2
4227253	440448	6	6
36248814	40174880	1	2
40796010	3026361	5	5
44338190	19127890	0	0
44363258	1119510	0	0
44360233	1110410	0	0
44340486	19019273	2	3
45640866	1548195	0	0
45637365	1539403	0	0
45644327	1125315	0	0
45632826	1125315	0	0
45668789	1119510	0	0
45651414	975125	0	0
45687209	1322184	0	0
45679663	1154029	0	0
45700831	1110410	0	0
45800015	19078461	2	3
45782589	1119510	0	0
45672688	1738521	0	0
45694606	738818	0	0
45876002	3006906	1	1
46289277	1129625	0	0
45896457	1129625	0	0
45804083	1177480	0	0
46302027	1589505	0	0
46301246	1107830	0	0
46318938	1545959	2	3
4180248	4035793	1	1
21000472	1551099	0	0
21013458	705944	0	0
21502657	1118084	0	0
21602723	1551099	2	2
1713545	1713671	1	1
36248806	40174880	1	2
36300000	4195803	5	5
44338190	1512674	0	0
44363193	1119510	0	0
44359774	1548195	0	0
44340494	920334	2	3
45640868	782043	0	0
45637341	1154029	0	0
45644092	1125315	0	0
45632751	1125315	0	0
45668525	1119510	0	0
45651423	1343916	0	0
45687210	1729720	0	0
45679664	1107830	0	0
45700834	738818	0	0
45799993	43012036	2	3
45782590	1119510	0	0
45672791	1149196	0	0
45802647	738818	0	0
46233710	46233710	0	0
46243839	1129625	0	0
45896622	1129625	0	0
45804027	1177480	0	0
46302101	1778162	0	0
46301270	1729720	0	0
45894285	1332419	2	3
4105895	4293740	1	1
21000472	1305058	0	0
21013433	1759842	0	0
21602860	1741122	0	0
21604182	19016749	2	2
1717504	19129655	1	1
36225210	1539411	1	2
37302323	4156265	5	5
44338176	1501700	0	0
44363323	1119510	0	0
44360124	1118084	0	0
44340417	19019273	2	3
45640961	1343916	0	0
45625321	1332418	0	0
45644161	1125315	0	0
45632785	1125315	0	0
45665857	1119510	0	0
45651432	1717327	0	0
45687200	1107830	0	0
45679672	19127890	0	0
45697943	1115008	0	0
45800053	40229134	2	3
45782534	1119510	0	0
45672673	1501700	0	0
45688171	738818	0	0
46238179	1149196	0	0
46243754	1129625	0	0
45894114	1129625	0	0
45798907	1177480	0	0
46302249	1124300	0	0
46301275	1322184	0	0
46300426	1332419	2	3
4040398	4243062	1	1
21000471	1551099	0	0
21013433	920293	0	0
21003026	1154029	0	0
21603057	920293	2	2
4056622	4056621	1	1
36225209	1539411	1	2
40779591	3021226	5	5
44338265	1177480	0	0
44363302	1119510	0	0
44359780	975125	0	0
44340631	40232448	2	3
45640996	738818	0	0
45625323	975125	0	0
45644179	1125315	0	0
45632824	1125315	0	0
45667371	1119510	0	0
45651435	740275	0	0
45687296	1000560	0	0
45679672	1589505	0	0
45697876	1343916	0	0
45800082	19077572	2	3
45782665	1119510	0	0
45672719	1192710	0	0
45688436	738818	0	0
46235214	46235214	0	0
46243849	1129625	0	0
45894088	1129625	0	0
45799812	1177480	0	0
46302216	1713332	0	0
46301184	1308738	0	0
45796860	1332419	2	3
4043028	4252419	1	1
21000474	1149380	0	0
21013433	1768849	0	0
21003025	19003953	0	0
21601854	1545958	2	2
4092747	378419	1	1
36225662	35605482	1	2
40779591	3023430	5	5
44338124	1713332	0	0
44363596	1119510	0	0
44360423	975125	0	0
44340521	40232448	2	3
45640997	1124957	0	0
45622036	740275	0	0
45644342	1125315	0	0
45632922	1125315	0	0
45667225	1119510	0	0
45651682	1728416	0	0
45687203	1107830	0	0
45679672	1549786	0	0
45697920	1115008	0	0
45800084	1127433	2	3
45782235	1119510	0	0
45672723	1551099	0	0
45800016	738818	0	0
46221622	46221626	0	0
46241468	1129625	0	0
45798540	1119510	0	0
45793508	1177480	0	0
46302126	933724	0	0
46301395	1112807	0	0
46302167	1332419	2	3
4040396	4202451	1	1
21000431	1305058	0	0
21013475	1738521	0	0
21003025	753626	0	0
21601765	1307863	2	2
4092807	4012477	1	1
36246594	40173590	1	2
40779591	3036780	5	5
44338124	1759842	0	0
44356332	1119510	0	0
44360430	1500211	0	0
44340464	40232448	2	3
45640998	1153428	0	0
45621788	738818	0	0
45644089	1125315	0	0
45632789	1125315	0	0
45666380	1119510	0	0
45651690	1115008	0	0
45687248	1307863	0	0
45679675	1589505	0	0
45697921	738818	0	0
45800086	40229134	2	3
45782483	1119510	0	0
45672756	1713332	0	0
45800053	738818	0	0
46221626	46221626	0	0
46241444	1129625	0	0
45798380	1119510	0	0
45793553	1177480	0	0
46302387	1149196	0	0
46301401	975125	0	0
46318059	19079524	2	3
4179141	4035415	1	1
21000450	1500211	0	0
21013433	1778162	0	0
21003024	753626	0	0
21602472	1512674	2	2
4180938	4195803	1	1
36246593	40173590	1	2
40779591	3014599	5	5
44338125	1112807	0	0
44356425	1119510	0	0
44359784	1115008	0	0
44340596	40232448	2	3
45640845	1149196	0	0
45621835	1738521	0	0
45644209	1125315	0	0
45632932	1125315	0	0
45666476	1119510	0	0
45651779	1548195	0	0
45683955	1149380	0	0
45679675	19127890	0	0
45698037	723013	0	0
45800215	19075001	2	3
45782484	1119510	0	0
45672857	1539403	0	0
45800086	738818	0	0
46238178	1332418	0	0
46241635	1129625	0	0
45798659	1119510	0	0
45793687	1177480	0	0
46302389	1174888	0	0
46301354	1112807	0	0
45796907	1332419	2	3
4048365	4052083	1	1
21000471	975125	0	0
21013411	1759842	0	0
21003039	708298	0	0
21602472	1519936	2	2
4141657	4058899	1	1
36226749	40224805	1	2
36603422	40479768	5	5
44338134	1500211	0	0
44356412	1119510	0	0
44360319	967823	0	0
44337353	1115171	2	3
45640962	1539403	0	0
45621838	1310149	0	0
45644171	1125315	0	0
45632941	1125315	0	0
45666477	1119510	0	0
45651569	1192710	0	0
45683959	1309944	0	0
45679675	1549786	0	0
45698073	1549786	0	0
45800221	1115171	2	3
45782673	1119510	0	0
45672942	1545958	0	0
45799984	738818	0	0
46238182	1192710	0	0
46241578	1129625	0	0
45798616	1119510	0	0
45793786	1177480	0	0
46302395	738818	0	0
46301320	1551099	0	0
46240037	1545959	2	3
4043160	4199276	1	1
21000702	1539403	0	0
21013486	1129625	0	0
21003025	914335	0	0
21602472	1589505	2	2
4143250	4285898	1	1
36226749	40224132	1	2
36603422	40479422	5	5
44338135	1000560	0	0
44356416	1119510	0	0
44360359	1129625	0	0
44337330	40222846	2	3
45640877	967823	0	0
45621794	708298	0	0
45644428	1125315	0	0
45632869	1125315	0	0
45666521	1119510	0	0
45648176	1115008	0	0
45683912	1000560	0	0
45679503	1149196	0	0
45698073	1521369	0	0
45800282	1539411	2	3
45782610	1119510	0	0
45672734	1174888	0	0
45800095	738818	0	0
46238184	742185	0	0
46241598	1129625	0	0
45798360	1119510	0	0
45793643	1177480	0	0
46302225	1308738	0	0
46301303	1112807	0	0
45794333	1539411	2	3
4043160	4059978	1	1
21000702	1332418	0	0
21013433	1738521	0	0
21003079	1102527	0	0
21602514	1549786	2	2
4328798	4151422	1	1
36244815	44816277	1	2
37522193	4107731	5	5
44338269	1112807	0	0
44356489	1119510	0	0
44360360	1149380	0	0
44337332	40232448	2	3
45640878	1361711	0	0
45621806	1551099	0	0
45644433	1125315	0	0
45632844	1125315	0	0
45663821	1119510	0	0
45648178	1154029	0	0
45684122	1549786	0	0
45679511	740275	0	0
45697884	1174888	0	0
45800354	19008572	2	3
45782618	1119510	0	0
45672736	1115008	0	0
45685684	738818	0	0
45798316	1149196	0	0
46241610	1129625	0	0
45798759	1119510	0	0
45788461	1177480	0	0
46302229	1110410	0	0
46301364	1110410	0	0
46303440	42902245	2	2
4047779	4285898	7	10
21000640	1521369	0	0
21013489	1343916	0	0
21003056	1129625	0	0
21602514	1548195	2	2
4267432	439777	1	1
36246159	43012433	1	2
36702239	378419	5	5
44338194	1551099	0	0
44356574	1119510	0	0
44360240	1738521	0	0
45620321	19008572	2	3
45640976	1729720	0	0
45621807	1118084	0	0
45644303	1125315	0	0
45632771	1125315	0	0
45663971	1119510	0	0
45648183	1000560	0	0
45684122	19127890	0	0
45679426	1000560	0	0
45697989	1107830	0	0
45685900	1154615	2	3
45702533	1119510	0	0
45672771	723013	0	0
45685383	738818	0	0
45798528	1501700	0	0
46241526	1129625	0	0
45798556	1119510	0	0
45788459	1177480	0	0
46302233	1549786	0	0
46301506	1118084	0	0
46301618	19128009	2	2
4047779	4043241	7	10
21000640	1503184	0	0
21013490	1343916	0	0
21003063	1129625	0	0
35508581	42902245	2	2
4269879	4168004	1	1
36246160	43012433	1	2
37303790	4296204	5	5
44337774	1149380	0	0
44349208	1119510	0	0
44359788	1129625	0	0
45620271	19075601	2	3
45640989	19010482	0	0
45621720	19127890	0	0
45644396	1125315	0	0
45632856	1125315	0	0
45664078	1119510	0	0
45648185	1124957	0	0
45684123	1548195	0	0
45679434	1307863	0	0
45697990	1149380	0	0
45685508	40163554	2	3
45702716	1119510	0	0
45672979	1115008	0	0
45799949	738818	0	0
45798320	1738521	0	0
46238757	1129625	0	0
45798364	1119510	0	0
45788475	1177480	0	0
46302233	19127890	0	0
46301507	1713332	0	0
46301618	19127918	2	2
4029205	4198190	7	9
21000640	1595799	0	0
21002747	975125	0	0
21003063	1125315	0	0
21601766	1307863	2	2
4226399	313217	1	1
36227103	40165015	1	2
37320089	133834	5	5
44337943	1149380	0	0
44349172	1119510	0	0
44359791	1192710	0	0
45620187	19133768	2	3
45641070	1149196	0	0
45621720	1549786	0	0
45644515	1125315	0	0
45632857	1125315	0	0
45663997	1119510	0	0
45648187	1343916	0	0
45684124	975125	0	0
45677139	1115008	0	0
45697934	1551099	0	0
45685684	40229134	2	3
45702741	1119510	0	0
45672982	1124957	0	0
45799720	738818	0	0
45798325	1107830	0	0
46238819	1129625	0	0
45798365	1119510	0	0
45788573	1177480	0	0
46302233	1512674	0	0
46301418	975125	0	0
500002101	4296205	2	2
4180628	4230399	7	8
21000640	19127890	0	0
21002781	19010482	0	0
21003063	1177480	0	0
21601766	40171902	2	2
21505865	705944	1	1
36226711	782047	1	2
36703532	4029498	5	5
44337985	740275	0	0
44349408	1119510	0	0
44360243	1115008	0	0
45620137	19008572	2	3
45640630	967823	0	0
45620606	1124300	0	0
45641431	1125315	0	0
45632644	1125315	0	0
45664176	1119510	0	0
45648295	1154343	0	0
45684126	1551099	0	0
45677186	1115008	0	0
45698051	1153428	0	0
45685318	40223768	2	3
45702689	1119510	0	0
45672992	975125	0	0
45794918	738818	0	0
45798493	1174888	0	0
46240057	1129625	0	0
45793174	1119510	0	0
45788688	1177480	0	0
46302446	1738521	0	0
46301440	1539403	0	0
500002101	4299128	2	2
4178818	258780	7	7
21000669	1308738	0	0
21002783	1305058	0	0
21003027	791967	0	0
21602728	975125	2	2
21503005	738818	1	1
36248905	46221626	1	2
36702242	4132546	5	5
44337986	1129625	0	0
44349352	1119510	0	0
44359936	738818	0	0
45620448	19023398	2	3
45640635	1549786	0	0
45620578	1124957	0	0
45641530	1125315	0	0
45632958	1125315	0	0
45664043	1119510	0	0
45648296	1000560	0	0
45684127	738818	0	0
45677173	1000560	0	0
45698064	914335	0	0
45685319	1115171	2	3
45702651	1119510	0	0
45672793	1305058	0	0
45679119	738818	0	0
45798242	1557272	0	0
45897645	1129625	0	0
45793177	1119510	0	0
45788628	1177480	0	0
46302450	1551099	0	0
46301237	975125	0	0
46308809	19127918	2	2
4117930	258780	7	7
21000702	1545958	0	0
21002791	1759842	0	0
21003038	723013	0	0
21602728	1551099	2	2
21502749	1589505	1	1
36244985	19125062	1	2
36919117	4043241	5	5
44337991	1177480	0	0
44349601	1119510	0	0
44359938	738818	0	0
45620370	40224805	2	3
45640635	19127890	0	0
45620583	1115008	0	0
45641492	1125315	0	0
45630938	1125315	0	0
45664108	1119510	0	0
45648302	1149196	0	0
45684043	1545958	0	0
45677158	1713332	0	0
45697906	1154343	0	0
45685417	1127433	2	3
45702652	1119510	0	0
45672760	1539403	0	0
45679449	738818	0	0
45798453	975125	0	0
45897697	1129625	0	0
45793192	1119510	0	0
46301431	1177480	0	0
46302465	1322184	0	0
46301329	1174888	0	0
46308809	19128009	2	2
4117930	198809	7	7
19059528	19059528	0	0
21002791	1778162	0	0
21003079	1124957	0	0
21602753	40174880	2	2
21502749	975125	1	1
36248622	45892894	1	2
36902280	440086	5	5
44338199	1177480	0	0
44350015	1119510	0	0
44360303	1729720	0	0
45620373	40232448	2	3
45640635	1589505	0	0
45620566	1305058	0	0
45641460	1125315	0	0
45630941	1125315	0	0
45664139	1119510	0	0
45649185	1308738	0	0
45683987	1153428	0	0
45677158	1759842	0	0
45698017	1310149	0	0
45685261	19059056	2	3
45702546	1119510	0	0
45672828	1000560	0	0
45792061	738818	0	0
45798655	1154343	0	0
45897744	1129625	0	0
45793194	1119510	0	0
46301330	1177480	0	0
46306891	1174888	0	0
46301713	933724	0	0
46320092	42902245	2	2
4042150	4163971	7	7
19018935	19018935	0	0
21002792	1746114	0	0
21003079	1110410	0	0
21602753	1501700	2	2
4181060	4059978	1	1
36248623	45892894	1	2
37522270	4125906	5	5
44337968	1192710	0	0
44350046	1119510	0	0
44359942	1118084	0	0
44362250	19008572	2	3
45640639	933724	0	0
45620669	975125	0	0
45641589	1125315	0	0
45630948	1125315	0	0
45660747	1119510	0	0
45649228	1539403	0	0
45683993	1332418	0	0
45677188	738818	0	0
45698023	738818	0	0
45685383	40229134	2	3
45702939	1119510	0	0
45672842	1589505	0	0
45792181	738818	0	0
45798658	791967	0	0
45897835	1129625	0	0
45793200	1119510	0	0
46301452	1177480	0	0
46306685	1192710	0	0
46319618	1112807	0	0
46314764	19128009	2	2
4199402	255848	7	7
19019979	19019979	0	0
21002744	1129625	0	0
21003079	1112807	0	0
21603379	1125443	2	2
4181063	30753	1	1
36463118	19128263	1	2
40796128	3024561	5	5
44338202	1177480	0	0
44341801	1119510	0	0
44359949	1545958	0	0
44361983	40228230	2	3
45640645	1124957	0	0
45620693	975125	0	0
45641593	1125315	0	0
45629665	1125315	0	0
45660951	1119510	0	0
45649239	1192710	0	0
45684183	1548195	0	0
45677194	738818	0	0
45698035	1746114	0	0
45800043	40223834	2	3
45702818	1119510	0	0
45672849	1738521	0	0
45792210	738818	0	0
45798661	1154029	0	0
45897821	1129625	0	0
45793481	1119510	0	0
46301489	1177480	0	0
46306809	1717327	0	0
46319259	1501700	0	0
46315314	40223768	2	3
4048384	4168004	7	7
4302207	4302207	0	0
21002796	1746114	0	0
21003079	1177480	0	0
21603396	1174888	2	2
4181063	372328	1	1
36463118	19128022	1	2
40796128	3027970	5	5
44338151	1551099	0	0
44342122	1119510	0	0
44359961	1551099	0	0
44361999	1545959	2	3
45641086	1110410	0	0
45620654	1174888	0	0
45641594	1125315	0	0
45629649	1125315	0	0
45661041	1119510	0	0
45649225	1332418	0	0
45684201	1174888	0	0
45677199	1521369	0	0
45698035	1741122	0	0
45799872	19076374	2	3
45696618	1119510	0	0
45672850	975125	0	0
45792376	738818	0	0
45798667	1310149	0	0
45897915	1129625	0	0
45793434	1119510	0	0
46298141	1177480	0	0
46306322	914335	0	0
46319805	1539403	0	0
46320683	1107882	2	3
4043022	40492359	7	7
4280726	4280726	0	0
21002783	1551099	0	0
21003076	1125315	0	0
21601746	1332418	2	2
4181063	195588	1	1
36303164	4024958	1	4
37502353	4295880	5	5
44337995	1149196	0	0
44341834	1119510	0	0
44360103	1322184	0	0
44362094	19133905	2	3
45641020	1539403	0	0
45620805	1153428	0	0
45641413	1125315	0	0
45629683	1125315	0	0
45658081	1119510	0	0
45649270	1589505	0	0
45683906	19059528	0	0
45677199	19127890	0	0
45698036	1310149	0	0
45799741	1539411	2	3
45682541	1125315	0	0
45672860	1174888	0	0
45789384	738818	0	0
45798603	1501700	0	0
45897770	1129625	0	0
45793445	1119510	0	0
46298522	1177480	0	0
46306256	1124957	0	0
46319697	967823	0	0
46309206	1107882	2	3
4043025	4243062	2	3
4199402	4035415	6	7
21002775	975125	0	0
21003076	1112807	0	0
35200000	317576	3	7
4180941	4163951	1	1
36303164	4015189	1	5
37503887	4163971	5	5
44337996	1557272	0	0
44341805	1119510	0	0
44360306	738818	0	0
44362411	40229134	2	3
45640929	1548195	0	0
45620662	1738521	0	0
45641419	1125315	0	0
45629628	1125315	0	0
45658065	1119510	0	0
45649240	1115008	0	0
45684023	1153428	0	0
45677199	1549786	0	0
45697997	1174888	0	0
45797318	19133905	2	3
45680011	1125315	0	0
45672870	1713332	0	0
45789324	738818	0	0
45798606	1332418	0	0
45897842	1129625	0	0
45793294	1119510	0	0
46289708	1177480	0	0
46306776	1124957	0	0
46319701	1192710	0	0
46327429	1107882	2	3
4043161	4059978	2	3
4199402	4059173	6	7
21002744	1192710	0	0
21003076	1129625	0	0
35202051	313217	5	7
36217029	1713671	1	2
36500000	40480160	4	9
40772948	3015076	5	5
44338098	738818	0	0
44341889	1119510	0	0
44360111	1332418	0	0
44362305	19126352	2	3
45640935	738818	0	0
45620673	1746114	0	0
45641801	1125315	0	0
45629755	1125315	0	0
45658217	1119510	0	0
45649241	1107830	0	0
45684158	1107830	0	0
45677200	1326303	0	0
45698009	1759842	0	0
45797318	19133873	2	3
45680012	1125315	0	0
45672779	1192710	0	0
45786506	738818	0	0
45798330	975125	0	0
45897960	1129625	0	0
45793308	1119510	0	0
46290079	1177480	0	0
46306961	975125	0	0
46319456	1000560	0	0
46301052	1107882	2	3
4042836	4283893	2	3
4199402	381316	6	6
21002804	1746114	0	0
21003076	738818	0	0
21605007	40169281	5	7
36217124	19074843	1	2
36602234	81151	4	7
40772948	3006734	5	5
44362819	1177480	0	0
44341892	1119510	0	0
44360248	1310149	0	0
44362559	19129655	2	3
45641096	1713332	0	0
45620673	1741122	0	0
45641693	1125315	0	0
45629757	1125315	0	0
45658326	1119510	0	0
45648362	1115008	0	0
45684096	975125	0	0
45677295	1738521	0	0
45698009	1713332	0	0
45794821	40231925	2	3
45677545	1125315	0	0
45672770	740275	0	0
45786710	738818	0	0
45798608	1713332	0	0
45897929	1129625	0	0
45793469	1119510	0	0
46289947	1177480	0	0
46306901	1310149	0	0
46319461	1112807	0	0
46301246	1107882	2	3
4180169	195588	2	3
4199402	133834	6	6
21002805	19010482	0	0
21003076	1119510	0	0
21602471	19127904	5	7
36217124	19074841	1	2
36313913	4047491	4	5
40772948	3019406	5	5
44362849	1192710	0	0
44342040	1119510	0	0
44360261	1112807	0	0
44362422	40162522	2	3
45641188	1107830	0	0
45620731	1149196	0	0
45641694	1125315	0	0
45629762	1125315	0	0
45658329	1119510	0	0
45648325	1326303	0	0
45684098	19039298	0	0
45677321	1110410	0	0
45698124	1332418	0	0
45794907	1115171	2	3
45677555	1125315	0	0
45672751	1115008	0	0
45786920	738818	0	0
45798757	1115008	0	0
45895526	1129625	0	0
45794656	1119510	0	0
46290232	1177480	0	0
46306336	1551099	0	0
46319652	1124957	0	0
46313997	1107882	2	3
4108611	4329847	2	3
4199402	40479768	8	9
21002806	1115008	0	0
21003076	1192710	0	0
21602471	40221415	4	7
36217030	1713671	1	2
36303152	4024289	4	5
37109021	4174876	1	1
44362856	1177480	0	0
44341944	1119510	0	0
44360265	1107830	0	0
44362512	1115171	2	3
45641045	1713332	0	0
45620732	1115008	0	0
45641558	1125315	0	0
45629741	1125315	0	0
45654667	1119510	0	0
45648326	967823	0	0
45684099	1343916	0	0
45677302	1115008	0	0
45698127	1115008	0	0
45679272	19008572	2	3
45677561	1125315	0	0
45784493	975125	0	0
45786922	738818	0	0
45798631	1307863	0	0
45895497	1129625	0	0
45787859	1119510	0	0
46289970	1177480	0	0
46302613	1000560	0	0
46319656	1332418	0	0
46311899	1107882	2	3
4040397	4301346	2	3
4199402	198809	8	8
21002805	975125	0	0
21003076	1177480	0	0
21605007	1150771	4	7
36219949	19077344	1	2
36303152	4252419	4	5
36713504	4310024	1	1
44362858	1124300	0	0
44341934	1119510	0	0
44360270	1174888	0	0
44355164	40236446	2	3
45641045	1759842	0	0
45620718	1107830	0	0
45641641	1125315	0	0
45629653	1125315	0	0
45654668	1119510	0	0
45648338	1153428	0	0
45684101	1154343	0	0
45677306	1501700	0	0
45698133	967823	0	0
45679267	40232448	2	3
45677994	1125315	0	0
45784508	19127890	0	0
45786794	738818	0	0
45798852	1521369	0	0
45895552	1129625	0	0
45787862	1119510	0	0
46291822	1177480	0	0
46299726	1396131	0	0
46319659	967823	0	0
46305255	40174880	2	3
442264	4146173	2	3
4199402	4283893	5	7
21002806	1124300	0	0
21003027	708298	0	0
21605007	19112599	4	7
36217056	19073188	1	2
36303152	4243062	4	4
36713625	4146173	1	1
44362873	701322	0	0
44342072	1119510	0	0
44360328	1129625	0	0
44355202	1127433	2	3
45640822	738818	0	0
45620724	738818	0	0
45641545	1125315	0	0
45629705	1125315	0	0
45654614	1119510	0	0
45648438	1192710	0	0
45684206	975125	0	0
45677308	757627	0	0
45698135	1110410	0	0
45679651	40223834	2	3
45677617	1125315	0	0
45784508	1515774	0	0
45786964	738818	0	0
45798852	19127890	0	0
45895566	1129625	0	0
45787878	1119510	0	0
46241902	1177480	0	0
46299832	1539403	0	0
46319682	1738521	0	0
46313857	1107882	2	3
4040576	4117038	2	3
4199402	4156265	5	7
21002806	1177480	0	0
21003044	791967	0	0
21605007	40228230	4	7
36213600	44816277	1	2
36313959	4181917	4	4
36703483	378419	1	1
44362903	738818	0	0
44342073	1119510	0	0
44360339	1107830	0	0
45655537	19008572	2	3
45641106	1174888	0	0
45620850	975125	0	0
45641599	1125315	0	0
45629784	1125315	0	0
45654414	1119510	0	0
45648375	1115008	0	0
45684207	1174888	0	0
45677259	1153428	0	0
45697976	1500211	0	0
45679449	40229134	2	3
45678069	1125315	0	0
45784508	1549786	0	0
45786886	738818	0	0
45798852	1549786	0	0
45895465	1129625	0	0
45788007	1119510	0	0
46241956	1177480	0	0
46299800	738818	0	0
46319696	1738521	0	0
46314408	1332419	2	3
4043016	4059978	2	3
4199402	4132546	5	7
21002805	1112807	0	0
21003042	1154029	0	0
21605007	1107882	4	7
443357	81151	3	3
36313913	4202451	4	4
40798526	3024731	1	1
44362920	1124300	0	0
44342386	1119510	0	0
44360344	1174888	0	0
45655145	40232448	2	3
45637611	1501700	0	0
45620851	1713332	0	0
45641740	1125315	0	0
45629857	1125315	0	0
45655549	1119510	0	0
45648389	1107830	0	0
45684217	738818	0	0
45677190	1174888	0	0
45698149	1545958	0	0
45792058	1115171	2	3
45677894	1125315	0	0
45784521	967823	0	0
45786237	738818	0	0
45798574	1713332	0	0
45679534	1119510	0	0
45787965	1119510	0	0
46242015	1177480	0	0
46299905	1115008	0	0
46319744	1124300	0	0
46300773	1332419	2	3
4027880	81893	2	3
4199402	4296204	5	5
21002805	1551099	0	0
21003042	914335	0	0
21602359	40236824	4	7
4092876	198809	3	3
36502197	80502	5	5
40796605	3028833	1	1
44362923	1192710	0	0
44342351	1119510	0	0
44362697	1713332	0	0
44347517	1127433	2	3
45637575	1174888	0	0
45620851	1759842	0	0
45641613	1125315	0	0
45629793	1125315	0	0
45654762	1119510	0	0
45648522	1501700	0	0
45684293	1778162	0	0
45677220	1107830	0	0
45698182	1115008	0	0
45792062	19019273	2	3
45678015	1125315	0	0
45784529	1174888	0	0
45786427	738818	0	0
45798351	1539403	0	0
45679921	1119510	0	0
45788025	1119510	0	0
46241982	1177480	0	0
46299911	933724	0	0
46322413	1551099	0	0
46322513	19078461	2	3
4154739	4142905	2	3
4199402	134438	4	4
21002783	975125	0	0
21003042	791967	0	0
21602359	1519937	4	7
4092747	4043241	3	3
36313944	42535580	5	5
40796722	3006923	1	1
44362970	1129625	0	0
44342362	1119510	0	0
44362697	1759842	0	0
44347711	1115171	2	3
45637577	1124957	0	0
45620852	914335	0	0
45641618	1125315	0	0
45629800	1125315	0	0
45651367	1119510	0	0
45648529	1548195	0	0
45684237	1589505	0	0
45674056	1192710	0	0
45698282	1149380	0	0
45792249	40232448	2	3
45678032	1125315	0	0
45784585	1192710	0	0
45786575	738818	0	0
45798468	723013	0	0
45679465	1119510	0	0
45788049	1119510	0	0
46242021	1177480	0	0
46299941	975125	0	0
46322563	1000560	0	0
46319697	19079524	2	3
4154739	4237458	2	3
4199402	378419	7	8
21002793	1746114	0	0
21003079	1129625	0	0
35200000	313217	3	8
4144290	4163874	3	3
36602234	4149245	5	5
40796376	3016723	1	1
44362905	1501700	0	0
44342305	1119510	0	0
44362706	1177480	0	0
44347724	40232448	2	3
45637637	1326303	0	0
45620853	1778162	0	0
45641802	1125315	0	0
45630006	1125315	0	0
45651235	1119510	0	0
45648318	975125	0	0
45684238	1115008	0	0
45674078	1174888	0	0
45698282	1137529	0	0
45792395	19078461	2	3
45677835	1125315	0	0
45784542	1307863	0	0
45785578	738818	0	0
45798575	1501700	0	0
45679009	1119510	0	0
45788129	1119510	0	0
46241941	1177480	0	0
46299958	1000560	0	0
46327429	1107830	0	0
46301847	19075601	2	3
4162054	4293740	2	4
4199402	4230399	7	8
21002805	1177480	0	0
21003040	1154029	0	0
35802829	257012	6	8
4056681	4252419	3	3
36303152	4202451	5	5
40796407	3009201	1	1
44362821	1112807	0	0
44337832	1119510	0	0
44362707	1545958	0	0
44347922	40231925	2	3
45637716	1343916	0	0
45620855	1539403	0	0
45641524	1125315	0	0
45629770	1125315	0	0
45651352	1119510	0	0
45648471	967823	0	0
45684239	975125	0	0
45674081	914335	0	0
45698283	1717327	0	0
45792197	19008572	2	3
45677909	1125315	0	0
45784616	1322184	0	0
45785398	738818	0	0
45798584	1738521	0	0
45679086	1119510	0	0
45788134	1119510	0	0
46242429	1177480	0	0
46299870	1192710	0	0
46319864	1332418	0	0
46321014	1332419	2	3
4043017	4010253	2	4
4199402	313217	7	10
21002805	1115008	0	0
21003040	708298	0	0
35202051	257012	5	8
4056681	4024289	3	3
36502196	4048695	5	6
40796508	3006906	1	1
44363011	1124300	0	0
44337680	1119510	0	0
44362502	1759842	0	0
44348322	19019273	2	3
45637729	1154343	0	0
45620727	1545958	0	0
45641771	1125315	0	0
45626839	1125315	0	0
45651390	1119510	0	0
45648321	1107830	0	0
45684240	914335	0	0
45674103	1322184	0	0
45698076	1000560	0	0
45792182	19059056	2	3
45677970	1125315	0	0
45784546	1154343	0	0
45785531	738818	0	0
45798352	1115008	0	0
45678970	1119510	0	0
45788065	1119510	0	0
46242148	1177480	0	0
46299725	1309944	0	0
46320132	1738521	0	0
46306555	19075601	2	3
4179141	81151	2	4
4199402	378001	7	9
21002145	1741122	0	0
21003042	708298	0	0
21602359	40221415	5	8
4130852	81151	3	3
36303152	4047491	5	6
40780206	3020655	1	1
44363014	1115008	0	0
44363688	1119510	0	0
44362632	914335	0	0
44348432	19133873	2	3
45637646	1310149	0	0
45620676	1149196	0	0
45641805	1125315	0	0
45626920	1125315	0	0
45651608	1119510	0	0
45648630	738818	0	0
45684033	1738521	0	0
45673984	1738521	0	0
45698185	1107830	0	0
45792210	40229134	2	3
45677948	1125315	0	0
45784548	1153428	0	0
45785389	738818	0	0
45798720	1548195	0	0
45786031	1119510	0	0
45788240	1119510	0	0
46242196	1177480	0	0
46299745	1115008	0	0
46319954	1154029	0	0
45897073	1545959	2	3
4180169	30753	2	4
4199402	4280726	7	9
21002154	1741122	0	0
21003042	1110410	0	0
21603945	1124300	0	0
4057955	4024958	3	3
36602234	40479422	6	6
40780213	3000876	1	1
44363016	933724	0	0
44363354	1119510	0	0
44362501	1501700	0	0
44348243	1115171	2	3
45637647	1149196	0	0
45620727	1332418	0	0
45641786	1125315	0	0
45626922	1125315	0	0
45651653	1119510	0	0
45648556	1124300	0	0
45684311	708298	0	0
45673990	1192710	0	0
45698188	1153428	0	0
45792384	19023398	2	3
45679563	1125315	0	0
45784558	1551099	0	0
45783410	738818	0	0
45798725	1153428	0	0
45786544	1119510	0	0
45788070	1119510	0	0
46241928	1177480	0	0
46299820	1174888	0	0
46320157	1521369	0	0
45803875	1332419	2	3
4180169	4283893	2	5
4301351	4336464	5	9
21002154	1746114	0	0
21003026	1343916	0	0
21603453	738818	0	0
4201745	192671	3	3
36602234	40479768	6	6
40780242	3012494	1	1
44363019	1713332	0	0
44363812	1119510	0	0
44362502	1713332	0	0
44341330	19019273	2	3
45637598	1124300	0	0
45620728	1539403	0	0
45638373	1125315	0	0
45626702	1125315	0	0
45651667	1119510	0	0
45648644	1539403	0	0
45684287	1308738	0	0
45674247	1332418	0	0
45698211	1124300	0	0
45792391	1115171	2	3
45679622	1125315	0	0
45784679	1332418	0	0
45783326	738818	0	0
45798441	791967	0	0
45786561	1119510	0	0
45788093	1119510	0	0
45893691	1177480	0	0
46299822	1713332	0	0
46320161	1713332	0	0
46304338	1125315	0	0
4134423	4186930	2	5
4301351	4125906	5	5
21002222	1717327	0	0
21003069	1119510	0	0
21603462	1192710	0	0
4227253	30753	3	3
36502196	4278672	6	6
40780092	3024561	1	1
44362931	1115008	0	0
44363817	1119510	0	0
44362814	1729720	0	0
44340671	42707627	2	3
45637668	1308738	0	0
45620711	1343916	0	0
45638427	1125315	0	0
45626699	1125315	0	0
45651269	1119510	0	0
45648647	975125	0	0
45684129	1310149	0	0
45674068	1501700	0	0
45698215	738818	0	0
45676046	40228214	2	3
45674591	1125315	0	0
45784632	1713332	0	0
45783449	738818	0	0
45798561	1124957	0	0
45786368	1119510	0	0
46293850	1119510	0	0
45893765	1177480	0	0
46299822	1759842	0	0
46320161	1759842	0	0
46320119	1125315	0	0
4027384	257012	2	7
4301351	4330583	5	8
21002136	1741122	0	0
21003069	1115008	0	0
21603525	1153428	0	0
4227253	261325	3	3
36303152	42535580	6	6
40780881	3045716	1	1
44363041	1129625	0	0
44363831	1119510	0	0
44362506	1177480	0	0
44340778	19133873	2	3
45637642	1309944	0	0
45620856	1759842	0	0
45638212	1125315	0	0
45626971	1125315	0	0
45651681	1119510	0	0
45648714	1174888	0	0
45684131	1713332	0	0
45674218	1551099	0	0
45698119	1539403	0	0
45675957	1127433	2	3
45674605	1125315	0	0
45784692	1174888	0	0
45783368	738818	0	0
45798758	1110410	0	0
45786386	1119510	0	0
46294030	1119510	0	0
45893835	1177480	0	0
46299690	1124957	0	0
46319973	1551099	0	0
46320124	1125315	0	0
4038677	4310024	2	2
4301351	4242997	5	6
21002137	1741122	0	0
21003069	1177480	0	0
21603512	1150770	0	0
4141937	4337611	3	3
36500000	4155034	8	8
40782260	3036780	1	1
44362933	1545958	0	0
44363924	1119510	0	0
44362519	1000560	0	0
44340936	46275916	2	3
45637740	1332418	0	0
45620856	1713332	0	0
45638391	1125315	0	0
45626819	1125315	0	0
45651569	1119510	0	0
45648657	1307863	0	0
45684133	975125	0	0
45674219	1124300	0	0
45648931	1332418	0	0
45675972	1545959	2	3
45674625	1125315	0	0
45784706	1000560	0	0
45783516	738818	0	0
45798763	975125	0	0
45786383	1119510	0	0
46294130	1119510	0	0
45893803	1177480	0	0
46299691	1107830	0	0
46320199	1307863	0	0
46320183	1125315	0	0
4040560	4242997	2	2
4301351	4198190	6	8
21001840	1778162	0	0
21003069	1112807	0	0
21603288	1149380	0	0
36158237	1119510	0	0
36302170	4037675	8	8
40782474	3005136	1	1
44362958	1129625	0	0
44364003	1119510	0	0
44362523	1174888	0	0
44340937	19073183	2	3
45637844	967823	0	0
45661595	975125	0	0
45639955	1125315	0	0
45626801	1125315	0	0
45651570	1119510	0	0
45648575	1149196	0	0
45684283	1549786	0	0
45673742	1307863	0	0
45648933	1549786	0	0
45676078	43012036	2	3
45674689	1125315	0	0
45784798	1107830	0	0
46291583	738818	0	0
45798771	1728416	0	0
45786158	1119510	0	0
46293884	1119510	0	0
45893826	1177480	0	0
46299703	1149196	0	0
46320219	1153428	0	0
46320454	1125315	0	0
4040562	4198190	2	2
4301351	4057420	4	7
21001841	1778162	0	0
21003042	753626	0	0
21603266	1137529	0	0
36158237	738818	0	0
36302170	4035415	7	11
40654442	3028833	1	1
44363048	1310149	0	0
44363509	1119510	0	0
44362524	1107830	0	0
44340904	19019273	2	3
45637648	1124957	0	0
45661600	1728416	0	0
45640036	1125315	0	0
45626957	1125315	0	0
45651572	1119510	0	0
45648663	1153428	0	0
45684283	19127890	0	0
45673746	1192710	0	0
45648933	1521369	0	0
45676351	40174880	2	3
45674693	1125315	0	0
45784632	1759842	0	0
46291678	738818	0	0
45798824	1521369	0	0
45786160	1119510	0	0
46293543	1119510	0	0
45893837	1177480	0	0
46299785	1595799	0	0
46320222	1361711	0	0
46320363	1125315	0	0
4150819	4336464	2	2
4301351	4337611	4	5
21001839	1778162	0	0
21003079	1124300	0	0
21602517	1548195	0	0
36158241	1107830	0	0
36502196	4134304	8	8
40654504	3006906	1	1
44363019	1759842	0	0
44363577	1119510	0	0
44362607	1129625	0	0
44340849	1115171	2	3
45637651	1154343	0	0
45661603	967823	0	0
45638535	1125315	0	0
45626930	1125315	0	0
45648298	1119510	0	0
45645066	740275	0	0
45684356	738818	0	0
45673746	1174888	0	0
45648939	1308738	0	0
45789123	920300	2	3
45674699	1125315	0	0
45784622	1309944	0	0
46291715	738818	0	0
45798824	1548195	0	0
45786122	1119510	0	0
46294064	1119510	0	0
45893834	1177480	0	0
46299967	715997	0	0
46320233	1112807	0	0
46320366	1125315	0	0
4065001	4314290	2	2
4301351	44783196	4	5
21001840	1713332	0	0
21003099	791967	0	0
21602516	1549786	0	0
36158171	1515774	0	0
36602234	78272	8	8
40654685	3016723	1	1
44363126	738818	0	0
44363992	1119510	0	0
44362729	701322	0	0
44340891	1115171	2	3
45637862	1332418	0	0
45661732	1548195	0	0
45638466	1125315	0	0
45626931	1125315	0	0
45649239	1119510	0	0
45645385	1149196	0	0
45684358	1361711	0	0
45674221	19016749	0	0
45648769	1501700	0	0
45789379	40162522	2	3
45674538	1125315	0	0
45784787	1149196	0	0
46242680	738818	0	0
45798919	1713332	0	0
45786183	1119510	0	0
46294034	1119510	0	0
45801852	1177480	0	0
46300027	738818	0	0
46320130	1110410	0	0
46320488	1125315	0	0
4070456	4218408	2	2
4301351	4301346	4	5
21001842	1713332	0	0
21003069	1129625	0	0
21602540	1500211	0	0
36158171	19127890	0	0
36502196	4230399	7	7
40766216	3012494	1	1
44362978	723013	0	0
44363624	1119510	0	0
44362732	1124957	0	0
45637384	1127433	2	3
45637657	1307863	0	0
45661703	975125	0	0
45638467	1125315	0	0
45626853	1125315	0	0
45648438	1119510	0	0
45645329	1343916	0	0
45684361	1107830	0	0
45674086	1539403	0	0
45694959	1149196	0	0
45789390	40228214	2	3
45674541	1125315	0	0
45784634	1343916	0	0
46242773	738818	0	0
45798919	1759842	0	0
46292667	1119510	0	0
46294396	1119510	0	0
45801848	1177480	0	0
46300085	1174888	0	0
46320108	1154029	0	0
46320377	1125315	0	0
4063381	261325	2	2
4301351	4337138	3	4
21001840	1759842	0	0
21003081	1124957	0	0
21602102	975125	0	0
36158171	1549786	0	0
36402189	4144583	7	7
40766216	3006451	1	1
44363023	1307863	0	0
44363495	1119510	0	0
44362734	1332418	0	0
45637365	1539411	2	3
45637807	1501700	0	0
45661430	975125	0	0
45638528	1125315	0	0
45628031	1125315	0	0
45648630	1119510	0	0
45645269	1361711	0	0
45684368	1124957	0	0
45674000	1115008	0	0
45694825	1154343	0	0
45789324	40229134	2	3
45674957	1125315	0	0
45784596	1192710	0	0
46242804	738818	0	0
45798920	1107830	0	0
46292488	1119510	0	0
46294075	1119510	0	0
45802421	1177480	0	0
46300087	1551099	0	0
46320118	1124957	0	0
46320333	1125315	0	0
4187096	4230399	2	2
4244662	80180	2	2
21001840	1768849	0	0
21003081	1125315	0	0
21602136	1149380	0	0
36158174	1177480	0	0
36424251	1326303	0	0
40249018	19074679	1	1
44359235	1149380	0	0
44363609	1119510	0	0
44360439	1515774	0	0
45637355	40232448	2	3
45637741	1521369	0	0
45661708	723013	0	0
45638574	1125315	0	0
45628122	1125315	0	0
45648636	1119510	0	0
45645271	975125	0	0
45684252	1343916	0	0
45674226	738818	0	0
45695024	1000560	0	0
45777979	1367571	0	0
45674958	1125315	0	0
45784638	1107830	0	0
46242816	738818	0	0
45798921	1000560	0	0
46292575	1119510	0	0
46294475	1119510	0	0
45799139	1177480	0	0
46300089	1192710	0	0
46319905	1112807	0	0
46320592	1125315	0	0
4185284	4202451	2	2
4303053	4301346	2	2
21001846	1759842	0	0
21003081	1118084	0	0
35508516	1738521	0	0
36158175	975125	0	0
36423360	740275	0	0
40181758	40221415	1	1
44359242	920293	0	0
44356506	1119510	0	0
44360439	1549786	0	0
45621792	40232448	2	3
45637741	1549786	0	0
45661824	1545958	0	0
45638630	1125315	0	0
45628244	1125315	0	0
45645050	1119510	0	0
45645272	19127890	0	0
45684300	715997	0	0
45674228	738818	0	0
45694994	1521369	0	0
45777932	1192710	0	0
45674754	1125315	0	0
45784817	1154343	0	0
46240780	738818	0	0
45798558	1118084	0	0
46292797	1119510	0	0
46294153	1119510	0	0
45799072	1177480	0	0
46300095	1713332	0	0
46320147	1124957	0	0
46320551	1125315	0	0
4155030	4156265	2	2
4241075	4293740	2	2
21001839	1768849	0	0
21003053	791967	0	0
35508517	1713332	0	0
36157773	1177480	0	0
36416757	1154029	0	0
40181782	40221415	1	1
44359243	1129625	0	0
44356538	1119510	0	0
44360481	1129625	0	0
45621794	19078924	2	3
45637687	738818	0	0
45661433	1310149	0	0
45638604	1125315	0	0
45628210	1125315	0	0
45645434	1119510	0	0
45645272	1549786	0	0
45680883	1713332	0	0
45674229	920293	0	0
45694994	19127890	0	0
45777915	738818	0	0
45674640	1125315	0	0
45784665	1174888	0	0
46240720	738818	0	0
45798740	1322184	0	0
46293071	1119510	0	0
46294155	1119510	0	0
45799104	1177480	0	0
46300220	1153428	0	0
46320149	1000560	0	0
46320650	1125315	0	0
4115236	4294548	2	2
4327941	4043071	2	2
21001846	1713332	0	0
21003069	738818	0	0
35508518	1124300	0	0
36158124	1107830	0	0
36416791	708298	0	0
40181784	40221415	1	1
44359251	1115008	0	0
44356505	1119510	0	0
44360548	1545958	0	0
45620583	1115171	2	3
45637865	1110410	0	0
45661516	1192710	0	0
45638505	1125315	0	0
45628225	1125315	0	0
45645556	1119510	0	0
45645276	1107830	0	0
45680884	975125	0	0
45674230	1717327	0	0
45694994	1549786	0	0
45777943	1149196	0	0
45674646	1125315	0	0
45784912	967823	0	0
46272569	40492359	3	3
45798574	1759842	0	0
46292507	1119510	0	0
46294301	1119510	0	0
45799300	1177480	0	0
46300232	1107830	0	0
46320151	1149196	0	0
46320800	1125315	0	0
4125928	4108705	2	2
4307254	4230399	2	2
21001849	1759842	0	0
21003099	723013	0	0
35508618	1309944	0	0
36158073	1112807	0	0
36429708	1307863	0	0
40220385	40220386	1	1
44362605	1124957	0	0
44356740	1119510	0	0
44360440	975125	0	0
45620586	40232448	2	3
45637798	1124957	0	0
45661519	738818	0	0
45638582	1125315	0	0
45627062	1125315	0	0
45645463	1119510	0	0
45645048	1149196	0	0
45680886	1107830	0	0
45673981	1192710	0	0
45694562	1124300	0	0
45777903	738818	0	0
45674987	1125315	0	0
45784823	914335	0	0
46240186	19128022	3	4
45798687	1115008	0	0
46293009	1119510	0	0
46294485	1119510	0	0
45799432	1177480	0	0
46300235	914335	0	0
46313774	1112807	0	0
46320410	1125315	0	0
4074722	4107731	2	2
4283893	4294548	2	2
21001842	1759842	0	0
21003069	1192710	0	0
35508633	1545958	0	0
36157967	1129625	0	0
36427078	1361711	0	0
40165009	40165015	1	1
44362548	738818	0	0
44356741	1119510	0	0
44360557	1124957	0	0
45620570	19059056	2	3
45637767	1500211	0	0
45661944	1551099	0	0
45638628	1125315	0	0
45627079	1125315	0	0
45645134	1119510	0	0
45645145	1174888	0	0
45698764	1192710	0	0
45674114	1310149	0	0
45694964	1110410	0	0
45777876	1307863	0	0
45674784	1125315	0	0
45784834	1539403	0	0
45697433	19127904	3	4
45798774	1000560	0	0
46293047	1119510	0	0
46294488	1119510	0	0
45799410	1177480	0	0
46300061	1115008	0	0
46313774	1124957	0	0
46320411	1125315	0	0
4074298	4186930	2	2
4353828	317576	2	2
21001849	1778162	0	0
21003069	1125315	0	0
35508640	1129625	0	0
36157971	1118084	0	0
36427086	1308738	0	0
40102982	920334	1	1
44362653	1551099	0	0
44356624	1119510	0	0
44353463	1192710	0	0
45620732	1115171	2	3
45637781	1521369	0	0
45661947	914335	0	0
45638683	1125315	0	0
45623763	1125315	0	0
45645510	1119510	0	0
45645433	967823	0	0
45698733	1192710	0	0
45674232	1551099	0	0
45694596	1310149	0	0
45777879	1713332	0	0
45674786	1125315	0	0
45784715	1549786	0	0
45802402	19129144	3	4
45793176	1124957	0	0
46292657	1119510	0	0
46294214	1119510	0	0
45793933	1177480	0	0
46300103	1107830	0	0
46313780	1332418	0	0
46320434	1125315	0	0
4073634	4107731	2	2
4303802	438614	2	2
21001846	1778162	0	0
21003108	19003953	0	0
35508640	1115008	0	0
36157857	1177480	0	0
36427076	920293	0	0
40128143	40229134	1	1
44362656	914335	0	0
44356672	1119510	0	0
44353463	1174888	0	0
45620673	46275444	2	3
45637892	1115008	0	0
45661854	1713332	0	0
45635455	1125315	0	0
45623721	1125315	0	0
45645520	1119510	0	0
45645434	1192710	0	0
45698738	1192710	0	0
45673755	740275	0	0
45695049	1332418	0	0
45777880	1717327	0	0
45674955	1125315	0	0
45784715	1521369	0	0
45786850	19133679	3	4
45793269	975125	0	0
46292961	1119510	0	0
46294234	1119510	0	0
45794032	1177480	0	0
46300002	975125	0	0
46313807	1124300	0	0
46320867	1125315	0	0
4085100	4112343	2	2
4303802	442116	2	2
21001846	1717327	0	0
21003110	19003953	0	0
35508642	1119510	0	0
36157858	1112807	0	0
36424660	1548195	0	0
40061664	40165015	1	1
44362578	1332418	0	0
44356662	1119510	0	0
44353471	1343916	0	0
45620701	1127433	2	3
45637993	715997	0	0
45661746	975125	0	0
45635251	1125315	0	0
45623816	1125315	0	0
45642454	1119510	0	0
45645246	1521369	0	0
45695465	1192710	0	0
45673771	1501700	0	0
45694635	1539403	0	0
45778010	1539403	0	0
45674633	1125315	0	0
45784716	1153428	0	0
45876037	3014576	3	6
46240961	1129625	0	0
46293194	1119510	0	0
46294563	1119510	0	0
45789340	1177480	0	0
46300111	738818	0	0
46314344	1149196	0	0
46320662	1125315	0	0
4073287	4056621	2	2
4303802	4169137	2	2
21001850	1778162	0	0
21003079	1174888	0	0
35508648	1308738	0	0
36157865	920293	0	0
36463106	1149196	0	0
40021194	19074679	1	1
44362759	1000560	0	0
44356722	1119510	0	0
44353588	1115008	0	0
45620850	19008572	2	3
45637794	933724	0	0
45661856	967823	0	0
45635339	1125315	0	0
45623928	1125315	0	0
45642569	1119510	0	0
45645246	1595799	0	0
45692480	1192710	0	0
45673774	1174888	0	0
45695113	1361711	0	0
45707779	914335	0	0
45674970	1125315	0	0
45784722	1713332	0	0
45876037	3045716	3	6
46240753	1129625	0	0
46293210	1119510	0	0
46294439	1119510	0	0
45789397	1177480	0	0
46300112	723013	0	0
46314345	933724	0	0
46320918	1125315	0	0
4154162	4218389	2	2
4303802	4139681	2	2
21001850	1717327	0	0
21003081	1177480	0	0
35508890	1125315	0	0
36157972	967823	0	0
36463107	1713332	0	0
40021195	19074679	1	1
44362776	1713332	0	0
44356970	1119510	0	0
44353592	1124300	0	0
45661569	1115171	2	3
45637904	1115008	0	0
45661527	1500211	0	0
45635435	1125315	0	0
45623822	1125315	0	0
45642552	1119510	0	0
45645246	1549786	0	0
45692430	1192710	0	0
45674233	967823	0	0
45695124	1115008	0	0
45707835	1174888	0	0
45674976	1125315	0	0
45784722	1759842	0	0
45876037	3019550	3	6
46241094	1129625	0	0
46292768	1119510	0	0
46293974	1119510	0	0
45788790	1177480	0	0
46300130	1153428	0	0
46313808	1149196	0	0
46320631	1125315	0	0
4074287	4117038	2	2
19091065	19128009	2	2
21001849	1717327	0	0
21003081	1110410	0	0
35508891	1713332	0	0
36157976	1115008	0	0
36463112	1119510	0	0
37503938	4059978	1	1
44362616	914335	0	0
44356999	1119510	0	0
44353478	1332418	0	0
45662007	40236824	2	3
45637909	738818	0	0
45661569	1115008	0	0
45635402	1125315	0	0
45624068	1125315	0	0
45642559	1119510	0	0
45645258	1174888	0	0
45692729	1192710	0	0
45674234	1307863	0	0
45694799	967823	0	0
45707838	1521369	0	0
45674977	1125315	0	0
45784915	975125	0	0
45876037	3013721	3	5
46241033	1129625	0	0
46293333	1119510	0	0
46294453	1119510	0	0
45788784	1177480	0	0
46300145	933724	0	0
46313830	1192710	0	0
46320632	1125315	0	0
4186164	4278672	2	2
4242290	81151	2	2
21001860	1343916	0	0
21003082	1125315	0	0
35508586	1738521	0	0
36157977	1119510	0	0
36463118	1549786	0	0
37203741	441267	1	1
44362617	1521369	0	0
44357094	1119510	0	0
44353594	1153428	0	0
45661561	19019273	2	3
45637967	1545958	0	0
45661879	1124957	0	0
45635289	1125315	0	0
45624070	1125315	0	0
45642632	1119510	0	0
45645417	723013	0	0
45692519	1192710	0	0
45674274	1107830	0	0
45695104	738818	0	0
45707838	1595799	0	0
45674879	1125315	0	0
45784772	1174888	0	0
45876037	3015632	3	6
46240851	1129625	0	0
46293398	1119510	0	0
46294388	1119510	0	0
45788834	1177480	0	0
46300260	708298	0	0
46313837	19003953	0	0
46320879	1125315	0	0
4027880	4285898	2	2
4208786	80502	2	2
21600192	914335	0	0
21003081	1124300	0	0
35508397	1115008	0	0
36157977	738818	0	0
36463118	1515774	0	0
37203741	317009	1	1
44359387	1551099	0	0
44357046	1119510	0	0
44353432	1746114	0	0
45662002	19008572	2	3
45637968	1149196	0	0
45661884	1153428	0	0
45635247	1125315	0	0
45624074	1125315	0	0
45640051	1119510	0	0
45645556	738818	0	0
45692445	1192710	0	0
45674239	1551099	0	0
45695106	1500211	0	0
45707838	1549786	0	0
45674887	1125315	0	0
45784924	1310149	0	0
45876037	3006923	3	5
46238192	1129625	0	0
46292888	1119510	0	0
46243710	1119510	0	0
45788881	1177480	0	0
46300268	1153428	0	0
46313719	1174888	0	0
46315054	1125315	0	0
4027717	4238715	2	2
4207185	4294548	2	2
21600234	1326303	0	0
21003081	1154029	0	0
35508786	1539403	0	0
36157869	1149196	0	0
36427229	1000560	0	0
37203747	261325	1	1
44359393	791967	0	0
44357104	1119510	0	0
44353432	1741122	0	0
45661982	40231925	2	3
45638032	1713332	0	0
45661532	738818	0	0
45635449	1125315	0	0
45623843	1125315	0	0
45639476	1119510	0	0
45645239	1107830	0	0
45692604	1192710	0	0
45674310	967823	0	0
45695077	1149196	0	0
45707810	1000560	0	0
45674666	1125315	0	0
45784764	975125	0	0
45876037	3006906	3	5
46240207	1129625	0	0
46287955	1119510	0	0
46243663	1119510	0	0
46295416	1177480	0	0
46300401	1589505	0	0
46313731	1326303	0	0
46314285	1125315	0	0
4093991	4280726	4	5
4329725	4337138	2	2
21503162	1129625	0	0
21600493	1000560	0	0
35508399	1118084	0	0
36158001	701322	0	0
36427091	1521369	0	0
37003672	198199	1	1
44359421	742185	0	0
44357024	1119510	0	0
44353439	1500211	0	0
45664310	42707627	2	3
45638032	1759842	0	0
45661534	1107830	0	0
45635267	1125315	0	0
45623773	1125315	0	0
45639450	1119510	0	0
45645563	1174888	0	0
45692550	1192710	0	0
45674269	1153428	0	0
45695080	1738521	0	0
45707758	1118084	0	0
45674668	1125315	0	0
45784766	1174888	0	0
45876037	3024561	3	5
46238225	1129625	0	0
46288317	1119510	0	0
46243667	1119510	0	0
46244274	1177480	0	0
46300172	1713332	0	0
46314094	1112807	0	0
46313873	1125315	0	0
4093991	40486433	4	5
4251030	4047491	2	2
21503163	1149196	0	0
21501130	1759842	0	0
35508741	1500211	0	0
36158009	967823	0	0
36427297	1124957	0	0
37017419	4336464	1	1
44359364	1177480	0	0
44357191	1119510	0	0
44353548	1500211	0	0
45658205	19008572	2	3
45637992	1713332	0	0
45662007	933724	0	0
45635521	1125315	0	0
45623922	1125315	0	0
45639738	1119510	0	0
45645440	708298	0	0
45692703	1192710	0	0
45674258	1174888	0	0
45695054	1343916	0	0
45707778	1174888	0	0
45674768	1125315	0	0
45784734	1729720	0	0
45876037	3027970	3	5
45897256	1129625	0	0
46288476	1119510	0	0
46243864	1119510	0	0
46244430	1177480	0	0
46300174	1115008	0	0
46314095	1000560	0	0
46314894	1125315	0	0
4093991	134438	4	5
21001382	19133905	2	3
21503194	914335	0	0
21602842	1729720	0	0
35508745	1115008	0	0
21604344	1125315	0	0
36427387	926487	0	0
36718163	378419	1	1
44359444	1107830	0	0
44350113	1119510	0	0
44353551	1521369	0	0
45655882	19078924	2	3
45634686	1107830	0	0
45662008	1308738	0	0
45635533	1125315	0	0
45623682	1125315	0	0
45639524	1119510	0	0
45645125	1174888	0	0
45692669	1192710	0	0
45673639	1153428	0	0
45695085	1149196	0	0
45707801	1501700	0	0
45675084	1125315	0	0
45784934	1738521	0	0
45876037	3004501	3	5
45897185	1129625	0	0
46288477	1119510	0	0
46243891	1119510	0	0
46244518	1177480	0	0
46299853	1124300	0	0
46314122	1305058	0	0
46314896	1125315	0	0
4180627	4181917	4	5
21001034	19129655	2	3
21503163	1107830	0	0
21602831	1746114	0	0
35508755	1343916	0	0
36156768	1125315	0	0
36424688	1549786	0	0
36718526	4029498	1	1
44359432	1539403	0	0
44349644	1119510	0	0
44353648	1129625	0	0
45655669	19059056	2	3
45634690	933724	0	0
45661561	1115008	0	0
45635413	1125315	0	0
45624090	1125315	0	0
45639679	1119510	0	0
45645459	1310149	0	0
45692672	1192710	0	0
45674337	1154029	0	0
45694820	1000560	0	0
45707813	1548195	0	0
45675168	1125315	0	0
45782654	1307863	0	0
45876037	3020630	3	5
45897348	1129625	0	0
46288022	1119510	0	0
46243674	1119510	0	0
45787392	1129625	0	0
46300151	705944	0	0
46313838	1112807	0	0
46314899	1125315	0	0
4180627	4243062	4	5
21000108	19129655	2	3
21503163	1150836	0	0
21603256	1154343	0	0
35508762	1125315	0	0
36156772	1125315	0	0
36424689	1549786	0	0
40220958	40220960	1	1
44359368	1729720	0	0
44349782	1119510	0	0
44353651	1129625	0	0
45655802	19078924	2	3
45634657	1717327	0	0
45661690	1110410	0	0
45635595	1125315	0	0
45623792	1125315	0	0
45636361	1119510	0	0
45645550	1717327	0	0
45689587	1192710	0	0
45674345	1154029	0	0
45694924	1343916	0	0
45707824	967823	0	0
45674914	1125315	0	0
45782401	1367571	0	0
45876037	3000963	5	6
45897402	1129625	0	0
46288028	1119510	0	0
46243876	1119510	0	0
45787591	1129625	0	0
46300340	738818	0	0
46314028	1149196	0	0
46314901	1125315	0	0
4180627	4163872	4	5
21000061	19129655	2	3
21503163	1153428	0	0
21602886	1768849	0	0
35508762	1174888	0	0
36156776	1125315	0	0
36424721	1519936	0	0
40220959	40220960	1	1
44359374	1149380	0	0
44349794	1119510	0	0
44353613	1124300	0	0
45655782	40228230	2	3
45634662	914335	0	0
45661841	1124957	0	0
45635645	1125315	0	0
45623800	1125315	0	0
45636033	1119510	0	0
45645463	1192710	0	0
45689713	1192710	0	0
45674045	738818	0	0
45694931	1149196	0	0
45707879	1713332	0	0
45674925	1125315	0	0
45782341	1192710	0	0
45876049	3009201	2	2
45897499	1129625	0	0
46288298	1119510	0	0
46243774	1119510	0	0
45802229	1129625	0	0
46300344	1545958	0	0
46314355	920293	0	0
46314799	1125315	0	0
4042150	4238715	4	5
21000084	19133905	2	3
21503168	1125315	0	0
21003084	1124957	0	0
35508765	742185	0	0
36156780	1125315	0	0
36313965	4024958	5	5
40221144	44816277	1	1
44359428	1595799	0	0
44350157	1119510	0	0
44353573	1332418	0	0
44348254	40223834	2	3
45634676	1118084	0	0
45661842	1174888	0	0
45635655	1125315	0	0
45624095	1125315	0	0
45636217	1119510	0	0
45645575	1738521	0	0
45689729	1192710	0	0
45674049	1551099	0	0
45695066	738818	0	0
45707919	1107830	0	0
45674929	1125315	0	0
45782342	740275	0	0
45786320	19128009	2	2
45897411	1129625	0	0
46288310	1119510	0	0
46244772	1119510	0	0
45802333	1129625	0	0
46300532	1154343	0	0
46313916	1545958	0	0
46314803	1125315	0	0
4040400	44783196	4	5
21000090	19076374	2	3
21503168	1129625	0	0
21003084	1177480	0	0
35508769	1000560	0	0
36156387	1125315	0	0
36313965	4243062	5	5
40085778	1150837	1	1
44359460	1112807	0	0
44349942	1119510	0	0
44353576	1361711	0	0
44348405	19008572	2	3
45634705	19003953	0	0
45661844	967823	0	0
45635660	1125315	0	0
45624051	1125315	0	0
45636442	1119510	0	0
45645138	1310149	0	0
45689632	1192710	0	0
45674051	967823	0	0
45697584	740275	0	0
45707991	738818	0	0
45671838	1125315	0	0
45782356	1332418	0	0
45786320	19127918	2	2
45894943	1129625	0	0
46288311	1119510	0	0
46244777	1119510	0	0
45801318	1129625	0	0
46300246	1124957	0	0
46314137	1545958	0	0
46314808	1125315	0	0
4040400	4117038	4	5
21000084	19133873	2	3
21503172	1174888	0	0
21003079	914335	0	0
35508888	1118084	0	0
35506952	1125315	0	0
36313965	4314290	5	5
36718045	381316	1	1
44359375	1174888	0	0
44349952	1119510	0	0
44353682	1115008	0	0
44348409	40229134	2	3
45634747	1115008	0	0
45662002	975125	0	0
45635325	1125315	0	0
45624055	1125315	0	0
45636526	1119510	0	0
45645481	975125	0	0
45686615	1192710	0	0
45674052	738818	0	0
45645897	740275	0	0
45705089	1713332	0	0
45671942	1125315	0	0
45782438	1713332	0	0
46288185	42902245	2	2
45895190	1129625	0	0
46288259	1119510	0	0
46244780	1119510	0	0
45801312	1129625	0	0
46300182	791967	0	0
46314429	967823	0	0
46314811	1125315	0	0
4043025	4301346	3	5
4306074	4010253	2	3
21503178	1154343	0	0
21003084	914335	0	0
35508520	1548195	0	0
35506898	1125315	0	0
36313965	4163872	5	5
40181755	40221415	1	1
44359428	1521369	0	0
44350201	1119510	0	0
44353683	1000560	0	0
45651976	46275444	2	3
45634760	1115008	0	0
45661886	791967	0	0
45635552	1125315	0	0
45623888	1125315	0	0
45636436	1119510	0	0
45645485	1149196	0	0
45686647	1192710	0	0
45674182	1153428	0	0
45645979	1115008	0	0
45705089	1759842	0	0
45671842	1125315	0	0
45782438	1759842	0	0
46243537	19128022	2	2
45895014	1129625	0	0
46288360	1119510	0	0
46238901	1119510	0	0
45795919	1129625	0	0
46300183	975125	0	0
46314782	1124300	0	0
46314816	1125315	0	0
4180627	4252419	3	5
21000141	19133873	2	3
21503179	1149380	0	0
21003084	1174888	0	0
35508521	1119510	0	0
35506941	1125315	0	0
36313965	4252419	5	6
36718119	4029498	1	1
44359428	1549786	0	0
44349968	1119510	0	0
44353488	1112807	0	0
45649408	40162522	2	3
45634819	1545958	0	0
45661895	1174888	0	0
45632428	1125315	0	0
45623697	1125315	0	0
45636561	1119510	0	0
45645475	1124300	0	0
45686883	1192710	0	0
45674184	708298	0	0
45645801	1115008	0	0
45705045	1713332	0	0
45671828	1125315	0	0
45782439	1500211	0	0
45876069	3013682	2	2
45895211	1129625	0	0
46288417	1119510	0	0
46238902	1119510	0	0
45795798	1129625	0	0
46300184	738818	0	0
46313922	1551099	0	0
46314821	1125315	0	0
4043022	4238715	3	5
441840	372328	5	8
21503179	1137529	0	0
21003079	1192710	0	0
35508521	738818	0	0
35507131	1125315	0	0
36313965	4024289	5	6
40057961	40223768	1	1
44359448	1738521	0	0
44350164	1119510	0	0
44353708	1000560	0	0
45649962	1127433	2	3
45634442	1738521	0	0
45661692	1174888	0	0
45632324	1125315	0	0
45624113	1125315	0	0
45636152	1119510	0	0
45645554	1551099	0	0
45686964	1192710	0	0
45674193	1521369	0	0
45691751	1738521	0	0
45705045	1759842	0	0
45672107	1125315	0	0
45782522	1713332	0	0
45876069	3006906	2	2
45895150	1129625	0	0
46288434	1119510	0	0
46238903	1119510	0	0
45795945	1129625	0	0
46300323	1115008	0	0
46314390	975125	0	0
46315082	1125315	0	0
4180169	440448	3	5
441840	4152936	5	10
21503065	1343916	0	0
21003079	1115008	0	0
35508523	1129625	0	0
35507054	1125315	0	0
36313965	4058899	5	7
40105046	1713671	1	1
44359433	1149196	0	0
44349826	1119510	0	0
44353503	1107830	0	0
45649220	40174880	2	3
45634815	1332418	0	0
45661785	738818	0	0
45632287	1125315	0	0
45668028	1125315	0	0
45636340	1119510	0	0
45645510	738818	0	0
45687017	1192710	0	0
45674193	19127890	0	0
45691719	1124300	0	0
45705133	1149380	0	0
45671972	1125315	0	0
45783590	19003953	0	0
45895468	19128022	2	2
45895337	1129625	0	0
46288456	1119510	0	0
46238870	1119510	0	0
45795955	1129625	0	0
46295767	1110410	0	0
46314395	1149196	0	0
46314747	1125315	0	0
4093991	4310024	3	5
441840	4056621	5	9
21503281	975125	0	0
21003079	1125315	0	0
35508659	1549786	0	0
35507056	1125315	0	0
36313965	40478878	4	4
36718005	381316	0	0
44359853	1177480	0	0
44350088	1119510	0	0
44353414	1539403	0	0
44354696	1551192	2	3
45634737	1149196	0	0
45661837	1192710	0	0
45632296	1125315	0	0
45668034	1125315	0	0
45636644	1119510	0	0
45645522	738818	0	0
45686813	1192710	0	0
45674193	1549786	0	0
45691860	1149196	0	0
45704800	1310149	0	0
45671743	1125315	0	0
45783674	1107830	0	0
45679375	19008572	2	3
45894521	1129625	0	0
46288772	1119510	0	0
46238921	1119510	0	0
45790670	1129625	0	0
46295857	914335	0	0
46314785	1174888	0	0
46314192	1125315	0	0
4180628	134438	3	5
441840	4310024	5	9
21003454	1595799	0	0
21003090	1124957	0	0
35508659	1515774	0	0
35507061	1125315	0	0
36313965	4062501	4	4
40766240	40766240	0	0
44359982	1305058	0	0
44350124	1119510	0	0
44353415	975125	0	0
45655934	40223834	2	3
45634741	1310149	0	0
45661982	1124957	0	0
45632289	1125315	0	0
45667648	1125315	0	0
45636469	1119510	0	0
45645940	975125	0	0
45687034	1192710	0	0
45674194	738818	0	0
45691864	1310149	0	0
45704688	1107830	0	0
45671750	1125315	0	0
45783547	1149380	0	0
45679794	40232448	2	3
45894496	1129625	0	0
46288803	1119510	0	0
46238922	1119510	0	0
45790674	1129625	0	0
46296139	1501700	0	0
46314626	1713332	0	0
46314777	1125315	0	0
4162054	4107731	3	5
441840	4283893	5	9
21003454	19054876	0	0
21003091	1124957	0	0
35508668	1174888	0	0
35507141	1125315	0	0
36313965	4145310	4	4
40249018	740275	0	0
44359474	1177480	0	0
44350071	1119510	0	0
44353419	1192710	0	0
45655934	40223821	2	3
45634745	1309944	0	0
45661985	738818	0	0
45632293	1125315	0	0
45667988	1125315	0	0
45636675	1119510	0	0
45642530	1713332	0	0
45683693	1192710	0	0
45674346	1192710	0	0
45691891	1713332	0	0
45704693	1717327	0	0
45671753	1125315	0	0
45783548	1124300	0	0
45679032	40232448	2	3
45803008	1129625	0	0
46288691	1119510	0	0
46238923	1119510	0	0
45790587	1129625	0	0
46296306	1778162	0	0
46314408	1332418	0	0
46314940	1125315	0	0
4042150	4186930	3	6
441840	4174876	5	6
21003454	1521369	0	0
21003086	1102527	0	0
35508678	975125	0	0
35507174	1125315	0	0
36313965	4047491	6	7
40479768	40479768	0	0
44359430	19127890	0	0
44350075	1119510	0	0
44353535	1332418	0	0
44340911	19019273	2	3
45634805	1115008	0	0
45661908	1115008	0	0
45632335	1125315	0	0
45667991	1125315	0	0
45636605	1119510	0	0
45642346	1149196	0	0
45683889	1192710	0	0
45674318	1124957	0	0
45691891	1759842	0	0
45704694	1308738	0	0
45671790	1125315	0	0
45783579	1717327	0	0
45679055	40169216	2	3
45803279	1129625	0	0
46288694	1119510	0	0
46238895	1119510	0	0
45790762	1129625	0	0
46296318	1124300	0	0
46314555	1112807	0	0
46314959	1125315	0	0
4180169	257012	3	6
441840	440086	5	7
21003454	1589505	0	0
21003084	1154029	0	0
35508683	1729720	0	0
35507129	1125315	0	0
36303153	4048171	8	13
40479422	40479422	0	0
44359430	1589505	0	0
44350101	1119510	0	0
44353538	967823	0	0
44337399	19019273	2	3
45634420	1110410	0	0
45661928	1310149	0	0
45632337	1125315	0	0
45667978	1125315	0	0
45636940	1119510	0	0
45642501	1192710	0	0
45683893	1192710	0	0
45673724	738818	0	0
45691898	1309944	0	0
45704701	1332418	0	0
45671857	1125315	0	0
45783587	1322184	0	0
45678968	40232448	2	3
45803288	1129625	0	0
46288701	1119510	0	0
46238898	1119510	0	0
45790984	1129625	0	0
46296347	1149380	0	0
46314575	1112807	0	0
46314979	1125315	0	0
4199402	4278672	5	6
441840	140673	5	7
21003454	19127890	0	0
21003091	1174888	0	0
35508686	1741122	0	0
36152536	1125315	0	0
36303153	313217	8	13
40250232	967823	0	0
44359430	1549786	0	0
44350127	1119510	0	0
44353546	1361711	0	0
44348222	19123231	2	3
45634817	1500211	0	0
45661968	1309944	0	0
45632416	1125315	0	0
45667984	1125315	0	0
45637054	1119510	0	0
45642510	791967	0	0
45684008	1192710	0	0
45674358	1115008	0	0
45691543	1521369	0	0
45704928	757627	0	0
45672234	1125315	0	0
45783624	1124300	0	0
45679125	40232448	2	3
45803411	1129625	0	0
46288761	1119510	0	0
46238899	1119510	0	0
45790720	1129625	0	0
46296353	1000560	0	0
46314582	1192710	0	0
46314910	1125315	0	0
4172024	4240902	5	6
441840	4094814	5	5
21003454	1518198	0	0
21003090	1110410	0	0
35508686	1746114	0	0
36152491	1125315	0	0
36303153	375671	8	12
40480160	40480160	0	0
44359431	1129625	0	0
44349682	1119510	0	0
44353551	1549786	0	0
44340939	1545959	2	3
45634556	1154029	0	0
45661760	1778162	0	0
45632352	1125315	0	0
45667780	1125315	0	0
45633278	1119510	0	0
45642384	1149196	0	0
45684018	1192710	0	0
45673913	1192710	0	0
45691530	738818	0	0
45705050	1557272	0	0
45671871	1125315	0	0
45783644	1107830	0	0
45785844	40223834	2	3
45803080	1129625	0	0
46288716	1119510	0	0
46239042	1119510	0	0
46297406	1129625	0	0
46296468	967823	0	0
46314796	1738521	0	0
46314912	1125315	0	0
4172024	4219399	5	6
441840	4029498	4	7
21003454	1515774	0	0
21003091	1154029	0	0
35508697	1307863	0	0
36152494	1125315	0	0
36303153	4059173	8	11
40213198	40213198	0	0
44359381	1521369	0	0
44349669	1119510	0	0
44353645	1129625	0	0
44354886	1545959	2	3
45634680	1124300	0	0
45661761	975125	0	0
45632355	1125315	0	0
45667893	1125315	0	0
45633190	1119510	0	0
45642434	715997	0	0
45680862	1192710	0	0
45674299	1124300	0	0
45691577	1149196	0	0
45705059	1192710	0	0
45672137	1125315	0	0
45782678	1115008	0	0
45785976	1107882	2	3
45800485	1129625	0	0
46243296	1119510	0	0
46238992	1119510	0	0
46297345	1129625	0	0
600000007	1557272	0	0
46314456	1192710	0	0
46314919	1125315	0	0
4172024	37017711	5	6
441840	317576	4	10
21003454	1549786	0	0
21003084	1110410	0	0
35508405	1125315	0	0
36152598	1125315	0	0
36303153	81893	8	14
40213201	40213201	0	0
44359381	1549786	0	0
44342512	1119510	0	0
44353684	1589505	0	0
44351256	1545959	2	3
45634788	914335	0	0
45661899	975125	0	0
45632340	1125315	0	0
45668015	1125315	0	0
45633203	1119510	0	0
45642448	1713332	0	0
45680863	1192710	0	0
45674303	1192710	0	0
45691674	1738521	0	0
45707178	19128022	3	4
45672026	1125315	0	0
45782707	933724	0	0
45786067	40174880	2	3
45800583	1129625	0	0
46243339	1119510	0	0
46238993	1119510	0	0
46297349	1129625	0	0
600000010	1310149	0	0
46314512	705944	0	0
46314699	1125315	0	0
4042140	44782520	5	6
441840	4027663	4	8
21003454	1548195	0	0
21003091	1110410	0	0
35508406	791967	0	0
36152521	1125315	0	0
36303153	4219399	8	9
40213314	40213314	0	0
44359535	1124957	0	0
44342431	1119510	0	0
44353684	19127890	0	0
44341545	19078461	2	3
45634759	1153428	0	0
45664310	19003953	0	0
45632432	1125315	0	0
45670123	1125315	0	0
45633291	1119510	0	0
45642451	1124957	0	0
45677481	1192710	0	0
45673889	708298	0	0
45691642	967823	0	0
45781363	19128022	3	4
45672028	1125315	0	0
45782737	1713332	0	0
45786544	40229134	2	3
45800687	1129625	0	0
46243301	1119510	0	0
46239295	1119510	0	0
46297558	1129625	0	0
46318351	1149196	0	0
46314682	1545958	0	0
46314700	1125315	0	0
4040396	4198190	5	6
441840	317009	4	5
21003454	1519936	0	0
21003084	1102527	0	0
35508719	1119510	0	0
36152725	1125315	0	0
36303153	4240902	8	9
40213320	40213320	0	0
44359617	740275	0	0
44342586	1119510	0	0
44353684	1549786	0	0
45662011	1127433	2	3
45636801	1110410	0	0
45655524	1539403	0	0
45632702	1125315	0	0
45670276	1125315	0	0
45633317	1119510	0	0
45642452	1124957	0	0
45674157	1192710	0	0
45674017	914335	0	0
45691629	1332418	0	0
45671700	19128009	2	2
45672030	1125315	0	0
45782850	1124957	0	0
45786676	40232448	2	3
45800561	1129625	0	0
46243468	1119510	0	0
46239111	1119510	0	0
46297562	1129625	0	0
46318336	1326303	0	0
46313857	1107830	0	0
46317746	1125315	0	0
4093991	4048171	5	6
441840	37017711	7	8
21003454	1512674	0	0
21003118	975125	0	0
35508720	1124300	0	0
36152762	1125315	0	0
36303153	78272	7	13
40213154	40213154	0	0
44359619	967823	0	0
44342131	1119510	0	0
44353693	1124300	0	0
45662011	19078461	2	3
45636891	705944	0	0
45655567	1149196	0	0
45629211	1125315	0	0
45670001	1125315	0	0
45633438	1119510	0	0
45642597	975125	0	0
45676229	1192710	0	0
45674024	1738521	0	0
45691919	715997	0	0
45766058	4330583	2	2
45672157	1125315	0	0
45782765	967823	0	0
45786682	43012036	2	3
45800699	1129625	0	0
46243348	1119510	0	0
46239298	1119510	0	0
46297418	1129625	0	0
46318445	975125	0	0
46315008	715997	0	0
46317968	1125315	0	0
4117930	198199	4	6
441840	4240902	7	8
21003455	19127890	0	0
21003118	1149380	0	0
35508775	1115008	0	0
36152880	1125315	0	0
36303153	441267	7	8
40213160	40213160	0	0
44359523	1717327	0	0
44342264	1119510	0	0
44353747	1177480	0	0
44347456	1551192	2	3
45631645	1595799	0	0
45655576	1713332	0	0
45629297	1125315	0	0
45670049	1125315	0	0
45633557	1119510	0	0
45642627	1174888	0	0
45674467	1192710	0	0
45674026	1107830	0	0
45691753	1174888	0	0
45763613	81893	2	2
45671772	1125315	0	0
45782769	1192710	0	0
45786287	1115171	2	3
45800839	1129625	0	0
46240854	1119510	0	0
46239306	1119510	0	0
46297284	1129625	0	0
46318372	914335	0	0
46315014	967823	0	0
46317164	1125315	0	0
4043161	4107731	4	6
441840	4219399	7	8
21003511	1000560	0	0
21003090	1174888	0	0
35508907	1129625	0	0
36152577	1125315	0	0
36303153	438614	7	8
40213216	40213216	0	0
44359527	1129625	0	0
44344655	1119510	0	0
44353663	1192710	0	0
44358085	1545959	2	3
45631464	1549786	0	0
45658264	738818	0	0
45629300	1125315	0	0
45670288	1125315	0	0
45633687	1119510	0	0
45642602	723013	0	0
45674546	1192710	0	0
45671150	1000560	0	0
45691768	967823	0	0
45765647	4001336	2	2
45672171	1125315	0	0
45782732	1557272	0	0
46292550	46275444	2	3
45800744	1129625	0	0
46240858	1119510	0	0
46239205	1119510	0	0
46297908	1129625	0	0
46318376	914335	0	0
46314721	967823	0	0
46317359	1125315	0	0
4043022	4186930	4	6
441840	4166224	7	11
21003511	791967	0	0
21003153	1129625	0	0
35508908	1112807	0	0
36152579	1125315	0	0
36303153	4102123	7	8
40213227	40213227	0	0
44359624	1149196	0	0
44342631	1119510	0	0
44353663	1112807	0	0
45655751	1551192	2	3
45631464	19127890	0	0
45658006	753626	0	0
45629303	1125315	0	0
45670079	1125315	0	0
45630284	1119510	0	0
45642413	1515774	0	0
45671608	1192710	0	0
45671151	1551099	0	0
45691774	1322184	0	0
45690321	19128022	2	2
45671780	1125315	0	0
45782733	1115008	0	0
46293077	35605482	2	3
45797776	1129625	0	0
46242546	1119510	0	0
46239029	1119510	0	0
46297897	1129625	0	0
46318807	933724	0	0
46308893	1545958	0	0
46315285	1125315	0	0
4180169	81893	4	6
441840	378001	7	11
21003455	1549786	0	0
21604571	791967	0	0
35508910	1129625	0	0
36152661	1125315	0	0
36303153	4048169	7	8
40213230	40213230	0	0
44359475	1549786	0	0
44342639	1119510	0	0
44353666	738818	0	0
44362217	19079524	2	3
45631466	738818	0	0
45658205	975125	0	0
45629308	1125315	0	0
45670312	1125315	0	0
45630373	1119510	0	0
45642413	1549786	0	0
45671315	1192710	0	0
45671147	1713332	0	0
45691672	1115008	0	0
45690321	19128263	2	2
45671782	1125315	0	0
45782892	1124957	0	0
46292997	40165015	2	3
45798058	1129625	0	0
46242486	1119510	0	0
45894584	1119510	0	0
46298017	1129625	0	0
46318452	738818	0	0
46308797	1174888	0	0
46315304	1125315	0	0
4043023	4336464	4	6
441840	4059173	7	10
21003455	1589505	0	0
21604566	723013	0	0
35508913	1125315	0	0
36152607	1125315	0	0
36303153	4306014	7	8
40213251	40213251	0	0
44359475	19127890	0	0
44342649	1119510	0	0
44353677	1124300	0	0
45661928	40163554	2	3
45631647	1107830	0	0
45658021	1107830	0	0
45629510	1125315	0	0
45670265	1125315	0	0
45630013	1119510	0	0
45642423	1501700	0	0
45671575	1192710	0	0
45671336	967823	0	0
45691823	1548195	0	0
45675348	19127918	2	2
45671888	1125315	0	0
45782855	1174888	0	0
46292508	19078461	2	3
45797942	1129625	0	0
46242170	1119510	0	0
45894378	1119510	0	0
46297801	1129625	0	0
46318492	701322	0	0
46308841	975125	0	0
46315165	1125315	0	0
4047779	198199	4	6
4215793	4202832	2	2
21004032	1717327	0	0
21604643	708298	0	0
35508422	1307863	0	0
36152919	1125315	0	0
36303153	439406	7	8
40213180	40213180	0	0
44359475	1515774	0	0
44342656	1119510	0	0
44353678	1548195	0	0
45655796	40163554	2	3
45631578	1501700	0	0
45655599	738818	0	0
45629378	1125315	0	0
45670449	1125315	0	0
45630447	1119510	0	0
45642574	1738521	0	0
45671542	1192710	0	0
45671338	738818	0	0
45691838	933724	0	0
45675348	19128009	2	2
45784053	1125315	0	0
45782757	723013	0	0
46292653	1115171	2	3
45797900	1129625	0	0
46241209	1119510	0	0
45894620	1119510	0	0
46289063	1129625	0	0
46318571	1107830	0	0
46308843	1110410	0	0
46309493	1125315	0	0
4180628	4296204	4	6
4344497	4149245	2	2
21003438	1746114	0	0
21604417	740275	0	0
35508889	1149196	0	0
36152682	1125315	0	0
36303153	4304110	7	8
40220386	40220386	0	0
44359478	708298	0	0
44342669	1119510	0	0
44353779	1310149	0	0
45656022	19019273	2	3
45631579	1115008	0	0
45655621	967823	0	0
45629168	1125315	0	0
45670090	1125315	0	0
45630155	1119510	0	0
45642579	967823	0	0
45670157	1192710	0	0
45671213	1551099	0	0
45691959	1174888	0	0
45769811	375671	2	2
45783785	1125315	0	0
45782709	1551099	0	0
45784800	1129625	0	0
45797909	1129625	0	0
46241211	1119510	0	0
45894431	1119510	0	0
46289159	1129625	0	0
46318581	1124300	0	0
46309053	1501700	0	0
46309502	1125315	0	0
4043022	4057420	6	6
4316083	4296204	2	2
21003438	1778162	0	0
21604152	1557272	0	0
35508826	1118084	0	0
36153080	1125315	0	0
36303153	4230399	7	12
40220389	40220386	0	0
44359490	1741122	0	0
44364094	1119510	0	0
44353726	1545958	0	0
44355050	19019273	2	3
45631698	967823	0	0
45655679	1549786	0	0
45629169	1125315	0	0
45668116	1125315	0	0
45630959	1119510	0	0
45642580	1149196	0	0
45781818	1192710	0	0
45671184	1308738	0	0
45691648	1759842	0	0
45769811	378001	2	2
45783888	1125315	0	0
45782710	1326303	0	0
45784565	1129625	0	0
45795226	1129625	0	0
46241119	1119510	0	0
45893585	1119510	0	0
46289175	1129625	0	0
46318515	1512674	0	0
46308809	1549786	0	0
46309593	1125315	0	0
4043161	4216130	6	6
4216752	4197460	2	2
21003514	914335	0	0
21500804	1367571	0	0
35508534	1125315	0	0
36152812	1125315	0	0
36303153	440448	7	12
40165015	40165015	0	0
44359490	1746114	0	0
44364279	1119510	0	0
44353515	1112807	0	0
45661908	19019273	2	3
45631660	1545958	0	0
45655679	19127890	0	0
45629461	1125315	0	0
45668153	1125315	0	0
45631262	1119510	0	0
45642615	723013	0	0
45781777	1192710	0	0
45671162	723013	0	0
45691648	1713332	0	0
45679970	19008572	2	3
45783890	1125315	0	0
45782780	19127890	0	0
45784788	1129625	0	0
45795528	1129625	0	0
46241137	1119510	0	0
45893556	1119510	0	0
46289364	1129625	0	0
46318515	1549786	0	0
46308809	1589505	0	0
46309605	1125315	0	0
4043161	4108705	6	6
4322244	4125906	2	2
21003515	791967	0	0
21500819	1322184	0	0
35508536	1738521	0	0
36152648	1125315	0	0
36303153	40481087	7	11
37522318	4336464	0	0
44359501	1177480	0	0
44364289	1119510	0	0
44353706	1112807	0	0
44340813	19019273	2	3
45631700	1124300	0	0
45655630	1332418	0	0
45629549	1125315	0	0
45668183	1125315	0	0
45630553	1119510	0	0
45642517	1149196	0	0
45781801	1192710	0	0
45671164	1308738	0	0
45692015	1000560	0	0
45680023	40236824	2	3
45783903	1125315	0	0
45782780	1589505	0	0
45784819	1129625	0	0
45795378	1129625	0	0
46241376	1119510	0	0
45801384	1119510	0	0
46289508	1129625	0	0
46318521	1307863	0	0
46308967	1361711	0	0
46309607	1125315	0	0
4043023	40492359	6	6
19127891	19128263	2	2
21004035	723013	0	0
21500806	1310149	0	0
35508441	1149380	0	0
36153081	1125315	0	0
36303153	4278672	7	11
37522325	4216130	0	0
44359502	1153428	0	0
44364364	1119510	0	0
44353707	1107830	0	0
45620553	19019273	2	3
45631596	1124300	0	0
45655688	1154029	0	0
45629233	1125315	0	0
45668131	1125315	0	0
45627520	1119510	0	0
45642624	1332418	0	0
45783599	1192710	0	0
45671003	1343916	0	0
45692022	1549786	0	0
45680003	19018935	2	3
45783908	1125315	0	0
45782780	1549786	0	0
45782403	1129625	0	0
45794644	1129625	0	0
46241282	1119510	0	0
45801481	1119510	0	0
46289463	1129625	0	0
46318523	975125	0	0
46309076	975125	0	0
46310079	1125315	0	0
4040400	4330583	5	6
19127891	19128022	2	2
21004201	1717327	0	0
21500851	1759842	0	0
35508813	1177480	0	0
35509188	1125315	0	0
36303153	4146173	7	11
36718157	378419	0	0
44359506	1548195	0	0
44357062	1119510	0	0
44353881	1192710	0	0
45655496	40174880	2	3
45631706	1361711	0	0
45655694	975125	0	0
45629500	1125315	0	0
45668320	1125315	0	0
45627782	1119510	0	0
45642523	1154029	0	0
45779489	1192710	0	0
45671078	715997	0	0
45692022	1589505	0	0
45680013	19018935	2	3
45784172	1125315	0	0
45782771	1124957	0	0
45782662	1129625	0	0
45794537	1129625	0	0
46241391	1119510	0	0
45801617	1119510	0	0
46289789	1129625	0	0
46318405	1738521	0	0
46309028	715997	0	0
46309701	1125315	0	0
4040400	4163971	6	6
19127891	19128065	2	2
21004202	1717327	0	0
21500824	1112807	0	0
35508861	1000560	0	0
35509189	1125315	0	0
36303153	4001336	7	11
36718530	4029498	0	0
44359507	1521369	0	0
44357173	1119510	0	0
44353882	1129625	0	0
45655137	1539411	2	3
45631574	1149196	0	0
45655796	1310149	0	0
45629265	1125315	0	0
45668324	1125315	0	0
45627784	1119510	0	0
45642489	1154343	0	0
45707949	1192710	0	0
45671085	1115008	0	0
45692022	19127890	0	0
45677545	40231925	2	3
45784173	1125315	0	0
45782969	1149196	0	0
45780544	1129625	0	0
45794617	1129625	0	0
46238440	1119510	0	0
45801752	1119510	0	0
46289757	1129625	0	0
46318406	975125	0	0
46309018	1000560	0	0
46309548	1125315	0	0
4040400	4108705	6	6
19127891	19127904	2	2
21003656	1738521	0	0
21500845	1308738	0	0
35508863	701322	0	0
35509194	1125315	0	0
36303153	198199	7	10
40213260	40213260	0	0
44359508	1124300	0	0
44357258	1119510	0	0
44353519	738818	0	0
45621900	40223768	2	3
45631813	1124957	0	0
45655851	723013	0	0
45629266	1125315	0	0
45668325	1125315	0	0
45627718	1119510	0	0
45642491	1310149	0	0
45707950	1192710	0	0
45671253	1115008	0	0
45691690	738818	0	0
45677944	40232448	2	3
45784113	1125315	0	0
45782863	1192710	0	0
45780555	1129625	0	0
45794445	1129625	0	0
46238327	1119510	0	0
45801392	1119510	0	0
46289713	1129625	0	0
46318418	1153428	0	0
46308902	1107830	0	0
46309828	1125315	0	0
4040400	4301346	4	6
4302532	4202451	2	2
21004223	1713332	0	0
21500903	975125	0	0
35508541	1119510	0	0
36157065	1125315	0	0
36303153	28060	7	10
40213281	40213281	0	0
44359586	1545958	0	0
44358910	1119510	0	0
44353727	1118084	0	0
44352291	40223768	2	3
45631913	791967	0	0
45655857	1549786	0	0
45629375	1125315	0	0
45668339	1125315	0	0
45627722	1119510	0	0
45642628	1149196	0	0
45708187	1192710	0	0
45671106	1310149	0	0
45691695	1115008	0	0
45677837	1154615	2	3
45784159	1125315	0	0
45780747	975125	0	0
45706600	1129625	0	0
45792782	1129625	0	0
46238392	1119510	0	0
45801609	1119510	0	0
46289604	1129625	0	0
46318696	1501700	0	0
46308908	740275	0	0
46309842	1125315	0	0
4040400	4216130	3	6
4301352	4323902	2	2
21002330	1746114	0	0
21500875	967823	0	0
35508879	1125315	0	0
36157223	1125315	0	0
36303153	4296204	7	10
40213296	40213296	0	0
44359733	1153428	0	0
44358718	1119510	0	0
44353716	1110410	0	0
45636974	19078461	2	3
45631916	1310149	0	0
45655857	19127890	0	0
45629474	1125315	0	0
45668159	1125315	0	0
45627530	1119510	0	0
45642558	1192710	0	0
45708299	1192710	0	0
45671108	19010482	0	0
45691696	1310149	0	0
45677904	40232448	2	3
45783929	1125315	0	0
45780749	791967	0	0
45706733	1129625	0	0
45792791	1129625	0	0
46238395	1119510	0	0
45801595	1119510	0	0
46289847	1129625	0	0
46318767	975125	0	0
46309082	1595799	0	0
46309867	1125315	0	0
4093991	40479768	6	7
4301352	4337611	2	2
21002335	1741122	0	0
21500874	967823	0	0
35508879	1119510	0	0
36156815	1125315	0	0
36303153	4116491	7	9
40213299	40213299	0	0
44359652	1129625	0	0
44358751	1119510	0	0
44353728	1129625	0	0
44355081	40223768	2	3
45631924	1500211	0	0
45655857	1589505	0	0
45629475	1125315	0	0
45668106	1125315	0	0
45627585	1119510	0	0
45642559	738818	0	0
45705334	1192710	0	0
45671189	1309944	0	0
45692039	738818	0	0
45678052	920334	2	3
45784083	1125315	0	0
45780754	1153428	0	0
45706635	1129625	0	0
45792858	1129625	0	0
46238502	1119510	0	0
45801566	1119510	0	0
46289895	1129625	0	0
46318699	1729720	0	0
46309082	1521369	0	0
46309895	1125315	0	0
4093991	133834	6	7
4339410	4035415	2	2
21002328	1713332	0	0
21500894	975125	0	0
35508814	1129625	0	0
36156821	1125315	0	0
36303153	4296205	7	7
40220960	40220960	0	0
44359545	1149380	0	0
44357336	1119510	0	0
44353492	920293	0	0
44357981	19075001	2	3
45631709	1174888	0	0
45655606	1115008	0	0
45629482	1125315	0	0
45665790	1125315	0	0
45627702	1119510	0	0
45642725	1149196	0	0
45702017	1192710	0	0
45671119	1738521	0	0
45691840	1124957	0	0
45677970	1127433	2	3
45781947	1125315	0	0
45780779	1000560	0	0
45706832	1129625	0	0
45792774	1129625	0	0
46238344	1119510	0	0
45801581	1119510	0	0
46241638	1129625	0	0
46318662	1713332	0	0
46309082	1549786	0	0
46309910	1125315	0	0
4093991	40479422	6	7
4339410	80502	2	2
21002346	1759842	0	0
21500853	975125	0	0
35508815	705944	0	0
36156977	1125315	0	0
36303153	4094814	6	6
40213306	40213306	0	0
44359467	1501700	0	0
44357311	1119510	0	0
44353812	1177480	0	0
44357999	40223768	2	3
45631718	1149196	0	0
45655658	975125	0	0
45629492	1125315	0	0
45665594	1125315	0	0
45627412	1119510	0	0
45642479	1174888	0	0
45702068	1192710	0	0
45671222	740275	0	0
45692046	1124957	0	0
45679772	35605482	2	3
45781878	1125315	0	0
45780781	1729720	0	0
45706835	1129625	0	0
45787332	1129625	0	0
46238349	1119510	0	0
45795901	1119510	0	0
46241716	1129625	0	0
46318722	1332418	0	0
46309105	1332418	0	0
46310078	1125315	0	0
4043022	4275113	5	7
4198525	4027663	2	2
21002330	1759842	0	0
21500932	975125	0	0
35508817	1119510	0	0
36156754	1125315	0	0
36303153	4051466	6	7
40221414	40221415	0	0
44359743	1177480	0	0
44353921	1119510	0	0
44353816	1112807	0	0
44340145	40223768	2	3
45631830	967823	0	0
45655672	975125	0	0
45629495	1125315	0	0
45665810	1125315	0	0
45627414	1119510	0	0
45642564	1174888	0	0
45702133	1192710	0	0
45671292	1115008	0	0
45691801	757627	0	0
45679639	19057271	2	3
45781939	1125315	0	0
45780847	1115008	0	0
45706841	1129625	0	0
45787279	1129625	0	0
46238695	1119510	0	0
45795961	1119510	0	0
46241741	1129625	0	0
46318529	1115008	0	0
46309286	1112807	0	0
46309543	1125315	0	0
4043022	4117038	4	7
4200516	381316	2	2
21002329	1717327	0	0
21500876	1124300	0	0
35508824	1549786	0	0
36156825	1125315	0	0
36303153	4174876	6	7
40221415	40221415	0	0
44359657	1000560	0	0
44354030	1119510	0	0
44353816	1192710	0	0
45655576	19073183	2	3
45631817	1501700	0	0
45655977	1124300	0	0
45629402	1125315	0	0
45666059	1125315	0	0
45624608	1119510	0	0
45642629	975125	0	0
45699021	1192710	0	0
45671135	1192710	0	0
45691777	738818	0	0
45679245	40223768	2	3
45781967	1125315	0	0
45780632	1115008	0	0
46240377	1129625	0	0
45787280	1129625	0	0
46238727	1119510	0	0
45796160	1119510	0	0
46241742	1129625	0	0
46318841	1124300	0	0
46308958	791967	0	0
46309556	1125315	0	0
4043022	4198190	6	7
4301471	195588	2	2
21002347	1746114	0	0
21500926	975125	0	0
35508824	1515774	0	0
36156990	1125315	0	0
36303153	4024289	6	7
40231925	40231925	0	0
44359764	1192710	0	0
44353844	1119510	0	0
44353827	1713332	0	0
44362515	19078461	2	3
45631925	1500211	0	0
45655618	1000560	0	0
45629584	1125315	0	0
45665915	1125315	0	0
45624468	1119510	0	0
45642632	1192710	0	0
45699518	1192710	0	0
45671138	1192710	0	0
45691979	1124300	0	0
45674626	40232448	2	3
45781926	1125315	0	0
45780786	1149380	0	0
45702776	1129625	0	0
45696301	1119510	0	0
45897495	1119510	0	0
45795965	1119510	0	0
46241682	1129625	0	0
46318670	1738521	0	0
46309209	715997	0	0
46309968	1125315	0	0
4180169	260139	3	7
4261497	42535580	2	2
21002338	1746114	0	0
21002855	1125315	0	0
35508824	19127890	0	0
36157006	1125315	0	0
36303153	440086	6	8
36718530	380378	0	1
44359765	1545958	0	0
44354249	1119510	0	0
44353788	1192710	0	0
45620447	19073183	2	3
45631930	967823	0	0
45655751	1551099	0	0
45631236	1125315	0	0
45666075	1125315	0	0
45624628	1119510	0	0
45642637	1153428	0	0
45695753	1192710	0	0
45671144	933724	0	0
45692071	1326303	0	0
45674538	1127433	2	3
45781912	1125315	0	0
45780889	1000560	0	0
45702869	1129625	0	0
45696812	1119510	0	0
45897513	1119510	0	0
45796250	1119510	0	0
46242515	1129625	0	0
46318981	1308738	0	0
46309230	1595799	0	0
46309746	1125315	0	0
4199402	4048695	5	7
4201402	81893	2	2
21002338	1741122	0	0
21002855	723013	0	0
35508918	1153428	0	0
36157160	1125315	0	0
36303153	140673	6	8
37202316	4280726	3	9
44359767	1124300	0	0
44354196	1119510	0	0
44353788	1112807	0	0
45625321	1332419	2	3
45631877	1539403	0	0
45655802	708298	0	0
45626452	1125315	0	0
45665828	1125315	0	0
45624651	1119510	0	0
45642496	1174888	0	0
45697750	1192710	0	0
45671261	723013	0	0
45691990	1149196	0	0
45674958	19133768	2	3
45781915	1125315	0	0
45780895	1174888	0	0
45703037	1129625	0	0
45696818	1119510	0	0
45897518	1119510	0	0
45795913	1119510	0	0
46241888	1129625	0	0
46318986	967823	0	0
46309230	1549786	0	0
46309562	1125315	0	0
4159949	4336464	5	7
4197094	4266809	2	2
21002332	1759842	0	0
21002855	1112807	0	0
35508924	1332418	0	0
36157171	1125315	0	0
36303153	4155034	6	9
37202316	261325	3	9
44359699	1129625	0	0
44354102	1119510	0	0
44353731	1310149	0	0
44348694	19078461	2	3
45631879	1174888	0	0
45655863	967823	0	0
45626453	1125315	0	0
45666049	1125315	0	0
45624413	1119510	0	0
45640051	738818	0	0
45692862	1192710	0	0
45671365	1738521	0	0
45691993	1717327	0	0
45674741	1115171	2	3
45781917	1125315	0	0
45780952	705944	0	0
45703074	1129625	0	0
45696874	1119510	0	0
45897589	1119510	0	0
45796114	1119510	0	0
46241894	1129625	0	0
46318586	1738521	0	0
46309230	1521369	0	0
46309974	1125315	0	0
4117930	317576	5	7
4342752	81893	2	2
21002349	920293	0	0
21002855	791967	0	0
35509016	1124957	0	0
36157308	1125315	0	0
36303153	380378	6	9
37202316	257012	3	8
44359700	738818	0	0
44354279	1119510	0	0
44353736	1115008	0	0
45620556	1107882	2	3
45631781	738818	0	0
45655757	1343916	0	0
45626634	1125315	0	0
45666221	1125315	0	0
45624448	1119510	0	0
45640054	1361711	0	0
45693067	1192710	0	0
45671366	1500211	0	0
45691805	738818	0	0
45674640	1127433	2	3
45782080	1125315	0	0
45780200	1149196	0	0
45703938	1129625	0	0
45696717	1119510	0	0
45897776	1119510	0	0
45796199	1119510	0	0
45897795	1129625	0	0
46318746	1000560	0	0
46309231	1149196	0	0
46309994	1125315	0	0
4117930	4142905	4	7
4200851	258780	2	2
21002434	1717327	0	0
21002856	1125315	0	0
35508887	708298	0	0
36157344	1125315	0	0
36303153	4310024	6	10
37200000	258780	3	11
44359705	1115008	0	0
44352402	1119510	0	0
44353830	1177480	0	0
44344712	1107882	2	3
45631782	738818	0	0
45655760	1174888	0	0
45626637	1125315	0	0
45666254	1125315	0	0
45624415	1119510	0	0
45639421	1174888	0	0
45690014	1192710	0	0
45671516	1124300	0	0
45691808	1501700	0	0
45675001	1539411	2	3
45781946	1125315	0	0
45780250	1149196	0	0
45703129	1129625	0	0
45696794	1119510	0	0
45895436	1119510	0	0
45796097	1119510	0	0
45895810	1129625	0	0
46318851	1124300	0	0
46309137	975125	0	0
46309572	1125315	0	0
4117930	195588	4	7
4344040	4146173	2	2
21002436	1746114	0	0
21002858	1728416	0	0
35509019	1129625	0	0
36157488	1125315	0	0
36303153	4035415	6	10
37200000	261325	3	10
44359708	1129625	0	0
44352235	1119510	0	0
44353791	1149380	0	0
44347685	1107882	2	3
45632152	738818	0	0
45655761	975125	0	0
45626737	1125315	0	0
45665730	1125315	0	0
45624767	1119510	0	0
45639461	967823	0	0
45689788	1192710	0	0
45671518	1149196	0	0
45691811	933724	0	0
45674879	40229134	2	3
45781995	1125315	0	0
45780285	1107830	0	0
45703170	1129625	0	0
45802680	1119510	0	0
45895348	1119510	0	0
45796101	1119510	0	0
45895901	1129625	0	0
46318727	1308738	0	0
46309152	1729720	0	0
46309931	1125315	0	0
4180169	40486433	4	7
4320791	40486433	2	2
21002491	1125315	0	0
21002881	1746114	0	0
35508981	1115008	0	0
36157468	1125315	0	0
36303153	4283893	6	10
37200000	4280726	3	10
44355985	1595799	0	0
44350288	1119510	0	0
44353792	1551099	0	0
44355183	1107882	2	3
45632153	1549786	0	0
45655981	1307863	0	0
45626537	1125315	0	0
45666175	1125315	0	0
45624563	1119510	0	0
45639477	1310149	0	0
45690123	1192710	0	0
45671289	1153428	0	0
45688791	1107830	0	0
45674666	19133768	2	3
45782124	1125315	0	0
45780262	1174888	0	0
45699987	1129625	0	0
45802895	1119510	0	0
45895374	1119510	0	0
45796179	1119510	0	0
45895851	1129625	0	0
46318729	967823	0	0
46309112	1112807	0	0
46309937	1125315	0	0
4180169	4294548	4	7
4320791	4280726	2	2
21002491	1595799	0	0
21002846	1112807	0	0
35508871	1177480	0	0
36157377	1125315	0	0
36303153	4132546	6	10
37200000	260139	3	10
44355985	1521369	0	0
44350343	1119510	0	0
44353913	1177480	0	0
44337411	1107882	2	3
45632153	1595799	0	0
45655986	1149196	0	0
45626784	1125315	0	0
45666177	1125315	0	0
45624863	1119510	0	0
45639489	1149196	0	0
45690178	1192710	0	0
45671510	791967	0	0
45688763	914335	0	0
45674777	40232448	2	3
45782023	1125315	0	0
45780289	933724	0	0
45700251	1129625	0	0
45802774	1119510	0	0
45895297	1119510	0	0
45796274	1119510	0	0
45896083	1129625	0	0
46318894	1308738	0	0
46309120	1000560	0	0
46310156	1125315	0	0
4180169	4280726	4	7
4278510	4197460	2	2
21002491	19054876	0	0
21002865	1125315	0	0
35508837	1125315	0	0
36157378	1125315	0	0
36303153	4056621	6	10
37200000	255848	3	9
44355985	1549786	0	0
44350244	1119510	0	0
44353621	1332418	0	0
44343872	1107882	2	3
45632153	1521369	0	0
45655821	914335	0	0
45626605	1125315	0	0
45663610	1125315	0	0
45624867	1119510	0	0
45639491	1149196	0	0
45690085	1192710	0	0
45671588	1149196	0	0
45688853	791967	0	0
45674783	1154615	2	3
45781958	1125315	0	0
45780291	708298	0	0
45697773	1129625	0	0
45802778	1119510	0	0
45895443	1119510	0	0
45796437	1119510	0	0
45804140	1129625	0	0
46318901	1738521	0	0
46309122	1500211	0	0
46310159	1125315	0	0
4181322	4336464	4	7
21000912	19133905	2	3
21002425	1746114	0	0
21002880	1759842	0	0
35508839	1000560	0	0
36151910	1125315	0	0
36303153	261325	6	11
37200000	28060	3	9
44355989	1129625	0	0
44350452	1119510	0	0
44353939	738818	0	0
44347777	1107882	2	3
45631900	1000560	0	0
45655750	738818	0	0
45626619	1125315	0	0
45663616	1125315	0	0
45624878	1119510	0	0
45639496	1545958	0	0
45688408	1192710	0	0
45671592	1539403	0	0
45688833	967823	0	0
45674912	1115171	2	3
45781960	1125315	0	0
45780234	967823	0	0
45696901	1129625	0	0
45802861	1119510	0	0
45895266	1119510	0	0
45790725	1119510	0	0
45804223	1129625	0	0
46319000	975125	0	0
46309165	1545958	0	0
46309769	1125315	0	0
4180628	40479768	6	7
21000912	19133873	2	3
21002436	1717327	0	0
21002880	1778162	0	0
35508735	1557272	0	0
36152267	1125315	0	0
36303153	4152936	6	11
37200000	4283893	3	8
44355625	1551099	0	0
44350395	1119510	0	0
44353916	914335	0	0
44341489	19078461	2	3
45631756	1322184	0	0
45655934	1153428	0	0
45626665	1125315	0	0
45663618	1125315	0	0
45624879	1119510	0	0
45639401	1192710	0	0
45688730	1192710	0	0
45671277	1717327	0	0
45688793	1539403	0	0
45671682	19133905	2	3
45782056	1125315	0	0
45780235	1000560	0	0
45697018	1129625	0	0
45802730	1119510	0	0
45894650	1119510	0	0
45790730	1119510	0	0
45804248	1129625	0	0
46319189	1192710	0	0
46309182	1551099	0	0
46309781	1125315	0	0
4163873	4181917	2	2
21000907	40163554	2	3
21002374	1738521	0	0
21002842	1551099	0	0
35508982	1738521	0	0
36151921	1125315	0	0
36303153	4294548	6	12
37200000	441267	3	7
44355628	975125	0	0
44350249	1119510	0	0
44345925	1332418	0	0
45620492	1107882	2	3
45632036	1149196	0	0
45655722	1124957	0	0
45626777	1125315	0	0
45663628	1125315	0	0
45624592	1119510	0	0
45639424	1515774	0	0
45687091	1192710	0	0
45671278	1310149	0	0
45688812	1115008	0	0
45671686	19008572	2	3
45782141	1125315	0	0
45780238	742185	0	0
45697037	1129625	0	0
45802913	1119510	0	0
45803298	1119510	0	0
45791011	1119510	0	0
45803916	1129625	0	0
46318646	1308738	0	0
46309108	1539403	0	0
46310059	1125315	0	0
4134134	4132546	2	2
21000931	19078924	2	3
21002421	1746114	0	0
21002845	1112807	0	0
35508845	1125315	0	0
36151923	1125315	0	0
36303153	4285898	6	13
37000000	198199	3	7
44356061	1112807	0	0
44350690	1119510	0	0
44346081	1107830	0	0
45651818	19078461	2	3
45632037	1310149	0	0
45655726	1549786	0	0
45626716	1125315	0	0
45663652	1125315	0	0
45624784	1119510	0	0
45639424	1549786	0	0
45684213	1192710	0	0
45671279	1192710	0	0
45688834	1713332	0	0
45671838	1127433	2	3
45782006	1125315	0	0
45780242	1307863	0	0
45697231	1129625	0	0
45802921	1119510	0	0
45803342	1119510	0	0
45790779	1119510	0	0
45803853	1129625	0	0
46318776	1192710	0	0
46309206	1107830	0	0
46310007	1125315	0	0
4188066	4314290	2	2
21000931	19076374	2	3
21002422	1746114	0	0
21002863	1115008	0	0
35508845	1174888	0	0
36157756	1125315	0	0
36303153	40479768	9	12
37600000	317576	3	7
44356062	1759842	0	0
44350492	1119510	0	0
44346067	1112807	0	0
45649268	19078461	2	3
45632118	1549786	0	0
45655726	1595799	0	0
45626835	1125315	0	0
45663655	1125315	0	0
45624536	1119510	0	0
45639426	1551099	0	0
45654965	1112807	0	0
45671237	1589505	0	0
45688834	1759842	0	0
45671942	1127433	2	3
45782008	1125315	0	0
45780253	975125	0	0
45693847	1129625	0	0
45803052	1119510	0	0
45803429	1119510	0	0
45790824	1119510	0	0
45798788	1129625	0	0
46312454	975125	0	0
46309382	914335	0	0
46304466	1125315	0	0
4179922	439777	2	2
21001380	1713671	2	3
21002332	920293	0	0
21002863	1125315	0	0
35508846	1119510	0	0
36157761	1125315	0	0
36303153	4144583	9	9
37202317	4112343	3	6
44356111	1129625	0	0
44350605	1119510	0	0
44346002	1115008	0	0
44344813	40228214	2	3
45632118	19127890	0	0
45655726	1521369	0	0
45626979	1125315	0	0
45663735	1125315	0	0
45624913	1119510	0	0
45639431	1310149	0	0
45700759	1112807	0	0
45671410	1174888	0	0
45688874	1174888	0	0
45671977	19019979	2	3
45782208	1125315	0	0
45780266	1124957	0	0
45694167	1129625	0	0
45802993	1119510	0	0
45803357	1119510	0	0
45790975	1119510	0	0
45798924	1129625	0	0
46312926	1107830	0	0
46309387	1192710	0	0
46304428	1125315	0	0
4180175	4301346	2	2
21000830	1551192	2	3
21002350	1768849	0	0
21003153	738818	0	0
35508846	1125315	0	0
36157763	1125315	0	0
36303153	4145310	5	5
37202317	4294548	3	6
44356062	1713332	0	0
44346468	1119510	0	0
44346008	1551099	0	0
45661826	19078461	2	3
45632103	1174888	0	0
45655780	740275	0	0
45626868	1125315	0	0
45663761	1125315	0	0
45668463	1119510	0	0
45639432	19078219	0	0
45701538	1112807	0	0
45671444	738818	0	0
45688816	19127890	0	0
45672108	40232448	2	3
45782011	1125315	0	0
45780202	975125	0	0
45693859	1129625	0	0
45800135	1119510	0	0
45803452	1119510	0	0
45791037	1119510	0	0
45799681	1129625	0	0
46312406	1713332	0	0
46309450	967823	0	0
46304430	1125315	0	0
4180170	4283893	2	2
21000474	19008572	2	3
21002410	1746114	0	0
21003153	1115008	0	0
35508949	1125315	0	0
36157347	1125315	0	0
36303153	80180	5	7
36703500	4132546	3	6
44356063	1192710	0	0
44346648	1119510	0	0
44346099	791967	0	0
44341563	1332419	2	3
45632105	967823	0	0
45655782	1149196	0	0
45626887	1125315	0	0
45663772	1125315	0	0
45668794	1119510	0	0
45639433	1308738	0	0
45701565	1112807	0	0
45669875	1539403	0	0
45688816	1512674	0	0
45672071	40174880	2	3
45782189	1125315	0	0
45780272	1174888	0	0
45694038	1129625	0	0
45800137	1119510	0	0
45803505	1119510	0	0
45791887	1119510	0	0
45799845	1129625	0	0
46312525	975125	0	0
46309359	1107830	0	0
46304445	1125315	0	0
4193318	4112343	2	2
21000474	1551192	2	3
21001738	1149196	0	0
21003174	1119510	0	0
35506856	1713332	0	0
36157361	1125315	0	0
36303153	4029498	5	8
36718338	4001336	3	6
44355637	715997	0	0
44346749	1119510	0	0
44346102	1112807	0	0
44348218	1332419	2	3
45631740	1343916	0	0
45655737	1192710	0	0
45623286	1125315	0	0
45663701	1125315	0	0
45668704	1119510	0	0
45639446	1310149	0	0
45701613	1112807	0	0
45669813	1107830	0	0
45688816	1549786	0	0
45671784	19008572	2	3
45779575	1125315	0	0
45780334	1107830	0	0
45694187	1129625	0	0
45799916	1119510	0	0
45803481	1119510	0	0
45791895	1119510	0	0
45799045	1129625	0	0
46312544	1307863	0	0
46309360	920293	0	0
46304477	1125315	0	0
4193169	40481087	2	2
21001379	19073188	2	3
21001738	738818	0	0
21003174	1149196	0	0
35506797	140673	0	0
36157363	1125315	0	0
36303153	317576	5	11
37200000	317009	3	5
44355881	1310149	0	0
44346533	1119510	0	0
44346115	701322	0	0
44350812	40228214	2	3
45631746	1332418	0	0
45655889	1124300	0	0
45623294	1125315	0	0
45663323	1125315	0	0
45668718	1119510	0	0
45639450	738818	0	0
45701742	1112807	0	0
45669729	1501700	0	0
45688859	1332418	0	0
45671874	40169281	2	3
45779589	1125315	0	0
45780275	1115008	0	0
45694010	1129625	0	0
45800114	1119510	0	0
45803495	1119510	0	0
45791922	1119510	0	0
45793489	1129625	0	0
46313165	1115008	0	0
46309393	1000560	0	0
46304629	1125315	0	0
4189544	4024958	2	2
21001379	19133873	2	3
21001739	1778162	0	0
21003174	1153428	0	0
35506858	1177480	0	0
36157364	1125315	0	0
36303153	257012	5	11
37202310	261325	3	5
44355781	1112807	0	0
44346537	1119510	0	0
44346117	1153428	0	0
44351287	19075601	2	3
45628761	1738521	0	0
45656022	1115008	0	0
45623295	1125315	0	0
45663324	1125315	0	0
45668873	1119510	0	0
45639463	1110410	0	0
45701643	1112807	0	0
45669826	1192710	0	0
45688863	738818	0	0
45783885	1115171	2	3
45779698	1125315	0	0
45780307	1192710	0	0
45694012	1129625	0	0
45800026	1119510	0	0
45800751	1119510	0	0
45792039	1119510	0	0
45793517	1129625	0	0
46312690	791967	0	0
46309366	1124957	0	0
46304639	1125315	0	0
4130851	4113008	2	2
21001379	19073183	2	3
21001692	1310149	0	0
21003205	1119510	0	0
35506815	1129625	0	0
36157427	1125315	0	0
36303153	4237458	5	11
37002287	4116491	3	5
44355646	1738521	0	0
44346539	1119510	0	0
44346015	1501700	0	0
44355091	19075601	2	3
45628442	1332418	0	0
44348222	742185	0	0
45623338	1125315	0	0
45663416	1125315	0	0
45668876	1119510	0	0
45639590	1149196	0	0
45701762	1112807	0	0
45669831	1738521	0	0
45689001	1343916	0	0
45783895	19133873	2	3
45779523	1125315	0	0
45780357	1521369	0	0
45694403	1129625	0	0
45800120	1119510	0	0
45800652	1119510	0	0
45791078	1119510	0	0
45793687	1129625	0	0
46313177	1192710	0	0
46303394	1343916	0	0
46304668	1125315	0	0
4130851	4278672	2	2
21000408	1551192	2	3
21001738	1119510	0	0
21003156	1125315	0	0
35506918	1119510	0	0
36157437	1125315	0	0
36303153	4280726	5	12
37502347	4117038	3	5
44355884	1149380	0	0
44346763	1119510	0	0
44346121	1115008	0	0
44343706	19075601	2	3
45628704	1332418	0	0
44348124	1124957	0	0
45623373	1125315	0	0
45663889	1125315	0	0
45668895	1119510	0	0
45639606	1501700	0	0
45698513	1112807	0	0
45669833	1717327	0	0
45689018	1107830	0	0
45783958	1115171	2	3
45779649	1125315	0	0
45780230	1326303	0	0
45691047	1129625	0	0
45800256	1119510	0	0
45800897	1119510	0	0
46294580	1119510	0	0
45793626	1129625	0	0
46312531	1115008	0	0
46303521	1332418	0	0
46305172	1125315	0	0
4190185	30753	2	2
21001378	19075001	2	3
21001744	1713332	0	0
21003156	1112807	0	0
35506918	738818	0	0
36157410	1125315	0	0
36303153	439777	4	9
37202320	40486433	3	5
44355810	1129625	0	0
44346764	1119510	0	0
44346167	791967	0	0
45655863	19079524	2	3
45628450	1107830	0	0
44348253	705944	0	0
45623479	1125315	0	0
45663894	1125315	0	0
45668954	1119510	0	0
45639598	1000560	0	0
45698681	1112807	0	0
45669847	1361711	0	0
45688911	1153428	0	0
45783905	19018935	2	3
45779730	1125315	0	0
45780400	19003953	0	0
45691025	1129625	0	0
45800262	1119510	0	0
45800931	1119510	0	0
46294808	1119510	0	0
45793790	1129625	0	0
46312853	1738521	0	0
46303861	1174888	0	0
46305184	1125315	0	0
4093228	4149245	2	2
21001378	1713671	2	3
21001741	1778162	0	0
21003153	1119510	0	0
35506817	1545958	0	0
36157412	1125315	0	0
36303153	80809	4	8
37202317	40481087	3	5
44355813	1308738	0	0
44346782	1119510	0	0
44346176	1129625	0	0
44351368	19078461	2	3
45628451	715997	0	0
44348254	1153428	0	0
45623363	1125315	0	0
45663897	1125315	0	0
45668923	1119510	0	0
45639601	740275	0	0
45699028	1112807	0	0
45669852	1192710	0	0
45688978	1107830	0	0
45783998	1115171	2	3
45779800	1125315	0	0
45780277	1174888	0	0
45688631	1129625	0	0
45800382	1119510	0	0
45801014	1119510	0	0
46294175	1119510	0	0
45793853	1129625	0	0
46312866	1548195	0	0
46303865	1124957	0	0
46304500	1125315	0	0
4134148	4238715	2	2
21001378	19073188	2	3
21001738	1150836	0	0
21003174	1150770	0	0
35506865	1119510	0	0
36157529	1125315	0	0
36303153	40478878	4	5
37003663	198199	3	5
44355912	967823	0	0
44346685	1119510	0	0
44346178	1174888	0	0
44347812	1539411	2	3
45628750	1307863	0	0
44348259	1548195	0	0
45623420	1125315	0	0
45663428	1125315	0	0
45668963	1119510	0	0
45639533	1174888	0	0
45694390	1112807	0	0
45669853	1308738	0	0
45688982	1501700	0	0
45783928	43012036	2	3
45779409	1125315	0	0
45780404	1501700	0	0
45688060	1129625	0	0
45800235	1119510	0	0
45800799	1119510	0	0
46295008	1119510	0	0
45793815	1129625	0	0
46312942	1174888	0	0
46303928	933724	0	0
46304945	1125315	0	0
4043160	44805732	2	2
21000873	1551192	2	3
21001738	1107830	0	0
21003156	1129625	0	0
35506865	1125315	0	0
36157536	1125315	0	0
36303153	4246502	4	4
37003663	195588	3	6
44355992	1174888	0	0
44346617	1119510	0	0
44346179	1177480	0	0
44347450	19078461	2	3
45628600	738818	0	0
44348218	1332418	0	0
45623422	1125315	0	0
45663439	1125315	0	0
45668728	1119510	0	0
45639534	1192710	0	0
45692481	1112807	0	0
45669864	1549786	0	0
45689026	1549786	0	0
45784000	19008572	2	3
45779633	1125315	0	0
45780550	1551099	0	0
45688065	1129625	0	0
45800067	1119510	0	0
45800781	1119510	0	0
46295010	1119510	0	0
45788375	1129625	0	0
46312958	1174888	0	0
46303930	1000560	0	0
46304511	1125315	0	0
4048375	4330583	2	2
21000436	1551192	2	3
21001740	1778162	0	0
21003156	738818	0	0
35506874	705944	0	0
36157475	1125315	0	0
36303153	4151422	4	4
36718338	380378	3	4
44355917	1112807	0	0
44346713	1119510	0	0
44346190	1129625	0	0
45620855	1539411	2	3
45628708	1124300	0	0
44348191	933724	0	0
45623625	1125315	0	0
45663442	1125315	0	0
45668749	1119510	0	0
45639542	1741122	0	0
45692490	1112807	0	0
45669874	19127890	0	0
45689026	19127890	0	0
45784063	1115171	2	3
45779742	1125315	0	0
45780421	1361711	0	0
45688093	1129625	0	0
45802225	1119510	0	0
45800937	1119510	0	0
46294957	1119510	0	0
45788353	1129625	0	0
46313096	1551099	0	0
46303936	1000560	0	0
46304680	1125315	0	0
4093991	81151	4	8
21000890	46275444	2	3
21001743	1713332	0	0
21003156	1192710	0	0
35506926	1177480	0	0
36157754	1125315	0	0
36303153	4133840	4	4
36718588	381316	3	4
44355920	1118084	0	0
44346146	1119510	0	0
44346200	1332418	0	0
45661844	19079524	2	3
45628711	1000560	0	0
44348405	975125	0	0
45623645	1125315	0	0
45663844	1125315	0	0
45668880	1119510	0	0
45639612	1192710	0	0
45692716	1112807	0	0
45669874	1589505	0	0
45689026	1515774	0	0
45784174	40232448	2	3
45779803	1125315	0	0
45777763	1729720	0	0
45684964	1129625	0	0
45802436	1119510	0	0
45801090	1119510	0	0
46294430	1119510	0	0
45788543	1129625	0	0
46313042	1717327	0	0
46303937	1107830	0	0
46304929	1125315	0	0
4040400	4336464	5	8
21000890	1713671	2	3
21001750	1713332	0	0
21003205	1174888	0	0
21605050	1149380	0	0
36157499	1125315	0	0
36303153	4015189	3	7
36718588	4066995	3	4
44356127	1557272	0	0
44346829	1119510	0	0
44346153	738818	0	0
45649228	1539411	2	3
45628684	1549786	0	0
44348194	1110410	0	0
45667568	1125315	0	0
45663550	1125315	0	0
45668882	1119510	0	0
45639628	975125	0	0
45689599	1112807	0	0
45669874	1549786	0	0
45686027	723013	0	0
45784240	1115171	2	3
45779590	1125315	0	0
45777810	1589505	0	0
45684937	1129625	0	0
45802437	1119510	0	0
45801046	1119510	0	0
46294677	1119510	0	0
45788615	1129625	0	0
46313104	1154029	0	0
46306441	933724	0	0
46304936	1125315	0	0
4043022	4330583	4	8
21000874	1551192	2	3
21001749	1717327	0	0
21003205	1112807	0	0
21604191	782043	0	0
36157741	1125315	0	0
36303153	4010253	3	7
36703500	4029498	3	4
44356001	1110410	0	0
44346830	1119510	0	0
44346344	1129625	0	0
45620429	40228230	2	3
45628684	1515774	0	0
44348409	738818	0	0
45667655	1125315	0	0
45663746	1125315	0	0
45670354	1119510	0	0
45639594	1728416	0	0
45689802	1112807	0	0
45669673	715997	0	0
45686038	1110410	0	0
45783942	40228230	2	3
45779705	1125315	0	0
45777707	1308738	0	0
45685137	1129625	0	0
45802278	1119510	0	0
45800774	1119510	0	0
46294767	1119510	0	0
45788317	1129625	0	0
46313107	1124300	0	0
46306448	1738521	0	0
46321017	1125315	0	0
4043161	4336464	6	8
21000404	1551192	2	3
21001766	1174888	0	0
21003205	1192710	0	0
21604192	19002770	0	0
36157637	1125315	0	0
36303153	4012477	3	6
36718119	378419	3	4
44355844	1149196	0	0
44346839	1119510	0	0
44346258	738818	0	0
45620429	40228214	2	3
45628625	1102527	0	0
44348200	738818	0	0
45667573	1125315	0	0
45663449	1125315	0	0
45666595	1119510	0	0
45639651	1174888	0	0
45689731	1112807	0	0
45669780	1326303	0	0
45686042	1102527	0	0
45782075	40232448	2	3
45779692	1125315	0	0
45777709	1549786	0	0
45684790	1129625	0	0
45800422	1119510	0	0
45800777	1119510	0	0
46244039	1119510	0	0
45788349	1129625	0	0
46313194	1115008	0	0
46306951	967823	0	0
46321559	1125315	0	0
4180169	4112343	4	8
21000702	1545959	2	3
21001745	1713332	0	0
21002036	1713332	0	0
21604193	19039298	0	0
36157699	1125315	0	0
36303153	4052083	3	3
37202316	317009	3	4
44355921	1343916	0	0
44346288	1119510	0	0
44346525	1305058	0	0
45620676	40228214	2	3
45631131	1501700	0	0
44348265	1545958	0	0
45667842	1125315	0	0
45660205	1125315	0	0
45666729	1119510	0	0
45639652	1174888	0	0
45689783	1112807	0	0
45669787	1322184	0	0
45686047	1332418	0	0
45782076	44816277	2	3
45779760	1125315	0	0
45777709	19127890	0	0
45685094	1129625	0	0
45797326	1119510	0	0
45801039	1119510	0	0
46244043	1119510	0	0
45788570	1129625	0	0
46313140	708298	0	0
46307069	1307863	0	0
46320827	1125315	0	0
4180169	258780	4	8
21000702	1539411	2	3
21001743	1759842	0	0
21002025	1713332	0	0
21603497	1149196	0	0
36157564	1125315	0	0
36300000	192671	5	10
37003663	4116491	3	4
44355922	1124957	0	0
44346410	1119510	0	0
44346204	1192710	0	0
44354798	40228214	2	3
45631136	1521369	0	0
45651975	1192710	0	0
45667800	1125315	0	0
45660219	1125315	0	0
45666731	1119510	0	0
45639527	1149196	0	0
45689852	1112807	0	0
45670405	705944	0	0
45686050	1549786	0	0
45782117	42707627	2	3
45779812	1125315	0	0
45777709	1589505	0	0
45685552	1129625	0	0
45797525	1119510	0	0
45801083	1119510	0	0
46244100	1119510	0	0
45788505	1129625	0	0
46313144	975125	0	0
46304046	715997	0	0
46321184	1125315	0	0
4047779	378419	5	8
21000375	1551192	2	3
21001757	1768849	0	0
21500864	1343916	0	0
21603513	1150836	0	0
36157574	1125315	0	0
36300000	4058899	5	10
36703483	4043241	3	3
44355933	975125	0	0
44346299	1119510	0	0
44346154	1310149	0	0
44354639	40228214	2	3
45631136	1595799	0	0
45651976	1741122	0	0
45667936	1125315	0	0
45660371	1125315	0	0
45666864	1119510	0	0
45639528	975125	0	0
45686624	1112807	0	0
45670409	715997	0	0
45686050	19127890	0	0
45781948	1551192	2	3
45779823	1125315	0	0
45777720	1115008	0	0
45685840	1129625	0	0
45797544	1119510	0	0
45800888	1119510	0	0
46244101	1119510	0	0
45788678	1129625	0	0
46313147	1149196	0	0
46304049	975125	0	0
46321191	1125315	0	0
4180628	440448	5	8
21000471	1551192	2	3
21001738	1112807	0	0
21500927	975125	0	0
21603514	1107830	0	0
36157578	1125315	0	0
36300000	4010253	4	9
40782473	3000876	3	3
44356036	1112807	0	0
44346790	1119510	0	0
44346209	1729720	0	0
44347162	40228214	2	3
45631136	1549786	0	0
45651976	1746114	0	0
45667738	1125315	0	0
45660383	1125315	0	0
45664075	1119510	0	0
45639475	740275	0	0
45686631	1112807	0	0
45670610	723013	0	0
45686050	1521369	0	0
45781919	43012036	2	3
45779766	1125315	0	0
45777725	967823	0	0
45682152	1129625	0	0
45797577	1119510	0	0
45800993	1119510	0	0
46244075	1119510	0	0
45788655	1129625	0	0
46312628	1343916	0	0
46304050	1153428	0	0
46321331	1125315	0	0
4117930	4285898	4	9
21000472	19007333	2	3
21001743	1717327	0	0
21500889	975125	0	0
21602800	1738521	0	0
36157766	1125315	0	0
36300000	4024289	6	9
40772883	3001488	3	3
44356177	1177480	0	0
44346792	1119510	0	0
44346243	1124957	0	0
44347162	40228230	2	3
45630830	1539403	0	0
45652231	1102527	0	0
45667742	1125315	0	0
45660340	1125315	0	0
45664390	1119510	0	0
45639569	1332418	0	0
45686846	1112807	0	0
45670583	914335	0	0
45686143	967823	0	0
45779563	43012036	2	3
45779792	1125315	0	0
45777640	920293	0	0
45682155	1129625	0	0
45797735	1119510	0	0
45801150	1119510	0	0
46244165	1119510	0	0
45788661	1129625	0	0
46313259	1115008	0	0
46304215	1174888	0	0
46321451	1125315	0	0
4093991	78272	4	9
21000472	1551192	2	3
21001749	1713332	0	0
21500892	975125	0	0
21602016	1129625	0	0
36157643	1125315	0	0
36300000	4252419	6	9
40772617	3008598	3	3
44356081	1124300	0	0
44348446	1119510	0	0
44346160	1129625	0	0
44347677	40228214	2	3
45631094	1107830	0	0
45651820	1115008	0	0
45667743	1125315	0	0
45660334	1125315	0	0
45664393	1119510	0	0
45639589	1149380	0	0
45686941	1112807	0	0
45670278	1545958	0	0
45685623	1154343	0	0
45779589	40162522	2	3
45779884	1125315	0	0
45777656	1115008	0	0
45682381	1129625	0	0
45797845	1119510	0	0
45799770	1119510	0	0
46244175	1119510	0	0
46297507	1129625	0	0
46312733	1501700	0	0
46304229	975125	0	0
46321080	1125315	0	0
4042140	4237458	3	9
4301351	4323902	2	6
21001749	1759842	0	0
21500973	975125	0	0
35508949	1177480	0	0
36157710	1125315	0	0
36300000	134438	6	11
37203740	260139	3	3
44356118	1110410	0	0
44348382	1119510	0	0
44346320	1115008	0	0
44347677	40228230	2	3
45631102	1153428	0	0
45651821	1738521	0	0
45667837	1125315	0	0
45660392	1125315	0	0
45664309	1119510	0	0
45639589	1137529	0	0
45686815	1112807	0	0
45669942	1107830	0	0
45685987	1396131	0	0
45779644	1115171	2	3
45779660	1125315	0	0
45777796	975125	0	0
45682349	1129625	0	0
45797599	1119510	0	0
45799716	1119510	0	0
46244232	1119510	0	0
46297934	1129625	0	0
46312630	914335	0	0
46304117	1551099	0	0
46321354	1125315	0	0
4042140	380378	4	7
4301351	4117038	2	6
21001750	1728416	0	0
21500954	1129625	0	0
35508985	1119510	0	0
36157616	1125315	0	0
36300000	80809	6	10
37003668	198199	3	3
44356119	1545958	0	0
44342766	1119510	0	0
44346326	975125	0	0
44354620	40223768	2	3
45630976	1713332	0	0
45649324	1174888	0	0
45667838	1125315	0	0
45660504	1125315	0	0
45778196	1119510	0	0
45639672	1154029	0	0
45686809	1112807	0	0
45669927	1192710	0	0
45686104	1500211	0	0
45779737	1115171	2	3
45779602	1125315	0	0
45777797	723013	0	0
45682191	1129625	0	0
45797698	1119510	0	0
45798088	1119510	0	0
46244286	1119510	0	0
46298219	1129625	0	0
46312683	975125	0	0
46304072	975125	0	0
46321224	1125315	0	0
4042140	257012	4	9
4301351	4163971	2	7
21001757	1729720	0	0
21501001	967823	0	0
35508985	738818	0	0
36157621	1125315	0	0
36300000	40478878	6	7
36718163	4043241	3	3
44356122	1501700	0	0
44342777	1119510	0	0
44346327	1129625	0	0
45655524	1539411	2	3
45631023	1107830	0	0
45649327	1174888	0	0
45667546	1125315	0	0
45660505	1125315	0	0
45661833	1119510	0	0
45639676	914335	0	0
45683577	1112807	0	0
45669901	1000560	0	0
45686169	1305058	0	0
45779742	40162522	2	3
45779920	1125315	0	0
45777804	1124300	0	0
45682369	1129625	0	0
45797861	1119510	0	0
45798185	1119510	0	0
46244289	1119510	0	0
46298169	1129625	0	0
46312841	705944	0	0
46304080	1153428	0	0
46321203	1125315	0	0
4042140	30753	4	8
4171379	198199	2	4
21001746	1713332	0	0
21003205	1129625	0	0
35508990	1129625	0	0
36158064	1125315	0	0
36300000	44782520	7	10
37003664	4056621	3	3
44356182	1343916	0	0
44342760	1119510	0	0
44346302	1149196	0	0
44347738	40228214	2	3
45631220	1149380	0	0
45649408	1174888	0	0
45668017	1125315	0	0
45660506	1125315	0	0
45661649	1119510	0	0
45639542	1746114	0	0
45683720	1112807	0	0
45669976	1192710	0	0
45686172	1115008	0	0
45779747	1115171	2	3
45779923	1125315	0	0
45777790	1192710	0	0
45682124	1129625	0	0
45794855	1119510	0	0
45798069	1119510	0	0
46244373	1119510	0	0
46298237	1129625	0	0
46312878	1000560	0	0
46304087	1322184	0	0
46321473	1125315	0	0
4042140	4132546	4	8
4309188	30753	2	4
21001746	1759842	0	0
21003217	1129625	0	0
35508992	1738521	0	0
36158115	1125315	0	0
36300000	4047491	7	10
37003664	198199	3	3
44356186	1309944	0	0
44342788	1119510	0	0
44346309	1112807	0	0
44362456	40223768	2	3
45628783	1107830	0	0
45649411	757627	0	0
45667163	1125315	0	0
45660359	1125315	0	0
45661673	1119510	0	0
45639680	1107830	0	0
45683888	1112807	0	0
45669903	1124300	0	0
45685762	1000560	0	0
45779803	40229134	2	3
45708118	1125315	0	0
45777791	1154343	0	0
45678881	1129625	0	0
45797135	1119510	0	0
45798261	1119510	0	0
46244384	1119510	0	0
46298178	1129625	0	0
46313032	1310149	0	0
46304307	1308738	0	0
46320954	1125315	0	0
4042140	4035415	4	8
4301347	4301346	1	1
21001753	1768849	0	0
21002884	1746114	0	0
35508994	791967	0	0
36158076	1125315	0	0
36300000	4027663	7	11
40779671	3026361	3	3
44356190	738818	0	0
44342874	1119510	0	0
44346313	1124957	0	0
44354923	19078461	2	3
45628822	1124957	0	0
45649556	975125	0	0
45667219	1125315	0	0
45660347	1125315	0	0
45661767	1119510	0	0
45639660	715997	0	0
45683932	1112807	0	0
45670023	1501700	0	0
45685768	1713332	0	0
45779837	19008572	2	3
45708354	1125315	0	0
45777634	1124300	0	0
45678862	1129625	0	0
45797188	1119510	0	0
45798397	1119510	0	0
46244402	1119510	0	0
46298339	1129625	0	0
46312649	967823	0	0
46304608	1545958	0	0
46320967	1125315	0	0
4042140	81151	5	10
4301347	44783196	1	1
21001757	1713332	0	0
21002894	1717327	0	0
35508935	1153428	0	0
36158023	1125315	0	0
36300000	317009	7	8
37503950	4043071	3	3
44356207	1129625	0	0
44342964	1119510	0	0
44346244	975125	0	0
44362563	19078461	2	3
45628825	1778162	0	0
45649574	738818	0	0
45667193	1125315	0	0
45660416	1125315	0	0
45661320	1119510	0	0
45639856	1124300	0	0
45684007	1112807	0	0
45781234	791967	0	0
45685769	738818	0	0
45708337	19019273	2	3
45708207	1125315	0	0
45777741	975125	0	0
45678746	1129625	0	0
45797190	1119510	0	0
45798508	1119510	0	0
46239161	1119510	0	0
46298382	1129625	0	0
46313034	1343916	0	0
46304281	1549786	0	0
46321582	1125315	0	0
4042140	4294548	5	10
4214956	45766064	1	1
21001758	1728416	0	0
21002894	1741122	0	0
35509025	1107830	0	0
36157982	1125315	0	0
36300000	4237458	7	13
40782921	3019406	3	3
44356224	1322184	0	0
44343084	1119510	0	0
44346245	975125	0	0
44348023	19078461	2	3
45628781	1738521	0	0
45649264	975125	0	0
45667249	1125315	0	0
45660422	1125315	0	0
45777849	1119510	0	0
45639549	1361711	0	0
45680558	1112807	0	0
45781326	1000560	0	0
45685971	1110410	0	0
45777957	920334	2	3
45708348	1125315	0	0
45777746	1192710	0	0
45706689	1119510	0	0
45795027	1119510	0	0
45795393	1119510	0	0
46239175	1119510	0	0
46298545	1129625	0	0
46312795	1115008	0	0
46304281	19127890	0	0
46321585	1125315	0	0
4042140	440448	5	10
19057704	19128263	1	1
21001751	1717327	0	0
21002894	1778162	0	0
35508873	1124300	0	0
36158237	1125315	0	0
36300000	198809	7	13
37019273	195588	3	3
44356245	701322	0	0
44342796	1119510	0	0
44346479	975125	0	0
45661755	19078461	2	3
45628788	1124300	0	0
45649216	1713332	0	0
45665454	1125315	0	0
45660431	1125315	0	0
45777823	1119510	0	0
45639551	1308738	0	0
45680671	1112807	0	0
45781278	738818	0	0
45685779	1174888	0	0
45777970	19059056	2	3
45777918	1125315	0	0
45777704	1521369	0	0
45706693	1119510	0	0
45795053	1119510	0	0
45795561	1119510	0	0
46239371	1119510	0	0
46298300	1129625	0	0
46312812	1309944	0	0
46304197	975125	0	0
46321588	1125315	0	0
4042140	40480160	5	9
19057704	19128022	1	1
21001757	1759842	0	0
21002894	1746114	0	0
35508874	1551099	0	0
36158073	1125315	0	0
36300000	257012	7	13
40797982	3004501	3	3
44356246	1153428	0	0
44343134	1119510	0	0
44346221	1539403	0	0
44354919	19078461	2	3
45628795	1307863	0	0
45649220	1501700	0	0
45665581	1125315	0	0
45660438	1125315	0	0
45654850	1119510	0	0
45639913	1174888	0	0
45682260	1112807	0	0
45781281	723013	0	0
45686206	1539403	0	0
45705861	19008572	2	3
45778205	1125315	0	0
45777704	19127890	0	0
45705287	1119510	0	0
45795089	1119510	0	0
45795570	1119510	0	0
46239433	1119510	0	0
46289703	1129625	0	0
46312928	1192710	0	0
46304287	791967	0	0
46321590	1125315	0	0
4042140	4146173	5	9
4337138	4337611	1	1
21001744	1759842	0	0
21002902	1557272	0	0
35508877	1125315	0	0
36157977	1125315	0	0
36300000	4280726	7	14
37202310	4051466	3	3
44356040	19127890	0	0
44343004	1119510	0	0
44346229	1129625	0	0
44362331	19078461	2	3
45628841	1501700	0	0
45649222	1307863	0	0
45665677	1125315	0	0
45660475	1125315	0	0
45635051	1177480	0	0
45639559	1343916	0	0
45677489	1112807	0	0
45781273	1124957	0	0
45686142	1501700	0	0
45705769	40232448	2	3
45778139	1125315	0	0
45777704	1549786	0	0
45705238	1119510	0	0
45795149	1119510	0	0
45795579	1119510	0	0
46239533	1119510	0	0
46290057	1129625	0	0
46312929	1153428	0	0
46304302	1000560	0	0
46321595	1125315	0	0
4042140	198809	5	9
4340361	4166224	1	1
21001769	1738521	0	0
21002885	1746114	0	0
35508945	1125315	0	0
36103041	198199	6	6
36300000	80180	7	9
40772892	3049273	3	3
44356040	1589505	0	0
44343011	1119510	0	0
44346261	1549786	0	0
44357763	19078461	2	3
45628890	1332418	0	0
44337912	1177480	0	0
45665682	1125315	0	0
45660571	1125315	0	0
45635028	1177480	0	0
45639804	1192710	0	0
45677484	1112807	0	0
45781385	1713332	0	0
45686180	1115008	0	0
45706088	40232448	2	3
45777960	1125315	0	0
45777751	1154343	0	0
45705267	1119510	0	0
45795057	1119510	0	0
45795546	1119510	0	0
46239547	1119510	0	0
46290270	1129625	0	0
46312931	1717327	0	0
46304356	1343916	0	0
46321614	1125315	0	0
4042140	4266809	5	8
4261784	81893	1	1
21001769	1713332	0	0
21002895	1557272	0	0
35508945	1119510	0	0
36102970	433125	6	6
36300000	40479768	11	14
37202312	255848	3	3
44356040	1549786	0	0
44343098	1119510	0	0
44346261	19127890	0	0
44358074	19078461	2	3
45625735	1149196	0	0
44778256	1177480	0	0
45665603	1125315	0	0
45660487	1125315	0	0
45635017	1177480	0	0
45636477	1115008	0	0
45677784	1112807	0	0
45781123	1545958	0	0
45686181	738818	0	0
45706043	1551192	2	3
45777941	1125315	0	0
45777779	1548195	0	0
45780010	1119510	0	0
45792279	1119510	0	0
45795592	1119510	0	0
46239639	1119510	0	0
46290245	1129625	0	0
46313223	738818	0	0
46304314	1000560	0	0
46321619	1125315	0	0
4042140	198199	5	8
4217966	4047491	1	1
21001745	1759842	0	0
21002912	1551099	0	0
35508948	975125	0	0
36102970	28060	6	6
36300000	4218389	8	10
36718588	4029498	3	3
44356047	1149380	0	0
44343173	1119510	0	0
44346261	1515774	0	0
44340037	19078461	2	3
45625844	1332418	0	0
44778258	1177480	0	0
45665737	1125315	0	0
45660616	1125315	0	0
45634991	1177480	0	0
45636299	1107830	0	0
45677864	1112807	0	0
45781335	1343916	0	0
45686155	1000560	0	0
45705901	19077344	2	3
45778031	1125315	0	0
45706372	1503184	0	0
45779967	1119510	0	0
45792360	1119510	0	0
45795646	1119510	0	0
46239560	1119510	0	0
46290294	1129625	0	0
46313224	1149196	0	0
46320092	1521369	0	0
46321657	1125315	0	0
4042140	4156265	5	8
4201402	440448	1	1
21001772	1107830	0	0
21002900	1589505	0	0
35508952	1125315	0	0
36100000	4048171	6	6
36300000	140673	8	10
40779558	3005136	3	3
44356050	1129625	0	0
44343216	1119510	0	0
44346262	1177480	0	0
44340639	19078461	2	3
45625857	1174888	0	0
44778237	1177480	0	0
45665617	1125315	0	0
45660733	1125315	0	0
45635282	1177480	0	0
45636300	1124957	0	0
45674282	1112807	0	0
45781368	1174888	0	0
45685939	967823	0	0
45705992	19008572	2	3
45778000	1125315	0	0
45706372	19127890	0	0
45779679	1119510	0	0
45792364	1119510	0	0
45795649	1119510	0	0
46239580	1119510	0	0
46289670	1129625	0	0
46313079	1174888	0	0
46320092	1549786	0	0
46321664	1125315	0	0
4042140	45769019	6	8
4201540	4108705	1	1
21001770	1149196	0	0
21002900	1500211	0	0
35508960	1119510	0	0
35802131	4156265	6	8
36300000	440086	8	10
37503959	4337138	3	3
44356143	738818	0	0
44343020	1119510	0	0
44346463	1192710	0	0
45655888	19078461	2	3
45625941	1738521	0	0
44358319	1177480	0	0
45665633	1125315	0	0
45660641	1125315	0	0
45635382	1177480	0	0
45636302	1149380	0	0
45676225	1112807	0	0
45781375	967823	0	0
45686006	1110410	0	0
45703694	19078461	2	3
45778003	1125315	0	0
45706372	1521369	0	0
45780195	1119510	0	0
45792427	1119510	0	0
45795690	1119510	0	0
46239679	1119510	0	0
46292015	1129625	0	0
46313084	740275	0	0
46320254	1118084	0	0
46315312	1125315	0	0
4042140	4113008	6	7
19086049	19126352	1	1
21001744	1717327	0	0
21002975	914335	0	0
35508962	1119510	0	0
36102154	4116491	6	8
36300000	80502	8	10
36718119	4132546	3	3
44356057	1124957	0	0
44339274	1119510	0	0
44346463	1112807	0	0
44351125	19078461	2	3
45625563	1115008	0	0
44358502	1177480	0	0
45663134	1125315	0	0
45658565	1125315	0	0
45635345	1177480	0	0
45636366	975125	0	0
45674422	1112807	0	0
45781100	1149196	0	0
45686016	1153428	0	0
45703575	40228214	2	3
45705648	1125315	0	0
45706542	791967	0	0
45780063	1119510	0	0
45792429	1119510	0	0
45796925	1119510	0	0
46239757	1119510	0	0
46242013	1129625	0	0
46307371	1539403	0	0
46320257	1112807	0	0
46315366	1125315	0	0
4042140	378419	6	9
19084040	19077344	1	1
21506158	967823	0	0
21003001	1500211	0	0
35508962	738818	0	0
35202461	4048171	6	9
36300000	4056621	8	12
40782530	3005136	4	4
44356166	1738521	0	0
44339412	1119510	0	0
44346248	1115008	0	0
44354810	19078461	2	3
45625512	1738521	0	0
44358598	1177480	0	0
45663231	1125315	0	0
45658566	1125315	0	0
45629993	1177480	0	0
45636030	1551099	0	0
45674554	1112807	0	0
45781127	1332418	0	0
45685752	1322184	0	0
45703873	19057271	2	3
45705587	1125315	0	0
45706587	1149196	0	0
45780118	1119510	0	0
45792631	1119510	0	0
45796937	1119510	0	0
46239588	1119510	0	0
46242024	1129625	0	0
46307535	1192710	0	0
46320341	1713332	0	0
46315373	1125315	0	0
4180627	4275113	6	8
19084980	19077572	1	1
21506206	1332418	0	0
21002898	1548195	0	0
35508967	1713332	0	0
36200000	40479422	6	11
36300000	4132546	8	12
37503959	4323902	4	4
44356158	1124300	0	0
44339606	1119510	0	0
44346465	738818	0	0
44358137	1332419	2	3
45625868	1332418	0	0
44358610	1177480	0	0
45663232	1125315	0	0
45658374	1125315	0	0
45630039	1177480	0	0
45636630	1115008	0	0
45671545	1112807	0	0
45781128	1124300	0	0
45685753	1713332	0	0
45702268	40223834	2	3
45705852	1125315	0	0
45706420	1551099	0	0
45779971	1119510	0	0
45792161	1119510	0	0
45797227	1119510	0	0
46239658	1119510	0	0
46242233	1129625	0	0
46307850	1124957	0	0
46320341	1759842	0	0
46315624	1125315	0	0
4180627	4242997	6	7
19085458	836659	1	1
21506167	1115008	0	0
21002900	1521369	0	0
35508967	1759842	0	0
36102149	433125	7	7
4141937	4323902	3	3
37503959	4337611	4	4
44356162	738818	0	0
44339512	1119510	0	0
44346361	1501700	0	0
44354574	1332419	2	3
45625912	1115008	0	0
44351368	1177480	0	0
45663283	1125315	0	0
45650247	1713332	0	0
45630133	1177480	0	0
45636522	1309944	0	0
45671533	1112807	0	0
45781161	740275	0	0
45686162	1149380	0	0
45702354	920334	2	3
45705856	1125315	0	0
45706422	1500211	0	0
45779977	1119510	0	0
45792447	1119510	0	0
45797247	1119510	0	0
46239728	1119510	0	0
46241918	1129625	0	0
46307863	738818	0	0
46320270	1118084	0	0
46315628	1125315	0	0
4180627	44783196	3	8
19061283	19128009	1	1
21500621	753626	0	0
21002900	1549786	0	0
35508968	1129625	0	0
36102154	28060	7	7
4181063	198809	3	3
36718119	4001336	4	4
44352659	1129625	0	0
44339623	1119510	0	0
44346056	1149380	0	0
44340600	1332419	2	3
45625915	757627	0	0
44351445	1177480	0	0
45663284	1125315	0	0
45650552	1759842	0	0
45630168	1177480	0	0
45636217	738818	0	0
45669905	1112807	0	0
45781165	1124957	0	0
45685930	1308738	0	0
45702326	1115171	2	3
45705532	1125315	0	0
45706427	1174888	0	0
45780038	1119510	0	0
45792152	1119510	0	0
45797249	1119510	0	0
46239730	1119510	0	0
46241923	1129625	0	0
46307511	1332418	0	0
46320251	1124300	0	0
46315663	1125315	0	0
4180627	4058899	3	8
19019339	19129144	1	1
21500645	19003953	0	0
21002900	1512674	0	0
35508969	1112807	0	0
36102154	433125	7	7
4181063	4280726	3	3
36718588	380378	4	4
44352661	1729720	0	0
44339627	1119510	0	0
44346059	1713332	0	0
44340822	1332419	2	3
45626006	1713332	0	0
44351412	1177480	0	0
45663180	1125315	0	0
45650449	1149380	0	0
45630260	1177480	0	0
45636449	1307863	0	0
45783881	1112807	0	0
45781250	738818	0	0
45685933	738818	0	0
45702346	40163554	2	3
45706069	1125315	0	0
45706442	1310149	0	0
45780039	1119510	0	0
45792630	1119510	0	0
45792873	1119510	0	0
46239733	1119510	0	0
46242042	1129625	0	0
46307864	738818	0	0
46320377	1174888	0	0
46315667	1125315	0	0
4180627	4186930	5	7
19019339	19127922	1	1
21013503	1361711	0	0
21002899	1557272	0	0
35508972	1310149	0	0
36102154	198199	7	7
4181063	81893	3	3
37522376	4108705	4	4
44352794	1177480	0	0
44339443	1119510	0	0
44346424	975125	0	0
44347935	1332419	2	3
45625952	1000560	0	0
44344324	1177480	0	0
45663184	1125315	0	0
45650452	1107830	0	0
45629950	1177480	0	0
45636450	1107830	0	0
45783795	1112807	0	0
45781251	1545958	0	0
45686125	1367571	0	0
45702436	40232448	2	3
45705945	1125315	0	0
45706450	1115008	0	0
45780041	1119510	0	0
45792172	1119510	0	0
45793013	1119510	0	0
45895917	1119510	0	0
46242002	1129625	0	0
46307935	1192710	0	0
46320570	1112807	0	0
46315902	1125315	0	0
4180627	4330583	5	9
19019339	19133679	1	1
21013503	975125	0	0
21003024	19039298	0	0
35508974	1129625	0	0
35802131	375671	8	10
4180941	44805732	3	3
37203758	4051466	4	4
44352838	933724	0	0
44339554	1119510	0	0
44346490	738818	0	0
44354711	1545959	2	3
45625742	738818	0	0
44337373	1177480	0	0
45663275	1125315	0	0
45650255	740275	0	0
45627213	1177480	0	0
45636460	1174888	0	0
45783798	1112807	0	0
45781251	1332418	0	0
45686133	1124300	0	0
45702502	19008572	2	3
45705809	1125315	0	0
45706412	1149196	0	0
45706900	1119510	0	0
45792514	1119510	0	0
45792825	1119510	0	0
45896106	1119510	0	0
45893540	1129625	0	0
46307945	1149196	0	0
46320579	701322	0	0
46315577	1125315	0	0
4180627	4047491	5	8
19019340	19128065	1	1
21013496	1551099	0	0
21003024	782043	0	0
35508978	1154343	0	0
35802131	378419	8	9
4180941	4163971	3	3
37503943	4117038	4	4
44352844	1115008	0	0
44339558	1119510	0	0
44346498	1551099	0	0
44340954	19078461	2	3
45625743	1110410	0	0
44337305	1177480	0	0
45663276	1125315	0	0
45650187	1153428	0	0
45627162	1177480	0	0
45636464	1307863	0	0
45783992	1112807	0	0
45781353	738818	0	0
45688610	1305058	0	0
45702435	40232448	2	3
45706047	1125315	0	0
45706598	1153428	0	0
45707015	1119510	0	0
45792651	1119510	0	0
45792831	1119510	0	0
45895878	1119510	0	0
45893649	1129625	0	0
46307705	1322184	0	0
46320580	1738521	0	0
46315968	1125315	0	0
4180627	4108705	5	8
4344027	4149245	1	1
21013536	1717327	0	0
21003003	1501700	0	0
35509042	19127890	0	0
35300000	4043241	8	8
4042505	4066995	3	5
37003680	195588	4	4
44352845	1124300	0	0
44339349	1119510	0	0
44346267	738818	0	0
44340226	1539411	2	3
45625969	1738521	0	0
44337772	1177480	0	0
45663347	1125315	0	0
45650356	740275	0	0
45627419	1177480	0	0
45636423	1149196	0	0
45781721	1112807	0	0
45781363	19127890	0	0
45688615	701322	0	0
45702480	1127433	2	3
45705785	1125315	0	0
45706537	791967	0	0
45707019	1119510	0	0
45789500	1119510	0	0
45793089	1119510	0	0
45896170	1119510	0	0
45893753	1129625	0	0
46307946	1153428	0	0
46320592	1192710	0	0
46315217	1125315	0	0
4180627	4117038	5	8
4344271	81151	1	1
21013536	1759842	0	0
21003024	1154029	0	0
35509042	1589505	0	0
36202157	40480160	9	9
4201944	4010253	3	5
37502348	4043071	4	4
44352684	1545958	0	0
44341300	1119510	0	0
44346249	723013	0	0
44337636	1738521	0	0
45625971	19127890	0	0
44337513	1177480	0	0
45663349	1125315	0	0
45650362	1107830	0	0
45627260	1177480	0	0
45636436	738818	0	0
45779232	1112807	0	0
45781363	1515774	0	0
45688621	1124957	0	0
45699381	19018935	2	3
45706079	1125315	0	0
45706491	1322184	0	0
45706100	1119510	0	0
45789558	1119510	0	0
45793128	1119510	0	0
45896136	1119510	0	0
45893826	1129625	0	0
46307995	1501700	0	0
46320764	1738521	0	0
46315935	1125315	0	0
4180627	4337611	5	8
4318404	255848	1	1
21013536	1713332	0	0
21003027	1102527	0	0
35509042	1549786	0	0
36217214	42902245	3	4
4201745	4310024	3	5
40782937	3027231	4	4
44352858	1192710	0	0
44341432	1119510	0	0
44346268	1129625	0	0
44337849	1501700	0	0
45625971	1589505	0	0
45622053	1177480	0	0
45663405	1125315	0	0
45650521	1501700	0	0
45627160	1177480	0	0
45636445	1174888	0	0
45779235	1112807	0	0
45781363	1549786	0	0
45688574	967823	0	0
45699534	19008572	2	3
45706083	1125315	0	0
45706452	1107830	0	0
45706221	1119510	0	0
45789727	1119510	0	0
45793049	1119510	0	0
45896031	1119510	0	0
45893832	1129625	0	0
46307714	1192710	0	0
46320379	920293	0	0
46316136	1125315	0	0
4180627	4323902	5	8
4321844	4117038	1	1
21002805	1124300	0	0
21003027	1110410	0	0
35509043	1177480	0	0
36217214	19128022	3	4
4201745	198809	3	5
40782937	3015076	4	4
44352685	1149196	0	0
44339676	1119510	0	0
44346059	1759842	0	0
44337601	1192710	0	0
45625971	1549786	0	0
45622019	1177480	0	0
45663076	1125315	0	0
45650636	738818	0	0
45623708	1177480	0	0
45636587	1305058	0	0
45778828	1112807	0	0
45781476	914335	0	0
45688529	1539403	0	0
45699384	40236446	2	3
45705893	1125315	0	0
45706454	705944	0	0
45706223	1119510	0	0
45789743	1119510	0	0
45793167	1119510	0	0
45895997	1119510	0	0
45801808	1129625	0	0
46307726	738818	0	0
46320595	1548195	0	0
46316026	1125315	0	0
4180627	4238715	4	6
4301352	4337138	1	1
21002805	1305058	0	0
21002900	1548195	0	0
35509056	1125315	0	0
36217214	19133768	2	3
4201745	4266809	3	5
40782937	3006734	4	4
44352810	1548195	0	0
44339831	1119510	0	0
44346375	1124957	0	0
44337637	1307863	0	0
45625870	1515774	0	0
45622090	1177480	0	0
45663518	1125315	0	0
45650718	1107830	0	0
45625223	1177480	0	0
45636508	1149196	0	0
45779265	1112807	0	0
45781219	791967	0	0
45688668	708298	0	0
45699645	19019273	2	3
45705851	1125315	0	0
45706456	1110410	0	0
45706165	1119510	0	0
45789746	1119510	0	0
45793324	1119510	0	0
45896099	1119510	0	0
45802461	1129625	0	0
46307734	933724	0	0
46320595	19054876	0	0
46315566	1125315	0	0
4180627	4010253	4	6
19057161	19128009	1	1
21002804	1778162	0	0
21003024	19002770	0	0
35509059	1125315	0	0
36217214	40223834	2	3
4201745	30753	3	5
37202317	40486433	4	4
44352966	1115008	0	0
44339699	1119510	0	0
44346253	1332418	0	0
44337873	738818	0	0
45625870	19127890	0	0
45658541	1177480	0	0
45663373	1125315	0	0
45647015	1110410	0	0
45625348	1177480	0	0
45636588	1107830	0	0
45779268	1112807	0	0
45781478	1738521	0	0
45682728	1174888	0	0
45699471	1107882	2	3
45705971	1125315	0	0
45706459	1192710	0	0
45706359	1119510	0	0
45789633	1119510	0	0
45793411	1119510	0	0
45896807	1119510	0	0
45799071	1129625	0	0
46307610	1549786	0	0
46320541	1307863	0	0
46315842	1125315	0	0
4180627	44805732	4	6
19057161	19127918	1	1
21002805	1118084	0	0
21002955	975125	0	0
35509062	19127890	0	0
36217214	1150837	2	3
4093991	4149245	4	5
37202317	4280726	4	4
44352971	1149196	0	0
44339771	1119510	0	0
44346386	975125	0	0
44338023	1713332	0	0
45625870	1549786	0	0
45658457	1177480	0	0
45663194	1125315	0	0
45646895	1717327	0	0
45625152	1177480	0	0
45636218	1000560	0	0
45779277	1112807	0	0
45781226	1501700	0	0
45682736	1521369	0	0
45699655	42707627	2	3
45705998	1125315	0	0
45706462	1174888	0	0
45706176	1119510	0	0
45789650	1119510	0	0
45791942	1119510	0	0
45804357	1119510	0	0
45799083	1129625	0	0
46307610	1521369	0	0
46320843	1149380	0	0
46315873	1125315	0	0
4180627	4301346	4	9
4233623	40478878	1	1
21003153	1125315	0	0
21002900	1557272	0	0
35509062	1515774	0	0
36217214	19018935	2	3
4113999	4285898	4	5
37203740	261325	4	4
44352927	1713332	0	0
44339772	1119510	0	0
44346061	1177480	0	0
44338026	1149196	0	0
45625881	1174888	0	0
45658869	1177480	0	0
45663660	1125315	0	0
45647246	1549786	0	0
45624518	1177480	0	0
45636638	1107830	0	0
45779287	1112807	0	0
45781230	1713332	0	0
45682868	1124957	0	0
45699659	40228230	2	3
45703861	1125315	0	0
45706552	1539403	0	0
45706255	1119510	0	0
45789768	1119510	0	0
45791978	1119510	0	0
45796287	1119510	0	0
45799164	1129625	0	0
46307612	1149196	0	0
46320861	1557272	0	0
46315886	1125315	0	0
4180627	4337138	4	7
4216752	4107731	1	1
21003156	1177480	0	0
21002901	1557272	0	0
35509062	1549786	0	0
36217214	40236446	2	3
4041261	4117038	4	5
37203740	258780	4	4
44352668	1149196	0	0
44362962	1125315	0	0
44346646	1115008	0	0
44337906	1149380	0	0
45625885	738818	0	0
45658442	1177480	0	0
45663727	1125315	0	0
45647246	1589505	0	0
45624141	1177480	0	0
45636438	1548195	0	0
45780702	1112807	0	0
45781230	1759842	0	0
45682870	1500211	0	0
45699688	43012036	2	3
45702248	1125315	0	0
45706646	1154343	0	0
45706265	1119510	0	0
45789836	1119510	0	0
45791849	1119510	0	0
45797162	1119510	0	0
45799134	1129625	0	0
46307626	967823	0	0
46320406	1124957	0	0
46316038	1125315	0	0
4180627	4057420	4	7
21000640	19127918	1	1
21003156	1115008	0	0
21003017	753626	0	0
35509068	1112807	0	0
36217214	1127433	2	3
4042505	4237458	4	5
37202310	260139	4	4
44352823	1129625	0	0
44362940	1125315	0	0
44338834	1124957	0	0
44337919	1174888	0	0
45625888	1124300	0	0
45658991	1177480	0	0
45663661	1125315	0	0
45647258	1332418	0	0
45624277	1177480	0	0
45636592	1521369	0	0
45779422	1112807	0	0
45781311	1124957	0	0
45682736	1549786	0	0
45695988	1107882	2	3
45702251	1125315	0	0
45706668	1115008	0	0
45706559	1119510	0	0
45789681	1119510	0	0
45790255	1119510	0	0
45796530	1119510	0	0
45793980	1129625	0	0
46307916	1539403	0	0
46320683	1107830	0	0
46315997	1125315	0	0
4180627	4216130	4	8
21000640	19128009	1	1
21003157	1125315	0	0
21003025	708298	0	0
35509145	1548195	0	0
36217214	19045231	2	3
4054559	4336464	4	5
36703484	4043241	4	4
44352826	738818	0	0
44362914	1125315	0	0
44338972	1124300	0	0
44778144	920293	0	0
45626019	1153428	0	0
45659047	1177480	0	0
45663158	1125315	0	0
45647261	1107830	0	0
45668393	1177480	0	0
45636153	1192710	0	0
45779455	1112807	0	0
45781389	1115008	0	0
45683056	19127890	0	0
45696207	35605482	2	3
45702256	1125315	0	0
45706721	1154343	0	0
45706561	1119510	0	0
45789965	1119510	0	0
45790279	1119510	0	0
45796535	1119510	0	0
45793702	1129625	0	0
46308144	1110410	0	0
46320687	1501700	0	0
46316009	1125315	0	0
4237321	4323902	2	2
4339410	4059173	5	5
21003174	738818	0	0
21002958	1717327	0	0
35509107	1125315	0	0
36217214	1115171	2	3
4180938	4252419	4	5
40779591	3020655	4	4
44352674	723013	0	0
44362995	1125315	0	0
44339041	742185	0	0
44778204	1545958	0	0
45626049	1000560	0	0
44352072	1177480	0	0
45663459	1125315	0	0
45647250	1551099	0	0
45668561	1177480	0	0
45636340	738818	0	0
45708069	1112807	0	0
45781391	1361711	0	0
45683056	1549786	0	0
45696095	1127433	2	3
45702242	1125315	0	0
45706724	1153428	0	0
45706404	1119510	0	0
45789165	1119510	0	0
45790243	1119510	0	0
45796630	1119510	0	0
45794091	1129625	0	0
46308021	1713332	0	0
46320698	1332418	0	0
46309612	1125315	0	0
4237321	4246502	2	2
4339410	4048695	5	5
21003174	1125315	0	0
21002958	1728416	0	0
35509107	1112807	0	0
36217214	920300	2	3
4180938	4024289	4	5
40782473	3021226	4	4
44352675	1332418	0	0
44363106	1125315	0	0
44338937	1174888	0	0
44778157	1153428	0	0
45625980	1115008	0	0
45652400	1177480	0	0
45659665	1125315	0	0
45646896	1107830	0	0
45668837	1177480	0	0
45636347	967823	0	0
45708076	1112807	0	0
45781312	1000560	0	0
45683056	1521369	0	0
45696068	42707627	2	3
45702287	1125315	0	0
45706725	1539403	0	0
45706249	1119510	0	0
45789239	1119510	0	0
45790249	1119510	0	0
45796693	1119510	0	0
45794247	1129625	0	0
46308216	975125	0	0
46320786	1738521	0	0
46309617	1125315	0	0
4237320	4326177	2	2
4339410	4278672	5	5
21003174	1129625	0	0
21002959	1728416	0	0
35509044	933724	0	0
36217214	19112599	2	3
4227253	4329847	4	5
37522284	4337611	4	4
44352769	1112807	0	0
44363100	1125315	0	0
44338938	1548195	0	0
44778165	1153428	0	0
45625827	1149196	0	0
45652431	1177480	0	0
45659917	1125315	0	0
45647263	1115008	0	0
45666138	1177480	0	0
45636325	1501700	0	0
45705329	1112807	0	0
45781625	738818	0	0
45682838	1107830	0	0
45696225	43012036	2	3
45702291	1125315	0	0
45706682	1149196	0	0
45706192	1119510	0	0
45787097	1119510	0	0
45790443	1119510	0	0
45796671	1119510	0	0
45794125	1129625	0	0
46308228	1174888	0	0
46320718	1112807	0	0
46309622	1125315	0	0
4275564	4057420	2	2
4339410	4066995	5	5
21003153	1177480	0	0
21003017	708298	0	0
35509047	1177480	0	0
36217214	40231925	2	3
4141937	4336464	5	5
37016775	4066995	4	4
44352774	967823	0	0
44363103	1125315	0	0
44338948	1129625	0	0
44778004	1149196	0	0
45626058	1107830	0	0
45652734	1177480	0	0
45659845	1125315	0	0
45647066	1551099	0	0
45666319	1177480	0	0
45636594	1322184	0	0
45705433	1112807	0	0
45781581	1332418	0	0
45683001	914335	0	0
45696255	1115171	2	3
45702270	1125315	0	0
45706729	914335	0	0
45700619	1119510	0	0
45787098	1119510	0	0
45790538	1119510	0	0
45791177	1119510	0	0
45794266	1129625	0	0
46308266	1192710	0	0
46320913	967823	0	0
46309811	1125315	0	0
4043371	440448	2	2
4339468	40486433	5	5
21003174	1150836	0	0
21003017	1102527	0	0
35509092	19127890	0	0
36217214	43012036	2	3
4201944	4037675	5	5
37016775	4048695	4	4
44352779	1717327	0	0
44363243	1125315	0	0
44338952	1124300	0	0
44778214	1589505	0	0
45625836	1115008	0	0
44344404	1177480	0	0
45659846	1125315	0	0
45647302	1174888	0	0
45666281	1177480	0	0
45636530	791967	0	0
45702051	1112807	0	0
45781700	1107830	0	0
45682991	1149196	0	0
45696290	19008572	2	3
45702305	1125315	0	0
45706637	1551099	0	0
45699774	1119510	0	0
45786990	1119510	0	0
45790414	1119510	0	0
45791178	1119510	0	0
45789340	1129625	0	0
46308286	920293	0	0
46320411	1192710	0	0
46311849	1125315	0	0
4043371	28060	2	2
4339468	4280726	5	5
21003185	1343916	0	0
21003017	791967	0	0
35509092	1549786	0	0
36217214	19077344	2	3
21502620	1759842	5	5
36702247	44782520	4	5
44352790	1589505	0	0
44363026	1125315	0	0
44338953	1713332	0	0
44782520	44782520	0	0
45626070	1107830	0	0
45646279	1177480	0	0
45660009	1125315	0	0
45647306	1107830	0	0
45665984	1177480	0	0
45636486	1308738	0	0
45703808	1112807	0	0
45781324	1125315	0	0
45683098	1115008	0	0
45696165	19008572	2	3
45702342	1125315	0	0
45706714	1307863	0	0
45699895	1119510	0	0
45786993	1119510	0	0
45790606	1119510	0	0
45791247	1119510	0	0
45789348	1129625	0	0
46307698	723013	0	0
46320596	791967	0	0
46311903	1125315	0	0
4317258	134438	2	2
4279903	4163971	5	5
21003153	1192710	0	0
21003018	1309944	0	0
35509092	1515774	0	0
36217214	40174880	2	3
4130852	40479768	5	5
37202317	258780	4	5
44352780	1539403	0	0
44363109	1125315	0	0
44339030	1118084	0	0
44778201	723013	0	0
45625676	738818	0	0
45646145	1177480	0	0
45660057	1125315	0	0
45647266	738818	0	0
45666401	1177480	0	0
45636494	1115008	0	0
45699261	1112807	0	0
45781383	1125315	0	0
45683100	1729720	0	0
45696341	40223834	2	3
45702371	1125315	0	0
45706738	967823	0	0
45699781	1119510	0	0
45787050	1119510	0	0
45790610	1119510	0	0
45791148	1119510	0	0
45788700	1129625	0	0
46308167	1308738	0	0
46320600	1545958	0	0
46312002	1125315	0	0
4215793	4059978	2	2
4200516	378001	5	5
21003174	1192710	0	0
21003027	1343916	0	0
35509113	1153428	0	0
36217214	1539411	2	3
4141833	4048171	5	5
37003663	4056621	4	5
44353090	1177480	0	0
44363394	1125315	0	0
44339039	1343916	0	0
44778271	1124957	0	0
45625839	1326303	0	0
44340998	1177480	0	0
45660155	1125315	0	0
45647267	1322184	0	0
45664617	1177480	0	0
45636469	738818	0	0
45699308	1112807	0	0
45781179	1125315	0	0
45683021	1551099	0	0
45696485	40229134	2	3
45702447	1125315	0	0
45706830	1107830	0	0
45699818	1119510	0	0
45787027	1119510	0	0
45787664	1119510	0	0
45791234	1119510	0	0
45788754	1129625	0	0
46307694	1115008	0	0
46320304	1308738	0	0
46312011	1125315	0	0
4237017	40478878	2	2
4200516	375671	5	5
21003263	933724	0	0
21003027	914335	0	0
35509114	1177480	0	0
36217216	19019979	2	3
4227253	198809	5	5
37202316	4051466	4	5
44353184	1115008	0	0
44363464	1125315	0	0
44339040	1149196	0	0
44778276	975125	0	0
45626033	1174888	0	0
44341078	1177480	0	0
45659868	1125315	0	0
45647165	757627	0	0
45664517	1177480	0	0
45636653	1154029	0	0
45695931	1112807	0	0
45781368	1125315	0	0
45683104	967823	0	0
45696487	1127433	2	3
45702520	1125315	0	0
45706616	1307863	0	0
45699970	1119510	0	0
45787166	1119510	0	0
45787722	1119510	0	0
45791239	1119510	0	0
45788904	1129625	0	0
46308287	1000560	0	0
46320911	1738521	0	0
46311993	1125315	0	0
4053826	4296204	2	2
4318379	4048171	5	5
21003174	1107830	0	0
21003025	1102527	0	0
35509201	1310149	0	0
36217216	19077572	2	3
4227253	195588	5	5
37503959	4057420	4	5
44353202	1129625	0	0
44363466	1125315	0	0
44339111	1738521	0	0
44778278	1501700	0	0
45626077	1713332	0	0
45643316	1177480	0	0
45649418	1119510	0	0
45647287	1539403	0	0
45663977	1177480	0	0
45636674	1149196	0	0
45697545	1112807	0	0
45781371	1125315	0	0
45683177	1149196	0	0
45696323	40232448	2	3
45702480	1125315	0	0
45706617	1192710	0	0
45699889	1119510	0	0
45787167	1119510	0	0
45787829	1119510	0	0
45791240	1119510	0	0
45788905	1129625	0	0
46308117	1174888	0	0
46320625	1717327	0	0
46310339	1125315	0	0
4032251	4163872	2	2
4215793	4337611	5	5
21003153	1112807	0	0
21003025	1154029	0	0
35509202	1119510	0	0
36217216	40165015	2	3
21502553	1326303	5	5
37002287	195588	4	7
44353215	1192710	0	0
44363467	1125315	0	0
44339129	705944	0	0
44778060	1149196	0	0
45626078	1153428	0	0
45643399	1177480	0	0
45649385	1119510	0	0
45647169	1174888	0	0
45664021	1177480	0	0
45636655	1115008	0	0
45697598	1112807	0	0
45781159	1125315	0	0
45683276	914335	0	0
45696519	1154615	2	3
45702415	1125315	0	0
45706620	1308738	0	0
45693482	1119510	0	0
45787188	1119510	0	0
45787871	1119510	0	0
45791355	1119510	0	0
45789012	1129625	0	0
46308170	1308738	0	0
46320999	1118084	0	0
46310341	1125315	0	0
4043197	4186930	2	2
4326426	4163971	5	5
21002808	1177480	0	0
21003025	1110410	0	0
35509119	1119510	0	0
36217216	19075001	2	3
4101219	81893	3	4
37202316	4112343	4	10
44353107	1115008	0	0
44363053	1125315	0	0
44338990	1332418	0	0
44778219	738818	0	0
45626083	1551099	0	0
45643391	1177480	0	0
45649307	1119510	0	0
45647307	1322184	0	0
45660666	1177480	0	0
45636680	753626	0	0
45697601	1112807	0	0
45781250	1125315	0	0
45683213	1521369	0	0
45696543	1545959	2	3
45699389	1125315	0	0
45706799	1124957	0	0
45693532	1119510	0	0
45787349	1119510	0	0
45786216	1119510	0	0
45791407	1119510	0	0
45788807	1129625	0	0
46308289	1551099	0	0
46321109	1124300	0	0
46310242	1125315	0	0
4194895	4062501	2	2
4197094	81893	5	6
21002808	1115008	0	0
21003025	791967	0	0
35509119	738818	0	0
36217216	19074841	2	3
4041261	4186930	3	4
37202316	40486433	4	9
44353137	1713332	0	0
44363224	1125315	0	0
44339140	1107830	0	0
44778223	1738521	0	0
45625779	1501700	0	0
45643401	1177480	0	0
45649300	1119510	0	0
45648822	705944	0	0
45660857	1177480	0	0
45636572	1115008	0	0
45697831	1112807	0	0
45781353	1125315	0	0
45683213	1549786	0	0
45693259	19059056	2	3
45699391	1125315	0	0
45706834	1107830	0	0
45693494	1119510	0	0
45787325	1119510	0	0
45786231	1119510	0	0
45791330	1119510	0	0
46296901	1129625	0	0
46308291	1192710	0	0
46320803	715997	0	0
46310263	1125315	0	0
4112731	4285898	2	2
4212577	4280726	5	6
21002808	1124300	0	0
21003063	791967	0	0
35509119	1125315	0	0
36217216	40236824	2	3
4144078	4198190	3	4
37202316	4294548	4	9
44353137	1759842	0	0
44363368	1125315	0	0
44338996	975125	0	0
44778202	1551099	0	0
45625896	1124300	0	0
45643226	1177480	0	0
45649492	1119510	0	0
45649205	1713332	0	0
45660928	1177480	0	0
45636678	1551099	0	0
45696025	1112807	0	0
45781571	1125315	0	0
45683213	19127890	0	0
45693131	40174880	2	3
45699323	1125315	0	0
45706845	1192710	0	0
45693476	1119510	0	0
45785604	1119510	0	0
45786363	1119510	0	0
45791277	1119510	0	0
46296704	1129625	0	0
46308059	705944	0	0
46321263	1551099	0	0
46310305	1125315	0	0
4045839	4336464	2	2
4212577	40486433	5	6
21002808	1551099	0	0
21003063	1115008	0	0
35509073	1119510	0	0
36217216	19073188	2	3
21505865	40236446	3	4
37202316	255848	4	8
44353113	1107830	0	0
44363514	1125315	0	0
44339167	1332418	0	0
44778069	1343916	0	0
45625911	1149196	0	0
45640340	1177480	0	0
45632050	1119510	0	0
45649073	705944	0	0
45660940	1177480	0	0
45636595	1343916	0	0
45692923	1112807	0	0
45781311	1125315	0	0
45683088	1124300	0	0
45693226	40243436	2	3
45699368	1125315	0	0
45706847	1545958	0	0
45693608	1119510	0	0
45785682	1119510	0	0
46297008	1119510	0	0
45791547	1119510	0	0
46296709	1129625	0	0
46308095	1115008	0	0
46320882	1112807	0	0
46310309	1125315	0	0
4043349	4035415	2	2
4304916	440448	5	6
21002808	1112807	0	0
21003018	1307863	0	0
35509076	1119510	0	0
36217216	1150837	2	3
4130852	4230399	3	4
36702247	375671	4	9
44352867	1112807	0	0
44363516	1125315	0	0
44339217	1124300	0	0
44778070	1343916	0	0
45626102	1343916	0	0
45640406	1177480	0	0
45641423	19079524	2	3
45649017	967823	0	0
45661006	1177480	0	0
45636600	1501700	0	0
45692993	1112807	0	0
45781625	1125315	0	0
45683281	1501700	0	0
45693231	40232448	2	3
45699586	1125315	0	0
46240175	1174888	0	0
45693616	1119510	0	0
45785508	1119510	0	0
46297012	1119510	0	0
45791282	1119510	0	0
46295026	1129625	0	0
46308079	1545958	0	0
46320805	1153428	0	0
46310372	1125315	0	0
4043671	40481087	2	2
4309188	4166224	5	6
21002808	975125	0	0
21002602	1717327	0	0
35509076	1125315	0	0
36217216	40236446	2	3
4180941	40492359	3	4
40480457	439777	4	7
44352869	975125	0	0
44363193	1125315	0	0
44339115	975125	0	0
44778230	1738521	0	0
45622643	1738521	0	0
45640411	1177480	0	0
45644392	19078924	2	3
45649023	933724	0	0
45657755	1177480	0	0
45636603	1551099	0	0
45693097	1112807	0	0
45781580	1125315	0	0
45683287	1307863	0	0
45693291	19019273	2	3
45699342	1125315	0	0
45702766	740275	0	0
45693905	1119510	0	0
45785569	1119510	0	0
46297021	1119510	0	0
45791452	1119510	0	0
46295153	1129625	0	0
46307996	1115008	0	0
46320816	1332418	0	0
46310430	1125315	0	0
4043671	28060	2	2
4322976	4043071	5	6
21002808	1118084	0	0
21002603	1746114	0	0
35509076	738818	0	0
36217216	19018935	2	3
4181193	4301346	4	4
37203758	4112343	5	9
44353158	975125	0	0
44363448	1125315	0	0
44339015	1149380	0	0
44778257	1149196	0	0
45622574	1539403	0	0
45640447	1177480	0	0
45631095	19078461	2	3
45649048	1149196	0	0
45658165	1177480	0	0
45636610	1154029	0	0
45693106	1112807	0	0
45781643	1125315	0	0
45682943	1778162	0	0
45694754	19019273	2	3
45699429	1125315	0	0
45703088	1124957	0	0
45693919	1119510	0	0
45785523	1119510	0	0
46296937	1119510	0	0
46298711	1119510	0	0
46295390	1129625	0	0
46308105	1551099	0	0
46314874	967823	0	0
46310506	1125315	0	0
4043671	257012	2	2
4322976	40478878	5	6
21002811	1112807	0	0
21002603	1717327	0	0
35509157	967823	0	0
36217216	40231925	2	3
4181193	44783196	4	4
37203758	261325	5	8
44353008	1177480	0	0
44363323	1125315	0	0
44339220	1118084	0	0
44783196	44783196	0	0
45622577	1308738	0	0
45640445	1177480	0	0
45663397	40223768	2	3
45649183	1539403	0	0
45654658	1177480	0	0
45636629	1107830	0	0
45693066	1112807	0	0
45781649	1125315	0	0
45683321	1307863	0	0
45694859	920334	2	3
45699436	1125315	0	0
45703090	1551099	0	0
45690640	1119510	0	0
45785644	1119510	0	0
46296945	1119510	0	0
46298417	1119510	0	0
46295215	1129625	0	0
46308426	1124300	0	0
46313868	1332418	0	0
46310490	1125315	0	0
4212887	4146173	2	2
4274025	80502	5	6
21002811	1115008	0	0
21002618	1746114	0	0
35509096	1129625	0	0
36217216	40162522	2	3
4141937	4057420	4	4
37203758	40486433	5	8
44352722	723013	0	0
44363589	1125315	0	0
44339224	1149380	0	0
44358139	1549786	0	0
45622618	708298	0	0
45640454	1177480	0	0
45665854	1107882	2	3
45647309	1545958	0	0
45638905	1119510	0	0
45636409	1124957	0	0
45689790	1112807	0	0
45781449	1125315	0	0
45683323	1107830	0	0
45693313	40229134	2	3
45699623	1125315	0	0
45703028	1308738	0	0
45690768	1119510	0	0
45785674	1119510	0	0
46297072	1119510	0	0
46298429	1119510	0	0
46295574	1129625	0	0
46308367	1308738	0	0
46313873	1174888	0	0
46310414	1125315	0	0
4195601	4186930	2	2
4274025	438614	5	6
21002811	1177480	0	0
21002682	1305058	0	0
35509101	1119510	0	0
36217216	43012036	2	3
4201745	196456	4	4
36718588	375671	5	7
44352901	1545958	0	0
44363592	1125315	0	0
44339232	1124957	0	0
44357924	1000560	0	0
45622630	1548195	0	0
45640380	1177480	0	0
45659604	19078924	2	3
45647406	1115008	0	0
45639204	1119510	0	0
45636554	975125	0	0
45690030	1112807	0	0
45781594	1125315	0	0
45683328	1153428	0	0
45693298	40232448	2	3
45699443	1125315	0	0
45702996	1557272	0	0
45690819	1119510	0	0
45785779	1119510	0	0
46297077	1119510	0	0
46298689	1119510	0	0
46295308	1129625	0	0
46308088	1396131	0	0
46313876	1149196	0	0
46310653	1125315	0	0
4196708	4029498	2	2
4274025	4048169	5	6
21002810	1124300	0	0
21002682	975125	0	0
35509103	1112807	0	0
36217216	1127433	2	3
4201745	4027663	4	4
36718588	378001	5	7
44352908	1149380	0	0
44363594	1125315	0	0
44339236	1589505	0	0
44357932	1548195	0	0
45622631	1107830	0	0
45637199	1177480	0	0
45629454	40174880	2	3
45647408	738818	0	0
45639298	1119510	0	0
45636555	1149196	0	0
45690085	1112807	0	0
45779008	1125315	0	0
45683336	1124957	0	0
45693399	43012036	2	3
45699635	1125315	0	0
45800012	1119510	0	0
45687424	1119510	0	0
45785985	1119510	0	0
46297120	1119510	0	0
46298495	1119510	0	0
46295252	1129625	0	0
46308335	1124957	0	0
46314292	967823	0	0
46310656	1125315	0	0
4196732	196456	2	2
4304916	4285898	5	7
21002814	1177480	0	0
21002683	975125	0	0
35509172	1129625	0	0
36217216	19077344	2	3
4180938	4243062	4	4
36718595	4001336	5	7
44353179	1500211	0	0
44363662	1125315	0	0
44339237	708298	0	0
44358062	1332418	0	0
45622566	19127890	0	0
45637207	1177480	0	0
45626153	19075001	2	3
45644283	1110410	0	0
45635859	1119510	0	0
45637054	738818	0	0
45690200	1112807	0	0
45778663	1125315	0	0
45682946	1154343	0	0
45693301	19008572	2	3
45699461	1125315	0	0
45800016	1119510	0	0
45687758	1119510	0	0
46296467	1119510	0	0
46297226	1119510	0	0
46298576	1119510	0	0
46244334	1129625	0	0
46308342	1115008	0	0
46314896	1174888	0	0
46310671	1125315	0	0
19081738	19128263	2	2
4274025	4149245	5	9
21002814	1115008	0	0
21002686	1149380	0	0
35509156	1149380	0	0
36217216	40232448	2	3
4093991	381316	4	4
37503996	4336464	5	7
44353015	701322	0	0
44358779	1125315	0	0
44339305	975125	0	0
44358219	1595799	0	0
45622566	1549786	0	0
45637490	1177480	0	0
45667423	1107882	2	3
45644342	738818	0	0
45636050	1119510	0	0
45636950	1539403	0	0
45686905	1112807	0	0
45779015	1125315	0	0
45682997	1115008	0	0
45693337	46233988	2	3
45699403	1125315	0	0
45800053	1119510	0	0
45687702	1119510	0	0
46292313	1119510	0	0
45894600	1119510	0	0
46298643	1119510	0	0
46244419	1129625	0	0
46308350	1332418	0	0
46314897	1501700	0	0
46310596	1125315	0	0
19081738	19128022	2	2
4274025	40486433	5	9
21002814	1124300	0	0
21002683	1551099	0	0
35509175	1125315	0	0
36217216	19045231	2	3
4112892	4107731	4	4
37100000	198199	5	7
44352915	1115008	0	0
44358686	1125315	0	0
44339333	1149380	0	0
44358219	1521369	0	0
45622566	1512674	0	0
45639979	1177480	0	0
45663511	1107882	2	3
45644343	1343916	0	0
45635868	1119510	0	0
45637421	791967	0	0
45688698	1112807	0	0
45778781	1125315	0	0
45682905	1107830	0	0
45693337	46233710	2	3
45699490	1125315	0	0
45800086	1119510	0	0
45687714	1119510	0	0
46292515	1119510	0	0
45803024	1119510	0	0
46298782	1119510	0	0
46244312	1129625	0	0
46302551	738818	0	0
46314901	1192710	0	0
46310532	1125315	0	0
4297887	4310024	2	2
4274025	440448	5	10
21002411	1746114	0	0
21002677	1149380	0	0
35509167	975125	0	0
36217216	1539411	2	3
4042645	4057420	4	4
40783000	3049273	5	6
44353188	1115008	0	0
44358484	1125315	0	0
44339335	723013	0	0
44358219	1549786	0	0
45622544	1149196	0	0
45640112	1177480	0	0
45662751	19078461	2	3
45644358	19010482	0	0
45635810	1119510	0	0
45633278	1192710	0	0
45687177	1112807	0	0
45779081	1125315	0	0
45683220	967823	0	0
45693500	1519937	2	3
45699497	1125315	0	0
45799984	1119510	0	0
45687630	1119510	0	0
46292319	1119510	0	0
45802962	1119510	0	0
46298992	1119510	0	0
46244562	1129625	0	0
46302661	1115008	0	0
46313884	1322184	0	0
46304812	1125315	0	0
4235428	4057420	2	2
4322976	4197460	5	7
21002450	1759842	0	0
21002685	19010482	0	0
35509150	1112807	0	0
36217216	1115171	2	3
4042645	4078793	4	4
37604009	313217	5	6
44353190	738818	0	0
44358489	1125315	0	0
44339345	1129625	0	0
44358972	1192710	0	0
45622845	933724	0	0
45634240	1177480	0	0
45663453	40228214	2	3
45644362	1115008	0	0
45635907	1119510	0	0
45633178	1501700	0	0
45687318	1112807	0	0
45779061	1125315	0	0
45683064	1778162	0	0
45690307	43012036	2	3
45699601	1125315	0	0
45799827	1119510	0	0
45687876	1119510	0	0
46292123	1119510	0	0
45803387	1119510	0	0
46299029	1119510	0	0
46244529	1129625	0	0
46302576	1124957	0	0
46314803	1174888	0	0
46304879	1125315	0	0
4043371	81893	2	3
4322976	4216130	5	9
21002452	1746114	0	0
21002685	1305058	0	0
35509152	1177480	0	0
36217216	19128009	3	4
21604180	740275	4	4
36718588	378419	5	6
44352836	1548195	0	0
44356252	1125315	0	0
44339427	933724	0	0
44359132	19003953	0	0
45622395	738818	0	0
45634590	1177480	0	0
45665387	1107882	2	3
45644324	1551099	0	0
45636078	1119510	0	0
45633279	1545958	0	0
45683952	1112807	0	0
45778708	1125315	0	0
45683297	1741122	0	0
45690317	40232448	2	3
45696115	1125315	0	0
45800092	1119510	0	0
45687920	1119510	0	0
46292380	1119510	0	0
45803392	1119510	0	0
46299040	1119510	0	0
46244322	1129625	0	0
46302795	1107830	0	0
46314747	1174888	0	0
46304885	1125315	0	0
21000815	19133905	2	3
4199402	4329847	6	9
21002453	1759842	0	0
21002627	1149380	0	0
35509182	1125315	0	0
36217216	19128065	3	4
4141833	4280726	4	4
37604032	313217	5	6
44353093	1000560	0	0
44356332	1125315	0	0
44339181	1738521	0	0
44359043	723013	0	0
45622406	738818	0	0
45634281	1177480	0	0
45629131	1107882	2	3
45644310	1332418	0	0
45636015	1119510	0	0
45633288	1728416	0	0
45684084	1112807	0	0
45779195	1125315	0	0
45683297	1746114	0	0
45690340	43012036	2	3
45695996	1125315	0	0
45800189	1119510	0	0
45687895	1119510	0	0
46292301	1119510	0	0
45803400	1119510	0	0
46298628	1119510	0	0
46244440	1129625	0	0
46302814	1521369	0	0
46314193	1308738	0	0
46305431	1125315	0	0
21000815	19133873	2	3
4199402	4112343	6	9
21002454	1759842	0	0
21002623	1741122	0	0
36156645	1112807	0	0
36217216	42902245	3	4
4141833	40486433	4	4
37602360	4329847	5	6
44353198	1177480	0	0
44356256	1125315	0	0
44339258	1129625	0	0
44359047	1332418	0	0
45622410	1713332	0	0
45634652	1177480	0	0
45650491	40223768	2	3
45644092	1174888	0	0
45636017	1119510	0	0
45633327	791967	0	0
45654955	1177480	0	0
45779208	1125315	0	0
45683419	723013	0	0
45690544	920334	2	3
45696011	1125315	0	0
45799910	1119510	0	0
45687504	1119510	0	0
46292223	1119510	0	0
45803410	1119510	0	0
46299295	1119510	0	0
46244535	1129625	0	0
46302963	1149196	0	0
46314764	1549786	0	0
46305003	1125315	0	0
4042516	4295880	2	3
4322976	4337611	6	9
21002445	1746114	0	0
21002623	1746114	0	0
36156671	967823	0	0
36217216	19129144	3	4
4100932	40479768	4	4
37602360	4310024	5	6
44353216	1149196	0	0
44356441	1125315	0	0
44339125	1192710	0	0
44358978	738818	0	0
45622410	1759842	0	0
45634468	1177480	0	0
45641384	1107882	2	3
45644286	1154343	0	0
45636274	1119510	0	0
45633203	738818	0	0
45654899	1177480	0	0
45778984	1125315	0	0
45683430	1549786	0	0
45691410	1127433	2	3
45696090	1125315	0	0
45800095	1119510	0	0
45688013	1119510	0	0
46292477	1119510	0	0
45803384	1119510	0	0
46298923	1119510	0	0
45787646	1119510	0	0
46302845	1738521	0	0
46314755	1310149	0	0
46305445	1125315	0	0
21000260	46233988	2	3
4304916	81893	6	8
21002445	1759842	0	0
21002627	975125	0	0
36156675	1713332	0	0
35809386	4285898	3	6
4057955	4015189	4	4
36718595	380378	5	5
44353219	975125	0	0
44356449	1125315	0	0
44339331	1177480	0	0
44359179	738818	0	0
45622414	1521369	0	0
45631362	1177480	0	0
45649286	1332419	2	3
45644188	1367571	0	0
45636200	1119510	0	0
45633487	1192710	0	0
45654841	1177480	0	0
45778986	1125315	0	0
45683200	1595799	0	0
45687203	1107882	2	3
45696095	1125315	0	0
45685906	1119510	0	0
45687959	1119510	0	0
46292470	1119510	0	0
45803079	1119510	0	0
46298939	1119510	0	0
45787229	1119510	0	0
46303139	1118084	0	0
46314698	1551099	0	0
46305016	1125315	0	0
21000260	46233710	2	3
4199402	4146173	6	8
21002455	1759842	0	0
21002630	1149380	0	0
36156679	1343916	0	0
35700000	198809	7	9
4203551	4108705	4	4
37602360	321042	5	5
44353221	1310149	0	0
44356344	1125315	0	0
44339332	723013	0	0
44359180	1115008	0	0
45622416	738818	0	0
45633937	1177480	0	0
45650718	1107882	2	3
45644476	967823	0	0
45636185	1119510	0	0
45633646	1174888	0	0
45655110	1177480	0	0
45778786	1125315	0	0
45683200	1308738	0	0
45687249	19008572	2	3
45696218	1125315	0	0
45685684	1119510	0	0
45687902	1119510	0	0
46292451	1119510	0	0
45803235	1119510	0	0
46299065	1119510	0	0
45787633	1119510	0	0
46302853	975125	0	0
46314700	1192710	0	0
46305571	1125315	0	0
21000259	46233988	2	3
4199402	257012	6	8
21002455	1741122	0	0
21002630	1149196	0	0
36156660	1539403	0	0
35700000	196456	7	8
4227253	321042	4	4
37602360	4163874	5	5
44353222	1112807	0	0
44356306	1125315	0	0
44339417	1107830	0	0
44359185	1192710	0	0
45622274	1124300	0	0
45631557	1177480	0	0
45647261	1107882	2	3
45644335	967823	0	0
45636021	1119510	0	0
45633574	1551099	0	0
45655113	1177480	0	0
45779157	1125315	0	0
45683430	1512674	0	0
45687394	19076374	2	3
45696061	1125315	0	0
45685323	1119510	0	0
45687906	1119510	0	0
46287882	1119510	0	0
45803330	1119510	0	0
46290400	1119510	0	0
45787640	1119510	0	0
46302701	1174888	0	0
46314704	1112807	0	0
46305574	1125315	0	0
21000803	19077344	2	3
4199402	4149245	6	8
21002455	1746114	0	0
21600965	1310149	0	0
36156662	1309944	0	0
35700000	441267	3	3
4227253	4266809	4	4
37604009	4310024	5	5
44353039	738818	0	0
44356389	1125315	0	0
44339153	1124300	0	0
44358862	1149196	0	0
45622303	1153428	0	0
45628133	1177480	0	0
45626189	1107882	2	3
45644198	1332418	0	0
45632944	1119510	0	0
45633529	1759842	0	0
45655238	1177480	0	0
45779229	1125315	0	0
45683466	1332418	0	0
45687406	19077344	2	3
45696226	1125315	0	0
45685359	1119510	0	0
45687963	1119510	0	0
46287975	1119510	0	0
45800456	1119510	0	0
46290369	1119510	0	0
45787741	1119510	0	0
46302707	1551099	0	0
46314710	1124300	0	0
46305330	1125315	0	0
21000299	19133905	2	3
4199402	321042	6	8
21002491	1112807	0	0
21600036	975125	0	0
36156666	1361711	0	0
35700000	4116491	3	3
4227253	4310024	4	4
37602356	381316	5	5
44349052	1129625	0	0
44356456	1125315	0	0
44339160	933724	0	0
44358354	1548195	0	0
45622309	1154343	0	0
45628522	1177480	0	0
45634244	19078461	2	3
45644202	1501700	0	0
45632997	1119510	0	0
45633529	1713332	0	0
45655222	1177480	0	0
45779400	1125315	0	0
45683164	1107830	0	0
45687676	1115171	2	3
45696179	1125315	0	0
45685378	1119510	0	0
45684648	1119510	0	0
46287987	1119510	0	0
45800430	1119510	0	0
46290404	1119510	0	0
45787519	1119510	0	0
46302712	791967	0	0
46314715	1149196	0	0
46305332	1125315	0	0
21000299	19133873	2	3
4212577	4048171	6	7
21002491	1115008	0	0
21500949	1129625	0	0
36156654	1000560	0	0
35700000	440448	3	11
4227253	255848	4	4
37602356	321042	5	5
44349057	975125	0	0
44356425	1125315	0	0
44339523	920293	0	0
44358359	1307863	0	0
45622358	1512674	0	0
45628188	1177480	0	0
45626850	1107882	2	3
45644289	1102527	0	0
45633002	1119510	0	0
45633385	1174888	0	0
45700760	1177480	0	0
45779393	1125315	0	0
45679895	1124300	0	0
45687677	19059056	2	3
45696129	1125315	0	0
45685383	1119510	0	0
45684736	1119510	0	0
46243137	1119510	0	0
45800485	1119510	0	0
46290385	1119510	0	0
45787490	1119510	0	0
46302814	1549786	0	0
46314856	1149196	0	0
46305211	1125315	0	0
21000292	46233988	2	3
4274025	4219399	6	7
21002491	1118084	0	0
21501230	967823	0	0
36156659	967823	0	0
35700000	30753	3	9
4227253	196456	4	4
40782662	3010813	5	5
44349058	723013	0	0
44356489	1125315	0	0
44339526	1332418	0	0
44358364	738818	0	0
45622358	19127890	0	0
45628354	1177480	0	0
45623747	19078461	2	3
45644423	1539403	0	0
45633974	1119510	0	0
45633388	1115008	0	0
45701541	1177480	0	0
45779395	1125315	0	0
45679880	1501700	0	0
45687598	1115171	2	3
45696256	1125315	0	0
45799949	1119510	0	0
45684607	1119510	0	0
46243140	1119510	0	0
45800473	1119510	0	0
46290474	1119510	0	0
45787613	1119510	0	0
46302816	738818	0	0
46317595	1778162	0	0
46305217	1125315	0	0
21000230	46233710	2	3
4274025	321042	6	8
21002412	1746114	0	0
21500050	1308738	0	0
36156669	791967	0	0
35700000	4027663	3	8
4181063	133834	4	4
40782662	3026361	5	5
44348777	791967	0	0
44356574	1125315	0	0
44339023	738818	0	0
44358327	738818	0	0
45622358	1549786	0	0
45628343	1177480	0	0
45646896	1107882	2	3
45644506	914335	0	0
45633953	1119510	0	0
45633395	791967	0	0
45701641	1177480	0	0
45779337	1125315	0	0
45679882	1124957	0	0
45687551	40163554	2	3
45696190	1125315	0	0
45800006	1119510	0	0
45684803	1119510	0	0
46242899	1119510	0	0
45800579	1119510	0	0
46290527	1119510	0	0
45787616	1119510	0	0
46302823	1551099	0	0
46317740	1551099	0	0
46307146	1125315	0	0
21000230	46233988	2	3
4274025	4152936	6	8
21002475	1515774	0	0
21500095	742185	0	0
36156791	1125315	0	0
35700000	81893	3	13
36200000	40479768	6	11
40772935	3009201	5	5
44348887	914335	0	0
44356647	1125315	0	0
44341844	1125315	0	0
44358532	1110410	0	0
45622359	1110410	0	0
45628703	1177480	0	0
45626519	1332419	2	3
45644510	791967	0	0
45634008	1119510	0	0
45633396	738818	0	0
45701794	1177480	0	0
45779181	1125315	0	0
45679885	1124957	0	0
45687576	19078924	2	3
45696280	1125315	0	0
45800041	1119510	0	0
45684990	1119510	0	0
46242917	1119510	0	0
45800635	1119510	0	0
46290529	1119510	0	0
45787777	1119510	0	0
46302682	1713332	0	0
46317753	920293	0	0
46306699	1125315	0	0
21000291	46233710	2	3
4339468	4048171	6	6
21002475	19127890	0	0
21500108	1500211	0	0
36156795	1551099	0	0
35700000	192671	3	7
36200000	381316	6	6
37302322	134438	5	5
44348890	1149196	0	0
44356560	1125315	0	0
44341889	1125315	0	0
44358535	1124300	0	0
45622249	975125	0	0
45628642	1177480	0	0
45662947	19075601	2	3
45644469	1124957	0	0
45634033	1119510	0	0
45633401	1713332	0	0
45701779	1177480	0	0
45779373	1125315	0	0
45679602	1501700	0	0
45687224	19008572	2	3
45696285	1125315	0	0
45799719	1119510	0	0
45684726	1119510	0	0
46243230	1119510	0	0
45800545	1119510	0	0
46290602	1119510	0	0
45801201	1119510	0	0
46302691	967823	0	0
46317667	1118084	0	0
46306700	1125315	0	0
21000291	46233988	2	3
4339410	4230399	6	6
21002475	1595799	0	0
21013948	1738521	0	0
36156797	1149196	0	0
35700000	4112343	5	11
36200000	4329847	6	6
37203758	441267	5	5
44348903	1713332	0	0
44349172	1125315	0	0
44342040	1125315	0	0
44358515	1118084	0	0
45622326	19127890	0	0
45625365	1177480	0	0
45650526	19078461	2	3
45644447	1326303	0	0
45659136	1129625	0	0
45633401	1759842	0	0
45701769	1177480	0	0
45779374	1125315	0	0
45679927	1115008	0	0
45691641	1129625	0	0
45696292	1125315	0	0
45799720	1119510	0	0
45684727	1119510	0	0
46243181	1119510	0	0
45800718	1119510	0	0
46290875	1119510	0	0
45802364	1119510	0	0
46302928	1551099	0	0
46317813	1738521	0	0
46306550	1125315	0	0
21000285	46233710	2	3
4199402	4116491	6	6
21002491	1515774	0	0
21002644	975125	0	0
36156800	1119510	0	0
35700000	4285898	4	12
36200000	4094814	6	6
40786239	3001488	5	5
44348904	1192710	0	0
44349407	1125315	0	0
44341998	1125315	0	0
44358931	975125	0	0
45622326	1549786	0	0
45625294	1177480	0	0
45650307	19075601	2	3
45644539	1149196	0	0
45659251	1129625	0	0
45633339	1308738	0	0
45701866	1177480	0	0
45779375	1125315	0	0
45679928	1110410	0	0
45691634	1129625	0	0
45696234	1125315	0	0
45682525	1119510	0	0
45681281	1119510	0	0
46243067	1119510	0	0
45800720	1119510	0	0
46291019	1119510	0	0
45802515	1119510	0	0
46302772	975125	0	0
46317359	1192710	0	0
46321686	1125315	0	0
21000295	46233988	2	3
4279903	4198190	6	6
21002475	1589505	0	0
21002630	1551099	0	0
36156518	1125315	0	0
35700000	4166224	4	11
36200000	81151	4	11
37602356	4310024	6	6
44349114	723013	0	0
44349357	1125315	0	0
44342052	1125315	0	0
44358936	1713332	0	0
45622281	1501700	0	0
45625647	1177480	0	0
45641708	1107882	2	3
45644449	1343916	0	0
45657275	1129625	0	0
45633341	975125	0	0
45701973	1177480	0	0
45779376	1125315	0	0
45679818	1738521	0	0
45691763	1129625	0	0
45696158	1125315	0	0
45682286	1119510	0	0
45682671	1119510	0	0
46243220	1119510	0	0
45800607	1119510	0	0
46290686	1119510	0	0
45802230	1119510	0	0
46302777	1192710	0	0
46315091	1545958	0	0
46321817	1125315	0	0
21000295	46233710	2	3
4300157	78272	6	6
21002491	1589505	0	0
21002642	975125	0	0
36156764	1713332	0	0
35700000	28060	4	9
36200000	4132546	4	9
37600000	321042	6	6
44349077	1589505	0	0
44349352	1125315	0	0
44341921	1125315	0	0
44358440	1107830	0	0
45622429	1154029	0	0
45625635	1177480	0	0
45638661	40228214	2	3
45644424	1500211	0	0
45657290	1129625	0	0
45633494	1521369	0	0
45701855	1177480	0	0
45779392	1125315	0	0
45679945	1332418	0	0
45691819	1129625	0	0
45696159	1125315	0	0
45794884	1119510	0	0
45681849	1119510	0	0
46243212	1119510	0	0
45800500	1119510	0	0
46290743	1119510	0	0
45802594	1119510	0	0
46302782	1154029	0	0
46315316	1310149	0	0
46321698	1125315	0	0
21000297	46233710	2	3
4213310	4043241	6	6
21002350	920293	0	0
21002630	975125	0	0
36156765	1149196	0	0
35700000	4310024	4	9
36200000	4156265	4	9
37600000	4163874	6	6
44349077	1549786	0	0
44349447	1125315	0	0
44342230	1125315	0	0
44358396	1174888	0	0
45622507	738818	0	0
45625748	1177480	0	0
45644544	40228214	2	3
45644544	1149196	0	0
45657024	1129625	0	0
45633211	1107830	0	0
45698881	1177480	0	0
45779166	1125315	0	0
45679835	1115008	0	0
45691859	1129625	0	0
45696160	1125315	0	0
45794946	1119510	0	0
45681941	1119510	0	0
46243122	1119510	0	0
45800711	1119510	0	0
46291113	1119510	0	0
45801237	1119510	0	0
46302788	1149196	0	0
46315100	975125	0	0
46321723	1125315	0	0
21000297	46233988	2	3
4215217	4149245	3	3
21002475	1521369	0	0
21002642	1149380	0	0
36156777	1000560	0	0
35700000	4266809	4	9
36200000	4149245	4	5
40783186	3008598	6	6
44348968	1174888	0	0
44349610	1125315	0	0
44341941	1125315	0	0
44358400	753626	0	0
45622508	975125	0	0
45624965	1177480	0	0
45665409	40173590	2	3
45644392	708298	0	0
45657050	1129625	0	0
45633348	975125	0	0
45698895	1177480	0	0
45779396	1125315	0	0
45682297	1738521	0	0
45691848	1129625	0	0
45696274	1125315	0	0
45794911	1119510	0	0
45681735	1119510	0	0
46243126	1119510	0	0
45800818	1119510	0	0
46290845	1119510	0	0
45801285	1119510	0	0
46302973	975125	0	0
46315120	1118084	0	0
46321727	1125315	0	0
21000301	46233710	2	3
4320791	4048171	3	3
21002475	1500211	0	0
21002655	1551099	0	0
36156778	1129625	0	0
35802131	378001	8	10
36200000	4048695	4	10
36425574	19008572	2	3
44348972	1149380	0	0
44349376	1125315	0	0
44342110	1125315	0	0
44358402	1124300	0	0
45622371	975125	0	0
45622533	1177480	0	0
45621852	19073188	2	3
45644396	738818	0	0
45657055	1129625	0	0
45633353	1548195	0	0
45698676	1177480	0	0
45779397	1125315	0	0
45682300	1361711	0	0
45688819	1129625	0	0
45696482	1125315	0	0
45794918	1119510	0	0
45681862	1119510	0	0
46244713	1119510	0	0
45800537	1119510	0	0
46242437	1119510	0	0
45801227	1119510	0	0
46303060	1595799	0	0
46315192	1154029	0	0
46321831	1125315	0	0
21000301	46233988	2	3
4276572	439777	3	3
21002475	1503184	0	0
21002644	1149380	0	0
36156533	1129625	0	0
35802131	4112343	7	10
36200000	4299128	3	7
36502202	4218389	3	3
44348974	1192710	0	0
44349749	1125315	0	0
44341873	1125315	0	0
44358416	1124300	0	0
45622432	1174888	0	0
45622432	1177480	0	0
45621852	19073183	2	3
45644617	1000560	0	0
45657336	1129625	0	0
45633246	1343916	0	0
45698861	1177480	0	0
45779398	1125315	0	0
45682301	1154343	0	0
45688825	1129625	0	0
45696485	1125315	0	0
45679135	1119510	0	0
45678530	1119510	0	0
46244721	1119510	0	0
45800614	1119510	0	0
46242354	1119510	0	0
45801274	1119510	0	0
46303060	1308738	0	0
46315357	1149380	0	0
46321792	1125315	0	0
21000290	46233710	2	3
4195979	4324181	3	3
21002475	1549786	0	0
21002642	1551099	0	0
36156534	1115008	0	0
35802131	4294548	7	10
36200000	4296204	3	8
36302183	4314290	3	3
44348984	1192710	0	0
44349601	1125315	0	0
44341876	1125315	0	0
44358529	1192710	0	0
45622597	1115008	0	0
45622477	1177480	0	0
45660082	19075601	2	3
45644662	967823	0	0
45655371	1129625	0	0
45633612	791967	0	0
45698828	1177480	0	0
45779401	1125315	0	0
45682315	1174888	0	0
45688772	1129625	0	0
45696487	1125315	0	0
45679342	1119510	0	0
45678889	1119510	0	0
46240867	1119510	0	0
45797763	1119510	0	0
46242356	1119510	0	0
45801279	1119510	0	0
46303016	1738521	0	0
46315360	967823	0	0
46316294	1125315	0	0
21000290	46233988	2	3
4200516	4132546	3	3
21002421	1741122	0	0
21002655	975125	0	0
36156790	1149196	0	0
35802131	257012	7	9
36200000	375671	3	11
36313913	4243062	3	3
44348985	1713332	0	0
44349557	1125315	0	0
44341934	1125315	0	0
44358441	1738521	0	0
45622434	1589505	0	0
45620829	1177480	0	0
45623627	19075601	2	3
45644667	1308738	0	0
45655474	1129625	0	0
45633310	1192710	0	0
45698953	1177480	0	0
45779402	1125315	0	0
45682393	1551099	0	0
45688849	1129625	0	0
45696244	1125315	0	0
45679248	1119510	0	0
45678875	1119510	0	0
46240870	1119510	0	0
45797876	1119510	0	0
46242517	1119510	0	0
45801352	1119510	0	0
46303295	738818	0	0
46315362	1112807	0	0
46316047	1125315	0	0
2100082