package MOP::Slot::Initializer;
# ABSTRACT: A representation of a class slot initializer

use strict;
use warnings;

use Carp ();

use UNIVERSAL::Object::Immutable;

use MOP::Internal::Util;

our $VERSION   = '0.12';
our $AUTHORITY = 'cpan:STEVAN';

our @ISA; BEGIN { @ISA = ('UNIVERSAL::Object::Immutable') }
our %HAS; BEGIN {
    %HAS = (
        default  => sub {},
        required => sub {},
    )
}

sub BUILDARGS {
    my $class = shift;
    my $args  = $class->SUPER::BUILDARGS( @_ );

    Carp::confess('Cannot have both a default and be required in the same initializer')
        if $args->{default} && $args->{required};

    return $args;
}

sub CREATE {
    my ($class, $args) = @_;

    my $code;
    if ( my $message = $args->{required} ) {
        $code = eval 'sub { die \''.$message.'\' }';
    }
    else {
        $code = $args->{default} || eval 'sub { undef }';
    }

    return $code;
}

sub BUILD {
    my ($self, $params) = @_;

    MOP::Internal::Util::SET_COMP_STASH_FOR_CV( $self, $params->{within_package} )
        if $params->{within_package};
}

1;

__END__

=pod

=head1 NAME

MOP::Slot::Initializer - A representation of a class slot initializer

=head1 VERSION

version 0.12

=head1 DESCRIPTION

Initializer objects for the MOP made out of CODE refs.

=head1 CONSTRUCTORS

=over 4

=item C<new( %args )>

=back

=head1 AUTHOR

Stevan Little <stevan@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Stevan Little.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
