package XString;

use strict;
use warnings;

# ABSTRACT: Isolated String helpers from B

BEGIN {

    our $VERSION = '0.003'; # VERSION: generated by DZP::OurPkgVersion
    require XSLoader;
    XSLoader::load(__PACKAGE__);
}


1;

__END__

=pod

=encoding utf-8

=head1 NAME

XString - Isolated String helpers from B

=head1 VERSION

version 0.003

=head1 SYNOPSIS

 #!perl
 
 use strict;
 use warnings;
 
 use Test::More;
 
 use XString;
 use B;
 
 is XString::cstring( q[a'string"with quotes] ), B::cstring( q[a'string"with quotes] ), q["a'string\"with quotes"];
 is XString::perlstring( q[a'string"with quotes] ), B::perlstring( q[a'string"with quotes] ), q["a'string\"with quotes"];
 
 done_testing;

=head1 DESCRIPTION

XString provides the L<B> string helpers in one isolated package.
Right now only L<cstring> and L<perlstring> are available.

=for markdown [![](https://github.com/atoomic/XString/workflows/linux/badge.svg)](https://github.com/atoomic/XString/actions) [![](https://github.com/atoomic/XString/workflows/macos/badge.svg)](https://github.com/atoomic/XString/actions) [![](https://github.com/atoomic/XString/workflows/windows/badge.svg)](https://github.com/atoomic/XString/actions)

=head1 FUNCTIONS

=head2 cstring(STR)

Similar to B::cstring;
Returns a double-quote-surrounded escaped version of STR which can
be used as a string in C source code.

=head2 perlstring(STR)

Similar to B::perlstring;
Returns a double-quote-surrounded escaped version of STR which can
be used as a string in Perl source code.

=head1 AUTHOR

Nicolas R <atoomic@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018 by cPanel, Inc.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
