#!/usr/bin/perl
use strict;
use warnings;

use Test::More tests => 2;
use Test::File::Contents;

use LCFG::Template;

my $res = { partitions => { VALUE => 'hda1 hda2' },
            mnt_hda1   => { VALUE => '/' },
            args_hda1  => { VALUE => 'ext2 defaults 1 0' },
            mnt_hda2   => { VALUE => 'swap' },
            args_hda2  => { VALUE => 'swap defaults' },
            };

my $tmplfile = 't/templates/for.tmpl';
my $file = '/tmp/for.txt';
my $mode = 0;
my $result = LCFG::Template::Substitute($tmplfile,$file,$mode,
                                        $res);

isnt( $result, undef, 'Result is not undefined' );

file_contents_identical( $file, 't/expected/for.txt' );
