# Generated by default/object.tt
package Paws::MediaLive::InputLossFailoverSettings;
  use Moose;
  has InputLossThresholdMsec => (is => 'ro', isa => 'Int', request_name => 'inputLossThresholdMsec', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::InputLossFailoverSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::InputLossFailoverSettings object:

  $service_obj->Method(Att1 => { InputLossThresholdMsec => $value, ..., InputLossThresholdMsec => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::InputLossFailoverSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->InputLossThresholdMsec

=head1 DESCRIPTION

MediaLive will perform a failover if content is not detected in this
input for the specified period.

=head1 ATTRIBUTES


=head2 InputLossThresholdMsec => Int

The amount of time (in milliseconds) that no input is detected. After
that time, an input failover will occur.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

