#!/usr/bin/perl

package eBay::API::XML::DataType::LiveAuctionCatalogType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. LiveAuctionCatalogType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::LiveAuctionCatalogType

=head1 DESCRIPTION

Describes one live auction catalog and its sale schedules.
Use this information to determine an appropriate combination of catalog and schedule IDs
in which to list a lot item when you use AddLiveAuctionItem.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::LiveAuctionCatalogType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ScheduleType;


my @gaProperties = ( [ 'CatalogName', 'xs:string', '', '', '' ]
	, [ 'Schedule', 'ns:ScheduleType', '1'
	     ,'eBay::API::XML::DataType::ScheduleType', '1' ]
	, [ 'UserCatalogID', 'xs:int', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCatalogName()

Descriptive name that the seller created for the catalog.
Pass as input to AddLiveAuctionItem when you list a lot item.

MaxLength: 45

#    Argument: 'xs:string'

=cut

sub setCatalogName {
  my $self = shift;
  $self->{'CatalogName'} = shift
}

=head2 getCatalogName()

  Calls: GetLiveAuctionCatalogDetails
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCatalogName {
  my $self = shift;
  return $self->{'CatalogName'};
}


=head2 setSchedule()

Describes a single live auction sale schedule that the user defined.
A seller can define a maximum of 5 schedules for each catalog.
Each schedule defines the start and end time of a live auction event.
(Only the start time is returned from GetLiveAuctionCatalogDetails.)
A schedule must be created at least 48 hours in advance of the auction.
The seller then lists one or more lots that will be auctioned during that event.
Only schedules for future sales are returned. That is, schedules for
ended sales or sales in progress are not returned.
Pass as input to AddLiveAuctionItem when you list a lot item.

#    Argument: reference to an array  
                      of 'ns:ScheduleType'

=cut

sub setSchedule {
  my $self = shift;
  $self->{'Schedule'} = 
		$self->convertArray_To_RefToArrayIfNeeded(@_);
}

=head2 getSchedule()

  Calls: GetLiveAuctionCatalogDetails
  Returned: Conditionally

#    Returns: reference to an array  
                      of 'ns:ScheduleType'

=cut

sub getSchedule {
  my $self = shift;
  return $self->_getDataTypeArray('Schedule');
}


=head2 setUserCatalogID()

ID number identifiying a specific eBay Live Auctions catalog that the user has created.
Pass as input to AddLiveAuctionItem when you list a lot item.

#    Argument: 'xs:int'

=cut

sub setUserCatalogID {
  my $self = shift;
  $self->{'UserCatalogID'} = shift
}

=head2 getUserCatalogID()

  Calls: GetLiveAuctionCatalogDetails
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getUserCatalogID {
  my $self = shift;
  return $self->{'UserCatalogID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
