/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.ArrayList;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.SortObserver;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private boolean unique;
    private String indexType;
    private long conglomId;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;

    CreateIndexConstantAction(boolean bl, String string, String string2, String string3, String string4, UUID uUID, long l, String[] stringArray, boolean[] blArray, boolean bl2, UUID uUID2, Properties properties) {
        super(uUID, string3, string4, string2);
        this.unique = bl;
        this.indexType = string;
        this.conglomId = l;
        this.columnNames = stringArray;
        this.isAscending = blArray;
        this.isConstraint = bl2;
        this.conglomerateUUID = uUID2;
        this.properties = properties;
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        Object object;
        Object object2;
        GroupFetchScanController groupFetchScanController;
        boolean bl;
        long l;
        RowSource rowSource;
        DataDescriptorGenerator dataDescriptorGenerator;
        TableDescriptor tableDescriptor;
        SchemaDescriptor schemaDescriptor;
        TransactionController transactionController;
        DataDictionary dataDictionary;
        IndexRowGenerator indexRowGenerator;
        block43: {
            block41: {
                block42: {
                    int n;
                    Object object3;
                    indexRowGenerator = null;
                    int n2 = -1;
                    LanguageConnectionContext languageConnectionContext = activation.getLanguageConnectionContext();
                    dataDictionary = languageConnectionContext.getDataDictionary();
                    DependencyManager dependencyManager = dataDictionary.getDependencyManager();
                    transactionController = languageConnectionContext.getTransactionExecute();
                    boolean bl2 = activation.getForCreateTable();
                    dataDictionary.startWriting(languageConnectionContext);
                    schemaDescriptor = dataDictionary.getSchemaDescriptor(this.schemaName, transactionController, true);
                    tableDescriptor = activation.getDDLTableDescriptor();
                    if (tableDescriptor == null) {
                        tableDescriptor = this.tableId != null ? dataDictionary.getTableDescriptor(this.tableId) : dataDictionary.getTableDescriptor(this.tableName, schemaDescriptor);
                    }
                    if (tableDescriptor == null) {
                        throw StandardException.newException("X0Y38.S", this.indexName, (Object)this.tableName);
                    }
                    if (tableDescriptor.getTableType() == 1) {
                        throw StandardException.newException("X0Y28.S", this.indexName, (Object)this.tableName);
                    }
                    this.lockTableForDDL(transactionController, tableDescriptor.getHeapConglomerateId(), false);
                    if (!bl2) {
                        dependencyManager.invalidateFor(tableDescriptor, 3, languageConnectionContext);
                    }
                    int[] nArray = new int[this.columnNames.length];
                    for (int i = 0; i < this.columnNames.length; ++i) {
                        ClassFactory classFactory;
                        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.columnNames[i]);
                        if (columnDescriptor == null) {
                            throw StandardException.newException("42X14", this.columnNames[i], (Object)this.tableName);
                        }
                        TypeId typeId = columnDescriptor.getType().getTypeId();
                        boolean bl3 = typeId.orderable(classFactory = languageConnectionContext.getLanguageConnectionFactory().getClassFactory());
                        if (bl3 && typeId.userType()) {
                            object3 = typeId.getCorrespondingJavaTypeName();
                            try {
                                if (classFactory.isApplicationClass(classFactory.loadApplicationClass((String)object3))) {
                                    bl3 = false;
                                }
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                bl3 = false;
                            }
                        }
                        if (!bl3) {
                            throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
                        }
                        nArray[i] = columnDescriptor.getPosition();
                        if (n2 >= nArray[i]) continue;
                        n2 = nArray[i];
                    }
                    ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
                    boolean bl4 = false;
                    for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                        ConglomerateDescriptor conglomerateDescriptor = conglomerateDescriptorArray[i];
                        if (!conglomerateDescriptor.isIndex()) continue;
                        object3 = conglomerateDescriptor.getIndexDescriptor();
                        int[] nArray2 = ((IndexRowGenerator)object3).baseColumnPositions();
                        boolean[] blArray = ((IndexRowGenerator)object3).isAscending();
                        if (nArray2.length == nArray.length && (((IndexRowGenerator)object3).isUnique() || !this.unique) && this.indexType.equals(((IndexRowGenerator)object3).indexType())) {
                            for (n = 0; n < nArray2.length && nArray2[n] == nArray[n] && blArray[n] == this.isAscending[n]; ++n) {
                            }
                        }
                        if (n != nArray.length) continue;
                        if (!this.isConstraint) {
                            activation.addWarning(StandardException.newWarning("01504", conglomerateDescriptor.getConglomerateName()));
                            return;
                        }
                        this.conglomId = conglomerateDescriptor.getConglomerateNumber();
                        indexRowGenerator = conglomerateDescriptor.getIndexDescriptor();
                        this.conglomerateUUID = conglomerateDescriptor.getUUID();
                        bl4 = true;
                        break;
                    }
                    dataDescriptorGenerator = dataDictionary.getDataDescriptorGenerator();
                    if (bl4) {
                        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
                        dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
                        object3 = tableDescriptor.getConglomerateDescriptorList();
                        ((ArrayList)object3).add(conglomerateDescriptor);
                    }
                    Properties properties = this.properties != null ? this.properties : new Properties();
                    properties.put("baseConglomerateId", Long.toString(tableDescriptor.getHeapConglomerateId()));
                    properties.put("nUniqueColumns", Integer.toString(this.unique ? nArray.length : nArray.length + 1));
                    properties.put("rowLocationColumn", Integer.toString(nArray.length));
                    properties.put("nKeyFields", Integer.toString(nArray.length + 1));
                    if (!bl4) {
                        indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, nArray, this.isAscending, nArray.length);
                    }
                    rowSource = null;
                    l = 0L;
                    bl = false;
                    int n3 = bl2 ? 1 : 16;
                    int n4 = tableDescriptor.getNumberOfColumns();
                    n = 0;
                    FormatableBitSet formatableBitSet = new FormatableBitSet(n4 + 1);
                    for (int i = 0; i < nArray.length; ++i) {
                        formatableBitSet.set(nArray[i]);
                    }
                    FormatableBitSet formatableBitSet2 = RowUtil.shift(formatableBitSet, 1);
                    groupFetchScanController = transactionController.openGroupFetchScan(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5, formatableBitSet2, null, 0, null, null, 0);
                    ExecRow[] execRowArray = new ExecRow[n3];
                    ExecIndexRow[] execIndexRowArray = new ExecIndexRow[n3];
                    ExecRow[] execRowArray2 = new ExecRow[n3];
                    try {
                        ColumnOrdering[] columnOrderingArray;
                        Object object4;
                        for (int i = 0; i < n3; ++i) {
                            execRowArray[i] = activation.getExecutionFactory().getValueRow(n2);
                            execIndexRowArray[i] = indexRowGenerator.getIndexRowTemplate();
                            execRowArray2[i] = activation.getExecutionFactory().getValueRow(nArray.length);
                        }
                        this.indexTemplateRow = execIndexRowArray[0];
                        object2 = tableDescriptor.getColumnDescriptorList();
                        int n5 = ((ArrayList)object2).size();
                        int n6 = 0;
                        for (int i = 0; i < n5; ++i) {
                            if (!formatableBitSet2.get(i)) continue;
                            ++n6;
                            object4 = ((ColumnDescriptorList)object2).elementAt(i);
                            columnOrderingArray = ((ColumnDescriptor)object4).getType();
                            for (int j = 0; j < n3; ++j) {
                                execRowArray[j].setColumn(i + 1, columnOrderingArray.getNull());
                                execRowArray2[j].setColumn(n6, execRowArray[j].getColumn(i + 1));
                            }
                            n += columnOrderingArray.getTypeId().getApproximateLengthInBytes((DataTypeDescriptor)columnOrderingArray);
                        }
                        object = new RowLocation[n3];
                        for (n6 = 0; n6 < n3; ++n6) {
                            object[n6] = groupFetchScanController.newRowLocationTemplate();
                            indexRowGenerator.getIndexRow(execRowArray2[n6], object[n6], execIndexRowArray[n6], formatableBitSet);
                        }
                        if (bl4) {
                            Object var40_58 = null;
                            if (groupFetchScanController == null) break block41;
                            break block42;
                        }
                        object4 = null;
                        if (this.unique) {
                            n6 = nArray.length;
                            columnOrderingArray = this.indexName;
                            if (this.conglomerateUUID != null) {
                                ConglomerateDescriptor conglomerateDescriptor = dataDictionary.getConglomerateDescriptor(this.conglomerateUUID);
                                if (this.isConstraint && conglomerateDescriptor != null && conglomerateDescriptor.getUUID() != null && tableDescriptor != null) {
                                    ConstraintDescriptor constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor.getUUID());
                                    columnOrderingArray = constraintDescriptor.getConstraintName();
                                }
                            }
                            object4 = new UniqueIndexSortObserver(true, this.isConstraint, (String)columnOrderingArray, this.indexTemplateRow, true, tableDescriptor.getName());
                        } else {
                            n6 = nArray.length + 1;
                            object4 = new BasicSortObserver(true, false, this.indexTemplateRow, true);
                        }
                        columnOrderingArray = new ColumnOrdering[n6];
                        for (int i = 0; i < n6; ++i) {
                            columnOrderingArray[i] = new IndexColumnOrder(i, this.unique || i < n6 - 1 ? this.isAscending[i] : true);
                        }
                        l = transactionController.createSort(null, this.indexTemplateRow.getRowArrayClone(), columnOrderingArray, (SortObserver)object4, false, groupFetchScanController.getEstimatedRowCount(), n);
                        bl = true;
                        rowSource = this.loadSorter(execRowArray, execIndexRowArray, transactionController, groupFetchScanController, l, (RowLocation[])object);
                        this.conglomId = transactionController.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), columnOrderingArray, properties, 0, (RowLocationRetRowSource)rowSource, null);
                        break block43;
                    }
                    catch (Throwable throwable) {
                        Object var40_60 = null;
                        if (groupFetchScanController != null) {
                            groupFetchScanController.close();
                        }
                        if (rowSource != null) {
                            rowSource.closeRowSource();
                        }
                        if (bl) {
                            transactionController.dropSort(l);
                        }
                        throw throwable;
                    }
                }
                groupFetchScanController.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (bl) {
                transactionController.dropSort(l);
            }
            return;
        }
        Object var40_59 = null;
        if (groupFetchScanController != null) {
            groupFetchScanController.close();
        }
        if (rowSource != null) {
            rowSource.closeRowSource();
        }
        if (bl) {
            transactionController.dropSort(l);
        }
        if (!(object2 = transactionController.openConglomerate(this.conglomId, false, 0, 7, 5)).isKeyed()) {
            object2.close();
            throw StandardException.newException("X0X85.S", this.indexName, (Object)this.indexType);
        }
        object2.close();
        ConglomerateDescriptor conglomerateDescriptor = dataDescriptorGenerator.newConglomerateDescriptor(this.conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, tableDescriptor.getUUID(), schemaDescriptor.getUUID());
        dataDictionary.addDescriptor(conglomerateDescriptor, schemaDescriptor, 0, false, transactionController);
        object = tableDescriptor.getConglomerateDescriptorList();
        ((ArrayList)object).add(conglomerateDescriptor);
        CardinalityCounter cardinalityCounter = (CardinalityCounter)rowSource;
        long l2 = cardinalityCounter.getRowCount();
        if (l2 > 0L) {
            long[] lArray = cardinalityCounter.getCardinality();
            for (int i = 0; i < lArray.length; ++i) {
                StatisticsDescriptor statisticsDescriptor = new StatisticsDescriptor(dataDictionary, dataDictionary.getUUIDFactory().createUUID(), conglomerateDescriptor.getUUID(), tableDescriptor.getUUID(), "I", new StatisticsImpl(l2, lArray[i]), i + 1);
                dataDictionary.addDescriptor(statisticsDescriptor, null, 14, true, transactionController);
            }
        }
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    private void statementExceptionCleanup(ScanController scanController, ConglomerateController conglomerateController) throws StandardException {
        if (conglomerateController != null) {
            conglomerateController.close();
        }
        if (scanController != null) {
            scanController.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] execRowArray, ExecIndexRow[] execIndexRowArray, TransactionController transactionController, GroupFetchScanController groupFetchScanController, long l, RowLocation[] rowLocationArray) throws StandardException {
        long l2 = 0L;
        SortController sortController = transactionController.openSort(l);
        try {
            int n;
            int n2 = execRowArray.length;
            DataValueDescriptor[][] dataValueDescriptorArray = new DataValueDescriptor[n2][];
            for (n = 0; n < n2; ++n) {
                dataValueDescriptorArray[n] = execRowArray[n].getRowArray();
            }
            n = 0;
            while ((n = groupFetchScanController.fetchNextGroup(dataValueDescriptorArray, rowLocationArray)) > 0) {
                for (int i = 0; i < n; ++i) {
                    sortController.insert(execIndexRowArray[i].getRowArray());
                    ++l2;
                }
            }
            groupFetchScanController.setEstimatedRowCount(l2);
        }
        finally {
            sortController.close();
        }
        return new CardinalityCounter(transactionController.openSortRowSource(l));
    }
}

