package Net::EMI::Common;
use strict;

use vars qw($VERSION);
$VERSION='1.0';

###########################################################################################################
# Since 'constants' are actually implemented as subs,
# they can be called from the outside as any other class method.
use constant STX=>chr(2);
use constant ETX=>chr(3);
use constant UCP_DELIMITER=>'/';
use constant DEF_SMSC_PORT=>3024;
use constant ACK=>'A';
use constant NACK=>'N';

###########################################################################################################
sub new {
   my$self={};
   bless($self,shift())->_init(@_);
}

###########################################################################################################
# calcuate packet checksum
sub checksum {
	my$checksum;
	map{$checksum+=ord}(split //,pop @_);
	sprintf("%X",$checksum%256);
}

###########################################################################################################
# calculate data length
sub data_len {
	my$len=length(pop @_)+17;
	for(1..(5-length($len))) {
		$len='0'.$len;
	}
	$len;
}

###########################################################################################################
sub encode_7bit {
   my($self,$msg)=@_;
   my($bits,$ud)=('','');
   my($octet,$foo);

   defined($msg)&&length($msg)||return('');

   for(split(//,$msg)) {
      $bits.=unpack('b7',$_);
   }

   while(defined($bits)&&(length($bits))) {
      $octet=substr($bits,0,8);
      $foo = $octet;
      $ud.=unpack("H2",pack("b8",substr($octet.'0'x7,0,8)));
      $bits=(length($bits)>8)?substr($bits,8):'';
   }

   my$len;
   if(length($foo)<5) {
      $len =sprintf("%02X", (length($ud)-1));
   }
   else {
      $len =sprintf("%02X", length($ud));
   }

   $len.uc($ud);
}

###########################################################################################################
sub ia5_decode {
   my($self,$message)=@_;
   my($decoded,$i);

	for($i=0;$i<=length($message);$i+=2) {
		$decoded.=chr(hex(substr($message,$i,2)));
	}
	$decoded;
}

###########################################################################################################
sub ia5_encode {
	join('',map{sprintf "%X",ord} split(//,pop(@_)));
}

###########################################################################################################
###########################################################################################################
#
# 'Internal' subs. Don't call these since they may, and will, change without notice.
#
###########################################################################################################
###########################################################################################################

###########################################################################################################
sub _init {
   shift;
}

###########################################################################################################
'Choppers rule';
__END__

=head1 NAME

Net::EMI::Common - EMI/UCP GSM SMSC Protocol Common library class

=head1 SYNOPSIS

C<use Net::EMI::Common>

C<$emi = Net::EMI::Common-E<gt>new();>

=head1 DESCRIPTION

This module implements a collection of common routines used in the Net::EMI set of classes.

The Net::EMI::Common class is primarily intended to part some functionality between
the Net::EMI::Client class and any future Net::EMI::Server classes.

Even so, there is nothing to stop any application or other module to make use of the
common routines found in this class.

(If someone makes use of this module to support any other module,
I'd like to hear about it.
That way I may be able to maintain backwards compatibility for those modules.)

=head1 CONSTRUCTOR

=over 4

=item new()

No parameters are currently honored.

=back

=head1 PUBLIC OBJECT METHODS

=over 4

=item checksum('Some string')

Calcuate packet checksum.

=item data_len('Some string')

Calculate data length.

=item encode_7bit('Some string')

=item ia5_decode('Some string')

=item ia5_encode('Some string')

=back

=head1 SEE ALSO

L<Net::EMI::Client>

=head1 ACKNOWLEDGMENTS

I'd like to thank Jochen Schneider for writing the first beta releases under the name Net::EMI
and also for letting me in on the project.

In February 2003, Jochen gave me free hands to distribute this class module
which is primarily built upon his work.
Without Jochens initial releases, this module would probably not have seen the light.

And, as everyone else I owe so much to Larry.
For having provided Perl.

=head1 AUTHOR

Gustav Schaffter, E<lt>schaffter_cpan@hotmail.comE<gt>

=head1 COPYRIGHT

Copyright (c) 2002 Jochen Schneider.
Copyright (c) 2003 Gustav Schaffter.
All rights reserved.
This program is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

