
package Google::Ads::AdWords::v201402::ConstantDataService::getUserInterestCriterion;
use strict;
use warnings;

{ # BLOCK to scope variables

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201402' }

__PACKAGE__->__set_name('getUserInterestCriterion');
__PACKAGE__->__set_nillable();
__PACKAGE__->__set_minOccurs();
__PACKAGE__->__set_maxOccurs();
__PACKAGE__->__set_ref();

use base qw(
    SOAP::WSDL::XSD::Typelib::Element
    Google::Ads::SOAP::Typelib::ComplexType
);

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %userInterestTaxonomyType_of :ATTR(:get<userInterestTaxonomyType>);

__PACKAGE__->_factory(
    [ qw(        userInterestTaxonomyType

    ) ],
    {
        'userInterestTaxonomyType' => \%userInterestTaxonomyType_of,
    },
    {
        'userInterestTaxonomyType' => 'Google::Ads::AdWords::v201402::ConstantDataService::UserInterestTaxonomyType',
    },
    {

        'userInterestTaxonomyType' => 'userInterestTaxonomyType',
    }
);

} # end BLOCK






} # end of BLOCK



1;


=pod

=head1 NAME

Google::Ads::AdWords::v201402::ConstantDataService::getUserInterestCriterion

=head1 DESCRIPTION

Perl data type class for the XML Schema defined element
getUserInterestCriterion from the namespace https://adwords.google.com/api/adwords/cm/v201402.

Returns a list of user interests. @param userInterestTaxonomyType The type of taxonomy to use when requesting user interests. @return A list of user interests. @throws ApiException when there is at least one error with the request. 





=head1 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * userInterestTaxonomyType

 $element->set_userInterestTaxonomyType($data);
 $element->get_userInterestTaxonomyType();





=back


=head1 METHODS

=head2 new

 my $element = Google::Ads::AdWords::v201402::ConstantDataService::getUserInterestCriterion->new($data);

Constructor. The following data structure may be passed to new():

 {
   userInterestTaxonomyType => $some_value, # ConstantDataService.UserInterestTaxonomyType
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=cut

