package Google::Ads::AdWords::v201209::InStreamAdSpec;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/o/v201209' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %inStreamTypes_of :ATTR(:get<inStreamTypes>);
my %durations_of :ATTR(:get<durations>);

__PACKAGE__->_factory(
    [ qw(        inStreamTypes
        durations

    ) ],
    {
        'inStreamTypes' => \%inStreamTypes_of,
        'durations' => \%durations_of,
    },
    {
        'inStreamTypes' => 'Google::Ads::AdWords::v201209::InStreamAdSpec::InStreamType',
        'durations' => 'SOAP::WSDL::XSD::Typelib::Builtin::long',
    },
    {

        'inStreamTypes' => 'inStreamTypes',
        'durations' => 'durations',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201209::InStreamAdSpec

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
InStreamAdSpec from the namespace https://adwords.google.com/api/adwords/o/v201209.

Placement request/response object which provides details about instream ad types, options, and other available configuration variables. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * inStreamTypes


=item * durations




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Google::Ads::AdWords::v201209::InStreamAdSpec
   inStreamTypes => $some_value, # InStreamAdSpec.InStreamType
   durations =>  $some_value, # long
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

