package DBD::mysqlx;

our $VERSION = '0.003';
our @ISA     = 'DynaLoader';

__PACKAGE__->bootstrap($VERSION);

our $drh = undef;

sub driver {
    return $drh if $drh;      # already created - return same one
    my ($class, $attr) = @_;
 
    $class .= "::dr";

    # not a 'my' since we use it above to prevent multiple drivers
    $drh = DBI::_new_drh($class, {
            'Name'        => 'DBD::mysqlx',
            'Version'     => $VERSION,
            'Attribution' => 'DBD::mysqlx by Daniël van Eeden',
        })
        or return undef;
 
    return $drh;
}

sub CLONE {
  undef $drh;
}

package DBD::mysqlx::dr;

sub connect {
  my ($drh, $dbname, $user, $auth, $attr) = @_;

  my $dbh = DBI::_new_dbh($drh, {
    'Name' => split(/\//,$dbname),
  }) or return undef;

  DBD::mysqlx::db::_login($dbh, $dbname, $user, $auth, $attr)
    or return undef;

  $dbh;
}


package DBD::mysqlx::db;

sub prepare {
  my($dbh, $statement, @attribs) = @_;

  return undef if ! defined $statement;

  # Create a 'blank' statement handle:
  my $sth = DBI::_new_sth($dbh, {'Statement' => $statement});

  if (!DBD::mysqlx::st::_prepare($sth, $statement, @attribs)) {
    $sth = undef;
  }

  $sth;
}

# The type_info_all function was automatically generated by
# DBI::DBD::Metadata::write_typeinfo_pm v2.014214.
sub type_info_all
{
    my ($dbh) = @_;
    require DBD::mysqlx::TypeInfo;
    return [ @$DBD::mysqlx::TypeInfo::type_info_all ];
}

# The get_info function was automatically generated by
# DBI::DBD::Metadata::write_getinfo_pm v2.014214.
sub get_info {
    my($dbh, $info_type) = @_;
    require DBD::mysqlx::GetInfo;
    my $v = $DBD::mysqlx::GetInfo::info{int($info_type)};
    $v = $v->($dbh) if ref $v eq 'CODE';
    return $v;
}

1;

__END__

=pod

=encoding utf8

=head1 NAME

DBD::mysql - MySQL X Protocol driver for the Perl5 Database Interface (DBI)

=head1 COPYRIGHT

This module is Copyright (c) 2018 Daniël van Eeden

=head1 SYNOPSIS

 use DBI;
 my $dsn = "DBI:mysqlx:localhost/test"
 my $dbh = DBI->connect($dsn, "msandbox", "msandbox");

 $dbh->do("DO 1");
 $dbh->disconnect();

The part of the DSN after C<DBI:mysqlx:> is identical to what you would
use in a X Protocol URI after the C<@>. The DSN above would translate to
C<mysqlx://msandbox:msandbox@localhost/test>

=head1 DESCRIPTION

This driver allows you to connect to a MySQL 5.7.12 or newer database
over the MySQL X Protocol. On 5.7 you need to configure it to load the
C<mysqlx> plugin. See L<https://dev.mysql.com/doc/refman/5.7/en/document-store-setting-up.html>
for details.

=head2 Differences with DBD::mysql

DBD::mysql uses libmysqlclient, supports a wide range of MySQL and MariaDB
versions and is stable. It uses the Classic MySQL Protocol.

DBD::mysqlx uses libmysqlcppconn8, only supports MySQL 5.7 and 8.0 and
is experimental. It uses the new MySQL X Protocol, which is protobuf based.

The DSN format is different.

Attributes on the dbh and sth are different, except for DBI standard attributes.

DBD::mysqlx only supports last_insert_id() on the $sth, not on the $dbh.


