use strict;
use warnings;
use Test::More;

use t::Util;
use Imager::Heatmap;

sub linear_gen_matrix {
    my $hmap = hmap;

    $hmap->insert_datas(sample_data('sample.tsv'));
    return $hmap->matrix;
}

sub iterate_gen_matrix {
    my $hmap = hmap;

    my @insert_datas = sample_data('sample.tsv');

    $hmap->insert_datas(@insert_datas[0..$#insert_datas/2]);
    $hmap->insert_datas(@insert_datas[$#insert_datas/2+1..$#insert_datas]);

    return $hmap->matrix;
}

is_deeply(linear_gen_matrix, iterate_gen_matrix,
          "Two matrix generated by single source and splitted source should be same");

done_testing;
