####################################################################
#
#     This file was generated using XDR::Parse version v0.3.1,
#        XDR::Gen version 0.0.5 and LibVirt version v11.7.0
#
#      Don't edit this file, use the source template instead
#
#                 ANY CHANGES HERE WILL BE LOST !
#
####################################################################

package Protocol::Sys::Virt::Remote::XDR v11.7.0;

use constant {
    VIR_TYPED_PARAM_INT     => 1,
    VIR_TYPED_PARAM_UINT    => 2,
    VIR_TYPED_PARAM_LLONG   => 3,
    VIR_TYPED_PARAM_ULLONG  => 4,
    VIR_TYPED_PARAM_DOUBLE  => 5,
    VIR_TYPED_PARAM_BOOLEAN => 6,
    VIR_TYPED_PARAM_STRING  => 7,
};

use v5.14;
use warnings FATAL => 'uninitialized';
use Config;
use Carp qw(croak);
use constant STRING_MAX => 4194304; # 4194304
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_string {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "String too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1] = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_string {
    # my ($class, $value, $index, $output) = @_;
    do {
        my $len = length $_[1];
        croak "Missing required input 'string' value"
            unless defined $_[1];
        die "String too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1];
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_string {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_string {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_string( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
use constant CONNECT_IDENTITY_PARAMS_MAX => 20; # 20
use constant DOMAIN_LIST_MAX => 16384; # 16384
use constant CPUMAP_MAX => 2048; # 2048
use constant VCPUINFO_MAX => 16384; # 16384
use constant CPUMAPS_MAX => 8388608; # 8388608
use constant IOTHREAD_INFO_MAX => 16384; # 16384
use constant MIGRATE_COOKIE_MAX => 4194304; # 4194304
use constant NETWORK_LIST_MAX => 16384; # 16384
use constant NETWORK_PORT_LIST_MAX => 16384; # 16384
use constant INTERFACE_LIST_MAX => 16384; # 16384
use constant STORAGE_POOL_LIST_MAX => 16384; # 16384
use constant STORAGE_VOL_LIST_MAX => 16384; # 16384
use constant NODE_DEVICE_LIST_MAX => 65536; # 65536
use constant NODE_DEVICE_CAPS_LIST_MAX => 65536; # 65536
use constant NWFILTER_LIST_MAX => 16384; # 16384
use constant NWFILTER_BINDING_LIST_MAX => 16384; # 16384
use constant DOMAIN_SCHEDULER_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_BLKIO_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_MEMORY_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_BLOCK_IO_TUNE_PARAMETERS_MAX => 32; # 32
use constant DOMAIN_NUMA_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_PERF_EVENTS_MAX => 64; # 64
use constant DOMAIN_BLOCK_COPY_PARAMETERS_MAX => 16; # 16
use constant NODE_CPU_STATS_MAX => 16; # 16
use constant NODE_MEMORY_STATS_MAX => 16; # 16
use constant DOMAIN_BLOCK_STATS_PARAMETERS_MAX => 16; # 16
use constant NODE_MAX_CELLS => 1024; # 1024
use constant AUTH_SASL_DATA_MAX => 65536; # 65536
use constant AUTH_TYPE_LIST_MAX => 20; # 20
use constant DOMAIN_MEMORY_STATS_MAX => 1024; # 1024
use constant DOMAIN_CHECKPOINT_LIST_MAX => 16384; # 16384
use constant DOMAIN_SNAPSHOT_LIST_MAX => 16384; # 16384
use constant DOMAIN_BLOCK_PEEK_BUFFER_MAX => 4194304; # 4194304
use constant DOMAIN_MEMORY_PEEK_BUFFER_MAX => 4194304; # 4194304
use constant SECURITY_LABEL_LIST_MAX => 64; # 64
use constant SECURITY_MODEL_MAX => 257; # VIR_SECURITY_MODEL_BUFLEN
use constant SECURITY_LABEL_MAX => 4097; # VIR_SECURITY_LABEL_BUFLEN
use constant SECURITY_DOI_MAX => 257; # VIR_SECURITY_DOI_BUFLEN
use constant SECRET_VALUE_MAX => 65536; # 65536
use constant SECRET_LIST_MAX => 16384; # 16384
use constant CPU_BASELINE_MAX => 256; # 256
use constant DOMAIN_SEND_KEY_MAX => 16; # 16
use constant DOMAIN_INTERFACE_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_GET_CPU_STATS_NCPUS_MAX => 128; # 128
use constant DOMAIN_GET_CPU_STATS_MAX => 2048; # 2048
use constant DOMAIN_DISK_ERRORS_MAX => 256; # 256
use constant NODE_MEMORY_PARAMETERS_MAX => 64; # 64
use constant DOMAIN_MIGRATE_PARAM_LIST_MAX => 64; # 64
use constant DOMAIN_SAVE_PARAMS_MAX => 64; # 64
use constant DOMAIN_JOB_STATS_MAX => 64; # 64
use constant CONNECT_CPU_MODELS_MAX => 8192; # 8192
use constant DOMAIN_FSFREEZE_MOUNTPOINTS_MAX => 256; # 256
use constant NETWORK_DHCP_LEASES_MAX => 65536; # 65536
use constant CONNECT_GET_ALL_DOMAIN_STATS_MAX => 262144; # 262144
use constant DOMAIN_EVENT_TUNABLE_MAX => 2048; # 2048
use constant DOMAIN_FSINFO_MAX => 256; # 256
use constant DOMAIN_FSINFO_DISKS_MAX => 256; # 256
use constant DOMAIN_INTERFACE_MAX => 2048; # 2048
use constant DOMAIN_IP_ADDR_MAX => 2048; # 2048
use constant DOMAIN_GUEST_VCPU_PARAMS_MAX => 64; # 64
use constant DOMAIN_IOTHREAD_PARAMS_MAX => 64; # 64
use constant NODE_SEV_INFO_MAX => 64; # 64
use constant DOMAIN_LAUNCH_SECURITY_INFO_PARAMS_MAX => 64; # 64
use constant DOMAIN_LAUNCH_SECURITY_STATE_PARAMS_MAX => 64; # 64
use constant DOMAIN_GUEST_INFO_PARAMS_MAX => 2048; # 2048
use constant NETWORK_PORT_PARAMETERS_MAX => 16; # 16
use constant DOMAIN_AUTHORIZED_SSH_KEYS_MAX => 2048; # 2048
use constant DOMAIN_MESSAGES_MAX => 2048; # 2048
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_uuid {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 16;
    $_[1] = substr( $_[3], $_[2], 16 );
    $_[2] += 16;
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_uuid {
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1];
    do {
        my $len = length $_[1];
        die "Opaque value length mismatch (defined: 16): $len"
            if not $len  == 16;

        substr( $_[3], $_[2] ) = $_[1];
        $_[2] += $len;
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_domain {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );

    # Deserializing field: 'id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{id} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{id}"
        unless (-2147483648 <= $_[1]->{id} and $_[1]->{id} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_domain {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );

    # Serializing field: 'id'
    croak "Missing required input value 'id'"
        unless exists $_[1]->{id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{id};
    die "Out of bounds 'int': $_[1]->{id}"
        unless (-2147483648 <= $_[1]->{id} and $_[1]->{id} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{id}"
        unless int($_[1]->{id}) == $_[1]->{id};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{id});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_network {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_network {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_network_port {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_network_port {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_nwfilter {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_nwfilter {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_nwfilter_binding {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'portdev'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{portdev}, $_[2], $_[3] );

    # Deserializing field: 'filtername'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{filtername}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_nwfilter_binding {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'portdev'
    croak "Missing required input value 'portdev'"
        unless exists $_[1]->{portdev};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{portdev}, $_[2], $_[3] );

    # Serializing field: 'filtername'
    croak "Missing required input value 'filtername'"
        unless exists $_[1]->{filtername};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{filtername}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_interface {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'mac'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{mac}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_interface {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'mac'
    croak "Missing required input value 'mac'"
        unless exists $_[1]->{mac};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{mac}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_storage_pool {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_storage_pool {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_storage_vol {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'key'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{key}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_storage_vol {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'key'
    croak "Missing required input value 'key'"
        unless exists $_[1]->{key};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{key}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_node_device {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_node_device {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_secret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );

    # Deserializing field: 'usageType'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{usageType} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{usageType}"
        unless (-2147483648 <= $_[1]->{usageType} and $_[1]->{usageType} < 2147483648);

    # Deserializing field: 'usageID'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{usageID}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_secret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );

    # Serializing field: 'usageType'
    croak "Missing required input value 'usageType'"
        unless exists $_[1]->{usageType};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{usageType};
    die "Out of bounds 'int': $_[1]->{usageType}"
        unless (-2147483648 <= $_[1]->{usageType} and $_[1]->{usageType} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{usageType}"
        unless int($_[1]->{usageType}) == $_[1]->{usageType};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{usageType});
    $_[2] += 4;

    # Serializing field: 'usageID'
    croak "Missing required input value 'usageID'"
        unless exists $_[1]->{usageID};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{usageID}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_domain_checkpoint {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_domain_checkpoint {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nonnull_domain_snapshot {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nonnull_domain_snapshot {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_domain( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_domain( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_network( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_network( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_port {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_network_port( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_port {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_network_port( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_nwfilter( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_nwfilter( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_binding {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_nwfilter_binding( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_binding {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_nwfilter_binding( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_storage_pool( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_storage_pool( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_storage_vol( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_storage_vol( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_node_device( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_node_device( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    do {
        my $b;
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $b = unpack("L>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $b (must be 0 or 1)"
            unless $b == 0 or $b == 1;
        $_[2] += 4;
        if ($b) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_secret( $_[1], $_[2], $_[3] );
        }
        else {
            $_[1] = undef;
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret {
    # my ($class, $value, $index, $output) = @_;
    if (defined $_[1]) {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 1);
        $_[2] += 4;
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_secret( $_[1], $_[2], $_[3] );
    }
    else {
        # my ($class, $value, $index, $output) = @_;
        # Allow <undef> to model a <false> value
        substr( $_[3], $_[2] ) = pack("L>", 0);
        $_[2] += 4;
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_error {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'code'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{code} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{code}"
        unless (-2147483648 <= $_[1]->{code} and $_[1]->{code} < 2147483648);

    # Deserializing field: 'domain'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{domain} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{domain}"
        unless (-2147483648 <= $_[1]->{domain} and $_[1]->{domain} < 2147483648);

    # Deserializing field: 'message'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{message}, $_[2], $_[3] );

    # Deserializing field: 'level'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{level} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{level}"
        unless (-2147483648 <= $_[1]->{level} and $_[1]->{level} < 2147483648);

    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'str1'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{str1}, $_[2], $_[3] );

    # Deserializing field: 'str2'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{str2}, $_[2], $_[3] );

    # Deserializing field: 'str3'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{str3}, $_[2], $_[3] );

    # Deserializing field: 'int1'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{int1} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{int1}"
        unless (-2147483648 <= $_[1]->{int1} and $_[1]->{int1} < 2147483648);

    # Deserializing field: 'int2'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{int2} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{int2}"
        unless (-2147483648 <= $_[1]->{int2} and $_[1]->{int2} < 2147483648);

    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_error {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'code'
    croak "Missing required input value 'code'"
        unless exists $_[1]->{code};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{code};
    die "Out of bounds 'int': $_[1]->{code}"
        unless (-2147483648 <= $_[1]->{code} and $_[1]->{code} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{code}"
        unless int($_[1]->{code}) == $_[1]->{code};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{code});
    $_[2] += 4;

    # Serializing field: 'domain'
    croak "Missing required input value 'domain'"
        unless exists $_[1]->{domain};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{domain};
    die "Out of bounds 'int': $_[1]->{domain}"
        unless (-2147483648 <= $_[1]->{domain} and $_[1]->{domain} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{domain}"
        unless int($_[1]->{domain}) == $_[1]->{domain};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{domain});
    $_[2] += 4;

    # Serializing field: 'message'
    croak "Missing required input value 'message'"
        unless exists $_[1]->{message};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{message}, $_[2], $_[3] );

    # Serializing field: 'level'
    croak "Missing required input value 'level'"
        unless exists $_[1]->{level};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{level};
    die "Out of bounds 'int': $_[1]->{level}"
        unless (-2147483648 <= $_[1]->{level} and $_[1]->{level} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{level}"
        unless int($_[1]->{level}) == $_[1]->{level};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{level});
    $_[2] += 4;

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'str1'
    croak "Missing required input value 'str1'"
        unless exists $_[1]->{str1};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{str1}, $_[2], $_[3] );

    # Serializing field: 'str2'
    croak "Missing required input value 'str2'"
        unless exists $_[1]->{str2};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{str2}, $_[2], $_[3] );

    # Serializing field: 'str3'
    croak "Missing required input value 'str3'"
        unless exists $_[1]->{str3};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{str3}, $_[2], $_[3] );

    # Serializing field: 'int1'
    croak "Missing required input value 'int1'"
        unless exists $_[1]->{int1};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{int1};
    die "Out of bounds 'int': $_[1]->{int1}"
        unless (-2147483648 <= $_[1]->{int1} and $_[1]->{int1} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{int1}"
        unless int($_[1]->{int1}) == $_[1]->{int1};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{int1});
    $_[2] += 4;

    # Serializing field: 'int2'
    croak "Missing required input value 'int2'"
        unless exists $_[1]->{int2};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{int2};
    die "Out of bounds 'int': $_[1]->{int2}"
        unless (-2147483648 <= $_[1]->{int2} and $_[1]->{int2} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{int2}"
        unless int($_[1]->{int2}) == $_[1]->{int2};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{int2});
    $_[2] += 4;

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_network( $_[1]->{net}, $_[2], $_[3] );
}
# Define elements from enum 'auth_type'
use constant {
    AUTH_NONE   => 0,
    AUTH_SASL   => 1,
    AUTH_POLKIT => 2,
};
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_type {
    my $input_length = length $_[3];
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1] = unpack("l>", substr( $_[3], $_[2] ) );
    die "Out of range enum value supplied: $_[1]"
        unless vec(state $m = pack('H*', '07'),
                   $_[1], 1);
    $_[2] += 4;
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_type {
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'enum' value"
        unless defined $_[1];
    die "Out of range enum value: $_[1]"
        unless vec(state $m = pack('H*', '07'),
                   $_[1], 1);
    substr( $_[3], $_[2] ) = pack("l>", $_[1]);
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_vcpu_info {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'number'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{number} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{number}"
        unless (0 <= $_[1]->{number} and $_[1]->{number} <= 4294967295);

    # Deserializing field: 'state'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{state} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{state}"
        unless (-2147483648 <= $_[1]->{state} and $_[1]->{state} < 2147483648);

    # Deserializing field: 'cpu_time'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{cpu_time} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{cpu_time}"
        unless (0 <= $_[1]->{cpu_time}
                and $_[1]->{cpu_time} <= 18446744073709551615);

    # Deserializing field: 'cpu'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cpu} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cpu}"
        unless (-2147483648 <= $_[1]->{cpu} and $_[1]->{cpu} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_vcpu_info {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'number'
    croak "Missing required input value 'number'"
        unless exists $_[1]->{number};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{number};
    die "Out of bounds 'unsigned int': $_[1]->{number}"
        unless (0 <= $_[1]->{number} and $_[1]->{number} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{number}"
        unless int($_[1]->{number}) == $_[1]->{number};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{number});
    $_[2] += 4;

    # Serializing field: 'state'
    croak "Missing required input value 'state'"
        unless exists $_[1]->{state};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{state};
    die "Out of bounds 'int': $_[1]->{state}"
        unless (-2147483648 <= $_[1]->{state} and $_[1]->{state} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{state}"
        unless int($_[1]->{state}) == $_[1]->{state};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{state});
    $_[2] += 4;

    # Serializing field: 'cpu_time'
    croak "Missing required input value 'cpu_time'"
        unless exists $_[1]->{cpu_time};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{cpu_time};
    die "Out of bounds 'unsigned hyper': $_[1]->{cpu_time}"
        unless (0 <= $_[1]->{cpu_time}
                and $_[1]->{cpu_time} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{cpu_time}"
        unless int($_[1]->{cpu_time}) == $_[1]->{cpu_time};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cpu_time});
    $_[2] += 8;

    # Serializing field: 'cpu'
    croak "Missing required input value 'cpu'"
        unless exists $_[1]->{cpu};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cpu};
    die "Out of bounds 'int': $_[1]->{cpu}"
        unless (-2147483648 <= $_[1]->{cpu} and $_[1]->{cpu} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cpu}"
        unless int($_[1]->{cpu}) == $_[1]->{cpu};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cpu});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_typed_param_value {
    my $input_length = length $_[3];
    $_[1] = {};
    my $d;
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $d = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $d"
        unless (-2147483648 <= $d and $d < 2147483648);

    $_[1]->{type} = $d;
    # Deserializing member 'i' (discriminator == VIR_TYPED_PARAM_INT)
    if ($d == VIR_TYPED_PARAM_INT) {
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $_[1]->{i} = unpack("l>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Out of bounds 'int': $_[1]->{i}"
            unless (-2147483648 <= $_[1]->{i} and $_[1]->{i} < 2147483648);
    }

    # Deserializing member 'ui' (discriminator == VIR_TYPED_PARAM_UINT)
    elsif ($d == VIR_TYPED_PARAM_UINT) {
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $_[1]->{ui} = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Out of bounds 'unsigned int': $_[1]->{ui}"
            unless (0 <= $_[1]->{ui} and $_[1]->{ui} <= 4294967295);
    }

    # Deserializing member 'l' (discriminator == VIR_TYPED_PARAM_LLONG)
    elsif ($d == VIR_TYPED_PARAM_LLONG) {
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 8;
        $_[1]->{l} = unpack("q>", substr( $_[3], $_[2] ));
        $_[2] += 8;
        die "Out of bounds 'hyper': $_[1]->{l}"
            unless (-9223372036854775808 <= $_[1]->{l}
                    and $_[1]->{l} < 9223372036854775808);
    }

    # Deserializing member 'ul' (discriminator == VIR_TYPED_PARAM_ULLONG)
    elsif ($d == VIR_TYPED_PARAM_ULLONG) {
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 8;
        $_[1]->{ul} = unpack("Q>", substr( $_[3], $_[2] ));
        $_[2] += 8;
        die "Out of bounds 'unsigned hyper': $_[1]->{ul}"
            unless (0 <= $_[1]->{ul}
                    and $_[1]->{ul} <= 18446744073709551615);
    }

    # Deserializing member 'd' (discriminator == VIR_TYPED_PARAM_DOUBLE)
    elsif ($d == VIR_TYPED_PARAM_DOUBLE) {
        # my ($class, $value, $index, $input) = @_;
        die "The platform doesn't support IEEE-754 floats"
            unless $Config{d_double_style_ieee754};
        die "Input buffer too short"
            if ($input_length - $_[2]) < 8;
        $_[1]->{d} = unpack("d>", substr( $_[3], $_[2] ));
        die "Incorrect bool value $_[1]->{d} (must be 0 or 1)"
            unless $_[1]->{d} == 0 or $_[1]->{d} == 1;
        $_[2] += 8;
    }

    # Deserializing member 'b' (discriminator == VIR_TYPED_PARAM_BOOLEAN)
    elsif ($d == VIR_TYPED_PARAM_BOOLEAN) {
        # my ($class, $value, $index, $input) = @_;
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        $_[1]->{b} = unpack("l>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Out of bounds 'int': $_[1]->{b}"
            unless (-2147483648 <= $_[1]->{b} and $_[1]->{b} < 2147483648);
    }

    # Deserializing member 's' (discriminator == VIR_TYPED_PARAM_STRING)
    elsif ($d == VIR_TYPED_PARAM_STRING) {
        # my ($class, $value, $index, $input) = @_;
        $_[0]->deserialize_nonnull_string( $_[1]->{s}, $_[2], $_[3] );
    }

    else {
        die "Unhandled union discriminator value ($d)";
    }
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_typed_param_value {
    croak "Missing required input 'union' value"
        unless defined $_[1];

    my $d = $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $d;
    die "Out of bounds 'int': $d"
        unless (-2147483648 <= $d and $d < 2147483648);
    die "Non-integer 'int' value given: $d"
        unless int($d) == $d;
    substr( $_[3], $_[2] ) = pack("l>", $d);
    $_[2] += 4;

    # Serializing member 'i' (discriminator == VIR_TYPED_PARAM_INT)
    if ($d == VIR_TYPED_PARAM_INT) {
        # my ($class, $value, $index, $output) = @_;
        croak "Missing required input 'int' value"
            unless defined $_[1]->{i};
        die "Out of bounds 'int': $_[1]->{i}"
            unless (-2147483648 <= $_[1]->{i} and $_[1]->{i} < 2147483648);
        die "Non-integer 'int' value given: $_[1]->{i}"
            unless int($_[1]->{i}) == $_[1]->{i};
        substr( $_[3], $_[2] ) = pack("l>", $_[1]->{i});
        $_[2] += 4;
    }

    # Serializing member 'ui' (discriminator == VIR_TYPED_PARAM_UINT)
    elsif ($d == VIR_TYPED_PARAM_UINT) {
        # my ($class, $value, $index, $output) = @_;
        croak "Missing required input 'unsigned int' value"
            unless defined $_[1]->{ui};
        die "Out of bounds 'unsigned int': $_[1]->{ui}"
            unless (0 <= $_[1]->{ui} and $_[1]->{ui} <= 4294967295);
        die "Non-integer 'int' value given: $_[1]->{ui}"
            unless int($_[1]->{ui}) == $_[1]->{ui};
        substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ui});
        $_[2] += 4;
    }

    # Serializing member 'l' (discriminator == VIR_TYPED_PARAM_LLONG)
    elsif ($d == VIR_TYPED_PARAM_LLONG) {
        # my ($class, $value, $index, $output) = @_;
        croak "Missing required input 'long' value"
            unless defined $_[1]->{l};
        die "Out of bounds 'hyper': $_[1]->{l}"
            unless (-9223372036854775808 <= $_[1]->{l}
                    and $_[1]->{l} < 9223372036854775808);
        die "Non-integer 'long' value given: $_[1]->{l}"
            unless int($_[1]->{l}) == $_[1]->{l};
        substr( $_[3], $_[2] ) = pack("q>", $_[1]->{l});
        $_[2] += 8;
    }

    # Serializing member 'ul' (discriminator == VIR_TYPED_PARAM_ULLONG)
    elsif ($d == VIR_TYPED_PARAM_ULLONG) {
        # my ($class, $value, $index, $output) = @_;
        croak "Missing required input 'unsigned long' value"
            unless defined $_[1]->{ul};
        die "Out of bounds 'unsigned hyper': $_[1]->{ul}"
            unless (0 <= $_[1]->{ul}
                    and $_[1]->{ul} <= 18446744073709551615);
        die "Non-integer 'long' value given: $_[1]->{ul}"
            unless int($_[1]->{ul}) == $_[1]->{ul};
        substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{ul});
        $_[2] += 8;
    }

    # Serializing member 'd' (discriminator == VIR_TYPED_PARAM_DOUBLE)
    elsif ($d == VIR_TYPED_PARAM_DOUBLE) {
        # my ($class, $value, $index, $output) = @_;
        die "The platform doesn't support IEEE-754 floats"
            unless $Config{d_double_style_ieee754};
        croak "Missing required input 'double' value"
            unless defined $_[1]->{d};
        substr( $_[3], $_[2] ) = pack("d>", $_[1]->{d});
        $_[2] += 8;
    }

    # Serializing member 'b' (discriminator == VIR_TYPED_PARAM_BOOLEAN)
    elsif ($d == VIR_TYPED_PARAM_BOOLEAN) {
        # my ($class, $value, $index, $output) = @_;
        croak "Missing required input 'int' value"
            unless defined $_[1]->{b};
        die "Out of bounds 'int': $_[1]->{b}"
            unless (-2147483648 <= $_[1]->{b} and $_[1]->{b} < 2147483648);
        die "Non-integer 'int' value given: $_[1]->{b}"
            unless int($_[1]->{b}) == $_[1]->{b};
        substr( $_[3], $_[2] ) = pack("l>", $_[1]->{b});
        $_[2] += 4;
    }

    # Serializing member 's' (discriminator == VIR_TYPED_PARAM_STRING)
    elsif ($d == VIR_TYPED_PARAM_STRING) {
        # my ($class, $value, $index, $output) = @_;
        $_[0]->serialize_nonnull_string( $_[1]->{s}, $_[2], $_[3] );
    }

    else {
        die "Unhandled union discriminator value ($d)";
    }
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_typed_param {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'field'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Deserializing field: 'value'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_typed_param_value( $_[1]->{value}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_typed_param {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'field'
    croak "Missing required input value 'field'"
        unless exists $_[1]->{field};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Serializing field: 'value'
    croak "Missing required input value 'value'"
        unless exists $_[1]->{value};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_typed_param_value( $_[1]->{value}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_cpu_stats {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'field'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Deserializing field: 'value'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{value} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{value}"
        unless (0 <= $_[1]->{value}
                and $_[1]->{value} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_cpu_stats {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'field'
    croak "Missing required input value 'field'"
        unless exists $_[1]->{field};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Serializing field: 'value'
    croak "Missing required input value 'value'"
        unless exists $_[1]->{value};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{value};
    die "Out of bounds 'unsigned hyper': $_[1]->{value}"
        unless (0 <= $_[1]->{value}
                and $_[1]->{value} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{value}"
        unless int($_[1]->{value}) == $_[1]->{value};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{value});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_memory_stats {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'field'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Deserializing field: 'value'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{value} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{value}"
        unless (0 <= $_[1]->{value}
                and $_[1]->{value} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_memory_stats {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'field'
    croak "Missing required input value 'field'"
        unless exists $_[1]->{field};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{field}, $_[2], $_[3] );

    # Serializing field: 'value'
    croak "Missing required input value 'value'"
        unless exists $_[1]->{value};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{value};
    die "Out of bounds 'unsigned hyper': $_[1]->{value}"
        unless (0 <= $_[1]->{value}
                and $_[1]->{value} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{value}"
        unless int($_[1]->{value}) == $_[1]->{value};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{value});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_disk_error {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'disk'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Deserializing field: 'error'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{error} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{error}"
        unless (-2147483648 <= $_[1]->{error} and $_[1]->{error} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_disk_error {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'disk'
    croak "Missing required input value 'disk'"
        unless exists $_[1]->{disk};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Serializing field: 'error'
    croak "Missing required input value 'error'"
        unless exists $_[1]->{error};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{error};
    die "Out of bounds 'int': $_[1]->{error}"
        unless (-2147483648 <= $_[1]->{error} and $_[1]->{error} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{error}"
        unless int($_[1]->{error}) == $_[1]->{error};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{error});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_open_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_open_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_supports_feature_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'feature'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{feature} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{feature}"
        unless (-2147483648 <= $_[1]->{feature} and $_[1]->{feature} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_supports_feature_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'feature'
    croak "Missing required input value 'feature'"
        unless exists $_[1]->{feature};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{feature};
    die "Out of bounds 'int': $_[1]->{feature}"
        unless (-2147483648 <= $_[1]->{feature} and $_[1]->{feature} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{feature}"
        unless int($_[1]->{feature}) == $_[1]->{feature};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{feature});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_supports_feature_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'supported'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{supported} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{supported}"
        unless (-2147483648 <= $_[1]->{supported} and $_[1]->{supported} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_supports_feature_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'supported'
    croak "Missing required input value 'supported'"
        unless exists $_[1]->{supported};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{supported};
    die "Out of bounds 'int': $_[1]->{supported}"
        unless (-2147483648 <= $_[1]->{supported} and $_[1]->{supported} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{supported}"
        unless int($_[1]->{supported}) == $_[1]->{supported};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{supported});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_type_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_type_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_version_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'hv_ver'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{hv_ver} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{hv_ver}"
        unless (0 <= $_[1]->{hv_ver}
                and $_[1]->{hv_ver} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_version_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'hv_ver'
    croak "Missing required input value 'hv_ver'"
        unless exists $_[1]->{hv_ver};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{hv_ver};
    die "Out of bounds 'unsigned hyper': $_[1]->{hv_ver}"
        unless (0 <= $_[1]->{hv_ver}
                and $_[1]->{hv_ver} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{hv_ver}"
        unless int($_[1]->{hv_ver}) == $_[1]->{hv_ver};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{hv_ver});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_lib_version_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'lib_ver'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{lib_ver} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{lib_ver}"
        unless (0 <= $_[1]->{lib_ver}
                and $_[1]->{lib_ver} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_lib_version_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'lib_ver'
    croak "Missing required input value 'lib_ver'"
        unless exists $_[1]->{lib_ver};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{lib_ver};
    die "Out of bounds 'unsigned hyper': $_[1]->{lib_ver}"
        unless (0 <= $_[1]->{lib_ver}
                and $_[1]->{lib_ver} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{lib_ver}"
        unless int($_[1]->{lib_ver}) == $_[1]->{lib_ver};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{lib_ver});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_hostname_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'hostname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{hostname}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_hostname_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'hostname'
    croak "Missing required input value 'hostname'"
        unless exists $_[1]->{hostname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{hostname}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_sysinfo_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_sysinfo_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_sysinfo_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'sysinfo'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{sysinfo}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_sysinfo_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'sysinfo'
    croak "Missing required input value 'sysinfo'"
        unless exists $_[1]->{sysinfo};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{sysinfo}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_uri_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_uri_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_max_vcpus_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_max_vcpus_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_max_vcpus_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'max_vcpus'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{max_vcpus} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{max_vcpus}"
        unless (-2147483648 <= $_[1]->{max_vcpus} and $_[1]->{max_vcpus} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_max_vcpus_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'max_vcpus'
    croak "Missing required input value 'max_vcpus'"
        unless exists $_[1]->{max_vcpus};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{max_vcpus};
    die "Out of bounds 'int': $_[1]->{max_vcpus}"
        unless (-2147483648 <= $_[1]->{max_vcpus} and $_[1]->{max_vcpus} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{max_vcpus}"
        unless int($_[1]->{max_vcpus}) == $_[1]->{max_vcpus};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{max_vcpus});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'model'
    # my ($class, $value, $index, $input) = @_;
    $_[1]->{model} = [];
    for my $i1 ( 0 .. (32 - 1) ) {
        # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{model}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{model}->[$i1]"
                unless (-128 <= $_[1]->{model}->[$i1] and $_[1]->{model}->[$i1] < 128);
    }

    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);

    # Deserializing field: 'cpus'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cpus} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cpus}"
        unless (-2147483648 <= $_[1]->{cpus} and $_[1]->{cpus} < 2147483648);

    # Deserializing field: 'mhz'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{mhz} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{mhz}"
        unless (-2147483648 <= $_[1]->{mhz} and $_[1]->{mhz} < 2147483648);

    # Deserializing field: 'nodes'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nodes} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nodes}"
        unless (-2147483648 <= $_[1]->{nodes} and $_[1]->{nodes} < 2147483648);

    # Deserializing field: 'sockets'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{sockets} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{sockets}"
        unless (-2147483648 <= $_[1]->{sockets} and $_[1]->{sockets} < 2147483648);

    # Deserializing field: 'cores'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cores} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cores}"
        unless (-2147483648 <= $_[1]->{cores} and $_[1]->{cores} < 2147483648);

    # Deserializing field: 'threads'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{threads} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{threads}"
        unless (-2147483648 <= $_[1]->{threads} and $_[1]->{threads} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'model'
    croak "Missing required input value 'model'"
        unless exists $_[1]->{model};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{model};
    do {
        my $len = scalar @{ $_[1]->{model} };
        die "Array length mismatch (defined: 32): $len"
            if not $len  == 32;

        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{model}->[$i1];
            die "Out of bounds 'char': $_[1]->{model}->[$i1]"
                unless (-128 <= $_[1]->{model}->[$i1] and $_[1]->{model}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{model}->[$i1]"
                unless int($_[1]->{model}->[$i1]) == $_[1]->{model}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{model}->[$i1]);
            $_[2] += 4;
        }
    };

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;

    # Serializing field: 'cpus'
    croak "Missing required input value 'cpus'"
        unless exists $_[1]->{cpus};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cpus};
    die "Out of bounds 'int': $_[1]->{cpus}"
        unless (-2147483648 <= $_[1]->{cpus} and $_[1]->{cpus} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cpus}"
        unless int($_[1]->{cpus}) == $_[1]->{cpus};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cpus});
    $_[2] += 4;

    # Serializing field: 'mhz'
    croak "Missing required input value 'mhz'"
        unless exists $_[1]->{mhz};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{mhz};
    die "Out of bounds 'int': $_[1]->{mhz}"
        unless (-2147483648 <= $_[1]->{mhz} and $_[1]->{mhz} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{mhz}"
        unless int($_[1]->{mhz}) == $_[1]->{mhz};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{mhz});
    $_[2] += 4;

    # Serializing field: 'nodes'
    croak "Missing required input value 'nodes'"
        unless exists $_[1]->{nodes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nodes};
    die "Out of bounds 'int': $_[1]->{nodes}"
        unless (-2147483648 <= $_[1]->{nodes} and $_[1]->{nodes} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nodes}"
        unless int($_[1]->{nodes}) == $_[1]->{nodes};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nodes});
    $_[2] += 4;

    # Serializing field: 'sockets'
    croak "Missing required input value 'sockets'"
        unless exists $_[1]->{sockets};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{sockets};
    die "Out of bounds 'int': $_[1]->{sockets}"
        unless (-2147483648 <= $_[1]->{sockets} and $_[1]->{sockets} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{sockets}"
        unless int($_[1]->{sockets}) == $_[1]->{sockets};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{sockets});
    $_[2] += 4;

    # Serializing field: 'cores'
    croak "Missing required input value 'cores'"
        unless exists $_[1]->{cores};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cores};
    die "Out of bounds 'int': $_[1]->{cores}"
        unless (-2147483648 <= $_[1]->{cores} and $_[1]->{cores} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cores}"
        unless int($_[1]->{cores}) == $_[1]->{cores};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cores});
    $_[2] += 4;

    # Serializing field: 'threads'
    croak "Missing required input value 'threads'"
        unless exists $_[1]->{threads};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{threads};
    die "Out of bounds 'int': $_[1]->{threads}"
        unless (-2147483648 <= $_[1]->{threads} and $_[1]->{threads} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{threads}"
        unless int($_[1]->{threads}) == $_[1]->{threads};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{threads});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_capabilities_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'capabilities'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{capabilities}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_capabilities_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'capabilities'
    croak "Missing required input value 'capabilities'"
        unless exists $_[1]->{capabilities};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{capabilities}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_domain_capabilities_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'emulatorbin'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{emulatorbin}, $_[2], $_[3] );

    # Deserializing field: 'arch'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{arch}, $_[2], $_[3] );

    # Deserializing field: 'machine'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{machine}, $_[2], $_[3] );

    # Deserializing field: 'virttype'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{virttype}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_domain_capabilities_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'emulatorbin'
    croak "Missing required input value 'emulatorbin'"
        unless exists $_[1]->{emulatorbin};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{emulatorbin}, $_[2], $_[3] );

    # Serializing field: 'arch'
    croak "Missing required input value 'arch'"
        unless exists $_[1]->{arch};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{arch}, $_[2], $_[3] );

    # Serializing field: 'machine'
    croak "Missing required input value 'machine'"
        unless exists $_[1]->{machine};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{machine}, $_[2], $_[3] );

    # Serializing field: 'virttype'
    croak "Missing required input value 'virttype'"
        unless exists $_[1]->{virttype};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{virttype}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_get_domain_capabilities_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'capabilities'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{capabilities}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_get_domain_capabilities_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'capabilities'
    croak "Missing required input value 'capabilities'"
        unless exists $_[1]->{capabilities};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{capabilities}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_cpu_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cpuNum'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cpuNum} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cpuNum}"
        unless (-2147483648 <= $_[1]->{cpuNum} and $_[1]->{cpuNum} < 2147483648);

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_cpu_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cpuNum'
    croak "Missing required input value 'cpuNum'"
        unless exists $_[1]->{cpuNum};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cpuNum};
    die "Out of bounds 'int': $_[1]->{cpuNum}"
        unless (-2147483648 <= $_[1]->{cpuNum} and $_[1]->{cpuNum} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cpuNum}"
        unless int($_[1]->{cpuNum}) == $_[1]->{cpuNum};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cpuNum});
    $_[2] += 4;

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_cpu_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_node_get_cpu_stats( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_cpu_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_node_get_cpu_stats( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_memory_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'cellNum'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cellNum} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cellNum}"
        unless (-2147483648 <= $_[1]->{cellNum} and $_[1]->{cellNum} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_memory_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'cellNum'
    croak "Missing required input value 'cellNum'"
        unless exists $_[1]->{cellNum};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cellNum};
    die "Out of bounds 'int': $_[1]->{cellNum}"
        unless (-2147483648 <= $_[1]->{cellNum} and $_[1]->{cellNum} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cellNum}"
        unless int($_[1]->{cellNum}) == $_[1]->{cellNum};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cellNum});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_memory_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_node_get_memory_stats( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_memory_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_node_get_memory_stats( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_cells_free_memory_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'startCell'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{startCell} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{startCell}"
        unless (-2147483648 <= $_[1]->{startCell} and $_[1]->{startCell} < 2147483648);

    # Deserializing field: 'maxcells'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxcells} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxcells}"
        unless (-2147483648 <= $_[1]->{maxcells} and $_[1]->{maxcells} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_cells_free_memory_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'startCell'
    croak "Missing required input value 'startCell'"
        unless exists $_[1]->{startCell};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{startCell};
    die "Out of bounds 'int': $_[1]->{startCell}"
        unless (-2147483648 <= $_[1]->{startCell} and $_[1]->{startCell} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{startCell}"
        unless int($_[1]->{startCell}) == $_[1]->{startCell};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{startCell});
    $_[2] += 4;

    # Serializing field: 'maxcells'
    croak "Missing required input value 'maxcells'"
        unless exists $_[1]->{maxcells};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxcells};
    die "Out of bounds 'int': $_[1]->{maxcells}"
        unless (-2147483648 <= $_[1]->{maxcells} and $_[1]->{maxcells} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxcells}"
        unless int($_[1]->{maxcells}) == $_[1]->{maxcells};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxcells});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_cells_free_memory_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cells'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 1024): $len"
            unless ($len <= 1024);
        $_[1]->{cells} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 8;
            $_[1]->{cells}->[$i1] = unpack("Q>", substr( $_[3], $_[2] ));
            $_[2] += 8;
            die "Out of bounds 'unsigned hyper': $_[1]->{cells}->[$i1]"
                unless (0 <= $_[1]->{cells}->[$i1]
                        and $_[1]->{cells}->[$i1] <= 18446744073709551615);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_cells_free_memory_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cells'
    croak "Missing required input value 'cells'"
        unless exists $_[1]->{cells};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{cells};
    do {
        my $len = scalar @{ $_[1]->{cells} };
        die "Array too long (max: 1024): $len"
            unless ($len <= 1024);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'unsigned long' value"
                unless defined $_[1]->{cells}->[$i1];
            die "Out of bounds 'unsigned hyper': $_[1]->{cells}->[$i1]"
                unless (0 <= $_[1]->{cells}->[$i1]
                        and $_[1]->{cells}->[$i1] <= 18446744073709551615);
            die "Non-integer 'long' value given: $_[1]->{cells}->[$i1]"
                unless int($_[1]->{cells}->[$i1]) == $_[1]->{cells}->[$i1];
            substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cells}->[$i1]);
            $_[2] += 8;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_free_memory_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'freeMem'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{freeMem} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{freeMem}"
        unless (0 <= $_[1]->{freeMem}
                and $_[1]->{freeMem} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_free_memory_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'freeMem'
    croak "Missing required input value 'freeMem'"
        unless exists $_[1]->{freeMem};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{freeMem};
    die "Out of bounds 'unsigned hyper': $_[1]->{freeMem}"
        unless (0 <= $_[1]->{freeMem}
                and $_[1]->{freeMem} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{freeMem}"
        unless int($_[1]->{freeMem}) == $_[1]->{freeMem};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{freeMem});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_type_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_type_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_type_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_type_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_parameters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_parameters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_parameters_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_parameters_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_scheduler_parameters_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_scheduler_parameters_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_scheduler_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_scheduler_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_scheduler_parameters_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_scheduler_parameters_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_blkio_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_blkio_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_blkio_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_blkio_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_blkio_parameters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_blkio_parameters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_memory_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_memory_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_memory_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_memory_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_memory_parameters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_memory_parameters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_resize_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'disk'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Deserializing field: 'size'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{size} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{size}"
        unless (0 <= $_[1]->{size}
                and $_[1]->{size} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_resize_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'disk'
    croak "Missing required input value 'disk'"
        unless exists $_[1]->{disk};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Serializing field: 'size'
    croak "Missing required input value 'size'"
        unless exists $_[1]->{size};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{size};
    die "Out of bounds 'unsigned hyper': $_[1]->{size}"
        unless (0 <= $_[1]->{size}
                and $_[1]->{size} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{size}"
        unless int($_[1]->{size}) == $_[1]->{size};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{size});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_numa_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_numa_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_numa_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_numa_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_numa_parameters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_numa_parameters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_perf_events_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_perf_events_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_perf_events_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_perf_events_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_perf_events_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_perf_events_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'rd_req'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rd_req} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rd_req}"
        unless (-9223372036854775808 <= $_[1]->{rd_req}
                and $_[1]->{rd_req} < 9223372036854775808);

    # Deserializing field: 'rd_bytes'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rd_bytes} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rd_bytes}"
        unless (-9223372036854775808 <= $_[1]->{rd_bytes}
                and $_[1]->{rd_bytes} < 9223372036854775808);

    # Deserializing field: 'wr_req'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{wr_req} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{wr_req}"
        unless (-9223372036854775808 <= $_[1]->{wr_req}
                and $_[1]->{wr_req} < 9223372036854775808);

    # Deserializing field: 'wr_bytes'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{wr_bytes} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{wr_bytes}"
        unless (-9223372036854775808 <= $_[1]->{wr_bytes}
                and $_[1]->{wr_bytes} < 9223372036854775808);

    # Deserializing field: 'errs'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{errs} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{errs}"
        unless (-9223372036854775808 <= $_[1]->{errs}
                and $_[1]->{errs} < 9223372036854775808);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'rd_req'
    croak "Missing required input value 'rd_req'"
        unless exists $_[1]->{rd_req};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rd_req};
    die "Out of bounds 'hyper': $_[1]->{rd_req}"
        unless (-9223372036854775808 <= $_[1]->{rd_req}
                and $_[1]->{rd_req} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rd_req}"
        unless int($_[1]->{rd_req}) == $_[1]->{rd_req};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rd_req});
    $_[2] += 8;

    # Serializing field: 'rd_bytes'
    croak "Missing required input value 'rd_bytes'"
        unless exists $_[1]->{rd_bytes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rd_bytes};
    die "Out of bounds 'hyper': $_[1]->{rd_bytes}"
        unless (-9223372036854775808 <= $_[1]->{rd_bytes}
                and $_[1]->{rd_bytes} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rd_bytes}"
        unless int($_[1]->{rd_bytes}) == $_[1]->{rd_bytes};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rd_bytes});
    $_[2] += 8;

    # Serializing field: 'wr_req'
    croak "Missing required input value 'wr_req'"
        unless exists $_[1]->{wr_req};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{wr_req};
    die "Out of bounds 'hyper': $_[1]->{wr_req}"
        unless (-9223372036854775808 <= $_[1]->{wr_req}
                and $_[1]->{wr_req} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{wr_req}"
        unless int($_[1]->{wr_req}) == $_[1]->{wr_req};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{wr_req});
    $_[2] += 8;

    # Serializing field: 'wr_bytes'
    croak "Missing required input value 'wr_bytes'"
        unless exists $_[1]->{wr_bytes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{wr_bytes};
    die "Out of bounds 'hyper': $_[1]->{wr_bytes}"
        unless (-9223372036854775808 <= $_[1]->{wr_bytes}
                and $_[1]->{wr_bytes} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{wr_bytes}"
        unless int($_[1]->{wr_bytes}) == $_[1]->{wr_bytes};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{wr_bytes});
    $_[2] += 8;

    # Serializing field: 'errs'
    croak "Missing required input value 'errs'"
        unless exists $_[1]->{errs};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{errs};
    die "Out of bounds 'hyper': $_[1]->{errs}"
        unless (-9223372036854775808 <= $_[1]->{errs}
                and $_[1]->{errs} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{errs}"
        unless int($_[1]->{errs}) == $_[1]->{errs};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{errs});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_stats_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_stats_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_stats_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_stats_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_interface_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'device'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_interface_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'device'
    croak "Missing required input value 'device'"
        unless exists $_[1]->{device};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_interface_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'rx_bytes'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rx_bytes} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rx_bytes}"
        unless (-9223372036854775808 <= $_[1]->{rx_bytes}
                and $_[1]->{rx_bytes} < 9223372036854775808);

    # Deserializing field: 'rx_packets'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rx_packets} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rx_packets}"
        unless (-9223372036854775808 <= $_[1]->{rx_packets}
                and $_[1]->{rx_packets} < 9223372036854775808);

    # Deserializing field: 'rx_errs'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rx_errs} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rx_errs}"
        unless (-9223372036854775808 <= $_[1]->{rx_errs}
                and $_[1]->{rx_errs} < 9223372036854775808);

    # Deserializing field: 'rx_drop'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{rx_drop} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{rx_drop}"
        unless (-9223372036854775808 <= $_[1]->{rx_drop}
                and $_[1]->{rx_drop} < 9223372036854775808);

    # Deserializing field: 'tx_bytes'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{tx_bytes} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{tx_bytes}"
        unless (-9223372036854775808 <= $_[1]->{tx_bytes}
                and $_[1]->{tx_bytes} < 9223372036854775808);

    # Deserializing field: 'tx_packets'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{tx_packets} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{tx_packets}"
        unless (-9223372036854775808 <= $_[1]->{tx_packets}
                and $_[1]->{tx_packets} < 9223372036854775808);

    # Deserializing field: 'tx_errs'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{tx_errs} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{tx_errs}"
        unless (-9223372036854775808 <= $_[1]->{tx_errs}
                and $_[1]->{tx_errs} < 9223372036854775808);

    # Deserializing field: 'tx_drop'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{tx_drop} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{tx_drop}"
        unless (-9223372036854775808 <= $_[1]->{tx_drop}
                and $_[1]->{tx_drop} < 9223372036854775808);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_interface_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'rx_bytes'
    croak "Missing required input value 'rx_bytes'"
        unless exists $_[1]->{rx_bytes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rx_bytes};
    die "Out of bounds 'hyper': $_[1]->{rx_bytes}"
        unless (-9223372036854775808 <= $_[1]->{rx_bytes}
                and $_[1]->{rx_bytes} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rx_bytes}"
        unless int($_[1]->{rx_bytes}) == $_[1]->{rx_bytes};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rx_bytes});
    $_[2] += 8;

    # Serializing field: 'rx_packets'
    croak "Missing required input value 'rx_packets'"
        unless exists $_[1]->{rx_packets};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rx_packets};
    die "Out of bounds 'hyper': $_[1]->{rx_packets}"
        unless (-9223372036854775808 <= $_[1]->{rx_packets}
                and $_[1]->{rx_packets} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rx_packets}"
        unless int($_[1]->{rx_packets}) == $_[1]->{rx_packets};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rx_packets});
    $_[2] += 8;

    # Serializing field: 'rx_errs'
    croak "Missing required input value 'rx_errs'"
        unless exists $_[1]->{rx_errs};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rx_errs};
    die "Out of bounds 'hyper': $_[1]->{rx_errs}"
        unless (-9223372036854775808 <= $_[1]->{rx_errs}
                and $_[1]->{rx_errs} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rx_errs}"
        unless int($_[1]->{rx_errs}) == $_[1]->{rx_errs};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rx_errs});
    $_[2] += 8;

    # Serializing field: 'rx_drop'
    croak "Missing required input value 'rx_drop'"
        unless exists $_[1]->{rx_drop};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{rx_drop};
    die "Out of bounds 'hyper': $_[1]->{rx_drop}"
        unless (-9223372036854775808 <= $_[1]->{rx_drop}
                and $_[1]->{rx_drop} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{rx_drop}"
        unless int($_[1]->{rx_drop}) == $_[1]->{rx_drop};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{rx_drop});
    $_[2] += 8;

    # Serializing field: 'tx_bytes'
    croak "Missing required input value 'tx_bytes'"
        unless exists $_[1]->{tx_bytes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{tx_bytes};
    die "Out of bounds 'hyper': $_[1]->{tx_bytes}"
        unless (-9223372036854775808 <= $_[1]->{tx_bytes}
                and $_[1]->{tx_bytes} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{tx_bytes}"
        unless int($_[1]->{tx_bytes}) == $_[1]->{tx_bytes};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{tx_bytes});
    $_[2] += 8;

    # Serializing field: 'tx_packets'
    croak "Missing required input value 'tx_packets'"
        unless exists $_[1]->{tx_packets};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{tx_packets};
    die "Out of bounds 'hyper': $_[1]->{tx_packets}"
        unless (-9223372036854775808 <= $_[1]->{tx_packets}
                and $_[1]->{tx_packets} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{tx_packets}"
        unless int($_[1]->{tx_packets}) == $_[1]->{tx_packets};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{tx_packets});
    $_[2] += 8;

    # Serializing field: 'tx_errs'
    croak "Missing required input value 'tx_errs'"
        unless exists $_[1]->{tx_errs};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{tx_errs};
    die "Out of bounds 'hyper': $_[1]->{tx_errs}"
        unless (-9223372036854775808 <= $_[1]->{tx_errs}
                and $_[1]->{tx_errs} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{tx_errs}"
        unless int($_[1]->{tx_errs}) == $_[1]->{tx_errs};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{tx_errs});
    $_[2] += 8;

    # Serializing field: 'tx_drop'
    croak "Missing required input value 'tx_drop'"
        unless exists $_[1]->{tx_drop};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{tx_drop};
    die "Out of bounds 'hyper': $_[1]->{tx_drop}"
        unless (-9223372036854775808 <= $_[1]->{tx_drop}
                and $_[1]->{tx_drop} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{tx_drop}"
        unless int($_[1]->{tx_drop}) == $_[1]->{tx_drop};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{tx_drop});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_interface_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'device'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_interface_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'device'
    croak "Missing required input value 'device'"
        unless exists $_[1]->{device};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_interface_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'device'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_interface_parameters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'device'
    croak "Missing required input value 'device'"
        unless exists $_[1]->{device};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{device}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_interface_parameters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_interface_parameters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_memory_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'maxStats'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxStats} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{maxStats}"
        unless (0 <= $_[1]->{maxStats} and $_[1]->{maxStats} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_memory_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'maxStats'
    croak "Missing required input value 'maxStats'"
        unless exists $_[1]->{maxStats};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{maxStats};
    die "Out of bounds 'unsigned int': $_[1]->{maxStats}"
        unless (0 <= $_[1]->{maxStats} and $_[1]->{maxStats} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{maxStats}"
        unless int($_[1]->{maxStats}) == $_[1]->{maxStats};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{maxStats});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_memory_stat {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'tag'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{tag} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{tag}"
        unless (-2147483648 <= $_[1]->{tag} and $_[1]->{tag} < 2147483648);

    # Deserializing field: 'val'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{val} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{val}"
        unless (0 <= $_[1]->{val}
                and $_[1]->{val} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_memory_stat {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'tag'
    croak "Missing required input value 'tag'"
        unless exists $_[1]->{tag};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{tag};
    die "Out of bounds 'int': $_[1]->{tag}"
        unless (-2147483648 <= $_[1]->{tag} and $_[1]->{tag} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{tag}"
        unless int($_[1]->{tag}) == $_[1]->{tag};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{tag});
    $_[2] += 4;

    # Serializing field: 'val'
    croak "Missing required input value 'val'"
        unless exists $_[1]->{val};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{val};
    die "Out of bounds 'unsigned hyper': $_[1]->{val}"
        unless (0 <= $_[1]->{val}
                and $_[1]->{val} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{val}"
        unless int($_[1]->{val}) == $_[1]->{val};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{val});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_memory_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'stats'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 1024): $len"
            unless ($len <= 1024);
        $_[1]->{stats} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_domain_memory_stat( $_[1]->{stats}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_memory_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'stats'
    croak "Missing required input value 'stats'"
        unless exists $_[1]->{stats};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{stats};
    do {
        my $len = scalar @{ $_[1]->{stats} };
        die "Array too long (max: 1024): $len"
            unless ($len <= 1024);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_domain_memory_stat( $_[1]->{stats}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_peek_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'offset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{offset} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);

    # Deserializing field: 'size'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{size} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{size}"
        unless (0 <= $_[1]->{size} and $_[1]->{size} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_peek_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'offset'
    croak "Missing required input value 'offset'"
        unless exists $_[1]->{offset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{offset};
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{offset}"
        unless int($_[1]->{offset}) == $_[1]->{offset};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{offset});
    $_[2] += 8;

    # Serializing field: 'size'
    croak "Missing required input value 'size'"
        unless exists $_[1]->{size};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{size};
    die "Out of bounds 'unsigned int': $_[1]->{size}"
        unless (0 <= $_[1]->{size} and $_[1]->{size} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{size}"
        unless int($_[1]->{size}) == $_[1]->{size};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{size});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_peek_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'buffer'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{buffer} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_peek_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'buffer'
    croak "Missing required input value 'buffer'"
        unless exists $_[1]->{buffer};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{buffer};
    do {
        my $len = length $_[1]->{buffer};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{buffer};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_memory_peek_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'offset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{offset} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);

    # Deserializing field: 'size'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{size} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{size}"
        unless (0 <= $_[1]->{size} and $_[1]->{size} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_memory_peek_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'offset'
    croak "Missing required input value 'offset'"
        unless exists $_[1]->{offset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{offset};
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{offset}"
        unless int($_[1]->{offset}) == $_[1]->{offset};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{offset});
    $_[2] += 8;

    # Serializing field: 'size'
    croak "Missing required input value 'size'"
        unless exists $_[1]->{size};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{size};
    die "Out of bounds 'unsigned int': $_[1]->{size}"
        unless (0 <= $_[1]->{size} and $_[1]->{size} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{size}"
        unless int($_[1]->{size}) == $_[1]->{size};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{size});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_memory_peek_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'buffer'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{buffer} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_memory_peek_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'buffer'
    croak "Missing required input value 'buffer'"
        unless exists $_[1]->{buffer};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{buffer};
    do {
        my $len = length $_[1]->{buffer};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{buffer};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'allocation'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{allocation} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);

    # Deserializing field: 'capacity'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{capacity} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);

    # Deserializing field: 'physical'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{physical} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{physical}"
        unless (0 <= $_[1]->{physical}
                and $_[1]->{physical} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'allocation'
    croak "Missing required input value 'allocation'"
        unless exists $_[1]->{allocation};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{allocation};
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{allocation}"
        unless int($_[1]->{allocation}) == $_[1]->{allocation};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{allocation});
    $_[2] += 8;

    # Serializing field: 'capacity'
    croak "Missing required input value 'capacity'"
        unless exists $_[1]->{capacity};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{capacity};
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{capacity}"
        unless int($_[1]->{capacity}) == $_[1]->{capacity};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{capacity});
    $_[2] += 8;

    # Serializing field: 'physical'
    croak "Missing required input value 'physical'"
        unless exists $_[1]->{physical};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{physical};
    die "Out of bounds 'unsigned hyper': $_[1]->{physical}"
        unless (0 <= $_[1]->{physical}
                and $_[1]->{physical} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{physical}"
        unless int($_[1]->{physical}) == $_[1]->{physical};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{physical});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_domains_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxids'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxids} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxids}"
        unless (-2147483648 <= $_[1]->{maxids} and $_[1]->{maxids} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_domains_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxids'
    croak "Missing required input value 'maxids'"
        unless exists $_[1]->{maxids};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxids};
    die "Out of bounds 'int': $_[1]->{maxids}"
        unless (-2147483648 <= $_[1]->{maxids} and $_[1]->{maxids} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxids}"
        unless int($_[1]->{maxids}) == $_[1]->{maxids};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxids});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_domains_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'ids'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{ids} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{ids}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'int': $_[1]->{ids}->[$i1]"
                unless (-2147483648 <= $_[1]->{ids}->[$i1] and $_[1]->{ids}->[$i1] < 2147483648);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_domains_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'ids'
    croak "Missing required input value 'ids'"
        unless exists $_[1]->{ids};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{ids};
    do {
        my $len = scalar @{ $_[1]->{ids} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'int' value"
                unless defined $_[1]->{ids}->[$i1];
            die "Out of bounds 'int': $_[1]->{ids}->[$i1]"
                unless (-2147483648 <= $_[1]->{ids}->[$i1] and $_[1]->{ids}->[$i1] < 2147483648);
            die "Non-integer 'int' value given: $_[1]->{ids}->[$i1]"
                unless int($_[1]->{ids}->[$i1]) == $_[1]->{ids}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ids}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_domains_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_domains_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_xml_with_files_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_xml_with_files_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_xml_with_files_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_xml_with_files_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_id_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{id} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{id}"
        unless (-2147483648 <= $_[1]->{id} and $_[1]->{id} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_id_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'id'
    croak "Missing required input value 'id'"
        unless exists $_[1]->{id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{id};
    die "Out of bounds 'int': $_[1]->{id}"
        unless (-2147483648 <= $_[1]->{id} and $_[1]->{id} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{id}"
        unless int($_[1]->{id}) == $_[1]->{id};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{id});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_id_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_id_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_uuid_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_uuid_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_uuid_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_uuid_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_suspend_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_suspend_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_resume_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_resume_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pm_suspend_for_duration_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'target'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{target} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{target}"
        unless (0 <= $_[1]->{target} and $_[1]->{target} <= 4294967295);

    # Deserializing field: 'duration'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{duration} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{duration}"
        unless (0 <= $_[1]->{duration}
                and $_[1]->{duration} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pm_suspend_for_duration_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'target'
    croak "Missing required input value 'target'"
        unless exists $_[1]->{target};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{target};
    die "Out of bounds 'unsigned int': $_[1]->{target}"
        unless (0 <= $_[1]->{target} and $_[1]->{target} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{target}"
        unless int($_[1]->{target}) == $_[1]->{target};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{target});
    $_[2] += 4;

    # Serializing field: 'duration'
    croak "Missing required input value 'duration'"
        unless exists $_[1]->{duration};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{duration};
    die "Out of bounds 'unsigned hyper': $_[1]->{duration}"
        unless (0 <= $_[1]->{duration}
                and $_[1]->{duration} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{duration}"
        unless int($_[1]->{duration}) == $_[1]->{duration};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{duration});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pm_wakeup_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pm_wakeup_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_shutdown_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_shutdown_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_reboot_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_reboot_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_reset_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_reset_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_destroy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_destroy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_destroy_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_destroy_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_os_type_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_os_type_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_os_type_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_os_type_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_max_memory_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_max_memory_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_max_memory_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_max_memory_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_max_memory_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_max_memory_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_memory_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_memory_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_memory_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_memory_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_memory_stats_period_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'period'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{period} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{period}"
        unless (-2147483648 <= $_[1]->{period} and $_[1]->{period} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_memory_stats_period_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'period'
    croak "Missing required input value 'period'"
        unless exists $_[1]->{period};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{period};
    die "Out of bounds 'int': $_[1]->{period}"
        unless (-2147483648 <= $_[1]->{period} and $_[1]->{period} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{period}"
        unless int($_[1]->{period}) == $_[1]->{period};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{period});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'state'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{state} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned char': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 255);

    # Deserializing field: 'maxMem'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{maxMem} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{maxMem}"
        unless (0 <= $_[1]->{maxMem}
                and $_[1]->{maxMem} <= 18446744073709551615);

    # Deserializing field: 'memory'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memory} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);

    # Deserializing field: 'nrVirtCpu'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nrVirtCpu} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned short': $_[1]->{nrVirtCpu}"
        unless (0 <= $_[1]->{nrVirtCpu} and $_[1]->{nrVirtCpu} <= 65535);

    # Deserializing field: 'cpuTime'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{cpuTime} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{cpuTime}"
        unless (0 <= $_[1]->{cpuTime}
                and $_[1]->{cpuTime} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'state'
    croak "Missing required input value 'state'"
        unless exists $_[1]->{state};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'char' value"
        unless defined $_[1]->{state};
    die "Out of bounds 'unsigned char': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 255);
    die "Non-integer 'char' value given: $_[1]->{state}"
        unless int($_[1]->{state}) == $_[1]->{state};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{state});
    $_[2] += 4;

    # Serializing field: 'maxMem'
    croak "Missing required input value 'maxMem'"
        unless exists $_[1]->{maxMem};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{maxMem};
    die "Out of bounds 'unsigned hyper': $_[1]->{maxMem}"
        unless (0 <= $_[1]->{maxMem}
                and $_[1]->{maxMem} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{maxMem}"
        unless int($_[1]->{maxMem}) == $_[1]->{maxMem};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{maxMem});
    $_[2] += 8;

    # Serializing field: 'memory'
    croak "Missing required input value 'memory'"
        unless exists $_[1]->{memory};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memory};
    die "Out of bounds 'unsigned hyper': $_[1]->{memory}"
        unless (0 <= $_[1]->{memory}
                and $_[1]->{memory} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memory}"
        unless int($_[1]->{memory}) == $_[1]->{memory};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memory});
    $_[2] += 8;

    # Serializing field: 'nrVirtCpu'
    croak "Missing required input value 'nrVirtCpu'"
        unless exists $_[1]->{nrVirtCpu};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'short' value"
        unless defined $_[1]->{nrVirtCpu};
    die "Out of bounds 'unsigned short': $_[1]->{nrVirtCpu}"
        unless (0 <= $_[1]->{nrVirtCpu} and $_[1]->{nrVirtCpu} <= 65535);
    die "Non-integer 'short' value given: $_[1]->{nrVirtCpu}"
        unless int($_[1]->{nrVirtCpu}) == $_[1]->{nrVirtCpu};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{nrVirtCpu});
    $_[2] += 4;

    # Serializing field: 'cpuTime'
    croak "Missing required input value 'cpuTime'"
        unless exists $_[1]->{cpuTime};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{cpuTime};
    die "Out of bounds 'unsigned hyper': $_[1]->{cpuTime}"
        unless (0 <= $_[1]->{cpuTime}
                and $_[1]->{cpuTime} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{cpuTime}"
        unless int($_[1]->{cpuTime}) == $_[1]->{cpuTime};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cpuTime});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'to'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'to'
    croak "Missing required input value 'to'"
        unless exists $_[1]->{to};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'to'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Deserializing field: 'dxml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'to'
    croak "Missing required input value 'to'"
        unless exists $_[1]->{to};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Serializing field: 'dxml'
    croak "Missing required input value 'dxml'"
        unless exists $_[1]->{dxml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_params_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_params_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_restore_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'from'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{from}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_restore_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'from'
    croak "Missing required input value 'from'"
        unless exists $_[1]->{from};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{from}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_restore_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'from'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{from}, $_[2], $_[3] );

    # Deserializing field: 'dxml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_restore_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'from'
    croak "Missing required input value 'from'"
        unless exists $_[1]->{from};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{from}, $_[2], $_[3] );

    # Serializing field: 'dxml'
    croak "Missing required input value 'dxml'"
        unless exists $_[1]->{dxml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_restore_params_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_restore_params_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_image_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'file'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{file}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_image_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'file'
    croak "Missing required input value 'file'"
        unless exists $_[1]->{file};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{file}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_image_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_image_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_save_image_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'file'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{file}, $_[2], $_[3] );

    # Deserializing field: 'dxml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_save_image_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'file'
    croak "Missing required input value 'file'"
        unless exists $_[1]->{file};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{file}, $_[2], $_[3] );

    # Serializing field: 'dxml'
    croak "Missing required input value 'dxml'"
        unless exists $_[1]->{dxml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_core_dump_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'to'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_core_dump_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'to'
    croak "Missing required input value 'to'"
        unless exists $_[1]->{to};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_core_dump_with_format_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'to'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Deserializing field: 'dumpformat'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{dumpformat} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{dumpformat}"
        unless (0 <= $_[1]->{dumpformat} and $_[1]->{dumpformat} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_core_dump_with_format_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'to'
    croak "Missing required input value 'to'"
        unless exists $_[1]->{to};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{to}, $_[2], $_[3] );

    # Serializing field: 'dumpformat'
    croak "Missing required input value 'dumpformat'"
        unless exists $_[1]->{dumpformat};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{dumpformat};
    die "Out of bounds 'unsigned int': $_[1]->{dumpformat}"
        unless (0 <= $_[1]->{dumpformat} and $_[1]->{dumpformat} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{dumpformat}"
        unless int($_[1]->{dumpformat}) == $_[1]->{dumpformat};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{dumpformat});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_screenshot_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'screen'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{screen} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{screen}"
        unless (0 <= $_[1]->{screen} and $_[1]->{screen} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_screenshot_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'screen'
    croak "Missing required input value 'screen'"
        unless exists $_[1]->{screen};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{screen};
    die "Out of bounds 'unsigned int': $_[1]->{screen}"
        unless (0 <= $_[1]->{screen} and $_[1]->{screen} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{screen}"
        unless int($_[1]->{screen}) == $_[1]->{screen};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{screen});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_screenshot_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'mime'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{mime}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_screenshot_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'mime'
    croak "Missing required input value 'mime'"
        unless exists $_[1]->{mime};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{mime}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uri_in'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uri_in'
    croak "Missing required input value 'uri_in'"
        unless exists $_[1]->{uri_in};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri_out'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie'
    croak "Missing required input value 'cookie'"
        unless exists $_[1]->{cookie};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie};
    do {
        my $len = length $_[1]->{cookie};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri_out'
    croak "Missing required input value 'uri_out'"
        unless exists $_[1]->{uri_out};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_perform_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'cookie'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_perform_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'cookie'
    croak "Missing required input value 'cookie'"
        unless exists $_[1]->{cookie};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie};
    do {
        my $len = length $_[1]->{cookie};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'cookie'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'cookie'
    croak "Missing required input value 'cookie'"
        unless exists $_[1]->{cookie};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie};
    do {
        my $len = length $_[1]->{cookie};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'ddom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{ddom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'ddom'
    croak "Missing required input value 'ddom'"
        unless exists $_[1]->{ddom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{ddom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare2_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uri_in'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'dom_xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare2_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uri_in'
    croak "Missing required input value 'uri_in'"
        unless exists $_[1]->{uri_in};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'dom_xml'
    croak "Missing required input value 'dom_xml'"
        unless exists $_[1]->{dom_xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare2_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri_out'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare2_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie'
    croak "Missing required input value 'cookie'"
        unless exists $_[1]->{cookie};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie};
    do {
        my $len = length $_[1]->{cookie};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri_out'
    croak "Missing required input value 'uri_out'"
        unless exists $_[1]->{uri_out};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish2_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'cookie'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'retcode'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{retcode} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{retcode}"
        unless (-2147483648 <= $_[1]->{retcode} and $_[1]->{retcode} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish2_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'cookie'
    croak "Missing required input value 'cookie'"
        unless exists $_[1]->{cookie};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie};
    do {
        my $len = length $_[1]->{cookie};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'retcode'
    croak "Missing required input value 'retcode'"
        unless exists $_[1]->{retcode};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{retcode};
    die "Out of bounds 'int': $_[1]->{retcode}"
        unless (-2147483648 <= $_[1]->{retcode} and $_[1]->{retcode} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{retcode}"
        unless int($_[1]->{retcode}) == $_[1]->{retcode};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{retcode});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish2_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'ddom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{ddom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish2_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'ddom'
    croak "Missing required input value 'ddom'"
        unless exists $_[1]->{ddom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{ddom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_domains_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_domains_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_domains_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_domains_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_defined_domains_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_defined_domains_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_with_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_with_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_with_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_with_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_with_files_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_with_files_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_create_with_files_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_create_with_files_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_define_xml_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_define_xml_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_define_xml_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_define_xml_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_undefine_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_undefine_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_inject_nmi_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_inject_nmi_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_send_key_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'codeset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{codeset} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{codeset}"
        unless (0 <= $_[1]->{codeset} and $_[1]->{codeset} <= 4294967295);

    # Deserializing field: 'holdtime'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{holdtime} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{holdtime}"
        unless (0 <= $_[1]->{holdtime} and $_[1]->{holdtime} <= 4294967295);

    # Deserializing field: 'keycodes'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{keycodes} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{keycodes}->[$i1] = unpack("L>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'unsigned int': $_[1]->{keycodes}->[$i1]"
                unless (0 <= $_[1]->{keycodes}->[$i1] and $_[1]->{keycodes}->[$i1] <= 4294967295);
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_send_key_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'codeset'
    croak "Missing required input value 'codeset'"
        unless exists $_[1]->{codeset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{codeset};
    die "Out of bounds 'unsigned int': $_[1]->{codeset}"
        unless (0 <= $_[1]->{codeset} and $_[1]->{codeset} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{codeset}"
        unless int($_[1]->{codeset}) == $_[1]->{codeset};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{codeset});
    $_[2] += 4;

    # Serializing field: 'holdtime'
    croak "Missing required input value 'holdtime'"
        unless exists $_[1]->{holdtime};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{holdtime};
    die "Out of bounds 'unsigned int': $_[1]->{holdtime}"
        unless (0 <= $_[1]->{holdtime} and $_[1]->{holdtime} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{holdtime}"
        unless int($_[1]->{holdtime}) == $_[1]->{holdtime};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{holdtime});
    $_[2] += 4;

    # Serializing field: 'keycodes'
    croak "Missing required input value 'keycodes'"
        unless exists $_[1]->{keycodes};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{keycodes};
    do {
        my $len = scalar @{ $_[1]->{keycodes} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'unsigned int' value"
                unless defined $_[1]->{keycodes}->[$i1];
            die "Out of bounds 'unsigned int': $_[1]->{keycodes}->[$i1]"
                unless (0 <= $_[1]->{keycodes}->[$i1] and $_[1]->{keycodes}->[$i1] <= 4294967295);
            die "Non-integer 'int' value given: $_[1]->{keycodes}->[$i1]"
                unless int($_[1]->{keycodes}->[$i1]) == $_[1]->{keycodes}->[$i1];
            substr( $_[3], $_[2] ) = pack("L>", $_[1]->{keycodes}->[$i1]);
            $_[2] += 4;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_send_process_signal_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'pid_value'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{pid_value} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{pid_value}"
        unless (-9223372036854775808 <= $_[1]->{pid_value}
                and $_[1]->{pid_value} < 9223372036854775808);

    # Deserializing field: 'signum'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{signum} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{signum}"
        unless (0 <= $_[1]->{signum} and $_[1]->{signum} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_send_process_signal_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'pid_value'
    croak "Missing required input value 'pid_value'"
        unless exists $_[1]->{pid_value};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{pid_value};
    die "Out of bounds 'hyper': $_[1]->{pid_value}"
        unless (-9223372036854775808 <= $_[1]->{pid_value}
                and $_[1]->{pid_value} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{pid_value}"
        unless int($_[1]->{pid_value}) == $_[1]->{pid_value};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{pid_value});
    $_[2] += 8;

    # Serializing field: 'signum'
    croak "Missing required input value 'signum'"
        unless exists $_[1]->{signum};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{signum};
    die "Out of bounds 'unsigned int': $_[1]->{signum}"
        unless (0 <= $_[1]->{signum} and $_[1]->{signum} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{signum}"
        unless int($_[1]->{signum}) == $_[1]->{signum};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{signum});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_vcpus_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nvcpus'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nvcpus} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{nvcpus}"
        unless (0 <= $_[1]->{nvcpus} and $_[1]->{nvcpus} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_vcpus_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nvcpus'
    croak "Missing required input value 'nvcpus'"
        unless exists $_[1]->{nvcpus};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{nvcpus};
    die "Out of bounds 'unsigned int': $_[1]->{nvcpus}"
        unless (0 <= $_[1]->{nvcpus} and $_[1]->{nvcpus} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{nvcpus}"
        unless int($_[1]->{nvcpus}) == $_[1]->{nvcpus};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{nvcpus});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_vcpus_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nvcpus'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nvcpus} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{nvcpus}"
        unless (0 <= $_[1]->{nvcpus} and $_[1]->{nvcpus} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_vcpus_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nvcpus'
    croak "Missing required input value 'nvcpus'"
        unless exists $_[1]->{nvcpus};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{nvcpus};
    die "Out of bounds 'unsigned int': $_[1]->{nvcpus}"
        unless (0 <= $_[1]->{nvcpus} and $_[1]->{nvcpus} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{nvcpus}"
        unless int($_[1]->{nvcpus}) == $_[1]->{nvcpus};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{nvcpus});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpus_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpus_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpus_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpus_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pin_vcpu_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'vcpu'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{vcpu} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{vcpu}"
        unless (0 <= $_[1]->{vcpu} and $_[1]->{vcpu} <= 4294967295);

    # Deserializing field: 'cpumap'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumap} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pin_vcpu_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'vcpu'
    croak "Missing required input value 'vcpu'"
        unless exists $_[1]->{vcpu};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{vcpu};
    die "Out of bounds 'unsigned int': $_[1]->{vcpu}"
        unless (0 <= $_[1]->{vcpu} and $_[1]->{vcpu} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{vcpu}"
        unless int($_[1]->{vcpu}) == $_[1]->{vcpu};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{vcpu});
    $_[2] += 4;

    # Serializing field: 'cpumap'
    croak "Missing required input value 'cpumap'"
        unless exists $_[1]->{cpumap};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumap};
    do {
        my $len = length $_[1]->{cpumap};
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumap};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pin_vcpu_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'vcpu'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{vcpu} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{vcpu}"
        unless (0 <= $_[1]->{vcpu} and $_[1]->{vcpu} <= 4294967295);

    # Deserializing field: 'cpumap'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumap} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pin_vcpu_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'vcpu'
    croak "Missing required input value 'vcpu'"
        unless exists $_[1]->{vcpu};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{vcpu};
    die "Out of bounds 'unsigned int': $_[1]->{vcpu}"
        unless (0 <= $_[1]->{vcpu} and $_[1]->{vcpu} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{vcpu}"
        unless int($_[1]->{vcpu}) == $_[1]->{vcpu};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{vcpu});
    $_[2] += 4;

    # Serializing field: 'cpumap'
    croak "Missing required input value 'cpumap'"
        unless exists $_[1]->{cpumap};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumap};
    do {
        my $len = length $_[1]->{cpumap};
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumap};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpu_pin_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'ncpumaps'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ncpumaps} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{ncpumaps}"
        unless (-2147483648 <= $_[1]->{ncpumaps} and $_[1]->{ncpumaps} < 2147483648);

    # Deserializing field: 'maplen'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maplen} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpu_pin_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'ncpumaps'
    croak "Missing required input value 'ncpumaps'"
        unless exists $_[1]->{ncpumaps};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{ncpumaps};
    die "Out of bounds 'int': $_[1]->{ncpumaps}"
        unless (-2147483648 <= $_[1]->{ncpumaps} and $_[1]->{ncpumaps} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{ncpumaps}"
        unless int($_[1]->{ncpumaps}) == $_[1]->{ncpumaps};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ncpumaps});
    $_[2] += 4;

    # Serializing field: 'maplen'
    croak "Missing required input value 'maplen'"
        unless exists $_[1]->{maplen};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maplen};
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maplen}"
        unless int($_[1]->{maplen}) == $_[1]->{maplen};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maplen});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpu_pin_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cpumaps'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumaps} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpu_pin_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cpumaps'
    croak "Missing required input value 'cpumaps'"
        unless exists $_[1]->{cpumaps};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumaps};
    do {
        my $len = length $_[1]->{cpumaps};
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumaps};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pin_emulator_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'cpumap'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumap} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pin_emulator_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'cpumap'
    croak "Missing required input value 'cpumap'"
        unless exists $_[1]->{cpumap};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumap};
    do {
        my $len = length $_[1]->{cpumap};
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumap};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_emulator_pin_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'maplen'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maplen} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_emulator_pin_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'maplen'
    croak "Missing required input value 'maplen'"
        unless exists $_[1]->{maplen};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maplen};
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maplen}"
        unless int($_[1]->{maplen}) == $_[1]->{maplen};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maplen});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_emulator_pin_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cpumaps'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumaps} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_emulator_pin_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cpumaps'
    croak "Missing required input value 'cpumaps'"
        unless exists $_[1]->{cpumaps};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumaps};
    do {
        my $len = length $_[1]->{cpumaps};
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumaps};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpus_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'maxinfo'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxinfo} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxinfo}"
        unless (-2147483648 <= $_[1]->{maxinfo} and $_[1]->{maxinfo} < 2147483648);

    # Deserializing field: 'maplen'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maplen} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpus_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'maxinfo'
    croak "Missing required input value 'maxinfo'"
        unless exists $_[1]->{maxinfo};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxinfo};
    die "Out of bounds 'int': $_[1]->{maxinfo}"
        unless (-2147483648 <= $_[1]->{maxinfo} and $_[1]->{maxinfo} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxinfo}"
        unless int($_[1]->{maxinfo}) == $_[1]->{maxinfo};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxinfo});
    $_[2] += 4;

    # Serializing field: 'maplen'
    croak "Missing required input value 'maplen'"
        unless exists $_[1]->{maplen};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maplen};
    die "Out of bounds 'int': $_[1]->{maplen}"
        unless (-2147483648 <= $_[1]->{maplen} and $_[1]->{maplen} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maplen}"
        unless int($_[1]->{maplen}) == $_[1]->{maplen};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maplen});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_vcpus_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'info'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{info} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_vcpu_info( $_[1]->{info}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'cpumaps'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumaps} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_vcpus_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'info'
    croak "Missing required input value 'info'"
        unless exists $_[1]->{info};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{info};
    do {
        my $len = scalar @{ $_[1]->{info} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_vcpu_info( $_[1]->{info}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'cpumaps'
    croak "Missing required input value 'cpumaps'"
        unless exists $_[1]->{cpumaps};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumaps};
    do {
        my $len = length $_[1]->{cpumaps};
        die "Opaque data too long (max: 8388608): $len"
            unless ($len <= 8388608);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumaps};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_max_vcpus_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_max_vcpus_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_max_vcpus_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_max_vcpus_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_iothread_info {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iothread_id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{iothread_id} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);

    # Deserializing field: 'cpumap'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumap} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_iothread_info {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iothread_id'
    croak "Missing required input value 'iothread_id'"
        unless exists $_[1]->{iothread_id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{iothread_id};
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{iothread_id}"
        unless int($_[1]->{iothread_id}) == $_[1]->{iothread_id};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{iothread_id});
    $_[2] += 4;

    # Serializing field: 'cpumap'
    croak "Missing required input value 'cpumap'"
        unless exists $_[1]->{cpumap};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumap};
    do {
        my $len = length $_[1]->{cpumap};
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumap};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_iothread_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_iothread_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_iothread_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'info'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{info} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_domain_iothread_info( $_[1]->{info}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_iothread_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'info'
    croak "Missing required input value 'info'"
        unless exists $_[1]->{info};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{info};
    do {
        my $len = scalar @{ $_[1]->{info} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_domain_iothread_info( $_[1]->{info}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_pin_iothread_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'iothreads_id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{iothreads_id} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{iothreads_id}"
        unless (0 <= $_[1]->{iothreads_id} and $_[1]->{iothreads_id} <= 4294967295);

    # Deserializing field: 'cpumap'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cpumap} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_pin_iothread_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'iothreads_id'
    croak "Missing required input value 'iothreads_id'"
        unless exists $_[1]->{iothreads_id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{iothreads_id};
    die "Out of bounds 'unsigned int': $_[1]->{iothreads_id}"
        unless (0 <= $_[1]->{iothreads_id} and $_[1]->{iothreads_id} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{iothreads_id}"
        unless int($_[1]->{iothreads_id}) == $_[1]->{iothreads_id};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{iothreads_id});
    $_[2] += 4;

    # Serializing field: 'cpumap'
    croak "Missing required input value 'cpumap'"
        unless exists $_[1]->{cpumap};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cpumap};
    do {
        my $len = length $_[1]->{cpumap};
        die "Opaque data too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cpumap};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_add_iothread_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'iothread_id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{iothread_id} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_add_iothread_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'iothread_id'
    croak "Missing required input value 'iothread_id'"
        unless exists $_[1]->{iothread_id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{iothread_id};
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{iothread_id}"
        unless int($_[1]->{iothread_id}) == $_[1]->{iothread_id};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{iothread_id});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_del_iothread_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'iothread_id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{iothread_id} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_del_iothread_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'iothread_id'
    croak "Missing required input value 'iothread_id'"
        unless exists $_[1]->{iothread_id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{iothread_id};
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{iothread_id}"
        unless int($_[1]->{iothread_id}) == $_[1]->{iothread_id};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{iothread_id});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_iothread_params_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'iothread_id'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{iothread_id} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_iothread_params_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'iothread_id'
    croak "Missing required input value 'iothread_id'"
        unless exists $_[1]->{iothread_id};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{iothread_id};
    die "Out of bounds 'unsigned int': $_[1]->{iothread_id}"
        unless (0 <= $_[1]->{iothread_id} and $_[1]->{iothread_id} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{iothread_id}"
        unless int($_[1]->{iothread_id}) == $_[1]->{iothread_id};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{iothread_id});
    $_[2] += 4;

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_security_label_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_security_label_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_security_label_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'label'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 4097): $len"
            unless ($len <= 4097);
        $_[1]->{label} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{label}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{label}->[$i1]"
                unless (-128 <= $_[1]->{label}->[$i1] and $_[1]->{label}->[$i1] < 128);
        }
    };

    # Deserializing field: 'enforcing'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{enforcing} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{enforcing}"
        unless (-2147483648 <= $_[1]->{enforcing} and $_[1]->{enforcing} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_security_label_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'label'
    croak "Missing required input value 'label'"
        unless exists $_[1]->{label};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{label};
    do {
        my $len = scalar @{ $_[1]->{label} };
        die "Array too long (max: 4097): $len"
            unless ($len <= 4097);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{label}->[$i1];
            die "Out of bounds 'char': $_[1]->{label}->[$i1]"
                unless (-128 <= $_[1]->{label}->[$i1] and $_[1]->{label}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{label}->[$i1]"
                unless int($_[1]->{label}->[$i1]) == $_[1]->{label}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{label}->[$i1]);
            $_[2] += 4;
        }
    };

    # Serializing field: 'enforcing'
    croak "Missing required input value 'enforcing'"
        unless exists $_[1]->{enforcing};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{enforcing};
    die "Out of bounds 'int': $_[1]->{enforcing}"
        unless (-2147483648 <= $_[1]->{enforcing} and $_[1]->{enforcing} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{enforcing}"
        unless int($_[1]->{enforcing}) == $_[1]->{enforcing};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{enforcing});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_security_label_list_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_security_label_list_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_security_label_list_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'labels'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{labels} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_domain_get_security_label_ret( $_[1]->{labels}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_security_label_list_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'labels'
    croak "Missing required input value 'labels'"
        unless exists $_[1]->{labels};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{labels};
    do {
        my $len = scalar @{ $_[1]->{labels} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_domain_get_security_label_ret( $_[1]->{labels}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_get_security_model_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'model'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 257): $len"
            unless ($len <= 257);
        $_[1]->{model} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{model}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{model}->[$i1]"
                unless (-128 <= $_[1]->{model}->[$i1] and $_[1]->{model}->[$i1] < 128);
        }
    };

    # Deserializing field: 'doi'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 257): $len"
            unless ($len <= 257);
        $_[1]->{doi} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{doi}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{doi}->[$i1]"
                unless (-128 <= $_[1]->{doi}->[$i1] and $_[1]->{doi}->[$i1] < 128);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_get_security_model_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'model'
    croak "Missing required input value 'model'"
        unless exists $_[1]->{model};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{model};
    do {
        my $len = scalar @{ $_[1]->{model} };
        die "Array too long (max: 257): $len"
            unless ($len <= 257);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{model}->[$i1];
            die "Out of bounds 'char': $_[1]->{model}->[$i1]"
                unless (-128 <= $_[1]->{model}->[$i1] and $_[1]->{model}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{model}->[$i1]"
                unless int($_[1]->{model}->[$i1]) == $_[1]->{model}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{model}->[$i1]);
            $_[2] += 4;
        }
    };

    # Serializing field: 'doi'
    croak "Missing required input value 'doi'"
        unless exists $_[1]->{doi};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{doi};
    do {
        my $len = scalar @{ $_[1]->{doi} };
        die "Array too long (max: 257): $len"
            unless ($len <= 257);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{doi}->[$i1];
            die "Out of bounds 'char': $_[1]->{doi}->[$i1]"
                unless (-128 <= $_[1]->{doi}->[$i1] and $_[1]->{doi}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{doi}->[$i1]"
                unless int($_[1]->{doi}->[$i1]) == $_[1]->{doi}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{doi}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_attach_device_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_attach_device_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_attach_device_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_attach_device_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_detach_device_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_detach_device_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_detach_device_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_detach_device_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_update_device_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_update_device_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_detach_device_alias_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'alias'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{alias}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_detach_device_alias_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'alias'
    croak "Missing required input value 'alias'"
        unless exists $_[1]->{alias};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{alias}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_autostart_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_autostart_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_metadata_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'metadata'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{metadata}, $_[2], $_[3] );

    # Deserializing field: 'key'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{key}, $_[2], $_[3] );

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_metadata_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'metadata'
    croak "Missing required input value 'metadata'"
        unless exists $_[1]->{metadata};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{metadata}, $_[2], $_[3] );

    # Serializing field: 'key'
    croak "Missing required input value 'key'"
        unless exists $_[1]->{key};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{key}, $_[2], $_[3] );

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_metadata_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_metadata_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_metadata_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'metadata'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{metadata}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_metadata_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'metadata'
    croak "Missing required input value 'metadata'"
        unless exists $_[1]->{metadata};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{metadata}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_job_abort_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_job_abort_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_job_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_job_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_job_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'found'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{found} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{found}"
        unless (-2147483648 <= $_[1]->{found} and $_[1]->{found} < 2147483648);

    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'cur'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{cur} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{cur}"
        unless (0 <= $_[1]->{cur}
                and $_[1]->{cur} <= 18446744073709551615);

    # Deserializing field: 'end'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{end} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{end}"
        unless (0 <= $_[1]->{end}
                and $_[1]->{end} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_job_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'found'
    croak "Missing required input value 'found'"
        unless exists $_[1]->{found};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{found};
    die "Out of bounds 'int': $_[1]->{found}"
        unless (-2147483648 <= $_[1]->{found} and $_[1]->{found} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{found}"
        unless int($_[1]->{found}) == $_[1]->{found};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{found});
    $_[2] += 4;

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'cur'
    croak "Missing required input value 'cur'"
        unless exists $_[1]->{cur};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{cur};
    die "Out of bounds 'unsigned hyper': $_[1]->{cur}"
        unless (0 <= $_[1]->{cur}
                and $_[1]->{cur} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{cur}"
        unless int($_[1]->{cur}) == $_[1]->{cur};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cur});
    $_[2] += 8;

    # Serializing field: 'end'
    croak "Missing required input value 'end'"
        unless exists $_[1]->{end};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{end};
    die "Out of bounds 'unsigned hyper': $_[1]->{end}"
        unless (0 <= $_[1]->{end}
                and $_[1]->{end} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{end}"
        unless int($_[1]->{end}) == $_[1]->{end};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{end});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_job_set_speed_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_job_set_speed_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_pull_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_pull_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_rebase_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'base'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{base}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_rebase_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'base'
    croak "Missing required input value 'base'"
        unless exists $_[1]->{base};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{base}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_copy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'destxml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{destxml}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16): $len"
            unless ($len <= 16);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_copy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'destxml'
    croak "Missing required input value 'destxml'"
        unless exists $_[1]->{destxml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{destxml}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 16): $len"
            unless ($len <= 16);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_block_commit_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'disk'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Deserializing field: 'base'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{base}, $_[2], $_[3] );

    # Deserializing field: 'top'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{top}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_block_commit_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'disk'
    croak "Missing required input value 'disk'"
        unless exists $_[1]->{disk};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Serializing field: 'base'
    croak "Missing required input value 'base'"
        unless exists $_[1]->{base};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{base}, $_[2], $_[3] );

    # Serializing field: 'top'
    croak "Missing required input value 'top'"
        unless exists $_[1]->{top};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{top}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_block_io_tune_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'disk'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 32): $len"
            unless ($len <= 32);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_block_io_tune_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'disk'
    croak "Missing required input value 'disk'"
        unless exists $_[1]->{disk};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{disk}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 32): $len"
            unless ($len <= 32);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_io_tune_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'disk'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{disk}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_io_tune_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'disk'
    croak "Missing required input value 'disk'"
        unless exists $_[1]->{disk};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{disk}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_block_io_tune_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 32): $len"
            unless ($len <= 32);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_block_io_tune_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 32): $len"
            unless ($len <= 32);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_set_throttle_group_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'group'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{group}, $_[2], $_[3] );

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 32): $len"
            unless ($len <= 32);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_set_throttle_group_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'group'
    croak "Missing required input value 'group'"
        unless exists $_[1]->{group};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{group}, $_[2], $_[3] );

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 32): $len"
            unless ($len <= 32);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_del_throttle_group_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'group'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{group}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_del_throttle_group_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'group'
    croak "Missing required input value 'group'"
        unless exists $_[1]->{group};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{group}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_cpu_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{nparams}"
        unless (0 <= $_[1]->{nparams} and $_[1]->{nparams} <= 4294967295);

    # Deserializing field: 'start_cpu'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{start_cpu} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{start_cpu}"
        unless (-2147483648 <= $_[1]->{start_cpu} and $_[1]->{start_cpu} < 2147483648);

    # Deserializing field: 'ncpus'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ncpus} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ncpus}"
        unless (0 <= $_[1]->{ncpus} and $_[1]->{ncpus} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_cpu_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'unsigned int': $_[1]->{nparams}"
        unless (0 <= $_[1]->{nparams} and $_[1]->{nparams} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{nparams});
    $_[2] += 4;

    # Serializing field: 'start_cpu'
    croak "Missing required input value 'start_cpu'"
        unless exists $_[1]->{start_cpu};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{start_cpu};
    die "Out of bounds 'int': $_[1]->{start_cpu}"
        unless (-2147483648 <= $_[1]->{start_cpu} and $_[1]->{start_cpu} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{start_cpu}"
        unless int($_[1]->{start_cpu}) == $_[1]->{start_cpu};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{start_cpu});
    $_[2] += 4;

    # Serializing field: 'ncpus'
    croak "Missing required input value 'ncpus'"
        unless exists $_[1]->{ncpus};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ncpus};
    die "Out of bounds 'unsigned int': $_[1]->{ncpus}"
        unless (0 <= $_[1]->{ncpus} and $_[1]->{ncpus} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ncpus}"
        unless int($_[1]->{ncpus}) == $_[1]->{ncpus};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ncpus});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_cpu_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 2048): $len"
            unless ($len <= 2048);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nparams'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nparams} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_cpu_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 2048): $len"
            unless ($len <= 2048);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nparams'
    croak "Missing required input value 'nparams'"
        unless exists $_[1]->{nparams};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nparams};
    die "Out of bounds 'int': $_[1]->{nparams}"
        unless (-2147483648 <= $_[1]->{nparams} and $_[1]->{nparams} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nparams}"
        unless int($_[1]->{nparams}) == $_[1]->{nparams};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nparams});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_hostname_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_hostname_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_hostname_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'hostname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{hostname}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_hostname_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'hostname'
    croak "Missing required input value 'hostname'"
        unless exists $_[1]->{hostname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{hostname}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_networks_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_networks_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_networks_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_networks_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_networks_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_networks_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_defined_networks_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_defined_networks_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_networks_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_networks_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_networks_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_networks_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_lookup_by_uuid_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_lookup_by_uuid_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_lookup_by_uuid_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_lookup_by_uuid_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_create_xml_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_create_xml_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_create_xml_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_create_xml_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_define_xml_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_define_xml_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_define_xml_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_define_xml_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_update_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Deserializing field: 'command'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{command} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{command}"
        unless (0 <= $_[1]->{command} and $_[1]->{command} <= 4294967295);

    # Deserializing field: 'section'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{section} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{section}"
        unless (0 <= $_[1]->{section} and $_[1]->{section} <= 4294967295);

    # Deserializing field: 'parentIndex'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{parentIndex} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{parentIndex}"
        unless (-2147483648 <= $_[1]->{parentIndex} and $_[1]->{parentIndex} < 2147483648);

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_update_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Serializing field: 'command'
    croak "Missing required input value 'command'"
        unless exists $_[1]->{command};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{command};
    die "Out of bounds 'unsigned int': $_[1]->{command}"
        unless (0 <= $_[1]->{command} and $_[1]->{command} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{command}"
        unless int($_[1]->{command}) == $_[1]->{command};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{command});
    $_[2] += 4;

    # Serializing field: 'section'
    croak "Missing required input value 'section'"
        unless exists $_[1]->{section};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{section};
    die "Out of bounds 'unsigned int': $_[1]->{section}"
        unless (0 <= $_[1]->{section} and $_[1]->{section} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{section}"
        unless int($_[1]->{section}) == $_[1]->{section};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{section});
    $_[2] += 4;

    # Serializing field: 'parentIndex'
    croak "Missing required input value 'parentIndex'"
        unless exists $_[1]->{parentIndex};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{parentIndex};
    die "Out of bounds 'int': $_[1]->{parentIndex}"
        unless (-2147483648 <= $_[1]->{parentIndex} and $_[1]->{parentIndex} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{parentIndex}"
        unless int($_[1]->{parentIndex}) == $_[1]->{parentIndex};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{parentIndex});
    $_[2] += 4;

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_create_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_create_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_destroy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_destroy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_bridge_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_bridge_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_bridge_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_bridge_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_get_autostart_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_get_autostart_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_set_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_set_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_nwfilters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_nwfilters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_nwfilters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_nwfilters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_nwfilters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_nwfilters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_lookup_by_uuid_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_lookup_by_uuid_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_lookup_by_uuid_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_lookup_by_uuid_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_define_xml_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_define_xml_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_define_xml_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_define_xml_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nwfilter'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nwfilter'
    croak "Missing required input value 'nwfilter'"
        unless exists $_[1]->{nwfilter};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_nwfilter( $_[1]->{nwfilter}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_nwfilter_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_nwfilter_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_interfaces_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_interfaces_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_interfaces_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_interfaces_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_interfaces_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_interfaces_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_defined_interfaces_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_defined_interfaces_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_interfaces_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_interfaces_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_interfaces_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_interfaces_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_lookup_by_mac_string_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'mac'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{mac}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_lookup_by_mac_string_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'mac'
    croak "Missing required input value 'mac'"
        unless exists $_[1]->{mac};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{mac}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_lookup_by_mac_string_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_lookup_by_mac_string_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_create_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_create_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_destroy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_destroy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_change_begin_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_change_begin_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_change_commit_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_change_commit_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_change_rollback_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_change_rollback_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_list_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'types'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 20): $len"
            unless ($len <= 20);
        $_[1]->{types} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_auth_type( $_[1]->{types}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_list_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'types'
    croak "Missing required input value 'types'"
        unless exists $_[1]->{types};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{types};
    do {
        my $len = scalar @{ $_[1]->{types} };
        die "Array too long (max: 20): $len"
            unless ($len <= 20);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_auth_type( $_[1]->{types}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_sasl_init_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'mechlist'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{mechlist}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_sasl_init_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'mechlist'
    croak "Missing required input value 'mechlist'"
        unless exists $_[1]->{mechlist};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{mechlist}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_sasl_start_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'mech'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{mech}, $_[2], $_[3] );

    # Deserializing field: 'nil'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nil} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);

    # Deserializing field: 'data'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{data} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{data}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_sasl_start_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'mech'
    croak "Missing required input value 'mech'"
        unless exists $_[1]->{mech};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{mech}, $_[2], $_[3] );

    # Serializing field: 'nil'
    croak "Missing required input value 'nil'"
        unless exists $_[1]->{nil};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nil};
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nil}"
        unless int($_[1]->{nil}) == $_[1]->{nil};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nil});
    $_[2] += 4;

    # Serializing field: 'data'
    croak "Missing required input value 'data'"
        unless exists $_[1]->{data};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{data};
    do {
        my $len = scalar @{ $_[1]->{data} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{data}->[$i1];
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{data}->[$i1]"
                unless int($_[1]->{data}->[$i1]) == $_[1]->{data}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{data}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_sasl_start_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'complete'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{complete} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);

    # Deserializing field: 'nil'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nil} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);

    # Deserializing field: 'data'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{data} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{data}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_sasl_start_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'complete'
    croak "Missing required input value 'complete'"
        unless exists $_[1]->{complete};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{complete};
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{complete}"
        unless int($_[1]->{complete}) == $_[1]->{complete};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{complete});
    $_[2] += 4;

    # Serializing field: 'nil'
    croak "Missing required input value 'nil'"
        unless exists $_[1]->{nil};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nil};
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nil}"
        unless int($_[1]->{nil}) == $_[1]->{nil};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nil});
    $_[2] += 4;

    # Serializing field: 'data'
    croak "Missing required input value 'data'"
        unless exists $_[1]->{data};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{data};
    do {
        my $len = scalar @{ $_[1]->{data} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{data}->[$i1];
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{data}->[$i1]"
                unless int($_[1]->{data}->[$i1]) == $_[1]->{data}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{data}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_sasl_step_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nil'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nil} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);

    # Deserializing field: 'data'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{data} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{data}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_sasl_step_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nil'
    croak "Missing required input value 'nil'"
        unless exists $_[1]->{nil};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nil};
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nil}"
        unless int($_[1]->{nil}) == $_[1]->{nil};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nil});
    $_[2] += 4;

    # Serializing field: 'data'
    croak "Missing required input value 'data'"
        unless exists $_[1]->{data};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{data};
    do {
        my $len = scalar @{ $_[1]->{data} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{data}->[$i1];
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{data}->[$i1]"
                unless int($_[1]->{data}->[$i1]) == $_[1]->{data}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{data}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_sasl_step_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'complete'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{complete} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);

    # Deserializing field: 'nil'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nil} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);

    # Deserializing field: 'data'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{data} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            die "Input buffer too short"
                if ($input_length - $_[2]) < 4;
            $_[1]->{data}->[$i1] = unpack("l>", substr( $_[3], $_[2] ));
            $_[2] += 4;
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_sasl_step_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'complete'
    croak "Missing required input value 'complete'"
        unless exists $_[1]->{complete};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{complete};
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{complete}"
        unless int($_[1]->{complete}) == $_[1]->{complete};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{complete});
    $_[2] += 4;

    # Serializing field: 'nil'
    croak "Missing required input value 'nil'"
        unless exists $_[1]->{nil};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nil};
    die "Out of bounds 'int': $_[1]->{nil}"
        unless (-2147483648 <= $_[1]->{nil} and $_[1]->{nil} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nil}"
        unless int($_[1]->{nil}) == $_[1]->{nil};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nil});
    $_[2] += 4;

    # Serializing field: 'data'
    croak "Missing required input value 'data'"
        unless exists $_[1]->{data};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{data};
    do {
        my $len = scalar @{ $_[1]->{data} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            croak "Missing required input 'char' value"
                unless defined $_[1]->{data}->[$i1];
            die "Out of bounds 'char': $_[1]->{data}->[$i1]"
                unless (-128 <= $_[1]->{data}->[$i1] and $_[1]->{data}->[$i1] < 128);
            die "Non-integer 'char' value given: $_[1]->{data}->[$i1]"
                unless int($_[1]->{data}->[$i1]) == $_[1]->{data}->[$i1];
            substr( $_[3], $_[2] ) = pack("l>", $_[1]->{data}->[$i1]);
            $_[2] += 4;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_auth_polkit_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'complete'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{complete} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_auth_polkit_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'complete'
    croak "Missing required input value 'complete'"
        unless exists $_[1]->{complete};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{complete};
    die "Out of bounds 'int': $_[1]->{complete}"
        unless (-2147483648 <= $_[1]->{complete} and $_[1]->{complete} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{complete}"
        unless int($_[1]->{complete}) == $_[1]->{complete};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{complete});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_storage_pools_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_storage_pools_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_storage_pools_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_storage_pools_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_storage_pools_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_storage_pools_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_defined_storage_pools_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_defined_storage_pools_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_storage_pools_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_storage_pools_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_defined_storage_pools_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_defined_storage_pools_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_find_storage_pool_sources_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Deserializing field: 'srcSpec'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{srcSpec}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_find_storage_pool_sources_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Serializing field: 'srcSpec'
    croak "Missing required input value 'srcSpec'"
        unless exists $_[1]->{srcSpec};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{srcSpec}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_find_storage_pool_sources_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_find_storage_pool_sources_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_uuid_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_uuid_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_uuid_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_uuid_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_volume_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_volume_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_volume_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_volume_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_target_path_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_target_path_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_lookup_by_target_path_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_lookup_by_target_path_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_build_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_build_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_create_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_create_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_destroy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_destroy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_delete_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_delete_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_refresh_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_refresh_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'state'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{state} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned char': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 255);

    # Deserializing field: 'capacity'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{capacity} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);

    # Deserializing field: 'allocation'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{allocation} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);

    # Deserializing field: 'available'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{available} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{available}"
        unless (0 <= $_[1]->{available}
                and $_[1]->{available} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'state'
    croak "Missing required input value 'state'"
        unless exists $_[1]->{state};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'char' value"
        unless defined $_[1]->{state};
    die "Out of bounds 'unsigned char': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 255);
    die "Non-integer 'char' value given: $_[1]->{state}"
        unless int($_[1]->{state}) == $_[1]->{state};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{state});
    $_[2] += 4;

    # Serializing field: 'capacity'
    croak "Missing required input value 'capacity'"
        unless exists $_[1]->{capacity};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{capacity};
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{capacity}"
        unless int($_[1]->{capacity}) == $_[1]->{capacity};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{capacity});
    $_[2] += 8;

    # Serializing field: 'allocation'
    croak "Missing required input value 'allocation'"
        unless exists $_[1]->{allocation};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{allocation};
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{allocation}"
        unless int($_[1]->{allocation}) == $_[1]->{allocation};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{allocation});
    $_[2] += 8;

    # Serializing field: 'available'
    croak "Missing required input value 'available'"
        unless exists $_[1]->{available};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{available};
    die "Out of bounds 'unsigned hyper': $_[1]->{available}"
        unless (0 <= $_[1]->{available}
                and $_[1]->{available} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{available}"
        unless int($_[1]->{available}) == $_[1]->{available};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{available});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_get_autostart_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_get_autostart_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_set_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_set_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_num_of_volumes_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_num_of_volumes_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_num_of_volumes_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_num_of_volumes_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_list_volumes_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_list_volumes_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_list_volumes_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_list_volumes_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_key_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'key'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{key}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_key_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'key'
    croak "Missing required input value 'key'"
        unless exists $_[1]->{key};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{key}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_key_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_key_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_path_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_path_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_lookup_by_path_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_lookup_by_path_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_create_xml_from_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'clonevol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{clonevol}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_create_xml_from_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'clonevol'
    croak "Missing required input value 'clonevol'"
        unless exists $_[1]->{clonevol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{clonevol}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_create_xml_from_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_create_xml_from_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_delete_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_delete_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_wipe_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_wipe_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_wipe_pattern_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'algorithm'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{algorithm} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{algorithm}"
        unless (0 <= $_[1]->{algorithm} and $_[1]->{algorithm} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_wipe_pattern_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'algorithm'
    croak "Missing required input value 'algorithm'"
        unless exists $_[1]->{algorithm};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{algorithm};
    die "Out of bounds 'unsigned int': $_[1]->{algorithm}"
        unless (0 <= $_[1]->{algorithm} and $_[1]->{algorithm} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{algorithm}"
        unless int($_[1]->{algorithm}) == $_[1]->{algorithm};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{algorithm});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'char': $_[1]->{type}"
        unless (-128 <= $_[1]->{type} and $_[1]->{type} < 128);

    # Deserializing field: 'capacity'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{capacity} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);

    # Deserializing field: 'allocation'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{allocation} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'char' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'char': $_[1]->{type}"
        unless (-128 <= $_[1]->{type} and $_[1]->{type} < 128);
    die "Non-integer 'char' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'capacity'
    croak "Missing required input value 'capacity'"
        unless exists $_[1]->{capacity};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{capacity};
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{capacity}"
        unless int($_[1]->{capacity}) == $_[1]->{capacity};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{capacity});
    $_[2] += 8;

    # Serializing field: 'allocation'
    croak "Missing required input value 'allocation'"
        unless exists $_[1]->{allocation};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{allocation};
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{allocation}"
        unless int($_[1]->{allocation}) == $_[1]->{allocation};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{allocation});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_info_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_info_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_info_flags_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'char': $_[1]->{type}"
        unless (-128 <= $_[1]->{type} and $_[1]->{type} < 128);

    # Deserializing field: 'capacity'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{capacity} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);

    # Deserializing field: 'allocation'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{allocation} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_info_flags_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'char' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'char': $_[1]->{type}"
        unless (-128 <= $_[1]->{type} and $_[1]->{type} < 128);
    die "Non-integer 'char' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'capacity'
    croak "Missing required input value 'capacity'"
        unless exists $_[1]->{capacity};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{capacity};
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{capacity}"
        unless int($_[1]->{capacity}) == $_[1]->{capacity};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{capacity});
    $_[2] += 8;

    # Serializing field: 'allocation'
    croak "Missing required input value 'allocation'"
        unless exists $_[1]->{allocation};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{allocation};
    die "Out of bounds 'unsigned hyper': $_[1]->{allocation}"
        unless (0 <= $_[1]->{allocation}
                and $_[1]->{allocation} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{allocation}"
        unless int($_[1]->{allocation}) == $_[1]->{allocation};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{allocation});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_path_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_path_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_get_path_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_get_path_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_resize_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'capacity'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{capacity} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_resize_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'capacity'
    croak "Missing required input value 'capacity'"
        unless exists $_[1]->{capacity};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{capacity};
    die "Out of bounds 'unsigned hyper': $_[1]->{capacity}"
        unless (0 <= $_[1]->{capacity}
                and $_[1]->{capacity} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{capacity}"
        unless int($_[1]->{capacity}) == $_[1]->{capacity};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{capacity});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_num_of_devices_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{cap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_num_of_devices_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cap'
    croak "Missing required input value 'cap'"
        unless exists $_[1]->{cap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{cap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_num_of_devices_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_num_of_devices_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_list_devices_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{cap}, $_[2], $_[3] );

    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_list_devices_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cap'
    croak "Missing required input value 'cap'"
        unless exists $_[1]->{cap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{cap}, $_[2], $_[3] );

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_list_devices_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_list_devices_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dev'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dev'
    croak "Missing required input value 'dev'"
        unless exists $_[1]->{dev};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_lookup_scsi_host_by_wwn_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'wwnn'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{wwnn}, $_[2], $_[3] );

    # Deserializing field: 'wwpn'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{wwpn}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_lookup_scsi_host_by_wwn_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'wwnn'
    croak "Missing required input value 'wwnn'"
        unless exists $_[1]->{wwnn};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{wwnn}, $_[2], $_[3] );

    # Serializing field: 'wwpn'
    croak "Missing required input value 'wwpn'"
        unless exists $_[1]->{wwpn};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{wwpn}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_lookup_scsi_host_by_wwn_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dev'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_lookup_scsi_host_by_wwn_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dev'
    croak "Missing required input value 'dev'"
        unless exists $_[1]->{dev};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_parent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_parent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_parent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'parentName'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{parentName}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_parent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'parentName'
    croak "Missing required input value 'parentName'"
        unless exists $_[1]->{parentName};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{parentName}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_num_of_caps_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_num_of_caps_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_num_of_caps_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_num_of_caps_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_list_caps_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_list_caps_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_list_caps_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_list_caps_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_dettach_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_dettach_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_detach_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'driverName'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{driverName}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_detach_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'driverName'
    croak "Missing required input value 'driverName'"
        unless exists $_[1]->{driverName};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{driverName}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_re_attach_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_re_attach_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_reset_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_reset_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dev'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dev'
    croak "Missing required input value 'dev'"
        unless exists $_[1]->{dev};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_destroy_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_destroy_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dev'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dev'
    croak "Missing required input value 'dev'"
        unless exists $_[1]->{dev};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_node_device( $_[1]->{dev}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_create_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_create_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_get_autostart_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_get_autostart_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_set_autostart_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'autostart'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{autostart} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_set_autostart_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'autostart'
    croak "Missing required input value 'autostart'"
        unless exists $_[1]->{autostart};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{autostart};
    die "Out of bounds 'int': $_[1]->{autostart}"
        unless (-2147483648 <= $_[1]->{autostart} and $_[1]->{autostart} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{autostart}"
        unless int($_[1]->{autostart}) == $_[1]->{autostart};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{autostart});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_is_persistent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_is_persistent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_is_persistent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'persistent'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{persistent} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_is_persistent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'persistent'
    croak "Missing required input value 'persistent'"
        unless exists $_[1]->{persistent};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{persistent};
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{persistent}"
        unless int($_[1]->{persistent}) == $_[1]->{persistent};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{persistent});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_is_active_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_is_active_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_is_active_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'active'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{active} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_is_active_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'active'
    croak "Missing required input value 'active'"
        unless exists $_[1]->{active};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{active};
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{active}"
        unless int($_[1]->{active}) == $_[1]->{active};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{active});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_device_update_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_device_update_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_register_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cb_registered'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cb_registered} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cb_registered}"
        unless (-2147483648 <= $_[1]->{cb_registered} and $_[1]->{cb_registered} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_register_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cb_registered'
    croak "Missing required input value 'cb_registered'"
        unless exists $_[1]->{cb_registered};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cb_registered};
    die "Out of bounds 'int': $_[1]->{cb_registered}"
        unless (-2147483648 <= $_[1]->{cb_registered} and $_[1]->{cb_registered} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cb_registered}"
        unless int($_[1]->{cb_registered}) == $_[1]->{cb_registered};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cb_registered});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_deregister_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cb_registered'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cb_registered} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cb_registered}"
        unless (-2147483648 <= $_[1]->{cb_registered} and $_[1]->{cb_registered} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_deregister_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cb_registered'
    croak "Missing required input value 'cb_registered'"
        unless exists $_[1]->{cb_registered};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cb_registered};
    die "Out of bounds 'int': $_[1]->{cb_registered}"
        unless (-2147483648 <= $_[1]->{cb_registered} and $_[1]->{cb_registered} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cb_registered}"
        unless int($_[1]->{cb_registered}) == $_[1]->{cb_registered};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cb_registered});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_lifecycle_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'event'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{event} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{event}"
        unless (-2147483648 <= $_[1]->{event} and $_[1]->{event} < 2147483648);

    # Deserializing field: 'detail'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{detail} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{detail}"
        unless (-2147483648 <= $_[1]->{detail} and $_[1]->{detail} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_lifecycle_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'event'
    croak "Missing required input value 'event'"
        unless exists $_[1]->{event};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{event};
    die "Out of bounds 'int': $_[1]->{event}"
        unless (-2147483648 <= $_[1]->{event} and $_[1]->{event} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{event}"
        unless int($_[1]->{event}) == $_[1]->{event};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{event});
    $_[2] += 4;

    # Serializing field: 'detail'
    croak "Missing required input value 'detail'"
        unless exists $_[1]->{detail};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{detail};
    die "Out of bounds 'int': $_[1]->{detail}"
        unless (-2147483648 <= $_[1]->{detail} and $_[1]->{detail} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{detail}"
        unless int($_[1]->{detail}) == $_[1]->{detail};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{detail});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_lifecycle_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_lifecycle_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_lifecycle_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_lifecycle_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_xml_from_native_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nativeFormat'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{nativeFormat}, $_[2], $_[3] );

    # Deserializing field: 'nativeConfig'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{nativeConfig}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_xml_from_native_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nativeFormat'
    croak "Missing required input value 'nativeFormat'"
        unless exists $_[1]->{nativeFormat};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{nativeFormat}, $_[2], $_[3] );

    # Serializing field: 'nativeConfig'
    croak "Missing required input value 'nativeConfig'"
        unless exists $_[1]->{nativeConfig};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{nativeConfig}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_xml_from_native_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'domainXml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{domainXml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_xml_from_native_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'domainXml'
    croak "Missing required input value 'domainXml'"
        unless exists $_[1]->{domainXml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{domainXml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_xml_to_native_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nativeFormat'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{nativeFormat}, $_[2], $_[3] );

    # Deserializing field: 'domainXml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{domainXml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_xml_to_native_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nativeFormat'
    croak "Missing required input value 'nativeFormat'"
        unless exists $_[1]->{nativeFormat};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{nativeFormat}, $_[2], $_[3] );

    # Serializing field: 'domainXml'
    croak "Missing required input value 'domainXml'"
        unless exists $_[1]->{domainXml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{domainXml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_xml_to_native_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nativeConfig'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{nativeConfig}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_xml_to_native_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nativeConfig'
    croak "Missing required input value 'nativeConfig'"
        unless exists $_[1]->{nativeConfig};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{nativeConfig}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_num_of_secrets_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_num_of_secrets_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_secrets_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'maxuuids'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxuuids} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxuuids}"
        unless (-2147483648 <= $_[1]->{maxuuids} and $_[1]->{maxuuids} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_secrets_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'maxuuids'
    croak "Missing required input value 'maxuuids'"
        unless exists $_[1]->{maxuuids};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxuuids};
    die "Out of bounds 'int': $_[1]->{maxuuids}"
        unless (-2147483648 <= $_[1]->{maxuuids} and $_[1]->{maxuuids} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxuuids}"
        unless int($_[1]->{maxuuids}) == $_[1]->{maxuuids};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxuuids});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_secrets_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuids'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{uuids} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{uuids}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_secrets_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuids'
    croak "Missing required input value 'uuids'"
        unless exists $_[1]->{uuids};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{uuids};
    do {
        my $len = scalar @{ $_[1]->{uuids} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{uuids}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_lookup_by_uuid_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'uuid'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_lookup_by_uuid_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'uuid'
    croak "Missing required input value 'uuid'"
        unless exists $_[1]->{uuid};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_uuid( $_[1]->{uuid}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_lookup_by_uuid_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_lookup_by_uuid_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_define_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_define_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_set_value_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Deserializing field: 'value'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 65536): $len"
            unless ($len <= 65536);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{value} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_set_value_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Serializing field: 'value'
    croak "Missing required input value 'value'"
        unless exists $_[1]->{value};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{value};
    do {
        my $len = length $_[1]->{value};
        die "Opaque data too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{value};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_get_value_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_get_value_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_get_value_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'value'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 65536): $len"
            unless ($len <= 65536);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{value} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_get_value_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'value'
    croak "Missing required input value 'value'"
        unless exists $_[1]->{value};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{value};
    do {
        my $len = length $_[1]->{value};
        die "Opaque data too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{value};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_undefine_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_undefine_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_lookup_by_usage_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'usageType'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{usageType} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{usageType}"
        unless (-2147483648 <= $_[1]->{usageType} and $_[1]->{usageType} < 2147483648);

    # Deserializing field: 'usageID'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{usageID}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_lookup_by_usage_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'usageType'
    croak "Missing required input value 'usageType'"
        unless exists $_[1]->{usageType};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{usageType};
    die "Out of bounds 'int': $_[1]->{usageType}"
        unless (-2147483648 <= $_[1]->{usageType} and $_[1]->{usageType} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{usageType}"
        unless int($_[1]->{usageType}) == $_[1]->{usageType};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{usageType});
    $_[2] += 4;

    # Serializing field: 'usageID'
    croak "Missing required input value 'usageID'"
        unless exists $_[1]->{usageID};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{usageID}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_secret_lookup_by_usage_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secret'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_secret_lookup_by_usage_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secret'
    croak "Missing required input value 'secret'"
        unless exists $_[1]->{secret};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_secret( $_[1]->{secret}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare_tunnel_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'dom_xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare_tunnel_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'dom_xml'
    croak "Missing required input value 'dom_xml'"
        unless exists $_[1]->{dom_xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_is_secure_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secure'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{secure} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{secure}"
        unless (-2147483648 <= $_[1]->{secure} and $_[1]->{secure} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_is_secure_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secure'
    croak "Missing required input value 'secure'"
        unless exists $_[1]->{secure};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{secure};
    die "Out of bounds 'int': $_[1]->{secure}"
        unless (-2147483648 <= $_[1]->{secure} and $_[1]->{secure} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{secure}"
        unless int($_[1]->{secure}) == $_[1]->{secure};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{secure});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_active_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_active_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_active_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'active'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{active} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_active_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'active'
    croak "Missing required input value 'active'"
        unless exists $_[1]->{active};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{active};
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{active}"
        unless int($_[1]->{active}) == $_[1]->{active};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{active});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_persistent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_persistent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_persistent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'persistent'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{persistent} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_persistent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'persistent'
    croak "Missing required input value 'persistent'"
        unless exists $_[1]->{persistent};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{persistent};
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{persistent}"
        unless int($_[1]->{persistent}) == $_[1]->{persistent};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{persistent});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_updated_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_updated_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_is_updated_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'updated'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{updated} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{updated}"
        unless (-2147483648 <= $_[1]->{updated} and $_[1]->{updated} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_is_updated_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'updated'
    croak "Missing required input value 'updated'"
        unless exists $_[1]->{updated};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{updated};
    die "Out of bounds 'int': $_[1]->{updated}"
        unless (-2147483648 <= $_[1]->{updated} and $_[1]->{updated} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{updated}"
        unless int($_[1]->{updated}) == $_[1]->{updated};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{updated});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_is_active_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_is_active_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_is_active_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'active'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{active} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_is_active_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'active'
    croak "Missing required input value 'active'"
        unless exists $_[1]->{active};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{active};
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{active}"
        unless int($_[1]->{active}) == $_[1]->{active};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{active});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_is_persistent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'net'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_is_persistent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'net'
    croak "Missing required input value 'net'"
        unless exists $_[1]->{net};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_network( $_[1]->{net}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_network_is_persistent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'persistent'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{persistent} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_network_is_persistent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'persistent'
    croak "Missing required input value 'persistent'"
        unless exists $_[1]->{persistent};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{persistent};
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{persistent}"
        unless int($_[1]->{persistent}) == $_[1]->{persistent};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{persistent});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_is_active_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_is_active_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_is_active_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'active'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{active} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_is_active_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'active'
    croak "Missing required input value 'active'"
        unless exists $_[1]->{active};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{active};
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{active}"
        unless int($_[1]->{active}) == $_[1]->{active};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{active});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_is_persistent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_is_persistent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_is_persistent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'persistent'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{persistent} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_is_persistent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'persistent'
    croak "Missing required input value 'persistent'"
        unless exists $_[1]->{persistent};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{persistent};
    die "Out of bounds 'int': $_[1]->{persistent}"
        unless (-2147483648 <= $_[1]->{persistent} and $_[1]->{persistent} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{persistent}"
        unless int($_[1]->{persistent}) == $_[1]->{persistent};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{persistent});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_is_active_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'iface'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_is_active_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'iface'
    croak "Missing required input value 'iface'"
        unless exists $_[1]->{iface};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_interface( $_[1]->{iface}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_interface_is_active_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'active'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{active} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_interface_is_active_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'active'
    croak "Missing required input value 'active'"
        unless exists $_[1]->{active};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{active};
    die "Out of bounds 'int': $_[1]->{active}"
        unless (-2147483648 <= $_[1]->{active} and $_[1]->{active} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{active}"
        unless int($_[1]->{active}) == $_[1]->{active};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{active});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_compare_cpu_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_compare_cpu_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_compare_cpu_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'result'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{result} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_compare_cpu_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'result'
    croak "Missing required input value 'result'"
        unless exists $_[1]->{result};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{result};
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{result}"
        unless int($_[1]->{result}) == $_[1]->{result};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{result});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_baseline_cpu_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xmlCPUs'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 256): $len"
            unless ($len <= 256);
        $_[1]->{xmlCPUs} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{xmlCPUs}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_baseline_cpu_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xmlCPUs'
    croak "Missing required input value 'xmlCPUs'"
        unless exists $_[1]->{xmlCPUs};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{xmlCPUs};
    do {
        my $len = scalar @{ $_[1]->{xmlCPUs} };
        die "Array too long (max: 256): $len"
            unless ($len <= 256);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{xmlCPUs}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_baseline_cpu_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cpu'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{cpu}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_baseline_cpu_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cpu'
    croak "Missing required input value 'cpu'"
        unless exists $_[1]->{cpu};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{cpu}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_job_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_job_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_job_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'timeElapsed'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{timeElapsed} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{timeElapsed}"
        unless (0 <= $_[1]->{timeElapsed}
                and $_[1]->{timeElapsed} <= 18446744073709551615);

    # Deserializing field: 'timeRemaining'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{timeRemaining} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{timeRemaining}"
        unless (0 <= $_[1]->{timeRemaining}
                and $_[1]->{timeRemaining} <= 18446744073709551615);

    # Deserializing field: 'dataTotal'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{dataTotal} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{dataTotal}"
        unless (0 <= $_[1]->{dataTotal}
                and $_[1]->{dataTotal} <= 18446744073709551615);

    # Deserializing field: 'dataProcessed'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{dataProcessed} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{dataProcessed}"
        unless (0 <= $_[1]->{dataProcessed}
                and $_[1]->{dataProcessed} <= 18446744073709551615);

    # Deserializing field: 'dataRemaining'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{dataRemaining} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{dataRemaining}"
        unless (0 <= $_[1]->{dataRemaining}
                and $_[1]->{dataRemaining} <= 18446744073709551615);

    # Deserializing field: 'memTotal'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memTotal} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memTotal}"
        unless (0 <= $_[1]->{memTotal}
                and $_[1]->{memTotal} <= 18446744073709551615);

    # Deserializing field: 'memProcessed'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memProcessed} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memProcessed}"
        unless (0 <= $_[1]->{memProcessed}
                and $_[1]->{memProcessed} <= 18446744073709551615);

    # Deserializing field: 'memRemaining'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{memRemaining} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{memRemaining}"
        unless (0 <= $_[1]->{memRemaining}
                and $_[1]->{memRemaining} <= 18446744073709551615);

    # Deserializing field: 'fileTotal'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{fileTotal} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{fileTotal}"
        unless (0 <= $_[1]->{fileTotal}
                and $_[1]->{fileTotal} <= 18446744073709551615);

    # Deserializing field: 'fileProcessed'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{fileProcessed} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{fileProcessed}"
        unless (0 <= $_[1]->{fileProcessed}
                and $_[1]->{fileProcessed} <= 18446744073709551615);

    # Deserializing field: 'fileRemaining'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{fileRemaining} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{fileRemaining}"
        unless (0 <= $_[1]->{fileRemaining}
                and $_[1]->{fileRemaining} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_job_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'timeElapsed'
    croak "Missing required input value 'timeElapsed'"
        unless exists $_[1]->{timeElapsed};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{timeElapsed};
    die "Out of bounds 'unsigned hyper': $_[1]->{timeElapsed}"
        unless (0 <= $_[1]->{timeElapsed}
                and $_[1]->{timeElapsed} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{timeElapsed}"
        unless int($_[1]->{timeElapsed}) == $_[1]->{timeElapsed};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{timeElapsed});
    $_[2] += 8;

    # Serializing field: 'timeRemaining'
    croak "Missing required input value 'timeRemaining'"
        unless exists $_[1]->{timeRemaining};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{timeRemaining};
    die "Out of bounds 'unsigned hyper': $_[1]->{timeRemaining}"
        unless (0 <= $_[1]->{timeRemaining}
                and $_[1]->{timeRemaining} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{timeRemaining}"
        unless int($_[1]->{timeRemaining}) == $_[1]->{timeRemaining};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{timeRemaining});
    $_[2] += 8;

    # Serializing field: 'dataTotal'
    croak "Missing required input value 'dataTotal'"
        unless exists $_[1]->{dataTotal};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{dataTotal};
    die "Out of bounds 'unsigned hyper': $_[1]->{dataTotal}"
        unless (0 <= $_[1]->{dataTotal}
                and $_[1]->{dataTotal} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{dataTotal}"
        unless int($_[1]->{dataTotal}) == $_[1]->{dataTotal};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{dataTotal});
    $_[2] += 8;

    # Serializing field: 'dataProcessed'
    croak "Missing required input value 'dataProcessed'"
        unless exists $_[1]->{dataProcessed};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{dataProcessed};
    die "Out of bounds 'unsigned hyper': $_[1]->{dataProcessed}"
        unless (0 <= $_[1]->{dataProcessed}
                and $_[1]->{dataProcessed} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{dataProcessed}"
        unless int($_[1]->{dataProcessed}) == $_[1]->{dataProcessed};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{dataProcessed});
    $_[2] += 8;

    # Serializing field: 'dataRemaining'
    croak "Missing required input value 'dataRemaining'"
        unless exists $_[1]->{dataRemaining};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{dataRemaining};
    die "Out of bounds 'unsigned hyper': $_[1]->{dataRemaining}"
        unless (0 <= $_[1]->{dataRemaining}
                and $_[1]->{dataRemaining} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{dataRemaining}"
        unless int($_[1]->{dataRemaining}) == $_[1]->{dataRemaining};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{dataRemaining});
    $_[2] += 8;

    # Serializing field: 'memTotal'
    croak "Missing required input value 'memTotal'"
        unless exists $_[1]->{memTotal};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memTotal};
    die "Out of bounds 'unsigned hyper': $_[1]->{memTotal}"
        unless (0 <= $_[1]->{memTotal}
                and $_[1]->{memTotal} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memTotal}"
        unless int($_[1]->{memTotal}) == $_[1]->{memTotal};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memTotal});
    $_[2] += 8;

    # Serializing field: 'memProcessed'
    croak "Missing required input value 'memProcessed'"
        unless exists $_[1]->{memProcessed};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memProcessed};
    die "Out of bounds 'unsigned hyper': $_[1]->{memProcessed}"
        unless (0 <= $_[1]->{memProcessed}
                and $_[1]->{memProcessed} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memProcessed}"
        unless int($_[1]->{memProcessed}) == $_[1]->{memProcessed};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memProcessed});
    $_[2] += 8;

    # Serializing field: 'memRemaining'
    croak "Missing required input value 'memRemaining'"
        unless exists $_[1]->{memRemaining};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{memRemaining};
    die "Out of bounds 'unsigned hyper': $_[1]->{memRemaining}"
        unless (0 <= $_[1]->{memRemaining}
                and $_[1]->{memRemaining} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{memRemaining}"
        unless int($_[1]->{memRemaining}) == $_[1]->{memRemaining};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{memRemaining});
    $_[2] += 8;

    # Serializing field: 'fileTotal'
    croak "Missing required input value 'fileTotal'"
        unless exists $_[1]->{fileTotal};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{fileTotal};
    die "Out of bounds 'unsigned hyper': $_[1]->{fileTotal}"
        unless (0 <= $_[1]->{fileTotal}
                and $_[1]->{fileTotal} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{fileTotal}"
        unless int($_[1]->{fileTotal}) == $_[1]->{fileTotal};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{fileTotal});
    $_[2] += 8;

    # Serializing field: 'fileProcessed'
    croak "Missing required input value 'fileProcessed'"
        unless exists $_[1]->{fileProcessed};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{fileProcessed};
    die "Out of bounds 'unsigned hyper': $_[1]->{fileProcessed}"
        unless (0 <= $_[1]->{fileProcessed}
                and $_[1]->{fileProcessed} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{fileProcessed}"
        unless int($_[1]->{fileProcessed}) == $_[1]->{fileProcessed};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{fileProcessed});
    $_[2] += 8;

    # Serializing field: 'fileRemaining'
    croak "Missing required input value 'fileRemaining'"
        unless exists $_[1]->{fileRemaining};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{fileRemaining};
    die "Out of bounds 'unsigned hyper': $_[1]->{fileRemaining}"
        unless (0 <= $_[1]->{fileRemaining}
                and $_[1]->{fileRemaining} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{fileRemaining}"
        unless int($_[1]->{fileRemaining}) == $_[1]->{fileRemaining};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{fileRemaining});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_job_stats_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_job_stats_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_job_stats_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 64): $len"
            unless ($len <= 64);
        $_[1]->{params} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_job_stats_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'params'
    croak "Missing required input value 'params'"
        unless exists $_[1]->{params};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{params};
    do {
        my $len = scalar @{ $_[1]->{params} };
        die "Array too long (max: 64): $len"
            unless ($len <= 64);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_typed_param( $_[1]->{params}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_abort_job_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_abort_job_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_abort_job_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_abort_job_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_max_downtime_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_max_downtime_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_max_downtime_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'downtime'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{downtime} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{downtime}"
        unless (0 <= $_[1]->{downtime}
                and $_[1]->{downtime} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_max_downtime_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'downtime'
    croak "Missing required input value 'downtime'"
        unless exists $_[1]->{downtime};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{downtime};
    die "Out of bounds 'unsigned hyper': $_[1]->{downtime}"
        unless (0 <= $_[1]->{downtime}
                and $_[1]->{downtime} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{downtime}"
        unless int($_[1]->{downtime}) == $_[1]->{downtime};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{downtime});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_set_max_downtime_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'downtime'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{downtime} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{downtime}"
        unless (0 <= $_[1]->{downtime}
                and $_[1]->{downtime} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_set_max_downtime_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'downtime'
    croak "Missing required input value 'downtime'"
        unless exists $_[1]->{downtime};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{downtime};
    die "Out of bounds 'unsigned hyper': $_[1]->{downtime}"
        unless (0 <= $_[1]->{downtime}
                and $_[1]->{downtime} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{downtime}"
        unless int($_[1]->{downtime}) == $_[1]->{downtime};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{downtime});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_compression_cache_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_compression_cache_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_compression_cache_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cacheSize'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{cacheSize} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{cacheSize}"
        unless (0 <= $_[1]->{cacheSize}
                and $_[1]->{cacheSize} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_compression_cache_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cacheSize'
    croak "Missing required input value 'cacheSize'"
        unless exists $_[1]->{cacheSize};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{cacheSize};
    die "Out of bounds 'unsigned hyper': $_[1]->{cacheSize}"
        unless (0 <= $_[1]->{cacheSize}
                and $_[1]->{cacheSize} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{cacheSize}"
        unless int($_[1]->{cacheSize}) == $_[1]->{cacheSize};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cacheSize});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_set_compression_cache_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'cacheSize'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{cacheSize} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{cacheSize}"
        unless (0 <= $_[1]->{cacheSize}
                and $_[1]->{cacheSize} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_set_compression_cache_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'cacheSize'
    croak "Missing required input value 'cacheSize'"
        unless exists $_[1]->{cacheSize};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{cacheSize};
    die "Out of bounds 'unsigned hyper': $_[1]->{cacheSize}"
        unless (0 <= $_[1]->{cacheSize}
                and $_[1]->{cacheSize} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{cacheSize}"
        unless int($_[1]->{cacheSize}) == $_[1]->{cacheSize};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{cacheSize});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_set_max_speed_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_set_max_speed_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_max_speed_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_max_speed_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_get_max_speed_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_get_max_speed_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_register_any_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'eventID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{eventID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_register_any_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'eventID'
    croak "Missing required input value 'eventID'"
        unless exists $_[1]->{eventID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{eventID};
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{eventID}"
        unless int($_[1]->{eventID}) == $_[1]->{eventID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{eventID});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_deregister_any_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'eventID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{eventID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_deregister_any_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'eventID'
    croak "Missing required input value 'eventID'"
        unless exists $_[1]->{eventID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{eventID};
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{eventID}"
        unless int($_[1]->{eventID}) == $_[1]->{eventID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{eventID});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_callback_register_any_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'eventID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{eventID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);

    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_callback_register_any_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'eventID'
    croak "Missing required input value 'eventID'"
        unless exists $_[1]->{eventID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{eventID};
    die "Out of bounds 'int': $_[1]->{eventID}"
        unless (-2147483648 <= $_[1]->{eventID} and $_[1]->{eventID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{eventID}"
        unless int($_[1]->{eventID}) == $_[1]->{eventID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{eventID});
    $_[2] += 4;

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_callback_register_any_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_callback_register_any_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_domain_event_callback_deregister_any_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_domain_event_callback_deregister_any_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_reboot_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_reboot_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_reboot_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_reboot_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_reboot_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_reboot_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_rtc_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'offset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{offset} = unpack("q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'hyper': $_[1]->{offset}"
        unless (-9223372036854775808 <= $_[1]->{offset}
                and $_[1]->{offset} < 9223372036854775808);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_rtc_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'offset'
    croak "Missing required input value 'offset'"
        unless exists $_[1]->{offset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'long' value"
        unless defined $_[1]->{offset};
    die "Out of bounds 'hyper': $_[1]->{offset}"
        unless (-9223372036854775808 <= $_[1]->{offset}
                and $_[1]->{offset} < 9223372036854775808);
    die "Non-integer 'long' value given: $_[1]->{offset}"
        unless int($_[1]->{offset}) == $_[1]->{offset};
    substr( $_[3], $_[2] ) = pack("q>", $_[1]->{offset});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_rtc_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_rtc_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_rtc_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_rtc_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_watchdog_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'action'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{action} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_watchdog_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'action'
    croak "Missing required input value 'action'"
        unless exists $_[1]->{action};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{action};
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{action}"
        unless int($_[1]->{action}) == $_[1]->{action};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{action});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_watchdog_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_watchdog_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_watchdog_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_watchdog_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_io_error_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'srcPath'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{srcPath}, $_[2], $_[3] );

    # Deserializing field: 'devAlias'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Deserializing field: 'action'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{action} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_io_error_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'srcPath'
    croak "Missing required input value 'srcPath'"
        unless exists $_[1]->{srcPath};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{srcPath}, $_[2], $_[3] );

    # Serializing field: 'devAlias'
    croak "Missing required input value 'devAlias'"
        unless exists $_[1]->{devAlias};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Serializing field: 'action'
    croak "Missing required input value 'action'"
        unless exists $_[1]->{action};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{action};
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{action}"
        unless int($_[1]->{action}) == $_[1]->{action};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{action});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_io_error_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_io_error_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_io_error_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_io_error_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_io_error_reason_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'srcPath'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{srcPath}, $_[2], $_[3] );

    # Deserializing field: 'devAlias'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Deserializing field: 'action'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{action} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{reason}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_io_error_reason_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'srcPath'
    croak "Missing required input value 'srcPath'"
        unless exists $_[1]->{srcPath};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{srcPath}, $_[2], $_[3] );

    # Serializing field: 'devAlias'
    croak "Missing required input value 'devAlias'"
        unless exists $_[1]->{devAlias};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Serializing field: 'action'
    croak "Missing required input value 'action'"
        unless exists $_[1]->{action};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{action};
    die "Out of bounds 'int': $_[1]->{action}"
        unless (-2147483648 <= $_[1]->{action} and $_[1]->{action} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{action}"
        unless int($_[1]->{action}) == $_[1]->{action};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{action});
    $_[2] += 4;

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{reason}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_io_error_reason_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_io_error_reason_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_io_error_reason_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_io_error_reason_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_graphics_address {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'family'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{family} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{family}"
        unless (-2147483648 <= $_[1]->{family} and $_[1]->{family} < 2147483648);

    # Deserializing field: 'node'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{node}, $_[2], $_[3] );

    # Deserializing field: 'service'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{service}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_graphics_address {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'family'
    croak "Missing required input value 'family'"
        unless exists $_[1]->{family};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{family};
    die "Out of bounds 'int': $_[1]->{family}"
        unless (-2147483648 <= $_[1]->{family} and $_[1]->{family} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{family}"
        unless int($_[1]->{family}) == $_[1]->{family};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{family});
    $_[2] += 4;

    # Serializing field: 'node'
    croak "Missing required input value 'node'"
        unless exists $_[1]->{node};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{node}, $_[2], $_[3] );

    # Serializing field: 'service'
    croak "Missing required input value 'service'"
        unless exists $_[1]->{service};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{service}, $_[2], $_[3] );
}
use constant DOMAIN_EVENT_GRAPHICS_IDENTITY_MAX => 20; # 20
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_graphics_identity {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_graphics_identity {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{type}, $_[2], $_[3] );

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_graphics_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'phase'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{phase} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{phase}"
        unless (-2147483648 <= $_[1]->{phase} and $_[1]->{phase} < 2147483648);

    # Deserializing field: 'local'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_graphics_address( $_[1]->{local}, $_[2], $_[3] );

    # Deserializing field: 'remote'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_graphics_address( $_[1]->{remote}, $_[2], $_[3] );

    # Deserializing field: 'authScheme'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{authScheme}, $_[2], $_[3] );

    # Deserializing field: 'subject'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 20): $len"
            unless ($len <= 20);
        $_[1]->{subject} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_domain_event_graphics_identity( $_[1]->{subject}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_graphics_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'phase'
    croak "Missing required input value 'phase'"
        unless exists $_[1]->{phase};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{phase};
    die "Out of bounds 'int': $_[1]->{phase}"
        unless (-2147483648 <= $_[1]->{phase} and $_[1]->{phase} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{phase}"
        unless int($_[1]->{phase}) == $_[1]->{phase};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{phase});
    $_[2] += 4;

    # Serializing field: 'local'
    croak "Missing required input value 'local'"
        unless exists $_[1]->{local};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_graphics_address( $_[1]->{local}, $_[2], $_[3] );

    # Serializing field: 'remote'
    croak "Missing required input value 'remote'"
        unless exists $_[1]->{remote};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_graphics_address( $_[1]->{remote}, $_[2], $_[3] );

    # Serializing field: 'authScheme'
    croak "Missing required input value 'authScheme'"
        unless exists $_[1]->{authScheme};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{authScheme}, $_[2], $_[3] );

    # Serializing field: 'subject'
    croak "Missing required input value 'subject'"
        unless exists $_[1]->{subject};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{subject};
    do {
        my $len = scalar @{ $_[1]->{subject} };
        die "Array too long (max: 20): $len"
            unless ($len <= 20);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_domain_event_graphics_identity( $_[1]->{subject}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_graphics_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_graphics_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_graphics_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_graphics_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_block_job_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'path'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Deserializing field: 'type'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{type} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);

    # Deserializing field: 'status'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{status} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{status}"
        unless (-2147483648 <= $_[1]->{status} and $_[1]->{status} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_block_job_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'path'
    croak "Missing required input value 'path'"
        unless exists $_[1]->{path};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{path}, $_[2], $_[3] );

    # Serializing field: 'type'
    croak "Missing required input value 'type'"
        unless exists $_[1]->{type};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{type};
    die "Out of bounds 'int': $_[1]->{type}"
        unless (-2147483648 <= $_[1]->{type} and $_[1]->{type} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{type}"
        unless int($_[1]->{type}) == $_[1]->{type};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{type});
    $_[2] += 4;

    # Serializing field: 'status'
    croak "Missing required input value 'status'"
        unless exists $_[1]->{status};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{status};
    die "Out of bounds 'int': $_[1]->{status}"
        unless (-2147483648 <= $_[1]->{status} and $_[1]->{status} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{status}"
        unless int($_[1]->{status}) == $_[1]->{status};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{status});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_block_job_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_block_job_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_block_job_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_block_job_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_disk_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'oldSrcPath'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{oldSrcPath}, $_[2], $_[3] );

    # Deserializing field: 'newSrcPath'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{newSrcPath}, $_[2], $_[3] );

    # Deserializing field: 'devAlias'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_disk_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'oldSrcPath'
    croak "Missing required input value 'oldSrcPath'"
        unless exists $_[1]->{oldSrcPath};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{oldSrcPath}, $_[2], $_[3] );

    # Serializing field: 'newSrcPath'
    croak "Missing required input value 'newSrcPath'"
        unless exists $_[1]->{newSrcPath};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{newSrcPath}, $_[2], $_[3] );

    # Serializing field: 'devAlias'
    croak "Missing required input value 'devAlias'"
        unless exists $_[1]->{devAlias};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_disk_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_disk_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_disk_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_disk_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_tray_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'devAlias'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_tray_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'devAlias'
    croak "Missing required input value 'devAlias'"
        unless exists $_[1]->{devAlias};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{devAlias}, $_[2], $_[3] );

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_tray_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_tray_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_tray_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_tray_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_pmwakeup_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_pmwakeup_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_pmwakeup_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_pmwakeup_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_pmwakeup_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_pmwakeup_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_pmsuspend_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_pmsuspend_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_pmsuspend_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_pmsuspend_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_pmsuspend_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_pmsuspend_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_balloon_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'actual'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{actual} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{actual}"
        unless (0 <= $_[1]->{actual}
                and $_[1]->{actual} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_balloon_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'actual'
    croak "Missing required input value 'actual'"
        unless exists $_[1]->{actual};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{actual};
    die "Out of bounds 'unsigned hyper': $_[1]->{actual}"
        unless (0 <= $_[1]->{actual}
                and $_[1]->{actual} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{actual}"
        unless int($_[1]->{actual}) == $_[1]->{actual};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{actual});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_balloon_change_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_balloon_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_balloon_change_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_balloon_change_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_pmsuspend_disk_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_pmsuspend_disk_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_pmsuspend_disk_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_pmsuspend_disk_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_pmsuspend_disk_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_pmsuspend_disk_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_managed_save_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_managed_save_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_has_managed_save_image_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_has_managed_save_image_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_has_managed_save_image_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'result'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{result} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_has_managed_save_image_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'result'
    croak "Missing required input value 'result'"
        unless exists $_[1]->{result};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{result};
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{result}"
        unless int($_[1]->{result}) == $_[1]->{result};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{result});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_managed_save_remove_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_managed_save_remove_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_managed_save_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_managed_save_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_managed_save_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_managed_save_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_managed_save_define_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'dxml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_managed_save_define_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'dxml'
    croak "Missing required input value 'dxml'"
        unless exists $_[1]->{dxml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dxml}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_create_xml_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xml_desc'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_create_xml_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xml_desc'
    croak "Missing required input value 'xml_desc'"
        unless exists $_[1]->{xml_desc};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml_desc}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_create_xml_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_create_xml_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_get_xml_desc_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_get_xml_desc_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_get_xml_desc_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_get_xml_desc_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_num_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_num_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_num_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_num_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_names_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_names_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_names_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_names_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_list_all_snapshots_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_list_all_snapshots_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_list_all_snapshots_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snapshots'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{snapshots} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snapshots}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_list_all_snapshots_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snapshots'
    croak "Missing required input value 'snapshots'"
        unless exists $_[1]->{snapshots};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{snapshots};
    do {
        my $len = scalar @{ $_[1]->{snapshots} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snapshots}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_num_children_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_num_children_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_num_children_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'num'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{num} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_num_children_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'num'
    croak "Missing required input value 'num'"
        unless exists $_[1]->{num};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{num};
    die "Out of bounds 'int': $_[1]->{num}"
        unless (-2147483648 <= $_[1]->{num} and $_[1]->{num} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{num}"
        unless int($_[1]->{num}) == $_[1]->{num};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{num});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_children_names_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'maxnames'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxnames} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_children_names_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'maxnames'
    croak "Missing required input value 'maxnames'"
        unless exists $_[1]->{maxnames};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{maxnames};
    die "Out of bounds 'int': $_[1]->{maxnames}"
        unless (-2147483648 <= $_[1]->{maxnames} and $_[1]->{maxnames} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{maxnames}"
        unless int($_[1]->{maxnames}) == $_[1]->{maxnames};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{maxnames});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_children_names_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'names'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{names} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_children_names_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'names'
    croak "Missing required input value 'names'"
        unless exists $_[1]->{names};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{names};
    do {
        my $len = scalar @{ $_[1]->{names} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_string( $_[1]->{names}->[$i1], $_[2], $_[3] );
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_all_children_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snapshot'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snapshot}, $_[2], $_[3] );

    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_all_children_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snapshot'
    croak "Missing required input value 'snapshot'"
        unless exists $_[1]->{snapshot};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snapshot}, $_[2], $_[3] );

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_list_all_children_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snapshots'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{snapshots} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snapshots}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_list_all_children_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snapshots'
    croak "Missing required input value 'snapshots'"
        unless exists $_[1]->{snapshots};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{snapshots};
    do {
        my $len = scalar @{ $_[1]->{snapshots} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snapshots}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'int': $_[1]->{ret}"
        unless (-2147483648 <= $_[1]->{ret} and $_[1]->{ret} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_lookup_by_name_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_lookup_by_name_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_lookup_by_name_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_lookup_by_name_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_has_current_snapshot_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_has_current_snapshot_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_has_current_snapshot_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'result'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{result} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_has_current_snapshot_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'result'
    croak "Missing required input value 'result'"
        unless exists $_[1]->{result};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{result};
    die "Out of bounds 'int': $_[1]->{result}"
        unless (-2147483648 <= $_[1]->{result} and $_[1]->{result} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{result}"
        unless int($_[1]->{result}) == $_[1]->{result};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{result});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_get_parent_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_get_parent_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_get_parent_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_get_parent_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_current_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_current_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_current_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_current_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_is_current_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_is_current_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_is_current_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'current'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{current} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{current}"
        unless (-2147483648 <= $_[1]->{current} and $_[1]->{current} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_is_current_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'current'
    croak "Missing required input value 'current'"
        unless exists $_[1]->{current};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{current};
    die "Out of bounds 'int': $_[1]->{current}"
        unless (-2147483648 <= $_[1]->{current} and $_[1]->{current} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{current}"
        unless int($_[1]->{current}) == $_[1]->{current};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{current});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_has_metadata_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_has_metadata_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_has_metadata_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'metadata'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{metadata} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{metadata}"
        unless (-2147483648 <= $_[1]->{metadata} and $_[1]->{metadata} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_has_metadata_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'metadata'
    croak "Missing required input value 'metadata'"
        unless exists $_[1]->{metadata};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{metadata};
    die "Out of bounds 'int': $_[1]->{metadata}"
        unless (-2147483648 <= $_[1]->{metadata} and $_[1]->{metadata} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{metadata}"
        unless int($_[1]->{metadata}) == $_[1]->{metadata};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{metadata});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_revert_to_snapshot_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_revert_to_snapshot_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_snapshot_delete_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'snap'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_snapshot_delete_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'snap'
    croak "Missing required input value 'snap'"
        unless exists $_[1]->{snap};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain_snapshot( $_[1]->{snap}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_open_console_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'dev_name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dev_name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_open_console_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'dev_name'
    croak "Missing required input value 'dev_name'"
        unless exists $_[1]->{dev_name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dev_name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_open_channel_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'name'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{name}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_open_channel_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'name'
    croak "Missing required input value 'name'"
        unless exists $_[1]->{name};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{name}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_upload_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'offset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{offset} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);

    # Deserializing field: 'length'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{length} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{length}"
        unless (0 <= $_[1]->{length}
                and $_[1]->{length} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_upload_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'offset'
    croak "Missing required input value 'offset'"
        unless exists $_[1]->{offset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{offset};
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{offset}"
        unless int($_[1]->{offset}) == $_[1]->{offset};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{offset});
    $_[2] += 8;

    # Serializing field: 'length'
    croak "Missing required input value 'length'"
        unless exists $_[1]->{length};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{length};
    die "Out of bounds 'unsigned hyper': $_[1]->{length}"
        unless (0 <= $_[1]->{length}
                and $_[1]->{length} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{length}"
        unless int($_[1]->{length}) == $_[1]->{length};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{length});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_vol_download_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vol'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Deserializing field: 'offset'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{offset} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);

    # Deserializing field: 'length'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{length} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{length}"
        unless (0 <= $_[1]->{length}
                and $_[1]->{length} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_vol_download_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vol'
    croak "Missing required input value 'vol'"
        unless exists $_[1]->{vol};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_vol( $_[1]->{vol}, $_[2], $_[3] );

    # Serializing field: 'offset'
    croak "Missing required input value 'offset'"
        unless exists $_[1]->{offset};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{offset};
    die "Out of bounds 'unsigned hyper': $_[1]->{offset}"
        unless (0 <= $_[1]->{offset}
                and $_[1]->{offset} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{offset}"
        unless int($_[1]->{offset}) == $_[1]->{offset};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{offset});
    $_[2] += 8;

    # Serializing field: 'length'
    croak "Missing required input value 'length'"
        unless exists $_[1]->{length};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{length};
    die "Out of bounds 'unsigned hyper': $_[1]->{length}"
        unless (0 <= $_[1]->{length}
                and $_[1]->{length} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{length}"
        unless int($_[1]->{length}) == $_[1]->{length};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{length});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_state_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_state_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_state_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'state'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{state} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{state}"
        unless (-2147483648 <= $_[1]->{state} and $_[1]->{state} < 2147483648);

    # Deserializing field: 'reason'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{reason} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_state_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'state'
    croak "Missing required input value 'state'"
        unless exists $_[1]->{state};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{state};
    die "Out of bounds 'int': $_[1]->{state}"
        unless (-2147483648 <= $_[1]->{state} and $_[1]->{state} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{state}"
        unless int($_[1]->{state}) == $_[1]->{state};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{state});
    $_[2] += 4;

    # Serializing field: 'reason'
    croak "Missing required input value 'reason'"
        unless exists $_[1]->{reason};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{reason};
    die "Out of bounds 'int': $_[1]->{reason}"
        unless (-2147483648 <= $_[1]->{reason} and $_[1]->{reason} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{reason}"
        unless int($_[1]->{reason}) == $_[1]->{reason};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{reason});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_begin3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xmlin'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{xmlin}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_begin3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xmlin'
    croak "Missing required input value 'xmlin'"
        unless exists $_[1]->{xmlin};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{xmlin}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_begin3_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_out'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_out} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_begin3_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_out'
    croak "Missing required input value 'cookie_out'"
        unless exists $_[1]->{cookie_out};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_out};
    do {
        my $len = length $_[1]->{cookie_out};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_out};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'xml'
    croak "Missing required input value 'xml'"
        unless exists $_[1]->{xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_in'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_in} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri_in'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'dom_xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_in'
    croak "Missing required input value 'cookie_in'"
        unless exists $_[1]->{cookie_in};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_in};
    do {
        my $len = length $_[1]->{cookie_in};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_in};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri_in'
    croak "Missing required input value 'uri_in'"
        unless exists $_[1]->{uri_in};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_in}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'dom_xml'
    croak "Missing required input value 'dom_xml'"
        unless exists $_[1]->{dom_xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare3_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_out'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_out} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'uri_out'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare3_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_out'
    croak "Missing required input value 'cookie_out'"
        unless exists $_[1]->{cookie_out};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_out};
    do {
        my $len = length $_[1]->{cookie_out};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_out};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'uri_out'
    croak "Missing required input value 'uri_out'"
        unless exists $_[1]->{uri_out};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri_out}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare_tunnel3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_in'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_in} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);

    # Deserializing field: 'dom_xml'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare_tunnel3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_in'
    croak "Missing required input value 'cookie_in'"
        unless exists $_[1]->{cookie_in};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_in};
    do {
        my $len = length $_[1]->{cookie_in};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_in};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;

    # Serializing field: 'dom_xml'
    croak "Missing required input value 'dom_xml'"
        unless exists $_[1]->{dom_xml};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dom_xml}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_prepare_tunnel3_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_out'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_out} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_prepare_tunnel3_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_out'
    croak "Missing required input value 'cookie_out'"
        unless exists $_[1]->{cookie_out};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_out};
    do {
        my $len = length $_[1]->{cookie_out};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_out};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_perform3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'xmlin'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{xmlin}, $_[2], $_[3] );

    # Deserializing field: 'cookie_in'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_in} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'dconnuri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dconnuri}, $_[2], $_[3] );

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'bandwidth'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{bandwidth} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_perform3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'xmlin'
    croak "Missing required input value 'xmlin'"
        unless exists $_[1]->{xmlin};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{xmlin}, $_[2], $_[3] );

    # Serializing field: 'cookie_in'
    croak "Missing required input value 'cookie_in'"
        unless exists $_[1]->{cookie_in};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_in};
    do {
        my $len = length $_[1]->{cookie_in};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_in};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'dconnuri'
    croak "Missing required input value 'dconnuri'"
        unless exists $_[1]->{dconnuri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dconnuri}, $_[2], $_[3] );

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'bandwidth'
    croak "Missing required input value 'bandwidth'"
        unless exists $_[1]->{bandwidth};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{bandwidth};
    die "Out of bounds 'unsigned hyper': $_[1]->{bandwidth}"
        unless (0 <= $_[1]->{bandwidth}
                and $_[1]->{bandwidth} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{bandwidth}"
        unless int($_[1]->{bandwidth}) == $_[1]->{bandwidth};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{bandwidth});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_perform3_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'cookie_out'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_out} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_perform3_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'cookie_out'
    croak "Missing required input value 'cookie_out'"
        unless exists $_[1]->{cookie_out};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_out};
    do {
        my $len = length $_[1]->{cookie_out};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_out};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dname'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Deserializing field: 'cookie_in'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_in} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'dconnuri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{dconnuri}, $_[2], $_[3] );

    # Deserializing field: 'uri'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'cancelled'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cancelled} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cancelled}"
        unless (-2147483648 <= $_[1]->{cancelled} and $_[1]->{cancelled} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dname'
    croak "Missing required input value 'dname'"
        unless exists $_[1]->{dname};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_string( $_[1]->{dname}, $_[2], $_[3] );

    # Serializing field: 'cookie_in'
    croak "Missing required input value 'cookie_in'"
        unless exists $_[1]->{cookie_in};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_in};
    do {
        my $len = length $_[1]->{cookie_in};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_in};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'dconnuri'
    croak "Missing required input value 'dconnuri'"
        unless exists $_[1]->{dconnuri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{dconnuri}, $_[2], $_[3] );

    # Serializing field: 'uri'
    croak "Missing required input value 'uri'"
        unless exists $_[1]->{uri};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_string( $_[1]->{uri}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'cancelled'
    croak "Missing required input value 'cancelled'"
        unless exists $_[1]->{cancelled};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cancelled};
    die "Out of bounds 'int': $_[1]->{cancelled}"
        unless (-2147483648 <= $_[1]->{cancelled} and $_[1]->{cancelled} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cancelled}"
        unless int($_[1]->{cancelled}) == $_[1]->{cancelled};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cancelled});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_finish3_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'cookie_out'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_out} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_finish3_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'cookie_out'
    croak "Missing required input value 'cookie_out'"
        unless exists $_[1]->{cookie_out};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_out};
    do {
        my $len = length $_[1]->{cookie_out};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_out};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_migrate_confirm3_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'cookie_in'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);
        die "Input buffer too short"
            if ($input_length - $_[2]) < $len;
        $_[1]->{cookie_in} = substr( $_[3], $_[2], $len );
        $_[2] += $len + ((4 - ($len % 4)) % 4); # skip padding too
    };

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{flags} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);

    # Deserializing field: 'cancelled'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{cancelled} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{cancelled}"
        unless (-2147483648 <= $_[1]->{cancelled} and $_[1]->{cancelled} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_migrate_confirm3_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'cookie_in'
    croak "Missing required input value 'cookie_in'"
        unless exists $_[1]->{cookie_in};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'opaque' value"
        unless defined $_[1]->{cookie_in};
    do {
        my $len = length $_[1]->{cookie_in};
        die "Opaque data too long (max: 4194304): $len"
            unless ($len <= 4194304);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        substr( $_[3], $_[2] ) = $_[1]->{cookie_in};
        $_[2] += $len;
        if (my $pad = ((4 - ($len % 4)) % 4)) {
            substr( $_[3], $_[2] ) = ("\0" x $pad);
            $_[2] += $pad;
        }
    };

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned hyper': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags}
                and $_[1]->{flags} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{flags});
    $_[2] += 8;

    # Serializing field: 'cancelled'
    croak "Missing required input value 'cancelled'"
        unless exists $_[1]->{cancelled};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{cancelled};
    die "Out of bounds 'int': $_[1]->{cancelled}"
        unless (-2147483648 <= $_[1]->{cancelled} and $_[1]->{cancelled} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{cancelled}"
        unless int($_[1]->{cancelled}) == $_[1]->{cancelled};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{cancelled});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_control_error_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_control_error_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_event_callback_control_error_msg {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'callbackID'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{callbackID} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);

    # Deserializing field: 'msg'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_domain_event_control_error_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_event_callback_control_error_msg {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'callbackID'
    croak "Missing required input value 'callbackID'"
        unless exists $_[1]->{callbackID};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{callbackID};
    die "Out of bounds 'int': $_[1]->{callbackID}"
        unless (-2147483648 <= $_[1]->{callbackID} and $_[1]->{callbackID} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{callbackID}"
        unless int($_[1]->{callbackID}) == $_[1]->{callbackID};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{callbackID});
    $_[2] += 4;

    # Serializing field: 'msg'
    croak "Missing required input value 'msg'"
        unless exists $_[1]->{msg};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_domain_event_control_error_msg( $_[1]->{msg}, $_[2], $_[3] );
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_control_info_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_control_info_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_control_info_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'state'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{state} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 4294967295);

    # Deserializing field: 'details'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{details} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{details}"
        unless (0 <= $_[1]->{details} and $_[1]->{details} <= 4294967295);

    # Deserializing field: 'stateTime'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{stateTime} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{stateTime}"
        unless (0 <= $_[1]->{stateTime}
                and $_[1]->{stateTime} <= 18446744073709551615);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_control_info_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'state'
    croak "Missing required input value 'state'"
        unless exists $_[1]->{state};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{state};
    die "Out of bounds 'unsigned int': $_[1]->{state}"
        unless (0 <= $_[1]->{state} and $_[1]->{state} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{state}"
        unless int($_[1]->{state}) == $_[1]->{state};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{state});
    $_[2] += 4;

    # Serializing field: 'details'
    croak "Missing required input value 'details'"
        unless exists $_[1]->{details};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{details};
    die "Out of bounds 'unsigned int': $_[1]->{details}"
        unless (0 <= $_[1]->{details} and $_[1]->{details} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{details}"
        unless int($_[1]->{details}) == $_[1]->{details};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{details});
    $_[2] += 4;

    # Serializing field: 'stateTime'
    croak "Missing required input value 'stateTime'"
        unless exists $_[1]->{stateTime};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{stateTime};
    die "Out of bounds 'unsigned hyper': $_[1]->{stateTime}"
        unless (0 <= $_[1]->{stateTime}
                and $_[1]->{stateTime} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{stateTime}"
        unless int($_[1]->{stateTime}) == $_[1]->{stateTime};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{stateTime});
    $_[2] += 8;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_open_graphics_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'idx'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{idx} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{idx}"
        unless (0 <= $_[1]->{idx} and $_[1]->{idx} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_open_graphics_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'idx'
    croak "Missing required input value 'idx'"
        unless exists $_[1]->{idx};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{idx};
    die "Out of bounds 'unsigned int': $_[1]->{idx}"
        unless (0 <= $_[1]->{idx} and $_[1]->{idx} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{idx}"
        unless int($_[1]->{idx}) == $_[1]->{idx};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{idx});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_open_graphics_fd_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'idx'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{idx} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{idx}"
        unless (0 <= $_[1]->{idx} and $_[1]->{idx} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_open_graphics_fd_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'idx'
    croak "Missing required input value 'idx'"
        unless exists $_[1]->{idx};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{idx};
    die "Out of bounds 'unsigned int': $_[1]->{idx}"
        unless (0 <= $_[1]->{idx} and $_[1]->{idx} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{idx}"
        unless int($_[1]->{idx}) == $_[1]->{idx};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{idx});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_suspend_for_duration_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'target'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{target} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{target}"
        unless (0 <= $_[1]->{target} and $_[1]->{target} <= 4294967295);

    # Deserializing field: 'duration'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 8;
    $_[1]->{duration} = unpack("Q>", substr( $_[3], $_[2] ));
    $_[2] += 8;
    die "Out of bounds 'unsigned hyper': $_[1]->{duration}"
        unless (0 <= $_[1]->{duration}
                and $_[1]->{duration} <= 18446744073709551615);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_node_suspend_for_duration_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'target'
    croak "Missing required input value 'target'"
        unless exists $_[1]->{target};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{target};
    die "Out of bounds 'unsigned int': $_[1]->{target}"
        unless (0 <= $_[1]->{target} and $_[1]->{target} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{target}"
        unless int($_[1]->{target}) == $_[1]->{target};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{target});
    $_[2] += 4;

    # Serializing field: 'duration'
    croak "Missing required input value 'duration'"
        unless exists $_[1]->{duration};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned long' value"
        unless defined $_[1]->{duration};
    die "Out of bounds 'unsigned hyper': $_[1]->{duration}"
        unless (0 <= $_[1]->{duration}
                and $_[1]->{duration} <= 18446744073709551615);
    die "Non-integer 'long' value given: $_[1]->{duration}"
        unless int($_[1]->{duration}) == $_[1]->{duration};
    substr( $_[3], $_[2] ) = pack("Q>", $_[1]->{duration});
    $_[2] += 8;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_shutdown_flags_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_shutdown_flags_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_disk_errors_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'dom'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Deserializing field: 'maxerrors'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{maxerrors} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{maxerrors}"
        unless (0 <= $_[1]->{maxerrors} and $_[1]->{maxerrors} <= 4294967295);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_disk_errors_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'dom'
    croak "Missing required input value 'dom'"
        unless exists $_[1]->{dom};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_domain( $_[1]->{dom}, $_[2], $_[3] );

    # Serializing field: 'maxerrors'
    croak "Missing required input value 'maxerrors'"
        unless exists $_[1]->{maxerrors};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{maxerrors};
    die "Out of bounds 'unsigned int': $_[1]->{maxerrors}"
        unless (0 <= $_[1]->{maxerrors} and $_[1]->{maxerrors} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{maxerrors}"
        unless int($_[1]->{maxerrors}) == $_[1]->{maxerrors};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{maxerrors});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_domain_get_disk_errors_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'errors'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 256): $len"
            unless ($len <= 256);
        $_[1]->{errors} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_domain_disk_error( $_[1]->{errors}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'nerrors'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{nerrors} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{nerrors}"
        unless (-2147483648 <= $_[1]->{nerrors} and $_[1]->{nerrors} < 2147483648);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_domain_get_disk_errors_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'errors'
    croak "Missing required input value 'errors'"
        unless exists $_[1]->{errors};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{errors};
    do {
        my $len = scalar @{ $_[1]->{errors} };
        die "Array too long (max: 256): $len"
            unless ($len <= 256);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_domain_disk_error( $_[1]->{errors}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'nerrors'
    croak "Missing required input value 'nerrors'"
        unless exists $_[1]->{nerrors};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{nerrors};
    die "Out of bounds 'int': $_[1]->{nerrors}"
        unless (-2147483648 <= $_[1]->{nerrors} and $_[1]->{nerrors} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{nerrors}"
        unless int($_[1]->{nerrors}) == $_[1]->{nerrors};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{nerrors});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_domains_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_domains_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_domains_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'domains'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{domains} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_domain( $_[1]->{domains}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_domains_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'domains'
    croak "Missing required input value 'domains'"
        unless exists $_[1]->{domains};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{domains};
    do {
        my $len = scalar @{ $_[1]->{domains} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_domain( $_[1]->{domains}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_storage_pools_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_storage_pools_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_storage_pools_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pools'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{pools} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pools}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_storage_pools_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pools'
    croak "Missing required input value 'pools'"
        unless exists $_[1]->{pools};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{pools};
    do {
        my $len = scalar @{ $_[1]->{pools} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_storage_pool( $_[1]->{pools}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_list_all_volumes_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'pool'
    # my ($class, $value, $index, $input) = @_;
    $_[0]->deserialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_list_all_volumes_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'pool'
    croak "Missing required input value 'pool'"
        unless exists $_[1]->{pool};
    # my ($class, $value, $index, $output) = @_;
    $_[0]->serialize_nonnull_storage_pool( $_[1]->{pool}, $_[2], $_[3] );

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_storage_pool_list_all_volumes_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'vols'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{vols} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_storage_vol( $_[1]->{vols}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_storage_pool_list_all_volumes_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'vols'
    croak "Missing required input value 'vols'"
        unless exists $_[1]->{vols};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{vols};
    do {
        my $len = scalar @{ $_[1]->{vols} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_storage_vol( $_[1]->{vols}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_networks_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_networks_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_networks_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'nets'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{nets} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_network( $_[1]->{nets}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_networks_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'nets'
    croak "Missing required input value 'nets'"
        unless exists $_[1]->{nets};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{nets};
    do {
        my $len = scalar @{ $_[1]->{nets} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_network( $_[1]->{nets}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_interfaces_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_interfaces_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_interfaces_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'ifaces'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{ifaces} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_interface( $_[1]->{ifaces}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_interfaces_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'ifaces'
    croak "Missing required input value 'ifaces'"
        unless exists $_[1]->{ifaces};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{ifaces};
    do {
        my $len = scalar @{ $_[1]->{ifaces} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_interface( $_[1]->{ifaces}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_node_devices_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_node_devices_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_node_devices_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'devices'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);
        $_[1]->{devices} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_node_device( $_[1]->{devices}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_node_devices_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'devices'
    croak "Missing required input value 'devices'"
        unless exists $_[1]->{devices};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{devices};
    do {
        my $len = scalar @{ $_[1]->{devices} };
        die "Array too long (max: 65536): $len"
            unless ($len <= 65536);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_node_device( $_[1]->{devices}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_nwfilters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_nwfilters_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_nwfilters_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'filters'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{filters} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_nwfilter( $_[1]->{filters}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_nwfilters_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'filters'
    croak "Missing required input value 'filters'"
        unless exists $_[1]->{filters};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{filters};
    do {
        my $len = scalar @{ $_[1]->{filters} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_nwfilter( $_[1]->{filters}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_secrets_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'need_results'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{need_results} = unpack("l>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);

    # Deserializing field: 'flags'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{flags} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_secrets_args {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'need_results'
    croak "Missing required input value 'need_results'"
        unless exists $_[1]->{need_results};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'int' value"
        unless defined $_[1]->{need_results};
    die "Out of bounds 'int': $_[1]->{need_results}"
        unless (-2147483648 <= $_[1]->{need_results} and $_[1]->{need_results} < 2147483648);
    die "Non-integer 'int' value given: $_[1]->{need_results}"
        unless int($_[1]->{need_results}) == $_[1]->{need_results};
    substr( $_[3], $_[2] ) = pack("l>", $_[1]->{need_results});
    $_[2] += 4;

    # Serializing field: 'flags'
    croak "Missing required input value 'flags'"
        unless exists $_[1]->{flags};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{flags};
    die "Out of bounds 'unsigned int': $_[1]->{flags}"
        unless (0 <= $_[1]->{flags} and $_[1]->{flags} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{flags}"
        unless int($_[1]->{flags}) == $_[1]->{flags};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{flags});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_connect_list_all_secrets_ret {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'secrets'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);
        $_[1]->{secrets} = [];
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $input) = @_;
            $_[0]->deserialize_nonnull_secret( $_[1]->{secrets}->[$i1], $_[2], $_[3] );
        }
    };

    # Deserializing field: 'ret'
    # my ($class, $value, $index, $input) = @_;
    die "Input buffer too short"
        if ($input_length - $_[2]) < 4;
    $_[1]->{ret} = unpack("L>", substr( $_[3], $_[2] ));
    $_[2] += 4;
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
}
# @_: ($class, $value, $index, $output) = @_;
sub serialize_connect_list_all_secrets_ret {
    croak "Missing required input 'struct' value"
        unless defined $_[1];

    # Serializing field: 'secrets'
    croak "Missing required input value 'secrets'"
        unless exists $_[1]->{secrets};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'array' value"
        unless defined $_[1]->{secrets};
    do {
        my $len = scalar @{ $_[1]->{secrets} };
        die "Array too long (max: 16384): $len"
            unless ($len <= 16384);

        substr( $_[3], $_[2] ) = pack("L>", $len);
        $_[2] += 4;
        for my $i1 ( 0 .. ($len - 1) ) {
            # my ($class, $value, $index, $output) = @_;
            $_[0]->serialize_nonnull_secret( $_[1]->{secrets}->[$i1], $_[2], $_[3] );
        }
    };

    # Serializing field: 'ret'
    croak "Missing required input value 'ret'"
        unless exists $_[1]->{ret};
    # my ($class, $value, $index, $output) = @_;
    croak "Missing required input 'unsigned int' value"
        unless defined $_[1]->{ret};
    die "Out of bounds 'unsigned int': $_[1]->{ret}"
        unless (0 <= $_[1]->{ret} and $_[1]->{ret} <= 4294967295);
    die "Non-integer 'int' value given: $_[1]->{ret}"
        unless int($_[1]->{ret}) == $_[1]->{ret};
    substr( $_[3], $_[2] ) = pack("L>", $_[1]->{ret});
    $_[2] += 4;
}
# @_: ($class, $value, $index, $input) = @_;
sub deserialize_node_set_memory_parameters_args {
    my $input_length = length $_[3];
    $_[1] = {};
    # Deserializing field: 'params'
    # my ($class, $value, $index, $input) = @_;
    do {
        die "Input buffer too short"
            if ($input_length - $_[2]) < 4;
        my $len = unpack("L>", substr( $_[3], $_[2] ));
        $_[2] += 4;

        die "Array too long (