
use ExtUtils::MakeMaker;
use strict;

my @MLPODFILES = qw( bin/mlpod2html.mlpod
                     bin/mlpod2pod.mlpod
                     lib/Pod/MultiLang.mlpod
                     lib/Pod/MultiLang/Dict.mlpod
                     lib/Pod/MultiLang/Dict/ja.mlpod
                     lib/Pod/MultiLang/Html.mlpod
                     lib/Pod/MultiLang/Pod.mlpod
                    );

my $pod_refresh = q{find lib -name '*.mlpod' | while read f; do d=`dirname $f`/`basename $f .mlpod`; perl -Ilib bin/mlpod2pod --langs=ja $d.mlpod >  "${d}_ja.pod"; done};
$pod_refresh =~ s/\$/\$\$/g;

my %ATTR = 
(
  NAME         => 'Pod::MultiLang',
  VERSION_FROM => 'lib/Pod/MultiLang.pm',
  EXE_FILES    => [qw(bin/mlpod2html bin/mlpod2pod bin/mlpod2html.mlpod bin/mlpod2pod.mlpod)],
  depend       => {
                   '.SUFFIXES' => '.mlpod .pod',
                   '.mlpod.pod' => ';$(PERLRUNINST) bin/mlpod2pod $< > $@',
                   'pod-refresh' => ";$pod_refresh",
                  },
);
mlpodconvertion(\%ATTR,@MLPODFILES);
WriteMakefile(%ATTR);

# -----------------------------------------------------------------------------
# 
sub mlpodconvertion
{
  my $ATTR = shift;
  my $CP = '$(PERLRUNINST) -MExtUtils::Command -e cp ';
  my @clean_FILES;
  defined($ATTR->{clean}{FILES}) and push(@clean_FILES,$ATTR->{clean}{FILES});
  foreach(@MLPODFILES)
  {
    # *.mlpod           (src)
    # => *.pod          (auto gen)
    #  => $(INST)*.pod  (blib)
    #   => $(INST)*.man (blib)
    
    my $mlpod = $_;
    (my $mlpod_basename = $mlpod) =~ s/\.mlpod$//;
    
    # man section.
    my ($mannum, $pod2man, $mansect)
      = /^bin\// ? (1, 'MAN1PODS', '1')
      : /^lib\// ? (3, 'MAN3PODS', '3pm')
      :            die "category unknown [$_]"
      ;
    
    # man name.
    # bin/mlpod2pod.mlpod     => mlpod2pod
    # lib/Pod/MultiLang.mlpod => Pod::MultiLang
    my $manname = $_;
    $manname =~ s/^(bin|lib)\///;
    $manname =~ s/\.\w+$//;
    $manname =~ s/\//::/g;
    
    my $instpod_base = $mlpod_basename;
    $instpod_base =~ s/bin/\$(INST_SCRIPT)/;
    $instpod_base =~ s/lib/\$(INST_LIB)/;
    
    my $ja_builder = '$(PERLRUNINST) bin/mlpod2pod --langs=ja $< > $@';
    my $builder = { _ja => "; $ja_builder", };
    foreach my $lang ('', '_ja')
    {
      # lib/*.mlpod ==> lib/*.pod
      my $pod = $mlpod_basename . $lang . '.pod';
      my $bld = $builder->{$lang} || '';
      $ATTR->{depend}{$pod} = $mlpod . $bld;
      
      # {bin/lib}/*.pod ==> blib/{script/lib}/*.pod
      my $instpod = $instpod_base . $lang . '.pod';
      $ATTR->{depend}{$instpod} = "$pod; $CP \$< \$\@";
      
      # blib/*.pod ==> blib/man*
      my $man = "\$(INST_MAN${mannum}DIR)/${manname}$lang.${mansect}";
      $ATTR->{$pod2man}{$instpod} = $man;
      
      #print "\n";
      #print "$mlpod\n";
      #print "  $mlpod ==> $pod$bld\n";
      #print "  $pod ==> $instpod\n";
      #print "  $instpod ==> $man\n";
    }
  }
  $ATTR->{clean}{FILES} = join(' ',@clean_FILES);
  $ATTR;
}
