use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my $extra_libs = $ENV{EXTRALIBS};
my $libs = "$extra_libs -lrpm -lrpmdb -lrpmio -lpopt";
my $include = "-I/usr/include";

# try to be smart about which shared libs we should load.
# use the .la file.  probably linux only.

my $filename = '/usr/lib/librpm.la';
$filename = '/usr/lib64/librpm.la' unless -e $filename;

if (open FH, "<$filename") {
  my ($line, @rest) = grep { /^dependency_libs=/ } <FH>;
  if ($line and not @rest) {
    if ($line =~ /^dependency_libs='(.*)'$/) {
      my $l = $1;
      my @l = split /\s+/, $l;
      @l = grep { /^-l/ } @l;
      $libs = "$libs -lrpm @l";
    }
  }
}

my @defines;

# detect which rpm is running.  ugly but necessary... for now.
# ^^^ (Poor you, if only you knew I'll make it much worse -- lkundrak)
my ($major, $minor) = (4,0);
if (`pkg-config rpm --modversion 2>/dev/null` =~ /^(\d+)\.(\d+).*/) {
  ($major, $minor) = ($1, $2);
  if ($major >= 4 and $minor >= 9) {
    ($major, $minor) = (4,9)
  } elsif ($major >= 4 and $minor >= 6) {
    ($major, $minor) = (4,6)
  }
}
elsif (-e '/usr/include/rpm/rpmts.h') {
  ($major, $minor) = (4,1)
}

`pkg-config rpm --libs 2>/dev/null` =~ /(.+)/ and $libs = $1;
`pkg-config rpm --cflags-only-I 2>/dev/null` =~ /(.+)/ and $include = $1;

push @defines, "-DRPM2_RPM$major$minor";
push @defines, sprintf "-DRPM2_API=%i%03i", $major, $minor;

WriteMakefile(
    'NAME'		=> 'RPM2',
    'VERSION_FROM'	=> 'RPM2.pm', # finds $VERSION
    'PREREQ_PM'		=> {}, # e.g., Module::Name => 1.1
    'LIBS'		=> [ $libs ], # e.g., '-lm'
    'DEFINE'		=> join(" ", @defines), # e.g., '-DHAVE_SOMETHING'
    'INC'		=> $include, # e.g., '-I/usr/include/other'
    'TYPEMAPS'          => [ 'typemap' ],
    'OPTIMIZE'          => '-g'
);
