# Generated by default/object.tt
package Paws::RedShift::PartnerIntegrationInfo;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str');
  has DatabaseName => (is => 'ro', isa => 'Str');
  has PartnerName => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');
  has StatusMessage => (is => 'ro', isa => 'Str');
  has UpdatedAt => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::RedShift::PartnerIntegrationInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::RedShift::PartnerIntegrationInfo object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::RedShift::PartnerIntegrationInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

Describes a partner integration.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

The date (UTC) that the partner integration was created.


=head2 DatabaseName => Str

The name of the database that receives data from a partner.


=head2 PartnerName => Str

The name of the partner.


=head2 Status => Str

The partner integration status.


=head2 StatusMessage => Str

The status message provided by the partner.


=head2 UpdatedAt => Str

The date (UTC) that the partner integration status was last updated by
the partner.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::RedShift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

