#!perl
use 5.006;
use strict;
use warnings;
use Test::More;

our $VERSION = '0.05';

use GCC::Builtins qw/:all/;

my $res = powif(2.56,2);
my $expected = "6.55359983444214";
if( $expected =~ /^([+-]?)(?=\d|\.\d)\d*(\.\d*)?([Ee]([+-]?\d+))?$/ ){
	my $dif = abs($res-$expected);
	ok($dif<1e-09, "called powif(2.56,2) returned ($res) and expected ($expected) values differ ($dif) by less than 1e-09.");
} else {
	is($res, $expected, "called powif(2.56,2) returned ($res) and expected ($expected) values are identical.");
}
diag("copy-this-expected-value 'powif' => '$res',");

done_testing();
