/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import java.util.Set;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.PrimitiveUType;
import net.sf.saxon.type.UType;
import net.sf.saxon.z.IntHashMap;

public final class AxisInfo {
    public static final byte ANCESTOR = 0;
    public static final byte ANCESTOR_OR_SELF = 1;
    public static final byte ATTRIBUTE = 2;
    public static final byte CHILD = 3;
    public static final byte DESCENDANT = 4;
    public static final byte DESCENDANT_OR_SELF = 5;
    public static final byte FOLLOWING = 6;
    public static final byte FOLLOWING_SIBLING = 7;
    public static final byte NAMESPACE = 8;
    public static final byte PARENT = 9;
    public static final byte PRECEDING = 10;
    public static final byte PRECEDING_SIBLING = 11;
    public static final byte SELF = 12;
    public static final byte PRECEDING_OR_ANCESTOR = 13;
    public static final short[] principalNodeType = new short[]{1, 1, 2, 1, 1, 1, 1, 1, 13, 1, 1, 1, 1, 1};
    public static final UType[] principalNodeUType = new UType[]{UType.ELEMENT, UType.ELEMENT, UType.ATTRIBUTE, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT, UType.NAMESPACE, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT, UType.ELEMENT};
    public static final boolean[] isForwards = new boolean[]{false, false, true, true, true, true, true, true, true, true, false, false, true, false};
    public static final boolean[] isPeerAxis = new boolean[]{false, false, true, true, false, false, false, true, true, true, false, true, true, false};
    public static final boolean[] isSubtreeAxis = new boolean[]{false, false, true, true, true, true, false, false, true, false, false, false, true, false};
    public static final String[] axisName = new String[]{"ancestor", "ancestor-or-self", "attribute", "child", "descendant", "descendant-or-self", "following", "following-sibling", "namespace", "parent", "preceding", "preceding-sibling", "self", "preceding-or-ancestor"};
    private static final int DOC = 512;
    private static final int ELE = 2;
    private static final int ATT = 4;
    private static final int TEX = 8;
    private static final int PIN = 128;
    private static final int COM = 256;
    private static final int NAM = 8192;
    private static int[] voidAxisTable = new int[]{512, 0, 9100, 8588, 8588, 0, 512, 8708, 9100, 512, 512, 8708, 0};
    private static int[] nodeKindTable = new int[]{514, 9102, 4, 394, 394, 9102, 394, 394, 8192, 514, 394, 394, 9102};
    public static byte[] inverseAxis = new byte[]{4, 5, 9, 9, 0, 1, 10, 11, 9, 3, 6, 7, 12};
    public static byte[] excludeSelfAxis = new byte[]{0, 0, 2, 3, 4, 4, 6, 7, 8, 9, 10, 11, 12};
    private static IntHashMap<UType> axisTransitions = new IntHashMap(50);

    private AxisInfo() {
    }

    public static byte getAxisNumber(String name) throws XPathException {
        switch (name.length()) {
            case 4: {
                if (!name.equals("self")) break;
                return 12;
            }
            case 5: {
                if (!name.equals("child")) break;
                return 3;
            }
            case 6: {
                if (!name.equals("parent")) break;
                return 9;
            }
            case 8: {
                if (!name.equals("ancestor")) break;
                return 0;
            }
            case 9: {
                if (name.equals("attribute")) {
                    return 2;
                }
                if (name.equals("following")) {
                    return 6;
                }
                if (name.equals("namespace")) {
                    return 8;
                }
                if (!name.equals("preceding")) break;
                return 10;
            }
            case 10: {
                if (!name.equals("descendant")) break;
                return 4;
            }
            case 16: {
                if (!name.equals("ancestor-or-self")) break;
                return 1;
            }
            case 17: {
                if (name.equals("following-sibling")) {
                    return 7;
                }
                if (!name.equals("preceding-sibling")) break;
                return 11;
            }
            case 18: {
                if (!name.equals("descendant-or-self")) break;
                return 5;
            }
        }
        throw new XPathException("Unknown axis name: " + name);
    }

    public static boolean isAlwaysEmpty(int axis, int nodeKind) {
        return (voidAxisTable[axis] & 1 << nodeKind) != 0;
    }

    public static boolean containsNodeKind(int axis, int nodeKind) {
        return nodeKind == 0 || (nodeKindTable[axis] & 1 << nodeKind) != 0;
    }

    private static void e(PrimitiveUType origin, byte axis, UType target) {
        axisTransitions.put(AxisInfo.makeKey(origin, axis), target);
    }

    private static int makeKey(PrimitiveUType origin, byte axis) {
        return origin.getBit() << 16 | axis;
    }

    public static UType getTargetUType(UType origin, byte axis) {
        UType resultType = UType.VOID;
        Set<PrimitiveUType> origins = origin.intersection(UType.ANY_NODE).decompose();
        for (PrimitiveUType u : origins) {
            UType r = axisTransitions.get(AxisInfo.makeKey(u, axis));
            resultType = resultType.union(r);
        }
        return resultType;
    }

    static {
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)0, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)1, UType.DOCUMENT);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)3, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)4, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)5, UType.DOCUMENT.union(UType.CHILD_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)6, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)7, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)9, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)10, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)11, UType.VOID);
        AxisInfo.e(PrimitiveUType.DOCUMENT, (byte)12, UType.DOCUMENT);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)1, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)2, UType.ATTRIBUTE);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)3, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)4, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)5, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)7, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)8, UType.NAMESPACE);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)9, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)11, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ELEMENT, (byte)12, UType.ELEMENT);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)1, UType.ATTRIBUTE.union(UType.PARENT_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)3, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)4, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)5, UType.ATTRIBUTE);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)7, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)9, UType.ELEMENT);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)11, UType.VOID);
        AxisInfo.e(PrimitiveUType.ATTRIBUTE, (byte)12, UType.ATTRIBUTE);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)1, UType.TEXT.union(UType.PARENT_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.TEXT, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)3, UType.VOID);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)4, UType.VOID);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)5, UType.TEXT);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)7, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)9, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)11, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.TEXT, (byte)12, UType.TEXT);
        AxisInfo.e(PrimitiveUType.PI, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)1, UType.PI.union(UType.PARENT_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.PI, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.PI, (byte)3, UType.VOID);
        AxisInfo.e(PrimitiveUType.PI, (byte)4, UType.VOID);
        AxisInfo.e(PrimitiveUType.PI, (byte)5, UType.PI);
        AxisInfo.e(PrimitiveUType.PI, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)7, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.PI, (byte)9, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)11, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.PI, (byte)12, UType.PI);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)1, UType.COMMENT.union(UType.PARENT_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)3, UType.VOID);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)4, UType.VOID);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)5, UType.COMMENT);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)7, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)9, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)11, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.COMMENT, (byte)12, UType.COMMENT);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)0, UType.PARENT_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)1, UType.NAMESPACE.union(UType.PARENT_NODE_KINDS));
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)2, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)3, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)4, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)5, UType.NAMESPACE);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)6, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)7, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)8, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)9, UType.ELEMENT);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)10, UType.CHILD_NODE_KINDS);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)11, UType.VOID);
        AxisInfo.e(PrimitiveUType.NAMESPACE, (byte)12, UType.NAMESPACE);
    }
}

