#!/usr/bin/perl -w

require 5.003;	# keep this compatible, an old perl is all we may have before
                # we build the new one

#
# See database of global and static function prototypes at the __END__.
# This is used to generate prototype headers under various configurations,
# export symbols lists for different platforms, and macros to provide an
# implicit interpreter context argument.
#

my $END = tell DATA;

# walk table providing an array of components in each line to
# subroutine, printing the result
sub walk_table (&@) {
    my $function = shift;
    my $filename = shift || '-';
    my $leader = shift;
    my $trailer = shift;
    my $F;
    local *F;
    if (ref $filename) {	# filehandle
	$F = $filename;
    }
    else {
	open F, ">$filename" or die "Can't open $filename: $!";
	$F = \*F;
    }
    print $F $leader if $leader;
    seek DATA, $END, 0;		# so we may restart
    while (<DATA>) {
	chomp;
	next if /^:/;
	while (s|\\$||) {
	    $_ .= <DATA>;
	    chomp;
	}
	my @args;
	if (/^\s*(#|$)/) {
	    @args = $_;
	}
	else {
	    @args = split /\s*\|\s*/, $_;
	}
	print $F $function->(@args);
    }
    print $F $trailer if $trailer;
    close $F unless ref $filename;
}

sub munge_c_files () {
    my $functions = {};
    unless (@ARGV) {
        warn "\@ARGV empty, nothing to do\n";
	return;
    }
    walk_table {
	if (@_ > 1) {
	    $functions->{$_[2]} = \@_ if $_[@_-1] =~ /\.\.\./;
	}
    } '/dev/null';
    local $^I = '.bak';
    while (<>) {
#	if (/^#\s*include\s+"perl.h"/) {
#	    my $file = uc $ARGV;
#	    $file =~ s/\./_/g;
#	    print "#define PERL_IN_$file\n";
#	}
#	s{^(\w+)\s*\(}
#	 {
#	    my $f = $1;
#	    my $repl = "$f(";
#	    if (exists $functions->{$f}) {
#		my $flags = $functions->{$f}[0];
#		$repl = "Perl_$repl" if $flags =~ /p/;
#		unless ($flags =~ /n/) {
#		    $repl .= "pTHX";
#		    $repl .= "_ " if @{$functions->{$f}} > 3;
#		}
#		warn("$ARGV:$.:$repl\n");
#	    }
#	    $repl;
#	 }e;
	s{(\b(\w+)[ \t]*\([ \t]*(?!aTHX))}
	 {
	    my $repl = $1;
	    my $f = $2;
	    if (exists $functions->{$f}) {
		$repl .= "aTHX_ ";
		warn("$ARGV:$.:$`#$repl#$'");
	    }
	    $repl;
	 }eg;
	print;
	close ARGV if eof;	# restart $.
    }
    exit;
}

#munge_c_files();

# generate proto.h
my $wrote_protected = 0;

sub write_protos {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n";
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	if ($flags =~ /s/) {
	    $retval = "STATIC $retval";
	    $func = "S_$func";
	}
	else {
	    $retval = "PERL_CALLCONV $retval";
	    if ($flags =~ /p/) {
		$func = "Perl_$func";
	    }
	}
	$ret .= "$retval\t$func(";
	unless ($flags =~ /n/) {
	    $ret .= "pTHX";
	    $ret .= "_ " if @args;
	}
	if (@args) {
	    $ret .= join ", ", @args;
	}
	else {
	    $ret .= "void" if $flags =~ /n/;
	}
	$ret .= ")";
	$ret .= " __attribute__((noreturn))" if $flags =~ /r/;
	if( $flags =~ /f/ ) { 
	    my $prefix = $flags =~ /n/ ? '' : 'pTHX_';
	    my $args = scalar @args; 
	    $ret .= "\n#ifdef CHECK_FORMAT\n";
	    $ret .= sprintf " __attribute__((format(printf,%s%d,%s%d)))",
				    $prefix, $args - 1, $prefix, $args; 
	    $ret .= "\n#endif\n";
	}
	$ret .= ";\n";
    }
    $ret;
}

# generates global.sym (API export list), and populates %global with global symbols
sub write_global_sym {
    my $ret = "";
    if (@_ > 1) {
	my ($flags,$retval,$func,@args) = @_;
	if ($flags =~ /A/ && $flags !~ /x/) { # public API, so export
	    $func = "Perl_$func" if $flags =~ /p/;
	    $ret = "$func\n";
	}
    }
    $ret;
}


walk_table(\&write_protos, 'proto.h', <<'EOT');
/*
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is autogenerated from data in embed.pl.  Edit that file
 * and run 'make regen_headers' to effect changes.
 */

EOT

walk_table(\&write_global_sym, 'global.sym', <<'EOT');
#
# !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
# This file is autogenerated from data in embed.pl.  Edit that file
# and run 'make regen_headers' to effect changes.
#

EOT

# XXX others that may need adding
#       warnhook
#       hints
#       copline
my @extvars = qw(sv_undef sv_yes sv_no na dowarn
                 curcop compiling 
                 tainting tainted stack_base stack_sp sv_arenaroot
		 no_modify
                 curstash DBsub DBsingle debstash
                 rsfp 
                 stdingv
		 defgv
		 errgv
		 rsfp_filters
		 perldb
		 diehook
		 dirty
		 perl_destruct_level
                );

sub readsyms (\%$) {
    my ($syms, $file) = @_;
    local (*FILE, $_);
    open(FILE, "< $file")
	or die "embed.pl: Can't open $file: $!\n";
    while (<FILE>) {
	s/[ \t]*#.*//;		# Delete comments.
	if (/^\s*(\S+)\s*$/) {
	    my $sym = $1;
	    warn "duplicate symbol $sym while processing $file\n"
		if exists $$syms{$sym};
	    $$syms{$sym} = 1;
	}
    }
    close(FILE);
}

# Perl_pp_* and Perl_ck_* are in pp.sym
readsyms my %ppsym, 'pp.sym';

sub readvars(\%$$@) {
    my ($syms, $file,$pre,$keep_pre) = @_;
    local (*FILE, $_);
    open(FILE, "< $file")
	or die "embed.pl: Can't open $file: $!\n";
    while (<FILE>) {
	s/[ \t]*#.*//;		# Delete comments.
	if (/PERLVARA?I?C?\($pre(\w+)/) {
	    my $sym = $1;
	    $sym = $pre . $sym if $keep_pre;
	    warn "duplicate symbol $sym while processing $file\n"
		if exists $$syms{$sym};
	    $$syms{$sym} = $pre || 1;
	}
    }
    close(FILE);
}

my %intrp;
my %thread;

readvars %intrp,  'intrpvar.h','I';
readvars %thread, 'thrdvar.h','T';
readvars %globvar, 'perlvars.h','G';

foreach my $sym (sort keys %thread) {
  warn "$sym in intrpvar.h as well as thrdvar.h\n" if exists $intrp{$sym};
}

sub undefine ($) {
    my ($sym) = @_;
    "#undef  $sym\n";
}

sub hide ($$) {
    my ($from, $to) = @_;
    my $t = int(length($from) / 8);
    "#define $from" . "\t" x ($t < 3 ? 3 - $t : 1) . "$to\n";
}

sub bincompat_var ($$) {
    my ($pfx, $sym) = @_;
    my $arg = ($pfx eq 'G' ? 'NULL' : 'aTHXo');
    undefine("PL_$sym") . hide("PL_$sym", "(*Perl_${pfx}${sym}_ptr($arg))");
}

sub multon ($$$) {
    my ($sym,$pre,$ptr) = @_;
    hide("PL_$sym", "($ptr$pre$sym)");
}

sub multoff ($$) {
    my ($sym,$pre) = @_;
    return hide("PL_$pre$sym", "PL_$sym");
}

unlink 'embed.h';
open(EM, '> embed.h') or die "Can't create embed.h: $!\n";

print EM <<'END';
/* !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!! 
   This file is built by embed.pl from data in embed.pl, pp.sym, intrpvar.h,
   perlvars.h and thrdvar.h.  Any changes made here will be lost!
*/

/* (Doing namespace management portably in C is really gross.) */

/* NO_EMBED is no longer supported. i.e. EMBED is always active. */

/* provide binary compatible (but inconsistent) names */
#if defined(PERL_BINCOMPAT_5005)
#  define  Perl_call_atexit		perl_atexit
#  define  Perl_eval_sv			perl_eval_sv
#  define  Perl_eval_pv			perl_eval_pv
#  define  Perl_call_argv		perl_call_argv
#  define  Perl_call_method		perl_call_method
#  define  Perl_call_pv			perl_call_pv
#  define  Perl_call_sv			perl_call_sv
#  define  Perl_get_av			perl_get_av
#  define  Perl_get_cv			perl_get_cv
#  define  Perl_get_hv			perl_get_hv
#  define  Perl_get_sv			perl_get_sv
#  define  Perl_init_i18nl10n		perl_init_i18nl10n
#  define  Perl_init_i18nl14n		perl_init_i18nl14n
#  define  Perl_new_collate		perl_new_collate
#  define  Perl_new_ctype		perl_new_ctype
#  define  Perl_new_numeric		perl_new_numeric
#  define  Perl_require_pv		perl_require_pv
#  define  Perl_safesyscalloc		Perl_safecalloc
#  define  Perl_safesysfree		Perl_safefree
#  define  Perl_safesysmalloc		Perl_safemalloc
#  define  Perl_safesysrealloc		Perl_saferealloc
#  define  Perl_set_numeric_local	perl_set_numeric_local
#  define  Perl_set_numeric_standard	perl_set_numeric_standard
/* malloc() pollution was the default in earlier versions, so enable
 * it for bincompat; but not for systems that used to do prevent that,
 * or when they ask for {HIDE,EMBED}MYMALLOC */
#  if !defined(EMBEDMYMALLOC) && !defined(HIDEMYMALLOC)
#    if !defined(NeXT) && !defined(__NeXT) && !defined(__MACHTEN__) && \
        !defined(__QNX__)
#      define  PERL_POLLUTE_MALLOC
#    endif
#  endif
#endif

/* Hide global symbols */

#if !defined(PERL_OBJECT)
#if !defined(PERL_IMPLICIT_CONTEXT)

END

walk_table {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n" if $arg =~ /^#\s*(if|ifn?def|else|endif)\b/;
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	unless ($flags =~ /o/) {
	    if ($flags =~ /s/) {
		$ret .= hide($func,"S_$func");
	    }
	    elsif ($flags =~ /p/) {
		$ret .= hide($func,"Perl_$func");
	    }
	}
    }
    $ret;
} \*EM;

for $sym (sort keys %ppsym) {
    $sym =~ s/^Perl_//;
    print EM hide($sym, "Perl_$sym");
}

print EM <<'END';

#else	/* PERL_IMPLICIT_CONTEXT */

END

my @az = ('a'..'z');

walk_table {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n" if $arg =~ /^#\s*(if|ifn?def|else|endif)\b/;
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	unless ($flags =~ /o/) {
	    my $args = scalar @args;
	    if ($args and $args[$args-1] =~ /\.\.\./) {
	        # we're out of luck for varargs functions under CPP
	    }
	    elsif ($flags =~ /n/) {
		if ($flags =~ /s/) {
		    $ret .= hide($func,"S_$func");
		}
		elsif ($flags =~ /p/) {
		    $ret .= hide($func,"Perl_$func");
		}
	    }
	    else {
		my $alist = join(",", @az[0..$args-1]);
		$ret = "#define $func($alist)";
		my $t = int(length($ret) / 8);
		$ret .=  "\t" x ($t < 4 ? 4 - $t : 1);
		if ($flags =~ /s/) {
		    $ret .= "S_$func(aTHX";
		}
		elsif ($flags =~ /p/) {
		    $ret .= "Perl_$func(aTHX";
		}
		$ret .= "_ " if $alist;
		$ret .= $alist . ")\n";
	    }
	}
    }
    $ret;
} \*EM;

for $sym (sort keys %ppsym) {
    $sym =~ s/^Perl_//;
    if ($sym =~ /^ck_/) {
	print EM hide("$sym(a)", "Perl_$sym(aTHX_ a)");
    }
    elsif ($sym =~ /^pp_/) {
	print EM hide("$sym()", "Perl_$sym(aTHX)");
    }
    else {
	warn "Illegal symbol '$sym' in pp.sym";
    }
}

print EM <<'END';

#endif	/* PERL_IMPLICIT_CONTEXT */
#else	/* PERL_OBJECT */

END

walk_table {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n" if $arg =~ /^#\s*(if|ifn?def|else|endif)\b/;
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	if ($flags =~ /s/) {
	    $ret .= hide("S_$func","CPerlObj::S_$func") if $flags !~ /j/;
	    $ret .= hide($func,"S_$func");
	}
	elsif ($flags =~ /p/) {
	    $ret .= hide("Perl_$func","CPerlObj::Perl_$func") if $flags !~ /j/;
	    $ret .= hide($func,"Perl_$func");
	}
	else {
	    $ret .= hide($func,"CPerlObj::$func") if $flags !~ /j/;
	}
    }
    $ret;
} \*EM;

for $sym (sort keys %ppsym) {
    $sym =~ s/^Perl_//;
    print EM hide("Perl_$sym", "CPerlObj::Perl_$sym");
    print EM hide($sym, "Perl_$sym");
}

print EM <<'END';

#endif	/* PERL_OBJECT */

/* Compatibility stubs.  Compile extensions with -DPERL_NOCOMPAT to
   disable them.
 */

#if !defined(PERL_CORE)
#  define sv_setptrobj(rv,ptr,name)	sv_setref_iv(rv,name,PTR2IV(ptr))
#  define sv_setptrref(rv,ptr)		sv_setref_iv(rv,Nullch,PTR2IV(ptr))
#endif

#if !defined(PERL_CORE) && !defined(PERL_NOCOMPAT) && !defined(PERL_BINCOMPAT_5005)

/* Compatibility for various misnamed functions.  All functions
   in the API that begin with "perl_" (not "Perl_") take an explicit
   interpreter context pointer.
   The following are not like that, but since they had a "perl_"
   prefix in previous versions, we provide compatibility macros.
 */
#  define perl_atexit(a,b)		call_atexit(a,b)
#  define perl_call_argv(a,b,c)		call_argv(a,b,c)
#  define perl_call_pv(a,b)		call_pv(a,b)
#  define perl_call_method(a,b)		call_method(a,b)
#  define perl_call_sv(a,b)		call_sv(a,b)
#  define perl_eval_sv(a,b)		eval_sv(a,b)
#  define perl_eval_pv(a,b)		eval_pv(a,b)
#  define perl_require_pv(a)		require_pv(a)
#  define perl_get_sv(a,b)		get_sv(a,b)
#  define perl_get_av(a,b)		get_av(a,b)
#  define perl_get_hv(a,b)		get_hv(a,b)
#  define perl_get_cv(a,b)		get_cv(a,b)
#  define perl_init_i18nl10n(a)		init_i18nl10n(a)
#  define perl_init_i18nl14n(a)		init_i18nl14n(a)
#  define perl_new_ctype(a)		new_ctype(a)
#  define perl_new_collate(a)		new_collate(a)
#  define perl_new_numeric(a)		new_numeric(a)

/* varargs functions can't be handled with CPP macros. :-(
   This provides a set of compatibility functions that don't take
   an extra argument but grab the context pointer using the macro
   dTHX.
 */
#if defined(PERL_IMPLICIT_CONTEXT) && !defined(PERL_OBJECT)
#  define croak				Perl_croak_nocontext
#  define deb				Perl_deb_nocontext
#  define die				Perl_die_nocontext
#  define form				Perl_form_nocontext
#  define load_module			Perl_load_module_nocontext
#  define mess				Perl_mess_nocontext
#  define newSVpvf			Perl_newSVpvf_nocontext
#  define sv_catpvf			Perl_sv_catpvf_nocontext
#  define sv_setpvf			Perl_sv_setpvf_nocontext
#  define warn				Perl_warn_nocontext
#  define warner			Perl_warner_nocontext
#  define sv_catpvf_mg			Perl_sv_catpvf_mg_nocontext
#  define sv_setpvf_mg			Perl_sv_setpvf_mg_nocontext
#endif

#endif /* !defined(PERL_CORE) && !defined(PERL_NOCOMPAT) */

#if !defined(PERL_IMPLICIT_CONTEXT)
/* undefined symbols, point them back at the usual ones */
#  define Perl_croak_nocontext		Perl_croak
#  define Perl_die_nocontext		Perl_die
#  define Perl_deb_nocontext		Perl_deb
#  define Perl_form_nocontext		Perl_form
#  define Perl_load_module_nocontext	Perl_load_module
#  define Perl_mess_nocontext		Perl_mess
#  define Perl_newSVpvf_nocontext	Perl_newSVpvf
#  define Perl_sv_catpvf_nocontext	Perl_sv_catpvf
#  define Perl_sv_setpvf_nocontext	Perl_sv_setpvf
#  define Perl_warn_nocontext		Perl_warn
#  define Perl_warner_nocontext		Perl_warner
#  define Perl_sv_catpvf_mg_nocontext	Perl_sv_catpvf_mg
#  define Perl_sv_setpvf_mg_nocontext	Perl_sv_setpvf_mg
#endif

END

close(EM);

unlink 'embedvar.h';
open(EM, '> embedvar.h')
    or die "Can't create embedvar.h: $!\n";

print EM <<'END';
/* !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!! 
   This file is built by embed.pl from data in embed.pl, pp.sym, intrpvar.h,
   perlvars.h and thrdvar.h.  Any changes made here will be lost!
*/

/* (Doing namespace management portably in C is really gross.) */

/*
   The following combinations of MULTIPLICITY, USE_THREADS, PERL_OBJECT
   and PERL_IMPLICIT_CONTEXT are supported:
     1) none
     2) MULTIPLICITY	# supported for compatibility
     3) MULTIPLICITY && PERL_IMPLICIT_CONTEXT
     4) USE_THREADS && PERL_IMPLICIT_CONTEXT
     5) MULTIPLICITY && USE_THREADS && PERL_IMPLICIT_CONTEXT
     6) PERL_OBJECT && PERL_IMPLICIT_CONTEXT

   All other combinations of these flags are errors.

   #3, #4, #5, and #6 are supported directly, while #2 is a special
   case of #3 (supported by redefining vTHX appropriately).
*/

#if defined(MULTIPLICITY)
/* cases 2, 3 and 5 above */

#  if defined(PERL_IMPLICIT_CONTEXT)
#    define vTHX	aTHX
#  else
#    define vTHX	PERL_GET_INTERP
#  endif

END

for $sym (sort keys %thread) {
    print EM multon($sym,'T','vTHX->');
}

print EM <<'END';

#  if defined(PERL_OBJECT)
#    include "error: PERL_OBJECT + MULTIPLICITY don't go together"
#  endif

#  if defined(USE_THREADS)
/* case 5 above */

END

for $sym (sort keys %intrp) {
    print EM multon($sym,'I','PERL_GET_INTERP->');
}

print EM <<'END';

#  else		/* !USE_THREADS */
/* cases 2 and 3 above */

END

for $sym (sort keys %intrp) {
    print EM multon($sym,'I','vTHX->');
}

print EM <<'END';

#  endif	/* USE_THREADS */

#else	/* !MULTIPLICITY */

#  if defined(PERL_OBJECT)
/* case 6 above */

END

for $sym (sort keys %thread) {
    print EM multon($sym,'T','aTHXo->interp.');
}


for $sym (sort keys %intrp) {
    print EM multon($sym,'I','aTHXo->interp.');
}

print EM <<'END';

#  else	/* !PERL_OBJECT */

/* cases 1 and 4 above */

END

for $sym (sort keys %intrp) {
    print EM multoff($sym,'I');
}

print EM <<'END';

#    if defined(USE_THREADS)
/* case 4 above */

END

for $sym (sort keys %thread) {
    print EM multon($sym,'T','aTHX->');
}

print EM <<'END';

#    else	/* !USE_THREADS */
/* case 1 above */

END

for $sym (sort keys %thread) {
    print EM multoff($sym,'T');
}

print EM <<'END';

#    endif	/* USE_THREADS */
#  endif	/* PERL_OBJECT */
#endif	/* MULTIPLICITY */

#if defined(PERL_GLOBAL_STRUCT)

END

for $sym (sort keys %globvar) {
    print EM multon($sym,'G','PL_Vars.');
}

print EM <<'END';

#else /* !PERL_GLOBAL_STRUCT */

END

for $sym (sort keys %globvar) {
    print EM multoff($sym,'G');
}

print EM <<'END';

#endif /* PERL_GLOBAL_STRUCT */

#ifdef PERL_POLLUTE		/* disabled by default in 5.6.0 */

END

for $sym (sort @extvars) {
    print EM hide($sym,"PL_$sym");
}

print EM <<'END';

#endif /* PERL_POLLUTE */
END

close(EM);

unlink 'objXSUB.h';
open(OBX, '> objXSUB.h')
    or die "Can't create objXSUB.h: $!\n";

print OBX <<'EOT';
/* !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!! 
   This file is built by embed.pl from data in embed.pl, pp.sym, intrpvar.h,
   perlvars.h and thrdvar.h.  Any changes made here will be lost!
*/

#ifndef __objXSUB_h__
#define __objXSUB_h__

/* method calls via pPerl (static functions without a "this" pointer need these) */

#if defined(PERL_CORE) && defined(PERL_OBJECT)

/* XXX soon to be eliminated, only a few things in PERLCORE need these now */

EOT

walk_table {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n" if $arg =~ /^#\s*(if|ifn?def|else|endif)\b/;
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	if ($flags =~ /A/ && $flags !~ /j/) { # API function needing macros
	    if ($flags =~ /p/) {
		$ret .= undefine("Perl_$func") . hide("Perl_$func","pPerl->Perl_$func");
		$ret .= undefine($func) . hide($func,"Perl_$func");
	    }
	    else {
		$ret .= undefine($func) . hide($func,"pPerl->$func");
	    }
	}
    }
    $ret;
} \*OBX;

# NOTE: not part of API
#for $sym (sort keys %ppsym) {
#    $sym =~ s/^Perl_//;
#    print OBX undefine("Perl_$sym") . hide("Perl_$sym", "pPerl->Perl_$sym");
#    print OBX undefine($sym) . hide($sym, "Perl_$sym");
#}

print OBX <<'EOT';

#endif  /* PERL_CORE && PERL_OBJECT */
#endif	/* __objXSUB_h__ */
EOT

close(OBX);

unlink 'perlapi.h';
unlink 'perlapi.c';
open(CAPI, '> perlapi.c') or die "Can't create perlapi.c: $!\n";
open(CAPIH, '> perlapi.h') or die "Can't create perlapi.h: $!\n";

print CAPIH <<'EOT';
/* !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!! 
   This file is built by embed.pl from data in embed.pl, pp.sym, intrpvar.h,
   perlvars.h and thrdvar.h.  Any changes made here will be lost!
*/

/* declare accessor functions for Perl variables */
#ifndef __perlapi_h__
#define __perlapi_h__

#if defined(PERL_OBJECT) || defined (MULTIPLICITY)

#if defined(PERL_OBJECT)
#  undef  aTHXo
#  define aTHXo			pPerl
#  undef  aTHXo_
#  define aTHXo_		aTHXo,
#endif /* PERL_OBJECT */

START_EXTERN_C

#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC
#define PERLVAR(v,t)	EXTERN_C t* Perl_##v##_ptr(pTHXo);
#define PERLVARA(v,n,t)	typedef t PL_##v##_t[n];			\
			EXTERN_C PL_##v##_t* Perl_##v##_ptr(pTHXo);
#define PERLVARI(v,t,i)	PERLVAR(v,t)
#define PERLVARIC(v,t,i) PERLVAR(v, const t)

#include "thrdvar.h"
#include "intrpvar.h"
#include "perlvars.h"

#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC

END_EXTERN_C

#if defined(PERL_CORE)

/* accessor functions for Perl variables (provide binary compatibility) */

/* these need to be mentioned here, or most linkers won't put them in
   the perl executable */

#ifndef PERL_NO_FORCE_LINK

START_EXTERN_C

#ifndef DOINIT
EXT void *PL_force_link_funcs[];
#else
EXT void *PL_force_link_funcs[] = {
#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC
#define PERLVAR(v,t)	(void*)Perl_##v##_ptr,
#define PERLVARA(v,n,t)	PERLVAR(v,t)
#define PERLVARI(v,t,i)	PERLVAR(v,t)
#define PERLVARIC(v,t,i) PERLVAR(v,t)

#include "thrdvar.h"
#include "intrpvar.h"
#include "perlvars.h"

#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC
};
#endif	/* DOINIT */

START_EXTERN_C

#endif	/* PERL_NO_FORCE_LINK */

#else	/* !PERL_CORE */

EOT

foreach my $sym (sort keys %intrp) {
    print CAPIH bincompat_var('I',$sym);
}

foreach my $sym (sort keys %thread) {
    print CAPIH bincompat_var('T',$sym);
}

foreach my $sym (sort keys %globvar) {
    print CAPIH bincompat_var('G',$sym);
}

print CAPIH <<'EOT';

#endif /* !PERL_CORE */
#endif /* PERL_OBJECT || MULTIPLICITY */

#endif /* __perlapi_h__ */

EOT
close CAPIH;

print CAPI <<'EOT';
/* !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!! 
   This file is built by embed.pl from data in embed.pl, pp.sym, intrpvar.h,
   perlvars.h and thrdvar.h.  Any changes made here will be lost!
*/

#include "EXTERN.h"
#include "perl.h"
#include "perlapi.h"

#if defined(PERL_OBJECT) || defined (MULTIPLICITY)

/* accessor functions for Perl variables (provides binary compatibility) */
START_EXTERN_C

#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC

#if defined(PERL_OBJECT)
#define PERLVAR(v,t)	t* Perl_##v##_ptr(pTHXo)			\
			{ return &(aTHXo->interp.v); }
#define PERLVARA(v,n,t)	PL_##v##_t* Perl_##v##_ptr(pTHXo)		\
			{ return &(aTHXo->interp.v); }
#else	/* MULTIPLICITY */
#define PERLVAR(v,t)	t* Perl_##v##_ptr(pTHX)				\
			{ return &(aTHX->v); }
#define PERLVARA(v,n,t)	PL_##v##_t* Perl_##v##_ptr(pTHX)		\
			{ return &(aTHX->v); }
#endif

#define PERLVARI(v,t,i)	PERLVAR(v,t)
#define PERLVARIC(v,t,i) PERLVAR(v, const t)

#include "thrdvar.h"
#include "intrpvar.h"

#undef PERLVAR
#undef PERLVARA
#define PERLVAR(v,t)	t* Perl_##v##_ptr(pTHXo)			\
			{ return &(PL_##v); }
#define PERLVARA(v,n,t)	PL_##v##_t* Perl_##v##_ptr(pTHXo)		\
			{ return &(PL_##v); }
#undef PERLVARIC
#define PERLVARIC(v,t,i)	const t* Perl_##v##_ptr(pTHXo)		\
			{ return (const t *)&(PL_##v); }
#include "perlvars.h"

#undef PERLVAR
#undef PERLVARA
#undef PERLVARI
#undef PERLVARIC

#if defined(PERL_OBJECT)

/* C-API layer for PERL_OBJECT */

EOT

# functions that take va_list* for implementing vararg functions
# NOTE: makedef.pl must be updated if you add symbols to %vfuncs
my %vfuncs = qw(
    Perl_croak			Perl_vcroak
    Perl_warn			Perl_vwarn
    Perl_warner			Perl_vwarner
    Perl_die			Perl_vdie
    Perl_form			Perl_vform
    Perl_load_module		Perl_vload_module
    Perl_mess			Perl_vmess
    Perl_deb			Perl_vdeb
    Perl_newSVpvf		Perl_vnewSVpvf
    Perl_sv_setpvf		Perl_sv_vsetpvf
    Perl_sv_setpvf_mg		Perl_sv_vsetpvf_mg
    Perl_sv_catpvf		Perl_sv_vcatpvf
    Perl_sv_catpvf_mg		Perl_sv_vcatpvf_mg
    Perl_dump_indent		Perl_dump_vindent
    Perl_default_protect	Perl_vdefault_protect
);

sub emit_func {
    my ($addcontext, $rettype,$func,@args) = @_;
    my @aargs = @args;
    my $a;
    for $a (@aargs) { $a =~ s/^.*\b(\w+)$/$1/ }
    my $ctxarg = '';
    if (not $addcontext) {
	$ctxarg = 'pTHXo';
	$ctxarg .= '_ ' if @args;
    }
    my $decl = '';
    if ($addcontext) {
	$decl .= "    dTHXo;\n";
    }
    local $" = ', ';
    my $return = ($rettype =~ /^\s*(void|Free_t|Signal_t)\s*$/
		  ? '' : 'return ');
    my $emitval = '';
    if (@args and $args[$#args] =~ /\.\.\./) {
	pop @aargs;
	my $retarg = '';
	my $ctxfunc = $func;
	$ctxfunc =~ s/_nocontext$//;
	return $emitval unless exists $vfuncs{$ctxfunc};
	if (length $return) {
	    $decl .= "    $rettype retval;\n";
	    $retarg .= "retval = ";
	    $return = "\n    ${return}retval;\n";
	}
	$emitval .= <<EOT
$rettype
$func($ctxarg@args)
{
$decl    va_list args;
    va_start(args, $aargs[$#aargs]);
    $retarg((CPerlObj*)pPerl)->$vfuncs{$ctxfunc}(@aargs, &args);
    va_end(args);$return
}
EOT
    }
    else {
	$emitval .= <<EOT
$rettype
$func($ctxarg@args)
{
$decl    $return((CPerlObj*)pPerl)->$func(@aargs);
}
EOT
    }
    $emitval;
}

# XXXX temporary hack
my $sym;
for $sym (qw(
		perl_construct
		perl_destruct
		perl_free
		perl_run
		perl_parse
		))
{
    $skipapi_funcs{$sym}++;
}

walk_table {
    my $ret = "";
    if (@_ == 1) {
	my $arg = shift;
	$ret .= "$arg\n" if $arg =~ /^#\s*(if|ifn?def|else|endif)\b/;
    }
    else {
	my ($flags,$retval,$func,@args) = @_;
	return $ret if exists $skipapi_funcs{$func};
	if ($flags =~ /A/ && $flags !~ /j/) { # in public API, needed for XSUBS
	    $ret .= "\n";
	    my $addctx = 1 if $flags =~ /n/;
	    if ($flags =~ /p/) {
		$ret .= undefine("Perl_$func");
		$ret .= emit_func($addctx,$retval,"Perl_$func",@args);
	    }
	    else {
		$ret .= undefine($func);
		$ret .= emit_func($addctx,$retval,$func,@args);
	    }
	}
    }
    $ret;
} \*CAPI;

# NOTE: not part of the API
#for $sym (sort keys %ppsym) {
#    $sym =~ s/^Perl_//;
#    print CAPI "\n";
#    print CAPI undefine("Perl_$sym");
#    if ($sym =~ /^ck_/) {
#	print CAPI emit_func(0, 'OP *',"Perl_$sym",'OP *o');
#    }
#   else {					# pp_foo
#	print CAPI emit_func(0, 'OP *',"Perl_$sym");
#    }
#}

print CAPI <<'EOT';

#undef Perl_fprintf_nocontext
int
Perl_fprintf_nocontext(PerlIO *stream, const char *format, ...)
{
    dTHXo;
    va_list(arglist);
    va_start(arglist, format);
    return (*PL_StdIO->pVprintf)(PL_StdIO, stream, format, arglist);
}

END_EXTERN_C

#endif /* PERL_OBJECT */
#endif /* PERL_OBJECT || MULTIPLICITY */
EOT

close(CAPI);

# autogenerate documentation from comments in source files

my %apidocs;
my %gutsdocs;
my %docfuncs;

sub autodoc ($$) { # parse a file and extract documentation info
    my($fh,$file) = @_;
    my($in, $doc, $line);
FUNC:
    while (defined($in = <$fh>)) {
	$line++;
	if ($in =~ /^=for\s+apidoc\s+(.*)\n/) {
	    my $proto = $1;
	    $proto = "||$proto" unless $proto =~ /\|/;
	    my($flags, $ret, $name, @args) = split /\|/, $proto;
	    my $docs = "";
DOC:
	    while (defined($doc = <$fh>)) {
		$line++;
		last DOC if $doc =~ /^=\w+/;
		if ($doc =~ m:^\*/$:) {
		    warn "=cut missing? $file:$line:$doc";;
		    last DOC;
		}
		$docs .= $doc;
	    }
	    $docs = "\n$docs" if $docs and $docs !~ /^\n/;
	    if ($flags =~ /m/) {
		if ($flags =~ /A/) {
		    $apidocs{$name} = [$flags, $docs, $ret, $file, @args];
		}
		else {
		    $gutsdocs{$name} = [$flags, $docs, $ret, $file, @args];
		}
	    }
	    else {
		$docfuncs{$name} = [$flags, $docs, $ret, $file, @args];
	    }
	    if (defined $doc) {
		if ($doc =~ /^=for/) {
		    $in = $doc;
		    redo FUNC;
		}
	    } else {
		warn "$file:$line:$in";
	    }
	}
    }
}

sub docout ($$$) { # output the docs for one function
    my($fh, $name, $docref) = @_;
    my($flags, $docs, $ret, $file, @args) = @$docref;

    $docs .= "NOTE: this function is experimental and may change or be
removed without notice.\n\n" if $flags =~ /x/;
    $docs .= "NOTE: the perl_ form of this function is deprecated.\n\n" 
	if $flags =~ /p/;

    print $fh "=item $name\n$docs";

    if ($flags =~ /U/) { # no usage
	# nothing
    } elsif ($flags =~ /s/) { # semicolon ("dTHR;")
	print $fh "\t\t$name;\n\n";
    } elsif ($flags =~ /n/) { # no args
	print $fh "\t$ret\t$name\n\n";
    } else { # full usage
	print $fh "\t$ret\t$name";
	print $fh "(" . join(", ", @args) . ")";
	print $fh "\n\n";
    }
    print $fh "=for hackers\nFound in file $file\n\n";
}

my $file;
for $file (glob('*.c'), glob('*.h')) {
    open F, "< $file" or die "Cannot open $file for docs: $!\n";
    autodoc(\*F,$file);
    close F or die "Error closing $file: $!\n";
}

unlink "pod/perlapi.pod";
open (DOC, ">pod/perlapi.pod") or 
	die "Can't create pod/perlapi.pod: $!\n";

walk_table {	# load documented functions into approriate hash
    if (@_ > 1) {
	my($flags, $retval, $func, @args) = @_;
	return "" unless $flags =~ /d/;
	$func =~ s/\t//g; $flags =~ s/p//; # clean up fields from embed.pl
	$retval =~ s/\t//;
	if ($flags =~ /A/) {
	    my $docref = delete $docfuncs{$func};
	    warn "no docs for $func\n" unless $docref and @$docref;
        $docref->[0].="x" if $flags =~ /M/;
	    $apidocs{$func} = [$docref->[0] . 'A', $docref->[1], $retval,
			       $docref->[3], @args];
	} else {
	    my $docref = delete $docfuncs{$func};
	    $gutsdocs{$func} = [$docref->[0], $docref->[1], $retval,
				$docref->[3], @args];
	}
    }
    return "";
} \*DOC;

for (sort keys %docfuncs) {
    # Have you used a full for apidoc or just a func name?  
    # Have you used Ap instead of Am in the for apidoc?
    warn "Unable to place $_!\n";
}

print DOC <<'_EOB_';
=head1 NAME

perlapi - autogenerated documentation for the perl public API

=head1 DESCRIPTION

This file contains the documentation of the perl public API generated by 
embed.pl, specifically a listing of functions, macros, flags, and variables 
that may be used by extension writers.  The interfaces of any functions that 
are not listed here are subject to change without notice.  For this reason,
blindly using functions listed in proto.h is to be avoided when writing
extensions.

Note that all Perl API global variables must be referenced with the C<PL_>
prefix.  Some macros are provided for compatibility with the older,
unadorned names, but this support may be disabled in a future release.

The listing is alphabetical, case insensitive.

=over 8

_EOB_

my $key;
for $key (sort { uc($a) cmp uc($b); } keys %apidocs) { # case insensitive sort
    docout(\*DOC, $key, $apidocs{$key});
}

print DOC <<'_EOE_';
=back

=head1 AUTHORS

Until May 1997, this document was maintained by Jeff Okamoto
<okamoto@corp.hp.com>.  It is now maintained as part of Perl itself.

With lots of help and suggestions from Dean Roehrich, Malcolm Beattie,
Andreas Koenig, Paul Hudson, Ilya Zakharevich, Paul Marquess, Neil
Bowers, Matthew Green, Tim Bunce, Spider Boardman, Ulrich Pfeifer,
Stephen McCamant, and Gurusamy Sarathy.

API Listing originally by Dean Roehrich <roehrich@cray.com>.

Updated to be autogenerated from comments in the source by Benjamin Stuhl.

=head1 SEE ALSO

perlguts(1), perlxs(1), perlxstut(1), perlintern(1)

_EOE_


close(DOC);

open(GUTS, ">pod/perlintern.pod") or 
		die "Unable to create pod/perlintern.pod: $!\n";
print GUTS <<'END';
=head1 NAME

perlintern - autogenerated documentation of purely B<internal> 
		 Perl functions

=head1 DESCRIPTION

This file is the autogenerated documentation of functions in the 
Perl interpreter that are documented using Perl's internal documentation
format but are not marked as part of the Perl API. In other words, 
B<they are not for use in extensions>!

=over 8

END

for $key (sort { uc($a) cmp uc($b); } keys %gutsdocs) {
    docout(\*GUTS, $key, $gutsdocs{$key});
}

print GUTS <<'END';
=back

=head1 AUTHORS

The autodocumentation system was originally added to the Perl core by 
Benjamin Stuhl. Documentation is by whoever was kind enough to 
document their functions.

=head1 SEE ALSO

perlguts(1), perlapi(1)

END

close GUTS;


__END__

: Lines are of the form:
:    flags|return_type|function_name|arg1|arg2|...|argN
:
: A line may be continued on another by ending it with a backslash.
: Leading and trailing whitespace will be ignored in each component.
:
: flags are single letters with following meanings:
:	A		member of public API
:	d		function has documentation with its source
:	s		static function, should have an S_ prefix in source
:				file
:	n		has no implicit interpreter/thread context argument
:	p		function has a Perl_ prefix
:	f		function takes printf style format string, varargs
:	r		function never returns
:       o		has no compatibility macro (#define foo Perl_foo)
:       j		not a member of CPerlObj
:       x		not exported
:       M		may change
:
: Individual flags may be separated by whitespace.
:
: New global functions should be added at the end for binary compatibility
: in some configurations.

START_EXTERN_C

#if defined(PERL_IMPLICIT_SYS)
Ajno	|PerlInterpreter*	|perl_alloc_using \
				|struct IPerlMem* m|struct IPerlMem* ms \
				|struct IPerlMem* mp|struct IPerlEnv* e \
				|struct IPerlStdIO* io|struct IPerlLIO* lio \
				|struct IPerlDir* d|struct IPerlSock* s \
				|struct IPerlProc* p
#endif
Ajnod	|PerlInterpreter*	|perl_alloc
Ajnod	|void	|perl_construct	|PerlInterpreter* interp
Ajnod	|void	|perl_destruct	|PerlInterpreter* interp
Ajnod	|void	|perl_free	|PerlInterpreter* interp
Ajnod	|int	|perl_run	|PerlInterpreter* interp
Ajnod	|int	|perl_parse	|PerlInterpreter* interp|XSINIT_t xsinit \
				|int argc|char** argv|char** env
#if defined(USE_ITHREADS)
: XXX: perl_clone needs docs
Ajno	|PerlInterpreter*|perl_clone|PerlInterpreter* interp, UV flags
#  if defined(PERL_IMPLICIT_SYS)
Ajno	|PerlInterpreter*|perl_clone_using|PerlInterpreter *interp|UV flags \
				|struct IPerlMem* m|struct IPerlMem* ms \
				|struct IPerlMem* mp|struct IPerlEnv* e \
				|struct IPerlStdIO* io|struct IPerlLIO* lio \
				|struct IPerlDir* d|struct IPerlSock* s \
				|struct IPerlProc* p
#  endif
#endif

#if defined(MYMALLOC)
Ajnop	|Malloc_t|malloc	|MEM_SIZE nbytes
Ajnop	|Malloc_t|calloc	|MEM_SIZE elements|MEM_SIZE size
Ajnop	|Malloc_t|realloc	|Malloc_t where|MEM_SIZE nbytes
Ajnop	|Free_t	|mfree		|Malloc_t where
jnp	|MEM_SIZE|malloced_size	|void *p
#endif

Ajnp	|void*	|get_context
Ajnp	|void	|set_context	|void *thx

END_EXTERN_C

/* functions with flag 'n' should come before here */
#if defined(PERL_OBJECT)
class CPerlObj {
public:
	struct interpreter interp;
	CPerlObj(IPerlMem*, IPerlMem*, IPerlMem*, IPerlEnv*, IPerlStdIO*,
	    IPerlLIO*, IPerlDir*, IPerlSock*, IPerlProc*);
	void* operator new(size_t nSize, IPerlMem *pvtbl);
#ifndef __BORLANDC__
	static void operator delete(void* pPerl, IPerlMem *pvtbl);
#endif
	int do_aspawn (void *vreally, void **vmark, void **vsp);
#endif
#if defined(PERL_OBJECT)
public:
#else
START_EXTERN_C
#endif
#  include "pp_proto.h"
Ap	|SV*	|amagic_call	|SV* left|SV* right|int method|int dir
Ap	|bool	|Gv_AMupdate	|HV* stash
p	|OP*	|append_elem	|I32 optype|OP* head|OP* tail
p	|OP*	|append_list	|I32 optype|LISTOP* first|LISTOP* last
p	|I32	|apply		|I32 type|SV** mark|SV** sp
Ap	|void	|apply_attrs_string|char *stashpv|CV *cv|char *attrstr|STRLEN len
Ap	|SV*	|avhv_delete_ent|AV *ar|SV* keysv|I32 flags|U32 hash
Ap	|bool	|avhv_exists_ent|AV *ar|SV* keysv|U32 hash
Ap	|SV**	|avhv_fetch_ent	|AV *ar|SV* keysv|I32 lval|U32 hash
Ap	|SV**	|avhv_store_ent	|AV *ar|SV* keysv|SV* val|U32 hash
Ap	|HE*	|avhv_iternext	|AV *ar
Ap	|SV*	|avhv_iterval	|AV *ar|HE* entry
Ap	|HV*	|avhv_keys	|AV *ar
Apd	|void	|av_clear	|AV* ar
Apd	|SV*	|av_delete	|AV* ar|I32 key|I32 flags
Apd	|bool	|av_exists	|AV* ar|I32 key
Apd	|void	|av_extend	|AV* ar|I32 key
p	|AV*	|av_fake	|I32 size|SV** svp
Apd	|SV**	|av_fetch	|AV* ar|I32 key|I32 lval
Apd	|void	|av_fill	|AV* ar|I32 fill
Apd	|I32	|av_len		|AV* ar
Apd	|AV*	|av_make	|I32 size|SV** svp
Apd	|SV*	|av_pop		|AV* ar
Apd	|void	|av_push	|AV* ar|SV* val
p	|void	|av_reify	|AV* ar
Apd	|SV*	|av_shift	|AV* ar
Apd	|SV**	|av_store	|AV* ar|I32 key|SV* val
Apd	|void	|av_undef	|AV* ar
Apd	|void	|av_unshift	|AV* ar|I32 num
p	|OP*	|bind_match	|I32 type|OP* left|OP* pat
p	|OP*	|block_end	|I32 floor|OP* seq
Ap	|I32	|block_gimme
p	|int	|block_start	|int full
p	|void	|boot_core_UNIVERSAL
Ap	|void	|call_list	|I32 oldscope|AV* av_list
p	|bool	|cando		|Mode_t mode|Uid_t effective|Stat_t* statbufp
Ap	|U32	|cast_ulong	|NV f
Ap	|I32	|cast_i32	|NV f
Ap	|IV	|cast_iv	|NV f
Ap	|UV	|cast_uv	|NV f
#if !defined(HAS_TRUNCATE) && !defined(HAS_CHSIZE) && defined(F_FREESP)
Ap	|I32	|my_chsize	|int fd|Off_t length
#endif
#if defined(USE_THREADS)
Ap	|MAGIC*	|condpair_magic	|SV *sv
#endif
p	|OP*	|convert	|I32 optype|I32 flags|OP* o
Afprd	|void	|croak		|const char* pat|...
Apr	|void	|vcroak		|const char* pat|va_list* args
#if defined(PERL_IMPLICIT_CONTEXT)
Afnrp	|void	|croak_nocontext|const char* pat|...
Afnp	|OP*	|die_nocontext	|const char* pat|...
Afnp	|void	|deb_nocontext	|const char* pat|...
Afnp	|char*	|form_nocontext	|const char* pat|...
Anp	|void	|load_module_nocontext|U32 flags|SV* name|SV* ver|...
Afnp	|SV*	|mess_nocontext	|const char* pat|...
Afnp	|void	|warn_nocontext	|const char* pat|...
Afnp	|void	|warner_nocontext|U32 err|const char* pat|...
Afnp	|SV*	|newSVpvf_nocontext|const char* pat|...
Afnp	|void	|sv_catpvf_nocontext|SV* sv|const char* pat|...
Afnp	|void	|sv_setpvf_nocontext|SV* sv|const char* pat|...
Afnp	|void	|sv_catpvf_mg_nocontext|SV* sv|const char* pat|...
Afnp	|void	|sv_setpvf_mg_nocontext|SV* sv|const char* pat|...
Afnp	|int	|fprintf_nocontext|PerlIO* stream|const char* fmt|...
#endif
p	|void	|cv_ckproto	|CV* cv|GV* gv|char* p
p	|CV*	|cv_clone	|CV* proto
Ap	|SV*	|cv_const_sv	|CV* cv
p	|SV*	|op_const_sv	|OP* o|CV* cv
Ap	|void	|cv_undef	|CV* cv
Ap	|void	|cx_dump	|PERL_CONTEXT* cs
Ap	|SV*	|filter_add	|filter_t funcp|SV* datasv
Ap	|void	|filter_del	|filter_t funcp
Ap	|I32	|filter_read	|int idx|SV* buffer|int maxlen
Ap	|char**	|get_op_descs
Ap	|char**	|get_op_names
p	|char*	|get_no_modify
p	|U32*	|get_opargs
Ap	|PPADDR_t*|get_ppaddr
p	|I32	|cxinc
Afp	|void	|deb		|const char* pat|...
Ap	|void	|vdeb		|const char* pat|va_list* args
Ap	|void	|debprofdump
Ap	|I32	|debop		|OP* o
Ap	|I32	|debstack
Ap	|I32	|debstackptrs
Ap	|char*	|delimcpy	|char* to|char* toend|char* from \
				|char* fromend|int delim|I32* retlen
p	|void	|deprecate	|char* s
Afp	|OP*	|die		|const char* pat|...
p	|OP*	|vdie		|const char* pat|va_list* args
p	|OP*	|die_where	|char* message|STRLEN msglen
Ap	|void	|dounwind	|I32 cxix
p	|bool	|do_aexec	|SV* really|SV** mark|SV** sp
p	|bool	|do_aexec5	|SV* really|SV** mark|SV** sp|int fd|int flag
Ap	|int	|do_binmode	|PerlIO *fp|int iotype|int mode
p	|void	|do_chop	|SV* asv|SV* sv
Ap	|bool	|do_close	|GV* gv|bool not_implicit
p	|bool	|do_eof		|GV* gv
p	|bool	|do_exec	|char* cmd
#if !defined(WIN32)
p	|bool	|do_exec3	|char* cmd|int fd|int flag
#endif
p	|void	|do_execfree
#if defined(HAS_MSG) || defined(HAS_SEM) || defined(HAS_SHM)
p	|I32	|do_ipcctl	|I32 optype|SV** mark|SV** sp
p	|I32	|do_ipcget	|I32 optype|SV** mark|SV** sp
p	|I32	|do_msgrcv	|SV** mark|SV** sp
p	|I32	|do_msgsnd	|SV** mark|SV** sp
p	|I32	|do_semop	|SV** mark|SV** sp
p	|I32	|do_shmio	|I32 optype|SV** mark|SV** sp
#endif
Ap	|void	|do_join	|SV* sv|SV* del|SV** mark|SV** sp
p	|OP*	|do_kv
Ap	|bool	|do_open	|GV* gv|char* name|I32 len|int as_raw \
				|int rawmode|int rawperm|PerlIO* supplied_fp
Ap	|bool	|do_open9	|GV *gv|char *name|I32 len|int as_raw \
				|int rawmode|int rawperm|PerlIO *supplied_fp \
				|SV *svs|I32 num
p	|void	|do_pipe	|SV* sv|GV* rgv|GV* wgv
p	|bool	|do_print	|SV* sv|PerlIO* fp
p	|OP*	|do_readline
p	|I32	|do_chomp	|SV* sv
p	|bool	|do_seek	|GV* gv|Off_t pos|int whence
p	|void	|do_sprintf	|SV* sv|I32 len|SV** sarg
p	|Off_t	|do_sysseek	|GV* gv|Off_t pos|int whence
p	|Off_t	|do_tell	|GV* gv
p	|I32	|do_trans	|SV* sv
p	|UV	|do_vecget	|SV* sv|I32 offset|I32 size
p	|void	|do_vecset	|SV* sv
p	|void	|do_vop		|I32 optype|SV* sv|SV* left|SV* right
p	|OP*	|dofile		|OP* term
Ap	|I32	|dowantarray
Ap	|void	|dump_all
Ap	|void	|dump_eval
#if defined(DUMP_FDS)
Ap	|void	|dump_fds	|char* s
#endif
Ap	|void	|dump_form	|GV* gv
Ap	|void	|gv_dump	|GV* gv
Ap	|void	|op_dump	|OP* arg
Ap	|void	|pmop_dump	|PMOP* pm
Ap	|void	|dump_packsubs	|HV* stash
Ap	|void	|dump_sub	|GV* gv
Apd	|void	|fbm_compile	|SV* sv|U32 flags
Apd	|char*	|fbm_instr	|unsigned char* big|unsigned char* bigend \
				|SV* littlesv|U32 flags
p	|char*	|find_script	|char *scriptname|bool dosearch \
				|char **search_ext|I32 flags
#if defined(USE_THREADS)
p	|PADOFFSET|find_threadsv|const char *name
#endif
p	|OP*	|force_list	|OP* arg
p	|OP*	|fold_constants	|OP* arg
Afp	|char*	|form		|const char* pat|...
Ap	|char*	|vform		|const char* pat|va_list* args
Ap	|void	|free_tmps
p	|OP*	|gen_constant_list|OP* o
#if !defined(HAS_GETENV_LEN)
p	|char*	|getenv_len	|const char* key|unsigned long *len
#endif
Ap	|void	|gp_free	|GV* gv
Ap	|GP*	|gp_ref		|GP* gp
Ap	|GV*	|gv_AVadd	|GV* gv
Ap	|GV*	|gv_HVadd	|GV* gv
Ap	|GV*	|gv_IOadd	|GV* gv
Ap	|GV*	|gv_autoload4	|HV* stash|const char* name|STRLEN len \
				|I32 method
Ap	|void	|gv_check	|HV* stash
Ap	|void	|gv_efullname	|SV* sv|GV* gv
Ap	|void	|gv_efullname3	|SV* sv|GV* gv|const char* prefix
Ap	|void	|gv_efullname4	|SV* sv|GV* gv|const char* prefix|bool keepmain
Ap	|GV*	|gv_fetchfile	|const char* name
Apd	|GV*	|gv_fetchmeth	|HV* stash|const char* name|STRLEN len \
				|I32 level
Apd	|GV*	|gv_fetchmethod	|HV* stash|const char* name
Apd	|GV*	|gv_fetchmethod_autoload|HV* stash|const char* name \
				|I32 autoload
Ap	|GV*	|gv_fetchpv	|const char* name|I32 add|I32 sv_type
Ap	|void	|gv_fullname	|SV* sv|GV* gv
Ap	|void	|gv_fullname3	|SV* sv|GV* gv|const char* prefix
Ap	|void	|gv_fullname4	|SV* sv|GV* gv|const char* prefix|bool keepmain
Ap	|void	|gv_init	|GV* gv|HV* stash|const char* name \
				|STRLEN len|int multi
Apd	|HV*	|gv_stashpv	|const char* name|I32 create
Ap	|HV*	|gv_stashpvn	|const char* name|U32 namelen|I32 create
Apd	|HV*	|gv_stashsv	|SV* sv|I32 create
Apd	|void	|hv_clear	|HV* tb
Ap	|void	|hv_delayfree_ent|HV* hv|HE* entry
Apd	|SV*	|hv_delete	|HV* tb|const char* key|U32 klen|I32 flags
Apd	|SV*	|hv_delete_ent	|HV* tb|SV* key|I32 flags|U32 hash
Apd	|bool	|hv_exists	|HV* tb|const char* key|U32 klen
Apd	|bool	|hv_exists_ent	|HV* tb|SV* key|U32 hash
Apd	|SV**	|hv_fetch	|HV* tb|const char* key|U32 klen|I32 lval
Apd	|HE*	|hv_fetch_ent	|HV* tb|SV* key|I32 lval|U32 hash
Ap	|void	|hv_free_ent	|HV* hv|HE* entry
Apd	|I32	|hv_iterinit	|HV* tb
Apd	|char*	|hv_iterkey	|HE* entry|I32* retlen
Apd	|SV*	|hv_iterkeysv	|HE* entry
Apd	|HE*	|hv_iternext	|HV* tb
Apd	|SV*	|hv_iternextsv	|HV* hv|char** key|I32* retlen
Apd	|SV*	|hv_iterval	|HV* tb|HE* entry
Ap	|void	|hv_ksplit	|HV* hv|IV newmax
Apd	|void	|hv_magic	|HV* hv|GV* gv|int how
Apd	|SV**	|hv_store	|HV* tb|const char* key|U32 klen|SV* val \
				|U32 hash
Apd	|HE*	|hv_store_ent	|HV* tb|SV* key|SV* val|U32 hash
Apd	|void	|hv_undef	|HV* tb
Ap	|I32	|ibcmp		|const char* a|const char* b|I32 len
Ap	|I32	|ibcmp_locale	|const char* a|const char* b|I32 len
p	|bool	|ingroup	|Gid_t testgid|Uid_t effective
p	|void	|init_debugger
Ap	|void	|init_stacks
p	|U32	|intro_my
Ap	|char*	|instr		|const char* big|const char* little
p	|bool	|io_close	|IO* io|bool not_implicit
p	|OP*	|invert		|OP* cmd
dp	|bool	|is_gv_magical	|char *name|STRLEN len|U32 flags
p	|I32	|is_lvalue_sub
Ap	|bool	|is_uni_alnum	|U32 c
Ap	|bool	|is_uni_alnumc	|U32 c
Ap	|bool	|is_uni_idfirst	|U32 c
Ap	|bool	|is_uni_alpha	|U32 c
Ap	|bool	|is_uni_ascii	|U32 c
Ap	|bool	|is_uni_space	|U32 c
Ap	|bool	|is_uni_cntrl	|U32 c
Ap	|bool	|is_uni_graph	|U32 c
Ap	|bool	|is_uni_digit	|U32 c
Ap	|bool	|is_uni_upper	|U32 c
Ap	|bool	|is_uni_lower	|U32 c
Ap	|bool	|is_uni_print	|U32 c
Ap	|bool	|is_uni_punct	|U32 c
Ap	|bool	|is_uni_xdigit	|U32 c
Ap	|U32	|to_uni_upper	|U32 c
Ap	|U32	|to_uni_title	|U32 c
Ap	|U32	|to_uni_lower	|U32 c
Ap	|bool	|is_uni_alnum_lc|U32 c
Ap	|bool	|is_uni_alnumc_lc|U32 c
Ap	|bool	|is_uni_idfirst_lc|U32 c
Ap	|bool	|is_uni_alpha_lc|U32 c
Ap	|bool	|is_uni_ascii_lc|U32 c
Ap	|bool	|is_uni_space_lc|U32 c
Ap	|bool	|is_uni_cntrl_lc|U32 c
Ap	|bool	|is_uni_graph_lc|U32 c
Ap	|bool	|is_uni_digit_lc|U32 c
Ap	|bool	|is_uni_upper_lc|U32 c
Ap	|bool	|is_uni_lower_lc|U32 c
Ap	|bool	|is_uni_print_lc|U32 c
Ap	|bool	|is_uni_punct_lc|U32 c
Ap	|bool	|is_uni_xdigit_lc|U32 c
Ap	|U32	|to_uni_upper_lc|U32 c
Ap	|U32	|to_uni_title_lc|U32 c
Ap	|U32	|to_uni_lower_lc|U32 c
Apd	|STRLEN	|is_utf8_char	|U8 *p
Apd	|bool	|is_utf8_string	|U8 *s|STRLEN len
Ap	|bool	|is_utf8_alnum	|U8 *p
Ap	|bool	|is_utf8_alnumc	|U8 *p
Ap	|bool	|is_utf8_idfirst|U8 *p
Ap	|bool	|is_utf8_alpha	|U8 *p
Ap	|bool	|is_utf8_ascii	|U8 *p
Ap	|bool	|is_utf8_space	|U8 *p
Ap	|bool	|is_utf8_cntrl	|U8 *p
Ap	|bool	|is_utf8_digit	|U8 *p
Ap	|bool	|is_utf8_graph	|U8 *p
Ap	|bool	|is_utf8_upper	|U8 *p
Ap	|bool	|is_utf8_lower	|U8 *p
Ap	|bool	|is_utf8_print	|U8 *p
Ap	|bool	|is_utf8_punct	|U8 *p
Ap	|bool	|is_utf8_xdigit	|U8 *p
Ap	|bool	|is_utf8_mark	|U8 *p
p	|OP*	|jmaybe		|OP* arg
p	|I32	|keyword	|char* d|I32 len
Ap	|void	|leave_scope	|I32 base
p	|void	|lex_end
p	|void	|lex_start	|SV* line
p	|OP*	|linklist	|OP* o
p	|OP*	|list		|OP* o
p	|OP*	|listkids	|OP* o
Ap	|void	|load_module|U32 flags|SV* name|SV* ver|...
Ap	|void	|vload_module|U32 flags|SV* name|SV* ver|va_list* args
p	|OP*	|localize	|OP* arg|I32 lexical
Apd	|I32	|looks_like_number|SV* sv
p	|int	|magic_clearenv	|SV* sv|MAGIC* mg
p	|int	|magic_clear_all_env|SV* sv|MAGIC* mg
p	|int	|magic_clearpack|SV* sv|MAGIC* mg
p	|int	|magic_clearsig	|SV* sv|MAGIC* mg
p	|int	|magic_existspack|SV* sv|MAGIC* mg
p	|int	|magic_freeregexp|SV* sv|MAGIC* mg
p	|int	|magic_get	|SV* sv|MAGIC* mg
p	|int	|magic_getarylen|SV* sv|MAGIC* mg
p	|int	|magic_getdefelem|SV* sv|MAGIC* mg
p	|int	|magic_getglob	|SV* sv|MAGIC* mg
p	|int	|magic_getnkeys	|SV* sv|MAGIC* mg
p	|int	|magic_getpack	|SV* sv|MAGIC* mg
p	|int	|magic_getpos	|SV* sv|MAGIC* mg
p	|int	|magic_getsig	|SV* sv|MAGIC* mg
p	|int	|magic_getsubstr|SV* sv|MAGIC* mg
p	|int	|magic_gettaint	|SV* sv|MAGIC* mg
p	|int	|magic_getuvar	|SV* sv|MAGIC* mg
p	|int	|magic_getvec	|SV* sv|MAGIC* mg
p	|U32	|magic_len	|SV* sv|MAGIC* mg
#if defined(USE_THREADS)
p	|int	|magic_mutexfree|SV* sv|MAGIC* mg
#endif
p	|int	|magic_nextpack	|SV* sv|MAGIC* mg|SV* key
p	|U32	|magic_regdata_cnt|SV* sv|MAGIC* mg
p	|int	|magic_regdatum_get|SV* sv|MAGIC* mg
p	|int	|magic_regdatum_set|SV* sv|MAGIC* mg
p	|int	|magic_set	|SV* sv|MAGIC* mg
p	|int	|magic_setamagic|SV* sv|MAGIC* mg
p	|int	|magic_setarylen|SV* sv|MAGIC* mg
p	|int	|magic_setbm	|SV* sv|MAGIC* mg
p	|int	|magic_setdbline|SV* sv|MAGIC* mg
#if defined(USE_LOCALE_COLLATE)
p	|int	|magic_setcollxfrm|SV* sv|MAGIC* mg
#endif
p	|int	|magic_setdefelem|SV* sv|MAGIC* mg
p	|int	|magic_setenv	|SV* sv|MAGIC* mg
p	|int	|magic_setfm	|SV* sv|MAGIC* mg
p	|int	|magic_setisa	|SV* sv|MAGIC* mg
p	|int	|magic_setglob	|SV* sv|MAGIC* mg
p	|int	|magic_setmglob	|SV* sv|MAGIC* mg
p	|int	|magic_setnkeys	|SV* sv|MAGIC* mg
p	|int	|magic_setpack	|SV* sv|MAGIC* mg
p	|int	|magic_setpos	|SV* sv|MAGIC* mg
p	|int	|magic_setsig	|SV* sv|MAGIC* mg
p	|int	|magic_setsubstr|SV* sv|MAGIC* mg
p	|int	|magic_settaint	|SV* sv|MAGIC* mg
p	|int	|magic_setuvar	|SV* sv|MAGIC* mg
p	|int	|magic_setvec	|SV* sv|MAGIC* mg
p	|int	|magic_set_all_env|SV* sv|MAGIC* mg
p	|U32	|magic_sizepack	|SV* sv|MAGIC* mg
p	|int	|magic_wipepack	|SV* sv|MAGIC* mg
p	|void	|magicname	|char* sym|char* name|I32 namlen
Ap	|void	|markstack_grow
#if defined(USE_LOCALE_COLLATE)
p	|char*	|mem_collxfrm	|const char* s|STRLEN len|STRLEN* xlen
#endif
Afp	|SV*	|mess		|const char* pat|...
Ap	|SV*	|vmess		|const char* pat|va_list* args
p	|void	|qerror		|SV* err
Apd	|int	|mg_clear	|SV* sv
Apd	|int	|mg_copy	|SV* sv|SV* nsv|const char* key|I32 klen
Apd	|MAGIC*	|mg_find	|SV* sv|int type
Apd	|int	|mg_free	|SV* sv
Apd	|int	|mg_get		|SV* sv
Apd	|U32	|mg_length	|SV* sv
Apd	|void	|mg_magical	|SV* sv
Apd	|int	|mg_set		|SV* sv
Ap	|I32	|mg_size	|SV* sv
p	|OP*	|mod		|OP* o|I32 type
p	|int	|mode_from_discipline|SV* discp
Ap	|char*	|moreswitches	|char* s
p	|OP*	|my		|OP* o
Ap	|NV	|my_atof	|const char *s
#if !defined(HAS_BCOPY) || !defined(HAS_SAFE_BCOPY)
Anp	|char*	|my_bcopy	|const char* from|char* to|I32 len
#endif
#if !defined(HAS_BZERO) && !defined(HAS_MEMSET)
Anp	|char*	|my_bzero	|char* loc|I32 len
#endif
Apr	|void	|my_exit	|U32 status
Apr	|void	|my_failure_exit
Ap	|I32	|my_fflush_all
Ap	|I32	|my_lstat
#if !defined(HAS_MEMCMP) || !defined(HAS_SANE_MEMCMP)
Anp	|I32	|my_memcmp	|const char* s1|const char* s2|I32 len
#endif
#if !defined(HAS_MEMSET)
Anp	|void*	|my_memset	|char* loc|I32 ch|I32 len
#endif
#if !defined(PERL_OBJECT)
Ap	|I32	|my_pclose	|PerlIO* ptr
Ap	|PerlIO*|my_popen	|char* cmd|char* mode
#endif
Ap	|void	|my_setenv	|char* nam|char* val
Ap	|I32	|my_stat
#if defined(MYSWAP)
Ap	|short	|my_swap	|short s
Ap	|long	|my_htonl	|long l
Ap	|long	|my_ntohl	|long l
#endif
p	|void	|my_unexec
Ap	|OP*	|newANONLIST	|OP* o
Ap	|OP*	|newANONHASH	|OP* o
Ap	|OP*	|newANONSUB	|I32 floor|OP* proto|OP* block
Ap	|OP*	|newASSIGNOP	|I32 flags|OP* left|I32 optype|OP* right
Ap	|OP*	|newCONDOP	|I32 flags|OP* expr|OP* trueop|OP* falseop
Apd	|void	|newCONSTSUB	|HV* stash|char* name|SV* sv
Ap	|void	|newFORM	|I32 floor|OP* o|OP* block
Ap	|OP*	|newFOROP	|I32 flags|char* label|line_t forline \
				|OP* sclr|OP* expr|OP*block|OP*cont
Ap	|OP*	|newLOGOP	|I32 optype|I32 flags|OP* left|OP* right
Ap	|OP*	|newLOOPEX	|I32 type|OP* label
Ap	|OP*	|newLOOPOP	|I32 flags|I32 debuggable|OP* expr|OP* block
Ap	|OP*	|newNULLLIST
Ap	|OP*	|newOP		|I32 optype|I32 flags
Ap	|void	|newPROG	|OP* o
Ap	|OP*	|newRANGE	|I32 flags|OP* left|OP* right
Ap	|OP*	|newSLICEOP	|I32 flags|OP* subscript|OP* listop
Ap	|OP*	|newSTATEOP	|I32 flags|char* label|OP* o
Ap	|CV*	|newSUB		|I32 floor|OP* o|OP* proto|OP* block
Apd	|CV*	|newXS		|char* name|XSUBADDR_t f|char* filename
Apd	|AV*	|newAV
Ap	|OP*	|newAVREF	|OP* o
Ap	|OP*	|newBINOP	|I32 type|I32 flags|OP* first|OP* last
Ap	|OP*	|newCVREF	|I32 flags|OP* o
Ap	|OP*	|newGVOP	|I32 type|I32 flags|GV* gv
Ap	|GV*	|newGVgen	|char* pack
Ap	|OP*	|newGVREF	|I32 type|OP* o
Ap	|OP*	|newHVREF	|OP* o
Apd	|HV*	|newHV
Ap	|HV*	|newHVhv	|HV* hv
Ap	|IO*	|newIO
Ap	|OP*	|newLISTOP	|I32 type|I32 flags|OP* first|OP* last
Ap	|OP*	|newPADOP	|I32 type|I32 flags|SV* sv
Ap	|OP*	|newPMOP	|I32 type|I32 flags
Ap	|OP*	|newPVOP	|I32 type|I32 flags|char* pv
Ap	|SV*	|newRV		|SV* pref
Apd	|SV*	|newRV_noinc	|SV *sv
Ap	|SV*	|newSV		|STRLEN len
Ap	|OP*	|newSVREF	|OP* o
Ap	|OP*	|newSVOP	|I32 type|I32 flags|SV* sv
Apd	|SV*	|newSViv	|IV i
Apd	|SV*	|newSVuv	|UV u
Apd	|SV*	|newSVnv	|NV n
Apd	|SV*	|newSVpv	|const char* s|STRLEN len
Apd	|SV*	|newSVpvn	|const char* s|STRLEN len
Afpd	|SV*	|newSVpvf	|const char* pat|...
Ap	|SV*	|vnewSVpvf	|const char* pat|va_list* args
Apd	|SV*	|newSVrv	|SV* rv|const char* classname
Apd	|SV*	|newSVsv	|SV* old
Ap	|OP*	|newUNOP	|I32 type|I32 flags|OP* first
Ap	|OP*	|newWHILEOP	|I32 flags|I32 debuggable|LOOP* loop \
				|I32 whileline|OP* expr|OP* block|OP* cont

Ap	|PERL_SI*|new_stackinfo|I32 stitems|I32 cxitems
p	|PerlIO*|nextargv	|GV* gv
Ap	|char*	|ninstr		|const char* big|const char* bigend \
				|const char* little|const char* lend
p	|OP*	|oopsCV		|OP* o
Ap	|void	|op_free	|OP* arg
p	|void	|package	|OP* o
p	|PADOFFSET|pad_alloc	|I32 optype|U32 tmptype
p	|PADOFFSET|pad_allocmy	|char* name
p	|PADOFFSET|pad_findmy	|char* name
p	|OP*	|oopsAV		|OP* o
p	|OP*	|oopsHV		|OP* o
p	|void	|pad_leavemy	|I32 fill
Ap	|SV*	|pad_sv		|PADOFFSET po
p	|void	|pad_free	|PADOFFSET po
p	|void	|pad_reset
p	|void	|pad_swipe	|PADOFFSET po
p	|void	|peep		|OP* o
#if defined(PERL_OBJECT)
Aox	|void	|Perl_construct
Aox	|void	|Perl_destruct
Aox	|void	|Perl_free
Aox	|int	|Perl_run
Aox	|int	|Perl_parse	|XSINIT_t xsinit \
				|int argc|char** argv|char** env
#endif
#if defined(USE_THREADS)
Ap	|struct perl_thread*	|new_struct_thread|struct perl_thread *t
#endif
Ap	|void	|call_atexit	|ATEXIT_t fn|void *ptr
Apd	|I32	|call_argv	|const char* sub_name|I32 flags|char** argv
Apd	|I32	|call_method	|const char* methname|I32 flags
Apd	|I32	|call_pv	|const char* sub_name|I32 flags
Apd	|I32	|call_sv	|SV* sv|I32 flags
Apd	|SV*	|eval_pv	|const char* p|I32 croak_on_error
Apd	|I32	|eval_sv	|SV* sv|I32 flags
Apd	|SV*	|get_sv		|const char* name|I32 create
Apd	|AV*	|get_av		|const char* name|I32 create
Apd	|HV*	|get_hv		|const char* name|I32 create
Apd	|CV*	|get_cv		|const char* name|I32 create
Ap	|int	|init_i18nl10n	|int printwarn
Ap	|int	|init_i18nl14n	|int printwarn
Ap	|void	|new_collate	|char* newcoll
Ap	|void	|new_ctype	|char* newctype
Ap	|void	|new_numeric	|char* newcoll
Ap	|void	|set_numeric_local
Ap	|void	|set_numeric_radix
Ap	|void	|set_numeric_standard
Apd	|void	|require_pv	|const char* pv
p	|void	|pidgone	|Pid_t pid|int status
Ap	|void	|pmflag		|U16* pmfl|int ch
p	|OP*	|pmruntime	|OP* pm|OP* expr|OP* repl
p	|OP*	|pmtrans	|OP* o|OP* expr|OP* repl
p	|OP*	|pop_return
Ap	|void	|pop_scope
p	|OP*	|prepend_elem	|I32 optype|OP* head|OP* tail
p	|void	|push_return	|OP* o
Ap	|void	|push_scope
p	|OP*	|ref		|OP* o|I32 type
p	|OP*	|refkids	|OP* o|I32 type
Ap	|void	|regdump	|regexp* r
Ap	|I32	|pregexec	|regexp* prog|char* stringarg \
				|char* strend|char* strbeg|I32 minend \
				|SV* screamer|U32 nosave
Ap	|void	|pregfree	|struct regexp* r
Ap	|regexp*|pregcomp	|char* exp|char* xend|PMOP* pm
Ap	|char*	|re_intuit_start|regexp* prog|SV* sv|char* strpos \
				|char* strend|U32 flags \
				|struct re_scream_pos_data_s *data
Ap	|SV*	|re_intuit_string|regexp* prog
Ap	|I32	|regexec_flags	|regexp* prog|char* stringarg \
				|char* strend|char* strbeg|I32 minend \
				|SV* screamer|void* data|U32 flags
Ap	|regnode*|regnext	|regnode* p
p	|void	|regprop	|SV* sv|regnode* o
Ap	|void	|repeatcpy	|char* to|const char* from|I32 len|I32 count
Ap	|char*	|rninstr	|const char* big|const char* bigend \
				|const char* little|const char* lend
Ap	|Sighandler_t|rsignal	|int i|Sighandler_t t
p	|int	|rsignal_restore|int i|Sigsave_t* t
p	|int	|rsignal_save	|int i|Sighandler_t t1|Sigsave_t* t2
p	|Sighandler_t|rsignal_state|int i
p	|void	|rxres_free	|void** rsp
p	|void	|rxres_restore	|void** rsp|REGEXP* prx
p	|void	|rxres_save	|void** rsp|REGEXP* prx
#if !defined(HAS_RENAME)
p	|I32	|same_dirent	|char* a|char* b
#endif
Apd	|char*	|savepv		|const char* sv
Apd	|char*	|savepvn	|const char* sv|I32 len
Ap	|void	|savestack_grow
Ap	|void	|save_aelem	|AV* av|I32 idx|SV **sptr
Ap	|I32	|save_alloc	|I32 size|I32 pad
Ap	|void	|save_aptr	|AV** aptr
Ap	|AV*	|save_ary	|GV* gv
Ap	|void	|save_clearsv	|SV** svp
Ap	|void	|save_delete	|HV* hv|char* key|I32 klen
Ap	|void	|save_destructor|DESTRUCTORFUNC_NOCONTEXT_t f|void* p
Ap	|void	|save_destructor_x|DESTRUCTORFUNC_t f|void* p
Ap	|void	|save_freesv	|SV* sv
p	|void	|save_freeop	|OP* o
Ap	|void	|save_freepv	|char* pv
Ap	|void	|save_generic_svref|SV** sptr
Ap	|void	|save_generic_pvref|char** str
Ap	|void	|save_gp	|GV* gv|I32 empty
Ap	|HV*	|save_hash	|GV* gv
Ap	|void	|save_helem	|HV* hv|SV *key|SV **sptr
Ap	|void	|save_hints
Ap	|void	|save_hptr	|HV** hptr
Ap	|void	|save_I16	|I16* intp
Ap	|void	|save_I32	|I32* intp
Ap	|void	|save_I8	|I8* bytep
Ap	|void	|save_int	|int* intp
Ap	|void	|save_item	|SV* item
Ap	|void	|save_iv	|IV* iv
Ap	|void	|save_list	|SV** sarg|I32 maxsarg
Ap	|void	|save_long	|long* longp
Ap	|void	|save_nogv	|GV* gv
p	|void	|save_op
Ap	|SV*	|save_scalar	|GV* gv
Ap	|void	|save_pptr	|char** pptr
Ap	|void	|save_vptr	|void* pptr
Ap	|void	|save_re_context
Ap	|void	|save_padsv	|PADOFFSET off
Ap	|void	|save_sptr	|SV** sptr
Ap	|SV*	|save_svref	|SV** sptr
Ap	|SV**	|save_threadsv	|PADOFFSET i
p	|OP*	|sawparens	|OP* o
p	|OP*	|scalar		|OP* o
p	|OP*	|scalarkids	|OP* o
p	|OP*	|scalarseq	|OP* o
p	|OP*	|scalarvoid	|OP* o
Ap	|NV	|scan_bin	|char* start|STRLEN len|STRLEN* retlen
Ap	|NV	|scan_hex	|char* start|STRLEN len|STRLEN* retlen
Ap	|char*	|scan_num	|char* s|YYSTYPE *lvalp
Ap	|NV	|scan_oct	|char* start|STRLEN len|STRLEN* retlen
p	|OP*	|scope		|OP* o
Ap	|char*	|screaminstr	|SV* bigsv|SV* littlesv|I32 start_shift \
				|I32 end_shift|I32 *state|I32 last
#if !defined(VMS)
p	|I32	|setenv_getix	|char* nam
#endif
p	|void	|setdefout	|GV* gv
Ap	|char*	|sharepvn	|const char* sv|I32 len|U32 hash
p	|HEK*	|share_hek	|const char* sv|I32 len|U32 hash
np	|Signal_t |sighandler	|int sig
Ap	|SV**	|stack_grow	|SV** sp|SV**p|int n
Ap	|I32	|start_subparse	|I32 is_format|U32 flags
p	|void	|sub_crush_depth|CV* cv
Ap	|bool	|sv_2bool	|SV* sv
Ap	|CV*	|sv_2cv		|SV* sv|HV** st|GV** gvp|I32 lref
Ap	|IO*	|sv_2io		|SV* sv
Ap	|IV	|sv_2iv		|SV* sv
Apd	|SV*	|sv_2mortal	|SV* sv
Ap	|NV	|sv_2nv		|SV* sv
Ap	|char*	|sv_2pv		|SV* sv|STRLEN* lp
Ap	|char*	|sv_2pvutf8	|SV* sv|STRLEN* lp
Ap	|char*	|sv_2pvbyte	|SV* sv|STRLEN* lp
Ap	|UV	|sv_2uv		|SV* sv
Ap	|IV	|sv_iv		|SV* sv
Ap	|UV	|sv_uv		|SV* sv
Ap	|NV	|sv_nv		|SV* sv
Ap	|char*	|sv_pvn		|SV *sv|STRLEN *len
Ap	|char*	|sv_pvutf8n	|SV *sv|STRLEN *len
Ap	|char*	|sv_pvbyten	|SV *sv|STRLEN *len
Apd	|I32	|sv_true	|SV *sv
p	|void	|sv_add_arena	|char* ptr|U32 size|U32 flags
Ap	|int	|sv_backoff	|SV* sv
Apd	|SV*	|sv_bless	|SV* sv|HV* stash
Afpd	|void	|sv_catpvf	|SV* sv|const char* pat|...
Ap	|void	|sv_vcatpvf	|SV* sv|const char* pat|va_list* args
Apd	|void	|sv_catpv	|SV* sv|const char* ptr
Apd	|void	|sv_catpvn	|SV* sv|const char* ptr|STRLEN len
Apd	|void	|sv_catsv	|SV* dsv|SV* ssv
Apd	|void	|sv_chop	|SV* sv|char* ptr
p	|void	|sv_clean_all
p	|void	|sv_clean_objs
Apd	|void	|sv_clear	|SV* sv
Apd	|I32	|sv_cmp		|SV* sv1|SV* sv2
Apd	|I32	|sv_cmp_locale	|SV* sv1|SV* sv2
#if defined(USE_LOCALE_COLLATE)
Ap	|char*	|sv_collxfrm	|SV* sv|STRLEN* nxp
#endif
Ap	|OP*	|sv_compile_2op	|SV* sv|OP** startp|char* code|AV** avp
Apd	|void	|sv_dec		|SV* sv
Ap	|void	|sv_dump	|SV* sv
Apd	|bool	|sv_derived_from|SV* sv|const char* name
Apd	|I32	|sv_eq		|SV* sv1|SV* sv2
Apd	|void	|sv_free	|SV* sv
p	|void	|sv_free_arenas
Apd	|char*	|sv_gets	|SV* sv|PerlIO* fp|I32 append
Apd	|char*	|sv_grow	|SV* sv|STRLEN newlen
Apd	|void	|sv_inc		|SV* sv
Apd	|void	|sv_insert	|SV* bigsv|STRLEN offset|STRLEN len \
				|char* little|STRLEN littlelen
Apd	|int	|sv_isa		|SV* sv|const char* name
Apd	|int	|sv_isobject	|SV* sv
Apd	|STRLEN	|sv_len		|SV* sv
Apd	|STRLEN	|sv_len_utf8	|SV* sv
Apd	|void	|sv_magic	|SV* sv|SV* obj|int how|const char* name \
				|I32 namlen
Apd	|SV*	|sv_mortalcopy	|SV* oldsv
Apd	|SV*	|sv_newmortal
Ap	|SV*	|sv_newref	|SV* sv
Ap	|char*	|sv_peek	|SV* sv
Ap	|void	|sv_pos_u2b	|SV* sv|I32* offsetp|I32* lenp
Ap	|void	|sv_pos_b2u	|SV* sv|I32* offsetp
Apd	|char*	|sv_pvn_force	|SV* sv|STRLEN* lp
Apd	|char*	|sv_pvutf8n_force|SV* sv|STRLEN* lp
Ap	|char*	|sv_pvbyten_force|SV* sv|STRLEN* lp
Apd	|char*	|sv_reftype	|SV* sv|int ob
Apd	|void	|sv_replace	|SV* sv|SV* nsv
Ap	|void	|sv_report_used
Ap	|void	|sv_reset	|char* s|HV* stash
Afpd	|void	|sv_setpvf	|SV* sv|const char* pat|...
Ap	|void	|sv_vsetpvf	|SV* sv|const char* pat|va_list* args
Apd	|void	|sv_setiv	|SV* sv|IV num
Apd	|void	|sv_setpviv	|SV* sv|IV num
Apd	|void	|sv_setuv	|SV* sv|UV num
Apd	|void	|sv_setnv	|SV* sv|NV num
Apd	|SV*	|sv_setref_iv	|SV* rv|const char* classname|IV iv
Apd	|SV*	|sv_setref_nv	|SV* rv|const char* classname|NV nv
Apd	|SV*	|sv_setref_pv	|SV* rv|const char* classname|void* pv
Apd	|SV*	|sv_setref_pvn	|SV* rv|const char* classname|char* pv \
				|STRLEN n
Apd	|void	|sv_setpv	|SV* sv|const char* ptr
Apd	|void	|sv_setpvn	|SV* sv|const char* ptr|STRLEN len
Apd	|void	|sv_setsv	|SV* dsv|SV* ssv
Ap	|void	|sv_taint	|SV* sv
Ap	|bool	|sv_tainted	|SV* sv
Apd	|int	|sv_unmagic	|SV* sv|int type
Apd	|void	|sv_unref	|SV* sv
Ap	|void	|sv_untaint	|SV* sv
Apd	|bool	|sv_upgrade	|SV* sv|U32 mt
Apd	|void	|sv_usepvn	|SV* sv|char* ptr|STRLEN len
Apd	|void	|sv_vcatpvfn	|SV* sv|const char* pat|STRLEN patlen \
				|va_list* args|SV** svargs|I32 svmax \
				|bool *maybe_tainted
Apd	|void	|sv_vsetpvfn	|SV* sv|const char* pat|STRLEN patlen \
				|va_list* args|SV** svargs|I32 svmax \
				|bool *maybe_tainted
Ap	|NV	|str_to_version	|SV *sv
Ap	|SV*	|swash_init	|char* pkg|char* name|SV* listsv \
				|I32 minbits|I32 none
Ap	|UV	|swash_fetch	|SV *sv|U8 *ptr
Ap	|void	|taint_env
Ap	|void	|taint_proper	|const char* f|const char* s
Ap	|UV	|to_utf8_lower	|U8 *p
Ap	|UV	|to_utf8_upper	|U8 *p
Ap	|UV	|to_utf8_title	|U8 *p
#if defined(UNLINK_ALL_VERSIONS)
Ap	|I32	|unlnk		|char* f
#endif
#if defined(USE_THREADS)
Ap	|void	|unlock_condpair|void* svv
#endif
Ap	|void	|unsharepvn	|const char* sv|I32 len|U32 hash
p	|void	|unshare_hek	|HEK* hek
p	|void	|utilize	|int aver|I32 floor|OP* version|OP* id|OP* arg
ApM	|U8*	|utf16_to_utf8	|U8* p|U8 *d|I32 bytelen|I32 *newlen
ApM	|U8*	|utf16_to_utf8_reversed|U8* p|U8 *d|I32 bytelen|I32 *newlen
ApMd	|STRLEN	|utf8_length	|U8* s|U8 *e
ApMd	|IV	|utf8_distance	|U8 *a|U8 *b
ApMd	|U8*	|utf8_hop	|U8 *s|I32 off
ApMd	|U8*	|utf8_to_bytes	|U8 *s|STRLEN *len
ApMd	|U8*	|bytes_from_utf8|U8 *s|STRLEN *len|bool *is_utf8
ApMd	|U8*	|bytes_to_utf8	|U8 *s|STRLEN *len
ApMd	|UV	|utf8_to_uv_simple|U8 *s|STRLEN* retlen
ApMd	|UV	|utf8_to_uv	|U8 *s|STRLEN curlen|STRLEN* retlen|U32 flags
ApMd	|U8*	|uv_to_utf8	|U8 *d|UV uv
p	|void	|vivify_defelem	|SV* sv
p	|void	|vivify_ref	|SV* sv|U32 to_what
p	|I32	|wait4pid	|Pid_t pid|int* statusp|int flags
p	|void	|report_evil_fh	|GV *gv|IO *io|I32 op
p	|void	|report_uninit
Afpd	|void	|warn		|const char* pat|...
Ap	|void	|vwarn		|const char* pat|va_list* args
Afp	|void	|warner		|U32 err|const char* pat|...
Ap	|void	|vwarner	|U32 err|const char* pat|va_list* args
p	|void	|watch		|char** addr
Ap	|I32	|whichsig	|char* sig
p	|int	|yyerror	|char* s
#ifdef USE_PURE_BISON
p	|int	|yylex_r	|YYSTYPE *lvalp|int *lcharp
p	|int	|yylex		|YYSTYPE *lvalp|int *lcharp
#else
p	|int	|yylex
#endif
p	|int	|yyparse
p	|int	|yywarn		|char* s
#if defined(MYMALLOC)
Ap	|void	|dump_mstats	|char* s
Ap	|int	|get_mstats	|perl_mstats_t *buf|int buflen|int level
#endif
Anp	|Malloc_t|safesysmalloc	|MEM_SIZE nbytes
Anp	|Malloc_t|safesyscalloc	|MEM_SIZE elements|MEM_SIZE size
Anp	|Malloc_t|safesysrealloc|Malloc_t where|MEM_SIZE nbytes
Anp	|Free_t	|safesysfree	|Malloc_t where
#if defined(LEAKTEST)
Anp	|Malloc_t|safexmalloc	|I32 x|MEM_SIZE size
Anp	|Malloc_t|safexcalloc	|I32 x|MEM_SIZE elements|MEM_SIZE size
Anp	|Malloc_t|safexrealloc	|Malloc_t where|MEM_SIZE size
Anp	|void	|safexfree	|Malloc_t where
#endif
#if defined(PERL_GLOBAL_STRUCT)
Ap	|struct perl_vars *|GetVars
#endif
Ap	|int	|runops_standard
Ap	|int	|runops_debug
#if defined(USE_THREADS)
Ap	|SV*	|sv_lock	|SV *sv
#endif
Afpd	|void	|sv_catpvf_mg	|SV *sv|const char* pat|...
Ap	|void	|sv_vcatpvf_mg	|SV* sv|const char* pat|va_list* args
Apd	|void	|sv_catpv_mg	|SV *sv|const char *ptr
Apd	|void	|sv_catpvn_mg	|SV *sv|const char *ptr|STRLEN len
Apd	|void	|sv_catsv_mg	|SV *dstr|SV *sstr
Afpd	|void	|sv_setpvf_mg	|SV *sv|const char* pat|...
Ap	|void	|sv_vsetpvf_mg	|SV* sv|const char* pat|va_list* args
Apd	|void	|sv_setiv_mg	|SV *sv|IV i
Apd	|void	|sv_setpviv_mg	|SV *sv|IV iv
Apd	|void	|sv_setuv_mg	|SV *sv|UV u
Apd	|void	|sv_setnv_mg	|SV *sv|NV num
Apd	|void	|sv_setpv_mg	|SV *sv|const char *ptr
Apd	|void	|sv_setpvn_mg	|SV *sv|const char *ptr|STRLEN len
Apd	|void	|sv_setsv_mg	|SV *dstr|SV *sstr
Apd	|void	|sv_usepvn_mg	|SV *sv|char *ptr|STRLEN len
Ap	|MGVTBL*|get_vtbl	|int vtbl_id
p	|char*	|pv_display	|SV *sv|char *pv|STRLEN cur|STRLEN len \
				|STRLEN pvlim
Afp	|void	|dump_indent	|I32 level|PerlIO *file|const char* pat|...
Ap	|void	|dump_vindent	|I32 level|PerlIO *file|const char* pat \
				|va_list *args
Ap	|void	|do_gv_dump	|I32 level|PerlIO *file|char *name|GV *sv
Ap	|void	|do_gvgv_dump	|I32 level|PerlIO *file|char *name|GV *sv
Ap	|void	|do_hv_dump	|I32 level|PerlIO *file|char *name|HV *sv
Ap	|void	|do_magic_dump	|I32 level|PerlIO *file|MAGIC *mg|I32 nest \
				|I32 maxnest|bool dumpops|STRLEN pvlim
Ap	|void	|do_op_dump	|I32 level|PerlIO *file|OP *o
Ap	|void	|do_pmop_dump	|I32 level|PerlIO *file|PMOP *pm
Ap	|void	|do_sv_dump	|I32 level|PerlIO *file|SV *sv|I32 nest \
				|I32 maxnest|bool dumpops|STRLEN pvlim
Ap	|void	|magic_dump	|MAGIC *mg
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
Ap	|void*	|default_protect|volatile JMPENV *je|int *excpt \
				|protect_body_t body|...
Ap	|void*	|vdefault_protect|volatile JMPENV *je|int *excpt \
				|protect_body_t body|va_list *args
#endif
Ap	|void	|reginitcolors
Ap	|char*	|sv_2pv_nolen	|SV* sv
Ap	|char*	|sv_2pvutf8_nolen|SV* sv
Ap	|char*	|sv_2pvbyte_nolen|SV* sv
Ap	|char*	|sv_pv		|SV *sv
Ap	|char*	|sv_pvutf8	|SV *sv
Ap	|char*	|sv_pvbyte	|SV *sv
ApMd	|void   |sv_utf8_upgrade|SV *sv
ApMd	|bool   |sv_utf8_downgrade|SV *sv|bool fail_ok
ApMd	|void   |sv_utf8_encode |SV *sv
ApM	|bool   |sv_utf8_decode |SV *sv
Ap	|void	|sv_force_normal|SV *sv
Ap	|void	|sv_add_backref	|SV *tsv|SV *sv
Ap	|void	|sv_del_backref	|SV *sv
Ap	|void	|tmps_grow	|I32 n
Apd	|SV*	|sv_rvweaken	|SV *sv
p	|int	|magic_killbackrefs|SV *sv|MAGIC *mg
Ap	|OP*	|newANONATTRSUB	|I32 floor|OP *proto|OP *attrs|OP *block
Ap	|CV*	|newATTRSUB	|I32 floor|OP *o|OP *proto|OP *attrs|OP *block
Ap	|void	|newMYSUB	|I32 floor|OP *o|OP *proto|OP *attrs|OP *block
p	|OP *	|my_attrs	|OP *o|OP *attrs
p	|void	|boot_core_xsutils
#if defined(USE_ITHREADS)
Ap	|PERL_CONTEXT*|cx_dup	|PERL_CONTEXT* cx|I32 ix|I32 max
Ap	|PERL_SI*|si_dup	|PERL_SI* si
Ap	|ANY*	|ss_dup		|PerlInterpreter* proto_perl
Ap	|void*	|any_dup	|void* v|PerlInterpreter* proto_perl
Ap	|HE*	|he_dup		|HE* e|bool shared
Ap	|REGEXP*|re_dup		|REGEXP* r
Ap	|PerlIO*|fp_dup		|PerlIO* fp|char type
Ap	|DIR*	|dirp_dup	|DIR* dp
Ap	|GP*	|gp_dup		|GP* gp
Ap	|MAGIC*	|mg_dup		|MAGIC* mg
Ap	|SV*	|sv_dup		|SV* sstr
#if defined(HAVE_INTERP_INTERN)
Ap	|void	|sys_intern_dup	|struct interp_intern* src \
				|struct interp_intern* dst
#endif
Ap	|PTR_TBL_t*|ptr_table_new
Ap	|void*	|ptr_table_fetch|PTR_TBL_t *tbl|void *sv
Ap	|void	|ptr_table_store|PTR_TBL_t *tbl|void *oldsv|void *newsv
Ap	|void	|ptr_table_split|PTR_TBL_t *tbl
#endif
#if defined(HAVE_INTERP_INTERN)
Ap	|void	|sys_intern_clear
Ap	|void	|sys_intern_init
#endif

#if defined(PERL_OBJECT)
protected:
#else
END_EXTERN_C
#endif

#if defined(PERL_IN_AV_C) || defined(PERL_DECL_PROT)
s	|I32	|avhv_index_sv	|SV* sv
s	|I32	|avhv_index	|AV* av|SV* sv|U32 hash
#endif

#if defined(PERL_IN_DOOP_C) || defined(PERL_DECL_PROT)
s	|I32	|do_trans_simple	|SV *sv
s	|I32	|do_trans_count		|SV *sv
s	|I32	|do_trans_complex	|SV *sv
s	|I32	|do_trans_simple_utf8	|SV *sv
s	|I32	|do_trans_count_utf8	|SV *sv
s	|I32	|do_trans_complex_utf8	|SV *sv
#endif

#if defined(PERL_IN_GV_C) || defined(PERL_DECL_PROT)
s	|void	|gv_init_sv	|GV *gv|I32 sv_type
#endif

#if defined(PERL_IN_HV_C) || defined(PERL_DECL_PROT)
s	|void	|hsplit		|HV *hv
s	|void	|hfreeentries	|HV *hv
s	|void	|more_he
s	|HE*	|new_he
s	|void	|del_he		|HE *p
s	|HEK*	|save_hek	|const char *str|I32 len|U32 hash
s	|void	|hv_magic_check	|HV *hv|bool *needs_copy|bool *needs_store
#endif

#if defined(PERL_IN_MG_C) || defined(PERL_DECL_PROT)
s	|void	|save_magic	|I32 mgs_ix|SV *sv
s	|int	|magic_methpack	|SV *sv|MAGIC *mg|char *meth
s	|int	|magic_methcall	|SV *sv|MAGIC *mg|char *meth|I32 f \
				|int n|SV *val
#endif

#if defined(PERL_IN_OP_C) || defined(PERL_DECL_PROT)
s	|I32	|list_assignment|OP *o
s	|void	|bad_type	|I32 n|char *t|char *name|OP *kid
s	|void	|cop_free	|COP *cop
s	|OP*	|modkids	|OP *o|I32 type
s	|void	|no_bareword_allowed|OP *o
s	|OP*	|no_fh_allowed	|OP *o
s	|OP*	|scalarboolean	|OP *o
s	|OP*	|too_few_arguments|OP *o|char* name
s	|OP*	|too_many_arguments|OP *o|char* name
s	|U8*	|trlist_upgrade	|U8** sp|U8** ep
s	|void	|op_clear	|OP* o
s	|void	|null		|OP* o
s	|PADOFFSET|pad_addlex	|SV* name
s	|PADOFFSET|pad_findlex	|char* name|PADOFFSET newoff|U32 seq \
				|CV* startcv|I32 cx_ix|I32 saweval|U32 flags
s	|OP*	|newDEFSVOP
s	|OP*	|new_logop	|I32 type|I32 flags|OP **firstp|OP **otherp
s	|void	|simplify_sort	|OP *o
s	|bool	|is_handle_constructor	|OP *o|I32 argnum
s	|char*	|gv_ename	|GV *gv
s	|void	|cv_dump	|CV *cv
s	|CV*	|cv_clone2	|CV *proto|CV *outside
s	|bool	|scalar_mod_type|OP *o|I32 type
s	|OP *	|my_kid		|OP *o|OP *attrs
s	|OP *	|dup_attrlist	|OP *o
s	|void	|apply_attrs	|HV *stash|SV *target|OP *attrs
#  if defined(PL_OP_SLAB_ALLOC)
s	|void*	|Slab_Alloc	|int m|size_t sz
#  endif
#endif

#if defined(PERL_IN_PERL_C) || defined(PERL_DECL_PROT)
s	|void	|find_beginning
s	|void	|forbid_setid	|char *
s	|void	|incpush	|char *|int|int
s	|void	|init_interp
s	|void	|init_ids
s	|void	|init_lexer
s	|void	|init_main_stash
s	|void	|init_perllib
s	|void	|init_postdump_symbols|int|char **|char **
s	|void	|init_predump_symbols
rs	|void	|my_exit_jump
s	|void	|nuke_stacks
s	|void	|open_script	|char *|bool|SV *|int *fd
s	|void	|usage		|char *
s	|void	|validate_suid	|char *|char*|int
#  if defined(IAMSUID)
s	|int	|fd_on_nosuid_fs|int fd
#  endif
s	|void*	|parse_body	|char **env|XSINIT_t xsinit
s	|void*	|run_body	|I32 oldscope
s	|void	|call_body	|OP *myop|int is_eval
s	|void*	|call_list_body	|CV *cv
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
s	|void*	|vparse_body	|va_list args
s	|void*	|vrun_body	|va_list args
s	|void*	|vcall_body	|va_list args
s	|void*	|vcall_list_body|va_list args
#endif
#  if defined(USE_THREADS)
s	|struct perl_thread *	|init_main_thread
#  endif
#endif

#if defined(PERL_IN_PP_C) || defined(PERL_DECL_PROT)
s	|void	|doencodes	|SV* sv|char* s|I32 len
s	|SV*	|refto		|SV* sv
s	|U32	|seed
s	|SV*	|mul128		|SV *sv|U8 m
s	|SV*	|is_an_int	|char *s|STRLEN l
s	|int	|div128		|SV *pnum|bool *done
#endif

#if defined(PERL_IN_PP_CTL_C) || defined(PERL_DECL_PROT)
s	|OP*	|docatch	|OP *o
s	|void*	|docatch_body
#if defined(PERL_FLEXIBLE_EXCEPTIONS)
s	|void*	|vdocatch_body	|va_list args
#endif
s	|OP*	|dofindlabel	|OP *o|char *label|OP **opstack|OP **oplimit
s	|void	|doparseform	|SV *sv
s	|I32	|dopoptoeval	|I32 startingblock
s	|I32	|dopoptolabel	|char *label
s	|I32	|dopoptoloop	|I32 startingblock
s	|I32	|dopoptosub	|I32 startingblock
s	|I32	|dopoptosub_at	|PERL_CONTEXT* cxstk|I32 startingblock
s	|void	|free_closures
s	|void	|save_lines	|AV *array|SV *sv
s	|OP*	|doeval		|int gimme|OP** startop
s	|PerlIO *|doopen_pmc	|const char *name|const char *mode
s	|void	|qsortsv	|SV ** array|size_t num_elts|SVCOMPARE_t f
#endif

#if defined(PERL_IN_PP_HOT_C) || defined(PERL_DECL_PROT)
s	|int	|do_maybe_phash	|AV *ary|SV **lelem|SV **firstlelem \
				|SV **relem|SV **lastrelem
s	|void	|do_oddball	|HV *hash|SV **relem|SV **firstrelem
s	|CV*	|get_db_sub	|SV **svp|CV *cv
s	|SV*	|method_common	|SV* meth|U32* hashp
#endif

#if defined(PERL_IN_PP_SYS_C) || defined(PERL_DECL_PROT)
s	|OP*	|doform		|CV *cv|GV *gv|OP *retop
s	|int	|emulate_eaccess|const char* path|Mode_t mode
#  if !defined(HAS_MKDIR) || !defined(HAS_RMDIR)
s	|int	|dooneliner	|char *cmd|char *filename
#  endif
#endif

#if defined(PERL_IN_REGCOMP_C) || defined(PERL_DECL_PROT)
s	|regnode*|reg		|I32|I32 *
s	|regnode*|reganode	|U8|U32
s	|regnode*|regatom	|I32 *
s	|regnode*|regbranch	|I32 *|I32
s	|void	|reguni		|UV|char *|STRLEN*
s	|regnode*|regclass
s	|regnode*|regclassutf8
s	|I32	|regcurly	|char *
s	|regnode*|reg_node	|U8
s	|regnode*|regpiece	|I32 *
s	|void	|reginsert	|U8|regnode *
s	|void	|regoptail	|regnode *|regnode *
s	|void	|regtail	|regnode *|regnode *
s	|char*|regwhite	|char *|char *
s	|char*|nextchar
s	|regnode*|dumpuntil	|regnode *start|regnode *node \
				|regnode *last|SV* sv|I32 l
s	|void	|put_byte	|SV* sv|int c
s	|void	|scan_commit	|struct scan_data_t *data
s	|void	|cl_anything	|struct regnode_charclass_class *cl
s	|int	|cl_is_anything	|struct regnode_charclass_class *cl
s	|void	|cl_init	|struct regnode_charclass_class *cl
s	|void	|cl_init_zero	|struct regnode_charclass_class *cl
s	|void	|cl_and		|struct regnode_charclass_class *cl \
				|struct regnode_charclass_class *and_with
s	|void	|cl_or		|struct regnode_charclass_class *cl \
				|struct regnode_charclass_class *or_with
s	|I32	|study_chunk	|regnode **scanp|I32 *deltap \
				|regnode *last|struct scan_data_t *data \
				|U32 flags
s	|I32	|add_data	|I32 n|char *s
rs	|void|re_croak2	|const char* pat1|const char* pat2|...
s	|I32	|regpposixcc	|I32 value
s	|void	|checkposixcc
#endif

#if defined(PERL_IN_REGEXEC_C) || defined(PERL_DECL_PROT)
s	|I32	|regmatch	|regnode *prog
s	|I32	|regrepeat	|regnode *p|I32 max
s	|I32	|regrepeat_hard	|regnode *p|I32 max|I32 *lp
s	|I32	|regtry		|regexp *prog|char *startpos
s	|bool	|reginclass	|regnode *p|I32 c
s	|bool	|reginclassutf8	|regnode *f|U8* p
s	|CHECKPOINT|regcppush	|I32 parenfloor
s	|char*|regcppop
s	|char*|regcp_set_to	|I32 ss
s	|void	|cache_re	|regexp *prog
s	|U8*	|reghop		|U8 *pos|I32 off
s	|U8*	|reghopmaybe	|U8 *pos|I32 off
s	|char*	|find_byclass	|regexp * prog|regnode *c|char *s|char *strend|char *startpos|I32 norun
#endif

#if defined(PERL_IN_RUN_C) || defined(PERL_DECL_PROT)
s	|void	|debprof	|OP *o
#endif

#if defined(PERL_IN_SCOPE_C) || defined(PERL_DECL_PROT)
s	|SV*	|save_scalar_at	|SV **sptr
#endif

#if defined(PERL_IN_SV_C) || defined(PERL_DECL_PROT)
s	|IV	|asIV		|SV* sv
s	|UV	|asUV		|SV* sv
s	|SV*	|more_sv
s	|void	|more_xiv
s	|void	|more_xnv
s	|void	|more_xpv
s	|void	|more_xpviv
s	|void	|more_xpvnv
s	|void	|more_xpvcv
s	|void	|more_xpvav
s	|void	|more_xpvhv
s	|void	|more_xpvmg
s	|void	|more_xpvlv
s	|void	|more_xpvbm
s	|void	|more_xrv
s	|XPVIV*	|new_xiv
s	|XPVNV*	|new_xnv
s	|XPV*	|new_xpv
s	|XPVIV*	|new_xpviv
s	|XPVNV*	|new_xpvnv
s	|XPVCV*	|new_xpvcv
s	|XPVAV*	|new_xpvav
s	|XPVHV*	|new_xpvhv
s	|XPVMG*	|new_xpvmg
s	|XPVLV*	|new_xpvlv
s	|XPVBM*	|new_xpvbm
s	|XRV*	|new_xrv
s	|void	|del_xiv	|XPVIV* p
s	|void	|del_xnv	|XPVNV* p
s	|void	|del_xpv	|XPV* p
s	|void	|del_xpviv	|XPVIV* p
s	|void	|del_xpvnv	|XPVNV* p
s	|void	|del_xpvcv	|XPVCV* p
s	|void	|del_xpvav	|XPVAV* p
s	|void	|del_xpvhv	|XPVHV* p
s	|void	|del_xpvmg	|XPVMG* p
s	|void	|del_xpvlv	|XPVLV* p
s	|void	|del_xpvbm	|XPVBM* p
s	|void	|del_xrv	|XRV* p
s	|void	|sv_unglob	|SV* sv
s	|void	|not_a_number	|SV *sv
s	|void	|visit		|SVFUNC_t f
#  if defined(DEBUGGING)
s	|void	|del_sv	|SV *p
#  endif
#endif

#if defined(PERL_IN_TOKE_C) || defined(PERL_DECL_PROT)
s	|void	|check_uni
s	|void	|force_next	|I32 type
s	|char*	|force_version	|char *start
s	|char*	|force_word	|char *start|int token|int check_keyword \
				|int allow_pack|int allow_tick
s	|SV*	|tokeq		|SV *sv
s	|char*	|scan_const	|char *start
s	|char*	|scan_formline	|char *s
s	|char*	|scan_heredoc	|char *s
s	|char*	|scan_ident	|char *s|char *send|char *dest \
				|STRLEN destlen|I32 ck_uni
s	|char*	|scan_inputsymbol|char *start
s	|char*	|scan_pat	|char *start|I32 type
s	|char*	|scan_str	|char *start|int keep_quoted|int keep_delims
s	|char*	|scan_subst	|char *start
s	|char*	|scan_trans	|char *start
s	|char*	|scan_word	|char *s|char *dest|STRLEN destlen \
				|int allow_package|STRLEN *slp
s	|char*	|skipspace	|char *s
s	|char*	|swallow_bom	|U8 *s
s	|void	|checkcomma	|char *s|char *name|char *what
s	|void	|force_ident	|char *s|int kind
s	|void	|incline	|char *s
s	|int	|intuit_method	|char *s|GV *gv
s	|int	|intuit_more	|char *s
s	|I32	|lop		|I32 f|int x|char *s
s	|void	|missingterm	|char *s
s	|void	|no_op		|char *what|char *s
s	|void	|set_csh
s	|I32	|sublex_done
s	|I32	|sublex_push
s	|I32	|sublex_start
s	|char *	|filter_gets	|SV *sv|PerlIO *fp|STRLEN append
s	|HV *	|find_in_my_stash|char *pkgname|I32 len
s	|SV*	|new_constant	|char *s|STRLEN len|const char *key|SV *sv \
				|SV *pv|const char *type
s	|int	|ao		|int toketype
s	|void	|depcom
s	|char*	|incl_perldb
#if 0
s	|I32	|utf16_textfilter|int idx|SV *sv|int maxlen
s	|I32	|utf16rev_textfilter|int idx|SV *sv|int maxlen
#endif
#  if defined(CRIPPLED_CC)
s	|int	|uni		|I32 f|char *s
#  endif
#  if defined(PERL_CR_FILTER)
s	|I32	|cr_textfilter	|int idx|SV *sv|int maxlen
#  endif
#endif

#if defined(PERL_IN_UNIVERSAL_C) || defined(PERL_DECL_PROT)
s	|SV*|isa_lookup	|HV *stash|const char *name|int len|int level
#endif

#if defined(PERL_IN_UTIL_C) || defined(PERL_DECL_PROT)
s	|char*	|stdize_locale	|char* locs
s	|SV*	|mess_alloc
#  if defined(LEAKTEST)
s	|void	|xstat		|int
#  endif
#endif

#if defined(PERL_OBJECT)
};
#endif
