/*
 * Decompiled with CFR 0.152.
 */
package com.vizdom.util;

import com.vizdom.util.CharacterEncodable;
import com.vizdom.util.CharacterEncoderDecMcs;
import com.vizdom.util.CharacterEncoderEuropa3;
import com.vizdom.util.CharacterEncoderHpRoman8;
import com.vizdom.util.CharacterEncoderHpRoman9;
import com.vizdom.util.CharacterEncoderReader;
import com.vizdom.util.CharacterEncoderWriter;
import com.vizdom.util.CharsetEncodable;
import com.vizdom.util.UnreachableCodeException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class CharacterEncoder
implements CharacterEncodable {
    private static final Logger gLog = LogManager.getLogger(CharacterEncoder.class);
    private static HashMap<String, CharacterEncoder> gEncoders = new HashMap();
    protected int[] mByteToCharTable;
    protected int[] mCharToByteTable;
    protected char[] mCharExceptions;
    protected byte[] mByteExceptions;
    protected char mUnicodeUnknownCharacter = (char)65533;
    protected byte mNativeUnknownCharacter;

    public static String getDefaultEncoding() {
        byte[] b = new byte[]{};
        InputStreamReader reader = new InputStreamReader(new ByteArrayInputStream(b));
        String encoding = reader.getEncoding();
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return encoding;
    }

    public static byte[] toByteArray(String aString, String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            return aString.getBytes(anEncoding);
        }
        return enc.gConvertAll(aString);
    }

    public static String toString(byte[] aByteArray, String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            return new String(aByteArray, anEncoding);
        }
        return enc.gConvertAll(aByteArray);
    }

    public static String toString(byte[] aByteArray, int anOffset, int aLength, String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            return new String(aByteArray, anOffset, aLength, anEncoding);
        }
        return enc.gConvert(aByteArray, anOffset, aLength);
    }

    public static Writer toWriter(OutputStream anOut, String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            return new OutputStreamWriter(anOut, anEncoding);
        }
        return new CharacterEncoderWriter(anOut, enc);
    }

    public static Reader toReader(InputStream anIn, String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            return new InputStreamReader(anIn, anEncoding);
        }
        return new CharacterEncoderReader(anIn, enc);
    }

    public static CharacterEncodable getCharacterEncodable(String anEncoding) throws UnsupportedEncodingException {
        CharacterEncoder enc = CharacterEncoder.gGetEncoder(anEncoding);
        if (enc == null) {
            try {
                return new CharsetEncodable(anEncoding);
            }
            catch (UnsupportedCharsetException e) {
                UnsupportedEncodingException ue = new UnsupportedEncodingException(anEncoding);
                ue.initCause(e);
                throw ue;
            }
        }
        return enc;
    }

    private static synchronized CharacterEncoder gGetEncoder(String anEncoding) {
        CharacterEncoder enc = gEncoders.get(anEncoding);
        if (enc == null && gEncoders.containsKey(anEncoding)) {
            if (anEncoding.equals("DEC_MCS")) {
                enc = new CharacterEncoderDecMcs();
                gEncoders.put(anEncoding, enc);
            } else if (anEncoding.equals("HP_Roman8")) {
                enc = new CharacterEncoderHpRoman8();
                gEncoders.put(anEncoding, enc);
            } else if (anEncoding.equals("HP_Roman9")) {
                enc = new CharacterEncoderHpRoman9();
                gEncoders.put(anEncoding, enc);
            } else if (anEncoding.equals("Europa_3")) {
                enc = new CharacterEncoderEuropa3();
                gEncoders.put(anEncoding, enc);
            } else {
                throw new UnreachableCodeException();
            }
        }
        return enc;
    }

    private byte[] gConvertAll(String aString) {
        byte[] bytes = new byte[aString.length()];
        for (int i = 0; i < aString.length(); ++i) {
            bytes[i] = this.getNative(aString.charAt(i));
        }
        return bytes;
    }

    private byte[] gConvertAll(char[] aCharacterArray) {
        return this.gConvert(aCharacterArray, 0, aCharacterArray.length);
    }

    final byte[] gConvert(char[] aCharacterArray, int anOffset, int aLength) {
        byte[] bytes = new byte[aLength];
        for (int i = anOffset; i < anOffset + aLength; ++i) {
            bytes[i] = this.getNative(aCharacterArray[i]);
        }
        return bytes;
    }

    private String gConvertAll(byte[] aByteArray) {
        return this.gConvert(aByteArray, 0, aByteArray.length);
    }

    private String gConvert(byte[] aByteArray, int anOffset, int aLength) {
        StringBuffer buffer = new StringBuffer(aLength);
        for (int i = anOffset; i < anOffset + aLength; ++i) {
            buffer.append(this.getUnicode(aByteArray[i]));
        }
        return buffer.toString();
    }

    private byte getNative(char aCharacter) {
        char index = aCharacter;
        if (index < this.mCharToByteTable.length) {
            return (byte)(this.mCharToByteTable[index] & 0xFF);
        }
        if (this.mCharExceptions != null) {
            for (int i = 0; i < this.mCharExceptions.length; ++i) {
                if (this.mCharExceptions[i] != aCharacter) continue;
                return this.mByteExceptions[i];
            }
            return this.mNativeUnknownCharacter;
        }
        return this.mNativeUnknownCharacter;
    }

    final char getUnicode(byte aByte) {
        int index = aByte & 0xFF;
        return (char)this.mByteToCharTable[index];
    }

    @Override
    public boolean canEncode(char aCharacter) {
        char index = aCharacter;
        if (index < this.mCharToByteTable.length && (byte)aCharacter == this.mNativeUnknownCharacter) {
            return true;
        }
        return this.getNative(aCharacter) != this.mNativeUnknownCharacter;
    }

    static {
        gEncoders.put("DEC_MCS", null);
        gEncoders.put("HP_Roman8", null);
        gEncoders.put("HP_Roman9", null);
        gEncoders.put("Europa_3", null);
    }
}

