#!/usr/bin/perl

package eBay::API::XML::DataType::BuyingGuideType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BuyingGuideType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BuyingGuideType

=head1 DESCRIPTION

Information that identifies a buying guide. A buying guide provides content about particular
product areas, categories, or subjects to help buyers decide which type of item
to purchase based on their particular interests.
Buying guides are useful to buyers who do not have a specific product in mind.
For example, a digital camera buying guide could help a buyer determine what kind of
digital camera is right for them.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BuyingGuideType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'CategoryID', 'xs:string', '', '', '' ]
	, [ 'CreationTime', 'xs:dateTime', '', '', '' ]
	, [ 'Name', 'xs:string', '', '', '' ]
	, [ 'ProductFinderID', 'xs:int', '', '', '' ]
	, [ 'Text', 'xs:string', '', '', '' ]
	, [ 'Title', 'xs:string', '', '', '' ]
	, [ 'URL', 'xs:anyURI', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setCategoryID()

Identifies the category (if any) that is associated
with the buying guide. For GetSearchResults, this can be a category that is higher or lower in the hierarchy
than the category specified in the request. For a matching categories search,
you can use this information to determine the order that the buying guides are
returned in when multiple guides are found.
Optionally, you can use this information to determine where to present
the buying guide link in your application.
Not returned for product finder searches.

MaxLength: 10

#    Argument: 'xs:string'

=cut

sub setCategoryID {
  my $self = shift;
  $self->{'CategoryID'} = shift
}

=head2 getCategoryID()

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getCategoryID {
  my $self = shift;
  return $self->{'CategoryID'};
}


=head2 setCreationTime()

The time and date when the guide was posted.

#    Argument: 'xs:dateTime'

=cut

sub setCreationTime {
  my $self = shift;
  $self->{'CreationTime'} = shift
}

=head2 getCreationTime()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:dateTime'

=cut

sub getCreationTime {
  my $self = shift;
  return $self->{'CreationTime'};
}


=head2 setName()

Display name of the buying guide. <br>
<br>
GetProducts only returns 20 characters, followed by "..." if the name is
longer than 20 characters. For the full title, see BuyingGuide.Title
instead.

#    Argument: 'xs:string'

=cut

sub setName {
  my $self = shift;
  $self->{'Name'} = shift
}

=head2 getName()

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally
  MaxLength: 23

#    Returns: 'xs:string'

=cut

sub getName {
  my $self = shift;
  return $self->{'Name'};
}


=head2 setProductFinderID()

Identifies the product finder (if any) that is associated with the buying guide.
Only returned for product finder searches.

#    Argument: 'xs:int'

=cut

sub setProductFinderID {
  my $self = shift;
  $self->{'ProductFinderID'} = shift
}

=head2 getProductFinderID()

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll

#    Returns: 'xs:int'

=cut

sub getProductFinderID {
  my $self = shift;
  return $self->{'ProductFinderID'};
}


=head2 setText()

The text of the guide. If the guide is longer than
2000 characters, the text is cut off and it ends with "...".
See BuyingGuide.URL for a link to the full text of the review.

#    Argument: 'xs:string'

=cut

sub setText {
  my $self = shift;
  $self->{'Text'} = shift
}

=head2 getText()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:string'

=cut

sub getText {
  my $self = shift;
  return $self->{'Text'};
}


=head2 setTitle()

The title of the buying guide.

#    Argument: 'xs:string'

=cut

sub setTitle {
  my $self = shift;
  $self->{'Title'} = shift
}

=head2 getTitle()

  Calls: GetProducts
  Returned: Conditionally
  MaxLength: 55

#    Returns: 'xs:string'

=cut

sub getTitle {
  my $self = shift;
  return $self->{'Title'};
}


=head2 setURL()

URL for the buying guide. Your application can
present this as a link. Use the value of Name as the link's display name.

#    Argument: 'xs:anyURI'

=cut

sub setURL {
  my $self = shift;
  $self->{'URL'} = shift
}

=head2 getURL()

  Calls: GetCategoryListings
  Returned: Conditionally

  Calls: GetSearchResults
  Returned: Conditionally
  Details: DetailLevel: ItemReturnAttributes, ItemReturnCategories, none, ReturnAll
           GranularityLevel: Coarse


  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'xs:anyURI'

=cut

sub getURL {
  my $self = shift;
  return $self->{'URL'};
}


=head2 setUserID()

The author's eBay user ID.

#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

  Calls: GetProducts
  Returned: Conditionally

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
