// /** vim: et:ts=4:sw=4:sts=4
//  * @license RequireJS 2.0.2 Copyright (c) 2010-2012, The Dojo Foundation All Rights Reserved.
//  * Available via the MIT or new BSD license.
//  * see: http://github.com/jrburke/requirejs for details
//  */
// /*jslint regexp: true, nomen: true */
// /*global window, navigator, document, importScripts, jQuery, setTimeout, opera */

// var requirejs, require, define;
// (function (global) {
//     'use strict';

//     var version = '2.0.2',
//         commentRegExp = /(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg,
//         cjsRequireRegExp = /require\s*\(\s*["']([^'"\s]+)["']\s*\)/g,
//         jsSuffixRegExp = /\.js$/,
//         currDirRegExp = /^\.\//,
//         ostring = Object.prototype.toString,
//         ap = Array.prototype,
//         aps = ap.slice,
//         apsp = ap.splice,
//         isBrowser = !!(typeof window !== 'undefined' && navigator && document),
//         isWebWorker = !isBrowser && typeof importScripts !== 'undefined',
//         //PS3 indicates loaded and complete, but need to wait for complete
//         //specifically. Sequence is 'loading', 'loaded', execution,
//         // then 'complete'. The UA check is unfortunate, but not sure how
//         //to feature test w/o causing perf issues.
//         readyRegExp = isBrowser && navigator.platform === 'PLAYSTATION 3' ?
//                       /^complete$/ : /^(complete|loaded)$/,
//         defContextName = '_',
//         //Oh the tragedy, detecting opera. See the usage of isOpera for reason.
//         isOpera = typeof opera !== 'undefined' && opera.toString() === '[object Opera]',
//         contexts = {},
//         cfg = {},
//         globalDefQueue = [],
//         useInteractive = false,
//         req, s, head, baseElement, dataMain, src,
//         interactiveScript, currentlyAddingScript, mainScript, subPath;

//     function isFunction(it) {
//         return ostring.call(it) === '[object Function]';
//     }

//     function isArray(it) {
//         return ostring.call(it) === '[object Array]';
//     }

//     /**
//      * Helper function for iterating over an array. If the func returns
//      * a true value, it will break out of the loop.
//      */
//     function each(ary, func) {
//         if (ary) {
//             var i;
//             for (i = 0; i < ary.length; i += 1) {
//                 if (ary[i] && func(ary[i], i, ary)) {
//                     break;
//                 }
//             }
//         }
//     }

//     /**
//      * Helper function for iterating over an array backwards. If the func
//      * returns a true value, it will break out of the loop.
//      */
//     function eachReverse(ary, func) {
//         if (ary) {
//             var i;
//             for (i = ary.length - 1; i > -1; i -= 1) {
//                 if (ary[i] && func(ary[i], i, ary)) {
//                     break;
//                 }
//             }
//         }
//     }

//     function hasProp(obj, prop) {
//         return obj.hasOwnProperty(prop);
//     }

//     /**
//      * Cycles over properties in an object and calls a function for each
//      * property value. If the function returns a truthy value, then the
//      * iteration is stopped.
//      */
//     function eachProp(obj, func) {
//         var prop;
//         for (prop in obj) {
//             if (obj.hasOwnProperty(prop)) {
//                 if (func(obj[prop], prop)) {
//                     break;
//                 }
//             }
//         }
//     }

//     /**
//      * Simple function to mix in properties from source into target,
//      * but only if target does not already have a property of the same name.
//      * This is not robust in IE for transferring methods that match
//      * Object.prototype names, but the uses of mixin here seem unlikely to
//      * trigger a problem related to that.
//      */
//     function mixin(target, source, force, deepStringMixin) {
//         if (source) {
//             eachProp(source, function (value, prop) {
//                 if (force || !hasProp(target, prop)) {
//                     if (deepStringMixin && typeof value !== 'string') {
//                         if (!target[prop]) {
//                             target[prop] = {};
//                         }
//                         mixin(target[prop], value, force, deepStringMixin);
//                     } else {
//                         target[prop] = value;
//                     }
//                 }
//             });
//         }
//         return target;
//     }

//     //Similar to Function.prototype.bind, but the 'this' object is specified
//     //first, since it is easier to read/figure out what 'this' will be.
//     function bind(obj, fn) {
//         return function () {
//             return fn.apply(obj, arguments);
//         };
//     }

//     function scripts() {
//         return document.getElementsByTagName('script');
//     }

//     //Allow getting a global that expressed in
//     //dot notation, like 'a.b.c'.
//     function getGlobal(value) {
//         if (!value) {
//             return value;
//         }
//         var g = global;
//         each(value.split('.'), function (part) {
//             g = g[part];
//         });
//         return g;
//     }

//     function makeContextModuleFunc(func, relMap, enableBuildCallback) {
//         return function () {
//             //A version of a require function that passes a moduleName
//             //value for items that may need to
//             //look up paths relative to the moduleName
//             var args = aps.call(arguments, 0), lastArg;
//             if (enableBuildCallback &&
//                 isFunction((lastArg = args[args.length - 1]))) {
//                 lastArg.__requireJsBuild = true;
//             }
//             args.push(relMap);
//             return func.apply(null, args);
//         };
//     }

//     function addRequireMethods(req, context, relMap) {
//         each([
//             ['toUrl'],
//             ['undef'],
//             ['defined', 'requireDefined'],
//             ['specified', 'requireSpecified']
//         ], function (item) {
//             var prop = item[1] || item[0];
//             req[item[0]] = context ? makeContextModuleFunc(context[prop], relMap) :
//                 //If no context, then use default context. Reference from
//                 //contexts instead of early binding to default context, so
//                 //that during builds, the latest instance of the default
//                 //context with its config gets used.
//                 function () {
//                     var ctx = contexts[defContextName];
//                     return ctx[prop].apply(ctx, arguments);
//                 };
//         });
//     }

//     /**
//      * Constructs an error with a pointer to an URL with more information.
//      * @param {String} id the error ID that maps to an ID on a web page.
//      * @param {String} message human readable error.
//      * @param {Error} [err] the original error, if there is one.
//      *
//      * @returns {Error}
//      */
//     function makeError(id, msg, err, requireModules) {
//         var e = new Error(msg + '\nhttp://requirejs.org/docs/errors.html#' + id);
//         e.requireType = id;
//         e.requireModules = requireModules;
//         if (err) {
//             e.originalError = err;
//         }
//         return e;
//     }

//     if (typeof define !== 'undefined') {
//         //If a define is already in play via another AMD loader,
//         //do not overwrite.
//         return;
//     }

//     if (typeof requirejs !== 'undefined') {
//         if (isFunction(requirejs)) {
//             //Do not overwrite and existing requirejs instance.
//             return;
//         }
//         cfg = requirejs;
//         requirejs = undefined;
//     }

//     //Allow for a require config object
//     if (typeof require !== 'undefined' && !isFunction(require)) {
//         //assume it is a config object.
//         cfg = require;
//         require = undefined;
//     }

//     function newContext(contextName) {
//         var config = {
//                 waitSeconds: 7,
//                 baseUrl: './',
//                 paths: {},
//                 pkgs: {},
//                 shim: {}
//             },
//             registry = {},
//             undefEvents = {},
//             defQueue = [],
//             defined = {},
//             urlFetched = {},
//             requireCounter = 1,
//             unnormalizedCounter = 1,
//             //Used to track the order in which modules
//             //should be executed, by the order they
//             //load. Important for consistent cycle resolution
//             //behavior.
//             waitAry = [],
//             inCheckLoaded, Module, context, handlers,
//             checkLoadedTimeoutId;

//         /**
//          * Trims the . and .. from an array of path segments.
//          * It will keep a leading path segment if a .. will become
//          * the first path segment, to help with module name lookups,
//          * which act like paths, but can be remapped. But the end result,
//          * all paths that use this function should look normalized.
//          * NOTE: this method MODIFIES the input array.
//          * @param {Array} ary the array of path segments.
//          */
//         function trimDots(ary) {
//             var i, part;
//             for (i = 0; ary[i]; i+= 1) {
//                 part = ary[i];
//                 if (part === '.') {
//                     ary.splice(i, 1);
//                     i -= 1;
//                 } else if (part === '..') {
//                     if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {
//                         //End of the line. Keep at least one non-dot
//                         //path segment at the front so it can be mapped
//                         //correctly to disk. Otherwise, there is likely
//                         //no path mapping for a path starting with '..'.
//                         //This can still fail, but catches the most reasonable
//                         //uses of ..
//                         break;
//                     } else if (i > 0) {
//                         ary.splice(i - 1, 2);
//                         i -= 2;
//                     }
//                 }
//             }
//         }

//         /**
//          * Given a relative module name, like ./something, normalize it to
//          * a real name that can be mapped to a path.
//          * @param {String} name the relative name
//          * @param {String} baseName a real name that the name arg is relative
//          * to.
//          * @param {Boolean} applyMap apply the map config to the value. Should
//          * only be done if this normalization is for a dependency ID.
//          * @returns {String} normalized name
//          */
//         function normalize(name, baseName, applyMap) {
//             var baseParts = baseName && baseName.split('/'),
//                 map = config.map,
//                 starMap = map && map['*'],
//                 pkgName, pkgConfig, mapValue, nameParts, i, j, nameSegment,
//                 foundMap;

//             //Adjust any relative paths.
//             if (name && name.charAt(0) === '.') {
//                 //If have a base name, try to normalize against it,
//                 //otherwise, assume it is a top-level require that will
//                 //be relative to baseUrl in the end.
//                 if (baseName) {
//                     if (config.pkgs[baseName]) {
//                         //If the baseName is a package name, then just treat it as one
//                         //name to concat the name with.
//                         baseParts = [baseName];
//                     } else {
//                         //Convert baseName to array, and lop off the last part,
//                         //so that . matches that 'directory' and not name of the baseName's
//                         //module. For instance, baseName of 'one/two/three', maps to
//                         //'one/two/three.js', but we want the directory, 'one/two' for
//                         //this normalization.
//                         baseParts = baseParts.slice(0, baseParts.length - 1);
//                     }

//                     name = baseParts.concat(name.split('/'));
//                     trimDots(name);

//                     //Some use of packages may use a . path to reference the
//                     //'main' module name, so normalize for that.
//                     pkgConfig = config.pkgs[(pkgName = name[0])];
//                     name = name.join('/');
//                     if (pkgConfig && name === pkgName + '/' + pkgConfig.main) {
//                         name = pkgName;
//                     }
//                 } else if (name.indexOf('./') === 0) {
//                     // No baseName, so this is ID is resolved relative
//                     // to baseUrl, pull off the leading dot.
//                     name = name.substring(2);
//                 }
//             }

//             //Apply map config if available.
//             if (applyMap && (baseParts || starMap) && map) {
//                 nameParts = name.split('/');

//                 for (i = nameParts.length; i > 0; i -= 1) {
//                     nameSegment = nameParts.slice(0, i).join('/');

//                     if (baseParts) {
//                         //Find the longest baseName segment match in the config.
//                         //So, do joins on the biggest to smallest lengths of baseParts.
//                         for (j = baseParts.length; j > 0; j -= 1) {
//                             mapValue = map[baseParts.slice(0, j).join('/')];

//                             //baseName segment has  config, find if it has one for
//                             //this name.
//                             if (mapValue) {
//                                 mapValue = mapValue[nameSegment];
//                                 if (mapValue) {
//                                     //Match, update name to the new value.
//                                     foundMap = mapValue;
//                                     break;
//                                 }
//                             }
//                         }
//                     }

//                     if (!foundMap && starMap && starMap[nameSegment]) {
//                         foundMap = starMap[nameSegment];
//                     }

//                     if (foundMap) {
//                         nameParts.splice(0, i, foundMap);
//                         name = nameParts.join('/');
//                         break;
//                     }
//                 }
//             }

//             return name;
//         }

//         function removeScript(name) {
//             if (isBrowser) {
//                 each(scripts(), function (scriptNode) {
//                     if (scriptNode.getAttribute('data-requiremodule') === name &&
//                         scriptNode.getAttribute('data-requirecontext') === context.contextName) {
//                         scriptNode.parentNode.removeChild(scriptNode);
//                         return true;
//                     }
//                 });
//             }
//         }

//         function hasPathFallback(id) {
//             var pathConfig = config.paths[id];
//             if (pathConfig && isArray(pathConfig) && pathConfig.length > 1) {
//                 removeScript(id);
//                 //Pop off the first array value, since it failed, and
//                 //retry
//                 pathConfig.shift();
//                 context.undef(id);
//                 context.require([id]);
//                 return true;
//             }
//         }

//         /**
//          * Creates a module mapping that includes plugin prefix, module
//          * name, and path. If parentModuleMap is provided it will
//          * also normalize the name via require.normalize()
//          *
//          * @param {String} name the module name
//          * @param {String} [parentModuleMap] parent module map
//          * for the module name, used to resolve relative names.
//          * @param {Boolean} isNormalized: is the ID already normalized.
//          * This is true if this call is done for a define() module ID.
//          * @param {Boolean} applyMap: apply the map config to the ID.
//          * Should only be true if this map is for a dependency.
//          *
//          * @returns {Object}
//          */
//         function makeModuleMap(name, parentModuleMap, isNormalized, applyMap) {
//             var index = name ? name.indexOf('!') : -1,
//                 prefix = null,
//                 parentName = parentModuleMap ? parentModuleMap.name : null,
//                 originalName = name,
//                 isDefine = true,
//                 normalizedName = '',
//                 url, pluginModule, suffix;

//             //If no name, then it means it is a require call, generate an
//             //internal name.
//             if (!name) {
//                 isDefine = false;
//                 name = '_@r' + (requireCounter += 1);
//             }

//             if (index !== -1) {
//                 prefix = name.substring(0, index);
//                 name = name.substring(index + 1, name.length);
//             }

//             if (prefix) {
//                 prefix = normalize(prefix, parentName, applyMap);
//                 pluginModule = defined[prefix];
//             }

//             //Account for relative paths if there is a base name.
//             if (name) {
//                 if (prefix) {
//                     if (pluginModule && pluginModule.normalize) {
//                         //Plugin is loaded, use its normalize method.
//                         normalizedName = pluginModule.normalize(name, function (name) {
//                             return normalize(name, parentName, applyMap);
//                         });
//                     } else {
//                         normalizedName = normalize(name, parentName, applyMap);
//                     }
//                 } else {
//                     //A regular module.
//                     normalizedName = normalize(name, parentName, applyMap);

//                     //Calculate url for the module, if it has a name.
//                     //Use name here since nameToUrl also calls normalize,
//                     //and for relative names that are outside the baseUrl
//                     //this causes havoc. Was thinking of just removing
//                     //parentModuleMap to avoid extra normalization, but
//                     //normalize() still does a dot removal because of
//                     //issue #142, so just pass in name here and redo
//                     //the normalization. Paths outside baseUrl are just
//                     //messy to support.
//                     url = context.nameToUrl(name, null, parentModuleMap);
//                 }
//             }

//             //If the id is a plugin id that cannot be determined if it needs
//             //normalization, stamp it with a unique ID so two matching relative
//             //ids that may conflict can be separate.
//             suffix = prefix && !pluginModule && !isNormalized ?
//                      '_unnormalized' + (unnormalizedCounter += 1) :
//                      '';

//             return {
//                 prefix: prefix,
//                 name: normalizedName,
//                 parentMap: parentModuleMap,
//                 unnormalized: !!suffix,
//                 url: url,
//                 originalName: originalName,
//                 isDefine: isDefine,
//                 id: (prefix ?
//                     prefix + '!' + normalizedName :
//                     normalizedName) + suffix
//             };
//         }

//         function getModule(depMap) {
//             var id = depMap.id,
//                 mod = registry[id];

//             if (!mod) {
//                 mod = registry[id] = new context.Module(depMap);
//             }

//             return mod;
//         }

//         function on(depMap, name, fn) {
//             var id = depMap.id,
//                 mod = registry[id];

//             if (hasProp(defined, id) &&
//                 (!mod || mod.defineEmitComplete)) {
//                 if (name === 'defined') {
//                     fn(defined[id]);
//                 }
//             } else {
//                 getModule(depMap).on(name, fn);
//             }
//         }

//         function onError(err, errback) {
//             var ids = err.requireModules,
//                 notified = false;

//             if (errback) {
//                 errback(err);
//             } else {
//                 each(ids, function (id) {
//                     var mod = registry[id];
//                     if (mod) {
//                         //Set error on module, so it skips timeout checks.
//                         mod.error = err;
//                         if (mod.events.error) {
//                             notified = true;
//                             mod.emit('error', err);
//                         }
//                     }
//                 });

//                 if (!notified) {
//                     req.onError(err);
//                 }
//             }
//         }

//         /**
//          * Internal method to transfer globalQueue items to this context's
//          * defQueue.
//          */
//         function takeGlobalQueue() {
//             //Push all the globalDefQueue items into the context's defQueue
//             if (globalDefQueue.length) {
//                 //Array splice in the values since the context code has a
//                 //local var ref to defQueue, so cannot just reassign the one
//                 //on context.
//                 apsp.apply(defQueue,
//                            [defQueue.length - 1, 0].concat(globalDefQueue));
//                 globalDefQueue = [];
//             }
//         }

//         /**
//          * Helper function that creates a require function object to give to
//          * modules that ask for it as a dependency. It needs to be specific
//          * per module because of the implication of path mappings that may
//          * need to be relative to the module name.
//          */
//         function makeRequire(mod, enableBuildCallback, altRequire) {
//             var relMap = mod && mod.map,
//                 modRequire = makeContextModuleFunc(altRequire || context.require,
//                                                    relMap,
//                                                    enableBuildCallback);

//             addRequireMethods(modRequire, context, relMap);
//             modRequire.isBrowser = isBrowser;

//             return modRequire;
//         }

//         handlers = {
//             'require': function (mod) {
//                 return makeRequire(mod);
//             },
//             'exports': function (mod) {
//                 mod.usingExports = true;
//                 if (mod.map.isDefine) {
//                     return (mod.exports = defined[mod.map.id] = {});
//                 }
//             },
//             'module': function (mod) {
//                 return (mod.module = {
//                     id: mod.map.id,
//                     uri: mod.map.url,
//                     config: function () {
//                         return (config.config && config.config[mod.map.id]) || {};
//                     },
//                     exports: defined[mod.map.id]
//                 });
//             }
//         };

//         function removeWaiting(id) {
//             //Clean up machinery used for waiting modules.
//             delete registry[id];

//             each(waitAry, function (mod, i) {
//                 if (mod.map.id === id) {
//                     waitAry.splice(i, 1);
//                     if (!mod.defined) {
//                         context.waitCount -= 1;
//                     }
//                     return true;
//                 }
//             });
//         }

//         function findCycle(mod, traced) {
//             var id = mod.map.id,
//                 depArray = mod.depMaps,
//                 foundModule;

//             //Do not bother with unitialized modules or not yet enabled
//             //modules.
//             if (!mod.inited) {
//                 return;
//             }

//             //Found the cycle.
//             if (traced[id]) {
//                 return mod;
//             }

//             traced[id] = true;

//             //Trace through the dependencies.
//             each(depArray, function (depMap) {
//                 var depId = depMap.id,
//                     depMod = registry[depId];

//                 if (!depMod) {
//                     return;
//                 }

//                 if (!depMod.inited || !depMod.enabled) {
//                     //Dependency is not inited, so this cannot
//                     //be used to determine a cycle.
//                     foundModule = null;
//                     delete traced[id];
//                     return true;
//                 }

//                 //mixin traced to a new object for each dependency, so that
//                 //sibling dependencies in this object to not generate a
//                 //false positive match on a cycle. Ideally an Object.create
//                 //type of prototype delegation would be used here, but
//                 //optimizing for file size vs. execution speed since hopefully
//                 //the trees are small for circular dependency scans relative
//                 //to the full app perf.
//                 return (foundModule = findCycle(depMod, mixin({}, traced)));
//             });

//             return foundModule;
//         }

//         function forceExec(mod, traced, uninited) {
//             var id = mod.map.id,
//                 depArray = mod.depMaps;

//             if (!mod.inited || !mod.map.isDefine) {
//                 return;
//             }

//             if (traced[id]) {
//                 return defined[id];
//             }

//             traced[id] = mod;

//             each(depArray, function(depMap) {
//                 var depId = depMap.id,
//                     depMod = registry[depId],
//                     value;

//                 if (handlers[depId]) {
//                     return;
//                 }

//                 if (depMod) {
//                     if (!depMod.inited || !depMod.enabled) {
//                         //Dependency is not inited,
//                         //so this module cannot be
//                         //given a forced value yet.
//                         uninited[id] = true;
//                         return;
//                     }

//                     //Get the value for the current dependency
//                     value = forceExec(depMod, traced, uninited);

//                     //Even with forcing it may not be done,
//                     //in particular if the module is waiting
//                     //on a plugin resource.
//                     if (!uninited[depId]) {
//                         mod.defineDepById(depId, value);
//                     }
//                 }
//             });

//             mod.check(true);

//             return defined[id];
//         }

//         function modCheck(mod) {
//             mod.check();
//         }

//         function checkLoaded() {
//             var waitInterval = config.waitSeconds * 1000,
//                 //It is possible to disable the wait interval by using waitSeconds of 0.
//                 expired = waitInterval && (context.startTime + waitInterval) < new Date().getTime(),
//                 noLoads = [],
//                 stillLoading = false,
//                 needCycleCheck = true,
//                 map, modId, err, usingPathFallback;

//             //Do not bother if this call was a result of a cycle break.
//             if (inCheckLoaded) {
//                 return;
//             }

//             inCheckLoaded = true;

//             //Figure out the state of all the modules.
//             eachProp(registry, function (mod) {
//                 map = mod.map;
//                 modId = map.id;

//                 //Skip things that are not enabled or in error state.
//                 if (!mod.enabled) {
//                     return;
//                 }

//                 if (!mod.error) {
//                     //If the module should be executed, and it has not
//                     //been inited and time is up, remember it.
//                     if (!mod.inited && expired) {
//                         if (hasPathFallback(modId)) {
//                             usingPathFallback = true;
//                             stillLoading = true;
//                         } else {
//                             noLoads.push(modId);
//                             removeScript(modId);
//                         }
//                     } else if (!mod.inited && mod.fetched && map.isDefine) {
//                         stillLoading = true;
//                         if (!map.prefix) {
//                             //No reason to keep looking for unfinished
//                             //loading. If the only stillLoading is a
//                             //plugin resource though, keep going,
//                             //because it may be that a plugin resource
//                             //is waiting on a non-plugin cycle.
//                             return (needCycleCheck = false);
//                         }
//                     }
//                 }
//             });

//             if (expired && noLoads.length) {
//                 //If wait time expired, throw error of unloaded modules.
//                 err = makeError('timeout', 'Load timeout for modules: ' + noLoads, null, noLoads);
//                 err.contextName = context.contextName;
//                 return onError(err);
//             }

//             //Not expired, check for a cycle.
//             if (needCycleCheck) {

//                 each(waitAry, function (mod) {
//                     if (mod.defined) {
//                         return;
//                     }

//                     var cycleMod = findCycle(mod, {}),
//                         traced = {};

//                     if (cycleMod) {
//                         forceExec(cycleMod, traced, {});

//                         //traced modules may have been
//                         //removed from the registry, but
//                         //their listeners still need to
//                         //be called.
//                         eachProp(traced, modCheck);
//                     }
//                 });

//                 //Now that dependencies have
//                 //been satisfied, trigger the
//                 //completion check that then
//                 //notifies listeners.
//                 eachProp(registry, modCheck);
//             }

//             //If still waiting on loads, and the waiting load is something
//             //other than a plugin resource, or there are still outstanding
//             //scripts, then just try back later.
//             if ((!expired || usingPathFallback) && stillLoading) {
//                 //Something is still waiting to load. Wait for it, but only
//                 //if a timeout is not already in effect.
//                 if ((isBrowser || isWebWorker) && !checkLoadedTimeoutId) {
//                     checkLoadedTimeoutId = setTimeout(function () {
//                         checkLoadedTimeoutId = 0;
//                         checkLoaded();
//                     }, 50);
//                 }
//             }

//             inCheckLoaded = false;
//         }

//         Module = function (map) {
//             this.events = undefEvents[map.id] || {};
//             this.map = map;
//             this.shim = config.shim[map.id];
//             this.depExports = [];
//             this.depMaps = [];
//             this.depMatched = [];
//             this.pluginMaps = {};
//             this.depCount = 0;

//             /* this.exports this.factory
//                this.depMaps = [],
//                this.enabled, this.fetched
//             */
//         };

//         Module.prototype = {
//             init: function(depMaps, factory, errback, options) {
//                 options = options || {};

//                 //Do not do more inits if already done. Can happen if there
//                 //are multiple define calls for the same module. That is not
//                 //a normal, common case, but it is also not unexpected.
//                 if (this.inited) {
//                     return;
//                 }

//                 this.factory = factory;

//                 if (errback) {
//                     //Register for errors on this module.
//                     this.on('error', errback);
//                 } else if (this.events.error) {
//                     //If no errback already, but there are error listeners
//                     //on this module, set up an errback to pass to the deps.
//                     errback = bind(this, function (err) {
//                         this.emit('error', err);
//                     });
//                 }

//                 //Do a copy of the dependency array, so that
//                 //source inputs are not modified. For example
//                 //"shim" deps are passed in here directly, and
//                 //doing a direct modification of the depMaps array
//                 //would affect that config.
//                 this.depMaps = depMaps && depMaps.slice(0);
//                 this.depMaps.rjsSkipMap = depMaps.rjsSkipMap;

//                 this.errback = errback;

//                 //Indicate this module has be initialized
//                 this.inited = true;

//                 this.ignore = options.ignore;

//                 //Could have option to init this module in enabled mode,
//                 //or could have been previously marked as enabled. However,
//                 //the dependencies are not known until init is called. So
//                 //if enabled previously, now trigger dependencies as enabled.
//                 if (options.enabled || this.enabled) {
//                     //Enable this module and dependencies.
//                     //Will call this.check()
//                     this.enable();
//                 } else {
//                     this.check();
//                 }
//             },

//             defineDepById: function (id, depExports) {
//                 var i;

//                 //Find the index for this dependency.
//                 each(this.depMaps, function (map, index) {
//                     if (map.id === id) {
//                         i = index;
//                         return true;
//                     }
//                 });

//                 return this.defineDep(i, depExports);
//             },

//             defineDep: function (i, depExports) {
//                 //Because of cycles, defined callback for a given
//                 //export can be called more than once.
//                 if (!this.depMatched[i]) {
//                     this.depMatched[i] = true;
//                     this.depCount -= 1;
//                     this.depExports[i] = depExports;
//                 }
//             },

//             fetch: function () {
//                 if (this.fetched) {
//                     return;
//                 }
//                 this.fetched = true;

//                 context.startTime = (new Date()).getTime();

//                 var map = this.map;

//                 //If the manager is for a plugin managed resource,
//                 //ask the plugin to load it now.
//                 if (this.shim) {
//                     makeRequire(this, true)(this.shim.deps || [], bind(this, function () {
//                         return map.prefix ? this.callPlugin() : this.load();
//                     }));
//                 } else {
//                     //Regular dependency.
//                     return map.prefix ? this.callPlugin() : this.load();
//                 }
//             },

//             load: function() {
//                 var url = this.map.url;

//                 //Regular dependency.
//                 if (!urlFetched[url]) {
//                     urlFetched[url] = true;
//                     context.load(this.map.id, url);
//                 }
//             },

//             /**
//              * Checks is the module is ready to define itself, and if so,
//              * define it. If the silent argument is true, then it will just
//              * define, but not notify listeners, and not ask for a context-wide
//              * check of all loaded modules. That is useful for cycle breaking.
//              */
//             check: function (silent) {
//                 if (!this.enabled || this.enabling) {
//                     return;
//                 }

//                 var id = this.map.id,
//                     depExports = this.depExports,
//                     exports = this.exports,
//                     factory = this.factory,
//                     err, cjsModule;

//                 if (!this.inited) {
//                     this.fetch();
//                 } else if (this.error) {
//                     this.emit('error', this.error);
//                 } else if (!this.defining) {
//                     //The factory could trigger another require call
//                     //that would result in checking this module to
//                     //define itself again. If already in the process
//                     //of doing that, skip this work.
//                     this.defining = true;

//                     if (this.depCount < 1 && !this.defined) {
//                         if (isFunction(factory)) {
//                             //If there is an error listener, favor passing
//                             //to that instead of throwing an error.
//                             if (this.events.error) {
//                                 try {
//                                     exports = context.execCb(id, factory, depExports, exports);
//                                 } catch (e) {
//                                     err = e;
//                                 }
//                             } else {
//                                 exports = context.execCb(id, factory, depExports, exports);
//                             }

//                             if (this.map.isDefine) {
//                                 //If setting exports via 'module' is in play,
//                                 //favor that over return value and exports. After that,
//                                 //favor a non-undefined return value over exports use.
//                                 cjsModule = this.module;
//                                 if (cjsModule &&
//                                     cjsModule.exports !== undefined &&
//                                     //Make sure it is not already the exports value
//                                     cjsModule.exports !== this.exports) {
//                                     exports = cjsModule.exports;
//                                 } else if (exports === undefined && this.usingExports) {
//                                     //exports already set the defined value.
//                                     exports = this.exports;
//                                 }
//                             }

//                             if (err) {
//                                 err.requireMap = this.map;
//                                 err.requireModules = [this.map.id];
//                                 err.requireType = 'define';
//                                 return onError((this.error = err));
//                             }

//                         } else {
//                             //Just a literal value
//                             exports = factory;
//                         }

//                         this.exports = exports;

//                         if (this.map.isDefine && !this.ignore) {
//                             defined[id] = exports;

//                             if (req.onResourceLoad) {
//                                 req.onResourceLoad(context, this.map, this.depMaps);
//                             }
//                         }

//                         //Clean up
//                         delete registry[id];

//                         this.defined = true;
//                         context.waitCount -= 1;
//                         if (context.waitCount === 0) {
//                             //Clear the wait array used for cycles.
//                             waitAry = [];
//                         }
//                     }

//                     //Finished the define stage. Allow calling check again
//                     //to allow define notifications below in the case of a
//                     //cycle.
//                     this.defining = false;

//                     if (!silent) {
//                         if (this.defined && !this.defineEmitted) {
//                             this.defineEmitted = true;
//                             this.emit('defined', this.exports);
//                             this.defineEmitComplete = true;
//                         }
//                     }
//                 }
//             },

//             callPlugin: function() {
//                 var map = this.map,
//                     id = map.id,
//                     pluginMap = makeModuleMap(map.prefix, null, false, true);

//                 on(pluginMap, 'defined', bind(this, function (plugin) {
//                     var name = this.map.name,
//                         parentName = this.map.parentMap ? this.map.parentMap.name : null,
//                         load, normalizedMap, normalizedMod;

//                     //If current map is not normalized, wait for that
//                     //normalized name to load instead of continuing.
//                     if (this.map.unnormalized) {
//                         //Normalize the ID if the plugin allows it.
//                         if (plugin.normalize) {
//                             name = plugin.normalize(name, function (name) {
//                                 return normalize(name, parentName, true);
//                             }) || '';
//                         }

//                         normalizedMap = makeModuleMap(map.prefix + '!' + name,
//                                                       this.map.parentMap,
//                                                       false,
//                                                       true);
//                         on(normalizedMap,
//                            'defined', bind(this, function (value) {
//                             this.init([], function () { return value; }, null, {
//                                 enabled: true,
//                                 ignore: true
//                             });
//                         }));
//                         normalizedMod = registry[normalizedMap.id];
//                         if (normalizedMod) {
//                             if (this.events.error) {
//                                 normalizedMod.on('error', bind(this, function (err) {
//                                     this.emit('error', err);
//                                 }));
//                             }
//                             normalizedMod.enable();
//                         }

//                         return;
//                     }

//                     load = bind(this, function (value) {
//                         this.init([], function () { return value; }, null, {
//                             enabled: true
//                         });
//                     });

//                     load.error = bind(this, function (err) {
//                         this.inited = true;
//                         this.error = err;
//                         err.requireModules = [id];

//                         //Remove temp unnormalized modules for this module,
//                         //since they will never be resolved otherwise now.
//                         eachProp(registry, function (mod) {
//                             if (mod.map.id.indexOf(id + '_unnormalized') === 0) {
//                                 removeWaiting(mod.map.id);
//                             }
//                         });

//                         onError(err);
//                     });

//                     //Allow plugins to load other code without having to know the
//                     //context or how to 'complete' the load.
//                     load.fromText = function (moduleName, text) {
//                         /*jslint evil: true */
//                         var hasInteractive = useInteractive;

//                         //Turn off interactive script matching for IE for any define
//                         //calls in the text, then turn it back on at the end.
//                         if (hasInteractive) {
//                             useInteractive = false;
//                         }

//                         //Prime the system by creating a module instance for
//                         //it.
//                         getModule(makeModuleMap(moduleName));

//                         req.exec(text);

//                         if (hasInteractive) {
//                             useInteractive = true;
//                         }

//                         //Support anonymous modules.
//                         context.completeLoad(moduleName);
//                     };

//                     //Use parentName here since the plugin's name is not reliable,
//                     //could be some weird string with no path that actually wants to
//                     //reference the parentName's path.
//                     plugin.load(map.name, makeRequire(map.parentMap, true, function (deps, cb) {
//                         deps.rjsSkipMap = true;
//                         return context.require(deps, cb);
//                     }), load, config);
//                 }));

//                 context.enable(pluginMap, this);
//                 this.pluginMaps[pluginMap.id] = pluginMap;
//             },

//             enable: function () {
//                 this.enabled = true;

//                 if (!this.waitPushed) {
//                     waitAry.push(this);
//                     context.waitCount += 1;
//                     this.waitPushed = true;
//                 }

//                 //Set flag mentioning that the module is enabling,
//                 //so that immediate calls to the defined callbacks
//                 //for dependencies do not trigger inadvertent load
//                 //with the depCount still being zero.
//                 this.enabling = true;

//                 //Enable each dependency
//                 each(this.depMaps, bind(this, function (depMap, i) {
//                     var id, mod, handler;

//                     if (typeof depMap === 'string') {
//                         //Dependency needs to be converted to a depMap
//                         //and wired up to this module.
//                         depMap = makeModuleMap(depMap,
//                                                (this.map.isDefine ? this.map : this.map.parentMap),
//                                                false,
//                                                !this.depMaps.rjsSkipMap);
//                         this.depMaps[i] = depMap;

//                         handler = handlers[depMap.id];

//                         if (handler) {
//                             this.depExports[i] = handler(this);
//                             return;
//                         }

//                         this.depCount += 1;

//                         on(depMap, 'defined', bind(this, function (depExports) {
//                             this.defineDep(i, depExports);
//                             this.check();
//                         }));

//                         if (this.errback) {
//                             on(depMap, 'error', this.errback);
//                         }
//                     }

//                     id = depMap.id;
//                     mod = registry[id];

//                     //Skip special modules like 'require', 'exports', 'module'
//                     //Also, don't call enable if it is already enabled,
//                     //important in circular dependency cases.
//                     if (!handlers[id] && mod && !mod.enabled) {
//                         context.enable(depMap, this);
//                     }
//                 }));

//                 //Enable each plugin that is used in
//                 //a dependency
//                 eachProp(this.pluginMaps, bind(this, function (pluginMap) {
//                     var mod = registry[pluginMap.id];
//                     if (mod && !mod.enabled) {
//                         context.enable(pluginMap, this);
//                     }
//                 }));

//                 this.enabling = false;

//                 this.check();
//             },

//             on: function(name, cb) {
//                 var cbs = this.events[name];
//                 if (!cbs) {
//                     cbs = this.events[name] = [];
//                 }
//                 cbs.push(cb);
//             },

//             emit: function (name, evt) {
//                 each(this.events[name], function (cb) {
//                     cb(evt);
//                 });
//                 if (name === 'error') {
//                     //Now that the error handler was triggered, remove
//                     //the listeners, since this broken Module instance
//                     //can stay around for a while in the registry/waitAry.
//                     delete this.events[name];
//                 }
//             }
//         };

//         function callGetModule(args) {
//             getModule(makeModuleMap(args[0], null, true)).init(args[1], args[2]);
//         }

//         function removeListener(node, func, name, ieName) {
//             //Favor detachEvent because of IE9
//             //issue, see attachEvent/addEventListener comment elsewhere
//             //in this file.
//             if (node.detachEvent && !isOpera) {
//                 //Probably IE. If not it will throw an error, which will be
//                 //useful to know.
//                 if (ieName) {
//                     node.detachEvent(ieName, func);
//                 }
//             } else {
//                 node.removeEventListener(name, func, false);
//             }
//         }

//         /**
//          * Given an event from a script node, get the requirejs info from it,
//          * and then removes the event listeners on the node.
//          * @param {Event} evt
//          * @returns {Object}
//          */
//         function getScriptData(evt) {
//             //Using currentTarget instead of target for Firefox 2.0's sake. Not
//             //all old browsers will be supported, but this one was easy enough
//             //to support and still makes sense.
//             var node = evt.currentTarget || evt.srcElement;

//             //Remove the listeners once here.
//             removeListener(node, context.onScriptLoad, 'load', 'onreadystatechange');
//             removeListener(node, context.onScriptError, 'error');

//             return {
//                 node: node,
//                 id: node && node.getAttribute('data-requiremodule')
//             };
//         }

//         return (context = {
//             config: config,
//             contextName: contextName,
//             registry: registry,
//             defined: defined,
//             urlFetched: urlFetched,
//             waitCount: 0,
//             defQueue: defQueue,
//             Module: Module,
//             makeModuleMap: makeModuleMap,

//             /**
//              * Set a configuration for the context.
//              * @param {Object} cfg config object to integrate.
//              */
//             configure: function (cfg) {
//                 //Make sure the baseUrl ends in a slash.
//                 if (cfg.baseUrl) {
//                     if (cfg.baseUrl.charAt(cfg.baseUrl.length - 1) !== '/') {
//                         cfg.baseUrl += '/';
//                     }
//                 }

//                 //Save off the paths and packages since they require special processing,
//                 //they are additive.
//                 var pkgs = config.pkgs,
//                     shim = config.shim,
//                     paths = config.paths,
//                     map = config.map;

//                 //Mix in the config values, favoring the new values over
//                 //existing ones in context.config.
//                 mixin(config, cfg, true);

//                 //Merge paths.
//                 config.paths = mixin(paths, cfg.paths, true);

//                 //Merge map
//                 if (cfg.map) {
//                     config.map = mixin(map || {}, cfg.map, true, true);
//                 }

//                 //Merge shim
//                 if (cfg.shim) {
//                     eachProp(cfg.shim, function (value, id) {
//                         //Normalize the structure
//                         if (isArray(value)) {
//                             value = {
//                                 deps: value
//                             };
//                         }
//                         if (value.exports && !value.exports.__buildReady) {
//                             value.exports = context.makeShimExports(value.exports);
//                         }
//                         shim[id] = value;
//                     });
//                     config.shim = shim;
//                 }

//                 //Adjust packages if necessary.
//                 if (cfg.packages) {
//                     each(cfg.packages, function (pkgObj) {
//                         var location;

//                         pkgObj = typeof pkgObj === 'string' ? { name: pkgObj } : pkgObj;
//                         location = pkgObj.location;

//                         //Create a brand new object on pkgs, since currentPackages can
//                         //be passed in again, and config.pkgs is the internal transformed
//                         //state for all package configs.
//                         pkgs[pkgObj.name] = {
//                             name: pkgObj.name,
//                             location: location || pkgObj.name,
//                             //Remove leading dot in main, so main paths are normalized,
//                             //and remove any trailing .js, since different package
//                             //envs have different conventions: some use a module name,
//                             //some use a file name.
//                             main: (pkgObj.main || 'main')
//                                   .replace(currDirRegExp, '')
//                                   .replace(jsSuffixRegExp, '')
//                         };
//                     });

//                     //Done with modifications, assing packages back to context config
//                     config.pkgs = pkgs;
//                 }

//                 //If there are any "waiting to execute" modules in the registry,
//                 //update the maps for them, since their info, like URLs to load,
//                 //may have changed.
//                 eachProp(registry, function (mod, id) {
//                     mod.map = makeModuleMap(id);
//                 });

//                 //If a deps array or a config callback is specified, then call
//                 //require with those args. This is useful when require is defined as a
//                 //config object before require.js is loaded.
//                 if (cfg.deps || cfg.callback) {
//                     context.require(cfg.deps || [], cfg.callback);
//                 }
//             },

//             makeShimExports: function (exports) {
//                 var func;
//                 if (typeof exports === 'string') {
//                     func = function () {
//                         return getGlobal(exports);
//                     };
//                     //Save the exports for use in nodefine checking.
//                     func.exports = exports;
//                     return func;
//                 } else {
//                     return function () {
//                         return exports.apply(global, arguments);
//                     };
//                 }
//             },

//             requireDefined: function (id, relMap) {
//                 return hasProp(defined, makeModuleMap(id, relMap, false, true).id);
//             },

//             requireSpecified: function (id, relMap) {
//                 id = makeModuleMap(id, relMap, false, true).id;
//                 return hasProp(defined, id) || hasProp(registry, id);
//             },

//             require: function (deps, callback, errback, relMap) {
//                 var moduleName, id, map, requireMod, args;
//                 if (typeof deps === 'string') {
//                     if (isFunction(callback)) {
//                         //Invalid call
//                         return onError(makeError('requireargs', 'Invalid require call'), errback);
//                     }

//                     //Synchronous access to one module. If require.get is
//                     //available (as in the Node adapter), prefer that.
//                     //In this case deps is the moduleName and callback is
//                     //the relMap
//                     if (req.get) {
//                         return req.get(context, deps, callback);
//                     }

//                     //Just return the module wanted. In this scenario, the
//                     //second arg (if passed) is just the relMap.
//                     moduleName = deps;
//                     relMap = callback;

//                     //Normalize module name, if it contains . or ..
//                     map = makeModuleMap(moduleName, relMap, false, true);
//                     id = map.id;

//                     if (!hasProp(defined, id)) {
//                         return onError(makeError('notloaded', 'Module name "' +
//                                     id +
//                                     '" has not been loaded yet for context: ' +
//                                     contextName));
//                     }
//                     return defined[id];
//                 }

//                 //Callback require. Normalize args. if callback or errback is
//                 //not a function, it means it is a relMap. Test errback first.
//                 if (errback && !isFunction(errback)) {
//                     relMap = errback;
//                     errback = undefined;
//                 }
//                 if (callback && !isFunction(callback)) {
//                     relMap = callback;
//                     callback = undefined;
//                 }

//                 //Any defined modules in the global queue, intake them now.
//                 takeGlobalQueue();

//                 //Make sure any remaining defQueue items get properly processed.
//                 while (defQueue.length) {
//                     args = defQueue.shift();
//                     if (args[0] === null) {
//                         return onError(makeError('mismatch', 'Mismatched anonymous define() module: ' + args[args.length - 1]));
//                     } else {
//                         //args are id, deps, factory. Should be normalized by the
//                         //define() function.
//                         callGetModule(args);
//                     }
//                 }

//                 //Mark all the dependencies as needing to be loaded.
//                 requireMod = getModule(makeModuleMap(null, relMap));

//                 requireMod.init(deps, callback, errback, {
//                     enabled: true
//                 });

//                 checkLoaded();

//                 return context.require;
//             },

//             undef: function (id) {
//                 var map = makeModuleMap(id, null, true),
//                     mod = registry[id];

//                 delete defined[id];
//                 delete urlFetched[map.url];
//                 delete undefEvents[id];

//                 if (mod) {
//                     //Hold on to listeners in case the
//                     //module will be attempted to be reloaded
//                     //using a different config.
//                     if (mod.events.defined) {
//                         undefEvents[id] = mod.events;
//                     }

//                     removeWaiting(id);
//                 }
//             },

//             /**
//              * Called to enable a module if it is still in the registry
//              * awaiting enablement. parent module is passed in for context,
//              * used by the optimizer.
//              */
//             enable: function (depMap, parent) {
//                 var mod = registry[depMap.id];
//                 if (mod) {
//                     getModule(depMap).enable();
//                 }
//             },

//             /**
//              * Internal method used by environment adapters to complete a load event.
//              * A load event could be a script load or just a load pass from a synchronous
//              * load call.
//              * @param {String} moduleName the name of the module to potentially complete.
//              */
//             completeLoad: function (moduleName) {
//                 var shim = config.shim[moduleName] || {},
//                 shExports = shim.exports && shim.exports.exports,
//                 found, args, mod;

//                 takeGlobalQueue();

//                 while (defQueue.length) {
//                     args = defQueue.shift();
//                     if (args[0] === null) {
//                         args[0] = moduleName;
//                         //If already found an anonymous module and bound it
//                         //to this name, then this is some other anon module
//                         //waiting for its completeLoad to fire.
//                         if (found) {
//                             break;
//                         }
//                         found = true;
//                     } else if (args[0] === moduleName) {
//                         //Found matching define call for this script!
//                         found = true;
//                     }

//                     callGetModule(args);
//                 }

//                 //Do this after the cycle of callGetModule in case the result
//                 //of those calls/init calls changes the registry.
//                 mod = registry[moduleName];

//                 if (!found &&
//                     !defined[moduleName] &&
//                     mod && !mod.inited) {
//                     if (config.enforceDefine && (!shExports || !getGlobal(shExports))) {
//                         if (hasPathFallback(moduleName)) {
//                             return;
//                         } else {
//                             return onError(makeError('nodefine',
//                                              'No define call for ' + moduleName,
//                                              null,
//                                              [moduleName]));
//                         }
//                     } else {
//                         //A script that does not call define(), so just simulate
//                         //the call for it.
//                         callGetModule([moduleName, (shim.deps || []), shim.exports]);
//                     }
//                 }

//                 checkLoaded();
//             },

//             /**
//              * Converts a module name + .extension into an URL path.
//              * *Requires* the use of a module name. It does not support using
//              * plain URLs like nameToUrl.
//              */
//             toUrl: function (moduleNamePlusExt, relModuleMap) {
//                 var index = moduleNamePlusExt.lastIndexOf('.'),
//                     ext = null;

//                 if (index !== -1) {
//                     ext = moduleNamePlusExt.substring(index, moduleNamePlusExt.length);
//                     moduleNamePlusExt = moduleNamePlusExt.substring(0, index);
//                 }

//                 return context.nameToUrl(moduleNamePlusExt, ext, relModuleMap);
//             },

//             /**
//              * Converts a module name to a file path. Supports cases where
//              * moduleName may actually be just an URL.
//              */
//             nameToUrl: function (moduleName, ext, relModuleMap) {
//                 var paths, pkgs, pkg, pkgPath, syms, i, parentModule, url,
//                     parentPath;

//                 //Normalize module name if have a base relative module name to work from.
//                 moduleName = normalize(moduleName, relModuleMap && relModuleMap.id, true);

//                 //If a colon is in the URL, it indicates a protocol is used and it is just
//                 //an URL to a file, or if it starts with a slash, contains a query arg (i.e. ?)
//                 //or ends with .js, then assume the user meant to use an url and not a module id.
//                 //The slash is important for protocol-less URLs as well as full paths.
//                 if (req.jsExtRegExp.test(moduleName)) {
//                     //Just a plain path, not module name lookup, so just return it.
//                     //Add extension if it is included. This is a bit wonky, only non-.js things pass
//                     //an extension, this method probably needs to be reworked.
//                     url = moduleName + (ext || '');
//                 } else {
//                     //A module that needs to be converted to a path.
//                     paths = config.paths;
//                     pkgs = config.pkgs;

//                     syms = moduleName.split('/');
//                     //For each module name segment, see if there is a path
//                     //registered for it. Start with most specific name
//                     //and work up from it.
//                     for (i = syms.length; i > 0; i -= 1) {
//                         parentModule = syms.slice(0, i).join('/');
//                         pkg = pkgs[parentModule];
//                         parentPath = paths[parentModule];
//                         if (parentPath) {
//                             //If an array, it means there are a few choices,
//                             //Choose the one that is desired
//                             if (isArray(parentPath)) {
//                                 parentPath = parentPath[0];
//                             }
//                             syms.splice(0, i, parentPath);
//                             break;
//                         } else if (pkg) {
//                             //If module name is just the package name, then looking
//                             //for the main module.
//                             if (moduleName === pkg.name) {
//                                 pkgPath = pkg.location + '/' + pkg.main;
//                             } else {
//                                 pkgPath = pkg.location;
//                             }
//                             syms.splice(0, i, pkgPath);
//                             break;
//                         }
//                     }

//                     //Join the path parts together, then figure out if baseUrl is needed.
//                     url = syms.join('/') + (ext || '.js');
//                     url = (url.charAt(0) === '/' || url.match(/^[\w\+\.\-]+:/) ? '' : config.baseUrl) + url;
//                 }

//                 return config.urlArgs ? url +
//                                         ((url.indexOf('?') === -1 ? '?' : '&') +
//                                          config.urlArgs) : url;
//             },

//             //Delegates to req.load. Broken out as a separate function to
//             //allow overriding in the optimizer.
//             load: function (id, url) {
//                 req.load(context, id, url);
//             },

//             /**
//              * Executes a module callack function. Broken out as a separate function
//              * solely to allow the build system to sequence the files in the built
//              * layer in the right sequence.
//              *
//              * @private
//              */
//             execCb: function (name, callback, args, exports) {
//                 return callback.apply(exports, args);
//             },

//             /**
//              * callback for script loads, used to check status of loading.
//              *
//              * @param {Event} evt the event from the browser for the script
//              * that was loaded.
//              */
//             onScriptLoad: function (evt) {
//                 //Using currentTarget instead of target for Firefox 2.0's sake. Not
//                 //all old browsers will be supported, but this one was easy enough
//                 //to support and still makes sense.
//                 if (evt.type === 'load' ||
//                     (readyRegExp.test((evt.currentTarget || evt.srcElement).readyState))) {
//                     //Reset interactive script so a script node is not held onto for
//                     //to long.
//                     interactiveScript = null;

//                     //Pull out the name of the module and the context.
//                     var data = getScriptData(evt);
//                     context.completeLoad(data.id);
//                 }
//             },

//             /**
//              * Callback for script errors.
//              */
//             onScriptError: function (evt) {
//                 var data = getScriptData(evt);
//                 if (!hasPathFallback(data.id)) {
//                     return onError(makeError('scripterror', 'Script error', evt, [data.id]));
//                 }
//             }
//         });
//     }

//     /**
//      * Main entry point.
//      *
//      * If the only argument to require is a string, then the module that
//      * is represented by that string is fetched for the appropriate context.
//      *
//      * If the first argument is an array, then it will be treated as an array
//      * of dependency string names to fetch. An optional function callback can
//      * be specified to execute when all of those dependencies are available.
//      *
//      * Make a local req variable to help Caja compliance (it assumes things
//      * on a require that are not standardized), and to give a short
//      * name for minification/local scope use.
//      */
//     req = requirejs = function (deps, callback, errback, optional) {

//         //Find the right context, use default
//         var contextName = defContextName,
//             context, config;

//         // Determine if have config object in the call.
//         if (!isArray(deps) && typeof deps !== 'string') {
//             // deps is a config object
//             config = deps;
//             if (isArray(callback)) {
//                 // Adjust args if there are dependencies
//                 deps = callback;
//                 callback = errback;
//                 errback = optional;
//             } else {
//                 deps = [];
//             }
//         }

//         if (config && config.context) {
//             contextName = config.context;
//         }

//         context = contexts[contextName];
//         if (!context) {
//             context = contexts[contextName] = req.s.newContext(contextName);
//         }

//         if (config) {
//             context.configure(config);
//         }

//         return context.require(deps, callback, errback);
//     };

//     /**
//      * Support require.config() to make it easier to cooperate with other
//      * AMD loaders on globally agreed names.
//      */
//     req.config = function (config) {
//         return req(config);
//     };

//     /**
//      * Export require as a global, but only if it does not already exist.
//      */
//     if (!require) {
//         require = req;
//     }

//     req.version = version;

//     //Used to filter out dependencies that are already paths.
//     req.jsExtRegExp = /^\/|:|\?|\.js$/;
//     req.isBrowser = isBrowser;
//     s = req.s = {
//         contexts: contexts,
//         newContext: newContext
//     };

//     //Create default context.
//     req({});

//     //Exports some context-sensitive methods on global require, using
//     //default context if no context specified.
//     addRequireMethods(req);

//     if (isBrowser) {
//         head = s.head = document.getElementsByTagName('head')[0];
//         //If BASE tag is in play, using appendChild is a problem for IE6.
//         //When that browser dies, this can be removed. Details in this jQuery bug:
//         //http://dev.jquery.com/ticket/2709
//         baseElement = document.getElementsByTagName('base')[0];
//         if (baseElement) {
//             head = s.head = baseElement.parentNode;
//         }
//     }

//     /**
//      * Any errors that require explicitly generates will be passed to this
//      * function. Intercept/override it if you want custom error handling.
//      * @param {Error} err the error object.
//      */
//     req.onError = function (err) {
//         throw err;
//     };

//     /**
//      * Does the request to load a module for the browser case.
//      * Make this a separate function to allow other environments
//      * to override it.
//      *
//      * @param {Object} context the require context to find state.
//      * @param {String} moduleName the name of the module.
//      * @param {Object} url the URL to the module.
//      */
//     req.load = function (context, moduleName, url) {
//         var config = (context && context.config) || {},
//             node;
//         if (isBrowser) {
//             //In the browser so use a script tag
//             node = config.xhtml ?
//                    document.createElementNS('http://www.w3.org/1999/xhtml', 'html:script') :
//                    document.createElement('script');
//             node.type = config.scriptType || 'text/javascript';
//             node.charset = 'utf-8';

//             node.setAttribute('data-requirecontext', context.contextName);
//             node.setAttribute('data-requiremodule', moduleName);

//             //Set up load listener. Test attachEvent first because IE9 has
//             //a subtle issue in its addEventListener and script onload firings
//             //that do not match the behavior of all other browsers with
//             //addEventListener support, which fire the onload event for a
//             //script right after the script execution. See:
//             //https://connect.microsoft.com/IE/feedback/details/648057/script-onload-event-is-not-fired-immediately-after-script-execution
//             //UNFORTUNATELY Opera implements attachEvent but does not follow the script
//             //script execution mode.
//             if (node.attachEvent &&
//                 //Check if node.attachEvent is artificially added by custom script or
//                 //natively supported by browser
//                 //read https://github.com/jrburke/requirejs/issues/187
//                 //if we can NOT find [native code] then it must NOT natively supported.
//                 //in IE8, node.attachEvent does not have toString()
//                 //Note the test for "[native code" with no closing brace, see:
//                 //https://github.com/jrburke/requirejs/issues/273
//                 !(node.attachEvent.toString && node.attachEvent.toString().indexOf('[native code') < 0) &&
//                 !isOpera) {
//                 //Probably IE. IE (at least 6-8) do not fire
//                 //script onload right after executing the script, so
//                 //we cannot tie the anonymous define call to a name.
//                 //However, IE reports the script as being in 'interactive'
//                 //readyState at the time of the define call.
//                 useInteractive = true;

//                 node.attachEvent('onreadystatechange', context.onScriptLoad);
//                 //It would be great to add an error handler here to catch
//                 //404s in IE9+. However, onreadystatechange will fire before
//                 //the error handler, so that does not help. If addEvenListener
//                 //is used, then IE will fire error before load, but we cannot
//                 //use that pathway given the connect.microsoft.com issue
//                 //mentioned above about not doing the 'script execute,
//                 //then fire the script load event listener before execute
//                 //next script' that other browsers do.
//                 //Best hope: IE10 fixes the issues,
//                 //and then destroys all installs of IE 6-9.
//                 //node.attachEvent('onerror', context.onScriptError);
//             } else {
//                 node.addEventListener('load', context.onScriptLoad, false);
//                 node.addEventListener('error', context.onScriptError, false);
//             }
//             node.src = url;

//             //For some cache cases in IE 6-8, the script executes before the end
//             //of the appendChild execution, so to tie an anonymous define
//             //call to the module name (which is stored on the node), hold on
//             //to a reference to this node, but clear after the DOM insertion.
//             currentlyAddingScript = node;
//             if (baseElement) {
//                 head.insertBefore(node, baseElement);
//             } else {
//                 head.appendChild(node);
//             }
//             currentlyAddingScript = null;

//             return node;
//         } else if (isWebWorker) {
//             //In a web worker, use importScripts. This is not a very
//             //efficient use of importScripts, importScripts will block until
//             //its script is downloaded and evaluated. However, if web workers
//             //are in play, the expectation that a build has been done so that
//             //only one script needs to be loaded anyway. This may need to be
//             //reevaluated if other use cases become common.
//             importScripts(url);

//             //Account for anonymous modules
//             context.completeLoad(moduleName);
//         }
//     };

//     function getInteractiveScript() {
//         if (interactiveScript && interactiveScript.readyState === 'interactive') {
//             return interactiveScript;
//         }

//         eachReverse(scripts(), function (script) {
//             if (script.readyState === 'interactive') {
//                 return (interactiveScript = script);
//             }
//         });
//         return interactiveScript;
//     }

//     //Look for a data-main script attribute, which could also adjust the baseUrl.
//     if (isBrowser) {
//         //Figure out baseUrl. Get it from the script tag with require.js in it.
//         eachReverse(scripts(), function (script) {
//             //Set the 'head' where we can append children by
//             //using the script's parent.
//             if (!head) {
//                 head = script.parentNode;
//             }

//             //Look for a data-main attribute to set main script for the page
//             //to load. If it is there, the path to data main becomes the
//             //baseUrl, if it is not already set.
//             dataMain = script.getAttribute('data-main');
//             if (dataMain) {

//                 //Pull off the directory of data-main for use as the
//                 //baseUrl.
//                 src = dataMain.split('/');
//                 mainScript = src.pop();
//                 subPath = src.length ? src.join('/')  + '/' : './';

//                 //Set final baseUrl if there is not already an explicit one.
//                 if (!cfg.baseUrl) {
//                     cfg.baseUrl = subPath;
//                 }

//                 //Strip off any trailing .js since dataMain is now
//                 //like a module name.
//                 dataMain = mainScript.replace(jsSuffixRegExp, '');

//                 //Put the data-main script in the files to load.
//                 cfg.deps = cfg.deps ? cfg.deps.concat(dataMain) : [dataMain];

//                 return true;
//             }
//         });
//     }

//     /**
//      * The function that handles definitions of modules. Differs from
//      * require() in that a string for the module should be the first argument,
//      * and the function to execute after dependencies are loaded should
//      * return a value to define the module corresponding to the first argument's
//      * name.
//      */
//     define = function (name, deps, callback) {
//         var node, context;

//         //Allow for anonymous functions
//         if (typeof name !== 'string') {
//             //Adjust args appropriately
//             callback = deps;
//             deps = name;
//             name = null;
//         }

//         //This module may not have dependencies
//         if (!isArray(deps)) {
//             callback = deps;
//             deps = [];
//         }

//         //If no name, and callback is a function, then figure out if it a
//         //CommonJS thing with dependencies.
//         if (!deps.length && isFunction(callback)) {
//             //Remove comments from the callback string,
//             //look for require calls, and pull them into the dependencies,
//             //but only if there are function args.
//             if (callback.length) {
//                 callback
//                     .toString()
//                     .replace(commentRegExp, '')
//                     .replace(cjsRequireRegExp, function (match, dep) {
//                         deps.push(dep);
//                     });

//                 //May be a CommonJS thing even without require calls, but still
//                 //could use exports, and module. Avoid doing exports and module
//                 //work though if it just needs require.
//                 //REQUIRES the function to expect the CommonJS variables in the
//                 //order listed below.
//                 deps = (callback.length === 1 ? ['require'] : ['require', 'exports', 'module']).concat(deps);
//             }
//         }

//         //If in IE 6-8 and hit an anonymous define() call, do the interactive
//         //work.
//         if (useInteractive) {
//             node = currentlyAddingScript || getInteractiveScript();
//             if (node) {
//                 if (!name) {
//                     name = node.getAttribute('data-requiremodule');
//                 }
//                 context = contexts[node.getAttribute('data-requirecontext')];
//             }
//         }

//         //Always save off evaluating the def call until the script onload handler.
//         //This allows multiple modules to be in a file without prematurely
//         //tracing dependencies, and allows for anonymous module support,
//         //where the module name is not known until the script onload event
//         //occurs. If no context, use the global queue, and get it processed
//         //in the onscript load callback.
//         (context ? context.defQueue : globalDefQueue).push([name, deps, callback]);
//     };

//     define.amd = {
//         jQuery: true
//     };


//     /**
//      * Executes the text. Normally just uses eval, but can be modified
//      * to use a better, environment-specific call. Only used for transpiling
//      * loader plugins, not for plain JS modules.
//      * @param {String} text the text to execute/evaluate.
//      */
//     req.exec = function (text) {
//         /*jslint evil: true */
//         return eval(text);
//     };

//     //Set up with config info.
//     req(cfg);
// }(this));


/*
 RequireJS 1.0.2 Copyright (c) 2010-2011, The Dojo Foundation All Rights Reserved.
 Available via the MIT or new BSD license.
 see: http://github.com/jrburke/requirejs for details
*/
var requirejs,require,define;
(function(){function J(a){return M.call(a)==="[object Function]"}function E(a){return M.call(a)==="[object Array]"}function Z(a,c,h){for(var k in c)if(!(k in K)&&(!(k in a)||h))a[k]=c[k];return d}function N(a,c,d){a=Error(c+"\nhttp://requirejs.org/docs/errors.html#"+a);if(d)a.originalError=d;return a}function $(a,c,d){var k,j,q;for(k=0;q=c[k];k++){q=typeof q==="string"?{name:q}:q;j=q.location;if(d&&(!j||j.indexOf("/")!==0&&j.indexOf(":")===-1))j=d+"/"+(j||q.name);a[q.name]={name:q.name,location:j||
q.name,main:(q.main||"main").replace(ea,"").replace(aa,"")}}}function V(a,c){a.holdReady?a.holdReady(c):c?a.readyWait+=1:a.ready(!0)}function fa(a){function c(b,l){var f,a;if(b&&b.charAt(0)===".")if(l){p.pkgs[l]?l=[l]:(l=l.split("/"),l=l.slice(0,l.length-1));f=b=l.concat(b.split("/"));var c;for(a=0;c=f[a];a++)if(c===".")f.splice(a,1),a-=1;else if(c==="..")if(a===1&&(f[2]===".."||f[0]===".."))break;else a>0&&(f.splice(a-1,2),a-=2);a=p.pkgs[f=b[0]];b=b.join("/");a&&b===f+"/"+a.main&&(b=f)}else b.indexOf("./")===
0&&(b=b.substring(2));return b}function h(b,l){var f=b?b.indexOf("!"):-1,a=null,d=l?l.name:null,i=b,e,h;f!==-1&&(a=b.substring(0,f),b=b.substring(f+1,b.length));a&&(a=c(a,d));b&&(a?e=(f=m[a])&&f.normalize?f.normalize(b,function(b){return c(b,d)}):c(b,d):(e=c(b,d),h=E[e],h||(h=g.nameToUrl(e,null,l),E[e]=h)));return{prefix:a,name:e,parentMap:l,url:h,originalName:i,fullName:a?a+"!"+(e||""):e}}function k(){var b=!0,l=p.priorityWait,f,a;if(l){for(a=0;f=l[a];a++)if(!s[f]){b=!1;break}b&&delete p.priorityWait}return b}
function j(b,l,f){return function(){var a=ga.call(arguments,0),c;if(f&&J(c=a[a.length-1]))c.__requireJsBuild=!0;a.push(l);return b.apply(null,a)}}function q(b,l){var a=j(g.require,b,l);Z(a,{nameToUrl:j(g.nameToUrl,b),toUrl:j(g.toUrl,b),defined:j(g.requireDefined,b),specified:j(g.requireSpecified,b),isBrowser:d.isBrowser});return a}function o(b){var l,a,c,C=b.callback,i=b.map,e=i.fullName,ba=b.deps;c=b.listeners;if(C&&J(C)){if(p.catchError.define)try{a=d.execCb(e,b.callback,ba,m[e])}catch(k){l=k}else a=
d.execCb(e,b.callback,ba,m[e]);if(e)(C=b.cjsModule)&&C.exports!==void 0&&C.exports!==m[e]?a=m[e]=b.cjsModule.exports:a===void 0&&b.usingExports?a=m[e]:(m[e]=a,F[e]&&(Q[e]=!0))}else e&&(a=m[e]=C,F[e]&&(Q[e]=!0));if(D[b.id])delete D[b.id],b.isDone=!0,g.waitCount-=1,g.waitCount===0&&(I=[]);delete R[e];if(d.onResourceLoad&&!b.placeholder)d.onResourceLoad(g,i,b.depArray);if(l)return a=(e?h(e).url:"")||l.fileName||l.sourceURL,c=l.moduleTree,l=N("defineerror",'Error evaluating module "'+e+'" at location "'+
a+'":\n'+l+"\nfileName:"+a+"\nlineNumber: "+(l.lineNumber||l.line),l),l.moduleName=e,l.moduleTree=c,d.onError(l);for(l=0;C=c[l];l++)C(a)}function r(b,a){return function(f){b.depDone[a]||(b.depDone[a]=!0,b.deps[a]=f,b.depCount-=1,b.depCount||o(b))}}function u(b,a){var f=a.map,c=f.fullName,h=f.name,i=L[b]||(L[b]=m[b]),e;if(!a.loading)a.loading=!0,e=function(b){a.callback=function(){return b};o(a);s[a.id]=!0;w()},e.fromText=function(b,a){var l=O;s[b]=!1;g.scriptCount+=1;g.fake[b]=!0;l&&(O=!1);d.exec(a);
l&&(O=!0);g.completeLoad(b)},c in m?e(m[c]):i.load(h,q(f.parentMap,!0),e,p)}function v(b){D[b.id]||(D[b.id]=b,I.push(b),g.waitCount+=1)}function B(b){this.listeners.push(b)}function t(b,a){var f=b.fullName,c=b.prefix,d=c?L[c]||(L[c]=m[c]):null,i,e;f&&(i=R[f]);if(!i&&(e=!0,i={id:(c&&!d?M++ +"__p@:":"")+(f||"__r@"+M++),map:b,depCount:0,depDone:[],depCallbacks:[],deps:[],listeners:[],add:B},y[i.id]=!0,f&&(!c||L[c])))R[f]=i;c&&!d?(f=t(h(c),!0),f.add(function(){var a=h(b.originalName,b.parentMap),a=t(a,
!0);i.placeholder=!0;a.add(function(b){i.callback=function(){return b};o(i)})})):e&&a&&(s[i.id]=!1,g.paused.push(i),v(i));return i}function x(b,a,f,c){var b=h(b,c),d=b.name,i=b.fullName,e=t(b),k=e.id,j=e.deps,n;if(i){if(i in m||s[k]===!0||i==="jquery"&&p.jQuery&&p.jQuery!==f().fn.jquery)return;y[k]=!0;s[k]=!0;i==="jquery"&&f&&S(f())}e.depArray=a;e.callback=f;for(f=0;f<a.length;f++)if(k=a[f])k=h(k,d?b:c),n=k.fullName,a[f]=n,n==="require"?j[f]=q(b):n==="exports"?(j[f]=m[i]={},e.usingExports=!0):n===
"module"?e.cjsModule=j[f]={id:d,uri:d?g.nameToUrl(d,null,c):void 0,exports:m[i]}:n in m&&!(n in D)&&(!(i in F)||i in F&&Q[n])?j[f]=m[n]:(i in F&&(F[n]=!0,delete m[n],T[k.url]=!1),e.depCount+=1,e.depCallbacks[f]=r(e,f),t(k,!0).add(e.depCallbacks[f]));e.depCount?v(e):o(e)}function n(b){x.apply(null,b)}function z(b,a){if(!b.isDone){var c=b.map.fullName,d=b.depArray,g,i,e,k;if(c){if(a[c])return m[c];a[c]=!0}if(d)for(g=0;g<d.length;g++)if(i=d[g])if((e=h(i).prefix)&&(k=D[e])&&z(k,a),(e=D[i])&&!e.isDone&&
s[i])i=z(e,a),b.depCallbacks[g](i);return c?m[c]:void 0}}function A(){var b=p.waitSeconds*1E3,a=b&&g.startTime+b<(new Date).getTime(),b="",c=!1,h=!1,j;if(!(g.pausedCount>0)){if(p.priorityWait)if(k())w();else return;for(j in s)if(!(j in K)&&(c=!0,!s[j]))if(a)b+=j+" ";else{h=!0;break}if(c||g.waitCount){if(a&&b)return j=N("timeout","Load timeout for modules: "+b),j.requireType="timeout",j.requireModules=b,d.onError(j);if(h||g.scriptCount){if((G||ca)&&!W)W=setTimeout(function(){W=0;A()},50)}else{if(g.waitCount){for(H=
0;b=I[H];H++)z(b,{});g.paused.length&&w();X<5&&(X+=1,A())}X=0;d.checkReadyState()}}}}var g,w,p={waitSeconds:7,baseUrl:"./",paths:{},pkgs:{},catchError:{}},P=[],y={require:!0,exports:!0,module:!0},E={},m={},s={},D={},I=[],T={},M=0,R={},L={},F={},Q={},Y=0;S=function(b){if(!g.jQuery&&(b=b||(typeof jQuery!=="undefined"?jQuery:null))&&!(p.jQuery&&b.fn.jquery!==p.jQuery)&&("holdReady"in b||"readyWait"in b))if(g.jQuery=b,n(["jquery",[],function(){return jQuery}]),g.scriptCount)V(b,!0),g.jQueryIncremented=
!0};w=function(){var b,a,c,h,j,i;Y+=1;if(g.scriptCount<=0)g.scriptCount=0;for(;P.length;)if(b=P.shift(),b[0]===null)return d.onError(N("mismatch","Mismatched anonymous define() module: "+b[b.length-1]));else n(b);if(!p.priorityWait||k())for(;g.paused.length;){j=g.paused;g.pausedCount+=j.length;g.paused=[];for(h=0;b=j[h];h++)a=b.map,c=a.url,i=a.fullName,a.prefix?u(a.prefix,b):!T[c]&&!s[i]&&(d.load(g,i,c),c.indexOf("empty:")!==0&&(T[c]=!0));g.startTime=(new Date).getTime();g.pausedCount-=j.length}Y===
1&&A();Y-=1};g={contextName:a,config:p,defQueue:P,waiting:D,waitCount:0,specified:y,loaded:s,urlMap:E,urlFetched:T,scriptCount:0,defined:m,paused:[],pausedCount:0,plugins:L,needFullExec:F,fake:{},fullExec:Q,managerCallbacks:R,makeModuleMap:h,normalize:c,configure:function(b){var a,c,d;b.baseUrl&&b.baseUrl.charAt(b.baseUrl.length-1)!=="/"&&(b.baseUrl+="/");a=p.paths;d=p.pkgs;Z(p,b,!0);if(b.paths){for(c in b.paths)c in K||(a[c]=b.paths[c]);p.paths=a}if((a=b.packagePaths)||b.packages){if(a)for(c in a)c in
K||$(d,a[c],c);b.packages&&$(d,b.packages);p.pkgs=d}if(b.priority)c=g.requireWait,g.requireWait=!1,g.takeGlobalQueue(),w(),g.require(b.priority),w(),g.requireWait=c,p.priorityWait=b.priority;if(b.deps||b.callback)g.require(b.deps||[],b.callback)},requireDefined:function(b,a){return h(b,a).fullName in m},requireSpecified:function(b,a){return h(b,a).fullName in y},require:function(b,c,f){if(typeof b==="string"){if(J(c))return d.onError(N("requireargs","Invalid require call"));if(d.get)return d.get(g,
b,c);c=h(b,c);b=c.fullName;return!(b in m)?d.onError(N("notloaded","Module name '"+c.fullName+"' has not been loaded yet for context: "+a)):m[b]}(b&&b.length||c)&&x(null,b,c,f);if(!g.requireWait)for(;!g.scriptCount&&g.paused.length;)g.takeGlobalQueue(),w();return g.require},takeGlobalQueue:function(){U.length&&(ha.apply(g.defQueue,[g.defQueue.length-1,0].concat(U)),U=[])},completeLoad:function(b){var a;for(g.takeGlobalQueue();P.length;)if(a=P.shift(),a[0]===null){a[0]=b;break}else if(a[0]===b)break;
else n(a),a=null;a?n(a):n([b,[],b==="jquery"&&typeof jQuery!=="undefined"?function(){return jQuery}:null]);S();d.isAsync&&(g.scriptCount-=1);w();d.isAsync||(g.scriptCount-=1)},toUrl:function(a,c){var d=a.lastIndexOf("."),h=null;d!==-1&&(h=a.substring(d,a.length),a=a.substring(0,d));return g.nameToUrl(a,h,c)},nameToUrl:function(a,h,f){var j,k,i,e,m=g.config,a=c(a,f&&f.fullName);if(d.jsExtRegExp.test(a))h=a+(h?h:"");else{j=m.paths;k=m.pkgs;f=a.split("/");for(e=f.length;e>0;e--)if(i=f.slice(0,e).join("/"),
j[i]){f.splice(0,e,j[i]);break}else if(i=k[i]){a=a===i.name?i.location+"/"+i.main:i.location;f.splice(0,e,a);break}h=f.join("/")+(h||".js");h=(h.charAt(0)==="/"||h.match(/^\w+:/)?"":m.baseUrl)+h}return m.urlArgs?h+((h.indexOf("?")===-1?"?":"&")+m.urlArgs):h}};g.jQueryCheck=S;g.resume=w;return g}function ia(){var a,c,d;if(n&&n.readyState==="interactive")return n;a=document.getElementsByTagName("script");for(c=a.length-1;c>-1&&(d=a[c]);c--)if(d.readyState==="interactive")return n=d;return null}var ja=
/(\/\*([\s\S]*?)\*\/|([^:]|^)\/\/(.*)$)/mg,ka=/require\(\s*["']([^'"\s]+)["']\s*\)/g,ea=/^\.\//,aa=/\.js$/,M=Object.prototype.toString,r=Array.prototype,ga=r.slice,ha=r.splice,G=!!(typeof window!=="undefined"&&navigator&&document),ca=!G&&typeof importScripts!=="undefined",la=G&&navigator.platform==="PLAYSTATION 3"?/^complete$/:/^(complete|loaded)$/,da=typeof opera!=="undefined"&&opera.toString()==="[object Opera]",K={},t={},U=[],n=null,X=0,O=!1,d,r={},I,v,x,y,u,z,A,H,B,S,W;if(typeof define==="undefined"){if(typeof requirejs!==
"undefined")if(J(requirejs))return;else r=requirejs,requirejs=void 0;typeof require!=="undefined"&&!J(require)&&(r=require,require=void 0);d=requirejs=function(a,c,d){var k="_",j;!E(a)&&typeof a!=="string"&&(j=a,E(c)?(a=c,c=d):a=[]);if(j&&j.context)k=j.context;d=t[k]||(t[k]=fa(k));j&&d.configure(j);return d.require(a,c)};d.config=function(a){return d(a)};require||(require=d);d.toUrl=function(a){return t._.toUrl(a)};d.version="1.0.2";d.jsExtRegExp=/^\/|:|\?|\.js$/;v=d.s={contexts:t,skipAsync:{}};if(d.isAsync=
d.isBrowser=G)if(x=v.head=document.getElementsByTagName("head")[0],y=document.getElementsByTagName("base")[0])x=v.head=y.parentNode;d.onError=function(a){throw a;};d.load=function(a,c,h){d.resourcesReady(!1);a.scriptCount+=1;d.attach(h,a,c);if(a.jQuery&&!a.jQueryIncremented)V(a.jQuery,!0),a.jQueryIncremented=!0};define=function(a,c,d){var k,j;typeof a!=="string"&&(d=c,c=a,a=null);E(c)||(d=c,c=[]);!c.length&&J(d)&&d.length&&(d.toString().replace(ja,"").replace(ka,function(a,d){c.push(d)}),c=(d.length===
1?["require"]:["require","exports","module"]).concat(c));if(O&&(k=I||ia()))a||(a=k.getAttribute("data-requiremodule")),j=t[k.getAttribute("data-requirecontext")];(j?j.defQueue:U).push([a,c,d])};define.amd={multiversion:!0,plugins:!0,jQuery:!0};d.exec=function(a){return eval(a)};d.execCb=function(a,c,d,k){return c.apply(k,d)};d.addScriptToDom=function(a){I=a;y?x.insertBefore(a,y):x.appendChild(a);I=null};d.onScriptLoad=function(a){var c=a.currentTarget||a.srcElement,h;if(a.type==="load"||c&&la.test(c.readyState))n=
null,a=c.getAttribute("data-requirecontext"),h=c.getAttribute("data-requiremodule"),t[a].completeLoad(h),c.detachEvent&&!da?c.detachEvent("onreadystatechange",d.onScriptLoad):c.removeEventListener("load",d.onScriptLoad,!1)};d.attach=function(a,c,h,k,j,n){var o;if(G)return k=k||d.onScriptLoad,o=c&&c.config&&c.config.xhtml?document.createElementNS("http://www.w3.org/1999/xhtml","html:script"):document.createElement("script"),o.type=j||"text/javascript",o.charset="utf-8",o.async=!v.skipAsync[a],c&&o.setAttribute("data-requirecontext",
c.contextName),o.setAttribute("data-requiremodule",h),o.attachEvent&&!da?(O=!0,n?o.onreadystatechange=function(){if(o.readyState==="loaded")o.onreadystatechange=null,o.attachEvent("onreadystatechange",k),n(o)}:o.attachEvent("onreadystatechange",k)):o.addEventListener("load",k,!1),o.src=a,n||d.addScriptToDom(o),o;else ca&&(importScripts(a),c.completeLoad(h));return null};if(G){u=document.getElementsByTagName("script");for(H=u.length-1;H>-1&&(z=u[H]);H--){if(!x)x=z.parentNode;if(A=z.getAttribute("data-main")){if(!r.baseUrl)u=
A.split("/"),z=u.pop(),u=u.length?u.join("/")+"/":"./",r.baseUrl=u,A=z.replace(aa,"");r.deps=r.deps?r.deps.concat(A):[A];break}}}d.checkReadyState=function(){var a=v.contexts,c;for(c in a)if(!(c in K)&&a[c].waitCount)return;d.resourcesReady(!0)};d.resourcesReady=function(a){var c,h;d.resourcesDone=a;if(d.resourcesDone)for(h in a=v.contexts,a)if(!(h in K)&&(c=a[h],c.jQueryIncremented))V(c.jQuery,!1),c.jQueryIncremented=!1};d.pageLoaded=function(){if(document.readyState!=="complete")document.readyState=
"complete"};if(G&&document.addEventListener&&!document.readyState)document.readyState="loading",window.addEventListener("load",d.pageLoaded,!1);d(r);if(d.isAsync&&typeof setTimeout!=="undefined")B=v.contexts[r.context||"_"],B.requireWait=!0,setTimeout(function(){B.requireWait=!1;B.takeGlobalQueue();B.jQueryCheck();B.scriptCount||B.resume();d.checkReadyState()},0)}})();