
######################################################################
## $Id: Checkbox.pm 12429 2009-01-13 18:28:04Z spadkins $
######################################################################

package App::Widget::Checkbox;
$VERSION = (q$Revision: 12429 $ =~ /(\d[\d\.]*)/)[0];  # VERSION numbers generated by svn

use App;
use App::Widget;
@ISA = ( "App::Widget" );

use strict;

=head1 NAME

App::Widget::Checkbox - A widget

=head1 SYNOPSIS

   $name = "widget01";

   # official way
   use App;
   $context = App->context();
   $w = $context->widget($name);

   # internal way
   use App::Widget::Checkbox;
   $w = App::Widget::Checkbox->new($name);

=cut

######################################################################
# CONSTANTS
######################################################################

######################################################################
# ATTRIBUTES
######################################################################

# INPUTS FROM THE ENVIRONMENT

=head1 DESCRIPTION

This class implements a widget.

=cut

######################################################################
# INITIALIZATION
######################################################################

# no special initialization

######################################################################
# EVENTS
######################################################################

# no events

######################################################################
# OUTPUT METHODS
######################################################################

sub html {
    my $self = shift;
    my ($name, $value, $html);
    $name = $self->{name};
    $value = $self->get_value();

    # HTML checkboxes are funny.
    # They don't submit anything unless checked.
    # So we have to send a hidden variable to unset them.
    # Then they are reset if they are still really checked.
    # This relies on the behavior that browsers will post values
    # in the order in which they occurred in the HTML.
    # (This is not specified explicitly in standards docs but
    # universally implemented. If anyone knows differently, please
    # let me know.)

    # To caputre the click event
    my $enable_warn = $self->{enable_warning};
    my $enable_warning_widget = $self->{enable_warning_widget};

    $html = "<input type=\"hidden\" name=\"$name\" value=\"{:delete:}\" />";
    if ($value) {
        if($enable_warn) {
            $html .= "<input type=\"checkbox\" name=\"$name\" value=\"1\" checked
                  onclick=\"javascript: var enable_warning = context.getElementByName('" . $enable_warning_widget . "');
                  enable_warning.value = 'enabled';\" />";
        }
        else {
            $html .= "<input type=\"checkbox\" name=\"$name\" value=\"1\" checked />";
        }
    }
    else {
        if($enable_warn) {
            $html .= "<input type=\"checkbox\" name=\"$name\" value=\"1\" 
                  onclick=\"javascript: var enable_warning = context.getElementByName('" . $enable_warning_widget . "');
                  enable_warning.value = 'enabled';\" />";
        }
        else {
            $html .= "<input type=\"checkbox\" name=\"$name\" value=\"1\" />";
        }
    }
    $html;
}

1;

